(* Content-type: application/vnd.wolfram.cdf.text *)

(*** Wolfram CDF File ***)
(* http://www.wolfram.com/cdf *)

(* CreatedBy='Mathematica 10.2' *)

(*************************************************************************)
(*                                                                       *)
(*  The Mathematica License under which this file was created prohibits  *)
(*  restricting third parties in receipt of this file from republishing  *)
(*  or redistributing it by any means, including but not limited to      *)
(*  rights management or terms of use, without the express consent of    *)
(*  Wolfram Research, Inc. For additional information concerning CDF     *)
(*  licensing and redistribution see:                                    *)
(*                                                                       *)
(*        www.wolfram.com/cdf/adopting-cdf/licensing-options.html        *)
(*                                                                       *)
(*************************************************************************)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[      1064,         20]
NotebookDataLength[     17019,        411]
NotebookOptionsPosition[     17172,        396]
NotebookOutlinePosition[     17527,        412]
CellTagsIndexPosition[     17484,        409]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["\<\
The experiment: you swing a pendulum in a downward-pointing magnetic field. \
The pendulum bob has some positive charge on it. The magnetic force acting on \
the bob causes it to deflect in the horizontal plane, resulting in complex \
(and often beautiful) trajectories. The following simulation plots the \
trajectory of the pendulum as seen from the top (i.e., in the horizontal x-y \
plane).\
\>", "Subsection",
 CellChangeTimes->{3.654520106403268*^9, 
  3.7096967441771097`*^9},ExpressionUUID->"1094568f-335c-416a-b926-\
60b6cd1a497c"],

Cell[CellGroupData[{

Cell[TextData[{
 "Controls : \n (i) \[CapitalOmega] = ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    FractionBox["qB", "m"], 
    SqrtBox[
     FractionBox["L", "g"]]}], TraditionalForm]],ExpressionUUID->
  "96bef9c2-98b4-4c1a-9bef-5a862d4d3619"],
 " (B \[RightArrow] z-component of magnetic field, q \[RightArrow] charge, m \
\[RightArrow] mass, L \[RightArrow] length of string, g \[RightArrow] \
acceleration due to gravity),\n \n (ii) Sideways Kick :  Initial sideways \
velocity of the pendulum, \n (iii) In-plane Kick :   Initial velocity in the \
vertical plane, \n (iv) Time duration : Duration over which you want to see \
the trajectory."
}], "Subsubsection",
 CellChangeTimes->{{3.6544575489979353`*^9, 3.6544579588024807`*^9}, {
  3.654519909301845*^9, 3.654519918058804*^9}, {3.654519960582155*^9, 
  3.654520083248088*^9}, {3.6545201274888573`*^9, 3.654520164869945*^9}, {
  3.680432548075234*^9, 
  3.680432549433124*^9}},ExpressionUUID->"50bfbf90-bf66-411b-a9cc-\
fb1fc798a98e"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"solution", "=", "\[IndentingNewLine]", 
       RowBox[{"First", "[", 
        RowBox[{"NDSolve", "[", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"{", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{"\[Theta]", "''"}], "[", "t", "]"}], "-", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 SuperscriptBox[
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"\[Phi]", "'"}], "[", "t", "]"}], ")"}], "2"], 
                 "+", 
                 RowBox[{"\[CapitalOmega]", "*", 
                  RowBox[{
                   RowBox[{"\[Phi]", "'"}], "[", "t", "]"}]}]}], ")"}], "*", 
               RowBox[{"Sin", "[", 
                RowBox[{"\[Theta]", "[", "t", "]"}], "]"}], "*", 
               RowBox[{"Cos", "[", 
                RowBox[{"\[Theta]", "[", "t", "]"}], "]"}]}], "+", 
              RowBox[{"Sin", "[", 
               RowBox[{"\[Theta]", "[", "t", "]"}], "]"}]}], "\[Equal]", 
             "0"}], ",", "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{"\[Phi]", "''"}], "[", "t", "]"}], "*", 
               RowBox[{"Sin", "[", 
                RowBox[{"\[Theta]", "[", "t", "]"}], "]"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"2", "*", 
                  RowBox[{
                   RowBox[{"\[Theta]", "'"}], "[", "t", "]"}], "*", 
                  RowBox[{
                   RowBox[{"\[Phi]", "'"}], "[", "t", "]"}]}], "+", 
                 RowBox[{"\[CapitalOmega]", "*", 
                  RowBox[{
                   RowBox[{"\[Theta]", "'"}], "[", "t", "]"}]}]}], ")"}], "*", 
               RowBox[{"Cos", "[", 
                RowBox[{"\[Theta]", "[", "t", "]"}], "]"}]}]}], "\[Equal]", 
             "0"}], ",", "\[IndentingNewLine]", "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{"\[Theta]", "[", "0", "]"}], "\[Equal]", "1."}], ",", 
            RowBox[{
             RowBox[{"\[Phi]", "[", "0", "]"}], "\[Equal]", "\[Pi]"}], ",", 
            RowBox[{
             RowBox[{
              RowBox[{"\[Theta]", "'"}], "[", "0", "]"}], "\[Equal]", 
             "inplanekick"}], ",", 
            RowBox[{
             RowBox[{
              RowBox[{"\[Phi]", "'"}], "[", "0", "]"}], "\[Equal]", 
             "sidewayskick"}]}], "\[IndentingNewLine]", "}"}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"{", 
           RowBox[{"\[Theta]", ",", "\[Phi]"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"t", ",", "1000"}], "}"}]}], "\[IndentingNewLine]", "]"}], 
        "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"Manipulate", "[", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"ParametricPlot", "[", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"Evaluate", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{
               RowBox[{"Sin", "[", 
                RowBox[{"\[Theta]", "[", 
                 RowBox[{"2", "*", "\[Pi]", "*", "t"}], "]"}], "]"}], "*", 
               RowBox[{"Cos", "[", 
                RowBox[{"\[Phi]", "[", 
                 RowBox[{"2", "*", "\[Pi]", "*", "t"}], "]"}], "]"}]}], ",", 
              RowBox[{
               RowBox[{"Sin", "[", 
                RowBox[{"\[Theta]", "[", 
                 RowBox[{"2", "*", "\[Pi]", "*", "t"}], "]"}], "]"}], "*", 
               RowBox[{"Sin", "[", 
                RowBox[{"\[Phi]", "[", 
                 RowBox[{"2", "*", "\[Pi]", "*", "t"}], "]"}], "]"}]}]}], 
             "}"}], "/.", "solution"}], "]"}], ",", "\[IndentingNewLine]", 
          RowBox[{"{", 
           RowBox[{"t", ",", "0", ",", "T"}], "}"}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"PlotRange", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "}"}]}], ",", 
          RowBox[{"AxesLabel", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"Style", "[", 
              RowBox[{"\"\<x\>\"", ",", "Black", ",", "15"}], "]"}], ",", 
             RowBox[{"Style", "[", 
              RowBox[{"\"\<y\>\"", ",", "Black", ",", "15"}], "]"}]}], 
            "}"}]}], ",", "\[IndentingNewLine]", 
          RowBox[{"Epilog", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{"Red", ",", 
             RowBox[{"PointSize", "[", "0.025", "]"}], ",", 
             RowBox[{"Point", "[", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"Sin", "[", 
                    RowBox[{"\[Theta]", "[", 
                    RowBox[{"2", "*", "\[Pi]", "*", "T"}], "]"}], "]"}], "*", 
                   
                   RowBox[{"Cos", "[", 
                    RowBox[{"\[Phi]", "[", 
                    RowBox[{"2", "*", "\[Pi]", "*", "T"}], "]"}], "]"}]}], 
                  ",", 
                  RowBox[{
                   RowBox[{"Sin", "[", 
                    RowBox[{"\[Theta]", "[", 
                    RowBox[{"2", "*", "\[Pi]", "*", "T"}], "]"}], "]"}], "*", 
                   
                   RowBox[{"Sin", "[", 
                    RowBox[{"\[Phi]", "[", 
                    RowBox[{"2", "*", "\[Pi]", "*", "T"}], "]"}], "]"}]}]}], 
                 "}"}], "/.", "solution"}], "}"}], "]"}]}], "}"}]}]}], 
         "\[IndentingNewLine]", "]"}], ",", "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"T", ",", "0.0001", ",", 
            RowBox[{"Style", "[", 
             RowBox[{"\"\<Time\>\"", ",", "Black", ",", "15"}], "]"}]}], 
           "}"}], ",", "0.0001", ",", "finaltime", ",", 
          RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}]}], 
       "]"}]}], "}"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}], ",", "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\[CapitalOmega]", ",", "0", ",", 
       RowBox[{"Style", "[", 
        RowBox[{"\"\<Field strength\>\"", ",", "Black", ",", "14"}], "]"}]}], 
      "}"}], ",", 
     RowBox[{"-", "10"}], ",", "10", ",", 
     RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"sidewayskick", ",", "0", ",", 
       RowBox[{"Style", "[", 
        RowBox[{"\"\<Sideways Kick\>\"", ",", "Black", ",", "14"}], "]"}]}], 
      "}"}], ",", 
     RowBox[{"-", "10"}], ",", "10", ",", 
     RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"inplanekick", ",", "0", ",", 
       RowBox[{"Style", "[", 
        RowBox[{"\"\<In-plane Kick\>\"", ",", "Black", ",", "14"}], "]"}]}], 
      "}"}], ",", 
     RowBox[{"-", "15"}], ",", "15", ",", 
     RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"finaltime", ",", "15", ",", 
       RowBox[{"Style", "[", 
        RowBox[{"\"\<Time duration\>\"", ",", "Black", ",", "14"}], "]"}]}], 
      "}"}], ",", "1", ",", "50", ",", 
     RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}]}], 
  "]"}]], "Input",
 CellOpen->False,
 CellChangeTimes->{{3.654440593797319*^9, 3.654440706089449*^9}, {
  3.654440742123206*^9, 3.654440907453252*^9}, {3.6545202936129293`*^9, 
  3.654520385194145*^9}, {3.6545204797855988`*^9, 3.654520513720014*^9}, {
  3.654520581577703*^9, 3.654520584167653*^9}, {3.681163521599965*^9, 
  3.6811635224614553`*^9}, {3.68121983230653*^9, 3.6812198671037188`*^9}, {
  3.709534535792427*^9, 
  3.709534539851246*^9}},ExpressionUUID->"b6c55a95-3307-4c52-81e5-\
c47156ef2523"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`finaltime$$ = 
    8.8, $CellContext`inplanekick$$ = 
    3.1000000000000014`, $CellContext`sidewayskick$$ = 
    1.4000000000000004`, $CellContext`\[CapitalOmega]$$ = 0, Typeset`show$$ = 
    True, Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`\[CapitalOmega]$$], 0, 
       Style["Field strength", 
        GrayLevel[0], 14]}, -10, 10}, {{
       Hold[$CellContext`sidewayskick$$], 0, 
       Style["Sideways Kick", 
        GrayLevel[0], 14]}, -10, 10}, {{
       Hold[$CellContext`inplanekick$$], 0, 
       Style["In-plane Kick", 
        GrayLevel[0], 14]}, -15, 15}, {{
       Hold[$CellContext`finaltime$$], 15, 
       Style["Time duration", 
        GrayLevel[0], 14]}, 1, 50}}, Typeset`size$$ = {405., {226., 232.}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`\[CapitalOmega]$4089$$ = 
    0, $CellContext`sidewayskick$4090$$ = 0, $CellContext`inplanekick$4091$$ =
     0, $CellContext`finaltime$4092$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`finaltime$$ = 
        15, $CellContext`inplanekick$$ = 0, $CellContext`sidewayskick$$ = 
        0, $CellContext`\[CapitalOmega]$$ = 0}, "ControllerVariables" :> {
        Hold[$CellContext`\[CapitalOmega]$$, \
$CellContext`\[CapitalOmega]$4089$$, 0], 
        Hold[$CellContext`sidewayskick$$, $CellContext`sidewayskick$4090$$, 
         0], 
        Hold[$CellContext`inplanekick$$, $CellContext`inplanekick$4091$$, 0], 
        
        Hold[$CellContext`finaltime$$, $CellContext`finaltime$4092$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> 
      Part[{$CellContext`solution = First[
            
            NDSolve[{
             Derivative[
                2][$CellContext`\[Theta]][$CellContext`t] - ((
                 Derivative[
                   1][$CellContext`\[Phi]][$CellContext`t]^2 + $CellContext`\
\[CapitalOmega]$$ Derivative[1][$CellContext`\[Phi]][$CellContext`t]) Sin[
                  $CellContext`\[Theta][$CellContext`t]]) Cos[
                 $CellContext`\[Theta][$CellContext`t]] + Sin[
                 $CellContext`\[Theta][$CellContext`t]] == 0, 
              Derivative[2][$CellContext`\[Phi]][$CellContext`t] Sin[
                  $CellContext`\[Theta][$CellContext`t]] + ((2 
                   Derivative[1][$CellContext`\[Theta]][$CellContext`t]) 
                  Derivative[
                   1][$CellContext`\[Phi]][$CellContext`t] + $CellContext`\
\[CapitalOmega]$$ Derivative[1][$CellContext`\[Theta]][$CellContext`t]) Cos[
                  $CellContext`\[Theta][$CellContext`t]] == 
              0, $CellContext`\[Theta][0] == 1., $CellContext`\[Phi][0] == Pi,
               Derivative[1][$CellContext`\[Theta]][
               0] == $CellContext`inplanekick$$, 
              Derivative[1][$CellContext`\[Phi]][
               0] == $CellContext`sidewayskick$$}, {$CellContext`\[Theta], \
$CellContext`\[Phi]}, {$CellContext`t, 1000}]]; Manipulate[
           ParametricPlot[
            Evaluate[
             ReplaceAll[{Sin[
                 $CellContext`\[Theta][(2 Pi) $CellContext`t]] Cos[
                 $CellContext`\[Phi][(2 Pi) $CellContext`t]], Sin[
                 $CellContext`\[Theta][(2 Pi) $CellContext`t]] Sin[
                 $CellContext`\[Phi][(2 
                   Pi) $CellContext`t]]}, $CellContext`solution]], \
{$CellContext`t, 0, $CellContext`T}, PlotRange -> {{-1, 1}, {-1, 1}}, 
            AxesLabel -> {
              Style["x", Black, 15], 
              Style["y", Black, 15]}, Epilog -> {Red, 
              PointSize[0.025], 
              Point[{
                ReplaceAll[{Sin[
                    $CellContext`\[Theta][(2 Pi) $CellContext`T]] Cos[
                    $CellContext`\[Phi][(2 Pi) $CellContext`T]], Sin[
                    $CellContext`\[Theta][(2 Pi) $CellContext`T]] Sin[
                    $CellContext`\[Phi][(2 
                    Pi) $CellContext`T]]}, $CellContext`solution]}]}], \
{{$CellContext`T, 0.0001, 
             Style["Time", Black, 15]}, 0.0001, $CellContext`finaltime$$, 
            Appearance -> "Labeled"}]}, 1], 
      "Specifications" :> {{{$CellContext`\[CapitalOmega]$$, 0, 
          Style["Field strength", 
           GrayLevel[0], 14]}, -10, 10, Appearance -> 
         "Labeled"}, {{$CellContext`sidewayskick$$, 0, 
          Style["Sideways Kick", 
           GrayLevel[0], 14]}, -10, 10, Appearance -> 
         "Labeled"}, {{$CellContext`inplanekick$$, 0, 
          Style["In-plane Kick", 
           GrayLevel[0], 14]}, -15, 15, Appearance -> 
         "Labeled"}, {{$CellContext`finaltime$$, 15, 
          Style["Time duration", 
           GrayLevel[0], 14]}, 1, 50, Appearance -> "Labeled"}}, 
      "Options" :> {}, "DefaultOptions" :> {}],
     ImageSizeCache->{450., {314., 320.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UndoTrackedVariables:>{Typeset`show$$, Typeset`bookmarkMode$$},
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellChangeTimes->{
  3.7095345996292143`*^9},ExpressionUUID->"1d1b6316-cfee-41e1-836e-\
67da47cae248"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1148, 696},
WindowMargins->{{40, Automatic}, {Automatic, 0}},
FrontEndVersion->"11.1 for Mac OS X x86 (32-bit, 64-bit Kernel) (April 18, \
2017)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[1486, 35, 550, 10, 94, "Subsection", "ExpressionUUID" -> \
"1094568f-335c-416a-b926-60b6cd1a497c"],
Cell[CellGroupData[{
Cell[2061, 49, 992, 21, 180, "Subsubsection", "ExpressionUUID" -> \
"50bfbf90-bf66-411b-a9cc-fb1fc798a98e"],
Cell[CellGroupData[{
Cell[3078, 74, 8278, 199, 19, "Input", "ExpressionUUID" -> \
"b6c55a95-3307-4c52-81e5-c47156ef2523",
 CellOpen->False],
Cell[11359, 275, 5773, 116, 651, "Output", "ExpressionUUID" -> \
"1d1b6316-cfee-41e1-836e-67da47cae248"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

(* NotebookSignature dxD8JidsP2J7PCwcA#rzQmOB *)
