(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 10.4' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[   2705582,      48517]
NotebookOptionsPosition[   2697982,      48258]
NotebookOutlinePosition[   2698337,      48274]
CellTagsIndexPosition[   2698294,      48271]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["\<\
Basic rules :
(i) Built-in functions start with a capital letter, such as \
\[OpenCurlyDoubleQuote]Plot,\[CloseCurlyDoubleQuote] \
\[OpenCurlyDoubleQuote]Sin,\[CloseCurlyDoubleQuote] etc.
(ii) Arguments for functions are kept within brackets, such as Sin[x].
(iii) To evaluate commands, press Shift+Enter.
(iv) Play with it!\
\>", "Subsection",
 CellChangeTimes->{{3.681164481915846*^9, 3.6811646105959473`*^9}, {
  3.681229838313321*^9, 3.681229846377157*^9}}],

Cell[CellGroupData[{

Cell["\<\
Note 1 : Below you'll find some grayed out commands enclosed within the \
symbols (* and *) . You don' t need those for the 1st homework (HW 0). But \
you are welcome to play around with them. To see them in action, delete the \
(* and *) symbols, and evaluate!\
\>", "Item",
 CellChangeTimes->{{3.68123080168408*^9, 3.6812309724194517`*^9}, {
  3.681231024115877*^9, 3.6812310514069242`*^9}, {3.681231084653022*^9, 
  3.681231125675179*^9}}],

Cell["\<\
Note 2 : We didn\[CloseCurlyQuote]t have time to cover the following in \
section : (i) generating random numbers, (ii) defining new functions. There \
are examples of those later in this notebook. You may need them for HW 0.\
\>", "Item",
 CellChangeTimes->{{3.68123080168408*^9, 3.6812309724194517`*^9}, {
  3.681231024115877*^9, 3.6812310514069242`*^9}, {3.681231084653022*^9, 
  3.68123109180832*^9}, {3.681231130217003*^9, 3.68123122969149*^9}}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Plotting functions :", "Subsection",
 CellChangeTimes->{{3.6811646149275007`*^9, 3.681164622026536*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "10"}], ",", "10"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.6811315193520403`*^9, 3.681131526640081*^9}}],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
     1.], LineBox[CompressedData["
1:eJwte3k8lN/7vl1ZwowlwgySrKk3pVLnpIXsSVnSagmVqIRKEVEplSwladGC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      "]]}}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None},
  PlotRange->{{-10, 10}, {-0.9999999783676297, 0.9999999998482011}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{3.681131527125103*^9, 3.681230188790991*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell["with options to change the style :", "Subsubsection",
 CellChangeTimes->{{3.68116463226429*^9, 3.681164636701314*^9}, {
  3.681164874425152*^9, 3.6811649063891563`*^9}, {3.681229920122366*^9, 
  3.681229921096286*^9}}],

Cell[BoxData[
 RowBox[{"(*", "\[IndentingNewLine]", 
  RowBox[{"Plot", "[", 
   RowBox[{
    RowBox[{"Sin", "[", "x", "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", 
      RowBox[{"-", "10"}], ",", "10"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{"Frame", "\[Rule]", "True"}], ",", 
    RowBox[{"Axes", "\[Rule]", "False"}], ",", 
    RowBox[{"FrameLabel", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Style", "[", 
        RowBox[{"\"\<x\>\"", ",", "Black", ",", "15"}], "]"}], ",", 
       RowBox[{"Style", "[", 
        RowBox[{"\"\<sin(x)\>\"", ",", "Black", ",", "15"}], "]"}]}], "}"}]}],
     ",", 
    RowBox[{"FrameTicksStyle", "\[Rule]", 
     RowBox[{"Directive", "[", 
      RowBox[{"\"\<Label\>\"", ",", "13"}], "]"}]}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"ImageSize", "\[Rule]", 
     RowBox[{"Scaled", "[", "0.4", "]"}]}], ",", 
    RowBox[{"GridLines", "\[Rule]", "Automatic"}], ",", 
    RowBox[{"GridLinesStyle", "\[Rule]", 
     RowBox[{"Directive", "[", 
      RowBox[{
       RowBox[{"GrayLevel", "[", "0.6", "]"}], ",", 
       RowBox[{"Dashing", "[", "0.02", "]"}]}], "]"}]}], ",", 
    RowBox[{"AspectRatio", "\[Rule]", "0.6"}]}], "\[IndentingNewLine]", "]"}],
   "\[IndentingNewLine]", "*)"}]], "Input",
 CellChangeTimes->{{3.681164641549762*^9, 3.6811648603156767`*^9}, {
  3.6812298985290728`*^9, 3.68122994869411*^9}}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Consider the motion of a particle under the potential ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"V", "(", 
     RowBox[{"x", ",", "y"}], ")"}], "=", 
    RowBox[{"-", 
     RowBox[{
      SuperscriptBox["e", 
       RowBox[{"-", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["x", "2"], "+", 
          SuperscriptBox["y", "2"]}], ")"}]}]], " ", ":"}]}]}], 
   TraditionalForm]]]
}], "Subsection",
 CellChangeTimes->{{3.681164945825323*^9, 3.681165032571065*^9}}],

Cell[CellGroupData[{

Cell["3D plot of the potential :", "Subsubsection",
 CellChangeTimes->{{3.68116506144176*^9, 3.681165068482341*^9}}],

Cell[BoxData[
 RowBox[{"(*", "\[IndentingNewLine]", 
  RowBox[{"Plot3D", "[", 
   RowBox[{
    RowBox[{"-", 
     RowBox[{"Exp", "[", 
      RowBox[{"-", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["x", "2"], "+", 
         SuperscriptBox["y", "2"]}], ")"}]}], "]"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", 
      RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"y", ",", 
      RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
    RowBox[{"AxesLabel", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Style", "[", 
        RowBox[{"\"\<x\>\"", ",", "Black", ",", "15"}], "]"}], ",", 
       RowBox[{"Style", "[", 
        RowBox[{"\"\<y\>\"", ",", "Black", ",", "15"}], "]"}], ",", 
       RowBox[{"Style", "[", 
        RowBox[{"\"\<V(x,y)\>\"", ",", "Black", ",", "15"}], "]"}]}], 
      "}"}]}]}], "]"}], "\[IndentingNewLine]", "*)"}]], "Input",
 CellChangeTimes->{{3.68115290256542*^9, 3.6811529232818108`*^9}, {
  3.681153184632921*^9, 3.6811531912276087`*^9}, {3.681165072665228*^9, 
  3.681165096882966*^9}, {3.681229964108522*^9, 3.6812299664481573`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Density plot of the potential :", "Subsubsection",
 CellChangeTimes->{{3.681165144380282*^9, 3.6811651498662033`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DensityPlot", "[", 
  RowBox[{
   RowBox[{"-", 
    RowBox[{"Exp", "[", 
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["x", "2"], "+", 
        SuperscriptBox["y", "2"]}], ")"}]}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{3.68116516279956*^9}],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJx1lztKBEEQQGe9ibD3mHhTjyCYuXoHQwMREQNDT9CIrAYNAx7BRGEFwcBE
XPYIMtO8hnrNmBRv9tP9trqrysPj86OTg67rFouuG2P52w/Ez816u1n/Vn4Z
cftT+Xa5ulmuvit/Te/fVr6bXn+rfD/x6xDXSRm+LK/38FX5fOX38v2Vr8v6
lZ/K/ip/lP33cb29uXo64gvjC+ML4wvjG3/HlGF8YXxhfGF8YXxhfJU3c+MF
O+IL4wvjC+Mbz0nKML4wvjC+ML4wvjC+OpfmJm/2gh3xhfGF8Y33IGUYXxhf
GF8YXxhfGF/dO3NzLp03e8GO+ML4xnueMowvjC+ML4wvjC+Mr+qKubl3PpfO
m71gR3xjHUsZxhfGF8YXxhfGF8ZXddPc1BXfO59L581esCO+ML4wvjC+ML4w
vjC+6gvmpm66rvje+Vw6b/aCHWM/Sjn2o5RjP0o59qOUYz9KOfaj2vfMTV9w
3XRd8b3zuXTe7AU74gvjC+ML4wvjq75ubvqe+4LrpuuK753PpfNmL9gRXxhf
GF8YX80t5qavu++5L7huuq743vlcOm/2gh3xhfGF8dVcZm7mFvd19z33BddN
1xXfO59L581esCO+ML6aO83NXOa5xX3dfc99wXXTdcX3zufSebMX7Iiv5mpz
M3d6LvPc4r7uvue+4LrpuuJ753PpvNkLdsR37v8Iz9meQz2neY5xn3cfdJ9w
HXWd8T30OXUe7el4Nr598zcQ8YdPS+z1euWHaf3HGi9K7OeeO+IPe132A89F
78ufi3lN2fvzPmB7E/ne5+n33g3Ekp7d7HNH9uX3+bnX9zrRb988n1m3/wfV
5ozN
   "], {
    {GrayLevel[0.8], EdgeForm[None], 
     GraphicsGroupBox[PolygonBox[CompressedData["
1:eJxNmHm4lVMUh3fIPKXMQ64SCikJCaVSidJFlFL3NiDNZJYMIaQ0EKWiKAlX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       "]]]}, {}, {}, {}, {}},
   VertexColors->CompressedData["
1:eJztmGlM1GcQxhexIiiCF55Bl7Jc4oEIokUGCFGxgKLWs9iWWo+IR1G0VWnx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    "]],
  AspectRatio->1,
  AxesLabel->{None, None},
  DisplayFunction->Identity,
  Frame->True,
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  Method->{
   "DefaultBoundaryStyle" -> Automatic, "DefaultPlotStyle" -> Automatic, 
    "ScalingFunctions" -> None},
  PlotRange->{{-1, 1}, {-1, 1}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.02]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{3.681165163208143*^9, 3.681230192966159*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
with legends, equipotential lines, and other options to change the style :\
\>", "Subsubsection",
 CellChangeTimes->{{3.6811651759966793`*^9, 3.681165207693363*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"densityplot", "=", "\[IndentingNewLine]", 
  RowBox[{"DensityPlot", "[", 
   RowBox[{
    RowBox[{"-", 
     RowBox[{"Exp", "[", 
      RowBox[{"-", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["x", "2"], "+", 
         SuperscriptBox["y", "2"]}], ")"}]}], "]"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", 
      RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"y", ",", 
      RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{"PlotLegends", "\[Rule]", "Automatic"}], ",", 
    RowBox[{"MeshFunctions", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"#3", "&"}], "}"}]}], ",", 
    RowBox[{"Mesh", "\[Rule]", "10"}], ",", 
    RowBox[{"PlotPoints", "\[Rule]", "50"}], ",", "\[IndentingNewLine]", 
    RowBox[{"FrameTicksStyle", "\[Rule]", 
     RowBox[{"Directive", "[", 
      RowBox[{"\"\<Label\>\"", ",", "12"}], "]"}]}], ",", 
    RowBox[{"FrameLabel", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Style", "[", 
        RowBox[{"\"\<x\>\"", ",", "Black", ",", "15"}], "]"}], ",", 
       RowBox[{"Style", "[", 
        RowBox[{"\"\<y\>\"", ",", "Black", ",", "15"}], "]"}]}], "}"}]}]}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.681130757041531*^9, 3.681130853508032*^9}, {
  3.681130972602127*^9, 3.681131037612028*^9}, {3.681131440067038*^9, 
  3.681131492005878*^9}, {3.6811652170060596`*^9, 3.681165256056431*^9}, {
  3.68116551771352*^9, 3.6811655182136917`*^9}, {3.681165696196632*^9, 
  3.681165703196746*^9}}],

Cell[BoxData[
 TemplateBox[{GraphicsBox[
    GraphicsComplexBox[CompressedData["
1:eJx1nXm4ltP6x4uMoTiGNJHSEaGcZLbMlRyk0CFKio5kKkpHSqGZDKlDMpfQ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     "], {{{
        EdgeForm[], 
        GrayLevel[0.8], 
        GraphicsGroupBox[{
          PolygonBox[CompressedData["
1:eJxMnXeYFEXXxWd3Z2Z3e2Z2es1ZwYCYA4oEERBERAVUFAEVCQYMqAQVBQVR
RBRQxIQJBRUVcwYMGBExgTnngAJmfU3f+XnuPHx/nOfe6q6qru6urqquqntu
kwFDDzq5OpPJfLpGJlMj+Wx9JkO4hXBDOZMZpIMXFjKZg6symc2EJsJBwqYR
PiSONRV6JJnM5pInSF6ldIOFY4SDFG6m4ydJHlrlOFsIV8f5Y4XD0kzm1lwm
c2oxk+ktfY7006QfIv0m6UOlvyl5szBL6JVankJ85bWlsJXwto7NFm4R3hNu
yzmvgxX/RsmTFf9w6XdIHyb9I8k7hbnCYVEu8jpAZd1E8jjJPlUu/9bCNw2Z
zF6SR+n4SZKthTbCySHb8kx0blvJoZIjJDsKewvDhPZCB2F4SM4NEVoKewhf
KP9Wkv2U9uMo111CPx1rLmwjHChsKGwk7COsKaxFmYUN4lz3OL+x0DfKTvrO
whqRpkukW1t4V9dtJD9dd3/J9SOv/RReR3Kg5PGSu0dZ+6Qu1wg9w77S75E+
UvpiyauEq4WXQl4j9FSc6yRPUpxXJK/NOdxDx2dInqjjL0hOF64QnhOmCZcL
z4fk3IGKf6XkCYp/hPTHpJ8tfYXkPGG+sEbe75Xnd7zifCA5SXFWSS4QHhee
FS6La1yic59RtySHpE53sfS1lM8n0j8VVkbepG/U8Q9zvsYzwqWRF+cnChdF
WS6M8FfCA8KDwufCvcJ9wum6xv2SkyW/zFknXr/Ucc/U8e8kH835Pr8RHhIe
Fkbp3CNcW3J5zvqjUda7c34fy4SZOX8/T3BP3KvwmnC9cEPcD+WdJBxbdJnP
kpwu/Cj9dsnji047WvJpyalxz09GfpOFp0JOERaGJN7Rqis7CDsKH6mObS95
qOrSkVX+RrYTzlF4rOS1kvcRFs4V7hXGRPhBYZxwnvBQyPHCY8IE4ULhEeF8
4QLh0ZCcmy9MFC4SXhCmC1cIC+LYJOEpYbIwRXg8jl1MfirTJZI3U8bE+d8g
uTDiThWeFy6PfJ8RLhUuE54NOU3IlC0vVNrzEpdnpmS1jl9JOaQvlryKdlG4
Rxgd9/8Kz0a4Tngpzl8jZJV2BuVU2tcpl3CjkNfx67kfHV8ax2bGvdLG0V7e
LZwd13iyyvfI/SdKO4t7UNp3JG8RbqV9CHmb8F7IOcL7IW8X3hZmR5oP4tgd
vHfhTmGu8GEcI/xxHLtLmJG4TPdInlnldo326Ywqt1mETxc6RZh2+gc91h8z
bqe+kvxaaKn0KyUPjL5oVcbxaM++zDheSvkkPxTWlf655BdCA/cm+T6vq8qS
eLSLxP0o4z7ve8kVGfcPyyW/Ez5T3d5N4T667mDJXYRdhQFVrvs7VbnPJC7p
j4nzLYSRVe4fuLdPlM/OvKPE7Tj39I2wm8LfSnaTPC5133ZR0W3zZxnfA/0W
z+OnjNv7XyR/zbjdR/4mtFb63yUPlnxV18roXLvorzj+h/Cyjv8l2Tbx98mx
/2V8D39L/pNxGZH/CutV+fnxfLmfKqFa2JP6JBSq3Kflhdoq96U/Z1y+Von1
nomfH+lqqtwX5iLNGypPPc+Iei49K7299HaRd7HKfTKyVOVv69Co68emHhNM
1LMqqd1+N8YF5wsHMS4QxtM/RXiCcIjQS9grtexVdDt+KGMEoV3qdIfo+KGM
J6QfF20kep9oF5F9oy3sJxwRfeGxxI8+7WhhQLSnRwpHRV+C7B9tM9fsnXP/
R9yBQgeV4RjOFd1fcmxQtLlHRF5XxrHB0Tb3jXLMiOsfL3RMLXsXPT46SThZ
6KLjIyhH0eOnkfRXwr6pZf+i+48TI02n1On66vje0k/g/osxdhNOEfbU8R48
56L73f5x/111/Ez0ovu/scI47lXhsyWHF92noY/OedwwJOdrdFPac7nPosdK
o+i/hP10fAzPpei+kHSEByt8nuQZRffB5+ScnrHkqcJpwuZ5jxV+oA4o3gaS
3SWnKs/+OrdI+mXSB0pfLP0OyTOEM4UrhUHCYOFy3pHkEsW5XPJoYYBwjXCs
cJxwBc9f8mXFuU5yiHAC+aSWr/CcJU8UThJmCacKpwlX88wlX+U5Sw4VThG2
En5SmX8WbpE+TBguzODdSb6h+EuFEdKXS96Wtz5SmBOSeG/q3CjJFZJ3SZ4l
nC08IVwsXCLcL5wrjBXm5h2feNfqWufwvSnt28Jonqnk+zx/yif5sOR44XzG
UwpfIPkLdSDyGyc8lHd84m2Z95iEe7sn7zzHCI8JE4QLhSejXJOFBcJFwiTh
8ZCU+95IR/meirhThBtV5kslP1YZnpW8TJgmzIu8JwrzQ5Iv/yvDc/5O+N8Y
FuF9UtejI5VPTvFel76Uuph67HW+jv8t+WLO4+XBqcdqF+j4X5KL4lwN7zbn
NNw3Y7gn4/6RjLkGpB5Pn6e0/0R+jLv7p5bjdHxX6W35dovxHQrthBapZVcd
H1N0/pdL7qLjrWkDpO+fuq08puhxJ20l4Qz1WvLlnMedF+Tcdv4c5WIM+EtI
xoy/hmS83CTv8Tpj6qZ5S763abrG95K3SW6S97iW8e9meR8nzQkqzxeSUxRn
/bzHzYyv18l7DM/4et285RfRlrXJ+f5PUtpvJS9T2g0V5+ucx9S/Rbn4J/g9
JP8ff4Tk/+PE1NeZqrRHpf5XOVf6Man/SydIr+Pbyjm8Ud55c71E+ls590Nt
Ff9AyZ5Ft197CK1ybo93E3bPuc3eWdgl5z6kmbB1zm3lDsKOOfcDyJ04pjy3
kuxUdPu6sbBJzv3GFsKWOV9zQ8olbJtatlf87VLH7VB0H7JTXJv+Zzth+5zb
4u45583/x3lRDzqnrk/9im7Lt4/y0Z4eENekv2kubJNzv4TcNuf+adu4Rt+4
P+IV9azeybmfpj/elPdP3rrW5pJ7F92W7yd0y7lNR+7Pe04teyhOa+ldKUPR
32dH0ub8Xe7FvfOsFacDeRXdB/LsW/IMUst9dLyj0ET6wUX3K/vmnG/L1Pl1
K7pv5hnzDhg7EL9pzmMHJOVupfhdeC5F98e82115hzregmdZdH/OMcL0sZ04
Th1JLfdXnGtSt/GvSz8x5lPGSZ4c8xTjJd+tVtsk3CZsUVCbLtlWcoDG9o9K
31H6cslHqh3+Vng4wu8It0T6FcI8Yb7wvfBYhPspn6slN1Q+faRfIX196S9K
XilcJSwRrhFmCG8LsyPfl+PYtcIqYYHwuPCMcKlwmbBQmCJMFQ4tW66t/J+X
vFyYLvTmf0pyXR3/SfJJ4SlhoI4/Ibmzjv8QeRMereN/SHbT8U8k7xLuFpor
fK9kB8nPq63fJ2xfozGv5J/CMOnthQ7C8JAd0ZVmb8lJkqcVHGei5BtKc5Nw
s/BF5He/0Kzg6+4l+ZXkA8KDwtchHxKOLlturzifRhnvEbYtOP7ekh9I3i7c
IXwY8k5hcNnPbhfF+SiOzRVG1ricnYQ3o1yzhGXCzChrtc69Ivmq0C6u0Ucy
rbHOdRprLMm7qfSV8Q7/ERYLLwlnlP3cuyjtZjWuN9Sjf+M89eL4suvKHgU/
3xeERUKD4r8n+b5QrHFdpC6Xaiw5t6X0H6v9zmtqXN7XhGPLrh+7K88Tyq5n
raX/Lvms8Fy13z+SeGeWnUdXxTlL+q/S95PeTHn+LP0X6laN6wTvcITifCnZ
SXE2qPH74711Vvgbyf6S2+j4b9W+5lH8g0tuUnDeT0cdXyrcGM/9deGGCL8V
74TvZL0aX5PrHVN2uhbKZ+Maf6t8uyPLlvvo+KY6/l21n/VwHf9MsqOOb1Tj
spGmfdT7fpJr1Vinfq1dY0maNWr8bj8WTo/60lkYJXQR9hXOFPaJ8Pm61pqS
RyjPI4V1pI+UvKjs53is9MMlt6pxeGLZ729wwd/q5Gp/5xeX/eyO1/G+klsL
zYVdmZAWqoTzyn7fPRWnpWRWyAl7hMwLrULWCq1D1gmTy/6ehyjtTpJ/R50d
U3b9O0DHd9Txv6p97tyy62v3gu+f58J9HilsK2wnHCpsLmwhTCj7exhUcHsz
iXuqdruDvEToVbZcU3EukL6h4h8tfQcd+1Pt9l9CU9ooycfVhm+v4/+r8rmd
Ka/kv8x7KM7fzNkoTpu4v3phgPLaRPIsyYNqXCf4/varcT2mTh2lc+tLniF5
iGSTGpe7Z43TkqZrjd/juvGOqSvUkf1rnJa6373GdYv6eEAc4376RnsxLNpF
9MaoR43xHM+Oa1CuoUJbYU/hhHiXvMMTQ/IOR0fcbsIUoR/1TZhW9rEzda0Z
Zb+b8dKvLrsOjZN+Gfcs9BdOivx4ZscLu9e4Hp1ecHmmSJ4q2U7YSxhRcD2/
RHJIxKV8p0R5ice6RQthN+HkyJv7OS6OcY3Lyq7HJyufL/Xe7hceEKbzzoSB
XEPoU+NyHy3sUOP6OLXs+nqi0o6P98S7vaLs9zea76vgtvKUgq9NXUiijMhC
jfsr2tZyjfuoUoSvK/t6FyjthZK9ol5fruM9eFd8y5KHCb2FSSH5pq8qW56r
OFeWne4c6WMlD4w6ck7UG+rIqIKPX1bwmtLOwi68p4jL9SbF3OThzCdVeS6Y
5/WUmoHJwhThKmEw82fC1SGPFWY06L1K/lWva0geJfRn3qreeq2+lyskBwqD
Iq9+whHC1JBHCtMi3dHC5SEHCNNDkn6Y0F7oQBxdd0/JT3SdkyXbMG8mTBAO
EXoJpwl7RZpxQnehh3Cq0C7OjWcOTDhIOC/OE/5J+R4sWa3yXxj5HSpMDHmY
sLubyUyW+c+QGi5mxqpsJeYm611WpvvKzCVmvMZHmjE6WMvcpuLsEenycQ86
lNFl/7s/pF5d5rIGx/tQJztGfhqSZjoJjcIawiVCH6FvvLe+8awnCb2Fw4W9
Ix1pfqt3/Jwucp3kEOEE4aK4v97xjltE2Y+Pe24Zz7suynqi0EpoLQyP90MZ
mYM/SujPfGCsb52deA2hh9CzymsL3SPMWsSBEWZ+fD+hW5Xn78nj6JhnfDfj
+eJRMVe9r3BWyK5Vnl/vGulZK2AN7wjhlFj/uCDWFhi3s0b3fYPni4clnovv
G2lYx2D9lbXWCSF7CUMSr8WeG+sSB0U85u9PFU4TbuZ6Eb5JGBrh0Sr3fkI3
4Wyha4TPEvaN8BlCZ2Ef4VzhAOFA6kyk2184JyTnxsZ56veVDa4TX+jFnBTv
hHd1ZuTXRXhOcd6R3D7xesxAYVCV10OQzKP/3OC11TMVZ1Sko3wrGzyHPiLx
WscJwolVXhc5VjiuymsjSNYtf2jwOuvpiduD7biu8Hu99T/q3QZsI2wrPBTf
Id/lgxl/t4TviOfCfdwsnJLxd3yTMDTCD0e684VHQl4gXN/gNuIfXeuBeF7k
u0yYGXnc3+B808Rz9k8LzwhvCbOE2RnPmy+Mczc1uK7zgc6X/qzUrRLP1z8v
vJDxXP4i4cWM1wDIj3jM6z8X8W4XTo97myOMjPBtwogIL4hvku/48ZAXRx60
m5dHXkjay/kZt1MXRXlpc2lr84nbiCaJ74Fjlwp1idvuLRKvYzwhPBn3QH60
3/fqHq+XLLFe1OA+IJG+RPIaYYaQTdz+bpz4nq/MuN9YHJI0rwjXZtzevBzp
CL8u3CDcKCwNybvZPHE/tEesVzwV9/R4g/Ntlrg93pzyZ9xuIbcUftb73or3
Vu/2u2nEo39oEuGNEteJnRPfH+0f7dm3UZ+oR18I91FHMl5DekyYl3H/sFnk
RTvaTNg64/5qR2GnjPuxHSLcP+O6T/i4jNtU2lP60l0zbmcHRrqdeSYq9wvC
8/Vuy8m7ecZtOpJv5vMqr9fSZ7PG9WiUj3Wpe6PcrNu8Fs/4yQa/g+aJ13te
zfjcD1G3ePes+byZcd1/usHfybaKX6fjb2R8jvWnlzJ+/6xlLYn3uTyeGeVg
DXBB5PupcLdwj/CJcFeEP4tjlHWzxHV391hLnB/paatuEW4VPhbmRvq3M/4u
OfdIg9uItRKvF94Z8Vqow63iP5v/7dTrAZ8W9X7zngd/hLlyddy3CrcJWcW5
RXJdxXld8gbhRqFKx6+XXFPHX5W8LutwLnW69XT8ecnLhenCK8K1Ee9tYXbW
+dawf0ZyHfbVSN6cdXihMEWYKjwojBPOE35XRz9ask7xn5OcFtegEyfuGjr+
huRNkdczwqXCZcLSKPtMoTq1XIs59jhPXi9Eea8QftW1RnJPinOR5GFCb+F7
xr2S/+MfSvLgrMPf6fhBkn/o+ArGotL/ZCwqeaDQXbhQ6JX1Oe5jP6Gb8I3i
HyD5m+L/If0c6fW8l7LT/V7w8xomDBdeFmbEM10sXCVcLSyKsl8Zz6uH0FNY
IlwTaV6M86R5KdJdE+97RNb3/L4wR7g9wnsLnYT7hXOzvqffVLazJGtVzrc0
wNteA6BdNZB6Q3pz6TtLf1n6xtKbS18ifSPpW0t/SfqG0ptJ/1z6PtJbSn9R
+vrSt5T+ivRNpG8j/TPpnaXvLv0d6TtL3036YukbSN9K+gvS15W+ufSHpf+g
AeUG0h+R/ov0jaS/Kn1TxdlW+j3SP9XxtaU/IH2l9PWkPyR9lfT1pS+Svp7i
byH9Xumf6fg60pdJ30rHd5T+uvQtpe8g/TXpm0nfTvqfZb+Dop7PU5KTo04/
LIwXzhceFyYJF1Ofyn6uieLnhTOlry95Z9b6KGFuyLPi3ZwunCHcLZwddeqJ
yO8S4Z+y626qfGokdxd2EzqoDW0QykJO4T2ElsK/ZadrVPzHJCdEnX0kykt9
/6tsWVKc+ZITs77G32XHbdDxz6V3lP5DwfW1Q9bhL8quRz8WPMf/N2XMeq4f
+a+wlb7NssKti54Xb8g5zFx5KcKsOfyVdfpmit/IvHvRc+FpzmHmvFfq/Kqs
1xaW840KG6eWO7N2o+NfSv9K2DC13JF1H+krpO9S9Jz3GsKawgas++j4DkWv
XXwj/dus1zS+zjrMOsH3WaffKPX5nYqer19HWJc1Bh1fW3JPHd86dd5ti57v
zwq5nNdj8kJtzutgyDrm8VPLlpRf+mfKf/ui8/hY+ifCeqnldkXf/4Koaz+E
pI6wHrAqjjVNfc3diy7f51nf5xY6njD3X/QaXYG1EdYZUstWRa9X1ES5Wd+q
zzkNawj8yFXFWgKymnWJ1HK3otcfeOfEY83mz6zf66apy7Vr0eszv0v/Q/hZ
9WeoZHXR7ffJWYdp10+KMH3MEOGErPuZ07JuN+kPThFOFWqKPr520W3iccLx
Wbenx0d62sRj49z1kd+JPC/mdqh7zJ9L7yr9F+ZVpO8j/aeCv8nO2QiXna6q
6O9236zTfF122/9rwd90lzjH99cn62usYn6DZ6I4z6ptaVTb0rTRbfYxUT76
vSOEI7Ne//mRa2a9DoT8mTqZWrZQGT7Kuk2hLWG96xfKkPWa2G9ZP2vWwDhG
mLUxnv3/sl5bQ/Kefiz7mv+qbHn2skrfoOj++GhhAM+l7O8/W3Qfe5TQP+t2
sF+U+4Os2zLST4vzpKd/Ghz3OT3yG5h1/4YclHU/NijiNaRuj5rSdulZ/a62
ehM9q6+kH6Ln1kr6hMR75L7T+OisxP+jX0sflfh/9CvpZyT+P/1SetfE+1Jf
lD468R7Ab/nXSfx/96n00xL/M34sfUziPYPLmQdK/E//If+Iif/dP5A+OPG/
+PvS+ybeu7tU+qDE/+nvSR+Z+F/yc+n7J94/u1j6YYn3dL0ivXvi/c4vST88
8Z7Y16T3SrzXcYn0fRPvrV0kvUvi/bYvSO+ceP/t89LXTjw2nCV9jcTjx5nS
y4n/9W6QXkz8P3Kt9DUTjydvlr6d8L6e7TF6to2Jx5836tg2icfG90nfOvG4
+h7mFRLvMXtHekPi/5rrpK+bePx7i/RNEo/Z75C+QeIx+xzpGyb+57hd+jqJ
x7yzpW+a+P/jTulNE/+rzZW+ZeL/y7ukr5d4XH2r9PUTj69vY84s8T6xJ6Qf
nXgf9NvSj0i8j3oZz4rnon7ydN1jF+lrST9T+h7Sf9G9nyp9d+mrpA+VvoP0
D6UfJ30fnpfinyF9Z+lf6/gQ6dtL/0D6sdI7Si8ozkjpHaQn0kdIb8NEmfRh
0lfUe05jko59V++5jonMJQjDmGtUnF2lf6M8T5D+Q73n7Sbr2Mp6z4VcTBnr
Pad3ifR2Qk7h4Yr/fb3nTi5i/6CwXPmcpOMtpH8r/UTp+1JXFG+U9IOlbyX9
fOndpW8mfaz0Y6WfKP1S6QfwbqSfK70n70P6eOn1if+Rr9axHkITHR+n40cm
3pf+Js8j8b/wNdL7J96j/pb0brxLxR+t+IdQz6RPkN5X+l7SJ0rfj/ok/Wzp
Xakr0s+Svj/vXvoYrsX3I32S9IF8h9KnSu9PmaRfLP1Q6dtKv1D60dIPlT5Z
+l6J9wQ+pWMdEu8NXMg8U+J9gM9Kv1Vtzstqf9ZU/H+kn61nuI/0Kp0bJ31f
6TXSz5PeVXpW+njp+0mfrfiLlbZRek7Hz9fxbtLz0i+SfgC62rlWWY/bDlD8
HRT/bbV/3RkbS3+XvYHSW0r/kD1i0g+W/qn0QbSH0j+T/rf0s5RnZ56b9G10
/A32L0jfVvqb7F9grCt9qfSe0ltIf1/6PtK3kP4a4xGVbZLyOVD5/KXjo6R3
kv6H9OHS95ZeUJxp0g+SXpJ+pfRDpG8g/V7pvaVvKP0+6YdLX1/6PdIPk74m
81HSe0lfR/pt0g+V/o3y7yW9tfRvpR8qvY30wRxX2T5nj4ni36/jfXR8S+kv
SB8kfaXiDJDeQfpy6X2k78m3IP1I6XtJ31zxn5E+gHorfYr0HtI3lv6Y9H7S
N5U+T/oR0ptKf1J6f+mbSX9C+lHSByjPg1SeT1SefflfkP669O2k/6p/7mek
j5N+sY7/Jv086VOk/yF9rPRJ0n9lL5v0i6T/wn4o6VOl/0/6EO5F+rfSz+Cd
Sv+BfXnSj5O+QvqJ0gdL/076BdKnSf9L+lnSz5H+o/RdEu9NflRl3yHxvPKD
0tsk3nO7QHrHxPtpn5F+ttKeq7Q/cS+J56If0PGdEu9Zflj6jon3MD8kfdfE
e4kfk94i8Z7iedLnK5+/lM9melbXS58nvV76tdIflV5LO8m/pPSX2fPCv6H0
V6TvxT+a9CXsc5TeV/qX0ndm0UH6i9K34R9Qz/lp6c2kf8OeO+nbS/+f9Oek
7yj9b+kvSL9O+mNKW6frXin9AenV0idJv056lfSZ0p+RXpJ+s/TnpZel3yD9
SekF6cdJP0r618pzhvRHpOcZv0l/SHpW+jXSH5aek36h9Cuk/6P4V0l/UHoN
/7Yq13T2aQrlNMbvRY/p+LdkvoQ9mG2EtuwLTC0fZD8wz4g9jEXv2dlTaJf3
fs/dhZZ57+lsHeknKP5u7E8ser9mB6Ejew9Tx72v6D2hewit2IeYWj7APi7G
6TV6pkJzxpWSvwnNGIdK/lLjvai7Ci3YP6Tx4e869prGkNfEWibrlq+WHffV
gvdwsfeVfyz2WK2X83/bUUq/nbC9cKSwbYTH8r7ZB1r0Hsw+Qt/YX4nsF3sw
ewuHxx7KwyJ8cRzrE3s9ewoHUVeU18GSH7A/kf1t0t+LPaQ9It5LKvMKlXlx
wXszD4182RN6iNBLOJ9vTPIe0lLnpN9d9H5e7mOHvPefHhxp2Nu7k7Bz3vth
9xY6CZekfiePFL0ntFdc71H+VyWXSU5mr5f0x6S/wj4Tle1llW0L/mGk/ygs
0vFvkOzH0PFPpH8qrCn94xqHnylYf1eyUcc/lP6RsLH0byWXC3XS35B8k7Xf
rOVbwgvK/yska/46/mWNw+tJ/6LG4bZZp0niH2bbrOvRJ+yX4BpKWyu5rMbX
aJP19UjzvOJ8rmPPK07rrONx7rmy7+M59oMo/FmN43ENyvU270lxvpN8UXGe
KfvYU+ybiustL3i+hHmTbNbzJtURbsH/XITpg5lDoU/eif9C5fNPjedTsnGO
++Cb+FNYpmv9JblU+S+Rvkr6Euk7Z53uX2HXbOa/BVSuURbe17EPhGfLlk8r
/kLhPZ6z5C5ZpyNNQ9bHScO/bjthL6EovMN7FJpKX1nja28m/fsa1132ju+T
d71hL3nnCLOXel+hq/Bx3nus2Yt9p+rYnZIrVcc+zHsPOuE3hZvz3if+ScS9
m+9HuD3iLRVuFGZyLPXe8W/Ze1t0nLzav/fy3hfOfvC3hdl57yWnHOy1ZY/t
WanlbKXrJrle3ntyFwtXCVfH/WBHt3bee6tpL2g/pgpHRPidyPtWypdafqc8
b069n/5z6bNT75v/UvrLkjOEa4UvaBfz3of+ZUj2j38V8kHhD+E54Xnh56L3
lBejL0Jn/n1R3m081/ut6D3lDYqzPO+5+UeFUanvY1bRfRf50T8wjnhaeIZ7
SL2P/yvFeU3y+rz379+WWn7DPurU+8v/kj439fv5QfqPRd9Lwnxn3nvc2av+
YOp96n8U3ZcujOtRP9aM53tmarvHm5ifEVLuS3Jk6n3J1xfdL9XnvR+ZfiMv
1ArDU+9Tv465GRblpV9TdHv5b2wIOD11uhuYN8t7bzd7upvnLdlD3Szv/d+c
o7/K5p0vfVp13vvZ2dd/oNA97z341Jv9hXnKdz/Jt4run6oiDbYFB0Qa9vvv
F2kWFH38HclhqfOeUfQ+/n5Rt5jL2EHYMet+iTKyv5u2n3327MG/VWk2Vvjx
ottxbD+2oB4WbW+wsOg2vmmcoxzsHWd/9y06t4Hk/CjLBnGOvoLnj51op5C8
m6Gp95RfWXQf0yTypR+jDOx5PzX1Pv6riu6X/sfcXM79E5Jy00dtFukZTxTy
3jd9RmobpxuLHndwjHDPyHtTYU7RaZ8seo7qyRjHDIjnRDv6ptq1Am1TwW3Z
HOH2aL9uFW5D6txMycclX5e8QbiR8YRwfYTpbx4QHoz+4ybh5hr3JzMj/EHk
fUf0E/cK9wkPly3vKbjPu1OYKzxUtryL/bHS91Q5VxTc75H3LK5Xdn5zdfxu
4R7a74L71LuEu6P/uz/KRx91T1ybdvqWuM85BetPFtx3kfdswuzJlHy04DHU
s/R39GFly3kF9wdL6PejfZ8nzK9xv/eo8BgoWz6g+K9KXhfPbl7ZcR/S8c/K
7kNWFtwnkd8r0Ve9VONrPKo4D3M/ivNI2c/7PvYLl/2u7ii4vyTdqzFueCTK
Qb/4grCoxn0j8kX6OaVdLLmg4P7z+YhHv7WA9y5sk3rOup3qUmPq9cgti56/
vi/rNSvm9R/Iei2R+XjWYFjTYL7+oQgXUp/ftOg5UNYFWWNk7rh91msYSer8
NlGceun3St9Yem3q+dQNi553vyvrNZk09dh8i6LnU5/Oek3yt5Bc44+4Duul
rBnMy3oekzWKR7Nehymllk2UT13qvDeSXkx9H5sVPSfL+iVrgMzNv5P1Wu5a
qddcty56rp01P9YD/4q4rAf+HZK1xH9CEu9/US7yZc6edVyeL/P15ME6JPP+
r2W9PswaApK1Vub7OU+aNVIf26rotQvWaFnvZS3nvazXG9dOXd7mRa8fvJV1
uVn3WJZ1GtaBiMucMWs8H2Y9n71uarkt6yCp824mfZ3UcbeRvoA9+XzTBf9b
LKR+UYd0/CnqIt9X2ePg9xkHSi9RhsLq8VMpxlOFCHeI8RZjtA8Ub13Jnwte
L02zHi+/U7C+inas7LHXZwWv/RKfsTDrxptmPRbrFscYL79dtvxQ8d9hvy73
W/C6AmN0ysr68EZZj8dZ690k8nq37GOfME4sO+9PC16rbpJ1Od7U8TUk3yt4
XY7yEmYdYu2sx87MrzM2ZYw5OCTj02NCMhZm7YXxN2Nz5uZ3ijQflv3v92XB
6xlbZ/1f+FHZ8uuC1ze2yjreEwW3y8sKXsshP/4PvovxfaboNfgtI80HZf/P
fFHwmvrmWYeHRjraZdZzGMczHj82ystY/riQnGNth3E8c2pDIm5lXE+/srTG
Y3n6FcK3l71X9cqC2+sxNd5nSnuNbcYI2m/WxyWnFtzWs+d4dLTrwyIefQV7
eU+Ndh15WvRL7OUdGv3T0Ih3UcFpb5O8tez8Li24X2JP/Khol6+Ndpx/Fdpa
ys3/35M1rutzIy7lu7/sf++ZBfex2Gmw7/72kGcIkwvO/07JiwuOc3vB6zfb
ZP3Pdl88g3OjP2MP7rho3y8QJgiXK8159HGSD9VYZ0/xHJXhfMkrCu5bZsQ9
0P9MrPH+38ciD577nWXvA76q4G/64hrvX76t7OtP0/G5ZR+7WvpdZe/bnlFw
n3lpjfdl3122vK7gPnMaZYxnNLnGae4te5/0DQX3RXDKXB191BXUgWhHpka+
L8Yx4m3FxtRqtTXYtmOTUeW99dtI/63K4ZHMjzJfKizUmHtPyY8kT2YuU2jL
XDxznBE+kbWsCD8f+yLYH3E0exDYk1DneU3kTsIIoWNcg7nYDhF+pmT9E8l3
alUvhVuFI9hzwR4J4f7YU8HeCvZbsO/i8Zgf5fx2wmnMlQrtY/8H+0AWKM4p
db6XdqyRhCTeYGEX4rJGwj4O9nUIT5Z8Xx9IHsDeDWFDYW8hZT5c2Crm+pjz
2589GhGvI3NvEe8l/iNY+1Oc9szPCQ3C7sylMedW63lxJPHYe7KmsBZz8ezv
ENYVtlD6tSX3lDwmyttCOD7K25K1nJB7MKdf6/ikf1uYHc90H9YBhLWEYcpr
luQUyabCGtLb8A5rrROvFXOEzHkKXaJca8eeEvaWPFjyukEPoWfMX/O+32Xu
UHIg89t1niPn3VO/Po15eObjx0e6g4TbhdOFM4Q5EZfw+XH+4DqvV3SP641l
jj/CzLMz37605Lly6sTb0i9jzps5cOGOyPvMOs/9c4x6OkboJuwvnBPyAOHc
kFxjtLBfxPsy1hRYW5gddW6YMCvqFmHKsrmwRZ3j8uz2rfP6BrKrcF28sxPq
vG7QNNKwj4f9PI/GWnGTOMeaQDNh6zrvZ2Jf07yS8+OdrCPcUOdvkm90Zp2/
26HCeyXX758kP47v4beS1zFOiXLfGOlIc2W8N76Ps6O83P+M+E6odx+WfK1f
JK+NY9xP66gvdUJb5s6FhO9EKMY3sClz//rn+p5/NtYEJFfmvYbzg+SP/FtK
X5V3uGmtzxNmDp259A1LXk/i+2nBXqda50dezMczT8E1SjGv0Szm7NlfyDnm
2ZmzWL/kNQ/mLNaNdaffpP8unCB9j/gOWNf6k//kvOflmZ/fINa4/mFeIO+1
FMr+U97rVMif+e+OdY2zYv5+rDCu1nPqyPOEO4UzhVHCHGGkcLpwmzAiwn1L
1odL3iF5RqRhjeJCYSJtZsnHR0oukbxGmFHrNUDktbVeT+P+mAdapXs5VeHD
S24jhpF/rdcHzhcuqPW6B3JCrdcKKO/4aFdOizQPxzHSPBZxKdM9wmhhjHBU
rAexLnS35NlxjnaT+amv825HmbciTPvKfBbhg6Le8J4PDkndYY1la6F5rdcI
ubcdYl2R89SdXiGpU4vZ8yO5ccnriLynbVlzk2wWebFOtVut22nWqXYRdq31
WibvexfqW8ntfCv6yajjBcpYcj1vWfLaJGuUu0o/sNZ9yEa1Xh+lPu2k482j
XnaMdbMdOV7rtZrthO1rvdbXr879IflV1foenlQ+7zNnpbQLUs+vVcda05K8
5wXnpZZVJad5Rfqrefc3r+c998n3ukzyjby/WyTzptwPc53MRz6eOm625L6N
+VPmWbnvt/KOVyj5fW0Z/clHec/R1pWsNym5/2MulXI/kTrvXMn9DXGZo6Xv
+jTvOT/6MOTnebcd7+advr7kOJtL/qt8rta5odIn6xn1jefFGvVhQu862/Ji
04vt5BDGQjW2Z3wpbHErNrv/hM0j9qm/ht3rq2FbS3rsT38L29hBZdvGYjN7
Ytk2mNhjcgz7Tuw8R5Vtv4ntJ7Z12IxiE0oe2Hhi14k9IcexL3w27GV/C7tX
bPqw98OmELsx7Mewl8R2DBuydeM8NnvY/hEfe0bsf7HXxr77uLJtObHrxLYY
G0/OYbNLvtgxYru7YVwHO0x0bHh/DBtj7Dqx+SUudpPYNmI/h010xRYa+8aP
wm6WMHbLxMG2jmPYjmL7iK0xzwa7V2ymsbnE9hLbPezzehdsV4oNI7aNFVtl
nsvpZduZYluK/TN5Y7+H/S82m9h9YvuL7SZhbICx+ySM3S82mthqVuyosRXE
bhfbRmwcOYf9Hc+3YkNbsalFYveIjSm2jdhPYl/YNsIVO0PCFZtb0nNP7eIc
dvHYU55asI0+Ntc8Y+z0kdiJYzOLzTi25KeFDTS20KdU21Yd+/RT4xjhbJQL
+0q4DOAw2IG9f9W2hcc2fli1+QbICw4EuBA2p07G+TnxLLGNxCZybNm2nNhp
UlewF8bOd1LZNqfYk/IOsXnEBvLCsu0isXnkXWKPeXCN6z52nH3iHWCvid0m
NtEcw16Sd9Ijnjs2lujY7a4V3wTvBpti7DGx8azY0GJTS73GNhQbUeyXkdg1
n112HcKGmvqCPSbp+baxISXNOWXbXWJPSnuAXSo2mPAYwGcwLOp4x3gu2IGv
GXW5YitOGb+Ib5Vv8cNa98305x+FnFvr/d13R384Kvq/6YzH4vxd9PfRr08r
ec/448ITwufCvcJ9woiSxwSXsiZVa53xwvshb6/1/vH5wgKhWOd/qneFhjqn
IS57AtgbML7k/Q2MIc4teb/5grj2mBivsO/gsyg75fgiynK/kFOer0suFbLS
X6t1uJo2V/LVWu9FYE/CxJL3Qj4rPCdcFvdwZ8l7F9jDMCH2XywSXuSZlbzX
lD2nfyr8QpybFO364XX+71yjzv9O/E+WhVT4WfGeEhbWeg8Te5kuUj51OvcG
4wWhVvqyWofXavR9TC55nz7pnuZZ1fk/iuc4Vefe4jlLJnXWOfev8FKtx1zs
tWK8dXHJ+0i4n1tK/mf9J+I2abS8rWQ7gy+lf1VrW4SvJb+p9X/AT7W+D+wV
OPZtre+VukXdubzkOndXPKcPo95dUXKdw7aA50LcT2ptQ8D743rYJFDPbiz5
f+576StqzV9APYcbAf4E7N/hM4D7gTpOGDuDH2tdPvZOLg07Jmwavqt1XjfE
sdcytr2g7MtrbUuBJB77nPi3eTP+7z+P+oWNBO/gppL/7f+Q/r9a//dW1bl+
8e9bU+d61zIk9ZG9ttSzWSXXBer7B7WeDyAP6hH/0JnIi7mJv2v9brDh4D3w
DuYofV7hJyTnlvz9PF3yfAf1hnrUJmR9nf/JflW632o9v8C3V6rzXEI+0jAP
Qb2hTt0RdeipmP9oiLrbLs6T/sxq85bQjrPXhz0/p5RcX28SbhbWblA9VNxt
Yv/m23zzwnqxJ5a9sSUdf5fvn3zrfZ4w+zQfEh6u857QByPM3k/yJK866W/w
juq8T/N1yaXcU73lsjrvbfyM91fnfaYfS35S5z2qyE95rsIDcQ32RRL3izrv
hfwyzrOnkmOEa+udN9dm3+tHdc6X/XPso6vWfT0tOVW4tM774Rgrr9DzebnO
/6v8m74kXC1cU+f9i8wpfF3yvrkJwoV1zvtOYW6d98MyH8GcwYch74z7uUu4
O8oxN8LsReX+uP95kd/EOu8p5F/6x5L3+k2v87wI+w6Zg1hV8p4+ys5cxaPC
BVGm54XLIw179y4WLqnznj4k41yeAfMU/82FNLpN/I7xf+xXZN/iGg1+X1tL
Vqucr0h/tc42p9iqYmOOjT02ueMz3quLPC/j/blIbHLZ84t97rmZ1Xbsl2RW
295fmLGd6QV0pYltIadEvAqnAGG4CrA5xQYVfoFL4xy2rujwEvTP2H4W21ds
4ynnpMxqDgLODczY/rXCQzA9zh2TsT3rVbGvl/292MP2jjwqNvQXRbl7Rdkn
ZLzX+JF4D+yb5Fknsbd6YZ3rWlW96xbP8dv4bkizUpgvLKjz/kvqQa3S/iz5
VKRfFecfF2rq/R5eE/4RFkc9Hay0SyTTBu/xZa/vQey3lTxM6M1e4ZCHC/9G
OtL8ITwXdYd9otStotL+LvlsnPtLWCS8WOe9p9TLhmgn5kS9/7PkOTv2t9JO
3CLcKrSo9/1Tj5rHnm32bu9e7/vJCrvFecLbC/8jP6FZ7CFvE3uZf4/yntZo
uRX7POsdlzLuJP3veDY711tyr2dJ31foyl52obOwD3vWhb2FTvXei/1bna8x
SnqXSHN6nCfNmZGuS+z5Zu93S5Whl2RTYfN6H1sR75Z95d/XOczeet5lk9jr
TXtK+7pt7JnvEHu3NxY2qff+7o0i3Lre7Rptasewe0uF9pFHQ9wHxxqFnWLP
f+fY9025tmAPvrBh5Ms+ctrQXRSnueSvdb5/9sX/VOc6SJofaIuEA6RvEOmx
GaB+b9HgffZ8A5vEHnnikr5NlLdeaFXvdp97GBH3QHmHxT1gzzc8JOcGUy5h
V2HPBtehwySPrbdOfWFv/nd1fr7HxTHq1BDeibCHcHwcI3xilINneVJIyti+
wccPZ0906n1X/xbdjzE/Ozu+W/qE66IdRF4v/Fry/Gljg/sc5k9vqnPbyXHm
R5eG5NzPJfcv5Qb3kbPjO/k95lXZJ9492k7azUH1rsc8i4H1rt+EJwiH1Lve
nS8cJBwsjBd6RhgbAOrTgcrzgjhPmjFCN2F/4ZyQvNuz4/vYTxgdkngnx3Nq
K5wbcalHp/BuhHZCH6GZsHW9bSqoQ62wfaj398w32inqfd+wVyAu9Q77BL7t
1jp+lOR2kWZoXJNrDBB2jPvnP+EGxo+1tvmgb4E/A26MkzK292cP/jnRz9GE
dMiYN4YpnI4RZkp47wirCP/xbBBmL/+YSH9Og7ll4KUZ12AeD7g46CdHRzz2
ufdj/Fvr/ezII2u9z/0woXet908zN3dgyfvW+wtH167mhYEnhnnYQyPNpEh3
eK1tAJiL7FLyvnDmLruVvNee88xBqhj/8YLwDJ6rt/8JOAhelVwsXFZvngL6
QvrJHaP/Iwy3D30q3B3bRv9K37t9xIXnY4vo/+i34WLoHeGFSjNFmFpvLoZD
o29kHz/zkj1K5jUgP/r2rWMcAL+Cfgf+40uo8Ogg4Ux4OvK7tN6cNvTlv9av
5uUhDdvp9ojw6Abz1cCl0zyu09fdxn/PlefSNMoFVwRz2ccLQ4SVqefrDy15
XDyUcbIwUzg5woeVrJ9a8rzzfjz/Ws9Dd40wNgy8++MZk8faXv+Yt9434mGr
wLs/oeT/2suF6bX+f71UuKzW/5pX1Xpe8rSSy3FJyf+aM2PszpoA+bPGyL/u
lZGG//JLhMm13n/PPvyTSh7rc0/M12ObQb05tmS7B/Jgjpm5+R5Cz1qvLXSP
MPP0rMGwDtm65HXKPrGegM7a5siQnWr9X8v6IHP8XH+gMKjWNhvMiR9Usi0H
c+WHlHyfx1CeWv+j8E54H8Pimh2EziXP42ODwroF65FdhHYlP9sjS14bOTDK
vUfJZe4daxqdIw3vkrUl5t3blny8X8nPhmPthI9VtjaSu5XMA0J9gRcE/ijG
uz/Wm89jYHw/W4WN3pYxDn0ms5qLBQm3CWNb+DPg0dgsbP02DfuwlzPm2mBc
CTcGHBknZMxdAqcKXCqvRDzsD7FDbB72Z6SDs6PCj1Phy0FWeHeQ8O4wFoYL
BO4OxtDwuSzKrOaaeS7jsfALEYYThrzhY6lwvpBmStwTvC2bh60iNouTIu8F
8R0flzHXFN/q8RG+tMGcVHCLwdUFn9epmdX8R2PiWz0543acb/rEeB7TGswL
BOdPu0h3SsZ8OnMy5tdpnzGnGPlObzDfDg3sPhnzDFV4mJBw8gz5f8+Y/mB4
pO+SMUcSabpFueB52jdjXifOdc2Y74nwfnGeMLamszLmHaJ8N2dWcxoh4cCh
vewnHCFcWe8+nvFO7xjfDCYPyVOF0+pt10d/2avBbeKR9e4np0YehK+I8cGg
aOs5T987PfpOzl1T7/wZK90U/St9+HX1HjOdIMzStS4mH13rKcnJ0b7PjHEA
aa6t97iKNH3CXhK7yRmRN+dujry5hxvrPd4iPXkfHuOFRVG2y7mPBo8FsQfd
KOxksZfFRhdbXXhgWkSd4l9t15CD433ekVnNvXR71IlxUffhA8Lul3kl+I5G
RH25Vbgqnv0x9ebl4bvemffY6LHOUUp3U6PHWwOkPyR5Xr3HWQ+HZPz1pHBJ
PK95jGmEicL8kPyHLQjJf9gDwljGFMKDIckXblu4ZrdiLrravLVw3Z5XbT5b
+G1baRBzDOtN2FJLDhYGCbsJxwnHCrsqzhGsBynO1pJ9hT5CSx0fyFqOjm8q
eZDQk7UO4eAI7ygMEI4WthOOEo4kf6Xtz5pKYj8q+FN5WajR8SWScxL7IPmk
yj5JflC4B+sRiX2q4FvlNTiKFF5Hx1/BDlVpX9WxOxLzOq7PnHi1eQuR6wo7
w1fDegf24pK9qh3eXDg0wgcI5wrnCIWC9USyu+Q4Yaywf5wfI+xT7Tky1jo6
VXs9Y6TQOY4RbiPg1OskYe84P6LafmPwH4OfmXpdY7SO1WFzU3CeecktJA+L
8v2cWP+J91X2e/gFG/pqp+U9Nxf6xXtqozhDJP/FJl7y+Hiv+wpnCaOErpGO
cOso44nM9SntIpXr1sT+apbGc8evz7wq+/mBHxLfPPjtwTfPExGelVjHRw++
d/DB8zR8d4nT4mcHPj18/ODrBi6+hRG+KPLDR9DceP/4q/msyu967WrXEQZ6
8K+uVTaPE/vK3uQ58gyrzctHGfE7RL2oqTbX0xtVPl8rrKO0OclnEtenbLXj
Lavy+Xz1ar9B3EPFjxF+jfB19HCVfR9VfPBUfPIg8dWD7x188LxVZR8870S4
4qeHNPjewQcP/nnujHslXFt2OeYm9tvzQaS5KurLi1X2b4T/JPwd8UPyHNdM
7KMI7i98Fs2Ib+maxNyJHMOvz+WRjjRwOdwXaSr+nPDvBH/D/XHuxsT3i6+l
6xNzpl4n2SrqywlCW2Fo1PWNq/3N8t1g/4qPH3z4wLMA3wJ+zfDhgy8fzvUI
Dge4HH7I2J8Q/oIqvn/wBYQvGnzS4NMGfgd4HvqEbS7nKxyQSHzP7BecFV3D
vhb/axUfPkj8FMHhhr8c/A5VRd74Afo+Y99C+Ag6IHgn4J/4LuNj+BpakbGv
PeJ9nnEe+P/BJh5/Ofhlwya+VYThtoDjAl9ycKXBpwZ3GjbE+ObBVx18gPiU
w0cQfID4+8EX0L0ZX+OzjPkhPs2YL+2eOEaYvu7LzGpeui8iDcfwt8R9woUB
JwY+vyq+iPBNhE0z/oTwjVTxJ0QYfg14NvB/hB89yoavInwI4t8PP0FwA+Lr
iHeGryOOE8YumnvDTxAciVwHX0NfZfzsKVOP6JNoWxNhz6hHP+ncVpJb0qeU
3fe8q3w2L7tf+SAxBzNczDsJbyduK9/iXev4RtI3FH6o8nHa+K9459XuG15P
rL8m+W2V6ytp4HeGAxq+Z/if6bfeo38peA07y9pstN/DKW/Z6+JVBfNDbx99
3UZR9w+s9nUOiH5jZWJ9ReJ9r9tEm83+V/bFEl6v7GfxnOJsWXbf/JH076vc
v9LfloT2wl5Cg9AhwuVql49wGv0NYdq5PYSW1W4v4b/bleuV/Q1/DmeDZLt4
B8XIm/CyxM9nKWWI/ua76Hu7Rn+yQmVrUu3yvZlYf0NyVZWffdN47jyDbqSv
8n1sIjRWu++krM3KHn98kritJ+8uwreJ+9pvEvve4nvGbp7+YU0dX0P4tMpp
1gowfqgcQ9KH3J+YG5ExA+VhrEC9qIwVCJMX7TB50yfQN9D3MYYg7RdxTc5z
jbXLHsMw9qBfon9iPMP7og+iz1te5X6D/mPNsvt9xjn0N/RPXINnRd9HH0pf
SR/4iOTKKuuc413wzBgLfRf5cY11y+6j6S9qow+jr6M/pF+kD8JvA2M5xmCd
yh4nMK7rCLdStccScKIzrmD8gD8HxmmM3/ApwXiP8eE+ZY/lGL+xB4S9IOwT
YS/IKRGmv+B+H5Lct+xxIGPF/coeZzLm7Bnvn3rwaGqbz7+L7p8pO+XuWXaf
wvd1cNQv6tYBZY9nGNvg+4JxLONVOP7pi+iTrqv2+Ifw7Cgj3zD9F/3bA9FW
0N/RtzGe5B0vT1zvqDfrRP1bK8LU3fX+X11GbhDfFt8YYwa+edqeShuA5Ptp
XnZ9YrzRRPqvvFfpj9GGVrnt4nlQVyrfx3dVq797JN8ZbRf504Y8GvWDb43v
jDpEm8f3tjLqFG0o+VfaVOTP1NHEdf2rxN9eGt/i9mXXG9ofuO0ZazDmaCx7
vMGYkL37jB0YQ3AfjO8YI8GbvyjScB3Gd0/F9ZALo3zUccaIpbIlY8avq/xe
eB/lssdds+NeOce72ivaplK0U7STtFsPJ35utFEPRl607bR95bi39pGu0l42
xDneD3nTD7SL/P67hurceMntCv5foo+ir8Lvx9gIM8ZnrE/bxFi/U4TpH7g2
z/Us9YOP8y/b6H27L+a9NkCbRt1inP9kPC/eE3t5X8p7D+XIyIN8h0e5yZcx
Fv8V9JXnV/t/i++Dfxv+aRoK/m/iGysW/JzJm7rGPfWMNIz9acNp02nbqd/8
g4yKel/5V9g34j0e72/V/3uvP8X7px78Et/St/G+Ho7+lXbg0ajXy+Mdc/7r
aB9XRD2n3vz9/+oR8s+oq9TNJdTZsvt+fC6Mi2+McQTv/av4rmnnae/vS1xP
qa/0sWnZ/TQ+HRrK7oPnx3iWtF9GO8v9rYy29fsoN9/aimiTGRPTD9Af3B/p
CI+N758yjYn2ovK/iKTvr43nu2XBe99Oj3rUoez/O/7z2A83Ms7dHe+Jf7w7
Ii7/h3fFu+HchdX+f+U/cWJI8ppQ7frAOcYw1KEmBfvVGRPlKhccjz17j0R9
uqDaPojGR5j/U+JvjQ2fcJH0nQr2QTQhrj8vJNe/L/Lm/5n/aJ7LNgX3l7Sl
9J/0A4xtGIe0LntMQr9Pv8SYiLFQi7LHRYzB6JO2jnO9q92u0Z7xL9ys2uND
/l9bx7dB/aYNpe1k3MV74V9+aHw3tB97lD2GZHxFn9Eq0jNXQD/DWIZ+hv9n
xk5ty27rGS/xL71bnGP8SXn4N6evY4zKuJR+kvEg48Ldyx5bMnblfdBGV+Ye
kIxT74px/ccZz8Uuz5hzem4cg8MYTpitw5YQLplmYQMIl8kWYfuH7Rs2xhUb
ZSQLHy+XbTOInSB2bdh7Y1OO3TLnsWOGi2PzsM3EZg7bOfKCJ6Np2ExmwuZx
l7hGiwhXhy0h4TmRNxwccOFsF/ZxcOE0DxvI18q2m8P+Ee6NzcJmEw6ZJmGn
id00ecDzgS05vCtPh60ftuiEsR/E5hy7duzesVPEPhH7bWz+uA/sE7Fpx778
poiLjeUNEZd42F2SFjt6bPewmcc2Hft3eFrgV+EZ7RJ2nddF3hVbQyTPGztH
eFewcYd7BR2bd+zl4ZCBS2ZGxOXZ3xVxOQf3Chws2LljR4mdP3bw2EW+FfeJ
3fvbEcbOnecLdxC8KTuH3Sl24vCt8NzZu409IHaJ2ORhm4fdHrZ5iyN8X9k2
7NiYYweL/StcN+yLxX5xbDxrbGOx4+XZrxG2svgowYYRu0b212LLSBj7Q66L
n5HpZds/YtvIXljsF7FjxF8Jto3YkPIMsOXFppd95dh1Yi/K/nRsNLHVxI4U
HR8x+8c9YXeKDxokdqDw3mC3i/0y73udsOPlXWJHjF0xzw4eHPhz4L3Blhmu
BZ41Ns3/hWt8Hi4d7J+xe4ZnBr4fbIqxN4Y7CIk98tKyOS7g6nmxbBtk7I7h
wuGdwOlAvSO/2rCjxZ6WbwxOG54rdtLw+WATjS019Y7yEoaTB34d7ILhFNog
a5to6ghlo9x8c9hhN4TNLra7XIN6nQ9bXjgS4EqAkwougf/FNwqnwJ8RZv6Y
PccV32VI9trjj4y99XsW7C+OfeIr/18fQJ+AfyvS4luta9l+6PBJR7/C/vBH
qlf7S/sg+oz5kZ694eytZ488frPwhYU/OPoU9jqzDxTfeeyzx98W/yX8n+CH
Dt9sxGd/9K2RB37L7o5j+NniXwAfePj4uiXOE+Yfgn8J/OV1K9tfHj71+Ifg
XwIfeaPjGhVfdfdEn3hO9Hn0qweW7Udsk5g/vj/OMVZhHMn4Ef9x90efiG85
5uQZZ54fz+bheI7YD3Cfe5ftnwt/Vfyf8Z+GLyv+z/hPw08f/znXR1m7lO2b
D398/PPx74dvr85l+/XDf1+veGcTqlePGwgzDqF/p58vxztjPMm7WRFlooz4
O6v4KkTi22x+2f0QPE7wZtBnwAMGtwbtOxxT90ebSr2GuwIOC+LRX3P/jDng
54CngzS8B/zUYStzSdk+pPAt1bdsmxn81mFbDZcHXBrwb/B9wuW1sOxvD44p
2jba7n9qVvNrUNfh6Pi6xtxcT5TdP8G3Bh8C/StcYXAkwJVA+JG4DtfAjhx7
cjjErinb9hnbanwqvhzlxp8cfubwL8c/Mj7/Kj4Jkfj9O7xs2xj85fF+8DGH
DdCsqKekwdcdPuj2Lqz2U4gNDT4Kefado059Gd/JEWXbHeF377CybXvwW0c9
wC8hPt9mxvUpH98ofgDx/XdDlBdffvh8pCz4MaRO4a/vuerVPtWwF8GfGvYk
+HmcHHkTnhTnaSd4b9iYYxuODQc25diW4yPsP6m0vzR43hx/9z82eL1ncmIO
YPzKXFdlzmLmry9M7P8HP0DM08NhjK8dfOzgux3/9Phyh5MYfzbMl8NnjN+d
mVXmOb45wkdFHqxXVHwFVXwHIfEphJ/7MyLfil8c8oXDeHSkwUcRvovwWQTP
8Zg4h5+hqVWr/Q4hWQNZ1eA1sIuT1T5yKj5zkKwR4SOJvOBOZt70gCr7TGIO
+8AIM3eODyJ8ETH3it8u/K3DeYwvpH2qPO/eOZ7NmnGM8Npxn5V4Z8Z94s+U
PE9IPM9N3vgzght4hDC8yhzGIyO8osHrExclngvm+vhD7RBxh1V5Dr57lJs5
9R4R3izyxmcSfpTgi4Y3uks8e8p0TuI1CbilSXdePGv29+PLBL8lcNEy/44/
evY4cIx1A3iNmd9vl5i7k/nuton3KOCbh7l29jHgm+fPjPcgsA6xKuM9DZz/
PeN9CRxbmfG+BvydMF/OXgzWA1g3gPsZHyT4SYH3Gf5n/KTMimPM/bPnAv8o
pL8lY18mpLkzxvisjcAfynoG/pgei7xZf3g05PKYaz883nfLxGXATwrXZG2h
Nt4D62oTeWaJ1/DGxbtFZ61sbOI1rf98VyVez8N3LflOivRc5+II9436i78s
3tX4eB/sDfkxnh3vkzUzfGHBZQyn8VGJ/SLxLFsn3gPC2gA+fJ7MeP2A9BXf
WqRnLwzrIqxXtEocB78/T8cx0rPesxfvt8rcw0jWVJbXe+/FhQ1ef6Dc+PeC
T5w2Bf9TV0R/wNgHH4BwXMB9cW3ZPBhwYmA7B+9IxUciEl4SeJ3gd4LHAxu7
UyNemziPn0PGvI9Gv8F497EIw51CPwffFGNYeEP4R4G7gz4Sri3GxXB/EA+7
vdPiGmMiLjxZ15d9D/ByMEbnv4X0cIlwTXioGL8/GOfgTiEffOPCYQJHCz5z
sTNDh48FnhP4TvC3iN0kOhwo2CDiGxIfjNjnwVN6TI3t5Bibw41S8U0IVwl+
CeEkgZ8Eezt4SAgfFue5vzvKHgfAr4WfxuMi30uZK5a8sGB7O64P30rreK74
paz4AIYLBvvD4yN9xW8lZZ1S9nvFr2LLKDvxsL3D9yE+H7Hbw/di/ygfXCpw
avH+4UNhvHxP2WNl+MRYJ8M3HL7nWB/DNxp9AmuHx0QYHnz6HvzHzczYXxJ2
SszTXRBjHeYYmVMsxjvhv47/PLjO0OG3qXDi8I+7Q1yTfo+1u35Rp9tH+4qP
Ofj66efw0QZ3O/7aTqqyT2q+4ZMSr03ifw1fbHD309/gu233OEZfxFrfEXEN
fOShD028hkl++Hfj2fOPCpcPvGbwm8GHA88MYya4pODnoZ7C/ca/HP/G/O/C
C4SEO47+H64ZxlOMoeCRIT3cNRyDqwqOGt4DPG+MIZ6JeNTZ26Ic8ODx/39L
wXUIPp+ra1bz+MyJunxHhOGkQ4fP58ay/8nh/zklnneFcwg5M+o4nEHMPVA3
+X++Mr6BqyP8db33eJ3f4P+ulsGt9G2993hNaDAPWD78jMDTVR9+TOD3qg1/
J/B+JeFHBG6whvD7Aj9YKXyOwGlWCL8k8ILVhX+UCrdahWsNiX8L+NjgZcM/
Cvxpn2btGwU+N/y/4M8Frjg44/B9ArcbEr8q8KgVw/cJfG7khx8N+OLw+YK/
mAr3WYULLRs+UeCjqwlfJxWeNXjX8JPFvcF1hq8teM+4Dv62kHC14SMIXjr4
6eBig7sNbjZ8YcFTB58dPoY4v2lw0HF/cKDBzZYJ3yoVTjeuDRdbdfhigdcN
frcK/xyywnv3ezxHeN/+jHhwuVWFT5dFcR+cw08UnGzcD348PogwPkHgZ4N7
DX8j8LMRZp4ATkz8fHxctk8QfIjA5YWPLXxmMQ8Hnxe+suBMQ+Jvi3mEAZEe
fyr4VYETjLk9eMFIz5zg4RGm/sH/BdcXfF7wfMHvxRwbPGj47qrwmlV4zpAV
DrOBcb0K39ngqNdDIt8Kj1iFV+zYiIevpEfi/THfB/cZPl2Y84MzC98ncF7C
fYm/Fji9kfi7qfjpWRXp4SuEpxB+zJ8jzYI4vzLqAfyGX0ZdIS71kjnHI+N6
+EYh7i7BGYgvJHwSwcNGWfBlA1cbZcTXDH5y8JeDHzU4hGdFGD9t6PjNgacQ
vkJ8HcFTCF8h+cJVyDH8K8E7xzPGJxp+o4gHVyF+qbgHfLXAaQG3BbweFS4M
uDHguYDziXNwVMBVAb/F68GjAX8T9ib/BCfMsuDUgDsJbiXSwn0BXwd5wx0C
hwVcGHBasIedvezwszysOv2t8I3wqPCdsDxnrgx4ReAXeTu4OeDeYC3r7+Cl
eTc4Moj3VnBzwL/zUvDT/BNrWvCD/BvcIHCJwKUDHwzcKfDf/BBcPBUOHmSF
gwdZ4exBwsPybGquEnhX4MWCswoOkC+DzwUeF3zx8J3zfcOvw3XgbKlw5cCd
Mz81LxbcLPCUwFdC+eAe4VnCowU/CPxVvAN4sdDhAPkx+Hco98LUXC7wulQ4
ROAUwV/PomhL8NfzYoTx77M4wqdH20Fbgg8hfAHh+wyfZnBd0n7jbw4Jx2bF
FxrtCv7THo9vAr5H/H/hOwwfTHdEvvhDeyLi4deP6+CjEP9EtL/4N8SPGbyb
1Gt8mSHh28QvG98YnJ/4voP/k74CP31I+D/hCMU/H/6m8KGHLz3yxV/hPVlz
deJL7bH4VibH90wbgC9F+gw4S/FVSB9G34WBDRLuUPwlLYw0+FF6NuLhr408
8AWAT6iX4plOj+fNu58W7580+G+kr+J6+LdaEmnwe0XfQBuP/6xXI4xfraWR
Bp+J9NNweNIu0O8ui3uGp5N+e0bksSTaizcjHn4eOQ8nJ5wy1FXqB2secF/C
WwnfJjyrcMwer3iT9B6Pg+8xZ/0ioY9wiXCxcFgcm4jfMeU/VnJQ0f4CzhXO
EboL43I+d7RwuTBNGCBMj/BA4YoId4PfVfJ05XOE5FRhitAv5GShb0jKcaRw
acTbU2nPkxwMn39c5zL8FIQk3iB4l+N6PYXxOadpp7QXSB6jtGdJ3iXMFUYU
rQ8v+n7uE+4V9kstR+r4aMl7hLuFUZHuTtIItwq3CF0U/zbJU4t+Fg/kfJ8j
hTk5n+uaOt0wOKjjuV4o7JVaHgtftOSEnMt6kHB+3AP8q/jIwwffvtJvl36a
9GMlrxGuFtrr+FWSJxT9Th6MctwsvCm8IcwW3hbeius8Fu3x2UXrZxVdrvnC
PGEM/aXk6Kgv6AuiTLTpD8W7ekp4MurLgkh/rfCK8LKwPzy6PL+i3ytxn4g6
8YLwvHAAe3WoW0Xfz0vC4pzvCfli1IOnhYXxjCj7I1F3FkY5uiufJZLjaDfi
/XDfPeEupj7oeB/pn0i/WPpB0l/nWUu/XvK1nOPNFJYJS4Uzi36eZ/COUj/L
C4p+r+8J7wqHMrbkvcIlnsYzLrrefJrz9XrDbcVzKroufCR8GHXq4wj3VZzP
JC8pug5+nnOYuvlFhPsxNuZ5KM7hqfOYRDtWdJzJRb/7r4Qvc15Lg38W3tx9
Uj+PUxSnY+r3dGLRY77Ls6t9xE2LthA/dLSb+H49Ko4Rxlcg7RQ+XuGRhU8W
nlrGQ/jMq/igmxLtMXyxQyMePv44hh9M/PfRbuLrlvEf/VbF7xyy4o/uiuxq
P3XTo6zwyTJGZdy5suy+Cl+cjLMuiX6JNTr8AVY4d5H4AoSLGIk/QdbNuAc4
cOHCJV/8U7COt2eUHf5xdPjSWQ+Dsxiu4vo4T3rWxuAspp1lraxjhE+Ktp77
xGcnx+Er3iTaZvzI4uOQcsJvzLocPMVwGMNRvH/WfgzhHCYu/mpZG4SbGN+3
8AzjDxG/n6xxwl9MGE5jzuP3luc+M8rB87o+u9qXI5I+Cj+59MH4xsV/4pis
fQFTDnyfnh3Xw48q8fCfy/8SPlX5J4E/mv9JxqT4MD0/7g0/rcRbXvZ/Fz5b
+VeBY5rxxEnCjcINwnHCjGjX9k79TZ7Ev0icJ9wp9fd5so6fKjkr2jnaI8aY
fBtDhZviO+6c+vxQxR8ieV20T/iX5J7wsUu9wH8kYx/+h/C1ypgCX8OMXfC7
yv8PvlgJ819Cf1zxY4m8OuoWeeBTtuLzknjHxHnqNz6OyRsfr3yT+AAeEe+M
cRXjNfxdkge+auGHx58mfjWpc/wz8A8BNz4Sf53UOcZJxMMPLHngWxlfseSN
j0jq4vCIBxchHIWMZR9JzQMJbyR8hXD6ce7EvP1Z4N/iytQSnxf4TsD3Dr4U
huTtCwM/HUPz9jOCz5Fhefv7wKfIVal9keAXY/NIh78F2kv8F+Db4DjFacjb
rwHtK/4s8FtBO4pPCnxa4NcA/wa30felToevCtpffCCQ16l5+0XBP8rxqX00
4CuDNhIfDYSvSX0efyj4YLo1yjo9tc8R/I/g92de3j5C8BWCb5Bfi/Y9ND/O
4dtoQYTxefR4hGek9rGCrxV8JD0JL2DePpKeivAxqe8Jnx34HsIHC75Yjs3b
Bwp+VaYozmWSHxftQwXfKhWfKkj8YBydt5/xaZxP7ccKn+P4VuG+lksOytvn
Cb5PpqX224K/FfobfFbwXIak9jOCbxH6KvyNED46tZ8OfIXQr+InBH8hz+Xs
5+L36C/xzYEvj2fjGH44+qeOi58LxgQrhRXRh+NPBB8i8+LY99HP4xcDnx1H
pvaLgR8NyoEfFPzl4AMFiS8m/DPhpwkfKE2jTuFzg/zwm4EPjBcjP3xqLAqJ
jw3+QalL+My4ON4P7++I1GWZFmOfH4RV0Y/i9wb/Nyem9gOCbxDaGvyBEOaf
lvzw83FSaonvEXzJ4FPm5qLHAug8X9oqfIyQfkFcZ2X08fjcwQfPoNQ+XPDb
Mr3o8lxe9HiH54cvlqdC/pTz2Ar5o/BMvAee9Qmpy44fH8Y7+GzBd8vA1BK/
KpSpSzzr8/P2iYPfHPzp4GPnp6L9Xo2S/qb0XQveJ9C7bJ9BZ+fty2i3gvdO
9GENueA5KfawfF7wXBL7xb4qeL6GvVpvF50WvzD4fcFnDH5g9o38uN67jNHz
9gWDL5lzIh6+V07Pr/bfhRyRtw8v5FLF/zj6WvbOcG/4YcL/0htFp8WfV6Ho
vok+6p+CxzrMn5WLHlcwvnip4H0I7Ed4peA1fdb2Hyt4Dp+5/PmxJ4B9T0fE
GHQ3leXBgtcjWJc4p+i6yJj38Ojbdk7tdwbfOfjDubngfWA3Kf6NBc8hM5f8
euz7YQ/CLTEvPVv67IL3nM2SPqvgPWo3M0YreA/ZTOnXF7ymw9rOtQWvQ7Ae
dU3B8+PsNcBnz7goB+007R1t4WHR3hHGjxH+jFYVV/t+q/iCuyS/2s8bknYR
P3j4wztOuDa1/yP8IOHzjv7jZekXpG77lhTt+w4feEPiWeDv6b543/hKuifK
SJ3E/xP+sfCLtaLod4t+R7xj5O1Rj/CTNTfu7YHIl3p3d5zDp9CUuJ/xUffx
HYUPPvrCV4r24YcvQHz6HRTfScWXHRKfde8XXT582H1YdBx829E24a8OH3T4
/aPvoZ/sHc+J59srnjfx8DNIn/oqdTB13/Z60T6D8GmHj63WURbKh98//P8N
piyp2/3FRfu4w9fdgLz9E+KnkHzx6Ue/Qn8yLnVfsqhoP39HxbmKfyO+rXLe
7S1lp52izaWdrfAswLsAZwPcDfBAwD0BJwVcFPA8Dw9+hj2CRwE+hQ9SzxXC
t9A+uBXgdYDDYkykh2saHc6KrpEf3BXPp8EtXPI8IDzGOwWfAlwM8CvAHX16
cCnAAXF6lPUj3mmtuTXgcB4VXA1wN4yK9PAtwK0Bx0bb4GggDK80fBVwOMAP
AU8EHBdfpebKgGejwrdS4V9Bwn0BhwWc0nBafJ+ayxqOX3hV4GSBZwWeZjgo
4J2o+DyDg3h5aj4NeDPgaIGvA14OuCEoT4Ur4pQoK/wUw+OZwj8xNt4NPBTj
IgwHBlwYcH18k5r3Aw6QHlHG/zi98x4XMmYsxRgR32p8H3CPw0XO+AX+44pP
OSRzt/h6Q8KHjH805pfhc4bfmfj4oWPsBWcyc8C3pJ4nhduZ8Sb8z3A7M67B
Dxv+2GZHXOaDGVfC4Uy+8E7DRb11ybzpzONWeNmRFQ51JPzUjHnhrIaPmvEg
/NDMkc9JPd8NLzTXg1MdXvEvUnOYwE8yM7W/Ofy74cPuvznrotsm5mfhccbv
GxJeZ9oX5nmZa6cN+zziPRd5M1dNf7s8nmnFvx3vHg5q4uMzjjHcongWjEm/
izT4ioPvHd9xjO+wBaFMjGfhymaOfFYa8+ZFt4usAbA+gJ9BuKzhtF4YecDx
/lDqeW045OdG2YkHrw88LRUeoElRdw+N+gtH+h3xn3B7jFnQGfszxkHSdjBO
2SpvH2yMX/AtR7jiC4127uTU7RT+Rhnv4JeOeIxr8PeGb7pv6s15cUGD/cTR
3+BflbEn/u3w73lK6nYQf6D4v6OtxE8oY1t80RFm/LpbhBkn4kOOcjA+wtcd
+eJHj/4JP63Xp35e+Oyr+MmjfCNSt8v4bMV/Iv7s8H3HeI5xEuMa/Awi8R/K
fwu+3Cp+3pC004zXGA+RHr9v7fP2M4ufPs7jf5YxMs+JNpvxLH0SfRHtMv0N
fuT4z8AvIH0XY03GGfiyWxBjKXzbMbbdP67HmLR7xMM3K3niS26TyBtfdvhp
JQ4+9ZjnfT7+CS4req3n0uJqnnp461nDoX2H+wYOHNos+OQL0X5V+Ob/47+p
9RrJfzzztV4P6RLtOlz3tI/wzy9KzWO/S6zP0N/QP7SLdhzfImtGOvh03kvd
XsPzQzo4f+D/YQ2MPgzOIHiEaDfhwG+INpRyrxN5w+nTNvqSNrEO1inSV3j8
4QNizWf3aMvh64G3Z/eS13DgxOIb2ija4gqPPpL+E44m+r/2JfML0Wd0KpnH
v2+kfzX19wbvVpN4xlwb/yz0r/iPoG+E5wour7dS9xlwfLGOh0+Lii8UJGkq
vlsoN/+d+K/E3+UGUS54nd5J3WfAncX6GLxh8IktS93Pwf11afx78J/H3Pyz
EZ4WdYTwn6k5k+FGps+EZwpeYvof+KfgUv45NeczHM74XsAHA34b4FaD0/j1
aGvmxbmKTwj4iiFNg6sZvuJr4hhcxvS9+HXA5wN+HR6JcMUnBGH6WLir4GT+
OzU/MzzPtP3wWMFfDT8/+cG9TN+/ONL8npqfGQ5quJjh0IVLF15cdDiW8XkC
PzA8zzs1mtsfrmB4d/FVUvFHhMQfCX5J8KmC7x58ouC7BB8p+D3BFwr+jPBj
NDTSM8aBMxvu7LUjLv5a4EzGHw/c0vA7w8cLVy/+WPDLgj8a/LL0ivD2jfY1
gA8a/LgcGufWivzIC05qfB/BUY2/JPwsPVfymAPfG3BtMQa5NcJwfaPj74Pn
Cm8x/MVJo7mX4W2GpxsO5wpvNxL+b/jF4AheFu/mr0hfbDRHMbzKPHu4peFw
bmg0xzKcyWmj+ZDhrIYTG+5iuJDhKYdHGn7p+XEd+KLXgHSvzlzWvGd4reFS
pk7B0wzHMvUPbmY4mikTXMjkC184x+BxrvhnwicN9R0O59/iPqgXpBkZ7wre
86Fxn/CpwbFGXYfb7aSo93ALMr67OeLBr867xjfKafG84TjDBwoSn0hwfv8S
z+W8qPv4aYELHb7z0SXzg/NNwed2Q3xb3Ae87vC4nxljZJ4X/O+My+FOh/P9
zDgGz3vFBwwc64zZ7414FT53uNHxl4R/IXxjwSl9Wjwj6gF81nBj867gsMbP
FvUCbm58D23aaD9c+MCCH+/6WnNHwxkKJyncj7xz8sCH1saN9reFX6ENG/3t
4YeI+gK3Nb6HCvGe4LFeGN/SU/G9oreJ9w1Pd4VjG4mfrXMazWkJjyX1Az50
yg0XOufx5zUh8b6+7xVnYuK9fCulj068z3q59FsS7/2u1j/47Yn3peel35Z4
/3aWf/bEe8D/VfzLEu9//k36lMT78X6WPi3xvunfpU9NvH/v14bVvN60K5ck
3mv3k46PTMwl8oX0SYn37/0g/ezE+8G/lT4q8d7Xr6WflpjH4xPpp0rfXvpH
0s9KvFf2G+lnJN4n+5X04Yn5VT5rcF3n+nCH448Mv17wkPOdwHu+WzxTfDQN
qlvtaw2fVvhTwwcaXOXwj6NX+Mj3ivfHOzkm0sN1Du883OdwzMM1TxgedI7B
T9+i0f688O1VjjYMznLKRXtb8T+GrPglQ+IvCv9Tx0q+z1ii0T658M+1Q5QX
X1zUO/zb9Iu6eGSEKfuwqPfwx8MjT/ngjodrHi55eO1pZys890g48vEdQJsL
Nz7tLj7F8ENGewe3Pt8JbRlxG+tW88hT9lzcG+EKZz3XhkeePHkG+AMoxjex
bqP7BnyiwX0Pnz7lg2ef51fh3UfCc39/9E/3lfytkx/87/hpKMW7mhvv785o
tz6IdgHOf3T8ROBDgTT4g6j4MIPLFB9p+GbDZ1rFnxnn2jWaLx2OdNoReHHh
q4W3Fr5b/ILxfuAjh5cc/2djI323yLviDw2JfzD8s8GpPj7eHxzs8JP3jGOU
o3uUhbwqvtDwjUY/zHXh1O0a+XEOP2v4avui5Hc/O8pKXbglwviHg68a3mrq
F/zuV0cdhNe34pcMCVcvnL3EwQ9aRz2Hq+rMzc73A0873OxwRsNhC4c0PO/w
usP73rbRHOzfRbngg4cXnro7LZ7XyCgL3NlwaMOZ/b+SxxncX8XHGhJOYTiH
4R7Gh9rAuD587+0bzf2+KsYy18f99I3nCv87vi/ge6/4OEJOjHcMZ+698c7u
j3CXRnPvw5kPxzwc5/CWcx34wuEGh2CXe/43yo5/gHeiTC9EvFvi2NtRF7gO
HLo9G80xDt/4/o3mQof/nGcGf/3jdav56wl3bzQvOvzq1DO4yuFXh/v+sSgf
PPrzIjw1zsOjDrc17wfO4dlRlreiLsDd/37dar5m+JvhwIdnHW5nniX6q1Ev
4IOGz/2ueM8f163mhubcHo1+XvgLOCPeOdfBtwK+FNZtMFc7/OtwQR/caH51
ONXnRn4V3wLIij+BD6Os+G7Ar8JaDf4O8HUA/zT1lDwrvguQi6MeLYt7g+eb
ZwD/Mjzq8C3DvQznOrzLhHmH8IpXfD4gKz4ikPCVc6/wtVf8AyDheef+4CMn
Pc8Mfnfi8bw4DzEv5YKXHX52vhV8IeDzAd8O+HjAL0TfRvN7wysOXz68+d/E
/ZAOnnd478kPnng4z+E+37HBPhXIg3wr/iQq/iWQcKNTj5dHvvDSU078HcDH
Dmc5fjEYl30S49eKb54PYwzI+B6+26nxH4JPTMaMb8bYE18qpJ0e43Ha24qf
0nciPe8ETnS40Rkn0u5/EWM6fJrgP4f3THkq/jSQpKn40oBPf8MYl8HNzf8B
bRztyj2RBz5d7ou8yZd+mD4Nn5qXJ7YF+6PBPjx4xhWfHkj8a8DnDqc3/O7w
scPL3rbB7xze9RbxjneP8AZRFrjFT240Nz48+fDTw/sOxzvvqlOEy3EM/nf4
5uGdh7Mebnc49OF6h+MfHnHqKHUHTvQKxz+ywv2PhCv8lEZzksNDDv8+vPzk
RZ0iPzj24arnnrge3x8+BP6M+ktZ4KanXrSMe6Ot+j3akoGN/mbwQUA7+Eec
O7LR9wDPP34b4PzHF8DRjf724Mx/IJ4r/krmx3nKCBc9vPV7Nbid+zmePb5N
8HGybrx7uOtbRZ1oE+FSlBeOdbjW4WXfO+py24hHO/hL5Mu14f8n3+Mb/c7w
BTA21qHZ53VFYpvCP7ERTGzT97f0V6h/9eZwfS/0afXmG19Wb87x90N/hnaA
ulv/n+ncf3HfivjvCq9z3ThOXi9GOtK/JHxQ/9/W48wYXfdT7lP6WOkf1/+3
dT5zrvTP+b6lnyf9S9oS6eMbPG+5bthuvB7Xe0H4irYhbD2w+1gn5jYp5zvC
kijD21F+0r4Z5dw+5/2R7ItsKvTKeV/hZuzLyXlf4frC/kI3Yb2Q+zGPmHpv
Yi8VvEfRcbpLbpP6/IHSX47rwUe7Tc77ONm/uV1ckz2brOvAl83+7x1Y49Sx
Q5V2y5z3m7K3dIuQXK9ZzntPibdt5EG+zSNv9oRuHZJ4z8U7g0cenmE42RfG
sSVxfJ3EnMe36Lmtn5jDeY709RJzJt8mfd3E3Mi3Sl87MV/ybOlrJuZRntVg
W7/1pU+U/h1th/SLGmx3s17YAH4vfUPpk2jjE/M0z5TeJLE/mbnSt0js++Uu
bAYTc2jfK32TxL5a7pS+cWKfLXdILyfmir4Ru57E/M83Sd8gsU+B26VvyDvJ
eU/uZVGv4WB+Jeo+3MXwQ8ETdXaD+X/hTX4y6tFrUeenxPN7KvJ4OvK5JOI+
UW9OY54rPMdvRNrn4jp8E0fXu25QL+Aofj7q8qCM6+pLkffi0J+O98T7qs64
Li+Lb/St+Ga5j4GRF/kMiOsdHfX99bhmQ2Je7uvpH1PvS+7JOmbqfcAHFW1j
s33UU2yN2gl75myXs13Uuy1SH9uXuip9L+ldi7aLap9zGLuptkKbnO14SMd3
gG3GJpIbsx+E/SHEV9r1pK9FmqLth9bMeS8v9k/rSq4jbJD6O2xXtJ3J+vFd
speuQ1wbmxPeN/lig7JRzuFmStuJb7jovXR7Cx1ZV0kt9yvaXqqlsHvO9lLI
3YQmqWXnou2OdmW9JNoC9j2fnbNNUos41yb1PumBRbcZYyLe+qnvY8+ibaLI
Y+ec7aKQOwmbp35mXYq2JWsttMrZJg25B+1VarlP0fZUpNuRb1/H96HNKtom
aoec3yU2UpwnvFHqZ99ecTaWvinPrmg7q22iLWmVeg/30ewxkH6G9P7SW6Te
R9iv6Pd/Ss77B3dNLfuyPzDnveOj4lkcIwyOenByznsYd4lj7EPnnZye8x5w
3sOInPeMU8YeOdfRQ4pukw8u+h7YQ98/7nlAhHkGAyPcMnV+RxVdF0/Ludzs
L2GfyZFF3zdtfM94B4MiPe+na873sWnq9nfvou2iaJcJY/u0Vc5hbPt4ZrS7
2OQhaac3Udom3FPRdkj0K1xzs9TnO+n4jqn3ph9WtF0U/RBpqPed49lQ79jr
SbydUu/L7F30Phj2w/Qpui6ckPM56uzxkQbbrM1zzrd56ns6QPFbp66zA1hT
S8zTf53ahF/URmwlfar0H6RvSpv3f0Wde7RVVRXGiSvKXXuvdc62ZGCCOkCM
eAhGYEiFylsekrwkCVAe8RQQQU0QCQQVNCUFkac2EEVAEAS0KJUwEZXHgIwy
C8jSXoKmI1G0+eubZ/AH48y7WXefc/bdjzXn+ubvs3hHEN8SzuWLQbxNuJv1
MvG54EHuDOIrn23xq0G85PoW7wpiLdejfzeIw/xVi+tn4oVdBUcnE8+rh8V1
M7HJYFXCaIPV1tfiBpm4fn1KYqjBUrva4vMzMcVgVZ6Xic3XG55HEAv6HIu/
kokFBjuzTiZGGFzMXwWxQGGCbg/iK8JZ3BjEas4tPhLEjYQf+ecgZmhji9+2
mBvyhRa/FcTNu8DiQ0EsPhiTsCxhWra0uFkQr/7ZJC8oPH2ow56ZibkGE/Td
IDZbC4v/GsSBhAe5IYgbncFcCeJRn0tvUBCnEV7jRUG8/C22/9eCONbnlcSX
hDN5kcVHg/ikTS1+J4j12QwdVxBXDb7aiSAmG2y2z4K4cPDhWgbx+bfZ/lsE
8fm3wicO4vM/Tz4R5FXxc4vbBflN/NLii4P4/c9ZfF0Qc/qQxd2D+Gq7LR4a
xJr+ncVdg5jKr1rcKYi99orFi4JYFJ9Z/FAQC+SExZcH9XfvsLh9UJ/3SxZf
EcR12Gnxd4I8OF6wuEsQ522XxR2D+A8vW9wkyOthk8WDg7jWb9JHHsSW/gM1
kiDOSbBjUpWJa3mZxTUz8THbW1wjE8vyuxYXmfiucF7XBzFPqi3+bxCPDi7d
x0GcPXh71wdxuX9v77U2iI9Sm57UIGbFXts+PIh3/ZbFo4J42G9bPCKIM/1H
i38QxLg+aPG1QTyKAxb3C+JsvGHxwCB2x36LewXnaiR5KeCpUPG14LXiTcEr
fhTkhXgr4D11TyEfBHwW8FTDd63iscZrxauNV3zYKp5VeFiR0+BHga9ER/9/
/Nza+TY8J7r7WPys8LbC4wovuFmFfPHwyCNHxI8CX4o5hbw58Nog58PjAj8L
crKx/nNX3wefteKVxX7xwmAMPmLkrviu4c9V8RvDJwNfLvwi8I3IgrxRlpCj
BXmkPGLxyWp5Qj1o8afV8jlaYPExi8+1+D6Lv6iWV9VCcluL61k83+L3La5v
8b1JvlkT/Rh9KcjfalE65UWBNwU54iQfhwcHfiODknJyjmXFq43Xij8br3h1
1Azyxnk4nfK6qHhf8Pq8/VscxOH5PKkGwPHAg6yNH1f8QirehPf432C+//yT
QvNjvEjwOSEPqXin8Mpc+95C74c3x2j7t4J9JvmfMF9/wM8F/EvwIRng78Pn
Zf7LvJr5Lv4fi6t17o5MivFh4fPha/KI//2XV5/yS+EVL5TB/j58PubPnOMP
+vdb6r9Pre1aP8/4ezzmn6ni/4EfCHW3Ib4/ahjDfH/UNob7z9Q8RvjPrf34
4elCTWSo/34r/z4VTxlivPNm+vtsqlZ9hH0zz8cXbo6fl3iQbPHPtNKO7TZ7
vTWd8jvh/zhHVlWf8qjhFb8X1uhm+z74G8/1/U70/+c7j8nVb3aZa67bni6t
T7condN+235+Uv2EOgo651ecszXe4ppVdsws/lMufeb9zB9te5Vtn1US3/xK
f27uy6X5mW9jLsnEHLvW77eT/B7LffhGv/cOy+Sffovfh2Fiw4nflEtrhOao
QVLNaIh9th25dKXTyorRVU0v65kORxTmPdxb+Lfn+fMdDipc/J25dEwzbPxY
e68vbPsdzEOSal6DCmm/YX/BAGubiQkGG6x+Ug2L+ihzCVis8OZh3E/2Z8pv
cmm3Zpb1vIA319qfF3Dl8IfhWQ9fmflAj0ye6KMsvitX3wj9djzT4fRd4jrn
Ma6XZm4Gk/kcn1fAY2bO9mouPdidaDdyab3mllXvpi7cv5AWerDtZ4mNz5Jq
aqwD/DqX7ux29CC5tGGz0ADm0n3dUVa9m3poPxvfy/aDidwYnnGZWICTLe6X
ibs2yech8AHxzKn2mhprCMxb4APitdI/E6vtxpI49Z19HgUnEV7iUOaZXlMe
YL/b07Wh6H3QqMMzecHGHIhaX7nIxoy18Y9zD7K4byZe3EQbM8riTyye7lp3
eDXbLW6eVAMdaeN7RGlbD6KlQgNv42+zMTfYmCe5v9iYK6O0QGiC9ket5aAl
uSpKO4SGaLev7TWy7a9FreddaPG0qFrwB2VpDqhxH7d4X9SaXFMbM9K1OOgx
d0Wt2zW07X0ycecm8LeOWtu7wLaPcP3Q0bLuv9yHH2DdPkoPhi6sT5QOGT3y
8Cg90JGy5sbwePEQaGf732vxYOY8rqtGV8j8E8Yvvgdrc+kV0S0yF73U56XM
gTv5fPWcpLWEawrth56XSTa+XlItdWCheXI7n8cyV2/j8/PZ3r9B3yrvRQ/O
BIvf9DVO1qLH236e4D5v8SFfh2Ote5xtX23bf8q6d5T+6bD97sGodTi0SP2i
dNHoo6/w5/SUQv0IY72noCpKH4tO9qVc+k3uMx28rju1kKaENYMPy+pHGOe9
CQtdszjY7y3wkmaUdD2i/5/j51VjuDgl3T9b+321jT+nqdm39nxjXKHrGq07
mneutVCl6+WbSbqQsYWuWfTt6Ny5V8OZmunXV3WVrkfO/6YWTyspf4E52MHz
piOep8ykbwWek+eD8N7JAdt7bfwme6/DufTK9GN9mkvji14YbvhRz7+O5tLp
0o91Ipd+dwX3w1yaUrSl9Juh8V1m8ee5tLtoeLmH1K7SNfuy92Bwr56ViYcI
z/LOTHwqOFVcF6dbfAP5VNI6xw8LPafQ+dFn1ippnWZMoe8IS3FeSetVrIWM
su23Z2Js3WXbZ7nWCr3bxUn1eer019iYrEr3uocs7mvxQn/e0b9AHwM572rP
c/ESW+e5MM+FQX4vbZiJ2UpeTG8OHIN/+nOwIeylkj5PI4vvtvhqi2tZPN7i
3hafBqvL4rmZmEpwvyZl4p3N9pzloOcg5D6/9fyFY9jcxtxXUl72lK8vMFdc
5+sLPAsG+vOUgj96dXTrjZLWXFh7oYawxHN/9DYwJ2FPott53DU59OyM9/4d
tDowKmFVoudZ6foc9DyrXeez2PXK9OThvbTe5678rVvCuPLv28riBRbHpHUj
1m+X5prT0E9GLxIstbU2pqvF/7HPOdziOVEaNbSZ/O1gzMFXbpi0NsQaETol
GPp4eaFNwpcEjzXWYtZ43koO+6Sv2bF+94TrkahjrPTaCD1WcKQPl1SHwecC
7yzqG/gkUEuhpgEbFO4sNRY8FKjDsLbHPHJyoVoBvH24+9RMHvU6CXUPmPyw
+anh4OmABw61ETj/8P6pn8BFhV/7Ti6tPD2g1GrglsIYpoYDKxZ2L7UdGKaw
eN/N1XtAbytrT2s9f2fu9H2fJ3zL8zfW+qgv4ZGDtxgeV5tdx0Uu/H9vsJJ0
X/i24DtH3xmcpWMWz4jSJqKH5Xl9RpWecfSdwRXcaPGjrmlDC8naEz6U+AP3
TJr7olNjfaq9r0mxboWHJf60eEmQ1+CvyPlMP+9qvleUXqqmbb8uKZchp+EZ
RL92H2rtSXnjHbb95qTcGX/CHkn57XSLb0rKQ5cyN0jKdW8rdJ3Cg+Wa5fyE
tzDC9vlRrh4p7nvdk/LYaTZ+alJ+vbzQcwR2xJCyrgtYE9dbfJfrSk/6PZNe
2lXUepPm+48WmudTv72cenBSLoCPIvNwWM2DSnqvjeRRtn2yxevJsyyulbTe
f6XFS6L0W7UKzYGX+dwAjR/MUtilTaI03/B70NfBZYXPylwCrvKQko7bM/69
uiTVF25hLhqlXTutUM8gbJNeZR3Pp8ndbPuKKH0k+tkptn2DH+flrtmqbfHi
KD1clcWvR+mfvlbonKcvb6Htc2mUJuz0Qv2ScI93+3lOv9tiG7MsSqN2ho15
P0pnc5nPN6b63I/nHf3Ij9n4ra4bPtu2b4nSFte1uCrId5bcvG9Szkxtg3sR
DOERJdUEpnoNgXoCvpj4pj4fpatD1/kL19uhCd0cpVVDs9bfc/K5hbRoaNLq
WLw6SruJthev3Ku9DrwxSid9FrrgpDVv9D7kHbCLR9vn2RalHUVDit/zQK8n
r4rSqqIvpt+T9Zo2Zc3/YTWPLanHk/WOb9j22knr7j1t/GDPe6kzDfL6xt3M
Y5PqDrMtnphUa3qY6yUpH57p5+Q0PwfIiWDRDLD935hU/+FcnZBUm1pUaH5O
DWohx9nrWbf6nHCKzxXJC27y+WG3pFrSjyyeF6V7RlP/vaQ6BTWqifYdc3+e
MoehP31lWTWiCTXki0uNaEwN+ev+LEqbiy57UlKNanGhOc/9Pv9hfbyzr5Vz
Pt/u1+DQpHrEvELr6Z1qyPOctfIuvp7ePKonAXYXOgE4Er3L0tuhb7vEfvfb
mXxQyJvo1YXluMniv7gWqo2NqRPV90T/E8f/KT+GHM81fgzpx6AvY09ZvbRw
PpcxN07SpnS1MWdG9ZQ/Y2POiur9f5Y8MYoBsJm1i6jev30WfzmqD32T/x3X
+fHhWK31c4D72Davf3SO6gGhF+RO13l/UlafLwzSFTxHolgFT9v2G6J6Ieg7
HJZUv6KOxef5wN93XFT/A72GzFHpJ33QP9tx/y70dMM5P2D7L0fxDzaU1ZuM
78MOrt8kHQkaveNRukT0iXweevPW2/gUxVcgZj//9s95WpLWp5uNL6KYChvL
6oMe7b3MHNtjvv3vUbq6S8mdo3RvnSzeE6UZ/Xqh4/+hH/O9UTrOJoV6FdAk
NbD4ZJS+raPFLaL6Z+gxrRvVc4efWIeo3sg3yjpP6JHZavE/onSBaCqZi8I+
Z77dLKpvZwfnZFQ/w0cW/ytK/4d29cdRPQ8fl5VbwdBYU1YfIz1CL1r8RpTe
tLEfk/f9mJ9wXWMH2/5elNawrecg9PwuYH4e1e9Ev9SoqH4belXrRfVXbmf9
Lar35j3fTv8S7Dp0k+gnO9s+/xalG0Q/2Dmp9n1zoV5+fB/2l/Q8fc6fs/Qv
0cf0ell1KpgeU/140nsJdwQmAKz7Pfa7/wP/pXaK
           "]], 
          PolygonBox[CompressedData["
1:eJxFnWOYPMnTtXt60DPtWdu2bdu2bdu28Vvbtnf/a9u2bb/3vSef6/0QV0d2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           "]]}]}, {}, {}, {}, {}}, {{}, {
        Directive[{
          Opacity[0.3], 
          GrayLevel[0]}], 
        LineBox[{2527, 3710, 2525, 3709, 2526, 3730, 2555, 3729, 2556, 3739, 
         2571, 3738, 2569, 3737, 2570, 3759, 2599, 3774, 2619, 3773, 2620, 
         3790, 2645, 3789, 2646, 3807, 2673}, VertexColors -> None], 
        LineBox[{2531, 3713, 2530, 3712, 2528, 3711, 2529, 3732, 2557, 3731, 
         2558, 3742, 2574, 3741, 2572, 3740, 2573, 3761, 2600, 3760, 2601, 
         3776, 2621, 3775, 2622, 3792, 2647, 3791, 2648, 3809, 2674, 3808, 
         2675, 3821, 2695, 3820, 2696, 3840, 2725, 3855, 2747, 3854, 2748, 
         3873, 2777, 3872, 2778, 3890, 2805, 3906, 2833}, VertexColors -> 
         None], 
        LineBox[{2548, 2549, 3728, 2550, 2551, 2565, 2566, 2593, 3757, 2594, 
         2595, 2616, 2617, 2641, 2642, 2669, 2670, 2692, 2693, 2723, 2724, 
         3853, 2746, 2775, 2776, 2803, 2804, 3905, 2832, 2864}, VertexColors -> 
         None], 
        LineBox[{2552, 2553, 2554, 2567, 2568, 2596, 3758, 2597, 2598, 3772, 
         2618, 2643, 2644, 2671, 2672, 2694}, VertexColors -> None], 
        LineBox[{3382, 3381, 4320, 3415, 3441, 3442, 3469, 3470, 4372, 3497, 
         3519, 3520, 3549, 3550, 3573, 3574, 3601, 3602, 3624, 3625, 3646, 
         4468, 3647, 3648, 3673, 3674, 3687, 4497, 3688, 3689}, VertexColors -> 
         None], 
        LineBox[{3413, 4319, 3414, 4335, 3440, 4353, 3467, 4352, 3468, 4371, 
         3495, 4370, 3496, 4385, 3518, 4405, 3545, 4404, 3546, 4417, 3567, 
         4416, 3568, 4434, 3595, 4433, 3596, 4450, 3619, 4449, 3620, 4465, 
         3640, 4464, 3641, 4485, 3667, 4484, 3665, 4483, 3666, 4494, 3681, 
         4493, 3682, 4514, 3706, 4513, 3704, 4512, 3705}, VertexColors -> 
         None], 
        LineBox[{3548, 3547, 3571, 3572, 3599, 3600, 4453, 3623, 3643, 4467, 
         3644, 3645, 3671, 3672, 3685, 3686}, VertexColors -> None], 
        LineBox[{3569, 4418, 3570, 4436, 3597, 4435, 3598, 4452, 3621, 4451, 
         3622, 4466, 3642, 4488, 3670, 4487, 3668, 4486, 3669, 4496, 3683, 
         4495, 3684, 4516, 3707, 4515, 3708}, VertexColors -> None], 
        LineBox[CompressedData["
1:eJwl1FdszVEcwPFTI3FrtDUSEtXxZIsRJbGJEaONkahZ48FszZIgqNlBBS1q
S1SoFyRUYgQvJF4QK2LEXq2VGE98/vHwvZ/7+z/cm5xz/idtZt7Y3LgQwkgf
BU1CeBMLYQ/j4kMo519zGYP5GJvyKJN4hAk8zESeY3ueZQfe4EBeZ39e4wDe
ZTbvcBJfcRlfcjm/sJC1LGKdhBAqGccTTOJlJvIK0/mEPfiT3fmLQ9i0YQiD
2YwT2JWzOIwrOYsrOJtbuIblLGMZy3mS53iRt3iLz/k4+h9+YKxRCH+YzFhi
CJ3Yin3ZjqPZmzM4gkuZzWLO5VFeULW2me/xkz6ryly/cQhXmcIM9dJEZetr
9Hss1Q6dUpWu6bqe64V+6beaWdcJSSE0Z4toz6L9ivYqWn/PBzGfgzlEk6P9
ME/hVM3TTvN87uIC7uZCljGX5czjHi7iXi7mPi5hBZdyP5fxAJfzIPN5iCt4
mNOjc8BpLGYOSziGazma65jJ9cxiATOYy57MYxqnMZXTmc4cxjOTMWax1hr1
Yw378xG78SG78zJTeImprGQijzOJRfxrT/JYw1zWcjyfchyfsQdvsw2vsB5P
sm60h/xo7yt4l8W8wxKe50oe4RwWcSKXcDhz2Iuj2JZ92JId2YCt+dtZbcD3
0TvjDD/iM97kTVbzLM9od5R5NVdppvLNQ6Pv7MLOSlATfffudfX8Ae/roqqj
+yO6O7RBBVqg+cpSpm5b/zHMUE+lKkWnPW/DKiaznupqr7kOf7ijvqvU/I3b
+ZXb+IUlrGUxa1jEzyzkJ27lR27hB27me27iO27kW27g69j/e/Ifb4m2LA==

         "], VertexColors -> None], 
        LineBox[CompressedData["
1:eJwl1FtMzmEcwPG/w7wWlVPlUGFsNhSVwxwvpJTSpotsDnOYY06zOeUQbkx0
g4uYC6ZQjc2FUBib06YbG7lwGsacNzZGjPk8c/F9P/td/d/3+f+ed/CS9aXr
OkRRNMJHbUIU9YmLossczUscxYvMZBNH8gIzeIfTeZvTeIu5bOMCPuQ8PuB8
vuFmvuYWfuUBfmE1OydGUT07sYG9eZ29eIND+ZRD+Izj+JNj2c589ukWRXlM
YhmzuYwFXMpCVnAZq1jJfdzFGtawkRfYwnts5Qve40s+Ds/lB8Z1j6JfTGdc
D+fE/pzK4SzhRC7hRm3SXHM1y3mSFWzmQ7XpmPkzu8RHUUw3zIM4QRM1V/O0
UZt0UId0Vud0U7f0Uq/Urtyevid/K9l5l5lT2De8Uy03Z3AFM7mSo8IeKC+8
L3M+t3IGK1jAbSzkds7kDhZxJ4tZyWyuYhbLmcPVHMM1HMu1TA/7wrSwLxwY
9ogxFrMLZ7ErS/jJb5nMj5zCRxzNNmbxCtPYwnTWMYG1TGQV/zjbffzLtfzI
NfzEUj7hbD5lDluZxqtM5TV2ZD3fe2dH+I5HeZ/72cQtPM4VrGJZeC7ncANn
cCHHs4jDOIkpHMEYB/CHXYvxLb/bwW96prvmu7zE86znYR7SNu01L+aicD+0
2JzBkYpXd30NdzHc23Bnw/0Pd18ndFx7tFvlWqXnYU84S8VqNReF+6gxumLO
YQuz2cwspmqAGs392cB+rA/7yDNM4Wkm8xSTWMfecf//p/4B8J+cNA==
         "], 
         VertexColors -> None], 
        LineBox[CompressedData["
1:eJwl1FtojnEAx/H/sKUdjHJopjRlFxPLmU25sIO9LraUzGEbwxSFG7OD0xVR
m0RxwcohK1t2YeRwRW2zUTKaM+WwoyjcMKfPm4vv+3l/9fbW8/yf900r37ly
R0wIIdlLx5gQ8uJDeMFyPudGPuMGPmUpe1jGAdaynzXsYxV7Wc3vPMZvrONX
1jMuOYTLjGUTJ/AOx/Mu0/mG0/mWi/iTCznM5ZyYEEI+J7GYc7ma81jBCGtZ
wRpu5VEe5GmeZjOvsYnXeZv3+YDv+JI/+IkJiSEMMZHDnMqEsSFkMpVLWagi
ZdubGGEl17GOF3RRNfYt1rOHn/VFzfbopBDSNE3ZWqL1KlGl9uiETuqKWtQW
/fy4ENrZofdaYH/gQn5kr34px/7NXP5hHv8yOJsUrbYns5ipXMMpXMsRzGcM
l3MkCziKEcZyBft93yL2cTEHmMXB6DXxMWeym7P4hJm8yVTe4BSeZyLPMYmH
OeweHYpeC7dzgNs4yCI+ZyFfcA47OZtdTOVtxvASAxvZ596f4kMeYSt38yor
2cAKHuYq7mIeSzmfJVzACNOZxYnMYBwnMyX6Xr2enW+eqad8xXa2s00tarSP
8wSrWaUy7bZzuEwzlKEExeuL38RndeuRrqlVDTqrv87lDA9ov4bsfRzkXm5V
hV7bW/iKm/mSmxhRgbqi587O6HPAe8yN//+/8Q/pt5dw
         "], VertexColors -> 
         None], 
        LineBox[CompressedData["
1:eJwl00lIVVEcwOHTQtKnNizUp7QoyvRlkIsKjIoKWpgUFG2KMAhDJciNZOOi
kaBIG7RsoBbZKsuhFBpWCU1ObVKqRQNWYEEGmZpa36PFj49zuFzOvfd/5+yo
2LR7SghhUL+mhXA2EkJkegh3mcQ7TORtTmUjM/iE6exgjB+Zy/fM4Qcu4zgL
OMF1jCaHUMhMbuUSbuFSlrKIh1jGgyznaR7mKR5hPevZyHY+ZicfsYtd/MR3
HON3pqY4C2czZUYI+ZzFVczjRi5nCYtYxTOq1i7rBh7gQ/apXz80pEb7Sakh
zNU8rdBKFWu79mrINfu4X7WqU5PSZobQzHS2sFXP4veyfh6/H18wmy85n53M
YRdz2c0Ye7iAvczjKy7kfWbwHqNsYybbmcUbjPA6k3mMI857lKM8zjGW8wvL
+JUb2Mf17I+/Uz7lovgzMIsP+Nc7uslJNvAzaznAOnbzJFtYyWss4VXu5Alu
ZgXXchsXs5DZLGAaY0xglMO+dQIH+NMMvOZbvlGH2uKzzVusYbWqtEfFqrS/
hqsVU66SlBifJ7P8TfmuGWSvetSqFqXYb2Yym3hFlzXp/6rnBC9xnBf5h3Uc
Yy1HeYEjPM/fPMdh1kT+/6f/AE3Jids=
         "], VertexColors -> None], 
        LineBox[CompressedData["
1:eJwl011ozWEcwPEHx8aZeSllr7Sykb1ILqzQtnIhO7s53G3KyNtacyFFmLeN
K1IUzhk3yhXKhZrCjc687ZzdoKZc7WxeLsRsXGj4/HPx7dPze+rf/9/z/Kt2
H0r2zAohjKhkUQhD8RDqOcE6jrOWY1zDPDfxDzfyL9tYURRCgmVsZTk7uIHt
bORBJniAbexlFy/xHC+yj2mmmGKa9znIp8xxJHoP5qL34wf+5lcuXBDCDKtY
vDiEdaxkC+uY5Gbu5VEdU4f1ZXbzDh/riUb1XgPmk4wXh1CkatWoSVl7zWzR
LnXquCbNT/AHT7JX1zR7SQjXOYc3GGOKc5lmAQdYyJucx1ucz9Oc8rxTnOYZ
/uRZ/uJ+jnMfJ9jKN9zGt0zwHRuYYT2HWMpBlvARZ3zrbeZ5hWO8yizPc5gX
+ICHmeYe9jPJPm5nD7ewneu5lSvZyKVczRiXcdqZxZjnd2f5TaPKWD/jQ97j
3ei+RHdFR9RvvjO6a2pWk1apRjvsVbNQBfrirn7WWvNPbOBH5pTVCuthLudr
VvIVK/iS5XzBMj5nKTPx///NP+pLch8=
         "], VertexColors -> None], 
        LineBox[CompressedData["
1:eJwl0j1IVlEcwOFj6uQniDllqYGpLb1LlKnhZ4FofiwZlr2Zg6ZBNbUklC0J
lpuiQy1BDTpE4uJXTgr6VkiCEqjRapCbIj2Xhh/P/cO5cM49tyD+sHUgKYQw
pYqsEJLSQmjhGd7gaTbzFJuYzzss521eYicvs49N7GUzB9nHZ3zA1xziCF9y
khOc4CSnOMsFrnOeCSb4mz95xD/MSg9hn9k8ZiEzs0OIMZ/VbFO7Ks09bORT
vtGo+s3vOad5bWlbf3Wg9IwQMlSsRWvPsUTVWjPXcJ21rFNcO+Z73GU393if
v9jABOv5ldf4jdf5nWVcYim/8DyXmcfPPMkZHtnbWx7yHXejM3EnOhdX+YIr
HOI0H3GcdznGOJ+zhf2sYQcv8CZj0X5ZxIvMYTGTo30wN3rWnm+/7042uMkf
WtIn80d+0LBe6Yke65Y6VKkKdVl7hWdVpLboPtnKAqYqRVfNyaziieh9hrT/
/+0/edJazg==
         "], VertexColors -> None], 
        LineBox[CompressedData["
1:eJwl0j0s3GEcwPGH9XCOmgWJTSJpYpWQWCm9YpA0Fsu5F0aWOxK0Q70sXdx1
ZMF5WWpxiYGRwVbEwkIiUUUi+rkYvvnkl/8vT548+TeNpvqTFSGE70pEQ/gU
CWGGKeY4ziyTXOYclzjPAvPMs8Aif3OL+yzxhKe85glveMFX3jNWFcIbWxit
DeEjG9nNNsbZyTFOaVoj5hWuaV0HKumPzvVXq3Ye+U811SFsmKPcZC23GGOR
ddxmPXf4gbts4B6fnZHnEwt84S9e8gcvuMhj5njEGW4yzQ1m+JNfmWMvs+xj
gl0cYjt72MwO1rGVleV78cFbVfKKd97wVmc6NJd4oHWt6ZsWNKGMZu2kOawh
TZoHy9/5pbzDONP8zBQHmGQ/x9kXef9P/gNwCFIZ
         "], VertexColors -> None], 
        LineBox[CompressedData["
1:eJwl0Dsvg2EYx+H7ndtE8QU0Ya2FnYSRwcCmSSeHpP0CaH0Hh7VHEoeF1SFp
HXZlZ3SYdMf1xvDLtfzzJPeTL1WWyklEFFUfimhkIi55xQtes8cndtnnM9/Z
5wff+MNX/vKbI1kP5iLGmeMUxzjHApe5pnVta0d72teJTtXVlm0v3fAu3fGe
VT6wxkfu8pxlnrHCQ67ygEXWuMAqF7nJGW5wliuc5DzznOYwJ5hwlAO3Jelt
+nLrp17SP9GtbnSsI3VsO2yzzRZbbLLJBuuZ/3//AympOmM=
         "], VertexColors -> 
         None]}, {}, {}}}, VertexColors -> CompressedData["
1:eJztvXdcVGvSNaqoqKioiJgAE2JWzBhLUYyomHOOGDCAipgQFbMHIwZEMGJG
TIABMWJCRMmp6W6ggaYbxYBiuD3j2sd793frc5hXX8GDf83sw2+HqrVWP1VP
PVW1J88bPE2rSJEiRysWKVKsiPAvi6b/+5+Kvv1/BQnXTTooWykrqKhE5uik
gAmpf1+vutXXYrhfJm0L1r3h5Z/y9/XY5Gw9rXGZlDtgo2yK7vfrIZkmF8Z8
VZKscz3l4/HJf19/N2rUkPhDSjq3odenm6flf19P66v00SUlLS57bXPHd7K/
r5/ziNZbG59B60uPPDKCZNThxdPk1TI1pbXKzg35K4NmerstS4yRUv8qJSMa
3lNT1fHOL193z6COwdIVIculFGknndbmhJrm3zO9Xv5DOqW0WjDsdU0pPZw9
pFjCRjX1bxFkefl8Ol2bMVDn890kOrLDYeT4uWqy1fOovnhmOt374O1wdE4S
2eT03/ZqkJoSXFvVTqmbTj0vvyrhWSWJBk5ftzasnZrc697csFeaRkHDZ7U+
fl9CDn6GWh1rqklrgd9to2NptDC8Xq1ZjhJ6d+ugdHIpNXXRzrUrOieNmkZc
frW3lYSaLm3WY1W2ih6EyWcEt0ujytf9j59LTqRyxv4BQRIVvbMlV1WpNEoZ
Ulm5YkEi5Zg7bBkRqiKLlgcNkxMV1GpS2nS/Mon0cGW1TzNvq+jJRJ+LFW4o
SFfP49KIywm0+Lbd0apXVfSl9I6oB54KilEUmdxyXgKpJA5pzudU1CjCeN2g
zQp6GzXEPqd9Aklmeay+4a0i7fPLi8qXK2j2lNKbzAwS6JT/guqRxzS4ebPl
65FFCkrv9+ZIm+L8deE+JXGfObgP91zuPYXveorvqoDvEuzQA3ZoCzsIdnsP
uylgN8HOwbBzVdhZ8AvBL83gF7Ef7eBHa/jdA36/A7/PAk4kwElv4ETA1Tzg
6j5w9Qg4HAgc3gAOBdwuAG4VwO0A4Lw6cN4FOO8IXqSDFzbghcCjC+DRZvBI
uJ4B3i0V8S4HPL0g4mkoeJ0i4nUcdOCLSAdqQDd2inTDFDpTSqQzedUlv6D9
fYdeyqT2jaVljH2/37/ZptlTxg/NpCpHbD6affn+noYfBj6Y90pJ+tmXd1/o
8f26pMuq1Z83K0m+O2TwMpfv32tz/dibzSZK6hl0ZZbLXRntfNbO3O69mu43
+tTnVFAGSWwq5V6oKqPdpV172Eao6cm1KIXRvAxSWG9+OcxXSodeHvObcFlN
U9uV37zUMIP8zhxQx/aTUgX7ou+cdqmpSE/7o1aP0qnlgOdN3yUn0YW3LY11
7dWkp5O1oenSdKKd7d6PX51E3s61Z1gOVZPjrB6BVxumU6nKNUwjjZOo8Z4W
46a3UVP3A3NMN8Wl0WBjp4C6gRLqkdXa4EIVNTl9evOmx440ClPMH19mioTC
y+8bOS1XRXP6qfev75dG0hUx94aUkVBZkc4kgy+OXXfc1ApWUWnLhGoVHyto
bMNXxSpGJVCZ7aNUky6oaOE264qrdijI/sr2Hff6JVDXbXu+6B9U0ZKSaf43
JyjI9FiUq+JpPJnss/lotVlFPocdzvdtpaAll7dVODUhnkxTN61ss1xFV5Mf
f/irnIKGPHm3uKpWPBlUHlLyzTwVbR15a6BSlUp+zjZNDa/EUZWud4ed0OCj
Qo/YnWciU2n01q0Su+Vx5NO5knr6RM31m7V2lglOpdMX4qdcGBZHu/oe8rcY
p6I+CSvLtbiVSp9mePdrZ8FfvyC6zxnch3uu8J7b8J4BeM/6+C4/fNdQfJdg
hwuwgwPs0A12c4DdGsJugp3tYGcH2HkZ/KIDv0yAXzjdi4DfbeF3GfxuCZys
AU7CgZMmwJUlcDUMuBJwuBw4LA0c+gK3lYFbC+C2InCuBZy3Bs49wYvp4MU1
8GIPePQMPMoAj3aBd8HgnRy8E3g6BzztC54K16XgtULEa2PoQDWRDphBN2qI
dCMAOtNZpDN5XS9xurQ3cn7CHaWSOu+q1E3d8fv1nKCkcm9Wa3S4X8n9J+2+
v//SSYsGztVX0m2DT2+sjsuo6OCGo3tnqSkmK9I48HwGucut5Eu1ZHQ7wTsq
5YmarocajOk3IoNeVz126PEuKZ17q32k60k16ehohTf+kk4z7gdP6G0qJbPc
VRVd16kp1M3M5vXRdJLeKFvs2NUk6vxob5VKkzXrqIO2Oe2tNL9TlL3bq08S
var4ylOH1ORr/fjZ0Tdp5HF10KiS8RJqrUyO9DdU08iFzaNjPNJIu+H5NccX
/p/6kwQczty5ecjgWBWN3tVfd2SugtY0btb+8cBEUq5df+TedRWZzu8+POec
gvyeJ72dvCOB2pwoG6vlqaIYywqTKs5QkOXx1ZcqSuKpdXx4/37rVBRtVdKp
p4mCyr9tunxOh3iq1Hpwjfg5mvWM6c2irVJTyT7ObPGbw3HklKxHr4eraG9S
zdgZPql0aYx3rYo14ij2Weszgd1V5Hj6zWwbp1SqOq/XPZ2jsdRjwzkH+1Yq
Wp1jMvvsiFQq6+Q5uATFkmGHJkbtTVVk2GaC9r62qZRYNPFSrjKG+usGPW1m
qLl/rxe0yiiVKgQuDb52LoY2lGqjtq2soibtF+08VDaVnEJ6f5GujaE5i6qd
0dFT0fQ+PhkmxVOpRNTBu7Hz+OvcfcTP1cNzufe0xHc547vK47sEOyyDHQxh
h9Ww2z7YzQ92E+xcEnZeAju3gV9i4Rd9+EXwYxz82Bd+zITf68Pv1+F3G+Bk
HHCyETjh9K0NcDgaOCwNHL4Gbi8Bt57AbRfgfCFwHgictwAvnoMXcvDiPHhU
FjyaBR7dAe9ugndvwTst8DQOPPUATwVeLwOvH4DXwvVc6MBVkQ7sh250E+kG
p2N5jeO49RKnS3X80rYXL6+kru33bG/gLqOVi7Uvn1SqqdKTIs6+xzOoVqcH
fbu9l9LNEmW313igpla+ug2e9c6g1g5R9uHOUqrkaNqstJeatMNDzbzS0snW
8ZT3s7JSems5L/6Mo5quhWnPCNiYThW2LDwn351EJ/B7tBS/R9r4PWpu/8G+
cjM1WfWUaBbZafT+0uyri7y/x1+dsc5vgnV+eEqDd4tkKlLKI0wulE+jRm6f
b3dzTqTsjfvW7A1U0ZXl811KXlHQmRtrH8qPfF/nLMbvtQl+r4X1zBX87lvj
d38n1hu9sN54j/XGLVenXOeumr8v19J3kEMqlalhJM/5K5ZqgKc1wNM48LR3
Wr01R3RVVHb2wBJHclNo1PG1O2+PjqEW9VfWz/2QSWElmtT68iCFHgeeCDoX
E01zWmZfWqjIJLlXaNGG7inUNkw26ePcaHJ42tyvTUwmramn2OjqkEI1mr5d
dLFyNO02vJMx41kmWc2O0tk2LoW0Vro4Xw2LokdlpIdNgjPJOujYy2n9UuiC
NPHV+WNR1O3tqOEr72bShw2DKve0SKG7dXf1Lf8Xf124zyDcxxf3ET+3OJ4r
vOdavKch3lP4rhR8lzm+qyXs8AJ2eAI79IHdysFuY2E3QQ+NYGcJ7BwEv/jB
LxXgF2Hd2Bd+/Aw/cus9bl0n4OoqcOUDXEUAh2rg0Aw45OJTM+B8AHD+ETjn
1mnvwKOb4FEl8EgfvCsN3i0A7wLB09bgaVvwdBV4XRm8NgGvBR2oBx2whA78
SMe49Vhe80tcHCdeL3G6JOSRqiC+7oD4OrfJHLnUXU399Fc5dEtMp6hXCtfX
X/l47eoNB930vmqqvdJj0hC9dMqo2n1neNEkOthxuE5AbTUlmPceMeZ0Gk0b
XKZWfWcJDZZNd72Xo6J6cQtMc3qkkdXoY9SimITeI7/RFfmNZshvJCKvUgJ5
lZnIq5Sw9j7Y01lFstm7HwQYKsgoa+nzy/V5/anl6NWvaAfN+mrYWsdyM1Op
8dvLXl4zYun2mKwBoVVV1GnjQ61KlVNJbh42MGrfd515Dn4Fg19fB+1yeRif
SeHzZeWcV6fQx91ui5IaR1NX6MB76MAt6MCzW9q+w89lUvy61R+lOilUwtLV
8GKJKFrRe27WhgOZVCF69R5JbDJ12HYszGh7JPU52/l+9y2ZpBuuc/bi5WQa
37JfkQUtIym2/qu1Z50yaen6x6Wv702mC66dzfenR9CzYQGOModMGudokWWx
LplCJYZNBgZE0JfmtZd8sNfow4HuqUuXJdPtsTPO6xzmr4vvE4b7CM91xHN9
8dy+eM/yeM9JeE/xd3XCd4XCDgmwQynYgdPPIoO/2TkCdv4CO3O6dwd+7Aw/
psGPteH3BvC7GfzOxcXawFUKcGUCXHH5PS4vNwQ4NwXOBwDnHuBFEngxE7zw
A49MwCMVeMTFm5/A0/7gaQx4yuXNfqRj3HqMiyvzmvcW55e4OI5bL3G65Pxm
8tzwBWoyLKkIOWSXThPHWmkvd0yi6jL/MWY91eQ2JqjOGu100up6y7l5toTs
RiZubFtdTe+K1NyzY28aPWpc1DJuloSOz/fLaq7SrHNudK7i3CiN2q5f8vL2
3UQKRj72EfKxpZGPXTZiWVALNxVt+mLipT1IQTsG7Tk/42Q86SEuKIG4YAHi
ghjEF0sRXxggvrBC/LIH8UtZxC8ztkbNW/Uuk0aU0A3vHZhCy9pH1TC4F039
YqZmFn+RSTvvKbftmZ5CHsuPbjFOi6I56X3jyvtq1j+ZjeUt9FPIXdL2erBh
FK2rvjlBuTOT6k5/YhMTnEzFuzR+pJ4U+Tffx4LvIeD7uAkltdpMyqSuemtu
6/ZNpjjFxOhl9SOoXbHYjTX6Z5Kksb7BsyrJFCDpnxV/Kpxe6L/4EtxJsz4Z
4RRQRC2n1P5Xck5ZhtME2YTh080yqfvYiZV1QuXks3qwXJLzkuamn5HpNdD8
fabn4vbX5OQl+ZTW7d5L2lTx+gtZ3UzyeXY/5I6PnG7OeTNk0Gn+unCfVNzn
MO4jPLcHnuuL5wrvmYr3TMN7Ct+VhO+6hu8aDztYwA4S2CEUdhsPu72A3Vxg
53qwcynYeS78kgK/eMIvVvDjbvjxKPw4E34fDb87w+9cnMvFrVx8uhy43QLc
7gVuuX2HE+CFA3jRCbywB48+gkch4FEN8G4/eFcCvFsDnhqDp5PBU0HHBoh0
TFiPtYEOtIMO/CiunAudsRLlx/7T/Tgu783ll7g4jlsvcbrE5bGbBbq6RCpU
9HB1TLl6RmnU3+uSt8eRRDJYGT4qy19FuhO0jWUnFFTHPqdJmFMC1UXe9Rzy
rvORd+XWRdMTqsU1NFNRxMALsoUDU+lU87m1DzaKpbYbbLeMLa6icTlr3V8l
aeKXVZJ9OjViaAnilNWIUwyEOEWkP/uBc2E9Uw7rhLFYJ3iUaGxd3yaTZC3i
1inHafgy/OimWyMjyO5Gc+OyfTJp8efUDd7lkunBwzfrL2wPp/n9Nk/p0iST
5kus2h6/J6dBc5vYGCa+pGrz2l0pVimT9rTPXbtT8/s0s+8rdx+LlyS9PPn9
vs9K2jortX6ZQXJa1trtUeaNF7S1iGp4W6WS2h67Y7Cjnpye2rheMhr8QoPL
rUuKJyrpcJtBM3cXl1OtJu2SBxR5Qbm7nfzqRSjpUXXfTTNVMqoUfqWH9cMw
elyv0kmf50oa5FxL3l0mo9VG8RfOnuWvC/d5jPvo4z7Cc4/guXXwXOE92+E9
n+E9Zfiubfiulfiu6rDDXthhDuywAHZbCLsNh93sYWcH2PkJ7HwIfkmGX3Th
F269x+kbF8+2A64mAFd+wNUM4DAKOPQBDrk4VNhf8AXOHYHzKuBFRfCiEXjR
HDx6Ah4NBY+4fQFOx7j1GBdXCvmxQOjGO+jGj/L8/2mdALcfx+W9ufwSF8dx
6yVOlxZhX/sT9rXDsa8t5KujkBfVRV70xsjJb+8NUWnWByl1lnqnauKsSa+m
lowjQzfblrI6KjpotK6jRbNU0o+TzO4fFUNrfK1vFsnOJKPJHaptuZJCDf1H
a80+/z3+eoc44ibiiHETUlyuu2nWMzt8tk0KS6YTlz/Guy6NpEjzK1NrzM2k
Vy3M/UNmaNY/923md18QQZH75nX40COTFhxdP3BpMU085e90cJ5DOE13PGt2
oaYmHhlWp53lcTktcW21q+/27zqzBXxcCj6K9aQmeD20pM5HEzclbepl9qaZ
5vep+ZWRngtCwki7fFKL0FJKym2svtBwh4wsOx0u/XDRC7qVbrWpw+4MujN4
4v1NNjKq//Sz6bnPL0hrSnNdl84Z9EyiV8uvr4wSylm8ezz1JR248eovV60M
Wr077eLXNjJSjtx1yujUS7Lpt7FYljydHDsmtN7TWEZ1HJzfvX7CXz+I+zjj
Pum4T0k8NxTPjcZz7+A97+I96+I9S+O7PuG7uuG7RsAOm2GHxrBDTZEe1oXd
BN37C3ZeBTvPgF8i4Zdl8EsU/GgPP0bAj1Hwezb8Hg6/jwdOLICTs8AJF5+u
BQ5rAYfNgUMj4NYTuK0O3AYC5xeB81DgnNsvENeHxIJHnI5x6zF/8LoeeJ0F
Xgv5sUDogD50gMvzc/uVnC5x9UtcnQC3H8flvbn8EhfHceslTpdypGfe7rHW
xPWxnkfWeKaSe3Lz7BPZfLw2G3laGfK0LZCn1dGTxty7nEnq0GMSB6MUKnVk
6cVHraIo/HD77VvXZlJ6gFODOYeTaeTNx+meWpHkaR9U3GxYJs3sNbSPVpNk
SjokXfMuLlyzvvoW78gR77gj3hHrjwN48RHrjYdYb5THesOg/fkWDvWU5FRv
RWRHdxktrFzufZWhL8jLLL1R7OgMcmncw7DkMBnJ99uOGahZPxzdPk4++WQ6
DZ/2YaW3gYw+uHtmvdMLJwvf08dua/C06oEsxy9JSr36jXutezecGqm0ts/X
4C/IvZL29StSumFi65Q4JIJmbF+891DHNNrcMnyd0R4puV+p5v/1VgQlfg5f
1uGzgiIWVslp7iSlLw33uY/RiSRFroUyMV5B7ta6dRovkpLeDTM38+b89STc
JxL3+YT7zMRzt+C5+/HcJnjP23jPa3hPS3yXE76rO77rFOwwEnZ4DTucgN02
wG7xsFsN2NkZdp4DO3PrQG5dJ8S5Cvj9KPx+GDiZDZykAScRwJUKuJoIXJUB
Dl8Dh+WBQ25/gYs3P4AXPcGLw+AFp2PceoyLK4X8mBS8tgGvT0IHVkAHykAH
hP3KMOhGMnRDXHdxHTqT17pKrn6JqxPg9uO4vDeXX+LiOG69xOlSUe0JWgp5
JkW1HN99wM4UshnpFFt8ZPTfeelY5GOLIB8bgvzGGOQ3HiO/IV4XheD3VIi/
diHumIa442pDz6a2MiXVKrv6/MHycvLUSqp+usYLWll70aOSFkpKfLrPxvK4
jGKizHevafmCimJdEYJ1hQTrihWrzSUDB6bTu4odfIq8l9Lz4fXi4peH04pB
Fh77l6bRiefqR8mnpZRz/JZrLYcI2lP90Y5ZNxVUwiE5yXCWlHx0blZoMzSS
OlVuEbuppoI21L07oFdLjV4FpG7/qhtFeke7GLh4pFLPsbdvqYtr4vnysUY+
x6MoqG9wcc9OqTSchnxdL02iuHelKjyqFk1HNwzpFvoxhdz3S3RnPE6i4WWu
9ms0I5r0DmxpejM6hRJzZ9x+EJhEvXoHlCi7jb9+XHSfobjPbTx3BJ4bg+dW
xnv2wnuWx3t2w3dtwndZ4Lv2ww7asMNp2GE17HYSdnsNu62Gnd/Dzo9hZ269
txZ+lMKPL+BHP/i9LvzuDb9z8Sm3TuPybMI+QiJwWxq41QLO44DzBcA5p2PC
euwSeBQGHnFxpZAfCwFP9cDToeB1A/DaGrwW9isHQgdyoQNC3YUddOMWdENc
P9YGOpPXem8u78TVL3F1Atx+HJf35vJLXBzHrZc4XfqMfatQ7FsFYN8qDHld
OfK6MuR1g2rX82qjnUkdHPpbu07XxAXFLzpZZb+gR8jPWCM/sxz5GVvzue97
+GaQgan5mkA7GT3bvWDMxtgXtGVcT9PFmzXx/KNkc5OyMlrjEfS8XttwWibS
n4/g0cr960ybr1JQbWWRYvIhUvIPtVdu8YikCiKdqQz+loc+JEAf+kIfQq4O
qBjQMoX87iw/XnldEh16kNncZnAM9Tx6eF/V08lUpEFAu9nDkqhYw9yExFcx
9HDLK+NmPZJpg+Mwva4tkqij23hl4qxYWmjWXfnli5yGbxrvo66aRKdnl7Ju
dz2Wijzo+b5DnJy6BO9WXC2bRA3bpjWokhxLWrhOuF4f17n7PMFzN+K55nhu
b7xnUbzn1wbf3jMU3+WP7zqA79KHHSSwgyXswOneOti5Lux8AXZeA7+cgl+y
4Jcd8KMd/LgcflwMv1eD3+/D70IebzBwsgY4uQNcdQGu1gJX4v2FdODwq2i/
9Q5wy+kYtx4Tx5WG4NFuUX7sC3gn5Pm3gafu4OkH0X6lOXj9HjrQFTpgBh0Q
6scuQzcOQzcuQmcMRHmwvJ5D4eq92bpKpn6JqxPg9uO4vDeXX+LiOG69xOlS
ml7zw2lFM8lwSMrgsDFy8oqtu9476gUdm/T43pCLSrpbftBqgxAZBb3X1h2o
wdshUVyWgviiK+KUlYhTeiNOkYviIwPER43tPrtl3Uylfae7NBxaQUrWVRNm
7HSKIqeUUVF/+aXQxR0R640vJdG8C21ydC9H0+BV1aY3eZpMbjflBtMmafiu
pa7z7GEMzYcODIMOnIUOqMpF1ihqLaeRucPKzo+V0Llwh9dvNsaRRe+u7slB
MhoSdCdj5UkJjfUbqVW6RTy9PrtCu+JwGVWIK+u1b42EBtxb3Dn0fDwNH7K9
0q5yMrK1W1e81iwJdXp5/EvpEgmUeL1VrfppmnhvrVQyeJyEJkrD18Q3TyCJ
6Pp4XB8puk8H3OcNnlsRz7XCc3viPYfiPUcJ74nvGoXvOoXvshfp4UnYYSTs
th92Owq7rYWdL8HOs2DnVvCLO/zSC35Rwo8e8GM5+LGXKD7tBr9zceg54CoY
uLoCXKUDh7WAw9PAIadj4vVYOHAuxJXZ4EVF8ELIj9UGj1qCR0KePxq8uwje
6YOnpcBTR/BUqLsoBV7bgteR0IEs6EAr6IBQBzsWulEGusHFj3k9H8edQ+Hq
vbm6Sq5+iasT4PbjuLw3l1/i4jhuvcTp0tfJ/994TYq4YOi96fefhqfRLLs3
L62eSImk+2T+Zfh10S1RnJWAeMfpY/fSnyukUHWX/ZYdlibRtSM2ikqOMTRP
pD/nwDvjYQveNy8tp2JpN4O33NbwtMopv3bxcaTu30JL2kJGh+Ys6yZdLCGd
+M2vRsfEk75Vy1r1lkmp7C5Pn5NtJdSsX06N1hcSaHjIhraBKUn0vk27/c5a
mvXxkgjXsxMSqesJqxMmi5NoZ7Ez/omXE8mk/Z2VFeWJ5DSqapeFjZIoPUtt
dNopkR5Y2q3fYCyhhL6pTjOLJ5HyYu2LqmmJ5LdrWra8tYQkuJ6J61dxfbXo
Pvdxn2547i48tw6eOxrvmYP3fI33rILvKofvaoTveg07eMIO2rBDHditBOx2
FHZbAjuPhJ2Pw84u8Ish/HIJfrkPP46EHyPgR26dNg44mQuctAZOuHiT0zFh
PUbArQtwGy2KK6OAc3F+bDJ4IeT5P4JHweCRsF85Cby7Ad7FgafLwdOa4KlQ
P5YKXpuC12+gA37QgUtCHSx0Yx50Ixm60RQ60ws6MwI6k9dzu1xdAXcOhav3
5uI7Lu/E1Qlw+3Fc3pvLL3FxHLde4nTp+BK/5Jma7zzboPpQ/95Sshp2ea3i
TiR5IT9zAPmZ0cjP9EBc87X+t7imOOKveMpe2slOTj7duz9+niqhnV+TL22Y
GEdZonWONdYbtwLelu84XEoJGyN2+TSU0P6kagH74xKoC/i+A3w3Bd9vBb2b
lX1Vsx66PsmihVkidY5a1CRykoQinAzvrjKSkLLSX8+87iTQ9f6dVYevS8hs
1ejN+60TycHh1uNuCxLoYZCq6YaiSbT8wEvfUhcTqHvDSduS2ifQQZPrp6Oa
a66nXQqMmZJAHcycVeWMNe+RtcrduNf/5Tpzn7Z4riOeG4znxuA91XhPf7zn
fXxXV3xXe3yXBeywG3aoBTvchd0ksNsu2C0HdtaDnXvBzsnwy0X4ZRP80h9+
1EJ8+hHx6Sn43QN+Hwi/nwdOfICTbsAJp2MngcONwGEscCjElUOA27XArTg/
ZgucC3n+OeCFEryYAB51B498wKOl4N068K4WeDcAPN0PnhqAp0L82A+8LjLz
G6+Fen5H6EAT6IBwLmk8dGMLdEOoo1gLnYmAzuS1nwB3bpc7H8edQ+Hqvbm6
Sq5+iasT4PbjuLw3l1/i4jhuvcTpUvCKredTNyTTlHL6RjP6JNGzsVMi9KrH
0qXHO4+caCKnDo2b+hd7JqGcVda71l6MowTETRURN01G3PSkuu+Y4UGa9dbX
VQn+6Ym09X6Dbic38/rzYeI02RePRJLqbN4esiWBdK62XLUiXULzLDPr2egn
kHxZmw11tDT3nXdtnsP4JBpafejlDy/iyO/SPLd12+PJwe5j2onrmvWF6ZwT
LyWxVL1Km2F6neKpyt1ru2sWl9L84t1eTewcS16ltCWeGr/a2yovNGotpfaK
Z326ZMTQgEVq6zvJcaRcf7rcQCv+uj3ucxj3scN9zuC5RniuAZ47Hu95De+5
CO/pgO9KxXc9xHdpT/pmh1TYQRt24PQtDHa+CTtvgJ1T4Bd9+GUU/HITfuwM
Pyrhx1D4fTr8fh9+53TMBbgyAa58gKvewOFq4JCAw6XAbXXg9jZw6w+cmwDn
pwWcgxdp4MUJ8CIaPHoLHkWDR0L9mAK8OwbeCXWwY8FTF/BUqOdvBF63Bq+F
c0n+0IHR0AEVdKMhdOMWdCMSOjMfOpMCnclrnxOunwB3bpdbR3HnULh6b66u
kqtf4uoEuP04Lu/N5Ze4OI5bL3G69OK9W7kDd6UU0N3iqaO1hPY+6OYZPppf
F/n26FZ3QA8JhZidmadISKCWvU+khx2T0FKsW9pj3UJYt8xaO9mu5Zo4anVE
ZVxnUTzVzXVpOP2lZt0C3egP3ciEbux5eOCv7EPRVO62vtewBXH0ObnVwvNn
pbQwM2Tv9qNR9LHbaPPPVeOo1Nwvn3a8l5JuoKXZrtxImjImaP2++FiyD2/1
tEtDGdXZeK7OyeORtKj02gNBgbHUtH/tba0t+OsVcZ+puI8d7uOA537Cc0vi
ue54zwp4z1y8pwW+axC+K03QQ9ihLexQC3Zwht06wW6dYDc/2PkF7NwMdu4F
v+yFX2rAL3Hw4034cSv8yOnYQOCkGNZjOViPPQCuRgFXL4ErFXB4CDgsAxy6
AbeLgNslwO1G4FwGnD8FzuXghSt44QxeCPHjYvAoFjzqB95VBO9mgHf9wVM3
8NQbPL0LXncFr9XgtbDusoIOaGHd1Ra6kQjdsIZu6EJnPkJnVNCZvPZf4vqc
cP0EuHO73Pk47hwKV+/N1VVy9UtcnQC3H8fmvZn8EhfHceslTpe4uMz7oM/p
i3fj6dGTRr1qpsSTl3p225RFSeRkYXmis8auD6Y6xEyrGU+zKxklVzfk9YfT
Ga9ne861Oh5BWl7dnD2nxZL7hoG6e7ZqdKOU2dlGR8IpJ2qKh5uOZh2cbTLb
P1pGbkMuDir19iU5bbavPu1pDA3UcR6sKCunm/u7r1x/8CXd93l64KgmToh7
0dLN05S/fhD3ccZ9+uM+K/HcXDx3Gp57Du+pjffci/fUx3dNw3ctxHcdgh0q
wg4fYYetsNtj2G0m7OYHOz+Dnd1h53j45TX8chV+4XQsFX6vDL+PgN9TgJNL
wMkG4GQzcGUEXJ0DrtoChweBwx7AoYtovzITuC0LnIcB5y+A80/gRQh4YQhe
zASPYsAjZ/DIE7xLBe8qgXe24GkaeHoCPG0FXoeD12HgtXBOPAA6oA8daAvd
SIBuVIduLIfOlIPOzIDO5LUvHNd/ietzwvUT4M7tcufjuHMoXL03V1fJ1S9x
8R23H8flvbn8EhfHceslTpdsETd5Im5ahLipgc8l26M5UVTLI6P+xrZxFBG6
42FcgpSuVVDX/JCr0V3PPc3urYml+VG2hhPtZZRYx8Wri1U4pZ5tZ1NG4w+z
15feWGbLKL3xuf7HMl9Qb0eLyy/nx9CkPQ1rDRmtiZsbNspwl4VR7ptlFsMr
xdDBGXVLrvOWU2LvYYPvm4XRkJKL1i9/GU3OK/zllePlpDfdeKwi4jnZO6eN
S70UTc+PO5R0es9fT8Z9huE+TrjPcTz3M557AM/Nwnv2w3tOwHsm47vS8V3N
8F23YYemsIMt7GAOu5nCbmGw2wrY+RjsPB92vga/hMIvB+AXf/jxJfzYFH6M
gN9vw+/O8HsucKIPnPQAThyBq1HA1WHgaiNweAU4nAocbgZuTYHbU8DtRuD8
I3B+GzivC16sBS+mgBfiddda8GgReOcI3oWBd+vB0/rgqS54WhTnxKPB6+J7
vvHaCDpQCzqggA4I+4w60I0V0I2y0JnF0JmV0Jm89qvk+sJx/Ze4PidsPwHm
3C53Po47h8LVe3N1lVz9ElcnwO3HcXlvLr/ExXHceonTJW5dxK1nOP3xbXRR
u8mq51SnhtyoxK5okht10DpcOpmqrZ3qqDoSSmTj1828ejQdK7Lma85hOdUw
X791S4VQ2lNH0XxEcBTd7L372dtxcnr86rDZxy3P6OnLs/VbHoqizq/Mcnp1
5K9z9zHGcy3w3BN47hW8Zz28Zwre8wy+6yu+ax++6xHs8Ah2iIIdLsFupWG3
PbBbR9i5Puz8HHZ2hV+ewC8z4JcN8CPBjx3gx4fwuwX83g5+fwicJAEnfwEn
DYCrksCVO3A1Fjg8ABx6AIfVgds+wK0OcLsBOD8NnGcA52fBi03gRTh4IZxL
OgYeNQCPFoJ39uDdWPDuOXg6CTyNBU8twOtP4PUT8LovdKACdGAqdMAZuuEO
3QiEblhAZ5ZDZ1pAZ/LaR5frV8n1heP6L3F9Trh+Aty5Xe58HHcOhav35uoq
ufolrk6Ai++4vDeXX+LiOG69xOnSmh6eQSM2hdHkdcWevMuOpkjV0K63b8s1
8WWvcd0yQ6mBXpLLG4to8l1vsWmABo9B0JNH0JOO0JMdHtFzjj59SorHzU6p
60TRvQRLyy1hMtJZM/uF0vMJTdicPHTGs0gyLtNwmMkWGemam5mHln5Cm95t
PTD3WCRddn5lfmemjKri+lZcv4rr3H3c8dwMPDcYz+V07z6+qxm+6yq+ayPs
MBV2iIAdOB0Lhp2bw85zYGdv+EUffsmBXxzhx/bwY034sTzy/OnwezH4vTdw
sg84qQacfASujgBXn+K+4Wq5aN3lCRxWB26lwG1n4PYwcF4aOD8MnPuAF6PB
iwzwYgJ4tA08qgMe1QDvDoB39uDdBPDUEjxVgKfPwWspeF0RvBbixEjoQAR0
IB66sQq6UQ+6UQ86cwk64wSdyWt/b66PLtevkusLx/Vf4vqccP0EuHO73Pk4
7hwKV+/N1VVy9UvcOorbj+Py3lx+iYvjuPUSp0uZXXv6jc0JIde4Ejlpi6JI
p/L2VcurylndmOr9vkulmEcUO/beQt1BkWRweFm747Vl1Frv+cQB3g8p/WhA
ovGnCGphPXFF+Rgp7fQsnXJC96EGx0295j+PoL+ytTsYXOGvd8F9MnGf1riP
LZ6bgOdWxXP18Z6T8Z618Z5Fu337rt34Ll18F6dj3HosA3ZWws5NYOfq8MtM
+GUB/GIFPw6DH1Phx3XwuxJ+vw+/PwJOugMnbYGTmsBVBeCqDnD1ATgcCxx6
AYdRwO114HYHcNsHON8KnLcHzgeAF2vAC3PwoiJ49BU8MgePhDhxO3jnAt6Z
g6dy8PQOeLoKvNYHry3Ba1voQBp0oCt0oCd0wwW6YQDdaACduQadGQ+dyevc
Aa6/N9eflutXyfWF4/ovcX1OuH4C3Lld7nwcdw6Fq/fm6iq5PDlXJ8Cto7j4
jssvcXEct17idMnO7VOxhd0e0cTpr+55m0bSl/BVxumfpRTqFlt3pX0wmWzv
nHFQ8161RvXq8GW7lGJbdC91qMsDqv9osfsm6whSZti5L+gjpSPHpj5VHL5P
ufpF7vWpF0HHm7k9/GTCX0/GfRrhPircJwbPrY/n1sFzV+A9J+M9i0Z8e09O
x8Jhh1DYoSvscAt2awS7ZcBu72Dn/rDzONiZix+5ddcs+D0Qfl8Iv0uAkzfA
yRXgZDJwlQtcpQNXVsDhcOBwMHA4GLgtDty+wT6jMXDeFzgvDpy3Ay/ugxfn
wIsn4NED8KgqeLQNvOsI3kWBd+HgaQZ4+gY8FfYTK4HXc8BrR+jABuiAKXSA
y2tVgc5sh87cgc7kdR4K1/+f6+/N9dHl+lVyfeG4/ktcnxOunwB3bpc7H8ed
Q+Hqvbm6Sq5+iasT4PbjuHUUl1/i4jhuvcTpEqczLQeVe6C0uUcuK3ZUHRUS
TtcrjnS7HJtEqzbGVTn+5C6V6zm6+MnDmt+bkse0ZFf4651wn424TyDuwz2X
0zEHfFcSvqsGvus47KCCHR7BDnVhN0vY7RTsdhF21nr7zc5usPNm+OUr/DIZ
ftkAP2pZfPOjFvzoB7/Xht/14PeewIkTcHIHOOkLXO0HrqoCV1+Aw8rAYVfg
MAK43QLcNgFuQ4DzMcD5U+DcDrxwBS+2ghflwaMX4NEz8KgWeHcCvGsK3k0C
T3uDpzfA03jweiV4fQO8doMODIIO6EIHBkI33KEbNaAbVaEz+tCZKdCZvM5p
4uahcPMCuP7eXB9drl8l1xeO67/E9Tnh+glw522583HcORSuTpurq+TiPq5O
gNuP4/LV3DqKi+O49RKnSysatC0V3ewu1Whs5/5icTjZ7E54n7U9iZ7M7Ftv
nesdavE451ZU33BqNaTu2MQ5/PX1uI8x7jMH9+F0jFuP9cZ3ZeG72uK7uHVX
PdjtAOx2B3Z7DTuPgp1XwM6n4BcX+KUP/FIbfpwFP86DH13gd2/43RZ+3wac
9AVO3ICTTcDVK+AqCLiaCBwuAA6bA4crgNvRwK0HcOsDnHsC572AcyV4EQNe
qMELb/DIBTyKB48+g3fPwLua4N088DQDPD0Lngp5+MngdQJ4/QQ6MAw6cAM6
sAm60QK6sQW64QudqQyduQqdyev8OK7vNDf3hOs/xvXx5vrlcn0puf5vXJ8l
rp8J10+AO7fLnY/jzptwdd1c/SSXP+fqAbj8M5f35vJI3HqGWxdx+rN5Tmru
yVe3qea6jEF+xuHUO8lR/5zGDrtxvQ6u98V17j4b8dwKeK4rnnsW7/kF7+mN
9zyI78rAd23Hd9WBHVxhB3/YIRF2ewG7WcBu9WDnZbDzE9g5FH55Ar9Ewi8t
4Mdl8GND+HEg/D4cfk+B33cAJxbASTvgJA24ygauLgBXSuDQADgcDByWBW4t
gNvqwK0xcC4Hzs2B83fgxWHwQgu8WAQerQKPKoFHT8G74eDdVvBuC3h6GTx9
BJ4WMfvG6yjwOgS87g4d+AwdeAYdsIVuzIZu6EE39kBnBkBntFFfmte5ln+q
XnF9Trh+Aty53fymV9x+3K/WK06X/lS9ag0/LocfG/yXepUOXL0Brnx+oFe6
wG134LbqP1SvuHkc3FzLH8WD4jlN3DwUbu4A19eR66PL9avk+sJx8SDX54Tr
J8DFg9z5OO4cClfvzdVV5jUe5PbjuDiLi8u4OO5nxYM98dwteG4QnpuF92yK
93z1g3jQGHaYCjvU/S/jQR/4ZQP80usnx4NbgKvXwNUt4GoycLgQOGwKHK4S
xYPuwK0vcO4FnFsC55ngRSx4kfk/jAeV4Om5/+V48D+dA/6f5tv1mHx7cVG+
XTyniZuHws0d4PpvcH10uX6VXF84rv8S1+eE6yfAndvlzsdx51C4em+urpKr
X+LqBLg8Nrfu4nSMWxdx1zld4tZRcrxnQ7xnPbynM75Lju8ywnf5wA5ZsMMT
2KEB7NYbdjvzg3z7dvilaPQ3v0yEXzbDj8WQby8KP96G303g9/Lwex/gZDVw
chs4sQKu3IErA+BK69w3HBoAh52Aw0jgditw2wi4fQacjwXOHwPni0T59s3g
hR549BI8eiLKt3uDd81E+fY+4OlNUb59FXgdyOTbK4jy7QehG4bQjWrQmcrQ
mek/yLf/qJ5BPAf8R/UM4jkg3DwRbk4TNw+FmzvA9ffm+kly/Sq5vnBc/yWu
zwnXT4A7t8udj+POoXD13lycyOWfuToBTse49RinM9x1br3E6dIGvOc0vGcx
vCe3jkqDHSJghx5CfSns1hR2y4TdPsHOA2HnMbBzAPxSBn7ZBb+cgx8N4Md3
8KMt/H4Lfl8AvycDJ++Bk4vAyVTg6hNwlQJcWQOHI4FDK+BwGHBbArjNAm5r
Aef9gHMt4NxcVM9wFrwIAY+CwSMD8OgvUT1DjKieQQmevgVPrcBrffDalqln
qA8dMIZu1IFuKP/LegZufhk3r5abA871X+XmWnLz47h+/tw8FG7uANffm+uj
y/Wr5PrCcf1JuD4nXD8B7twudz6Oq3vk6iS5ukpOx7g6AS7+4vJI3HXuPtx6
idMlA3zXAXxXJXzXY9jBDHbwhx24dVQO7JwFOzeAnevDL3Pgl7nwyzD4cST8
KIcft8Hvavj9Dvz+HDjpDZy0Ak7qAFcVgStj4OoTcDgOOPQADuOA2xvA7Tbg
dgBwvg04bwWcDwYv1oIXrcGLyuBR0SbfeNQSPEoG73aCd5vAu/bgaQp4Giyq
F60MXvcW1YumQwe6i+pF10M3qovqRa9DZyaK6kXFusTNjRXO41xAnbyD6DyO
eM4jNw+Xm7fLzbXk+vNzc5q4eSjc3AGuvzfXR5frV8n1heP6L3F9Trh+Aty5
Xe5cCXcOhdMxrq6Sq1/i9I3Lb3PXOf3h4jhuvcTpkjvsMAt2CIUdImG3ENgt
HHZ7CTu3hp1tYGdf+KUK/PIWfnGBHzvDjzXgx6rwuwp+LwK/DxDFffrAyWfg
6ihw9QHncbg8FZdXPwac6wDnHsD5ZfBiLHiRDF5MBo/+Ao+MwSND8M4dvFsC
3k0ET3uCpxngaRh4LQev9ZnzOJE/OI9jCp25Ap1ZKzqPI9Yl4Vzhe5wrVOBc
odAn0AHnEBviHOJqnFvch3OLfji32AfnHMvhnONYnHPk9g25OSDcXEtufhzX
H5ubh8LFiVx/b66PLtevklt3cf2XuD4nXD8Bru6a0zFuPcbVe3N1lVy+mtt3
Y/fjmPtw+SUujuPWS5wucfFdD9i5EewcAjt7wi9h8Mtk+GU3/NgdfmwLP3Lr
qGfAiQw42QCcNAWuSgFXbsDVZODwIHDoBhxycd824PwscC4Hzn3Biy3gRSh4
wdWF2oF3i8G7SeBdGHg6BTyVgKfcPmA/6EBF6MAM6MAa6MZB6MZt0XnnFdCZ
1qLzzmJdEvo2BKNvQ1VRPxk79HlwEPWTEc/LFvJaRohPJYhPi6DvRAT6TnxB
PxluDjg3b5eba8nNj+PmNHF9trm5A1x/b66PLtevkusLx/Vf4vqccP0EuHO7
3Pk47hwKpwPcPhpXD8Bd5+7DPZfLL3FxHLde4nRpE+x8EnaeCzs/gl8i4Bc3
+CUIfoyBHxvAj3Hw+3343RF+5/Ln3DrqL+DQDzgcBxy6Arf1gdtjwO024PwT
cH4dOG8IXriAF2PBCy7uE/rJLAfvIkX9ZBqCp5XAUy3wOha8Lo1+MlyeqjJ0
owx0wwm6UQ46swQ64yzqJyPWJaEvFqEvVjP0xVqGPlo66KM1AX20uHmLQp8u
P/TpqoA+XVycyM3v5uaAc/N2ufoHbj+Rm9PEzUPh5g5w/b25PrpcnzeuLxzX
f4nrc8Kda+PO7XLrNO4cClfvzdUpcde5OgFuP45bF3H5JS6O49ZLnC5xefKB
8KMH/KgHP2bC71Xgd2v4PQs4uQqcLAdOdgBXtYCrE8BVJ+DwEHDYCTjk1lHc
fh9XnyD064sDj1zAIy/wLh28qybq15cBnp4W9esTx323oQM3oAPVRf36EqEb
RqJ+fbrQmZmifn1iXRL3HbVD31FuPSb0Q45DX9O+6Gu6SzS/7DPqS++gb2pn
9E1NQ99UK/RZ3Y0+q0fRZ5XbT+TmS3L5eW6uJTc/jpvTxM1D4eYOcH1xuT66
nI5xfeG4/ktcnxOunwCnb9z5OK7uiKv35uoquftwdQLcfhyX9+byS1wcx62X
OF2Sw4+34Me18OM9+L0r/C6H37l9Pa4OgavzdAduFwO3C4Dbv4DzFOD8PnDO
raNiwCMH8ChJ1A9ZfH55AHi6Dzw9K+qHbAFevwGvufrPdtANCXRjiKgfci50
5jXTD1nQJWv0dfdAX/c76OsuzN+xRR94GfrAZ6JvfH30jb+OvvHcfqLQl74B
+tKboS+90Md+NPrYO6OPPbfuikKf/Gz0yQ//u0/+//8ccG7eLjfXkpsfx8WP
3BwBbu4Ap2NcH12uXyXXF47rv8T1OeH6CXDndrl6SK6um7vO3YerX+LqBLj9
OC7vzeWXuDiOWy9xuhQFv8+E36/D71w95zZRv9DjwJW1aF+vLXC4Grg1Am79
gdsA4LwBcH4ROOfqPGPAoxzwSAIecesoG/B0PHi6BTytA143Ba87gNfcfp8w
b6IxdOOuaN7EAuiMAjrD6dIszM2RYG5Ob8zNEebsrMGcnXBhzg7m8ozDXJ6N
mMvD5ee5cz1c3SlXxzUec4gsMIfoLOYQCXOLZmNuURrmFnH7jNy8XS5vz81d
4uY0cTrGzR3g+ntzfXS5fpVcXziu/xLX54TrJ8DVaXPnTbjr3H24ukouLuP0
h9uP4/LeXH6Ji+O49RKnS37AyUXgpC1wMg24mg9cNQauuDw5d16G29c7Al7M
Ay9egxcTwaOe4NEV8IjrA8P1VeDWUVy/0FnQjYnQDVfoRk/ojAt0Jho6w+mS
MJdwHuYS3sdcwiaYY2iJOYbDMMeQW3cJ81KvYk6iD+YkCnMVUzBX0QRzFbm6
CGFu4wTMbfTD3EZun1E8F3Ii5kJy8SM3B5ybU8nlwTgd4+Y0cfNQuLkDXH9v
ro8u16+S6wvH9V/i+pxw/QS4c7vc+TjuHApX783VVXL1S1ydALcfx+W9ufwS
F8dx6yVOl7i+Ln7A4WPg8DRweBe47QbcbgFuhfhuCXCeAJxHghevwItZ4IWF
aF8vBDwyB++mgnd3wDuuDqEkeJ0GXjcBr99CB65BBwKgA+K5Xamieam9oTOj
RPNSxbr0CHOfB2Lu8w3RPPrlmBNdGnOihbnSozFXujTmSkdgDrUac6jNMIea
OwfE7TMKc7GjMBfbB3OxhTnatTBHuznmaAtzt19j7nZ5zN3m6iW4ud7cHHBO
x7i5ltz8OG5OEzcPhZs7wPX35vrocv0qub5wXP8lrs8Jdz6Xu86dj+PWOVy9
N1dXyekPVyfA7cdxeW8uv8TFcdx6idMlJXBoAhxeAg65vnncOb6y4MVb8KIK
eLEOPDIBj8zBo5ngXRx45w/eVRbNiVgJnkrB6zLg9WLwOgo68Bo60B460Ba6
MR66UU40j34ldKYsdIbTpUg76bQ2J9S04J7p9fIf0knRasGw1zWl5Pu2pbGu
vZoq62RtaLo0nSx2tns/frXmd7HiK08dUtMl68fPjr5JI8+rg0aVjJew+Xyu
7mv5iGVBLdxUtOWLiZf2IAXtHbTn/IyTfN7eyM22payOijyN1nW0aJZK1eMk
s/tHxbB19UKdaiLq2Uqjnu2rqF/EHZwr53SMmwPOzdvl5lpy8+O4OU3cPBRu
7gDX35vro8v1q+T6wnH9l7g+J1w/AU5PuPNxXPzF1XtzdZVc/RJbJ8Dsx3F5
by6/xMVx3HqJ0yWhH0IEcPsYuOX6qHN9iWuCR0fAo7rgkRDf9QfvSiC+WwGe
uoKnh8HTj+B1L/C6C3idAx2wgA60gg5kQzeuQjeOQTcuQmeqQGcsoTOcLg2o
UjKi4T01VR/v/PJ19wzqEixdEbJcs862L/rOaZeatHraH7V6lE6tBzxv+i45
ibo82lul0mQ1LTxom9PeKp0CKXu3V58kMrP/YF+5mZoG9JRoxDGNPl6afXWR
t4SGyKa73stRkWncAtOcHmk0YPQxalFMwtbbC3X1vqh3dUS9a+DIyW/vDVHR
xdUpdZZ6p1Jo4KRXU0vyeTAt7QlaCnkmxbUc333AzhRaMNIptvhIXsfE67Fw
/E5Fi+LKKKy3uTng3Lxdbq4lNz+Om9PEzUPh5g5w/b25Prpcv0quLxynD9x1
Ls/DxVmcznDnULh6b05/uPolrk6A24/j8t5cfomL47j1EqdLxYDzROB8KXDO
5Z1ugUdXwKMo8EioM78M3jmDd4/A0+fgaVXwdBh43Qi8Hgxet4AODIIOfIYO
EHTDHrpxB7qhB50pAZ0xh85wutTxxdPk1TI1pbfKzg35K4NsvN2WJcZIyfPl
Mb8Jl9U0vV35zUsNM+jamQPq2H5SapG7qqLrOjU9dzOzeX00neQ3yhY7dpWP
Hz06DtcJqK2mJPPeI8acTqOZg8vUqu8soRPz/bKaq1TkcKNzFedGadRp/ZKX
t+8mUpWV4aOy/FVUcYK2seyEghrZ5zQJc+Lrvj5Iz7zdY62inrGeR9Z4ptLh
5ObZJ7JjWR3j1mNCXJmN9XNFrJ/F+bHJyAMIef45yGcqkc/k5oBz83a5uZbc
/DhuThM3D4WbO8D19+b66HL9Krn4iLvO9Tnh+glw53a583HcORQuLuPqKrn6
Ja5OgNuP4/LeXH6Ji+O49RKnS7ngRV/w4gx4wdVBVQPv9MG7FuCdN3i6DDzt
AZ4eAq/l4PUc8JqL71pCN8KhGwrohhd0xgY6Ewid4XSpyL//ZdEFj2i9tfEZ
tLn0yCMjSEZ7Srv2sI1Q07NrUQqjeRmUYb355TBfKZ1/q32k60k1ldXRCm/8
JZ1m3Q+e0NtUSu8s58WfcVTTzTDtGQEb06nSloXn5LuTyO+Gg256XzWZrPSY
NESDL1XV7jvDiyaR/cjEjW2rq+ljkZp7dmjwGNK4qGXcv/Iiga4ukQoVPVkd
U66eURoN9brk7XEk8f84rx2L89qcjgnrsUv4HQnD74g4rjTEeljIj9VGXN8S
cb2Q5/+I/GQw8pMTsM/SHfssPthnicZ+8VvsF0djv5ibA87N2+XmWnLz47g5
Tdw8FG7uAJcH5vomcf3fuOvcfbj1DNdPgDu3y52P486hcPrD1VVy9UtcnQC3
H8flvbn8EhfHceslTpeWgEdFdb7xSAYemYF3IeDdGPBuEXj6CTwNA08DwOsG
4HU2eP0eOnALOmAAHfCBbuhCN2yhG27QmefQGRV0htMl4XpGX6WPLilpadlr
mzu+k9GuZ+3M7d6rKbjRpz6ngjJIblMp90JVGd1J8I5KeaLRpVCDMf1GZNDb
qscOPd4lJX1H02alvdRUOjzUzCstnRY4nvJ+VpbPg9WQ+Y8x66mm/WOC6qzR
TqcSXW85N8+WsHUUnI5x6zEurtwtyo99QX5MyPNHI994EflGYb9yEvZNbmDf
ZCn2f9dh/7cW9n+F+jEF6liOoY5FqMeriHq8GajH4+aAc/N2ubmW3Pw4bk4T
Nw+F4zW33uDyM9x17j5c/yWuzwmnM1z8xZ2P486hcPXeXF0lV7/E1Qlw+3Fc
3pvLL3FxHLde4nRJXFcQBd4Zgqfu4Gkp8JTLO1WGDpSBDthBB+5CN25BN3Kg
G7uhM4+hMynQGU6XhOs5o0YNiT+kpAsben26eVr+9/U514+92WyipL5BV2a5
aH6vtAY3HN07S01xWZHGgeczyENuJV+qJaPAEmW313igpta+ug2e9c6gtg5R
9uHOUvrUZI5c6q6m/vqrHLolplPMK4Xr669JtObN5LnhC9RkXFIRcsgunSaP
tdJe7sjrGLce4+JKIT8WgrhbD3G3kOffhvyhO/KHwrzsUtgHccQ+SBz2c5dj
P7cm9nMHYB2+H+twA6zDhTrYsaivc0F9XX/UCbuhTtgbdcICztOA8xPAOTcH
nJu3y8215ObHcXldbh4KN3eA65fLXefiJq4vHNd/ietzwvYTYM7tcufjOP3h
6r25ukouXuPqBLj9OC7vzeWXuDiOWy9xurQWPK0Nnk4HTz+D19bgdQJ4fQs6
YA4d6AAdKAbdSIBuHIZuCDozDzpjDZ35kS6FZppcGPNVSSmd6ykfj0/++7q0
y6rVnzcrSbE7ZPAyl+9/v2zSooFz9ZX0wODTG6vjMlq1WPvySaVmHfWkiLPv
8Qwy6fSgb7f3fD5f0LEBIh3j1mP+WH/Ww/ozC+tPIT8mRRxtgzh6KPKBDZAP
tEY+8INov9Ic+xpC3UUp7M/aYn9WqB9LRZ2JKepMhHVaP/zeFcHvnVDP3wh1
v61R9yucX+iK8wtqnF8QzmGF4xxWGM5hFcV50micJy2O86TcHHAuH8vNteTW
CdycJi4PzPXx5q5z9+H6VXJ94bj+S1yfE66fAHdulzsfx51D4eq9ubpKrn6J
qxPg9uO4vDeXX+LiOG69xOnSQPDaELzuCl47QQeqQgfqQwcE3VgJ3XgK3RCu
J0NnMkU6w+lSXHK2nta4TPoyYKNsim7K39eNPwx8MO+VkqplX959ocf3v88N
Sir3ZrWSrvYruf+k3ff71/NL2168vJIs2+/Z3sCd1zFhPdYGOtwOOszFlUJ+
LBBxsT7iYiG/twL5vTLI7wn7lQOxT5GLfYr32G/tiv1WM+y3RqJuJAt1I61Q
N/IG9W9+qH+7hPo3oZ7fEXW8TVDHK5xL8sd5hNE4jyDomxVwqwXcCufEA3A+
VB/nQ7n5kn3Rr6MC+nVMRb8Obg44l6fl4hRufhzXl5vTAe46dx+ujy7Xr5Lr
C8fpDNfnhOsnwJ3b5fSHO4fC1XtzdZVc/RJXJ8Dtx3F5by6/xMVx3HrpR7rU
ADrQDzogXP8M3bgm0o1a0Bkjkc5wulRjq6/FcL9M2hmse8PL//t1s02zp4wf
mkk1jth8NPvy/T77I+cn3FEqqduuSt3UHX+sY+L1GBdXCvmxQMS57xDncnl+
Yb8yDPsOydh3EOou7LB/egv7p0L92GXUgRxGHYhQBzsW9WxlhDpY1OXOQ11u
MupyhXNJ43G+YAvOFwjnpBrinNQtnJNqi/OeiTjvaY3znkJeNAF50erIi+qL
4oIViAuc0UfIHX2EAtFHiIsvuDngnB5y8Qs3L4Cbe8Jd5+7D9ffm9ITrV8nZ
geu/xPU54fLV3Lld7nwcdw6Fq/fm6iq5+iWuToDbj+Py3lx+6UdxHLde4nTp
IHSjp0g3WkFnaol0htMl0w7KVsoKmngoc3RSwITUv68HBO3vO/RSJnVuLC1j
7PtjHePWY1xcORdxqxXiVi7Pz+1XiusurmM/VFw/1gZ1HcK610AUb3LrNOG8
QC+cFxiB8wLCvsBa5CcjkJ8U4zAFOBTOoX/EOXQVzqEL/TTKoZ/GDPTTKIu+
QIvRF2gl+gJxv9f1kHe9hLyrE/Kuwu/+Nfzuj8fvPtc3m5u3y80x4dYb3HXu
PtzcAe49ufUM16+S7QvH9F/i+pxw/QS4c7vc+TjuHAq3LuLiNa5+iasT4Pbj
fpT35vJLXBzHrZc4XboOnbEQ6QynS9P//U+F/6/4+7oJ/r6E6O+rQve2iXQv
Fuu3XNH6LQRxqEwUh75DPu2cKJ+Whn2BxaJ9gXPY31yP/c0OqNNIQ53GTNRp
9Ed8XRXxdUfE10Ld7HzUzaagbvYh6v/7o/7/Gur/hXNMtjjHdA/nmGxwHjMB
5zF74jzmQJwrd8e58iCcKxf3x1iI/hjCuYAuWOc3xTpf6Ff2AP3KKqNfmdDn
5x34kgK+COcILJDfaIX8hrDv8AT5WF3kY7l+/nmdA57XuZZ5ndOU17kDee2j
m9e+cHntc5LXc7t5PYeS17pKgUf/aZ2AcD2vee+8xnF51aXmK5Iyv5RXkd8j
7S+fx33/+666HXX0OmmuBzR74eXz/boZ/j7gf/j33fD310R/3wJ/f+M//Hvu
uT/r7xOKTNWJ7qgir9XLstv+v64n4vrh/+H1dyETi40YpPk9XzvMdE1Uwbte
Ud6wm4eekrw2NwtQHJbl+frIXJfL80aqqXVVizW1W6dT4zLXfW81Tvpp1z30
/vVAFU0Oa2R6drKCXkQPPtg0PL7w+v/S9V/t35+Fw1+N24Lul4Ji599l/3+/
tjyTXLdUemi+PYWsNVejB0f/sdfzGz5/F25/NQ7zm9/zG65+Fx5+l/78LDs3
+tflhpl0q+en2XcD5RQ6sVQ5l9CXv+16ftOlQp35M3D1p+L2T9W9fxreCgpO
/lS/r/v3/0gnncgj8zvryKhLveAhzp3CC6/j+p+K84KC2/yGh1+Nn0Kc/O/g
5EPkhlVbc5JpQed//Zck2pM+52TInpg/9nohbv87POc33P6peC7oeluoq/8d
Dmcn+rwrNzuJzvVKctQ/l0ivz1f8Wv1V4m+7XqirhfgsiLj91Tj/p+E/r3jO
b7gt6Hj7Xbj6Xfr2u/x+4+mFWMNr0bRc/1//JY6Odxhz6uIx6R97/Xfh9nfp
W0HRsYKO25+Fq4Kie79LD/9UnSwov6cFRa8KCk48jMhu89NQam1TeefwFtHk
N3RGv0VX5AXmekHBeX7Tw5/1O5tX3OY3fP4s/PwsPPyueKGgrK9+Fx7y2/rq
nxY//tN0o6DEd78aJwVdH/LbOiG/rQd+tX9/l54X9N/338XHfxq/Cu1faP9/
sv0Lf18Kf18K13uF8V1hfPdnx3cFRc8Liv7nNz0pzCf/M/PJhftlhftf+WGd
U1gPUFgPkJ/rAQrKeqmwfil//m7+qb+n+e16Qfl9LCjr+cJ68vypS4XnbgrP
3RSeuyk8L5nf8F+Iw8Lz4/nhPHjh+fHf2wc4v+E2v+GtUCf/mTjMb9cLcVLY
Py0/462g4LCwD+TvvV7Q8VDQ8fOn4upX47AQn//M/t6/Cyf5DT8FRccKyvWC
4vfCeSUFCye/K4771XjLb79fBV3PCzqv/2nXCwpPC/GTP68XlHxIXq//03Cb
39Ynv2vdm99wm9/snNfrBX099rPs8LvyCT9L3woKzvNbPvBn+bGg+CW/2fNP
tU9+29f7XfuGBcWP+c2ef+o++z+tLqiwzjB/1mXlNe74p/HoV9chF+rYn3E+
gnvPvPolv9n/V9vtZ+VJfhbOC88z/nfX87oe/tV5j8Lz0d+uc++ZV979an4V
FN7lNzwXFLvlt34mv7p/yK/WpfzWv+hn9U/41euBgqL/P6s/D/eehf0Afy8v
fvV66VfbOb/1O81vfaLym/7nN/0pKPpfiP9C+xfav9D+P8v+ebVzYf/wQvwX
RPzn1c7cd+W3vrh/ar+1P1V/Crr+FxRe/C79/1k6n9/yk39qP8mflSfnnltQ
7Pa7fi+4v8+r/ue3Pqj5re/lr14v5bf934LCu/y2Hivsc/h/t2dBr/8pKPb/
WTjPaz1bfvPLn2p/7u8Lev1qQfFXXnmR3+xfyKP/7txBfjtPUVDsXFDOp+Q3
f+U3P+bVv/ntPOPvsg93jvJn1RXkt+t5tX9+8wt3/WflLQu6nX+X/fPKo4Jy
Pb/ZOb+dry8ofvld69KfxaP89r2/C7eF1/Mnbv8fOXx1cA==
      "]], {
    DisplayFunction -> Identity, AspectRatio -> 1, AxesLabel -> {None, None}, 
     DisplayFunction :> Identity, Frame -> True, FrameLabel -> {{
        FormBox[
         StyleBox["\"y\"", 
          GrayLevel[0], 15, StripOnInput -> False], TraditionalForm], None}, {
       
        FormBox[
         StyleBox["\"x\"", 
          GrayLevel[0], 15, StripOnInput -> False], TraditionalForm], None}}, 
     FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
     FrameTicksStyle -> Directive["Label", 12], GridLinesStyle -> Directive[
       GrayLevel[0.5, 0.4]], 
     Method -> {
      "DefaultBoundaryStyle" -> Automatic, "DefaultPlotStyle" -> Automatic, 
       "ScalingFunctions" -> None}, PlotRange -> {{-1, 1}, {-1, 1}}, 
     PlotRangeClipping -> True, PlotRangePadding -> {{
        Scaled[0.02], 
        Scaled[0.02]}, {
        Scaled[0.02], 
        Scaled[0.02]}}, Ticks -> {Automatic, Automatic}}],FormBox[
    FormBox[
     TemplateBox[{
       FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           GraphicsBox[{{}, {}, 
             RasterBox[CompressedData["
1:eJxFlwd4FWUWhiluCEkAC22VHqqg7KqgoPiBFFHAAixNVBCwIGKQIiBFOoQA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              "], {{
                Rational[-15, 2], 
                Rational[-225, 2]}, {
                Rational[15, 2], 
                Rational[225, 2]}}], {Antialiasing -> False, 
              AbsoluteThickness[0.1], 
              Directive[
               Opacity[0.3], 
               GrayLevel[0]], 
              LineBox[
               NCache[{{
                  Rational[15, 2], 
                  Rational[-225, 2]}, {
                  Rational[-15, 2], 
                  Rational[-225, 2]}, {
                  Rational[-15, 2], 
                  Rational[225, 2]}, {
                  Rational[15, 2], 
                  Rational[225, 2]}, {
                  Rational[15, 2], 
                  Rational[-225, 2]}}, {{7.5, -112.5}, {-7.5, -112.5}, {-7.5, 
                112.5}, {7.5, 112.5}, {7.5, -112.5}}]]}, {
              CapForm[None], {}}, {Antialiasing -> False, 
              StyleBox[
               LineBox[{{7.5, -112.5}, {7.5, 112.5}}], 
               Directive[
                AbsoluteThickness[0.2], 
                Opacity[0.3], 
                GrayLevel[0]], StripOnInput -> False], 
              StyleBox[
               StyleBox[{{
                  StyleBox[
                   LineBox[{{{7.5, -60.67708333333333}, 
                    Offset[{4., 0}, {7.5, -60.67708333333333}]}, {{
                    7.5, -8.593749999999996}, 
                    Offset[{4., 0}, {7.5, -8.593749999999996}]}, {{7.5, 
                    43.489583333333336`}, 
                    Offset[{4., 0}, {7.5, 43.489583333333336`}]}, {{7.5, 
                    95.57291666666667}, 
                    Offset[{4., 0}, {7.5, 95.57291666666667}]}}], 
                   Directive[
                    AbsoluteThickness[0.2], 
                    GrayLevel[0.4]], StripOnInput -> False], 
                  StyleBox[
                   LineBox[{{{7.5, -99.73958333333333}, 
                    Offset[{2.5, 0.}, {7.5, -99.73958333333333}]}, {{
                    7.5, -86.71875}, 
                    Offset[{2.5, 0.}, {7.5, -86.71875}]}, {{
                    7.5, -73.69791666666667}, 
                    Offset[{2.5, 0.}, {7.5, -73.69791666666667}]}, {{
                    7.5, -47.65625}, 
                    Offset[{2.5, 0.}, {7.5, -47.65625}]}, {{
                    7.5, -34.635416666666664`}, 
                    Offset[{2.5, 0.}, {7.5, -34.635416666666664`}]}, {{
                    7.5, -21.614583333333332`}, 
                    Offset[{2.5, 0.}, {7.5, -21.614583333333332`}]}, {{7.5, 
                    4.427083333333321}, 
                    Offset[{2.5, 0.}, {7.5, 4.427083333333321}]}, {{7.5, 
                    17.44791666666667}, 
                    Offset[{2.5, 0.}, {7.5, 17.44791666666667}]}, {{7.5, 
                    30.468750000000004`}, 
                    Offset[{2.5, 0.}, {7.5, 30.468750000000004`}]}, {{7.5, 
                    56.51041666666667}, 
                    Offset[{2.5, 0.}, {7.5, 56.51041666666667}]}, {{7.5, 
                    69.53125}, 
                    Offset[{2.5, 0.}, {7.5, 69.53125}]}, {{7.5, 
                    82.55208333333334}, 
                    Offset[{2.5, 0.}, {7.5, 82.55208333333334}]}, {{7.5, 
                    108.59375}, 
                    Offset[{2.5, 0.}, {7.5, 108.59375}]}}], 
                   Directive[
                    AbsoluteThickness[0.2], 
                    GrayLevel[0.4], 
                    Opacity[0.3]], StripOnInput -> False]}, 
                 StyleBox[
                  StyleBox[{{
                    StyleBox[{
                    InsetBox[
                    FormBox[
                    TagBox[
                    InterpretationBox["\"-0.8\"", -0.8, AutoDelete -> True], 
                    NumberForm[#, {
                    DirectedInfinity[1], 1}]& ], TraditionalForm], 
                    Offset[{7., 0.}, {7.5, -60.67708333333333}], {-1, 0.}, 
                    Automatic, {1, 0}], 
                    InsetBox[
                    FormBox[
                    TagBox[
                    InterpretationBox["\"-0.6\"", -0.6, AutoDelete -> True], 
                    NumberForm[#, {
                    DirectedInfinity[1], 1}]& ], TraditionalForm], 
                    Offset[{7., 0.}, {7.5, -8.593749999999996}], {-1, 0.}, 
                    Automatic, {1, 0}], 
                    InsetBox[
                    FormBox[
                    TagBox[
                    InterpretationBox["\"-0.4\"", -0.4, AutoDelete -> True], 
                    NumberForm[#, {
                    DirectedInfinity[1], 1}]& ], TraditionalForm], 
                    Offset[{7., 0.}, {7.5, 43.489583333333336`}], {-1, 0.}, 
                    Automatic, {1, 0}], 
                    InsetBox[
                    FormBox[
                    TagBox[
                    InterpretationBox["\"-0.2\"", -0.2, AutoDelete -> True], 
                    NumberForm[#, {
                    DirectedInfinity[1], 1}]& ], TraditionalForm], 
                    Offset[{7., 0.}, {7.5, 95.57291666666667}], {-1, 0.}, 
                    Automatic, {1, 0}]}, 
                    Directive[
                    AbsoluteThickness[0.2], 
                    GrayLevel[0.4]], {
                    Directive[
                    Opacity[1]], 
                    Directive[
                    Opacity[1]]}, StripOnInput -> False], 
                    
                    StyleBox[{{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}}, 
                    Directive[
                    AbsoluteThickness[0.2], 
                    GrayLevel[0.4], 
                    Opacity[0.3]], {
                    Directive[
                    Opacity[1]], 
                    Directive[
                    Opacity[1]]}, StripOnInput -> False]}, {}}, {
                    Directive[
                    Opacity[1]], 
                    Directive[
                    Opacity[1]]}, StripOnInput -> False], "GraphicsLabel", 
                  StripOnInput -> False]}, "GraphicsTicks", StripOnInput -> 
                False], 
               Directive[
                AbsoluteThickness[0.2], 
                Opacity[0.3], 
                GrayLevel[0]], StripOnInput -> False]}}, PlotRangePadding -> 
            Scaled[0.02], PlotRange -> All, Frame -> True, 
            FrameTicks -> {{False, False}, {True, False}}, FrameStyle -> 
            Opacity[0], FrameTicksStyle -> Opacity[0], 
            ImageSize -> {Automatic, 225}, BaseStyle -> {}], Alignment -> 
           Left, AppearanceElements -> None, ImageMargins -> {{5, 5}, {5, 5}},
            ImageSizeAction -> "ResizeToFit"], LineIndent -> 0, StripOnInput -> 
          False], {FontFamily -> "Arial"}, Background -> Automatic, 
         StripOnInput -> False], TraditionalForm]}, "BarLegend", 
      DisplayFunction -> (#& ), 
      InterpretationFunction :> (RowBox[{"BarLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{
                 RowBox[{"Blend", "[", 
                   RowBox[{"\"M10DefaultDensityGradient\"", ",", "#1"}], 
                   "]"}], "&"}], ",", 
               RowBox[{"{", 
                 RowBox[{
                   RowBox[{"-", "0.9991673605810143`"}], ",", 
                   RowBox[{"-", "0.1353352832366127`"}]}], "}"}]}], "}"}], 
           ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"{", "}"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}], ",", 
           RowBox[{"Charting`TickAnnotations", "\[Rule]", "None"}], ",", 
           RowBox[{"Charting`TickSide", "\[Rule]", "Right"}], ",", 
           RowBox[{"ColorFunctionScaling", "\[Rule]", "True"}]}], "]"}]& )], 
     TraditionalForm], TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"], 
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& )]], "Output",
 CellChangeTimes->{{3.681130791699168*^9, 3.681130854024742*^9}, {
   3.681130971150887*^9, 3.6811310381408978`*^9}, {3.6811314449103813`*^9, 
   3.681131492658991*^9}, {3.6811652244416847`*^9, 3.681165256702689*^9}, 
   3.681165706695797*^9, 3.681230195285376*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Gradient of the potential, i.e., the force field :", "Subsubsection",
 CellChangeTimes->{{3.6811652860928907`*^9, 3.681165291205525*^9}, {
  3.6811653361350393`*^9, 3.6811653407487593`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"-", 
  RowBox[{"D", "[", 
   RowBox[{
    RowBox[{"-", 
     RowBox[{"Exp", "[", 
      RowBox[{"-", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["x", "2"], "+", 
         SuperscriptBox["y", "2"]}], ")"}]}], "]"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"x", ",", "y"}], "}"}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.6811309284489*^9, 3.681130934069583*^9}, {
  3.6811315558699703`*^9, 3.68113155824343*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "2"}], " ", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["x", "2"]}], "-", 
      SuperscriptBox["y", "2"]}]], " ", "x"}], ",", 
   RowBox[{
    RowBox[{"-", "2"}], " ", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["x", "2"]}], "-", 
      SuperscriptBox["y", "2"]}]], " ", "y"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.681130928817252*^9, 3.681130934376876*^9}, {
   3.6811315564413643`*^9, 3.681131558716343*^9}, 3.681230197399828*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Plotting the field lines :", "Subsubsection",
 CellChangeTimes->{{3.6811653445316763`*^9, 3.681165381379614*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StreamPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "2"}], " ", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["x", "2"]}], "-", 
        SuperscriptBox["y", "2"]}]], " ", "x"}], ",", 
     RowBox[{
      RowBox[{"-", "2"}], " ", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["x", "2"]}], "-", 
        SuperscriptBox["y", "2"]}]], " ", "y"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.681130930238344*^9, 3.681130948797868*^9}, 
   3.6811653866614017`*^9}],

Cell[BoxData[
 GraphicsBox[{{}, {
    {RGBColor[0.2947336, 0.4054232, 0.5678384000000001], 
     {Arrowheads[{{0.020000000000000004`, 1.}}], 
      ArrowBox[{{-0.9999999708675869, -1.}, {-0.9904442343474705, \
-0.990444263201502}, {-0.9609153095966091, -0.9609153375903916}, \
{-0.9451723486647164, -0.9451723761998685}, {-0.9287265002626874, \
-0.9287265273187322}, {-0.9078168705646098, -0.9078168970115066}, \
{-0.8857412835151846, -0.8857413093189661}, {-0.8819400075974252, \
-0.8819400332904664}}]}, 
     {Arrowheads[{{0.019999999999999997`, 1.}}], 
      ArrowBox[{{-0.8789885085156711, -0.8789885341227281}, \
{-0.8624249898470684, -0.86242501497159}, {-0.8377932402929178, \
-0.8377932646998572}, {-0.8118002842133074, -0.8118003078630092}, \
{-0.7843487278367421, -0.784348750686714}, {-0.7609285452455095, \
-0.7609285674131947}}]}, 
     {Arrowheads[{{0.019999999999999997`, 1.}}], 
      ArrowBox[{{-0.7579770461637554, -0.7579770682454564}, \
{-0.7554385711632221, -0.7554385931709712}, {-0.7250698141927474, \
-0.7250698353157813}, {-0.7057904106482582, -0.7057904312096366}, \
{-0.6859976523059952, -0.6859976722907627}, {-0.6656915391659584, \
-0.6656915585591597}, {-0.6448720712281477, -0.6448720900148277}, \
{-0.6399170828935937, -0.639917101535923}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{-0.6369655838118397, -0.6369656023681847}, \
{-0.6236209510391115, -0.6236209692066952}, {-0.6020198811453982, \
-0.6020198986836904}, {-0.5800688615470075, -0.5800688784458137}, \
{-0.5577678922439399, -0.5577679084930649}, {-0.5352678747099943, \
-0.5352678903036395}, {-0.5189056205416779, -0.5189056356586512}}]}, 
     {Arrowheads[{{0.019999999999999997`, 1.}}], 
      ArrowBox[{{-0.5159541214599238, -0.5159541364909129}, \
{-0.51271971041897, -0.5127197253557328}, {-0.49012339937086746`, \
-0.49012341364934525`}, {-0.4674789415656863, -0.4674789551844764}, \
{-0.4498426163190811, -0.4498426294240825}, {-0.43231355403191757`, \
-0.4323135666262551}, {-0.41024741666213027`, -0.4102474286136279}, \
{-0.3978941581897621, -0.3978941697813795}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{-0.3949426591080081, -0.39494267061364113`}, \
{-0.38856843140651515`, -0.3885684427264516}, {-0.3675239719446929, \
-0.3675239826515534}, {-0.34703158038345655`, -0.34703159049332427`}, \
{-0.32568159492058035`, -0.32568160440847144`}, {-0.3051577328819345, \
-0.30515774177191596`}, {-0.2854599942675191, -0.28546000258365795`}, \
{-0.2768826958378463, -0.27688270390410774`}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{-0.2739311967560923, -0.2739312047363694}, \
{-0.26658837907733407`, -0.2665883868436972}, {-0.24859386031669328`, \
-0.24859386755883267`}, {-0.2315274109909105, -0.231527417735863}, \
{-0.21538903109998575`, -0.21538903737478826`}, {-0.20017872064391903`, \
-0.2001787264756085}, {-0.17240910206760257`, -0.172409107090296}, \
{-0.15587123348593057`, -0.15587123802683595`}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{-0.15291973440417653`, -0.1529197388590976}, \
{-0.148085349293204, -0.14808535360728778`}, {-0.1304755965846523, \
-0.13047560038572148`}, {-0.1146867482177655, -0.1146867515588674}, \
{-0.1007188041925436, -0.10071880712672555`}, {-0.08857176450898661, \
-0.08857176708929598}, {-0.06840125243084033, -0.06840125442353398}, \
{-0.0528360662472996, -0.05283606778654179}, {-0.03485977113401481, \
-0.03485977214956412}}]}, 
     {Arrowheads[{{0.005187649130505704, 1.}}], 
      ArrowBox[{{-0.03190827205226077, -0.03190827298182578}, \
{-0.03166291552343063, -0.031662916445847816`}, {-0.018992413545213145`, \
-0.018992414098508006`}, {-0.011374492897805783`, -0.011374493229172222`}, \
{-0.006806550378993543, -0.006806550577284788}, {-0.0038760656874013435`, \
-0.003876065800320495}, {-0.002229023668683608, -0.0022290237336204492`}, \
{-0.0012855887619612854`, -0.0012855887994135898`}}]}}, 
    {RGBColor[0.2947336, 0.4054232, 0.5678384000000001], 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{1., -0.9999151842234703}, {
       0.9904836681281073, -0.990399659486655}, {
       0.9609534393546337, -0.960871935342466}, {
       0.9452097863205337, -0.9451296176185235}, {
       0.9287632174491856, -0.9286844436756855}, {
       0.9078521644729407, -0.9077751642866367}, {
       0.8857750514372857, -0.8856999237384675}, {
       0.8819350282301918, -0.8818602262259237}}]}, 
     {Arrowheads[{{0.020000000000000004`, 1.}}], 
      ArrowBox[{{0.8789834039359465, -0.878908852275985}, {
       0.8624571221926651, -0.8623839722221228}, {
       0.837823620589523, -0.8377525599285477}, {
       0.8118297247241079, -0.8117608687555954}, {
       0.7843772114035272, -0.7843106838412498}, {
       0.7609184321661383, -0.7608538942784385}}]}, 
     {Arrowheads[{{0.019999999999999993`, 1.}}], 
      ArrowBox[{{0.7579668078718931, -0.7579025203284998}, {
       0.7554660806277812, -0.755402005185511}, {
       0.7250963323968698, -0.7250348327883788}, {
       0.7058160043182087, -0.7057561399857155}, {
       0.6860223056218209, -0.6859641201072528}, {
       0.6657152363077061, -0.6656587731529913}, {
       0.6448947963758647, -0.6448400991229302}, {
       0.639901836102085, -0.6398475623309533}}]}, 
     {Arrowheads[{{0.020000000000000004`, 1.}}], 
      ArrowBox[{{0.6369502118078397, -0.6368961883810146}, {
       0.6236426955391843, -0.6235898007996852}, {
       0.6020406435105528, -0.6019895809658711}, {
       0.5800886402899701, -0.5800394396214879}, {
       0.5577866858774363, -0.5577393767665356}, {
       0.535285691167694, -0.5352402904961323}, {
       0.5188852400380316, -0.518841230383468}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{0.5159336157437864, -0.5158898564335294}, {
       0.5127365670554858, -0.5126930789053958}, {
       0.49013931354081186`, -0.4900977419943262}, {
       0.46749393062367217`, -0.4674542797629234}, {
       0.44985688159875004`, -0.44981872663801}, {
       0.43232711286373193`, -0.4322904447039395}, {
       0.4102601432150595, -0.4102253466824335}, {
       0.39786864397397825`, -0.39783489843598274`}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{0.39491701967973303`, -0.3948835244860441}, {
       0.38858036094060106`, -0.3885474031955437}, {
       0.3675351444935779, -0.36750397171489574`}, {
       0.347042034389583, -0.3470125997499478}, {
       0.3256911598105396, -0.32566353606191134`}, {
       0.30516646456517516`, -0.3051405816345123}, {
       0.2854679486534902, -0.2854437364677508}, {
       0.27685204790992485`, -0.2768285664884976}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{0.2739004236156796, -0.2738771925385589}, {
       0.26659561207548427`, -0.2665730005616267}, {
       0.24860042526289017`, -0.2485793400247759}, {
       0.23153335864744046`, -0.23151372096583425`}, {
       0.2153944122291351, -0.21537614338480174`}, {
       0.2001835860079742, -0.20016660728167845`}, {
       0.17241306505317244`, -0.1723984417051761}, {
       0.15583545184587147`, -0.15582223454101232`}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{0.15288382755162627`, -0.15287086059107366`}, {
       0.14808856667912207`, -0.14807600643234403`}, {
       0.13047856206040306`, -0.13046749541984146`}, {
       0.11468947850487943`, -0.11467975102770026`}, {
       0.10072131601255123`, -0.10071277325592054`}, {
       0.08857407458341843, -0.08856656210450226}, {
       0.06840319730983102, -0.0683973956395341}, {
       0.05283768907920923, -0.05283320760957996}, {
       0.03481885578181809, -0.0348159025935271}}]}, 
     {Arrowheads[{{0.00003442370773956503, 1.}}], 
      ArrowBox[{{0.03186723148757289, -0.031864528643588436`}, {
       0.031664019783448696`, -0.031661334175022725`}}]}}, 
    {RGBColor[0.2947336, 0.4054232, 0.5678384000000001], 
     {Arrowheads[{{0.019999999999999993`, 1.}}], 
      ArrowBox[{{-0.9999146800667139, 1.}, {-0.9903999687981172, 
       0.9904844768676045}, {-0.9608722631949037, 
       0.9609542517475539}, {-0.9451299546807479, 
       0.9452105999860803}, {-0.9286847898107489, 
       0.928764031895989}, {-0.9077756316884621, 
       0.9078530896535051}, {-0.885700524218851, 
       0.8857760985764882}, {-0.8818597518333295, 0.8819349984685617}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{-0.8789083786274949, 
       0.8789833734302758}, {-0.8623847184144839, 
       0.8624583032993836}, {-0.8377534652879288, 
       0.8378249484566367}, {-0.8117617454248534, 
       0.8118310107925337}, {-0.7843115225142929, 
       0.7843784456309453}, {-0.7608534503941107, 0.7609183718988373}}]}, 
     {Arrowheads[{{0.019999999999999993`, 1.}}], 
      ArrowBox[{{-0.7579020771882761, 
       0.7579667468605513}, {-0.7554027965562479, 
       0.7554672529718713}, {-0.7250355675507179, 
       0.7250974328153116}, {-0.7057569026759891, 
       0.7058171229458311}, {-0.6859649095659541, 
       0.6860234410401764}, {-0.665659588220613, 
       0.6657163870983478}, {-0.6448409386399657, 
       0.644895961120345}, {-0.6398471489548918, 0.6399017453291129}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{-0.6368957757490572, 
       0.636950120290827}, {-0.6235906627855979, 
       0.6236438720391546}, {-0.6019904626190956, 
       0.6020418287877631}, {-0.5800403381404586, 
       0.5800898313661706}, {-0.557740289349687, 
       0.557787879774377}, {-0.53524121365076, 
       0.5352868842920167}, {-0.5188408475156729, 0.5188851187593885}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{-0.5158894743098383, 
       0.5159334937211025}, {-0.5126940084476572, 
       0.5127377551987239}, {-0.49009867374037847`, 
       0.49014049249449876`}, {-0.4674552095289237, 
       0.4674950961793412}, {-0.4498196555685816, 
       0.4498580374263229}, {-0.43229137000749285`, 
       0.43232825622547155`}, {-0.410226255083719, 
       0.41026125854692796`}, {-0.39783454607645397`, 
       0.39786849218966414`}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{-0.39488317287061936`, 
       0.3949168671513782}, {-0.38854829052256257`, 
       0.38858144426546337`}, {-0.3675048349708938, 
       0.36753619313437214`}, {-0.34701343554642267`, 
       0.34704304523588947`}, {-0.3256643736450208, 
       0.32569216167852694`}, {-0.3051414162831006, 
       0.30516745314984434`}, {-0.28544456346066227`, 
       0.285468919649842}, {-0.27682824463723504`, 0.2768518656199398}}]}, 
     {Arrowheads[{{0.019999999999999997`, 1.}}], 
      ArrowBox[{{-0.27387687143140044`, 
       0.27390024058165385`}, {-0.26657381517770573`, 
       0.2665965611785197}, {-0.24858013855450437`, 
       0.2486013492050333}, {-0.23151450071133167`, 
       0.2315342551985386}, {-0.21537690164818765`, 
       0.21539527915903553`}, {-0.20016734136507228`, 
       0.2001844210865242}, {-0.17239912315061498`, 
       0.17241383348738565`}, {-0.15582194319801612`, 
       0.15583523905021543`}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{-0.15287056999218152`, 
       0.15288361401192946`}, {-0.14807663207964725`, 
       0.14808926704603192`}, {-0.13046801839836317`, 
       0.13047915087081063`}, {-0.11468018397116529`, 
       0.11468996931169549`}, {-0.10071312879805362`, 
       0.10072172236868654`}, {-0.08856685287902814, 
       0.08857441004178372}, {-0.06839758539610369, 
       0.06840342157146868}, {-0.05283332811525973, 
       0.052837836235922336`}, {-0.034815641758797145`, 
       0.034818612480491076`}}]}, 
     {Arrowheads[{{0.00003437224771127734, 1.}}], 
      ArrowBox[{{-0.03186426855296254, 
       0.03186698744220512}, {-0.03166137789112379, 
       0.03166407946827157}}]}}, 
    {RGBColor[0.2947336, 0.4054232, 0.5678384000000001], 
     {Arrowheads[{{0.020000000000000004`, 1.}}], 
      ArrowBox[{{0.9999999395749831, 1.}, {0.9904396389246614, 
       0.9904396987719968}, {0.9609106237231773, 0.9609106817862213}, {
       0.9451676200996337, 0.9451676772114065}, {0.9287217315907224, 
       0.928721787708752}, {0.9078111518854652, 0.9078112067399726}, {
       0.8857345204828555, 0.8857345740033821}, {0.8819399781520234, 
       0.8819400314432646}}]}, 
     {Arrowheads[{{0.020000000000000004`, 1.}}], 
      ArrowBox[{{0.8789884791164494, 0.8789885322293463}, {0.8624170815396621,
        0.8624171336512321}, {0.8377840792126543, 0.8377841298357744}, {
       0.8117914122830199, 0.8117914613355325}, {0.7843402243356834, 
       0.7843402717294574}, {0.7609285176934897, 0.7609285636726109}}]}, 
     {Arrowheads[{{0.020000000000000007`, 1.}}], 
      ArrowBox[{{0.7579770186579157, 0.7579770644586925}, {0.755430515370645, 
       0.7554305610175494}, {0.7250622853879048, 0.7250623291998083}, {
       0.7057826931563786, 0.7057827358033122}, {0.6859897566951367, 
       0.6859897981460817}, {0.6656834760041791, 0.6656835162281167}, {
       0.6448638510835057, 0.6448638900494171}, {0.6399170572349558, 
       0.6399170959019571}}]}, 
     {Arrowheads[{{0.020000000000000004`, 1.}}], 
      ArrowBox[{{0.6369655581993818, 0.6369655966880388}, {0.6236125910362283,
        0.6236126287180319}, {0.6020114049654584, 0.6020114413420099}, {
       0.580060292871196, 0.5800603279213511}, {0.5577592547534408, 
       0.5577592884560553}, {0.5352591974343681, 0.5352592297774161}, {
       0.518905596776422, 0.5189056281313035}}]}, 
     {Arrowheads[{{0.019999999999999997`, 1.}}], 
      ArrowBox[{{0.515954097740848, 0.5159541289173851}, {0.5127110277361525, 
       0.512711058716727}, {0.49011474565879415`, 0.4901147752739877}, {
       0.46747035120229297`, 0.4674703794491985}, {0.4498340695040802, 
       0.4498340966853131}, {0.43230507341325075`, 0.43230509953529367`}, {
       0.4102391204437513, 0.41023914523245864`}, {0.39789413631788834`, 
       0.39789416036064973`}}]}, 
     {Arrowheads[{{0.020000000000000004`, 1.}}], 
      ArrowBox[{{0.3949426372823143, 0.3949426611467313}, {
       0.38856035296345304`, 0.38856037644222036`}, {0.3675161345085466, 
       0.3675161567157166}, {0.34702401056696847`, 0.34702403153590144`}, {
       0.32567405489884227`, 0.32567407457770375`}, {0.30515025961557984`, 
       0.3051502780542905}, {0.28545262471718125`, 0.2854526419656619}, {
       0.2768826758593546, 0.2768826925899959}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{0.2739311768237806, 0.2739311933760776}, {
       0.26658115020364637`, 0.26658116631181783`}, {0.24858680068597316`, 
       0.2485868157068357}, {0.23152054077515943`, 0.23152055476479289`}, {
       0.21538237047120515`, 0.21538238348568936`}, {0.20017228977411036`, 
       0.20017230186952512`}, {0.17240316024758706`, 0.17240317066505162`}, {
       0.15587121540082083`, 0.15587122481934226`}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{0.15291971636524684`, 0.15291972560542388`}, {
       0.14807991524267747`, 0.1480799241904094}, {0.130471040337113, 
       0.13047104822082828`}, {0.11468296247687741`, 0.11468296940659779`}, {
       0.1007156816619709, 0.10071568774771804`}, {0.08856919789239327, 
       0.08856920324418889}, {0.06839955542157752, 0.06839955955462207}, {
       0.0528349689967827, 0.05283497218933679}, {0.03485975494228711, 
       0.03485975704868852}}]}, 
     {Arrowheads[{{0.005187644813614216, 1.}}], 
      ArrowBox[{{0.03190825590671312, 0.03190825783477013}, {
       0.03166249146640007, 0.03166249337960677}, {0.018992291398826706`, 
       0.018992292546436303`}, {0.011374501615783158`, 0.01137450230308765}, {
       0.006806606103008409, 0.006806606514297722}, {0.0038760929107718566`, 
       0.0038760931449848502`}, {0.0022290395021461805`, 
       0.0022290396368359385`}, {0.0012855985781475422`, 
       0.0012855986558298628`}}]}}, 
    {RGBColor[0.2947336, 0.4054232, 0.5678384000000001], 
     {Arrowheads[{{0.019999999999999997`, 1.}}], 
      ArrowBox[{{1., 0.02243617355673628}, {0.9874755915479216, 
       0.022155173755009992`}, {0.9580072535652133, 0.021494017009601383`}, {
       0.9277311227597166, 0.020814736484222808`}, {0.8967631322638137, 
       0.020119933274753372`}, {0.865219215209887, 0.01941220847707218}, {
       0.8330993715979365, 0.01869156209117923}, {0.8330800033035397, 
       0.018691127540764643`}}]}, 
     {Arrowheads[{{0.020000000000000004`, 1.}}], 
      ArrowBox[{{0.8289070033861282, 0.018597501390365354`}, {
       0.8004036014279622, 0.017957994117074525`}, {0.7673634225250587, 
       0.017216698928863364`}, {0.7342103527143203, 0.016472870900651047`}, {
       0.7009443919957477, 0.01572651003243758}, {0.6675655403693401, 
       0.014977616324222953`}, {0.6619870066896678, 0.014852455374393727`}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{0.6578140067722563, 0.014758829223994435`}, {
       0.6422040733708528, 0.014408602048991453`}, {0.6169816445373892, 
       0.013842707258161438`}, {0.581870486400534, 0.013054947220424941`}, {
       0.5474410110110538, 0.012282481535119183`}, {0.5141828858241226, 
       0.011536296466253534`}, {0.490894010075796, 0.01101378320802281}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{0.4867210101583845, 0.010920157057623519`}, {
       0.48193288835468273`, 0.010812729925824873`}, {0.45077676344950623`, 
       0.01011370570009698}, {0.4209192054636568, 0.009443816347146146}, {
       0.39236021439713475`, 0.008803061866972375}, {0.3650997902499396, 
       0.00819144225957566}, {0.3392017873336497, 0.007610390171372916}, {
       0.31980101346192413`, 0.007175111041651887}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{0.31562801354451264`, 0.007081484891252597}, {
       0.31473005995984266`, 0.007061338248781048}, {0.2916846081285186, 
       0.0065442864918000545`}, {0.27006543183967746`, 
       0.006059234900429937}, {0.23083579991316827`, 0.005179072069959895}, {
       0.19677105820403923`, 0.0044147896128084825`}, {0.17005587813586281`, 
       0.0038154031961994146`}, {0.1487080168480523, 
       0.0033364388752809655`}}]}, 
     {Arrowheads[{{0.009413222688498719, 1.}}], 
      ArrowBox[{{0.14453501693064078`, 0.003242812724881675}, {
       0.1257344698179694, 0.0028210003869001826`}, {0.10812824156825249`, 
       0.0024259839942100208`}, {0.06597226192727818, 
       0.0014801651185308792`}}]}}, 
    {RGBColor[0.2947336, 0.4054232, 0.5678384000000001], 
     {Arrowheads[{{0.019999999999999997`, 1.}}], 
      ArrowBox[{{0.02243614191290602, 1.}, {0.022155142166970815`, 
       0.9874755763702152}, {0.021493986346000946`, 0.9580072380286062}, {
       0.02081470677108685, 0.9277311068848932}, {0.02011990453476274, 
       0.8967631160858854}, {0.019412180729562835`, 0.8652191987783916}, {
       0.018691535355487145`, 0.8330993549624122}, {0.018691101176264917`, 
       0.8330800031850918}}]}, 
     {Arrowheads[{{0.019999999999999997`, 1.}}], 
      ArrowBox[{{0.01859747515784889, 0.8289070032647191}, {
       0.017957968412535653`, 0.8004035846379465}, {0.017216674267760884`, 
       0.767363405642272}, {0.016472847288215353`, 0.7342103358126657}, {
       0.01572648747389906, 0.7009443751491274}, {0.014977594824812004`, 
       0.6675655236516572}, {0.014852434421207792`, 0.6619870064498109}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{0.014758808402791765`, 0.6578140065294382}, {
       0.014408581353473901`, 0.6422040567137615}, {0.013842687363187353`, 
       0.6169816279876787}, {0.013054928446137226`, 0.5818704702802575}, {
       0.012282463861806687`, 0.5474409954031089}, {0.011536279858026069`, 
       0.5141828707809166}, {0.011013767666150665`, 
       0.49089400971452996`}}]}, 
     {Arrowheads[{{0.019999999999999997`, 1.}}], 
      ArrowBox[{{0.010920141647734636`, 0.4867210097941572}, {
       0.010812714352185263`, 0.4819328739387864}, {0.010113691113413488`, 
       0.45077674908072096`}, {0.009443802708078767, 0.4209191912200543}, {
       0.008803049136181108, 0.39236020035678665`}, {0.008191430397720502, 
       0.36509977649091774`}, {0.007610379136671832, 0.33920177391524187`}, {
       0.007175100911093532, 0.319801012979249}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{0.007081474892677505, 0.3156280130588763}, {
       0.007061327997009976, 0.31473004692255324`}, {0.006544276978734935, 
       0.29168459551285175`}, {0.006059226081846706, 0.2700654196861375}, {
       0.005179064514733355, 0.23083578873933677`}, {0.004414783158172588, 
       0.1967710480398172}, {0.0038153976553374474`, 0.17005587102044056`}, {
       0.0033364341560364018`, 0.14870801624396804`}}]}, 
     {Arrowheads[{{0.009413222686913305, 1.}}], 
      ArrowBox[{{0.003242808137620374, 0.14453501632359533`}, {
       0.002820996351549388, 0.12573446729389134`}, {0.002425980550596468, 
       0.10812824058671879`}, {0.0014801630163421462`, 
       0.06597226127771577}}]}}, 
    {RGBColor[0.2947336, 0.4054232, 0.5678384000000001], 
     {Arrowheads[{{0.020000000000000004`, 1.}}], 
      ArrowBox[{{0.02248489379751763, -1.}, {
       0.02220331118810513, -0.9874768094549067}, {
       0.021540720971291435`, -0.9580085707885161}, {
       0.02085996759127442, -0.9277325380819629}, {
       0.020163657737051015`, -0.8967646420138803}, {
       0.01945439809761815, -0.8652208132629005}, {
       0.01873218867297583, -0.8331010518290238}, {
       0.018731719504080473`, -0.8330801858689892}}]}, 
     {Arrowheads[{{0.020000000000000004`, 1.}}], 
      ArrowBox[{{0.018637890146744544`, -0.8289071905157139}, {
       0.01799702946312405, -0.80040535771225}, {
       0.017254126065446546`, -0.7673652462326253}, {
       0.01650868407732704, -0.7342122327101952}, {
       0.015760703498765537`, -0.7009463171449599}, {
       0.015010184329762036`, -0.6675674995369194}, {
       0.014884715853307386`, -0.6619873763847032}}]}, 
     {Arrowheads[{{0.019999999999999997`, 1.}}], 
      ArrowBox[{{0.014790886495971456`, -0.6578143810314279}, {
       0.014439934911619077`, -0.6422060536133494}, {
       0.013872811582639933`, -0.6169836383292818}, {
       0.013083341591378164`, -0.5818725100148163}, {
       0.012309198793238545`, -0.5474430479452608}, {
       0.011561393351632178`, -0.514184921474193}, {
       0.011037712202534296`, -0.49089456690041716`}}]}, 
     {Arrowheads[{{0.020000000000000004`, 1.}}], 
      ArrowBox[{{0.010943882845198368`, -0.4867215715471419}, {
       0.010836255212088693`, -0.48193490748375384`}, {
       0.010135713889564992`, -0.4507788198085236}, {
       0.009464370344902145, -0.42092128297919845`}, {
       0.008822224578100151, -0.39236229699577846`}, {
       0.008209276589159008, -0.36510186185826343`}, {
       0.007626962206492445, -0.33920383503587964`}, {
       0.0071907085517612076`, -0.31980175741613115`}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{0.007096879194425278, -0.3156287620628559}, {
       0.007076717258514189, -0.3147320739978531}, {
       0.006558541745224239, -0.2916865787441839}, {
       0.0060724356666225976`, -0.27006734927487197`}, {
       0.005190358787748655, -0.23083759409713905`}, {
       0.004424413596156782, -0.1967727148724734}, {
       0.0038237140022187636`, -0.17005701857666358`}, {
       0.0033437049009881177`, -0.14870894793184516`}}]}, 
     {Arrowheads[{{0.009413335528547546, 1.}}], 
      ArrowBox[{{0.0032498755436521885`, -0.1445359525785699}, {
       0.00282713441535223, -0.125734835165837}, {
       0.002431254422423715, -0.10812834805082021`}, {
       0.0014833810975900215`, -0.06597234173967009}}]}}, 
    {RGBColor[0.2947336, 0.4054232, 0.5678384000000001], 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{-1., 0.022487201803812733`}, {-0.9874772939552581, 
       0.022205601185854795`}, {-0.9580090687326346, 
       0.02154294325847346}, {-0.9277330488220262, 
       0.020862120288927356`}, {-0.8967651644050156, 
       0.02016573922260489}, {-0.8652213456631851, 
       0.019456407004894455`}, {-0.8331015925965349, 
       0.018734123635796063`}, {-0.8330801945274057, 
       0.018733642453097343`}}]}, 
     {Arrowheads[{{0.019999999999999997`, 1.}}], 
      ArrowBox[{{-0.8289071993905908, 
       0.018639803469329457`}, {-0.800405905205065, 
       0.017998889115309703`}, {-0.7673657983768944, 
       0.0172559095654451}, {-0.7342127870001427, 
       0.01651039110821198}, {-0.7009468710748094, 
       0.015762333743610347`}, {-0.6675680506008949, 
       0.015011737471640193`}, {-0.6619873939179964, 
       0.01488624411861406}}]}, 
     {Arrowheads[{{0.019999999999999997`, 1.}}], 
      ArrowBox[{{-0.6578143987811815, 
       0.014792405134846174`}, {-0.6422066034742586, 
       0.014441429492066794`}, {-0.6169841853872612, 
       0.013874247886564347`}, {-0.5818730451760024, 
       0.013084696591071806`}, {-0.5474435682858203, 
       0.012310473996242575`}, {-0.5141854250281387, 
       0.011562591417186976`}, {-0.4908945933085872, 
       0.011038845784130778`}}]}, 
     {Arrowheads[{{0.020000000000000004`, 1.}}], 
      ArrowBox[{{-0.48672159817177235`, 
       0.010945006800362892`}, {-0.48193539196581636`, 
       0.0108373784155349}, {-0.45077930394219956`, 
       0.010136765176730475`}, {-0.42092176399592013`, 
       0.00946535265059309}, {-0.3923627721269781, 
       0.008823140837122745}, {-0.3651023283353734, 
       0.008210129736319436}, {-0.33920429073644404`, 
       0.007627755338509581}, {-0.31980179269917797`, 
       0.007191447449647499}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{-0.3156287975623631, 
       0.0070976084658796144`}, {-0.314732517445528, 
       0.007077453634019598}, {-0.2916870084626252, 
       0.006559224622849483}, {-0.27006776378773556`, 
       0.006073068304999236}, {-0.23083797607809445`, 
       0.0051909001520518035`}, {-0.19677306303270298`, 
       0.004424875577970753}, {-0.170057261755899, 
       0.0038241119633087043`}, {-0.1487089920897688, 
       0.0033440491151642197`}}]}, 
     {Arrowheads[{{0.009413338756816698, 1.}}], 
      ArrowBox[{{-0.14453599695295394`, 
       0.003250210131396335}, {-0.1257349203151494, 
       0.0028274265269130766`}, {-0.10812838015120387`, 
       0.002431504705179499}, {-0.06597236324618012, 
       0.0014835338457912894`}}]}}, 
    {RGBColor[0.2947336, 0.4054232, 0.5678384000000001], 
     {Arrowheads[{{0.020000000000000004`, 1.}}], 
      ArrowBox[{{-1., -0.4008126511920775}, {-0.9874489141444368, \
-0.3957820171949698}, {-0.9591590192981222, -0.38444306943967343`}, \
{-0.9298971570864433, -0.3727145448677931}, {-0.8996633275093993, \
-0.3605964434793287}, {-0.8685599834849288, -0.34812982969994144`}, \
{-0.8450231376773392, -0.3386959641311023}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{-0.8411487161192727, -0.3371430469545779}, \
{-0.8366895779309693, -0.3353557679552922}, {-0.8040521108475214, \
-0.32227425824538125`}, {-0.7706475822345845, -0.3088853005702084}, \
{-0.7476779886941487, -0.2996787968864619}, {-0.7244724733516298, \
-0.29037773275974843`}, {-0.6902141668432553, -0.27664657010277605`}, \
{-0.6861718537966119, -0.2750263598936026}}]}, 
     {Arrowheads[{{0.019999999999999993`, 1.}}], 
      ArrowBox[{{-0.6822974322385454, -0.2734734427170782}, \
{-0.6557777321282069, -0.2628440114070346}, {-0.6217196743083628, \
-0.24919311095780988`}, {-0.5878544916830974, -0.23561951732667333`}, \
{-0.5544783139970777, -0.22224192306168186`}, {-0.5273205699158847, \
-0.21135675565610296`}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{-0.5234461483578182, -0.2098038384795786}, \
{-0.5216766323775929, -0.20909459408821773`}, {-0.48994625109485507`, \
-0.1963766558429481}, {-0.4591215687254602, -0.1840217331803173}, \
{-0.4307219495569202, -0.17263880652852945`}, {-0.40341916684685675`, \
-0.16169550580558767`}, {-0.37721322059526974`, -0.151191831011492}, \
{-0.36846928603515744`, -0.14768715141860336`}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{-0.36459486447709094`, -0.14613423424207897`}, \
{-0.3521041108021592, -0.14112778214624241`}, {-0.32816372968299234`, \
-0.1315321745193204}, {-0.3054639694532363, -0.1224338234402074}, \
{-0.28400483011289107`, -0.1138327289089034}, {-0.2637863116619566, \
-0.10572889092540844`}, {-0.22689623062370554`, -0.09094287974177645}, \
{-0.20961800215443016`, -0.08401754718110375}}]}, 
     {Arrowheads[{{0.011602226201595775`, 1.}}], 
      ArrowBox[{{-0.20574358059636363`, -0.08246463000457938}, \
{-0.19461881953386848`, -0.0780056850292423}, {-0.1712719996459221, \
-0.06864798425305058}, {-0.15035988142134687`, -0.06026614270541643}, \
{-0.1318824648601428, -0.052860160386339825`}, {-0.11583974996230983`, \
-0.04643003729582076}}]}}, 
    {RGBColor[0.2947336, 0.4054232, 0.5678384000000001], 
     {Arrowheads[{{0.019999999999999997`, 1.}}], 
      ArrowBox[{{-0.40081398318852207`, -1.}, {-0.3957827116589853, \
-0.9874473652602827}, {-0.384443734957161, -0.9591574922083957}, \
{-0.37271518183209174`, -0.9298956560025649}, {-0.36059705228377764`, \
-0.8996618566427896}, {-0.3481304111549687, -0.8685585477471384}, \
{-0.3386971182717348, -0.8450232089643173}}]}, 
     {Arrowheads[{{0.020000000000000004`, 1.}}], 
      ArrowBox[{{-0.3371441966488151, -0.8411487891884252}, \
{-0.335356323288415, -0.8366881829336799}, {-0.32227478868411674`, \
-0.8040507622024139}, {-0.3088858073420736, -0.7706462855533405}, \
{-0.2996792742055725, -0.7476766948637591}, {-0.2903781811115506, \
-0.7244711843672673}, {-0.2766469929064118, -0.6902129279663665}, \
{-0.27502733173202787`, -0.6861719981527423}}]}, 
     {Arrowheads[{{0.019999999999999993`, 1.}}], 
      ArrowBox[{{-0.27347441010910817`, -0.6822975783768502}, \
{-0.2628444105130306, -0.6557765485676736}, {-0.2491934883391586, \
-0.6217185497292166}, {-0.23561987491554526`, -0.5878534302649863}, \
{-0.22224226476325504`, -0.5544773238580446}, {-0.21135754519232094`, \
-0.5273207873411675}}]}, 
     {Arrowheads[{{0.020000000000000004`, 1.}}], 
      ArrowBox[{{-0.20980462356940127`, -0.5234463675652754}, \
{-0.20909492160804383`, -0.5216757158636763}, {-0.19637697029844092`, \
-0.4899454074337405}, {-0.1840220358849365, -0.4591207981842841}, \
{-0.17263907885651297`, -0.43072119760680233`}, {-0.16169575001998185`, \
-0.403418435488885}, {-0.15119204937534314`, -0.37721251183053217`}, \
{-0.14768775865261402`, -0.3684695765295926}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{-0.14613483702969435`, -0.3645951567537005}, \
{-0.14112797692259682`, -0.3521034266317439}, {-0.1315323477947863, \
-0.3281630714288735}, {-0.1224339771249549, -0.30546333775827456`}, \
{-0.11383286491310268`, -0.28400422561994704`}, {-0.10572901115922961`, \
-0.2637857350138909}, {-0.0909429730782014, -0.22689570946287707`}, \
{-0.08401797211290704, -0.20961836571801776`}}]}, 
     {Arrowheads[{{0.01160230792126488, 1.}}], 
      ArrowBox[{{-0.08246505048998735, -0.2057439459421257}, \
{-0.07800575693465067, -0.19461835216951706`}, {-0.06864805460285264, \
-0.17127160598726957`}, {-0.0602662111359079, -0.15035955246990926`}, \
{-0.05286022653381646, -0.13188219161743608`}, {-0.046430100796578284`, \
-0.11583952342984996`}}]}}, 
    {RGBColor[0.2947336, 0.4054232, 0.5678384000000001], 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{1., -0.400817517837377}, {
       0.9874271790567517, -0.39577811095469045`}, {
       0.9591374633521045, -0.38443909732562864`}, {
       0.9298758489968013, -0.37271052969182145`}, {
       0.8996423359908414, -0.36059240805326853`}, {
       0.8685393912246178, -0.3481258029346377}, {
       0.8450233981354901, -0.3387001809551727}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{0.8411489830888773, -0.3371472475331176}, {
       0.8366694815885221, -0.33535178486059636`}, {
       0.8040326070825546, -0.32227035383114455`}, {
       0.7706287677067154, -0.3088815098462822}, {
       0.7476590577011364, -0.2996748476964017}, {
       0.724453461144923, -0.29037363808480465`}, {
       0.690195704401952, -0.2766425290604103}, {
       0.6861723812243674, -0.27502991065091326`}}]}, 
     {Arrowheads[{{0.019999999999999997`, 1.}}], 
      ArrowBox[{{0.6822979661777546, -0.27347697722885816`}, {
       0.6557599144547249, -0.2628400612089935}, {
       0.6217025787616921, -0.24918928445235783`}, {
       0.5878382015033705, -0.2356158488165688}, {
       0.5544631175378947, -0.22223853050391273`}, {
       0.5273213643132447, -0.2113596403466539}}]}, 
     {Arrowheads[{{0.019999999999999997`, 1.}}], 
      ArrowBox[{{0.5234469492666319, -0.2098067069245988}, {
       0.5216625809607679, -0.20909150084933467`}, {
       0.48993334113347065`, -0.19637386569889054`}, {
       0.4591098149355095, -0.18401925643722838`}, {
       0.43071031740708454`, -0.17263624033005634`}, {
       0.40340770654883046`, -0.16169287561537113`}, {
       0.3772019823607473, -0.15118916229317275`}, {
       0.36847034740212203`, -0.1476893700423945}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{0.3645959323555093, -0.14613643662033937`}, {
       0.35209314484283516`, -0.14112510036346118`}, {
       0.32815307351756284`, -0.13152950039801578`}, {
       0.30545364790739926`, -0.1224311729686158}, {
       0.2839948680123443, -0.11383011807526125`}, {
       0.26377673383239797`, -0.10572633571795215`}, {
       0.2268874512807224, -0.09094046505078789}, {
       0.20961933049099937`, -0.0840190997381351}}]}, 
     {Arrowheads[{{0.01160290095494631, 1.}}], 
      ArrowBox[{{0.2057449154443866, -0.08246616631607999}, {
       0.1946108489152636, -0.07800343740644068}, {
       0.171265326367568, -0.06864614300625682}, {
       0.15035434525845617`, -0.060264655462558346`}, {
       0.13187790558792808`, -0.05285897477534524}, {
       0.11583600735598377`, -0.046429100944617524`}}]}}, 
    {RGBColor[0.2947336, 0.4054232, 0.5678384000000001], 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{-0.40081741935310977`, 1.}, {-0.395778003631736, 
       0.9874271539158477}, {-0.38443899248941293`, 
       0.9591374374643437}, {-0.37271042749894967`, 
       0.9298758225140946}, {-0.3605923086603464, 
       0.8996423090651007}, {-0.34812570650717767`, 
       0.8685393640551535}, {-0.33870009562103365`, 0.845023392864689}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{-0.33714716252773175`, 
       0.8411489776863061}, {-0.33535169157301803`, 
       0.8366694544220441}, {-0.32227026385786767`, 
       0.8040325801657734}, {-0.3088814233617264, 
       0.7706287412863408}, {-0.2996747629476855, 
       0.7476590299676568}, {-0.29037355513339685`, 
       0.7244534321937373}, {-0.27664244927477144`, 
       0.6901956749316243}, {-0.2750298387956556, 0.6861723705509951}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{-0.2734769057023537, 
       0.6822979553726123}, {-0.2628399847168331, 
       0.6557598847401338}, {-0.24918921133053773`, 
       0.6217025490875896}, {-0.23561577915889986`, 
       0.5878381721512169}, {-0.22223846492215527`, 
       0.5544630901541954}, {-0.21135958197027765`, 0.5273213482373013}}]}, 
     {Arrowheads[{{0.020000000000000004`, 1.}}], 
      ArrowBox[{{-0.20980664887697575`, 
       0.5234469330589184}, {-0.20909143936625302`, 
       0.5216625557434889}, {-0.1963738082292238, 
       0.4899333181331212}, {-0.18401920293172405`, 
       0.459109794251751}, {-0.17263618925756663`, 
       0.43071029581545855`}, {-0.16169282695795356`, 
       0.40340768427408674`}, {-0.15118911603288482`, 
       0.3772019596276357}, {-0.14768932514489957`, 0.3684703259236074}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{-0.14613639205159767`, 
       0.3645959107452246}, {-0.14112505648236054`, 
       0.3520931218761054}, {-0.13152945885564726`, 
       0.3281530505034593}, {-0.12243113370201161`, 
       0.30545362499366063`}, {-0.11383008102145366`, 
       0.2839948453467096}, {-0.10572630081397337`, 
       0.26377671156260607`}, {-0.09094043420999218, 
       0.22688743008416007`}, {-0.08401906831952158, 0.20961930360991357`}}]}, 
     {Arrowheads[{{0.011602898180854755`, 1.}}], 
      ArrowBox[{{-0.08246613522621968, 
       0.2057448884315308}, {-0.07800341028181441, 
       0.194610829059541}, {-0.06864611957637176, 
       0.17126530999366646`}, {-0.060264635310871145`, 
       0.1503543319253287}, {-0.05285895748531258, 
       0.1318778948545278}, {-0.04642908609969608, 
       0.11583599878126369`}}]}}, 
    {RGBColor[0.2947336, 0.4054232, 0.5678384000000001], 
     {Arrowheads[{{0.019999999999999993`, 1.}}], 
      ArrowBox[{{0.4266953398308826, -1.}, {
       0.4180171566905704, -0.9796618750423856}, {
       0.4055216218926777, -0.9503774333542125}, {
       0.3925729637816047, -0.9200310552657969}, {
       0.3792048759566306, -0.8887017048438485}, {
       0.3654510520170343, -0.8564683461550764}, {
       0.3611692655790123, -0.8464335835543902}}]}, 
     {Arrowheads[{{0.019999999999999997`, 1.}}], 
      ArrowBox[{{0.35953111372271557`, -0.84259442314325}, {
       0.35131149196281597`, -0.8233309791994812}, {
       0.33678619579397534`, -0.7892896039770624}, {
       0.32719030418264883`, -0.7668007443257482}, {
       0.3174741099808688, -0.7440299444252126}, {
       0.30278331782785217`, -0.7096007140548055}, {
       0.29400503947084516`, -0.6890280066976402}}]}, 
     {Arrowheads[{{0.019999999999999997`, 1.}}], 
      ArrowBox[{{0.29236688761454843`, -0.6851888462864999}, {
       0.2879577241729197, -0.674855563894955}, {
       0.27323692299984603`, -0.6403560046100841}, {
       0.25854104964737296`, -0.6059148659787187}, {
       0.24585147799116935`, -0.5761756809638717}, {
       0.2333029139543162, -0.546766960348768}, {
       0.22684081336267808`, -0.5316224298408901}}]}, 
     {Arrowheads[{{0.019999999999999997`, 1.}}], 
      ArrowBox[{{0.22520266150638132`, -0.5277832694297498}, {
       0.2210550903440181, -0.5180630527430453}, {
       0.20905476289120686`, -0.48993917527682435`}, {
       0.19712185889278303`, -0.46197331091291227`}, {
       0.18557129796062083`, -0.4349035028931195}, {
       0.1744030800947203, -0.40872975121744626`}, {
       0.16361720529508145`, -0.38345205588589254`}, {
       0.159676587254511, -0.37421685298414004`}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{0.15803843539821424`, -0.3703776925729998}, {
       0.15325881953878895`, -0.3591762206719482}, {
       0.14337306880292758`, -0.3360080493491034}, {
       0.13395995308749728`, -0.313947541917358}, {
       0.1250194723924981, -0.2929946983767122}, {
       0.10854724720048459`, -0.2543905148893974}, {
       0.09394722436357857, -0.2201740108078374}, {
       0.09251236114634394, -0.21681127612738996`}}]}, 
     {Arrowheads[{{0.014388212881330348`, 1.}}], 
      ArrowBox[{{0.09087420929004718, -0.21297211571624972`}, {
       0.08223721417017493, -0.19273051869460084`}, {
       0.07177521434798051, -0.16821185433248015`}, {
       0.06256122489699525, -0.1466180177214753}, {
       0.054595245817219216`, -0.12794900886158644`}, {
       0.04373405400935873, -0.1024948011541265}}]}}, 
    {RGBColor[0.2947336, 0.4054232, 0.5678384000000001], 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{-1., 0.42669770267088686`}, {-0.9796615759564264, 
       0.41801934385554773`}, {-0.9503771557812198, 
       0.405523749042738}, {-0.9200307984157173, 
       0.3925750280704484}, {-0.8887014673909055, 
       0.3792068744959455}, {-0.8564681262377704, 
       0.3654529818764957}, {-0.8464337145347911, 0.3611713214551806}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{-0.8425945573981609, 
       0.35953316192478796`}, {-0.8233307749563124, 
       0.3513133502120994}, {-0.7892894135465311, 
       0.3367879795027564}, {-0.7668005796567595, 
       0.32719204574624366`}, {-0.7440298049241134, 
       0.3174758084797873}, {-0.709600608169741, 
       0.30278494931989264`}, {-0.689028271932952, 0.29400678070908176`}}]}, 
     {Arrowheads[{{0.020000000000000004`, 1.}}], 
      ArrowBox[{{-0.6851891147963218, 
       0.2923686211786891}, {-0.674855489402687, 
       0.28795928696296363`}, {-0.640355958274591, 
       0.2732384162873823}, {-0.6059148449015733, 
       0.2585424723336881}, {-0.57617497399139, 
       0.24585253773858406`}, {-0.5467655840292256, 
       0.23330361860477633`}, {-0.5316228293311129, 0.2268422399629829}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{-0.5277836721944827, 
       0.22520408043259024`}, {-0.5180610491197659, 
       0.22105545950267363`}, {-0.48993657789478245`, 
       0.20905481224213973`}, {-0.4619701292066267, 
       0.19712159283504044`}, {-0.43489978927660256`, 
       0.18557074097637916`}, {-0.40872555810471006`, 
       0.1744022566661559}, {-0.3834474356909492, 
       0.16361613990437068`}, {-0.37421738672927385`, 
       0.15967769921688402`}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{-0.3703782295926436, 
       0.15803953968649134`}, {-0.359171228177186, 
       0.15325753792868618`}, {-0.33600274170528666`, 
       0.14337159797676524`}, {-0.3139419762752511, 
       0.13395832004860772`}, {-0.29298893188707925`, 
       0.12501770414421368`}, {-0.25438449342484326`, 
       0.10854527893947793`}, {-0.22016791350709483`, 
       0.0939451428953199}, {-0.21681194412743474`, 0.09251315847078509}}]}, 
     {Arrowheads[{{0.014388590511657818`, 1.}}], 
      ArrowBox[{{-0.21297278699080452`, 
       0.09087499894039243}, {-0.1927254878669275, 
       0.08223552291894386}, {-0.16820775520489706`, 
       0.0717738627173565}, {-0.14661471552100352`, 
       0.06256016229055783}, {-0.12794636881524699`, 
       0.0545944216385479}, {-0.10249266709304249`, 
       0.04373338558921324}}]}}, 
    {RGBColor[0.2947336, 0.4054232, 0.5678384000000001], 
     {Arrowheads[{{0.020000000000000004`, 1.}}], 
      ArrowBox[{{1., 0.4266280990403443}, {0.9796807018011635, 
       0.4179593154759408}, {0.9503955142342917, 0.4054654315742464}, {
       0.9200483754036495, 0.39251848942361606`}, {0.8887182563641781, 
       0.3791521802950988}, {0.8564841281708189, 0.36540019545974306`}, {
       0.8464298563281516, 0.36111076057627106`}}]}, 
     {Arrowheads[{{0.020000000000000004`, 1.}}], 
      ArrowBox[{{0.8425906027363554, 0.3594728271146692}, {0.8233459908235721,
        0.3512625349175493}, {0.7893038443224373, 0.33673919866851726`}, {
       0.7668143488487656, 0.32714454796620823`}, {0.7440429142235758, 
       0.31742961409964204`}, {0.7096124963926428, 0.3027406303912663}, {
       0.689020459064507, 0.29395548865059595`}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{0.6851812054727108, 0.2923175551889941}, {0.6748661726946898,
        0.2879168723633682}, {0.6403654884087602, 0.273197911010871}, {
       0.6059232617751731, 0.25850388933546703`}, {0.5761918677021953, 
       0.2458196412002932}, {0.5467907464411278, 0.23327629672702932`}, {
       0.5316110618008624, 0.22680021672492096`}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{0.5277718082090661, 0.22516228326331914`}, {
       0.5180939467045501, 0.22103343560687172`}, {0.48997678558826907`, 
       0.20903786460942164`}, {0.4620175267554578, 0.1971096591630024}, {
       0.43495371110988285`, 0.18556347494135242`}, {0.4087853386515442, 
       0.17439931194447167`}, {0.3835124093804416, 0.1636171701723601}, {
       0.37420166453721776`, 0.15964494479924582`}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{0.37036241094542155`, 0.158007011337644}, {0.359240699817722,
        0.15326217686115767`}, {0.33607598648453163`, 0.14337945924700413`}, {
       0.31401826938087063`, 0.13396901732989955`}, {0.293067548506739, 
       0.1250308511098439}, {0.2544659015545399, 0.1085623038508007}, {
       0.22024985173541042`, 0.09396477555979578}, {0.2167922672735732, 
       0.09248967287357074}}]}, 
     {Arrowheads[{{0.014381884778186764`, 1.}}], 
      ArrowBox[{{0.212953013681777, 0.0908517394119689}, {0.1927932139811706, 
       0.0822510023886651}, {0.16826306058673965`, 0.07178574967683099}, {
       0.14665939155211752`, 0.0625690174242934}, {0.1279822068773043, 
       0.05460080563105238}, {0.10252160809887145`, 
       0.04373859877378067}}]}}, 
    {RGBColor[0.2947336, 0.4054232, 0.5678384000000001], 
     {Arrowheads[{{0.019999999999999997`, 1.}}], 
      ArrowBox[{{0.4266279187518798, 1.}, {0.4179591410025528, 
       0.9796807068447655}, {0.4054652617786193, 0.95039551786678}, {
       0.3925183245503724, 0.9200483777496403}, {0.3791520205981308, 
       0.888718257603389}, {0.36540004120221303`, 0.8564841285380671}, {
       0.361110603711375, 0.8464298463350013}}]}, 
     {Arrowheads[{{0.019999999999999997`, 1.}}], 
      ArrowBox[{{0.3594726708353624, 0.8425905924933763}, {
       0.35126238636261936`, 0.8233459905536753}, {0.33673905607934956`, 
       0.7893038436502131}, {0.32714440852160176`, 0.7668143460434522}, {
       0.31742947788136344`, 0.7440429093576868}, {0.30274049945573134`, 
       0.7096124893593767}, {0.2939553557948576, 0.6890204388283776}}]}, 
     {Arrowheads[{{0.019999999999999993`, 1.}}], 
      ArrowBox[{{0.292317422918845, 0.6851811849867526}, {
       0.28791674687617297`, 0.6748661637486996}, {0.273197791065087, 
       0.6403654778720065}, {0.25850377504834043`, 0.6059232499471799}, {
       0.24581956318980402`, 0.5761919283411194}, {0.23327625419076803`, 
       0.5467908778057207}, {0.22680010787834023`, 0.5316110313217539}}]}, 
     {Arrowheads[{{0.019999999999999997`, 1.}}], 
      ArrowBox[{{0.22516217500232763`, 0.5277717774801289}, {
       0.22103342653404368`, 0.5180941443792226}, {0.20903788739202725`, 
       0.4899770460488791}, {0.1971097133501532, 0.4620178490118673}, {
       0.18556355802327185`, 0.4349540896576737}, {0.17439942141138318`, 
       0.4087857679862981}, {0.16361730351448717`, 0.3835128839977406}, {
       0.15964485996182284`, 0.3742016238151302}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{0.1580069270858102, 0.37036236997350525`}, {
       0.1532623314429363, 0.3592412139630068}, {0.143379632307083, 
       0.3360765341531021}, {0.1339692061069273, 0.31401884456802687`}, {
       0.12503105284246918`, 0.29306814520778074`}, {0.1085625243178582, 
       0.2544665258557457}, {0.09396500593046257, 0.22025048479096646`}, {
       0.09248961204530545, 0.21679221630850648`}}]}, 
     {Arrowheads[{{0.01438184839324244, 1.}}], 
      ArrowBox[{{0.09085167916929283, 0.2129529624668815}, {
       0.0822511903585371, 0.1927937360479522}, {0.07178590070724927, 
       0.16826348570262897`}, {0.0625691369765991, 0.1466597337549968}, {
       0.05460089916658653, 0.12798248020505562`}, {0.0437386745670507, 
       0.10252182908003366`}}]}}, 
    {RGBColor[0.2947336, 0.4054232, 0.5678384000000001], 
     {Arrowheads[{{0.020000000000000004`, 1.}}], 
      ArrowBox[{{-1., -0.6597097702766422}, {-0.9976437345935457, \
-0.6581553189666395}, {-0.9750453653812634, -0.643246954004978}, \
{-0.9515274475658777, -0.627731953845605}, {-0.927089981147388, \
-0.61161031848852}, {-0.9017329661257946, -0.5948820479337231}, \
{-0.8754564025010974, -0.5775471421812146}, {-0.860633348409077, \
-0.5677682285713697}}]}, 
     {Arrowheads[{{0.019999999999999997`, 1.}}], 
      ArrowBox[{{-0.8571491821193039, -0.5654696900287379}, \
{-0.8397054653383094, -0.5539618996383772}, {-0.8141460890688501, \
-0.5371001293912381}, {-0.7878658544720387, -0.5197628018625593}, \
{-0.7610052215863083, -0.5020425799120288}, {-0.7335173703988481, \
-0.4839085759197509}, {-0.717782530528381, -0.4735281483234653}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{-0.7142983642386079, -0.4712296097808335}, \
{-0.7061613447003193, -0.4658615384904926}, {-0.6784417516779235, \
-0.4475746521455258}, {-0.6503585913316609, -0.4290479168848507}, \
{-0.6219118636615312, -0.41028133270846723`}, {-0.5933448671135726, \
-0.39143540597831983`}, {-0.5749317126476851, -0.3792880680755608}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{-0.571447546357912, -0.37698952953292897`}, \
{-0.5649009001338234, -0.37267064305635306`}, {-0.5365799627222834, \
-0.35398704394256675`}, {-0.5083820548789524, -0.335384608636961}, \
{-0.48056992286721745`, -0.31703667341659575`}, {-0.4534063129504653, \
-0.29911657455853086`}, {-0.43208089476698897`, -0.2850479878276564}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{-0.4285967284772159, -0.28274944928502455`}, \
{-0.4268912251286958, -0.28162431206276634`}, {-0.40102465940190907`, \
-0.26455988592930213`}, {-0.3753604220708097, -0.24762893781527737`}, \
{-0.3504467455824764, -0.2311931420224124}, {-0.326410191284051, \
-0.21533599230795614`}, {-0.30337732052267535`, -0.2001409824291574}, \
{-0.289230076886293, -0.1908079075797519}}]}, 
     {Arrowheads[{{0.01747089096453357, 1.}}], 
      ArrowBox[{{-0.28574591059651994`, -0.1885093690371201}, \
{-0.28147469464549135`, -0.18569160614326513`}, {-0.26082887499964086`, \
-0.1720713572075281}, {-0.24156642293226574`, -0.1593637293791952}, \
{-0.2238138997905078, -0.14765221641551532`}, {-0.2019512195841252, \
-0.13322919267893096`}, {-0.1820576500459594, -0.12010521048892517`}, \
{-0.16400293189466225`, -0.1081943365249234}}]}}, 
    {RGBColor[0.2947336, 0.4054232, 0.5678384000000001], 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{-0.659710624185658, -1.}, {-0.6581545121090141, \
-0.9976412202265732}, {-0.6432462531705319, -0.9750430409765651}, \
{-0.627731370920416, -0.9515253323307974}, {-0.6116098653586663, \
-0.9270880942892699}, {-0.594881736485283, -0.9017313268519827}, \
{-0.577546984300266, -0.8754550300189357}, {-0.5677689995616547, \
-0.8606334031114092}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{-0.5654704589460546, -0.8571492381891944}, \
{-0.5539616915037072, -0.8397040629556535}, {-0.5370998722951129, \
-0.8141446455528969}, {-0.5197624955804006, -0.787864370415425}, \
{-0.502042225778486, -0.7610036997633671}, {-0.48390817474973086`, \
-0.7335158128566802}, {-0.4735288343220515, -0.7177826413006035}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{-0.4712302937064514, -0.7142984763783887}, \
{-0.46586109119139746`, -0.7061597526437489}, {-0.44757416134706685`, \
-0.6784401295636994}, {-0.42904738521673913`, -0.650356943616532}, \
{-0.4102807628004142, -0.6219101948022464}, {-0.3914348015561122, \
-0.5933431829134123}, {-0.3792886690824482, -0.574931879489798}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{-0.3769901284668481, -0.5714477145675831}, \
{-0.3726700089418534, -0.5648992077425985}, {-0.35398638495763773`, \
-0.5365782692898056}, {-0.3353839296034652, -0.5083803675550331}, \
{-0.3170359793998524, -0.4805682488306131}, {-0.29911587086731617`, \
-0.4534046594088774}, {-0.28504850384284486`, -0.4320811176789924}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{-0.28274996322724477`, -0.4285969527567776}, \
{-0.2816236040058565, -0.42688959928982584`}, {-0.26455917881547325`, \
-0.4010230684734586}, {-0.24762795791041456`, -0.37535845086030667`}, \
{-0.2311919080285046, -0.35044442146719434`}, {-0.21533452636779143`, \
-0.32640754669306526`}, {-0.20013931012632308`, -0.3033743929368632}, \
{-0.1908083386032415, -0.28923035586818685`}}]}, 
     {Arrowheads[{{0.017471340006286282`, 1.}}], 
      ArrowBox[{{-0.18850979798764142`, -0.2857461909459721}, \
{-0.18568975650214767`, -0.2814715265975317}, {-0.17206936269331324`, \
-0.2608255140740145}, {-0.15936162589786784`, -0.24156292176525535`}, \
{-0.14765004331385959`, -0.2238103160701978}, {-0.13322717547757154`, \
-0.20194790047837444`}, {-0.1201033506684847, -0.1820545952503636}, \
{-0.10819262876082626`, -0.16400013095799157`}}]}}, 
    {RGBColor[0.2947336, 0.4054232, 0.5678384000000001], 
     {Arrowheads[{{0.019999999999999993`, 1.}}], 
      ArrowBox[{{1., -0.6596829895209765}, {
       0.997612814289883, -0.6581082037151847}, {
       0.9750178381508713, -0.6432026823076463}, {
       0.9515036844701569, -0.627690795111497}, {
       0.9270703532477399, -0.6115725421267367}, {
       0.9017178444836205, -0.5948479233533657}, {
       0.8754461581777986, -0.5775169387913838}, {
       0.860631632808242, -0.5677440484072603}}]}, 
     {Arrowheads[{{0.019999999999999997`, 1.}}], 
      ArrowBox[{{0.857147423628448, -0.5654455748794175}, {
       0.8396938700669407, -0.5539317624881979}, {
       0.8141330692634825, -0.5370697369996225}, {
       0.787851404188637, -0.5197321696134592}, {
       0.760989383587744, -0.5020117515588882}, {
       0.7335001712123574, -0.4838775857595161}, {
       0.7177790564366899, -0.47350663376570135`}}]}, 
     {Arrowheads[{{0.019999999999999997`, 1.}}], 
      ArrowBox[{{0.714294847256896, -0.47120816023785844`}, {
       0.7061428128237484, -0.4658304017923217}, {
       0.6784219706341998, -0.44754343374468114`}, {
       0.6503376446437128, -0.4290166816165949}, {
       0.6218898348522864, -0.4102501454080627}, {
       0.5933218742277582, -0.3914043477387564}, {
       0.5749264800651379, -0.3792692191241423}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{0.5714422708853439, -0.3769707455962994}, {
       0.5648770957379647, -0.37263981122834744`}, {
       0.5365554993829064, -0.35395653587683623`}, {
       0.5083570851625829, -0.33535452168422236`}, {
       0.4805446068343386, -0.31700710283465877`}, {
       0.4533808181555172, -0.29908761351229785`}, {
       0.43207390369358584`, -0.28503180448258325`}}]}, 
     {Arrowheads[{{0.019999999999999997`, 1.}}], 
      ArrowBox[{{0.42858969451379186`, -0.28273333095474035`}, {
       0.426865719126119, -0.2815960537171397}, {
       0.40099930974614384`, -0.26453242344918426`}, {
       0.3753265630352223, -0.24759654914970874`}, {
       0.3504049680851285, -0.23115619688939995`}, {
       0.32636119496412097`, -0.21529492875756961`}, {
       0.303321913740459, -0.20009630684352983`}, {
       0.2892213273220338, -0.19079438984102418`}}]}, 
     {Arrowheads[{{0.017477388916446256`, 1.}}], 
      ArrowBox[{{0.28573711814223984`, -0.18849591631318127`}, {
       0.2814137944824017, -0.18564389323659247`}, {
       0.2607635072582079, -0.17202125002606947`}, {
       0.24149772213613657`, -0.15931193930127271`}, {
       0.22374310918444684`, -0.14759952315151417`}, {
       0.2018855386391111, -0.13318045567050146`}, {
       0.1819971141665073, -0.12006040035755203`}, {
       0.16394736033921758`, -0.10815328479264785`}}]}}, 
    {RGBColor[0.2947336, 0.4054232, 0.5678384000000001], 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{-0.6596828105340169, 1.}, {-0.6581080017453541, 
       0.9976127788029099}, {-0.6432024897235638, 
       0.9750178107610349}, {-0.6276906127123563, 
       0.9515036661395455}, {-0.6115723707117318, 
       0.9270703449384419}, {-0.5948477637216903, 
       0.9017178471577237}, {-0.5775167917422318, 
       0.8754461727973915}, {-0.5677438868014618, 0.8606316213421872}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{-0.5654454137081479, 0.8571474118757418}, {-0.55393161823608,
        0.8396938792260924}, {-0.5370695938339503, 
       0.8141330731343288}, {-0.5197320276240472, 
       0.7878514027117386}, {-0.5020116109046733, 
       0.7609893768465668}, {-0.4838774465763941, 
       0.7335001592427317}, {-0.4735064899755928, 0.717779033217929}}]}, 
     {Arrowheads[{{0.019999999999999997`, 1.}}], 
      ArrowBox[{{-0.4712080168822789, 
       0.7142948237514837}, {-0.46583026411416145`, 
       0.7061427957127902}, {-0.4475432977751166, 
       0.6784219485919725}, {-0.42901654755925955`, 
       0.6503376178802784}, {-0.4102500134665903, 
       0.6218898035777084}, {-0.39140421814648785`, 
       0.5933218387631536}, {-0.37926909314972385`, 0.5749264450936709}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{-0.37697062005640997`, 
       0.5714422356272255}, {-0.3726396842483311, 
       0.5648770565155052}, {-0.35395641177212, 
       0.5365554568347634}, {-0.33535440071785483`, 
       0.5083570397209283}, {-0.3170069852470564, 
       0.48054455896832826`}, {-0.2990874995212459, 
       0.4533807683712918}, {-0.28503169632385494`, 
       0.43207385696941264`}}]}, 
     {Arrowheads[{{0.020000000000000004`, 1.}}], 
      ArrowBox[{{-0.28273322323054106`, 
       0.4285896475029673}, {-0.28159594354042333`, 
       0.426865667929819}, {-0.2645323173045888, 
       0.40099925764390987`}, {-0.2475964310993095, 
       0.37532648591961765`}, {-0.23115606791335913`, 
       0.350404867645766}, {-0.2152947900179872, 
       0.3263610732007779}, {-0.200096159684443, 
       0.30332177296307605`}, {-0.190794299497986, 0.2892212688451544}}]}, 
     {Arrowheads[{{0.017477400257947123`, 1.}}], 
      ArrowBox[{{-0.1884958264046721, 
       0.2857370593787091}, {-0.18564373918397611`, 
       0.2814136373110836}, {-0.17202109078783606`, 
       0.26076333662322354`}, {-0.1593117767672722, 
       0.24149754127791878`}, {-0.14759935939353402`, 
       0.22374292165359216`}, {-0.1331803045628983, 
       0.201885364354254}, {-0.12006026167732545`, 
       0.18199695332388002`}, {-0.10815315793673513`, 
       0.16394721252352257`}}]}}, 
    {RGBColor[0.2947336, 0.4054232, 0.5678384000000001], 
     {Arrowheads[{{0.019999999999999993`, 1.}}], 
      ArrowBox[{{0.6756023704218377, 1.}, {0.664196531864452, 
       0.9831175273256308}, {0.6494476698876023, 0.9612868431502026}, {
       0.6341237568037608, 0.9386049909917009}, {0.6182247926129277, 
       0.9150719708501257}, {0.6017507773151031, 0.890687782725477}, {
       0.5847017109102868, 0.8654524266177548}, {0.5821344182049248, 
       0.8616524211444777}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{0.5797977193995021, 0.8581937316730897}, {0.5728036060467178,
        0.8478413207595262}, {0.5606239874477359, 0.8298135293659331}, {
       0.5433718607776339, 0.8042776114571045}, {0.525637662094595, 
       0.7780281495554746}, {0.5075207258114364, 0.7512121745436542}, {
       0.48898794045721916`, 0.7237806761274401}, {0.48632976718258913`, 
       0.7198461528175674}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{0.4839930683771663, 0.7163874633461793}, {0.4705463503330961,
        0.6964841612963741}, {0.45187130159810285`, 0.6688420902312107}, {
       0.4329627942522393, 0.6408544629319499}, {0.41382082829550554`, 
       0.6125212793985917}, {0.3946116152829722, 0.5840885594237648}, {
       0.3905251161602534, 0.578039884490657}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{0.3881884173548306, 0.574581195019269}, {0.3755013667697099, 
       0.5558023228000981}, {0.35649008275571875`, 0.5276625695275915}, {
       0.3375777632409987, 0.49966929960624495`}, {0.31894060671087215`, 
       0.4720833150892136}, {0.30075481165066165`, 0.44516541802965237`}, {
       0.2947204651379176, 0.43623361616374673`}}]}, 
     {Arrowheads[{{0.020000000000000004`, 1.}}], 
      ArrowBox[{{0.2923837663324948, 0.4327749266923587}, {0.283020378060367, 
       0.41891560842756137`}, {0.26573730593998834`, 0.3933338862829406}, {
       0.24745429319366893`, 0.36627209143621187`}, {0.22975030241965838`, 
       0.3400673420908885}, {0.21272498984137148`, 0.3148671454609441}, {
       0.1989158141155817, 0.29442734783683644`}}]}, 
     {Arrowheads[{{0.01640929846265173, 1.}}], 
      ArrowBox[{{0.19657911531015887`, 0.2909686583654484}, {
       0.1964780116822234, 0.2908190087603525}, {0.18110902416562902`, 
       0.2680704392030874}, {0.16671768351500343`, 0.2467689440031226}, {
       0.15340364595376155`, 0.2270620303744319}, {0.14126656770531842`, 
       0.209097205530989}, {0.11989193907914909`, 0.17745932271417286`}}]}}, 
    {RGBColor[0.2947336, 0.4054232, 0.5678384000000001], 
     {Arrowheads[{{0.019999999999999993`, 1.}}], 
      ArrowBox[{{1., 0.6756025286310916}, {0.9831175384034929, 
       0.6641966948869741}, {0.9612868492087939, 0.6494478260652761}, {
       0.9386049914234867, 0.6341239055914717}, {0.9150719650475709, 
       0.6182249334655608}, {0.8906877700810464, 0.6017509096875433}, {
       0.8654524065239133, 0.5847018342574193}, {0.8616524312976661, 
       0.5821345613858312}}]}, 
     {Arrowheads[{{0.019999999999999997`, 1.}}], 
      ArrowBox[{{0.8581937420801078, 0.5797978622046996}, {0.8478413029111324,
        0.5728037281246403}, {0.8298135137793331, 0.5606241082015686}, {
       0.8042776002257748, 0.5433719804338797}, {0.7780281427322513, 
       0.5256377805760608}, {0.751212172067583, 0.5075208429873137}, {
       0.7237806779754964, 0.4889880562145712}, {0.7198461733777739, 
       0.4863298949594392}}]}, 
     {Arrowheads[{{0.019999999999999997`, 1.}}], 
      ArrowBox[{{0.7163874841602156, 0.4839931957783077}, {0.6964841673990987,
        0.4705464646463516}, {0.6688421004266605, 0.4518714143031824}, {
       0.6408544770581819, 0.4329629051850636}, {0.6125212972936628, 
       0.4138209372919952}, {0.5840885808376025, 0.39461172215843004`}, {
       0.5780399154578817, 0.3905252285330473}}]}, 
     {Arrowheads[{{0.019999999999999997`, 1.}}], 
      ArrowBox[{{0.5745812262403234, 0.3881885293519158}, {0.5558023473945006,
        0.37550147131882106`}, {0.527662596964357, 0.35649018477316813`}, {
       0.49966932954717164`, 0.3375778625214714}, {0.4720833471664751, 
       0.31894070307030004`}, {0.4451654518457979, 0.30075490492622353`}, {
       0.4362336575379895, 0.29472056210665537`}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{0.4327749683204311, 0.2923838629255239}, {0.4189156435851401,
        0.2830204680892418}, {0.3933339223845015, 0.26573739255935475`}, {
       0.3662721550028374, 0.2474543940870761}, {0.3400674312491711, 
       0.22975041645701993`}, {0.3148672579552727, 0.21272511565772045`}, {
       0.2944273996180972, 0.1989158956802634}}]}, 
     {Arrowheads[{{0.01640928022027252, 1.}}], 
      ArrowBox[{{0.2909687104005389, 0.1965791964991319}, {
       0.29081914195291203`, 0.19647814767771177`}, {0.26807059007385914`, 
       0.18110916850552805`}, {0.24676910914988404`, 0.16671783412970353`}, {
       0.2270622060127566, 0.15340380053877223`}, {0.2090973874942469, 
       0.14126672372126842`}, {0.1774595092690388, 
       0.11989209319179528`}}]}}, 
    {RGBColor[0.2947336, 0.4054232, 0.5678384000000001], 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{0.6756748419749365, -1.}, {
       0.6642496184547519, -0.9830906483260653}, {
       0.6494993507311793, -0.9612602251591185}, {
       0.6341739569035861, -0.9385786143079606}, {
       0.6182734369719729, -0.9150458157725918}, {
       0.6017977909363393, -0.890661829553012}, {
       0.5847470187966854, -0.8654266556492213}, {
       0.582200006008455, -0.8616570720714375}}]}, 
     {Arrowheads[{{0.019999999999999993`, 1.}}], 
      ArrowBox[{{0.579863135109293, -0.8581984988732234}, {
       0.5728480925720671, -0.8478162231076769}, {
       0.5606676314069033, -0.8297891183400028}, {
       0.543414417947711, -0.8042543309136088}, {
       0.525679099890166, -0.7780060278012624}, {
       0.5075610124958656, -0.7511912253715272}, {
       0.4890270440109438, -0.7237609181682153}, {
       0.48638829914281145`, -0.7198555709446609}}]}, 
     {Arrowheads[{{0.019999999999999997`, 1.}}], 
      ArrowBox[{{0.48405142824364944`, -0.7163969977464468}, {
       0.4705842733404906, -0.6964655838968568}, {
       0.4519080172083528, -0.668824690715828}, {
       0.43299827561453064`, -0.6408382386251289}, {
       0.413855048559024, -0.6125062276247597}, {
       0.3946445544356206, -0.5840746612410641}, {
       0.3905765922771679, -0.5780540698178843}}]}, 
     {Arrowheads[{{0.020000000000000004`, 1.}}], 
      ArrowBox[{{0.3882397213780059, -0.5745954966196702}, {
       0.37553301163810765`, -0.5557895430003855}, {
       0.3565204201664854, -0.527650872902724}, {
       0.3376067800207537, -0.4996586509480797}, {
       0.31896830081685873`, -0.47207366768983616`}, {
       0.3007811921707465, -0.445156713681377}, {
       0.29476488541152435`, -0.4362525686911077}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{0.29242801451236233`, -0.4327939954928936}, {
       0.28304545408241694`, -0.41890778892270225`}, {
       0.26576108655187003`, -0.39332689341381183`}, {
       0.2474783008057345, -0.3662683371225985}, {
       0.22977446701082427`, -0.340066630776446}, {
       0.21274922574607663`, -0.3148692426141394}, {
       0.19895317854588077`, -0.2944510675643311}}]}, 
     {Arrowheads[{{0.016411488142007977`, 1.}}], 
      ArrowBox[{{0.19661630764671875`, -0.290992494366117}, {
       0.1965022175904288, -0.29082364087446344`}, {
       0.18113308312281806`, -0.268077293796203}, {
       0.1667414629221818, -0.24677766961814285`}, {
       0.15342699756745715`, -0.22707223657906792`}, {
       0.1412893276375814, -0.209108462917763}, {
       0.1199132495447161, -0.17747182830460362`}}]}}, 
    {RGBColor[0.2947336, 0.4054232, 0.5678384000000001], 
     {Arrowheads[{{0.020000000000000004`, 1.}}], 
      ArrowBox[{{-1., 0.6756764394589987}, {-0.9830905359229549, 
       0.6642511129782611}, {-0.9612600800402058, 
       0.6495007882756383}, {-0.9385784321532575, 
       0.6341753331903224}, {-0.9150455922621106, 
       0.6182747477223135}, {-0.8906615603667646, 
       0.6017990318716114}, {-0.8654263364672198, 
       0.5847481856382164}, {-0.8616571745917464, 0.582201451762452}}]}, 
     {Arrowheads[{{0.020000000000000004`, 1.}}], 
      ArrowBox[{{-0.85819860395654, 0.5798645770700382}, {-0.8478159241049308,
        0.5728492449158602}, {-0.829788839722435, 
       0.5606687687264685}, {-0.8042540902027513, 
       0.5434155400885313}, {-0.7780058255593917, 
       0.5256802060923286}, {-0.7511910612759929, 
       0.5075621016363894}, {-0.7237607921913428, 
       0.48902811508787075`}, {-0.7198557785482864, 0.4863895893734916}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{-0.71639720791308, 0.4840527146810779}, {-0.6964654954858848,
        0.47058532619594995`}, {-0.6688246387375593, 
       0.45190905052464514`}, {-0.6408382219463665, 
       0.4329992880739565}, {-0.6125062451123062, 
       0.4138560388438838}, {-0.5840747110410768, 
       0.3946455211342783}, {-0.5780543825048264, 0.3905777269845313}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{-0.57459581186962, 
       0.38824085229211763`}, {-0.555789622538376, 
       0.37553395324499084`}, {-0.5276509796042044, 
       0.3565213351760216}, {-0.49965878223856147`, 
       0.3376076669273704}, {-0.47207382071023646`, 
       0.3189691583392983}, {-0.44515688528801844`, 
       0.3007820192520662}, {-0.4362529864613665, 0.2947658645955709}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{-0.4327944158261602, 
       0.29242898990315724`}, {-0.4189079759719073, 
       0.28304624966567415`}, {-0.3933270927619031, 
       0.265761849580122}, {-0.3662687481127161, 
       0.24747916360990485`}, {-0.3400672391507634, 
       0.22977542132603962`}, {-0.3148700312128908, 
       0.2127502615822699}, {-0.2944515904179066, 0.1989540022066106}}]}, 
     {Arrowheads[{{0.01641137804078971, 1.}}], 
      ArrowBox[{{-0.29099301978270026`, 
       0.19661712751419694`}, {-0.2908245896359445, 
       0.19650332323233943`}, {-0.2680783797567702, 
       0.18113424512999188`}, {-0.24677886691221407`, 
       0.16674266612897098`}, {-0.22707351643912196`, 
       0.15342822508302037`}, {-0.20910979367433988`, 
       0.14129056084588387`}, {-0.17747319943240938`, 0.1199144594918872}}]}}, 
    {RGBColor[0.2947336, 0.4054232, 0.5678384000000001], 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{-1., -0.1814903711566672}, {-0.9781548397791258, \
-0.17752568492020385`}, {-0.9394149050539325, -0.17049475978834347`}, \
{-0.899251603317229, -0.1632055072492719}, {-0.8757574843280654, \
-0.1589415508739297}, {-0.8518700863975894, -0.15460621815756062`}, \
{-0.8357216387514067, -0.1516754304006509}}]}, 
     {Arrowheads[{{0.019999999999999997`, 1.}}], 
      ArrowBox[{{-0.8316146797201919, -0.15093005688175049`}, \
{-0.8110100781030349, -0.1471905200867174}, {-0.7694159625598317, \
-0.13964158861884818`}, {-0.7278571214954024, -0.13209905912922393`}, \
{-0.6860770943339394, -0.1245163864927544}, {-0.6673363184715986, \
-0.12111511612573427`}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{-0.6632293594403837, -0.12036974260683386`}, \
{-0.6624555672154676, -0.1202293067687357}, {-0.6391711268624798, \
-0.11600340504689666`}, {-0.6160215212156857, -0.11180197452592949`}, \
{-0.5928044982157946, -0.1075883084045264}, {-0.5591543238253094, \
-0.10148112576491068`}, {-0.5262197856165785, -0.09550382420153467}, \
{-0.49895099819179045`, -0.09055480185081763}}]}, 
     {Arrowheads[{{0.019999999999999997`, 1.}}], 
      ArrowBox[{{-0.4948440391605756, -0.08980942833191721}, \
{-0.49443653424144396`, -0.08973547011289584}, {-0.4636593528159585, \
-0.08414970803282841}, {-0.4332002891606153, -0.07862168126493561}, \
{-0.4040612919164665, -0.07333323383996196}, {-0.37624236108351233`, \
-0.06828436575790747}, {-0.34974349666175264`, -0.06347507701877209}, \
{-0.3305656779119823, -0.05999448757590098}}]}, 
     {Arrowheads[{{0.012969610234289117`, 1.}}], 
      ArrowBox[{{-0.3264587188807675, -0.05924911405700057}, \
{-0.3246136309689551, -0.058914248367069065`}, {-0.30090169632288755`, \
-0.054610760547311635`}, {-0.2786076927235499, -0.050564613559499774`}, \
{-0.2577316201709422, -0.04677580740363349}, {-0.21992740311466746`, \
-0.03991470601880298}}]}}, 
    {RGBColor[0.2947336, 0.4054232, 0.5678384000000001], 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{-0.1814921789167073, -1.}, {-0.17752716682590963`, \
-0.9781532619506577}, {-0.17049618681030843`, -0.939413410693332}, \
{-0.16320687880330542`, -0.8992502033831794}, {-0.1589428784609499, \
-0.8757560761551824}, {-0.15460750137471968`, -0.8518686716835006}, \
{-0.15167695065505335`, -0.8357216909311714}}]}, 
     {Arrowheads[{{0.020000000000000004`, 1.}}], 
      ArrowBox[{{-0.150931569948512, -0.8316147332044507}, \
{-0.1471917418791827, -0.8110087319340289}, {-0.1396427492397916, \
-0.7694146936429598}, {-0.13210015984736434`, -0.727855936469799}, \
{-0.1245174282382949, -0.6860760005280447}, {-0.12111634168685803`, \
-0.6673364241356221}}]}, 
     {Arrowheads[{{0.020000000000000004`, 1.}}], 
      ArrowBox[{{-0.12037096098031669`, -0.6632294664089013}, \
{-0.12023034907090625`, -0.6624547117596944}, {-0.11600444776562105`, \
-0.6391705056274588}, {-0.11180301760517726`, -0.6160211325496693}, \
{-0.10758935187231275`, -0.5928043429446566}, {-0.10148210507366534`, \
-0.5591541502195461}, {-0.09550474081927308, -0.5262195946366554}, \
{-0.09055573271866271, -0.4989511573400728}}]}, 
     {Arrowheads[{{0.019999999999999997`, 1.}}], 
      ArrowBox[{{-0.08981035201212136, -0.4948441996133521}, \
{-0.08973632646659702, -0.4944363277922842}, {-0.08415050622981679, \
-0.4636591324876659}, {-0.07862242704426096, -0.43320008340603666`}, \
{-0.07333392950718126, -0.4040611002903688}, {-0.06828501361857772, \
-0.37624218314066266`}, {-0.06347567937845033, -0.349743331956918}, \
{-0.059995123750467366`, -0.33056589054452357`}}]}, 
     {Arrowheads[{{0.012969652426908588`, 1.}}], 
      ArrowBox[{{-0.05924974304392602, -0.32645893281780286`}, \
{-0.058914807598796096`, -0.3246134789413378}, {-0.05461127909161195, \
-0.3009015562961247}, {-0.05056509385689795, -0.2786075640212789}, \
{-0.046776251894654064`, -0.25773150211680035`}, {-0.03991508566479631, \
-0.21992730432265428`}}]}}, 
    {RGBColor[0.2947336, 0.4054232, 0.5678384000000001], 
     {Arrowheads[{{0.020000000000000004`, 1.}}], 
      ArrowBox[{{1., -0.18151973706273933`}, {
       0.9781238108191205, -0.17754877695469135`}, {
       0.9393855119907519, -0.17051701113710807`}, {
       0.8992240672715808, -0.16322691625162436`}, {
       0.8757297422892867, -0.1589622325583718}, {
       0.8518421725607751, -0.15462616718218453`}, {
       0.8357224864365203, -0.1517001259953759}}]}, 
     {Arrowheads[{{0.020000000000000004`, 1.}}], 
      ArrowBox[{{0.8316155485974333, -0.15095463571869183`}, {
       0.8109834286068873, -0.14720949872296102`}, {
       0.7693907527312943, -0.13965960713428763`}, {
       0.7278334905184631, -0.1321161438243672}, {
       0.6860551934402379, -0.12453255832379875`}, {
       0.6673380350339535, -0.12113502465132837`}}]}, 
     {Arrowheads[{{0.019999999999999997`, 1.}}], 
      ArrowBox[{{0.6632310971948665, -0.12038953437464428`}, {
       0.6624385986275938, -0.12024568024309035`}, {
       0.6391590056743468, -0.11601997465128935`}, {
       0.6160142134648587, -0.11181873805505133`}, {
       0.5928020208834911, -0.10760526696103181`}, {
       0.5591514016828429, -0.10149701541173178`}, {
       0.5262164410128447, -0.09551867001074205}, {
       0.4989535836313868, -0.09056992330728085}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{0.4948466457922998, -0.08982443303059676}, {
       0.49443281023273467`, -0.08974931370863728}, {
       0.4636552855561002, -0.08416258552189262}, {
       0.43319646667397815`, -0.07863370872716824}, {
       0.40405770904780003`, -0.07334444910452947}, {
       0.3762390126775657, -0.06829480665397636}, {
       0.34974037756327514`, -0.06348478137550886}, {
       0.3305691322288201, -0.06000482196323332}}]}, 
     {Arrowheads[{{0.012970337040463744`, 1.}}], 
      ArrowBox[{{0.3264621943897331, -0.05925933168654923}, {
       0.3246107334904202, -0.058923254990924004`}, {
       0.3008990102444924, -0.05461910922201875}, {
       0.27860520782549175`, -0.0505723440687931}, {
       0.2577293262334183, -0.046782959531247045`}, {
       0.21992545843534883`, -0.03992081138858691}}]}}, 
    {RGBColor[0.2947336, 0.4054232, 0.5678384000000001], 
     {Arrowheads[{{0.020000000000000004`, 1.}}], 
      ArrowBox[{{-0.18151971173564707`, 1.}, {-0.17754873943586796`, 
       0.9781237406020005}, {-0.1705169752566897, 
       0.9393854453945971}, {-0.16322688215164166`, 
       0.8992240048802753}, {-0.1589621988502971, 
       0.875729678778902}, {-0.15462613389220262`, 
       0.8518421080206955}, {-0.15170010469623674`, 0.8357224857053673}}]}, 
     {Arrowheads[{{0.020000000000000004`, 1.}}], 
      ArrowBox[{{-0.15095461452025147`, 
       0.8316155478480015}, {-0.14720946676187097`, 
       0.8109833656867899}, {-0.13965957660375158`, 
       0.7693906918888359}, {-0.13211611480390453`, 
       0.7278334321966609}, {-0.12453253090030984`, 
       0.686055138086989}, {-0.12113500748084113`, 0.6673380335533688}}]}, 
     {Arrowheads[{{0.019999999999999997`, 1.}}], 
      ArrowBox[{{-0.12038951730485588`, 
       0.663231095696003}, {-0.12024565610544233`, 
       0.662438558081008}, {-0.11601995374605076`, 
       0.6391589796870891}, {-0.1118187203608496, 
       0.616014201937995}, {-0.10760525248855321`, 
       0.5928020238664885}, {-0.10149700138091831`, 
       0.5591514024037874}, {-0.09551865642197738, 
       0.5262164395737042}, {-0.09056991026544552, 0.4989535814013704}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{-0.08982442008946026, 
       0.4948466435440046}, {-0.08974930056556332, 
       0.49443280681421553`}, {-0.08416257282706516, 
       0.46365528031266245`}, {-0.07863369679163623, 
       0.43319646136367246`}, {-0.07334443790242401, 
       0.4040577037122988}, {-0.06829479615942853, 
       0.3762390073585417}, {-0.06348477156264978, 
       0.34974037230240124`}, {-0.060004813050049885`, 
       0.330569129249372}}]}, 
     {Arrowheads[{{0.01297033715513958, 1.}}], 
      ArrowBox[{{-0.05925932287406462, 
       0.32646219139200616`}, {-0.05892324583090966, 
       0.32461072831980603`}, {-0.05461910068303006, 
       0.300899005186685}, {-0.05057233611901099, 
       0.27860520290303825`}, {-0.046782952138852446`, 
       0.25772932146886574`}, {-0.03992080501731832, 
       0.2199254540215238}}]}}, 
    {RGBColor[0.2947336, 0.4054232, 0.5678384000000001], 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{0.21655737372899647`, -1.}, {
       0.20798746407597132`, -0.9604266088683284}, {
       0.19895963339063763`, -0.9187386694097013}, {
       0.19399789909227266`, -0.8958267998532566}, {
       0.18894468709962078`, -0.8724925124741737}, {
       0.1812196455086733, -0.8368204803566494}}]}, 
     {Arrowheads[{{0.020000000000000004`, 1.}}], 
      ArrowBox[{{0.18033620230316524`, -0.8327409923655655}, {
       0.18007091789590857`, -0.8315159848643726}, {
       0.17100256692898944`, -0.7896409343372666}, {
       0.1619018133447283, -0.7476162577928884}, {
       0.152714597427837, -0.7051923229312274}, {
       0.14499847408284203`, -0.6695614727222149}}]}, 
     {Arrowheads[{{0.020000000000000004`, 1.}}], 
      ArrowBox[{{0.14411503087733393`, -0.6654819847311311}, {
       0.13695678371296982`, -0.6324272471292518}, {
       0.12918752139416628`, -0.5965510163409797}, {
       0.12149135543444936`, -0.5610123236278514}, {
       0.11394996668769647`, -0.5261883478061353}, {
       0.10877730265701072`, -0.5023024650877804}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{0.10789385945150264`, -0.49822297709669666`}, {
       0.10664503600778495`, -0.4924562676921004}, {
       0.09957656339471482, -0.45981608328574647`}, {
       0.09274454884848604, -0.42826779458707365`}, {
       0.08619346655516005, -0.3980167706643135}, {
       0.07996779070079826, -0.3692683805856976}, {
       0.07406752128540063, -0.34202262435122593`}, {
       0.0725561312311794, -0.335043457453346}}]}, 
     {Arrowheads[{{0.015023041524431945`, 1.}}], 
      ArrowBox[{{0.07167268802567132, -0.33096396946226225`}, {
       0.06849265830896718, -0.31627950196089843`}, {
       0.0618728605975376, -0.28571116989517203`}, {
       0.055772264992903386`, -0.25754036462733293`}, {
       0.05019087149506453, -0.23176708615738112`}, {
       0.04512868010402102, -0.2083913344853165}}]}}, 
    {RGBColor[0.2947336, 0.4054232, 0.5678384000000001], 
     {Arrowheads[{{0.020000000000000004`, 1.}}], 
      ArrowBox[{{-1., 0.21655962971395318`}, {-0.9604266790876913, 
       0.20798964599063222`}, {-0.9187387268047997, 
       0.19896171848071625`}, {-0.8958268773547379, 
       0.19399993684774902`}, {-0.8724926097596092, 
       0.18894667649770167`}, {-0.8368205565071545, 
       0.18122154985421365`}}]}, 
     {Arrowheads[{{0.020000000000000004`, 1.}}], 
      ArrowBox[{{-0.8327410704198334, 
       0.18033809785772015`}, {-0.8315161132499456, 
       0.1800728215865938}, {-0.7896410917138096, 
       0.17100438242846439`}, {-0.74761644017653, 
       0.16190353945269317`}, {-0.705192526962997, 
       0.1527162325161536}, {-0.6695616269269878, 0.1450000179979806}}]}, 
     {Arrowheads[{{0.019999999999999993`, 1.}}], 
      ArrowBox[{{-0.6654821408396667, 
       0.14411656600148712`}, {-0.6324274446634099, 
       0.13695825323724972`}, {-0.5965512066663932, 
       0.1291889084210861}, {-0.5610125041045609, 
       0.12149266015378138`}, {-0.5261885165085043, 
       0.11395119029481605`}, {-0.5023026973468213, 
       0.10877848614174752`}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{-0.4982232112595002, 
       0.10789503414525403`}, {-0.4924564234088138, 
       0.10664618070367048`}, {-0.45981622480548984`, 
       0.09957763138034476}, {-0.42826792069853237`, 
       0.09274554232483885}, {-0.3980168809425038, 
       0.08619438835681123}, {-0.3692684753919665, 
       0.0799686442959203}, {-0.3420227040469206, 
       0.07406831014216612}, {-0.33504376776665473`, 
       0.07255695428551448}}]}, 
     {Arrowheads[{{0.015023069707167389`, 1.}}], 
      ArrowBox[{{-0.3309642816793336, 
       0.07167350228902099}, {-0.31627956690736614`, 
       0.0684933858955487}, {-0.28571126097098704`, 
       0.06187352488098359}, {-0.25754047683444015`, 
       0.0557728702996213}, {-0.23176721449772572`, 
       0.05019142215146184}, {-0.20839147396084362`, 0.04512918043650521}}]}}, 
    {RGBColor[0.2947336, 0.4054232, 0.5678384000000001], 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{1., 0.21650223173476651`}, {0.9604314836327702, 
       0.20793555963482757`}, {0.9187433433192131, 0.19890998422007036`}, {
       0.895831083464012, 0.19394942882733243`}, {0.8724964065727072, 
       0.18889741920355527`}, {0.8368186192586868, 0.1811730986267115}}]}, 
     {Arrowheads[{{0.019999999999999997`, 1.}}], 
      ArrowBox[{{0.832739084740154, 0.1802898702990101}, {0.831518928873215, 
       0.18002570383075356`}, {0.7896429355920785, 0.17095945782927743`}, {
       0.7476173705503459, 0.16186082920782774`}, {0.7051925858076677, 
       0.15267576863017085`}, {0.6695577039988408, 0.14496073719095517`}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{0.665478169480308, 0.14407750886325382`}, {
       0.6324270671730069, 0.13692187145242904`}, {0.5965506796682245, 
       0.12915455349106236`}, {0.5610118733718075, 0.12146032261469851`}, {
       0.5261878212070712, 0.11392083760298519`}, {0.5022967887389949, 
       0.1087483757551989}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{0.49821725422046204`, 0.10786514742749752`}, {
       0.4924556960973308, 0.10661775723557004`}, {0.4598154980425865, 
       0.09955108151245312}, {0.42826722704283815`, 0.09272081043363439}, {
       0.3980162422102647, 0.08617140470520766}, {0.369267902657045, 
       0.07994732503326675}, {0.3420222083831791, 0.07404857141781164}, {
       0.33503587347914887`, 0.0725360143194426}}]}, 
     {Arrowheads[{{0.015022173348016131`, 1.}}], 
      ArrowBox[{{0.33095633896061605`, 0.07165278599174121}, {
       0.31627915938866696`, 0.06847514385884232}, {0.28571028330613474`, 
       0.06185691396535057}, {0.25753902963507697`, 0.05575777467480032}, {
       0.23176539837549356`, 0.050177725987191585`}, {0.20838938952738467`, 
       0.045116767902524356`}}]}}, 
    {RGBColor[0.2947336, 0.4054232, 0.5678384000000001], 
     {Arrowheads[{{0.019999999999999997`, 1.}}], 
      ArrowBox[{{0.21650213706015642`, 1.}, {0.20793545747960684`, 
       0.9604314317776492}, {0.1989098869542512, 0.918743295817828}, {
       0.19394933338565812`, 0.8958310343688115}, {0.18889732564034412`, 
       0.8724963559498623}, {0.18117301870950836`, 0.836818616063676}}]}, 
     {Arrowheads[{{0.019999999999999993`, 1.}}], 
      ArrowBox[{{0.18028979075074217`, 0.8327390814652679}, {
       0.18002561416967283`, 0.8315188783547742}, {0.17095937224558172`, 
       0.7896428855946103}, {0.1618607478211313, 0.7476173215609291}, {
       0.1526756915786348, 0.705192538289878}, {0.14496067240009416`, 
       0.6695576975289439}}]}, 
     {Arrowheads[{{0.019999999999999993`, 1.}}], 
      ArrowBox[{{0.14407744444132797`, 0.6654781629305357}, {
       0.13692180231543882`, 0.632427024391885}, {0.12915448835092047`, 
       0.5965506396596634}, {0.1214602614977885, 0.5610118364052915}, {
       0.11392078047491438`, 0.5261877874363003}, {0.10874832609067996`, 
       0.5022967789942118}}]}, 
     {Arrowheads[{{0.019999999999999997`, 1.}}], 
      ArrowBox[{{0.10786509813191376`, 0.49821724439580367`}, {
       0.10661770400116953`, 0.4924556655602209}, {0.09955103207655394, 
       0.4598154707770532}, {0.09272076470106756, 0.4282672030867969}, {
       0.08617136253933964, 0.3980162214999125}, {0.07994728625599937, 
       0.36926788502686014`}, {0.07404853585104676, 0.34202219366764}, {
       0.07253597978126572, 0.3350358604594797}}]}, 
     {Arrowheads[{{0.01502217349758439, 1.}}], 
      ArrowBox[{{0.07165275182249953, 0.3309563258610716}, {
       0.06847511132448175, 0.3162791474222516}, {0.061856883935723514`, 
       0.28571026954129414`}, {0.055757747010972664`, 0.25753901447855004`}, {
       0.050177700550229215`, 0.23176538223401938`}, {0.04511674455349317, 
       0.20838937280770212`}}]}}, 
    {RGBColor[0.2947336, 0.4054232, 0.5678384000000001], 
     {Arrowheads[{{0.020000000000000004`, 1.}}], 
      ArrowBox[{{-1., -0.8152648325160436}, {-0.979044522449642, \
-0.7981805686206572}, {-0.9471584390328074, -0.7721849661642389}, \
{-0.9340225987611068, -0.7614757775451735}, {-0.920524974556006, \
-0.7504716392082376}, {-0.901546332379685, -0.7349990196729773}, \
{-0.8818901963603151, -0.7189740632332332}, {-0.870593735681269, \
-0.7097644561097065}}]}, 
     {Arrowheads[{{0.020000000000000004`, 1.}}], 
      ArrowBox[{{-0.8673585790733007, -0.7071269466995481}, \
{-0.8615104866778311, -0.7023592026322172}, {-0.840422563272255, \
-0.685166960288859}, {-0.8193481221879642, -0.6679857096079055}, \
{-0.7975924320231512, -0.6502490605094183}, {-0.7751554927778168, \
-0.6319570129933981}, {-0.7520373044519606, -0.6131095670598447}, \
{-0.7379523147545697, -0.601626570293211}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{-0.7347171581466014, -0.5989890608830526}, \
{-0.7283025620867445, -0.5937594663006552}, {-0.7040159607233305, \
-0.5739594543077278}, {-0.6791775003617186, -0.5537095310810618}, \
{-0.6537871810019086, -0.5330096966206574}, {-0.628006319086633, \
-0.5119914665491809}, {-0.6053108938278704, -0.49348868447671557`}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{-0.6020757372199022, -0.4908511750665572}, \
{-0.6019962310586235, -0.4907863564892984}, {-0.5757569169178807, \
-0.4693943664410098}, {-0.5492883766644041, -0.44781549640431506`}, \
{-0.5310408110576191, -0.43293889788607404`}, {-0.5128146563734838, \
-0.4180797549401008}, {-0.4946566389650745, -0.40327616191881066`}, \
{-0.4766134851854682, -0.3885662131746187}, {-0.4726694729011712, \
-0.3853507986602201}}]}, 
     {Arrowheads[{{0.019999999999999997`, 1.}}], 
      ArrowBox[{{-0.46943431629320287`, -0.38271328925006165`}, \
{-0.4587319213877421, -0.3739880030599406}, {-0.4410586739249728, \
-0.3595796259271914}, {-0.4236404691502371, -0.34537917612878627`}, \
{-0.4065240334166119, -0.3314247480171407}, {-0.3732503160524512, \
-0.304297856403062}, {-0.34140224083452764`, -0.2783332406945632}, \
{-0.34002805197447195`, -0.2772129128437245}}]}, 
     {Arrowheads[{{0.003949318373205092, 1.}}], 
      ArrowBox[{{-0.33679289536650364`, -0.27457540343356607`}, \
{-0.3112395685024137, -0.25374267468748607`}}]}}, 
    {RGBColor[0.2947336, 0.4054232, 0.5678384000000001], 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{-0.8152653547381127, -1.}, {-0.7981795426978792, \
-0.9790426369268175}, {-0.7721837739127062, -0.9471563699168285}, \
{-0.7614745425383344, -0.9340204856159287}, {-0.7504703603831099, \
-0.9205228163095232}, {-0.7349976994659219, -0.9015441355312159}, \
{-0.7189727015073177, -0.8818879611758714}, {-0.7097649377355498, \
-0.8705937687779548}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{-0.7071274273104857, -0.8673586129974037}, \
{-0.7023578004265019, -0.8615082148954065}, {-0.685165518250406, \
-0.8404202561391823}, {-0.6679842285351865, -0.8193457806750081}, \
{-0.650247542646439, -0.7975900593191744}, {-0.6319554605841643, \
-0.7751530920716814}, {-0.613107982348362, -0.7520348789325291}, \
{-0.6016270103079229, -0.7379523817753585}}]}, 
     {Arrowheads[{{0.020000000000000004`, 1.}}], 
      ArrowBox[{{-0.5989894998828588, -0.7347172259948074}, \
{-0.5937578530142147, -0.728300116720828}, {-0.573957817656905, \
-0.7040135022556886}, {-0.5537078762764328, -0.6791750355371107}, \
{-0.5330080288727982, -0.6537847165650945}, {-0.5119897923940793, \
-0.6280038633047832}, {-0.49348908288029586`, -0.6053109947727622}}]}, 
     {Arrowheads[{{0.020000000000000004`, 1.}}], 
      ArrowBox[{{-0.49085157245523175`, -0.6020758389922111}, \
{-0.4907846837883537, -0.6019937937213194}, {-0.46939270305562175`, \
-0.5757545078147036}, {-0.4478138501958835, -0.5492860055849357}, \
{-0.43293726386401826`, -0.5310384666144566}, {-0.41807813639405544`, \
-0.5128123425879596}, {-0.4032745622498715, -0.4946543599653087}, \
{-0.3885646358953428, -0.4766112452063675}, {-0.38535115545266885`, \
-0.47266960777016587`}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{-0.3827136450276048, -0.46943445198961475`}, \
{-0.3739864517943459, -0.45872972477099977`}, {-0.3595781044107574, \
-0.4410565251190693}, {-0.34537768820845355`, -0.4236383727104398}, \
{-0.33142329765131096`, -0.4065219940049751}, {-0.30429648968582784`, \
-0.3732484005573582}, {-0.2783319650733107, -0.34140045747769954`}, \
{-0.27721322802504195`, -0.34002822076756956`}}]}, 
     {Arrowheads[{{0.003949599998155943, 1.}}], 
      ArrowBox[{{-0.27457571759997784`, -0.33679306498701844`}, \
{-0.25374149526003914`, -0.3112379224572206}}]}}, 
    {RGBColor[0.2947336, 0.4054232, 0.5678384000000001], 
     {Arrowheads[{{0.019999999999999997`, 1.}}], 
      ArrowBox[{{1., -0.8152148725397581}, {
       0.9790347818741747, -0.7981237149175452}, {
       0.9471439336827869, -0.7721258211740183}, {
       0.9340067928900885, -0.7614162286171618}, {
       0.9205078352001896, -0.7504116775445714}, {
       0.9015278065513945, -0.7349388759088429}, {
       0.8818702676167515, -0.7189137578117926}, {
       0.8705905693658966, -0.7097183800399349}}]}, 
     {Arrowheads[{{0.019999999999999993`, 1.}}], 
      ArrowBox[{{0.867355333600044, -0.7070809677274393}, {
       0.8614891674233773, -0.7022987818154309}, {
       0.8403998562955663, -0.6851064617324213}, {
       0.8193240480368705, -0.6679251493891362}, {
       0.7975670345819681, -0.6501885084386522}, {
       0.7751288159308592, -0.6318965388809692}, {
       0.7520093920835438, -0.6130492407160872}, {
       0.7379459029659406, -0.6015844752276162}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{0.734710667200088, -0.5989470629151206}, {
       0.7282734971689038, -0.5936993861686319}, {
       0.7039858653158213, -0.5738997474632287}, {
       0.6791464965242963, -0.5536503245998776}, {
       0.6537553907943289, -0.5329511175785787}, {
       0.627973901769441, -0.5119336642892696}, {
       0.6053012365659847, -0.49345057041529733`}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{0.6020660008001321, -0.4908131581028018}, {
       0.6019633830931548, -0.49072950262188797`}, {
       0.5757238347654704, -0.46933863257643377`}, {
       0.5492552567863875, -0.4477610541529071}, {
       0.5310076882586625, -0.4328853649014172}, {
       0.5127816152969887, -0.41802719915506603`}, {
       0.4946237679835147, -0.4032246519718159}, {
       0.4765808764003886, -0.38851581840962907`}, {
       0.47265657016602874`, -0.3853166656029784}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{0.46942133440017614`, -0.3826792532904828}, {
       0.4586996706297587, -0.37393879352646786`}, {
       0.44102688075377333`, -0.35953167238029443`}, {
       0.42360923685458063`, -0.3453325500290712}, {
       0.4064934690143291, -0.33137952153076045`}, {
       0.3732213239884832, -0.30425557406439113`}, {
       0.341375038282229, -0.27829400832150236`}, {
       0.34001190376607276`, -0.2771827607906595}}]}, 
     {Arrowheads[{{0.003950616368971417, 1.}}], 
      ArrowBox[{{0.33677666800022016`, -0.2745453484781639}, {
       0.31121431725210214`, -0.25370653997122034`}}]}}, 
    {RGBColor[0.2947336, 0.4054232, 0.5678384000000001], 
     {Arrowheads[{{0.019999999999999997`, 1.}}], 
      ArrowBox[{{-0.8152145919923026, 1.}, {-0.7981234743778869, 
       0.9790348237356171}, {-0.7721255770131858, 
       0.9471439601273434}, {-0.7614159844707615, 
       0.9340068148313408}, {-0.7504114334193215, 
       0.9205078525218636}, {-0.7349386328643261, 
       0.9015278186669968}, {-0.7189135159590805, 
       0.8818702744293724}, {-0.7097181213031442, 0.8705905515855213}}]}, 
     {Arrowheads[{{0.020000000000000004`, 1.}}], 
      ArrowBox[{{-0.7070807095359152, 
       0.8673553153751594}, {-0.7022985413403265, 
       0.86148916891193}, {-0.6851062227958169, 
       0.8403998524136894}, {-0.6679249120343508, 
       0.819324038842349}, {-0.650188272913216, 
       0.7975670201440107}, {-0.6318963054324127, 
       0.7751287963186746}, {-0.6130490095919406, 
       0.7520093673663406}, {-0.6015842388467569, 0.7379458669606805}}]}, 
     {Arrowheads[{{0.020000000000000004`, 1.}}], 
      ArrowBox[{{-0.598946827079528, 
       0.7347106307503186}, {-0.5936991576905968, 
       0.728273467529152}, {-0.5738995220271778, 
       0.7039858310492519}, {-0.5536501026016836, 
       0.6791464579266406}, {-0.5329508994141142, 
       0.6537553481613179}, {-0.5119334504037357, 
       0.6279738555128436}, {-0.4934503563903697, 0.6053011823358397}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{-0.49081294462314073`, 
       0.6020659461254778}, {-0.4907292935098139, 
       0.6019633337407775}, {-0.469338428732349, 
       0.5757237828451197}, {-0.4477608560713408, 
       0.54925520282587}, {-0.43288517087188805`, 
       0.5310076329889538}, {-0.4180270093647029, 
       0.5127815589550317}, {-0.4032244666059348, 
       0.4946237108201105}, {-0.3885156376517341, 
       0.47658081868019697`}, {-0.3853164739339825, 0.472656497710999}}]}, 
     {Arrowheads[{{0.020000000000000004`, 1.}}], 
      ArrowBox[{{-0.38267906216675357`, 
       0.469421261500637}, {-0.37393861755825053`, 
       0.4586996126312978}, {-0.35953150138163414`, 
       0.44102682276942007`}, {-0.3453323841780347, 
       0.4236091791905702}, {-0.33137936100360227`, 
       0.40649341199075517`}, {-0.30425542451024545`, 
       0.3732212689749283}, {-0.2782938699189745, 
       0.3413749859884774}, {-0.27718259147759533`, 
       0.34001181308615813`}}]}, 
     {Arrowheads[{{0.003950609315750829, 1.}}], 
      ArrowBox[{{-0.27454517971036635`, 
       0.33677657687579615`}, {-0.2537064127161952, 0.31121426825317533`}}]}}, 
    {RGBColor[0.2947336, 0.4054232, 0.5678384000000001], 
     {Arrowheads[{{0.020000000000000004`, 1.}}], 
      ArrowBox[{{0.8253162422522383, -1.}, {
       0.8125920254600529, -0.9845826167706795}, {
       0.78733727628163, -0.9539825293308586}, {
       0.7767960261225221, -0.9412101523686152}, {
       0.7659639552629796, -0.9280854005401737}, {
       0.750602105380011, -0.9094721113589903}, {
       0.7346837316503413, -0.8901845062995898}, {
       0.7190402403192409, -0.8712299643552678}}]}, 
     {Arrowheads[{{0.019999999999999993`, 1.}}], 
      ArrowBox[{{0.716383340270916, -0.8680107134641495}, {
       0.7010569865167452, -0.8494404334072029}, {
       0.6839564234651401, -0.828720420670099}, {
       0.6662814794439207, -0.8073044553511741}, {
       0.6480321544530874, -0.7851925374504286}, {
       0.6292084484926398, -0.7623846669678619}, {
       0.6101073383379187, -0.7392406778194172}}]}, 
     {Arrowheads[{{0.020000000000000004`, 1.}}], 
      ArrowBox[{{0.6074504382895938, -0.7360214269282989}, {
       0.5900132652247644, -0.7148935583948449}, {
       0.5696856308078022, -0.6902634428387895}, {
       0.548871301202157, -0.6650436197697024}, {
       0.5276943095814354, -0.6393843748202381}, {
       0.5062786891192439, -0.6134359936230505}, {
       0.5011744363565965, -0.6072513912835664}}]}, 
     {Arrowheads[{{0.020000000000000004`, 1.}}], 
      ArrowBox[{{0.4985175363082716, -0.6040321403924481}, {
       0.48462443981558256`, -0.5871984761781396}, {
       0.4627315616704514, -0.5606718224855056}, {
       0.44762134806884896`, -0.542363430104462}, {
       0.43250769672087797`, -0.5240508723548086}, {
       0.417428368797041, -0.5057799028138648}, {
       0.4024211254678407, -0.4875962750589493}, {
       0.3922415343752743, -0.4752621047477158}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{0.3895846343269494, -0.4720428538565975}, {
       0.3875237279037797, -0.4695457426673816}, {
       0.37277393727536057`, -0.45167405921648063`}, {
       0.35820951475308593`, -0.43402697828356546`}, {
       0.34386822150745844`, -0.41665025344595535`}, {
       0.32976808094273846`, -0.3995657228831719}, {
       0.3159210433043427, -0.38278786619079896`}, {
       0.3023557600245081, -0.36635139907024916`}, {
       0.2891008825354715, -0.350291037222935}, {
       0.28330863239395215`, -0.3432728182118651}}]}, 
     {Arrowheads[{{0.00320199882897615, 1.}}], 
      ArrowBox[{{0.28065173234562724`, -0.3400535673207468}, {
       0.26363695065874104`, -0.3194374921536643}}]}}, 
    {RGBColor[0.2947336, 0.4054232, 0.5678384000000001], 
     {Arrowheads[{{0.019999999999999993`, 1.}}], 
      ArrowBox[{{-1., 0.8253173409896326}, {-0.984582744166416, 
       0.8125932123997022}, {-0.9539827399815836, 
       0.7873384983116046}, {-0.941210388839178, 
       0.7767972554285685}, {-0.9280856635209707, 
       0.7659651920277264}, {-0.9094724013328398, 
       0.7506033439714753}, {-0.8901848236355887, 
       0.7346849716322491}, {-0.8712300338134458, 0.7190412548972207}}]}, 
     {Arrowheads[{{0.020000000000000004`, 1.}}], 
      ArrowBox[{{-0.8680107846587819, 
       0.7163843527449104}, {-0.8494408052091792, 
       0.7010582266833322}, {-0.8287208193449743, 
       0.6839576630445438}, {-0.8073048801787688, 
       0.6662827170770952}, {-0.7851929877105629, 
       0.6480333887809869}, {-0.7623851419403566, 
       0.6292096781562185}, {-0.7392408184722277, 0.6101082666524984}}]}, 
     {Arrowheads[{{0.020000000000000004`, 1.}}], 
      ArrowBox[{{-0.7360215693175638, 
       0.6074513645001881}, {-0.7148940776927898, 
       0.590014479290649}, {-0.6902639810151413, 
       0.5696868333923345}, {-0.6650441746349159, 
       0.5488724898503335}, {-0.6393849434381196, 
       0.5276954813871553}, {-0.613436572310758, 
       0.5062798407253091}, {-0.6072516031310095, 0.5011752784077762}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{-0.6040323539763456, 
       0.4985183762554659}, {-0.5871990612528311, 
       0.4846255678647948}, {-0.560672410264339, 
       0.46273266280561254`}, {-0.542364017412019, 
       0.4476224286989422}, {-0.5240514575783113, 
       0.43250875551027307`}, {-0.505780484269794, 
       0.417429404401995}, {-0.4875968509930459, 
       0.4024221365364986}, {-0.4752623877897913, 0.392242290163054}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{-0.4720431386351274, 
       0.3895853880107437}, {-0.4695463112546453, 
       0.3875247130761741}, {-0.4516746185611704, 
       0.37277489518341156`}, {-0.4340275264191997, 
       0.35821044402060126`}, {-0.4166507883353118, 
       0.3438691207501336}, {-0.3995662428689702, 
       0.3297689491138361}, {-0.38278837013437245`, 
       0.3159218798010554}, {-0.36635188597019797`, 
       0.3023565643954607}, {-0.3502915062151256, 
       0.2891016544807207}, {-0.34327317244857314`, 
       0.28330930191833187`}}]}, 
     {Arrowheads[{{0.0032019888825685215`, 1.}}], 
      ArrowBox[{{-0.34005392329390927`, 
       0.2806523997660216}, {-0.3194379232870057, 0.26363765745848167`}}]}}, 
    {RGBColor[0.2947336, 0.4054232, 0.5678384000000001], 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{0.8252353782498095, 1.}, {0.812520123016561, 
       0.9845919654338917}, {0.7872643455816536, 0.9539876335056232}, {
       0.7767230033588264, 0.941213893430175}, {0.7658908386985223, 
       0.9280877418547575}, {0.7505292421260529, 0.9094729357311412}, {
       0.7346111532485877, 0.890183785875224}, {0.7189655705884455, 
       0.8712248523727316}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{0.7163088253969113, 0.8680054736820499}, {0.7009851331282887,
        0.8494365990645781}, {0.6838849694138324, 0.8287150399007879}, {
       0.6662104983907622, 0.8072975492200624}, {0.6479617200590783, 
       0.7851841270224021}, {0.6291386344187804, 0.7623747733078067}, {
       0.6100390177355474, 0.7392303260547815}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{0.6073822725440132, 0.7360109473640998}, {0.5899450085464277,
        0.71488089834152}, {0.569618335147894, 0.6902495338432562}, {
       0.5488050881077884, 0.6650285513349116}, {0.5276293185718157, 
       0.6393682729536295}, {0.5062150776856803, 0.613419020836553}, {
       0.5011124648826493, 0.6072357997368313}}]}, 
     {Arrowheads[{{0.020000000000000004`, 1.}}], 
      ArrowBox[{{0.4984557196911152, 0.6040164210461496}, {
       0.48456236544938225`, 0.5871807949836816}, {0.4626711818629214, 
       0.5606535953950158}, {0.44756223101544246`, 0.5423449391671132}, {
       0.4324499032478919, 0.524032190870256}, {0.4173719593016551, 
       0.5057611080451174}, {0.4023661599181173, 0.4875774482323708}, {
       0.3921859120297513, 0.47524127341888106`}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{0.3895291668382172, 0.47202189472819933`}, {
       0.38747026583866395`, 0.46952696897268964`}, {0.37272203780468033`, 
       0.45165542780674706`}, {0.35815923655755183`, 0.43400858227521666`}, {
       0.34381962283866374`, 0.4166321899187715}, {0.3297212043123838, 
       0.39954807198361897`}, {0.3158759107732281, 0.38277068470228426`}, {
       0.3023123861578045, 0.36633473809491796`}, {0.28905927440272094`, 
       0.3502749421816705}, {0.2832593591768533, 0.34324674710093084`}}]}, 
     {Arrowheads[{{0.0032001090694539934`, 1.}}], 
      ArrowBox[{{0.2806026139853192, 0.3400273684102491}, {0.2635988652200061,
        0.3194226425181342}}]}}, 
    {RGBColor[0.2947336, 0.4054232, 0.5678384000000001], 
     {Arrowheads[{{0.020000000000000004`, 1.}}], 
      ArrowBox[{{1., 0.8252355243557291}, {0.984591936874716, 
       0.8125202433032294}, {0.9539876114424797, 0.7872644667576043}, {
       0.9412138734952262, 0.7767231244247199}, {0.9280877241053591, 
       0.7658909596502014}, {0.9094729204299624, 0.7505293623783564}, {
       0.8901837730730225, 0.7346112727448771}, {0.871224861609212, 
       0.7189657055018255}}]}, 
     {Arrowheads[{{0.019999999999999997`, 1.}}], 
      ArrowBox[{{0.8680054831494423, 0.716308960030478}, {0.8494365913312867, 
       0.7009852508542175}, {0.8287150346928712, 0.6838850861962478}, {
       0.8072975465193604, 0.6662106141129978}, {0.7851841268107544, 
       0.6479618346044681}, {0.7623747755670532, 0.6291387476706584}, {
       0.7392303447586543, 0.6100391411765743}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{0.7360109662988846, 0.6073823957052268}, {0.7148809052902397,
        0.5899451187290892}, {0.6902495429610961, 0.5696184435218024}, {
       0.6650285625047944, 0.5488051944901806}, {0.6393682860040151, 
       0.527629422756947}, {0.6134190355414382, 0.5062151794448243}, {
       0.6072358279080966, 0.5011125768513233}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{0.6040164494483269, 0.4984558313799757}, {0.587180811117064, 
       0.48456246455381263`}, {0.5606536127308924, 0.4626712780839119}, {
       0.5423449571657812, 0.44756232510838895`}, {0.5240322094275623, 
       0.43244999512624566`}, {0.5057611270505227, 0.4173720488802826}, {
       0.4875774675689485, 0.40236624711329977`}, {0.4752413110575388, 
       0.3921860125260722}}]}, 
     {Arrowheads[{{0.020000000000000004`, 1.}}], 
      ArrowBox[{{0.4720219325977691, 0.3895292670547246}, {
       0.46952698851712693`, 0.3874703505680977}, {0.4516554474293443, 
       0.3727221199874765}, {0.43400860183988726`, 0.35815931611423624`}, {
       0.4166322092830425, 0.3438196996911775}, {0.39954809102873995`, 
       0.3297212784054328}, {0.382770703342492, 0.31587598208085266`}, {
       0.36633475625195916`, 0.30231245466531376`}, {0.35027495978480183`, 
       0.2890593401066929}, {0.34324679420698107`, 0.28325944820082105`}}]}, 
     {Arrowheads[{{0.0032001141172805433`, 1.}}], 
      ArrowBox[{{0.34002741574721135`, 0.28060270272947346`}, {
       0.31942265883125553`, 0.2635989253517123}}]}}, 
    {RGBColor[0.2947336, 0.4054232, 0.5678384000000001], 
     {Arrowheads[{{0.019999999999999997`, 1.}}], 
      ArrowBox[{{-1., -0.5236542009929507}, {-0.9950388707478317, \
-0.5210562848183837}, {-0.9610108466564895, -0.5032373670514632}, \
{-0.9429512588505804, -0.4937803880286977}, {-0.9244374293277676, \
-0.4840855434226095}, {-0.898525255021406, -0.47051652449022163`}, \
{-0.8718268302370735, -0.45653578219201163`}, {-0.8520903501170134, \
-0.4462006914643283}}]}, 
     {Arrowheads[{{0.019999999999999997`, 1.}}], 
      ArrowBox[{{-0.8483926088699387, -0.4442643537261127}, \
{-0.8444333858088415, -0.442191089937501}, {-0.8163145114586863, \
-0.4274665232568493}, {-0.7883041736078618, -0.4127987921700332}, \
{-0.7597854788337755, -0.39786485784474723`}, {-0.7307584271364276, \
-0.3826647202809914}, {-0.701223018515818, -0.3671983794787658}, \
{-0.7004829589869521, -0.3668108441974903}}]}, 
     {Arrowheads[{{0.020000000000000004`, 1.}}], 
      ArrowBox[{{-0.6967852177398774, -0.36487450645927477`}, \
{-0.6714017159156975, -0.35158232909313075`}, {-0.6415169822798173, \
-0.3359330627791467}, {-0.6115688176081772, -0.3202505805368136}, \
{-0.5815572219007769, -0.30453488236613147`}, {-0.5517597289780596, \
-0.28893130001809286`}, {-0.5488755678568908, -0.2874209969306523}}]}, 
     {Arrowheads[{{0.019999999999999997`, 1.}}], 
      ArrowBox[{{-0.5451778266098162, -0.28548465919243676`}, \
{-0.5224538726604683, -0.27358516524369036`}, {-0.49363965294800294`, \
-0.25849647804292397`}, {-0.4653170698406635, -0.2436652384157937}, \
{-0.4429241392537501, -0.231939086241413}, {-0.42096022795023613`, \
-0.22043759181709133`}, {-0.39950528962111, -0.2092026232289997}, \
{-0.3972681767268296, -0.2080311496638143}}]}, 
     {Arrowheads[{{0.0047499657875698315`, 1.}}], 
      ArrowBox[{{-0.39357043547975495`, -0.20609481192559875`}, \
{-0.37863927795735985`, -0.1982760485633091}, {-0.35844214664997404`, \
-0.1876997359061902}}]}}, 
    {RGBColor[0.2947336, 0.4054232, 0.5678384000000001], 
     {Arrowheads[{{0.019999999999999997`, 1.}}], 
      ArrowBox[{{-0.5236553155244519, -1.}, {-0.521056614044749, \
-0.9950373816465509}, {-0.5032376390160227, -0.9610093206291999}, \
{-0.4937806311897071, -0.94294971625596}, {-0.48408575742666843`, \
-0.9244358704577387}, {-0.4705166930595953, -0.8985236645375458}, \
{-0.4565359048152351, -0.8718252088360924}, {-0.44620167662204546`, \
-0.852090417864211}}]}, 
     {Arrowheads[{{0.019999999999999997`, 1.}}], 
      ArrowBox[{{-0.4442653356494853, -0.8483926783108163}, \
{-0.44219116715385043`, -0.8444317359998277}, {-0.4274665552553538, \
-0.8163128351466021}, {-0.4127987796080724, -0.7883024718170686}, \
{-0.3978648022261094, -0.7597837555179582}, {-0.3826646231094648, \
-0.7307566862492708}, {-0.36719824225813874`, -0.7012212640110068}, \
{-0.36681169674707886`, -0.7004830961750274}}]}, 
     {Arrowheads[{{0.019999999999999993`, 1.}}], 
      ArrowBox[{{-0.3648753557745187, -0.6967853566216327}, \
{-0.351582154240724, -0.6713999530179638}, {-0.3359328536258135, \
-0.6415152174849398}, {-0.3202503404134073, -0.6115670574119347}, \
{-0.3045346146035053, -0.5815554727989487}, {-0.2889310083589357, \
-0.5517579976621936}, {-0.2874217168721123, -0.5488757744858437}}]}, 
     {Arrowheads[{{0.019999999999999997`, 1.}}], 
      ArrowBox[{{-0.28548537589955214`, -0.545178034932449}, \
{-0.273584853842527, -0.5224521660178814}, {-0.258496151054279, \
-0.49363797786601216`}, {-0.24366489999419175`, -0.46531543320658586`}, \
{-0.231938688741194, -0.44292243746041704`}, {-0.22043713925293668`, \
-0.4209584677511852}, {-0.20920212007569058`, -0.3995034784783388}, \
{-0.20803173699714578`, -0.39726845279665995`}}]}, 
     {Arrowheads[{{0.0047502607872175785`, 1.}}], 
      ArrowBox[{{-0.20609539602458563`, -0.3935707132432652}, \
{-0.1982754997557264, -0.3786374240413263}, {-0.18769914683931505`, \
-0.3584402588395964}}]}}, 
    {RGBColor[0.2947336, 0.4054232, 0.5678384000000001], 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{1., -0.5236451558802413}, {
       0.9950209688613126, -0.5210379103434908}, {
       0.960991721501368, -0.5032186598052053}, {
       0.942931540245985, -0.49376153337650486`}, {
       0.9244171169840821, -0.484066545321493}, {
       0.8985038590282836, -0.47049719331986395`}, {
       0.8718043502081428, -0.4565161248618155}, {
       0.852089800308479, -0.44619269630649716`}}]}, 
     {Arrowheads[{{0.019999999999999997`, 1.}}], 
      ArrowBox[{{0.8483920453161911, -0.44425638481715357`}, {
       0.8444098615188267, -0.44217113356183896`}, {
       0.8162899692952795, -0.42744628821510405`}, {
       0.7882786376741177, -0.4127782901019276}, {
       0.759759023723495, -0.3978441324091095}, {
       0.7307311274434121, -0.3826438151366499}, {
       0.7011949488338682, -0.36717733828454874`}, {
       0.7004818456246701, -0.3668039252434095}}]}, 
     {Arrowheads[{{0.019999999999999997`, 1.}}], 
      ArrowBox[{{0.6967840906323821, -0.3648676137540659}, {
       0.6713729828265844, -0.3515612102460093}, {
       0.6414877243532808, -0.33591193941423503`}, {
       0.6115391734139574, -0.32022952578922564`}, {
       0.5815273300086142, -0.30451396937098135`}, {
       0.5517297380882524, -0.2889106047049877}, {
       0.5488738909408611, -0.2874151541803218}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{0.5451761359485731, -0.28547884269097823`}, {
       0.522423941603873, -0.2735647663367302}, {
       0.4936099405554759, -0.2584764542662089}, {
       0.4652877349430613, -0.24364566849342376`}, {
       0.44289307581904297`, -0.2319188137255423}, {
       0.42092758909285855`, -0.22041669300482408`}, {
       0.3994712450563888, -0.20918118238722683`}, {
       0.3972659362570521, -0.20802638311723406`}}]}, 
     {Arrowheads[{{0.00475454905989991, 1.}}], 
      ArrowBox[{{0.39356818126476406`, -0.20609007162789048`}, {
       0.3786040140015148, -0.19825415792870832`}, {
       0.3584058662201176, -0.18767749568522643`}}]}}, 
    {RGBColor[0.2947336, 0.4054232, 0.5678384000000001], 
     {Arrowheads[{{0.020000000000000004`, 1.}}], 
      ArrowBox[{{-0.5236450226826012, 1.}, {-0.5210377759668445, 
       0.995020965343278}, {-0.5032185274456753, 
       0.960991713179508}, {-0.4937614021525481, 
       0.9429315294988174}, {-0.48406641528193434`, 
       0.9244171037893036}, {-0.47049706446304884`, 
       0.89850384150072}, {-0.45651599726556397`, 
       0.871804328296411}, {-0.4461925785705, 0.8520897922120656}}]}, 
     {Arrowheads[{{0.019999999999999997`, 1.}}], 
      ArrowBox[{{-0.4442562674676975, 
       0.8483920370173672}, {-0.442171007352281, 
       0.844409835287016}, {-0.4274461635022661, 
       0.8162899387689887}, {-0.412778166909975, 
       0.7882786029271088}, {-0.3978440108963992, 
       0.7597589849288913}, {-0.382643695461539, 
       0.7307310847743365}, {-0.3671772206053942, 
       0.7011949024634437}, {-0.36680382335559625`, 0.7004818292294329}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{-0.36486751225279374`, 
       0.6967840740347345}, {-0.3515610947460527, 
       0.671372933032051}, {-0.3359118263016022, 
       0.6414876715159952}, {-0.32022941527204263`, 
       0.6115391179152764}, {-0.30451386165737415`, 
       0.5815272722298944}, {-0.2889104999910027, 
       0.5517296784583803}, {-0.28741506814069256`, 0.5488738662468001}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{-0.28547875703789005`, 
       0.5451761110521017}, {-0.2735646648063342, 
       0.5224238805992643}, {-0.25847635610336867`, 
       0.4936098786525466}, {-0.24364557388210628`, 
       0.46528767261822734`}, {-0.23191871902124933`, 
       0.4428930076202083}, {-0.22041659838667138`, 
       0.42092751547124574`}, {-0.2091810880501719, 
       0.3994711665138153}, {-0.20802631292578888`, 
       0.39726590326416733`}}]}, 
     {Arrowheads[{{0.004754556031241722, 1.}}], 
      ArrowBox[{{-0.20609000182298634`, 
       0.393568148069469}, {-0.1982540640835503, 
       0.37860393109039214`}, {-0.1876774025586062, 0.358405779543452}}]}}, 
    {RGBColor[0.2947336, 0.4054232, 0.5678384000000001], 
     {Arrowheads[{{0.020000000000000004`, 1.}}], 
      ArrowBox[{{0.5452307504000544, 1.}, {0.5288764562239096, 
       0.9700048205935831}, {0.5193445719389241, 0.9525225265777162}, {
       0.5095673458547847, 0.9345902546415396}, {0.49597972383252437`, 
       0.9096693894623642}, {0.4819673427680373, 0.8839694797375264}, {
       0.467563613098195, 0.8575518030762709}, {0.46530592391483794`, 
       0.8534110073091566}}]}, 
     {Arrowheads[{{0.019999999999999997`, 1.}}], 
      ArrowBox[{{0.46330780325270754`, 0.8497462824918856}, {
       0.4527573980107069, 0.8303959336088494}, {0.43800013130610593`, 
       0.8033298396774762}, {0.4229382759496334, 0.7757051040120335}, {
       0.40757183194128943`, 0.7475217266125213}, {0.39190079928107385`, 
       0.7187797074789394}, {0.38338297676749095`, 0.7031572898010423}}]}, 
     {Arrowheads[{{0.019999999999999997`, 1.}}], 
      ArrowBox[{{0.38138485610536055`, 0.6994925649837712}, {
       0.37603203107838457`, 0.6896750243864215}, {0.36007238044261924`, 
       0.660403655110101}, {0.34402184737377794`, 0.630965599649978}, {
       0.32788043187186067`, 0.6013608580060524}, {0.31179316129956525`, 
       0.5718554228109691}, {0.30146002962014395`, 0.552903572292928}}]}, 
     {Arrowheads[{{0.019999999999999997`, 1.}}], 
      ArrowBox[{{0.29946190895801356`, 0.5492388474756569}, {
       0.29590506301958963`, 0.5427152866973733}, {0.28021613703193377`, 
       0.5139404496652648}, {0.2647263833365977, 0.48553091171464346`}, {
       0.25314025118197453`, 0.46428095076485837`}, {0.2417325438944704, 
       0.44335823633773946`}, {0.23054131595942226`, 0.42283256362607236`}, {
       0.219604621862167, 0.40277372782264304`}, {0.21953708247279693`, 
       0.40264985478481363`}}]}, 
     {Arrowheads[{{0.004727419381205136, 1.}}], 
      ArrowBox[{{0.21753896181066654`, 0.39898512996754254`}, {
       0.20896051608804164`, 0.38325152412023733`}, {0.198647053122383, 
       0.364335747711641}}]}}, 
    {RGBColor[0.2947336, 0.4054232, 0.5678384000000001], 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{1., 0.5452309201891676}, {0.9700047982634734, 
       0.5288766087451015}, {0.9525225066400523, 0.5193447227962481}, {
       0.9345902371330291, 0.5095674949918537}, {0.9096693759011414, 
       0.495979870890485}, {0.8839694701943397, 0.4819674876531907}, {
       0.8575517975426707, 0.46756375568406505`}, {0.8534110177698144, 
       0.4653060745182099}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{0.8497462932140598, 0.46330795337643593`}, {
       0.8303959321027856, 0.45275753818174325`}, {0.8033298421444462, 
       0.4380002690478352}, {0.7757051103609822, 0.42293841111755803`}, {
       0.7475217367523934, 0.4075719643909121}, {0.71877972131868, 
       0.39190092886789724`}, {0.7031573109838741, 0.38338310770547834`}}]}, 
     {Arrowheads[{{0.020000000000000004`, 1.}}], 
      ArrowBox[{{0.6994925864281195, 0.3813849865637044}, {0.6896750417502228,
        0.3760321576449765}, {0.6604036757374027, 0.36007250381861267`}, {
       0.6309656232802195, 0.34402196738880575`}, {0.6013608843786735, 
       0.32788054835555575`}, {0.5718554516119925, 0.31179327409759866`}, {
       0.5529036041979338, 0.30146014089274675`}}]}, 
     {Arrowheads[{{0.019999999999999997`, 1.}}], 
      ArrowBox[{{0.5492388796421792, 0.2994620197509728}, {0.542715317559404, 
       0.2959051719936701}, {0.5139404822209083, 0.2802162420437703}, {
       0.4855309455965055, 0.2647264842478993}, {0.464280988086354, 
       0.2531403503606587}, {0.4433582768440815, 0.24173264125718222`}, {
       0.42283260703749087`, 0.23054141142103576`}, {0.4027737738343847, 
       0.21960471533578516`}, {0.4026498974119936, 0.2195371740800151}}]}, 
     {Arrowheads[{{0.004727418721277736, 1.}}], 
      ArrowBox[{{0.39898517285623897`, 0.21753905293824116`}, {
       0.3832515724025659, 0.20896060748499634`}, {0.3643357979098375, 
       0.19864714235223524`}}]}}, 
    {RGBColor[0.2947336, 0.4054232, 0.5678384000000001], 
     {Arrowheads[{{0.019999999999999997`, 1.}}], 
      ArrowBox[{{0.5453000448911443, -1.}, {
       0.5289301097165934, -0.969979948969528}, {
       0.5193973425082605, -0.9524982573803848}, {
       0.5096192099473711, -0.934566601858806}, {
       0.4960304087597802, -0.9096467411052579}, {
       0.4820168114810973, -0.8839478668616653}, {
       0.46761182820410596`, -0.8575312483193598}, {
       0.465367388644621, -0.8534152766070652}}]}, 
     {Arrowheads[{{0.019999999999999997`, 1.}}], 
      ArrowBox[{{0.4633690722384579, -0.8497506585222419}, {
       0.4528043222312116, -0.8303764624145644}, {
       0.438045766603516, -0.8033114442361015}, {
       0.42298258897031527`, -0.7756877941478132}, {
       0.4076147893316091, -0.7475055121496998}, {
       0.39194236768739776`, -0.7187645982417613}, {
       0.3834364159919346, -0.703165935129307}}]}, 
     {Arrowheads[{{0.019999999999999993`, 1.}}], 
      ArrowBox[{{0.3814380995857715, -0.6995013170444837}, {
       0.37607218281910487`, -0.6896610156967407}, {
       0.3601110935081543, -0.660390727787381}, {
       0.34405909975454607`, -0.6309537345136822}, {
       0.32791620155828016`, -0.6013500358756444}, {
       0.3118274369593534, -0.5718456102852549}, {
       0.3015054433392482, -0.5529165936515489}}]}, 
     {Arrowheads[{{0.020000000000000004`, 1.}}], 
      ArrowBox[{{0.2995071269330851, -0.5492519755667256}, {
       0.29593784399776235`, -0.542706436154501}, {
       0.2802474226735072, -0.5139325134833826}, {
       0.26475617298658793`, -0.48552384227189993`}, {
       0.2531690218839456, -0.4642747130792635}, {
       0.2417602999604098, -0.4433527967316988}, {
       0.23056806420534998`, -0.42282788414473205`}, {
       0.21963037160813548`, -0.40276976623388916`}, {
       0.21957447068656183`, -0.4026672521737907}}]}, 
     {Arrowheads[{{0.0047303095689381095`, 1.}}], 
      ArrowBox[{{0.21757615428039875`, -0.3990026340889673}, {
       0.2089852791581358, -0.3832482339146964}, {
       0.19867084384472028`, -0.36433307810268}}]}}, 
    {RGBColor[0.2947336, 0.4054232, 0.5678384000000001], 
     {Arrowheads[{{0.019999999999999997`, 1.}}], 
      ArrowBox[{{-1., 0.545302054086487}, {-0.969979452896947, 
       0.528931788086392}, {-0.9524977841178474, 
       0.5193989981922894}, {-0.9345661518260943, 
       0.5096208422704728}, {-0.9096463288596517, 
       0.4960320116194}, {-0.8839474932724192, 
       0.4820183837860513}, {-0.8575309136702078, 
       0.4676133686670262}, {-0.8534154003979839, 0.4653691708260623}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{-0.8497507854079335, 
       0.46337084874455164`}, {-0.8303761671844141, 
       0.45280582963012506`}, {-0.8033111879923482, 
       0.43804724088288355`}, {-0.7756875765041558, 
       0.4229840287970851}, {-0.7475053327198367, 
       0.40761619337272975`}, {-0.7187644566393909, 
       0.3919437346098175}, {-0.7031661858059173, 0.38343796548412695`}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{-0.6995015708158668, 
       0.3814396434026163}, {-0.6896609108281616, 
       0.37607351129775396`}, {-0.6603906578514915, 
       0.36011238222594466`}, {-0.6309536977093808, 
       0.3440603473943897}, {-0.6013500304018294, 
       0.3279174068030889}, {-0.5718456338202333, 
       0.3118285987425623}, {-0.5529169712138506, 0.3015067601421917}}]}, 
     {Arrowheads[{{0.020000000000000004`, 1.}}], 
      ArrowBox[{{-0.5492523562238002, 
       0.29950843806068106`}, {-0.5427064858559887, 
       0.29593896150332955`}, {-0.5139325865090953, 
       0.2802484950853908}, {-0.4855239357795532, 
       0.2647571994887459}, {-0.4642748388730488, 
       0.2531700232981462}, {-0.44335295283099285`, 
       0.2417612758640497}, {-0.4228280683603648, 
       0.23056901420232837`}, {-0.4027699761681443, 
       0.21963129532885442`}, {-0.402667756621784, 0.21957555480025637`}}]}, 
     {Arrowheads[{{0.004730348246544155, 1.}}], 
      ArrowBox[{{-0.3990031416317336, 
       0.21757723271874574`}, {-0.3832484669613112, 
       0.20898617625950006`}, {-0.3643333314468449, 0.19867171401013736`}}]}}, 
    {RGBColor[0.2947336, 0.4054232, 0.5678384000000001], 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{-1., -0.2869356060506893}, {-0.9837864805338332, \
-0.28228337001645004`}, {-0.9628057747740204, -0.276263258493887}, \
{-0.9413445469035754, -0.27010526806828894`}, {-0.9092399810299161, \
-0.2608933250023362}, {-0.8762448267124572, -0.2514258404015201}, \
{-0.8426156819047159, -0.24177644135514448`}, {-0.839513912292536, \
-0.24088643321164402`}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{-0.8355017600998494, -0.23973520389066788`}, \
{-0.8082670139555199, -0.23192058550010805`}, {-0.7741326691337849, \
-0.2221262265815403}, {-0.7397074474255168, -0.21224840472724904`}, \
{-0.7049913488307158, -0.20228711993723433`}, {-0.6750156723923855, \
-0.19368603105162266`}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{-0.6710035201996989, -0.19253480173064652`}, \
{-0.6699843733493818, -0.19224237221149615`}, {-0.6350474619936426, \
-0.1822177283780979}, {-0.6005415557756257, -0.17231675526510304`}, \
{-0.5664666546953314, -0.1625394528725115}, {-0.5328227587527596, \
-0.15288582120032332`}, {-0.5105174324922349, -0.1464856288916013}}]}, 
     {Arrowheads[{{0.015630491736770547`, 1.}}], 
      ArrowBox[{{-0.5065052802995483, -0.14533439957062516`}, \
{-0.49993840825613844`, -0.14345013016099203`}, {-0.4681421435136961, \
-0.13432664966697117`}, {-0.4374339645254326, -0.12551537971826074`}, \
{-0.4078138712913479, -0.11701632031486071`}, {-0.3810814569106409, \
-0.1093458387933344}}]}}, 
    {RGBColor[0.2947336, 0.4054232, 0.5678384000000001], 
     {Arrowheads[{{0.019999999999999997`, 1.}}], 
      ArrowBox[{{-0.28693716933184915`, -1.}, {-0.28228444944343384`, \
-0.9837848825955542}, {-0.2762643006716915, -0.962804161325596}, \
{-0.2701062724831959, -0.9413429187726182}, {-0.26089426403025834`, \
-0.9092382999308408}, {-0.2514267129949295, -0.8762430938466148}, \
{-0.24177724784382398`, -0.8426139018755122}, {-0.2408877646926616, \
-0.8395139788044316}}]}, 
     {Arrowheads[{{0.019999999999999997`, 1.}}], 
      ArrowBox[{{-0.2397365295766819, -0.8355018282745423}, \
{-0.2319213257547368, -0.8082651902323421}, {-0.2221269014358882, \
-0.7741308034547226}, {-0.21224901571953497`, -0.7397055467361369}, \
{-0.20228766860567712`, -0.7049894200765848}, {-0.19368712493749432`, \
-0.6750158070789739}}]}, 
     {Arrowheads[{{0.019999999999999997`, 1.}}], 
      ArrowBox[{{-0.19253588982151465`, -0.6710036565490847}, \
{-0.1922428600943147, -0.6699824234760664}, {-0.18221815801126467`, \
-0.6350454994574976}, {-0.17231713018234385`, -0.6005395905437937}, \
{-0.16253977660755234`, -0.566464696734955}, {-0.15288609728689007`, \
-0.5328208180309815}, {-0.14648648518232704`, -0.5105176353535162}}]}, 
     {Arrowheads[{{0.015630681910760173`, 1.}}], 
      ArrowBox[{{-0.14533525006634737`, -0.506505484823627}, \
{-0.14345036245135837`, -0.49993649406032475`}, {-0.13432684233195852`, \
-0.46814026445143675`}, {-0.12551553692869047`, -0.43743212920431734`}, \
{-0.11701644624155427`, -0.4078120883189665}, {-0.10934607026159615`, \
-0.3810801874020547}}]}}, 
    {RGBColor[0.2947336, 0.4054232, 0.5678384000000001], 
     {Arrowheads[{{0.019999999999999997`, 1.}}], 
      ArrowBox[{{1., -0.2869530307633316}, {
       0.9837569849111514, -0.282292048354852}, {
       0.9627758614804316, -0.27627145139758746`}, {
       0.941314231010477, -0.27011297148911134`}, {
       0.9092083403169191, -0.26090008884923865`}, {
       0.8762118784587335, -0.25143165411456564`}, {
       0.8425815180918189, -0.24178132028161647`}, {
       0.8395146536661406, -0.24090127423972785`}}]}, 
     {Arrowheads[{{0.019999999999999997`, 1.}}], 
      ArrowBox[{{0.8355025200077941, -0.23974998032663775`}, {
       0.8082317016642094, -0.23192453635154986`}, {
       0.7740962476142493, -0.22212926435543134`}, {
       0.7396700622588923, -0.21225056613009147`}, {
       0.7049531455981393, -0.20228844167553037`}, {
       0.6750171736739348, -0.19369822380303386`}}]}, 
     {Arrowheads[{{0.020000000000000004`, 1.}}], 
      ArrowBox[{{0.6710050400155882, -0.19254692988994376`}, {
       0.6699454976319895, -0.1922428909917479}, {
       0.6350080953916435, -0.182217497531883}, {
       0.6005019159083013, -0.17231584474907446`}, {
       0.5664269591819626, -0.16253793264332217`}, {
       0.5327832252126278, -0.1528837612146263}, {
       0.5105196936817289, -0.14649517336633985`}}]}, 
     {Arrowheads[{{0.015634087569074313`, 1.}}], 
      ArrowBox[{{0.5065075600233824, -0.14534387945324975`}, {
       0.499899242886728, -0.1434476028226415}, {
       0.4681035410906944, -0.13432372982702256`}, {
       0.43739611982452714`, -0.12551214222776946`}, {
       0.4077769790882261, -0.11701284002488221`}, {
       0.38105546211654356`, -0.10934501974326412`}}]}}, 
    {RGBColor[0.2947336, 0.4054232, 0.5678384000000001], 
     {Arrowheads[{{0.019999999999999993`, 1.}}], 
      ArrowBox[{{-0.2869529709888647, 1.}, {-0.28229197358186275`, 
       0.9837569292593844}, {-0.27627137734700835`, 
       0.9627758039756598}, {-0.27011289819734446`, 
       0.9413141716794642}, {-0.260900015952106, 
       0.9092082756732647}, {-0.2514315816632676, 
       0.8762118084953527}, {-0.24178124838013856`, 
       0.8425814430390441}, {-0.24090122332837974`, 0.8395146511228421}}]}, 
     {Arrowheads[{{0.019999999999999997`, 1.}}], 
      ArrowBox[{{-0.23974992963686761`, 
       0.8355025174009131}, {-0.23192446508628248`, 
       0.8082316216732337}, {-0.22212919375147921`, 
       0.774096162817213}, {-0.21225049632405438`, 
       0.7396699730712697}, {-0.2022883728040082, 
       0.7049530524354044}, {-0.19369818197638267`, 0.6750171685237552}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{-0.19254688828487054`, 
       0.6710050348018262}, {-0.19224282319134048`, 
       0.6699454009096165}, {-0.18221743095602772`, 
       0.6350079956589778}, {-0.1723157795680463, 
       0.6005018138485596}, {-0.1625378690273963, 
       0.5664268554783624}, {-0.15288369933407764`, 
       0.5327831205483856}, {-0.14649514062438557`, 0.5105196859246682}}]}, 
     {Arrowheads[{{0.015634095042295487`, 1.}}], 
      ArrowBox[{{-0.14534384693287344`, 
       0.5065075522027392}, {-0.14344754282454572`, 
       0.4998991379326486}, {-0.134323671835256, 
       0.4681034365051705}, {-0.12551208636620845`, 
       0.43739601626595126`}, {-0.11701278641740305`, 
       0.40777687721499084`}, {-0.10934497694348193`, 0.3810553923406674}}]}}, 
    {RGBColor[0.2947336, 0.4054232, 0.5678384000000001], 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{-1., -0.07976409389990256}, {-0.9818021318888885, \
-0.07831255743910984}, {-0.9591718924285286, -0.0765074768938164}, \
{-0.9360640945398611, -0.07466430433320476}, {-0.914051193862202, \
-0.07290846525654272}, {-0.8911995346357707, -0.0710857233642371}, \
{-0.8680123719898307, -0.06923622034567402}, {-0.8449929610536451, \
-0.06740009789023967}, {-0.8335666073497329, -0.06648868514046731}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{-0.8294057725334761, -0.06615679992148142}, \
{-0.8218890409275581, -0.0655572346358466}, {-0.7983049254378525, \
-0.06367606903337958}, {-0.7745287318026993, -0.06177958249168297}, \
{-0.75084857724027, -0.05989075641960115}, {-0.7109149072034588, \
-0.05670548341301722}, {-0.6712055899029618, -0.053538105699159344`}, \
{-0.662972379883209, -0.05288139116204617}}]}, 
     {Arrowheads[{{0.019999999999999997`, 1.}}], 
      ArrowBox[{{-0.6588115450669523, -0.052549505943060286`}, \
{-0.6317206253387787, -0.050388623278027525`}, {-0.5924600135109098, \
-0.04725703614962176}, {-0.5539110323170351, -0.04418221159392796}, \
{-0.5165609596548348, -0.04120301689093203}, {-0.49237815241668514`, \
-0.03927409718362502}}]}, 
     {Arrowheads[{{0.012973117673471335`, 1.}}], 
      ArrowBox[{{-0.48821731760042847`, -0.03894221196463914}, \
{-0.48040979552430896`, -0.03831945204063398}, {-0.44545753992545734`, \
-0.03553151704303378}, {-0.41198158383210576`, -0.032861337737814675`}, \
{-0.38025931821807973`, -0.03033103996465985}}]}}, 
    {RGBColor[0.2947336, 0.4054232, 0.5678384000000001], 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{-0.0797661579013291, -1.}, {-0.07831447839276792, \
-0.9818008094315273}, {-0.07650934969815164, -0.9591705519124271}, \
{-0.0746661280855262, -0.9360627370054395}, {-0.07291024597646148, \
-0.9140498664440074}, {-0.07108745988068349, -0.8911982443559436}, \
{-0.06923791219022019, -0.8680111216572273}, {-0.06740174529709952, \
-0.8449917492638371}, {-0.06649040779497344, -0.833566634577313}}]}, 
     {Arrowheads[{{0.020000000000000004`, 1.}}], 
      ArrowBox[{{-0.06615851404231454, -0.8294058004417457}, \
{-0.06555883763085031, -0.8218878701910994}, {-0.06367762715154028, \
-0.7983038023507367}, {-0.061781095547005956`, -0.7745276590033243}, \
{-0.059892224505083774`, -0.7508475534094368}, {-0.05670687551459961, \
-0.7109139640992378}, {-0.053539422595289196`, -0.6712047314792016}, \
{-0.052882763935958886`, -0.6629724350190587}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{-0.05255087018329999, -0.6588116008834914}, \
{-0.050389865747152526`, -0.6317198555493282}, {-0.04725820497018961, \
-0.5924593363096177}, {-0.04418330829449484, -0.5539104484529602}, \
{-0.04120404375016265, -0.5165604666722463}, {-0.03927512007694432, \
-0.4923782354608044}}]}, 
     {Arrowheads[{{0.0129731494155866, 1.}}], 
      ArrowBox[{{-0.03894322632428543, -0.4882174013252372}, \
{-0.03832041133719303, -0.4804093909674759}, {-0.03553241105558597, \
-0.4454572213386489}, {-0.03286216914312618, -0.4119813465727753}, \
{-0.03033181183759834, -0.38025915545686506`}}]}}, 
    {RGBColor[0.2947336, 0.4054232, 0.5678384000000001], 
     {Arrowheads[{{0.020000000000000004`, 1.}}], 
      ArrowBox[{{1., -0.07980488788094073}, {
       0.9817745631005679, -0.0783504089326004}, {
       0.9591439391227315, -0.07654437452337345}, {
       0.9360357784323899, -0.07470023035034598}, {
       0.9140234945723068, -0.0729435425048886}, {
       0.8911725986740231, -0.07111992931974703}, {
       0.8679862579604591, -0.06926954599873177}, {
       0.8449676396545353, -0.06743254774565334}, {
       0.8335671456177349, -0.06652273259725915}}]}, 
     {Arrowheads[{{0.020000000000000004`, 1.}}], 
      ArrowBox[{{0.8294063242581783, -0.06619067871516711}, {
       0.8218645649801914, -0.06558880946156231}, {
       0.7982814331917328, -0.06370676027330294}, {
       0.7745062785576285, -0.061809386723376214`}, {
       0.7508271353463472, -0.059919675354283164`}, {
       0.7108951494282469, -0.05673290769522587}, {
       0.671187599984686, -0.05356405116385558}, {
       0.6629734698759132, -0.05290852343148551}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{0.6588126485163566, -0.05257646954939347}, {
       0.6317044870156648, -0.05041310576017233}, {
       0.592445810521183, -0.04728007148417608}, {
       0.5538987812270677, -0.04420383013321587}, {
       0.516550609859146, -0.04122326350464073}, {
       0.4923797941340915, -0.039294314265711866`}}]}, 
     {Arrowheads[{{0.012973771273755912`, 1.}}], 
      ArrowBox[{{0.48821897277453485`, -0.03896226038361982}, {
       0.480401296417418, -0.03833837159845063}, {
       0.4454508409018838, -0.035549154414645616`}, {
       0.411976588278905, -0.0328777454371705}, {
       0.3802558835148433, -0.030346278149970138`}}]}}, 
    {RGBColor[0.2947336, 0.4054232, 0.5678384000000001], 
     {Arrowheads[{{0.019999999999999993`, 1.}}], 
      ArrowBox[{{-0.07980489353615769, 1.}, {-0.078350408861903, 
       0.9817744926431649}, {-0.07654437421771805, 
       0.959143867324848}, {-0.07470022981154761, 
       0.9360357053506091}, {-0.07294354192854986, 
       0.9140234225799814}, {-0.0711199287314634, 
       0.8911725281513052}, {-0.06926954540874145, 
       0.8679861890594098}, {-0.06743254714883722, 
       0.844967572299124}, {-0.06652273731721868, 0.8335671456923731}}]}, 
     {Arrowheads[{{0.020000000000000004`, 1.}}], 
      ArrowBox[{{-0.06619068341174521, 
       0.8294063243346824}, {-0.06558880886994256, 
       0.8218644993270474}, {-0.06370675971502353, 
       0.7982813696275344}, {-0.06180938620969474, 
       0.7745062172370469}, {-0.05991967487957084, 
       0.7508270761920467}, {-0.056732907342926936`, 
       0.7108950946375564}, {-0.05356405095697499, 
       0.6711875498299662}, {-0.05290852719280619, 0.6629734700270554}}]}, 
     {Arrowheads[{{0.019999999999999997`, 1.}}], 
      ArrowBox[{{-0.05257647328733272, 
       0.6588126486693647}, {-0.050413105721715, 
       0.631704441769276}, {-0.047280071637146946`, 
       0.5924457704554856}, {-0.04420383048837034, 
       0.5538987464264036}, {-0.04122326406048461, 
       0.5165505802198376}, {-0.03929431706839369, 0.4923797943617378}}]}, 
     {Arrowheads[{{0.01297377257804862, 1.}}], 
      ArrowBox[{{-0.038962263162920216`, 
       0.4882189730040471}, {-0.038338372353489795`, 
       0.48040127183578796`}, {-0.03554915536738587, 
       0.4454508212742544}, {-0.032877746576807365`, 
       0.4119765733652818}, {-0.03034627945638877, 0.3802558729389145}}]}}, 
    {RGBColor[0.2947336, 0.4054232, 0.5678384000000001], 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{0.31709673589769716`, -1.}, {
       0.3132236596624506, -0.9877858211807765}, {
       0.3053682868778271, -0.9630130250736673}, {
       0.2986927631137251, -0.9419610147298721}, {
       0.2918685363245954, -0.9204400527754376}, {
       0.2815627164712192, -0.8879394979393855}, {
       0.27098084555489715`, -0.8545683852208491}, {
       0.26663008748673644`, -0.8408477833488563}}]}, 
     {Arrowheads[{{0.020000000000000004`, 1.}}], 
      ArrowBox[{{0.26536842127646243`, -0.8368689779325778}, {
       0.260215380877706, -0.820618289056301}, {
       0.24923550333895345`, -0.7859920179669165}, {
       0.23832890225399614`, -0.7515968323650186}, {
       0.22735444121506784`, -0.7169876428132569}, {
       0.21631212022216856`, -0.6821644493116318}, {
       0.21490177286550163`, -0.6777167612814341}}]}, 
     {Arrowheads[{{0.019999999999999993`, 1.}}], 
      ArrowBox[{{0.21364010665522762`, -0.6737379558651555}, {
       0.2052019392752983, -0.6471272518601427}, {
       0.19414227260106642`, -0.6122493568136292}, {
       0.18325149442608202`, -0.5779040705269296}, {
       0.17252960475034526`, -0.5440913930000443}, {
       0.16317345824426685`, -0.514585739214012}}]}, 
     {Arrowheads[{{0.015394309514375813`, 1.}}], 
      ArrowBox[{{0.16191179203399284`, -0.5106069337977334}, {
       0.15169332513936698`, -0.47838185628093877`}, {
       0.14178060368963086`, -0.447120981199165}, {
       0.13223843922464762`, -0.4170286989876516}, {
       0.12306683174441721`, -0.3881050096463983}}]}}, 
    {RGBColor[0.2947336, 0.4054232, 0.5678384000000001], 
     {Arrowheads[{{0.019999999999999997`, 1.}}], 
      ArrowBox[{{-1., 0.31709902142317975`}, {-0.9877856782382473, 
       0.3132258719451801}, {-0.963012855416116, 
       0.3053704340703925}, {-0.941960869435556, 
       0.29869486991694244`}, {-0.9204399319204503, 
       0.29187060169079304`}, {-0.8879394423504772, 
       0.2815647282523803}, {-0.8545683958888609, 
       0.2709828020755343}, {-0.8408478881537967, 0.26663204249931627`}}]}, 
     {Arrowheads[{{0.019999999999999997`, 1.}}], 
      ArrowBox[{{-0.8368690853576417, 
       0.26537036802621966`}, {-0.8206183647736198, 
       0.26021728043160486`}, {-0.7859921582587477, 
       0.24923734423014196`}, {-0.7515970359219803, 
       0.23833068459542248`}, {-0.7169879065417915, 
       0.22735616353665639`}, {-0.6821647701181814, 
       0.21631378105384375`}, {-0.6777169735114384, 0.2149033891023562}}]}, 
     {Arrowheads[{{0.019999999999999997`, 1.}}], 
      ArrowBox[{{-0.6737381707152834, 
       0.21364171462925963`}, {-0.6471276266511496, 
       0.20520353714698444`}, {-0.6122497810604965, 
       0.1941438064408396}, {-0.577904538266022, 
       0.18325296356017018`}, {-0.5440918982677261, 
       0.17253100850497627`}, {-0.5145860588690802, 
       0.16317473570539617`}}]}, 
     {Arrowheads[{{0.015394284639512854`, 1.}}], 
      ArrowBox[{{-0.5106072560729251, 
       0.1619130612322996}, {-0.47838241855448205`, 
       0.15169459678968034`}, {-0.44712156262915903`, 
       0.14178180996690937`}, {-0.4170292932896394, 
       0.13223958080694498`}, {-0.3881056105359232, 0.12306790930978703`}}]}}, 
    {RGBColor[0.2947336, 0.4054232, 0.5678384000000001], 
     {Arrowheads[{{0.020000000000000004`, 1.}}], 
      ArrowBox[{{1., 0.31703644154247784`}, {0.9877968058643013, 
       0.3131675842982439}, {0.9630240363930764, 0.30531371361793463`}, {
       0.9419715159840856, 0.29863929746196777`}, {0.9204500380164512, 
       0.29181620467037417`}, {0.8879482074579195, 0.2815119399664807}, {
       0.8545757903570511, 0.2709316676031501}, {0.8408450186920265, 
       0.2665785126148384}}]}, 
     {Arrowheads[{{0.019999999999999993`, 1.}}], 
      ArrowBox[{{0.8368661441593273, 0.26531706439164743`}, {
       0.8206243961996982, 0.2601678384140968}, {0.7859968218239101, 
       0.24918963545474948`}, {0.7516003553412259, 0.23828470211944422`}, {
       0.7169899244263145, 0.22731193426192892`}, {0.682165529079176, 
       0.21627133188220368`}, {0.6777111628513539, 0.21485913546400795`}}]}, 
     {Arrowheads[{{0.020000000000000004`, 1.}}], 
      ArrowBox[{{0.6737322883186546, 0.21359768724081696`}, {
       0.6471271692998101, 0.20516289498026843`}, {0.6122481783517146, 
       0.19410498380549196`}, {0.5779018894983877, 0.1832159586072431}, {
       0.5440883027398291, 0.17249581938552183`}, {0.5145773070106812, 
       0.1631397583131775}}]}, 
     {Arrowheads[{{0.015393742460161588`, 1.}}], 
      ArrowBox[{{0.5105984324779819, 0.16187831008998652`}, {
       0.4783772350341468, 0.15166301631015547`}, {0.4471157531412836, 
       0.14175198733349753`}, {0.4170229723974491, 0.13221147921035423`}, {
       0.38809889280264315`, 0.12304149194072556`}}]}}, 
    {RGBColor[0.2947336, 0.4054232, 0.5678384000000001], 
     {Arrowheads[{{0.019999999999999993`, 1.}}], 
      ArrowBox[{{0.3170363078241888, 1.}, {0.31316744107049854`, 
       0.9877967707224382}, {0.30531357549432164`, 0.9630240069021749}, {
       0.29863916144806363`, 0.941971484268208}, {0.29181607083501093`, 
       0.9204500040949137}, {0.2815118084139159, 0.8879481670283236}, {
       0.27093153843623674`, 0.8545757433766252}, {0.26657839823475826`, 
       0.840845012561111}}]}, 
     {Arrowheads[{{0.019999999999999997`, 1.}}], 
      ArrowBox[{{0.2653169504950225, 0.8368661378751387}, {0.2601677117813495,
        0.82062434289269}, {0.24918951148946222`, 0.7859967623255607}, {
       0.23828458083820664`, 0.7516002898013385}, {0.2273118158312144, 
       0.7169898532797363}, {0.21627121646848554`, 0.6821654527607541}, {
       0.21485904090559196`, 0.6777111504362497}}]}, 
     {Arrowheads[{{0.019999999999999997`, 1.}}], 
      ArrowBox[{{0.2135975931658562, 0.6737322757502775}, {
       0.20516278275001995`, 0.6471270882443918}, {0.19410487492281447`, 
       0.6122480931441284}, {0.18321585323386586`, 0.5779018008734429}, {
       0.1724957176831741, 0.5440882114323352}, {0.16313968357642566`, 
       0.5145772883113885}}]}, 
     {Arrowheads[{{0.015393751292979005`, 1.}}], 
      ArrowBox[{{0.16187823583668992`, 0.5105984136254162}, {
       0.15166292238930826`, 0.4783771405558141}, {0.14175189743162886`, 
       0.4471156581543235}, {0.13221139339770083`, 0.4170228776163333}, {
       0.12304141028752422`, 0.38809879894184346`}}]}}, 
    {RGBColor[0.2947336, 0.4054232, 0.5678384000000001], 
     {Arrowheads[{{0.019999999999999997`, 1.}}], 
      ArrowBox[{{0.11884386990220618`, -1.}, {
       0.11830012483521231`, -0.995424710862737}, {
       0.11548848431496281`, -0.9717664395310888}, {
       0.11279685618969289`, -0.9491180006382389}, {
       0.11004938252615437`, -0.9259996549818802}, {
       0.10747733162987752`, -0.9043573868666351}, {
       0.10481145795230387`, -0.8819256562290572}, {
       0.10210805516221153`, -0.8591781405825462}, {
       0.09942341692837851, -0.8365885174405017}, {
       0.09914011794825815, -0.8342047261658362}}]}, 
     {Arrowheads[{{0.019999999999999997`, 1.}}], 
      ArrowBox[{{0.09864752414940946, -0.8300598443199821}, {
       0.09673013385371071, -0.8139261531394734}, {
       0.0939842912430088, -0.7908215318160396}, {
       0.09121742481789331, -0.7675400076836442}, {
       0.08846107029998462, -0.7443469349557295}, {
       0.08378447642738043, -0.7049961979219013}, {
       0.07913593447000294, -0.6658815009568608}, {
       0.07894377219546145, -0.6642645704858183}}]}, 
     {Arrowheads[{{0.020000000000000004`, 1.}}], 
      ArrowBox[{{0.07845117839661275, -0.6601196886399643}, {
       0.07451544442785217, -0.6270028440606081}, {
       0.06992300630092808, -0.5883602272331429}, {
       0.06541433124455591, -0.5504224264859755}, {
       0.06104513041406083, -0.5136582178306163}, {
       0.05874742644266474, -0.4943244148058004}}]}, 
     {Arrowheads[{{0.0095908037383696, 1.}}], 
      ArrowBox[{{0.058254832643816035`, -0.4901795329599463}, {
       0.05681540380944286, -0.4780676012670652}, {
       0.052725151430701986`, -0.44365057679532216`}, {
       0.048806091748824436`, -0.4106740363553108}}]}}, 
    {RGBColor[0.2947336, 0.4054232, 0.5678384000000001], 
     {Arrowheads[{{0.020000000000000004`, 1.}}], 
      ArrowBox[{{-1., 0.11884613192268448`}, {-0.995424949169111, 
       0.11830240482808366`}, {-0.9717666566492952, 
       0.11549070827420817`}, {-0.9491182337358725, 
       0.11279903081679879`}, {-0.9259999038178173, 
       0.11005150672952545`}, {-0.9043576467819059, 
       0.10747940819473088`}, {-0.8819259257485255, 
       0.10481348491754489`}, {-0.8591784191161572, 
       0.10211003174340232`}, {-0.8365888052832829, 
       0.09942534351773803}, {-0.8342047701157898, 0.09914201015971381}}]}, 
     {Arrowheads[{{0.020000000000000004`, 1.}}], 
      ArrowBox[{{-0.8300598893686845, 
       0.09864940711563955}, {-0.813926449137752, 
       0.0967320101495874}, {-0.7908218336895101, 
       0.09398611597400275}, {-0.7675403145201843, 
       0.09121919747544455}, {-0.7443472472114006, 
       0.08846279113837313}, {-0.7049964954272254, 
       0.08378610650057425}, {-0.6658817810630766, 
       0.0791374739971345}, {-0.6642646594844742, 0.0789452853526689}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{-0.6601197787373689, 
       0.07845268230859463}, {-0.6270031041189545, 
       0.07451689362805392}, {-0.5883604645948588, 
       0.06992436539333251}, {-0.5504226395687578, 
       0.06541560163542079}, {-0.5136584061186199, 
       0.061046314696769334`}, {-0.49432454885315874`, 
       0.05874856054562398}}]}, 
     {Arrowheads[{{0.00959080909739785, 1.}}], 
      ArrowBox[{{-0.4901796681060535, 
       0.058255957501549716`}, {-0.47806776424444497`, 
       0.05681650457737812}, {-0.4436507139462329, 
       0.052726171277247144`}, {-0.41067414815212094`, 
       0.048807033988523034`}}]}}, 
    {RGBColor[0.2947336, 0.4054232, 0.5678384000000001], 
     {Arrowheads[{{0.020000000000000004`, 1.}}], 
      ArrowBox[{{1., 0.11879249533074672`}, {0.9954245024970934, 
       0.11824896056499684`}, {0.9717663853738628, 0.11543855379710123`}, {
       0.9491176760207061, 0.11274805709701892`}, {0.9259990612111911, 
       0.11000173915520628`}, {0.9043564700927874, 0.10743076175082805`}, {
       0.8819244244872991, 0.10476600307797898`}, {0.859176597086977, 
       0.10206373189774157`}, {0.8365866605840717, 0.09938021697119834}, {
       0.8342037281988328, 0.09909714248695137}}]}, 
     {Arrowheads[{{0.019999999999999997`, 1.}}], 
      ArrowBox[{{0.8300588214038036, 0.09860475866585648}, {
       0.8139239986224854, 0.0966880628059443}, {0.7908191055111755, 
       0.09394337489890164}, {0.7675373199399763, 0.09117767349514351}, {
       0.7443439805987219, 0.08842247883974311}, {0.7049932872542667, 
       0.08374791178436028}, {0.6658786752675383, 0.07910138942256287}, {
       0.6642625496026365, 0.07890940582206112}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{0.6601176428076073, 0.07841702200096623}, {0.627000144638537,
        0.07448291175435094}, {0.5883576953672627, 0.06989247877972446}, {
       0.5504200916707636, 0.06538577616974837}, {0.5136560977660879, 
       0.06101848959548758}, {0.4943213710064402, 0.05872166915717087}}]}, 
     {Arrowheads[{{0.009590542637694453, 1.}}], 
      ArrowBox[{{0.49017646421141103`, 0.058229285336075985`}, {
       0.4780657136532357, 0.056790619056942104`}, {0.443648939332207, 
       0.05270216455411194}, {0.41067265351741744`, 
       0.04878482927543319}}]}}, 
    {RGBColor[0.2947336, 0.4054232, 0.5678384000000001], 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{0.11879243375690345`, 1.}, {0.11824889158487242`, 
       0.9954244377790649}, {0.11543848677677639`, 0.9717663248907705}, {
       0.1127479912967778, 0.9491176140687968}, {0.11000167461030454`, 
       0.9259989978436817}, {0.10743069859766038`, 0.9043564072229239}, {
       0.10476594140377464`, 0.8819243624401821}, {0.10206367173739228`, 
       0.8591765359926469}, {0.09938015830725822, 0.8365866003775083}, {
       0.09909709097976466, 0.83420372700299}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{0.09860470741033618, 0.8300588201780646}, {
       0.09668800566057699, 0.8139239394525672}, {0.09394331934115341, 
       0.7908190477299151}, {0.09117761955263293, 0.7675372636881789}, {
       0.08842242649866086, 0.7443439258059845}, {0.08374786230113507, 
       0.704993236122399}, {0.07910134281629244, 0.6658786280796742}, {
       0.07890936463319737, 0.6642625471810546}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{0.07841698106376889, 0.6601176403561293}, {
       0.07448286804413302, 0.6270001016778106}, {0.06989243798465679, 
       0.5883576569168077}, {0.06538573826010363, 0.5504200578456778}, {
       0.061018454492713425`, 0.513656068513433}, {0.05872163828663008, 
       0.49432136735911925`}}]}, 
     {Arrowheads[{{0.009590544052967344, 1.}}], 
      ArrowBox[{{0.05822925471720161, 0.490176460534194}, {
       0.05679058668248618, 0.4780656889200732}, {0.05270213482942186, 
       0.4436489190655981}, {0.048784802090079536`, 
       0.41067263753441274`}}]}}}},
  AspectRatio->1,
  DisplayFunction->Identity,
  Frame->True,
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  Method->{
   "DefaultBoundaryStyle" -> Automatic, "TransparentPolygonMesh" -> True},
  PlotRange->{{-1.0435125228870954`, 
   1.0435125228870954`}, {-1.0435125228870954`, 1.0435125228870954`}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.05], 
     Scaled[0.05]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.681130942521586*^9, 3.681130949425378*^9}, 
   3.6811653876310873`*^9, 3.68123019880549*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Another way to plot, with other options :", "Subsubsection",
 CellChangeTimes->{{3.681165412190287*^9, 3.681165429282848*^9}, {
  3.681165538005891*^9, 3.681165543916595*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"fieldlines", "=", "\[IndentingNewLine]", 
  RowBox[{"StreamPlot", "[", 
   RowBox[{
    RowBox[{"Evaluate", "[", 
     RowBox[{"-", 
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"-", 
         RowBox[{"Exp", "[", 
          RowBox[{"-", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["x", "2"], "+", 
             SuperscriptBox["y", "2"]}], ")"}]}], "]"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"{", 
          RowBox[{"x", ",", "y"}], "}"}], "}"}]}], "]"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", 
      RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"y", ",", 
      RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
    RowBox[{"StreamScale", "\[Rule]", "Coarse"}], ",", "\[IndentingNewLine]", 
    
    RowBox[{"FrameTicksStyle", "\[Rule]", 
     RowBox[{"Directive", "[", 
      RowBox[{"\"\<Label\>\"", ",", "12"}], "]"}]}], ",", 
    RowBox[{"FrameLabel", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Style", "[", 
        RowBox[{"\"\<x\>\"", ",", "Black", ",", "15"}], "]"}], ",", 
       RowBox[{"Style", "[", 
        RowBox[{"\"\<y\>\"", ",", "Black", ",", "15"}], "]"}]}], "}"}]}]}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.681130879755739*^9, 3.681130914167327*^9}, {
  3.6811654354266872`*^9, 3.681165444391767*^9}, {3.68116552355259*^9, 
  3.681165525666375*^9}, {3.681165711463578*^9, 3.6811657142223387`*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {
    {RGBColor[0.2947336, 0.4054232, 0.5678384000000001], 
     {Arrowheads[{{0.0375972553623346, 1.}}], ArrowBox[CompressedData["
1:eJwdxQswEwAYwPGpJKVEJVLXcEloDpcrIbG5PKrLxbhb7awTJ3F5nXDSnNZr
FQqRR1YpVIYYyoe8Xcc8a2ryymzzyGNm3OTrf/e/nwEj1NN/A4FAsFkf9dam
za6tzQDhf7NQtddPn8edgfIGoSnqTsqJ4sM0LGS/TkI5xj27BQ7TUMzOMkKJ
fEsOkTcF2nQeF6Xk2S71aUxBdeR11f51xyjv9ympUqitZJmgQR963VYzJDDd
eMEHdWpeabTuFIOuvU43+vThXBpZMQlxs6846OJyfwJDbxKE4fps9OqOd0y2
uQhOttx8hIraAl80WU9AuhgKUIFWWFPfsz+wVSWuC/W2OOHLnR+HPuH8FZRm
WEv1OTsOy4mHGahUTKhvzx+DqFmdDpShVi0tWxiFQFmMDNWXvbQC51EQBWjY
oTqVvBTp4xGQkzuyUC83pYbdj2HIYFfuQcFTU1dMHIZLt0KIqF34XVPrwN8w
SGVboTnUnruky0NgRjLJQCVy/w5zyS/YFaMqQGMJtI/H23+C3CXkC1rTtS16
c9EghPGSk1AFOdIv/rQABqPdQtBT91yJ54TfYdHwhjm6Y2LNOTFpABgr8efR
cYr+3Ndj/ZDuKFtFxfNN2UsDvTAuWyxAm2kVHuWsHshSdfJG4xKkymVyN9QE
C9QU66rTA8tbNflw2hw+o29lqmFSfieY0lNvo8wSU25J/jcgNb4BNE/iYCxM
7oAUFs8a3fjWiR+R2wbUd62/0OahCHqCVjNsMXAIQhUpB+YiFxrAney3girE
xPzgsjoQpboVokGOwz77aV9A2WsbgHr56xl+aq0CgydlJLSSLM7lFFeAne9a
IRpnbJVWy+TCiFF9DlpYesTy4vYiWL3DcEBtMr0PHbTJA+km56OottzSA8JS
oZxR5oXaP1DPYLqzgOgSzEF7/16LsBiOhWOeGkw08UyhpLQuFDopFiuoWour
/LkTA3Tv26hkrmtmuDvYeKcXiDLpUeg/KJf0Dw==
       "]]}}, 
    {RGBColor[0.2947336, 0.4054232, 0.5678384000000001], 
     {Arrowheads[{{0.036452094157275454`, 1.}}], ArrowBox[CompressedData["
1:eJwBEQPu/CFib1JlAgAAADAAAAACAAAAAAAAAAAA8D+Tb+AgTv/vv4SiOs4K
su8/+95uoFqx779KOGBtIcDuP3IVPoB2v+6/C2MDmCg/7j+k4cR3gD7uv+6A
laNtuO0/Q4M8cMi37b90c4D7Hw3tP6BtV4B+DO2/xCWx60RY7D9e2NBdp1fs
v/qhwK0/mes/ITypRaaY678v8kd7c8/qP40R4XTezuq/EYuzVIL66T9jSu/t
8fnpvySW1jyeGek/zwwguBIZ6b9pE7EzxyzoP9JYc9NALOi/4AJDOf0z5z9p
Luk/fDPnv4JI8XELluY/OBOG5o2V5r+SHN8M5fPlP9ThwgZr8+W/Dn8MCopN
5T9Cmp+gE03lv/hveWn6ouQ/fDwctIei5L/UXLeG4fTjP8C4EZly9OO/JrNX
vepD4z9E/1inf0Pjv+5yWg0WkOI/CBDy3q6P4r8snL92Y9nhPw3r3D8A2eG/
wp8ydQ8h4T9z1uU+sCDhv5LuXoRWaOA/WhjZUPtn4L88EYlIcV7fP4RhbevC
Xd+/ytvGqWvr3T9WP/1axerdvyA4loR0ytw/s3gCfNTJ3L8GILtWP6vbPyAc
mIqlqtu/UYB9wrNB2j+wcf/PIUHav3/lhimA3tg/4upq7fXd2L9bwW4gsoXX
P/eY6mAvhde/o5gCy+811j8wds5VdDXWv4vi/rsf2NQ/GK4436vX1L/6LEns
2IfTP5hes1xsh9O/+XfhWxtF0j+yhz7OtUTSv4HDxwrnD9E/ZCnaM4gP0b+Y
TSOEI9LPPwUQ76Ny0c+/InKpleKizT/Bzw/aPaLNv5/0IUoLkss//ZEWCnKR
y78S1YyhnZ/JP7xWAzQPn8m/RDvnnaERxj/qpoDyJhHGvygwZu+Q9MI/fn95
kif0wr/rc3CChbPAP792Aq0os8C/OK5fJ0pcvT/CaS30plu9v3uzSEbfyLk/
0HNs80/Iub+c95thyqy2P6QLwldMrLa/GDdjN9+CsT9jQ2fhfYKxv5rOLqWK
Das/jN+mRfQMq7/yD9wyRDagP6OtqBXqNaC/VKqiuQ==
       "]]}}, 
    {RGBColor[0.2947336, 0.4054232, 0.5678384000000001], 
     {Arrowheads[{{0.036452082721713595`, 1.}}], ArrowBox[CompressedData["
1:eJwBEQPu/CFib1JlAgAAADAAAAACAAAAq6g1Ek3/778AAAAAAADwP49QfkZb
se+/6fFqgAyy7z+bx0Ewd7/uvxOnhiEjwO4/XFy6LIE+7r9kuthMKj/uPyD0
ECrJt+2/TzjWWG+47T9dpUZ7fwztv65MNOwhDe0/nT0yoKhX7L8Y3d4dR1js
P9AhRdanmOu/PLTaJ0KZ6z/ktvBa4M7qv8ycLER2z+o/wsuXxPP56b8YcScH
hfrpPzhlYnoUGem/3IJ106AZ6T9Jg1B8QizovxjSFqnJLOg/8iViyn0z57/J
XguI/zPnP5ht/X+Plea/AUuAyg2W5j+GQpmubPPlv3jScW7n8+U/vaQ1VhVN
5b8w9d9zjE3lPz2U0naJouS/J7PK2vyi5D/XKdhndPTjv4xJWP7j9OM/X36u
gIFD47+M9a457UPjP9SRVcGwj+K/KLfOjBiQ4j82ZM0pAtnhv1+Ot/dl2eE/
Xj6DLrIg4b/gYcD1ESHhPyZp5EP9Z+C/WxhAAllo4D8byeHTxl3fv6BjbTp2
Xt8/KGFRQcnq3b99XEiNcOvdP3T2cGHYydy/6q6lXXnK3D8onSFsqarbv8gB
aCJEq9s/XONinyVB2r8+lxFwuEHaP+CCLab53di/mPe8tITe2D90mdT/MoXX
vyTxZoa2hdc/g3I813c11r/I6WUI9DXWP6fFkWKv19S/pUK+7yPY1D+V0+Xc
b4fTv6lCxRHdh9M/Upw4RrlE0r/a6XpuH0XSP9wfip6LD9G/NDjfBesP0T9h
bMNWedHPvzTeSUQr0s8/nm6NZESizb/en/0a6qLNP29GcmZ4kcu/Y7XZjxKS
yz/T83FcFZ/Jv8ce3qKkn8k/bz7lqSwRxr9maBoQqBHGP4u9CtIs9MK/+vds
z5b0wj9b8hgQLbPAv8xl5nKKs8A/f8mnN65bvb9Xe19jUly9P3Epd+pVyLm/
NP+RF+bIuT+LBKA4Uay2vytXZALQrLY/ZNFmEIGCsb9VfpX64oKxP1yqyVD4
DKu/ZNc/lY8Nqz+yZi2N6zWgvzRgjDNGNqA/UBKiqA==
       "]]}}, 
    {RGBColor[0.2947336, 0.4054232, 0.5678384000000001], 
     {Arrowheads[{{0.037597254403025374`, 1.}}], ArrowBox[CompressedData["
1:eJwdxX0s1AEYwPHLJJH3S0ns9McVEc5iqe4ZGVovrHlJlLqp0bw06ro50fJ2
ldAilyE7lpAwebk6eYtC5iXujnO4dF5zx7zMMfR7+m7ffSwYUVduq5FIJEdi
lA8Z4zs7SiD9bxFqtpxZH6uVUHA1iIvOFM3wvjcpoKSN3IpeMaNZ9dEVYJsg
8UT9OJpFxg0LoPK1bEFDAvaqOvctQFd8nHEX4YZtz7zS/y+YbHM0Fwm17A7U
znPnYeaqQT/KeVSWTumdA2eyuBSlCaSb9huzoMN0MKYRvqtKL/c2mYXBe6R2
VH6tMT/OegYy1aEOXfocNlDrMA0u9spZdF2P+ro9ewrSwrQrUI3qi12Fy3JI
KHsxgZoWSCM9Lsnh4MqDJNRJJE7k8/6Av/s3LuqxyQ7hrUzCxEIdC3UsVQ+v
ODcJfk5pCaiGLDp3JOM38I+4VaA1vA6l5bAM9lSN7bIivFPMlosoMjgjFK+h
Lnk6q5TQCfBOq9xtQficrDqjdWMcUorbg9Cp0cw2zXkpHPeWy1Aq47yQ3DUK
wdOsZfSiqc7U7zIJlMSaqE0SOlOY2YEuIxC5bVSF6qpT6NZjYojo9fVHxyT5
IYxkEXDMmXGoatWIVnxSCPclOZ7okQzBlkg0CNMiqaGYMD7t2kpW6i8IXaJq
ZhPqKhb2S9wGYONozDG0r4bJKNPrhzx2awwaosg6Vd3fCxKBMAClFz3Se8jr
AfNkjg1qk1Li/u5lN+x45TJQhxzDcfrbTog326dCOR3xqZcNOsBHKM1HPT5l
BXmutMKb9u4odN2/NMy9phlcmTmxqCkFhkYDG2ErUm0ZPcRXfH38gw9FhobD
qCz2VibrQx1EiK6XoK1fuGa8J9VwUz/AFj1/YSTYVqccmN3ubDTPp35O37EQ
TidRN9HVWIFJffQrSGiIsUENKrPbEi+kAs3DQYLePdEURpexoe+9Wgp6mO30
tKU5ChzNQ0tRL6dwFs+VAT/tlM9Q+pDPmp2+L6ScrdS2J/wHyqe3/A==
       "]]}}, 
    {RGBColor[0.2947336, 0.4054232, 0.5678384000000001], 
     {Arrowheads[{{0.024869605041888593`, 1.}}], ArrowBox[CompressedData["
1:eJwBIQLe/SFib1JlAgAAACEAAAACAAAAAAAAAAAA8D9SurEegvmWP5B9aWlm
me8/5h/citivlj9+luzT/qfuP/mvdhCHApY/v3/3Lfmv7T86/OVRdVCVP3yc
qphIsuw/oqym3VGalD/gTyY14K/rPyppNULL4JM/6plqA8Co6j/RMZJ/4SOT
P5t6dwPonOk/mQa9lZRjkj9GiXy8PY7oP8TQYBtBoZE/O12ptaZ+5z+WeSin
Q96QP4D2/e4ibuY/EAEUOZwakD8QVXposlzlP2DORqKVrI4/p4uPju+M5D/W
56bUQYKNP/ymMEpQvuM/W/uxt5BZjD8MIrParp7iP6Hf5lqNvIo/SwPZAqOE
4T/gdQ7EjieJP1rh2KovdOA/fu9QgFeghz9gaZYK/dfeP1uRSwv8JIY/qv0z
yIbZ3D/PScmZfraEP6hhbhtX8No/ZCXikkdXgz9glUUEbhzZPxsklvZWB4I/
yZi5gstd1z/wReXErMaAP/zv1Wl7tdU/JmNVjhIsfz8FH6aMiSTUP1wbg41Z
7Hw/5iUq6/Wq0j9/tFOHLs56P54EYoXASNE/ki7He5HReD9YwK8JB4zNP1Qs
oJKmNnU/ipDkRcsvyT9rexcQPhVyPxIFixlkxMU/xP9b/npBbz8oBONme7zC
P0Z9RU1X52o/z43sLREYwD9gb+sMERxnPw5ET91Krrs/E9ZNPajfYz/suWvj
juOwP+WZtjFDQFg/pLkFQg==
       "]]}}, 
    {RGBColor[0.2947336, 0.4054232, 0.5678384000000001], 
     {Arrowheads[{{0.024869605041536288`, 1.}}], ArrowBox[CompressedData["
1:eJwBIQLe/SFib1JlAgAAACEAAAACAAAAyLAO/3/5lj8AAAAAAADwP4h1LmzW
r5Y/fntDYWaZ7z8Zv6oBhQKWP7pAlcv+p+4/ODtuU3NQlT8OrnEl+a/tP9vb
5u9PmpQ/PSL7j0iy7D/6koJlyeCTPwf8Uyzgr+s/l2BBtN8jkz9wO3z6v6jq
P61EI9ySY5I/cuBz+uec6T/II7RzP6GRPwYvbLM9jug/cOJ/EULekD8ga5as
pn7nP6WAhrWaGpA/v5Ty5SJu5j/O/I+/kqyOP+OrgF+yXOU/RTWPDT+CjT9a
Np6F74zkP2vwGwyOWYw/0BNOQVC+4z8NftLViryKPz6UC9KunuI/F1zOZIwn
iT+N33f6ooThP/trqUVVoIc/mFvFoi904D+VYjD0+SSGP9vMG/v8194/pHaX
pHy2hD9KVMa4htncPwKkP75FV4M/PCEjDFfw2j+06ihBVQeCP7YzMvVtHNk/
tEpTLavGgD+yi/Nzy13XP3bfCJgPLH8/eoNtW3u11T/7CgTNVux8P1Z1pn6J
JNQ/+BeY+SvOej9EYZ7d9arSP2oGxR2P0Xg/RkdVeMBI0T/lOG+LpDZ1P13f
sPEGjM0/nFOIVDwVcj92uRAwyy/JP/w/1AR4QW8/akZDCmTExT98apPCVOdq
P7pXE117vMI/tCZO4g4cZz9n7YAoERjAP6Z0BGSm32M/4Q4Y2Uquuz9RON7v
QEBYP1yGoeCO47A/yhIDgQ==
       "]]}}, 
    {RGBColor[0.2947336, 0.4054232, 0.5678384000000001], 
     {Arrowheads[{{0.02486963011745501, 1.}}], ArrowBox[CompressedData["
1:eJwBIQLe/SFib1JlAgAAACEAAAACAAAAZbcOrkcGlz8AAAAAAADwv1vNqf12
vJY/GFpF92iZ77/8c2pQxQ6WP01hGpcBqO6/BoxmulBclT9J6M8l/K/tv0uI
MSrIpZQ/lxQ1w0uy7L+Z216O2uuTP7gLGY/jr+u/8oXu5ocukz+wzXuJw6jq
v1SH4DPQbZI/e1pdsuuc6b8oSbDMEKuRP+D+lI9Bjui/0zTZCKfnkD+eB/qm
qn7nv1ZKW+iSI5A/tnSM+CZu5r9iE23WqL2OPyhGTIS2XOW/8jqdQa+SjT96
ALK184zkvyd3aEBZaYw/zVKZeFS+47/OFQ9icMuKP+yPHhmznuK/PC0OspA1
iT9aHmtIp4ThvzRLu/J/rYc/33667zN04L8e6/mNUTGGP3FinIIF2N6/bhlr
fQjChD9LpzNoj9ncv9Zi3kgOYoM/VYEl0l/w2r9Wx1PwYhGCP4/wccB2HNm/
7EbLcwbQgD/29Bgz1F3XvztY6hNzPX8/WwqKAIS11b/cggPTefx8P4qsNP+R
JNS/ug3iJCHdej+G2xgv/qrSv9f4hQlp33g/TJc2kMhI0b8GWPdTfEJ1PwrS
qhYWjM2/pAgxe1Ufcj8Aq48r2S/Jv4tX19LoUm8//fqeqm3Exb+F84CUVPZq
PwP7mVuBvMK/N+VeO+4oZz8Sq4A+FBjAv6Ascce16mM/Uxampkyuu79vS05T
wE1YPxRhNjqQ47C/1LERIg==
       "]]}}, 
    {RGBColor[0.2947336, 0.4054232, 0.5678384000000001], 
     {Arrowheads[{{0.024869630834848153`, 1.}}], ArrowBox[CompressedData["
1:eJwBIQLe/SFib1JlAgAAACEAAAACAAAAAAAAAAAA8L8LwE2R4gaXP7ySYvtp
me+/YGqGqxC9lj9yTG+iAqjuvzTXBHNaD5Y/t3wDOP2v7b/t8nYx4VyVP6z4
qdtMsuy/f8/X2VOmlD9vle2s5K/rv9h+Il9h7JM/A1POq8So6r/9AFfBCS+T
P2cxTNjsnOm/6lV1AE1ukj9KIAO4Qo7ov2I7/HyIq5E/YA+P0Kt+578ob2qX
GeiQP6X+7yEobua/PfG/TwAkkD8d7iWst1zlvz6D+Ut5vo4/Tk/m3PSM5L+n
4AHbd5ONP01mTJ5VvuO/i2RvBxpqjD84jm44tJ7iv35vfj8mzIo/Ni7GX6iE
4b8fbLLZOzaJP0NsEv40dOC/SFzzvyCuhz/CzNGKB9jevwTq807oMYY/Fk4J
cJHZ3L/LzF6XlcKEP/dfotZh8Nq/sJ6iIJJigz9mAp2+eBzZv7Nfv+rdEYI/
YTX5J9Zd17/SD7X1eNCAP8sO2OmFtdW/EFmI+0c+fz+IpFrbkyTUv6BmWn4/
/Xw/lvaA/P+q0r9QSOBz2N16P/QES03KSNG/If4Z3BLgeD9NEvdKGYzNv/Th
PKYNQ3U/Qsc6F9wvyb/kDVd+0R9yP80t2LRvxMW/Rmgyer5Tbz8y642pgrzC
v3iemNUL92o/b/9b9RQYwL9gvuAOiylnPxHVhDBNrru/AMgKJjzrYz99CZWW
kOOwv65kaVZkTlg/Up0UmQ==
       "]]}}, 
    {RGBColor[0.2947336, 0.4054232, 0.5678384000000001], 
     {Arrowheads[{{0.025356050267021278`, 1.}}], ArrowBox[CompressedData["
1:eJwBIQLe/SFib1JlAgAAACEAAAACAAAAAAAAAAAA8L+TWiwb6qbZv/0SF3cu
me+/paAMGX5U2b9TkHFBbrHuv0y0mhq3mti/e4zKrrfB7b802DwbjtrXv24H
Ir8Kyuy/WwzzGgMU17+D03VOPsvrv+qwVFbCR9a/BsPDOCnG6r8CJvkJeHbV
v/zVC37Luum/qGvgNSSg1L9hDE4eJanov9mBCtrGxNO/dCysY/rs57+Rpfv5
7y3Tvyu4fOXgLue/0iRsfIyV0r9EfDoFPBbmv3AWydCTtNG/O/EdlSH85L+e
VDywb9LQv+Lkjagg5eO/uuT5Uo/lz79MvRI5tM/iv7HSm8THKM6/aK0eTkm+
4b8nz6xfbHLMvw3GZDGTseC/lIywlZzDyr9jA1CFR1vfvyqLRcneIsm/sRmk
bj9i3b8voOEuBo7Hv54LwcvykNu/o74HRgcZxr/Q9AugntHZv8QurDZwssS/
RtWE60Ik2L+T8M4AQVrDvwCtK67fiNa/DwRwpHkQwr+SMq5xogDVv9NT99kL
1sC/jhy6v7iM07/ylJmz0le/v/VqT5giLdK/AdDgRyQkvb/FHW773+HQv9RY
xHAMEbu/k6cOie8Kzb+EhEtWCEi3v3/DivxE6ci/vkgaOi74s7+0kZmqPezF
v+ScTQ/qkrG/TuWqGv4+w79SoPMvNNuuv02+vkyG4cC/FsU9qHwQq79gOaqB
rKe9vxOoeYetxae/KgAqPA==
       "]]}}, 
    {RGBColor[0.2947336, 0.4054232, 0.5678384000000001], 
     {Arrowheads[{{0.02535606842694775, 1.}}], ArrowBox[CompressedData["
1:eJwBIQLe/SFib1JlAgAAACEAAAACAAAAob9kse+m2b8AAAAAAADwv0txuQKB
VNm/lg6KNyuZ778gwjLluZrYvy3zlw1rse6//EEsx5Da17/EJueItMHtv+Hw
pagFFNe/WKl3qQfK7L/61KnGxEfWv9+Gp0s7y+u/dvRBXnp21b9Uy9RLJsbq
v1ZPbm8moNS/tXb/qci66b+W5S76yMTTvwKJJ2Yiqei/9B+A+vEt07+beg2t
9+znvxcm1l2OldK/vg54Md4u579Sd8SWlbTRv9aKHGw5Fua/WcDFXHHS0L8K
n7IZH/zkv+Z7ZX2S5c+/wunMTB7l479kYobEyijOv4iLOv+xz+K/VDx5PW9y
zL8/AYs6R77hv0p6CFWfw8q/Yw9YRZGx4L9sR49s4SLJvz42cPtDW9+/AUDv
uAiOx7/KWkczPGLdvwyj2Y4JGca/I5JapO+Q2785dx5DcrLEv8zOwY6b0dm/
iLy91UJaw7/GEH3yPyTYv/hyt0Z7EMK/EliMz9yI1r+whRJODdbAv+Gu4q6f
ANW/rL+rR9VXv79lH3MZtozTv9QCA5AmJL2/n6k9DyAt0r/Y1Cp1DhG7v45N
QpDd4dC/jgAs5wlIt7+Mdd8p6wrNv+Qd724v+LO/iH7iEEHpyL/KCXQ965Kx
v61vOV067MW/T97Dezbbrr8v7j9Y+z7Dv/qbceB+EKu/DPr1AYThwL+RTPGo
r8Wnv4Imt7Sop72/GrMs5w==
       "]]}}, 
    {RGBColor[0.2947336, 0.4054232, 0.5678384000000001], 
     {Arrowheads[{{0.025356200212210286`, 1.}}], ArrowBox[CompressedData["
1:eJwBIQLe/SFib1JlAgAAACEAAAACAAAAAAAAAAAA8D+poLGE/qbZv35eJ+IA
me8/u3nBtm1U2b/p5q4MQbHuPzxPlHGmmti/BAIZ/4rB7T9trflDfdrXv8iv
Zbneyew/SJTxLfIT17+UHhMfE8vrP2Tfn3KxR9a/vHyfE//F6j9SaihVZ3bV
v0PKCpeiuuk/EjWL1ROg1L8oB1Wp/ajoP6M/yPO2xNO/TE4ssNLs5z+DjJJp
3y3TvyvtYga5Luc/NnfMT3uV0r/I30dNFRbmP/7Rv92CtNG/r4tTN/z75D82
Kb4eX9LQv8LZc8785OM/OkaeOW/lz79kfFkPks/iP5MQi/6oKM6/FDuVbym+
4T+gczbqT3LMvxvAmLl1seA/S30Co4LDyr9i2VhfEVvfP1qge2HHIsm/iOsa
Ig5i3T+Mth1o8Y3Hv5gL1AHCkNs/6TYpv/EYxr/NOKWObtHZP8vRYSZassS/
KHOOyBMk2D8yh8edKlrDv6q6j6+xiNY/HVdaJWMQwr+Mv7W/dQDVP9uXVWv1
1cC/CDINdY2M0z9uP+k7ple/vxwSls/4LNI/Yt1uevgjvb/IX1DPt+HQP5QJ
PJLhELu/uM6P46UKzT+/skbT30e3v2jYxB8C6cg/AeGihAj4s78N/9evBezF
P4BaNSvLkrG/8SjZqc8+wz+j/qFIAtuuvxNWyA1g4cA/6Z7r31QQq7/pDEu3
bae9P9SVRxyOxae/5MoefQ==
       "]]}}, 
    {RGBColor[0.2947336, 0.4054232, 0.5678384000000001], 
     {Arrowheads[{{0.025356199595745504`, 1.}}], ArrowBox[CompressedData["
1:eJwBIQLe/SFib1JlAgAAACEAAAACAAAAdHryGv6m2b8AAAAAAADwPzTEhENt
VNm/kgeo1ACZ7z9kJgMBpprYv03qyP5Ase4/YB0/1nza17+cQOHwisHtPyyp
OMPxE9e/gArxqt7J7D8gGBYLsUfWvwr6fBATy+s/lrj98GZ21b9EwQkF/8Xq
P5GK73QToNS/N2CXiKK66T8OjuuWtsTTv97WJZv9qOg/yf+SDt8t0787pUih
0uznP9H0uvZ6ldK/4OfX9rgu5z/IghSIgrTRv86AdT0VFuY/8ieczF7S0L90
ml8n/PvkP+wgl5xu5c+/GHmFvvzk4z80W/RoqCjOv0xbl/+Rz+I/zH9gXU9y
zL/QpOFgKb7hP87O+R6Cw8q/+ukOrHWx4D/MVxHmxiLJv62PpkYRW98/QcA2
9fCNx79saeULDmLdP/zQe1HxGMa//fuk6sGQ2z8OH+S9WbLEvw9junZu0dk/
dqpvOipaw7+kniWwEyTYPzlzHsdiEMK/vK7mlrGI1j9Abx8S9dXAv/ut/6Z1
ANU/7ihDk6VXv78Ft3JcjYzTP8HFSdv3I72/3Mk/t/gs0j/3tFL84BC7v37m
Zre34dA/fuLQTt9Ht7/G3wq2pQrNP3UJIxAI+LO/4Qsh9QHpyD8m7JPGypKx
v0ZZrowF7MU/RPeHmwHbrr8SMjeNzz7DP9RvZktUEKu/R5a79l/hwD/+QcOc
jcWnv8YLd5Jtp70/H+QptQ==
       "]]}}, 
    {RGBColor[0.2947336, 0.4054232, 0.5678384000000001], 
     {Arrowheads[{{0.02597515841807341, 1.}}], ArrowBox[CompressedData["
1:eJwBIQLe/SFib1JlAgAAACEAAAACAAAAyHh7+PlO2z8AAAAAAADwvzzJSQjL
wNo/Ij5O3GNZ7786Zfb1EPTZP8CbY+99ae6/GRcvWuof2T+OeLX35HDtv/Pq
LYfkRNg/UYXGjj5w7L/e7CzPjGPXP8ZyGU4waOu/3BwsMuN71j/yQK41uljq
v+l6K7DnjdU/0e+ERdxB6b/iGAKar/DUP3Wu7bahiei/UnPs7X5R1D+todHi
F8/nv3YU9kfNYNM/KK2Cjgy15r+FAv075m3SP6N6DrJqmOW/PgQWuLZ80T8F
HzPgy33kv7csOsLvi9A/Az6xkqdj479gmtKsD3jPPwWxT/sHcOK/q2W/sN7c
zT+1ZqdsHX/hvzop0n+IS8w/gYOZ9/iT4L8Va9h0TsLKP4n2tdcpW9+/qbei
AEo7yT8ou3+B+JDdv/qX6N/MwMc/4t91gHXV278JDKoS11LGP7pkmNSgKNq/
1hPnmGjxxD+xSed9eorYv6AP3yj8ncM/hFxSQr781r+pX9F4DFrCP/Vqyecn
gdW/7wO+iJklwT8DdUxutxfUv3T8pFijAMA/sHrb1WzA0r84AsycwMm7Pzs0
dyfvR9C/DQkx4OwMuD/hpex3qS7MvzgDYIF/DbU/tgFexWSryL8ouElG3F+y
P44plE73h8W/2ifuLgMEsD9oHY8TYcTCv6Okmnbo86s/SN1OFKJgwL+kJWJX
T2SmPxON92oZPbq/5BEgXw==
       "]]}}, 
    {RGBColor[0.2947336, 0.4054232, 0.5678384000000001], 
     {Arrowheads[{{0.025975242335923958`, 1.}}], ArrowBox[CompressedData["
1:eJwBIQLe/SFib1JlAgAAACEAAAACAAAAAAAAAAAA8L+T/I/hA0/bP3YuvDtj
We+/AB69NNTA2j9LRF5afWnuv6bz+OEZ9Nk/yUPQbeRw7b+mfLIC8x/ZP548
Sw8+cOy/ujgY6exE2D9zPgjYL2jrv5unWOeUY9c/TEkHyLlY6r9OyXP96nvW
PyZdSN/bQem/0J1pK++N1T99v4VeoYnov/Vz/+e28NQ/GL/slxfP5780R6wN
hlHUP6bxqVUMtea/fDLDH9Rg0z/2VhCKapjlv1N3BcrsbdI/ytFSx8t95L/e
xH37vHzRP+NrYIenY+O/EjbTufWL0D8qIsJ/BnDiv9DnnJAYeM8/0Hu/iRp/
4b+YFfmZ5NzNP4Sg6cP0k+C/NkeVmItLzD8ZBsvyHlvfv2xh095Owso/gPcq
KeuQ3b827UfFRzvJPzq9/uxl1du/wETLM8jAxz9JV0Y+jyjavwtoXSrQUsY/
rMUBHWeK2L8WV/6oX/HEP8nZq1Gp/Na/tnSiaPGdwz8IZb+kEYHVv8QjPiIA
WsI/aGc8FqAX1L87ZNHViyXBP+fgIqZUwNK/HTZcg5QAwD9yoffl1UfQvzYl
Lpefybs/nx0SUnYuzL9re1r0yQy4P54+v5E6q8i/V56BIWMNtT8Q8cTr1IfF
v74hFJnFX7I/9jQjYEXEwr+gBRJb8QOwP1MK2u6LYMC/ApT2zszzqz8nkz6d
9Ty6v9+zsuk4ZKY/1OQetg==
       "]]}}, 
    {RGBColor[0.2947336, 0.4054232, 0.5678384000000001], 
     {Arrowheads[{{0.025973752172930395`, 1.}}], ArrowBox[CompressedData["
1:eJwBIQLe/SFib1JlAgAAACEAAAACAAAAAAAAAAAA8D8XtTvx303bPzRE2FeL
We8/CsbBbdi/2j8m2Hzao2nuP0ZGEUgl89k/ZBdjSglx7T+NlcneBR/ZPzsn
zkRhcOw/WMWkgQdE2D/4LAFnUWjrPxXnXIC3Ytc/nij8sNlY6j/L+vHaFXvW
PykavyL6Qek/dwBkkSKN1T9lFs0+vonoP6MXpa/v79Q/NCXtFTPP5z9RwNVM
xFDUP7PbGkQlteY/wNusPBpg0z/sz5zxgJjlP/8aseM6bdI/dHzGw9995D8y
JEgXE3zRP3K4Ji65Y+M/pWql5VOL0D8aEYDtKXDiPyy51ZsEd88/1Qq3Tk9/
4T9U8q9o/9vNP2NAq8E5lOA/QISg2NJKzD8Ip3mXx1vfPxzDD7TAwco/2Pvl
9bGR3T+5V+qp4zrJP+toHxdI1ts/yUQaQIvAxz9C7iX7iSnaP0yKn3a3UsY/
2Iv5oXeL2D9AKHpNaPHEP0T+RrTM/dY/Zo2qUhiewz8SArvaRILVP3goMRRC
WsI/RJdVFeAY1D95+Q2S5SXBP9q9FmSewdI/aABBzAIBwD8N7kdZK0nQP0ob
nji9yrs/C4MTqyUxzD+JWwFWEw64P0JNeLJyrcg/n5FS1WYOtT8fJizbpInF
P/xKLgeNYLI/oQ0vJbzFwj+dh5TrhQSwP8sDgZC4YcA/DI8KBaP0qz/YAOsp
2z66P0jNnNbnZKY/H0cCZA==
       "]]}}, 
    {RGBColor[0.2947336, 0.4054232, 0.5678384000000001], 
     {Arrowheads[{{0.025973744087387212`, 1.}}], ArrowBox[CompressedData["
1:eJwBIQLe/SFib1JlAgAAACEAAAACAAAAQGSmL99N2z8AAAAAAADwP9bkarLX
v9o/LHSNWotZ7z86NcCRJPPZP/gWcNyjae4/cpLBLQUf2T+bhaVLCXHtP0Ka
K9YGRNg/Fnh4RWFw7D9q6rratmLXP16mM2dRaOs/74JvOxV71j94ENew2Vjq
P81jSfghjdU/YLZiIvpB6T/M2eoZ7+/UPzSHSz2+ieg/HluSusNQ1D/0YVAT
M8/nP5aSFbAZYNM/pjZUQCW15j+ocvNcOm3SP99Iz+yAmOU/ArJ9lhJ80T9k
Ux6+333kPxJp7mpTi9A/7xfNJ7lj4z/cAE/0A3fPP5I3Dg4qcOI/wGNXDf/b
zT+Mpz2VT3/hPzitJMXSSsw/nnPLKzqU4D/NofzkwMHKPxGFJK/IW98/OgtI
HuQ6yT+vJutPs5HdP3QJhfKLwMc/ktWVrUnW2z97nLNhuFLGP7mRJMiLKdo/
TsTTa2nxxD8jW5efeYvYP6vIoJ4ZnsM/SCxW3M791j9O8dWHQ1rCP5r/yCZH
gtU/OD5zJ+clwT8e1e9+4hjUP2iveH0EAcA/z6zK5KDB0j8qM4TrwMq7P+SJ
nvctSdA/m5VwMxcOuD/9e436KjHMP/egpfxpDrU/2oyZE3etyD90/tmPj2Cy
P6UUGmyoicU/FK4N7YcEsD9eEw8Ev8XCP6RfgSim9Ks/A4l427phwD8e96th
6mSmP1RcBt/ePro/bVMKAQ==
       "]]}}, 
    {RGBColor[0.2947336, 0.4054232, 0.5678384000000001], 
     {Arrowheads[{{0.02666019799211857, 1.}}], ArrowBox[CompressedData["
1:eJwBUQKu/SFib1JlAgAAACQAAAACAAAAAAAAAAAA8L9DEwaqVxzlv0VvpI2y
7O+/J85UvpsP5b+GuY1WkjPvv/N+1qJ6leS/bFaRsOly7r9IeY1SYRbkv/JF
r5u4qu2/Ir15zU+S478ZiOcX/9rsv4JKmxNGCeO/4hw6Jb0D7L9qIfIkRHvi
v5f0sRoHc+u/o8BPgswb4r/m0Pz+3d7qv9+oRU4OuuG/yPFWGXwN6r8iNU2c
7C/hv8b10nMyNum/Jqp1meWh4L+4jFmfJ1rov/99vZm7EOC/rSada/l457+m
EvWsW/jev/39Ja3fmOa/cvoR6qzQ3b8GU/Z5y7Xlv3XzXicQpdy/ySUO0rzP
5L+1/dtkhXXbv0V2bbWz5uO/LhmJogxC2r+EEvBfrvziv3AYyxZHDdm/kshx
DasT4r8Lzgb41dnXv2yY8r2pK+G//Dk8Rrmn1r8SgnJxqkTgv0VcawHxdtW/
8vqJWajB3r8JPv0vVErUvygFe+mbBN2/a+ha2Lkk07/EIriSL1Lbv2tbhPoh
BtK/x1NBVWOq2b8Il3mWjO7Qv8twQLjnBdi/19u6Fk6yz78vDNEvuG3Wv/Xa
BaS8l82/wlkpkufj1L/6o046IZDLv1GNf7WIatO/cq8PPzieyb+s2glwrgPS
v+51wxe+xMe/oXX+l2ux0L/4b+QpbwbGv/0jJwem686/IRbt2gdmxL8kx/4R
76XMv/XgV5BE5sK/HCXAnYnZyb/M2LZ4pw3Bv5eNd0KqTce/pg4hDze/vr+u
xHdODP7Ev7Gp/MCfsru/ARlOmA==
       "]]}}, 
    {RGBColor[0.2947336, 0.4054232, 0.5678384000000001], 
     {Arrowheads[{{0.026660297779174728`, 1.}}], ArrowBox[CompressedData["
1:eJwBUQKu/SFib1JlAgAAACQAAAACAAAAzW92dFkc5b8AAAAAAADwvz0jJw2a
D+W/JHjAR63s778Gi5QqeZXkv7z5pXaNM++/iNiYGWAW5L9NpPVA5XLuv8IL
NNpOkuO/1nevprSq7b+0JGZsRQnjv1h006f72uy/XyMv0EN74r/SmWFEugPs
v+NjESDMG+K/mFWwMQRz678z2YfeDbrhv7nPFg7b3uq/Zy9GEuwv4b9en1sS
eQ3qv7aQBvXkoeC/rcUTVy826b+ov53buhDgvxrMU24kWui/I0w0/ln43r9/
L2on9njnv9lWyQmr0N2/OmdrVtyY5r9CTGEYDqXcv5ekGBPIteW/YCz8KYN1
27+Y53Fduc/kvzH3mT4KQtq/OzB3NbDm47+8yMyNRA3Zv2ddvdeq/OK/Cr0m
T9PZ17/+TdmApxPivxnUp4K2p9a/BALLMKYr4b/qDVAo7nbVv3Z5kuemROC/
Xl/LRlFK1L9kTQ5UocHev1q9xeS2JNO/LPgA+pQE3b/eJz8CHwbSv0Dz/MAo
Utu/5543n4nu0L+kPgKpXKrZv592Zt5Fss+/Lzmuc98F2L+6hwpKspfNv3Ya
UXCubda/HoM57hSQy786t4163OPUv8Z60Tcqnsm/PuQGbnxq07+zgLCTrsTH
v0J2XyahA9K/4qa0bl4Gxr8HQjp/XbHQv1D/uzX2ZcS/ojh0qIjrzr/9m6RV
MubCv76zAwLRpcy/96vOjJYNwb8pdgbGbdnJv3vbQtsXv76/AOpXopBNx785
LjIag7K7v5uMgM/0/cS/YENCGA==
       "]]}}, 
    {RGBColor[0.2947336, 0.4054232, 0.5678384000000001], 
     {Arrowheads[{{0.026661641981432498`, 1.}}], ArrowBox[CompressedData["
1:eJwBUQKu/SFib1JlAgAAACQAAAACAAAAAAAAAAAA8D8ZCzeAHxzlvxpCbrVx
7O8/6fOF7zgP5b/V/PubWDPvPwe/psodleS/mVTa2rdy7j+4IaABCxbkv2dJ
CXKPqu0//RtylACS479A24hh39rsP9atHIP+COO/JApZqacD7D9D15/NBHvi
v/qHzzPwcus/5TCBOY0b4r+Y2tKtxd7qP0RHgxrPueG/NIViy2AN6j/ctYLf
rC/hv8ch4yUUNuk/5WflW6Wh4L8XmmNoBlroPzbm5PJ6EOC/kPXeWdV45z8Q
sYax2ffevzZF7M+4mOY/Uo5LUSrQ3b9YYBj+obXlP8lE3jaNpNy//kZj5JDP
5D9+1D5iAnXbvyH5zIKF5uM/bD1t04lB2r+g6LknfvziP/01Q9LEDNm/VIeO
IXkT4j+WdJqmVNnXvz/VSnB2K+E/PflyUDmn1r9g0u4TdkTgP+vDzM9ydtW/
s9mnKj7B3j+HktEo2EnUv5clp/owBN0/7iKrX0Ak079xiNuXxFHbPyJ1WXSr
BdK/PgJFAvmp2T8iidxmGe7Qv3GbY7RZBdg/iKiZZD6xz7/tBJL1CG3WP9Uv
9LiGls2/9HrDEBrj1D+gEwHDyI7Lv9Q561CgadM/a7/4esGcyb/XffwArwLS
P7CeE9ktw8e/Q4Pqa1mw0D/rHIrVygTGv8IMUbll6c4/l6WUaFVkxL/4hlM8
naPMPzGka4qK5MK/BcP+pGLXyT96HMmiDgzBvx/gp3KuS8c//pEURUe8vr9m
E3YjOvzEP4CvIwXvr7u/lkM64g==
       "]]}}, 
    {RGBColor[0.2947336, 0.4054232, 0.5678384000000001], 
     {Arrowheads[{{0.026661644501766023`, 1.}}], ArrowBox[CompressedData["
1:eJwBUQKu/SFib1JlAgAAACQAAAACAAAAUEMfIB8c5b8AAAAAAADwPz1uF4M4
D+W/PPdgonHs7z8CMUJjHZXkv6OOR41YM+8/fGKznwoW5L+M/QLRt3LuP6wC
azgAkuO/+EOTbY+q7T+TEWkt/gjjv+Vh+GLf2uw/L4+tfgR74r9WVzKxpwPs
Pz+8SuuMG+K/WswyOvBy6z8TaxHNzrnhv5itvbLF3uo/lCumkqwv4b+AhnbN
YA3qP5eHqg+loeC/CSYYJRQ26T/6h2GnehDgvwAaxWQGWug/jlMUHNn33r/M
3XFT1XjnPxXfdr0p0N2/5I68xriY5j9IPd+kjKTcv2rqQvKhteU/KG5N0gF1
279c8ATWkM/kP7RxwUWJQdq/vaACcoXm4z/MKB1HxAzZv8iwrxR+/OI/TXRC
HlTZ17+41X8MeRPiPzZUMcs4p9a/jQ9zWXYr4T+MyOlNcnbVv0peift1ROA/
nlaPqtdJ1L+qikL3PcHeP8KDReU/JNO/LJAyxTAE3T/3Twz+qgXSvxvN4mDE
Uds/QLvj9Bju0L94QVPK+KnZP9jDFmc9sc+/LzuWYVkF2D/K2/qjhZbNvx91
uYkIbdY/Qy8QmceOy79qbQWOGePUPyYv8z7AnMm/LqLCuZ9p0z9jTECOLMPH
v5CROViuAtI/5veTf8kExr+zubK0WLDQP5aiigtUZMS/cDHtNGTpzj9evcAq
ieTCv35Zm6mbo8w/8NNIXg0Mwb/5pbguYdfJP3IMdPFEvL6/vbQ/Ga1Lxz9s
Ikzk7K+7v76JB+Y4/MQ/VFkwLw==
       "]]}}, 
    {RGBColor[0.2947336, 0.4054232, 0.5678384000000001], 
     {Arrowheads[{{0.026424288547255932`, 1.}}], ArrowBox[CompressedData["
1:eJwBMQLO/SFib1JlAgAAACIAAAACAAAA2PrB3Iie5T8AAAAAAADwP6QuzxUZ
QeU/dZ1/47J17z9VLtR6RsjkP2r3LKDcwu4/iNei571K5D/QfoVVDQnuPz8q
O1x/yOM/pzOJA0VI7T95Jp3YikHjP+8VOKqDgOw/NszIXOC14j+oJZJJybHr
P3UMYDpoVOI/74EbH4Qh6z/SHW63ofDhP+n1TBrVjeo/SmlzYk1j4T/Rn8Nm
pLzpP/m/BxMG0uA/QKk2Spvl6D+p3+wanD3gP4q0QB3uCeg/2rwZE5RL3z9C
Nq4XNinnPxqze3BuHd4/tmXeJplJ5j/0WJebdevcPxBn94YnZ+U/Z65slKm1
2z9SOvk34YHkP3Oz+1oKfNo/et/jOcaZ4z88xpATUUHZP5orln3asOI/5kR4
4jYI2D/E8+7zIcnhP3Evsse70NY/9zfunJzi4D/dhT7D35rVP2bwJ/GU+t8/
TyLM3IVp1D9r6NLvnDbeP+7eCRyRP9M/dtfvF5d93D+3u/eAAR3SP4i9fmmD
z9o/rLiVC9cB0T+hmn/kYSzZP+fDQhCVrM8/wPyJfwBx1z/Cu5E5dWjNP+Lz
LdCpw9U/SY80jZI6yz9+vBWHyCbUP+p0RwUxJsk/EpPrVMec0j8Io+ablC7H
Pxa0WeoQKNE/DlAuSwFXxT8OuBTwH5bPP2CyOg27osM/vo5PXV4QzT9oACjc
BRXCPzFluH2yw8o/4SJm9Tyxvj9Mvrax/LbGP5jcGAE=
       "]]}}, 
    {RGBColor[0.2947336, 0.4054232, 0.5678384000000001], 
     {Arrowheads[{{0.026424284493393884`, 1.}}], ArrowBox[CompressedData["
1:eJwBMQLO/SFib1JlAgAAACIAAAACAAAAAAAAAAAA8D8aGLIxiZ7lPxQlcumy
de8/t9NUbRlB5T8lp22j3MLuP7gTrc5GyOQ/7dbAVQ0J7j+3EYQ3vkrkP2i0
awBFSO0/s83Zp3/I4z+VP26jg4DsP6pHrh+LQeM/dnjIPsmx6z+efwGf4LXi
P2dxhhWEIes/gk/qe2hU4j8twe4R1Y3qP5plQvih8OE/iAC8YKS86T8q17Ci
TWPhP2zijEab5eg/9LejUgbS4D+HZewb7gnoP1Rn1VmcPeA/9TSsGDYp5z9Y
4GSPlEvfPz4mJSqZSeY/VeM5624d3j+Qp3CMJ2flP917mxR269w/7LiOP+GB
5D/vqYkLqrXbP1Faf0PGmeM/jG0E0Ap82j8JRBWJ2rDiP/15UoZRQdk/YC4j
ASLJ4T+OgrpSNwjYP1UZqauc4uA/PYc8NbzQ1j/PCU4RlfrfPwyI2C3gmtU/
Bz1EEp023j89NkNEhmnUPygnPzyXfdw/FUMxgJE/0z8yyD6Pg8/aP5OuouEB
HdI/IiBDC2Is2T+1eJdo1wHRP1wMy8MAcdc/noDt6JWszz9DmOkvqsPVP5pv
di52aM0/IPHf/8gm1D881GSbkzrLPzhE7+PHnNI/YMRTKTImyT/UvliMESjR
P+RV3tGVLsc/eBy7UiGWzz+onp+OAlfFP2u/fdZfEM0/hLQyWbyiwz8UwXsE
tMPKP1qtMisHFcI/kl1WQv62xj9gyE6LP7G+PwRZCgE=
       "]]}}, 
    {RGBColor[0.2947336, 0.4054232, 0.5678384000000001], 
     {Arrowheads[{{0.026424775142668437`, 1.}}], ArrowBox[CompressedData["
1:eJwBMQLO/SFib1JlAgAAACIAAAACAAAA7mSg2CCf5T8AAAAAAADwv66YdGqI
QeU/XgvyhHp177+cPMXcssjkP9ogwM2kwu6/rwacLidL5D+gr6UE1gjuv+r2
+F/lyOM/sLeiKQ5I7b9LDdxw7UHjPwo5tzxNgOy/0klFYT+24j+vM+M9k7Hr
v0qJ5YXFVOI/toDofE8h67+ZMJo+/fDhP4Iau+ihjeq/VFQooqZj4T8IFx6U
c7zpv+MBx/lc0uA/yumv5Wzl6L/YnqyX8D3gP3hpQC7CCei/V704FjhM3z8t
+TSoDCnnv+SYAIANHt4/pgw0MXJJ5r/1ca2aD+zcP6w3rAkDZ+W/jkg/Zj62
2z8/ep0xv4Hkv6wctuKZfNo/YNQHqaaZ479hHLY720HZPxp8Dli9sOK/t3Xj
nLsI2D91p9QmB8nhv7EoPgY70dY/clZaFYTi4L9ONcZ3WZvVPyISP0do+t+/
tQUeBfpp1D+m9QF5dDbevw4E6MH/P9M/cM62lXJ93L9XMCSuah3SP4GcXZ1i
z9q/kIrSyToC0T/XX/aPRCzZv2sTN3Rerc8/hx5gwPBw17+UN6LuP2nNP9lT
adSmw9W/ghNq2107yz8y0eJS0SbUvxo5EhP8Jsk/8medwtqc0r9EOh5uXi/H
P3vpaaotKNG/66gRxchXxT9cTjIiaZbPv/AWcPB+o8M/2+T3+rMQzb88Fr3I
xBXCPzU5xuwQxMq/DNImfaKyvj/syUOZZbfGv+p3IRU=
       "]]}}, 
    {RGBColor[0.2947336, 0.4054232, 0.5678384000000001], 
     {Arrowheads[{{0.026424750675731044`, 1.}}], ArrowBox[CompressedData["
1:eJwBMQLO/SFib1JlAgAAACIAAAACAAAAAAAAAAAA8L+U7kQyJJ/lP4J6mUh6
de+/7FfSjItB5T8II9d/pMLuv8DXi+C1yOQ/xojaotUI7r9Qb38RKkvkP8Cr
o7ENSO2/nR6tH+jI4z/zizKsTIDsv6XlFAvwQeM/YSmHkpKx679qxLbTQbbi
P9bgYdxOIeu/FHaO8MdU4j9VMiZToY3qv10zMqH/8OE/qArjEnO86b99MJr8
qGPhP48AHHls5ei/YUaqS1/S4D8iSyfWwQnov0r0ZuDyPeA/BdiSZAwp57+b
H0iUPEzfPx3wvAFySea/Xk1/6hEe3j/tYMTtAmflv8pDMfAT7Nw/dyqpKL+B
5L/iAl6lQrbbP7hMa7KmmeO/oooFCp582j9H8spyvbDiv+w2sknfQdk/tkWI
UQfJ4b+YY+6PvwjYPwhHo06E4uC/qhC63D7R1j917DfUaPrfvx8+FTBdm9U/
DeNPHXU23r/i/t+d/WnUP0qu+U1zfdy/22X6OQNA0z8qTjVmY8/avwpzZARu
HdI/rcICZkUs2b9tJh79PQLRP/k4rHnycNe/TK8SsWWtzz+O/KVhqcPVvxaO
AvBHac0//jCjodQm1L+yC9uLZjvLP+T5Vr3enNK/oEprWQUnyT/SenQ4MijR
v1xtgi1oL8c/xK5dLXOWz79mlu/c0lfFP09mcre+EM2/OeiBPImjwz9zY40W
HMTKv1iFCCHPFcI/hUW9GXG3xr/azdXJtrK+P2A3Ibg=
       "]]}}, 
    {RGBColor[0.2947336, 0.4054232, 0.5678384000000001], 
     {Arrowheads[{{0.021104357829842015`, 1.}}], ArrowBox[CompressedData["
1:eJwBwQE+/iFib1JlAgAAABsAAAACAAAAAAAAAAAA8L+bEVSUEzvHv5zQ6GAL
Te+/0VR3YSm5xr9ZnNLYrw/uv28Ut7TF0sW/I/BjTKvG7L/O0xQG6+PEvx1S
TY80Buy/dFF9XTJYxL9AljAOhULrv/1aX/UiysO/4rlFaMvz6b8Q3waTI9fC
v/PfhjkOn+i/psQjjMbfwb9weJ8Em0rnv/BsZTmf6MC/BF5W81f05b8Wb81P
TuC/v0XLhwTWMuW/MqyXDFnHvr+If80BF3Tkvwis5i5msr2/AB3ow3K2479c
kzfgDZ+8v91FmCNB+OK/8oYHSuiKu7/y5Mebl+Thv2NRUsSq+rm/Gmc34MrW
4L+OqZZJ8HK4v/ruICLZpN+/IBNtXef4tr9wDzVHmKzdv+EM+NPVirW/aQGk
tI25279fGMrtjCC0vz8Wl+Qj3Nm/YnQNgffFsr/3TQ7XWhTYv+wgwo0Ve7G/
jqgJjDJi1r/4HegT5z+wvwg9NkB4xtS/I40CJAIqrr9qIkEw+UHTv4LrHg3x
9au/tFgqXLXU0b8KVyXjmuOpv+bf8cOsftC/vM8Vpv/yp78KlO/FlCbMv4De
9Umzb6S/bkr0ZQ==
       "]]}}, 
    {RGBColor[0.2947336, 0.4054232, 0.5678384000000001], 
     {Arrowheads[{{0.021104367205979687`, 1.}}], ArrowBox[CompressedData["
1:eJwBwQE+/iFib1JlAgAAABsAAAACAAAAM6l2viI7x78AAAAAAADwv9Sb1c81
uca/srjREQhN77+cszit0dLFv/FAi7asD+6/oKF4h/bjxL+jd85cqMbsv0AA
doA9WMS/boNLmzEG7L/4cg+5LcrDv1nDqxaCQuu/7GHO0i3Xwr+uqo2VyPPp
vynhjUjQ38G/lERIkAuf6L9onyt1qOjAv6zKaoiYSue/1sQQyl/gv79t1Bqo
VfTlv2EHP4lqx76/CtlCOdQy5b+yCFitd7K9v2abR7QVdOS/VVY1YB+fvL9D
Qz7zcbbjv859sMv5iru/Xvg70ED44r9Mrmsyu/q5vyyzkz6X5OG/IYZuqv9y
uL9tUq95ytbgvzjtb7v1+La/3p50RNik37+Y6zI444q1vy6uoVqXrN2/myLj
cJkgtL8anrbXjLnbv7ym6ywDxrK/Zk7VFiPc2b/+d0xsIHuxvxm//RdaFNi/
YJYFL/E/sL8u8C/bMWLWv9IfxucUKq6/hTT5nHfG1L845WFzAvarv/be5pn4
QdO/+HzeAKvjqb+F7/jRtNTRvxDnO5AO86e/MWYvRax+0L/DPBgHwG+kvzwY
yPGTJsy/Acv7xQ==
       "]]}}, 
    {RGBColor[0.2947336, 0.4054232, 0.5678384000000001], 
     {Arrowheads[{{0.021104519342325274`, 1.}}], ArrowBox[CompressedData["
1:eJwBwQE+/iFib1JlAgAAABsAAAACAAAAAAAAAAAA8D96qSHrCTzHv0EGXU7K
TO8/mos7F+u5xr+SxIo0cg/uPxVuH12A08W/MqQWjXHG7D8VV5CdnuTEvziL
aGH6Bew/y5QR299YxL9ZERCESkLrP7Kfk03KysO/ct3uhJPz6T9mfFbHwtfC
v2VsGlvZnug/fWObsl3gwb/8utZ1aUrnP7jof4ou6cC/8nRiBSr05T+qtUmh
XeG/v7LVlm6yMuU/2BwhwGvIvr8aFkqW/XPkP5Jezyx8s72/xnyWcGO24z+E
xAYfJ6C8v09QlvE7+OI/Wph5zgSMu78csfd6keThP0zC1Vm1+7m/2JCY3MPW
4D90gtpb6XO4v8w2gYPJpN8/CpA3n8/5tr/3LgU4h6zdP1IDXeCti7W/HuFG
rH252z8wrFi3ViG0v6Klg90U3Nk/VEE/qrPGsr+BfLvLTBTYP8DCELnEe7G/
umXudiVi1j9yMM3jiUCwvz9nERlsxtQ/wtxRWjArrr/8hhns7UHTPwLBsC8J
96u/8cQG8KrU0T+kDbdHnuSpvx8h2SSjftA/psJkou/zp78U0cR1hCbMP/wB
sCaAcKS/WuTr+Q==
       "]]}}, 
    {RGBColor[0.2947336, 0.4054232, 0.5678384000000001], 
     {Arrowheads[{{0.021104519367808793`, 1.}}], ArrowBox[CompressedData["
1:eJwBwQE+/iFib1JlAgAAABsAAAACAAAAIPK9tAk8x78AAAAAAADwP6Jaqcbq
uca/+nSqKMpM7z8f9hEQgNPFv67cyRByD+4/Kq1VVJ7kxL9KpZdrccbsPwZf
rpLfWMS/Nr5PP/oF7D9BQxYGysrDvyy/aWFKQus/3LCzgsLXwr9TMSdjk/Pp
P4cMC3Fd4MG/s0xwOtme6D+xvS1MLunAv/4Kh1ZpSuc/w0OBK13hv7+kw6rn
KfTlP+58dVhryL6/iSfSWLIy5T8G0QXTe7O9v8JsVoj9c+Q/f8kH0yagvL9Q
P2ZqY7bjP8bvUJAEjLu/M0sw8zv44j9nt5Idtfu5vxbHWnuR5OE/PIF9Ielz
uL+XxdLbw9bgP5qZxGbP+ba/5onVf8mk3z8O59aprYu1v9bgYzKHrN0/mGoV
hFYhtL+TMZOmfbnbP/RoInqzxrK/HQnJ1xTc2T8l4v2LxHuxv3dnBcZMFNg/
KtanuYlAsL+jTEhxJWLWPxzHogswK66/nx2EE2zG1D+5UVfmCPerv24/q+bt
QdM/LExtA57kqb8Ssr3qqtTRP3S25GLv86e/inW7H6N+0D+gcPXvf3Ckv25K
SmyEJsw/qP3q+Q==
       "]]}}, 
    {RGBColor[0.2947336, 0.4054232, 0.5678384000000001], 
     {Arrowheads[{{0.02156067589431821, 1.}}], ArrowBox[CompressedData["
1:eJwBoQFe/iFib1JlAgAAABkAAAACAAAADtXv6ia4yz8AAAAAAADwvzeWF05V
n8o/YoZpldC77r8xh1FfgnfJP1jtVaNOZu2/0ggMVOzUyD+dAAj3nKrsv/lD
7OlWL8g/OZvianXr67+obKlXkAzHP6//ImnHm+q/2fs+gGnjxT9Y95EQvUTp
vzBGvdgyucQ/IrUl7njs57/QhMnkJozDPxQojH3vkOa/KF+HPseIwj+xfA7Y
gWXlv0SbgcXMh8E/Tp/wENg85L8qObh5N4nAP+6PMijyFuO/qnFWtg4avz+P
TtQd0PPhv2TPTTTTK70/0KIr8ojW4L9XJu/NFk27P6KoHEtnhN+/hHY6g9l9
uT8jxvhvoG3dv+i/L1Qbvrc/JJ7rUr1o279iuPtnxhC2PwrRUFUbedm/zhXL
5cR4tD85/4PYF6LXvynYnc0W9rI/sSiF3LLj1b91/3MfvIixP3FNVGHsPdS/
H4ONscytrz91TrOAF0nSvwg0Vqwujqw/GVvelIp70L+iEUIvnrKpP7rmqjuL
qs2/7BtROhsbpz9+LjE3kazKv6QV1io=
       "]]}}, 
    {RGBColor[0.2947336, 0.4054232, 0.5678384000000001], 
     {Arrowheads[{{0.021560682157148306`, 1.}}], ArrowBox[CompressedData["
1:eJwBoQFe/iFib1JlAgAAABkAAAACAAAAAAAAAAAA8L+hraDXObjLP5NmHLvQ
u+6/Zdu3m2efyj/YPybCTmbtv9rrA92Td8k/kbmjIJ2q7L9y9Bds/dTIPy9q
HZ916+u/N20fmmcvyD90LRCux5vqv01yzk+gDMc/MaIPZb1E6b8QYAC7eOPF
PwpTEFB57Oe/yymHU0G5xD/HERbr75Dmv7vTHJw0jMM/2k2PRIJl5b+xnuBD
1IjCP6CC/XrYPOS/fx9JGdmHwT8YsGCO8hbjvyRWVhxDicA/Q9a4ftDz4b9C
hRCaJBq/P7zpvUyJ1uC/4RCou+crvT80vk/yZ4Tfvw+WXQIqTbs/wWztB6Ft
3b/UFDFu6325Px7fVNq9aNu/LY0i/yu+tz/N2rnLG3nZv65aF9/VELY/TiVQ
Phii17/m2PQ303i0P6S+FzKz49W/2we7CST2sj/QphCn7D3Uv4vnaVTIiLE/
Lwl+4hdJ0r8aQrT74q2vP1KcWQ2Le9C/sMDh+0KOrD97wEZPjKrNv9pKXKmw
sqk/3qm2YpKsyr+Y4CMELBunP1hT1eQ=
       "]]}}, 
    {RGBColor[0.2947336, 0.4054232, 0.5678384000000001], 
     {Arrowheads[{{0.021560482966225796`, 1.}}], ArrowBox[CompressedData["
1:eJwBoQFe/iFib1JlAgAAABkAAAACAAAAAAAAAAAA8D866mdaWLbLP1kMiM7a
u+4/KE0n5qGdyj+4KJ9wWGbtP6FaieLhdck/UPvG8qWq7D83FfK6VdPIP/pu
g5V96+s/35fjZsotyD86frCVzZvqP2g8Mg8VC8c/S1X8QsFE6T8fySjg/+HF
P5DtjUN77Oc/ZLz5C9u3xD+Snq0K8JDmP2xBlCzhisM/iaC84oFl5T9u4KD9
kYfCP9OfU7DXPOQ/82X/56eGwT9wnHJz8RbjP/rRr+siiMA/YJYZLM/z4T8H
SWQRBhi/P2ZpdNeH1uA/rnbWf+opvT+F4l3lZITfP3TofyRNS7s/7luS+51t
3T9cnmD/LXy5PwY/hvG6aNs/ZJh4EI28tz9FeeQdGXnZP9cqD0VUD7Y/IvhX
1xWi1z8BqmuKbXe0P5674B2x49U/4RWO4Nj0sj+5w37x6j3UP3ZudkeWh7E/
TZG7yBNJ0j81fAadtauvP496bvuEe9A/2rZzdUiMrD/7/i4TfarNP9yMNBjl
sKk/NkBt5oCsyj87/kiFixmnP/uX0sE=
       "]]}}, 
    {RGBColor[0.2947336, 0.4054232, 0.5678384000000001], 
     {Arrowheads[{{0.021560482999463195`, 1.}}], ArrowBox[CompressedData["
1:eJwBoQFe/iFib1JlAgAAABkAAAACAAAAZP8Xj1e2yz8AAAAAAADwP/jfxgqh
nco/eiKxstq77j+K56gR4XXJP0+eHldYZu0/sHf87VTTyD+DY2vYparsP4is
9p3JLcg/9+FVen3r6z8aiaZOFAvHP5xKkXrNm+o/vqZeKP/hxT/EuyQowUTp
PybtMl3at8Q/sd9AKXvs5z/EuRyH4IrDP/rSKvHvkOY/2KChYJGHwj930GzK
gWXlP5jvhlOnhsE/6tRbmdc85D8EpsxfIojAP1bg913xFuM/NYjlCgUYvz+5
8kAYz/PhP0h8eYrpKb0/CP5SxYfW4D/PENw/TEu7P3Lok8RkhN8/ykUNKy18
uT+YqkvenW3dPzUbDUyMvLc/fELN17po2z8fTvWPUw+2P8unpwcZedk/kpvf
42x3tD8q0mnEFaLXP5ADzEfY9LI/nMETDrHj1T8Uhrq7lYexPxp2peTqPdQ/
DqMSm7Srrz/B6vO5E0nSP1xQ0odHjKw/y0go64R70D8UFLQ95LCpP3IghfB8
qs0/Nu63vIoZpz8VgoXCgKzKPwje0pI=
       "]]}}, 
    {RGBColor[0.2947336, 0.4054232, 0.5678384000000001], 
     {Arrowheads[{{0.023655404082934466`, 1.}}], ArrowBox[CompressedData["
1:eJwBEQLu/SFib1JlAgAAACAAAAACAAAAAAAAAAAA8L/IhydGphbqvwr5py1V
VO+/tejQ+bGK6b+Y1/g2H0/uv7tsBD+9tei/nuxsXIPj7b8MFihzAl7ovyDR
m8rwdO2/UDJfGd0D6L+lyKyxd9nsv8nMAqochee/cfoAynE47L+BSQjl1QHn
v44nrnB+keu/SDOrAbp55r/5ZALcveTqvzKx10Lj7OW/HsOajRk46r8Hwx6R
I2Dlv/9yYpDghem/z5AkHtfO5L+idFnkEs7ov48a6en9OOS/BMh/ibAQ6L9F
YGz0l57jv7AtuCxBTue/j3Qu2hMA478yZuV6TIfmvxBqrzfgXeK/inEHdNK7
5b/EQO8M/bfhv7VPHhjT6+S/rPjtWWoO4b/aEUW1oBjkvyodle07YuC/GMmW
mY1D478/c5wtC2nfv3J1E8WZbOK/F5wyq44K3r/mFrs3xZPhv9y07FMCqdy/
Z66KTEn+4L/xkOVZRbXbvy0TQUj6aOC/aZilltHB2r9urMZRdKjfv/6mrNFG
z9m/EBHt2NWA3r9mmHrSRN7Yv0x2/yHdW92/YkiPYGvv178i/gcpTjrcv6aS
akNaA9e/mMoQ6uwc27/rUoxCsRrWv7L9I2F9BNq/7mR0JRA21b8srypLVePX
v5ueX7ededO/HJbKyIjZ1b/mD4s5NtDRv+EY/F1Z69O/7XdY6lE90L+gwCUe

       "]]}}, 
    {RGBColor[0.2947336, 0.4054232, 0.5678384000000001], 
     {Arrowheads[{{0.023655466666256873`, 1.}}], ArrowBox[CompressedData["
1:eJwBEQLu/SFib1JlAgAAACAAAAACAAAAXy+FXqcW6r8AAAAAAADwv/MnB9Ov
ium/ZrBfOVFU778un+6+urXovxm1H+AaT+6/4wke3P9d6L9kdvDtfuPtvy/P
zmraA+i/0K3oQ+x07b+D7DrlGYXnv7A6QBZz2ey/Nhr2CdMB579Kkf8ZbTjs
v6aD3RC3eea/bMEGrXmR67+yb6c84Ozlv3xwYAW55Oq/ZK35dSBg5b8FrIOk
FDjqv/cQP+/TzuS/a3+MltuF6b9xmneo+jjkv7DqetsNzui/z0mjoZSe47/U
7U5zqxDovyYODngQAOO/Y6XfCzxO57+J1gPJ3F3iv+otBFNHh+a/96KElPm3
4b9mh7xIzbvlv3FzkNpmDuG/2rEI7c3r5L8i/cZqOGLgv3v71I6bGOS/YuqP
KQRp3797sg19iEPjv0C3JrGHCt6/3dayt5Rs4r/gYFJs+6jcv6FoxD7Ak+G/
6wBhfz6127/V3eBhRP7gv84Lv8zKwdq/XNAMbvVo4L+lAAscQM/Zv+78t8Jq
qN+/iV7jND7e2L/DTMRzzIDev5mk5t5k79e/swxm69Nb3b/xUbPhUwPXvzm5
xCVFOty/q+XnBKsa1r/Qzgcf5Bzbv+TeIhAKNtW/88lW03QE2r8xP9/7l3nT
vwBna0JN49e/UPba3zDQ0b+yMe1NgdnVv6Pr8fdMPdC/yKOOdlLr0782MTDl

       "]]}}, 
    {RGBColor[0.2947336, 0.4054232, 0.5678384000000001], 
     {Arrowheads[{{0.023655692526438094`, 1.}}], ArrowBox[CompressedData["
1:eJwBEQLu/SFib1JlAgAAACAAAAACAAAAAAAAAAAA8D+arBiAPRbqv3B5OcBA
VO8/yXO3vjqK6b8yt3jLAE/uP57dyjVBtei/hY22NmLj7T9lvRGRhV3ov7iw
/NjMdO0/0eSyWV8D6L/SVLLXUNnsP6jMkoiehOe/o1HX/kc47D+QRs5sVwHn
vzIi/rpRkes/kF99Szt55r8mSEs9juTqP6do7WJk7OW/UaHkEOc36j8RrBmQ
pF/lv062PE2rhek/OVR/IVjO5L8fh1Py2s3oPx5hHhd/OOS/whMpAHYQ6D/A
0vZwGZ7jv6ZJnDgETuc/Tvzn2pX/4r86FoxdDYfmP/Uw0QBjXeK/fXn4bpG7
5T+2cLLigLfhv3Fz4WyQ6+Q/kbuLgO8N4b+m61q5XBjkP94AO7XCYeC/rsl4
tkhD4z/uXzy3HGjfv4sNO2RUbOI/tZFq56QJ3r86t6HCf5PhPxSXAPsdqNy/
Stvf1QP+4D+PykrRZLTbv48Zdv20aOA/PmhNJ/XA2r8uENRy6qffP1A8SsVu
ztm/2nmCE02A3j/zEoNzcd3YvzqcAt1VW90/Vrg5+pzu179no1/PyDncP6X4
ryGRAte/druk6mkc2z8RoCey7RnWv4MQ3S79A9o/yHric1I11b+g0iyx2+LX
P3HdDl/seNO/bfJFsBbZ1T9/eBqskc/Rv4pDqXTv6tM/F0v9Wro80L/owRkK

       "]]}}, 
    {RGBColor[0.2947336, 0.4054232, 0.5678384000000001], 
     {Arrowheads[{{0.02365569095905574, 1.}}], ArrowBox[CompressedData["
1:eJwBEQLu/SFib1JlAgAAACAAAAACAAAAioZ66TwW6r8AAAAAAADwP/Lukz06
ium/Ad6y1kBU7z8KqLWyQLXov086q9kAT+4/moP+DYVd6L+1In5CYuPtPzCT
otZeA+i/8VxJ4sx07T/yAxcGnoTnv658M95Q2ew/wEr26lYB579to38CSDjs
PwO6Yso6eea//LfKu1GR6z9CNqbiY+zlv7/CNTuO5Oo/++CrEKRf5b/Z8fQL
5zfqP6T1DKNXzuS/1198RauF6T8+dMmZfjjkv7gMzOfazeg/x1zh9Bie4798
+OPydRDoPxo0PmCV/+K/mKGyKARO5z8Pf8mHYl3iv4CGJksNh+Y/pj2Da4C3
4b82pz9akbvlP99vawvvDeG/uAP+VZDr5D+pzGZCwmHgv1B2haBcGOQ/4xW0
1hto379G2fmbSEPjP3RVigykCd6/myxbSFRs4j8DWFAmHajcv01wqaV/k+E/
Qlz0AGS0279LpTO4A/7gP7s6hFv0wNq/LoU237Ro4D8MQEH+bc7ZvzYbczXq
p98/4bhssXDd2L90eIjVTIDeP97xRz2c7te/Xx28nlVb3T+qNxRqkALXv0gF
HZHIOdw/6NYSAO0Z1r92K7qsaRzbP0EchcdRNdW/Ooui8fwD2j8GvHm+63jT
v9vPGnbb4tc/a6x+F5HP0b/MjB94FtnVP8iyWdK5PNC/mIoMQO/q0z/irxXB

       "]]}}, 
    {RGBColor[0.2947336, 0.4054232, 0.5678384000000001], 
     {Arrowheads[{{0.02348933307310581, 1.}}], ArrowBox[CompressedData["
1:eJwBMQLO/SFib1JlAgAAACIAAAACAAAAXZeqm/1o6j8AAAAAAADwvybsyv3A
AOo/eK9nZ7OB779kpJHx3THpPwTOjV4Gh+6/4Xz7VoPb6D+ew+LAZB7uvySe
ONfGgug/KOJmJ+Cy7b//Tt207gToP14m3UFlGu2/Ne0KdYeC5z/7zb43ZHzs
v0zHxWIy++Y/3tlySGrY679xGLcPD2/mP79JLLSdLuu/PIDVlPji5T8lxgmw
4ITqv2CMhIktUuU/kr80J3DV6b/gPMTtrbzkPwk2rRlMIOm/uZGUwXki5D+F
KXOHdGXov4OG7vbsg+M/fSJ42Fil57/VFst/Y+HiP1+prXRo4Oa/sEIqXN06
4j8wvhNcoxbmvxMKDIxakOE/62CqjglI5b+HAD4t3+LgP3ykbTjWdeS/lLmN
XW8z4D/Im1mFRKHjv3Rq9jkWBN8/0UZudVTK4r/y5gzXZJ3dP5ilqwgG8eG/
7Z28AtSl3D+eCluNClvhvybOK8M0rts/l4jGVQbF4L+P+hl6JbfaP07osVVZ
L+C/HKZGiUTB2T8Y5cEBxzTfv79TcVIwzdg/OuAulgkN3r9qhlk3h9vXP5ZT
MlA66Ny/EMG+mefs1j+/0FMXGcfbv6SGYNvvAdY/Teka02Wq2r/CerqU6xrV
P0+xGBx8ktm/ABBH5Qw41D82FqatmH/Yv8f/Q/nLWdM/qG92I01y1798A+/8
oIDSP0oVPRkra9a/YCxGhG3f0D/Bo3rzqXHUv4TnJjo=
       "]]}}, 
    {RGBColor[0.2947336, 0.4054232, 0.5678384000000001], 
     {Arrowheads[{{0.023489330862793003`, 1.}}], ArrowBox[CompressedData["
1:eJwBMQLO/SFib1JlAgAAACIAAAACAAAAAAAAAAAA8L+s6Ivp/2jqP3fSzKuz
ge+/aqoGe8MA6j+Ba6XPBofuv7kppIHgMek/4wfXP2Ue7r86BvbqhdvoP16w
lrTgsu2/LkU0b8mC6D8v2ordZRrtv/EF1E3xBOg/2CEd4mR87L8JvsAOioLn
PyQmbgFr2Ou/CGK8/DT75j/TXMh7ni7rvxdLhqkRb+Y/TTsThuGE6r81/1Mu
++LlP7ybSAtx1em/f473ITBS5T8jfmgLTSDpv/n4cISwvOQ/geJyhnVl6L+f
PsBVfCLkP+1X9ONZpee/wAqTh++D4z99bXmLaeDmv6gIlwtm4eI/MyMCfaQW
5r9XOMzh3zriPw15jrgKSOW/zZkyCl2Q4T+a47Np13Xkv/7AWaLh4uA/aNcH
vEWh47/gQdHHcTPgP3ZUiq9VyuK/5Dgy9RoE3z/GWjtEB/Hhv2ihYnVpnd0/
PPqpyAtb4b+C9A2L2KXcPxAK948HxeC/O54JNDmu2z8TmtyNWi/gv6PmEtIp
t9o/M3QpbMk037/YFefGSMHZP+7zsvgLDd6/8HNDdDTN2D/40smoPOjcvwBJ
5TuL29c/+DDiYxvH278f3Yl/6+zWP5YtcBFoqtq/Z3juoPMB1j/tTG1KfpLZ
v6GI6zjvGtU/nQrBypp/2L8vh3VnEDjUP5h5RC5Pcte/kc3zWM9Z0z/GrNAQ
LWvWvz+1zTmkgNI/kKtnwqtx1L+CzjF7cN/QP9j3Kkw=
       "]]}}, 
    {RGBColor[0.2947336, 0.4054232, 0.5678384000000001], 
     {Arrowheads[{{0.023488913126545333`, 1.}}], ArrowBox[CompressedData["
1:eJwBMQLO/SFib1JlAgAAACIAAAACAAAAUbkiBlRo6j8AAAAAAADwPztWdjMq
AOo/dixuAseB7z+5jzL/RDHpPyQ+1hIRh+4/DkQvM+ra6D+MWVqZbB7uP2uE
EIEtgug/prViEOWy7T8h8LPmVQToP93+cfxmGu0/TFjPP++B5z8Ib/i0Ynzs
P5qpnuOa+uY/nRRKhWXY6z8llbhfeG7mPx9AoKmVLus/xXc7u2Li5T+UeEJn
1YTqP8ri2q2YUeU/11CBq2HV6T811pY3GrzkP+3IXHY6IOk/BFJvWOch5D/R
4NTHX2XoPzEHOA9cg+M/Jig6GkGl5z+wpsRa1ODiP4Yu3edN4OY/gzAVO1A6
4j/2870whhbmP6ikKbDPj+E/cXjc9OlH5T+kp3XhVuLgP2fyzXO0deQ/+d1s
9uky4D9FmCftIKHjP1CPHt4RA98/CGrpYC/K4j9fybmWZ5zdP7RnE8/f8OE/
OrZIDtyk3D+r9hvG41rhP3Tq5ltCrds/69g6KN/E4D+P9N3gOLbaP2CPVOsx
L+A/CmN3/l3A2T/qNZsKeDTfP2jE/BVQzNg/LvkU2LoM3j8pp7eIrdrXP2Bq
3yrs59w/z5nxtxTs1j9ci8Puy8bbP9oq9AQkAdY/9F2KDxqq2j9rcVT3JhrV
PypelhMyktk/6F+XmE831D9UfCqdUH/YP7dN7gwWWdM/02jgQQdy1z9Akop4
8n/SPwXUUZfnatY/JH1Yxs3e0D8B6M2qa3HUP5htGJU=
       "]]}}, 
    {RGBColor[0.2947336, 0.4054232, 0.5678384000000001], 
     {Arrowheads[{{0.023488914248284566`, 1.}}], ArrowBox[CompressedData["
1:eJwBMQLO/SFib1JlAgAAACIAAAACAAAAAAAAAAAA8D9bXpNUVGjqP8wHGfPG
ge8/IWkKdCoA6j9K6P0GEYfuP3bbQEBFMek/5IKmjmwe7j+Aby506troPzZA
2wblsu0/Tf3/wS2C6D9/BDv0ZhrtP+xJQydWBOg/nekYrmJ87D81yvZ/74Hn
PxrNxH9l2Os/QNxRI5v65j8eZXmllS7rPwe27J54buY/TbN2ZNWE6j+66+35
YuLlP1YiDqph1ek//KD765hR5T88sj92OiDpP9PVFXUavOQ//WILyV9l6D87
ijyV5yHkPw74uhxBpec/YuQ+S1yD4z/dNJjrTeDmP3IK7JXU4OI/bxmjNYYW
5j9u/EN1UDriP8Gl2/rpR+U/VLpG6c+P4T8GlM96tHXkPxHAZBlX4uA/bJ4M
9SCh4z+PiQ4t6jLgP/bEkmkvyuI/ny2ISBID3z+jB2LY3/DhP6PPCv5nnN0/
gK7Fz+Na4T+1yFBz3KTcPxdYMTLfxOA/0z6OvkKt2z+gpIj1MS/gPxUkDUE5
tto/mmheH3g03z+HahdcXsDZP7BOEe26DN4/QQT3cFDM2D/nO/E/7OfcP1Lj
9eCt2tc/qXDFA8zG2z/I+V0NFezWP2MtVSQaqto/uzl5VyQB1j9pcwkoMpLZ
Pzv84kYnGtU/V0QusVB/2D/mQyjlTzfUPwNhX1UHctc/HIF9VhZZ0z9Eijiq
52rWPz4kF7/yf9I/3gVSvGtx1D/LXekGzt7QPxU1EYs=
       "]]}}, 
    {RGBColor[0.2947336, 0.4054232, 0.5678384000000001], 
     {Arrowheads[{{0.019277770175015512`, 1.}}], ArrowBox[CompressedData["
1:eJwBsQFO/iFib1JlAgAAABoAAAACAAAAAAAAAAAA8L//r3V0xsHgv+yKA8Jb
1++/cHLVOn6s4L9mta/RmcDuv86OM0CFGuC/XIdPHqgs7r8YU38OGZrfv4Mn
xc39lO2/Edtd7kH73r/QTR4JuMDsv/xvOlfxHN6/Kph0YQHm679m+33b4Tfd
v4Ji9imZBeu/bE5329tM3L+I4z6cPx/qv7B4YYycW9u/OkaerMk56b/BtQyg
S2vav/Ii8qIpUOi/rO8qKp522b+yeTp/X2Lnv3AmvCqUfdi/eUp3QWtw5r8P
WsChLYDXvy7CinMffOW/y51TK1OA1r+9DVefTofkv+oEkmPtf9W/Iy3cxPiR
479rj3tK/H7Uv18gGuQdnOK/Tj0Q4H99078mveYEBKjhvxCVF7XZfdK/K9kX
L/G34L8uHVlaa4LRv9zoWsXKl9+/qNXUzzSL0L/dHU8/wcfdv/18FStsMM+/
Kwstfd5Y3L9HFgkTLrDNv0qh/SoD8dq/cOrUi0w3zL90G2CifpHZv2vDgMwm
x8q/3rTzPKA72L8qaxQMHGHJv7+oV1S38Na/lquXgYsGyL8i1ehM
       "]]}}, 
    {RGBColor[0.2947336, 0.4054232, 0.5678384000000001], 
     {Arrowheads[{{0.01927783573049279, 1.}}], ArrowBox[CompressedData["
1:eJwBsQFO/iFib1JlAgAAABoAAAACAAAACrvRysjB4L8AAAAAAADwv2D5let+
rOC/YQWPoljX778QFTbShRrgv2wdaJ6WwO6/9emWExqa379B8CLipCzuv/HX
JtRC+96/YLDbiPqU7b8ebzoM8hzev+DdO7O0wOy/pGUoX+I33b+98Pj6/eXr
v/ZfYC7cTNy/Slw6tJUF679EJ72unFvbv21PSBg8H+q/WbSPkktr2r++7fka
xjnpv/qZcu6ddtm/AWq/BSZQ6L8k2GXCk33YvzXEmNhbYue/225pDi2A179d
/IWTZ3Dmv4ONlG9SgNa/XfAXwRt85b+EY/6C7H/Vvxt+3+tKh+S/3vCmSPt+
1L+YpdwT9ZHjv5A1jsB+fdO/1GYPORqc4r9y7Ox72H3Sv4R/aGMAqOG/YdD7
C2qC0b9erdia7bfgv1nhunAzi9C/xuC/vsOX37+5PlRUaTDPvySR/GG6x92/
1gdpvSqwzb94p+NZ11jcv/4j9b9IN8y/ksz9yPvw2r9vTv2TIsfKvx75rAl3
kdm/YkKGcRdhyb/GJVN2mDvYvxq7lJCGBsi/OktSaa/w1r8hGvcO
       "]]}}, 
    {RGBColor[0.2947336, 0.4054232, 0.5678384000000001], 
     {Arrowheads[{{0.019278788679977753`, 1.}}], ArrowBox[CompressedData["
1:eJwBsQFO/iFib1JlAgAAABoAAAACAAAAAAAAAAAA8D/Y3GZ8s8Hgv4v+Ajc2
1+8/3tgcsles4L9ZZ/K1ccDuP7Y10wReGuC/NCb3w34s7j9g/nf5yZnfv0nl
qTTTlO0/vZVPP/L63r+VZjsqi8DsP27KikKgHN6/s/GUPNLl6z+cM5hojzfd
v4CVdNRnBes/v4h4J4hM3L9dokUkDB/qP7GMK61HW9u/vUMeH5Q56T8fJB+i
9WravzB39yfyT+g/T5FmPEd22b+6PNE+JmLnP0bUAXw8fdi/VpSrYzBw5j8B
7fBg1X/Xv5APlTHje+U/YB8jl/p/1r/uP5xDEYfkP0avh8qUf9W/byXBmbqR
4z+tnB77o37UvxXAAzTfm+I/mefnKCh907/mOqofxafhP307q+eCfdK/6MD6
abK34D/MQzDLFYLRvzik6iVOl98/hgB30+CK0L8E3TM1RsfdP1Xj/gDIL8+/
+yARM1xY3D/+nyMEhK/NvzzUSEV68No/Vl75O502zL/zaU3X75DZPxRYpfBy
xsq/UFWRVAw72D/yxkxqZGDJv4YJhygf8NY/reQU8dAFyL/ebN99
       "]]}}, 
    {RGBColor[0.2947336, 0.4054232, 0.5678384000000001], 
     {Arrowheads[{{0.019278790229164827`, 1.}}], ArrowBox[CompressedData["
1:eJwBsQFO/iFib1JlAgAAABoAAAACAAAAg1HkNLPB4L8AAAAAAADwP/JC+GlX
rOC/tHofNTbX7z/C2sO9XRrgv+6nerFxwO4/VW2RbMmZ37/cETK+fizuP02V
rrPx+t6/SmuULdOU7T8s5i64nxzev0Ru0iCLwOw/oc+W34433b8sa9Ew0uXr
P6ZQ9J+HTNy/tk9fxmcF6z/nvkInR1vbv/0h4hMMH+o/H2XYHfVq2r8NrHYM
lDnpP3xo7blGdtm/apMjE/JP6D8CyYH7O33YvxjY6CcmYuc/r4aV4tR/178R
esZKMHDmP3q8Hhv6f9a/LFrZFuN75T9ahRNRlH/VvzZZPicRh+Q/TOFzhKN+
1L8xd/V7upHjP1TQP7UnfdO/G7T+FN+b4j/eqzt3gn3Sv0rDpv/Ep+E/Vc0r
XhWC0b8OWDpJsrfgP7s0EGrgitC/0uRy402X3z8kxNE1xy/Pv7gkSPJFx90/
qmPDOIOvzb+hxtbpW1jcPyx9yHCcNsy/zN879nnw2j/p/w4mcsbKv7DL94Lv
kNk/HdvEoGNgyb+85Yr7CzvYPwz+FynQBci/aol1yx7w1j9x+uTm
       "]]}}, 
    {RGBColor[0.2947336, 0.4054232, 0.5678384000000001], 
     {Arrowheads[{{0.01927275986249003, 1.}}], ArrowBox[CompressedData["
1:eJwBsQFO/iFib1JlAgAAABoAAAACAAAAmrw3wody4T8AAAAAAADwP+dkY1GO
7OA/Wy2tjEcK7z9JpvqBeJ7gP7xYi4UQe+4/SsmxLWBO4D8tEFvSKejtP1m/
Vb0hvt8/dDi9+gIc7T+EcLuNjdjeP15QxFx6Sew/J5vD7o/s3T9N1Jp6EHHr
PzyYXir6+dw/y5oyfpqS6j+cnuazMQjcPxQaqsfgtOk/BIrbs2sR2z+ETaKC
k9LoP3ZaPSqoFdo/GTUbr7Lr5z/vDwwX5xTZP9PQFE0+AOc/PrrupugQ2D8j
clNb0RHmPy5pjAZtC9c/eWqb2AYi5T/AHOU1dATWP9W57MTeMOQ/9NT4NP77
1D83YEcgWT7jPzx6uU1r9NM/fG1gvqNM4j8M9RjKG/DSP4Xx7HLsXeE/Y0UX
qg/v0T9P7Ow9M3LgP0JrtO1G8dA/trvAPvAS3z/5LQgrczPQP+827HLHtt0/
2OszjRfxzj+v5l45+1/cPy8VNrpggs0/7EwdULAP2z/wZnkWARzMP6PrK3UL
x9k/F3Bg2ze/yj/ORI9mMYfYP5q/TUJEbck/ZtpL4kZR1z/pKc//
       "]]}}, 
    {RGBColor[0.2947336, 0.4054232, 0.5678384000000001], 
     {Arrowheads[{{0.019272759715839492`, 1.}}], ArrowBox[CompressedData["
1:eJwBsQFO/iFib1JlAgAAABoAAAACAAAAAAAAAAAA8D/wX18diHLhP3gmsIBH
Cu8/Rb9Fo47s4D+NItd6EHvuP4FS+NJ4nuA/O7b0yCno7T9rB8N9YE7gP1hh
dfMCHO0/XLs8WyK+3z9WtaRXeknsP88qTSmO2N4/DkyidxBx6z/ET92HkOzd
P+KcY32akuo/CITgwPr53D/fKP3I4LTpPx7HzEcyCNw/SuUKhpPS6D8gN/5E
bBHbPyLSjLSy6+c/E9R0uKgV2j9o74JUPgDnP/WdMKLnFNk/leilZNER5j9f
FtUu6RDYPyFpruMGIuU/5r4Fi20L1z8LcZzR3jDkP4qXwrZ0BNY/VABwLlk+
4z9LoAuy/vvUP2jP1s2jTOI/MSrXxmv00z+xln6D7F3hPz2GGz8c8NI/L1Zn
TzNy4D9ztNgaEO/RP8sbImPwEt8/07QOWkfx0D+2Ef+ax7bdP201hpVzM9A/
GzPdZPtf3D9do0leGPHOP+0jun6wD9s/56g2h2GCzT8diJOmC8fZPy8RNd8B
HMw/ogNnmjGH2D/wcaafOL/KP3I6MhhHUdc/5GDsAUVtyT9iFc5p
       "]]}}, 
    {RGBColor[0.2947336, 0.4054232, 0.5678384000000001], 
     {Arrowheads[{{0.019273402126430687`, 1.}}], ArrowBox[CompressedData["
1:eJwBsQFO/iFib1JlAgAAABoAAAACAAAA0BJqFBlz4T8AAAAAAADwv1tHY9b+
7OA/JjLTYxMK778oefYs557gP4hDHqDdeu6/5mQE8sxO4D+LW903+OftvxR3
3FP2vt8/07h+e9Mb7b+ivlsKXdnePylGcQlNSey/gABXKVrt3T/yjFpf5XDr
v6oc3vq++tw/DgquqHGS6r+Ip20c8QjcPwPkrzO6tOm/HuqZkCUS2z/7rXg1
b9Lov2jkYldcFto/+GcIrpDr579qlshwlRXZP/kRX50eAOe/Ry2JD5ER2D/u
y3f6sxHmvybWYmYPDNc/x7VNvOsh5b8IkVV1EAXWP4TP4OLFMOS/7F1hPJT8
1D8lGTFuQj7jv2MZ7xD79NM/oClRKo9M4r/6n2dIpfDSP+mXU+PZXeG/tPHK
4pLv0T8BZDiZInLgv5AOGeDD8dA/0Bv/l9IS37/JhFbX6zPQPwxBQkmttt2/
x4rmYgDyzj/IYKNo5F/cv/bKoRtBg80/mkOPr5wP279U9KEX2RzMPxSyctf6
xtm/HDGqlQfAyj/OdLqZI4fYv4KrfdQLbsk/XlTTrztR1785v+EZ
       "]]}}, 
    {RGBColor[0.2947336, 0.4054232, 0.5678384000000001], 
     {Arrowheads[{{0.019273410721454255`, 1.}}], ArrowBox[CompressedData["
1:eJwBsQFO/iFib1JlAgAAABoAAAACAAAAAAAAAAAA8L9axxdLHXPhP+B/f1kS
Cu+/2qp0WwLt4D9Rjgmi3Hruvxf02aXqnuA/KVVBRvfn7b9HLF1e0E7gPwYe
LJ7SG+2/ninrDP2+3z8ej99ATEnsv7Wjm6Jj2d4/qriwq+Rw67+mOWafYO3d
P5jqLQpxkuq/LsVsTcX63D90BB6qubTpvzF7bEv3CNw/jvafwG7S6L++e5qa
KxLbP+bAs02Q6+e/18b2OmIW2j98Y1lRHgDnv3tcgSybFdk/08QqwrMR5r97
m/qhlhHYP2zLwZbrIeW/qOIizhQM1z9Idx7PxTDkvwMy+rAVBdY/Z8hAa0I+
47+KiYBKmfzUPxDJ8zaPTOK/zqJj8P/00z+MgwL+2V3hv1o3Ufip8NI/2vds
wCJy4L8xR0lil+/RP/JLZvzSEt+/UNJLLsjx0D+/L1TQrbbdv3womQrwM9A/
EqA/EOVf3L/vPaOSCPLOP1YSXHWdD9u/pSe8E0mDzT/5+9y4+8bZv0HKTtfg
HMw/bNL1kySH2L/q4SwcD8DKPxgL2r88Ude/wyooIRNuyT8xleGR
       "]]}}, 
    {RGBColor[0.2947336, 0.4054232, 0.5678384000000001], 
     {Arrowheads[{{0.017140109274837896`, 1.}}], ArrowBox[CompressedData["
1:eJwBYQGe/iFib1JlAgAAABUAAAACAAAAAAAAAAAA8L/v6wIpJ13Sv954BMkt
e++/cTibRO4Q0r9QvWEOTs/uvzJUFBdMrtG/XQBnmX4f7r/IKDWbZ0nRvx6n
13F+GO2/jE2o6nmy0L82nUCXMgrsv780eWhcF9C/bhScKbX26r9KJEjKh/LO
vy7868hS3em/T/7+4JKvzb/COxbgscXov3o0YNehbsy/hJvp866r578oQneq
9CrLv3YbZgRKj+a/WydEWovkyb+Wu4sRg3DlvxLkxuZlm8i/uHQVDk9S5L/g
UhEY6VLHv6w/vuyiN+O/WE41tnkOxr90HIatfiDiv3nWMsEXzsS/EAttUOIM
4b9D6wk5w5HDv8BcXqr9/t+/5/7S6JJcwr+MUhF3Cvbdv5SDppudMcG/hPfy
Buv+279LeYRR4xDAv6dLA1qfGdq/FcDZFMj0vb9gxKJ6o2PYv/IwksEW/ru/
C6a7hw==
       "]]}}, 
    {RGBColor[0.2947336, 0.4054232, 0.5678384000000001], 
     {Arrowheads[{{0.01714015153572448, 1.}}], ArrowBox[CompressedData["
1:eJwBYQGe/iFib1JlAgAAABUAAAACAAAA81+Sty1d0r8AAAAAAADwv7nZocvy
ENK/4oEhbyp777+C+xt2UK7Rv5oTK6xKz+6/a6Cw0WtJ0b/1Yk4vex/uvy1V
7tp9stC/vCdP63oY7b8l22kRYBfQv6JY7fQuCuy/bvszjo7yzr+ZuvZtsfbq
v4FHrhaZr82/TmHR9U7d6b9oTp2Ap27Mv29Bdfatxei/4tGPyvkqy78m2Xz3
qqvnv+/RhfSP5Mm/cyjo+EWP5r+RTn/+aZvIv1Uvt/p+cOW/rqeysuxSx7/B
inTwSlLkvyg9Vtt8Dsa/p9eqzZ43478DD2p4Gs7EvwkWWpJ6IOK/PB3uicWR
w7/mRYI+3gzhv6H5qduUXMK/OzkEo/X+37/+NWU5nzHBvyCfcJUC9t2/UdIf
o+QQwL95vUlU4/7bvzidszHK9L2/RZSP35cZ2r+IPLijGv67v3HngieeY9i/
enDGXg==
       "]]}}, 
    {RGBColor[0.2947336, 0.4054232, 0.5678384000000001], 
     {Arrowheads[{{0.017140908348683176`, 1.}}], ArrowBox[CompressedData["
1:eJwBYQGe/iFib1JlAgAAABUAAAACAAAAAAAAAAAA8D87dqc+cF3Sv3D1rO3v
eu8/VrfmqhIR0r9I+c1SD8/uP8SMJHRurtG/YmGuBT8f7j/tWbHqh0nRv+Ar
3RY8GO0/4mFISZay0L+FGkt+7QnsP8V65sp0F9C/fWMNhG326j/UVbK3sPLO
v2efx7oI3ek/GItiBbSvzb9htG5+ZcXoPxgQ8lK7bsy/Zm7njGCr5z+GCQvM
BivLv37NMeb5juY/Z3etcJbkyb+j0U2KMXDlP7ZZ2UBqm8i/HOBMf/xR5D9k
RlQo51LHvy1eQMtPN+M/YNPjEnIOxr/USyhuKyDiP6QAiAALzsS/E6kEaI8M
4T83zkDxsZHDvxWY32RZ/t8/OQtotX1cwr+0FQiOaPXdP9CGVx2FMcG/BcuC
S0z+2z/6QA8pyBDAvwa4T50EGdo/cHMesY30vb+XLPByNmPYP30dxwMJ/ru/
eNOtBQ==
       "]]}}, 
    {RGBColor[0.2947336, 0.4054232, 0.5678384000000001], 
     {Arrowheads[{{0.017140910009398998`, 1.}}], ArrowBox[CompressedData["
1:eJwBYQGe/iFib1JlAgAAABUAAAACAAAAD8h4/m9d0r8AAAAAAADwP/xFnVoS
EdK/9jzMz+967z+CrqEkbq7Rv/6T7jMPz+4/VRD/m4dJ0b/0/NPlPh/uPzSS
AvuVstC/fJ0o9DsY7T/qNxt9dBfQv+Zou1jtCew/axRKHbDyzr+8NsJbbfbq
P1sMWGyzr82/Jr/Vjwjd6T80IVO7um7Mv+dJ6FBlxeg/McMiNgYry7/mkwVd
YKvnP1ryxtyV5Mm/Kp0ttPmO5j+prj+vaZvIv61lYFYxcOU/vM9bmeZSx7/k
uMFJ/FHkPy8t6oZxDsa/QGJ1lE834z8Ex+p3Cs7Ev8VhezYrIOI/OJ1dbLGR
w79vt9MvjwzhP+u9jzR9XMK/Ugku9Fj+3z8+N86ghDHBv7rVux1o9d0/LwkZ
sccQwL8W1FDcS/7bP31n4MqM9L2/ZQTtLwQZ2j/LQfRLCP67v89TBCg2Y9g/
rpizMA==
       "]]}}, 
    {RGBColor[0.2947336, 0.4054232, 0.5678384000000001], 
     {Arrowheads[{{0.016549581705215855`, 1.}}], ArrowBox[CompressedData["
1:eJwBcQGO/iFib1JlAgAAABYAAAACAAAAAAAAAAAA8L+n9bFua2u0vypj803s
au+/Wi0RsUoMtL9+IqdAibHuvwaOKHf+lbO/FkYgsDz07b8kKkopMx2zv9RA
EEroP+2/Cd/gESGqsr/hEu/itITsv8bYD4msMrK/3AfH4cHG679xVBUGd7mx
v2Broq0uCuu/JY8vACJBsb96MPc+6kzqv+/zxuJbyLC/sLhfxbaL6b+kRAkq
E02wv1f1nHrwyOi/CIG5zJKhr7/G12+Y8wbov5xNT1AAqq6/+K+VntC/5r8G
i4ZJgAitv8nRMCWEeuW/CKciulhpq785PUEsDjfkv6KhI6KJzKm/SfLGs271
4r/UeokBEzKov5w/FqGjueG/TMS4Aw2fpr/Yc4PZqofgv7gPFtSPGKW/+B0d
ugi/3r8ZXaFym56jvw4ib1dggty/bKxa3y8xor9JPkcB6F3av8YAxoUz06C/
+7zvLStW2L9uus6iGQ+fv4Y6vb4=
       "]]}}, 
    {RGBColor[0.2947336, 0.4054232, 0.5678384000000001], 
     {Arrowheads[{{0.016549588759019244`, 1.}}], ArrowBox[CompressedData["
1:eJwBcQGO/iFib1JlAgAAABYAAAACAAAAHoeDD45rtL8AAAAAAADwv4YPgOtq
DLS/Szv2h+lq77+rssriHZazvy8B+HCGse6/WAw/wlEds7/gKU7XOfTtv7Ig
A/I+qrK/J0lpgeU/7b8U31eryTKyv1hdOC6yhOy/rBSAaJO5sb9OoIJCv8br
v6iOvqM9QbG/4UsPIywK679FmZbHdsiwv0xlbsrnTOq/o00aTi1NsL+4zWtq
tIvpv6FYxZHFoa+/9IioOu7I6L+saxGTMaquv8iaxXLxBui//UuW/64Irb8j
bkKkzr/mv/7dL+qEaau/zPRTWIJ65b+uId5Ss8ypv8Qu+o4MN+S/DhehOToy
qL8LHDVIbfXiv1fRTtAxn6a/wJSgZ6K54b/EY71IshilvwRx2NCph+C/Vc7s
orueo7+uYbkHB7/evwkR3d5NMaK/b6haAV+C3L8pnn1rT9OgvyjlhQLnXdq/
+c97b00Pn7+0Rix/KlbYv3qCwsw=
       "]]}}, 
    {RGBColor[0.2947336, 0.4054232, 0.5678384000000001], 
     {Arrowheads[{{0.016549726949723537`, 1.}}], ArrowBox[CompressedData["
1:eJwBcQGO/iFib1JlAgAAABYAAAACAAAAAAAAAAAA8D9OdILXF260v9r4EX2y
au8/Emb+u8UOtL83ClahTrHuP0ZKRYFpmLO/txgITgH07T9GwFvmjR+zv4/W
HjOuP+0/REyDkW2ssr8ursxlfITsP0yrhWrqNLK/tinqHYvG6z+9Xqwiprux
v0nTT5P5Ces/+edAa0JDsb8amYrqtkzqP+j4np9tyrC/AwASgYWL6T9Kb+gT
Fk+wvyt0HmTByOg/gBwg3Xqlr7+0YeigxgboP9gxEazKra6/RL01L6e/5j//
4lB+GAytv1NH7WpeeuU/RuX6T79sq7/l/w5U7DbkP7A4DyG/z6m/9uaa6lD1
4j863Y3xFzWov7RD1e+JueE/dmmPaeKhpr9JXQIllYfgP/hzLDE3G6W/bGdE
FOW+3j+8/GRIFqGjv/iNaT5Egtw/xwM5r38zor8TCVgN013aP+N01hJa1aC/
nLPzxRxW2D+8d9ZAGBOfv5m1t2s=
       "]]}}, 
    {RGBColor[0.2947336, 0.4054232, 0.5678384000000001], 
     {Arrowheads[{{0.01654972723956636, 1.}}], ArrowBox[CompressedData["
1:eJwBcQGO/iFib1JlAgAAABYAAAACAAAAXm7M7xdutL8AAAAAAADwP4aqsLvF
DrS/XmE+V7Jq7z/tN/V/aZizv8Q2ynpOse4/BFYL5I0fs78l0MsmAfTtP1Wb
CY9trLK/y0l4DK4/7T8t2P5n6jSyv6Ic8D98hOw/OqsjIKa7sb+Oeez4isbr
PyuzsGhCQ7G/b5Emb/kJ6z/AehSdbcqwv3RMS8e2TOo/m5mCERZPsL+azfFe
hYvpP4qDtth6pa+/Ap4yQ8HI6D+QSv2nyq2uv8lGJoHGBug/VCxKexgMrb85
XcsRp7/mP9r1M06/bKu/ABEAUF565T8jp7ogv8+pvx1ixDvsNuQ/K0De8hc1
qL+PUBjVUPXiP6dnnGzioaa/MEwm3Ym54T9CxPI1Nxulv9TEGBWVh+A//1Xh
Thaho7/8dN/55L7eP9wcaLd/M6K/VlpWKUSC3D9oi6AcWtWgvyScVP3SXdo/
WihIVxgTn7/InJi6HFbYP3oLtnA=
       "]]}}, 
    {RGBColor[0.2947336, 0.4054232, 0.5678384000000001], 
     {Arrowheads[{{0.017087624336527957`, 1.}}], ArrowBox[CompressedData["
1:eJwBYQGe/iFib1JlAgAAABUAAAACAAAAVlWWG1BL1D8AAAAAAADwv65apT/b
C9Q/6ZCtAvGb779TDVhtJ4vTP5wHCrEA0e6/UQVIQMgd0z+V5QttiyTuv7C2
j175rdI/KSuTsj507b9eE8GgHwXSPwQ+DxgAauy/owtgC8BX0T+tAlfMn1jr
v7JMsmlep9A/luE/SYFC6r9G5Ovv8ubPP+u3grvYJum/461vvI+Bzj9OHtnM
FA3ov7c9z0jzGc0/NJywEZDx5r/CkwqVHbDLP6ExCYpK1OW/BbAhoQ5Eyj+Q
3uI1RLXkv4Ddy2un2cg/zV6Q9ouX478sZ8DzyHTHPxpuZK0wfuK/D03/OHMV
xj97DF9aMmnhvySPiDumu8Q/7TmA/ZBY4L+lXj/Xr2rDP2h97u7Ond6/zOwG
6N0lwj8oxuZRoZ3cv5g5320w7cA/Gk7pI5mw2r8OipDRToG/PzkV9mS21ti/
LX2wvQ==
       "]]}}, 
    {RGBColor[0.2947336, 0.4054232, 0.5678384000000001], 
     {Arrowheads[{{0.017087618808780628`, 1.}}], ArrowBox[CompressedData["
1:eJwBYQGe/iFib1JlAgAAABUAAAACAAAAAAAAAAAA8L9Vy6axWUvUP8ax77Xw
m++/HwARh+QL1D8zefRVANHuv6nZ324wi9M/TcwKH4sk7r/zrXEW0R3TP1H8
sHE+dO2/SEA7CAKu0j8uKTf6/2nsvzxF4xAoBdI/+TUR0p9Y67/VVyxAyFfR
P+hj5nGBQuq/DrNTYWan0D/oR9QG2Sbpv3uGNGEC588/MMYhOhUN6L+fPfyv
noHOPxgvR5+Q8ea/Oox3uwEazT+kgkQ2S9Tlv05ypoMrsMs/zsAZ/0S15L/X
74gIHETKP3BqVNqMl+O/tzKxSbTZyD9eAIKoMX7iv8xosUbVdMc/moKiaTNp
4b8Ykon/fhXGPyDxtR2SWOC/ma45dLG7xD+IEKtK0Z3ev9CFGIK6asM/qgg1
wqOd3L8833wG6CXCP6XKCaKbsNq/4LpmATrtwD96VinquNbYv24xrOVggb8/
17evlg==
       "]]}}, 
    {RGBColor[0.2947336, 0.4054232, 0.5678384000000001], 
     {Arrowheads[{{0.017087498324480345`, 1.}}], ArrowBox[CompressedData["
1:eJwBYQGe/iFib1JlAgAAABUAAAACAAAAAAAAAAAA8D+NKwQ3U0rUP1P5CAwI
nO8/JpwuDfAK1D/kPrLIF9HuPwOZwIdCitM/OkndcqEk7j+Dkvn/5xzTP2E+
XKNTdO0/ZiLg3x2t0j/UWvJbEmrsPzC75adKBNI/LS7xU69Y6z/3mfPG8VbR
P0ZH/xeOQuo/Z2ldAZem0D/Xy4/O4ibpPzzhYyty5c8/C0g7MBwN6D8VvF71
HIDOP/wen9qU8eY/Tp/StY4YzT+tULvNTNTlP+uKv2zHrss/Gd2PCUS15D/p
fiUax0LKP07M4X2Jl+M/jrS3nm7YyD9ZJnYaLH7iPyJlKduec8c/OOtM3ytp
4T+kkHrPVxTGP+oaZsyIWOA/Ejere5m6xD8f2OeMu53eP21MiJexacM/jipR
ZIud3D+2xN7a7STCPyItCB+BsNo/65+uRU7swD/X3wy9nNbYPxi876+lf78/
rEmp/Q==
       "]]}}, 
    {RGBColor[0.2947336, 0.4054232, 0.5678384000000001], 
     {Arrowheads[{{0.017087500287328666`, 1.}}], ArrowBox[CompressedData["
1:eJwBYQGe/iFib1JlAgAAABUAAAACAAAAevdvp1JK1D8AAAAAAADwP5R3ZHPv
CtQ/8Bwr+Qec7z/Td3HzQYrTPwoM3bgX0e4/41rubecc0z/9SdZhoSTuP/a/
K1AdrdI/YhomkVN07T9o1qQaSgTSP+LAPUYSauw/fHhCPPFW0T9kPbg6r1jr
PwHeZHmWptA/qtFg+41C6j8QPi0hceXPP8dnnq7iJuk/Uqvr8BuAzj9CjAsN
HA3oPwCmfreNGM0/Ts9stJTx5j8bLuZ0xq7LP+wwwqRM1OU/n0MiKcZCyj8a
sQveQ7XkPwDS5LRt2Mg/4/QiUImX4z+uxN/4nXPHP1Ch4eorfuI/qRsT9VYU
xj9htkeuK2nhP+7WfqmYusQ/EzRVmohY4D9JxNbNsGnDP3/WdSe7nd4/hLHO
Ge0kwj92WVP+ip3cP5yeZo1N7MA/CvFCuYCw2j8mFz1RpH+/Pz2dRFic1tg/
e2+p5Q==
       "]]}}, 
    {RGBColor[0.2947336, 0.4054232, 0.5678384000000001], 
     {Arrowheads[{{0.01579795638630435, 1.}}], ArrowBox[CompressedData["
1:eJwBcQGO/iFib1JlAgAAABYAAAACAAAAt1+PRo1svj8AAAAAAADwvxWrR7/q
SL4/jCRZ7ITa778ehzI/p5C9P0pdpO61GO+/BSVtOEHgvD8WKJm2LF/uv2AT
5UIyLLw/hyRIB8qh7b86Y2loooO7P3ufD+d+8Oy/orYmeOzUuj98OmAnvDjs
v95xlOXAI7o/Ha/nJ2N+678v+Skk0HO5P+62U0hVxeq/3HtwWU7DuD/j+iLc
rgvqv2r5OcFaD7g/ousD9WhO6b+JDmtwBlq3P0/u6w+wj+i/4Ffoe2Kltj8E
aNCpsNHnv2oHK0LmcrU/BiC8L1SP5r8UsHyqQEK0PyLgs7jmTuW/31HdtHET
sz9YqLdEaBDkv8nsTGF55rE/pXjH09jT4r+DlGJd/r6wP1fAF34PneG/drlq
rU5Brz+57txb42/gv+SKiproFq0/lwcu2qiY3r9OnSSCyv6qPxr/i2PFZNy/
/0TQrxz9qD+Nl93Ae0jav5SLvOE=
       "]]}}, 
    {RGBColor[0.2947336, 0.4054232, 0.5678384000000001], 
     {Arrowheads[{{0.015797957577199526`, 1.}}], ArrowBox[CompressedData["
1:eJwBcQGO/iFib1JlAgAAABYAAAACAAAAAAAAAAAA8L8qMd05s2y+P664SWyF
2u+/clfG/xBJvj8N3TRjthjvv+mTB4/MkL0/9dm9My1f7r8C72C0ZeC8P7rk
34zKoe2/x2FH5lUsvD8UG5pyf/Dsv/eWMD/Fg7s/vrMSuLw47L+kkOZ5DtW6
P1MNcb1jfuu/g3LuDuIjuj9zhtziVcXqv0lgzXbwc7k/dqwMe68L6r8OnhHU
bcO4PyQYFZdpTum/cOtiXnkPuD9POae0sI/ov3yl7C0kWrc/vH90UbHR5780
Kdpaf6W2PwzydM9Uj+a/rnVHmwFztT90YRVP507lv5SrtH5aQrQ/+M1V0GgQ
5L/oyiEFihOzP5Q3NlPZ0+K/q9OOLpDmsT89oH3wD53hv54brK0Tv7A/5wnz
wONv4L8N8VNqdkGvPyLpLImpmN6/xtQQig0XrT90wM/2xWTcv2bijrrs/qo/
rxDoOHxI2r9vR5dNPP2oPy9WvX0=
       "]]}}, 
    {RGBColor[0.2947336, 0.4054232, 0.5678384000000001], 
     {Arrowheads[{{0.015797898363932104`, 1.}}], ArrowBox[CompressedData["
1:eJwBcQGO/iFib1JlAgAAABYAAAACAAAAAAAAAAAA8D+lrnRaL2m+PzaWe3yE
2u8/xKNpWpBFvj9NDZHRtRjvP+GOQY1hjb0/BhBSCCxf7j8dU+uBDt28P6vr
gMjIoe0/WLss8BIpvD9NL9/6fPDsP1zeTRiVgLs/J+4Wkrk47D+m2vPc8dG6
P7FEP+tffus/csebRtkguj9iT29jUcXqP/67wl37cLk/g2twV6oL6j+eRaqD
jMC4P34eZ95jTuk/xNzdSqwMuD8FQfNsqo/oP1F5yYVrV7c/x6u0d6rR5z8q
E9kG26K2P/ECFRVOj+Y/4tw4zoBwtT+aF6zL4E7lP2pYoxj9P7Q/xel5m2IQ
5D/HhRjmTxGzP3B5foTT0+I/9mSYNnnksT8qMZmYCp3hPxfMRUofvbA/gXup
6d5v4D+LIofC0D2vP+qwXu+gmN4/CGkj96gTrT8NkFWFvmTcP6NrYDLH+6o/
mAEO9HVI2j/Gz448U/qoP3ylsuo=
       "]]}}, 
    {RGBColor[0.2947336, 0.4054232, 0.5678384000000001], 
     {Arrowheads[{{0.01579789867843719, 1.}}], ArrowBox[CompressedData["
1:eJwBcQGO/iFib1JlAgAAABYAAAACAAAAi4b/US5pvj8AAAAAAADwP9owJTKP
Rb4/BM+8WYTa7z+B7mdtYI29P61RGLG1GO8/xzFPZw3dvD//dA/nK1/uP6Hc
9NoRKbw/o8F7psih7T/2ORAJlIC7P6FqHtl88Ow/a1kQ1PDRuj9NPcdwuTjs
P4jGOETYILo/DIdyyl9+6z/QDM1h+nC5P0GVHENRxeo/r0Y6jovAuD8YK6w3
qgvqP+B4P1yrDLg/ILlhv2NO6T9oDhueale3P9kQwE6qj+g/QnILJtqitj+4
A0paqtHnPzh7sfl/cLU/SICh+U2P5j+INXdQ/D+0PzykVrLgTuU/NaFcKk8R
sz+Wb2mEYhDkPz2+YYd45LE/U+LZb9PT4j+4s3OnHr2wP8NOcIYKneE/eFH/
lM89rz82B/XZ3m/gP5Q6C+GnE60/VBfQ1KCY3j++IgszxvuqPzy4km++ZNw/
M5YJU1L6qD+goeTidUjaP6U+rYU=
       "]]}}}},
  AspectRatio->1,
  DisplayFunction->Identity,
  Frame->True,
  FrameLabel->{
    FormBox[
     StyleBox["\"x\"", 
      GrayLevel[0], 15, StripOnInput -> False], TraditionalForm], 
    FormBox[
     StyleBox["\"y\"", 
      GrayLevel[0], 15, StripOnInput -> False], TraditionalForm]},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  FrameTicksStyle->Directive["Label", 12],
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  Method->{
   "DefaultBoundaryStyle" -> Automatic, "TransparentPolygonMesh" -> True},
  PlotRange->{{-1.0435125228870954`, 
   1.0435125228870954`}, {-1.0435125228870954`, 1.0435125228870954`}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.05], 
     Scaled[0.05]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.681130891256036*^9, 3.681130921070141*^9}, {
   3.681165432857595*^9, 3.681165444931686*^9}, 3.6811655276698847`*^9, 
   3.68116571507927*^9, 3.681230201435664*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Show the field lines on the density plot of the potential :", \
"Subsubsection",
 CellChangeTimes->{{3.6811655696025543`*^9, 3.681165593004198*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{"densityplot", ",", "fieldlines"}], "]"}]], "Input",
 CellChangeTimes->{{3.6811657250726213`*^9, 3.6811657288278427`*^9}}],

Cell[BoxData[
 TemplateBox[{GraphicsBox[{
     GraphicsComplexBox[CompressedData["
1:eJx1nXm4ltP6x4uMoTiGNJHSEaGcZLbMlRyk0CFKio5kKkpHSqGZDKlDMpfQ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      "], {{{
         EdgeForm[], 
         GrayLevel[0.8], 
         GraphicsGroupBox[{
           PolygonBox[CompressedData["
1:eJxMnXeYFEXXxWd3Z2Z3e2Z2es1ZwYCYA4oEERBERAVUFAEVCQYMqAQVBQVR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            "]], 
           PolygonBox[CompressedData["
1:eJxFnWOYPMnTtXt60DPtWdu2bdu2bdu28Vvbtnf/a9u2bb/3vSef6/0QV0d2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            
            "]]}]}, {}, {}, {}, {}}, {{}, {
         Directive[{
           Opacity[0.3], 
           GrayLevel[0]}], 
         LineBox[{2527, 3710, 2525, 3709, 2526, 3730, 2555, 3729, 2556, 3739, 
          2571, 3738, 2569, 3737, 2570, 3759, 2599, 3774, 2619, 3773, 2620, 
          3790, 2645, 3789, 2646, 3807, 2673}, VertexColors -> None], 
         LineBox[{2531, 3713, 2530, 3712, 2528, 3711, 2529, 3732, 2557, 3731, 
          2558, 3742, 2574, 3741, 2572, 3740, 2573, 3761, 2600, 3760, 2601, 
          3776, 2621, 3775, 2622, 3792, 2647, 3791, 2648, 3809, 2674, 3808, 
          2675, 3821, 2695, 3820, 2696, 3840, 2725, 3855, 2747, 3854, 2748, 
          3873, 2777, 3872, 2778, 3890, 2805, 3906, 2833}, VertexColors -> 
          None], 
         LineBox[{2548, 2549, 3728, 2550, 2551, 2565, 2566, 2593, 3757, 2594, 
          2595, 2616, 2617, 2641, 2642, 2669, 2670, 2692, 2693, 2723, 2724, 
          3853, 2746, 2775, 2776, 2803, 2804, 3905, 2832, 2864}, VertexColors -> 
          None], 
         LineBox[{2552, 2553, 2554, 2567, 2568, 2596, 3758, 2597, 2598, 3772, 
          2618, 2643, 2644, 2671, 2672, 2694}, VertexColors -> None], 
         LineBox[{3382, 3381, 4320, 3415, 3441, 3442, 3469, 3470, 4372, 3497, 
          3519, 3520, 3549, 3550, 3573, 3574, 3601, 3602, 3624, 3625, 3646, 
          4468, 3647, 3648, 3673, 3674, 3687, 4497, 3688, 3689}, VertexColors -> 
          None], 
         LineBox[{3413, 4319, 3414, 4335, 3440, 4353, 3467, 4352, 3468, 4371, 
          3495, 4370, 3496, 4385, 3518, 4405, 3545, 4404, 3546, 4417, 3567, 
          4416, 3568, 4434, 3595, 4433, 3596, 4450, 3619, 4449, 3620, 4465, 
          3640, 4464, 3641, 4485, 3667, 4484, 3665, 4483, 3666, 4494, 3681, 
          4493, 3682, 4514, 3706, 4513, 3704, 4512, 3705}, VertexColors -> 
          None], 
         LineBox[{3548, 3547, 3571, 3572, 3599, 3600, 4453, 3623, 3643, 4467, 
          3644, 3645, 3671, 3672, 3685, 3686}, VertexColors -> None], 
         LineBox[{3569, 4418, 3570, 4436, 3597, 4435, 3598, 4452, 3621, 4451, 
          3622, 4466, 3642, 4488, 3670, 4487, 3668, 4486, 3669, 4496, 3683, 
          4495, 3684, 4516, 3707, 4515, 3708}, VertexColors -> None], 
         LineBox[CompressedData["
1:eJwl1FdszVEcwPFTI3FrtDUSEtXxZIsRJbGJEaONkahZ48FszZIgqNlBBS1q
S1SoFyRUYgQvJF4QK2LEXq2VGE98/vHwvZ/7+z/cm5xz/idtZt7Y3LgQwkgf
BU1CeBMLYQ/j4kMo519zGYP5GJvyKJN4hAk8zESeY3ueZQfe4EBeZ39e4wDe
ZTbvcBJfcRlfcjm/sJC1LGKdhBAqGccTTOJlJvIK0/mEPfiT3fmLQ9i0YQiD
2YwT2JWzOIwrOYsrOJtbuIblLGMZy3mS53iRt3iLz/k4+h9+YKxRCH+YzFhi
CJ3Yin3ZjqPZmzM4gkuZzWLO5VFeULW2me/xkz6ryly/cQhXmcIM9dJEZetr
9Hss1Q6dUpWu6bqe64V+6beaWdcJSSE0Z4toz6L9ivYqWn/PBzGfgzlEk6P9
ME/hVM3TTvN87uIC7uZCljGX5czjHi7iXi7mPi5hBZdyP5fxAJfzIPN5iCt4
mNOjc8BpLGYOSziGazma65jJ9cxiATOYy57MYxqnMZXTmc4cxjOTMWax1hr1
Yw378xG78SG78zJTeImprGQijzOJRfxrT/JYw1zWcjyfchyfsQdvsw2vsB5P
sm60h/xo7yt4l8W8wxKe50oe4RwWcSKXcDhz2Iuj2JZ92JId2YCt+dtZbcD3
0TvjDD/iM97kTVbzLM9od5R5NVdppvLNQ6Pv7MLOSlATfffudfX8Ae/roqqj
+yO6O7RBBVqg+cpSpm5b/zHMUE+lKkWnPW/DKiaznupqr7kOf7ijvqvU/I3b
+ZXb+IUlrGUxa1jEzyzkJ27lR27hB27me27iO27kW27g69j/e/Ifb4m2LA==

          "], VertexColors -> None], 
         LineBox[CompressedData["
1:eJwl1FtMzmEcwPG/w7wWlVPlUGFsNhSVwxwvpJTSpotsDnOYY06zOeUQbkx0
g4uYC6ZQjc2FUBib06YbG7lwGsacNzZGjPk8c/F9P/td/d/3+f+ed/CS9aXr
OkRRNMJHbUIU9YmLossczUscxYvMZBNH8gIzeIfTeZvTeIu5bOMCPuQ8PuB8
vuFmvuYWfuUBfmE1OydGUT07sYG9eZ29eIND+ZRD+Izj+JNj2c589ukWRXlM
YhmzuYwFXMpCVnAZq1jJfdzFGtawkRfYwnts5Qve40s+Ds/lB8Z1j6JfTGdc
D+fE/pzK4SzhRC7hRm3SXHM1y3mSFWzmQ7XpmPkzu8RHUUw3zIM4QRM1V/O0
UZt0UId0Vud0U7f0Uq/Urtyevid/K9l5l5lT2De8Uy03Z3AFM7mSo8IeKC+8
L3M+t3IGK1jAbSzkds7kDhZxJ4tZyWyuYhbLmcPVHMM1HMu1TA/7wrSwLxwY
9ogxFrMLZ7ErS/jJb5nMj5zCRxzNNmbxCtPYwnTWMYG1TGQV/zjbffzLtfzI
NfzEUj7hbD5lDluZxqtM5TV2ZD3fe2dH+I5HeZ/72cQtPM4VrGJZeC7ncANn
cCHHs4jDOIkpHMEYB/CHXYvxLb/bwW96prvmu7zE86znYR7SNu01L+aicD+0
2JzBkYpXd30NdzHc23Bnw/0Pd18ndFx7tFvlWqXnYU84S8VqNReF+6gxumLO
YQuz2cwspmqAGs392cB+rA/7yDNM4Wkm8xSTWMfecf//p/4B8J+cNA==
          "], 
          VertexColors -> None], 
         LineBox[CompressedData["
1:eJwl1FtojnEAx/H/sKUdjHJopjRlFxPLmU25sIO9LraUzGEbwxSFG7OD0xVR
m0RxwcohK1t2YeRwRW2zUTKaM+WwoyjcMKfPm4vv+3l/9fbW8/yf900r37ly
R0wIIdlLx5gQ8uJDeMFyPudGPuMGPmUpe1jGAdaynzXsYxV7Wc3vPMZvrONX
1jMuOYTLjGUTJ/AOx/Mu0/mG0/mWi/iTCznM5ZyYEEI+J7GYc7ma81jBCGtZ
wRpu5VEe5GmeZjOvsYnXeZv3+YDv+JI/+IkJiSEMMZHDnMqEsSFkMpVLWagi
ZdubGGEl17GOF3RRNfYt1rOHn/VFzfbopBDSNE3ZWqL1KlGl9uiETuqKWtQW
/fy4ENrZofdaYH/gQn5kr34px/7NXP5hHv8yOJsUrbYns5ipXMMpXMsRzGcM
l3MkCziKEcZyBft93yL2cTEHmMXB6DXxMWeym7P4hJm8yVTe4BSeZyLPMYmH
OeweHYpeC7dzgNs4yCI+ZyFfcA47OZtdTOVtxvASAxvZ596f4kMeYSt38yor
2cAKHuYq7mIeSzmfJVzACNOZxYnMYBwnMyX6Xr2enW+eqad8xXa2s00tarSP
8wSrWaUy7bZzuEwzlKEExeuL38RndeuRrqlVDTqrv87lDA9ov4bsfRzkXm5V
hV7bW/iKm/mSmxhRgbqi587O6HPAe8yN//+/8Q/pt5dw
          "], VertexColors -> 
          None], 
         LineBox[CompressedData["
1:eJwl00lIVVEcwOHTQtKnNizUp7QoyvRlkIsKjIoKWpgUFG2KMAhDJciNZOOi
kaBIG7RsoBbZKsuhFBpWCU1ObVKqRQNWYEEGmZpa36PFj49zuFzOvfd/5+yo
2LR7SghhUL+mhXA2EkJkegh3mcQ7TORtTmUjM/iE6exgjB+Zy/fM4Qcu4zgL
OMF1jCaHUMhMbuUSbuFSlrKIh1jGgyznaR7mKR5hPevZyHY+ZicfsYtd/MR3
HON3pqY4C2czZUYI+ZzFVczjRi5nCYtYxTOq1i7rBh7gQ/apXz80pEb7Sakh
zNU8rdBKFWu79mrINfu4X7WqU5PSZobQzHS2sFXP4veyfh6/H18wmy85n53M
YRdz2c0Ye7iAvczjKy7kfWbwHqNsYybbmcUbjPA6k3mMI857lKM8zjGW8wvL
+JUb2Mf17I+/Uz7lovgzMIsP+Nc7uslJNvAzaznAOnbzJFtYyWss4VXu5Alu
ZgXXchsXs5DZLGAaY0xglMO+dQIH+NMMvOZbvlGH2uKzzVusYbWqtEfFqrS/
hqsVU66SlBifJ7P8TfmuGWSvetSqFqXYb2Yym3hFlzXp/6rnBC9xnBf5h3Uc
Yy1HeYEjPM/fPMdh1kT+/6f/AE3Jids=
          "], VertexColors -> None], 
         LineBox[CompressedData["
1:eJwl011ozWEcwPEHx8aZeSllr7Sykb1ILqzQtnIhO7s53G3KyNtacyFFmLeN
K1IUzhk3yhXKhZrCjc687ZzdoKZc7WxeLsRsXGj4/HPx7dPze+rf/9/z/Kt2
H0r2zAohjKhkUQhD8RDqOcE6jrOWY1zDPDfxDzfyL9tYURRCgmVsZTk7uIHt
bORBJniAbexlFy/xHC+yj2mmmGKa9znIp8xxJHoP5qL34wf+5lcuXBDCDKtY
vDiEdaxkC+uY5Gbu5VEdU4f1ZXbzDh/riUb1XgPmk4wXh1CkatWoSVl7zWzR
LnXquCbNT/AHT7JX1zR7SQjXOYc3GGOKc5lmAQdYyJucx1ucz9Oc8rxTnOYZ
/uRZ/uJ+jnMfJ9jKN9zGt0zwHRuYYT2HWMpBlvARZ3zrbeZ5hWO8yizPc5gX
+ICHmeYe9jPJPm5nD7ewneu5lSvZyKVczRiXcdqZxZjnd2f5TaPKWD/jQ97j
3ei+RHdFR9RvvjO6a2pWk1apRjvsVbNQBfrirn7WWvNPbOBH5pTVCuthLudr
VvIVK/iS5XzBMj5nKTPx///NP+pLch8=
          "], VertexColors -> None], 
         LineBox[CompressedData["
1:eJwl0j1IVlEcwOFj6uQniDllqYGpLb1LlKnhZ4FofiwZlr2Zg6ZBNbUklC0J
lpuiQy1BDTpE4uJXTgr6VkiCEqjRapCbIj2Xhh/P/cO5cM49tyD+sHUgKYQw
pYqsEJLSQmjhGd7gaTbzFJuYzzss521eYicvs49N7GUzB9nHZ3zA1xziCF9y
khOc4CSnOMsFrnOeCSb4mz95xD/MSg9hn9k8ZiEzs0OIMZ/VbFO7Ks09bORT
vtGo+s3vOad5bWlbf3Wg9IwQMlSsRWvPsUTVWjPXcJ21rFNcO+Z73GU393if
v9jABOv5ldf4jdf5nWVcYim/8DyXmcfPPMkZHtnbWx7yHXejM3EnOhdX+YIr
HOI0H3GcdznGOJ+zhf2sYQcv8CZj0X5ZxIvMYTGTo30wN3rWnm+/7042uMkf
WtIn80d+0LBe6Yke65Y6VKkKdVl7hWdVpLboPtnKAqYqRVfNyaziieh9hrT/
/+0/edJazg==
          "], VertexColors -> None], 
         LineBox[CompressedData["
1:eJwl0j0s3GEcwPGH9XCOmgWJTSJpYpWQWCm9YpA0Fsu5F0aWOxK0Q70sXdx1
ZMF5WWpxiYGRwVbEwkIiUUUi+rkYvvnkl/8vT548+TeNpvqTFSGE70pEQ/gU
CWGGKeY4ziyTXOYclzjPAvPMs8Aif3OL+yzxhKe85glveMFX3jNWFcIbWxit
DeEjG9nNNsbZyTFOaVoj5hWuaV0HKumPzvVXq3Ye+U811SFsmKPcZC23GGOR
ddxmPXf4gbts4B6fnZHnEwt84S9e8gcvuMhj5njEGW4yzQ1m+JNfmWMvs+xj
gl0cYjt72MwO1rGVleV78cFbVfKKd97wVmc6NJd4oHWt6ZsWNKGMZu2kOawh
TZoHy9/5pbzDONP8zBQHmGQ/x9kXef9P/gNwCFIZ
          "], VertexColors -> None], 
         
         LineBox[CompressedData["
1:eJwl0Dsvg2EYx+H7ndtE8QU0Ya2FnYSRwcCmSSeHpP0CaH0Hh7VHEoeF1SFp
HXZlZ3SYdMf1xvDLtfzzJPeTL1WWyklEFFUfimhkIi55xQtes8cndtnnM9/Z
5wff+MNX/vKbI1kP5iLGmeMUxzjHApe5pnVta0d72teJTtXVlm0v3fAu3fGe
VT6wxkfu8pxlnrHCQ67ygEXWuMAqF7nJGW5wliuc5DzznOYwJ5hwlAO3Jelt
+nLrp17SP9GtbnSsI3VsO2yzzRZbbLLJBuuZ/3//AympOmM=
          "], VertexColors -> 
          None]}, {}, {}}}, VertexColors -> CompressedData["
1:eJztvXdcVGvSNaqoqKioiJgAE2JWzBhLUYyomHOOGDCAipgQFbMHIwZEMGJG
TIABMWJCRMmp6W6ggaYbxYBiuD3j2sd793frc5hXX8GDf83sw2+HqrVWP1VP
PVW1J88bPE2rSJEiRysWKVKsiPAvi6b/+5+Kvv1/BQnXTTooWykrqKhE5uik
gAmpf1+vutXXYrhfJm0L1r3h5Z/y9/XY5Gw9rXGZlDtgo2yK7vfrIZkmF8Z8
VZKscz3l4/HJf19/N2rUkPhDSjq3odenm6flf19P66v00SUlLS57bXPHd7K/
r5/ziNZbG59B60uPPDKCZNThxdPk1TI1pbXKzg35K4NmerstS4yRUv8qJSMa
3lNT1fHOL193z6COwdIVIculFGknndbmhJrm3zO9Xv5DOqW0WjDsdU0pPZw9
pFjCRjX1bxFkefl8Ol2bMVDn890kOrLDYeT4uWqy1fOovnhmOt374O1wdE4S
2eT03/ZqkJoSXFvVTqmbTj0vvyrhWSWJBk5ftzasnZrc697csFeaRkHDZ7U+
fl9CDn6GWh1rqklrgd9to2NptDC8Xq1ZjhJ6d+ugdHIpNXXRzrUrOieNmkZc
frW3lYSaLm3WY1W2ih6EyWcEt0ujytf9j59LTqRyxv4BQRIVvbMlV1WpNEoZ
Ulm5YkEi5Zg7bBkRqiKLlgcNkxMV1GpS2nS/Mon0cGW1TzNvq+jJRJ+LFW4o
SFfP49KIywm0+Lbd0apXVfSl9I6oB54KilEUmdxyXgKpJA5pzudU1CjCeN2g
zQp6GzXEPqd9Aklmeay+4a0i7fPLi8qXK2j2lNKbzAwS6JT/guqRxzS4ebPl
65FFCkrv9+ZIm+L8deE+JXGfObgP91zuPYXveorvqoDvEuzQA3ZoCzsIdnsP
uylgN8HOwbBzVdhZ8AvBL83gF7Ef7eBHa/jdA36/A7/PAk4kwElv4ETA1Tzg
6j5w9Qg4HAgc3gAOBdwuAG4VwO0A4Lw6cN4FOO8IXqSDFzbghcCjC+DRZvBI
uJ4B3i0V8S4HPL0g4mkoeJ0i4nUcdOCLSAdqQDd2inTDFDpTSqQzedUlv6D9
fYdeyqT2jaVljH2/37/ZptlTxg/NpCpHbD6affn+noYfBj6Y90pJ+tmXd1/o
8f26pMuq1Z83K0m+O2TwMpfv32tz/dibzSZK6hl0ZZbLXRntfNbO3O69mu43
+tTnVFAGSWwq5V6oKqPdpV172Eao6cm1KIXRvAxSWG9+OcxXSodeHvObcFlN
U9uV37zUMIP8zhxQx/aTUgX7ou+cdqmpSE/7o1aP0qnlgOdN3yUn0YW3LY11
7dWkp5O1oenSdKKd7d6PX51E3s61Z1gOVZPjrB6BVxumU6nKNUwjjZOo8Z4W
46a3UVP3A3NMN8Wl0WBjp4C6gRLqkdXa4EIVNTl9evOmx440ClPMH19mioTC
y+8bOS1XRXP6qfev75dG0hUx94aUkVBZkc4kgy+OXXfc1ApWUWnLhGoVHyto
bMNXxSpGJVCZ7aNUky6oaOE264qrdijI/sr2Hff6JVDXbXu+6B9U0ZKSaf43
JyjI9FiUq+JpPJnss/lotVlFPocdzvdtpaAll7dVODUhnkxTN61ss1xFV5Mf
f/irnIKGPHm3uKpWPBlUHlLyzTwVbR15a6BSlUp+zjZNDa/EUZWud4ed0OCj
Qo/YnWciU2n01q0Su+Vx5NO5knr6RM31m7V2lglOpdMX4qdcGBZHu/oe8rcY
p6I+CSvLtbiVSp9mePdrZ8FfvyC6zxnch3uu8J7b8J4BeM/6+C4/fNdQfJdg
hwuwgwPs0A12c4DdGsJugp3tYGcH2HkZ/KIDv0yAXzjdi4DfbeF3GfxuCZys
AU7CgZMmwJUlcDUMuBJwuBw4LA0c+gK3lYFbC+C2InCuBZy3Bs49wYvp4MU1
8GIPePQMPMoAj3aBd8HgnRy8E3g6BzztC54K16XgtULEa2PoQDWRDphBN2qI
dCMAOtNZpDN5XS9xurQ3cn7CHaWSOu+q1E3d8fv1nKCkcm9Wa3S4X8n9J+2+
v//SSYsGztVX0m2DT2+sjsuo6OCGo3tnqSkmK9I48HwGucut5Eu1ZHQ7wTsq
5YmarocajOk3IoNeVz126PEuKZ17q32k60k16ehohTf+kk4z7gdP6G0qJbPc
VRVd16kp1M3M5vXRdJLeKFvs2NUk6vxob5VKkzXrqIO2Oe2tNL9TlL3bq08S
var4ylOH1ORr/fjZ0Tdp5HF10KiS8RJqrUyO9DdU08iFzaNjPNJIu+H5NccX
/p/6kwQczty5ecjgWBWN3tVfd2SugtY0btb+8cBEUq5df+TedRWZzu8+POec
gvyeJ72dvCOB2pwoG6vlqaIYywqTKs5QkOXx1ZcqSuKpdXx4/37rVBRtVdKp
p4mCyr9tunxOh3iq1Hpwjfg5mvWM6c2irVJTyT7ObPGbw3HklKxHr4eraG9S
zdgZPql0aYx3rYo14ij2Weszgd1V5Hj6zWwbp1SqOq/XPZ2jsdRjwzkH+1Yq
Wp1jMvvsiFQq6+Q5uATFkmGHJkbtTVVk2GaC9r62qZRYNPFSrjKG+usGPW1m
qLl/rxe0yiiVKgQuDb52LoY2lGqjtq2soibtF+08VDaVnEJ6f5GujaE5i6qd
0dFT0fQ+PhkmxVOpRNTBu7Hz+OvcfcTP1cNzufe0xHc547vK47sEOyyDHQxh
h9Ww2z7YzQ92E+xcEnZeAju3gV9i4Rd9+EXwYxz82Bd+zITf68Pv1+F3G+Bk
HHCyETjh9K0NcDgaOCwNHL4Gbi8Bt57AbRfgfCFwHgictwAvnoMXcvDiPHhU
FjyaBR7dAe9ugndvwTst8DQOPPUATwVeLwOvH4DXwvVc6MBVkQ7sh250E+kG
p2N5jeO49RKnS3X80rYXL6+kru33bG/gLqOVi7Uvn1SqqdKTIs6+xzOoVqcH
fbu9l9LNEmW313igpla+ug2e9c6g1g5R9uHOUqrkaNqstJeatMNDzbzS0snW
8ZT3s7JSems5L/6Mo5quhWnPCNiYThW2LDwn351EJ/B7tBS/R9r4PWpu/8G+
cjM1WfWUaBbZafT+0uyri7y/x1+dsc5vgnV+eEqDd4tkKlLKI0wulE+jRm6f
b3dzTqTsjfvW7A1U0ZXl811KXlHQmRtrH8qPfF/nLMbvtQl+r4X1zBX87lvj
d38n1hu9sN54j/XGLVenXOeumr8v19J3kEMqlalhJM/5K5ZqgKc1wNM48LR3
Wr01R3RVVHb2wBJHclNo1PG1O2+PjqEW9VfWz/2QSWElmtT68iCFHgeeCDoX
E01zWmZfWqjIJLlXaNGG7inUNkw26ePcaHJ42tyvTUwmramn2OjqkEI1mr5d
dLFyNO02vJMx41kmWc2O0tk2LoW0Vro4Xw2LokdlpIdNgjPJOujYy2n9UuiC
NPHV+WNR1O3tqOEr72bShw2DKve0SKG7dXf1Lf8Xf124zyDcxxf3ET+3OJ4r
vOdavKch3lP4rhR8lzm+qyXs8AJ2eAI79IHdysFuY2E3QQ+NYGcJ7BwEv/jB
LxXgF2Hd2Bd+/Aw/cus9bl0n4OoqcOUDXEUAh2rg0Aw45OJTM+B8AHD+ETjn
1mnvwKOb4FEl8EgfvCsN3i0A7wLB09bgaVvwdBV4XRm8NgGvBR2oBx2whA78
SMe49Vhe80tcHCdeL3G6JOSRqiC+7oD4OrfJHLnUXU399Fc5dEtMp6hXCtfX
X/l47eoNB930vmqqvdJj0hC9dMqo2n1neNEkOthxuE5AbTUlmPceMeZ0Gk0b
XKZWfWcJDZZNd72Xo6J6cQtMc3qkkdXoY9SimITeI7/RFfmNZshvJCKvUgJ5
lZnIq5Sw9j7Y01lFstm7HwQYKsgoa+nzy/V5/anl6NWvaAfN+mrYWsdyM1Op
8dvLXl4zYun2mKwBoVVV1GnjQ61KlVNJbh42MGrfd515Dn4Fg19fB+1yeRif
SeHzZeWcV6fQx91ui5IaR1NX6MB76MAt6MCzW9q+w89lUvy61R+lOilUwtLV
8GKJKFrRe27WhgOZVCF69R5JbDJ12HYszGh7JPU52/l+9y2ZpBuuc/bi5WQa
37JfkQUtIym2/qu1Z50yaen6x6Wv702mC66dzfenR9CzYQGOModMGudokWWx
LplCJYZNBgZE0JfmtZd8sNfow4HuqUuXJdPtsTPO6xzmr4vvE4b7CM91xHN9
8dy+eM/yeM9JeE/xd3XCd4XCDgmwQynYgdPPIoO/2TkCdv4CO3O6dwd+7Aw/
psGPteH3BvC7GfzOxcXawFUKcGUCXHH5PS4vNwQ4NwXOBwDnHuBFEngxE7zw
A49MwCMVeMTFm5/A0/7gaQx4yuXNfqRj3HqMiyvzmvcW55e4OI5bL3G65Pxm
8tzwBWoyLKkIOWSXThPHWmkvd0yi6jL/MWY91eQ2JqjOGu100up6y7l5toTs
RiZubFtdTe+K1NyzY28aPWpc1DJuloSOz/fLaq7SrHNudK7i3CiN2q5f8vL2
3UQKRj72EfKxpZGPXTZiWVALNxVt+mLipT1IQTsG7Tk/42Q86SEuKIG4YAHi
ghjEF0sRXxggvrBC/LIH8UtZxC8ztkbNW/Uuk0aU0A3vHZhCy9pH1TC4F039
YqZmFn+RSTvvKbftmZ5CHsuPbjFOi6I56X3jyvtq1j+ZjeUt9FPIXdL2erBh
FK2rvjlBuTOT6k5/YhMTnEzFuzR+pJ4U+Tffx4LvIeD7uAkltdpMyqSuemtu
6/ZNpjjFxOhl9SOoXbHYjTX6Z5Kksb7BsyrJFCDpnxV/Kpxe6L/4EtxJsz4Z
4RRQRC2n1P5Xck5ZhtME2YTh080yqfvYiZV1QuXks3qwXJLzkuamn5HpNdD8
fabn4vbX5OQl+ZTW7d5L2lTx+gtZ3UzyeXY/5I6PnG7OeTNk0Gn+unCfVNzn
MO4jPLcHnuuL5wrvmYr3TMN7Ct+VhO+6hu8aDztYwA4S2CEUdhsPu72A3Vxg
53qwcynYeS78kgK/eMIvVvDjbvjxKPw4E34fDb87w+9cnMvFrVx8uhy43QLc
7gVuuX2HE+CFA3jRCbywB48+gkch4FEN8G4/eFcCvFsDnhqDp5PBU0HHBoh0
TFiPtYEOtIMO/CiunAudsRLlx/7T/Tgu783ll7g4jlsvcbrE5bGbBbq6RCpU
9HB1TLl6RmnU3+uSt8eRRDJYGT4qy19FuhO0jWUnFFTHPqdJmFMC1UXe9Rzy
rvORd+XWRdMTqsU1NFNRxMALsoUDU+lU87m1DzaKpbYbbLeMLa6icTlr3V8l
aeKXVZJ9OjViaAnilNWIUwyEOEWkP/uBc2E9Uw7rhLFYJ3iUaGxd3yaTZC3i
1inHafgy/OimWyMjyO5Gc+OyfTJp8efUDd7lkunBwzfrL2wPp/n9Nk/p0iST
5kus2h6/J6dBc5vYGCa+pGrz2l0pVimT9rTPXbtT8/s0s+8rdx+LlyS9PPn9
vs9K2jortX6ZQXJa1trtUeaNF7S1iGp4W6WS2h67Y7Cjnpye2rheMhr8QoPL
rUuKJyrpcJtBM3cXl1OtJu2SBxR5Qbm7nfzqRSjpUXXfTTNVMqoUfqWH9cMw
elyv0kmf50oa5FxL3l0mo9VG8RfOnuWvC/d5jPvo4z7Cc4/guXXwXOE92+E9
n+E9Zfiubfiulfiu6rDDXthhDuywAHZbCLsNh93sYWcH2PkJ7HwIfkmGX3Th
F269x+kbF8+2A64mAFd+wNUM4DAKOPQBDrk4VNhf8AXOHYHzKuBFRfCiEXjR
HDx6Ah4NBY+4fQFOx7j1GBdXCvmxQOjGO+jGj/L8/2mdALcfx+W9ufwSF8dx
6yVOlxZhX/sT9rXDsa8t5KujkBfVRV70xsjJb+8NUWnWByl1lnqnauKsSa+m
lowjQzfblrI6KjpotK6jRbNU0o+TzO4fFUNrfK1vFsnOJKPJHaptuZJCDf1H
a80+/z3+eoc44ibiiHETUlyuu2nWMzt8tk0KS6YTlz/Guy6NpEjzK1NrzM2k
Vy3M/UNmaNY/923md18QQZH75nX40COTFhxdP3BpMU085e90cJ5DOE13PGt2
oaYmHhlWp53lcTktcW21q+/27zqzBXxcCj6K9aQmeD20pM5HEzclbepl9qaZ
5vep+ZWRngtCwki7fFKL0FJKym2svtBwh4wsOx0u/XDRC7qVbrWpw+4MujN4
4v1NNjKq//Sz6bnPL0hrSnNdl84Z9EyiV8uvr4wSylm8ezz1JR248eovV60M
Wr077eLXNjJSjtx1yujUS7Lpt7FYljydHDsmtN7TWEZ1HJzfvX7CXz+I+zjj
Pum4T0k8NxTPjcZz7+A97+I96+I9S+O7PuG7uuG7RsAOm2GHxrBDTZEe1oXd
BN37C3ZeBTvPgF8i4Zdl8EsU/GgPP0bAj1Hwezb8Hg6/jwdOLICTs8AJF5+u
BQ5rAYfNgUMj4NYTuK0O3AYC5xeB81DgnNsvENeHxIJHnI5x6zF/8LoeeJ0F
Xgv5sUDogD50gMvzc/uVnC5x9UtcnQC3H8flvbn8EhfHceslTpdypGfe7rHW
xPWxnkfWeKaSe3Lz7BPZfLw2G3laGfK0LZCn1dGTxty7nEnq0GMSB6MUKnVk
6cVHraIo/HD77VvXZlJ6gFODOYeTaeTNx+meWpHkaR9U3GxYJs3sNbSPVpNk
SjokXfMuLlyzvvoW78gR77gj3hHrjwN48RHrjYdYb5THesOg/fkWDvWU5FRv
RWRHdxktrFzufZWhL8jLLL1R7OgMcmncw7DkMBnJ99uOGahZPxzdPk4++WQ6
DZ/2YaW3gYw+uHtmvdMLJwvf08dua/C06oEsxy9JSr36jXutezecGqm0ts/X
4C/IvZL29StSumFi65Q4JIJmbF+891DHNNrcMnyd0R4puV+p5v/1VgQlfg5f
1uGzgiIWVslp7iSlLw33uY/RiSRFroUyMV5B7ta6dRovkpLeDTM38+b89STc
JxL3+YT7zMRzt+C5+/HcJnjP23jPa3hPS3yXE76rO77rFOwwEnZ4DTucgN02
wG7xsFsN2NkZdp4DO3PrQG5dJ8S5Cvj9KPx+GDiZDZykAScRwJUKuJoIXJUB
Dl8Dh+WBQ25/gYs3P4AXPcGLw+AFp2PceoyLK4X8mBS8tgGvT0IHVkAHykAH
hP3KMOhGMnRDXHdxHTqT17pKrn6JqxPg9uO4vDeXX+LiOG69xOlSUe0JWgp5
JkW1HN99wM4UshnpFFt8ZPTfeelY5GOLIB8bgvzGGOQ3HiO/IV4XheD3VIi/
diHumIa442pDz6a2MiXVKrv6/MHycvLUSqp+usYLWll70aOSFkpKfLrPxvK4
jGKizHevafmCimJdEYJ1hQTrihWrzSUDB6bTu4odfIq8l9Lz4fXi4peH04pB
Fh77l6bRiefqR8mnpZRz/JZrLYcI2lP90Y5ZNxVUwiE5yXCWlHx0blZoMzSS
OlVuEbuppoI21L07oFdLjV4FpG7/qhtFeke7GLh4pFLPsbdvqYtr4vnysUY+
x6MoqG9wcc9OqTSchnxdL02iuHelKjyqFk1HNwzpFvoxhdz3S3RnPE6i4WWu
9ms0I5r0DmxpejM6hRJzZ9x+EJhEvXoHlCi7jb9+XHSfobjPbTx3BJ4bg+dW
xnv2wnuWx3t2w3dtwndZ4Lv2ww7asMNp2GE17HYSdnsNu62Gnd/Dzo9hZ269
txZ+lMKPL+BHP/i9LvzuDb9z8Sm3TuPybMI+QiJwWxq41QLO44DzBcA5p2PC
euwSeBQGHnFxpZAfCwFP9cDToeB1A/DaGrwW9isHQgdyoQNC3YUddOMWdENc
P9YGOpPXem8u78TVL3F1Atx+HJf35vJLXBzHrZc4XfqMfatQ7FsFYN8qDHld
OfK6MuR1g2rX82qjnUkdHPpbu07XxAXFLzpZZb+gR8jPWCM/sxz5GVvzue97
+GaQgan5mkA7GT3bvWDMxtgXtGVcT9PFmzXx/KNkc5OyMlrjEfS8XttwWibS
n4/g0cr960ybr1JQbWWRYvIhUvIPtVdu8YikCiKdqQz+loc+JEAf+kIfQq4O
qBjQMoX87iw/XnldEh16kNncZnAM9Tx6eF/V08lUpEFAu9nDkqhYw9yExFcx
9HDLK+NmPZJpg+Mwva4tkqij23hl4qxYWmjWXfnli5yGbxrvo66aRKdnl7Ju
dz2Wijzo+b5DnJy6BO9WXC2bRA3bpjWokhxLWrhOuF4f17n7PMFzN+K55nhu
b7xnUbzn1wbf3jMU3+WP7zqA79KHHSSwgyXswOneOti5Lux8AXZeA7+cgl+y
4Jcd8KMd/LgcflwMv1eD3+/D70IebzBwsgY4uQNcdQGu1gJX4v2FdODwq2i/
9Q5wy+kYtx4Tx5WG4NFuUX7sC3gn5Pm3gafu4OkH0X6lOXj9HjrQFTpgBh0Q
6scuQzcOQzcuQmcMRHmwvJ5D4eq92bpKpn6JqxPg9uO4vDeXX+LiOG69xOlS
ml7zw2lFM8lwSMrgsDFy8oqtu9476gUdm/T43pCLSrpbftBqgxAZBb3X1h2o
wdshUVyWgviiK+KUlYhTeiNOkYviIwPER43tPrtl3Uylfae7NBxaQUrWVRNm
7HSKIqeUUVF/+aXQxR0R640vJdG8C21ydC9H0+BV1aY3eZpMbjflBtMmafiu
pa7z7GEMzYcODIMOnIUOqMpF1ihqLaeRucPKzo+V0Llwh9dvNsaRRe+u7slB
MhoSdCdj5UkJjfUbqVW6RTy9PrtCu+JwGVWIK+u1b42EBtxb3Dn0fDwNH7K9
0q5yMrK1W1e81iwJdXp5/EvpEgmUeL1VrfppmnhvrVQyeJyEJkrD18Q3TyCJ
6Pp4XB8puk8H3OcNnlsRz7XCc3viPYfiPUcJ74nvGoXvOoXvshfp4UnYYSTs
th92Owq7rYWdL8HOs2DnVvCLO/zSC35Rwo8e8GM5+LGXKD7tBr9zceg54CoY
uLoCXKUDh7WAw9PAIadj4vVYOHAuxJXZ4EVF8ELIj9UGj1qCR0KePxq8uwje
6YOnpcBTR/BUqLsoBV7bgteR0IEs6EAr6IBQBzsWulEGusHFj3k9H8edQ+Hq
vbm6Sq5+iasT4PbjuLw3l1/i4jhuvcTp0tfJ/994TYq4YOi96fefhqfRLLs3
L62eSImk+2T+Zfh10S1RnJWAeMfpY/fSnyukUHWX/ZYdlibRtSM2ikqOMTRP
pD/nwDvjYQveNy8tp2JpN4O33NbwtMopv3bxcaTu30JL2kJGh+Ys6yZdLCGd
+M2vRsfEk75Vy1r1lkmp7C5Pn5NtJdSsX06N1hcSaHjIhraBKUn0vk27/c5a
mvXxkgjXsxMSqesJqxMmi5NoZ7Ez/omXE8mk/Z2VFeWJ5DSqapeFjZIoPUtt
dNopkR5Y2q3fYCyhhL6pTjOLJ5HyYu2LqmmJ5LdrWra8tYQkuJ6J61dxfbXo
Pvdxn2547i48tw6eOxrvmYP3fI33rILvKofvaoTveg07eMIO2rBDHditBOx2
FHZbAjuPhJ2Pw84u8Ish/HIJfrkPP46EHyPgR26dNg44mQuctAZOuHiT0zFh
PUbArQtwGy2KK6OAc3F+bDJ4IeT5P4JHweCRsF85Cby7Ad7FgafLwdOa4KlQ
P5YKXpuC12+gA37QgUtCHSx0Yx50Ixm60RQ60ws6MwI6k9dzu1xdAXcOhav3
5uI7Lu/E1Qlw+3Fc3pvLL3FxHLde4nTp+BK/5Jma7zzboPpQ/95Sshp2ea3i
TiR5IT9zAPmZ0cjP9EBc87X+t7imOOKveMpe2slOTj7duz9+niqhnV+TL22Y
GEdZonWONdYbtwLelu84XEoJGyN2+TSU0P6kagH74xKoC/i+A3w3Bd9vBb2b
lX1Vsx66PsmihVkidY5a1CRykoQinAzvrjKSkLLSX8+87iTQ9f6dVYevS8hs
1ejN+60TycHh1uNuCxLoYZCq6YaiSbT8wEvfUhcTqHvDSduS2ifQQZPrp6Oa
a66nXQqMmZJAHcycVeWMNe+RtcrduNf/5Tpzn7Z4riOeG4znxuA91XhPf7zn
fXxXV3xXe3yXBeywG3aoBTvchd0ksNsu2C0HdtaDnXvBzsnwy0X4ZRP80h9+
1EJ8+hHx6Sn43QN+Hwi/nwdOfICTbsAJp2MngcONwGEscCjElUOA27XArTg/
ZgucC3n+OeCFEryYAB51B498wKOl4N068K4WeDcAPN0PnhqAp0L82A+8LjLz
G6+Fen5H6EAT6IBwLmk8dGMLdEOoo1gLnYmAzuS1nwB3bpc7H8edQ+Hqvbm6
Sq5+iasT4PbjuLw3l1/i4jhuvcTpUvCKredTNyTTlHL6RjP6JNGzsVMi9KrH
0qXHO4+caCKnDo2b+hd7JqGcVda71l6MowTETRURN01G3PSkuu+Y4UGa9dbX
VQn+6Ym09X6Dbic38/rzYeI02RePRJLqbN4esiWBdK62XLUiXULzLDPr2egn
kHxZmw11tDT3nXdtnsP4JBpafejlDy/iyO/SPLd12+PJwe5j2onrmvWF6ZwT
LyWxVL1Km2F6neKpyt1ru2sWl9L84t1eTewcS16ltCWeGr/a2yovNGotpfaK
Z326ZMTQgEVq6zvJcaRcf7rcQCv+uj3ucxj3scN9zuC5RniuAZ47Hu95De+5
CO/pgO9KxXc9xHdpT/pmh1TYQRt24PQtDHa+CTtvgJ1T4Bd9+GUU/HITfuwM
Pyrhx1D4fTr8fh9+53TMBbgyAa58gKvewOFq4JCAw6XAbXXg9jZw6w+cmwDn
pwWcgxdp4MUJ8CIaPHoLHkWDR0L9mAK8OwbeCXWwY8FTF/BUqOdvBF63Bq+F
c0n+0IHR0AEVdKMhdOMWdCMSOjMfOpMCnclrnxOunwB3bpdbR3HnULh6b66u
kqtf4uoEuP04Lu/N5Ze4OI5bL3G69OK9W7kDd6UU0N3iqaO1hPY+6OYZPppf
F/n26FZ3QA8JhZidmadISKCWvU+khx2T0FKsW9pj3UJYt8xaO9mu5Zo4anVE
ZVxnUTzVzXVpOP2lZt0C3egP3ciEbux5eOCv7EPRVO62vtewBXH0ObnVwvNn
pbQwM2Tv9qNR9LHbaPPPVeOo1Nwvn3a8l5JuoKXZrtxImjImaP2++FiyD2/1
tEtDGdXZeK7OyeORtKj02gNBgbHUtH/tba0t+OsVcZ+puI8d7uOA537Cc0vi
ue54zwp4z1y8pwW+axC+K03QQ9ihLexQC3Zwht06wW6dYDc/2PkF7NwMdu4F
v+yFX2rAL3Hw4034cSv8yOnYQOCkGNZjOViPPQCuRgFXL4ErFXB4CDgsAxy6
AbeLgNslwO1G4FwGnD8FzuXghSt44QxeCPHjYvAoFjzqB95VBO9mgHf9wVM3
8NQbPL0LXncFr9XgtbDusoIOaGHd1Ra6kQjdsIZu6EJnPkJnVNCZvPZf4vqc
cP0EuHO73Pk47hwKV+/N1VVy9UtcnQC3H8fmvZn8EhfHceslTpe4uMz7oM/p
i3fj6dGTRr1qpsSTl3p225RFSeRkYXmis8auD6Y6xEyrGU+zKxklVzfk9YfT
Ga9ne861Oh5BWl7dnD2nxZL7hoG6e7ZqdKOU2dlGR8IpJ2qKh5uOZh2cbTLb
P1pGbkMuDir19iU5bbavPu1pDA3UcR6sKCunm/u7r1x/8CXd93l64KgmToh7
0dLN05S/fhD3ccZ9+uM+K/HcXDx3Gp57Du+pjffci/fUx3dNw3ctxHcdgh0q
wg4fYYetsNtj2G0m7OYHOz+Dnd1h53j45TX8chV+4XQsFX6vDL+PgN9TgJNL
wMkG4GQzcGUEXJ0DrtoChweBwx7AoYtovzITuC0LnIcB5y+A80/gRQh4YQhe
zASPYsAjZ/DIE7xLBe8qgXe24GkaeHoCPG0FXoeD12HgtXBOPAA6oA8daAvd
SIBuVIduLIfOlIPOzIDO5LUvHNd/ietzwvUT4M7tcufjuHMoXL03V1fJ1S9x
8R23H8flvbn8EhfHceslTpdsETd5Im5ahLipgc8l26M5UVTLI6P+xrZxFBG6
42FcgpSuVVDX/JCr0V3PPc3urYml+VG2hhPtZZRYx8Wri1U4pZ5tZ1NG4w+z
15feWGbLKL3xuf7HMl9Qb0eLyy/nx9CkPQ1rDRmtiZsbNspwl4VR7ptlFsMr
xdDBGXVLrvOWU2LvYYPvm4XRkJKL1i9/GU3OK/zllePlpDfdeKwi4jnZO6eN
S70UTc+PO5R0es9fT8Z9huE+TrjPcTz3M557AM/Nwnv2w3tOwHsm47vS8V3N
8F23YYemsIMt7GAOu5nCbmGw2wrY+RjsPB92vga/hMIvB+AXf/jxJfzYFH6M
gN9vw+/O8HsucKIPnPQAThyBq1HA1WHgaiNweAU4nAocbgZuTYHbU8DtRuD8
I3B+GzivC16sBS+mgBfiddda8GgReOcI3oWBd+vB0/rgqS54WhTnxKPB6+J7
vvHaCDpQCzqggA4I+4w60I0V0I2y0JnF0JmV0Jm89qvk+sJx/Ze4PidsPwHm
3C53Po47h8LVe3N1lVz9ElcnwO3HcXlvLr/ExXHceonTJW5dxK1nOP3xbXRR
u8mq51SnhtyoxK5okht10DpcOpmqrZ3qqDoSSmTj1828ejQdK7Lma85hOdUw
X791S4VQ2lNH0XxEcBTd7L372dtxcnr86rDZxy3P6OnLs/VbHoqizq/Mcnp1
5K9z9zHGcy3w3BN47hW8Zz28Zwre8wy+6yu+ax++6xHs8Ah2iIIdLsFupWG3
PbBbR9i5Puz8HHZ2hV+ewC8z4JcN8CPBjx3gx4fwuwX83g5+fwicJAEnfwEn
DYCrksCVO3A1Fjg8ABx6AIfVgds+wK0OcLsBOD8NnGcA52fBi03gRTh4IZxL
OgYeNQCPFoJ39uDdWPDuOXg6CTyNBU8twOtP4PUT8LovdKACdGAqdMAZuuEO
3QiEblhAZ5ZDZ1pAZ/LaR5frV8n1heP6L3F9Trh+Aty5Xe58HHcOhav35uoq
ufolrk6Ai++4vDeXX+LiOG69xOnSmh6eQSM2hdHkdcWevMuOpkjV0K63b8s1
8WWvcd0yQ6mBXpLLG4to8l1vsWmABo9B0JNH0JOO0JMdHtFzjj59SorHzU6p
60TRvQRLyy1hMtJZM/uF0vMJTdicPHTGs0gyLtNwmMkWGemam5mHln5Cm95t
PTD3WCRddn5lfmemjKri+lZcv4rr3H3c8dwMPDcYz+V07z6+qxm+6yq+ayPs
MBV2iIAdOB0Lhp2bw85zYGdv+EUffsmBXxzhx/bwY034sTzy/OnwezH4vTdw
sg84qQacfASujgBXn+K+4Wq5aN3lCRxWB26lwG1n4PYwcF4aOD8MnPuAF6PB
iwzwYgJ4tA08qgMe1QDvDoB39uDdBPDUEjxVgKfPwWspeF0RvBbixEjoQAR0
IB66sQq6UQ+6UQ86cwk64wSdyWt/b66PLtevkusLx/Vf4vqccP0EuHO73Pk4
7hwKV+/N1VVy9UvcOorbj+Py3lx+iYvjuPUSp0uZXXv6jc0JIde4Ejlpi6JI
p/L2VcurylndmOr9vkulmEcUO/beQt1BkWRweFm747Vl1Frv+cQB3g8p/WhA
ovGnCGphPXFF+Rgp7fQsnXJC96EGx0295j+PoL+ytTsYXOGvd8F9MnGf1riP
LZ6bgOdWxXP18Z6T8Z618Z5Fu337rt34Ll18F6dj3HosA3ZWws5NYOfq8MtM
+GUB/GIFPw6DH1Phx3XwuxJ+vw+/PwJOugMnbYGTmsBVBeCqDnD1ATgcCxx6
AYdRwO114HYHcNsHON8KnLcHzgeAF2vAC3PwoiJ49BU8MgePhDhxO3jnAt6Z
g6dy8PQOeLoKvNYHry3Ba1voQBp0oCt0oCd0wwW6YQDdaACduQadGQ+dyevc
Aa6/N9eflutXyfWF4/ovcX1OuH4C3Lld7nwcdw6Fq/fm6iq5PDlXJ8Cto7j4
jssvcXEct17idMnO7VOxhd0e0cTpr+55m0bSl/BVxumfpRTqFlt3pX0wmWzv
nHFQ8161RvXq8GW7lGJbdC91qMsDqv9osfsm6whSZti5L+gjpSPHpj5VHL5P
ufpF7vWpF0HHm7k9/GTCX0/GfRrhPircJwbPrY/n1sFzV+A9J+M9i0Z8e09O
x8Jhh1DYoSvscAt2awS7ZcBu72Dn/rDzONiZix+5ddcs+D0Qfl8Iv0uAkzfA
yRXgZDJwlQtcpQNXVsDhcOBwMHA4GLgtDty+wT6jMXDeFzgvDpy3Ay/ugxfn
wIsn4NED8KgqeLQNvOsI3kWBd+HgaQZ4+gY8FfYTK4HXc8BrR+jABuiAKXSA
y2tVgc5sh87cgc7kdR4K1/+f6+/N9dHl+lVyfeG4/ktcnxOunwB3bpc7H8ed
Q+Hqvbm6Sq5+iasT4PbjuHUUl1/i4jhuvcTpEqczLQeVe6C0uUcuK3ZUHRUS
TtcrjnS7HJtEqzbGVTn+5C6V6zm6+MnDmt+bkse0ZFf4651wn424TyDuwz2X
0zEHfFcSvqsGvus47KCCHR7BDnVhN0vY7RTsdhF21nr7zc5usPNm+OUr/DIZ
ftkAP2pZfPOjFvzoB7/Xht/14PeewIkTcHIHOOkLXO0HrqoCV1+Aw8rAYVfg
MAK43QLcNgFuQ4DzMcD5U+DcDrxwBS+2ghflwaMX4NEz8KgWeHcCvGsK3k0C
T3uDpzfA03jweiV4fQO8doMODIIO6EIHBkI33KEbNaAbVaEz+tCZKdCZvM5p
4uahcPMCuP7eXB9drl8l1xeO67/E9Tnh+glw522583HcORSuTpurq+TiPq5O
gNuP4/LV3DqKi+O49RKnSysatC0V3ewu1Whs5/5icTjZ7E54n7U9iZ7M7Ftv
nesdavE451ZU33BqNaTu2MQ5/PX1uI8x7jMH9+F0jFuP9cZ3ZeG72uK7uHVX
PdjtAOx2B3Z7DTuPgp1XwM6n4BcX+KUP/FIbfpwFP86DH13gd2/43RZ+3wac
9AVO3ICTTcDVK+AqCLiaCBwuAA6bA4crgNvRwK0HcOsDnHsC572AcyV4EQNe
qMELb/DIBTyKB48+g3fPwLua4N088DQDPD0Lngp5+MngdQJ4/QQ6MAw6cAM6
sAm60QK6sQW64QudqQyduQqdyev8OK7vNDf3hOs/xvXx5vrlcn0puf5vXJ8l
rp8J10+AO7fLnY/jzptwdd1c/SSXP+fqAbj8M5f35vJI3HqGWxdx+rN5Tmru
yVe3qea6jEF+xuHUO8lR/5zGDrtxvQ6u98V17j4b8dwKeK4rnnsW7/kF7+mN
9zyI78rAd23Hd9WBHVxhB3/YIRF2ewG7WcBu9WDnZbDzE9g5FH55Ar9Ewi8t
4Mdl8GND+HEg/D4cfk+B33cAJxbASTvgJA24ygauLgBXSuDQADgcDByWBW4t
gNvqwK0xcC4Hzs2B83fgxWHwQgu8WAQerQKPKoFHT8G74eDdVvBuC3h6GTx9
BJ4WMfvG6yjwOgS87g4d+AwdeAYdsIVuzIZu6EE39kBnBkBntFFfmte5ln+q
XnF9Trh+Aty53fymV9x+3K/WK06X/lS9ag0/LocfG/yXepUOXL0Brnx+oFe6
wG134LbqP1SvuHkc3FzLH8WD4jlN3DwUbu4A19eR66PL9avk+sJx8SDX54Tr
J8DFg9z5OO4cClfvzdVV5jUe5PbjuDiLi8u4OO5nxYM98dwteG4QnpuF92yK
93z1g3jQGHaYCjvU/S/jQR/4ZQP80usnx4NbgKvXwNUt4GoycLgQOGwKHK4S
xYPuwK0vcO4FnFsC55ngRSx4kfk/jAeV4Om5/+V48D+dA/6f5tv1mHx7cVG+
XTyniZuHws0d4PpvcH10uX6VXF84rv8S1+eE6yfAndvlzsdx51C4em+urpKr
X+LqBLg8Nrfu4nSMWxdx1zld4tZRcrxnQ7xnPbynM75Lju8ywnf5wA5ZsMMT
2KEB7NYbdjvzg3z7dvilaPQ3v0yEXzbDj8WQby8KP96G303g9/Lwex/gZDVw
chs4sQKu3IErA+BK69w3HBoAh52Aw0jgditw2wi4fQacjwXOHwPni0T59s3g
hR549BI8eiLKt3uDd81E+fY+4OlNUb59FXgdyOTbK4jy7QehG4bQjWrQmcrQ
mek/yLf/qJ5BPAf8R/UM4jkg3DwRbk4TNw+FmzvA9ffm+kly/Sq5vnBc/yWu
zwnXT4A7t8udj+POoXD13lycyOWfuToBTse49RinM9x1br3E6dIGvOc0vGcx
vCe3jkqDHSJghx5CfSns1hR2y4TdPsHOA2HnMbBzAPxSBn7ZBb+cgx8N4Md3
8KMt/H4Lfl8AvycDJ++Bk4vAyVTg6hNwlQJcWQOHI4FDK+BwGHBbArjNAm5r
Aef9gHMt4NxcVM9wFrwIAY+CwSMD8OgvUT1DjKieQQmevgVPrcBrffDalqln
qA8dMIZu1IFuKP/LegZufhk3r5abA871X+XmWnLz47h+/tw8FG7uANffm+uj
y/Wr5PrCcf1JuD4nXD8B7twudz6Oq3vk6iS5ukpOx7g6AS7+4vJI3HXuPtx6
idMlA3zXAXxXJXzXY9jBDHbwhx24dVQO7JwFOzeAnevDL3Pgl7nwyzD4cST8
KIcft8Hvavj9Dvz+HDjpDZy0Ak7qAFcVgStj4OoTcDgOOPQADuOA2xvA7Tbg
dgBwvg04bwWcDwYv1oIXrcGLyuBR0SbfeNQSPEoG73aCd5vAu/bgaQp4Giyq
F60MXvcW1YumQwe6i+pF10M3qovqRa9DZyaK6kXFusTNjRXO41xAnbyD6DyO
eM4jNw+Xm7fLzbXk+vNzc5q4eSjc3AGuvzfXR5frV8n1heP6L3F9Trh+Aty5
Xe5cCXcOhdMxrq6Sq1/i9I3Lb3PXOf3h4jhuvcTpkjvsMAt2CIUdImG3ENgt
HHZ7CTu3hp1tYGdf+KUK/PIWfnGBHzvDjzXgx6rwuwp+LwK/DxDFffrAyWfg
6ihw9QHncbg8FZdXPwac6wDnHsD5ZfBiLHiRDF5MBo/+Ao+MwSND8M4dvFsC
3k0ET3uCpxngaRh4LQev9ZnzOJE/OI9jCp25Ap1ZKzqPI9Yl4Vzhe5wrVOBc
odAn0AHnEBviHOJqnFvch3OLfji32AfnHMvhnONYnHPk9g25OSDcXEtufhzX
H5ubh8LFiVx/b66PLtevklt3cf2XuD4nXD8Bru6a0zFuPcbVe3N1lVy+mtt3
Y/fjmPtw+SUujuPWS5wucfFdD9i5EewcAjt7wi9h8Mtk+GU3/NgdfmwLP3Lr
qGfAiQw42QCcNAWuSgFXbsDVZODwIHDoBhxycd824PwscC4Hzn3Biy3gRSh4
wdWF2oF3i8G7SeBdGHg6BTyVgKfcPmA/6EBF6MAM6MAa6MZB6MZt0XnnFdCZ
1qLzzmJdEvo2BKNvQ1VRPxk79HlwEPWTEc/LFvJaRohPJYhPi6DvRAT6TnxB
PxluDjg3b5eba8nNj+PmNHF9trm5A1x/b66PLtevkusLx/Vf4vqccP0EuHO7
3Pk47hwKpwPcPhpXD8Bd5+7DPZfLL3FxHLde4nRpE+x8EnaeCzs/gl8i4Bc3
+CUIfoyBHxvAj3Hw+3343RF+5/Ln3DrqL+DQDzgcBxy6Arf1gdtjwO024PwT
cH4dOG8IXriAF2PBCy7uE/rJLAfvIkX9ZBqCp5XAUy3wOha8Lo1+MlyeqjJ0
owx0wwm6UQ46swQ64yzqJyPWJaEvFqEvVjP0xVqGPlo66KM1AX20uHmLQp8u
P/TpqoA+XVycyM3v5uaAc/N2ufoHbj+Rm9PEzUPh5g5w/b25PrpcnzeuLxzX
f4nrc8Kda+PO7XLrNO4cClfvzdUpcde5OgFuP45bF3H5JS6O49ZLnC5xefKB
8KMH/KgHP2bC71Xgd2v4PQs4uQqcLAdOdgBXtYCrE8BVJ+DwEHDYCTjk1lHc
fh9XnyD064sDj1zAIy/wLh28qybq15cBnp4W9esTx323oQM3oAPVRf36EqEb
RqJ+fbrQmZmifn1iXRL3HbVD31FuPSb0Q45DX9O+6Gu6SzS/7DPqS++gb2pn
9E1NQ99UK/RZ3Y0+q0fRZ5XbT+TmS3L5eW6uJTc/jpvTxM1D4eYOcH1xuT66
nI5xfeG4/ktcnxOunwCnb9z5OK7uiKv35uoquftwdQLcfhyX9+byS1wcx62X
OF2Sw4+34Me18OM9+L0r/C6H37l9Pa4OgavzdAduFwO3C4Dbv4DzFOD8PnDO
raNiwCMH8ChJ1A9ZfH55AHi6Dzw9K+qHbAFevwGvufrPdtANCXRjiKgfci50
5jXTD1nQJWv0dfdAX/c76OsuzN+xRR94GfrAZ6JvfH30jb+OvvHcfqLQl74B
+tKboS+90Md+NPrYO6OPPbfuikKf/Gz0yQ//u0/+//8ccG7eLjfXkpsfx8WP
3BwBbu4Ap2NcH12uXyXXF47rv8T1OeH6CXDndrl6SK6um7vO3YerX+LqBLj9
OC7vzeWXuDiOWy9xuhQFv8+E36/D71w95zZRv9DjwJW1aF+vLXC4Grg1Am79
gdsA4LwBcH4ROOfqPGPAoxzwSAIecesoG/B0PHi6BTytA143Ba87gNfcfp8w
b6IxdOOuaN7EAuiMAjrD6dIszM2RYG5Ob8zNEebsrMGcnXBhzg7m8ozDXJ6N
mMvD5ee5cz1c3SlXxzUec4gsMIfoLOYQCXOLZmNuURrmFnH7jNy8XS5vz81d
4uY0cTrGzR3g+ntzfXS5fpVcXziu/xLX54TrJ8DVaXPnTbjr3H24ukouLuP0
h9uP4/LeXH6Ji+O49RKnS37AyUXgpC1wMg24mg9cNQauuDw5d16G29c7Al7M
Ay9egxcTwaOe4NEV8IjrA8P1VeDWUVy/0FnQjYnQDVfoRk/ojAt0Jho6w+mS
MJdwHuYS3sdcwiaYY2iJOYbDMMeQW3cJ81KvYk6iD+YkCnMVUzBX0QRzFbm6
CGFu4wTMbfTD3EZun1E8F3Ii5kJy8SM3B5ybU8nlwTgd4+Y0cfNQuLkDXH9v
ro8u16+S6wvH9V/i+pxw/QS4c7vc+TjuHApX783VVXL1S1ydALcfx+W9ufwS
F8dx6yVOl7i+Ln7A4WPg8DRweBe47QbcbgFuhfhuCXCeAJxHghevwItZ4IWF
aF8vBDwyB++mgnd3wDuuDqEkeJ0GXjcBr99CB65BBwKgA+K5Xamieam9oTOj
RPNSxbr0CHOfB2Lu8w3RPPrlmBNdGnOihbnSozFXujTmSkdgDrUac6jNMIea
OwfE7TMKc7GjMBfbB3OxhTnatTBHuznmaAtzt19j7nZ5zN3m6iW4ud7cHHBO
x7i5ltz8OG5OEzcPhZs7wPX35vrocv0qub5wXP8lrs8Jdz6Xu86dj+PWOVy9
N1dXyekPVyfA7cdxeW8uv8TFcdx6idMlJXBoAhxeAg65vnncOb6y4MVb8KIK
eLEOPDIBj8zBo5ngXRx45w/eVRbNiVgJnkrB6zLg9WLwOgo68Bo60B460Ba6
MR66UU40j34ldKYsdIbTpUg76bQ2J9S04J7p9fIf0knRasGw1zWl5Pu2pbGu
vZoq62RtaLo0nSx2tns/frXmd7HiK08dUtMl68fPjr5JI8+rg0aVjJew+Xyu
7mv5iGVBLdxUtOWLiZf2IAXtHbTn/IyTfN7eyM22payOijyN1nW0aJZK1eMk
s/tHxbB19UKdaiLq2Uqjnu2rqF/EHZwr53SMmwPOzdvl5lpy8+O4OU3cPBRu
7gDX35vro8v1q+T6wnH9l7g+J1w/AU5PuPNxXPzF1XtzdZVc/RJbJ8Dsx3F5
by6/xMVx3HqJ0yWhH0IEcPsYuOX6qHN9iWuCR0fAo7rgkRDf9QfvSiC+WwGe
uoKnh8HTj+B1L/C6C3idAx2wgA60gg5kQzeuQjeOQTcuQmeqQGcsoTOcLg2o
UjKi4T01VR/v/PJ19wzqEixdEbJcs862L/rOaZeatHraH7V6lE6tBzxv+i45
ibo82lul0mQ1LTxom9PeKp0CKXu3V58kMrP/YF+5mZoG9JRoxDGNPl6afXWR
t4SGyKa73stRkWncAtOcHmk0YPQxalFMwtbbC3X1vqh3dUS9a+DIyW/vDVHR
xdUpdZZ6p1Jo4KRXU0vyeTAt7QlaCnkmxbUc333AzhRaMNIptvhIXsfE67Fw
/E5Fi+LKKKy3uTng3Lxdbq4lNz+Om9PEzUPh5g5w/b25Prpcv0quLxynD9x1
Ls/DxVmcznDnULh6b05/uPolrk6A24/j8t5cfomL47j1EqdLxYDzROB8KXDO
5Z1ugUdXwKMo8EioM78M3jmDd4/A0+fgaVXwdBh43Qi8Hgxet4AODIIOfIYO
EHTDHrpxB7qhB50pAZ0xh85wutTxxdPk1TI1pbfKzg35K4NsvN2WJcZIyfPl
Mb8Jl9U0vV35zUsNM+jamQPq2H5SapG7qqLrOjU9dzOzeX00neQ3yhY7dpWP
Hz06DtcJqK2mJPPeI8acTqOZg8vUqu8soRPz/bKaq1TkcKNzFedGadRp/ZKX
t+8mUpWV4aOy/FVUcYK2seyEghrZ5zQJc+Lrvj5Iz7zdY62inrGeR9Z4ptLh
5ObZJ7JjWR3j1mNCXJmN9XNFrJ/F+bHJyAMIef45yGcqkc/k5oBz83a5uZbc
/DhuThM3D4WbO8D19+b66HL9Krn4iLvO9Tnh+glw53a583HcORQuLuPqKrn6
Ja5OgNuP4/LeXH6Ji+O49RKnS7ngRV/w4gx4wdVBVQPv9MG7FuCdN3i6DDzt
AZ4eAq/l4PUc8JqL71pCN8KhGwrohhd0xgY6Ewid4XSpyL//ZdEFj2i9tfEZ
tLn0yCMjSEZ7Srv2sI1Q07NrUQqjeRmUYb355TBfKZ1/q32k60k1ldXRCm/8
JZ1m3Q+e0NtUSu8s58WfcVTTzTDtGQEb06nSloXn5LuTyO+Gg256XzWZrPSY
NESDL1XV7jvDiyaR/cjEjW2rq+ljkZp7dmjwGNK4qGXcv/Iiga4ukQoVPVkd
U66eURoN9brk7XEk8f84rx2L89qcjgnrsUv4HQnD74g4rjTEeljIj9VGXN8S
cb2Q5/+I/GQw8pMTsM/SHfssPthnicZ+8VvsF0djv5ibA87N2+XmWnLz47g5
Tdw8FG7uAJcH5vomcf3fuOvcfbj1DNdPgDu3y52P486hcPrD1VVy9UtcnQC3
H8flvbn8EhfHceslTpeWgEdFdb7xSAYemYF3IeDdGPBuEXj6CTwNA08DwOsG
4HU2eP0eOnALOmAAHfCBbuhCN2yhG27QmefQGRV0htMl4XpGX6WPLilpadlr
mzu+k9GuZ+3M7d6rKbjRpz6ngjJIblMp90JVGd1J8I5KeaLRpVCDMf1GZNDb
qscOPd4lJX1H02alvdRUOjzUzCstnRY4nvJ+VpbPg9WQ+Y8x66mm/WOC6qzR
TqcSXW85N8+WsHUUnI5x6zEurtwtyo99QX5MyPNHI994EflGYb9yEvZNbmDf
ZCn2f9dh/7cW9n+F+jEF6liOoY5FqMeriHq8GajH4+aAc/N2ubmW3Pw4bk4T
Nw+F4zW33uDyM9x17j5c/yWuzwmnM1z8xZ2P486hcPXeXF0lV7/E1Qlw+3Fc
3pvLL3FxHLde4nRJXFcQBd4Zgqfu4Gkp8JTLO1WGDpSBDthBB+5CN25BN3Kg
G7uhM4+hMynQGU6XhOs5o0YNiT+kpAsben26eVr+9/U514+92WyipL5BV2a5
aH6vtAY3HN07S01xWZHGgeczyENuJV+qJaPAEmW313igpta+ug2e9c6gtg5R
9uHOUvrUZI5c6q6m/vqrHLolplPMK4Xr669JtObN5LnhC9RkXFIRcsgunSaP
tdJe7sjrGLce4+JKIT8WgrhbD3G3kOffhvyhO/KHwrzsUtgHccQ+SBz2c5dj
P7cm9nMHYB2+H+twA6zDhTrYsaivc0F9XX/UCbuhTtgbdcICztOA8xPAOTcH
nJu3y8215ObHcXldbh4KN3eA65fLXefiJq4vHNd/ietzwvYTYM7tcufjOP3h
6r25ukouXuPqBLj9OC7vzeWXuDiOWy9xurQWPK0Nnk4HTz+D19bgdQJ4fQs6
YA4d6AAdKAbdSIBuHIZuCDozDzpjDZ35kS6FZppcGPNVSSmd6ykfj0/++7q0
y6rVnzcrSbE7ZPAyl+9/v2zSooFz9ZX0wODTG6vjMlq1WPvySaVmHfWkiLPv
8Qwy6fSgb7f3fD5f0LEBIh3j1mP+WH/Ww/ozC+tPIT8mRRxtgzh6KPKBDZAP
tEY+8INov9Ic+xpC3UUp7M/aYn9WqB9LRZ2JKepMhHVaP/zeFcHvnVDP3wh1
v61R9yucX+iK8wtqnF8QzmGF4xxWGM5hFcV50micJy2O86TcHHAuH8vNteTW
CdycJi4PzPXx5q5z9+H6VXJ94bj+S1yfE66fAHdulzsfx51D4eq9ubpKrn6J
qxPg9uO4vDeXX+LiOG69xOnSQPDaELzuCl47QQeqQgfqQwcE3VgJ3XgK3RCu
J0NnMkU6w+lSXHK2nta4TPoyYKNsim7K39eNPwx8MO+VkqplX959ocf3v88N
Sir3ZrWSrvYruf+k3ff71/NL2168vJIs2+/Z3sCd1zFhPdYGOtwOOszFlUJ+
LBBxsT7iYiG/twL5vTLI7wn7lQOxT5GLfYr32G/tiv1WM+y3RqJuJAt1I61Q
N/IG9W9+qH+7hPo3oZ7fEXW8TVDHK5xL8sd5hNE4jyDomxVwqwXcCufEA3A+
VB/nQ7n5kn3Rr6MC+nVMRb8Obg44l6fl4hRufhzXl5vTAe46dx+ujy7Xr5Lr
C8fpDNfnhOsnwJ3b5fSHO4fC1XtzdZVc/RJXJ8Dtx3F5by6/xMVx3HrpR7rU
ADrQDzogXP8M3bgm0o1a0Bkjkc5wulRjq6/FcL9M2hmse8PL//t1s02zp4wf
mkk1jth8NPvy/T77I+cn3FEqqduuSt3UHX+sY+L1GBdXCvmxQMS57xDncnl+
Yb8yDPsOydh3EOou7LB/egv7p0L92GXUgRxGHYhQBzsW9WxlhDpY1OXOQ11u
MupyhXNJ43G+YAvOFwjnpBrinNQtnJNqi/OeiTjvaY3znkJeNAF50erIi+qL
4oIViAuc0UfIHX2EAtFHiIsvuDngnB5y8Qs3L4Cbe8Jd5+7D9ffm9ITrV8nZ
geu/xPU54fLV3Lld7nwcdw6Fq/fm6iq5+iWuToDbj+Py3lx+6UdxHLde4nTp
IHSjp0g3WkFnaol0htMl0w7KVsoKmngoc3RSwITUv68HBO3vO/RSJnVuLC1j
7PtjHePWY1xcORdxqxXiVi7Pz+1XiusurmM/VFw/1gZ1HcK610AUb3LrNOG8
QC+cFxiB8wLCvsBa5CcjkJ8U4zAFOBTOoX/EOXQVzqEL/TTKoZ/GDPTTKIu+
QIvRF2gl+gJxv9f1kHe9hLyrE/Kuwu/+Nfzuj8fvPtc3m5u3y80x4dYb3HXu
PtzcAe49ufUM16+S7QvH9F/i+pxw/QS4c7vc+TjuHAq3LuLiNa5+iasT4Pbj
fpT35vJLXBzHrZc4XboOnbEQ6QynS9P//U+F/6/4+7oJ/r6E6O+rQve2iXQv
Fuu3XNH6LQRxqEwUh75DPu2cKJ+Whn2BxaJ9gXPY31yP/c0OqNNIQ53GTNRp
9Ed8XRXxdUfE10Ld7HzUzaagbvYh6v/7o/7/Gur/hXNMtjjHdA/nmGxwHjMB
5zF74jzmQJwrd8e58iCcKxf3x1iI/hjCuYAuWOc3xTpf6Ff2AP3KKqNfmdDn
5x34kgK+COcILJDfaIX8hrDv8AT5WF3kY7l+/nmdA57XuZZ5ndOU17kDee2j
m9e+cHntc5LXc7t5PYeS17pKgUf/aZ2AcD2vee+8xnF51aXmK5Iyv5RXkd8j
7S+fx33/+666HXX0OmmuBzR74eXz/boZ/j7gf/j33fD310R/3wJ/f+M//Hvu
uT/r7xOKTNWJ7qgir9XLstv+v64n4vrh/+H1dyETi40YpPk9XzvMdE1Uwbte
Ud6wm4eekrw2NwtQHJbl+frIXJfL80aqqXVVizW1W6dT4zLXfW81Tvpp1z30
/vVAFU0Oa2R6drKCXkQPPtg0PL7w+v/S9V/t35+Fw1+N24Lul4Ji599l/3+/
tjyTXLdUemi+PYWsNVejB0f/sdfzGz5/F25/NQ7zm9/zG65+Fx5+l/78LDs3
+tflhpl0q+en2XcD5RQ6sVQ5l9CXv+16ftOlQp35M3D1p+L2T9W9fxreCgpO
/lS/r/v3/0gnncgj8zvryKhLveAhzp3CC6/j+p+K84KC2/yGh1+Nn0Kc/O/g
5EPkhlVbc5JpQed//Zck2pM+52TInpg/9nohbv87POc33P6peC7oeluoq/8d
Dmcn+rwrNzuJzvVKctQ/l0ivz1f8Wv1V4m+7XqirhfgsiLj91Tj/p+E/r3jO
b7gt6Hj7Xbj6Xfr2u/x+4+mFWMNr0bRc/1//JY6Odxhz6uIx6R97/Xfh9nfp
W0HRsYKO25+Fq4Kie79LD/9UnSwov6cFRa8KCk48jMhu89NQam1TeefwFtHk
N3RGv0VX5AXmekHBeX7Tw5/1O5tX3OY3fP4s/PwsPPyueKGgrK9+Fx7y2/rq
nxY//tN0o6DEd78aJwVdH/LbOiG/rQd+tX9/l54X9N/338XHfxq/Cu1faP9/
sv0Lf18Kf18K13uF8V1hfPdnx3cFRc8Liv7nNz0pzCf/M/PJhftlhftf+WGd
U1gPUFgPkJ/rAQrKeqmwfil//m7+qb+n+e16Qfl9LCjr+cJ68vypS4XnbgrP
3RSeuyk8L5nf8F+Iw8Lz4/nhPHjh+fHf2wc4v+E2v+GtUCf/mTjMb9cLcVLY
Py0/462g4LCwD+TvvV7Q8VDQ8fOn4upX47AQn//M/t6/Cyf5DT8FRccKyvWC
4vfCeSUFCye/K4771XjLb79fBV3PCzqv/2nXCwpPC/GTP68XlHxIXq//03Cb
39Ynv2vdm99wm9/snNfrBX099rPs8LvyCT9L3woKzvNbPvBn+bGg+CW/2fNP
tU9+29f7XfuGBcWP+c2ef+o++z+tLqiwzjB/1mXlNe74p/HoV9chF+rYn3E+
gnvPvPolv9n/V9vtZ+VJfhbOC88z/nfX87oe/tV5j8Lz0d+uc++ZV979an4V
FN7lNzwXFLvlt34mv7p/yK/WpfzWv+hn9U/41euBgqL/P6s/D/eehf0Afy8v
fvV66VfbOb/1O81vfaLym/7nN/0pKPpfiP9C+xfav9D+P8v+ebVzYf/wQvwX
RPzn1c7cd+W3vrh/ar+1P1V/Crr+FxRe/C79/1k6n9/yk39qP8mflSfnnltQ
7Pa7fi+4v8+r/ue3Pqj5re/lr14v5bf934LCu/y2Hivsc/h/t2dBr/8pKPb/
WTjPaz1bfvPLn2p/7u8Lev1qQfFXXnmR3+xfyKP/7txBfjtPUVDsXFDOp+Q3
f+U3P+bVv/ntPOPvsg93jvJn1RXkt+t5tX9+8wt3/WflLQu6nX+X/fPKo4Jy
Pb/ZOb+dry8ofvld69KfxaP89r2/C7eF1/Mnbv8fOXx1cA==
       "]], {{{}}, {{
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {
         Arrowheads[{{0.0375972553623346, 1.}}], 
         ArrowBox[CompressedData["
1:eJwdxQswEwAYwPGpJKVEJVLXcEloDpcrIbG5PKrLxbhb7awTJ3F5nXDSnNZr
FQqRR1YpVIYYyoe8Xcc8a2ryymzzyGNm3OTrf/e/nwEj1NN/A4FAsFkf9dam
za6tzQDhf7NQtddPn8edgfIGoSnqTsqJ4sM0LGS/TkI5xj27BQ7TUMzOMkKJ
fEsOkTcF2nQeF6Xk2S71aUxBdeR11f51xyjv9ympUqitZJmgQR963VYzJDDd
eMEHdWpeabTuFIOuvU43+vThXBpZMQlxs6846OJyfwJDbxKE4fps9OqOd0y2
uQhOttx8hIraAl80WU9AuhgKUIFWWFPfsz+wVSWuC/W2OOHLnR+HPuH8FZRm
WEv1OTsOy4mHGahUTKhvzx+DqFmdDpShVi0tWxiFQFmMDNWXvbQC51EQBWjY
oTqVvBTp4xGQkzuyUC83pYbdj2HIYFfuQcFTU1dMHIZLt0KIqF34XVPrwN8w
SGVboTnUnruky0NgRjLJQCVy/w5zyS/YFaMqQGMJtI/H23+C3CXkC1rTtS16
c9EghPGSk1AFOdIv/rQABqPdQtBT91yJ54TfYdHwhjm6Y2LNOTFpABgr8efR
cYr+3Ndj/ZDuKFtFxfNN2UsDvTAuWyxAm2kVHuWsHshSdfJG4xKkymVyN9QE
C9QU66rTA8tbNflw2hw+o29lqmFSfieY0lNvo8wSU25J/jcgNb4BNE/iYCxM
7oAUFs8a3fjWiR+R2wbUd62/0OahCHqCVjNsMXAIQhUpB+YiFxrAney3girE
xPzgsjoQpboVokGOwz77aV9A2WsbgHr56xl+aq0CgydlJLSSLM7lFFeAne9a
IRpnbJVWy+TCiFF9DlpYesTy4vYiWL3DcEBtMr0PHbTJA+km56OottzSA8JS
oZxR5oXaP1DPYLqzgOgSzEF7/16LsBiOhWOeGkw08UyhpLQuFDopFiuoWour
/LkTA3Tv26hkrmtmuDvYeKcXiDLpUeg/KJf0Dw==
          "]]}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {
         Arrowheads[{{0.036452094157275454`, 1.}}], 
         ArrowBox[CompressedData["
1:eJwBEQPu/CFib1JlAgAAADAAAAACAAAAAAAAAAAA8D+Tb+AgTv/vv4SiOs4K
su8/+95uoFqx779KOGBtIcDuP3IVPoB2v+6/C2MDmCg/7j+k4cR3gD7uv+6A
laNtuO0/Q4M8cMi37b90c4D7Hw3tP6BtV4B+DO2/xCWx60RY7D9e2NBdp1fs
v/qhwK0/mes/ITypRaaY678v8kd7c8/qP40R4XTezuq/EYuzVIL66T9jSu/t
8fnpvySW1jyeGek/zwwguBIZ6b9pE7EzxyzoP9JYc9NALOi/4AJDOf0z5z9p
Luk/fDPnv4JI8XELluY/OBOG5o2V5r+SHN8M5fPlP9ThwgZr8+W/Dn8MCopN
5T9Cmp+gE03lv/hveWn6ouQ/fDwctIei5L/UXLeG4fTjP8C4EZly9OO/JrNX
vepD4z9E/1inf0Pjv+5yWg0WkOI/CBDy3q6P4r8snL92Y9nhPw3r3D8A2eG/
wp8ydQ8h4T9z1uU+sCDhv5LuXoRWaOA/WhjZUPtn4L88EYlIcV7fP4RhbevC
Xd+/ytvGqWvr3T9WP/1axerdvyA4loR0ytw/s3gCfNTJ3L8GILtWP6vbPyAc
mIqlqtu/UYB9wrNB2j+wcf/PIUHav3/lhimA3tg/4upq7fXd2L9bwW4gsoXX
P/eY6mAvhde/o5gCy+811j8wds5VdDXWv4vi/rsf2NQ/GK4436vX1L/6LEns
2IfTP5hes1xsh9O/+XfhWxtF0j+yhz7OtUTSv4HDxwrnD9E/ZCnaM4gP0b+Y
TSOEI9LPPwUQ76Ny0c+/InKpleKizT/Bzw/aPaLNv5/0IUoLkss//ZEWCnKR
y78S1YyhnZ/JP7xWAzQPn8m/RDvnnaERxj/qpoDyJhHGvygwZu+Q9MI/fn95
kif0wr/rc3CChbPAP792Aq0os8C/OK5fJ0pcvT/CaS30plu9v3uzSEbfyLk/
0HNs80/Iub+c95thyqy2P6QLwldMrLa/GDdjN9+CsT9jQ2fhfYKxv5rOLqWK
Das/jN+mRfQMq7/yD9wyRDagP6OtqBXqNaC/VKqiuQ==
          "]]}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {
         Arrowheads[{{0.036452082721713595`, 1.}}], 
         ArrowBox[CompressedData["
1:eJwBEQPu/CFib1JlAgAAADAAAAACAAAAq6g1Ek3/778AAAAAAADwP49QfkZb
se+/6fFqgAyy7z+bx0Ewd7/uvxOnhiEjwO4/XFy6LIE+7r9kuthMKj/uPyD0
ECrJt+2/TzjWWG+47T9dpUZ7fwztv65MNOwhDe0/nT0yoKhX7L8Y3d4dR1js
P9AhRdanmOu/PLTaJ0KZ6z/ktvBa4M7qv8ycLER2z+o/wsuXxPP56b8YcScH
hfrpPzhlYnoUGem/3IJ106AZ6T9Jg1B8QizovxjSFqnJLOg/8iViyn0z57/J
XguI/zPnP5ht/X+Plea/AUuAyg2W5j+GQpmubPPlv3jScW7n8+U/vaQ1VhVN
5b8w9d9zjE3lPz2U0naJouS/J7PK2vyi5D/XKdhndPTjv4xJWP7j9OM/X36u
gIFD47+M9a457UPjP9SRVcGwj+K/KLfOjBiQ4j82ZM0pAtnhv1+Ot/dl2eE/
Xj6DLrIg4b/gYcD1ESHhPyZp5EP9Z+C/WxhAAllo4D8byeHTxl3fv6BjbTp2
Xt8/KGFRQcnq3b99XEiNcOvdP3T2cGHYydy/6q6lXXnK3D8onSFsqarbv8gB
aCJEq9s/XONinyVB2r8+lxFwuEHaP+CCLab53di/mPe8tITe2D90mdT/MoXX
vyTxZoa2hdc/g3I813c11r/I6WUI9DXWP6fFkWKv19S/pUK+7yPY1D+V0+Xc
b4fTv6lCxRHdh9M/Upw4RrlE0r/a6XpuH0XSP9wfip6LD9G/NDjfBesP0T9h
bMNWedHPvzTeSUQr0s8/nm6NZESizb/en/0a6qLNP29GcmZ4kcu/Y7XZjxKS
yz/T83FcFZ/Jv8ce3qKkn8k/bz7lqSwRxr9maBoQqBHGP4u9CtIs9MK/+vds
z5b0wj9b8hgQLbPAv8xl5nKKs8A/f8mnN65bvb9Xe19jUly9P3Epd+pVyLm/
NP+RF+bIuT+LBKA4Uay2vytXZALQrLY/ZNFmEIGCsb9VfpX64oKxP1yqyVD4
DKu/ZNc/lY8Nqz+yZi2N6zWgvzRgjDNGNqA/UBKiqA==
          "]]}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {
         Arrowheads[{{0.037597254403025374`, 1.}}], 
         ArrowBox[CompressedData["
1:eJwdxX0s1AEYwPHLJJH3S0ns9McVEc5iqe4ZGVovrHlJlLqp0bw06ro50fJ2
ldAilyE7lpAwebk6eYtC5iXujnO4dF5zx7zMMfR7+m7ffSwYUVduq5FIJEdi
lA8Z4zs7SiD9bxFqtpxZH6uVUHA1iIvOFM3wvjcpoKSN3IpeMaNZ9dEVYJsg
8UT9OJpFxg0LoPK1bEFDAvaqOvctQFd8nHEX4YZtz7zS/y+YbHM0Fwm17A7U
znPnYeaqQT/KeVSWTumdA2eyuBSlCaSb9huzoMN0MKYRvqtKL/c2mYXBe6R2
VH6tMT/OegYy1aEOXfocNlDrMA0u9spZdF2P+ro9ewrSwrQrUI3qi12Fy3JI
KHsxgZoWSCM9Lsnh4MqDJNRJJE7k8/6Av/s3LuqxyQ7hrUzCxEIdC3UsVQ+v
ODcJfk5pCaiGLDp3JOM38I+4VaA1vA6l5bAM9lSN7bIivFPMlosoMjgjFK+h
Lnk6q5TQCfBOq9xtQficrDqjdWMcUorbg9Cp0cw2zXkpHPeWy1Aq47yQ3DUK
wdOsZfSiqc7U7zIJlMSaqE0SOlOY2YEuIxC5bVSF6qpT6NZjYojo9fVHxyT5
IYxkEXDMmXGoatWIVnxSCPclOZ7okQzBlkg0CNMiqaGYMD7t2kpW6i8IXaJq
ZhPqKhb2S9wGYONozDG0r4bJKNPrhzx2awwaosg6Vd3fCxKBMAClFz3Se8jr
AfNkjg1qk1Li/u5lN+x45TJQhxzDcfrbTog326dCOR3xqZcNOsBHKM1HPT5l
BXmutMKb9u4odN2/NMy9phlcmTmxqCkFhkYDG2ErUm0ZPcRXfH38gw9FhobD
qCz2VibrQx1EiK6XoK1fuGa8J9VwUz/AFj1/YSTYVqccmN3ubDTPp35O37EQ
TidRN9HVWIFJffQrSGiIsUENKrPbEi+kAs3DQYLePdEURpexoe+9Wgp6mO30
tKU5ChzNQ0tRL6dwFs+VAT/tlM9Q+pDPmp2+L6ScrdS2J/wHyqe3/A==
          "]]}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {
         Arrowheads[{{0.024869605041888593`, 1.}}], 
         ArrowBox[CompressedData["
1:eJwBIQLe/SFib1JlAgAAACEAAAACAAAAAAAAAAAA8D9SurEegvmWP5B9aWlm
me8/5h/citivlj9+luzT/qfuP/mvdhCHApY/v3/3Lfmv7T86/OVRdVCVP3yc
qphIsuw/oqym3VGalD/gTyY14K/rPyppNULL4JM/6plqA8Co6j/RMZJ/4SOT
P5t6dwPonOk/mQa9lZRjkj9GiXy8PY7oP8TQYBtBoZE/O12ptaZ+5z+WeSin
Q96QP4D2/e4ibuY/EAEUOZwakD8QVXposlzlP2DORqKVrI4/p4uPju+M5D/W
56bUQYKNP/ymMEpQvuM/W/uxt5BZjD8MIrParp7iP6Hf5lqNvIo/SwPZAqOE
4T/gdQ7EjieJP1rh2KovdOA/fu9QgFeghz9gaZYK/dfeP1uRSwv8JIY/qv0z
yIbZ3D/PScmZfraEP6hhbhtX8No/ZCXikkdXgz9glUUEbhzZPxsklvZWB4I/
yZi5gstd1z/wReXErMaAP/zv1Wl7tdU/JmNVjhIsfz8FH6aMiSTUP1wbg41Z
7Hw/5iUq6/Wq0j9/tFOHLs56P54EYoXASNE/ki7He5HReD9YwK8JB4zNP1Qs
oJKmNnU/ipDkRcsvyT9rexcQPhVyPxIFixlkxMU/xP9b/npBbz8oBONme7zC
P0Z9RU1X52o/z43sLREYwD9gb+sMERxnPw5ET91Krrs/E9ZNPajfYz/suWvj
juOwP+WZtjFDQFg/pLkFQg==
          "]]}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {
         Arrowheads[{{0.024869605041536288`, 1.}}], 
         ArrowBox[CompressedData["
1:eJwBIQLe/SFib1JlAgAAACEAAAACAAAAyLAO/3/5lj8AAAAAAADwP4h1LmzW
r5Y/fntDYWaZ7z8Zv6oBhQKWP7pAlcv+p+4/ODtuU3NQlT8OrnEl+a/tP9vb
5u9PmpQ/PSL7j0iy7D/6koJlyeCTPwf8Uyzgr+s/l2BBtN8jkz9wO3z6v6jq
P61EI9ySY5I/cuBz+uec6T/II7RzP6GRPwYvbLM9jug/cOJ/EULekD8ga5as
pn7nP6WAhrWaGpA/v5Ty5SJu5j/O/I+/kqyOP+OrgF+yXOU/RTWPDT+CjT9a
Np6F74zkP2vwGwyOWYw/0BNOQVC+4z8NftLViryKPz6UC9KunuI/F1zOZIwn
iT+N33f6ooThP/trqUVVoIc/mFvFoi904D+VYjD0+SSGP9vMG/v8194/pHaX
pHy2hD9KVMa4htncPwKkP75FV4M/PCEjDFfw2j+06ihBVQeCP7YzMvVtHNk/
tEpTLavGgD+yi/Nzy13XP3bfCJgPLH8/eoNtW3u11T/7CgTNVux8P1Z1pn6J
JNQ/+BeY+SvOej9EYZ7d9arSP2oGxR2P0Xg/RkdVeMBI0T/lOG+LpDZ1P13f
sPEGjM0/nFOIVDwVcj92uRAwyy/JP/w/1AR4QW8/akZDCmTExT98apPCVOdq
P7pXE117vMI/tCZO4g4cZz9n7YAoERjAP6Z0BGSm32M/4Q4Y2Uquuz9RON7v
QEBYP1yGoeCO47A/yhIDgQ==
          "]]}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {
         Arrowheads[{{0.02486963011745501, 1.}}], 
         ArrowBox[CompressedData["
1:eJwBIQLe/SFib1JlAgAAACEAAAACAAAAZbcOrkcGlz8AAAAAAADwv1vNqf12
vJY/GFpF92iZ77/8c2pQxQ6WP01hGpcBqO6/BoxmulBclT9J6M8l/K/tv0uI
MSrIpZQ/lxQ1w0uy7L+Z216O2uuTP7gLGY/jr+u/8oXu5ocukz+wzXuJw6jq
v1SH4DPQbZI/e1pdsuuc6b8oSbDMEKuRP+D+lI9Bjui/0zTZCKfnkD+eB/qm
qn7nv1ZKW+iSI5A/tnSM+CZu5r9iE23WqL2OPyhGTIS2XOW/8jqdQa+SjT96
ALK184zkvyd3aEBZaYw/zVKZeFS+47/OFQ9icMuKP+yPHhmznuK/PC0OspA1
iT9aHmtIp4ThvzRLu/J/rYc/33667zN04L8e6/mNUTGGP3FinIIF2N6/bhlr
fQjChD9LpzNoj9ncv9Zi3kgOYoM/VYEl0l/w2r9Wx1PwYhGCP4/wccB2HNm/
7EbLcwbQgD/29Bgz1F3XvztY6hNzPX8/WwqKAIS11b/cggPTefx8P4qsNP+R
JNS/ug3iJCHdej+G2xgv/qrSv9f4hQlp33g/TJc2kMhI0b8GWPdTfEJ1PwrS
qhYWjM2/pAgxe1Ufcj8Aq48r2S/Jv4tX19LoUm8//fqeqm3Exb+F84CUVPZq
PwP7mVuBvMK/N+VeO+4oZz8Sq4A+FBjAv6Ascce16mM/Uxampkyuu79vS05T
wE1YPxRhNjqQ47C/1LERIg==
          "]]}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {
         Arrowheads[{{0.024869630834848153`, 1.}}], 
         ArrowBox[CompressedData["
1:eJwBIQLe/SFib1JlAgAAACEAAAACAAAAAAAAAAAA8L8LwE2R4gaXP7ySYvtp
me+/YGqGqxC9lj9yTG+iAqjuvzTXBHNaD5Y/t3wDOP2v7b/t8nYx4VyVP6z4
qdtMsuy/f8/X2VOmlD9vle2s5K/rv9h+Il9h7JM/A1POq8So6r/9AFfBCS+T
P2cxTNjsnOm/6lV1AE1ukj9KIAO4Qo7ov2I7/HyIq5E/YA+P0Kt+578ob2qX
GeiQP6X+7yEobua/PfG/TwAkkD8d7iWst1zlvz6D+Ut5vo4/Tk/m3PSM5L+n
4AHbd5ONP01mTJ5VvuO/i2RvBxpqjD84jm44tJ7iv35vfj8mzIo/Ni7GX6iE
4b8fbLLZOzaJP0NsEv40dOC/SFzzvyCuhz/CzNGKB9jevwTq807oMYY/Fk4J
cJHZ3L/LzF6XlcKEP/dfotZh8Nq/sJ6iIJJigz9mAp2+eBzZv7Nfv+rdEYI/
YTX5J9Zd17/SD7X1eNCAP8sO2OmFtdW/EFmI+0c+fz+IpFrbkyTUv6BmWn4/
/Xw/lvaA/P+q0r9QSOBz2N16P/QES03KSNG/If4Z3BLgeD9NEvdKGYzNv/Th
PKYNQ3U/Qsc6F9wvyb/kDVd+0R9yP80t2LRvxMW/Rmgyer5Tbz8y642pgrzC
v3iemNUL92o/b/9b9RQYwL9gvuAOiylnPxHVhDBNrru/AMgKJjzrYz99CZWW
kOOwv65kaVZkTlg/Up0UmQ==
          "]]}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {
         Arrowheads[{{0.025356050267021278`, 1.}}], 
         ArrowBox[CompressedData["
1:eJwBIQLe/SFib1JlAgAAACEAAAACAAAAAAAAAAAA8L+TWiwb6qbZv/0SF3cu
me+/paAMGX5U2b9TkHFBbrHuv0y0mhq3mti/e4zKrrfB7b802DwbjtrXv24H
Ir8Kyuy/WwzzGgMU17+D03VOPsvrv+qwVFbCR9a/BsPDOCnG6r8CJvkJeHbV
v/zVC37Luum/qGvgNSSg1L9hDE4eJanov9mBCtrGxNO/dCysY/rs57+Rpfv5
7y3Tvyu4fOXgLue/0iRsfIyV0r9EfDoFPBbmv3AWydCTtNG/O/EdlSH85L+e
VDywb9LQv+Lkjagg5eO/uuT5Uo/lz79MvRI5tM/iv7HSm8THKM6/aK0eTkm+
4b8nz6xfbHLMvw3GZDGTseC/lIywlZzDyr9jA1CFR1vfvyqLRcneIsm/sRmk
bj9i3b8voOEuBo7Hv54LwcvykNu/o74HRgcZxr/Q9AugntHZv8QurDZwssS/
RtWE60Ik2L+T8M4AQVrDvwCtK67fiNa/DwRwpHkQwr+SMq5xogDVv9NT99kL
1sC/jhy6v7iM07/ylJmz0le/v/VqT5giLdK/AdDgRyQkvb/FHW773+HQv9RY
xHAMEbu/k6cOie8Kzb+EhEtWCEi3v3/DivxE6ci/vkgaOi74s7+0kZmqPezF
v+ScTQ/qkrG/TuWqGv4+w79SoPMvNNuuv02+vkyG4cC/FsU9qHwQq79gOaqB
rKe9vxOoeYetxae/KgAqPA==
          "]]}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {
         Arrowheads[{{0.02535606842694775, 1.}}], 
         ArrowBox[CompressedData["
1:eJwBIQLe/SFib1JlAgAAACEAAAACAAAAob9kse+m2b8AAAAAAADwv0txuQKB
VNm/lg6KNyuZ778gwjLluZrYvy3zlw1rse6//EEsx5Da17/EJueItMHtv+Hw
pagFFNe/WKl3qQfK7L/61KnGxEfWv9+Gp0s7y+u/dvRBXnp21b9Uy9RLJsbq
v1ZPbm8moNS/tXb/qci66b+W5S76yMTTvwKJJ2Yiqei/9B+A+vEt07+beg2t
9+znvxcm1l2OldK/vg54Md4u579Sd8SWlbTRv9aKHGw5Fua/WcDFXHHS0L8K
n7IZH/zkv+Z7ZX2S5c+/wunMTB7l479kYobEyijOv4iLOv+xz+K/VDx5PW9y
zL8/AYs6R77hv0p6CFWfw8q/Yw9YRZGx4L9sR49s4SLJvz42cPtDW9+/AUDv
uAiOx7/KWkczPGLdvwyj2Y4JGca/I5JapO+Q2785dx5DcrLEv8zOwY6b0dm/
iLy91UJaw7/GEH3yPyTYv/hyt0Z7EMK/EliMz9yI1r+whRJODdbAv+Gu4q6f
ANW/rL+rR9VXv79lH3MZtozTv9QCA5AmJL2/n6k9DyAt0r/Y1Cp1DhG7v45N
QpDd4dC/jgAs5wlIt7+Mdd8p6wrNv+Qd724v+LO/iH7iEEHpyL/KCXQ965Kx
v61vOV067MW/T97Dezbbrr8v7j9Y+z7Dv/qbceB+EKu/DPr1AYThwL+RTPGo
r8Wnv4Imt7Sop72/GrMs5w==
          "]]}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {
         Arrowheads[{{0.025356200212210286`, 1.}}], 
         ArrowBox[CompressedData["
1:eJwBIQLe/SFib1JlAgAAACEAAAACAAAAAAAAAAAA8D+poLGE/qbZv35eJ+IA
me8/u3nBtm1U2b/p5q4MQbHuPzxPlHGmmti/BAIZ/4rB7T9trflDfdrXv8iv
Zbneyew/SJTxLfIT17+UHhMfE8vrP2Tfn3KxR9a/vHyfE//F6j9SaihVZ3bV
v0PKCpeiuuk/EjWL1ROg1L8oB1Wp/ajoP6M/yPO2xNO/TE4ssNLs5z+DjJJp
3y3TvyvtYga5Luc/NnfMT3uV0r/I30dNFRbmP/7Rv92CtNG/r4tTN/z75D82
Kb4eX9LQv8LZc8785OM/OkaeOW/lz79kfFkPks/iP5MQi/6oKM6/FDuVbym+
4T+gczbqT3LMvxvAmLl1seA/S30Co4LDyr9i2VhfEVvfP1qge2HHIsm/iOsa
Ig5i3T+Mth1o8Y3Hv5gL1AHCkNs/6TYpv/EYxr/NOKWObtHZP8vRYSZassS/
KHOOyBMk2D8yh8edKlrDv6q6j6+xiNY/HVdaJWMQwr+Mv7W/dQDVP9uXVWv1
1cC/CDINdY2M0z9uP+k7ple/vxwSls/4LNI/Yt1uevgjvb/IX1DPt+HQP5QJ
PJLhELu/uM6P46UKzT+/skbT30e3v2jYxB8C6cg/AeGihAj4s78N/9evBezF
P4BaNSvLkrG/8SjZqc8+wz+j/qFIAtuuvxNWyA1g4cA/6Z7r31QQq7/pDEu3
bae9P9SVRxyOxae/5MoefQ==
          "]]}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {
         Arrowheads[{{0.025356199595745504`, 1.}}], 
         ArrowBox[CompressedData["
1:eJwBIQLe/SFib1JlAgAAACEAAAACAAAAdHryGv6m2b8AAAAAAADwPzTEhENt
VNm/kgeo1ACZ7z9kJgMBpprYv03qyP5Ase4/YB0/1nza17+cQOHwisHtPyyp
OMPxE9e/gArxqt7J7D8gGBYLsUfWvwr6fBATy+s/lrj98GZ21b9EwQkF/8Xq
P5GK73QToNS/N2CXiKK66T8OjuuWtsTTv97WJZv9qOg/yf+SDt8t0787pUih
0uznP9H0uvZ6ldK/4OfX9rgu5z/IghSIgrTRv86AdT0VFuY/8ieczF7S0L90
ml8n/PvkP+wgl5xu5c+/GHmFvvzk4z80W/RoqCjOv0xbl/+Rz+I/zH9gXU9y
zL/QpOFgKb7hP87O+R6Cw8q/+ukOrHWx4D/MVxHmxiLJv62PpkYRW98/QcA2
9fCNx79saeULDmLdP/zQe1HxGMa//fuk6sGQ2z8OH+S9WbLEvw9junZu0dk/
dqpvOipaw7+kniWwEyTYPzlzHsdiEMK/vK7mlrGI1j9Abx8S9dXAv/ut/6Z1
ANU/7ihDk6VXv78Ft3JcjYzTP8HFSdv3I72/3Mk/t/gs0j/3tFL84BC7v37m
Zre34dA/fuLQTt9Ht7/G3wq2pQrNP3UJIxAI+LO/4Qsh9QHpyD8m7JPGypKx
v0ZZrowF7MU/RPeHmwHbrr8SMjeNzz7DP9RvZktUEKu/R5a79l/hwD/+QcOc
jcWnv8YLd5Jtp70/H+QptQ==
          "]]}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {
         Arrowheads[{{0.02597515841807341, 1.}}], 
         ArrowBox[CompressedData["
1:eJwBIQLe/SFib1JlAgAAACEAAAACAAAAyHh7+PlO2z8AAAAAAADwvzzJSQjL
wNo/Ij5O3GNZ7786Zfb1EPTZP8CbY+99ae6/GRcvWuof2T+OeLX35HDtv/Pq
LYfkRNg/UYXGjj5w7L/e7CzPjGPXP8ZyGU4waOu/3BwsMuN71j/yQK41uljq
v+l6K7DnjdU/0e+ERdxB6b/iGAKar/DUP3Wu7bahiei/UnPs7X5R1D+todHi
F8/nv3YU9kfNYNM/KK2Cjgy15r+FAv075m3SP6N6DrJqmOW/PgQWuLZ80T8F
HzPgy33kv7csOsLvi9A/Az6xkqdj479gmtKsD3jPPwWxT/sHcOK/q2W/sN7c
zT+1ZqdsHX/hvzop0n+IS8w/gYOZ9/iT4L8Va9h0TsLKP4n2tdcpW9+/qbei
AEo7yT8ou3+B+JDdv/qX6N/MwMc/4t91gHXV278JDKoS11LGP7pkmNSgKNq/
1hPnmGjxxD+xSed9eorYv6AP3yj8ncM/hFxSQr781r+pX9F4DFrCP/Vqyecn
gdW/7wO+iJklwT8DdUxutxfUv3T8pFijAMA/sHrb1WzA0r84AsycwMm7Pzs0
dyfvR9C/DQkx4OwMuD/hpex3qS7MvzgDYIF/DbU/tgFexWSryL8ouElG3F+y
P44plE73h8W/2ifuLgMEsD9oHY8TYcTCv6Okmnbo86s/SN1OFKJgwL+kJWJX
T2SmPxON92oZPbq/5BEgXw==
          "]]}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {
         Arrowheads[{{0.025975242335923958`, 1.}}], 
         ArrowBox[CompressedData["
1:eJwBIQLe/SFib1JlAgAAACEAAAACAAAAAAAAAAAA8L+T/I/hA0/bP3YuvDtj
We+/AB69NNTA2j9LRF5afWnuv6bz+OEZ9Nk/yUPQbeRw7b+mfLIC8x/ZP548
Sw8+cOy/ujgY6exE2D9zPgjYL2jrv5unWOeUY9c/TEkHyLlY6r9OyXP96nvW
PyZdSN/bQem/0J1pK++N1T99v4VeoYnov/Vz/+e28NQ/GL/slxfP5780R6wN
hlHUP6bxqVUMtea/fDLDH9Rg0z/2VhCKapjlv1N3BcrsbdI/ytFSx8t95L/e
xH37vHzRP+NrYIenY+O/EjbTufWL0D8qIsJ/BnDiv9DnnJAYeM8/0Hu/iRp/
4b+YFfmZ5NzNP4Sg6cP0k+C/NkeVmItLzD8ZBsvyHlvfv2xh095Owso/gPcq
KeuQ3b827UfFRzvJPzq9/uxl1du/wETLM8jAxz9JV0Y+jyjavwtoXSrQUsY/
rMUBHWeK2L8WV/6oX/HEP8nZq1Gp/Na/tnSiaPGdwz8IZb+kEYHVv8QjPiIA
WsI/aGc8FqAX1L87ZNHViyXBP+fgIqZUwNK/HTZcg5QAwD9yoffl1UfQvzYl
Lpefybs/nx0SUnYuzL9re1r0yQy4P54+v5E6q8i/V56BIWMNtT8Q8cTr1IfF
v74hFJnFX7I/9jQjYEXEwr+gBRJb8QOwP1MK2u6LYMC/ApT2zszzqz8nkz6d
9Ty6v9+zsuk4ZKY/1OQetg==
          "]]}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {
         Arrowheads[{{0.025973752172930395`, 1.}}], 
         ArrowBox[CompressedData["
1:eJwBIQLe/SFib1JlAgAAACEAAAACAAAAAAAAAAAA8D8XtTvx303bPzRE2FeL
We8/CsbBbdi/2j8m2Hzao2nuP0ZGEUgl89k/ZBdjSglx7T+NlcneBR/ZPzsn
zkRhcOw/WMWkgQdE2D/4LAFnUWjrPxXnXIC3Ytc/nij8sNlY6j/L+vHaFXvW
PykavyL6Qek/dwBkkSKN1T9lFs0+vonoP6MXpa/v79Q/NCXtFTPP5z9RwNVM
xFDUP7PbGkQlteY/wNusPBpg0z/sz5zxgJjlP/8aseM6bdI/dHzGw9995D8y
JEgXE3zRP3K4Ji65Y+M/pWql5VOL0D8aEYDtKXDiPyy51ZsEd88/1Qq3Tk9/
4T9U8q9o/9vNP2NAq8E5lOA/QISg2NJKzD8Ip3mXx1vfPxzDD7TAwco/2Pvl
9bGR3T+5V+qp4zrJP+toHxdI1ts/yUQaQIvAxz9C7iX7iSnaP0yKn3a3UsY/
2Iv5oXeL2D9AKHpNaPHEP0T+RrTM/dY/Zo2qUhiewz8SArvaRILVP3goMRRC
WsI/RJdVFeAY1D95+Q2S5SXBP9q9FmSewdI/aABBzAIBwD8N7kdZK0nQP0ob
nji9yrs/C4MTqyUxzD+JWwFWEw64P0JNeLJyrcg/n5FS1WYOtT8fJizbpInF
P/xKLgeNYLI/oQ0vJbzFwj+dh5TrhQSwP8sDgZC4YcA/DI8KBaP0qz/YAOsp
2z66P0jNnNbnZKY/H0cCZA==
          "]]}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {
         Arrowheads[{{0.025973744087387212`, 1.}}], 
         ArrowBox[CompressedData["
1:eJwBIQLe/SFib1JlAgAAACEAAAACAAAAQGSmL99N2z8AAAAAAADwP9bkarLX
v9o/LHSNWotZ7z86NcCRJPPZP/gWcNyjae4/cpLBLQUf2T+bhaVLCXHtP0Ka
K9YGRNg/Fnh4RWFw7D9q6rratmLXP16mM2dRaOs/74JvOxV71j94ENew2Vjq
P81jSfghjdU/YLZiIvpB6T/M2eoZ7+/UPzSHSz2+ieg/HluSusNQ1D/0YVAT
M8/nP5aSFbAZYNM/pjZUQCW15j+ocvNcOm3SP99Iz+yAmOU/ArJ9lhJ80T9k
Ux6+333kPxJp7mpTi9A/7xfNJ7lj4z/cAE/0A3fPP5I3Dg4qcOI/wGNXDf/b
zT+Mpz2VT3/hPzitJMXSSsw/nnPLKzqU4D/NofzkwMHKPxGFJK/IW98/OgtI
HuQ6yT+vJutPs5HdP3QJhfKLwMc/ktWVrUnW2z97nLNhuFLGP7mRJMiLKdo/
TsTTa2nxxD8jW5efeYvYP6vIoJ4ZnsM/SCxW3M791j9O8dWHQ1rCP5r/yCZH
gtU/OD5zJ+clwT8e1e9+4hjUP2iveH0EAcA/z6zK5KDB0j8qM4TrwMq7P+SJ
nvctSdA/m5VwMxcOuD/9e436KjHMP/egpfxpDrU/2oyZE3etyD90/tmPj2Cy
P6UUGmyoicU/FK4N7YcEsD9eEw8Ev8XCP6RfgSim9Ks/A4l427phwD8e96th
6mSmP1RcBt/ePro/bVMKAQ==
          "]]}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {
         Arrowheads[{{0.02666019799211857, 1.}}], 
         ArrowBox[CompressedData["
1:eJwBUQKu/SFib1JlAgAAACQAAAACAAAAAAAAAAAA8L9DEwaqVxzlv0VvpI2y
7O+/J85UvpsP5b+GuY1WkjPvv/N+1qJ6leS/bFaRsOly7r9IeY1SYRbkv/JF
r5u4qu2/Ir15zU+S478ZiOcX/9rsv4JKmxNGCeO/4hw6Jb0D7L9qIfIkRHvi
v5f0sRoHc+u/o8BPgswb4r/m0Pz+3d7qv9+oRU4OuuG/yPFWGXwN6r8iNU2c
7C/hv8b10nMyNum/Jqp1meWh4L+4jFmfJ1rov/99vZm7EOC/rSada/l457+m
EvWsW/jev/39Ja3fmOa/cvoR6qzQ3b8GU/Z5y7Xlv3XzXicQpdy/ySUO0rzP
5L+1/dtkhXXbv0V2bbWz5uO/LhmJogxC2r+EEvBfrvziv3AYyxZHDdm/kshx
DasT4r8Lzgb41dnXv2yY8r2pK+G//Dk8Rrmn1r8SgnJxqkTgv0VcawHxdtW/
8vqJWajB3r8JPv0vVErUvygFe+mbBN2/a+ha2Lkk07/EIriSL1Lbv2tbhPoh
BtK/x1NBVWOq2b8Il3mWjO7Qv8twQLjnBdi/19u6Fk6yz78vDNEvuG3Wv/Xa
BaS8l82/wlkpkufj1L/6o046IZDLv1GNf7WIatO/cq8PPzieyb+s2glwrgPS
v+51wxe+xMe/oXX+l2ux0L/4b+QpbwbGv/0jJwem686/IRbt2gdmxL8kx/4R
76XMv/XgV5BE5sK/HCXAnYnZyb/M2LZ4pw3Bv5eNd0KqTce/pg4hDze/vr+u
xHdODP7Ev7Gp/MCfsru/ARlOmA==
          "]]}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {
         Arrowheads[{{0.026660297779174728`, 1.}}], 
         ArrowBox[CompressedData["
1:eJwBUQKu/SFib1JlAgAAACQAAAACAAAAzW92dFkc5b8AAAAAAADwvz0jJw2a
D+W/JHjAR63s778Gi5QqeZXkv7z5pXaNM++/iNiYGWAW5L9NpPVA5XLuv8IL
NNpOkuO/1nevprSq7b+0JGZsRQnjv1h006f72uy/XyMv0EN74r/SmWFEugPs
v+NjESDMG+K/mFWwMQRz678z2YfeDbrhv7nPFg7b3uq/Zy9GEuwv4b9en1sS
eQ3qv7aQBvXkoeC/rcUTVy826b+ov53buhDgvxrMU24kWui/I0w0/ln43r9/
L2on9njnv9lWyQmr0N2/OmdrVtyY5r9CTGEYDqXcv5ekGBPIteW/YCz8KYN1
27+Y53Fduc/kvzH3mT4KQtq/OzB3NbDm47+8yMyNRA3Zv2ddvdeq/OK/Cr0m
T9PZ17/+TdmApxPivxnUp4K2p9a/BALLMKYr4b/qDVAo7nbVv3Z5kuemROC/
Xl/LRlFK1L9kTQ5UocHev1q9xeS2JNO/LPgA+pQE3b/eJz8CHwbSv0Dz/MAo
Utu/5543n4nu0L+kPgKpXKrZv592Zt5Fss+/Lzmuc98F2L+6hwpKspfNv3Ya
UXCubda/HoM57hSQy786t4163OPUv8Z60Tcqnsm/PuQGbnxq07+zgLCTrsTH
v0J2XyahA9K/4qa0bl4Gxr8HQjp/XbHQv1D/uzX2ZcS/ojh0qIjrzr/9m6RV
MubCv76zAwLRpcy/96vOjJYNwb8pdgbGbdnJv3vbQtsXv76/AOpXopBNx785
LjIag7K7v5uMgM/0/cS/YENCGA==
          "]]}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {
         Arrowheads[{{0.026661641981432498`, 1.}}], 
         ArrowBox[CompressedData["
1:eJwBUQKu/SFib1JlAgAAACQAAAACAAAAAAAAAAAA8D8ZCzeAHxzlvxpCbrVx
7O8/6fOF7zgP5b/V/PubWDPvPwe/psodleS/mVTa2rdy7j+4IaABCxbkv2dJ
CXKPqu0//RtylACS479A24hh39rsP9atHIP+COO/JApZqacD7D9D15/NBHvi
v/qHzzPwcus/5TCBOY0b4r+Y2tKtxd7qP0RHgxrPueG/NIViy2AN6j/ctYLf
rC/hv8ch4yUUNuk/5WflW6Wh4L8XmmNoBlroPzbm5PJ6EOC/kPXeWdV45z8Q
sYax2ffevzZF7M+4mOY/Uo5LUSrQ3b9YYBj+obXlP8lE3jaNpNy//kZj5JDP
5D9+1D5iAnXbvyH5zIKF5uM/bD1t04lB2r+g6LknfvziP/01Q9LEDNm/VIeO
IXkT4j+WdJqmVNnXvz/VSnB2K+E/PflyUDmn1r9g0u4TdkTgP+vDzM9ydtW/
s9mnKj7B3j+HktEo2EnUv5clp/owBN0/7iKrX0Ak079xiNuXxFHbPyJ1WXSr
BdK/PgJFAvmp2T8iidxmGe7Qv3GbY7RZBdg/iKiZZD6xz7/tBJL1CG3WP9Uv
9LiGls2/9HrDEBrj1D+gEwHDyI7Lv9Q561CgadM/a7/4esGcyb/XffwArwLS
P7CeE9ktw8e/Q4Pqa1mw0D/rHIrVygTGv8IMUbll6c4/l6WUaFVkxL/4hlM8
naPMPzGka4qK5MK/BcP+pGLXyT96HMmiDgzBvx/gp3KuS8c//pEURUe8vr9m
E3YjOvzEP4CvIwXvr7u/lkM64g==
          "]]}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {
         Arrowheads[{{0.026661644501766023`, 1.}}], 
         ArrowBox[CompressedData["
1:eJwBUQKu/SFib1JlAgAAACQAAAACAAAAUEMfIB8c5b8AAAAAAADwPz1uF4M4
D+W/PPdgonHs7z8CMUJjHZXkv6OOR41YM+8/fGKznwoW5L+M/QLRt3LuP6wC
azgAkuO/+EOTbY+q7T+TEWkt/gjjv+Vh+GLf2uw/L4+tfgR74r9WVzKxpwPs
Pz+8SuuMG+K/WswyOvBy6z8TaxHNzrnhv5itvbLF3uo/lCumkqwv4b+AhnbN
YA3qP5eHqg+loeC/CSYYJRQ26T/6h2GnehDgvwAaxWQGWug/jlMUHNn33r/M
3XFT1XjnPxXfdr0p0N2/5I68xriY5j9IPd+kjKTcv2rqQvKhteU/KG5N0gF1
279c8ATWkM/kP7RxwUWJQdq/vaACcoXm4z/MKB1HxAzZv8iwrxR+/OI/TXRC
HlTZ17+41X8MeRPiPzZUMcs4p9a/jQ9zWXYr4T+MyOlNcnbVv0peift1ROA/
nlaPqtdJ1L+qikL3PcHeP8KDReU/JNO/LJAyxTAE3T/3Twz+qgXSvxvN4mDE
Uds/QLvj9Bju0L94QVPK+KnZP9jDFmc9sc+/LzuWYVkF2D/K2/qjhZbNvx91
uYkIbdY/Qy8QmceOy79qbQWOGePUPyYv8z7AnMm/LqLCuZ9p0z9jTECOLMPH
v5CROViuAtI/5veTf8kExr+zubK0WLDQP5aiigtUZMS/cDHtNGTpzj9evcAq
ieTCv35Zm6mbo8w/8NNIXg0Mwb/5pbguYdfJP3IMdPFEvL6/vbQ/Ga1Lxz9s
Ikzk7K+7v76JB+Y4/MQ/VFkwLw==
          "]]}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {
         Arrowheads[{{0.026424288547255932`, 1.}}], 
         ArrowBox[CompressedData["
1:eJwBMQLO/SFib1JlAgAAACIAAAACAAAA2PrB3Iie5T8AAAAAAADwP6QuzxUZ
QeU/dZ1/47J17z9VLtR6RsjkP2r3LKDcwu4/iNei571K5D/QfoVVDQnuPz8q
O1x/yOM/pzOJA0VI7T95Jp3YikHjP+8VOKqDgOw/NszIXOC14j+oJZJJybHr
P3UMYDpoVOI/74EbH4Qh6z/SHW63ofDhP+n1TBrVjeo/SmlzYk1j4T/Rn8Nm
pLzpP/m/BxMG0uA/QKk2Spvl6D+p3+wanD3gP4q0QB3uCeg/2rwZE5RL3z9C
Nq4XNinnPxqze3BuHd4/tmXeJplJ5j/0WJebdevcPxBn94YnZ+U/Z65slKm1
2z9SOvk34YHkP3Oz+1oKfNo/et/jOcaZ4z88xpATUUHZP5orln3asOI/5kR4
4jYI2D/E8+7zIcnhP3Evsse70NY/9zfunJzi4D/dhT7D35rVP2bwJ/GU+t8/
TyLM3IVp1D9r6NLvnDbeP+7eCRyRP9M/dtfvF5d93D+3u/eAAR3SP4i9fmmD
z9o/rLiVC9cB0T+hmn/kYSzZP+fDQhCVrM8/wPyJfwBx1z/Cu5E5dWjNP+Lz
LdCpw9U/SY80jZI6yz9+vBWHyCbUP+p0RwUxJsk/EpPrVMec0j8Io+ablC7H
Pxa0WeoQKNE/DlAuSwFXxT8OuBTwH5bPP2CyOg27osM/vo5PXV4QzT9oACjc
BRXCPzFluH2yw8o/4SJm9Tyxvj9Mvrax/LbGP5jcGAE=
          "]]}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {
         Arrowheads[{{0.026424284493393884`, 1.}}], 
         ArrowBox[CompressedData["
1:eJwBMQLO/SFib1JlAgAAACIAAAACAAAAAAAAAAAA8D8aGLIxiZ7lPxQlcumy
de8/t9NUbRlB5T8lp22j3MLuP7gTrc5GyOQ/7dbAVQ0J7j+3EYQ3vkrkP2i0
awBFSO0/s83Zp3/I4z+VP26jg4DsP6pHrh+LQeM/dnjIPsmx6z+efwGf4LXi
P2dxhhWEIes/gk/qe2hU4j8twe4R1Y3qP5plQvih8OE/iAC8YKS86T8q17Ci
TWPhP2zijEab5eg/9LejUgbS4D+HZewb7gnoP1Rn1VmcPeA/9TSsGDYp5z9Y
4GSPlEvfPz4mJSqZSeY/VeM5624d3j+Qp3CMJ2flP917mxR269w/7LiOP+GB
5D/vqYkLqrXbP1Faf0PGmeM/jG0E0Ap82j8JRBWJ2rDiP/15UoZRQdk/YC4j
ASLJ4T+OgrpSNwjYP1UZqauc4uA/PYc8NbzQ1j/PCU4RlfrfPwyI2C3gmtU/
Bz1EEp023j89NkNEhmnUPygnPzyXfdw/FUMxgJE/0z8yyD6Pg8/aP5OuouEB
HdI/IiBDC2Is2T+1eJdo1wHRP1wMy8MAcdc/noDt6JWszz9DmOkvqsPVP5pv
di52aM0/IPHf/8gm1D881GSbkzrLPzhE7+PHnNI/YMRTKTImyT/UvliMESjR
P+RV3tGVLsc/eBy7UiGWzz+onp+OAlfFP2u/fdZfEM0/hLQyWbyiwz8UwXsE
tMPKP1qtMisHFcI/kl1WQv62xj9gyE6LP7G+PwRZCgE=
          "]]}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {
         Arrowheads[{{0.026424775142668437`, 1.}}], 
         ArrowBox[CompressedData["
1:eJwBMQLO/SFib1JlAgAAACIAAAACAAAA7mSg2CCf5T8AAAAAAADwv66YdGqI
QeU/XgvyhHp177+cPMXcssjkP9ogwM2kwu6/rwacLidL5D+gr6UE1gjuv+r2
+F/lyOM/sLeiKQ5I7b9LDdxw7UHjPwo5tzxNgOy/0klFYT+24j+vM+M9k7Hr
v0qJ5YXFVOI/toDofE8h67+ZMJo+/fDhP4Iau+ihjeq/VFQooqZj4T8IFx6U
c7zpv+MBx/lc0uA/yumv5Wzl6L/YnqyX8D3gP3hpQC7CCei/V704FjhM3z8t
+TSoDCnnv+SYAIANHt4/pgw0MXJJ5r/1ca2aD+zcP6w3rAkDZ+W/jkg/Zj62
2z8/ep0xv4Hkv6wctuKZfNo/YNQHqaaZ479hHLY720HZPxp8Dli9sOK/t3Xj
nLsI2D91p9QmB8nhv7EoPgY70dY/clZaFYTi4L9ONcZ3WZvVPyISP0do+t+/
tQUeBfpp1D+m9QF5dDbevw4E6MH/P9M/cM62lXJ93L9XMCSuah3SP4GcXZ1i
z9q/kIrSyToC0T/XX/aPRCzZv2sTN3Rerc8/hx5gwPBw17+UN6LuP2nNP9lT
adSmw9W/ghNq2107yz8y0eJS0SbUvxo5EhP8Jsk/8medwtqc0r9EOh5uXi/H
P3vpaaotKNG/66gRxchXxT9cTjIiaZbPv/AWcPB+o8M/2+T3+rMQzb88Fr3I
xBXCPzU5xuwQxMq/DNImfaKyvj/syUOZZbfGv+p3IRU=
          "]]}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {
         Arrowheads[{{0.026424750675731044`, 1.}}], 
         ArrowBox[CompressedData["
1:eJwBMQLO/SFib1JlAgAAACIAAAACAAAAAAAAAAAA8L+U7kQyJJ/lP4J6mUh6
de+/7FfSjItB5T8II9d/pMLuv8DXi+C1yOQ/xojaotUI7r9Qb38RKkvkP8Cr
o7ENSO2/nR6tH+jI4z/zizKsTIDsv6XlFAvwQeM/YSmHkpKx679qxLbTQbbi
P9bgYdxOIeu/FHaO8MdU4j9VMiZToY3qv10zMqH/8OE/qArjEnO86b99MJr8
qGPhP48AHHls5ei/YUaqS1/S4D8iSyfWwQnov0r0ZuDyPeA/BdiSZAwp57+b
H0iUPEzfPx3wvAFySea/Xk1/6hEe3j/tYMTtAmflv8pDMfAT7Nw/dyqpKL+B
5L/iAl6lQrbbP7hMa7KmmeO/oooFCp582j9H8spyvbDiv+w2sknfQdk/tkWI
UQfJ4b+YY+6PvwjYPwhHo06E4uC/qhC63D7R1j917DfUaPrfvx8+FTBdm9U/
DeNPHXU23r/i/t+d/WnUP0qu+U1zfdy/22X6OQNA0z8qTjVmY8/avwpzZARu
HdI/rcICZkUs2b9tJh79PQLRP/k4rHnycNe/TK8SsWWtzz+O/KVhqcPVvxaO
AvBHac0//jCjodQm1L+yC9uLZjvLP+T5Vr3enNK/oEprWQUnyT/SenQ4MijR
v1xtgi1oL8c/xK5dLXOWz79mlu/c0lfFP09mcre+EM2/OeiBPImjwz9zY40W
HMTKv1iFCCHPFcI/hUW9GXG3xr/azdXJtrK+P2A3Ibg=
          "]]}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {
         Arrowheads[{{0.021104357829842015`, 1.}}], 
         ArrowBox[CompressedData["
1:eJwBwQE+/iFib1JlAgAAABsAAAACAAAAAAAAAAAA8L+bEVSUEzvHv5zQ6GAL
Te+/0VR3YSm5xr9ZnNLYrw/uv28Ut7TF0sW/I/BjTKvG7L/O0xQG6+PEvx1S
TY80Buy/dFF9XTJYxL9AljAOhULrv/1aX/UiysO/4rlFaMvz6b8Q3waTI9fC
v/PfhjkOn+i/psQjjMbfwb9weJ8Em0rnv/BsZTmf6MC/BF5W81f05b8Wb81P
TuC/v0XLhwTWMuW/MqyXDFnHvr+If80BF3Tkvwis5i5msr2/AB3ow3K2479c
kzfgDZ+8v91FmCNB+OK/8oYHSuiKu7/y5Mebl+Thv2NRUsSq+rm/Gmc34MrW
4L+OqZZJ8HK4v/ruICLZpN+/IBNtXef4tr9wDzVHmKzdv+EM+NPVirW/aQGk
tI25279fGMrtjCC0vz8Wl+Qj3Nm/YnQNgffFsr/3TQ7XWhTYv+wgwo0Ve7G/
jqgJjDJi1r/4HegT5z+wvwg9NkB4xtS/I40CJAIqrr9qIkEw+UHTv4LrHg3x
9au/tFgqXLXU0b8KVyXjmuOpv+bf8cOsftC/vM8Vpv/yp78KlO/FlCbMv4De
9Umzb6S/bkr0ZQ==
          "]]}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {
         Arrowheads[{{0.021104367205979687`, 1.}}], 
         ArrowBox[CompressedData["
1:eJwBwQE+/iFib1JlAgAAABsAAAACAAAAM6l2viI7x78AAAAAAADwv9Sb1c81
uca/srjREQhN77+cszit0dLFv/FAi7asD+6/oKF4h/bjxL+jd85cqMbsv0AA
doA9WMS/boNLmzEG7L/4cg+5LcrDv1nDqxaCQuu/7GHO0i3Xwr+uqo2VyPPp
vynhjUjQ38G/lERIkAuf6L9onyt1qOjAv6zKaoiYSue/1sQQyl/gv79t1Bqo
VfTlv2EHP4lqx76/CtlCOdQy5b+yCFitd7K9v2abR7QVdOS/VVY1YB+fvL9D
Qz7zcbbjv859sMv5iru/Xvg70ED44r9Mrmsyu/q5vyyzkz6X5OG/IYZuqv9y
uL9tUq95ytbgvzjtb7v1+La/3p50RNik37+Y6zI444q1vy6uoVqXrN2/myLj
cJkgtL8anrbXjLnbv7ym6ywDxrK/Zk7VFiPc2b/+d0xsIHuxvxm//RdaFNi/
YJYFL/E/sL8u8C/bMWLWv9IfxucUKq6/hTT5nHfG1L845WFzAvarv/be5pn4
QdO/+HzeAKvjqb+F7/jRtNTRvxDnO5AO86e/MWYvRax+0L/DPBgHwG+kvzwY
yPGTJsy/Acv7xQ==
          "]]}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {
         Arrowheads[{{0.021104519342325274`, 1.}}], 
         ArrowBox[CompressedData["
1:eJwBwQE+/iFib1JlAgAAABsAAAACAAAAAAAAAAAA8D96qSHrCTzHv0EGXU7K
TO8/mos7F+u5xr+SxIo0cg/uPxVuH12A08W/MqQWjXHG7D8VV5CdnuTEvziL
aGH6Bew/y5QR299YxL9ZERCESkLrP7Kfk03KysO/ct3uhJPz6T9mfFbHwtfC
v2VsGlvZnug/fWObsl3gwb/8utZ1aUrnP7jof4ou6cC/8nRiBSr05T+qtUmh
XeG/v7LVlm6yMuU/2BwhwGvIvr8aFkqW/XPkP5Jezyx8s72/xnyWcGO24z+E
xAYfJ6C8v09QlvE7+OI/Wph5zgSMu78csfd6keThP0zC1Vm1+7m/2JCY3MPW
4D90gtpb6XO4v8w2gYPJpN8/CpA3n8/5tr/3LgU4h6zdP1IDXeCti7W/HuFG
rH252z8wrFi3ViG0v6Klg90U3Nk/VEE/qrPGsr+BfLvLTBTYP8DCELnEe7G/
umXudiVi1j9yMM3jiUCwvz9nERlsxtQ/wtxRWjArrr/8hhns7UHTPwLBsC8J
96u/8cQG8KrU0T+kDbdHnuSpvx8h2SSjftA/psJkou/zp78U0cR1hCbMP/wB
sCaAcKS/WuTr+Q==
          "]]}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {
         Arrowheads[{{0.021104519367808793`, 1.}}], 
         ArrowBox[CompressedData["
1:eJwBwQE+/iFib1JlAgAAABsAAAACAAAAIPK9tAk8x78AAAAAAADwP6Jaqcbq
uca/+nSqKMpM7z8f9hEQgNPFv67cyRByD+4/Kq1VVJ7kxL9KpZdrccbsPwZf
rpLfWMS/Nr5PP/oF7D9BQxYGysrDvyy/aWFKQus/3LCzgsLXwr9TMSdjk/Pp
P4cMC3Fd4MG/s0xwOtme6D+xvS1MLunAv/4Kh1ZpSuc/w0OBK13hv7+kw6rn
KfTlP+58dVhryL6/iSfSWLIy5T8G0QXTe7O9v8JsVoj9c+Q/f8kH0yagvL9Q
P2ZqY7bjP8bvUJAEjLu/M0sw8zv44j9nt5Idtfu5vxbHWnuR5OE/PIF9Ielz
uL+XxdLbw9bgP5qZxGbP+ba/5onVf8mk3z8O59aprYu1v9bgYzKHrN0/mGoV
hFYhtL+TMZOmfbnbP/RoInqzxrK/HQnJ1xTc2T8l4v2LxHuxv3dnBcZMFNg/
KtanuYlAsL+jTEhxJWLWPxzHogswK66/nx2EE2zG1D+5UVfmCPerv24/q+bt
QdM/LExtA57kqb8Ssr3qqtTRP3S25GLv86e/inW7H6N+0D+gcPXvf3Ckv25K
SmyEJsw/qP3q+Q==
          "]]}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {
         Arrowheads[{{0.02156067589431821, 1.}}], 
         ArrowBox[CompressedData["
1:eJwBoQFe/iFib1JlAgAAABkAAAACAAAADtXv6ia4yz8AAAAAAADwvzeWF05V
n8o/YoZpldC77r8xh1FfgnfJP1jtVaNOZu2/0ggMVOzUyD+dAAj3nKrsv/lD
7OlWL8g/OZvianXr67+obKlXkAzHP6//ImnHm+q/2fs+gGnjxT9Y95EQvUTp
vzBGvdgyucQ/IrUl7njs57/QhMnkJozDPxQojH3vkOa/KF+HPseIwj+xfA7Y
gWXlv0SbgcXMh8E/Tp/wENg85L8qObh5N4nAP+6PMijyFuO/qnFWtg4avz+P
TtQd0PPhv2TPTTTTK70/0KIr8ojW4L9XJu/NFk27P6KoHEtnhN+/hHY6g9l9
uT8jxvhvoG3dv+i/L1Qbvrc/JJ7rUr1o279iuPtnxhC2PwrRUFUbedm/zhXL
5cR4tD85/4PYF6LXvynYnc0W9rI/sSiF3LLj1b91/3MfvIixP3FNVGHsPdS/
H4ONscytrz91TrOAF0nSvwg0Vqwujqw/GVvelIp70L+iEUIvnrKpP7rmqjuL
qs2/7BtROhsbpz9+LjE3kazKv6QV1io=
          "]]}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {
         Arrowheads[{{0.021560682157148306`, 1.}}], 
         ArrowBox[CompressedData["
1:eJwBoQFe/iFib1JlAgAAABkAAAACAAAAAAAAAAAA8L+hraDXObjLP5NmHLvQ
u+6/Zdu3m2efyj/YPybCTmbtv9rrA92Td8k/kbmjIJ2q7L9y9Bds/dTIPy9q
HZ916+u/N20fmmcvyD90LRCux5vqv01yzk+gDMc/MaIPZb1E6b8QYAC7eOPF
PwpTEFB57Oe/yymHU0G5xD/HERbr75Dmv7vTHJw0jMM/2k2PRIJl5b+xnuBD
1IjCP6CC/XrYPOS/fx9JGdmHwT8YsGCO8hbjvyRWVhxDicA/Q9a4ftDz4b9C
hRCaJBq/P7zpvUyJ1uC/4RCou+crvT80vk/yZ4Tfvw+WXQIqTbs/wWztB6Ft
3b/UFDFu6325Px7fVNq9aNu/LY0i/yu+tz/N2rnLG3nZv65aF9/VELY/TiVQ
Phii17/m2PQ303i0P6S+FzKz49W/2we7CST2sj/QphCn7D3Uv4vnaVTIiLE/
Lwl+4hdJ0r8aQrT74q2vP1KcWQ2Le9C/sMDh+0KOrD97wEZPjKrNv9pKXKmw
sqk/3qm2YpKsyr+Y4CMELBunP1hT1eQ=
          "]]}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {
         Arrowheads[{{0.021560482966225796`, 1.}}], 
         ArrowBox[CompressedData["
1:eJwBoQFe/iFib1JlAgAAABkAAAACAAAAAAAAAAAA8D866mdaWLbLP1kMiM7a
u+4/KE0n5qGdyj+4KJ9wWGbtP6FaieLhdck/UPvG8qWq7D83FfK6VdPIP/pu
g5V96+s/35fjZsotyD86frCVzZvqP2g8Mg8VC8c/S1X8QsFE6T8fySjg/+HF
P5DtjUN77Oc/ZLz5C9u3xD+Snq0K8JDmP2xBlCzhisM/iaC84oFl5T9u4KD9
kYfCP9OfU7DXPOQ/82X/56eGwT9wnHJz8RbjP/rRr+siiMA/YJYZLM/z4T8H
SWQRBhi/P2ZpdNeH1uA/rnbWf+opvT+F4l3lZITfP3TofyRNS7s/7luS+51t
3T9cnmD/LXy5PwY/hvG6aNs/ZJh4EI28tz9FeeQdGXnZP9cqD0VUD7Y/IvhX
1xWi1z8BqmuKbXe0P5674B2x49U/4RWO4Nj0sj+5w37x6j3UP3ZudkeWh7E/
TZG7yBNJ0j81fAadtauvP496bvuEe9A/2rZzdUiMrD/7/i4TfarNP9yMNBjl
sKk/NkBt5oCsyj87/kiFixmnP/uX0sE=
          "]]}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {
         Arrowheads[{{0.021560482999463195`, 1.}}], 
         ArrowBox[CompressedData["
1:eJwBoQFe/iFib1JlAgAAABkAAAACAAAAZP8Xj1e2yz8AAAAAAADwP/jfxgqh
nco/eiKxstq77j+K56gR4XXJP0+eHldYZu0/sHf87VTTyD+DY2vYparsP4is
9p3JLcg/9+FVen3r6z8aiaZOFAvHP5xKkXrNm+o/vqZeKP/hxT/EuyQowUTp
PybtMl3at8Q/sd9AKXvs5z/EuRyH4IrDP/rSKvHvkOY/2KChYJGHwj930GzK
gWXlP5jvhlOnhsE/6tRbmdc85D8EpsxfIojAP1bg913xFuM/NYjlCgUYvz+5
8kAYz/PhP0h8eYrpKb0/CP5SxYfW4D/PENw/TEu7P3Lok8RkhN8/ykUNKy18
uT+YqkvenW3dPzUbDUyMvLc/fELN17po2z8fTvWPUw+2P8unpwcZedk/kpvf
42x3tD8q0mnEFaLXP5ADzEfY9LI/nMETDrHj1T8Uhrq7lYexPxp2peTqPdQ/
DqMSm7Srrz/B6vO5E0nSP1xQ0odHjKw/y0go64R70D8UFLQ95LCpP3IghfB8
qs0/Nu63vIoZpz8VgoXCgKzKPwje0pI=
          "]]}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {
         Arrowheads[{{0.023655404082934466`, 1.}}], 
         ArrowBox[CompressedData["
1:eJwBEQLu/SFib1JlAgAAACAAAAACAAAAAAAAAAAA8L/IhydGphbqvwr5py1V
VO+/tejQ+bGK6b+Y1/g2H0/uv7tsBD+9tei/nuxsXIPj7b8MFihzAl7ovyDR
m8rwdO2/UDJfGd0D6L+lyKyxd9nsv8nMAqochee/cfoAynE47L+BSQjl1QHn
v44nrnB+keu/SDOrAbp55r/5ZALcveTqvzKx10Lj7OW/HsOajRk46r8Hwx6R
I2Dlv/9yYpDghem/z5AkHtfO5L+idFnkEs7ov48a6en9OOS/BMh/ibAQ6L9F
YGz0l57jv7AtuCxBTue/j3Qu2hMA478yZuV6TIfmvxBqrzfgXeK/inEHdNK7
5b/EQO8M/bfhv7VPHhjT6+S/rPjtWWoO4b/aEUW1oBjkvyodle07YuC/GMmW
mY1D478/c5wtC2nfv3J1E8WZbOK/F5wyq44K3r/mFrs3xZPhv9y07FMCqdy/
Z66KTEn+4L/xkOVZRbXbvy0TQUj6aOC/aZilltHB2r9urMZRdKjfv/6mrNFG
z9m/EBHt2NWA3r9mmHrSRN7Yv0x2/yHdW92/YkiPYGvv178i/gcpTjrcv6aS
akNaA9e/mMoQ6uwc27/rUoxCsRrWv7L9I2F9BNq/7mR0JRA21b8srypLVePX
v5ueX7ededO/HJbKyIjZ1b/mD4s5NtDRv+EY/F1Z69O/7XdY6lE90L+gwCUe

          "]]}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {
         Arrowheads[{{0.023655466666256873`, 1.}}], 
         ArrowBox[CompressedData["
1:eJwBEQLu/SFib1JlAgAAACAAAAACAAAAXy+FXqcW6r8AAAAAAADwv/MnB9Ov
ium/ZrBfOVFU778un+6+urXovxm1H+AaT+6/4wke3P9d6L9kdvDtfuPtvy/P
zmraA+i/0K3oQ+x07b+D7DrlGYXnv7A6QBZz2ey/Nhr2CdMB579Kkf8ZbTjs
v6aD3RC3eea/bMEGrXmR67+yb6c84Ozlv3xwYAW55Oq/ZK35dSBg5b8FrIOk
FDjqv/cQP+/TzuS/a3+MltuF6b9xmneo+jjkv7DqetsNzui/z0mjoZSe47/U
7U5zqxDovyYODngQAOO/Y6XfCzxO57+J1gPJ3F3iv+otBFNHh+a/96KElPm3
4b9mh7xIzbvlv3FzkNpmDuG/2rEI7c3r5L8i/cZqOGLgv3v71I6bGOS/YuqP
KQRp3797sg19iEPjv0C3JrGHCt6/3dayt5Rs4r/gYFJs+6jcv6FoxD7Ak+G/
6wBhfz6127/V3eBhRP7gv84Lv8zKwdq/XNAMbvVo4L+lAAscQM/Zv+78t8Jq
qN+/iV7jND7e2L/DTMRzzIDev5mk5t5k79e/swxm69Nb3b/xUbPhUwPXvzm5
xCVFOty/q+XnBKsa1r/Qzgcf5Bzbv+TeIhAKNtW/88lW03QE2r8xP9/7l3nT
vwBna0JN49e/UPba3zDQ0b+yMe1NgdnVv6Pr8fdMPdC/yKOOdlLr0782MTDl

          "]]}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {
         Arrowheads[{{0.023655692526438094`, 1.}}], 
         ArrowBox[CompressedData["
1:eJwBEQLu/SFib1JlAgAAACAAAAACAAAAAAAAAAAA8D+arBiAPRbqv3B5OcBA
VO8/yXO3vjqK6b8yt3jLAE/uP57dyjVBtei/hY22NmLj7T9lvRGRhV3ov7iw
/NjMdO0/0eSyWV8D6L/SVLLXUNnsP6jMkoiehOe/o1HX/kc47D+QRs5sVwHn
vzIi/rpRkes/kF99Szt55r8mSEs9juTqP6do7WJk7OW/UaHkEOc36j8RrBmQ
pF/lv062PE2rhek/OVR/IVjO5L8fh1Py2s3oPx5hHhd/OOS/whMpAHYQ6D/A
0vZwGZ7jv6ZJnDgETuc/Tvzn2pX/4r86FoxdDYfmP/Uw0QBjXeK/fXn4bpG7
5T+2cLLigLfhv3Fz4WyQ6+Q/kbuLgO8N4b+m61q5XBjkP94AO7XCYeC/rsl4
tkhD4z/uXzy3HGjfv4sNO2RUbOI/tZFq56QJ3r86t6HCf5PhPxSXAPsdqNy/
Stvf1QP+4D+PykrRZLTbv48Zdv20aOA/PmhNJ/XA2r8uENRy6qffP1A8SsVu
ztm/2nmCE02A3j/zEoNzcd3YvzqcAt1VW90/Vrg5+pzu179no1/PyDncP6X4
ryGRAte/druk6mkc2z8RoCey7RnWv4MQ3S79A9o/yHric1I11b+g0iyx2+LX
P3HdDl/seNO/bfJFsBbZ1T9/eBqskc/Rv4pDqXTv6tM/F0v9Wro80L/owRkK

          "]]}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {
         Arrowheads[{{0.02365569095905574, 1.}}], 
         ArrowBox[CompressedData["
1:eJwBEQLu/SFib1JlAgAAACAAAAACAAAAioZ66TwW6r8AAAAAAADwP/Lukz06
ium/Ad6y1kBU7z8KqLWyQLXov086q9kAT+4/moP+DYVd6L+1In5CYuPtPzCT
otZeA+i/8VxJ4sx07T/yAxcGnoTnv658M95Q2ew/wEr26lYB579to38CSDjs
PwO6Yso6eea//LfKu1GR6z9CNqbiY+zlv7/CNTuO5Oo/++CrEKRf5b/Z8fQL
5zfqP6T1DKNXzuS/1198RauF6T8+dMmZfjjkv7gMzOfazeg/x1zh9Bie4798
+OPydRDoPxo0PmCV/+K/mKGyKARO5z8Pf8mHYl3iv4CGJksNh+Y/pj2Da4C3
4b82pz9akbvlP99vawvvDeG/uAP+VZDr5D+pzGZCwmHgv1B2haBcGOQ/4xW0
1hto379G2fmbSEPjP3RVigykCd6/myxbSFRs4j8DWFAmHajcv01wqaV/k+E/
Qlz0AGS0279LpTO4A/7gP7s6hFv0wNq/LoU237Ro4D8MQEH+bc7ZvzYbczXq
p98/4bhssXDd2L90eIjVTIDeP97xRz2c7te/Xx28nlVb3T+qNxRqkALXv0gF
HZHIOdw/6NYSAO0Z1r92K7qsaRzbP0EchcdRNdW/Ooui8fwD2j8GvHm+63jT
v9vPGnbb4tc/a6x+F5HP0b/MjB94FtnVP8iyWdK5PNC/mIoMQO/q0z/irxXB

          "]]}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {
         Arrowheads[{{0.02348933307310581, 1.}}], 
         ArrowBox[CompressedData["
1:eJwBMQLO/SFib1JlAgAAACIAAAACAAAAXZeqm/1o6j8AAAAAAADwvybsyv3A
AOo/eK9nZ7OB779kpJHx3THpPwTOjV4Gh+6/4Xz7VoPb6D+ew+LAZB7uvySe
ONfGgug/KOJmJ+Cy7b//Tt207gToP14m3UFlGu2/Ne0KdYeC5z/7zb43ZHzs
v0zHxWIy++Y/3tlySGrY679xGLcPD2/mP79JLLSdLuu/PIDVlPji5T8lxgmw
4ITqv2CMhIktUuU/kr80J3DV6b/gPMTtrbzkPwk2rRlMIOm/uZGUwXki5D+F
KXOHdGXov4OG7vbsg+M/fSJ42Fil57/VFst/Y+HiP1+prXRo4Oa/sEIqXN06
4j8wvhNcoxbmvxMKDIxakOE/62CqjglI5b+HAD4t3+LgP3ykbTjWdeS/lLmN
XW8z4D/Im1mFRKHjv3Rq9jkWBN8/0UZudVTK4r/y5gzXZJ3dP5ilqwgG8eG/
7Z28AtSl3D+eCluNClvhvybOK8M0rts/l4jGVQbF4L+P+hl6JbfaP07osVVZ
L+C/HKZGiUTB2T8Y5cEBxzTfv79TcVIwzdg/OuAulgkN3r9qhlk3h9vXP5ZT
MlA66Ny/EMG+mefs1j+/0FMXGcfbv6SGYNvvAdY/Teka02Wq2r/CerqU6xrV
P0+xGBx8ktm/ABBH5Qw41D82FqatmH/Yv8f/Q/nLWdM/qG92I01y1798A+/8
oIDSP0oVPRkra9a/YCxGhG3f0D/Bo3rzqXHUv4TnJjo=
          "]]}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {
         Arrowheads[{{0.023489330862793003`, 1.}}], 
         ArrowBox[CompressedData["
1:eJwBMQLO/SFib1JlAgAAACIAAAACAAAAAAAAAAAA8L+s6Ivp/2jqP3fSzKuz
ge+/aqoGe8MA6j+Ba6XPBofuv7kppIHgMek/4wfXP2Ue7r86BvbqhdvoP16w
lrTgsu2/LkU0b8mC6D8v2ordZRrtv/EF1E3xBOg/2CEd4mR87L8JvsAOioLn
PyQmbgFr2Ou/CGK8/DT75j/TXMh7ni7rvxdLhqkRb+Y/TTsThuGE6r81/1Mu
++LlP7ybSAtx1em/f473ITBS5T8jfmgLTSDpv/n4cISwvOQ/geJyhnVl6L+f
PsBVfCLkP+1X9ONZpee/wAqTh++D4z99bXmLaeDmv6gIlwtm4eI/MyMCfaQW
5r9XOMzh3zriPw15jrgKSOW/zZkyCl2Q4T+a47Np13Xkv/7AWaLh4uA/aNcH
vEWh47/gQdHHcTPgP3ZUiq9VyuK/5Dgy9RoE3z/GWjtEB/Hhv2ihYnVpnd0/
PPqpyAtb4b+C9A2L2KXcPxAK948HxeC/O54JNDmu2z8TmtyNWi/gv6PmEtIp
t9o/M3QpbMk037/YFefGSMHZP+7zsvgLDd6/8HNDdDTN2D/40smoPOjcvwBJ
5TuL29c/+DDiYxvH278f3Yl/6+zWP5YtcBFoqtq/Z3juoPMB1j/tTG1KfpLZ
v6GI6zjvGtU/nQrBypp/2L8vh3VnEDjUP5h5RC5Pcte/kc3zWM9Z0z/GrNAQ
LWvWvz+1zTmkgNI/kKtnwqtx1L+CzjF7cN/QP9j3Kkw=
          "]]}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {
         Arrowheads[{{0.023488913126545333`, 1.}}], 
         ArrowBox[CompressedData["
1:eJwBMQLO/SFib1JlAgAAACIAAAACAAAAUbkiBlRo6j8AAAAAAADwPztWdjMq
AOo/dixuAseB7z+5jzL/RDHpPyQ+1hIRh+4/DkQvM+ra6D+MWVqZbB7uP2uE
EIEtgug/prViEOWy7T8h8LPmVQToP93+cfxmGu0/TFjPP++B5z8Ib/i0Ynzs
P5qpnuOa+uY/nRRKhWXY6z8llbhfeG7mPx9AoKmVLus/xXc7u2Li5T+UeEJn
1YTqP8ri2q2YUeU/11CBq2HV6T811pY3GrzkP+3IXHY6IOk/BFJvWOch5D/R
4NTHX2XoPzEHOA9cg+M/Jig6GkGl5z+wpsRa1ODiP4Yu3edN4OY/gzAVO1A6
4j/2870whhbmP6ikKbDPj+E/cXjc9OlH5T+kp3XhVuLgP2fyzXO0deQ/+d1s
9uky4D9FmCftIKHjP1CPHt4RA98/CGrpYC/K4j9fybmWZ5zdP7RnE8/f8OE/
OrZIDtyk3D+r9hvG41rhP3Tq5ltCrds/69g6KN/E4D+P9N3gOLbaP2CPVOsx
L+A/CmN3/l3A2T/qNZsKeDTfP2jE/BVQzNg/LvkU2LoM3j8pp7eIrdrXP2Bq
3yrs59w/z5nxtxTs1j9ci8Puy8bbP9oq9AQkAdY/9F2KDxqq2j9rcVT3JhrV
PypelhMyktk/6F+XmE831D9UfCqdUH/YP7dN7gwWWdM/02jgQQdy1z9Akop4
8n/SPwXUUZfnatY/JH1Yxs3e0D8B6M2qa3HUP5htGJU=
          "]]}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {
         Arrowheads[{{0.023488914248284566`, 1.}}], 
         ArrowBox[CompressedData["
1:eJwBMQLO/SFib1JlAgAAACIAAAACAAAAAAAAAAAA8D9bXpNUVGjqP8wHGfPG
ge8/IWkKdCoA6j9K6P0GEYfuP3bbQEBFMek/5IKmjmwe7j+Aby506troPzZA
2wblsu0/Tf3/wS2C6D9/BDv0ZhrtP+xJQydWBOg/nekYrmJ87D81yvZ/74Hn
PxrNxH9l2Os/QNxRI5v65j8eZXmllS7rPwe27J54buY/TbN2ZNWE6j+66+35
YuLlP1YiDqph1ek//KD765hR5T88sj92OiDpP9PVFXUavOQ//WILyV9l6D87
ijyV5yHkPw74uhxBpec/YuQ+S1yD4z/dNJjrTeDmP3IK7JXU4OI/bxmjNYYW
5j9u/EN1UDriP8Gl2/rpR+U/VLpG6c+P4T8GlM96tHXkPxHAZBlX4uA/bJ4M
9SCh4z+PiQ4t6jLgP/bEkmkvyuI/ny2ISBID3z+jB2LY3/DhP6PPCv5nnN0/
gK7Fz+Na4T+1yFBz3KTcPxdYMTLfxOA/0z6OvkKt2z+gpIj1MS/gPxUkDUE5
tto/mmheH3g03z+HahdcXsDZP7BOEe26DN4/QQT3cFDM2D/nO/E/7OfcP1Lj
9eCt2tc/qXDFA8zG2z/I+V0NFezWP2MtVSQaqto/uzl5VyQB1j9pcwkoMpLZ
Pzv84kYnGtU/V0QusVB/2D/mQyjlTzfUPwNhX1UHctc/HIF9VhZZ0z9Eijiq
52rWPz4kF7/yf9I/3gVSvGtx1D/LXekGzt7QPxU1EYs=
          "]]}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {
         Arrowheads[{{0.019277770175015512`, 1.}}], 
         ArrowBox[CompressedData["
1:eJwBsQFO/iFib1JlAgAAABoAAAACAAAAAAAAAAAA8L//r3V0xsHgv+yKA8Jb
1++/cHLVOn6s4L9mta/RmcDuv86OM0CFGuC/XIdPHqgs7r8YU38OGZrfv4Mn
xc39lO2/Edtd7kH73r/QTR4JuMDsv/xvOlfxHN6/Kph0YQHm679m+33b4Tfd
v4Ji9imZBeu/bE5329tM3L+I4z6cPx/qv7B4YYycW9u/OkaerMk56b/BtQyg
S2vav/Ii8qIpUOi/rO8qKp522b+yeTp/X2Lnv3AmvCqUfdi/eUp3QWtw5r8P
WsChLYDXvy7CinMffOW/y51TK1OA1r+9DVefTofkv+oEkmPtf9W/Iy3cxPiR
479rj3tK/H7Uv18gGuQdnOK/Tj0Q4H99078mveYEBKjhvxCVF7XZfdK/K9kX
L/G34L8uHVlaa4LRv9zoWsXKl9+/qNXUzzSL0L/dHU8/wcfdv/18FStsMM+/
Kwstfd5Y3L9HFgkTLrDNv0qh/SoD8dq/cOrUi0w3zL90G2CifpHZv2vDgMwm
x8q/3rTzPKA72L8qaxQMHGHJv7+oV1S38Na/lquXgYsGyL8i1ehM
          "]]}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {
         Arrowheads[{{0.01927783573049279, 1.}}], 
         ArrowBox[CompressedData["
1:eJwBsQFO/iFib1JlAgAAABoAAAACAAAACrvRysjB4L8AAAAAAADwv2D5let+
rOC/YQWPoljX778QFTbShRrgv2wdaJ6WwO6/9emWExqa379B8CLipCzuv/HX
JtRC+96/YLDbiPqU7b8ebzoM8hzev+DdO7O0wOy/pGUoX+I33b+98Pj6/eXr
v/ZfYC7cTNy/Slw6tJUF679EJ72unFvbv21PSBg8H+q/WbSPkktr2r++7fka
xjnpv/qZcu6ddtm/AWq/BSZQ6L8k2GXCk33YvzXEmNhbYue/225pDi2A179d
/IWTZ3Dmv4ONlG9SgNa/XfAXwRt85b+EY/6C7H/Vvxt+3+tKh+S/3vCmSPt+
1L+YpdwT9ZHjv5A1jsB+fdO/1GYPORqc4r9y7Ox72H3Sv4R/aGMAqOG/YdD7
C2qC0b9erdia7bfgv1nhunAzi9C/xuC/vsOX37+5PlRUaTDPvySR/GG6x92/
1gdpvSqwzb94p+NZ11jcv/4j9b9IN8y/ksz9yPvw2r9vTv2TIsfKvx75rAl3
kdm/YkKGcRdhyb/GJVN2mDvYvxq7lJCGBsi/OktSaa/w1r8hGvcO
          "]]}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {
         Arrowheads[{{0.019278788679977753`, 1.}}], 
         ArrowBox[CompressedData["
1:eJwBsQFO/iFib1JlAgAAABoAAAACAAAAAAAAAAAA8D/Y3GZ8s8Hgv4v+Ajc2
1+8/3tgcsles4L9ZZ/K1ccDuP7Y10wReGuC/NCb3w34s7j9g/nf5yZnfv0nl
qTTTlO0/vZVPP/L63r+VZjsqi8DsP27KikKgHN6/s/GUPNLl6z+cM5hojzfd
v4CVdNRnBes/v4h4J4hM3L9dokUkDB/qP7GMK61HW9u/vUMeH5Q56T8fJB+i
9WravzB39yfyT+g/T5FmPEd22b+6PNE+JmLnP0bUAXw8fdi/VpSrYzBw5j8B
7fBg1X/Xv5APlTHje+U/YB8jl/p/1r/uP5xDEYfkP0avh8qUf9W/byXBmbqR
4z+tnB77o37UvxXAAzTfm+I/mefnKCh907/mOqofxafhP307q+eCfdK/6MD6
abK34D/MQzDLFYLRvzik6iVOl98/hgB30+CK0L8E3TM1RsfdP1Xj/gDIL8+/
+yARM1xY3D/+nyMEhK/NvzzUSEV68No/Vl75O502zL/zaU3X75DZPxRYpfBy
xsq/UFWRVAw72D/yxkxqZGDJv4YJhygf8NY/reQU8dAFyL/ebN99
          "]]}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {
         Arrowheads[{{0.019278790229164827`, 1.}}], 
         ArrowBox[CompressedData["
1:eJwBsQFO/iFib1JlAgAAABoAAAACAAAAg1HkNLPB4L8AAAAAAADwP/JC+GlX
rOC/tHofNTbX7z/C2sO9XRrgv+6nerFxwO4/VW2RbMmZ37/cETK+fizuP02V
rrPx+t6/SmuULdOU7T8s5i64nxzev0Ru0iCLwOw/oc+W34433b8sa9Ew0uXr
P6ZQ9J+HTNy/tk9fxmcF6z/nvkInR1vbv/0h4hMMH+o/H2XYHfVq2r8NrHYM
lDnpP3xo7blGdtm/apMjE/JP6D8CyYH7O33YvxjY6CcmYuc/r4aV4tR/178R
esZKMHDmP3q8Hhv6f9a/LFrZFuN75T9ahRNRlH/VvzZZPicRh+Q/TOFzhKN+
1L8xd/V7upHjP1TQP7UnfdO/G7T+FN+b4j/eqzt3gn3Sv0rDpv/Ep+E/Vc0r
XhWC0b8OWDpJsrfgP7s0EGrgitC/0uRy402X3z8kxNE1xy/Pv7gkSPJFx90/
qmPDOIOvzb+hxtbpW1jcPyx9yHCcNsy/zN879nnw2j/p/w4mcsbKv7DL94Lv
kNk/HdvEoGNgyb+85Yr7CzvYPwz+FynQBci/aol1yx7w1j9x+uTm
          "]]}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {
         Arrowheads[{{0.01927275986249003, 1.}}], 
         ArrowBox[CompressedData["
1:eJwBsQFO/iFib1JlAgAAABoAAAACAAAAmrw3wody4T8AAAAAAADwP+dkY1GO
7OA/Wy2tjEcK7z9JpvqBeJ7gP7xYi4UQe+4/SsmxLWBO4D8tEFvSKejtP1m/
Vb0hvt8/dDi9+gIc7T+EcLuNjdjeP15QxFx6Sew/J5vD7o/s3T9N1Jp6EHHr
PzyYXir6+dw/y5oyfpqS6j+cnuazMQjcPxQaqsfgtOk/BIrbs2sR2z+ETaKC
k9LoP3ZaPSqoFdo/GTUbr7Lr5z/vDwwX5xTZP9PQFE0+AOc/PrrupugQ2D8j
clNb0RHmPy5pjAZtC9c/eWqb2AYi5T/AHOU1dATWP9W57MTeMOQ/9NT4NP77
1D83YEcgWT7jPzx6uU1r9NM/fG1gvqNM4j8M9RjKG/DSP4Xx7HLsXeE/Y0UX
qg/v0T9P7Ow9M3LgP0JrtO1G8dA/trvAPvAS3z/5LQgrczPQP+827HLHtt0/
2OszjRfxzj+v5l45+1/cPy8VNrpggs0/7EwdULAP2z/wZnkWARzMP6PrK3UL
x9k/F3Bg2ze/yj/ORI9mMYfYP5q/TUJEbck/ZtpL4kZR1z/pKc//
          "]]}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {
         Arrowheads[{{0.019272759715839492`, 1.}}], 
         ArrowBox[CompressedData["
1:eJwBsQFO/iFib1JlAgAAABoAAAACAAAAAAAAAAAA8D/wX18diHLhP3gmsIBH
Cu8/Rb9Fo47s4D+NItd6EHvuP4FS+NJ4nuA/O7b0yCno7T9rB8N9YE7gP1hh
dfMCHO0/XLs8WyK+3z9WtaRXeknsP88qTSmO2N4/DkyidxBx6z/ET92HkOzd
P+KcY32akuo/CITgwPr53D/fKP3I4LTpPx7HzEcyCNw/SuUKhpPS6D8gN/5E
bBHbPyLSjLSy6+c/E9R0uKgV2j9o74JUPgDnP/WdMKLnFNk/leilZNER5j9f
FtUu6RDYPyFpruMGIuU/5r4Fi20L1z8LcZzR3jDkP4qXwrZ0BNY/VABwLlk+
4z9LoAuy/vvUP2jP1s2jTOI/MSrXxmv00z+xln6D7F3hPz2GGz8c8NI/L1Zn
TzNy4D9ztNgaEO/RP8sbImPwEt8/07QOWkfx0D+2Ef+ax7bdP201hpVzM9A/
GzPdZPtf3D9do0leGPHOP+0jun6wD9s/56g2h2GCzT8diJOmC8fZPy8RNd8B
HMw/ogNnmjGH2D/wcaafOL/KP3I6MhhHUdc/5GDsAUVtyT9iFc5p
          "]]}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {
         Arrowheads[{{0.019273402126430687`, 1.}}], 
         ArrowBox[CompressedData["
1:eJwBsQFO/iFib1JlAgAAABoAAAACAAAA0BJqFBlz4T8AAAAAAADwv1tHY9b+
7OA/JjLTYxMK778oefYs557gP4hDHqDdeu6/5mQE8sxO4D+LW903+OftvxR3
3FP2vt8/07h+e9Mb7b+ivlsKXdnePylGcQlNSey/gABXKVrt3T/yjFpf5XDr
v6oc3vq++tw/DgquqHGS6r+Ip20c8QjcPwPkrzO6tOm/HuqZkCUS2z/7rXg1
b9Lov2jkYldcFto/+GcIrpDr579qlshwlRXZP/kRX50eAOe/Ry2JD5ER2D/u
y3f6sxHmvybWYmYPDNc/x7VNvOsh5b8IkVV1EAXWP4TP4OLFMOS/7F1hPJT8
1D8lGTFuQj7jv2MZ7xD79NM/oClRKo9M4r/6n2dIpfDSP+mXU+PZXeG/tPHK
4pLv0T8BZDiZInLgv5AOGeDD8dA/0Bv/l9IS37/JhFbX6zPQPwxBQkmttt2/
x4rmYgDyzj/IYKNo5F/cv/bKoRtBg80/mkOPr5wP279U9KEX2RzMPxSyctf6
xtm/HDGqlQfAyj/OdLqZI4fYv4KrfdQLbsk/XlTTrztR1785v+EZ
          "]]}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {
         Arrowheads[{{0.019273410721454255`, 1.}}], 
         ArrowBox[CompressedData["
1:eJwBsQFO/iFib1JlAgAAABoAAAACAAAAAAAAAAAA8L9axxdLHXPhP+B/f1kS
Cu+/2qp0WwLt4D9Rjgmi3Hruvxf02aXqnuA/KVVBRvfn7b9HLF1e0E7gPwYe
LJ7SG+2/ninrDP2+3z8ej99ATEnsv7Wjm6Jj2d4/qriwq+Rw67+mOWafYO3d
P5jqLQpxkuq/LsVsTcX63D90BB6qubTpvzF7bEv3CNw/jvafwG7S6L++e5qa
KxLbP+bAs02Q6+e/18b2OmIW2j98Y1lRHgDnv3tcgSybFdk/08QqwrMR5r97
m/qhlhHYP2zLwZbrIeW/qOIizhQM1z9Idx7PxTDkvwMy+rAVBdY/Z8hAa0I+
47+KiYBKmfzUPxDJ8zaPTOK/zqJj8P/00z+MgwL+2V3hv1o3Ufip8NI/2vds
wCJy4L8xR0lil+/RP/JLZvzSEt+/UNJLLsjx0D+/L1TQrbbdv3womQrwM9A/
EqA/EOVf3L/vPaOSCPLOP1YSXHWdD9u/pSe8E0mDzT/5+9y4+8bZv0HKTtfg
HMw/bNL1kySH2L/q4SwcD8DKPxgL2r88Ude/wyooIRNuyT8xleGR
          "]]}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {
         Arrowheads[{{0.017140109274837896`, 1.}}], 
         ArrowBox[CompressedData["
1:eJwBYQGe/iFib1JlAgAAABUAAAACAAAAAAAAAAAA8L/v6wIpJ13Sv954BMkt
e++/cTibRO4Q0r9QvWEOTs/uvzJUFBdMrtG/XQBnmX4f7r/IKDWbZ0nRvx6n
13F+GO2/jE2o6nmy0L82nUCXMgrsv780eWhcF9C/bhScKbX26r9KJEjKh/LO
vy7868hS3em/T/7+4JKvzb/COxbgscXov3o0YNehbsy/hJvp866r578oQneq
9CrLv3YbZgRKj+a/WydEWovkyb+Wu4sRg3DlvxLkxuZlm8i/uHQVDk9S5L/g
UhEY6VLHv6w/vuyiN+O/WE41tnkOxr90HIatfiDiv3nWMsEXzsS/EAttUOIM
4b9D6wk5w5HDv8BcXqr9/t+/5/7S6JJcwr+MUhF3Cvbdv5SDppudMcG/hPfy
Buv+279LeYRR4xDAv6dLA1qfGdq/FcDZFMj0vb9gxKJ6o2PYv/IwksEW/ru/
C6a7hw==
          "]]}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {
         Arrowheads[{{0.01714015153572448, 1.}}], 
         ArrowBox[CompressedData["
1:eJwBYQGe/iFib1JlAgAAABUAAAACAAAA81+Sty1d0r8AAAAAAADwv7nZocvy
ENK/4oEhbyp777+C+xt2UK7Rv5oTK6xKz+6/a6Cw0WtJ0b/1Yk4vex/uvy1V
7tp9stC/vCdP63oY7b8l22kRYBfQv6JY7fQuCuy/bvszjo7yzr+ZuvZtsfbq
v4FHrhaZr82/TmHR9U7d6b9oTp2Ap27Mv29Bdfatxei/4tGPyvkqy78m2Xz3
qqvnv+/RhfSP5Mm/cyjo+EWP5r+RTn/+aZvIv1Uvt/p+cOW/rqeysuxSx7/B
inTwSlLkvyg9Vtt8Dsa/p9eqzZ43478DD2p4Gs7EvwkWWpJ6IOK/PB3uicWR
w7/mRYI+3gzhv6H5qduUXMK/OzkEo/X+37/+NWU5nzHBvyCfcJUC9t2/UdIf
o+QQwL95vUlU4/7bvzidszHK9L2/RZSP35cZ2r+IPLijGv67v3HngieeY9i/
enDGXg==
          "]]}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {
         Arrowheads[{{0.017140908348683176`, 1.}}], 
         ArrowBox[CompressedData["
1:eJwBYQGe/iFib1JlAgAAABUAAAACAAAAAAAAAAAA8D87dqc+cF3Sv3D1rO3v
eu8/VrfmqhIR0r9I+c1SD8/uP8SMJHRurtG/YmGuBT8f7j/tWbHqh0nRv+Ar
3RY8GO0/4mFISZay0L+FGkt+7QnsP8V65sp0F9C/fWMNhG326j/UVbK3sPLO
v2efx7oI3ek/GItiBbSvzb9htG5+ZcXoPxgQ8lK7bsy/Zm7njGCr5z+GCQvM
BivLv37NMeb5juY/Z3etcJbkyb+j0U2KMXDlP7ZZ2UBqm8i/HOBMf/xR5D9k
RlQo51LHvy1eQMtPN+M/YNPjEnIOxr/USyhuKyDiP6QAiAALzsS/E6kEaI8M
4T83zkDxsZHDvxWY32RZ/t8/OQtotX1cwr+0FQiOaPXdP9CGVx2FMcG/BcuC
S0z+2z/6QA8pyBDAvwa4T50EGdo/cHMesY30vb+XLPByNmPYP30dxwMJ/ru/
eNOtBQ==
          "]]}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {
         Arrowheads[{{0.017140910009398998`, 1.}}], 
         ArrowBox[CompressedData["
1:eJwBYQGe/iFib1JlAgAAABUAAAACAAAAD8h4/m9d0r8AAAAAAADwP/xFnVoS
EdK/9jzMz+967z+CrqEkbq7Rv/6T7jMPz+4/VRD/m4dJ0b/0/NPlPh/uPzSS
AvuVstC/fJ0o9DsY7T/qNxt9dBfQv+Zou1jtCew/axRKHbDyzr+8NsJbbfbq
P1sMWGyzr82/Jr/Vjwjd6T80IVO7um7Mv+dJ6FBlxeg/McMiNgYry7/mkwVd
YKvnP1ryxtyV5Mm/Kp0ttPmO5j+prj+vaZvIv61lYFYxcOU/vM9bmeZSx7/k
uMFJ/FHkPy8t6oZxDsa/QGJ1lE834z8Ex+p3Cs7Ev8VhezYrIOI/OJ1dbLGR
w79vt9MvjwzhP+u9jzR9XMK/Ugku9Fj+3z8+N86ghDHBv7rVux1o9d0/LwkZ
sccQwL8W1FDcS/7bP31n4MqM9L2/ZQTtLwQZ2j/LQfRLCP67v89TBCg2Y9g/
rpizMA==
          "]]}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {
         Arrowheads[{{0.016549581705215855`, 1.}}], 
         ArrowBox[CompressedData["
1:eJwBcQGO/iFib1JlAgAAABYAAAACAAAAAAAAAAAA8L+n9bFua2u0vypj803s
au+/Wi0RsUoMtL9+IqdAibHuvwaOKHf+lbO/FkYgsDz07b8kKkopMx2zv9RA
EEroP+2/Cd/gESGqsr/hEu/itITsv8bYD4msMrK/3AfH4cHG679xVBUGd7mx
v2Broq0uCuu/JY8vACJBsb96MPc+6kzqv+/zxuJbyLC/sLhfxbaL6b+kRAkq
E02wv1f1nHrwyOi/CIG5zJKhr7/G12+Y8wbov5xNT1AAqq6/+K+VntC/5r8G
i4ZJgAitv8nRMCWEeuW/CKciulhpq785PUEsDjfkv6KhI6KJzKm/SfLGs271
4r/UeokBEzKov5w/FqGjueG/TMS4Aw2fpr/Yc4PZqofgv7gPFtSPGKW/+B0d
ugi/3r8ZXaFym56jvw4ib1dggty/bKxa3y8xor9JPkcB6F3av8YAxoUz06C/
+7zvLStW2L9uus6iGQ+fv4Y6vb4=
          "]]}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {
         Arrowheads[{{0.016549588759019244`, 1.}}], 
         ArrowBox[CompressedData["
1:eJwBcQGO/iFib1JlAgAAABYAAAACAAAAHoeDD45rtL8AAAAAAADwv4YPgOtq
DLS/Szv2h+lq77+rssriHZazvy8B+HCGse6/WAw/wlEds7/gKU7XOfTtv7Ig
A/I+qrK/J0lpgeU/7b8U31eryTKyv1hdOC6yhOy/rBSAaJO5sb9OoIJCv8br
v6iOvqM9QbG/4UsPIywK679FmZbHdsiwv0xlbsrnTOq/o00aTi1NsL+4zWtq
tIvpv6FYxZHFoa+/9IioOu7I6L+saxGTMaquv8iaxXLxBui//UuW/64Irb8j
bkKkzr/mv/7dL+qEaau/zPRTWIJ65b+uId5Ss8ypv8Qu+o4MN+S/DhehOToy
qL8LHDVIbfXiv1fRTtAxn6a/wJSgZ6K54b/EY71IshilvwRx2NCph+C/Vc7s
orueo7+uYbkHB7/evwkR3d5NMaK/b6haAV+C3L8pnn1rT9OgvyjlhQLnXdq/
+c97b00Pn7+0Rix/KlbYv3qCwsw=
          "]]}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {
         Arrowheads[{{0.016549726949723537`, 1.}}], 
         ArrowBox[CompressedData["
1:eJwBcQGO/iFib1JlAgAAABYAAAACAAAAAAAAAAAA8D9OdILXF260v9r4EX2y
au8/Emb+u8UOtL83ClahTrHuP0ZKRYFpmLO/txgITgH07T9GwFvmjR+zv4/W
HjOuP+0/REyDkW2ssr8ursxlfITsP0yrhWrqNLK/tinqHYvG6z+9Xqwiprux
v0nTT5P5Ces/+edAa0JDsb8amYrqtkzqP+j4np9tyrC/AwASgYWL6T9Kb+gT
Fk+wvyt0HmTByOg/gBwg3Xqlr7+0YeigxgboP9gxEazKra6/RL01L6e/5j//
4lB+GAytv1NH7WpeeuU/RuX6T79sq7/l/w5U7DbkP7A4DyG/z6m/9uaa6lD1
4j863Y3xFzWov7RD1e+JueE/dmmPaeKhpr9JXQIllYfgP/hzLDE3G6W/bGdE
FOW+3j+8/GRIFqGjv/iNaT5Egtw/xwM5r38zor8TCVgN013aP+N01hJa1aC/
nLPzxRxW2D+8d9ZAGBOfv5m1t2s=
          "]]}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {
         Arrowheads[{{0.01654972723956636, 1.}}], 
         ArrowBox[CompressedData["
1:eJwBcQGO/iFib1JlAgAAABYAAAACAAAAXm7M7xdutL8AAAAAAADwP4aqsLvF
DrS/XmE+V7Jq7z/tN/V/aZizv8Q2ynpOse4/BFYL5I0fs78l0MsmAfTtP1Wb
CY9trLK/y0l4DK4/7T8t2P5n6jSyv6Ic8D98hOw/OqsjIKa7sb+Oeez4isbr
PyuzsGhCQ7G/b5Emb/kJ6z/AehSdbcqwv3RMS8e2TOo/m5mCERZPsL+azfFe
hYvpP4qDtth6pa+/Ap4yQ8HI6D+QSv2nyq2uv8lGJoHGBug/VCxKexgMrb85
XcsRp7/mP9r1M06/bKu/ABEAUF565T8jp7ogv8+pvx1ixDvsNuQ/K0De8hc1
qL+PUBjVUPXiP6dnnGzioaa/MEwm3Ym54T9CxPI1Nxulv9TEGBWVh+A//1Xh
Thaho7/8dN/55L7eP9wcaLd/M6K/VlpWKUSC3D9oi6AcWtWgvyScVP3SXdo/
WihIVxgTn7/InJi6HFbYP3oLtnA=
          "]]}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {
         Arrowheads[{{0.017087624336527957`, 1.}}], 
         ArrowBox[CompressedData["
1:eJwBYQGe/iFib1JlAgAAABUAAAACAAAAVlWWG1BL1D8AAAAAAADwv65apT/b
C9Q/6ZCtAvGb779TDVhtJ4vTP5wHCrEA0e6/UQVIQMgd0z+V5QttiyTuv7C2
j175rdI/KSuTsj507b9eE8GgHwXSPwQ+DxgAauy/owtgC8BX0T+tAlfMn1jr
v7JMsmlep9A/luE/SYFC6r9G5Ovv8ubPP+u3grvYJum/461vvI+Bzj9OHtnM
FA3ov7c9z0jzGc0/NJywEZDx5r/CkwqVHbDLP6ExCYpK1OW/BbAhoQ5Eyj+Q
3uI1RLXkv4Ddy2un2cg/zV6Q9ouX478sZ8DzyHTHPxpuZK0wfuK/D03/OHMV
xj97DF9aMmnhvySPiDumu8Q/7TmA/ZBY4L+lXj/Xr2rDP2h97u7Ond6/zOwG
6N0lwj8oxuZRoZ3cv5g5320w7cA/Gk7pI5mw2r8OipDRToG/PzkV9mS21ti/
LX2wvQ==
          "]]}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {
         Arrowheads[{{0.017087618808780628`, 1.}}], 
         ArrowBox[CompressedData["
1:eJwBYQGe/iFib1JlAgAAABUAAAACAAAAAAAAAAAA8L9Vy6axWUvUP8ax77Xw
m++/HwARh+QL1D8zefRVANHuv6nZ324wi9M/TcwKH4sk7r/zrXEW0R3TP1H8
sHE+dO2/SEA7CAKu0j8uKTf6/2nsvzxF4xAoBdI/+TUR0p9Y67/VVyxAyFfR
P+hj5nGBQuq/DrNTYWan0D/oR9QG2Sbpv3uGNGEC588/MMYhOhUN6L+fPfyv
noHOPxgvR5+Q8ea/Oox3uwEazT+kgkQ2S9Tlv05ypoMrsMs/zsAZ/0S15L/X
74gIHETKP3BqVNqMl+O/tzKxSbTZyD9eAIKoMX7iv8xosUbVdMc/moKiaTNp
4b8Ykon/fhXGPyDxtR2SWOC/ma45dLG7xD+IEKtK0Z3ev9CFGIK6asM/qgg1
wqOd3L8833wG6CXCP6XKCaKbsNq/4LpmATrtwD96VinquNbYv24xrOVggb8/
17evlg==
          "]]}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {
         Arrowheads[{{0.017087498324480345`, 1.}}], 
         ArrowBox[CompressedData["
1:eJwBYQGe/iFib1JlAgAAABUAAAACAAAAAAAAAAAA8D+NKwQ3U0rUP1P5CAwI
nO8/JpwuDfAK1D/kPrLIF9HuPwOZwIdCitM/OkndcqEk7j+Dkvn/5xzTP2E+
XKNTdO0/ZiLg3x2t0j/UWvJbEmrsPzC75adKBNI/LS7xU69Y6z/3mfPG8VbR
P0ZH/xeOQuo/Z2ldAZem0D/Xy4/O4ibpPzzhYyty5c8/C0g7MBwN6D8VvF71
HIDOP/wen9qU8eY/Tp/StY4YzT+tULvNTNTlP+uKv2zHrss/Gd2PCUS15D/p
fiUax0LKP07M4X2Jl+M/jrS3nm7YyD9ZJnYaLH7iPyJlKduec8c/OOtM3ytp
4T+kkHrPVxTGP+oaZsyIWOA/Ejere5m6xD8f2OeMu53eP21MiJexacM/jipR
ZIud3D+2xN7a7STCPyItCB+BsNo/65+uRU7swD/X3wy9nNbYPxi876+lf78/
rEmp/Q==
          "]]}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {
         Arrowheads[{{0.017087500287328666`, 1.}}], 
         ArrowBox[CompressedData["
1:eJwBYQGe/iFib1JlAgAAABUAAAACAAAAevdvp1JK1D8AAAAAAADwP5R3ZHPv
CtQ/8Bwr+Qec7z/Td3HzQYrTPwoM3bgX0e4/41rubecc0z/9SdZhoSTuP/a/
K1AdrdI/YhomkVN07T9o1qQaSgTSP+LAPUYSauw/fHhCPPFW0T9kPbg6r1jr
PwHeZHmWptA/qtFg+41C6j8QPi0hceXPP8dnnq7iJuk/Uqvr8BuAzj9CjAsN
HA3oPwCmfreNGM0/Ts9stJTx5j8bLuZ0xq7LP+wwwqRM1OU/n0MiKcZCyj8a
sQveQ7XkPwDS5LRt2Mg/4/QiUImX4z+uxN/4nXPHP1Ch4eorfuI/qRsT9VYU
xj9htkeuK2nhP+7WfqmYusQ/EzRVmohY4D9JxNbNsGnDP3/WdSe7nd4/hLHO
Ge0kwj92WVP+ip3cP5yeZo1N7MA/CvFCuYCw2j8mFz1RpH+/Pz2dRFic1tg/
e2+p5Q==
          "]]}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {
         Arrowheads[{{0.01579795638630435, 1.}}], 
         ArrowBox[CompressedData["
1:eJwBcQGO/iFib1JlAgAAABYAAAACAAAAt1+PRo1svj8AAAAAAADwvxWrR7/q
SL4/jCRZ7ITa778ehzI/p5C9P0pdpO61GO+/BSVtOEHgvD8WKJm2LF/uv2AT
5UIyLLw/hyRIB8qh7b86Y2loooO7P3ufD+d+8Oy/orYmeOzUuj98OmAnvDjs
v95xlOXAI7o/Ha/nJ2N+678v+Skk0HO5P+62U0hVxeq/3HtwWU7DuD/j+iLc
rgvqv2r5OcFaD7g/ousD9WhO6b+JDmtwBlq3P0/u6w+wj+i/4Ffoe2Kltj8E
aNCpsNHnv2oHK0LmcrU/BiC8L1SP5r8UsHyqQEK0PyLgs7jmTuW/31HdtHET
sz9YqLdEaBDkv8nsTGF55rE/pXjH09jT4r+DlGJd/r6wP1fAF34PneG/drlq
rU5Brz+57txb42/gv+SKiproFq0/lwcu2qiY3r9OnSSCyv6qPxr/i2PFZNy/
/0TQrxz9qD+Nl93Ae0jav5SLvOE=
          "]]}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {
         Arrowheads[{{0.015797957577199526`, 1.}}], 
         ArrowBox[CompressedData["
1:eJwBcQGO/iFib1JlAgAAABYAAAACAAAAAAAAAAAA8L8qMd05s2y+P664SWyF
2u+/clfG/xBJvj8N3TRjthjvv+mTB4/MkL0/9dm9My1f7r8C72C0ZeC8P7rk
34zKoe2/x2FH5lUsvD8UG5pyf/Dsv/eWMD/Fg7s/vrMSuLw47L+kkOZ5DtW6
P1MNcb1jfuu/g3LuDuIjuj9zhtziVcXqv0lgzXbwc7k/dqwMe68L6r8OnhHU
bcO4PyQYFZdpTum/cOtiXnkPuD9POae0sI/ov3yl7C0kWrc/vH90UbHR5780
Kdpaf6W2PwzydM9Uj+a/rnVHmwFztT90YRVP507lv5SrtH5aQrQ/+M1V0GgQ
5L/oyiEFihOzP5Q3NlPZ0+K/q9OOLpDmsT89oH3wD53hv54brK0Tv7A/5wnz
wONv4L8N8VNqdkGvPyLpLImpmN6/xtQQig0XrT90wM/2xWTcv2bijrrs/qo/
rxDoOHxI2r9vR5dNPP2oPy9WvX0=
          "]]}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {
         Arrowheads[{{0.015797898363932104`, 1.}}], 
         ArrowBox[CompressedData["
1:eJwBcQGO/iFib1JlAgAAABYAAAACAAAAAAAAAAAA8D+lrnRaL2m+PzaWe3yE
2u8/xKNpWpBFvj9NDZHRtRjvP+GOQY1hjb0/BhBSCCxf7j8dU+uBDt28P6vr
gMjIoe0/WLss8BIpvD9NL9/6fPDsP1zeTRiVgLs/J+4Wkrk47D+m2vPc8dG6
P7FEP+tffus/csebRtkguj9iT29jUcXqP/67wl37cLk/g2twV6oL6j+eRaqD
jMC4P34eZ95jTuk/xNzdSqwMuD8FQfNsqo/oP1F5yYVrV7c/x6u0d6rR5z8q
E9kG26K2P/ECFRVOj+Y/4tw4zoBwtT+aF6zL4E7lP2pYoxj9P7Q/xel5m2IQ
5D/HhRjmTxGzP3B5foTT0+I/9mSYNnnksT8qMZmYCp3hPxfMRUofvbA/gXup
6d5v4D+LIofC0D2vP+qwXu+gmN4/CGkj96gTrT8NkFWFvmTcP6NrYDLH+6o/
mAEO9HVI2j/Gz448U/qoP3ylsuo=
          "]]}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {
         Arrowheads[{{0.01579789867843719, 1.}}], 
         ArrowBox[CompressedData["
1:eJwBcQGO/iFib1JlAgAAABYAAAACAAAAi4b/US5pvj8AAAAAAADwP9owJTKP
Rb4/BM+8WYTa7z+B7mdtYI29P61RGLG1GO8/xzFPZw3dvD//dA/nK1/uP6Hc
9NoRKbw/o8F7psih7T/2ORAJlIC7P6FqHtl88Ow/a1kQ1PDRuj9NPcdwuTjs
P4jGOETYILo/DIdyyl9+6z/QDM1h+nC5P0GVHENRxeo/r0Y6jovAuD8YK6w3
qgvqP+B4P1yrDLg/ILlhv2NO6T9oDhueale3P9kQwE6qj+g/QnILJtqitj+4
A0paqtHnPzh7sfl/cLU/SICh+U2P5j+INXdQ/D+0PzykVrLgTuU/NaFcKk8R
sz+Wb2mEYhDkPz2+YYd45LE/U+LZb9PT4j+4s3OnHr2wP8NOcIYKneE/eFH/
lM89rz82B/XZ3m/gP5Q6C+GnE60/VBfQ1KCY3j++IgszxvuqPzy4km++ZNw/
M5YJU1L6qD+goeTidUjaP6U+rYU=
          "]]}}}}}, {
    DisplayFunction -> Identity, AspectRatio -> 1, AxesLabel -> {None, None}, 
     DisplayFunction :> Identity, Frame -> True, FrameLabel -> {{
        FormBox[
         StyleBox["\"y\"", 
          GrayLevel[0], 15, StripOnInput -> False], TraditionalForm], None}, {
       
        FormBox[
         StyleBox["\"x\"", 
          GrayLevel[0], 15, StripOnInput -> False], TraditionalForm], None}}, 
     FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
     FrameTicksStyle -> Directive["Label", 12], GridLinesStyle -> Directive[
       GrayLevel[0.5, 0.4]], 
     Method -> {
      "DefaultBoundaryStyle" -> Automatic, "DefaultPlotStyle" -> Automatic, 
       "ScalingFunctions" -> None}, PlotRange -> {{-1, 1}, {-1, 1}}, 
     PlotRangeClipping -> True, PlotRangePadding -> {{
        Scaled[0.02], 
        Scaled[0.02]}, {
        Scaled[0.02], 
        Scaled[0.02]}}, Ticks -> {Automatic, Automatic}}],FormBox[
    FormBox[
     TemplateBox[{
       FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           GraphicsBox[{{}, {}, 
             RasterBox[CompressedData["
1:eJxFlwd4FWUWhiluCEkAC22VHqqg7KqgoPiBFFHAAixNVBCwIGKQIiBFOoQA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              "], {{
                Rational[-15, 2], 
                Rational[-225, 2]}, {
                Rational[15, 2], 
                Rational[225, 2]}}], {Antialiasing -> False, 
              AbsoluteThickness[0.1], 
              Directive[
               Opacity[0.3], 
               GrayLevel[0]], 
              LineBox[
               NCache[{{
                  Rational[15, 2], 
                  Rational[-225, 2]}, {
                  Rational[-15, 2], 
                  Rational[-225, 2]}, {
                  Rational[-15, 2], 
                  Rational[225, 2]}, {
                  Rational[15, 2], 
                  Rational[225, 2]}, {
                  Rational[15, 2], 
                  Rational[-225, 2]}}, {{7.5, -112.5}, {-7.5, -112.5}, {-7.5, 
                112.5}, {7.5, 112.5}, {7.5, -112.5}}]]}, {
              CapForm[None], {}}, {Antialiasing -> False, 
              StyleBox[
               LineBox[{{7.5, -112.5}, {7.5, 112.5}}], 
               Directive[
                AbsoluteThickness[0.2], 
                Opacity[0.3], 
                GrayLevel[0]], StripOnInput -> False], 
              StyleBox[
               StyleBox[{{
                  StyleBox[
                   LineBox[{{{7.5, -60.67708333333333}, 
                    Offset[{4., 0}, {7.5, -60.67708333333333}]}, {{
                    7.5, -8.593749999999996}, 
                    Offset[{4., 0}, {7.5, -8.593749999999996}]}, {{7.5, 
                    43.489583333333336`}, 
                    Offset[{4., 0}, {7.5, 43.489583333333336`}]}, {{7.5, 
                    95.57291666666667}, 
                    Offset[{4., 0}, {7.5, 95.57291666666667}]}}], 
                   Directive[
                    AbsoluteThickness[0.2], 
                    GrayLevel[0.4]], StripOnInput -> False], 
                  StyleBox[
                   LineBox[{{{7.5, -99.73958333333333}, 
                    Offset[{2.5, 0.}, {7.5, -99.73958333333333}]}, {{
                    7.5, -86.71875}, 
                    Offset[{2.5, 0.}, {7.5, -86.71875}]}, {{
                    7.5, -73.69791666666667}, 
                    Offset[{2.5, 0.}, {7.5, -73.69791666666667}]}, {{
                    7.5, -47.65625}, 
                    Offset[{2.5, 0.}, {7.5, -47.65625}]}, {{
                    7.5, -34.635416666666664`}, 
                    Offset[{2.5, 0.}, {7.5, -34.635416666666664`}]}, {{
                    7.5, -21.614583333333332`}, 
                    Offset[{2.5, 0.}, {7.5, -21.614583333333332`}]}, {{7.5, 
                    4.427083333333321}, 
                    Offset[{2.5, 0.}, {7.5, 4.427083333333321}]}, {{7.5, 
                    17.44791666666667}, 
                    Offset[{2.5, 0.}, {7.5, 17.44791666666667}]}, {{7.5, 
                    30.468750000000004`}, 
                    Offset[{2.5, 0.}, {7.5, 30.468750000000004`}]}, {{7.5, 
                    56.51041666666667}, 
                    Offset[{2.5, 0.}, {7.5, 56.51041666666667}]}, {{7.5, 
                    69.53125}, 
                    Offset[{2.5, 0.}, {7.5, 69.53125}]}, {{7.5, 
                    82.55208333333334}, 
                    Offset[{2.5, 0.}, {7.5, 82.55208333333334}]}, {{7.5, 
                    108.59375}, 
                    Offset[{2.5, 0.}, {7.5, 108.59375}]}}], 
                   Directive[
                    AbsoluteThickness[0.2], 
                    GrayLevel[0.4], 
                    Opacity[0.3]], StripOnInput -> False]}, 
                 StyleBox[
                  StyleBox[{{
                    StyleBox[{
                    InsetBox[
                    FormBox[
                    TagBox[
                    InterpretationBox["\"-0.8\"", -0.8, AutoDelete -> True], 
                    NumberForm[#, {
                    DirectedInfinity[1], 1}]& ], TraditionalForm], 
                    Offset[{7., 0.}, {7.5, -60.67708333333333}], {-1, 0.}, 
                    Automatic, {1, 0}], 
                    InsetBox[
                    FormBox[
                    TagBox[
                    InterpretationBox["\"-0.6\"", -0.6, AutoDelete -> True], 
                    NumberForm[#, {
                    DirectedInfinity[1], 1}]& ], TraditionalForm], 
                    Offset[{7., 0.}, {7.5, -8.593749999999996}], {-1, 0.}, 
                    Automatic, {1, 0}], 
                    InsetBox[
                    FormBox[
                    TagBox[
                    InterpretationBox["\"-0.4\"", -0.4, AutoDelete -> True], 
                    NumberForm[#, {
                    DirectedInfinity[1], 1}]& ], TraditionalForm], 
                    Offset[{7., 0.}, {7.5, 43.489583333333336`}], {-1, 0.}, 
                    Automatic, {1, 0}], 
                    InsetBox[
                    FormBox[
                    TagBox[
                    InterpretationBox["\"-0.2\"", -0.2, AutoDelete -> True], 
                    NumberForm[#, {
                    DirectedInfinity[1], 1}]& ], TraditionalForm], 
                    Offset[{7., 0.}, {7.5, 95.57291666666667}], {-1, 0.}, 
                    Automatic, {1, 0}]}, 
                    Directive[
                    AbsoluteThickness[0.2], 
                    GrayLevel[0.4]], {
                    Directive[
                    Opacity[1]], 
                    Directive[
                    Opacity[1]]}, StripOnInput -> False], 
                    
                    StyleBox[{{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}}, 
                    Directive[
                    AbsoluteThickness[0.2], 
                    GrayLevel[0.4], 
                    Opacity[0.3]], {
                    Directive[
                    Opacity[1]], 
                    Directive[
                    Opacity[1]]}, StripOnInput -> False]}, {}}, {
                    Directive[
                    Opacity[1]], 
                    Directive[
                    Opacity[1]]}, StripOnInput -> False], "GraphicsLabel", 
                  StripOnInput -> False]}, "GraphicsTicks", StripOnInput -> 
                False], 
               Directive[
                AbsoluteThickness[0.2], 
                Opacity[0.3], 
                GrayLevel[0]], StripOnInput -> False]}}, PlotRangePadding -> 
            Scaled[0.02], PlotRange -> All, Frame -> True, 
            FrameTicks -> {{False, False}, {True, False}}, FrameStyle -> 
            Opacity[0], FrameTicksStyle -> Opacity[0], 
            ImageSize -> {Automatic, 225}, BaseStyle -> {}], Alignment -> 
           Left, AppearanceElements -> None, ImageMargins -> {{5, 5}, {5, 5}},
            ImageSizeAction -> "ResizeToFit"], LineIndent -> 0, StripOnInput -> 
          False], {FontFamily -> "Arial"}, Background -> Automatic, 
         StripOnInput -> False], TraditionalForm]}, "BarLegend", 
      DisplayFunction -> (#& ), 
      InterpretationFunction :> (RowBox[{"BarLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{
                 RowBox[{"Blend", "[", 
                   RowBox[{"\"M10DefaultDensityGradient\"", ",", "#1"}], 
                   "]"}], "&"}], ",", 
               RowBox[{"{", 
                 RowBox[{
                   RowBox[{"-", "0.9991673605810143`"}], ",", 
                   RowBox[{"-", "0.1353352832366127`"}]}], "}"}]}], "}"}], 
           ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"{", "}"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}], ",", 
           RowBox[{"Charting`TickAnnotations", "\[Rule]", "None"}], ",", 
           RowBox[{"Charting`TickSide", "\[Rule]", "Right"}], ",", 
           RowBox[{"ColorFunctionScaling", "\[Rule]", "True"}]}], "]"}]& )], 
     TraditionalForm], TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"], 
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& )]], "Output",
 CellChangeTimes->{3.6811657293038473`*^9, 3.681230207163638*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Alternatively, give each code explicitly within \
\[OpenCurlyDoubleQuote]Show\[CloseCurlyDoubleQuote] :", "Subsubsection",
 CellChangeTimes->{{3.681165638546088*^9, 3.681165643982028*^9}, {
  3.68123002663472*^9, 3.681230045435833*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"DensityPlot", "[", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{"Exp", "[", 
       RowBox[{"-", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["x", "2"], "+", 
          SuperscriptBox["y", "2"]}], ")"}]}], "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", 
       RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{"PlotLegends", "\[Rule]", "Automatic"}], ",", 
     RowBox[{"MeshFunctions", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"#3", "&"}], "}"}]}], ",", 
     RowBox[{"Mesh", "\[Rule]", "10"}], ",", 
     RowBox[{"PlotPoints", "\[Rule]", "50"}], ",", "\[IndentingNewLine]", 
     RowBox[{"FrameTicksStyle", "\[Rule]", 
      RowBox[{"Directive", "[", 
       RowBox[{"\"\<Label\>\"", ",", "12"}], "]"}]}], ",", 
     RowBox[{"FrameLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Style", "[", 
         RowBox[{"\"\<x\>\"", ",", "Black", ",", "15"}], "]"}], ",", 
        RowBox[{"Style", "[", 
         RowBox[{"\"\<y\>\"", ",", "Black", ",", "15"}], "]"}]}], "}"}]}]}], 
    "]"}], ",", "\[IndentingNewLine]", 
   RowBox[{"StreamPlot", "[", 
    RowBox[{
     RowBox[{"Evaluate", "[", 
      RowBox[{"-", 
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"-", 
          RowBox[{"Exp", "[", 
           RowBox[{"-", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["x", "2"], "+", 
              SuperscriptBox["y", "2"]}], ")"}]}], "]"}]}], ",", 
         RowBox[{"{", 
          RowBox[{"{", 
           RowBox[{"x", ",", "y"}], "}"}], "}"}]}], "]"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", 
       RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
     RowBox[{"StreamScale", "\[Rule]", "Coarse"}], ",", "\[IndentingNewLine]", 
     RowBox[{"FrameTicksStyle", "\[Rule]", 
      RowBox[{"Directive", "[", 
       RowBox[{"\"\<Label\>\"", ",", "12"}], "]"}]}], ",", 
     RowBox[{"FrameLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Style", "[", 
         RowBox[{"\"\<x\>\"", ",", "Black", ",", "15"}], "]"}], ",", 
        RowBox[{"Style", "[", 
         RowBox[{"\"\<y\>\"", ",", "Black", ",", "15"}], "]"}]}], "}"}]}]}], 
    "]"}]}], "\[IndentingNewLine]", "]"}]], "Input",
 CellChangeTimes->{{3.681130959560418*^9, 3.6811309618173733`*^9}, {
  3.681131021159006*^9, 3.6811310466909103`*^9}, {3.681165618943469*^9, 
  3.681165632702433*^9}}],

Cell[BoxData[
 TemplateBox[{GraphicsBox[{
     GraphicsComplexBox[CompressedData["
1:eJx1nXm4ltP6x4uMoTiGNJHSEaGcZLbMlRyk0CFKio5kKkpHSqGZDKlDMpfQ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      "], {{{
         EdgeForm[], 
         GrayLevel[0.8], 
         GraphicsGroupBox[{
           PolygonBox[CompressedData["
1:eJxMnXeYFEXXxWd3Z2Z3e2Z2es1ZwYCYA4oEERBERAVUFAEVCQYMqAQVBQVR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            "]], 
           PolygonBox[CompressedData["
1:eJxFnWOYPMnTtXt60DPtWdu2bdu2bdu28Vvbtnf/a9u2bb/3vSef6/0QV0d2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            
            "]]}]}, {}, {}, {}, {}}, {{}, {
         Directive[{
           Opacity[0.3], 
           GrayLevel[0]}], 
         LineBox[{2527, 3710, 2525, 3709, 2526, 3730, 2555, 3729, 2556, 3739, 
          2571, 3738, 2569, 3737, 2570, 3759, 2599, 3774, 2619, 3773, 2620, 
          3790, 2645, 3789, 2646, 3807, 2673}, VertexColors -> None], 
         LineBox[{2531, 3713, 2530, 3712, 2528, 3711, 2529, 3732, 2557, 3731, 
          2558, 3742, 2574, 3741, 2572, 3740, 2573, 3761, 2600, 3760, 2601, 
          3776, 2621, 3775, 2622, 3792, 2647, 3791, 2648, 3809, 2674, 3808, 
          2675, 3821, 2695, 3820, 2696, 3840, 2725, 3855, 2747, 3854, 2748, 
          3873, 2777, 3872, 2778, 3890, 2805, 3906, 2833}, VertexColors -> 
          None], 
         LineBox[{2548, 2549, 3728, 2550, 2551, 2565, 2566, 2593, 3757, 2594, 
          2595, 2616, 2617, 2641, 2642, 2669, 2670, 2692, 2693, 2723, 2724, 
          3853, 2746, 2775, 2776, 2803, 2804, 3905, 2832, 2864}, VertexColors -> 
          None], 
         LineBox[{2552, 2553, 2554, 2567, 2568, 2596, 3758, 2597, 2598, 3772, 
          2618, 2643, 2644, 2671, 2672, 2694}, VertexColors -> None], 
         LineBox[{3382, 3381, 4320, 3415, 3441, 3442, 3469, 3470, 4372, 3497, 
          3519, 3520, 3549, 3550, 3573, 3574, 3601, 3602, 3624, 3625, 3646, 
          4468, 3647, 3648, 3673, 3674, 3687, 4497, 3688, 3689}, VertexColors -> 
          None], 
         LineBox[{3413, 4319, 3414, 4335, 3440, 4353, 3467, 4352, 3468, 4371, 
          3495, 4370, 3496, 4385, 3518, 4405, 3545, 4404, 3546, 4417, 3567, 
          4416, 3568, 4434, 3595, 4433, 3596, 4450, 3619, 4449, 3620, 4465, 
          3640, 4464, 3641, 4485, 3667, 4484, 3665, 4483, 3666, 4494, 3681, 
          4493, 3682, 4514, 3706, 4513, 3704, 4512, 3705}, VertexColors -> 
          None], 
         LineBox[{3548, 3547, 3571, 3572, 3599, 3600, 4453, 3623, 3643, 4467, 
          3644, 3645, 3671, 3672, 3685, 3686}, VertexColors -> None], 
         LineBox[{3569, 4418, 3570, 4436, 3597, 4435, 3598, 4452, 3621, 4451, 
          3622, 4466, 3642, 4488, 3670, 4487, 3668, 4486, 3669, 4496, 3683, 
          4495, 3684, 4516, 3707, 4515, 3708}, VertexColors -> None], 
         LineBox[CompressedData["
1:eJwl1FdszVEcwPFTI3FrtDUSEtXxZIsRJbGJEaONkahZ48FszZIgqNlBBS1q
S1SoFyRUYgQvJF4QK2LEXq2VGE98/vHwvZ/7+z/cm5xz/idtZt7Y3LgQwkgf
BU1CeBMLYQ/j4kMo519zGYP5GJvyKJN4hAk8zESeY3ueZQfe4EBeZ39e4wDe
ZTbvcBJfcRlfcjm/sJC1LGKdhBAqGccTTOJlJvIK0/mEPfiT3fmLQ9i0YQiD
2YwT2JWzOIwrOYsrOJtbuIblLGMZy3mS53iRt3iLz/k4+h9+YKxRCH+YzFhi
CJ3Yin3ZjqPZmzM4gkuZzWLO5VFeULW2me/xkz6ryly/cQhXmcIM9dJEZetr
9Hss1Q6dUpWu6bqe64V+6beaWdcJSSE0Z4toz6L9ivYqWn/PBzGfgzlEk6P9
ME/hVM3TTvN87uIC7uZCljGX5czjHi7iXi7mPi5hBZdyP5fxAJfzIPN5iCt4
mNOjc8BpLGYOSziGazma65jJ9cxiATOYy57MYxqnMZXTmc4cxjOTMWax1hr1
Yw378xG78SG78zJTeImprGQijzOJRfxrT/JYw1zWcjyfchyfsQdvsw2vsB5P
sm60h/xo7yt4l8W8wxKe50oe4RwWcSKXcDhz2Iuj2JZ92JId2YCt+dtZbcD3
0TvjDD/iM97kTVbzLM9od5R5NVdppvLNQ6Pv7MLOSlATfffudfX8Ae/roqqj
+yO6O7RBBVqg+cpSpm5b/zHMUE+lKkWnPW/DKiaznupqr7kOf7ijvqvU/I3b
+ZXb+IUlrGUxa1jEzyzkJ27lR27hB27me27iO27kW27g69j/e/Ifb4m2LA==

          "], VertexColors -> None], 
         LineBox[CompressedData["
1:eJwl1FtMzmEcwPG/w7wWlVPlUGFsNhSVwxwvpJTSpotsDnOYY06zOeUQbkx0
g4uYC6ZQjc2FUBib06YbG7lwGsacNzZGjPk8c/F9P/td/d/3+f+ed/CS9aXr
OkRRNMJHbUIU9YmLossczUscxYvMZBNH8gIzeIfTeZvTeIu5bOMCPuQ8PuB8
vuFmvuYWfuUBfmE1OydGUT07sYG9eZ29eIND+ZRD+Izj+JNj2c589ukWRXlM
YhmzuYwFXMpCVnAZq1jJfdzFGtawkRfYwnts5Qve40s+Ds/lB8Z1j6JfTGdc
D+fE/pzK4SzhRC7hRm3SXHM1y3mSFWzmQ7XpmPkzu8RHUUw3zIM4QRM1V/O0
UZt0UId0Vud0U7f0Uq/Urtyevid/K9l5l5lT2De8Uy03Z3AFM7mSo8IeKC+8
L3M+t3IGK1jAbSzkds7kDhZxJ4tZyWyuYhbLmcPVHMM1HMu1TA/7wrSwLxwY
9ogxFrMLZ7ErS/jJb5nMj5zCRxzNNmbxCtPYwnTWMYG1TGQV/zjbffzLtfzI
NfzEUj7hbD5lDluZxqtM5TV2ZD3fe2dH+I5HeZ/72cQtPM4VrGJZeC7ncANn
cCHHs4jDOIkpHMEYB/CHXYvxLb/bwW96prvmu7zE86znYR7SNu01L+aicD+0
2JzBkYpXd30NdzHc23Bnw/0Pd18ndFx7tFvlWqXnYU84S8VqNReF+6gxumLO
YQuz2cwspmqAGs392cB+rA/7yDNM4Wkm8xSTWMfecf//p/4B8J+cNA==
          "], 
          VertexColors -> None], 
         LineBox[CompressedData["
1:eJwl1FtojnEAx/H/sKUdjHJopjRlFxPLmU25sIO9LraUzGEbwxSFG7OD0xVR
m0RxwcohK1t2YeRwRW2zUTKaM+WwoyjcMKfPm4vv+3l/9fbW8/yf900r37ly
R0wIIdlLx5gQ8uJDeMFyPudGPuMGPmUpe1jGAdaynzXsYxV7Wc3vPMZvrONX
1jMuOYTLjGUTJ/AOx/Mu0/mG0/mWi/iTCznM5ZyYEEI+J7GYc7ma81jBCGtZ
wRpu5VEe5GmeZjOvsYnXeZv3+YDv+JI/+IkJiSEMMZHDnMqEsSFkMpVLWagi
ZdubGGEl17GOF3RRNfYt1rOHn/VFzfbopBDSNE3ZWqL1KlGl9uiETuqKWtQW
/fy4ENrZofdaYH/gQn5kr34px/7NXP5hHv8yOJsUrbYns5ipXMMpXMsRzGcM
l3MkCziKEcZyBft93yL2cTEHmMXB6DXxMWeym7P4hJm8yVTe4BSeZyLPMYmH
OeweHYpeC7dzgNs4yCI+ZyFfcA47OZtdTOVtxvASAxvZ596f4kMeYSt38yor
2cAKHuYq7mIeSzmfJVzACNOZxYnMYBwnMyX6Xr2enW+eqad8xXa2s00tarSP
8wSrWaUy7bZzuEwzlKEExeuL38RndeuRrqlVDTqrv87lDA9ov4bsfRzkXm5V
hV7bW/iKm/mSmxhRgbqi587O6HPAe8yN//+/8Q/pt5dw
          "], VertexColors -> 
          None], 
         LineBox[CompressedData["
1:eJwl00lIVVEcwOHTQtKnNizUp7QoyvRlkIsKjIoKWpgUFG2KMAhDJciNZOOi
kaBIG7RsoBbZKsuhFBpWCU1ObVKqRQNWYEEGmZpa36PFj49zuFzOvfd/5+yo
2LR7SghhUL+mhXA2EkJkegh3mcQ7TORtTmUjM/iE6exgjB+Zy/fM4Qcu4zgL
OMF1jCaHUMhMbuUSbuFSlrKIh1jGgyznaR7mKR5hPevZyHY+ZicfsYtd/MR3
HON3pqY4C2czZUYI+ZzFVczjRi5nCYtYxTOq1i7rBh7gQ/apXz80pEb7Sakh
zNU8rdBKFWu79mrINfu4X7WqU5PSZobQzHS2sFXP4veyfh6/H18wmy85n53M
YRdz2c0Ye7iAvczjKy7kfWbwHqNsYybbmcUbjPA6k3mMI857lKM8zjGW8wvL
+JUb2Mf17I+/Uz7lovgzMIsP+Nc7uslJNvAzaznAOnbzJFtYyWss4VXu5Alu
ZgXXchsXs5DZLGAaY0xglMO+dQIH+NMMvOZbvlGH2uKzzVusYbWqtEfFqrS/
hqsVU66SlBifJ7P8TfmuGWSvetSqFqXYb2Yym3hFlzXp/6rnBC9xnBf5h3Uc
Yy1HeYEjPM/fPMdh1kT+/6f/AE3Jids=
          "], VertexColors -> None], 
         LineBox[CompressedData["
1:eJwl011ozWEcwPEHx8aZeSllr7Sykb1ILqzQtnIhO7s53G3KyNtacyFFmLeN
K1IUzhk3yhXKhZrCjc687ZzdoKZc7WxeLsRsXGj4/HPx7dPze+rf/9/z/Kt2
H0r2zAohjKhkUQhD8RDqOcE6jrOWY1zDPDfxDzfyL9tYURRCgmVsZTk7uIHt
bORBJniAbexlFy/xHC+yj2mmmGKa9znIp8xxJHoP5qL34wf+5lcuXBDCDKtY
vDiEdaxkC+uY5Gbu5VEdU4f1ZXbzDh/riUb1XgPmk4wXh1CkatWoSVl7zWzR
LnXquCbNT/AHT7JX1zR7SQjXOYc3GGOKc5lmAQdYyJucx1ucz9Oc8rxTnOYZ
/uRZ/uJ+jnMfJ9jKN9zGt0zwHRuYYT2HWMpBlvARZ3zrbeZ5hWO8yizPc5gX
+ICHmeYe9jPJPm5nD7ewneu5lSvZyKVczRiXcdqZxZjnd2f5TaPKWD/jQ97j
3ei+RHdFR9RvvjO6a2pWk1apRjvsVbNQBfrirn7WWvNPbOBH5pTVCuthLudr
VvIVK/iS5XzBMj5nKTPx///NP+pLch8=
          "], VertexColors -> None], 
         LineBox[CompressedData["
1:eJwl0j1IVlEcwOFj6uQniDllqYGpLb1LlKnhZ4FofiwZlr2Zg6ZBNbUklC0J
lpuiQy1BDTpE4uJXTgr6VkiCEqjRapCbIj2Xhh/P/cO5cM49tyD+sHUgKYQw
pYqsEJLSQmjhGd7gaTbzFJuYzzss521eYicvs49N7GUzB9nHZ3zA1xziCF9y
khOc4CSnOMsFrnOeCSb4mz95xD/MSg9hn9k8ZiEzs0OIMZ/VbFO7Ks09bORT
vtGo+s3vOad5bWlbf3Wg9IwQMlSsRWvPsUTVWjPXcJ21rFNcO+Z73GU393if
v9jABOv5ldf4jdf5nWVcYim/8DyXmcfPPMkZHtnbWx7yHXejM3EnOhdX+YIr
HOI0H3GcdznGOJ+zhf2sYQcv8CZj0X5ZxIvMYTGTo30wN3rWnm+/7042uMkf
WtIn80d+0LBe6Yke65Y6VKkKdVl7hWdVpLboPtnKAqYqRVfNyaziieh9hrT/
/+0/edJazg==
          "], VertexColors -> None], 
         LineBox[CompressedData["
1:eJwl0j0s3GEcwPGH9XCOmgWJTSJpYpWQWCm9YpA0Fsu5F0aWOxK0Q70sXdx1
ZMF5WWpxiYGRwVbEwkIiUUUi+rkYvvnkl/8vT548+TeNpvqTFSGE70pEQ/gU
CWGGKeY4ziyTXOYclzjPAvPMs8Aif3OL+yzxhKe85glveMFX3jNWFcIbWxit
DeEjG9nNNsbZyTFOaVoj5hWuaV0HKumPzvVXq3Ye+U811SFsmKPcZC23GGOR
ddxmPXf4gbts4B6fnZHnEwt84S9e8gcvuMhj5njEGW4yzQ1m+JNfmWMvs+xj
gl0cYjt72MwO1rGVleV78cFbVfKKd97wVmc6NJd4oHWt6ZsWNKGMZu2kOawh
TZoHy9/5pbzDONP8zBQHmGQ/x9kXef9P/gNwCFIZ
          "], VertexColors -> None], 
         
         LineBox[CompressedData["
1:eJwl0Dsvg2EYx+H7ndtE8QU0Ya2FnYSRwcCmSSeHpP0CaH0Hh7VHEoeF1SFp
HXZlZ3SYdMf1xvDLtfzzJPeTL1WWyklEFFUfimhkIi55xQtes8cndtnnM9/Z
5wff+MNX/vKbI1kP5iLGmeMUxzjHApe5pnVta0d72teJTtXVlm0v3fAu3fGe
VT6wxkfu8pxlnrHCQ67ygEXWuMAqF7nJGW5wliuc5DzznOYwJ5hwlAO3Jelt
+nLrp17SP9GtbnSsI3VsO2yzzRZbbLLJBuuZ/3//AympOmM=
          "], VertexColors -> 
          None]}, {}, {}}}, VertexColors -> CompressedData["
1:eJztvXdcVGvSNaqoqKioiJgAE2JWzBhLUYyomHOOGDCAipgQFbMHIwZEMGJG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       "]], {{{}}, {{
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {
         Arrowheads[{{0.0375972553623346, 1.}}], 
         ArrowBox[CompressedData["
1:eJwdxQswEwAYwPGpJKVEJVLXcEloDpcrIbG5PKrLxbhb7awTJ3F5nXDSnNZr
FQqRR1YpVIYYyoe8Xcc8a2ryymzzyGNm3OTrf/e/nwEj1NN/A4FAsFkf9dam
za6tzQDhf7NQtddPn8edgfIGoSnqTsqJ4sM0LGS/TkI5xj27BQ7TUMzOMkKJ
fEsOkTcF2nQeF6Xk2S71aUxBdeR11f51xyjv9ympUqitZJmgQR963VYzJDDd
eMEHdWpeabTuFIOuvU43+vThXBpZMQlxs6846OJyfwJDbxKE4fps9OqOd0y2
uQhOttx8hIraAl80WU9AuhgKUIFWWFPfsz+wVSWuC/W2OOHLnR+HPuH8FZRm
WEv1OTsOy4mHGahUTKhvzx+DqFmdDpShVi0tWxiFQFmMDNWXvbQC51EQBWjY
oTqVvBTp4xGQkzuyUC83pYbdj2HIYFfuQcFTU1dMHIZLt0KIqF34XVPrwN8w
SGVboTnUnruky0NgRjLJQCVy/w5zyS/YFaMqQGMJtI/H23+C3CXkC1rTtS16
c9EghPGSk1AFOdIv/rQABqPdQtBT91yJ54TfYdHwhjm6Y2LNOTFpABgr8efR
cYr+3Ndj/ZDuKFtFxfNN2UsDvTAuWyxAm2kVHuWsHshSdfJG4xKkymVyN9QE
C9QU66rTA8tbNflw2hw+o29lqmFSfieY0lNvo8wSU25J/jcgNb4BNE/iYCxM
7oAUFs8a3fjWiR+R2wbUd62/0OahCHqCVjNsMXAIQhUpB+YiFxrAney3girE
xPzgsjoQpboVokGOwz77aV9A2WsbgHr56xl+aq0CgydlJLSSLM7lFFeAne9a
IRpnbJVWy+TCiFF9DlpYesTy4vYiWL3DcEBtMr0PHbTJA+km56OottzSA8JS
oZxR5oXaP1DPYLqzgOgSzEF7/16LsBiOhWOeGkw08UyhpLQuFDopFiuoWour
/LkTA3Tv26hkrmtmuDvYeKcXiDLpUeg/KJf0Dw==
          "]]}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {
         Arrowheads[{{0.036452094157275454`, 1.}}], 
         ArrowBox[CompressedData["
1:eJwBEQPu/CFib1JlAgAAADAAAAACAAAAAAAAAAAA8D+Tb+AgTv/vv4SiOs4K
su8/+95uoFqx779KOGBtIcDuP3IVPoB2v+6/C2MDmCg/7j+k4cR3gD7uv+6A
laNtuO0/Q4M8cMi37b90c4D7Hw3tP6BtV4B+DO2/xCWx60RY7D9e2NBdp1fs
v/qhwK0/mes/ITypRaaY678v8kd7c8/qP40R4XTezuq/EYuzVIL66T9jSu/t
8fnpvySW1jyeGek/zwwguBIZ6b9pE7EzxyzoP9JYc9NALOi/4AJDOf0z5z9p
Luk/fDPnv4JI8XELluY/OBOG5o2V5r+SHN8M5fPlP9ThwgZr8+W/Dn8MCopN
5T9Cmp+gE03lv/hveWn6ouQ/fDwctIei5L/UXLeG4fTjP8C4EZly9OO/JrNX
vepD4z9E/1inf0Pjv+5yWg0WkOI/CBDy3q6P4r8snL92Y9nhPw3r3D8A2eG/
wp8ydQ8h4T9z1uU+sCDhv5LuXoRWaOA/WhjZUPtn4L88EYlIcV7fP4RhbevC
Xd+/ytvGqWvr3T9WP/1axerdvyA4loR0ytw/s3gCfNTJ3L8GILtWP6vbPyAc
mIqlqtu/UYB9wrNB2j+wcf/PIUHav3/lhimA3tg/4upq7fXd2L9bwW4gsoXX
P/eY6mAvhde/o5gCy+811j8wds5VdDXWv4vi/rsf2NQ/GK4436vX1L/6LEns
2IfTP5hes1xsh9O/+XfhWxtF0j+yhz7OtUTSv4HDxwrnD9E/ZCnaM4gP0b+Y
TSOEI9LPPwUQ76Ny0c+/InKpleKizT/Bzw/aPaLNv5/0IUoLkss//ZEWCnKR
y78S1YyhnZ/JP7xWAzQPn8m/RDvnnaERxj/qpoDyJhHGvygwZu+Q9MI/fn95
kif0wr/rc3CChbPAP792Aq0os8C/OK5fJ0pcvT/CaS30plu9v3uzSEbfyLk/
0HNs80/Iub+c95thyqy2P6QLwldMrLa/GDdjN9+CsT9jQ2fhfYKxv5rOLqWK
Das/jN+mRfQMq7/yD9wyRDagP6OtqBXqNaC/VKqiuQ==
          "]]}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {
         Arrowheads[{{0.036452082721713595`, 1.}}], 
         ArrowBox[CompressedData["
1:eJwBEQPu/CFib1JlAgAAADAAAAACAAAAq6g1Ek3/778AAAAAAADwP49QfkZb
se+/6fFqgAyy7z+bx0Ewd7/uvxOnhiEjwO4/XFy6LIE+7r9kuthMKj/uPyD0
ECrJt+2/TzjWWG+47T9dpUZ7fwztv65MNOwhDe0/nT0yoKhX7L8Y3d4dR1js
P9AhRdanmOu/PLTaJ0KZ6z/ktvBa4M7qv8ycLER2z+o/wsuXxPP56b8YcScH
hfrpPzhlYnoUGem/3IJ106AZ6T9Jg1B8QizovxjSFqnJLOg/8iViyn0z57/J
XguI/zPnP5ht/X+Plea/AUuAyg2W5j+GQpmubPPlv3jScW7n8+U/vaQ1VhVN
5b8w9d9zjE3lPz2U0naJouS/J7PK2vyi5D/XKdhndPTjv4xJWP7j9OM/X36u
gIFD47+M9a457UPjP9SRVcGwj+K/KLfOjBiQ4j82ZM0pAtnhv1+Ot/dl2eE/
Xj6DLrIg4b/gYcD1ESHhPyZp5EP9Z+C/WxhAAllo4D8byeHTxl3fv6BjbTp2
Xt8/KGFRQcnq3b99XEiNcOvdP3T2cGHYydy/6q6lXXnK3D8onSFsqarbv8gB
aCJEq9s/XONinyVB2r8+lxFwuEHaP+CCLab53di/mPe8tITe2D90mdT/MoXX
vyTxZoa2hdc/g3I813c11r/I6WUI9DXWP6fFkWKv19S/pUK+7yPY1D+V0+Xc
b4fTv6lCxRHdh9M/Upw4RrlE0r/a6XpuH0XSP9wfip6LD9G/NDjfBesP0T9h
bMNWedHPvzTeSUQr0s8/nm6NZESizb/en/0a6qLNP29GcmZ4kcu/Y7XZjxKS
yz/T83FcFZ/Jv8ce3qKkn8k/bz7lqSwRxr9maBoQqBHGP4u9CtIs9MK/+vds
z5b0wj9b8hgQLbPAv8xl5nKKs8A/f8mnN65bvb9Xe19jUly9P3Epd+pVyLm/
NP+RF+bIuT+LBKA4Uay2vytXZALQrLY/ZNFmEIGCsb9VfpX64oKxP1yqyVD4
DKu/ZNc/lY8Nqz+yZi2N6zWgvzRgjDNGNqA/UBKiqA==
          "]]}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {
         Arrowheads[{{0.037597254403025374`, 1.}}], 
         ArrowBox[CompressedData["
1:eJwdxX0s1AEYwPHLJJH3S0ns9McVEc5iqe4ZGVovrHlJlLqp0bw06ro50fJ2
ldAilyE7lpAwebk6eYtC5iXujnO4dF5zx7zMMfR7+m7ffSwYUVduq5FIJEdi
lA8Z4zs7SiD9bxFqtpxZH6uVUHA1iIvOFM3wvjcpoKSN3IpeMaNZ9dEVYJsg
8UT9OJpFxg0LoPK1bEFDAvaqOvctQFd8nHEX4YZtz7zS/y+YbHM0Fwm17A7U
znPnYeaqQT/KeVSWTumdA2eyuBSlCaSb9huzoMN0MKYRvqtKL/c2mYXBe6R2
VH6tMT/OegYy1aEOXfocNlDrMA0u9spZdF2P+ro9ewrSwrQrUI3qi12Fy3JI
KHsxgZoWSCM9Lsnh4MqDJNRJJE7k8/6Av/s3LuqxyQ7hrUzCxEIdC3UsVQ+v
ODcJfk5pCaiGLDp3JOM38I+4VaA1vA6l5bAM9lSN7bIivFPMlosoMjgjFK+h
Lnk6q5TQCfBOq9xtQficrDqjdWMcUorbg9Cp0cw2zXkpHPeWy1Aq47yQ3DUK
wdOsZfSiqc7U7zIJlMSaqE0SOlOY2YEuIxC5bVSF6qpT6NZjYojo9fVHxyT5
IYxkEXDMmXGoatWIVnxSCPclOZ7okQzBlkg0CNMiqaGYMD7t2kpW6i8IXaJq
ZhPqKhb2S9wGYONozDG0r4bJKNPrhzx2awwaosg6Vd3fCxKBMAClFz3Se8jr
AfNkjg1qk1Li/u5lN+x45TJQhxzDcfrbTog326dCOR3xqZcNOsBHKM1HPT5l
BXmutMKb9u4odN2/NMy9phlcmTmxqCkFhkYDG2ErUm0ZPcRXfH38gw9FhobD
qCz2VibrQx1EiK6XoK1fuGa8J9VwUz/AFj1/YSTYVqccmN3ubDTPp35O37EQ
TidRN9HVWIFJffQrSGiIsUENKrPbEi+kAs3DQYLePdEURpexoe+9Wgp6mO30
tKU5ChzNQ0tRL6dwFs+VAT/tlM9Q+pDPmp2+L6ScrdS2J/wHyqe3/A==
          "]]}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {
         Arrowheads[{{0.024869605041888593`, 1.}}], 
         ArrowBox[CompressedData["
1:eJwBIQLe/SFib1JlAgAAACEAAAACAAAAAAAAAAAA8D9SurEegvmWP5B9aWlm
me8/5h/citivlj9+luzT/qfuP/mvdhCHApY/v3/3Lfmv7T86/OVRdVCVP3yc
qphIsuw/oqym3VGalD/gTyY14K/rPyppNULL4JM/6plqA8Co6j/RMZJ/4SOT
P5t6dwPonOk/mQa9lZRjkj9GiXy8PY7oP8TQYBtBoZE/O12ptaZ+5z+WeSin
Q96QP4D2/e4ibuY/EAEUOZwakD8QVXposlzlP2DORqKVrI4/p4uPju+M5D/W
56bUQYKNP/ymMEpQvuM/W/uxt5BZjD8MIrParp7iP6Hf5lqNvIo/SwPZAqOE
4T/gdQ7EjieJP1rh2KovdOA/fu9QgFeghz9gaZYK/dfeP1uRSwv8JIY/qv0z
yIbZ3D/PScmZfraEP6hhbhtX8No/ZCXikkdXgz9glUUEbhzZPxsklvZWB4I/
yZi5gstd1z/wReXErMaAP/zv1Wl7tdU/JmNVjhIsfz8FH6aMiSTUP1wbg41Z
7Hw/5iUq6/Wq0j9/tFOHLs56P54EYoXASNE/ki7He5HReD9YwK8JB4zNP1Qs
oJKmNnU/ipDkRcsvyT9rexcQPhVyPxIFixlkxMU/xP9b/npBbz8oBONme7zC
P0Z9RU1X52o/z43sLREYwD9gb+sMERxnPw5ET91Krrs/E9ZNPajfYz/suWvj
juOwP+WZtjFDQFg/pLkFQg==
          "]]}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {
         Arrowheads[{{0.024869605041536288`, 1.}}], 
         ArrowBox[CompressedData["
1:eJwBIQLe/SFib1JlAgAAACEAAAACAAAAyLAO/3/5lj8AAAAAAADwP4h1LmzW
r5Y/fntDYWaZ7z8Zv6oBhQKWP7pAlcv+p+4/ODtuU3NQlT8OrnEl+a/tP9vb
5u9PmpQ/PSL7j0iy7D/6koJlyeCTPwf8Uyzgr+s/l2BBtN8jkz9wO3z6v6jq
P61EI9ySY5I/cuBz+uec6T/II7RzP6GRPwYvbLM9jug/cOJ/EULekD8ga5as
pn7nP6WAhrWaGpA/v5Ty5SJu5j/O/I+/kqyOP+OrgF+yXOU/RTWPDT+CjT9a
Np6F74zkP2vwGwyOWYw/0BNOQVC+4z8NftLViryKPz6UC9KunuI/F1zOZIwn
iT+N33f6ooThP/trqUVVoIc/mFvFoi904D+VYjD0+SSGP9vMG/v8194/pHaX
pHy2hD9KVMa4htncPwKkP75FV4M/PCEjDFfw2j+06ihBVQeCP7YzMvVtHNk/
tEpTLavGgD+yi/Nzy13XP3bfCJgPLH8/eoNtW3u11T/7CgTNVux8P1Z1pn6J
JNQ/+BeY+SvOej9EYZ7d9arSP2oGxR2P0Xg/RkdVeMBI0T/lOG+LpDZ1P13f
sPEGjM0/nFOIVDwVcj92uRAwyy/JP/w/1AR4QW8/akZDCmTExT98apPCVOdq
P7pXE117vMI/tCZO4g4cZz9n7YAoERjAP6Z0BGSm32M/4Q4Y2Uquuz9RON7v
QEBYP1yGoeCO47A/yhIDgQ==
          "]]}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {
         Arrowheads[{{0.02486963011745501, 1.}}], 
         ArrowBox[CompressedData["
1:eJwBIQLe/SFib1JlAgAAACEAAAACAAAAZbcOrkcGlz8AAAAAAADwv1vNqf12
vJY/GFpF92iZ77/8c2pQxQ6WP01hGpcBqO6/BoxmulBclT9J6M8l/K/tv0uI
MSrIpZQ/lxQ1w0uy7L+Z216O2uuTP7gLGY/jr+u/8oXu5ocukz+wzXuJw6jq
v1SH4DPQbZI/e1pdsuuc6b8oSbDMEKuRP+D+lI9Bjui/0zTZCKfnkD+eB/qm
qn7nv1ZKW+iSI5A/tnSM+CZu5r9iE23WqL2OPyhGTIS2XOW/8jqdQa+SjT96
ALK184zkvyd3aEBZaYw/zVKZeFS+47/OFQ9icMuKP+yPHhmznuK/PC0OspA1
iT9aHmtIp4ThvzRLu/J/rYc/33667zN04L8e6/mNUTGGP3FinIIF2N6/bhlr
fQjChD9LpzNoj9ncv9Zi3kgOYoM/VYEl0l/w2r9Wx1PwYhGCP4/wccB2HNm/
7EbLcwbQgD/29Bgz1F3XvztY6hNzPX8/WwqKAIS11b/cggPTefx8P4qsNP+R
JNS/ug3iJCHdej+G2xgv/qrSv9f4hQlp33g/TJc2kMhI0b8GWPdTfEJ1PwrS
qhYWjM2/pAgxe1Ufcj8Aq48r2S/Jv4tX19LoUm8//fqeqm3Exb+F84CUVPZq
PwP7mVuBvMK/N+VeO+4oZz8Sq4A+FBjAv6Ascce16mM/Uxampkyuu79vS05T
wE1YPxRhNjqQ47C/1LERIg==
          "]]}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {
         Arrowheads[{{0.024869630834848153`, 1.}}], 
         ArrowBox[CompressedData["
1:eJwBIQLe/SFib1JlAgAAACEAAAACAAAAAAAAAAAA8L8LwE2R4gaXP7ySYvtp
me+/YGqGqxC9lj9yTG+iAqjuvzTXBHNaD5Y/t3wDOP2v7b/t8nYx4VyVP6z4
qdtMsuy/f8/X2VOmlD9vle2s5K/rv9h+Il9h7JM/A1POq8So6r/9AFfBCS+T
P2cxTNjsnOm/6lV1AE1ukj9KIAO4Qo7ov2I7/HyIq5E/YA+P0Kt+578ob2qX
GeiQP6X+7yEobua/PfG/TwAkkD8d7iWst1zlvz6D+Ut5vo4/Tk/m3PSM5L+n
4AHbd5ONP01mTJ5VvuO/i2RvBxpqjD84jm44tJ7iv35vfj8mzIo/Ni7GX6iE
4b8fbLLZOzaJP0NsEv40dOC/SFzzvyCuhz/CzNGKB9jevwTq807oMYY/Fk4J
cJHZ3L/LzF6XlcKEP/dfotZh8Nq/sJ6iIJJigz9mAp2+eBzZv7Nfv+rdEYI/
YTX5J9Zd17/SD7X1eNCAP8sO2OmFtdW/EFmI+0c+fz+IpFrbkyTUv6BmWn4/
/Xw/lvaA/P+q0r9QSOBz2N16P/QES03KSNG/If4Z3BLgeD9NEvdKGYzNv/Th
PKYNQ3U/Qsc6F9wvyb/kDVd+0R9yP80t2LRvxMW/Rmgyer5Tbz8y642pgrzC
v3iemNUL92o/b/9b9RQYwL9gvuAOiylnPxHVhDBNrru/AMgKJjzrYz99CZWW
kOOwv65kaVZkTlg/Up0UmQ==
          "]]}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {
         Arrowheads[{{0.025356050267021278`, 1.}}], 
         ArrowBox[CompressedData["
1:eJwBIQLe/SFib1JlAgAAACEAAAACAAAAAAAAAAAA8L+TWiwb6qbZv/0SF3cu
me+/paAMGX5U2b9TkHFBbrHuv0y0mhq3mti/e4zKrrfB7b802DwbjtrXv24H
Ir8Kyuy/WwzzGgMU17+D03VOPsvrv+qwVFbCR9a/BsPDOCnG6r8CJvkJeHbV
v/zVC37Luum/qGvgNSSg1L9hDE4eJanov9mBCtrGxNO/dCysY/rs57+Rpfv5
7y3Tvyu4fOXgLue/0iRsfIyV0r9EfDoFPBbmv3AWydCTtNG/O/EdlSH85L+e
VDywb9LQv+Lkjagg5eO/uuT5Uo/lz79MvRI5tM/iv7HSm8THKM6/aK0eTkm+
4b8nz6xfbHLMvw3GZDGTseC/lIywlZzDyr9jA1CFR1vfvyqLRcneIsm/sRmk
bj9i3b8voOEuBo7Hv54LwcvykNu/o74HRgcZxr/Q9AugntHZv8QurDZwssS/
RtWE60Ik2L+T8M4AQVrDvwCtK67fiNa/DwRwpHkQwr+SMq5xogDVv9NT99kL
1sC/jhy6v7iM07/ylJmz0le/v/VqT5giLdK/AdDgRyQkvb/FHW773+HQv9RY
xHAMEbu/k6cOie8Kzb+EhEtWCEi3v3/DivxE6ci/vkgaOi74s7+0kZmqPezF
v+ScTQ/qkrG/TuWqGv4+w79SoPMvNNuuv02+vkyG4cC/FsU9qHwQq79gOaqB
rKe9vxOoeYetxae/KgAqPA==
          "]]}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {
         Arrowheads[{{0.02535606842694775, 1.}}], 
         ArrowBox[CompressedData["
1:eJwBIQLe/SFib1JlAgAAACEAAAACAAAAob9kse+m2b8AAAAAAADwv0txuQKB
VNm/lg6KNyuZ778gwjLluZrYvy3zlw1rse6//EEsx5Da17/EJueItMHtv+Hw
pagFFNe/WKl3qQfK7L/61KnGxEfWv9+Gp0s7y+u/dvRBXnp21b9Uy9RLJsbq
v1ZPbm8moNS/tXb/qci66b+W5S76yMTTvwKJJ2Yiqei/9B+A+vEt07+beg2t
9+znvxcm1l2OldK/vg54Md4u579Sd8SWlbTRv9aKHGw5Fua/WcDFXHHS0L8K
n7IZH/zkv+Z7ZX2S5c+/wunMTB7l479kYobEyijOv4iLOv+xz+K/VDx5PW9y
zL8/AYs6R77hv0p6CFWfw8q/Yw9YRZGx4L9sR49s4SLJvz42cPtDW9+/AUDv
uAiOx7/KWkczPGLdvwyj2Y4JGca/I5JapO+Q2785dx5DcrLEv8zOwY6b0dm/
iLy91UJaw7/GEH3yPyTYv/hyt0Z7EMK/EliMz9yI1r+whRJODdbAv+Gu4q6f
ANW/rL+rR9VXv79lH3MZtozTv9QCA5AmJL2/n6k9DyAt0r/Y1Cp1DhG7v45N
QpDd4dC/jgAs5wlIt7+Mdd8p6wrNv+Qd724v+LO/iH7iEEHpyL/KCXQ965Kx
v61vOV067MW/T97Dezbbrr8v7j9Y+z7Dv/qbceB+EKu/DPr1AYThwL+RTPGo
r8Wnv4Imt7Sop72/GrMs5w==
          "]]}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {
         Arrowheads[{{0.025356200212210286`, 1.}}], 
         ArrowBox[CompressedData["
1:eJwBIQLe/SFib1JlAgAAACEAAAACAAAAAAAAAAAA8D+poLGE/qbZv35eJ+IA
me8/u3nBtm1U2b/p5q4MQbHuPzxPlHGmmti/BAIZ/4rB7T9trflDfdrXv8iv
Zbneyew/SJTxLfIT17+UHhMfE8vrP2Tfn3KxR9a/vHyfE//F6j9SaihVZ3bV
v0PKCpeiuuk/EjWL1ROg1L8oB1Wp/ajoP6M/yPO2xNO/TE4ssNLs5z+DjJJp
3y3TvyvtYga5Luc/NnfMT3uV0r/I30dNFRbmP/7Rv92CtNG/r4tTN/z75D82
Kb4eX9LQv8LZc8785OM/OkaeOW/lz79kfFkPks/iP5MQi/6oKM6/FDuVbym+
4T+gczbqT3LMvxvAmLl1seA/S30Co4LDyr9i2VhfEVvfP1qge2HHIsm/iOsa
Ig5i3T+Mth1o8Y3Hv5gL1AHCkNs/6TYpv/EYxr/NOKWObtHZP8vRYSZassS/
KHOOyBMk2D8yh8edKlrDv6q6j6+xiNY/HVdaJWMQwr+Mv7W/dQDVP9uXVWv1
1cC/CDINdY2M0z9uP+k7ple/vxwSls/4LNI/Yt1uevgjvb/IX1DPt+HQP5QJ
PJLhELu/uM6P46UKzT+/skbT30e3v2jYxB8C6cg/AeGihAj4s78N/9evBezF
P4BaNSvLkrG/8SjZqc8+wz+j/qFIAtuuvxNWyA1g4cA/6Z7r31QQq7/pDEu3
bae9P9SVRxyOxae/5MoefQ==
          "]]}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {
         Arrowheads[{{0.025356199595745504`, 1.}}], 
         ArrowBox[CompressedData["
1:eJwBIQLe/SFib1JlAgAAACEAAAACAAAAdHryGv6m2b8AAAAAAADwPzTEhENt
VNm/kgeo1ACZ7z9kJgMBpprYv03qyP5Ase4/YB0/1nza17+cQOHwisHtPyyp
OMPxE9e/gArxqt7J7D8gGBYLsUfWvwr6fBATy+s/lrj98GZ21b9EwQkF/8Xq
P5GK73QToNS/N2CXiKK66T8OjuuWtsTTv97WJZv9qOg/yf+SDt8t0787pUih
0uznP9H0uvZ6ldK/4OfX9rgu5z/IghSIgrTRv86AdT0VFuY/8ieczF7S0L90
ml8n/PvkP+wgl5xu5c+/GHmFvvzk4z80W/RoqCjOv0xbl/+Rz+I/zH9gXU9y
zL/QpOFgKb7hP87O+R6Cw8q/+ukOrHWx4D/MVxHmxiLJv62PpkYRW98/QcA2
9fCNx79saeULDmLdP/zQe1HxGMa//fuk6sGQ2z8OH+S9WbLEvw9junZu0dk/
dqpvOipaw7+kniWwEyTYPzlzHsdiEMK/vK7mlrGI1j9Abx8S9dXAv/ut/6Z1
ANU/7ihDk6VXv78Ft3JcjYzTP8HFSdv3I72/3Mk/t/gs0j/3tFL84BC7v37m
Zre34dA/fuLQTt9Ht7/G3wq2pQrNP3UJIxAI+LO/4Qsh9QHpyD8m7JPGypKx
v0ZZrowF7MU/RPeHmwHbrr8SMjeNzz7DP9RvZktUEKu/R5a79l/hwD/+QcOc
jcWnv8YLd5Jtp70/H+QptQ==
          "]]}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {
         Arrowheads[{{0.02597515841807341, 1.}}], 
         ArrowBox[CompressedData["
1:eJwBIQLe/SFib1JlAgAAACEAAAACAAAAyHh7+PlO2z8AAAAAAADwvzzJSQjL
wNo/Ij5O3GNZ7786Zfb1EPTZP8CbY+99ae6/GRcvWuof2T+OeLX35HDtv/Pq
LYfkRNg/UYXGjj5w7L/e7CzPjGPXP8ZyGU4waOu/3BwsMuN71j/yQK41uljq
v+l6K7DnjdU/0e+ERdxB6b/iGAKar/DUP3Wu7bahiei/UnPs7X5R1D+todHi
F8/nv3YU9kfNYNM/KK2Cjgy15r+FAv075m3SP6N6DrJqmOW/PgQWuLZ80T8F
HzPgy33kv7csOsLvi9A/Az6xkqdj479gmtKsD3jPPwWxT/sHcOK/q2W/sN7c
zT+1ZqdsHX/hvzop0n+IS8w/gYOZ9/iT4L8Va9h0TsLKP4n2tdcpW9+/qbei
AEo7yT8ou3+B+JDdv/qX6N/MwMc/4t91gHXV278JDKoS11LGP7pkmNSgKNq/
1hPnmGjxxD+xSed9eorYv6AP3yj8ncM/hFxSQr781r+pX9F4DFrCP/Vqyecn
gdW/7wO+iJklwT8DdUxutxfUv3T8pFijAMA/sHrb1WzA0r84AsycwMm7Pzs0
dyfvR9C/DQkx4OwMuD/hpex3qS7MvzgDYIF/DbU/tgFexWSryL8ouElG3F+y
P44plE73h8W/2ifuLgMEsD9oHY8TYcTCv6Okmnbo86s/SN1OFKJgwL+kJWJX
T2SmPxON92oZPbq/5BEgXw==
          "]]}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {
         Arrowheads[{{0.025975242335923958`, 1.}}], 
         ArrowBox[CompressedData["
1:eJwBIQLe/SFib1JlAgAAACEAAAACAAAAAAAAAAAA8L+T/I/hA0/bP3YuvDtj
We+/AB69NNTA2j9LRF5afWnuv6bz+OEZ9Nk/yUPQbeRw7b+mfLIC8x/ZP548
Sw8+cOy/ujgY6exE2D9zPgjYL2jrv5unWOeUY9c/TEkHyLlY6r9OyXP96nvW
PyZdSN/bQem/0J1pK++N1T99v4VeoYnov/Vz/+e28NQ/GL/slxfP5780R6wN
hlHUP6bxqVUMtea/fDLDH9Rg0z/2VhCKapjlv1N3BcrsbdI/ytFSx8t95L/e
xH37vHzRP+NrYIenY+O/EjbTufWL0D8qIsJ/BnDiv9DnnJAYeM8/0Hu/iRp/
4b+YFfmZ5NzNP4Sg6cP0k+C/NkeVmItLzD8ZBsvyHlvfv2xh095Owso/gPcq
KeuQ3b827UfFRzvJPzq9/uxl1du/wETLM8jAxz9JV0Y+jyjavwtoXSrQUsY/
rMUBHWeK2L8WV/6oX/HEP8nZq1Gp/Na/tnSiaPGdwz8IZb+kEYHVv8QjPiIA
WsI/aGc8FqAX1L87ZNHViyXBP+fgIqZUwNK/HTZcg5QAwD9yoffl1UfQvzYl
Lpefybs/nx0SUnYuzL9re1r0yQy4P54+v5E6q8i/V56BIWMNtT8Q8cTr1IfF
v74hFJnFX7I/9jQjYEXEwr+gBRJb8QOwP1MK2u6LYMC/ApT2zszzqz8nkz6d
9Ty6v9+zsuk4ZKY/1OQetg==
          "]]}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {
         Arrowheads[{{0.025973752172930395`, 1.}}], 
         ArrowBox[CompressedData["
1:eJwBIQLe/SFib1JlAgAAACEAAAACAAAAAAAAAAAA8D8XtTvx303bPzRE2FeL
We8/CsbBbdi/2j8m2Hzao2nuP0ZGEUgl89k/ZBdjSglx7T+NlcneBR/ZPzsn
zkRhcOw/WMWkgQdE2D/4LAFnUWjrPxXnXIC3Ytc/nij8sNlY6j/L+vHaFXvW
PykavyL6Qek/dwBkkSKN1T9lFs0+vonoP6MXpa/v79Q/NCXtFTPP5z9RwNVM
xFDUP7PbGkQlteY/wNusPBpg0z/sz5zxgJjlP/8aseM6bdI/dHzGw9995D8y
JEgXE3zRP3K4Ji65Y+M/pWql5VOL0D8aEYDtKXDiPyy51ZsEd88/1Qq3Tk9/
4T9U8q9o/9vNP2NAq8E5lOA/QISg2NJKzD8Ip3mXx1vfPxzDD7TAwco/2Pvl
9bGR3T+5V+qp4zrJP+toHxdI1ts/yUQaQIvAxz9C7iX7iSnaP0yKn3a3UsY/
2Iv5oXeL2D9AKHpNaPHEP0T+RrTM/dY/Zo2qUhiewz8SArvaRILVP3goMRRC
WsI/RJdVFeAY1D95+Q2S5SXBP9q9FmSewdI/aABBzAIBwD8N7kdZK0nQP0ob
nji9yrs/C4MTqyUxzD+JWwFWEw64P0JNeLJyrcg/n5FS1WYOtT8fJizbpInF
P/xKLgeNYLI/oQ0vJbzFwj+dh5TrhQSwP8sDgZC4YcA/DI8KBaP0qz/YAOsp
2z66P0jNnNbnZKY/H0cCZA==
          "]]}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {
         Arrowheads[{{0.025973744087387212`, 1.}}], 
         ArrowBox[CompressedData["
1:eJwBIQLe/SFib1JlAgAAACEAAAACAAAAQGSmL99N2z8AAAAAAADwP9bkarLX
v9o/LHSNWotZ7z86NcCRJPPZP/gWcNyjae4/cpLBLQUf2T+bhaVLCXHtP0Ka
K9YGRNg/Fnh4RWFw7D9q6rratmLXP16mM2dRaOs/74JvOxV71j94ENew2Vjq
P81jSfghjdU/YLZiIvpB6T/M2eoZ7+/UPzSHSz2+ieg/HluSusNQ1D/0YVAT
M8/nP5aSFbAZYNM/pjZUQCW15j+ocvNcOm3SP99Iz+yAmOU/ArJ9lhJ80T9k
Ux6+333kPxJp7mpTi9A/7xfNJ7lj4z/cAE/0A3fPP5I3Dg4qcOI/wGNXDf/b
zT+Mpz2VT3/hPzitJMXSSsw/nnPLKzqU4D/NofzkwMHKPxGFJK/IW98/OgtI
HuQ6yT+vJutPs5HdP3QJhfKLwMc/ktWVrUnW2z97nLNhuFLGP7mRJMiLKdo/
TsTTa2nxxD8jW5efeYvYP6vIoJ4ZnsM/SCxW3M791j9O8dWHQ1rCP5r/yCZH
gtU/OD5zJ+clwT8e1e9+4hjUP2iveH0EAcA/z6zK5KDB0j8qM4TrwMq7P+SJ
nvctSdA/m5VwMxcOuD/9e436KjHMP/egpfxpDrU/2oyZE3etyD90/tmPj2Cy
P6UUGmyoicU/FK4N7YcEsD9eEw8Ev8XCP6RfgSim9Ks/A4l427phwD8e96th
6mSmP1RcBt/ePro/bVMKAQ==
          "]]}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {
         Arrowheads[{{0.02666019799211857, 1.}}], 
         ArrowBox[CompressedData["
1:eJwBUQKu/SFib1JlAgAAACQAAAACAAAAAAAAAAAA8L9DEwaqVxzlv0VvpI2y
7O+/J85UvpsP5b+GuY1WkjPvv/N+1qJ6leS/bFaRsOly7r9IeY1SYRbkv/JF
r5u4qu2/Ir15zU+S478ZiOcX/9rsv4JKmxNGCeO/4hw6Jb0D7L9qIfIkRHvi
v5f0sRoHc+u/o8BPgswb4r/m0Pz+3d7qv9+oRU4OuuG/yPFWGXwN6r8iNU2c
7C/hv8b10nMyNum/Jqp1meWh4L+4jFmfJ1rov/99vZm7EOC/rSada/l457+m
EvWsW/jev/39Ja3fmOa/cvoR6qzQ3b8GU/Z5y7Xlv3XzXicQpdy/ySUO0rzP
5L+1/dtkhXXbv0V2bbWz5uO/LhmJogxC2r+EEvBfrvziv3AYyxZHDdm/kshx
DasT4r8Lzgb41dnXv2yY8r2pK+G//Dk8Rrmn1r8SgnJxqkTgv0VcawHxdtW/
8vqJWajB3r8JPv0vVErUvygFe+mbBN2/a+ha2Lkk07/EIriSL1Lbv2tbhPoh
BtK/x1NBVWOq2b8Il3mWjO7Qv8twQLjnBdi/19u6Fk6yz78vDNEvuG3Wv/Xa
BaS8l82/wlkpkufj1L/6o046IZDLv1GNf7WIatO/cq8PPzieyb+s2glwrgPS
v+51wxe+xMe/oXX+l2ux0L/4b+QpbwbGv/0jJwem686/IRbt2gdmxL8kx/4R
76XMv/XgV5BE5sK/HCXAnYnZyb/M2LZ4pw3Bv5eNd0KqTce/pg4hDze/vr+u
xHdODP7Ev7Gp/MCfsru/ARlOmA==
          "]]}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {
         Arrowheads[{{0.026660297779174728`, 1.}}], 
         ArrowBox[CompressedData["
1:eJwBUQKu/SFib1JlAgAAACQAAAACAAAAzW92dFkc5b8AAAAAAADwvz0jJw2a
D+W/JHjAR63s778Gi5QqeZXkv7z5pXaNM++/iNiYGWAW5L9NpPVA5XLuv8IL
NNpOkuO/1nevprSq7b+0JGZsRQnjv1h006f72uy/XyMv0EN74r/SmWFEugPs
v+NjESDMG+K/mFWwMQRz678z2YfeDbrhv7nPFg7b3uq/Zy9GEuwv4b9en1sS
eQ3qv7aQBvXkoeC/rcUTVy826b+ov53buhDgvxrMU24kWui/I0w0/ln43r9/
L2on9njnv9lWyQmr0N2/OmdrVtyY5r9CTGEYDqXcv5ekGBPIteW/YCz8KYN1
27+Y53Fduc/kvzH3mT4KQtq/OzB3NbDm47+8yMyNRA3Zv2ddvdeq/OK/Cr0m
T9PZ17/+TdmApxPivxnUp4K2p9a/BALLMKYr4b/qDVAo7nbVv3Z5kuemROC/
Xl/LRlFK1L9kTQ5UocHev1q9xeS2JNO/LPgA+pQE3b/eJz8CHwbSv0Dz/MAo
Utu/5543n4nu0L+kPgKpXKrZv592Zt5Fss+/Lzmuc98F2L+6hwpKspfNv3Ya
UXCubda/HoM57hSQy786t4163OPUv8Z60Tcqnsm/PuQGbnxq07+zgLCTrsTH
v0J2XyahA9K/4qa0bl4Gxr8HQjp/XbHQv1D/uzX2ZcS/ojh0qIjrzr/9m6RV
MubCv76zAwLRpcy/96vOjJYNwb8pdgbGbdnJv3vbQtsXv76/AOpXopBNx785
LjIag7K7v5uMgM/0/cS/YENCGA==
          "]]}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {
         Arrowheads[{{0.026661641981432498`, 1.}}], 
         ArrowBox[CompressedData["
1:eJwBUQKu/SFib1JlAgAAACQAAAACAAAAAAAAAAAA8D8ZCzeAHxzlvxpCbrVx
7O8/6fOF7zgP5b/V/PubWDPvPwe/psodleS/mVTa2rdy7j+4IaABCxbkv2dJ
CXKPqu0//RtylACS479A24hh39rsP9atHIP+COO/JApZqacD7D9D15/NBHvi
v/qHzzPwcus/5TCBOY0b4r+Y2tKtxd7qP0RHgxrPueG/NIViy2AN6j/ctYLf
rC/hv8ch4yUUNuk/5WflW6Wh4L8XmmNoBlroPzbm5PJ6EOC/kPXeWdV45z8Q
sYax2ffevzZF7M+4mOY/Uo5LUSrQ3b9YYBj+obXlP8lE3jaNpNy//kZj5JDP
5D9+1D5iAnXbvyH5zIKF5uM/bD1t04lB2r+g6LknfvziP/01Q9LEDNm/VIeO
IXkT4j+WdJqmVNnXvz/VSnB2K+E/PflyUDmn1r9g0u4TdkTgP+vDzM9ydtW/
s9mnKj7B3j+HktEo2EnUv5clp/owBN0/7iKrX0Ak079xiNuXxFHbPyJ1WXSr
BdK/PgJFAvmp2T8iidxmGe7Qv3GbY7RZBdg/iKiZZD6xz7/tBJL1CG3WP9Uv
9LiGls2/9HrDEBrj1D+gEwHDyI7Lv9Q561CgadM/a7/4esGcyb/XffwArwLS
P7CeE9ktw8e/Q4Pqa1mw0D/rHIrVygTGv8IMUbll6c4/l6WUaFVkxL/4hlM8
naPMPzGka4qK5MK/BcP+pGLXyT96HMmiDgzBvx/gp3KuS8c//pEURUe8vr9m
E3YjOvzEP4CvIwXvr7u/lkM64g==
          "]]}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {
         Arrowheads[{{0.026661644501766023`, 1.}}], 
         ArrowBox[CompressedData["
1:eJwBUQKu/SFib1JlAgAAACQAAAACAAAAUEMfIB8c5b8AAAAAAADwPz1uF4M4
D+W/PPdgonHs7z8CMUJjHZXkv6OOR41YM+8/fGKznwoW5L+M/QLRt3LuP6wC
azgAkuO/+EOTbY+q7T+TEWkt/gjjv+Vh+GLf2uw/L4+tfgR74r9WVzKxpwPs
Pz+8SuuMG+K/WswyOvBy6z8TaxHNzrnhv5itvbLF3uo/lCumkqwv4b+AhnbN
YA3qP5eHqg+loeC/CSYYJRQ26T/6h2GnehDgvwAaxWQGWug/jlMUHNn33r/M
3XFT1XjnPxXfdr0p0N2/5I68xriY5j9IPd+kjKTcv2rqQvKhteU/KG5N0gF1
279c8ATWkM/kP7RxwUWJQdq/vaACcoXm4z/MKB1HxAzZv8iwrxR+/OI/TXRC
HlTZ17+41X8MeRPiPzZUMcs4p9a/jQ9zWXYr4T+MyOlNcnbVv0peift1ROA/
nlaPqtdJ1L+qikL3PcHeP8KDReU/JNO/LJAyxTAE3T/3Twz+qgXSvxvN4mDE
Uds/QLvj9Bju0L94QVPK+KnZP9jDFmc9sc+/LzuWYVkF2D/K2/qjhZbNvx91
uYkIbdY/Qy8QmceOy79qbQWOGePUPyYv8z7AnMm/LqLCuZ9p0z9jTECOLMPH
v5CROViuAtI/5veTf8kExr+zubK0WLDQP5aiigtUZMS/cDHtNGTpzj9evcAq
ieTCv35Zm6mbo8w/8NNIXg0Mwb/5pbguYdfJP3IMdPFEvL6/vbQ/Ga1Lxz9s
Ikzk7K+7v76JB+Y4/MQ/VFkwLw==
          "]]}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {
         Arrowheads[{{0.026424288547255932`, 1.}}], 
         ArrowBox[CompressedData["
1:eJwBMQLO/SFib1JlAgAAACIAAAACAAAA2PrB3Iie5T8AAAAAAADwP6QuzxUZ
QeU/dZ1/47J17z9VLtR6RsjkP2r3LKDcwu4/iNei571K5D/QfoVVDQnuPz8q
O1x/yOM/pzOJA0VI7T95Jp3YikHjP+8VOKqDgOw/NszIXOC14j+oJZJJybHr
P3UMYDpoVOI/74EbH4Qh6z/SHW63ofDhP+n1TBrVjeo/SmlzYk1j4T/Rn8Nm
pLzpP/m/BxMG0uA/QKk2Spvl6D+p3+wanD3gP4q0QB3uCeg/2rwZE5RL3z9C
Nq4XNinnPxqze3BuHd4/tmXeJplJ5j/0WJebdevcPxBn94YnZ+U/Z65slKm1
2z9SOvk34YHkP3Oz+1oKfNo/et/jOcaZ4z88xpATUUHZP5orln3asOI/5kR4
4jYI2D/E8+7zIcnhP3Evsse70NY/9zfunJzi4D/dhT7D35rVP2bwJ/GU+t8/
TyLM3IVp1D9r6NLvnDbeP+7eCRyRP9M/dtfvF5d93D+3u/eAAR3SP4i9fmmD
z9o/rLiVC9cB0T+hmn/kYSzZP+fDQhCVrM8/wPyJfwBx1z/Cu5E5dWjNP+Lz
LdCpw9U/SY80jZI6yz9+vBWHyCbUP+p0RwUxJsk/EpPrVMec0j8Io+ablC7H
Pxa0WeoQKNE/DlAuSwFXxT8OuBTwH5bPP2CyOg27osM/vo5PXV4QzT9oACjc
BRXCPzFluH2yw8o/4SJm9Tyxvj9Mvrax/LbGP5jcGAE=
          "]]}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {
         Arrowheads[{{0.026424284493393884`, 1.}}], 
         ArrowBox[CompressedData["
1:eJwBMQLO/SFib1JlAgAAACIAAAACAAAAAAAAAAAA8D8aGLIxiZ7lPxQlcumy
de8/t9NUbRlB5T8lp22j3MLuP7gTrc5GyOQ/7dbAVQ0J7j+3EYQ3vkrkP2i0
awBFSO0/s83Zp3/I4z+VP26jg4DsP6pHrh+LQeM/dnjIPsmx6z+efwGf4LXi
P2dxhhWEIes/gk/qe2hU4j8twe4R1Y3qP5plQvih8OE/iAC8YKS86T8q17Ci
TWPhP2zijEab5eg/9LejUgbS4D+HZewb7gnoP1Rn1VmcPeA/9TSsGDYp5z9Y
4GSPlEvfPz4mJSqZSeY/VeM5624d3j+Qp3CMJ2flP917mxR269w/7LiOP+GB
5D/vqYkLqrXbP1Faf0PGmeM/jG0E0Ap82j8JRBWJ2rDiP/15UoZRQdk/YC4j
ASLJ4T+OgrpSNwjYP1UZqauc4uA/PYc8NbzQ1j/PCU4RlfrfPwyI2C3gmtU/
Bz1EEp023j89NkNEhmnUPygnPzyXfdw/FUMxgJE/0z8yyD6Pg8/aP5OuouEB
HdI/IiBDC2Is2T+1eJdo1wHRP1wMy8MAcdc/noDt6JWszz9DmOkvqsPVP5pv
di52aM0/IPHf/8gm1D881GSbkzrLPzhE7+PHnNI/YMRTKTImyT/UvliMESjR
P+RV3tGVLsc/eBy7UiGWzz+onp+OAlfFP2u/fdZfEM0/hLQyWbyiwz8UwXsE
tMPKP1qtMisHFcI/kl1WQv62xj9gyE6LP7G+PwRZCgE=
          "]]}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {
         Arrowheads[{{0.026424775142668437`, 1.}}], 
         ArrowBox[CompressedData["
1:eJwBMQLO/SFib1JlAgAAACIAAAACAAAA7mSg2CCf5T8AAAAAAADwv66YdGqI
QeU/XgvyhHp177+cPMXcssjkP9ogwM2kwu6/rwacLidL5D+gr6UE1gjuv+r2
+F/lyOM/sLeiKQ5I7b9LDdxw7UHjPwo5tzxNgOy/0klFYT+24j+vM+M9k7Hr
v0qJ5YXFVOI/toDofE8h67+ZMJo+/fDhP4Iau+ihjeq/VFQooqZj4T8IFx6U
c7zpv+MBx/lc0uA/yumv5Wzl6L/YnqyX8D3gP3hpQC7CCei/V704FjhM3z8t
+TSoDCnnv+SYAIANHt4/pgw0MXJJ5r/1ca2aD+zcP6w3rAkDZ+W/jkg/Zj62
2z8/ep0xv4Hkv6wctuKZfNo/YNQHqaaZ479hHLY720HZPxp8Dli9sOK/t3Xj
nLsI2D91p9QmB8nhv7EoPgY70dY/clZaFYTi4L9ONcZ3WZvVPyISP0do+t+/
tQUeBfpp1D+m9QF5dDbevw4E6MH/P9M/cM62lXJ93L9XMCSuah3SP4GcXZ1i
z9q/kIrSyToC0T/XX/aPRCzZv2sTN3Rerc8/hx5gwPBw17+UN6LuP2nNP9lT
adSmw9W/ghNq2107yz8y0eJS0SbUvxo5EhP8Jsk/8medwtqc0r9EOh5uXi/H
P3vpaaotKNG/66gRxchXxT9cTjIiaZbPv/AWcPB+o8M/2+T3+rMQzb88Fr3I
xBXCPzU5xuwQxMq/DNImfaKyvj/syUOZZbfGv+p3IRU=
          "]]}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {
         Arrowheads[{{0.026424750675731044`, 1.}}], 
         ArrowBox[CompressedData["
1:eJwBMQLO/SFib1JlAgAAACIAAAACAAAAAAAAAAAA8L+U7kQyJJ/lP4J6mUh6
de+/7FfSjItB5T8II9d/pMLuv8DXi+C1yOQ/xojaotUI7r9Qb38RKkvkP8Cr
o7ENSO2/nR6tH+jI4z/zizKsTIDsv6XlFAvwQeM/YSmHkpKx679qxLbTQbbi
P9bgYdxOIeu/FHaO8MdU4j9VMiZToY3qv10zMqH/8OE/qArjEnO86b99MJr8
qGPhP48AHHls5ei/YUaqS1/S4D8iSyfWwQnov0r0ZuDyPeA/BdiSZAwp57+b
H0iUPEzfPx3wvAFySea/Xk1/6hEe3j/tYMTtAmflv8pDMfAT7Nw/dyqpKL+B
5L/iAl6lQrbbP7hMa7KmmeO/oooFCp582j9H8spyvbDiv+w2sknfQdk/tkWI
UQfJ4b+YY+6PvwjYPwhHo06E4uC/qhC63D7R1j917DfUaPrfvx8+FTBdm9U/
DeNPHXU23r/i/t+d/WnUP0qu+U1zfdy/22X6OQNA0z8qTjVmY8/avwpzZARu
HdI/rcICZkUs2b9tJh79PQLRP/k4rHnycNe/TK8SsWWtzz+O/KVhqcPVvxaO
AvBHac0//jCjodQm1L+yC9uLZjvLP+T5Vr3enNK/oEprWQUnyT/SenQ4MijR
v1xtgi1oL8c/xK5dLXOWz79mlu/c0lfFP09mcre+EM2/OeiBPImjwz9zY40W
HMTKv1iFCCHPFcI/hUW9GXG3xr/azdXJtrK+P2A3Ibg=
          "]]}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {
         Arrowheads[{{0.021104357829842015`, 1.}}], 
         ArrowBox[CompressedData["
1:eJwBwQE+/iFib1JlAgAAABsAAAACAAAAAAAAAAAA8L+bEVSUEzvHv5zQ6GAL
Te+/0VR3YSm5xr9ZnNLYrw/uv28Ut7TF0sW/I/BjTKvG7L/O0xQG6+PEvx1S
TY80Buy/dFF9XTJYxL9AljAOhULrv/1aX/UiysO/4rlFaMvz6b8Q3waTI9fC
v/PfhjkOn+i/psQjjMbfwb9weJ8Em0rnv/BsZTmf6MC/BF5W81f05b8Wb81P
TuC/v0XLhwTWMuW/MqyXDFnHvr+If80BF3Tkvwis5i5msr2/AB3ow3K2479c
kzfgDZ+8v91FmCNB+OK/8oYHSuiKu7/y5Mebl+Thv2NRUsSq+rm/Gmc34MrW
4L+OqZZJ8HK4v/ruICLZpN+/IBNtXef4tr9wDzVHmKzdv+EM+NPVirW/aQGk
tI25279fGMrtjCC0vz8Wl+Qj3Nm/YnQNgffFsr/3TQ7XWhTYv+wgwo0Ve7G/
jqgJjDJi1r/4HegT5z+wvwg9NkB4xtS/I40CJAIqrr9qIkEw+UHTv4LrHg3x
9au/tFgqXLXU0b8KVyXjmuOpv+bf8cOsftC/vM8Vpv/yp78KlO/FlCbMv4De
9Umzb6S/bkr0ZQ==
          "]]}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {
         Arrowheads[{{0.021104367205979687`, 1.}}], 
         ArrowBox[CompressedData["
1:eJwBwQE+/iFib1JlAgAAABsAAAACAAAAM6l2viI7x78AAAAAAADwv9Sb1c81
uca/srjREQhN77+cszit0dLFv/FAi7asD+6/oKF4h/bjxL+jd85cqMbsv0AA
doA9WMS/boNLmzEG7L/4cg+5LcrDv1nDqxaCQuu/7GHO0i3Xwr+uqo2VyPPp
vynhjUjQ38G/lERIkAuf6L9onyt1qOjAv6zKaoiYSue/1sQQyl/gv79t1Bqo
VfTlv2EHP4lqx76/CtlCOdQy5b+yCFitd7K9v2abR7QVdOS/VVY1YB+fvL9D
Qz7zcbbjv859sMv5iru/Xvg70ED44r9Mrmsyu/q5vyyzkz6X5OG/IYZuqv9y
uL9tUq95ytbgvzjtb7v1+La/3p50RNik37+Y6zI444q1vy6uoVqXrN2/myLj
cJkgtL8anrbXjLnbv7ym6ywDxrK/Zk7VFiPc2b/+d0xsIHuxvxm//RdaFNi/
YJYFL/E/sL8u8C/bMWLWv9IfxucUKq6/hTT5nHfG1L845WFzAvarv/be5pn4
QdO/+HzeAKvjqb+F7/jRtNTRvxDnO5AO86e/MWYvRax+0L/DPBgHwG+kvzwY
yPGTJsy/Acv7xQ==
          "]]}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {
         Arrowheads[{{0.021104519342325274`, 1.}}], 
         ArrowBox[CompressedData["
1:eJwBwQE+/iFib1JlAgAAABsAAAACAAAAAAAAAAAA8D96qSHrCTzHv0EGXU7K
TO8/mos7F+u5xr+SxIo0cg/uPxVuH12A08W/MqQWjXHG7D8VV5CdnuTEvziL
aGH6Bew/y5QR299YxL9ZERCESkLrP7Kfk03KysO/ct3uhJPz6T9mfFbHwtfC
v2VsGlvZnug/fWObsl3gwb/8utZ1aUrnP7jof4ou6cC/8nRiBSr05T+qtUmh
XeG/v7LVlm6yMuU/2BwhwGvIvr8aFkqW/XPkP5Jezyx8s72/xnyWcGO24z+E
xAYfJ6C8v09QlvE7+OI/Wph5zgSMu78csfd6keThP0zC1Vm1+7m/2JCY3MPW
4D90gtpb6XO4v8w2gYPJpN8/CpA3n8/5tr/3LgU4h6zdP1IDXeCti7W/HuFG
rH252z8wrFi3ViG0v6Klg90U3Nk/VEE/qrPGsr+BfLvLTBTYP8DCELnEe7G/
umXudiVi1j9yMM3jiUCwvz9nERlsxtQ/wtxRWjArrr/8hhns7UHTPwLBsC8J
96u/8cQG8KrU0T+kDbdHnuSpvx8h2SSjftA/psJkou/zp78U0cR1hCbMP/wB
sCaAcKS/WuTr+Q==
          "]]}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {
         Arrowheads[{{0.021104519367808793`, 1.}}], 
         ArrowBox[CompressedData["
1:eJwBwQE+/iFib1JlAgAAABsAAAACAAAAIPK9tAk8x78AAAAAAADwP6Jaqcbq
uca/+nSqKMpM7z8f9hEQgNPFv67cyRByD+4/Kq1VVJ7kxL9KpZdrccbsPwZf
rpLfWMS/Nr5PP/oF7D9BQxYGysrDvyy/aWFKQus/3LCzgsLXwr9TMSdjk/Pp
P4cMC3Fd4MG/s0xwOtme6D+xvS1MLunAv/4Kh1ZpSuc/w0OBK13hv7+kw6rn
KfTlP+58dVhryL6/iSfSWLIy5T8G0QXTe7O9v8JsVoj9c+Q/f8kH0yagvL9Q
P2ZqY7bjP8bvUJAEjLu/M0sw8zv44j9nt5Idtfu5vxbHWnuR5OE/PIF9Ielz
uL+XxdLbw9bgP5qZxGbP+ba/5onVf8mk3z8O59aprYu1v9bgYzKHrN0/mGoV
hFYhtL+TMZOmfbnbP/RoInqzxrK/HQnJ1xTc2T8l4v2LxHuxv3dnBcZMFNg/
KtanuYlAsL+jTEhxJWLWPxzHogswK66/nx2EE2zG1D+5UVfmCPerv24/q+bt
QdM/LExtA57kqb8Ssr3qqtTRP3S25GLv86e/inW7H6N+0D+gcPXvf3Ckv25K
SmyEJsw/qP3q+Q==
          "]]}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {
         Arrowheads[{{0.02156067589431821, 1.}}], 
         ArrowBox[CompressedData["
1:eJwBoQFe/iFib1JlAgAAABkAAAACAAAADtXv6ia4yz8AAAAAAADwvzeWF05V
n8o/YoZpldC77r8xh1FfgnfJP1jtVaNOZu2/0ggMVOzUyD+dAAj3nKrsv/lD
7OlWL8g/OZvianXr67+obKlXkAzHP6//ImnHm+q/2fs+gGnjxT9Y95EQvUTp
vzBGvdgyucQ/IrUl7njs57/QhMnkJozDPxQojH3vkOa/KF+HPseIwj+xfA7Y
gWXlv0SbgcXMh8E/Tp/wENg85L8qObh5N4nAP+6PMijyFuO/qnFWtg4avz+P
TtQd0PPhv2TPTTTTK70/0KIr8ojW4L9XJu/NFk27P6KoHEtnhN+/hHY6g9l9
uT8jxvhvoG3dv+i/L1Qbvrc/JJ7rUr1o279iuPtnxhC2PwrRUFUbedm/zhXL
5cR4tD85/4PYF6LXvynYnc0W9rI/sSiF3LLj1b91/3MfvIixP3FNVGHsPdS/
H4ONscytrz91TrOAF0nSvwg0Vqwujqw/GVvelIp70L+iEUIvnrKpP7rmqjuL
qs2/7BtROhsbpz9+LjE3kazKv6QV1io=
          "]]}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {
         Arrowheads[{{0.021560682157148306`, 1.}}], 
         ArrowBox[CompressedData["
1:eJwBoQFe/iFib1JlAgAAABkAAAACAAAAAAAAAAAA8L+hraDXObjLP5NmHLvQ
u+6/Zdu3m2efyj/YPybCTmbtv9rrA92Td8k/kbmjIJ2q7L9y9Bds/dTIPy9q
HZ916+u/N20fmmcvyD90LRCux5vqv01yzk+gDMc/MaIPZb1E6b8QYAC7eOPF
PwpTEFB57Oe/yymHU0G5xD/HERbr75Dmv7vTHJw0jMM/2k2PRIJl5b+xnuBD
1IjCP6CC/XrYPOS/fx9JGdmHwT8YsGCO8hbjvyRWVhxDicA/Q9a4ftDz4b9C
hRCaJBq/P7zpvUyJ1uC/4RCou+crvT80vk/yZ4Tfvw+WXQIqTbs/wWztB6Ft
3b/UFDFu6325Px7fVNq9aNu/LY0i/yu+tz/N2rnLG3nZv65aF9/VELY/TiVQ
Phii17/m2PQ303i0P6S+FzKz49W/2we7CST2sj/QphCn7D3Uv4vnaVTIiLE/
Lwl+4hdJ0r8aQrT74q2vP1KcWQ2Le9C/sMDh+0KOrD97wEZPjKrNv9pKXKmw
sqk/3qm2YpKsyr+Y4CMELBunP1hT1eQ=
          "]]}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {
         Arrowheads[{{0.021560482966225796`, 1.}}], 
         ArrowBox[CompressedData["
1:eJwBoQFe/iFib1JlAgAAABkAAAACAAAAAAAAAAAA8D866mdaWLbLP1kMiM7a
u+4/KE0n5qGdyj+4KJ9wWGbtP6FaieLhdck/UPvG8qWq7D83FfK6VdPIP/pu
g5V96+s/35fjZsotyD86frCVzZvqP2g8Mg8VC8c/S1X8QsFE6T8fySjg/+HF
P5DtjUN77Oc/ZLz5C9u3xD+Snq0K8JDmP2xBlCzhisM/iaC84oFl5T9u4KD9
kYfCP9OfU7DXPOQ/82X/56eGwT9wnHJz8RbjP/rRr+siiMA/YJYZLM/z4T8H
SWQRBhi/P2ZpdNeH1uA/rnbWf+opvT+F4l3lZITfP3TofyRNS7s/7luS+51t
3T9cnmD/LXy5PwY/hvG6aNs/ZJh4EI28tz9FeeQdGXnZP9cqD0VUD7Y/IvhX
1xWi1z8BqmuKbXe0P5674B2x49U/4RWO4Nj0sj+5w37x6j3UP3ZudkeWh7E/
TZG7yBNJ0j81fAadtauvP496bvuEe9A/2rZzdUiMrD/7/i4TfarNP9yMNBjl
sKk/NkBt5oCsyj87/kiFixmnP/uX0sE=
          "]]}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {
         Arrowheads[{{0.021560482999463195`, 1.}}], 
         ArrowBox[CompressedData["
1:eJwBoQFe/iFib1JlAgAAABkAAAACAAAAZP8Xj1e2yz8AAAAAAADwP/jfxgqh
nco/eiKxstq77j+K56gR4XXJP0+eHldYZu0/sHf87VTTyD+DY2vYparsP4is
9p3JLcg/9+FVen3r6z8aiaZOFAvHP5xKkXrNm+o/vqZeKP/hxT/EuyQowUTp
PybtMl3at8Q/sd9AKXvs5z/EuRyH4IrDP/rSKvHvkOY/2KChYJGHwj930GzK
gWXlP5jvhlOnhsE/6tRbmdc85D8EpsxfIojAP1bg913xFuM/NYjlCgUYvz+5
8kAYz/PhP0h8eYrpKb0/CP5SxYfW4D/PENw/TEu7P3Lok8RkhN8/ykUNKy18
uT+YqkvenW3dPzUbDUyMvLc/fELN17po2z8fTvWPUw+2P8unpwcZedk/kpvf
42x3tD8q0mnEFaLXP5ADzEfY9LI/nMETDrHj1T8Uhrq7lYexPxp2peTqPdQ/
DqMSm7Srrz/B6vO5E0nSP1xQ0odHjKw/y0go64R70D8UFLQ95LCpP3IghfB8
qs0/Nu63vIoZpz8VgoXCgKzKPwje0pI=
          "]]}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {
         Arrowheads[{{0.023655404082934466`, 1.}}], 
         ArrowBox[CompressedData["
1:eJwBEQLu/SFib1JlAgAAACAAAAACAAAAAAAAAAAA8L/IhydGphbqvwr5py1V
VO+/tejQ+bGK6b+Y1/g2H0/uv7tsBD+9tei/nuxsXIPj7b8MFihzAl7ovyDR
m8rwdO2/UDJfGd0D6L+lyKyxd9nsv8nMAqochee/cfoAynE47L+BSQjl1QHn
v44nrnB+keu/SDOrAbp55r/5ZALcveTqvzKx10Lj7OW/HsOajRk46r8Hwx6R
I2Dlv/9yYpDghem/z5AkHtfO5L+idFnkEs7ov48a6en9OOS/BMh/ibAQ6L9F
YGz0l57jv7AtuCxBTue/j3Qu2hMA478yZuV6TIfmvxBqrzfgXeK/inEHdNK7
5b/EQO8M/bfhv7VPHhjT6+S/rPjtWWoO4b/aEUW1oBjkvyodle07YuC/GMmW
mY1D478/c5wtC2nfv3J1E8WZbOK/F5wyq44K3r/mFrs3xZPhv9y07FMCqdy/
Z66KTEn+4L/xkOVZRbXbvy0TQUj6aOC/aZilltHB2r9urMZRdKjfv/6mrNFG
z9m/EBHt2NWA3r9mmHrSRN7Yv0x2/yHdW92/YkiPYGvv178i/gcpTjrcv6aS
akNaA9e/mMoQ6uwc27/rUoxCsRrWv7L9I2F9BNq/7mR0JRA21b8srypLVePX
v5ueX7ededO/HJbKyIjZ1b/mD4s5NtDRv+EY/F1Z69O/7XdY6lE90L+gwCUe

          "]]}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {
         Arrowheads[{{0.023655466666256873`, 1.}}], 
         ArrowBox[CompressedData["
1:eJwBEQLu/SFib1JlAgAAACAAAAACAAAAXy+FXqcW6r8AAAAAAADwv/MnB9Ov
ium/ZrBfOVFU778un+6+urXovxm1H+AaT+6/4wke3P9d6L9kdvDtfuPtvy/P
zmraA+i/0K3oQ+x07b+D7DrlGYXnv7A6QBZz2ey/Nhr2CdMB579Kkf8ZbTjs
v6aD3RC3eea/bMEGrXmR67+yb6c84Ozlv3xwYAW55Oq/ZK35dSBg5b8FrIOk
FDjqv/cQP+/TzuS/a3+MltuF6b9xmneo+jjkv7DqetsNzui/z0mjoZSe47/U
7U5zqxDovyYODngQAOO/Y6XfCzxO57+J1gPJ3F3iv+otBFNHh+a/96KElPm3
4b9mh7xIzbvlv3FzkNpmDuG/2rEI7c3r5L8i/cZqOGLgv3v71I6bGOS/YuqP
KQRp3797sg19iEPjv0C3JrGHCt6/3dayt5Rs4r/gYFJs+6jcv6FoxD7Ak+G/
6wBhfz6127/V3eBhRP7gv84Lv8zKwdq/XNAMbvVo4L+lAAscQM/Zv+78t8Jq
qN+/iV7jND7e2L/DTMRzzIDev5mk5t5k79e/swxm69Nb3b/xUbPhUwPXvzm5
xCVFOty/q+XnBKsa1r/Qzgcf5Bzbv+TeIhAKNtW/88lW03QE2r8xP9/7l3nT
vwBna0JN49e/UPba3zDQ0b+yMe1NgdnVv6Pr8fdMPdC/yKOOdlLr0782MTDl

          "]]}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {
         Arrowheads[{{0.023655692526438094`, 1.}}], 
         ArrowBox[CompressedData["
1:eJwBEQLu/SFib1JlAgAAACAAAAACAAAAAAAAAAAA8D+arBiAPRbqv3B5OcBA
VO8/yXO3vjqK6b8yt3jLAE/uP57dyjVBtei/hY22NmLj7T9lvRGRhV3ov7iw
/NjMdO0/0eSyWV8D6L/SVLLXUNnsP6jMkoiehOe/o1HX/kc47D+QRs5sVwHn
vzIi/rpRkes/kF99Szt55r8mSEs9juTqP6do7WJk7OW/UaHkEOc36j8RrBmQ
pF/lv062PE2rhek/OVR/IVjO5L8fh1Py2s3oPx5hHhd/OOS/whMpAHYQ6D/A
0vZwGZ7jv6ZJnDgETuc/Tvzn2pX/4r86FoxdDYfmP/Uw0QBjXeK/fXn4bpG7
5T+2cLLigLfhv3Fz4WyQ6+Q/kbuLgO8N4b+m61q5XBjkP94AO7XCYeC/rsl4
tkhD4z/uXzy3HGjfv4sNO2RUbOI/tZFq56QJ3r86t6HCf5PhPxSXAPsdqNy/
Stvf1QP+4D+PykrRZLTbv48Zdv20aOA/PmhNJ/XA2r8uENRy6qffP1A8SsVu
ztm/2nmCE02A3j/zEoNzcd3YvzqcAt1VW90/Vrg5+pzu179no1/PyDncP6X4
ryGRAte/druk6mkc2z8RoCey7RnWv4MQ3S79A9o/yHric1I11b+g0iyx2+LX
P3HdDl/seNO/bfJFsBbZ1T9/eBqskc/Rv4pDqXTv6tM/F0v9Wro80L/owRkK

          "]]}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {
         Arrowheads[{{0.02365569095905574, 1.}}], 
         ArrowBox[CompressedData["
1:eJwBEQLu/SFib1JlAgAAACAAAAACAAAAioZ66TwW6r8AAAAAAADwP/Lukz06
ium/Ad6y1kBU7z8KqLWyQLXov086q9kAT+4/moP+DYVd6L+1In5CYuPtPzCT
otZeA+i/8VxJ4sx07T/yAxcGnoTnv658M95Q2ew/wEr26lYB579to38CSDjs
PwO6Yso6eea//LfKu1GR6z9CNqbiY+zlv7/CNTuO5Oo/++CrEKRf5b/Z8fQL
5zfqP6T1DKNXzuS/1198RauF6T8+dMmZfjjkv7gMzOfazeg/x1zh9Bie4798
+OPydRDoPxo0PmCV/+K/mKGyKARO5z8Pf8mHYl3iv4CGJksNh+Y/pj2Da4C3
4b82pz9akbvlP99vawvvDeG/uAP+VZDr5D+pzGZCwmHgv1B2haBcGOQ/4xW0
1hto379G2fmbSEPjP3RVigykCd6/myxbSFRs4j8DWFAmHajcv01wqaV/k+E/
Qlz0AGS0279LpTO4A/7gP7s6hFv0wNq/LoU237Ro4D8MQEH+bc7ZvzYbczXq
p98/4bhssXDd2L90eIjVTIDeP97xRz2c7te/Xx28nlVb3T+qNxRqkALXv0gF
HZHIOdw/6NYSAO0Z1r92K7qsaRzbP0EchcdRNdW/Ooui8fwD2j8GvHm+63jT
v9vPGnbb4tc/a6x+F5HP0b/MjB94FtnVP8iyWdK5PNC/mIoMQO/q0z/irxXB

          "]]}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {
         Arrowheads[{{0.02348933307310581, 1.}}], 
         ArrowBox[CompressedData["
1:eJwBMQLO/SFib1JlAgAAACIAAAACAAAAXZeqm/1o6j8AAAAAAADwvybsyv3A
AOo/eK9nZ7OB779kpJHx3THpPwTOjV4Gh+6/4Xz7VoPb6D+ew+LAZB7uvySe
ONfGgug/KOJmJ+Cy7b//Tt207gToP14m3UFlGu2/Ne0KdYeC5z/7zb43ZHzs
v0zHxWIy++Y/3tlySGrY679xGLcPD2/mP79JLLSdLuu/PIDVlPji5T8lxgmw
4ITqv2CMhIktUuU/kr80J3DV6b/gPMTtrbzkPwk2rRlMIOm/uZGUwXki5D+F
KXOHdGXov4OG7vbsg+M/fSJ42Fil57/VFst/Y+HiP1+prXRo4Oa/sEIqXN06
4j8wvhNcoxbmvxMKDIxakOE/62CqjglI5b+HAD4t3+LgP3ykbTjWdeS/lLmN
XW8z4D/Im1mFRKHjv3Rq9jkWBN8/0UZudVTK4r/y5gzXZJ3dP5ilqwgG8eG/
7Z28AtSl3D+eCluNClvhvybOK8M0rts/l4jGVQbF4L+P+hl6JbfaP07osVVZ
L+C/HKZGiUTB2T8Y5cEBxzTfv79TcVIwzdg/OuAulgkN3r9qhlk3h9vXP5ZT
MlA66Ny/EMG+mefs1j+/0FMXGcfbv6SGYNvvAdY/Teka02Wq2r/CerqU6xrV
P0+xGBx8ktm/ABBH5Qw41D82FqatmH/Yv8f/Q/nLWdM/qG92I01y1798A+/8
oIDSP0oVPRkra9a/YCxGhG3f0D/Bo3rzqXHUv4TnJjo=
          "]]}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {
         Arrowheads[{{0.023489330862793003`, 1.}}], 
         ArrowBox[CompressedData["
1:eJwBMQLO/SFib1JlAgAAACIAAAACAAAAAAAAAAAA8L+s6Ivp/2jqP3fSzKuz
ge+/aqoGe8MA6j+Ba6XPBofuv7kppIHgMek/4wfXP2Ue7r86BvbqhdvoP16w
lrTgsu2/LkU0b8mC6D8v2ordZRrtv/EF1E3xBOg/2CEd4mR87L8JvsAOioLn
PyQmbgFr2Ou/CGK8/DT75j/TXMh7ni7rvxdLhqkRb+Y/TTsThuGE6r81/1Mu
++LlP7ybSAtx1em/f473ITBS5T8jfmgLTSDpv/n4cISwvOQ/geJyhnVl6L+f
PsBVfCLkP+1X9ONZpee/wAqTh++D4z99bXmLaeDmv6gIlwtm4eI/MyMCfaQW
5r9XOMzh3zriPw15jrgKSOW/zZkyCl2Q4T+a47Np13Xkv/7AWaLh4uA/aNcH
vEWh47/gQdHHcTPgP3ZUiq9VyuK/5Dgy9RoE3z/GWjtEB/Hhv2ihYnVpnd0/
PPqpyAtb4b+C9A2L2KXcPxAK948HxeC/O54JNDmu2z8TmtyNWi/gv6PmEtIp
t9o/M3QpbMk037/YFefGSMHZP+7zsvgLDd6/8HNDdDTN2D/40smoPOjcvwBJ
5TuL29c/+DDiYxvH278f3Yl/6+zWP5YtcBFoqtq/Z3juoPMB1j/tTG1KfpLZ
v6GI6zjvGtU/nQrBypp/2L8vh3VnEDjUP5h5RC5Pcte/kc3zWM9Z0z/GrNAQ
LWvWvz+1zTmkgNI/kKtnwqtx1L+CzjF7cN/QP9j3Kkw=
          "]]}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {
         Arrowheads[{{0.023488913126545333`, 1.}}], 
         ArrowBox[CompressedData["
1:eJwBMQLO/SFib1JlAgAAACIAAAACAAAAUbkiBlRo6j8AAAAAAADwPztWdjMq
AOo/dixuAseB7z+5jzL/RDHpPyQ+1hIRh+4/DkQvM+ra6D+MWVqZbB7uP2uE
EIEtgug/prViEOWy7T8h8LPmVQToP93+cfxmGu0/TFjPP++B5z8Ib/i0Ynzs
P5qpnuOa+uY/nRRKhWXY6z8llbhfeG7mPx9AoKmVLus/xXc7u2Li5T+UeEJn
1YTqP8ri2q2YUeU/11CBq2HV6T811pY3GrzkP+3IXHY6IOk/BFJvWOch5D/R
4NTHX2XoPzEHOA9cg+M/Jig6GkGl5z+wpsRa1ODiP4Yu3edN4OY/gzAVO1A6
4j/2870whhbmP6ikKbDPj+E/cXjc9OlH5T+kp3XhVuLgP2fyzXO0deQ/+d1s
9uky4D9FmCftIKHjP1CPHt4RA98/CGrpYC/K4j9fybmWZ5zdP7RnE8/f8OE/
OrZIDtyk3D+r9hvG41rhP3Tq5ltCrds/69g6KN/E4D+P9N3gOLbaP2CPVOsx
L+A/CmN3/l3A2T/qNZsKeDTfP2jE/BVQzNg/LvkU2LoM3j8pp7eIrdrXP2Bq
3yrs59w/z5nxtxTs1j9ci8Puy8bbP9oq9AQkAdY/9F2KDxqq2j9rcVT3JhrV
PypelhMyktk/6F+XmE831D9UfCqdUH/YP7dN7gwWWdM/02jgQQdy1z9Akop4
8n/SPwXUUZfnatY/JH1Yxs3e0D8B6M2qa3HUP5htGJU=
          "]]}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {
         Arrowheads[{{0.023488914248284566`, 1.}}], 
         ArrowBox[CompressedData["
1:eJwBMQLO/SFib1JlAgAAACIAAAACAAAAAAAAAAAA8D9bXpNUVGjqP8wHGfPG
ge8/IWkKdCoA6j9K6P0GEYfuP3bbQEBFMek/5IKmjmwe7j+Aby506troPzZA
2wblsu0/Tf3/wS2C6D9/BDv0ZhrtP+xJQydWBOg/nekYrmJ87D81yvZ/74Hn
PxrNxH9l2Os/QNxRI5v65j8eZXmllS7rPwe27J54buY/TbN2ZNWE6j+66+35
YuLlP1YiDqph1ek//KD765hR5T88sj92OiDpP9PVFXUavOQ//WILyV9l6D87
ijyV5yHkPw74uhxBpec/YuQ+S1yD4z/dNJjrTeDmP3IK7JXU4OI/bxmjNYYW
5j9u/EN1UDriP8Gl2/rpR+U/VLpG6c+P4T8GlM96tHXkPxHAZBlX4uA/bJ4M
9SCh4z+PiQ4t6jLgP/bEkmkvyuI/ny2ISBID3z+jB2LY3/DhP6PPCv5nnN0/
gK7Fz+Na4T+1yFBz3KTcPxdYMTLfxOA/0z6OvkKt2z+gpIj1MS/gPxUkDUE5
tto/mmheH3g03z+HahdcXsDZP7BOEe26DN4/QQT3cFDM2D/nO/E/7OfcP1Lj
9eCt2tc/qXDFA8zG2z/I+V0NFezWP2MtVSQaqto/uzl5VyQB1j9pcwkoMpLZ
Pzv84kYnGtU/V0QusVB/2D/mQyjlTzfUPwNhX1UHctc/HIF9VhZZ0z9Eijiq
52rWPz4kF7/yf9I/3gVSvGtx1D/LXekGzt7QPxU1EYs=
          "]]}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {
         Arrowheads[{{0.019277770175015512`, 1.}}], 
         ArrowBox[CompressedData["
1:eJwBsQFO/iFib1JlAgAAABoAAAACAAAAAAAAAAAA8L//r3V0xsHgv+yKA8Jb
1++/cHLVOn6s4L9mta/RmcDuv86OM0CFGuC/XIdPHqgs7r8YU38OGZrfv4Mn
xc39lO2/Edtd7kH73r/QTR4JuMDsv/xvOlfxHN6/Kph0YQHm679m+33b4Tfd
v4Ji9imZBeu/bE5329tM3L+I4z6cPx/qv7B4YYycW9u/OkaerMk56b/BtQyg
S2vav/Ii8qIpUOi/rO8qKp522b+yeTp/X2Lnv3AmvCqUfdi/eUp3QWtw5r8P
WsChLYDXvy7CinMffOW/y51TK1OA1r+9DVefTofkv+oEkmPtf9W/Iy3cxPiR
479rj3tK/H7Uv18gGuQdnOK/Tj0Q4H99078mveYEBKjhvxCVF7XZfdK/K9kX
L/G34L8uHVlaa4LRv9zoWsXKl9+/qNXUzzSL0L/dHU8/wcfdv/18FStsMM+/
Kwstfd5Y3L9HFgkTLrDNv0qh/SoD8dq/cOrUi0w3zL90G2CifpHZv2vDgMwm
x8q/3rTzPKA72L8qaxQMHGHJv7+oV1S38Na/lquXgYsGyL8i1ehM
          "]]}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {
         Arrowheads[{{0.01927783573049279, 1.}}], 
         ArrowBox[CompressedData["
1:eJwBsQFO/iFib1JlAgAAABoAAAACAAAACrvRysjB4L8AAAAAAADwv2D5let+
rOC/YQWPoljX778QFTbShRrgv2wdaJ6WwO6/9emWExqa379B8CLipCzuv/HX
JtRC+96/YLDbiPqU7b8ebzoM8hzev+DdO7O0wOy/pGUoX+I33b+98Pj6/eXr
v/ZfYC7cTNy/Slw6tJUF679EJ72unFvbv21PSBg8H+q/WbSPkktr2r++7fka
xjnpv/qZcu6ddtm/AWq/BSZQ6L8k2GXCk33YvzXEmNhbYue/225pDi2A179d
/IWTZ3Dmv4ONlG9SgNa/XfAXwRt85b+EY/6C7H/Vvxt+3+tKh+S/3vCmSPt+
1L+YpdwT9ZHjv5A1jsB+fdO/1GYPORqc4r9y7Ox72H3Sv4R/aGMAqOG/YdD7
C2qC0b9erdia7bfgv1nhunAzi9C/xuC/vsOX37+5PlRUaTDPvySR/GG6x92/
1gdpvSqwzb94p+NZ11jcv/4j9b9IN8y/ksz9yPvw2r9vTv2TIsfKvx75rAl3
kdm/YkKGcRdhyb/GJVN2mDvYvxq7lJCGBsi/OktSaa/w1r8hGvcO
          "]]}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {
         Arrowheads[{{0.019278788679977753`, 1.}}], 
         ArrowBox[CompressedData["
1:eJwBsQFO/iFib1JlAgAAABoAAAACAAAAAAAAAAAA8D/Y3GZ8s8Hgv4v+Ajc2
1+8/3tgcsles4L9ZZ/K1ccDuP7Y10wReGuC/NCb3w34s7j9g/nf5yZnfv0nl
qTTTlO0/vZVPP/L63r+VZjsqi8DsP27KikKgHN6/s/GUPNLl6z+cM5hojzfd
v4CVdNRnBes/v4h4J4hM3L9dokUkDB/qP7GMK61HW9u/vUMeH5Q56T8fJB+i
9WravzB39yfyT+g/T5FmPEd22b+6PNE+JmLnP0bUAXw8fdi/VpSrYzBw5j8B
7fBg1X/Xv5APlTHje+U/YB8jl/p/1r/uP5xDEYfkP0avh8qUf9W/byXBmbqR
4z+tnB77o37UvxXAAzTfm+I/mefnKCh907/mOqofxafhP307q+eCfdK/6MD6
abK34D/MQzDLFYLRvzik6iVOl98/hgB30+CK0L8E3TM1RsfdP1Xj/gDIL8+/
+yARM1xY3D/+nyMEhK/NvzzUSEV68No/Vl75O502zL/zaU3X75DZPxRYpfBy
xsq/UFWRVAw72D/yxkxqZGDJv4YJhygf8NY/reQU8dAFyL/ebN99
          "]]}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {
         Arrowheads[{{0.019278790229164827`, 1.}}], 
         ArrowBox[CompressedData["
1:eJwBsQFO/iFib1JlAgAAABoAAAACAAAAg1HkNLPB4L8AAAAAAADwP/JC+GlX
rOC/tHofNTbX7z/C2sO9XRrgv+6nerFxwO4/VW2RbMmZ37/cETK+fizuP02V
rrPx+t6/SmuULdOU7T8s5i64nxzev0Ru0iCLwOw/oc+W34433b8sa9Ew0uXr
P6ZQ9J+HTNy/tk9fxmcF6z/nvkInR1vbv/0h4hMMH+o/H2XYHfVq2r8NrHYM
lDnpP3xo7blGdtm/apMjE/JP6D8CyYH7O33YvxjY6CcmYuc/r4aV4tR/178R
esZKMHDmP3q8Hhv6f9a/LFrZFuN75T9ahRNRlH/VvzZZPicRh+Q/TOFzhKN+
1L8xd/V7upHjP1TQP7UnfdO/G7T+FN+b4j/eqzt3gn3Sv0rDpv/Ep+E/Vc0r
XhWC0b8OWDpJsrfgP7s0EGrgitC/0uRy402X3z8kxNE1xy/Pv7gkSPJFx90/
qmPDOIOvzb+hxtbpW1jcPyx9yHCcNsy/zN879nnw2j/p/w4mcsbKv7DL94Lv
kNk/HdvEoGNgyb+85Yr7CzvYPwz+FynQBci/aol1yx7w1j9x+uTm
          "]]}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {
         Arrowheads[{{0.01927275986249003, 1.}}], 
         ArrowBox[CompressedData["
1:eJwBsQFO/iFib1JlAgAAABoAAAACAAAAmrw3wody4T8AAAAAAADwP+dkY1GO
7OA/Wy2tjEcK7z9JpvqBeJ7gP7xYi4UQe+4/SsmxLWBO4D8tEFvSKejtP1m/
Vb0hvt8/dDi9+gIc7T+EcLuNjdjeP15QxFx6Sew/J5vD7o/s3T9N1Jp6EHHr
PzyYXir6+dw/y5oyfpqS6j+cnuazMQjcPxQaqsfgtOk/BIrbs2sR2z+ETaKC
k9LoP3ZaPSqoFdo/GTUbr7Lr5z/vDwwX5xTZP9PQFE0+AOc/PrrupugQ2D8j
clNb0RHmPy5pjAZtC9c/eWqb2AYi5T/AHOU1dATWP9W57MTeMOQ/9NT4NP77
1D83YEcgWT7jPzx6uU1r9NM/fG1gvqNM4j8M9RjKG/DSP4Xx7HLsXeE/Y0UX
qg/v0T9P7Ow9M3LgP0JrtO1G8dA/trvAPvAS3z/5LQgrczPQP+827HLHtt0/
2OszjRfxzj+v5l45+1/cPy8VNrpggs0/7EwdULAP2z/wZnkWARzMP6PrK3UL
x9k/F3Bg2ze/yj/ORI9mMYfYP5q/TUJEbck/ZtpL4kZR1z/pKc//
          "]]}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {
         Arrowheads[{{0.019272759715839492`, 1.}}], 
         ArrowBox[CompressedData["
1:eJwBsQFO/iFib1JlAgAAABoAAAACAAAAAAAAAAAA8D/wX18diHLhP3gmsIBH
Cu8/Rb9Fo47s4D+NItd6EHvuP4FS+NJ4nuA/O7b0yCno7T9rB8N9YE7gP1hh
dfMCHO0/XLs8WyK+3z9WtaRXeknsP88qTSmO2N4/DkyidxBx6z/ET92HkOzd
P+KcY32akuo/CITgwPr53D/fKP3I4LTpPx7HzEcyCNw/SuUKhpPS6D8gN/5E
bBHbPyLSjLSy6+c/E9R0uKgV2j9o74JUPgDnP/WdMKLnFNk/leilZNER5j9f
FtUu6RDYPyFpruMGIuU/5r4Fi20L1z8LcZzR3jDkP4qXwrZ0BNY/VABwLlk+
4z9LoAuy/vvUP2jP1s2jTOI/MSrXxmv00z+xln6D7F3hPz2GGz8c8NI/L1Zn
TzNy4D9ztNgaEO/RP8sbImPwEt8/07QOWkfx0D+2Ef+ax7bdP201hpVzM9A/
GzPdZPtf3D9do0leGPHOP+0jun6wD9s/56g2h2GCzT8diJOmC8fZPy8RNd8B
HMw/ogNnmjGH2D/wcaafOL/KP3I6MhhHUdc/5GDsAUVtyT9iFc5p
          "]]}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {
         Arrowheads[{{0.019273402126430687`, 1.}}], 
         ArrowBox[CompressedData["
1:eJwBsQFO/iFib1JlAgAAABoAAAACAAAA0BJqFBlz4T8AAAAAAADwv1tHY9b+
7OA/JjLTYxMK778oefYs557gP4hDHqDdeu6/5mQE8sxO4D+LW903+OftvxR3
3FP2vt8/07h+e9Mb7b+ivlsKXdnePylGcQlNSey/gABXKVrt3T/yjFpf5XDr
v6oc3vq++tw/DgquqHGS6r+Ip20c8QjcPwPkrzO6tOm/HuqZkCUS2z/7rXg1
b9Lov2jkYldcFto/+GcIrpDr579qlshwlRXZP/kRX50eAOe/Ry2JD5ER2D/u
y3f6sxHmvybWYmYPDNc/x7VNvOsh5b8IkVV1EAXWP4TP4OLFMOS/7F1hPJT8
1D8lGTFuQj7jv2MZ7xD79NM/oClRKo9M4r/6n2dIpfDSP+mXU+PZXeG/tPHK
4pLv0T8BZDiZInLgv5AOGeDD8dA/0Bv/l9IS37/JhFbX6zPQPwxBQkmttt2/
x4rmYgDyzj/IYKNo5F/cv/bKoRtBg80/mkOPr5wP279U9KEX2RzMPxSyctf6
xtm/HDGqlQfAyj/OdLqZI4fYv4KrfdQLbsk/XlTTrztR1785v+EZ
          "]]}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {
         Arrowheads[{{0.019273410721454255`, 1.}}], 
         ArrowBox[CompressedData["
1:eJwBsQFO/iFib1JlAgAAABoAAAACAAAAAAAAAAAA8L9axxdLHXPhP+B/f1kS
Cu+/2qp0WwLt4D9Rjgmi3Hruvxf02aXqnuA/KVVBRvfn7b9HLF1e0E7gPwYe
LJ7SG+2/ninrDP2+3z8ej99ATEnsv7Wjm6Jj2d4/qriwq+Rw67+mOWafYO3d
P5jqLQpxkuq/LsVsTcX63D90BB6qubTpvzF7bEv3CNw/jvafwG7S6L++e5qa
KxLbP+bAs02Q6+e/18b2OmIW2j98Y1lRHgDnv3tcgSybFdk/08QqwrMR5r97
m/qhlhHYP2zLwZbrIeW/qOIizhQM1z9Idx7PxTDkvwMy+rAVBdY/Z8hAa0I+
47+KiYBKmfzUPxDJ8zaPTOK/zqJj8P/00z+MgwL+2V3hv1o3Ufip8NI/2vds
wCJy4L8xR0lil+/RP/JLZvzSEt+/UNJLLsjx0D+/L1TQrbbdv3womQrwM9A/
EqA/EOVf3L/vPaOSCPLOP1YSXHWdD9u/pSe8E0mDzT/5+9y4+8bZv0HKTtfg
HMw/bNL1kySH2L/q4SwcD8DKPxgL2r88Ude/wyooIRNuyT8xleGR
          "]]}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {
         Arrowheads[{{0.017140109274837896`, 1.}}], 
         ArrowBox[CompressedData["
1:eJwBYQGe/iFib1JlAgAAABUAAAACAAAAAAAAAAAA8L/v6wIpJ13Sv954BMkt
e++/cTibRO4Q0r9QvWEOTs/uvzJUFBdMrtG/XQBnmX4f7r/IKDWbZ0nRvx6n
13F+GO2/jE2o6nmy0L82nUCXMgrsv780eWhcF9C/bhScKbX26r9KJEjKh/LO
vy7868hS3em/T/7+4JKvzb/COxbgscXov3o0YNehbsy/hJvp866r578oQneq
9CrLv3YbZgRKj+a/WydEWovkyb+Wu4sRg3DlvxLkxuZlm8i/uHQVDk9S5L/g
UhEY6VLHv6w/vuyiN+O/WE41tnkOxr90HIatfiDiv3nWMsEXzsS/EAttUOIM
4b9D6wk5w5HDv8BcXqr9/t+/5/7S6JJcwr+MUhF3Cvbdv5SDppudMcG/hPfy
Buv+279LeYRR4xDAv6dLA1qfGdq/FcDZFMj0vb9gxKJ6o2PYv/IwksEW/ru/
C6a7hw==
          "]]}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {
         Arrowheads[{{0.01714015153572448, 1.}}], 
         ArrowBox[CompressedData["
1:eJwBYQGe/iFib1JlAgAAABUAAAACAAAA81+Sty1d0r8AAAAAAADwv7nZocvy
ENK/4oEhbyp777+C+xt2UK7Rv5oTK6xKz+6/a6Cw0WtJ0b/1Yk4vex/uvy1V
7tp9stC/vCdP63oY7b8l22kRYBfQv6JY7fQuCuy/bvszjo7yzr+ZuvZtsfbq
v4FHrhaZr82/TmHR9U7d6b9oTp2Ap27Mv29Bdfatxei/4tGPyvkqy78m2Xz3
qqvnv+/RhfSP5Mm/cyjo+EWP5r+RTn/+aZvIv1Uvt/p+cOW/rqeysuxSx7/B
inTwSlLkvyg9Vtt8Dsa/p9eqzZ43478DD2p4Gs7EvwkWWpJ6IOK/PB3uicWR
w7/mRYI+3gzhv6H5qduUXMK/OzkEo/X+37/+NWU5nzHBvyCfcJUC9t2/UdIf
o+QQwL95vUlU4/7bvzidszHK9L2/RZSP35cZ2r+IPLijGv67v3HngieeY9i/
enDGXg==
          "]]}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {
         Arrowheads[{{0.017140908348683176`, 1.}}], 
         ArrowBox[CompressedData["
1:eJwBYQGe/iFib1JlAgAAABUAAAACAAAAAAAAAAAA8D87dqc+cF3Sv3D1rO3v
eu8/VrfmqhIR0r9I+c1SD8/uP8SMJHRurtG/YmGuBT8f7j/tWbHqh0nRv+Ar
3RY8GO0/4mFISZay0L+FGkt+7QnsP8V65sp0F9C/fWMNhG326j/UVbK3sPLO
v2efx7oI3ek/GItiBbSvzb9htG5+ZcXoPxgQ8lK7bsy/Zm7njGCr5z+GCQvM
BivLv37NMeb5juY/Z3etcJbkyb+j0U2KMXDlP7ZZ2UBqm8i/HOBMf/xR5D9k
RlQo51LHvy1eQMtPN+M/YNPjEnIOxr/USyhuKyDiP6QAiAALzsS/E6kEaI8M
4T83zkDxsZHDvxWY32RZ/t8/OQtotX1cwr+0FQiOaPXdP9CGVx2FMcG/BcuC
S0z+2z/6QA8pyBDAvwa4T50EGdo/cHMesY30vb+XLPByNmPYP30dxwMJ/ru/
eNOtBQ==
          "]]}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {
         Arrowheads[{{0.017140910009398998`, 1.}}], 
         ArrowBox[CompressedData["
1:eJwBYQGe/iFib1JlAgAAABUAAAACAAAAD8h4/m9d0r8AAAAAAADwP/xFnVoS
EdK/9jzMz+967z+CrqEkbq7Rv/6T7jMPz+4/VRD/m4dJ0b/0/NPlPh/uPzSS
AvuVstC/fJ0o9DsY7T/qNxt9dBfQv+Zou1jtCew/axRKHbDyzr+8NsJbbfbq
P1sMWGyzr82/Jr/Vjwjd6T80IVO7um7Mv+dJ6FBlxeg/McMiNgYry7/mkwVd
YKvnP1ryxtyV5Mm/Kp0ttPmO5j+prj+vaZvIv61lYFYxcOU/vM9bmeZSx7/k
uMFJ/FHkPy8t6oZxDsa/QGJ1lE834z8Ex+p3Cs7Ev8VhezYrIOI/OJ1dbLGR
w79vt9MvjwzhP+u9jzR9XMK/Ugku9Fj+3z8+N86ghDHBv7rVux1o9d0/LwkZ
sccQwL8W1FDcS/7bP31n4MqM9L2/ZQTtLwQZ2j/LQfRLCP67v89TBCg2Y9g/
rpizMA==
          "]]}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {
         Arrowheads[{{0.016549581705215855`, 1.}}], 
         ArrowBox[CompressedData["
1:eJwBcQGO/iFib1JlAgAAABYAAAACAAAAAAAAAAAA8L+n9bFua2u0vypj803s
au+/Wi0RsUoMtL9+IqdAibHuvwaOKHf+lbO/FkYgsDz07b8kKkopMx2zv9RA
EEroP+2/Cd/gESGqsr/hEu/itITsv8bYD4msMrK/3AfH4cHG679xVBUGd7mx
v2Broq0uCuu/JY8vACJBsb96MPc+6kzqv+/zxuJbyLC/sLhfxbaL6b+kRAkq
E02wv1f1nHrwyOi/CIG5zJKhr7/G12+Y8wbov5xNT1AAqq6/+K+VntC/5r8G
i4ZJgAitv8nRMCWEeuW/CKciulhpq785PUEsDjfkv6KhI6KJzKm/SfLGs271
4r/UeokBEzKov5w/FqGjueG/TMS4Aw2fpr/Yc4PZqofgv7gPFtSPGKW/+B0d
ugi/3r8ZXaFym56jvw4ib1dggty/bKxa3y8xor9JPkcB6F3av8YAxoUz06C/
+7zvLStW2L9uus6iGQ+fv4Y6vb4=
          "]]}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {
         Arrowheads[{{0.016549588759019244`, 1.}}], 
         ArrowBox[CompressedData["
1:eJwBcQGO/iFib1JlAgAAABYAAAACAAAAHoeDD45rtL8AAAAAAADwv4YPgOtq
DLS/Szv2h+lq77+rssriHZazvy8B+HCGse6/WAw/wlEds7/gKU7XOfTtv7Ig
A/I+qrK/J0lpgeU/7b8U31eryTKyv1hdOC6yhOy/rBSAaJO5sb9OoIJCv8br
v6iOvqM9QbG/4UsPIywK679FmZbHdsiwv0xlbsrnTOq/o00aTi1NsL+4zWtq
tIvpv6FYxZHFoa+/9IioOu7I6L+saxGTMaquv8iaxXLxBui//UuW/64Irb8j
bkKkzr/mv/7dL+qEaau/zPRTWIJ65b+uId5Ss8ypv8Qu+o4MN+S/DhehOToy
qL8LHDVIbfXiv1fRTtAxn6a/wJSgZ6K54b/EY71IshilvwRx2NCph+C/Vc7s
orueo7+uYbkHB7/evwkR3d5NMaK/b6haAV+C3L8pnn1rT9OgvyjlhQLnXdq/
+c97b00Pn7+0Rix/KlbYv3qCwsw=
          "]]}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {
         Arrowheads[{{0.016549726949723537`, 1.}}], 
         ArrowBox[CompressedData["
1:eJwBcQGO/iFib1JlAgAAABYAAAACAAAAAAAAAAAA8D9OdILXF260v9r4EX2y
au8/Emb+u8UOtL83ClahTrHuP0ZKRYFpmLO/txgITgH07T9GwFvmjR+zv4/W
HjOuP+0/REyDkW2ssr8ursxlfITsP0yrhWrqNLK/tinqHYvG6z+9Xqwiprux
v0nTT5P5Ces/+edAa0JDsb8amYrqtkzqP+j4np9tyrC/AwASgYWL6T9Kb+gT
Fk+wvyt0HmTByOg/gBwg3Xqlr7+0YeigxgboP9gxEazKra6/RL01L6e/5j//
4lB+GAytv1NH7WpeeuU/RuX6T79sq7/l/w5U7DbkP7A4DyG/z6m/9uaa6lD1
4j863Y3xFzWov7RD1e+JueE/dmmPaeKhpr9JXQIllYfgP/hzLDE3G6W/bGdE
FOW+3j+8/GRIFqGjv/iNaT5Egtw/xwM5r38zor8TCVgN013aP+N01hJa1aC/
nLPzxRxW2D+8d9ZAGBOfv5m1t2s=
          "]]}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {
         Arrowheads[{{0.01654972723956636, 1.}}], 
         ArrowBox[CompressedData["
1:eJwBcQGO/iFib1JlAgAAABYAAAACAAAAXm7M7xdutL8AAAAAAADwP4aqsLvF
DrS/XmE+V7Jq7z/tN/V/aZizv8Q2ynpOse4/BFYL5I0fs78l0MsmAfTtP1Wb
CY9trLK/y0l4DK4/7T8t2P5n6jSyv6Ic8D98hOw/OqsjIKa7sb+Oeez4isbr
PyuzsGhCQ7G/b5Emb/kJ6z/AehSdbcqwv3RMS8e2TOo/m5mCERZPsL+azfFe
hYvpP4qDtth6pa+/Ap4yQ8HI6D+QSv2nyq2uv8lGJoHGBug/VCxKexgMrb85
XcsRp7/mP9r1M06/bKu/ABEAUF565T8jp7ogv8+pvx1ixDvsNuQ/K0De8hc1
qL+PUBjVUPXiP6dnnGzioaa/MEwm3Ym54T9CxPI1Nxulv9TEGBWVh+A//1Xh
Thaho7/8dN/55L7eP9wcaLd/M6K/VlpWKUSC3D9oi6AcWtWgvyScVP3SXdo/
WihIVxgTn7/InJi6HFbYP3oLtnA=
          "]]}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {
         Arrowheads[{{0.017087624336527957`, 1.}}], 
         ArrowBox[CompressedData["
1:eJwBYQGe/iFib1JlAgAAABUAAAACAAAAVlWWG1BL1D8AAAAAAADwv65apT/b
C9Q/6ZCtAvGb779TDVhtJ4vTP5wHCrEA0e6/UQVIQMgd0z+V5QttiyTuv7C2
j175rdI/KSuTsj507b9eE8GgHwXSPwQ+DxgAauy/owtgC8BX0T+tAlfMn1jr
v7JMsmlep9A/luE/SYFC6r9G5Ovv8ubPP+u3grvYJum/461vvI+Bzj9OHtnM
FA3ov7c9z0jzGc0/NJywEZDx5r/CkwqVHbDLP6ExCYpK1OW/BbAhoQ5Eyj+Q
3uI1RLXkv4Ddy2un2cg/zV6Q9ouX478sZ8DzyHTHPxpuZK0wfuK/D03/OHMV
xj97DF9aMmnhvySPiDumu8Q/7TmA/ZBY4L+lXj/Xr2rDP2h97u7Ond6/zOwG
6N0lwj8oxuZRoZ3cv5g5320w7cA/Gk7pI5mw2r8OipDRToG/PzkV9mS21ti/
LX2wvQ==
          "]]}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {
         Arrowheads[{{0.017087618808780628`, 1.}}], 
         ArrowBox[CompressedData["
1:eJwBYQGe/iFib1JlAgAAABUAAAACAAAAAAAAAAAA8L9Vy6axWUvUP8ax77Xw
m++/HwARh+QL1D8zefRVANHuv6nZ324wi9M/TcwKH4sk7r/zrXEW0R3TP1H8
sHE+dO2/SEA7CAKu0j8uKTf6/2nsvzxF4xAoBdI/+TUR0p9Y67/VVyxAyFfR
P+hj5nGBQuq/DrNTYWan0D/oR9QG2Sbpv3uGNGEC588/MMYhOhUN6L+fPfyv
noHOPxgvR5+Q8ea/Oox3uwEazT+kgkQ2S9Tlv05ypoMrsMs/zsAZ/0S15L/X
74gIHETKP3BqVNqMl+O/tzKxSbTZyD9eAIKoMX7iv8xosUbVdMc/moKiaTNp
4b8Ykon/fhXGPyDxtR2SWOC/ma45dLG7xD+IEKtK0Z3ev9CFGIK6asM/qgg1
wqOd3L8833wG6CXCP6XKCaKbsNq/4LpmATrtwD96VinquNbYv24xrOVggb8/
17evlg==
          "]]}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {
         Arrowheads[{{0.017087498324480345`, 1.}}], 
         ArrowBox[CompressedData["
1:eJwBYQGe/iFib1JlAgAAABUAAAACAAAAAAAAAAAA8D+NKwQ3U0rUP1P5CAwI
nO8/JpwuDfAK1D/kPrLIF9HuPwOZwIdCitM/OkndcqEk7j+Dkvn/5xzTP2E+
XKNTdO0/ZiLg3x2t0j/UWvJbEmrsPzC75adKBNI/LS7xU69Y6z/3mfPG8VbR
P0ZH/xeOQuo/Z2ldAZem0D/Xy4/O4ibpPzzhYyty5c8/C0g7MBwN6D8VvF71
HIDOP/wen9qU8eY/Tp/StY4YzT+tULvNTNTlP+uKv2zHrss/Gd2PCUS15D/p
fiUax0LKP07M4X2Jl+M/jrS3nm7YyD9ZJnYaLH7iPyJlKduec8c/OOtM3ytp
4T+kkHrPVxTGP+oaZsyIWOA/Ejere5m6xD8f2OeMu53eP21MiJexacM/jipR
ZIud3D+2xN7a7STCPyItCB+BsNo/65+uRU7swD/X3wy9nNbYPxi876+lf78/
rEmp/Q==
          "]]}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {
         Arrowheads[{{0.017087500287328666`, 1.}}], 
         ArrowBox[CompressedData["
1:eJwBYQGe/iFib1JlAgAAABUAAAACAAAAevdvp1JK1D8AAAAAAADwP5R3ZHPv
CtQ/8Bwr+Qec7z/Td3HzQYrTPwoM3bgX0e4/41rubecc0z/9SdZhoSTuP/a/
K1AdrdI/YhomkVN07T9o1qQaSgTSP+LAPUYSauw/fHhCPPFW0T9kPbg6r1jr
PwHeZHmWptA/qtFg+41C6j8QPi0hceXPP8dnnq7iJuk/Uqvr8BuAzj9CjAsN
HA3oPwCmfreNGM0/Ts9stJTx5j8bLuZ0xq7LP+wwwqRM1OU/n0MiKcZCyj8a
sQveQ7XkPwDS5LRt2Mg/4/QiUImX4z+uxN/4nXPHP1Ch4eorfuI/qRsT9VYU
xj9htkeuK2nhP+7WfqmYusQ/EzRVmohY4D9JxNbNsGnDP3/WdSe7nd4/hLHO
Ge0kwj92WVP+ip3cP5yeZo1N7MA/CvFCuYCw2j8mFz1RpH+/Pz2dRFic1tg/
e2+p5Q==
          "]]}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {
         Arrowheads[{{0.01579795638630435, 1.}}], 
         ArrowBox[CompressedData["
1:eJwBcQGO/iFib1JlAgAAABYAAAACAAAAt1+PRo1svj8AAAAAAADwvxWrR7/q
SL4/jCRZ7ITa778ehzI/p5C9P0pdpO61GO+/BSVtOEHgvD8WKJm2LF/uv2AT
5UIyLLw/hyRIB8qh7b86Y2loooO7P3ufD+d+8Oy/orYmeOzUuj98OmAnvDjs
v95xlOXAI7o/Ha/nJ2N+678v+Skk0HO5P+62U0hVxeq/3HtwWU7DuD/j+iLc
rgvqv2r5OcFaD7g/ousD9WhO6b+JDmtwBlq3P0/u6w+wj+i/4Ffoe2Kltj8E
aNCpsNHnv2oHK0LmcrU/BiC8L1SP5r8UsHyqQEK0PyLgs7jmTuW/31HdtHET
sz9YqLdEaBDkv8nsTGF55rE/pXjH09jT4r+DlGJd/r6wP1fAF34PneG/drlq
rU5Brz+57txb42/gv+SKiproFq0/lwcu2qiY3r9OnSSCyv6qPxr/i2PFZNy/
/0TQrxz9qD+Nl93Ae0jav5SLvOE=
          "]]}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {
         Arrowheads[{{0.015797957577199526`, 1.}}], 
         ArrowBox[CompressedData["
1:eJwBcQGO/iFib1JlAgAAABYAAAACAAAAAAAAAAAA8L8qMd05s2y+P664SWyF
2u+/clfG/xBJvj8N3TRjthjvv+mTB4/MkL0/9dm9My1f7r8C72C0ZeC8P7rk
34zKoe2/x2FH5lUsvD8UG5pyf/Dsv/eWMD/Fg7s/vrMSuLw47L+kkOZ5DtW6
P1MNcb1jfuu/g3LuDuIjuj9zhtziVcXqv0lgzXbwc7k/dqwMe68L6r8OnhHU
bcO4PyQYFZdpTum/cOtiXnkPuD9POae0sI/ov3yl7C0kWrc/vH90UbHR5780
Kdpaf6W2PwzydM9Uj+a/rnVHmwFztT90YRVP507lv5SrtH5aQrQ/+M1V0GgQ
5L/oyiEFihOzP5Q3NlPZ0+K/q9OOLpDmsT89oH3wD53hv54brK0Tv7A/5wnz
wONv4L8N8VNqdkGvPyLpLImpmN6/xtQQig0XrT90wM/2xWTcv2bijrrs/qo/
rxDoOHxI2r9vR5dNPP2oPy9WvX0=
          "]]}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {
         Arrowheads[{{0.015797898363932104`, 1.}}], 
         ArrowBox[CompressedData["
1:eJwBcQGO/iFib1JlAgAAABYAAAACAAAAAAAAAAAA8D+lrnRaL2m+PzaWe3yE
2u8/xKNpWpBFvj9NDZHRtRjvP+GOQY1hjb0/BhBSCCxf7j8dU+uBDt28P6vr
gMjIoe0/WLss8BIpvD9NL9/6fPDsP1zeTRiVgLs/J+4Wkrk47D+m2vPc8dG6
P7FEP+tffus/csebRtkguj9iT29jUcXqP/67wl37cLk/g2twV6oL6j+eRaqD
jMC4P34eZ95jTuk/xNzdSqwMuD8FQfNsqo/oP1F5yYVrV7c/x6u0d6rR5z8q
E9kG26K2P/ECFRVOj+Y/4tw4zoBwtT+aF6zL4E7lP2pYoxj9P7Q/xel5m2IQ
5D/HhRjmTxGzP3B5foTT0+I/9mSYNnnksT8qMZmYCp3hPxfMRUofvbA/gXup
6d5v4D+LIofC0D2vP+qwXu+gmN4/CGkj96gTrT8NkFWFvmTcP6NrYDLH+6o/
mAEO9HVI2j/Gz448U/qoP3ylsuo=
          "]]}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {
         Arrowheads[{{0.01579789867843719, 1.}}], 
         ArrowBox[CompressedData["
1:eJwBcQGO/iFib1JlAgAAABYAAAACAAAAi4b/US5pvj8AAAAAAADwP9owJTKP
Rb4/BM+8WYTa7z+B7mdtYI29P61RGLG1GO8/xzFPZw3dvD//dA/nK1/uP6Hc
9NoRKbw/o8F7psih7T/2ORAJlIC7P6FqHtl88Ow/a1kQ1PDRuj9NPcdwuTjs
P4jGOETYILo/DIdyyl9+6z/QDM1h+nC5P0GVHENRxeo/r0Y6jovAuD8YK6w3
qgvqP+B4P1yrDLg/ILlhv2NO6T9oDhueale3P9kQwE6qj+g/QnILJtqitj+4
A0paqtHnPzh7sfl/cLU/SICh+U2P5j+INXdQ/D+0PzykVrLgTuU/NaFcKk8R
sz+Wb2mEYhDkPz2+YYd45LE/U+LZb9PT4j+4s3OnHr2wP8NOcIYKneE/eFH/
lM89rz82B/XZ3m/gP5Q6C+GnE60/VBfQ1KCY3j++IgszxvuqPzy4km++ZNw/
M5YJU1L6qD+goeTidUjaP6U+rYU=
          "]]}}}}}, {
    DisplayFunction -> Identity, AspectRatio -> 1, AxesLabel -> {None, None}, 
     DisplayFunction :> Identity, Frame -> True, FrameLabel -> {{
        FormBox[
         StyleBox["\"y\"", 
          GrayLevel[0], 15, StripOnInput -> False], TraditionalForm], None}, {
       
        FormBox[
         StyleBox["\"x\"", 
          GrayLevel[0], 15, StripOnInput -> False], TraditionalForm], None}}, 
     FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
     FrameTicksStyle -> Directive["Label", 12], GridLinesStyle -> Directive[
       GrayLevel[0.5, 0.4]], 
     Method -> {
      "DefaultBoundaryStyle" -> Automatic, "DefaultPlotStyle" -> Automatic, 
       "ScalingFunctions" -> None}, PlotRange -> {{-1, 1}, {-1, 1}}, 
     PlotRangeClipping -> True, PlotRangePadding -> {{
        Scaled[0.02], 
        Scaled[0.02]}, {
        Scaled[0.02], 
        Scaled[0.02]}}, Ticks -> {Automatic, Automatic}}],FormBox[
    FormBox[
     TemplateBox[{
       FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           GraphicsBox[{{}, {}, 
             RasterBox[CompressedData["
1:eJxFlwd4FWUWhiluCEkAC22VHqqg7KqgoPiBFFHAAixNVBCwIGKQIiBFOoQA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              "], {{
                Rational[-15, 2], 
                Rational[-225, 2]}, {
                Rational[15, 2], 
                Rational[225, 2]}}], {Antialiasing -> False, 
              AbsoluteThickness[0.1], 
              Directive[
               Opacity[0.3], 
               GrayLevel[0]], 
              LineBox[
               NCache[{{
                  Rational[15, 2], 
                  Rational[-225, 2]}, {
                  Rational[-15, 2], 
                  Rational[-225, 2]}, {
                  Rational[-15, 2], 
                  Rational[225, 2]}, {
                  Rational[15, 2], 
                  Rational[225, 2]}, {
                  Rational[15, 2], 
                  Rational[-225, 2]}}, {{7.5, -112.5}, {-7.5, -112.5}, {-7.5, 
                112.5}, {7.5, 112.5}, {7.5, -112.5}}]]}, {
              CapForm[None], {}}, {Antialiasing -> False, 
              StyleBox[
               LineBox[{{7.5, -112.5}, {7.5, 112.5}}], 
               Directive[
                AbsoluteThickness[0.2], 
                Opacity[0.3], 
                GrayLevel[0]], StripOnInput -> False], 
              StyleBox[
               StyleBox[{{
                  StyleBox[
                   LineBox[{{{7.5, -60.67708333333333}, 
                    Offset[{4., 0}, {7.5, -60.67708333333333}]}, {{
                    7.5, -8.593749999999996}, 
                    Offset[{4., 0}, {7.5, -8.593749999999996}]}, {{7.5, 
                    43.489583333333336`}, 
                    Offset[{4., 0}, {7.5, 43.489583333333336`}]}, {{7.5, 
                    95.57291666666667}, 
                    Offset[{4., 0}, {7.5, 95.57291666666667}]}}], 
                   Directive[
                    AbsoluteThickness[0.2], 
                    GrayLevel[0.4]], StripOnInput -> False], 
                  StyleBox[
                   LineBox[{{{7.5, -99.73958333333333}, 
                    Offset[{2.5, 0.}, {7.5, -99.73958333333333}]}, {{
                    7.5, -86.71875}, 
                    Offset[{2.5, 0.}, {7.5, -86.71875}]}, {{
                    7.5, -73.69791666666667}, 
                    Offset[{2.5, 0.}, {7.5, -73.69791666666667}]}, {{
                    7.5, -47.65625}, 
                    Offset[{2.5, 0.}, {7.5, -47.65625}]}, {{
                    7.5, -34.635416666666664`}, 
                    Offset[{2.5, 0.}, {7.5, -34.635416666666664`}]}, {{
                    7.5, -21.614583333333332`}, 
                    Offset[{2.5, 0.}, {7.5, -21.614583333333332`}]}, {{7.5, 
                    4.427083333333321}, 
                    Offset[{2.5, 0.}, {7.5, 4.427083333333321}]}, {{7.5, 
                    17.44791666666667}, 
                    Offset[{2.5, 0.}, {7.5, 17.44791666666667}]}, {{7.5, 
                    30.468750000000004`}, 
                    Offset[{2.5, 0.}, {7.5, 30.468750000000004`}]}, {{7.5, 
                    56.51041666666667}, 
                    Offset[{2.5, 0.}, {7.5, 56.51041666666667}]}, {{7.5, 
                    69.53125}, 
                    Offset[{2.5, 0.}, {7.5, 69.53125}]}, {{7.5, 
                    82.55208333333334}, 
                    Offset[{2.5, 0.}, {7.5, 82.55208333333334}]}, {{7.5, 
                    108.59375}, 
                    Offset[{2.5, 0.}, {7.5, 108.59375}]}}], 
                   Directive[
                    AbsoluteThickness[0.2], 
                    GrayLevel[0.4], 
                    Opacity[0.3]], StripOnInput -> False]}, 
                 StyleBox[
                  StyleBox[{{
                    StyleBox[{
                    InsetBox[
                    FormBox[
                    TagBox[
                    InterpretationBox["\"-0.8\"", -0.8, AutoDelete -> True], 
                    NumberForm[#, {
                    DirectedInfinity[1], 1}]& ], TraditionalForm], 
                    Offset[{7., 0.}, {7.5, -60.67708333333333}], {-1, 0.}, 
                    Automatic, {1, 0}], 
                    InsetBox[
                    FormBox[
                    TagBox[
                    InterpretationBox["\"-0.6\"", -0.6, AutoDelete -> True], 
                    NumberForm[#, {
                    DirectedInfinity[1], 1}]& ], TraditionalForm], 
                    Offset[{7., 0.}, {7.5, -8.593749999999996}], {-1, 0.}, 
                    Automatic, {1, 0}], 
                    InsetBox[
                    FormBox[
                    TagBox[
                    InterpretationBox["\"-0.4\"", -0.4, AutoDelete -> True], 
                    NumberForm[#, {
                    DirectedInfinity[1], 1}]& ], TraditionalForm], 
                    Offset[{7., 0.}, {7.5, 43.489583333333336`}], {-1, 0.}, 
                    Automatic, {1, 0}], 
                    InsetBox[
                    FormBox[
                    TagBox[
                    InterpretationBox["\"-0.2\"", -0.2, AutoDelete -> True], 
                    NumberForm[#, {
                    DirectedInfinity[1], 1}]& ], TraditionalForm], 
                    Offset[{7., 0.}, {7.5, 95.57291666666667}], {-1, 0.}, 
                    Automatic, {1, 0}]}, 
                    Directive[
                    AbsoluteThickness[0.2], 
                    GrayLevel[0.4]], {
                    Directive[
                    Opacity[1]], 
                    Directive[
                    Opacity[1]]}, StripOnInput -> False], 
                    
                    StyleBox[{{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}}, 
                    Directive[
                    AbsoluteThickness[0.2], 
                    GrayLevel[0.4], 
                    Opacity[0.3]], {
                    Directive[
                    Opacity[1]], 
                    Directive[
                    Opacity[1]]}, StripOnInput -> False]}, {}}, {
                    Directive[
                    Opacity[1]], 
                    Directive[
                    Opacity[1]]}, StripOnInput -> False], "GraphicsLabel", 
                  StripOnInput -> False]}, "GraphicsTicks", StripOnInput -> 
                False], 
               Directive[
                AbsoluteThickness[0.2], 
                Opacity[0.3], 
                GrayLevel[0]], StripOnInput -> False]}}, PlotRangePadding -> 
            Scaled[0.02], PlotRange -> All, Frame -> True, 
            FrameTicks -> {{False, False}, {True, False}}, FrameStyle -> 
            Opacity[0], FrameTicksStyle -> Opacity[0], 
            ImageSize -> {Automatic, 225}, BaseStyle -> {}], Alignment -> 
           Left, AppearanceElements -> None, ImageMargins -> {{5, 5}, {5, 5}},
            ImageSizeAction -> "ResizeToFit"], LineIndent -> 0, StripOnInput -> 
          False], {FontFamily -> "Arial"}, Background -> Automatic, 
         StripOnInput -> False], TraditionalForm]}, "BarLegend", 
      DisplayFunction -> (#& ), 
      InterpretationFunction :> (RowBox[{"BarLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{
                 RowBox[{"Blend", "[", 
                   RowBox[{"\"M10DefaultDensityGradient\"", ",", "#1"}], 
                   "]"}], "&"}], ",", 
               RowBox[{"{", 
                 RowBox[{
                   RowBox[{"-", "0.9991673605810143`"}], ",", 
                   RowBox[{"-", "0.1353352832366127`"}]}], "}"}]}], "}"}], 
           ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"{", "}"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}], ",", 
           RowBox[{"Charting`TickAnnotations", "\[Rule]", "None"}], ",", 
           RowBox[{"Charting`TickSide", "\[Rule]", "Right"}], ",", 
           RowBox[{"ColorFunctionScaling", "\[Rule]", "True"}]}], "]"}]& )], 
     TraditionalForm], TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"], 
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& )]], "Output",
 CellChangeTimes->{{3.681131027355438*^9, 3.6811310473687353`*^9}, {
   3.6811656314732933`*^9, 3.681165633620594*^9}, 3.681230210461738*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Solving the equations of motion of a particle starting from at (x = 0.5, y \
= 0.5) with initial velocity ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "0.2"}], ",", "0.2"}], ")"}], " "}], TraditionalForm]],
  FormatType->"TraditionalForm"],
 ":"
}], "Subsubsection",
 CellChangeTimes->{{3.681165797193681*^9, 3.681165838646903*^9}, {
  3.681166518857777*^9, 3.681166521688085*^9}, {3.68123009371905*^9, 
  3.6812301302297783`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"solution", "=", "\[IndentingNewLine]", 
  RowBox[{"NDSolve", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"x", "''"}], "[", "t", "]"}], "\[Equal]", 
       RowBox[{
        RowBox[{"-", "2"}], " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox[
            RowBox[{"x", "[", "t", "]"}], "2"]}], "-", 
          SuperscriptBox[
           RowBox[{"y", "[", "t", "]"}], "2"]}]], " ", 
        RowBox[{"x", "[", "t", "]"}]}]}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"y", "''"}], "[", "t", "]"}], "\[Equal]", 
       RowBox[{
        RowBox[{"-", "2"}], " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox[
            RowBox[{"x", "[", "t", "]"}], "2"]}], "-", 
          SuperscriptBox[
           RowBox[{"y", "[", "t", "]"}], "2"]}]], " ", 
        RowBox[{"y", "[", "t", "]"}]}]}], ",", 
      RowBox[{
       RowBox[{"x", "[", "0", "]"}], "\[Equal]", "0.5"}], ",", 
      RowBox[{
       RowBox[{"y", "[", "0", "]"}], "\[Equal]", "0.5"}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"x", "'"}], "[", "0", "]"}], "\[Equal]", 
       RowBox[{"-", "0.2"}]}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"y", "'"}], "[", "0", "]"}], "\[Equal]", "0.2"}]}], "}"}], 
    ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"t", ",", "0", ",", "50"}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.6811319105300217`*^9, 3.6811319750187197`*^9}, {
   3.6811508819616823`*^9, 3.681150882214344*^9}, {3.6811665717928057`*^9, 
   3.681166574002335*^9}, 3.681230156471622*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"x", "\[Rule]", 
     TagBox[
      TemplateBox[{RowBox[{
          StyleBox[
           TagBox["InterpolatingFunction", "SummaryHead"], 
           "NonInterpretableSummary"], 
          StyleBox["[", "NonInterpretableSummary"], 
          DynamicModuleBox[{Typeset`open$$ = False}, 
           PanelBox[
            PaneSelectorBox[{False -> GridBox[{{
                  PaneBox[
                   ButtonBox[
                    DynamicBox[
                    FEPrivate`FrontEndResource[
                    "FEBitmaps", "SquarePlusIconMedium"]], 
                    ButtonFunction :> (Typeset`open$$ = True), Appearance -> 
                    None, Evaluator -> Automatic, Method -> "Preemptive"], 
                   Alignment -> {Center, Center}, ImageSize -> 
                   Dynamic[{
                    Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                  GraphicsBox[{{{{}, {}, {
                    Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]], 
                    LineBox[CompressedData["
1:eJwB0QMu/CFib1JlAgAAADwAAAACAAAAnIW2B5tvrD5HdgJK///fP/BdXF00
Feo/H13Oy5PIxD/OO7mkBi77P3b7CEWyq9W/ZDHLW8wwBEChxXhOWXrdv0XB
TstvqQpAtTFVwp6xyr8alh9oPtcQQKw0pRsjyM4/GlLMUc4dFECN2b/dTvjZ
P6F7LwaTqhdAIuIJw3DbyD9aI53txCYbQABOHJtqG8i/nFE/PABnHkC5giq1
ifTVv7P2yyq49iBAywHm57Roxb/chxLr9JsiQOb3OYGepME/H1jeROg4JEAi
U5ZwNVvSPyVfBQT2+CVABiO+A6s/wj9vqcZ2CJsnQKWbHfb86ry/fSrjTjVg
KUDaP2sMMzfPv6TqhMAYHStAtW84qxb9tr8P7sDlALwsQPoqrffIPME/PihY
cAN+LkCVgoGZRl3MP9jSRFcFETBAWuMMxatLrD/zLAsplvQwQHlJ40WX98a/
miaURwLUMUBhrekB60PMv+RB6r9wpDJA83UjBXn/ib+P+O1qbIYzQOllDu+c
m80/3NC+b2pZNEAXqEJNHTvQP7ZIUsFDKDVAmTWMgFzhgj/yW5NFqgg2QIXz
7+hilNG/0JChIxPaNkBNvUSbsAjUvxBhXTQJvTdAEK9bBG3aeL/c0NuR2ps4
QC3mlj026dQ/SmInSa5rOUCumEJPNh/YPxqPIDMPTTpABmrCPZTVoj+M3eZ2
ch87QPHzC5uSQ9a/i8tvB7HtO0AywXP5vhzdv+xUpsp8zTxADhqoz8WrwL/v
/6nnSp49QBx8ixf5R9U/VEZbN6aAPkCtRJ9BibDgP1uu2eADVD9AsJJqvl4j
zj/4Wo1rnhFAQHRpzU9GmdK/c6wEgAGCQED1W3J2UoDiv7+OYsHl6kBAgq0s
e9VC17+7PheckFxBQKC9+6vrX9A/fj4tHSnMQUAQLIFDncHjPxLPKctCNEJA
8ffp+K8N3T9XLX0SI6VCQCW13W0mjce/bRy3hoQOQ0DxdS1PoPXjv0lbUqHT
dUNAUVZkZ7cL4r/WZ0RV6eVDQDnsnX/+9qM/NAUdNoBOREA/k8wh2MLiP0Nw
TLDdv0RAppO6FGgR5D8YK93QKC9FQGZ24yInN7E/vnZUHvWWRUDcNI9O/E7h
vxWQIgWIB0ZAjB0xy6Kh5b89OtcYnHBGQIoUNu+oA82/FrLixXbiRkB6J+q0
/hDfP7V5Txk/UkdAgvYI/HFL5j8m0qKZiLpHQMud8XiZhtQ/R/hMs5grSEBp
JiyXLKPZvzmv3fkplUhALcaji2tK5r8+GeT4//9IQO2/tGKi99q/eDzQIQ==

                    "]]}}}, {}}, {
                   DisplayFunction -> Identity, PlotRangePadding -> {{
                    Scaled[0.1], 
                    Scaled[0.1]}, {
                    Scaled[0.1], 
                    Scaled[0.1]}}, PlotRangeClipping -> True, ImagePadding -> 
                    All, DisplayFunction -> Identity, AspectRatio -> 1, 
                    Axes -> {False, False}, AxesLabel -> {None, None}, 
                    AxesOrigin -> {0, 0}, DisplayFunction :> Identity, 
                    Frame -> {{True, True}, {True, True}}, 
                    FrameLabel -> {{None, None}, {None, None}}, FrameStyle -> 
                    Directive[
                    Opacity[0.5], 
                    Thickness[Tiny], 
                    RGBColor[0.368417, 0.506779, 0.709798]], 
                    FrameTicks -> {{None, None}, {None, None}}, 
                    GridLines -> {None, None}, GridLinesStyle -> Directive[
                    GrayLevel[0.5, 0.4]], ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], 
                    Method -> {
                    "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
                    AbsolutePointSize[6], "ScalingFunctions" -> None}, 
                    PlotRange -> {{0., 50.}, {-0.6965844848002171, 
                    0.6967096254881684}}, PlotRangeClipping -> True, 
                    PlotRangePadding -> {{
                    Scaled[0.1], 
                    Scaled[0.1]}, {
                    Scaled[0.1], 
                    Scaled[0.1]}}, Ticks -> {Automatic, Automatic}}], 
                  GridBox[{{
                    RowBox[{
                    TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{"0.`", ",", "50.`"}], "}"}], "}"}], 
                    "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Output: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"scalar\"", "SummaryItem"]}]}}, 
                   GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, 
                   AutoDelete -> False, 
                   GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                   GridBoxSpacings -> {
                    "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
                   BaseStyle -> {
                    ShowStringCharacters -> False, NumberMarks -> False, 
                    PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
                GridBoxAlignment -> {"Rows" -> {{Top}}}, AutoDelete -> False, 
                GridBoxItemSize -> {
                 "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                BaselinePosition -> {1, 1}], True -> GridBox[{{
                  PaneBox[
                   ButtonBox[
                    DynamicBox[
                    FEPrivate`FrontEndResource[
                    "FEBitmaps", "SquareMinusIconMedium"]], 
                    ButtonFunction :> (Typeset`open$$ = False), Appearance -> 
                    None, Evaluator -> Automatic, Method -> "Preemptive"], 
                   Alignment -> {Center, Center}, ImageSize -> 
                   Dynamic[{
                    Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                  GraphicsBox[{{{{}, {}, {
                    Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]], 
                    LineBox[CompressedData["
1:eJwB0QMu/CFib1JlAgAAADwAAAACAAAAnIW2B5tvrD5HdgJK///fP/BdXF00
Feo/H13Oy5PIxD/OO7mkBi77P3b7CEWyq9W/ZDHLW8wwBEChxXhOWXrdv0XB
TstvqQpAtTFVwp6xyr8alh9oPtcQQKw0pRsjyM4/GlLMUc4dFECN2b/dTvjZ
P6F7LwaTqhdAIuIJw3DbyD9aI53txCYbQABOHJtqG8i/nFE/PABnHkC5giq1
ifTVv7P2yyq49iBAywHm57Roxb/chxLr9JsiQOb3OYGepME/H1jeROg4JEAi
U5ZwNVvSPyVfBQT2+CVABiO+A6s/wj9vqcZ2CJsnQKWbHfb86ry/fSrjTjVg
KUDaP2sMMzfPv6TqhMAYHStAtW84qxb9tr8P7sDlALwsQPoqrffIPME/PihY
cAN+LkCVgoGZRl3MP9jSRFcFETBAWuMMxatLrD/zLAsplvQwQHlJ40WX98a/
miaURwLUMUBhrekB60PMv+RB6r9wpDJA83UjBXn/ib+P+O1qbIYzQOllDu+c
m80/3NC+b2pZNEAXqEJNHTvQP7ZIUsFDKDVAmTWMgFzhgj/yW5NFqgg2QIXz
7+hilNG/0JChIxPaNkBNvUSbsAjUvxBhXTQJvTdAEK9bBG3aeL/c0NuR2ps4
QC3mlj026dQ/SmInSa5rOUCumEJPNh/YPxqPIDMPTTpABmrCPZTVoj+M3eZ2
ch87QPHzC5uSQ9a/i8tvB7HtO0AywXP5vhzdv+xUpsp8zTxADhqoz8WrwL/v
/6nnSp49QBx8ixf5R9U/VEZbN6aAPkCtRJ9BibDgP1uu2eADVD9AsJJqvl4j
zj/4Wo1rnhFAQHRpzU9GmdK/c6wEgAGCQED1W3J2UoDiv7+OYsHl6kBAgq0s
e9VC17+7PheckFxBQKC9+6vrX9A/fj4tHSnMQUAQLIFDncHjPxLPKctCNEJA
8ffp+K8N3T9XLX0SI6VCQCW13W0mjce/bRy3hoQOQ0DxdS1PoPXjv0lbUqHT
dUNAUVZkZ7cL4r/WZ0RV6eVDQDnsnX/+9qM/NAUdNoBOREA/k8wh2MLiP0Nw
TLDdv0RAppO6FGgR5D8YK93QKC9FQGZ24yInN7E/vnZUHvWWRUDcNI9O/E7h
vxWQIgWIB0ZAjB0xy6Kh5b89OtcYnHBGQIoUNu+oA82/FrLixXbiRkB6J+q0
/hDfP7V5Txk/UkdAgvYI/HFL5j8m0qKZiLpHQMud8XiZhtQ/R/hMs5grSEBp
JiyXLKPZvzmv3fkplUhALcaji2tK5r8+GeT4//9IQO2/tGKi99q/eDzQIQ==

                    "]]}}}, {}}, {
                   DisplayFunction -> Identity, PlotRangePadding -> {{
                    Scaled[0.1], 
                    Scaled[0.1]}, {
                    Scaled[0.1], 
                    Scaled[0.1]}}, PlotRangeClipping -> True, ImagePadding -> 
                    All, DisplayFunction -> Identity, AspectRatio -> 1, 
                    Axes -> {False, False}, AxesLabel -> {None, None}, 
                    AxesOrigin -> {0, 0}, DisplayFunction :> Identity, 
                    Frame -> {{True, True}, {True, True}}, 
                    FrameLabel -> {{None, None}, {None, None}}, FrameStyle -> 
                    Directive[
                    Opacity[0.5], 
                    Thickness[Tiny], 
                    RGBColor[0.368417, 0.506779, 0.709798]], 
                    FrameTicks -> {{None, None}, {None, None}}, 
                    GridLines -> {None, None}, GridLinesStyle -> Directive[
                    GrayLevel[0.5, 0.4]], ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], 
                    Method -> {
                    "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
                    AbsolutePointSize[6], "ScalingFunctions" -> None}, 
                    PlotRange -> {{0., 50.}, {-0.6965844848002171, 
                    0.6967096254881684}}, PlotRangeClipping -> True, 
                    PlotRangePadding -> {{
                    Scaled[0.1], 
                    Scaled[0.1]}, {
                    Scaled[0.1], 
                    Scaled[0.1]}}, Ticks -> {Automatic, Automatic}}], 
                  GridBox[{{
                    RowBox[{
                    TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{"0.`", ",", "50.`"}], "}"}], "}"}], 
                    "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Output: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"scalar\"", "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Order: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["3", "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Method: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"Hermite\"", "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Periodic: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["False", "SummaryItem"]}]}}, 
                   GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, 
                   AutoDelete -> False, 
                   GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                   GridBoxSpacings -> {
                    "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
                   BaseStyle -> {
                    ShowStringCharacters -> False, NumberMarks -> False, 
                    PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
                GridBoxAlignment -> {"Rows" -> {{Top}}}, AutoDelete -> False, 
                GridBoxItemSize -> {
                 "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                BaselinePosition -> {1, 1}]}, 
             Dynamic[Typeset`open$$], ImageSize -> Automatic], 
            BaselinePosition -> Baseline], DynamicModuleValues :> {}], 
          StyleBox["]", "NonInterpretableSummary"]}]},
       "CopyTag",
       DisplayFunction->(#& ),
       InterpretationFunction->("InterpolatingFunction[{{0., 50.}}, <>]"& )],
      False,
      Editable->False,
      SelectWithContents->True,
      Selectable->False]}], ",", 
    RowBox[{"y", "\[Rule]", 
     TagBox[
      TemplateBox[{RowBox[{
          StyleBox[
           TagBox["InterpolatingFunction", "SummaryHead"], 
           "NonInterpretableSummary"], 
          StyleBox["[", "NonInterpretableSummary"], 
          DynamicModuleBox[{Typeset`open$$ = False}, 
           PanelBox[
            PaneSelectorBox[{False -> GridBox[{{
                  PaneBox[
                   ButtonBox[
                    DynamicBox[
                    FEPrivate`FrontEndResource[
                    "FEBitmaps", "SquarePlusIconMedium"]], 
                    ButtonFunction :> (Typeset`open$$ = True), Appearance -> 
                    None, Evaluator -> Automatic, Method -> "Preemptive"], 
                   Alignment -> {Center, Center}, ImageSize -> 
                   Dynamic[{
                    Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                  GraphicsBox[{{{{}, {}, {
                    Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]], 
                    LineBox[CompressedData["
1:eJwB0QMu/CFib1JlAgAAADwAAAACAAAAnIW2B5tvrD7utP5aAADgP/BdXF00
Feo/NZOdh+tN3D/OO7mkBi77P1h3SC+SlrO/ZDHLW8wwBEAwrQpAk3Xgv0XB
TstvqQpAHXxUQrY24b8alh9oPtcQQIRZvghQ1aa/GlLMUc4dFEDy177Kl0Lf
P6F7LwaTqhdAfMS15cxP4z9aI53txCYbQAp9SI2Cb8E/nFE/PABnHkA9WCyb
EmDdv7P2yyq49iBA3bMN9EsP5b/chxLr9JsiQDhpVo9YEtK/H1jeROg4JEB4
VUOHVTXXPyVfBQT2+CVAtmhHGrEj5j9vqcZ2CJsnQGZxVjHvpNs/fSrjTjVg
KUBOPAlqcxfSv6TqhMAYHStAK57FsoVE5r8P7sDlALwsQNsxxLxxlOC/PihY
cAN+LkCrUtQVXOHFP9jSRFcFETBAr9EI/fIf5T/zLAsplvQwQPJCKWIYTuI/
miaURwLUMUDHOnOMvwqyv+RB6r9wpDJAUbjxKrCZ47+P+O1qbIYzQESvm5Hy
muO/3NC+b2pZNED38/EinX20v7ZIUsFDKDVAwqF5uViG4D/yW5NFqgg2QL2c
6L1PkOQ/0JChIxPaNkAEFaqudAbNPxBhXTQJvTdAXuDCbLjL27/c0NuR2ps4
QD1ynXypEOS/SmInSa5rOUABcsnrU+/SvxqPIDMPTTpARy7g5UBx1T+M3eZ2
ch87QKXNAPLk8+I/i8tvB7HtO0DA/retV8bXP+xUpsp8zTxAPZpBvXtqyb/v
/6nnSp49QI6u5BLq6uC/VEZbN6aAPkBno8pVwEPYv1uu2eADVD9ApYr3SuE3
tz/4Wo1rnhFAQDFOhLGxv9w/c6wEgAGCQEAUiwRXeY/YP7+OYsHl6kBAyDpJ
7rrMWD+7PheckFxBQO+YT4KlSdi/fj4tHSnMQUD/GNa2MwPWvxLPKctCNEJA
Yd+MrOejm79XLX0SI6VCQHTMvy+TBtQ/bRy3hoQOQ0CIbXkRd4bTP0lbUqHT
dUNAN224rropqj/WZ0RV6eVDQO4w22441c+/NAUdNoBOREDTaJiulbDQv0Nw
TLDdv0RAOVOglRLzl78YK93QKC9FQEQ7/eSKMcw/vnZUHvWWRUDqwLIVj7LK
PxWQIgWIB0ZA2NadchjLjb89OtcYnHBGQOKkGvm6rcq/FrLixXbiRkBg1/nu
zunEv7V5Txk/UkdAubNAET2ssT8m0qKZiLpHQCWn/F0iis0/R/hMs5grSEDu
Ay+RxM7BPzmv3fkplUhAnPZ5l8q/u78+GeT4//9IQJfBfuwkT9G/rr3UqQ==

                    "]]}}}, {}}, {
                   DisplayFunction -> Identity, PlotRangePadding -> {{
                    Scaled[0.1], 
                    Scaled[0.1]}, {
                    Scaled[0.1], 
                    Scaled[0.1]}}, PlotRangeClipping -> True, ImagePadding -> 
                    All, DisplayFunction -> Identity, AspectRatio -> 1, 
                    Axes -> {False, False}, AxesLabel -> {None, None}, 
                    AxesOrigin -> {0, 0}, DisplayFunction :> Identity, 
                    Frame -> {{True, True}, {True, True}}, 
                    FrameLabel -> {{None, None}, {None, None}}, FrameStyle -> 
                    Directive[
                    Opacity[0.5], 
                    Thickness[Tiny], 
                    RGBColor[0.368417, 0.506779, 0.709798]], 
                    FrameTicks -> {{None, None}, {None, None}}, 
                    GridLines -> {None, None}, GridLinesStyle -> Directive[
                    GrayLevel[0.5, 0.4]], ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], 
                    Method -> {
                    "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
                    AbsolutePointSize[6], "ScalingFunctions" -> None}, 
                    PlotRange -> {{0., 50.}, {-0.6958645335807366, 
                    0.6918569100628449}}, PlotRangeClipping -> True, 
                    PlotRangePadding -> {{
                    Scaled[0.1], 
                    Scaled[0.1]}, {
                    Scaled[0.1], 
                    Scaled[0.1]}}, Ticks -> {Automatic, Automatic}}], 
                  GridBox[{{
                    RowBox[{
                    TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{"0.`", ",", "50.`"}], "}"}], "}"}], 
                    "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Output: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"scalar\"", "SummaryItem"]}]}}, 
                   GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, 
                   AutoDelete -> False, 
                   GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                   GridBoxSpacings -> {
                    "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
                   BaseStyle -> {
                    ShowStringCharacters -> False, NumberMarks -> False, 
                    PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
                GridBoxAlignment -> {"Rows" -> {{Top}}}, AutoDelete -> False, 
                GridBoxItemSize -> {
                 "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                BaselinePosition -> {1, 1}], True -> GridBox[{{
                  PaneBox[
                   ButtonBox[
                    DynamicBox[
                    FEPrivate`FrontEndResource[
                    "FEBitmaps", "SquareMinusIconMedium"]], 
                    ButtonFunction :> (Typeset`open$$ = False), Appearance -> 
                    None, Evaluator -> Automatic, Method -> "Preemptive"], 
                   Alignment -> {Center, Center}, ImageSize -> 
                   Dynamic[{
                    Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                  GraphicsBox[{{{{}, {}, {
                    Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]], 
                    LineBox[CompressedData["
1:eJwB0QMu/CFib1JlAgAAADwAAAACAAAAnIW2B5tvrD7utP5aAADgP/BdXF00
Feo/NZOdh+tN3D/OO7mkBi77P1h3SC+SlrO/ZDHLW8wwBEAwrQpAk3Xgv0XB
TstvqQpAHXxUQrY24b8alh9oPtcQQIRZvghQ1aa/GlLMUc4dFEDy177Kl0Lf
P6F7LwaTqhdAfMS15cxP4z9aI53txCYbQAp9SI2Cb8E/nFE/PABnHkA9WCyb
EmDdv7P2yyq49iBA3bMN9EsP5b/chxLr9JsiQDhpVo9YEtK/H1jeROg4JEB4
VUOHVTXXPyVfBQT2+CVAtmhHGrEj5j9vqcZ2CJsnQGZxVjHvpNs/fSrjTjVg
KUBOPAlqcxfSv6TqhMAYHStAK57FsoVE5r8P7sDlALwsQNsxxLxxlOC/PihY
cAN+LkCrUtQVXOHFP9jSRFcFETBAr9EI/fIf5T/zLAsplvQwQPJCKWIYTuI/
miaURwLUMUDHOnOMvwqyv+RB6r9wpDJAUbjxKrCZ47+P+O1qbIYzQESvm5Hy
muO/3NC+b2pZNED38/EinX20v7ZIUsFDKDVAwqF5uViG4D/yW5NFqgg2QL2c
6L1PkOQ/0JChIxPaNkAEFaqudAbNPxBhXTQJvTdAXuDCbLjL27/c0NuR2ps4
QD1ynXypEOS/SmInSa5rOUABcsnrU+/SvxqPIDMPTTpARy7g5UBx1T+M3eZ2
ch87QKXNAPLk8+I/i8tvB7HtO0DA/retV8bXP+xUpsp8zTxAPZpBvXtqyb/v
/6nnSp49QI6u5BLq6uC/VEZbN6aAPkBno8pVwEPYv1uu2eADVD9ApYr3SuE3
tz/4Wo1rnhFAQDFOhLGxv9w/c6wEgAGCQEAUiwRXeY/YP7+OYsHl6kBAyDpJ
7rrMWD+7PheckFxBQO+YT4KlSdi/fj4tHSnMQUD/GNa2MwPWvxLPKctCNEJA
Yd+MrOejm79XLX0SI6VCQHTMvy+TBtQ/bRy3hoQOQ0CIbXkRd4bTP0lbUqHT
dUNAN224rropqj/WZ0RV6eVDQO4w22441c+/NAUdNoBOREDTaJiulbDQv0Nw
TLDdv0RAOVOglRLzl78YK93QKC9FQEQ7/eSKMcw/vnZUHvWWRUDqwLIVj7LK
PxWQIgWIB0ZA2NadchjLjb89OtcYnHBGQOKkGvm6rcq/FrLixXbiRkBg1/nu
zunEv7V5Txk/UkdAubNAET2ssT8m0qKZiLpHQCWn/F0iis0/R/hMs5grSEDu
Ay+RxM7BPzmv3fkplUhAnPZ5l8q/u78+GeT4//9IQJfBfuwkT9G/rr3UqQ==

                    "]]}}}, {}}, {
                   DisplayFunction -> Identity, PlotRangePadding -> {{
                    Scaled[0.1], 
                    Scaled[0.1]}, {
                    Scaled[0.1], 
                    Scaled[0.1]}}, PlotRangeClipping -> True, ImagePadding -> 
                    All, DisplayFunction -> Identity, AspectRatio -> 1, 
                    Axes -> {False, False}, AxesLabel -> {None, None}, 
                    AxesOrigin -> {0, 0}, DisplayFunction :> Identity, 
                    Frame -> {{True, True}, {True, True}}, 
                    FrameLabel -> {{None, None}, {None, None}}, FrameStyle -> 
                    Directive[
                    Opacity[0.5], 
                    Thickness[Tiny], 
                    RGBColor[0.368417, 0.506779, 0.709798]], 
                    FrameTicks -> {{None, None}, {None, None}}, 
                    GridLines -> {None, None}, GridLinesStyle -> Directive[
                    GrayLevel[0.5, 0.4]], ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], 
                    Method -> {
                    "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
                    AbsolutePointSize[6], "ScalingFunctions" -> None}, 
                    PlotRange -> {{0., 50.}, {-0.6958645335807366, 
                    0.6918569100628449}}, PlotRangeClipping -> True, 
                    PlotRangePadding -> {{
                    Scaled[0.1], 
                    Scaled[0.1]}, {
                    Scaled[0.1], 
                    Scaled[0.1]}}, Ticks -> {Automatic, Automatic}}], 
                  GridBox[{{
                    RowBox[{
                    TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{"0.`", ",", "50.`"}], "}"}], "}"}], 
                    "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Output: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"scalar\"", "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Order: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["3", "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Method: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"Hermite\"", "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Periodic: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["False", "SummaryItem"]}]}}, 
                   GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, 
                   AutoDelete -> False, 
                   GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                   GridBoxSpacings -> {
                    "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
                   BaseStyle -> {
                    ShowStringCharacters -> False, NumberMarks -> False, 
                    PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
                GridBoxAlignment -> {"Rows" -> {{Top}}}, AutoDelete -> False, 
                GridBoxItemSize -> {
                 "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                BaselinePosition -> {1, 1}]}, 
             Dynamic[Typeset`open$$], ImageSize -> Automatic], 
            BaselinePosition -> Baseline], DynamicModuleValues :> {}], 
          StyleBox["]", "NonInterpretableSummary"]}]},
       "CopyTag",
       DisplayFunction->(#& ),
       InterpretationFunction->("InterpolatingFunction[{{0., 50.}}, <>]"& )],
      False,
      Editable->False,
      SelectWithContents->True,
      Selectable->False]}]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{{3.6811319335956793`*^9, 3.6811319754420147`*^9}, 
   3.681150882561763*^9, 3.6811665767582684`*^9, 3.681230214224074*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["plotting the trajectory :", "Subsubsection",
 CellChangeTimes->{{3.681165933083108*^9, 3.68116593887215*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"x", "[", "t", "]"}], ",", 
      RowBox[{"y", "[", "t", "]"}]}], "}"}], "/.", "solution"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "50"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{3.6812302273405867`*^9}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
    1.], FaceForm[Opacity[0.3]], LineBox[CompressedData["
1:eJw0mXk8Vd/3/zWQIcmUIkSI3kiSEK0GRKiUJJUm0qRJVJIpSSXzEDKGDJnH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     "]]}},
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  Method->{"ScalingFunctions" -> None},
  PlotRange->{{-0.7041733631713252, 0.7065007701088389}, {-0.7051644430743372,
    0.705925731397001}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.05], 
     Scaled[0.05]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{3.681230227892974*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["with other options to change the style :", "Subsubsection",
 CellChangeTimes->{{3.681230238728854*^9, 3.681230252161611*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"trajectory", "=", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"ParametricPlot", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"x", "[", "t", "]"}], ",", 
        RowBox[{"y", "[", "t", "]"}]}], "}"}], "/.", "solution"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "50"}], "}"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", "Black"}], ",", "\[IndentingNewLine]", 
     RowBox[{"Frame", "\[Rule]", "True"}], ",", 
     RowBox[{"Axes", "\[Rule]", "False"}], ",", 
     RowBox[{"FrameLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Style", "[", 
         RowBox[{"\"\<x\>\"", ",", "Black", ",", "15"}], "]"}], ",", 
        RowBox[{"Style", "[", 
         RowBox[{"\"\<y\>\"", ",", "Black", ",", "15"}], "]"}]}], "}"}]}], 
     ",", 
     RowBox[{"FrameTicksStyle", "\[Rule]", 
      RowBox[{"Directive", "[", 
       RowBox[{"\"\<Label\>\"", ",", "12"}], "]"}]}]}], "]"}], "/.", 
   RowBox[{"Line", "\[Rule]", "Arrow"}]}]}]], "Input",
 CellChangeTimes->{{3.681131202717352*^9, 3.6811312161728687`*^9}, {
   3.6811312551849833`*^9, 3.681131268673484*^9}, 3.681131388863269*^9, {
   3.681131606491934*^9, 3.681131611704258*^9}, {3.681131665809017*^9, 
   3.681131700149105*^9}, {3.681131880151538*^9, 3.6811318822981243`*^9}, {
   3.6811659860497103`*^9, 3.6811659870376797`*^9}, {3.681166144707788*^9, 
   3.681166279204792*^9}, {3.681166603299954*^9, 3.681166615269539*^9}, 
   3.681166654350184*^9, {3.681230216854226*^9, 3.68123021850457*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {GrayLevel[0], AbsoluteThickness[1.6], Opacity[1.], FaceForm[Opacity[0.3]],
     ArrowBox[CompressedData["
1:eJw0mXk8Vd/3/zWQIcmUIkSI3kiSEK0GRKiUJJUm0qRJVJIpSSXzEDKGDJnH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     "]]}},
  Axes->{False, False},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{
     FormBox[
      StyleBox["\"y\"", 
       GrayLevel[0], 15, StripOnInput -> False], TraditionalForm], None}, {
     FormBox[
      StyleBox["\"x\"", 
       GrayLevel[0], 15, StripOnInput -> False], TraditionalForm], None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  FrameTicksStyle->Directive["Label", 12],
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  Method->{"ScalingFunctions" -> None},
  PlotRange->{{-0.7041733631713252, 0.7065007701088389}, {-0.7051644430743372,
    0.705925731397001}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.05], 
     Scaled[0.05]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.68116660519986*^9, 3.681166615650115*^9}, 
   3.6811666548604593`*^9, 3.681167104511696*^9, 3.6812302550560627`*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Show the trajectory on the potential and field-line plot :", \
"Subsubsection",
 CellChangeTimes->{{3.681165947689788*^9, 3.681165969855812*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{"densityplot", ",", "fieldlines", ",", "trajectory"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.6811319893255463`*^9, 3.681131993088397*^9}, {
   3.681150872988818*^9, 3.681150873087818*^9}, {3.681166658951432*^9, 
   3.6811666654983597`*^9}, 3.68123025882275*^9}],

Cell[BoxData[
 TemplateBox[{GraphicsBox[{
     GraphicsComplexBox[CompressedData["
1:eJx1nXm4ltP6x4uMoTiGNJHSEaGcZLbMlRyk0CFKio5kKkpHSqGZDKlDMpfQ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      "], {{{
         EdgeForm[], 
         GrayLevel[0.8], 
         GraphicsGroupBox[{
           PolygonBox[CompressedData["
1:eJxMnXeYFEXXxWd3Z2Z3e2Z2es1ZwYCYA4oEERBERAVUFAEVCQYMqAQVBQVR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            "]], 
           PolygonBox[CompressedData["
1:eJxFnWOYPMnTtXt60DPtWdu2bdu2bdu28Vvbtnf/a9u2bb/3vSef6/0QV0d2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            
            "]]}]}, {}, {}, {}, {}}, {{}, {
         Directive[{
           Opacity[0.3], 
           GrayLevel[0]}], 
         LineBox[{2527, 3710, 2525, 3709, 2526, 3730, 2555, 3729, 2556, 3739, 
          2571, 3738, 2569, 3737, 2570, 3759, 2599, 3774, 2619, 3773, 2620, 
          3790, 2645, 3789, 2646, 3807, 2673}, VertexColors -> None], 
         LineBox[{2531, 3713, 2530, 3712, 2528, 3711, 2529, 3732, 2557, 3731, 
          2558, 3742, 2574, 3741, 2572, 3740, 2573, 3761, 2600, 3760, 2601, 
          3776, 2621, 3775, 2622, 3792, 2647, 3791, 2648, 3809, 2674, 3808, 
          2675, 3821, 2695, 3820, 2696, 3840, 2725, 3855, 2747, 3854, 2748, 
          3873, 2777, 3872, 2778, 3890, 2805, 3906, 2833}, VertexColors -> 
          None], 
         LineBox[{2548, 2549, 3728, 2550, 2551, 2565, 2566, 2593, 3757, 2594, 
          2595, 2616, 2617, 2641, 2642, 2669, 2670, 2692, 2693, 2723, 2724, 
          3853, 2746, 2775, 2776, 2803, 2804, 3905, 2832, 2864}, VertexColors -> 
          None], 
         LineBox[{2552, 2553, 2554, 2567, 2568, 2596, 3758, 2597, 2598, 3772, 
          2618, 2643, 2644, 2671, 2672, 2694}, VertexColors -> None], 
         LineBox[{3382, 3381, 4320, 3415, 3441, 3442, 3469, 3470, 4372, 3497, 
          3519, 3520, 3549, 3550, 3573, 3574, 3601, 3602, 3624, 3625, 3646, 
          4468, 3647, 3648, 3673, 3674, 3687, 4497, 3688, 3689}, VertexColors -> 
          None], 
         LineBox[{3413, 4319, 3414, 4335, 3440, 4353, 3467, 4352, 3468, 4371, 
          3495, 4370, 3496, 4385, 3518, 4405, 3545, 4404, 3546, 4417, 3567, 
          4416, 3568, 4434, 3595, 4433, 3596, 4450, 3619, 4449, 3620, 4465, 
          3640, 4464, 3641, 4485, 3667, 4484, 3665, 4483, 3666, 4494, 3681, 
          4493, 3682, 4514, 3706, 4513, 3704, 4512, 3705}, VertexColors -> 
          None], 
         LineBox[{3548, 3547, 3571, 3572, 3599, 3600, 4453, 3623, 3643, 4467, 
          3644, 3645, 3671, 3672, 3685, 3686}, VertexColors -> None], 
         LineBox[{3569, 4418, 3570, 4436, 3597, 4435, 3598, 4452, 3621, 4451, 
          3622, 4466, 3642, 4488, 3670, 4487, 3668, 4486, 3669, 4496, 3683, 
          4495, 3684, 4516, 3707, 4515, 3708}, VertexColors -> None], 
         LineBox[CompressedData["
1:eJwl1FdszVEcwPFTI3FrtDUSEtXxZIsRJbGJEaONkahZ48FszZIgqNlBBS1q
S1SoFyRUYgQvJF4QK2LEXq2VGE98/vHwvZ/7+z/cm5xz/idtZt7Y3LgQwkgf
BU1CeBMLYQ/j4kMo519zGYP5GJvyKJN4hAk8zESeY3ueZQfe4EBeZ39e4wDe
ZTbvcBJfcRlfcjm/sJC1LGKdhBAqGccTTOJlJvIK0/mEPfiT3fmLQ9i0YQiD
2YwT2JWzOIwrOYsrOJtbuIblLGMZy3mS53iRt3iLz/k4+h9+YKxRCH+YzFhi
CJ3Yin3ZjqPZmzM4gkuZzWLO5VFeULW2me/xkz6ryly/cQhXmcIM9dJEZetr
9Hss1Q6dUpWu6bqe64V+6beaWdcJSSE0Z4toz6L9ivYqWn/PBzGfgzlEk6P9
ME/hVM3TTvN87uIC7uZCljGX5czjHi7iXi7mPi5hBZdyP5fxAJfzIPN5iCt4
mNOjc8BpLGYOSziGazma65jJ9cxiATOYy57MYxqnMZXTmc4cxjOTMWax1hr1
Yw378xG78SG78zJTeImprGQijzOJRfxrT/JYw1zWcjyfchyfsQdvsw2vsB5P
sm60h/xo7yt4l8W8wxKe50oe4RwWcSKXcDhz2Iuj2JZ92JId2YCt+dtZbcD3
0TvjDD/iM97kTVbzLM9od5R5NVdppvLNQ6Pv7MLOSlATfffudfX8Ae/roqqj
+yO6O7RBBVqg+cpSpm5b/zHMUE+lKkWnPW/DKiaznupqr7kOf7ijvqvU/I3b
+ZXb+IUlrGUxa1jEzyzkJ27lR27hB27me27iO27kW27g69j/e/Ifb4m2LA==

          "], VertexColors -> None], 
         LineBox[CompressedData["
1:eJwl1FtMzmEcwPG/w7wWlVPlUGFsNhSVwxwvpJTSpotsDnOYY06zOeUQbkx0
g4uYC6ZQjc2FUBib06YbG7lwGsacNzZGjPk8c/F9P/td/d/3+f+ed/CS9aXr
OkRRNMJHbUIU9YmLossczUscxYvMZBNH8gIzeIfTeZvTeIu5bOMCPuQ8PuB8
vuFmvuYWfuUBfmE1OydGUT07sYG9eZ29eIND+ZRD+Izj+JNj2c589ukWRXlM
YhmzuYwFXMpCVnAZq1jJfdzFGtawkRfYwnts5Qve40s+Ds/lB8Z1j6JfTGdc
D+fE/pzK4SzhRC7hRm3SXHM1y3mSFWzmQ7XpmPkzu8RHUUw3zIM4QRM1V/O0
UZt0UId0Vud0U7f0Uq/Urtyevid/K9l5l5lT2De8Uy03Z3AFM7mSo8IeKC+8
L3M+t3IGK1jAbSzkds7kDhZxJ4tZyWyuYhbLmcPVHMM1HMu1TA/7wrSwLxwY
9ogxFrMLZ7ErS/jJb5nMj5zCRxzNNmbxCtPYwnTWMYG1TGQV/zjbffzLtfzI
NfzEUj7hbD5lDluZxqtM5TV2ZD3fe2dH+I5HeZ/72cQtPM4VrGJZeC7ncANn
cCHHs4jDOIkpHMEYB/CHXYvxLb/bwW96prvmu7zE86znYR7SNu01L+aicD+0
2JzBkYpXd30NdzHc23Bnw/0Pd18ndFx7tFvlWqXnYU84S8VqNReF+6gxumLO
YQuz2cwspmqAGs392cB+rA/7yDNM4Wkm8xSTWMfecf//p/4B8J+cNA==
          "], 
          VertexColors -> None], 
         LineBox[CompressedData["
1:eJwl1FtojnEAx/H/sKUdjHJopjRlFxPLmU25sIO9LraUzGEbwxSFG7OD0xVR
m0RxwcohK1t2YeRwRW2zUTKaM+WwoyjcMKfPm4vv+3l/9fbW8/yf900r37ly
R0wIIdlLx5gQ8uJDeMFyPudGPuMGPmUpe1jGAdaynzXsYxV7Wc3vPMZvrONX
1jMuOYTLjGUTJ/AOx/Mu0/mG0/mWi/iTCznM5ZyYEEI+J7GYc7ma81jBCGtZ
wRpu5VEe5GmeZjOvsYnXeZv3+YDv+JI/+IkJiSEMMZHDnMqEsSFkMpVLWagi
ZdubGGEl17GOF3RRNfYt1rOHn/VFzfbopBDSNE3ZWqL1KlGl9uiETuqKWtQW
/fy4ENrZofdaYH/gQn5kr34px/7NXP5hHv8yOJsUrbYns5ipXMMpXMsRzGcM
l3MkCziKEcZyBft93yL2cTEHmMXB6DXxMWeym7P4hJm8yVTe4BSeZyLPMYmH
OeweHYpeC7dzgNs4yCI+ZyFfcA47OZtdTOVtxvASAxvZ596f4kMeYSt38yor
2cAKHuYq7mIeSzmfJVzACNOZxYnMYBwnMyX6Xr2enW+eqad8xXa2s00tarSP
8wSrWaUy7bZzuEwzlKEExeuL38RndeuRrqlVDTqrv87lDA9ov4bsfRzkXm5V
hV7bW/iKm/mSmxhRgbqi587O6HPAe8yN//+/8Q/pt5dw
          "], VertexColors -> 
          None], 
         LineBox[CompressedData["
1:eJwl00lIVVEcwOHTQtKnNizUp7QoyvRlkIsKjIoKWpgUFG2KMAhDJciNZOOi
kaBIG7RsoBbZKsuhFBpWCU1ObVKqRQNWYEEGmZpa36PFj49zuFzOvfd/5+yo
2LR7SghhUL+mhXA2EkJkegh3mcQ7TORtTmUjM/iE6exgjB+Zy/fM4Qcu4zgL
OMF1jCaHUMhMbuUSbuFSlrKIh1jGgyznaR7mKR5hPevZyHY+ZicfsYtd/MR3
HON3pqY4C2czZUYI+ZzFVczjRi5nCYtYxTOq1i7rBh7gQ/apXz80pEb7Sakh
zNU8rdBKFWu79mrINfu4X7WqU5PSZobQzHS2sFXP4veyfh6/H18wmy85n53M
YRdz2c0Ye7iAvczjKy7kfWbwHqNsYybbmcUbjPA6k3mMI857lKM8zjGW8wvL
+JUb2Mf17I+/Uz7lovgzMIsP+Nc7uslJNvAzaznAOnbzJFtYyWss4VXu5Alu
ZgXXchsXs5DZLGAaY0xglMO+dQIH+NMMvOZbvlGH2uKzzVusYbWqtEfFqrS/
hqsVU66SlBifJ7P8TfmuGWSvetSqFqXYb2Yym3hFlzXp/6rnBC9xnBf5h3Uc
Yy1HeYEjPM/fPMdh1kT+/6f/AE3Jids=
          "], VertexColors -> None], 
         LineBox[CompressedData["
1:eJwl011ozWEcwPEHx8aZeSllr7Sykb1ILqzQtnIhO7s53G3KyNtacyFFmLeN
K1IUzhk3yhXKhZrCjc687ZzdoKZc7WxeLsRsXGj4/HPx7dPze+rf/9/z/Kt2
H0r2zAohjKhkUQhD8RDqOcE6jrOWY1zDPDfxDzfyL9tYURRCgmVsZTk7uIHt
bORBJniAbexlFy/xHC+yj2mmmGKa9znIp8xxJHoP5qL34wf+5lcuXBDCDKtY
vDiEdaxkC+uY5Gbu5VEdU4f1ZXbzDh/riUb1XgPmk4wXh1CkatWoSVl7zWzR
LnXquCbNT/AHT7JX1zR7SQjXOYc3GGOKc5lmAQdYyJucx1ucz9Oc8rxTnOYZ
/uRZ/uJ+jnMfJ9jKN9zGt0zwHRuYYT2HWMpBlvARZ3zrbeZ5hWO8yizPc5gX
+ICHmeYe9jPJPm5nD7ewneu5lSvZyKVczRiXcdqZxZjnd2f5TaPKWD/jQ97j
3ei+RHdFR9RvvjO6a2pWk1apRjvsVbNQBfrirn7WWvNPbOBH5pTVCuthLudr
VvIVK/iS5XzBMj5nKTPx///NP+pLch8=
          "], VertexColors -> None], 
         LineBox[CompressedData["
1:eJwl0j1IVlEcwOFj6uQniDllqYGpLb1LlKnhZ4FofiwZlr2Zg6ZBNbUklC0J
lpuiQy1BDTpE4uJXTgr6VkiCEqjRapCbIj2Xhh/P/cO5cM49tyD+sHUgKYQw
pYqsEJLSQmjhGd7gaTbzFJuYzzss521eYicvs49N7GUzB9nHZ3zA1xziCF9y
khOc4CSnOMsFrnOeCSb4mz95xD/MSg9hn9k8ZiEzs0OIMZ/VbFO7Ks09bORT
vtGo+s3vOad5bWlbf3Wg9IwQMlSsRWvPsUTVWjPXcJ21rFNcO+Z73GU393if
v9jABOv5ldf4jdf5nWVcYim/8DyXmcfPPMkZHtnbWx7yHXejM3EnOhdX+YIr
HOI0H3GcdznGOJ+zhf2sYQcv8CZj0X5ZxIvMYTGTo30wN3rWnm+/7042uMkf
WtIn80d+0LBe6Yke65Y6VKkKdVl7hWdVpLboPtnKAqYqRVfNyaziieh9hrT/
/+0/edJazg==
          "], VertexColors -> None], 
         LineBox[CompressedData["
1:eJwl0j0s3GEcwPGH9XCOmgWJTSJpYpWQWCm9YpA0Fsu5F0aWOxK0Q70sXdx1
ZMF5WWpxiYGRwVbEwkIiUUUi+rkYvvnkl/8vT548+TeNpvqTFSGE70pEQ/gU
CWGGKeY4ziyTXOYclzjPAvPMs8Aif3OL+yzxhKe85glveMFX3jNWFcIbWxit
DeEjG9nNNsbZyTFOaVoj5hWuaV0HKumPzvVXq3Ye+U811SFsmKPcZC23GGOR
ddxmPXf4gbts4B6fnZHnEwt84S9e8gcvuMhj5njEGW4yzQ1m+JNfmWMvs+xj
gl0cYjt72MwO1rGVleV78cFbVfKKd97wVmc6NJd4oHWt6ZsWNKGMZu2kOawh
TZoHy9/5pbzDONP8zBQHmGQ/x9kXef9P/gNwCFIZ
          "], VertexColors -> None], 
         
         LineBox[CompressedData["
1:eJwl0Dsvg2EYx+H7ndtE8QU0Ya2FnYSRwcCmSSeHpP0CaH0Hh7VHEoeF1SFp
HXZlZ3SYdMf1xvDLtfzzJPeTL1WWyklEFFUfimhkIi55xQtes8cndtnnM9/Z
5wff+MNX/vKbI1kP5iLGmeMUxzjHApe5pnVta0d72teJTtXVlm0v3fAu3fGe
VT6wxkfu8pxlnrHCQ67ygEXWuMAqF7nJGW5wliuc5DzznOYwJ5hwlAO3Jelt
+nLrp17SP9GtbnSsI3VsO2yzzRZbbLLJBuuZ/3//AympOmM=
          "], VertexColors -> 
          None]}, {}, {}}}, VertexColors -> CompressedData["
1:eJztvXdcVGvSNaqoqKioiJgAE2JWzBhLUYyomHOOGDCAipgQFbMHIwZEMGJG
TIABMWJCRMmp6W6ggaYbxYBiuD3j2sd793frc5hXX8GDf83sw2+HqrVWP1VP
PVW1J88bPE2rSJEiRysWKVKsiPAvi6b/+5+Kvv1/BQnXTTooWykrqKhE5uik
gAmpf1+vutXXYrhfJm0L1r3h5Z/y9/XY5Gw9rXGZlDtgo2yK7vfrIZkmF8Z8
VZKscz3l4/HJf19/N2rUkPhDSjq3odenm6flf19P66v00SUlLS57bXPHd7K/
r5/ziNZbG59B60uPPDKCZNThxdPk1TI1pbXKzg35K4NmerstS4yRUv8qJSMa
3lNT1fHOL193z6COwdIVIculFGknndbmhJrm3zO9Xv5DOqW0WjDsdU0pPZw9
pFjCRjX1bxFkefl8Ol2bMVDn890kOrLDYeT4uWqy1fOovnhmOt374O1wdE4S
2eT03/ZqkJoSXFvVTqmbTj0vvyrhWSWJBk5ftzasnZrc697csFeaRkHDZ7U+
fl9CDn6GWh1rqklrgd9to2NptDC8Xq1ZjhJ6d+ugdHIpNXXRzrUrOieNmkZc
frW3lYSaLm3WY1W2ih6EyWcEt0ujytf9j59LTqRyxv4BQRIVvbMlV1WpNEoZ
Ulm5YkEi5Zg7bBkRqiKLlgcNkxMV1GpS2nS/Mon0cGW1TzNvq+jJRJ+LFW4o
SFfP49KIywm0+Lbd0apXVfSl9I6oB54KilEUmdxyXgKpJA5pzudU1CjCeN2g
zQp6GzXEPqd9Aklmeay+4a0i7fPLi8qXK2j2lNKbzAwS6JT/guqRxzS4ebPl
65FFCkrv9+ZIm+L8deE+JXGfObgP91zuPYXveorvqoDvEuzQA3ZoCzsIdnsP
uylgN8HOwbBzVdhZ8AvBL83gF7Ef7eBHa/jdA36/A7/PAk4kwElv4ETA1Tzg
6j5w9Qg4HAgc3gAOBdwuAG4VwO0A4Lw6cN4FOO8IXqSDFzbghcCjC+DRZvBI
uJ4B3i0V8S4HPL0g4mkoeJ0i4nUcdOCLSAdqQDd2inTDFDpTSqQzedUlv6D9
fYdeyqT2jaVljH2/37/ZptlTxg/NpCpHbD6affn+noYfBj6Y90pJ+tmXd1/o
8f26pMuq1Z83K0m+O2TwMpfv32tz/dibzSZK6hl0ZZbLXRntfNbO3O69mu43
+tTnVFAGSWwq5V6oKqPdpV172Eao6cm1KIXRvAxSWG9+OcxXSodeHvObcFlN
U9uV37zUMIP8zhxQx/aTUgX7ou+cdqmpSE/7o1aP0qnlgOdN3yUn0YW3LY11
7dWkp5O1oenSdKKd7d6PX51E3s61Z1gOVZPjrB6BVxumU6nKNUwjjZOo8Z4W
46a3UVP3A3NMN8Wl0WBjp4C6gRLqkdXa4EIVNTl9evOmx440ClPMH19mioTC
y+8bOS1XRXP6qfev75dG0hUx94aUkVBZkc4kgy+OXXfc1ApWUWnLhGoVHyto
bMNXxSpGJVCZ7aNUky6oaOE264qrdijI/sr2Hff6JVDXbXu+6B9U0ZKSaf43
JyjI9FiUq+JpPJnss/lotVlFPocdzvdtpaAll7dVODUhnkxTN61ss1xFV5Mf
f/irnIKGPHm3uKpWPBlUHlLyzTwVbR15a6BSlUp+zjZNDa/EUZWud4ed0OCj
Qo/YnWciU2n01q0Su+Vx5NO5knr6RM31m7V2lglOpdMX4qdcGBZHu/oe8rcY
p6I+CSvLtbiVSp9mePdrZ8FfvyC6zxnch3uu8J7b8J4BeM/6+C4/fNdQfJdg
hwuwgwPs0A12c4DdGsJugp3tYGcH2HkZ/KIDv0yAXzjdi4DfbeF3GfxuCZys
AU7CgZMmwJUlcDUMuBJwuBw4LA0c+gK3lYFbC+C2InCuBZy3Bs49wYvp4MU1
8GIPePQMPMoAj3aBd8HgnRy8E3g6BzztC54K16XgtULEa2PoQDWRDphBN2qI
dCMAOtNZpDN5XS9xurQ3cn7CHaWSOu+q1E3d8fv1nKCkcm9Wa3S4X8n9J+2+
v//SSYsGztVX0m2DT2+sjsuo6OCGo3tnqSkmK9I48HwGucut5Eu1ZHQ7wTsq
5YmarocajOk3IoNeVz126PEuKZ17q32k60k16ehohTf+kk4z7gdP6G0qJbPc
VRVd16kp1M3M5vXRdJLeKFvs2NUk6vxob5VKkzXrqIO2Oe2tNL9TlL3bq08S
var4ylOH1ORr/fjZ0Tdp5HF10KiS8RJqrUyO9DdU08iFzaNjPNJIu+H5NccX
/p/6kwQczty5ecjgWBWN3tVfd2SugtY0btb+8cBEUq5df+TedRWZzu8+POec
gvyeJ72dvCOB2pwoG6vlqaIYywqTKs5QkOXx1ZcqSuKpdXx4/37rVBRtVdKp
p4mCyr9tunxOh3iq1Hpwjfg5mvWM6c2irVJTyT7ObPGbw3HklKxHr4eraG9S
zdgZPql0aYx3rYo14ij2Weszgd1V5Hj6zWwbp1SqOq/XPZ2jsdRjwzkH+1Yq
Wp1jMvvsiFQq6+Q5uATFkmGHJkbtTVVk2GaC9r62qZRYNPFSrjKG+usGPW1m
qLl/rxe0yiiVKgQuDb52LoY2lGqjtq2soibtF+08VDaVnEJ6f5GujaE5i6qd
0dFT0fQ+PhkmxVOpRNTBu7Hz+OvcfcTP1cNzufe0xHc547vK47sEOyyDHQxh
h9Ww2z7YzQ92E+xcEnZeAju3gV9i4Rd9+EXwYxz82Bd+zITf68Pv1+F3G+Bk
HHCyETjh9K0NcDgaOCwNHL4Gbi8Bt57AbRfgfCFwHgictwAvnoMXcvDiPHhU
FjyaBR7dAe9ugndvwTst8DQOPPUATwVeLwOvH4DXwvVc6MBVkQ7sh250E+kG
p2N5jeO49RKnS3X80rYXL6+kru33bG/gLqOVi7Uvn1SqqdKTIs6+xzOoVqcH
fbu9l9LNEmW313igpla+ug2e9c6g1g5R9uHOUqrkaNqstJeatMNDzbzS0snW
8ZT3s7JSems5L/6Mo5quhWnPCNiYThW2LDwn351EJ/B7tBS/R9r4PWpu/8G+
cjM1WfWUaBbZafT+0uyri7y/x1+dsc5vgnV+eEqDd4tkKlLKI0wulE+jRm6f
b3dzTqTsjfvW7A1U0ZXl811KXlHQmRtrH8qPfF/nLMbvtQl+r4X1zBX87lvj
d38n1hu9sN54j/XGLVenXOeumr8v19J3kEMqlalhJM/5K5ZqgKc1wNM48LR3
Wr01R3RVVHb2wBJHclNo1PG1O2+PjqEW9VfWz/2QSWElmtT68iCFHgeeCDoX
E01zWmZfWqjIJLlXaNGG7inUNkw26ePcaHJ42tyvTUwmramn2OjqkEI1mr5d
dLFyNO02vJMx41kmWc2O0tk2LoW0Vro4Xw2LokdlpIdNgjPJOujYy2n9UuiC
NPHV+WNR1O3tqOEr72bShw2DKve0SKG7dXf1Lf8Xf124zyDcxxf3ET+3OJ4r
vOdavKch3lP4rhR8lzm+qyXs8AJ2eAI79IHdysFuY2E3QQ+NYGcJ7BwEv/jB
LxXgF2Hd2Bd+/Aw/cus9bl0n4OoqcOUDXEUAh2rg0Aw45OJTM+B8AHD+ETjn
1mnvwKOb4FEl8EgfvCsN3i0A7wLB09bgaVvwdBV4XRm8NgGvBR2oBx2whA78
SMe49Vhe80tcHCdeL3G6JOSRqiC+7oD4OrfJHLnUXU399Fc5dEtMp6hXCtfX
X/l47eoNB930vmqqvdJj0hC9dMqo2n1neNEkOthxuE5AbTUlmPceMeZ0Gk0b
XKZWfWcJDZZNd72Xo6J6cQtMc3qkkdXoY9SimITeI7/RFfmNZshvJCKvUgJ5
lZnIq5Sw9j7Y01lFstm7HwQYKsgoa+nzy/V5/anl6NWvaAfN+mrYWsdyM1Op
8dvLXl4zYun2mKwBoVVV1GnjQ61KlVNJbh42MGrfd515Dn4Fg19fB+1yeRif
SeHzZeWcV6fQx91ui5IaR1NX6MB76MAt6MCzW9q+w89lUvy61R+lOilUwtLV
8GKJKFrRe27WhgOZVCF69R5JbDJ12HYszGh7JPU52/l+9y2ZpBuuc/bi5WQa
37JfkQUtIym2/qu1Z50yaen6x6Wv702mC66dzfenR9CzYQGOModMGudokWWx
LplCJYZNBgZE0JfmtZd8sNfow4HuqUuXJdPtsTPO6xzmr4vvE4b7CM91xHN9
8dy+eM/yeM9JeE/xd3XCd4XCDgmwQynYgdPPIoO/2TkCdv4CO3O6dwd+7Aw/
psGPteH3BvC7GfzOxcXawFUKcGUCXHH5PS4vNwQ4NwXOBwDnHuBFEngxE7zw
A49MwCMVeMTFm5/A0/7gaQx4yuXNfqRj3HqMiyvzmvcW55e4OI5bL3G65Pxm
8tzwBWoyLKkIOWSXThPHWmkvd0yi6jL/MWY91eQ2JqjOGu100up6y7l5toTs
RiZubFtdTe+K1NyzY28aPWpc1DJuloSOz/fLaq7SrHNudK7i3CiN2q5f8vL2
3UQKRj72EfKxpZGPXTZiWVALNxVt+mLipT1IQTsG7Tk/42Q86SEuKIG4YAHi
ghjEF0sRXxggvrBC/LIH8UtZxC8ztkbNW/Uuk0aU0A3vHZhCy9pH1TC4F039
YqZmFn+RSTvvKbftmZ5CHsuPbjFOi6I56X3jyvtq1j+ZjeUt9FPIXdL2erBh
FK2rvjlBuTOT6k5/YhMTnEzFuzR+pJ4U+Tffx4LvIeD7uAkltdpMyqSuemtu
6/ZNpjjFxOhl9SOoXbHYjTX6Z5Kksb7BsyrJFCDpnxV/Kpxe6L/4EtxJsz4Z
4RRQRC2n1P5Xck5ZhtME2YTh080yqfvYiZV1QuXks3qwXJLzkuamn5HpNdD8
fabn4vbX5OQl+ZTW7d5L2lTx+gtZ3UzyeXY/5I6PnG7OeTNk0Gn+unCfVNzn
MO4jPLcHnuuL5wrvmYr3TMN7Ct+VhO+6hu8aDztYwA4S2CEUdhsPu72A3Vxg
53qwcynYeS78kgK/eMIvVvDjbvjxKPw4E34fDb87w+9cnMvFrVx8uhy43QLc
7gVuuX2HE+CFA3jRCbywB48+gkch4FEN8G4/eFcCvFsDnhqDp5PBU0HHBoh0
TFiPtYEOtIMO/CiunAudsRLlx/7T/Tgu783ll7g4jlsvcbrE5bGbBbq6RCpU
9HB1TLl6RmnU3+uSt8eRRDJYGT4qy19FuhO0jWUnFFTHPqdJmFMC1UXe9Rzy
rvORd+XWRdMTqsU1NFNRxMALsoUDU+lU87m1DzaKpbYbbLeMLa6icTlr3V8l
aeKXVZJ9OjViaAnilNWIUwyEOEWkP/uBc2E9Uw7rhLFYJ3iUaGxd3yaTZC3i
1inHafgy/OimWyMjyO5Gc+OyfTJp8efUDd7lkunBwzfrL2wPp/n9Nk/p0iST
5kus2h6/J6dBc5vYGCa+pGrz2l0pVimT9rTPXbtT8/s0s+8rdx+LlyS9PPn9
vs9K2jortX6ZQXJa1trtUeaNF7S1iGp4W6WS2h67Y7Cjnpye2rheMhr8QoPL
rUuKJyrpcJtBM3cXl1OtJu2SBxR5Qbm7nfzqRSjpUXXfTTNVMqoUfqWH9cMw
elyv0kmf50oa5FxL3l0mo9VG8RfOnuWvC/d5jPvo4z7Cc4/guXXwXOE92+E9
n+E9Zfiubfiulfiu6rDDXthhDuywAHZbCLsNh93sYWcH2PkJ7HwIfkmGX3Th
F269x+kbF8+2A64mAFd+wNUM4DAKOPQBDrk4VNhf8AXOHYHzKuBFRfCiEXjR
HDx6Ah4NBY+4fQFOx7j1GBdXCvmxQOjGO+jGj/L8/2mdALcfx+W9ufwSF8dx
6yVOlxZhX/sT9rXDsa8t5KujkBfVRV70xsjJb+8NUWnWByl1lnqnauKsSa+m
lowjQzfblrI6KjpotK6jRbNU0o+TzO4fFUNrfK1vFsnOJKPJHaptuZJCDf1H
a80+/z3+eoc44ibiiHETUlyuu2nWMzt8tk0KS6YTlz/Guy6NpEjzK1NrzM2k
Vy3M/UNmaNY/923md18QQZH75nX40COTFhxdP3BpMU085e90cJ5DOE13PGt2
oaYmHhlWp53lcTktcW21q+/27zqzBXxcCj6K9aQmeD20pM5HEzclbepl9qaZ
5vep+ZWRngtCwki7fFKL0FJKym2svtBwh4wsOx0u/XDRC7qVbrWpw+4MujN4
4v1NNjKq//Sz6bnPL0hrSnNdl84Z9EyiV8uvr4wSylm8ezz1JR248eovV60M
Wr077eLXNjJSjtx1yujUS7Lpt7FYljydHDsmtN7TWEZ1HJzfvX7CXz+I+zjj
Pum4T0k8NxTPjcZz7+A97+I96+I9S+O7PuG7uuG7RsAOm2GHxrBDTZEe1oXd
BN37C3ZeBTvPgF8i4Zdl8EsU/GgPP0bAj1Hwezb8Hg6/jwdOLICTs8AJF5+u
BQ5rAYfNgUMj4NYTuK0O3AYC5xeB81DgnNsvENeHxIJHnI5x6zF/8LoeeJ0F
Xgv5sUDogD50gMvzc/uVnC5x9UtcnQC3H8flvbn8EhfHceslTpdypGfe7rHW
xPWxnkfWeKaSe3Lz7BPZfLw2G3laGfK0LZCn1dGTxty7nEnq0GMSB6MUKnVk
6cVHraIo/HD77VvXZlJ6gFODOYeTaeTNx+meWpHkaR9U3GxYJs3sNbSPVpNk
SjokXfMuLlyzvvoW78gR77gj3hHrjwN48RHrjYdYb5THesOg/fkWDvWU5FRv
RWRHdxktrFzufZWhL8jLLL1R7OgMcmncw7DkMBnJ99uOGahZPxzdPk4++WQ6
DZ/2YaW3gYw+uHtmvdMLJwvf08dua/C06oEsxy9JSr36jXutezecGqm0ts/X
4C/IvZL29StSumFi65Q4JIJmbF+891DHNNrcMnyd0R4puV+p5v/1VgQlfg5f
1uGzgiIWVslp7iSlLw33uY/RiSRFroUyMV5B7ta6dRovkpLeDTM38+b89STc
JxL3+YT7zMRzt+C5+/HcJnjP23jPa3hPS3yXE76rO77rFOwwEnZ4DTucgN02
wG7xsFsN2NkZdp4DO3PrQG5dJ8S5Cvj9KPx+GDiZDZykAScRwJUKuJoIXJUB
Dl8Dh+WBQ25/gYs3P4AXPcGLw+AFp2PceoyLK4X8mBS8tgGvT0IHVkAHykAH
hP3KMOhGMnRDXHdxHTqT17pKrn6JqxPg9uO4vDeXX+LiOG69xOlSUe0JWgp5
JkW1HN99wM4UshnpFFt8ZPTfeelY5GOLIB8bgvzGGOQ3HiO/IV4XheD3VIi/
diHumIa442pDz6a2MiXVKrv6/MHycvLUSqp+usYLWll70aOSFkpKfLrPxvK4
jGKizHevafmCimJdEYJ1hQTrihWrzSUDB6bTu4odfIq8l9Lz4fXi4peH04pB
Fh77l6bRiefqR8mnpZRz/JZrLYcI2lP90Y5ZNxVUwiE5yXCWlHx0blZoMzSS
OlVuEbuppoI21L07oFdLjV4FpG7/qhtFeke7GLh4pFLPsbdvqYtr4vnysUY+
x6MoqG9wcc9OqTSchnxdL02iuHelKjyqFk1HNwzpFvoxhdz3S3RnPE6i4WWu
9ms0I5r0DmxpejM6hRJzZ9x+EJhEvXoHlCi7jb9+XHSfobjPbTx3BJ4bg+dW
xnv2wnuWx3t2w3dtwndZ4Lv2ww7asMNp2GE17HYSdnsNu62Gnd/Dzo9hZ269
txZ+lMKPL+BHP/i9LvzuDb9z8Sm3TuPybMI+QiJwWxq41QLO44DzBcA5p2PC
euwSeBQGHnFxpZAfCwFP9cDToeB1A/DaGrwW9isHQgdyoQNC3YUddOMWdENc
P9YGOpPXem8u78TVL3F1Atx+HJf35vJLXBzHrZc4XfqMfatQ7FsFYN8qDHld
OfK6MuR1g2rX82qjnUkdHPpbu07XxAXFLzpZZb+gR8jPWCM/sxz5GVvzue97
+GaQgan5mkA7GT3bvWDMxtgXtGVcT9PFmzXx/KNkc5OyMlrjEfS8XttwWibS
n4/g0cr960ybr1JQbWWRYvIhUvIPtVdu8YikCiKdqQz+loc+JEAf+kIfQq4O
qBjQMoX87iw/XnldEh16kNncZnAM9Tx6eF/V08lUpEFAu9nDkqhYw9yExFcx
9HDLK+NmPZJpg+Mwva4tkqij23hl4qxYWmjWXfnli5yGbxrvo66aRKdnl7Ju
dz2Wijzo+b5DnJy6BO9WXC2bRA3bpjWokhxLWrhOuF4f17n7PMFzN+K55nhu
b7xnUbzn1wbf3jMU3+WP7zqA79KHHSSwgyXswOneOti5Lux8AXZeA7+cgl+y
4Jcd8KMd/LgcflwMv1eD3+/D70IebzBwsgY4uQNcdQGu1gJX4v2FdODwq2i/
9Q5wy+kYtx4Tx5WG4NFuUX7sC3gn5Pm3gafu4OkH0X6lOXj9HjrQFTpgBh0Q
6scuQzcOQzcuQmcMRHmwvJ5D4eq92bpKpn6JqxPg9uO4vDeXX+LiOG69xOlS
ml7zw2lFM8lwSMrgsDFy8oqtu9476gUdm/T43pCLSrpbftBqgxAZBb3X1h2o
wdshUVyWgviiK+KUlYhTeiNOkYviIwPER43tPrtl3Uylfae7NBxaQUrWVRNm
7HSKIqeUUVF/+aXQxR0R640vJdG8C21ydC9H0+BV1aY3eZpMbjflBtMmafiu
pa7z7GEMzYcODIMOnIUOqMpF1ihqLaeRucPKzo+V0Llwh9dvNsaRRe+u7slB
MhoSdCdj5UkJjfUbqVW6RTy9PrtCu+JwGVWIK+u1b42EBtxb3Dn0fDwNH7K9
0q5yMrK1W1e81iwJdXp5/EvpEgmUeL1VrfppmnhvrVQyeJyEJkrD18Q3TyCJ
6Pp4XB8puk8H3OcNnlsRz7XCc3viPYfiPUcJ74nvGoXvOoXvshfp4UnYYSTs
th92Owq7rYWdL8HOs2DnVvCLO/zSC35Rwo8e8GM5+LGXKD7tBr9zceg54CoY
uLoCXKUDh7WAw9PAIadj4vVYOHAuxJXZ4EVF8ELIj9UGj1qCR0KePxq8uwje
6YOnpcBTR/BUqLsoBV7bgteR0IEs6EAr6IBQBzsWulEGusHFj3k9H8edQ+Hq
vbm6Sq5+iasT4PbjuLw3l1/i4jhuvcTp0tfJ/994TYq4YOi96fefhqfRLLs3
L62eSImk+2T+Zfh10S1RnJWAeMfpY/fSnyukUHWX/ZYdlibRtSM2ikqOMTRP
pD/nwDvjYQveNy8tp2JpN4O33NbwtMopv3bxcaTu30JL2kJGh+Ys6yZdLCGd
+M2vRsfEk75Vy1r1lkmp7C5Pn5NtJdSsX06N1hcSaHjIhraBKUn0vk27/c5a
mvXxkgjXsxMSqesJqxMmi5NoZ7Ez/omXE8