(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     49573,       1345]
NotebookOptionsPosition[     46036,       1252]
NotebookOutlinePosition[     46391,       1268]
CellTagsIndexPosition[     46348,       1265]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Identical charges confined within a circle :", "Title",
 CellChangeTimes->{{3.682442026869276*^9, 3.682442059556175*^9}}],

Cell[CellGroupData[{

Cell["\<\
*** If any code looks unfamiliar, take it apart, and see what it does by \
applying to simple examples. ***\
\>", "Subsection",
 CellChangeTimes->{{3.682442334488948*^9, 3.682442417150363*^9}}],

Cell[CellGroupData[{

Cell["\<\
The function which calculates the acceleration of charges from their \
positions :\
\>", "Subsubsection",
 CellChangeTimes->{{3.682442064211314*^9, 3.682442094056615*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"accelerations", "[", 
   RowBox[{"positions_", ",", "radius_"}], "]"}], ":=", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Total", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"positions", "[", 
            RowBox[{"[", "n", "]"}], "]"}], "-", "#"}], ")"}], "/", 
         SuperscriptBox[
          RowBox[{"Norm", "[", 
           RowBox[{
            RowBox[{"positions", "[", 
             RowBox[{"[", "n", "]"}], "]"}], "-", "#"}], "]"}], "3"]}], "&"}],
        "/@", 
       RowBox[{"Drop", "[", 
        RowBox[{"positions", ",", 
         RowBox[{"{", "n", "}"}]}], "]"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", "1", ",", 
       RowBox[{"Length", "[", "positions", "]"}]}], "}"}]}], "]"}], "-", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"100", "*", "#", "*", 
       RowBox[{
        RowBox[{"Exp", "[", 
         RowBox[{"100", "*", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"Norm", "[", "#", "]"}], "-", "radius"}], ")"}]}], "]"}], 
        "/", 
        RowBox[{"Norm", "[", "#", "]"}]}]}], "&"}], "/@", "positions"}], 
    ")"}]}]}]], "Input",
 CellChangeTimes->{{3.682441202580323*^9, 
  3.682441208213358*^9}},ExpressionUUID->"ff32e48d-9f10-4f84-8731-\
4bd070e3b277"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Solving equations of motion without drag :", "Subsubsection",
 CellChangeTimes->{{3.682442120589175*^9, 
  3.682442130144495*^9}},ExpressionUUID->"9ecee018-ab0c-4506-a59b-\
c78c7f95d603"],

Cell[BoxData[
 RowBox[{"With", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"number", "=", "20"}], ",", 
     RowBox[{"radius", "=", "4"}], ",", 
     RowBox[{"drag", "=", "0"}], ",", 
     RowBox[{"tmax", "=", "20"}]}], "}"}], ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"positions", "[", "t_", "]"}], ":=", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"x", "[", "n", "]"}], "[", "t", "]"}], ",", 
         RowBox[{
          RowBox[{"y", "[", "n", "]"}], "[", "t", "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"n", ",", "1", ",", "number"}], "}"}]}], "]"}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"simulation", "[", 
      RowBox[{"number", ",", "radius", ",", "drag"}], "]"}], "=", 
     "\[IndentingNewLine]", 
     RowBox[{"First", "[", "\[IndentingNewLine]", 
      RowBox[{"NDSolve", "[", 
       RowBox[{
        RowBox[{"{", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"positions", "''"}], "[", "t", "]"}], "\[Equal]", 
           RowBox[{
            RowBox[{"accelerations", "[", 
             RowBox[{
              RowBox[{"positions", "[", "t", "]"}], ",", "radius"}], "]"}], 
            "-", 
            RowBox[{"drag", "*", 
             RowBox[{
              RowBox[{"positions", "'"}], "[", "t", "]"}]}]}]}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"positions", "[", "0", "]"}], "\[Equal]", 
           RowBox[{"RandomReal", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"number", ",", "2"}], "}"}]}], "]"}]}], ",", 
          RowBox[{
           RowBox[{
            RowBox[{"positions", "'"}], "[", "0", "]"}], "\[Equal]", 
           RowBox[{"ConstantArray", "[", 
            RowBox[{"0", ",", 
             RowBox[{"{", 
              RowBox[{"number", ",", "2"}], "}"}]}], "]"}]}]}], "}"}], ",", 
        RowBox[{"Flatten", "[", 
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"x", "[", "n", "]"}], ",", 
             RowBox[{"y", "[", "n", "]"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"n", ",", "1", ",", "number"}], "}"}]}], "]"}], "]"}], 
        ",", 
        RowBox[{"{", 
         RowBox[{"t", ",", "0", ",", "tmax"}], "}"}]}], "]"}], 
      "\[IndentingNewLine]", "]"}]}], ";"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.682441625969718*^9, 3.682441645876884*^9}, {
  3.68244176168279*^9, 3.6824417742416143`*^9}, {3.7095347072241383`*^9, 
  3.7095347143015137`*^9}},ExpressionUUID->"6cc933eb-0032-46b9-9cbc-\
262f3866f42b"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Seeing the charges move!", "Subsubsection",
 CellChangeTimes->{{3.682442136863414*^9, 3.68244214089441*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"With", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"number", "=", "20"}], ",", 
     RowBox[{"radius", "=", "4"}], ",", 
     RowBox[{"drag", "=", "0"}], ",", 
     RowBox[{"tmax", "=", "20"}]}], "}"}], ",", "\[IndentingNewLine]", 
   RowBox[{"Manipulate", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Graphics", "[", 
      RowBox[{
       RowBox[{"{", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"Circle", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"0", ",", "0"}], "}"}], ",", "radius"}], "]"}], ",", 
         "Red", ",", 
         RowBox[{"PointSize", "[", "0.015", "]"}], ",", 
         RowBox[{"Point", "[", 
          RowBox[{
           RowBox[{"Table", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{
                RowBox[{"x", "[", "n", "]"}], "[", "t", "]"}], ",", 
               RowBox[{
                RowBox[{"y", "[", "n", "]"}], "[", "t", "]"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"n", ",", "1", ",", "number"}], "}"}]}], "]"}], "/.", 
           RowBox[{"simulation", "[", 
            RowBox[{"number", ",", "radius", ",", "drag"}], "]"}]}], "]"}]}], 
        "}"}], ",", 
       RowBox[{"PlotRange", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "radius"}], ",", "radius"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "radius"}], ",", "radius"}], "}"}]}], "}"}]}]}], 
      "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"t", ",", "0", ",", 
         RowBox[{"Style", "[", 
          RowBox[{"\"\<time\>\"", ",", "Black", ",", "15"}], "]"}]}], "}"}], 
       ",", "0", ",", "tmax"}], "}"}]}], "]"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.6824412849040527`*^9, 3.682441388528425*^9}, {
   3.682441450747361*^9, 3.6824414516544647`*^9}, 3.682441666330567*^9, {
   3.6824417063072767`*^9, 3.6824417085267677`*^9}, {3.682441804192875*^9, 
   3.682441811138584*^9}},ExpressionUUID->"2e0cecbb-c6f6-4f7d-809c-\
6e4a6bf3c361"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`t$$ = 14.100000000000001`, Typeset`show$$ = 
    True, Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`t$$], 0, 
       Style["time", 
        GrayLevel[0], 15]}, 0, 20}}, Typeset`size$$ = {360., {178., 182.}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`t$169871$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`t$$ = 0}, 
      "ControllerVariables" :> {
        Hold[$CellContext`t$$, $CellContext`t$169871$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Graphics[{
         Circle[{0, 0}, 4], Red, 
         PointSize[0.015], 
         Point[
          ReplaceAll[
           Table[{
             $CellContext`x[$CellContext`n][$CellContext`t$$], 
             $CellContext`y[$CellContext`n][$CellContext`t$$]}, \
{$CellContext`n, 1, 20}], 
           $CellContext`simulation[20, 4, 0]]]}, 
        PlotRange -> {{-4, 4}, {-4, 4}}], 
      "Specifications" :> {{{$CellContext`t$$, 0, 
          Style["time", 
           GrayLevel[0], 15]}, 0, 20}}, "Options" :> {}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{405., {223., 229.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UndoTrackedVariables:>{Typeset`show$$, Typeset`bookmarkMode$$},
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellChangeTimes->{
  3.682441304821003*^9, {3.68244133542949*^9, 3.682441374960264*^9}, {
   3.6824414260987263`*^9, 3.682441452083716*^9}, {3.682441694938381*^9, 
   3.682441719193005*^9}, 3.682441831535475*^9, 
   3.7095348382365294`*^9},ExpressionUUID->"3cec53ee-2de1-4ef5-ac2b-\
a44c8b46c652"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Solving equations of motion with drag :", "Subsubsection",
 CellChangeTimes->{{3.68244215961656*^9, 3.682442180495058*^9}}],

Cell[BoxData[
 RowBox[{"With", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"number", "=", "20"}], ",", 
     RowBox[{"radius", "=", "4"}], ",", 
     RowBox[{"drag", "=", "0.2"}], ",", 
     RowBox[{"tmax", "=", "50"}]}], "}"}], ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"positions", "[", "t_", "]"}], ":=", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"x", "[", "n", "]"}], "[", "t", "]"}], ",", 
         RowBox[{
          RowBox[{"y", "[", "n", "]"}], "[", "t", "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"n", ",", "1", ",", "number"}], "}"}]}], "]"}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"simulation", "[", 
      RowBox[{"number", ",", "radius", ",", "drag"}], "]"}], "=", 
     "\[IndentingNewLine]", 
     RowBox[{"First", "[", "\[IndentingNewLine]", 
      RowBox[{"NDSolve", "[", 
       RowBox[{
        RowBox[{"{", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"positions", "''"}], "[", "t", "]"}], "\[Equal]", 
           RowBox[{
            RowBox[{"accelerations", "[", 
             RowBox[{
              RowBox[{"positions", "[", "t", "]"}], ",", "radius"}], "]"}], 
            "-", 
            RowBox[{"drag", "*", 
             RowBox[{
              RowBox[{"positions", "'"}], "[", "t", "]"}]}]}]}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"positions", "[", "0", "]"}], "\[Equal]", 
           RowBox[{"RandomReal", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"number", ",", "2"}], "}"}]}], "]"}]}], ",", 
          RowBox[{
           RowBox[{
            RowBox[{"positions", "'"}], "[", "0", "]"}], "\[Equal]", 
           RowBox[{"ConstantArray", "[", 
            RowBox[{"0", ",", 
             RowBox[{"{", 
              RowBox[{"number", ",", "2"}], "}"}]}], "]"}]}]}], "}"}], ",", 
        RowBox[{"Flatten", "[", 
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"x", "[", "n", "]"}], ",", 
             RowBox[{"y", "[", "n", "]"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"n", ",", "1", ",", "number"}], "}"}]}], "]"}], "]"}], 
        ",", 
        RowBox[{"{", 
         RowBox[{"t", ",", "0", ",", "tmax"}], "}"}]}], "]"}], 
      "\[IndentingNewLine]", "]"}]}], ";"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.682441885430365*^9, 3.682441888595755*^9}, {
  3.709535026733982*^9, 
  3.70953503284729*^9}},ExpressionUUID->"69a471b8-c1b4-48f3-990c-\
e6c843e25ad7"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"With", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"number", "=", "20"}], ",", 
     RowBox[{"radius", "=", "4"}], ",", 
     RowBox[{"drag", "=", "0.2"}], ",", 
     RowBox[{"tmax", "=", "50"}]}], "}"}], ",", "\[IndentingNewLine]", 
   RowBox[{"Manipulate", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Graphics", "[", 
      RowBox[{
       RowBox[{"{", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"Circle", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"0", ",", "0"}], "}"}], ",", "radius"}], "]"}], ",", 
         "Red", ",", 
         RowBox[{"PointSize", "[", "0.015", "]"}], ",", 
         RowBox[{"Point", "[", 
          RowBox[{
           RowBox[{"Table", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{
                RowBox[{"x", "[", "n", "]"}], "[", "t", "]"}], ",", 
               RowBox[{
                RowBox[{"y", "[", "n", "]"}], "[", "t", "]"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"n", ",", "1", ",", "number"}], "}"}]}], "]"}], "/.", 
           RowBox[{"simulation", "[", 
            RowBox[{"number", ",", "radius", ",", "drag"}], "]"}]}], "]"}], 
         ",", "\[IndentingNewLine]", "Black", ",", 
         RowBox[{"Arrow", "[", 
          RowBox[{"Transpose", "[", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"ConstantArray", "[", 
              RowBox[{"0", ",", 
               RowBox[{"{", 
                RowBox[{"number", ",", "2"}], "}"}]}], "]"}], ",", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"Table", "[", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"x", "[", "n", "]"}], "[", "t", "]"}], ",", 
                    RowBox[{
                    RowBox[{"y", "[", "n", "]"}], "[", "t", "]"}]}], "}"}], 
                  ",", 
                  RowBox[{"{", 
                   RowBox[{"n", ",", "1", ",", "number"}], "}"}]}], "]"}], "/.", 
                RowBox[{"{", 
                 RowBox[{"simulation", "[", 
                  RowBox[{"number", ",", "radius", ",", "drag"}], "]"}], 
                 "}"}]}], ")"}], "[", 
              RowBox[{"[", "1", "]"}], "]"}]}], "}"}], "]"}], "]"}]}], "}"}], 
       ",", 
       RowBox[{"PlotRange", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "radius"}], ",", "radius"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "radius"}], ",", "radius"}], "}"}]}], "}"}]}]}], 
      "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"t", ",", "0", ",", 
         RowBox[{"Style", "[", 
          RowBox[{"\"\<time\>\"", ",", "Black", ",", "15"}], "]"}]}], "}"}], 
       ",", "0", ",", "tmax"}], "}"}]}], "]"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.682441898558508*^9, 3.682441901944051*^9}, {
  3.709535076306773*^9, 
  3.709535078274061*^9}},ExpressionUUID->"9e9ca119-4197-4a66-9d74-\
0bb1ca0ca8ce"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`t$$ = 44., Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`t$$], 0, 
       Style["time", 
        GrayLevel[0], 15]}, 0, 50}}, Typeset`size$$ = {360., {178., 182.}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`t$333835$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`t$$ = 0}, 
      "ControllerVariables" :> {
        Hold[$CellContext`t$$, $CellContext`t$333835$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Graphics[{
         Circle[{0, 0}, 4], Red, 
         PointSize[0.015], 
         Point[
          ReplaceAll[
           Table[{
             $CellContext`x[$CellContext`n][$CellContext`t$$], 
             $CellContext`y[$CellContext`n][$CellContext`t$$]}, \
{$CellContext`n, 1, 20}], 
           $CellContext`simulation[20, 4, 0.2]]], Black, 
         Arrow[
          Transpose[{
            ConstantArray[0, {20, 2}], 
            Part[
             ReplaceAll[
              Table[{
                $CellContext`x[$CellContext`n][$CellContext`t$$], 
                $CellContext`y[$CellContext`n][$CellContext`t$$]}, \
{$CellContext`n, 1, 20}], {
               $CellContext`simulation[20, 4, 0.2]}], 1]}]]}, 
        PlotRange -> {{-4, 4}, {-4, 4}}], 
      "Specifications" :> {{{$CellContext`t$$, 0, 
          Style["time", 
           GrayLevel[0], 15]}, 0, 50}}, "Options" :> {}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{405., {223., 229.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UndoTrackedVariables:>{Typeset`show$$, Typeset`bookmarkMode$$},
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellChangeTimes->{
  3.682441919314776*^9, {3.709535070413807*^9, 
   3.70953507882062*^9}},ExpressionUUID->"d30bc6c1-88b1-4636-a9ee-\
b4d9a1983444"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Increasing the number of particles :", "Subsubsection",
 CellChangeTimes->{{3.682442195925721*^9, 3.68244220147681*^9}}],

Cell["40 particles :", "Text",
 CellChangeTimes->{{3.682442228858611*^9, 3.682442234270878*^9}}],

Cell[BoxData[
 RowBox[{"With", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"number", "=", "40"}], ",", 
     RowBox[{"radius", "=", "4"}], ",", 
     RowBox[{"drag", "=", "0.2"}], ",", 
     RowBox[{"tmax", "=", "50"}]}], "}"}], ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"positions", "[", "t_", "]"}], ":=", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"x", "[", "n", "]"}], "[", "t", "]"}], ",", 
         RowBox[{
          RowBox[{"y", "[", "n", "]"}], "[", "t", "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"n", ",", "1", ",", "number"}], "}"}]}], "]"}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"simulation", "[", 
      RowBox[{"number", ",", "radius", ",", "drag"}], "]"}], "=", 
     "\[IndentingNewLine]", 
     RowBox[{"First", "[", "\[IndentingNewLine]", 
      RowBox[{"NDSolve", "[", 
       RowBox[{
        RowBox[{"{", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"positions", "''"}], "[", "t", "]"}], "\[Equal]", 
           RowBox[{
            RowBox[{"accelerations", "[", 
             RowBox[{
              RowBox[{"positions", "[", "t", "]"}], ",", "radius"}], "]"}], 
            "-", 
            RowBox[{"drag", "*", 
             RowBox[{
              RowBox[{"positions", "'"}], "[", "t", "]"}]}]}]}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"positions", "[", "0", "]"}], "\[Equal]", 
           RowBox[{"RandomReal", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"number", ",", "2"}], "}"}]}], "]"}]}], ",", 
          RowBox[{
           RowBox[{
            RowBox[{"positions", "'"}], "[", "0", "]"}], "\[Equal]", 
           RowBox[{"ConstantArray", "[", 
            RowBox[{"0", ",", 
             RowBox[{"{", 
              RowBox[{"number", ",", "2"}], "}"}]}], "]"}]}]}], "}"}], ",", 
        RowBox[{"Flatten", "[", 
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"x", "[", "n", "]"}], ",", 
             RowBox[{"y", "[", "n", "]"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"n", ",", "1", ",", "number"}], "}"}]}], "]"}], "]"}], 
        ",", 
        RowBox[{"{", 
         RowBox[{"t", ",", "0", ",", "tmax"}], "}"}]}], "]"}], 
      "\[IndentingNewLine]", "]"}]}], ";"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.6824419337735987`*^9, 3.682441935057561*^9}, {
  3.709535091115616*^9, 
  3.709535102019294*^9}},ExpressionUUID->"7dfd5432-4275-4861-9e5b-\
1e7d5171235e"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"With", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"number", "=", "40"}], ",", 
     RowBox[{"radius", "=", "4"}], ",", 
     RowBox[{"drag", "=", "0.2"}], ",", 
     RowBox[{"tmax", "=", "50"}]}], "}"}], ",", "\[IndentingNewLine]", 
   RowBox[{"Manipulate", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Graphics", "[", 
      RowBox[{
       RowBox[{"{", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"Circle", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"0", ",", "0"}], "}"}], ",", "radius"}], "]"}], ",", 
         "Red", ",", 
         RowBox[{"PointSize", "[", "0.015", "]"}], ",", 
         RowBox[{"Point", "[", 
          RowBox[{
           RowBox[{"Table", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{
                RowBox[{"x", "[", "n", "]"}], "[", "t", "]"}], ",", 
               RowBox[{
                RowBox[{"y", "[", "n", "]"}], "[", "t", "]"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"n", ",", "1", ",", "number"}], "}"}]}], "]"}], "/.", 
           RowBox[{"simulation", "[", 
            RowBox[{"number", ",", "radius", ",", "drag"}], "]"}]}], "]"}], 
         ",", "\[IndentingNewLine]", "Black", ",", 
         RowBox[{"Arrow", "[", 
          RowBox[{"Transpose", "[", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"ConstantArray", "[", 
              RowBox[{"0", ",", 
               RowBox[{"{", 
                RowBox[{"number", ",", "2"}], "}"}]}], "]"}], ",", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"Table", "[", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"x", "[", "n", "]"}], "[", "t", "]"}], ",", 
                    RowBox[{
                    RowBox[{"y", "[", "n", "]"}], "[", "t", "]"}]}], "}"}], 
                  ",", 
                  RowBox[{"{", 
                   RowBox[{"n", ",", "1", ",", "number"}], "}"}]}], "]"}], "/.", 
                RowBox[{"{", 
                 RowBox[{"simulation", "[", 
                  RowBox[{"number", ",", "radius", ",", "drag"}], "]"}], 
                 "}"}]}], ")"}], "[", 
              RowBox[{"[", "1", "]"}], "]"}]}], "}"}], "]"}], "]"}]}], "}"}], 
       ",", 
       RowBox[{"PlotRange", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "radius"}], ",", "radius"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "radius"}], ",", "radius"}], "}"}]}], "}"}]}]}], 
      "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"t", ",", "0", ",", 
         RowBox[{"Style", "[", 
          RowBox[{"\"\<time\>\"", ",", "Black", ",", "15"}], "]"}]}], "}"}], 
       ",", "0", ",", "tmax"}], "}"}]}], "]"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.682441941907387*^9, 3.682441941987391*^9}, {
  3.7095351460954657`*^9, 
  3.70953514824942*^9}},ExpressionUUID->"866f4e81-0dee-4dc3-abfb-\
454b1772101a"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`t$$ = 38.300000000000004`, Typeset`show$$ = 
    True, Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`t$$], 0, 
       Style["time", 
        GrayLevel[0], 15]}, 0, 50}}, Typeset`size$$ = {360., {178., 182.}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`t$334458$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`t$$ = 0}, 
      "ControllerVariables" :> {
        Hold[$CellContext`t$$, $CellContext`t$334458$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Graphics[{
         Circle[{0, 0}, 4], Red, 
         PointSize[0.015], 
         Point[
          ReplaceAll[
           Table[{
             $CellContext`x[$CellContext`n][$CellContext`t$$], 
             $CellContext`y[$CellContext`n][$CellContext`t$$]}, \
{$CellContext`n, 1, 40}], 
           $CellContext`simulation[40, 4, 0.2]]], Black, 
         Arrow[
          Transpose[{
            ConstantArray[0, {40, 2}], 
            Part[
             ReplaceAll[
              Table[{
                $CellContext`x[$CellContext`n][$CellContext`t$$], 
                $CellContext`y[$CellContext`n][$CellContext`t$$]}, \
{$CellContext`n, 1, 40}], {
               $CellContext`simulation[40, 4, 0.2]}], 1]}]]}, 
        PlotRange -> {{-4, 4}, {-4, 4}}], 
      "Specifications" :> {{{$CellContext`t$$, 0, 
          Style["time", 
           GrayLevel[0], 15]}, 0, 50}}, "Options" :> {}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{405., {223., 229.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UndoTrackedVariables:>{Typeset`show$$, Typeset`bookmarkMode$$},
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellChangeTimes->{3.682441964941505*^9, 
  3.7095351487775106`*^9},ExpressionUUID->"000acad6-8ae0-4f20-b1c8-\
fcdb0d15a860"]
}, Open  ]],

Cell["80 particles (takes ~ 4 minutes to evaluate) :", "Text",
 CellChangeTimes->{{3.682442239230481*^9, 3.682442257717976*^9}, {
  3.709535200518693*^9, 
  3.70953520192303*^9}},ExpressionUUID->"3f6bcbd2-b91d-4fd8-be4f-\
1576b08a199b"],

Cell[BoxData[
 RowBox[{"With", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"number", "=", "80"}], ",", 
     RowBox[{"radius", "=", "4"}], ",", 
     RowBox[{"drag", "=", "0.2"}], ",", 
     RowBox[{"tmax", "=", "50"}]}], "}"}], ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"positions", "[", "t_", "]"}], ":=", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"x", "[", "n", "]"}], "[", "t", "]"}], ",", 
         RowBox[{
          RowBox[{"y", "[", "n", "]"}], "[", "t", "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"n", ",", "1", ",", "number"}], "}"}]}], "]"}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"simulation", "[", 
      RowBox[{"number", ",", "radius", ",", "drag"}], "]"}], "=", 
     "\[IndentingNewLine]", 
     RowBox[{"First", "[", "\[IndentingNewLine]", 
      RowBox[{"NDSolve", "[", 
       RowBox[{
        RowBox[{"{", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"positions", "''"}], "[", "t", "]"}], "\[Equal]", 
           RowBox[{
            RowBox[{"accelerations", "[", 
             RowBox[{
              RowBox[{"positions", "[", "t", "]"}], ",", "radius"}], "]"}], 
            "-", 
            RowBox[{"drag", "*", 
             RowBox[{
              RowBox[{"positions", "'"}], "[", "t", "]"}]}]}]}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"positions", "[", "0", "]"}], "\[Equal]", 
           RowBox[{"RandomReal", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"number", ",", "2"}], "}"}]}], "]"}]}], ",", 
          RowBox[{
           RowBox[{
            RowBox[{"positions", "'"}], "[", "0", "]"}], "\[Equal]", 
           RowBox[{"ConstantArray", "[", 
            RowBox[{"0", ",", 
             RowBox[{"{", 
              RowBox[{"number", ",", "2"}], "}"}]}], "]"}]}]}], "}"}], ",", 
        RowBox[{"Flatten", "[", 
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"x", "[", "n", "]"}], ",", 
             RowBox[{"y", "[", "n", "]"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"n", ",", "1", ",", "number"}], "}"}]}], "]"}], "]"}], 
        ",", 
        RowBox[{"{", 
         RowBox[{"t", ",", "0", ",", "tmax"}], "}"}]}], "]"}], 
      "\[IndentingNewLine]", "]"}]}], ";"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.682441978844241*^9, 3.6824419791261997`*^9}, {
  3.70953517281754*^9, 
  3.709535205747283*^9}},ExpressionUUID->"08e43442-638f-4a55-8fcf-\
17bd9158e39a"],

Cell[BoxData[
 RowBox[{"With", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"number", "=", "80"}], ",", 
     RowBox[{"radius", "=", "4"}], ",", 
     RowBox[{"drag", "=", "0.2"}], ",", 
     RowBox[{"tmax", "=", "50"}]}], "}"}], ",", "\[IndentingNewLine]", 
   RowBox[{"Manipulate", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Graphics", "[", 
      RowBox[{
       RowBox[{"{", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"Circle", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"0", ",", "0"}], "}"}], ",", "radius"}], "]"}], ",", 
         "Red", ",", 
         RowBox[{"PointSize", "[", "0.015", "]"}], ",", 
         RowBox[{"Point", "[", 
          RowBox[{
           RowBox[{"Table", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{
                RowBox[{"x", "[", "n", "]"}], "[", "t", "]"}], ",", 
               RowBox[{
                RowBox[{"y", "[", "n", "]"}], "[", "t", "]"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"n", ",", "1", ",", "number"}], "}"}]}], "]"}], "/.", 
           RowBox[{"simulation", "[", 
            RowBox[{"number", ",", "radius", ",", "drag"}], "]"}]}], "]"}], 
         ",", "\[IndentingNewLine]", "Black", ",", 
         RowBox[{"Arrow", "[", 
          RowBox[{"Transpose", "[", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"ConstantArray", "[", 
              RowBox[{"0", ",", 
               RowBox[{"{", 
                RowBox[{"number", ",", "2"}], "}"}]}], "]"}], ",", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"Table", "[", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"x", "[", "n", "]"}], "[", "t", "]"}], ",", 
                    RowBox[{
                    RowBox[{"y", "[", "n", "]"}], "[", "t", "]"}]}], "}"}], 
                  ",", 
                  RowBox[{"{", 
                   RowBox[{"n", ",", "1", ",", "number"}], "}"}]}], "]"}], "/.", 
                RowBox[{"{", 
                 RowBox[{"simulation", "[", 
                  RowBox[{"number", ",", "radius", ",", "drag"}], "]"}], 
                 "}"}]}], ")"}], "[", 
              RowBox[{"[", "1", "]"}], "]"}]}], "}"}], "]"}], "]"}]}], "}"}], 
       ",", 
       RowBox[{"PlotRange", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "radius"}], ",", "radius"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "radius"}], ",", "radius"}], "}"}]}], "}"}]}]}], 
      "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"t", ",", "0", ",", 
         RowBox[{"Style", "[", 
          RowBox[{"\"\<time\>\"", ",", "Black", ",", "15"}], "]"}]}], "}"}], 
       ",", "0", ",", "tmax"}], "}"}]}], "]"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.682442287770503*^9, 3.682442287900972*^9}, {
  3.70953517979342*^9, 
  3.709535182433784*^9}},ExpressionUUID->"bcc10135-f1a0-4859-9625-\
ee3e6ed3225b"]
}, Open  ]],

Cell["\<\
Its fascinating to see the charges spontaneously reaching such an equilibrium \
configuration. You\[CloseCurlyQuote]ll find interesting links on this \
behavior in the homework. Here are some questions to ponder :
(i) How does the number of particles decide the final charge configuration?
(ii) Does the final distribution depend on the drag coefficient?
(ii) Does it matter how we initialize the particles?
(iii) Does it matter how big the circle is?
(iv) How would the result change if we had a different shape, instead of a \
circle?\
\>", "Subsubsection",
 CellChangeTimes->{{3.6824424573468018`*^9, 3.6824425284628487`*^9}, {
  3.682442570415246*^9, 3.682442728742361*^9}, {3.682442765067631*^9, 
  3.682442767957056*^9}, {3.6824428246594887`*^9, 3.682442833241181*^9}, {
  3.682443141317357*^9, 3.68244317517797*^9}, {3.682443222400992*^9, 
  3.682443355231298*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Note that we have applied the 3D Coulomb\[CloseCurlyQuote]s law expression \
to simulate the dynamics. However, in a purely 2D universe (i.e., 2+1 \
spacetime dimensions), Coulomb\[CloseCurlyQuote]s law falls off as 1/r \
instead of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"1", "/", 
    SuperscriptBox["r", "2"]}], TraditionalForm]],
  FormatType->"TraditionalForm"],
 ". Then the charges would indeed end up on the periphery of the circle. Here\
\[CloseCurlyQuote]s an example :"
}], "Subsection",
 CellChangeTimes->{3.6824428372797413`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"accelerations2D", "[", 
   RowBox[{"positions_", ",", "radius_"}], "]"}], ":=", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Total", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"positions", "[", 
            RowBox[{"[", "n", "]"}], "]"}], "-", "#"}], ")"}], "/", 
         SuperscriptBox[
          RowBox[{"Norm", "[", 
           RowBox[{
            RowBox[{"positions", "[", 
             RowBox[{"[", "n", "]"}], "]"}], "-", "#"}], "]"}], "2"]}], "&"}],
        "/@", 
       RowBox[{"Drop", "[", 
        RowBox[{"positions", ",", 
         RowBox[{"{", "n", "}"}]}], "]"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", "1", ",", 
       RowBox[{"Length", "[", "positions", "]"}]}], "}"}]}], "]"}], "-", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"100", "*", "#", "*", 
       RowBox[{
        RowBox[{"Exp", "[", 
         RowBox[{"100", "*", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"Norm", "[", "#", "]"}], "-", "radius"}], ")"}]}], "]"}], 
        "/", 
        RowBox[{"Norm", "[", "#", "]"}]}]}], "&"}], "/@", "positions"}], 
    ")"}]}]}]], "Input",
 CellChangeTimes->{{3.6824427390827513`*^9, 
  3.682442743737005*^9}},ExpressionUUID->"1d03aa3f-be6f-4282-8125-\
d7c69859b10d"],

Cell[BoxData[
 RowBox[{"With", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"number", "=", "40"}], ",", 
     RowBox[{"radius", "=", "4"}], ",", 
     RowBox[{"drag", "=", "0.2"}], ",", 
     RowBox[{"tmax", "=", "50"}]}], "}"}], ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"positions", "[", "t_", "]"}], ":=", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"x", "[", "n", "]"}], "[", "t", "]"}], ",", 
         RowBox[{
          RowBox[{"y", "[", "n", "]"}], "[", "t", "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"n", ",", "1", ",", "number"}], "}"}]}], "]"}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"simulation2D", "[", 
      RowBox[{"number", ",", "radius", ",", "drag"}], "]"}], "=", 
     "\[IndentingNewLine]", 
     RowBox[{"First", "[", "\[IndentingNewLine]", 
      RowBox[{"NDSolve", "[", 
       RowBox[{
        RowBox[{"{", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"positions", "''"}], "[", "t", "]"}], "\[Equal]", 
           RowBox[{
            RowBox[{"accelerations2D", "[", 
             RowBox[{
              RowBox[{"positions", "[", "t", "]"}], ",", "radius"}], "]"}], 
            "-", 
            RowBox[{"drag", "*", 
             RowBox[{
              RowBox[{"positions", "'"}], "[", "t", "]"}]}]}]}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"positions", "[", "0", "]"}], "\[Equal]", 
           RowBox[{"RandomReal", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"number", ",", "2"}], "}"}]}], "]"}]}], ",", 
          RowBox[{
           RowBox[{
            RowBox[{"positions", "'"}], "[", "0", "]"}], "\[Equal]", 
           RowBox[{"ConstantArray", "[", 
            RowBox[{"0", ",", 
             RowBox[{"{", 
              RowBox[{"number", ",", "2"}], "}"}]}], "]"}]}]}], "}"}], ",", 
        RowBox[{"Flatten", "[", 
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"x", "[", "n", "]"}], ",", 
             RowBox[{"y", "[", "n", "]"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"n", ",", "1", ",", "number"}], "}"}]}], "]"}], "]"}], 
        ",", 
        RowBox[{"{", 
         RowBox[{"t", ",", "0", ",", "tmax"}], "}"}]}], "]"}], 
      "\[IndentingNewLine]", "]"}]}], ";"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.6824427714401417`*^9, 3.6824427745178347`*^9}, {
  3.709535223717799*^9, 
  3.709535227462735*^9}},ExpressionUUID->"8563900f-dbd4-42f2-9d0b-\
9710a67818ac"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"With", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"number", "=", "40"}], ",", 
     RowBox[{"radius", "=", "4"}], ",", 
     RowBox[{"drag", "=", "0.2"}], ",", 
     RowBox[{"tmax", "=", "50"}]}], "}"}], ",", "\[IndentingNewLine]", 
   RowBox[{"Manipulate", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Graphics", "[", 
      RowBox[{
       RowBox[{"{", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"Circle", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"0", ",", "0"}], "}"}], ",", "radius"}], "]"}], ",", 
         "Red", ",", 
         RowBox[{"PointSize", "[", "0.015", "]"}], ",", 
         RowBox[{"Point", "[", 
          RowBox[{
           RowBox[{"Table", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{
                RowBox[{"x", "[", "n", "]"}], "[", "t", "]"}], ",", 
               RowBox[{
                RowBox[{"y", "[", "n", "]"}], "[", "t", "]"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"n", ",", "1", ",", "number"}], "}"}]}], "]"}], "/.", 
           RowBox[{"simulation2D", "[", 
            RowBox[{"number", ",", "radius", ",", "drag"}], "]"}]}], "]"}], 
         ",", "\[IndentingNewLine]", "Black", ",", 
         RowBox[{"Arrow", "[", 
          RowBox[{"Transpose", "[", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"ConstantArray", "[", 
              RowBox[{"0", ",", 
               RowBox[{"{", 
                RowBox[{"number", ",", "2"}], "}"}]}], "]"}], ",", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"Table", "[", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"x", "[", "n", "]"}], "[", "t", "]"}], ",", 
                    RowBox[{
                    RowBox[{"y", "[", "n", "]"}], "[", "t", "]"}]}], "}"}], 
                  ",", 
                  RowBox[{"{", 
                   RowBox[{"n", ",", "1", ",", "number"}], "}"}]}], "]"}], "/.", 
                RowBox[{"{", 
                 RowBox[{"simulation2D", "[", 
                  RowBox[{"number", ",", "radius", ",", "drag"}], "]"}], 
                 "}"}]}], ")"}], "[", 
              RowBox[{"[", "1", "]"}], "]"}]}], "}"}], "]"}], "]"}]}], "}"}], 
       ",", 
       RowBox[{"PlotRange", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "radius"}], ",", "radius"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "radius"}], ",", "radius"}], "}"}]}], "}"}]}]}], 
      "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"t", ",", "0", ",", 
         RowBox[{"Style", "[", 
          RowBox[{"\"\<time\>\"", ",", "Black", ",", "15"}], "]"}]}], "}"}], 
       ",", "0", ",", "tmax"}], "}"}]}], "]"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.682442789787869*^9, 3.6824427919892473`*^9}, {
  3.709535262320016*^9, 
  3.709535264262849*^9}},ExpressionUUID->"ba62849c-f2f4-49bd-961d-\
f93a269a31a4"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`t$$ = 50., Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`t$$], 0, 
       Style["time", 
        GrayLevel[0], 15]}, 0, 50}}, Typeset`size$$ = {360., {178., 182.}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`t$334974$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`t$$ = 0}, 
      "ControllerVariables" :> {
        Hold[$CellContext`t$$, $CellContext`t$334974$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Graphics[{
         Circle[{0, 0}, 4], Red, 
         PointSize[0.015], 
         Point[
          ReplaceAll[
           Table[{
             $CellContext`x[$CellContext`n][$CellContext`t$$], 
             $CellContext`y[$CellContext`n][$CellContext`t$$]}, \
{$CellContext`n, 1, 40}], 
           $CellContext`simulation2D[40, 4, 0.2]]], Black, 
         Arrow[
          Transpose[{
            ConstantArray[0, {40, 2}], 
            Part[
             ReplaceAll[
              Table[{
                $CellContext`x[$CellContext`n][$CellContext`t$$], 
                $CellContext`y[$CellContext`n][$CellContext`t$$]}, \
{$CellContext`n, 1, 40}], {
               $CellContext`simulation2D[40, 4, 0.2]}], 1]}]]}, 
        PlotRange -> {{-4, 4}, {-4, 4}}], 
      "Specifications" :> {{{$CellContext`t$$, 0, 
          Style["time", 
           GrayLevel[0], 15]}, 0, 50}}, "Options" :> {}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{405., {223., 229.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UndoTrackedVariables:>{Typeset`show$$, Typeset`bookmarkMode$$},
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellChangeTimes->{3.682442808841015*^9, 
  3.709535264675146*^9},ExpressionUUID->"ee1977fc-3f1b-4311-9ade-\
029c5c2184d7"]
}, Open  ]]
}, Open  ]],

Cell["\<\
More about electrodynamics in a universe with 2+1 spacetime dimensions : 
(i) http://physics.stackexchange.com/questions/104008/maxwells-equations-of-\
electromagnetism-in-21-spacetime-dimensions
(ii) http://physics.stackexchange.com/questions/32685/can-light-exist-in-21-\
or-11-spacetime-dimensions\
\>", "Subsection",
 CellChangeTimes->{{3.682442864611927*^9, 3.682442900099225*^9}, {
   3.6824429564002523`*^9, 3.682442956411477*^9}, {3.6824430593939877`*^9, 
   3.682443071312291*^9}, 3.682443129992612*^9}]
}, Open  ]]
},
WindowSize->{1253, 684},
WindowMargins->{{10, Automatic}, {Automatic, 0}},
FrontEndVersion->"11.1 for Mac OS X x86 (32-bit, 64-bit Kernel) (April 18, \
2017)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 127, 1, 92, "Title", "ExpressionUUID" -> \
"e355be86-b13e-4ea1-87d1-a28ffe1efa59"],
Cell[CellGroupData[{
Cell[732, 27, 203, 4, 44, "Subsection", "ExpressionUUID" -> \
"00e51737-cf32-4055-b158-ba60a603246f"],
Cell[CellGroupData[{
Cell[960, 35, 181, 4, 35, "Subsubsection", "ExpressionUUID" -> \
"c1905af7-480d-40b9-bce4-23a3815e6626"],
Cell[1144, 41, 1389, 42, 77, "Input", "ExpressionUUID" -> \
"ff32e48d-9f10-4f84-8731-4bd070e3b277"]
}, Open  ]],
Cell[CellGroupData[{
Cell[2570, 88, 193, 3, 35, "Subsubsection", "ExpressionUUID" -> \
"9ecee018-ab0c-4506-a59b-c78c7f95d603"],
Cell[2766, 93, 2834, 76, 201, "Input", "ExpressionUUID" -> \
"6cc933eb-0032-46b9-9cbc-262f3866f42b"]
}, Open  ]],
Cell[CellGroupData[{
Cell[5637, 174, 114, 1, 35, "Subsubsection", "ExpressionUUID" -> \
"8e806f74-59c3-44b1-9e1a-6730a39b25fd"],
Cell[CellGroupData[{
Cell[5776, 179, 2193, 57, 138, "Input", "ExpressionUUID" -> \
"2e0cecbb-c6f6-4f7d-809c-6e4a6bf3c361"],
Cell[7972, 238, 2300, 51, 469, "Output", "ExpressionUUID" -> \
"3cec53ee-2de1-4ef5-ac2b-a44c8b46c652"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10321, 295, 129, 1, 35, "Subsubsection", "ExpressionUUID" -> \
"44eb6539-6d0c-45b3-94e5-9e87c2fda596"],
Cell[10453, 298, 2784, 76, 201, "Input", "ExpressionUUID" -> \
"69a471b8-c1b4-48f3-990c-e6c843e25ad7"],
Cell[CellGroupData[{
Cell[13262, 378, 3210, 84, 180, "Input", "ExpressionUUID" -> \
"9e9ca119-4197-4a66-9d74-0bb1ca0ca8ce"],
Cell[16475, 464, 2514, 59, 469, "Output", "ExpressionUUID" -> \
"d30bc6c1-88b1-4636-a9ee-b4d9a1983444"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[19038, 529, 126, 1, 35, "Subsubsection", "ExpressionUUID" -> \
"4014d1ab-3c01-481a-bad4-22906d082d72"],
Cell[19167, 532, 96, 1, 30, "Text", "ExpressionUUID" -> \
"b2dcc380-7a94-4b31-a122-18764cd94b11"],
Cell[19266, 535, 2787, 76, 201, "Input", "ExpressionUUID" -> \
"7dfd5432-4275-4861-9e5b-1e7d5171235e"],
Cell[CellGroupData[{
Cell[22078, 615, 3211, 84, 180, "Input", "ExpressionUUID" -> \
"866f4e81-0dee-4dc3-abfb-454b1772101a"],
Cell[25292, 701, 2505, 58, 469, "Output", "ExpressionUUID" -> \
"000acad6-8ae0-4f20-b1c8-fcdb0d15a860"]
}, Open  ]],
Cell[27812, 762, 236, 4, 30, "Text", "ExpressionUUID" -> \
"3f6bcbd2-b91d-4fd8-be4f-1576b08a199b"],
Cell[28051, 768, 2786, 76, 201, "Input", "ExpressionUUID" -> \
"08e43442-638f-4a55-8fcf-17bd9158e39a"],
Cell[30840, 846, 3209, 84, 180, "Input", "ExpressionUUID" -> \
"bcc10135-f1a0-4859-9625-ee3e6ed3225b"]
}, Open  ]],
Cell[34064, 933, 882, 15, 179, "Subsubsection", "ExpressionUUID" -> \
"28ca0f06-8989-4659-8553-1c7e3989ca72"]
}, Open  ]],
Cell[CellGroupData[{
Cell[34983, 953, 561, 13, 96, "Subsection", "ExpressionUUID" -> \
"f0950099-a751-4aec-becb-0173b460d605"],
Cell[35547, 968, 1393, 42, 77, "Input", "ExpressionUUID" -> \
"1d03aa3f-be6f-4282-8125-d7c69859b10d"],
Cell[36943, 1012, 2793, 76, 201, "Input", "ExpressionUUID" -> \
"8563900f-dbd4-42f2-9d0b-9710a67818ac"],
Cell[CellGroupData[{
Cell[39761, 1092, 3216, 84, 180, "Input", "ExpressionUUID" -> \
"ba62849c-f2f4-49bd-961d-f93a269a31a4"],
Cell[42980, 1178, 2491, 58, 469, "Output", "ExpressionUUID" -> \
"ee1977fc-3f1b-4311-9ade-029c5c2184d7"]
}, Open  ]]
}, Open  ]],
Cell[45498, 1240, 522, 9, 94, "Subsection", "ExpressionUUID" -> \
"7db2bef9-dab0-47a1-98e6-f0dea1cd45f8"]
}, Open  ]]
}
]
*)

