(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 10.4' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[   3702726,      63119]
NotebookOptionsPosition[   3691728,      62840]
NotebookOutlinePosition[   3692083,      62856]
CellTagsIndexPosition[   3692040,      62853]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Numerical techniques for solving equations of motion :", "Title",
 CellChangeTimes->{{3.6837368508128977`*^9, 3.6837368719604263`*^9}}],

Cell[CellGroupData[{

Cell[TextData[{
 "Test case : orbital motion under attractive ",
 Cell[BoxData[
  FormBox[
   RowBox[{"1", "/", 
    SuperscriptBox["r", "2"]}], TraditionalForm]],
  FormatType->"TraditionalForm"],
 " force :"
}], "Subsection",
 CellChangeTimes->{{3.683736970409329*^9, 3.683737010977522*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"ax", "[", 
   RowBox[{"x_", ",", "y_"}], "]"}], ":=", 
  RowBox[{
   RowBox[{"-", "x"}], "/", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["x", "2"], "+", 
      SuperscriptBox["y", "2"]}], ")"}], 
    RowBox[{"3", "/", "2"}]]}]}]], "Input",
 CellChangeTimes->{{3.683252963024151*^9, 3.683252980939896*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"ay", "[", 
   RowBox[{"x_", ",", "y_"}], "]"}], ":=", 
  RowBox[{
   RowBox[{"-", "y"}], "/", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["x", "2"], "+", 
      SuperscriptBox["y", "2"]}], ")"}], 
    RowBox[{"3", "/", "2"}]]}]}]], "Input",
 CellChangeTimes->{{3.683252986934739*^9, 3.683253000798531*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["NDSolve :", "Section",
 CellChangeTimes->{{3.683263081573264*^9, 3.683263093498658*^9}}],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SuperscriptBox["x", "\[Prime]\[Prime]"], "=", 
     RowBox[{
      SubscriptBox["a", "x"], "(", 
      RowBox[{"x", ",", "y"}], ")"}]}], " ", ";"}], TraditionalForm]]],
 "\n",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SuperscriptBox["y", "\[Prime]\[Prime]"], "=", 
     RowBox[{
      SubscriptBox["a", "y"], "(", 
      RowBox[{"x", ",", "y"}], ")"}]}], " ", ";"}], TraditionalForm]]]
}], "Subsubsection",
 CellChangeTimes->{{3.683733564108671*^9, 3.6837336641187077`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AbsoluteTiming", "[", "\[IndentingNewLine]", 
  RowBox[{"orbit", "=", "\[IndentingNewLine]", 
   RowBox[{"NDSolve", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"x", "''"}], "[", "t", "]"}], "\[Equal]", 
        RowBox[{"ax", "[", 
         RowBox[{
          RowBox[{"x", "[", "t", "]"}], ",", 
          RowBox[{"y", "[", "t", "]"}]}], "]"}]}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{"y", "''"}], "[", "t", "]"}], "\[Equal]", 
        RowBox[{"ay", "[", 
         RowBox[{
          RowBox[{"x", "[", "t", "]"}], ",", 
          RowBox[{"y", "[", "t", "]"}]}], "]"}]}], ",", 
       RowBox[{
        RowBox[{"x", "[", "0", "]"}], "\[Equal]", "1"}], ",", 
       RowBox[{
        RowBox[{"y", "[", "0", "]"}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "'"}], "[", "0", "]"}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{"y", "'"}], "[", "0", "]"}], "\[Equal]", "0.5"}]}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "y"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "10"}], "}"}]}], "]"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.683261394981387*^9, 3.683261405902788*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.004823`", ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"x", "\[Rule]", 
       TagBox[
        TemplateBox[{RowBox[{
            StyleBox[
             TagBox["InterpolatingFunction", "SummaryHead"], 
             "NonInterpretableSummary"], 
            StyleBox["[", "NonInterpretableSummary"], 
            DynamicModuleBox[{Typeset`open$$ = False}, 
             PanelBox[
              PaneSelectorBox[{False -> GridBox[{{
                    PaneBox[
                    ButtonBox[
                    DynamicBox[
                    FEPrivate`FrontEndResource[
                    "FEBitmaps", "SquarePlusIconMedium"]], 
                    ButtonFunction :> (Typeset`open$$ = True), Appearance -> 
                    None, Evaluator -> Automatic, Method -> "Preemptive"], 
                    Alignment -> {Center, Center}, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    GraphicsBox[{{{{}, {}, {
                    Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]], 
                    LineBox[CompressedData["
1:eJwB0QMu/CFib1JlAgAAADwAAAACAAAAStFeOa+/hj59///////vPzd0wYnD
3cQ/F/WaqtiS7z/SUFjDa77VP28G/dJeIe4/IqE47Akn4D+cwWN5Ac/rP9Wb
k3tZVOU/bitgKYaG6D+7wbiC/fHqPyzihKw7p+M/gEqXStgX8D9jstFPSiXb
P7tJtw/c7vI/sU1j77a9wj/ziT6Xnbj1P7xVp+rmSMK/2iBupGZS+D+WQiVv
iDrAP1rNgu1ZJPs/p0bKv4of2j+J0D+8VMb9P993UKO4SuM/WwqypoYtAEAB
z+BtsunnPz63Ng34kwFAINNikYSZ6z94j482beICQBOTZVs9+e0/f/LaffdM
BECqX0s4+3/vPwX2WabgsAVAYOQ3XPb/7z/iJK2RzfwGQD308Haxl+8/jN7y
ms9kCEC6O5nvZC7uP43DDGfVtAlAUqbj2xvn6z9bMxlR8CALQFfayWmRRug/
p0NZHGqGDECseorrKVjjP0t/barn0w1ANZDZzgdp2j+8RXRWej0PQE/AUD0k
8sA/wpunYohHEEBG5S4g2UfCv+XkrgoD7RBAFllh3sImvz9vc69BiKARQLaJ
D0pdzdk/pRcaWg9IEkD8pHH0uCPjP0EBfgGh/RJAk0JOCiAx6D8cu3sZ4q8T
QOGkBMzdx+s/oorjEiVWFEAwdITmERXuP4+fRJtyChVAn5W0NxyM7z8oyg8F
wrIVQO/aVkHv/+8/AMV038BXFkBVw93TDprvPz4F00jKChdA8hzzgx427j8o
W5uT1bEXQGbwkFsM9+s/ePZcbetmGEArXYAmJGPoP3SniCgDEBlATzIKWprM
4z+vKE5UyrUZQCdDDrLrsNs/Ue8MD5xpGkDjHsih0azEP5/LNatvERtApWHO
nwlIwb9T7VfWTccbQF6EVQPjuL4/R98Tctt5HEAD+7aKD6TZP+bmOe9qIB1A
wym2PhYM4z/rM1n7BNUdQJ435xDgGeg/nJbi6KB9HkAPwYdnSY3rP4zJBUfs
Ih9AIENQ4nLr7T/iQSI0QtYfQE3m0Z1Zdu8/8mdUAc0+IECowb0Aav7vP6ZR
FDB+mSBA/McgwgWa7z96IyEXh/IgQNulA6ytOO4/JADj7pBFIUBCMNZ8Bf/r
P4F/IQ6gnyFASP+hN0p06D+0CRUesPMhQN8gzI406+M/mjaFdcVOIkBgBcXs
/6XaP59LQoUyqCJAkW5orxwLwj96a7SFoPsiQCGXK5GKGMK/CC6jzRNWI0Bf
A0XDbpnBP2z7RgaIqiNA3gDDGgek2T8yFFD6//8jQMiH5dpLMOM/NtPNyw==

                    "]]}}}, {}, {}}, {
                    DisplayFunction -> Identity, 
                    Ticks -> {Automatic, Automatic}, AxesOrigin -> {0, 0}, 
                    FrameTicks -> {{None, None}, {None, None}}, 
                    GridLines -> {None, None}, DisplayFunction -> Identity, 
                    PlotRangePadding -> {{
                    Scaled[0.1], 
                    Scaled[0.1]}, {
                    Scaled[0.1], 
                    Scaled[0.1]}}, PlotRangeClipping -> True, ImagePadding -> 
                    All, DisplayFunction -> Identity, AspectRatio -> 1, 
                    Axes -> {False, False}, AxesLabel -> {None, None}, 
                    AxesOrigin -> {0, 0}, DisplayFunction :> Identity, 
                    Frame -> {{True, True}, {True, True}}, 
                    FrameLabel -> {{None, None}, {None, None}}, FrameStyle -> 
                    Directive[
                    Opacity[0.5], 
                    Thickness[Tiny], 
                    RGBColor[0.368417, 0.506779, 0.709798]], 
                    FrameTicks -> {{None, None}, {None, None}}, 
                    GridLines -> {None, None}, GridLinesStyle -> Directive[
                    GrayLevel[0.5, 0.4]], ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], 
                    Method -> {
                    "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
                    AbsolutePointSize[6], "ScalingFunctions" -> None, 
                    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
                    (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 
                    2][#]& )[
                    Part[#, 1]], 
                    (
                    Part[{{Identity, Identity}, {Identity, Identity}}, 2, 
                    2][#]& )[
                    Part[#, 2]]}& ), "CopiedValueFunction" -> ({
                    (
                    Part[{{Identity, Identity}, {Identity, Identity}}, 1, 
                    2][#]& )[
                    Part[#, 1]], 
                    (
                    Part[{{Identity, Identity}, {Identity, Identity}}, 2, 
                    2][#]& )[
                    Part[#, 2]]}& )}}, 
                    PlotRange -> {{0., 10.}, {-0.14284979303071832`, 
                    0.9999999999999855}}, PlotRangeClipping -> True, 
                    PlotRangePadding -> {{
                    Scaled[0.1], 
                    Scaled[0.1]}, {
                    Scaled[0.1], 
                    Scaled[0.1]}}, Ticks -> {Automatic, Automatic}}], 
                    GridBox[{{
                    RowBox[{
                    TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{"0.`", ",", "10.`"}], "}"}], "}"}], 
                    "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Output: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"scalar\"", "SummaryItem"]}]}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, 
                    AutoDelete -> False, 
                    GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
                    BaseStyle -> {
                    ShowStringCharacters -> False, NumberMarks -> False, 
                    PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
                  GridBoxAlignment -> {"Rows" -> {{Top}}}, AutoDelete -> 
                  False, GridBoxItemSize -> {
                   "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                  BaselinePosition -> {1, 1}], True -> GridBox[{{
                    PaneBox[
                    ButtonBox[
                    DynamicBox[
                    FEPrivate`FrontEndResource[
                    "FEBitmaps", "SquareMinusIconMedium"]], 
                    ButtonFunction :> (Typeset`open$$ = False), Appearance -> 
                    None, Evaluator -> Automatic, Method -> "Preemptive"], 
                    Alignment -> {Center, Center}, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    GraphicsBox[{{{{}, {}, {
                    Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]], 
                    LineBox[CompressedData["
1:eJwB0QMu/CFib1JlAgAAADwAAAACAAAAStFeOa+/hj59///////vPzd0wYnD
3cQ/F/WaqtiS7z/SUFjDa77VP28G/dJeIe4/IqE47Akn4D+cwWN5Ac/rP9Wb
k3tZVOU/bitgKYaG6D+7wbiC/fHqPyzihKw7p+M/gEqXStgX8D9jstFPSiXb
P7tJtw/c7vI/sU1j77a9wj/ziT6Xnbj1P7xVp+rmSMK/2iBupGZS+D+WQiVv
iDrAP1rNgu1ZJPs/p0bKv4of2j+J0D+8VMb9P993UKO4SuM/WwqypoYtAEAB
z+BtsunnPz63Ng34kwFAINNikYSZ6z94j482beICQBOTZVs9+e0/f/LaffdM
BECqX0s4+3/vPwX2WabgsAVAYOQ3XPb/7z/iJK2RzfwGQD308Haxl+8/jN7y
ms9kCEC6O5nvZC7uP43DDGfVtAlAUqbj2xvn6z9bMxlR8CALQFfayWmRRug/
p0NZHGqGDECseorrKVjjP0t/barn0w1ANZDZzgdp2j+8RXRWej0PQE/AUD0k
8sA/wpunYohHEEBG5S4g2UfCv+XkrgoD7RBAFllh3sImvz9vc69BiKARQLaJ
D0pdzdk/pRcaWg9IEkD8pHH0uCPjP0EBfgGh/RJAk0JOCiAx6D8cu3sZ4q8T
QOGkBMzdx+s/oorjEiVWFEAwdITmERXuP4+fRJtyChVAn5W0NxyM7z8oyg8F
wrIVQO/aVkHv/+8/AMV038BXFkBVw93TDprvPz4F00jKChdA8hzzgx427j8o
W5uT1bEXQGbwkFsM9+s/ePZcbetmGEArXYAmJGPoP3SniCgDEBlATzIKWprM
4z+vKE5UyrUZQCdDDrLrsNs/Ue8MD5xpGkDjHsih0azEP5/LNatvERtApWHO
nwlIwb9T7VfWTccbQF6EVQPjuL4/R98Tctt5HEAD+7aKD6TZP+bmOe9qIB1A
wym2PhYM4z/rM1n7BNUdQJ435xDgGeg/nJbi6KB9HkAPwYdnSY3rP4zJBUfs
Ih9AIENQ4nLr7T/iQSI0QtYfQE3m0Z1Zdu8/8mdUAc0+IECowb0Aav7vP6ZR
FDB+mSBA/McgwgWa7z96IyEXh/IgQNulA6ytOO4/JADj7pBFIUBCMNZ8Bf/r
P4F/IQ6gnyFASP+hN0p06D+0CRUesPMhQN8gzI406+M/mjaFdcVOIkBgBcXs
/6XaP59LQoUyqCJAkW5orxwLwj96a7SFoPsiQCGXK5GKGMK/CC6jzRNWI0Bf
A0XDbpnBP2z7RgaIqiNA3gDDGgek2T8yFFD6//8jQMiH5dpLMOM/NtPNyw==

                    "]]}}}, {}, {}}, {
                    DisplayFunction -> Identity, 
                    Ticks -> {Automatic, Automatic}, AxesOrigin -> {0, 0}, 
                    FrameTicks -> {{None, None}, {None, None}}, 
                    GridLines -> {None, None}, DisplayFunction -> Identity, 
                    PlotRangePadding -> {{
                    Scaled[0.1], 
                    Scaled[0.1]}, {
                    Scaled[0.1], 
                    Scaled[0.1]}}, PlotRangeClipping -> True, ImagePadding -> 
                    All, DisplayFunction -> Identity, AspectRatio -> 1, 
                    Axes -> {False, False}, AxesLabel -> {None, None}, 
                    AxesOrigin -> {0, 0}, DisplayFunction :> Identity, 
                    Frame -> {{True, True}, {True, True}}, 
                    FrameLabel -> {{None, None}, {None, None}}, FrameStyle -> 
                    Directive[
                    Opacity[0.5], 
                    Thickness[Tiny], 
                    RGBColor[0.368417, 0.506779, 0.709798]], 
                    FrameTicks -> {{None, None}, {None, None}}, 
                    GridLines -> {None, None}, GridLinesStyle -> Directive[
                    GrayLevel[0.5, 0.4]], ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], 
                    Method -> {
                    "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
                    AbsolutePointSize[6], "ScalingFunctions" -> None, 
                    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
                    (
                    Part[{{Identity, Identity}, {Identity, Identity}}, 1, 
                    2][#]& )[
                    Part[#, 1]], 
                    (
                    Part[{{Identity, Identity}, {Identity, Identity}}, 2, 
                    2][#]& )[
                    Part[#, 2]]}& ), "CopiedValueFunction" -> ({
                    (
                    Part[{{Identity, Identity}, {Identity, Identity}}, 1, 
                    2][#]& )[
                    Part[#, 1]], 
                    (
                    Part[{{Identity, Identity}, {Identity, Identity}}, 2, 
                    2][#]& )[
                    Part[#, 2]]}& )}}, 
                    PlotRange -> {{0., 10.}, {-0.14284979303071832`, 
                    0.9999999999999855}}, PlotRangeClipping -> True, 
                    PlotRangePadding -> {{
                    Scaled[0.1], 
                    Scaled[0.1]}, {
                    Scaled[0.1], 
                    Scaled[0.1]}}, Ticks -> {Automatic, Automatic}}], 
                    GridBox[{{
                    RowBox[{
                    TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{"0.`", ",", "10.`"}], "}"}], "}"}], 
                    "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Output: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"scalar\"", "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Order: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["3", "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Method: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"Hermite\"", "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Periodic: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["False", "SummaryItem"]}]}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, 
                    AutoDelete -> False, 
                    GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
                    BaseStyle -> {
                    ShowStringCharacters -> False, NumberMarks -> False, 
                    PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
                  GridBoxAlignment -> {"Rows" -> {{Top}}}, AutoDelete -> 
                  False, GridBoxItemSize -> {
                   "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                  BaselinePosition -> {1, 1}]}, 
               Dynamic[Typeset`open$$], ImageSize -> Automatic], 
              BaselinePosition -> Baseline], DynamicModuleValues :> {}], 
            StyleBox["]", "NonInterpretableSummary"]}]},
         "CopyTag",
         DisplayFunction->(#& ),
         InterpretationFunction->("InterpolatingFunction[{{0., 10.}}, <>]"& )],
        False,
        Editable->False,
        SelectWithContents->True,
        Selectable->False]}], ",", 
      RowBox[{"y", "\[Rule]", 
       TagBox[
        TemplateBox[{RowBox[{
            StyleBox[
             TagBox["InterpolatingFunction", "SummaryHead"], 
             "NonInterpretableSummary"], 
            StyleBox["[", "NonInterpretableSummary"], 
            DynamicModuleBox[{Typeset`open$$ = False}, 
             PanelBox[
              PaneSelectorBox[{False -> GridBox[{{
                    PaneBox[
                    ButtonBox[
                    DynamicBox[
                    FEPrivate`FrontEndResource[
                    "FEBitmaps", "SquarePlusIconMedium"]], 
                    ButtonFunction :> (Typeset`open$$ = True), Appearance -> 
                    None, Evaluator -> Automatic, Method -> "Preemptive"], 
                    Alignment -> {Center, Center}, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    GraphicsBox[{{{{}, {}, {
                    Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]], 
                    LineBox[CompressedData["
1:eJwB0QMu/CFib1JlAgAAADwAAAACAAAAStFeOa+/hj4AyF45r792Pjd0wYnD
3cQ/5Krv+uvFtD/SUFjDa77VPx+KPeyfT8U/IqE47Akn4D9dqPUsiNLOP9Wb
k3tZVOU/ZncwZ0qC0z+7wbiC/fHqP/lDApjZ4NY/gEqXStgX8D+o+eeJYTDY
P7tJtw/c7vI/XY5K4f0I1T/ziT6Xnbj1Pxqf1bCFhF6/2iBupGZS+D+fvrIW
g4rUv1rNgu1ZJPs/3+9Yr5os2L+J0D+8VMb9P5C0Nb1vCde/WwqypoYtAEBF
lnAk7BPUvz63Ng34kwFAbD6EgJ96z794j482beICQBYvLo3RIsa/f/LaffdM
BEA6Ng/UD3m2vwX2WabgsAVAcNfLaG4yVr/iJK2RzfwGQKhfIW3AT7Q/jN7y
ms9kCECMg7F10AjFP43DDGfVtAlAOxnZEbyEzj9bMxlR8CALQBIG9vQ5v9M/
p0NZHGqGDEAdP4JyuwPXP0t/barn0w1ALgCkOyou2D+8RXRWej0PQHLbKoDN
r9Q/wpunYohHEECU3K/ADw9yP+XkrgoD7RBA1aSfP7dn1L9vc69BiKARQDXM
zxRpKti/pRcaWg9IEkCl24s6shnXv0EBfgGh/RJAf4AaFyLT078cu3sZ4q8T
QKVBIHg56c6/oorjEiVWFED/5N+jU5HFv4+fRJtyChVANd7nCiZltb8oyg8F
wrIVQLCYVLaPU12/AMV038BXFkBYRaDOCRW0Pz4F00jKChdAOxWbxUPexD8o
W5uT1bEXQNQAV1+SUM4/ePZcbetmGECrkZ1DRaTTP3SniCgDEBlAzf9hFaTP
1j+vKE5UyrUZQC//pxtoMNg/Ue8MD5xpGkCRtxgiumLVP5/LNatvERtAsMka
FQP1rz9T7VfWTccbQHjljRQYXNS/R98Tctt5HEA7XozfHinYv+bmOe9qIB1A
9mRrzU0j17/rM1n7BNUdQK0lv9p66NO/nJbi6KB9HkBrwLP8JaDPv4zJBUfs
Ih9AfSdteRBpxr/iQSI0QtYfQD2abtAfSre/8mdUAc0+IEB4W03tKAeEv6ZR
FDB+mSBAokcfJNYVtD96IyEXh/IgQBO0+90R0MQ/JADj7pBFIUDBzOubQjbO
P4F/IQ6gnyFAGwAI6+KT0z+0CRUesPMhQC63e6gywdY/mjaFdcVOIkBdTQ0n
KC/YP59LQoUyqCJA9i8Y8QPn1D96a7SFoPsiQEJjUo2l25s/CC6jzRNWI0DR
r5pj59DUv2z7RgaIqiNA9Si1Lhsp2L8yFFD6//8jQNept3Z4FNe/JJ/IhA==

                    "]]}}}, {}, {}}, {
                    DisplayFunction -> Identity, 
                    Ticks -> {Automatic, Automatic}, AxesOrigin -> {0, 0}, 
                    FrameTicks -> {{None, None}, {None, None}}, 
                    GridLines -> {None, None}, DisplayFunction -> Identity, 
                    PlotRangePadding -> {{
                    Scaled[0.1], 
                    Scaled[0.1]}, {
                    Scaled[0.1], 
                    Scaled[0.1]}}, PlotRangeClipping -> True, ImagePadding -> 
                    All, DisplayFunction -> Identity, AspectRatio -> 1, 
                    Axes -> {False, False}, AxesLabel -> {None, None}, 
                    AxesOrigin -> {0, 0}, DisplayFunction :> Identity, 
                    Frame -> {{True, True}, {True, True}}, 
                    FrameLabel -> {{None, None}, {None, None}}, FrameStyle -> 
                    Directive[
                    Opacity[0.5], 
                    Thickness[Tiny], 
                    RGBColor[0.368417, 0.506779, 0.709798]], 
                    FrameTicks -> {{None, None}, {None, None}}, 
                    GridLines -> {None, None}, GridLinesStyle -> Directive[
                    GrayLevel[0.5, 0.4]], ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], 
                    Method -> {
                    "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
                    AbsolutePointSize[6], "ScalingFunctions" -> None, 
                    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
                    (
                    Part[{{Identity, Identity}, {Identity, Identity}}, 1, 
                    2][#]& )[
                    Part[#, 1]], 
                    (
                    Part[{{Identity, Identity}, {Identity, Identity}}, 2, 
                    2][#]& )[
                    Part[#, 2]]}& ), "CopiedValueFunction" -> ({
                    (
                    Part[{{Identity, Identity}, {Identity, Identity}}, 1, 
                    2][#]& )[
                    Part[#, 1]], 
                    (
                    Part[{{Identity, Identity}, {Identity, Identity}}, 2, 
                    2][#]& )[
                    Part[#, 2]]}& )}}, 
                    PlotRange -> {{0., 10.}, {-0.3777224266411831, 
                    0.3779545087891049}}, PlotRangeClipping -> True, 
                    PlotRangePadding -> {{
                    Scaled[0.1], 
                    Scaled[0.1]}, {
                    Scaled[0.1], 
                    Scaled[0.1]}}, Ticks -> {Automatic, Automatic}}], 
                    GridBox[{{
                    RowBox[{
                    TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{"0.`", ",", "10.`"}], "}"}], "}"}], 
                    "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Output: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"scalar\"", "SummaryItem"]}]}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, 
                    AutoDelete -> False, 
                    GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
                    BaseStyle -> {
                    ShowStringCharacters -> False, NumberMarks -> False, 
                    PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
                  GridBoxAlignment -> {"Rows" -> {{Top}}}, AutoDelete -> 
                  False, GridBoxItemSize -> {
                   "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                  BaselinePosition -> {1, 1}], True -> GridBox[{{
                    PaneBox[
                    ButtonBox[
                    DynamicBox[
                    FEPrivate`FrontEndResource[
                    "FEBitmaps", "SquareMinusIconMedium"]], 
                    ButtonFunction :> (Typeset`open$$ = False), Appearance -> 
                    None, Evaluator -> Automatic, Method -> "Preemptive"], 
                    Alignment -> {Center, Center}, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    GraphicsBox[{{{{}, {}, {
                    Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]], 
                    LineBox[CompressedData["
1:eJwB0QMu/CFib1JlAgAAADwAAAACAAAAStFeOa+/hj4AyF45r792Pjd0wYnD
3cQ/5Krv+uvFtD/SUFjDa77VPx+KPeyfT8U/IqE47Akn4D9dqPUsiNLOP9Wb
k3tZVOU/ZncwZ0qC0z+7wbiC/fHqP/lDApjZ4NY/gEqXStgX8D+o+eeJYTDY
P7tJtw/c7vI/XY5K4f0I1T/ziT6Xnbj1Pxqf1bCFhF6/2iBupGZS+D+fvrIW
g4rUv1rNgu1ZJPs/3+9Yr5os2L+J0D+8VMb9P5C0Nb1vCde/WwqypoYtAEBF
lnAk7BPUvz63Ng34kwFAbD6EgJ96z794j482beICQBYvLo3RIsa/f/LaffdM
BEA6Ng/UD3m2vwX2WabgsAVAcNfLaG4yVr/iJK2RzfwGQKhfIW3AT7Q/jN7y
ms9kCECMg7F10AjFP43DDGfVtAlAOxnZEbyEzj9bMxlR8CALQBIG9vQ5v9M/
p0NZHGqGDEAdP4JyuwPXP0t/barn0w1ALgCkOyou2D+8RXRWej0PQHLbKoDN
r9Q/wpunYohHEECU3K/ADw9yP+XkrgoD7RBA1aSfP7dn1L9vc69BiKARQDXM
zxRpKti/pRcaWg9IEkCl24s6shnXv0EBfgGh/RJAf4AaFyLT078cu3sZ4q8T
QKVBIHg56c6/oorjEiVWFED/5N+jU5HFv4+fRJtyChVANd7nCiZltb8oyg8F
wrIVQLCYVLaPU12/AMV038BXFkBYRaDOCRW0Pz4F00jKChdAOxWbxUPexD8o
W5uT1bEXQNQAV1+SUM4/ePZcbetmGECrkZ1DRaTTP3SniCgDEBlAzf9hFaTP
1j+vKE5UyrUZQC//pxtoMNg/Ue8MD5xpGkCRtxgiumLVP5/LNatvERtAsMka
FQP1rz9T7VfWTccbQHjljRQYXNS/R98Tctt5HEA7XozfHinYv+bmOe9qIB1A
9mRrzU0j17/rM1n7BNUdQK0lv9p66NO/nJbi6KB9HkBrwLP8JaDPv4zJBUfs
Ih9AfSdteRBpxr/iQSI0QtYfQD2abtAfSre/8mdUAc0+IEB4W03tKAeEv6ZR
FDB+mSBAokcfJNYVtD96IyEXh/IgQBO0+90R0MQ/JADj7pBFIUDBzOubQjbO
P4F/IQ6gnyFAGwAI6+KT0z+0CRUesPMhQC63e6gywdY/mjaFdcVOIkBdTQ0n
KC/YP59LQoUyqCJA9i8Y8QPn1D96a7SFoPsiQEJjUo2l25s/CC6jzRNWI0DR
r5pj59DUv2z7RgaIqiNA9Si1Lhsp2L8yFFD6//8jQNept3Z4FNe/JJ/IhA==

                    "]]}}}, {}, {}}, {
                    DisplayFunction -> Identity, 
                    Ticks -> {Automatic, Automatic}, AxesOrigin -> {0, 0}, 
                    FrameTicks -> {{None, None}, {None, None}}, 
                    GridLines -> {None, None}, DisplayFunction -> Identity, 
                    PlotRangePadding -> {{
                    Scaled[0.1], 
                    Scaled[0.1]}, {
                    Scaled[0.1], 
                    Scaled[0.1]}}, PlotRangeClipping -> True, ImagePadding -> 
                    All, DisplayFunction -> Identity, AspectRatio -> 1, 
                    Axes -> {False, False}, AxesLabel -> {None, None}, 
                    AxesOrigin -> {0, 0}, DisplayFunction :> Identity, 
                    Frame -> {{True, True}, {True, True}}, 
                    FrameLabel -> {{None, None}, {None, None}}, FrameStyle -> 
                    Directive[
                    Opacity[0.5], 
                    Thickness[Tiny], 
                    RGBColor[0.368417, 0.506779, 0.709798]], 
                    FrameTicks -> {{None, None}, {None, None}}, 
                    GridLines -> {None, None}, GridLinesStyle -> Directive[
                    GrayLevel[0.5, 0.4]], ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], 
                    Method -> {
                    "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
                    AbsolutePointSize[6], "ScalingFunctions" -> None, 
                    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
                    (
                    Part[{{Identity, Identity}, {Identity, Identity}}, 1, 
                    2][#]& )[
                    Part[#, 1]], 
                    (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 
                    2][#]& )[
                    Part[#, 2]]}& ), "CopiedValueFunction" -> ({
                    (
                    Part[{{Identity, Identity}, {Identity, Identity}}, 1, 
                    2][#]& )[
                    Part[#, 1]], 
                    (
                    Part[{{Identity, Identity}, {Identity, Identity}}, 2, 
                    2][#]& )[
                    Part[#, 2]]}& )}}, 
                    PlotRange -> {{0., 10.}, {-0.3777224266411831, 
                    0.3779545087891049}}, PlotRangeClipping -> True, 
                    PlotRangePadding -> {{
                    Scaled[0.1], 
                    Scaled[0.1]}, {
                    Scaled[0.1], 
                    Scaled[0.1]}}, Ticks -> {Automatic, Automatic}}], 
                    GridBox[{{
                    RowBox[{
                    TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{"0.`", ",", "10.`"}], "}"}], "}"}], 
                    "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Output: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"scalar\"", "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Order: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["3", "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Method: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"Hermite\"", "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Periodic: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["False", "SummaryItem"]}]}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, 
                    AutoDelete -> False, 
                    GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
                    BaseStyle -> {
                    ShowStringCharacters -> False, NumberMarks -> False, 
                    PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
                  GridBoxAlignment -> {"Rows" -> {{Top}}}, AutoDelete -> 
                  False, GridBoxItemSize -> {
                   "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                  BaselinePosition -> {1, 1}]}, 
               Dynamic[Typeset`open$$], ImageSize -> Automatic], 
              BaselinePosition -> Baseline], DynamicModuleValues :> {}], 
            StyleBox["]", "NonInterpretableSummary"]}]},
         "CopyTag",
         DisplayFunction->(#& ),
         InterpretationFunction->("InterpolatingFunction[{{0., 10.}}, <>]"& )],
        False,
        Editable->False,
        SelectWithContents->True,
        Selectable->False]}]}], "}"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.683261373803195*^9, 3.683261417195552*^9, {3.683734314482153*^9, 
   3.6837343209072113`*^9}},ExpressionUUID->"4f9c9210-dee8-4887-bb98-\
37e63e3183fa"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ndsolveorbit", "=", 
  RowBox[{
   RowBox[{"ParametricPlot", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"x", "[", "t", "]"}], ",", 
        RowBox[{"y", "[", "t", "]"}]}], "}"}], "/.", "orbit"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "10"}], "}"}], ",", 
     RowBox[{"AxesLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Style", "[", 
         RowBox[{"\"\<x\>\"", ",", "Black", ",", "15"}], "]"}], ",", 
        RowBox[{"Style", "[", 
         RowBox[{"\"\<y\>\"", ",", "Black", ",", "15"}], "]"}]}], "}"}]}]}], 
    "]"}], "/.", 
   RowBox[{"Line", "\[Rule]", "Arrow"}]}]}]], "Input",
 CellChangeTimes->{{3.6832614349269953`*^9, 3.6832614517854013`*^9}, {
  3.6832615362262573`*^9, 3.683261546884617*^9}, {3.683262138299184*^9, 
  3.683262141993515*^9}, {3.683734326795659*^9, 3.683734329844481*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
    1.], FaceForm[Opacity[0.3]], ArrowBox[CompressedData["
1:eJw0m3k8VN//x4WKqCSyhhRCWUoS5Z2yS0lIyp6tULJGqxZUKlsUksi+Zd9y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     "]]}},
  Axes->{True, True},
  AxesLabel->{
    FormBox[
     StyleBox["\"x\"", 
      GrayLevel[0], 15, StripOnInput -> False], TraditionalForm], 
    FormBox[
     StyleBox["\"y\"", 
      GrayLevel[0], 15, StripOnInput -> False], TraditionalForm]},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  Method->{"ScalingFunctions" -> None},
  PlotRange->{{-0.14285336768107812`, 1.}, {-0.3779629879283538, 
   0.377964041177982}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.05], 
     Scaled[0.05]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.683261426882053*^9, 3.6832614520849533`*^9}, {
   3.683261540161119*^9, 3.683261547220446*^9}, 3.683262142775962*^9, {
   3.683734315122816*^9, 3.683734330500869*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ndsolveenergy", "=", "\[IndentingNewLine]", 
  RowBox[{"Plot", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox[
          RowBox[{
           RowBox[{"x", "'"}], "[", "t", "]"}], "2"], "+", 
         SuperscriptBox[
          RowBox[{
           RowBox[{"y", "'"}], "[", "t", "]"}], "2"]}], ")"}], "/", "2"}], 
      "-", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox[
          RowBox[{"x", "[", "t", "]"}], "2"], "+", 
         SuperscriptBox[
          RowBox[{"y", "[", "t", "]"}], "2"]}], ")"}], 
       RowBox[{
        RowBox[{"-", "1"}], "/", "2"}]]}], "/.", "orbit"}], ",", 
    RowBox[{"{", 
     RowBox[{"t", ",", "0", ",", "10"}], "}"}], ",", 
    RowBox[{"AxesLabel", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Style", "[", 
        RowBox[{"\"\<time\>\"", ",", "Black", ",", "12"}], "]"}], ",", 
       RowBox[{"Style", "[", 
        RowBox[{"\"\<Energy\>\"", ",", "Black", ",", "12"}], "]"}]}], 
      "}"}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.683261489310588*^9, 3.683261518659277*^9}, {
  3.68326155908528*^9, 3.683261563409322*^9}, {3.683263486814712*^9, 
  3.6832634901382637`*^9}}],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
     1.], LineBox[CompressedData["
1:eJwlnHk8lV8TwEVl55Islyz3KhQVIZV6xpqyJD8kSYgoEpJkKUmohESE7CQk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      "]]}}, {}, {}},
  
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{
    FormBox[
     StyleBox["\"time\"", 
      GrayLevel[0], 12, StripOnInput -> False], TraditionalForm], 
    FormBox[
     StyleBox["\"Energy\"", 
      GrayLevel[0], 12, StripOnInput -> False], TraditionalForm]},
  AxesOrigin->{0, -0.875004289963714},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
         Part[#, 1]], 
        (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
         Part[#, 1]], 
        (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{0, 10}, {-0.875004289963714, -0.8749990684051275}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.683261486426916*^9, 3.683261519091839*^9}, 
   3.6832615639236*^9, 3.683263490655737*^9, 3.683734337012986*^9}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["(Forward) Euler method :", "Section",
 CellChangeTimes->{{3.6832631018475533`*^9, 3.6832631079432297`*^9}, {
  3.683263138208886*^9, 3.683263139676035*^9}}],

Cell[TextData[Cell[BoxData[{
 FormBox[
  RowBox[{
   RowBox[{
    SubscriptBox["x", 
     RowBox[{"n", "+", "1"}]], "=", 
    RowBox[{
     SubscriptBox["x", "n"], "+", 
     RowBox[{
      SubscriptBox[
       RowBox[{"(", 
        SubscriptBox["v", "x"], ")"}], "n"], "\[Delta]t"}]}]}], " ", ";"}], 
  TraditionalForm], "\[IndentingNewLine]", 
 FormBox[
  RowBox[{
   RowBox[{
    SubscriptBox["y", 
     RowBox[{"n", "+", "1"}]], "=", 
    RowBox[{
     SubscriptBox["y", "n"], "+", 
     RowBox[{
      SubscriptBox[
       RowBox[{"(", 
        SubscriptBox["v", "y"], ")"}], "n"], "\[Delta]t"}]}]}], " ", ";"}], 
  TraditionalForm], "\[IndentingNewLine]", 
 FormBox[
  RowBox[{
   RowBox[{
    SubscriptBox[
     RowBox[{"(", 
      SubscriptBox["v", "x"], ")"}], 
     RowBox[{"n", "+", "1"}]], "=", 
    RowBox[{
     SubscriptBox[
      RowBox[{"(", 
       SubscriptBox["v", "x"], ")"}], "n"], "+", 
     RowBox[{
      RowBox[{
       SubscriptBox["a", "x"], "(", 
       RowBox[{
        SubscriptBox["x", "n"], ",", 
        SubscriptBox["y", "n"]}], ")"}], "\[Delta]t"}]}]}], " ", ";"}], 
  TraditionalForm], "\[IndentingNewLine]", 
 FormBox[
  RowBox[{
   RowBox[{
    SubscriptBox[
     RowBox[{"(", 
      SubscriptBox["v", "y"], ")"}], 
     RowBox[{"n", "+", "1"}]], "=", 
    RowBox[{
     SubscriptBox[
      RowBox[{"(", 
       SubscriptBox["v", "y"], ")"}], "n"], "+", 
     RowBox[{
      RowBox[{
       SubscriptBox["a", "y"], "(", 
       RowBox[{
        SubscriptBox["x", "n"], ",", 
        SubscriptBox["y", "n"]}], ")"}], "\[Delta]t"}]}]}], " ", ";"}], 
  TraditionalForm]}]]], "ItemParagraph",
 CellChangeTimes->{{3.68373368104174*^9, 3.683733804961173*^9}},
 FontSize->18],

Cell[CellGroupData[{

Cell[TextData[{
 "1. Error in each step ~ ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Delta]t", "2"], TraditionalForm]],
  FormatType->"TraditionalForm"],
 ". II. Does not conserve energy."
}], "Subsubsection",
 CellChangeTimes->{
  3.6837362514690437`*^9, {3.683736362796658*^9, 3.6837363632405033`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AbsoluteTiming", "[", "\[IndentingNewLine]", 
  RowBox[{"With", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"\[Delta]t", "=", "0.001"}], ",", 
      RowBox[{"nmax", "=", "10000"}]}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "[", "0", "]"}], "=", "1"}], ";", 
     RowBox[{
      RowBox[{"y", "[", "0", "]"}], "=", "0"}], ";", 
     RowBox[{
      RowBox[{"vx", "[", "0", "]"}], "=", "0"}], ";", 
     RowBox[{
      RowBox[{"vy", "[", "0", "]"}], "=", "0.5"}], ";", "\[IndentingNewLine]", 
     RowBox[{"Do", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"x", "[", 
          RowBox[{"n", "+", "1"}], "]"}], "=", 
         RowBox[{
          RowBox[{"x", "[", "n", "]"}], "+", 
          RowBox[{
           RowBox[{"vx", "[", "n", "]"}], "*", "\[Delta]t"}]}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"y", "[", 
          RowBox[{"n", "+", "1"}], "]"}], "=", 
         RowBox[{
          RowBox[{"y", "[", "n", "]"}], "+", 
          RowBox[{
           RowBox[{"vy", "[", "n", "]"}], "*", "\[Delta]t"}]}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"vx", "[", 
          RowBox[{"n", "+", "1"}], "]"}], "=", 
         RowBox[{
          RowBox[{"vx", "[", "n", "]"}], "+", 
          RowBox[{
           RowBox[{"ax", "[", 
            RowBox[{
             RowBox[{"x", "[", "n", "]"}], ",", 
             RowBox[{"y", "[", "n", "]"}]}], "]"}], "*", "\[Delta]t"}]}]}], 
        ";", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"vy", "[", 
          RowBox[{"n", "+", "1"}], "]"}], "=", 
         RowBox[{
          RowBox[{"vy", "[", "n", "]"}], "+", 
          RowBox[{
           RowBox[{"ay", "[", 
            RowBox[{
             RowBox[{"x", "[", "n", "]"}], ",", 
             RowBox[{"y", "[", "n", "]"}]}], "]"}], "*", "\[Delta]t"}]}]}], 
        ";"}], ",", "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{"n", ",", "0", ",", "nmax"}], "}"}]}], "]"}]}]}], "]"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.6832616421061897`*^9, 3.683261653127754*^9}, {
  3.6832616894584627`*^9, 3.683261693990344*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.209939`", ",", "Null"}], "}"}]], "Output",
 CellChangeTimes->{{3.6832616684529467`*^9, 3.683261695110804*^9}, 
   3.683734343472658*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"With", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"\[Delta]t", "=", "0.001"}], ",", 
     RowBox[{"nmax", "=", "10000"}]}], "}"}], ",", 
   RowBox[{
    RowBox[{"xeuler", "[", "\[Delta]t", "]"}], "=", 
    RowBox[{"Interpolation", "[", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"n", "*", "\[Delta]t"}], ",", 
         RowBox[{"x", "[", "n", "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"n", ",", "0", ",", "nmax"}], "}"}]}], "]"}], "]"}]}]}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.683261683469326*^9, 3.683261751804677*^9}}],

Cell[BoxData[
 TagBox[
  TemplateBox[{RowBox[{
      StyleBox[
       TagBox["InterpolatingFunction", "SummaryHead"], 
       "NonInterpretableSummary"], 
      StyleBox["[", "NonInterpretableSummary"], 
      DynamicModuleBox[{Typeset`open$$ = False}, 
       PanelBox[
        PaneSelectorBox[{False -> GridBox[{{
              PaneBox[
               ButtonBox[
                DynamicBox[
                 FEPrivate`FrontEndResource[
                 "FEBitmaps", "SquarePlusIconMedium"]], 
                ButtonFunction :> (Typeset`open$$ = True), Appearance -> None,
                 Evaluator -> Automatic, Method -> "Preemptive"], 
               Alignment -> {Center, Center}, ImageSize -> 
               Dynamic[{
                 Automatic, 
                  3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                   Magnification])}]], 
              GraphicsBox[{{{{}, {}, {
                   Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]], 
                   LineBox[CompressedData["
1:eJwB0QMu/CFib1JlAgAAADwAAAACAAAAStFeOa+/hj6c0gUAAADwPzd0wYnD
3cQ/915RFIeT7z/SUFjDa77VP4OsFm3jIu4/IqE47Akn4D+cqWQbhNHrP9Wb
k3tZVOU/k6s2+WCK6D+7wbiC/fHqP3t2X65UreM/gEqXStgX8D8aWDwtszjb
P7tJtw/c7vI/fevUAuMDwz/ziT6Xnbj1Py99CkOg2cK/2iBupGZS+D/azynW
z2m5P1rNgu1ZJPs/AzgdaZiy2D+J0D+8VMb9PyEnztiVJ+M/WwqypoYtAECl
KE990KToPz63Ng34kwFAI2uJEPaU7T94j482beICQA996PIxtPA/f/LaffdM
BEBC8bhY82nyPwX2WabgsAVAIpJR8FfE8z/iJK2RzfwGQAluaDSpw/Q/jN7y
ms9kCEA2cyoBvpP1P43DDGfVtAlAJhT4BIcY9j9bMxlR8CALQPZBJWPBZ/Y/
p0NZHGqGDEDt9QjuVHX2P0t/barn0w1AXvWRudZI9j+8RXRWej0PQJ0lB6aF
2fU/wpunYohHEEBCz1GwvzT1P+XkrgoD7RBAr9YNrrVX9D9vc69BiKARQGaN
MbMsIfM/pRcaWg9IEkABqt/Hd7fxP0EBfgGh/RJA17lhW1aw7z8cu3sZ4q8T
QFIp3EVROOs/oorjEiVWFEAAcF1mljTmP4+fRJtyChVAU63zxeUy3z8oyg8F
wrIVQI5Gb8DAy88/AMV038BXFkA6ihBnenulvz4F00jKChdA9K2aBaR+rL8o
W5uT1bEXQEdeCsOQfc0/ePZcbetmGEAefyyTiF7fP3SniCgDEBlA87EuuQ05
5j+vKE5UyrUZQGjHMonWy+s/Ue8MD5xpGkAB5DSVaI7wP5/LNatvERtArXBS
ANjB8j9T7VfWTccbQBJAITN24vQ/R98Tctt5HEDxpSegH7/2P+bmOe9qIB1A
RBwq67FN+D/rM1n7BNUdQFLpWzBf0Pk/nJbi6KB9HkDlwT6UEhL7P4zJBUfs
Ih9ANYLuvykr/D/iQSI0QtYfQIWgUm0GOP0/8mdUAc0+IEBEMc+pwBL+P6ZR
FDB+mSBAyBFlAVve/j96IyEXh/IgQDvRTwWlhf8/JADj7pBFIUBDNDcWvQIA
QIF/IQ6gnyFAAnW+qhE5AEC0CRUesPMhQANDmUH6XQBAmjaFdcVOIkDOdUdZ
I3cAQJ9LQoUyqCJAn5hvYPeAAEB6a7SFoPsiQD9rVNXkfABACC6jzRNWI0AU
q2saA2oAQGz7RgaIqiNAzV8zh7NKAEAyFFD6//8jQGs1QDxmHQBA9Ka1Dw==

                    "]]}}}, {}, {}}, {
               DisplayFunction -> Identity, Ticks -> {Automatic, Automatic}, 
                AxesOrigin -> {0, 0}, 
                FrameTicks -> {{None, None}, {None, None}}, 
                GridLines -> {None, None}, DisplayFunction -> Identity, 
                PlotRangePadding -> {{
                   Scaled[0.1], 
                   Scaled[0.1]}, {
                   Scaled[0.1], 
                   Scaled[0.1]}}, PlotRangeClipping -> True, ImagePadding -> 
                All, DisplayFunction -> Identity, AspectRatio -> 1, 
                Axes -> {False, False}, AxesLabel -> {None, None}, 
                AxesOrigin -> {0, 0}, DisplayFunction :> Identity, 
                Frame -> {{True, True}, {True, True}}, 
                FrameLabel -> {{None, None}, {None, None}}, FrameStyle -> 
                Directive[
                  Opacity[0.5], 
                  Thickness[Tiny], 
                  RGBColor[0.368417, 0.506779, 0.709798]], 
                FrameTicks -> {{None, None}, {None, None}}, 
                GridLines -> {None, None}, GridLinesStyle -> Directive[
                  GrayLevel[0.5, 0.4]], ImageSize -> 
                Dynamic[{
                  Automatic, 
                   3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], 
                Method -> {
                 "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
                  AbsolutePointSize[6], "ScalingFunctions" -> None, 
                  "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
                    (
                    Part[{{Identity, Identity}, {Identity, Identity}}, 1, 
                    2][#]& )[
                    Part[#, 1]], 
                    (
                    Part[{{Identity, Identity}, {Identity, Identity}}, 2, 
                    2][#]& )[
                    Part[#, 2]]}& ), "CopiedValueFunction" -> ({
                    (
                    Part[{{Identity, Identity}, {Identity, Identity}}, 1, 
                    2][#]& )[
                    Part[#, 1]], 
                    (
                    Part[{{Identity, Identity}, {Identity, Identity}}, 2, 
                    2][#]& )[
                    Part[#, 2]]}& )}}, 
                PlotRange -> {{0., 10.}, {-0.14726641915783875`, 
                 2.062971833615918}}, PlotRangeClipping -> True, 
                PlotRangePadding -> {{
                   Scaled[0.1], 
                   Scaled[0.1]}, {
                   Scaled[0.1], 
                   Scaled[0.1]}}, Ticks -> {Automatic, Automatic}}], 
              GridBox[{{
                 RowBox[{
                   TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                   "\[InvisibleSpace]", 
                   TagBox[
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{"0.`", ",", "10.`"}], "}"}], "}"}], 
                    "SummaryItem"]}]}, {
                 RowBox[{
                   TagBox["\"Output: \"", "SummaryItemAnnotation"], 
                   "\[InvisibleSpace]", 
                   TagBox["\"scalar\"", "SummaryItem"]}]}}, 
               GridBoxAlignment -> {
                "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, AutoDelete -> 
               False, GridBoxItemSize -> {
                "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
               GridBoxSpacings -> {
                "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
               BaseStyle -> {
                ShowStringCharacters -> False, NumberMarks -> False, 
                 PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
            GridBoxAlignment -> {"Rows" -> {{Top}}}, AutoDelete -> False, 
            GridBoxItemSize -> {
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
            BaselinePosition -> {1, 1}], True -> GridBox[{{
              PaneBox[
               ButtonBox[
                DynamicBox[
                 FEPrivate`FrontEndResource[
                 "FEBitmaps", "SquareMinusIconMedium"]], 
                ButtonFunction :> (Typeset`open$$ = False), Appearance -> 
                None, Evaluator -> Automatic, Method -> "Preemptive"], 
               Alignment -> {Center, Center}, ImageSize -> 
               Dynamic[{
                 Automatic, 
                  3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                   Magnification])}]], 
              GraphicsBox[{{{{}, {}, {
                   Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]], 
                   LineBox[CompressedData["
1:eJwB0QMu/CFib1JlAgAAADwAAAACAAAAStFeOa+/hj6c0gUAAADwPzd0wYnD
3cQ/915RFIeT7z/SUFjDa77VP4OsFm3jIu4/IqE47Akn4D+cqWQbhNHrP9Wb
k3tZVOU/k6s2+WCK6D+7wbiC/fHqP3t2X65UreM/gEqXStgX8D8aWDwtszjb
P7tJtw/c7vI/fevUAuMDwz/ziT6Xnbj1Py99CkOg2cK/2iBupGZS+D/azynW
z2m5P1rNgu1ZJPs/AzgdaZiy2D+J0D+8VMb9PyEnztiVJ+M/WwqypoYtAECl
KE990KToPz63Ng34kwFAI2uJEPaU7T94j482beICQA996PIxtPA/f/LaffdM
BEBC8bhY82nyPwX2WabgsAVAIpJR8FfE8z/iJK2RzfwGQAluaDSpw/Q/jN7y
ms9kCEA2cyoBvpP1P43DDGfVtAlAJhT4BIcY9j9bMxlR8CALQPZBJWPBZ/Y/
p0NZHGqGDEDt9QjuVHX2P0t/barn0w1AXvWRudZI9j+8RXRWej0PQJ0lB6aF
2fU/wpunYohHEEBCz1GwvzT1P+XkrgoD7RBAr9YNrrVX9D9vc69BiKARQGaN
MbMsIfM/pRcaWg9IEkABqt/Hd7fxP0EBfgGh/RJA17lhW1aw7z8cu3sZ4q8T
QFIp3EVROOs/oorjEiVWFEAAcF1mljTmP4+fRJtyChVAU63zxeUy3z8oyg8F
wrIVQI5Gb8DAy88/AMV038BXFkA6ihBnenulvz4F00jKChdA9K2aBaR+rL8o
W5uT1bEXQEdeCsOQfc0/ePZcbetmGEAefyyTiF7fP3SniCgDEBlA87EuuQ05
5j+vKE5UyrUZQGjHMonWy+s/Ue8MD5xpGkAB5DSVaI7wP5/LNatvERtArXBS
ANjB8j9T7VfWTccbQBJAITN24vQ/R98Tctt5HEDxpSegH7/2P+bmOe9qIB1A
RBwq67FN+D/rM1n7BNUdQFLpWzBf0Pk/nJbi6KB9HkDlwT6UEhL7P4zJBUfs
Ih9ANYLuvykr/D/iQSI0QtYfQIWgUm0GOP0/8mdUAc0+IEBEMc+pwBL+P6ZR
FDB+mSBAyBFlAVve/j96IyEXh/IgQDvRTwWlhf8/JADj7pBFIUBDNDcWvQIA
QIF/IQ6gnyFAAnW+qhE5AEC0CRUesPMhQANDmUH6XQBAmjaFdcVOIkDOdUdZ
I3cAQJ9LQoUyqCJAn5hvYPeAAEB6a7SFoPsiQD9rVNXkfABACC6jzRNWI0AU
q2saA2oAQGz7RgaIqiNAzV8zh7NKAEAyFFD6//8jQGs1QDxmHQBA9Ka1Dw==

                    "]]}}}, {}, {}}, {
               DisplayFunction -> Identity, Ticks -> {Automatic, Automatic}, 
                AxesOrigin -> {0, 0}, 
                FrameTicks -> {{None, None}, {None, None}}, 
                GridLines -> {None, None}, DisplayFunction -> Identity, 
                PlotRangePadding -> {{
                   Scaled[0.1], 
                   Scaled[0.1]}, {
                   Scaled[0.1], 
                   Scaled[0.1]}}, PlotRangeClipping -> True, ImagePadding -> 
                All, DisplayFunction -> Identity, AspectRatio -> 1, 
                Axes -> {False, False}, AxesLabel -> {None, None}, 
                AxesOrigin -> {0, 0}, DisplayFunction :> Identity, 
                Frame -> {{True, True}, {True, True}}, 
                FrameLabel -> {{None, None}, {None, None}}, FrameStyle -> 
                Directive[
                  Opacity[0.5], 
                  Thickness[Tiny], 
                  RGBColor[0.368417, 0.506779, 0.709798]], 
                FrameTicks -> {{None, None}, {None, None}}, 
                GridLines -> {None, None}, GridLinesStyle -> Directive[
                  GrayLevel[0.5, 0.4]], ImageSize -> 
                Dynamic[{
                  Automatic, 
                   3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], 
                Method -> {
                 "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
                  AbsolutePointSize[6], "ScalingFunctions" -> None, 
                  "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
                    (
                    Part[{{Identity, Identity}, {Identity, Identity}}, 1, 
                    2][#]& )[
                    Part[#, 1]], 
                    (
                    Part[{{Identity, Identity}, {Identity, Identity}}, 2, 
                    2][#]& )[
                    Part[#, 2]]}& ), "CopiedValueFunction" -> ({
                    (
                    Part[{{Identity, Identity}, {Identity, Identity}}, 1, 
                    2][#]& )[
                    Part[#, 1]], 
                    (
                    Part[{{Identity, Identity}, {Identity, Identity}}, 2, 
                    2][#]& )[
                    Part[#, 2]]}& )}}, 
                PlotRange -> {{0., 10.}, {-0.14726641915783875`, 
                 2.062971833615918}}, PlotRangeClipping -> True, 
                PlotRangePadding -> {{
                   Scaled[0.1], 
                   Scaled[0.1]}, {
                   Scaled[0.1], 
                   Scaled[0.1]}}, Ticks -> {Automatic, Automatic}}], 
              GridBox[{{
                 RowBox[{
                   TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                   "\[InvisibleSpace]", 
                   TagBox[
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{"0.`", ",", "10.`"}], "}"}], "}"}], 
                    "SummaryItem"]}]}, {
                 RowBox[{
                   TagBox["\"Output: \"", "SummaryItemAnnotation"], 
                   "\[InvisibleSpace]", 
                   TagBox["\"scalar\"", "SummaryItem"]}]}, {
                 RowBox[{
                   TagBox["\"Order: \"", "SummaryItemAnnotation"], 
                   "\[InvisibleSpace]", 
                   TagBox["3", "SummaryItem"]}]}, {
                 RowBox[{
                   TagBox["\"Method: \"", "SummaryItemAnnotation"], 
                   "\[InvisibleSpace]", 
                   TagBox["\"Hermite\"", "SummaryItem"]}]}, {
                 RowBox[{
                   TagBox["\"Periodic: \"", "SummaryItemAnnotation"], 
                   "\[InvisibleSpace]", 
                   TagBox["False", "SummaryItem"]}]}}, 
               GridBoxAlignment -> {
                "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, AutoDelete -> 
               False, GridBoxItemSize -> {
                "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
               GridBoxSpacings -> {
                "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
               BaseStyle -> {
                ShowStringCharacters -> False, NumberMarks -> False, 
                 PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
            GridBoxAlignment -> {"Rows" -> {{Top}}}, AutoDelete -> False, 
            GridBoxItemSize -> {
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
            BaselinePosition -> {1, 1}]}, 
         Dynamic[Typeset`open$$], ImageSize -> Automatic], BaselinePosition -> 
        Baseline], DynamicModuleValues :> {}], 
      StyleBox["]", "NonInterpretableSummary"]}]},
   "CopyTag",
   DisplayFunction->(#& ),
   InterpretationFunction->("InterpolatingFunction[{{0., 10.}}, <>]"& )],
  False,
  Editable->False,
  SelectWithContents->True,
  Selectable->False]], "Output",
 CellChangeTimes->{3.683261758976274*^9, 3.68326180355539*^9, 
  3.683734345265572*^9},ExpressionUUID->"6c4c05e8-cbbb-4bbd-88d1-\
4d72d9783445"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"With", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"\[Delta]t", "=", "0.001"}], ",", 
     RowBox[{"nmax", "=", "10000"}]}], "}"}], ",", 
   RowBox[{
    RowBox[{"yeuler", "[", "\[Delta]t", "]"}], "=", 
    RowBox[{"Interpolation", "[", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"n", "*", "\[Delta]t"}], ",", 
         RowBox[{"y", "[", "n", "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"n", ",", "0", ",", "nmax"}], "}"}]}], "]"}], "]"}]}]}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.683261816267932*^9, 3.6832618184219007`*^9}}],

Cell[BoxData[
 TagBox[
  TemplateBox[{RowBox[{
      StyleBox[
       TagBox["InterpolatingFunction", "SummaryHead"], 
       "NonInterpretableSummary"], 
      StyleBox["[", "NonInterpretableSummary"], 
      DynamicModuleBox[{Typeset`open$$ = False}, 
       PanelBox[
        PaneSelectorBox[{False -> GridBox[{{
              PaneBox[
               ButtonBox[
                DynamicBox[
                 FEPrivate`FrontEndResource[
                 "FEBitmaps", "SquarePlusIconMedium"]], 
                ButtonFunction :> (Typeset`open$$ = True), Appearance -> None,
                 Evaluator -> Automatic, Method -> "Preemptive"], 
               Alignment -> {Center, Center}, ImageSize -> 
               Dynamic[{
                 Automatic, 
                  3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                   Magnification])}]], 
              GraphicsBox[{{{{}, {}, {
                   Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]], 
                   LineBox[CompressedData["
1:eJwB0QMu/CFib1JlAgAAADwAAAACAAAAStFeOa+/hj4AwC66rr92Pjd0wYnD
3cQ//As08lzGtD/SUFjDa77VP2x6/eykUMU/IqE47Akn4D+iclXvBdXOP9Wb
k3tZVOU/scdaF9OE0z+7wbiC/fHqP8eFbiAT5tY/gEqXStgX8D/Lh7cLSDvY
P7tJtw/c7vI/UNC9p+oo1T/ziT6Xnbj1P5JrBc4U2YM/2iBupGZS+D+s2S77
KrzVv1rNgu1ZJPs/kMkXxH0o3L+J0D+8VMb9Pzw4/07QnN2/WwqypoYtAEBI
XJ2G8SPdvz63Ng34kwFAKI51ZJVo2794j482beICQDnoyirwDdm/f/LaffdM
BECfF4dgePTVvwX2WabgsAVAoyciRxmF0r/iJK2RzfwGQPDP+KtpIc6/jN7y
ms9kCEAt3P7xMz/Gv43DDGfVtAlAL/aMCD9Gvb9bMxlR8CALQA4vVKDr5qi/
p0NZHGqGDEBUmEciSNWQP0t/barn0w1AQBc31mK2sz+8RXRWej0PQERSBJpT
JsI/wpunYohHEECV86EphbLJP+XkrgoD7RBAJmNsCVFo0D9vc69BiKARQLhT
LO76CtQ/pRcaWg9IEkDZYtHvKCTXP0EBfgGh/RJAFklDm14M2j8cu3sZ4q8T
QLfOKXPIPtw/oorjEiVWFEBA6CVgvWjdP4+fRJtyChVAR8ErpTMT3T8oyg8F
wrIVQC3P49ZA3tk/AMV038BXFkDNeAWampTOPz4F00jKChdA7MrfiwUSz78o
W5uT1bEXQKoiA65PGNy/ePZcbetmGEAxj+sjcNDgv3SniCgDEBlA3UAdAcL+
4b+vKE5UyrUZQM4Au5NldeK/Ue8MD5xpGkCch7mlAHniv5/LNatvERtAm6YF
AFcr4r9T7VfWTccbQBKlbNgTl+G/R98Tctt5HEBRK4+MUNTgv+bmOe9qIB1A
wrPzTZb437/rM1n7BNUdQAyb+eo96N2/nJbi6KB9HkBwrbnMKc3bv4zJBUfs
Ih9AFDaI5VaZ2b/iQSI0QtYfQI6HpanUFNe/8mdUAc0+IEDu24N13qHUv6ZR
FDB+mSBAtP43vl3j0b96IyEXh/IgQM+22zR7Pc6/JADj7pBFIUCDvA1ecPjI
v4F/IQ6gnyFANtDLSQsqw7+0CRUesPMhQLdNfN5IXLu/mjaFdcVOIkDXhSEd
wsKuv59LQoUyqCJAa6r5ZeeBjL96a7SFoPsiQCQTXlG95J0/CC6jzRNWI0CG
OGn+lWmzP2z7RgaIqiNAA8yqVXB/vj8yFFD6//8jQBCwdIPwzsQ/PfnUvA==

                    "]]}}}, {}, {}}, {
               DisplayFunction -> Identity, Ticks -> {Automatic, Automatic}, 
                AxesOrigin -> {0, 0}, 
                FrameTicks -> {{None, None}, {None, None}}, 
                GridLines -> {None, None}, DisplayFunction -> Identity, 
                PlotRangePadding -> {{
                   Scaled[0.1], 
                   Scaled[0.1]}, {
                   Scaled[0.1], 
                   Scaled[0.1]}}, PlotRangeClipping -> True, ImagePadding -> 
                All, DisplayFunction -> Identity, AspectRatio -> 1, 
                Axes -> {False, False}, AxesLabel -> {None, None}, 
                AxesOrigin -> {0, 0}, DisplayFunction :> Identity, 
                Frame -> {{True, True}, {True, True}}, 
                FrameLabel -> {{None, None}, {None, None}}, FrameStyle -> 
                Directive[
                  Opacity[0.5], 
                  Thickness[Tiny], 
                  RGBColor[0.368417, 0.506779, 0.709798]], 
                FrameTicks -> {{None, None}, {None, None}}, 
                GridLines -> {None, None}, GridLinesStyle -> Directive[
                  GrayLevel[0.5, 0.4]], ImageSize -> 
                Dynamic[{
                  Automatic, 
                   3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], 
                Method -> {
                 "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
                  AbsolutePointSize[6], "ScalingFunctions" -> None, 
                  "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
                    (
                    Part[{{Identity, Identity}, {Identity, Identity}}, 1, 
                    2][#]& )[
                    Part[#, 1]], 
                    (
                    Part[{{Identity, Identity}, {Identity, Identity}}, 2, 
                    2][#]& )[
                    Part[#, 2]]}& ), "CopiedValueFunction" -> ({
                    (
                    Part[{{Identity, Identity}, {Identity, Identity}}, 1, 
                    2][#]& )[
                    Part[#, 1]], 
                    (
                    Part[{{Identity, Identity}, {Identity, Identity}}, 2, 
                    2][#]& )[
                    Part[#, 2]]}& )}}, 
                PlotRange -> {{0., 10.}, {-0.577270816498856, 
                 0.45951780690632305`}}, PlotRangeClipping -> True, 
                PlotRangePadding -> {{
                   Scaled[0.1], 
                   Scaled[0.1]}, {
                   Scaled[0.1], 
                   Scaled[0.1]}}, Ticks -> {Automatic, Automatic}}], 
              GridBox[{{
                 RowBox[{
                   TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                   "\[InvisibleSpace]", 
                   TagBox[
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{"0.`", ",", "10.`"}], "}"}], "}"}], 
                    "SummaryItem"]}]}, {
                 RowBox[{
                   TagBox["\"Output: \"", "SummaryItemAnnotation"], 
                   "\[InvisibleSpace]", 
                   TagBox["\"scalar\"", "SummaryItem"]}]}}, 
               GridBoxAlignment -> {
                "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, AutoDelete -> 
               False, GridBoxItemSize -> {
                "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
               GridBoxSpacings -> {
                "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
               BaseStyle -> {
                ShowStringCharacters -> False, NumberMarks -> False, 
                 PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
            GridBoxAlignment -> {"Rows" -> {{Top}}}, AutoDelete -> False, 
            GridBoxItemSize -> {
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
            BaselinePosition -> {1, 1}], True -> GridBox[{{
              PaneBox[
               ButtonBox[
                DynamicBox[
                 FEPrivate`FrontEndResource[
                 "FEBitmaps", "SquareMinusIconMedium"]], 
                ButtonFunction :> (Typeset`open$$ = False), Appearance -> 
                None, Evaluator -> Automatic, Method -> "Preemptive"], 
               Alignment -> {Center, Center}, ImageSize -> 
               Dynamic[{
                 Automatic, 
                  3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                   Magnification])}]], 
              GraphicsBox[{{{{}, {}, {
                   Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]], 
                   LineBox[CompressedData["
1:eJwB0QMu/CFib1JlAgAAADwAAAACAAAAStFeOa+/hj4AwC66rr92Pjd0wYnD
3cQ//As08lzGtD/SUFjDa77VP2x6/eykUMU/IqE47Akn4D+iclXvBdXOP9Wb
k3tZVOU/scdaF9OE0z+7wbiC/fHqP8eFbiAT5tY/gEqXStgX8D/Lh7cLSDvY
P7tJtw/c7vI/UNC9p+oo1T/ziT6Xnbj1P5JrBc4U2YM/2iBupGZS+D+s2S77
KrzVv1rNgu1ZJPs/kMkXxH0o3L+J0D+8VMb9Pzw4/07QnN2/WwqypoYtAEBI
XJ2G8SPdvz63Ng34kwFAKI51ZJVo2794j482beICQDnoyirwDdm/f/LaffdM
BECfF4dgePTVvwX2WabgsAVAoyciRxmF0r/iJK2RzfwGQPDP+KtpIc6/jN7y
ms9kCEAt3P7xMz/Gv43DDGfVtAlAL/aMCD9Gvb9bMxlR8CALQA4vVKDr5qi/
p0NZHGqGDEBUmEciSNWQP0t/barn0w1AQBc31mK2sz+8RXRWej0PQERSBJpT
JsI/wpunYohHEECV86EphbLJP+XkrgoD7RBAJmNsCVFo0D9vc69BiKARQLhT
LO76CtQ/pRcaWg9IEkDZYtHvKCTXP0EBfgGh/RJAFklDm14M2j8cu3sZ4q8T
QLfOKXPIPtw/oorjEiVWFEBA6CVgvWjdP4+fRJtyChVAR8ErpTMT3T8oyg8F
wrIVQC3P49ZA3tk/AMV038BXFkDNeAWampTOPz4F00jKChdA7MrfiwUSz78o
W5uT1bEXQKoiA65PGNy/ePZcbetmGEAxj+sjcNDgv3SniCgDEBlA3UAdAcL+
4b+vKE5UyrUZQM4Au5NldeK/Ue8MD5xpGkCch7mlAHniv5/LNatvERtAm6YF
AFcr4r9T7VfWTccbQBKlbNgTl+G/R98Tctt5HEBRK4+MUNTgv+bmOe9qIB1A
wrPzTZb437/rM1n7BNUdQAyb+eo96N2/nJbi6KB9HkBwrbnMKc3bv4zJBUfs
Ih9AFDaI5VaZ2b/iQSI0QtYfQI6HpanUFNe/8mdUAc0+IEDu24N13qHUv6ZR
FDB+mSBAtP43vl3j0b96IyEXh/IgQM+22zR7Pc6/JADj7pBFIUCDvA1ecPjI
v4F/IQ6gnyFANtDLSQsqw7+0CRUesPMhQLdNfN5IXLu/mjaFdcVOIkDXhSEd
wsKuv59LQoUyqCJAa6r5ZeeBjL96a7SFoPsiQCQTXlG95J0/CC6jzRNWI0CG
OGn+lWmzP2z7RgaIqiNAA8yqVXB/vj8yFFD6//8jQBCwdIPwzsQ/PfnUvA==

                    "]]}}}, {}, {}}, {
               DisplayFunction -> Identity, Ticks -> {Automatic, Automatic}, 
                AxesOrigin -> {0, 0}, 
                FrameTicks -> {{None, None}, {None, None}}, 
                GridLines -> {None, None}, DisplayFunction -> Identity, 
                PlotRangePadding -> {{
                   Scaled[0.1], 
                   Scaled[0.1]}, {
                   Scaled[0.1], 
                   Scaled[0.1]}}, PlotRangeClipping -> True, ImagePadding -> 
                All, DisplayFunction -> Identity, AspectRatio -> 1, 
                Axes -> {False, False}, AxesLabel -> {None, None}, 
                AxesOrigin -> {0, 0}, DisplayFunction :> Identity, 
                Frame -> {{True, True}, {True, True}}, 
                FrameLabel -> {{None, None}, {None, None}}, FrameStyle -> 
                Directive[
                  Opacity[0.5], 
                  Thickness[Tiny], 
                  RGBColor[0.368417, 0.506779, 0.709798]], 
                FrameTicks -> {{None, None}, {None, None}}, 
                GridLines -> {None, None}, GridLinesStyle -> Directive[
                  GrayLevel[0.5, 0.4]], ImageSize -> 
                Dynamic[{
                  Automatic, 
                   3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], 
                Method -> {
                 "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
                  AbsolutePointSize[6], "ScalingFunctions" -> None, 
                  "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
                    (
                    Part[{{Identity, Identity}, {Identity, Identity}}, 1, 
                    2][#]& )[
                    Part[#, 1]], 
                    (
                    Part[{{Identity, Identity}, {Identity, Identity}}, 2, 
                    2][#]& )[
                    Part[#, 2]]}& ), "CopiedValueFunction" -> ({
                    (
                    Part[{{Identity, Identity}, {Identity, Identity}}, 1, 
                    2][#]& )[
                    Part[#, 1]], 
                    (
                    Part[{{Identity, Identity}, {Identity, Identity}}, 2, 
                    2][#]& )[
                    Part[#, 2]]}& )}}, 
                PlotRange -> {{0., 10.}, {-0.577270816498856, 
                 0.45951780690632305`}}, PlotRangeClipping -> True, 
                PlotRangePadding -> {{
                   Scaled[0.1], 
                   Scaled[0.1]}, {
                   Scaled[0.1], 
                   Scaled[0.1]}}, Ticks -> {Automatic, Automatic}}], 
              GridBox[{{
                 RowBox[{
                   TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                   "\[InvisibleSpace]", 
                   TagBox[
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{"0.`", ",", "10.`"}], "}"}], "}"}], 
                    "SummaryItem"]}]}, {
                 RowBox[{
                   TagBox["\"Output: \"", "SummaryItemAnnotation"], 
                   "\[InvisibleSpace]", 
                   TagBox["\"scalar\"", "SummaryItem"]}]}, {
                 RowBox[{
                   TagBox["\"Order: \"", "SummaryItemAnnotation"], 
                   "\[InvisibleSpace]", 
                   TagBox["3", "SummaryItem"]}]}, {
                 RowBox[{
                   TagBox["\"Method: \"", "SummaryItemAnnotation"], 
                   "\[InvisibleSpace]", 
                   TagBox["\"Hermite\"", "SummaryItem"]}]}, {
                 RowBox[{
                   TagBox["\"Periodic: \"", "SummaryItemAnnotation"], 
                   "\[InvisibleSpace]", 
                   TagBox["False", "SummaryItem"]}]}}, 
               GridBoxAlignment -> {
                "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, AutoDelete -> 
               False, GridBoxItemSize -> {
                "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
               GridBoxSpacings -> {
                "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
               BaseStyle -> {
                ShowStringCharacters -> False, NumberMarks -> False, 
                 PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
            GridBoxAlignment -> {"Rows" -> {{Top}}}, AutoDelete -> False, 
            GridBoxItemSize -> {
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
            BaselinePosition -> {1, 1}]}, 
         Dynamic[Typeset`open$$], ImageSize -> Automatic], BaselinePosition -> 
        Baseline], DynamicModuleValues :> {}], 
      StyleBox["]", "NonInterpretableSummary"]}]},
   "CopyTag",
   DisplayFunction->(#& ),
   InterpretationFunction->("InterpolatingFunction[{{0., 10.}}, <>]"& )],
  False,
  Editable->False,
  SelectWithContents->True,
  Selectable->False]], "Output",
 CellChangeTimes->{3.6832618227585773`*^9, 
  3.683734346188686*^9},ExpressionUUID->"fb6c4a29-1a89-44f7-9e55-\
3fb4a9b55615"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"With", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"\[Delta]t", "=", "0.001"}], ",", 
     RowBox[{"nmax", "=", "10000"}]}], "}"}], ",", 
   RowBox[{
    RowBox[{"vxeuler", "[", "\[Delta]t", "]"}], "=", 
    RowBox[{"Interpolation", "[", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"n", "*", "\[Delta]t"}], ",", 
         RowBox[{"vx", "[", "n", "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"n", ",", "0", ",", "nmax"}], "}"}]}], "]"}], "]"}]}]}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.683261826974167*^9, 3.683261828223486*^9}}],

Cell[BoxData[
 TagBox[
  TemplateBox[{RowBox[{
      StyleBox[
       TagBox["InterpolatingFunction", "SummaryHead"], 
       "NonInterpretableSummary"], 
      StyleBox["[", "NonInterpretableSummary"], 
      DynamicModuleBox[{Typeset`open$$ = False}, 
       PanelBox[
        PaneSelectorBox[{False -> GridBox[{{
              PaneBox[
               ButtonBox[
                DynamicBox[
                 FEPrivate`FrontEndResource[
                 "FEBitmaps", "SquarePlusIconMedium"]], 
                ButtonFunction :> (Typeset`open$$ = True), Appearance -> None,
                 Evaluator -> Automatic, Method -> "Preemptive"], 
               Alignment -> {Center, Center}, ImageSize -> 
               Dynamic[{
                 Automatic, 
                  3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                   Magnification])}]], 
              GraphicsBox[{{{{}, {}, {
                   Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]], 
                   LineBox[CompressedData["
1:eJwB0QMu/CFib1JlAgAAADwAAAACAAAAStFeOa+/hj4AoOcfsL+Gvjd0wYnD
3cQ/bA7Z/eH6xL/SUFjDa77VPzhVWlH2R9a/IqE47Akn4D8pF7Ic9BThv9Wb
k3tZVOU/44XmQKai57+7wbiC/fHqP3Ud9MM8FPC/gEqXStgX8D+h50+T7D/1
v7tJtw/c7vI/rqe44Ici/b/ziT6Xnbj1PwC5cjSOU8e/2iBupGZS+D9O+FQ5
rk39P1rNgu1ZJPs/qJcoq7ju9j+J0D+8VMb9PyqLafLxo/I/WwqypoYtAEDb
yD9VRQDvPz63Ng34kwFA49odmWOV6T94j482beICQM0IXkWoWeU/f/LaffdM
BEC0vCSvhVnhPwX2WabgsAVA3Cl+S8So2z/iJK2RzfwGQGZ1I7+OmdU/jN7y
ms9kCEDwsDQ0ctLOP43DDGfVtAlAKNvUCsLAwz9bMxlR8CALQD49wgebJLA/
p0NZHGqGDEBf4FA9ayeav0t/barn0w1Ass9IFTDJu7+8RXRWej0PQB0aOB2a
osm/wpunYohHEEDgj6hZg37Sv+XkrgoD7RBAzcWjvIhX2L9vc69BiKARQOc2
F+QUJd+/pRcaWg9IEkCnWUaagQ3jv0EBfgGh/RJAQ0taGblO578cu3sZ4q8T
QPwYwtEbNuy/oorjEiVWFEAQZ2p96OXwv4+fRJtyChVA3yWUSkjZ9L8oyg8F
wrIVQIUFgA/6B/q/AMV038BXFkBWijegIR/+vz4F00jKChdArlc6gih4/D8o
W5uT1bEXQAGCLfiB5Pk/ePZcbetmGEAEDyTJd1z1P3SniCgDEBlArIcaoCpe
8j+vKE5UyrUZQDugoJJDIvA/Ue8MD5xpGkBVPOmyxWTsP5/LNatvERtAuIiR
9ENi6T9T7VfWTccbQKK0AECvlOY/R98Tctt5HECODpDKjirkP+bmOe9qIB1A
lO4xNuwj4j/rM1n7BNUdQJAJtxJgIuA/nJbi6KB9HkB97RdDSM7cP4zJBUfs
Ih9A8I8RsJSf2T/iQSI0QtYfQEFvc1fcXNY/8mdUAc0+IEDAgS73c3fTP6ZR
FDB+mSBALQxrccx00D96IyEXh/IgQDBvSIPwNcs/JADj7pBFIUD0Uy+DUwrG
P4F/IQ6gnyFAAg7Qj4GOwD+0CRUesPMhQOY5sb1BDLc/mjaFdcVOIkCUVmMk
UIioP59LQoUyqCJAEZJmDMj0ez96a7SFoPsiQCy/pvrOHaC/CC6jzRNWI0AZ
Y3McQ7yyv2z7RgaIqiNANzOPlAHNvL8yFFD6//8jQAt6NYlskcO/PrnIUA==

                    "]]}}}, {}, {}}, {
               DisplayFunction -> Identity, Ticks -> {Automatic, Automatic}, 
                AxesOrigin -> {0, 0}, 
                FrameTicks -> {{None, None}, {None, None}}, 
                GridLines -> {None, None}, DisplayFunction -> Identity, 
                PlotRangePadding -> {{
                   Scaled[0.1], 
                   Scaled[0.1]}, {
                   Scaled[0.1], 
                   Scaled[0.1]}}, PlotRangeClipping -> True, ImagePadding -> 
                All, DisplayFunction -> Identity, AspectRatio -> 1, 
                Axes -> {False, False}, AxesLabel -> {None, None}, 
                AxesOrigin -> {0, 0}, DisplayFunction :> Identity, 
                Frame -> {{True, True}, {True, True}}, 
                FrameLabel -> {{None, None}, {None, None}}, FrameStyle -> 
                Directive[
                  Opacity[0.5], 
                  Thickness[Tiny], 
                  RGBColor[0.368417, 0.506779, 0.709798]], 
                FrameTicks -> {{None, None}, {None, None}}, 
                GridLines -> {None, None}, GridLinesStyle -> Directive[
                  GrayLevel[0.5, 0.4]], ImageSize -> 
                Dynamic[{
                  Automatic, 
                   3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], 
                Method -> {
                 "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
                  AbsolutePointSize[6], "ScalingFunctions" -> None, 
                  "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
                    (
                    Part[{{Identity, Identity}, {Identity, Identity}}, 1, 
                    2][#]& )[
                    Part[#, 1]], 
                    (
                    Part[{{Identity, Identity}, {Identity, Identity}}, 2, 
                    2][#]& )[
                    Part[#, 2]]}& ), "CopiedValueFunction" -> ({
                    (
                    Part[{{Identity, Identity}, {Identity, Identity}}, 1, 
                    2][#]& )[
                    Part[#, 1]], 
                    (
                    Part[{{Identity, Identity}, {Identity, Identity}}, 2, 
                    2][#]& )[
                    Part[#, 2]]}& )}}, 
                PlotRange -> {{0., 10.}, {-1.882600427482108, 
                 1.831464981034077}}, PlotRangeClipping -> True, 
                PlotRangePadding -> {{
                   Scaled[0.1], 
                   Scaled[0.1]}, {
                   Scaled[0.1], 
                   Scaled[0.1]}}, Ticks -> {Automatic, Automatic}}], 
              GridBox[{{
                 RowBox[{
                   TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                   "\[InvisibleSpace]", 
                   TagBox[
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{"0.`", ",", "10.`"}], "}"}], "}"}], 
                    "SummaryItem"]}]}, {
                 RowBox[{
                   TagBox["\"Output: \"", "SummaryItemAnnotation"], 
                   "\[InvisibleSpace]", 
                   TagBox["\"scalar\"", "SummaryItem"]}]}}, 
               GridBoxAlignment -> {
                "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, AutoDelete -> 
               False, GridBoxItemSize -> {
                "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
               GridBoxSpacings -> {
                "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
               BaseStyle -> {
                ShowStringCharacters -> False, NumberMarks -> False, 
                 PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
            GridBoxAlignment -> {"Rows" -> {{Top}}}, AutoDelete -> False, 
            GridBoxItemSize -> {
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
            BaselinePosition -> {1, 1}], True -> GridBox[{{
              PaneBox[
               ButtonBox[
                DynamicBox[
                 FEPrivate`FrontEndResource[
                 "FEBitmaps", "SquareMinusIconMedium"]], 
                ButtonFunction :> (Typeset`open$$ = False), Appearance -> 
                None, Evaluator -> Automatic, Method -> "Preemptive"], 
               Alignment -> {Center, Center}, ImageSize -> 
               Dynamic[{
                 Automatic, 
                  3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                   Magnification])}]], 
              GraphicsBox[{{{{}, {}, {
                   Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]], 
                   LineBox[CompressedData["
1:eJwB0QMu/CFib1JlAgAAADwAAAACAAAAStFeOa+/hj4AoOcfsL+Gvjd0wYnD
3cQ/bA7Z/eH6xL/SUFjDa77VPzhVWlH2R9a/IqE47Akn4D8pF7Ic9BThv9Wb
k3tZVOU/44XmQKai57+7wbiC/fHqP3Ud9MM8FPC/gEqXStgX8D+h50+T7D/1
v7tJtw/c7vI/rqe44Ici/b/ziT6Xnbj1PwC5cjSOU8e/2iBupGZS+D9O+FQ5
rk39P1rNgu1ZJPs/qJcoq7ju9j+J0D+8VMb9PyqLafLxo/I/WwqypoYtAEDb
yD9VRQDvPz63Ng34kwFA49odmWOV6T94j482beICQM0IXkWoWeU/f/LaffdM
BEC0vCSvhVnhPwX2WabgsAVA3Cl+S8So2z/iJK2RzfwGQGZ1I7+OmdU/jN7y
ms9kCEDwsDQ0ctLOP43DDGfVtAlAKNvUCsLAwz9bMxlR8CALQD49wgebJLA/
p0NZHGqGDEBf4FA9ayeav0t/barn0w1Ass9IFTDJu7+8RXRWej0PQB0aOB2a
osm/wpunYohHEEDgj6hZg37Sv+XkrgoD7RBAzcWjvIhX2L9vc69BiKARQOc2
F+QUJd+/pRcaWg9IEkCnWUaagQ3jv0EBfgGh/RJAQ0taGblO578cu3sZ4q8T
QPwYwtEbNuy/oorjEiVWFEAQZ2p96OXwv4+fRJtyChVA3yWUSkjZ9L8oyg8F
wrIVQIUFgA/6B/q/AMV038BXFkBWijegIR/+vz4F00jKChdArlc6gih4/D8o
W5uT1bEXQAGCLfiB5Pk/ePZcbetmGEAEDyTJd1z1P3SniCgDEBlArIcaoCpe
8j+vKE5UyrUZQDugoJJDIvA/Ue8MD5xpGkBVPOmyxWTsP5/LNatvERtAuIiR
9ENi6T9T7VfWTccbQKK0AECvlOY/R98Tctt5HECODpDKjirkP+bmOe9qIB1A
lO4xNuwj4j/rM1n7BNUdQJAJtxJgIuA/nJbi6KB9HkB97RdDSM7cP4zJBUfs
Ih9A8I8RsJSf2T/iQSI0QtYfQEFvc1fcXNY/8mdUAc0+IEDAgS73c3fTP6ZR
FDB+mSBALQxrccx00D96IyEXh/IgQDBvSIPwNcs/JADj7pBFIUD0Uy+DUwrG
P4F/IQ6gnyFAAg7Qj4GOwD+0CRUesPMhQOY5sb1BDLc/mjaFdcVOIkCUVmMk
UIioP59LQoUyqCJAEZJmDMj0ez96a7SFoPsiQCy/pvrOHaC/CC6jzRNWI0AZ
Y3McQ7yyv2z7RgaIqiNANzOPlAHNvL8yFFD6//8jQAt6NYlskcO/PrnIUA==

                    "]]}}}, {}, {}}, {
               DisplayFunction -> Identity, Ticks -> {Automatic, Automatic}, 
                AxesOrigin -> {0, 0}, 
                FrameTicks -> {{None, None}, {None, None}}, 
                GridLines -> {None, None}, DisplayFunction -> Identity, 
                PlotRangePadding -> {{
                   Scaled[0.1], 
                   Scaled[0.1]}, {
                   Scaled[0.1], 
                   Scaled[0.1]}}, PlotRangeClipping -> True, ImagePadding -> 
                All, DisplayFunction -> Identity, AspectRatio -> 1, 
                Axes -> {False, False}, AxesLabel -> {None, None}, 
                AxesOrigin -> {0, 0}, DisplayFunction :> Identity, 
                Frame -> {{True, True}, {True, True}}, 
                FrameLabel -> {{None, None}, {None, None}}, FrameStyle -> 
                Directive[
                  Opacity[0.5], 
                  Thickness[Tiny], 
                  RGBColor[0.368417, 0.506779, 0.709798]], 
                FrameTicks -> {{None, None}, {None, None}}, 
                GridLines -> {None, None}, GridLinesStyle -> Directive[
                  GrayLevel[0.5, 0.4]], ImageSize -> 
                Dynamic[{
                  Automatic, 
                   3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], 
                Method -> {
                 "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
                  AbsolutePointSize[6], "ScalingFunctions" -> None, 
                  "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
                    (
                    Part[{{Identity, Identity}, {Identity, Identity}}, 1, 
                    2][#]& )[
                    Part[#, 1]], 
                    (
                    Part[{{Identity, Identity}, {Identity, Identity}}, 2, 
                    2][#]& )[
                    Part[#, 2]]}& ), "CopiedValueFunction" -> ({
                    (
                    Part[{{Identity, Identity}, {Identity, Identity}}, 1, 
                    2][#]& )[
                    Part[#, 1]], 
                    (
                    Part[{{Identity, Identity}, {Identity, Identity}}, 2, 
                    2][#]& )[
                    Part[#, 2]]}& )}}, 
                PlotRange -> {{0., 10.}, {-1.882600427482108, 
                 1.831464981034077}}, PlotRangeClipping -> True, 
                PlotRangePadding -> {{
                   Scaled[0.1], 
                   Scaled[0.1]}, {
                   Scaled[0.1], 
                   Scaled[0.1]}}, Ticks -> {Automatic, Automatic}}], 
              GridBox[{{
                 RowBox[{
                   TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                   "\[InvisibleSpace]", 
                   TagBox[
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{"0.`", ",", "10.`"}], "}"}], "}"}], 
                    "SummaryItem"]}]}, {
                 RowBox[{
                   TagBox["\"Output: \"", "SummaryItemAnnotation"], 
                   "\[InvisibleSpace]", 
                   TagBox["\"scalar\"", "SummaryItem"]}]}, {
                 RowBox[{
                   TagBox["\"Order: \"", "SummaryItemAnnotation"], 
                   "\[InvisibleSpace]", 
                   TagBox["3", "SummaryItem"]}]}, {
                 RowBox[{
                   TagBox["\"Method: \"", "SummaryItemAnnotation"], 
                   "\[InvisibleSpace]", 
                   TagBox["\"Hermite\"", "SummaryItem"]}]}, {
                 RowBox[{
                   TagBox["\"Periodic: \"", "SummaryItemAnnotation"], 
                   "\[InvisibleSpace]", 
                   TagBox["False", "SummaryItem"]}]}}, 
               GridBoxAlignment -> {
                "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, AutoDelete -> 
               False, GridBoxItemSize -> {
                "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
               GridBoxSpacings -> {
                "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
               BaseStyle -> {
                ShowStringCharacters -> False, NumberMarks -> False, 
                 PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
            GridBoxAlignment -> {"Rows" -> {{Top}}}, AutoDelete -> False, 
            GridBoxItemSize -> {
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
            BaselinePosition -> {1, 1}]}, 
         Dynamic[Typeset`open$$], ImageSize -> Automatic], BaselinePosition -> 
        Baseline], DynamicModuleValues :> {}], 
      StyleBox["]", "NonInterpretableSummary"]}]},
   "CopyTag",
   DisplayFunction->(#& ),
   InterpretationFunction->("InterpolatingFunction[{{0., 10.}}, <>]"& )],
  False,
  Editable->False,
  SelectWithContents->True,
  Selectable->False]], "Output",
 CellChangeTimes->{3.6832618289771833`*^9, 3.6832618623666773`*^9, 
  3.683734347127438*^9},ExpressionUUID->"5be9f7b2-e72a-4d92-bd2b-\
6728ee310cda"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"With", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"\[Delta]t", "=", "0.001"}], ",", 
     RowBox[{"nmax", "=", "10000"}]}], "}"}], ",", 
   RowBox[{
    RowBox[{"vyeuler", "[", "\[Delta]t", "]"}], "=", 
    RowBox[{"Interpolation", "[", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"n", "*", "\[Delta]t"}], ",", 
         RowBox[{"vy", "[", "n", "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"n", ",", "0", ",", "nmax"}], "}"}]}], "]"}], "]"}]}]}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.683261866543598*^9, 3.6832618689251013`*^9}}],

Cell[BoxData[
 TagBox[
  TemplateBox[{RowBox[{
      StyleBox[
       TagBox["InterpolatingFunction", "SummaryHead"], 
       "NonInterpretableSummary"], 
      StyleBox["[", "NonInterpretableSummary"], 
      DynamicModuleBox[{Typeset`open$$ = False}, 
       PanelBox[
        PaneSelectorBox[{False -> GridBox[{{
              PaneBox[
               ButtonBox[
                DynamicBox[
                 FEPrivate`FrontEndResource[
                 "FEBitmaps", "SquarePlusIconMedium"]], 
                ButtonFunction :> (Typeset`open$$ = True), Appearance -> None,
                 Evaluator -> Automatic, Method -> "Preemptive"], 
               Alignment -> {Center, Center}, ImageSize -> 
               Dynamic[{
                 Automatic, 
                  3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                   Magnification])}]], 
              GraphicsBox[{{{{}, {}, {
                   Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]], 
                   
                   LineBox[{{1.694915254237288*^-7, 0.5000000000423656}, {
                    0.16301769472457447`, 0.4933131142215983}, {
                    0.3397473724046566, 0.4695509455859097}, {
                    0.5047654737182123, 0.42757110192263703`}, {
                    0.6665465749364282, 0.35877809445924586`}, {
                    0.8420398286016771, 0.22936424102091318`}, {
                    1.0058215059003999`, -0.004543246402628605}, {
                    1.1833153356461554`, -0.6744332850694625}, {
                    1.196482093075258, -0.8851859885995517}}], 
                   LineBox[CompressedData["
1:eJwBoQFe/iFib1JlAgAAABkAAAACAAAAUk3QlZDK+D86M/2QcVPsv1rNgu1Z
JPs/iuBEPHnV0b+J0D+8VMb9P51tvWbw15q/WwqypoYtAEB88oIwwmS7Pz63
Ng34kwFAh59ErAUYyT94j482beICQNuSoBmIF9A/f/LaffdMBEAT1QimXcjS
PwX2WabgsAVA5qwXS+yn1D/iJK2RzfwGQClsO+hP6tU/jN7yms9kCECHobRj
KuDWP43DDGfVtAlA8ieFwj921z9bMxlR8CALQHetBytGztc/p0NZHGqGDEC4
WT3pKt/XP0t/barn0w1AlKkhodGx1z+8RXRWej0PQMSYaZeEOtc/wpunYohH
EECC7aAaU4HWP+XkrgoD7RBAHIZa7Gh51T9vc69BiKARQOlfa8xj5tM/pRca
Wg9IEkCrWhAI7trRP0EBfgGh/RJA2/UP7blyzT8cu3sZ4q8TQBR8eRBFW8Q/
oorjEiVWFEDXYVXsXOasP4+fRJtyChVAp+hBuMypwb8oyg8FwrIVQKJc407I
DuG//sgjxNzeFUA6M/2QcVPsvxyuw1E=
                    "]], 
                   LineBox[CompressedData["
1:eJwBsQFO/iFib1JlAgAAABoAAAACAAAAIo0TyvabF0A6M/2QcVPsvyhbm5PV
sRdAmfL8/bX/5r949lxt62YYQFxIquKPZtS/dKeIKAMQGUBtU7KOa3TCv68o
TlTKtRlARCh3FGpJpb9R7wwPnGkaQGDEzpaFhqA/n8s1q28RG0DunT5WV820
P1PtV9ZNxxtA+xfrzyrzvj9H3xNy23kcQD9HretXS8M/5uY572ogHUAfUvHa
LiDGP+szWfsE1R1AAXhdYHabyD+cluLooH0eQNWtilbgf8o/jMkFR+wiH0D5
GKrDNgrMP+JBIjRC1h9AaG6/XMVszT/yZ1QBzT4gQFNoNEFtfs4/plEUMH6Z
IECZeBsRVHLPP3ojIReH8iBATGx03dMZ0D8kAOPukEUhQJbu3ePMYdA/gX8h
DqCfIUCCMRrd9Z3QP7QJFR6w8yFAGY8H4prG0D+aNoV1xU4iQDprv5m94tA/
n0tChTKoIkA0/fIi4e7QP3prtIWg+yJA2rSBuZfs0D8ILqPNE1YjQHlrzAIs
29A/bPtGBoiqI0D4wy6seLzQPzIUUPr//yNAOs0JinuO0D8/ssZ1
                    
                    "]]}}}, {}, {}}, {
               DisplayFunction -> Identity, Ticks -> {Automatic, Automatic}, 
                AxesOrigin -> {0, 0}, 
                FrameTicks -> {{None, None}, {None, None}}, 
                GridLines -> {None, None}, DisplayFunction -> Identity, 
                PlotRangePadding -> {{
                   Scaled[0.1], 
                   Scaled[0.1]}, {
                   Scaled[0.1], 
                   Scaled[0.1]}}, PlotRangeClipping -> True, ImagePadding -> 
                All, DisplayFunction -> Identity, AspectRatio -> 1, 
                Axes -> {False, False}, AxesLabel -> {None, None}, 
                AxesOrigin -> {0, 0}, DisplayFunction :> Identity, 
                Frame -> {{True, True}, {True, True}}, 
                FrameLabel -> {{None, None}, {None, None}}, FrameStyle -> 
                Directive[
                  Opacity[0.5], 
                  Thickness[Tiny], 
                  RGBColor[0.368417, 0.506779, 0.709798]], 
                FrameTicks -> {{None, None}, {None, None}}, 
                GridLines -> {None, None}, GridLinesStyle -> Directive[
                  GrayLevel[0.5, 0.4]], ImageSize -> 
                Dynamic[{
                  Automatic, 
                   3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], 
                Method -> {
                 "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
                  AbsolutePointSize[6], "ScalingFunctions" -> None, 
                  "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
                    (
                    Part[{{Identity, Identity}, {Identity, Identity}}, 1, 
                    2][#]& )[
                    Part[#, 1]], 
                    (
                    Part[{{Identity, Identity}, {Identity, Identity}}, 2, 
                    2][#]& )[
                    Part[#, 2]]}& ), "CopiedValueFunction" -> ({
                    (
                    Part[{{Identity, Identity}, {Identity, Identity}}, 1, 
                    2][#]& )[
                    Part[#, 1]], 
                    (
                    Part[{{Identity, Identity}, {Identity, Identity}}, 2, 
                    2][#]& )[
                    Part[#, 2]]}& )}}, 
                PlotRange -> {{0., 10.}, {-0.8851859885995517, 
                 0.5000000000423656}}, PlotRangeClipping -> True, 
                PlotRangePadding -> {{
                   Scaled[0.1], 
                   Scaled[0.1]}, {
                   Scaled[0.1], 
                   Scaled[0.1]}}, Ticks -> {Automatic, Automatic}}], 
              GridBox[{{
                 RowBox[{
                   TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                   "\[InvisibleSpace]", 
                   TagBox[
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{"0.`", ",", "10.`"}], "}"}], "}"}], 
                    "SummaryItem"]}]}, {
                 RowBox[{
                   TagBox["\"Output: \"", "SummaryItemAnnotation"], 
                   "\[InvisibleSpace]", 
                   TagBox["\"scalar\"", "SummaryItem"]}]}}, 
               GridBoxAlignment -> {
                "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, AutoDelete -> 
               False, GridBoxItemSize -> {
                "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
               GridBoxSpacings -> {
                "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
               BaseStyle -> {
                ShowStringCharacters -> False, NumberMarks -> False, 
                 PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
            GridBoxAlignment -> {"Rows" -> {{Top}}}, AutoDelete -> False, 
            GridBoxItemSize -> {
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
            BaselinePosition -> {1, 1}], True -> GridBox[{{
              PaneBox[
               ButtonBox[
                DynamicBox[
                 FEPrivate`FrontEndResource[
                 "FEBitmaps", "SquareMinusIconMedium"]], 
                ButtonFunction :> (Typeset`open$$ = False), Appearance -> 
                None, Evaluator -> Automatic, Method -> "Preemptive"], 
               Alignment -> {Center, Center}, ImageSize -> 
               Dynamic[{
                 Automatic, 
                  3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                   Magnification])}]], 
              GraphicsBox[{{{{}, {}, {
                   Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]], 
                   
                   LineBox[{{1.694915254237288*^-7, 0.5000000000423656}, {
                    0.16301769472457447`, 0.4933131142215983}, {
                    0.3397473724046566, 0.4695509455859097}, {
                    0.5047654737182123, 0.42757110192263703`}, {
                    0.6665465749364282, 0.35877809445924586`}, {
                    0.8420398286016771, 0.22936424102091318`}, {
                    1.0058215059003999`, -0.004543246402628605}, {
                    1.1833153356461554`, -0.6744332850694625}, {
                    1.196482093075258, -0.8851859885995517}}], 
                   LineBox[CompressedData["
1:eJwBoQFe/iFib1JlAgAAABkAAAACAAAAUk3QlZDK+D86M/2QcVPsv1rNgu1Z
JPs/iuBEPHnV0b+J0D+8VMb9P51tvWbw15q/WwqypoYtAEB88oIwwmS7Pz63
Ng34kwFAh59ErAUYyT94j482beICQNuSoBmIF9A/f/LaffdMBEAT1QimXcjS
PwX2WabgsAVA5qwXS+yn1D/iJK2RzfwGQClsO+hP6tU/jN7yms9kCECHobRj
KuDWP43DDGfVtAlA8ieFwj921z9bMxlR8CALQHetBytGztc/p0NZHGqGDEC4
WT3pKt/XP0t/barn0w1AlKkhodGx1z+8RXRWej0PQMSYaZeEOtc/wpunYohH
EECC7aAaU4HWP+XkrgoD7RBAHIZa7Gh51T9vc69BiKARQOlfa8xj5tM/pRca
Wg9IEkCrWhAI7trRP0EBfgGh/RJA2/UP7blyzT8cu3sZ4q8TQBR8eRBFW8Q/
oorjEiVWFEDXYVXsXOasP4+fRJtyChVAp+hBuMypwb8oyg8FwrIVQKJc407I
DuG//sgjxNzeFUA6M/2QcVPsvxyuw1E=
                    "]], 
                   LineBox[CompressedData["
1:eJwBsQFO/iFib1JlAgAAABoAAAACAAAAIo0TyvabF0A6M/2QcVPsvyhbm5PV
sRdAmfL8/bX/5r949lxt62YYQFxIquKPZtS/dKeIKAMQGUBtU7KOa3TCv68o
TlTKtRlARCh3FGpJpb9R7wwPnGkaQGDEzpaFhqA/n8s1q28RG0DunT5WV820
P1PtV9ZNxxtA+xfrzyrzvj9H3xNy23kcQD9HretXS8M/5uY572ogHUAfUvHa
LiDGP+szWfsE1R1AAXhdYHabyD+cluLooH0eQNWtilbgf8o/jMkFR+wiH0D5
GKrDNgrMP+JBIjRC1h9AaG6/XMVszT/yZ1QBzT4gQFNoNEFtfs4/plEUMH6Z
IECZeBsRVHLPP3ojIReH8iBATGx03dMZ0D8kAOPukEUhQJbu3ePMYdA/gX8h
DqCfIUCCMRrd9Z3QP7QJFR6w8yFAGY8H4prG0D+aNoV1xU4iQDprv5m94tA/
n0tChTKoIkA0/fIi4e7QP3prtIWg+yJA2rSBuZfs0D8ILqPNE1YjQHlrzAIs
29A/bPtGBoiqI0D4wy6seLzQPzIUUPr//yNAOs0JinuO0D8/ssZ1
                    
                    "]]}}}, {}, {}}, {
               DisplayFunction -> Identity, Ticks -> {Automatic, Automatic}, 
                AxesOrigin -> {0, 0}, 
                FrameTicks -> {{None, None}, {None, None}}, 
                GridLines -> {None, None}, DisplayFunction -> Identity, 
                PlotRangePadding -> {{
                   Scaled[0.1], 
                   Scaled[0.1]}, {
                   Scaled[0.1], 
                   Scaled[0.1]}}, PlotRangeClipping -> True, ImagePadding -> 
                All, DisplayFunction -> Identity, AspectRatio -> 1, 
                Axes -> {False, False}, AxesLabel -> {None, None}, 
                AxesOrigin -> {0, 0}, DisplayFunction :> Identity, 
                Frame -> {{True, True}, {True, True}}, 
                FrameLabel -> {{None, None}, {None, None}}, FrameStyle -> 
                Directive[
                  Opacity[0.5], 
                  Thickness[Tiny], 
                  RGBColor[0.368417, 0.506779, 0.709798]], 
                FrameTicks -> {{None, None}, {None, None}}, 
                GridLines -> {None, None}, GridLinesStyle -> Directive[
                  GrayLevel[0.5, 0.4]], ImageSize -> 
                Dynamic[{
                  Automatic, 
                   3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], 
                Method -> {
                 "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
                  AbsolutePointSize[6], "ScalingFunctions" -> None, 
                  "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
                    (
                    Part[{{Identity, Identity}, {Identity, Identity}}, 1, 
                    2][#]& )[
                    Part[#, 1]], 
                    (
                    Part[{{Identity, Identity}, {Identity, Identity}}, 2, 
                    2][#]& )[
                    Part[#, 2]]}& ), "CopiedValueFunction" -> ({
                    (
                    Part[{{Identity, Identity}, {Identity, Identity}}, 1, 
                    2][#]& )[
                    Part[#, 1]], 
                    (
                    Part[{{Identity, Identity}, {Identity, Identity}}, 2, 
                    2][#]& )[
                    Part[#, 2]]}& )}}, 
                PlotRange -> {{0., 10.}, {-0.8851859885995517, 
                 0.5000000000423656}}, PlotRangeClipping -> True, 
                PlotRangePadding -> {{
                   Scaled[0.1], 
                   Scaled[0.1]}, {
                   Scaled[0.1], 
                   Scaled[0.1]}}, Ticks -> {Automatic, Automatic}}], 
              GridBox[{{
                 RowBox[{
                   TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                   "\[InvisibleSpace]", 
                   TagBox[
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{"0.`", ",", "10.`"}], "}"}], "}"}], 
                    "SummaryItem"]}]}, {
                 RowBox[{
                   TagBox["\"Output: \"", "SummaryItemAnnotation"], 
                   "\[InvisibleSpace]", 
                   TagBox["\"scalar\"", "SummaryItem"]}]}, {
                 RowBox[{
                   TagBox["\"Order: \"", "SummaryItemAnnotation"], 
                   "\[InvisibleSpace]", 
                   TagBox["3", "SummaryItem"]}]}, {
                 RowBox[{
                   TagBox["\"Method: \"", "SummaryItemAnnotation"], 
                   "\[InvisibleSpace]", 
                   TagBox["\"Hermite\"", "SummaryItem"]}]}, {
                 RowBox[{
                   TagBox["\"Periodic: \"", "SummaryItemAnnotation"], 
                   "\[InvisibleSpace]", 
                   TagBox["False", "SummaryItem"]}]}}, 
               GridBoxAlignment -> {
                "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, AutoDelete -> 
               False, GridBoxItemSize -> {
                "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
               GridBoxSpacings -> {
                "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
               BaseStyle -> {
                ShowStringCharacters -> False, NumberMarks -> False, 
                 PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
            GridBoxAlignment -> {"Rows" -> {{Top}}}, AutoDelete -> False, 
            GridBoxItemSize -> {
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
            BaselinePosition -> {1, 1}]}, 
         Dynamic[Typeset`open$$], ImageSize -> Automatic], BaselinePosition -> 
        Baseline], DynamicModuleValues :> {}], 
      StyleBox["]", "NonInterpretableSummary"]}]},
   "CopyTag",
   DisplayFunction->(#& ),
   InterpretationFunction->("InterpolatingFunction[{{0., 10.}}, <>]"& )],
  False,
  Editable->False,
  SelectWithContents->True,
  Selectable->False]], "Output",
 CellChangeTimes->{3.6832618694225473`*^9, 
  3.683734348016985*^9},ExpressionUUID->"dad8126e-1d51-4302-a76a-\
b63c143fa8b2"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"With", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\[Delta]t", "=", "0.001"}], "}"}], ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"eulerorbit", "[", "\[Delta]t", "]"}], "=", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"ParametricPlot", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"xeuler", "[", "\[Delta]t", "]"}], "[", "t", "]"}], ",", 
         RowBox[{
          RowBox[{"yeuler", "[", "\[Delta]t", "]"}], "[", "t", "]"}]}], "}"}],
        ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", "0", ",", "10"}], "}"}], ",", 
       RowBox[{"AxesLabel", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Style", "[", 
           RowBox[{"\"\<x\>\"", ",", "Black", ",", "15"}], "]"}], ",", 
          RowBox[{"Style", "[", 
           RowBox[{"\"\<y\>\"", ",", "Black", ",", "15"}], "]"}]}], "}"}]}], 
       ",", 
       RowBox[{"PlotStyle", "\[Rule]", "Black"}]}], "]"}], "/.", 
     RowBox[{"Line", "\[Rule]", "Arrow"}]}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.683261910648492*^9, 3.683261942184559*^9}, {
  3.683262161372587*^9, 3.6832621722183123`*^9}, {3.683262249312037*^9, 
  3.683262250143906*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {GrayLevel[0], AbsoluteThickness[1.6], Opacity[1.], FaceForm[Opacity[0.3]],
     ArrowBox[CompressedData["
1:eJw013c8le//OHBKJSGzUlkhUbKLqJe0U/IWyczIKllZycwoOzuprMyQvbns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     "]]}},
  Axes->{True, True},
  AxesLabel->{
    FormBox[
     StyleBox["\"x\"", 
      GrayLevel[0], 15, StripOnInput -> False], TraditionalForm], 
    FormBox[
     StyleBox["\"y\"", 
      GrayLevel[0], 15, StripOnInput -> False], TraditionalForm]},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  Method->{"ScalingFunctions" -> None},
  PlotRange->{{-0.15654960467110648`, 
   2.063074376739849}, {-0.5786681428334729, 0.4614090111318889}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.05], 
     Scaled[0.05]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.683261924014382*^9, 3.683261942897002*^9}, 
   3.6832621726793137`*^9, 3.683262250497493*^9, 3.683262668846613*^9, 
   3.683734348872497*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"With", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\[Delta]t", "=", "0.001"}], "}"}], ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"eulerenergy", "[", "\[Delta]t", "]"}], "=", 
    "\[IndentingNewLine]", 
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox[
           RowBox[{
            RowBox[{"vxeuler", "[", "\[Delta]t", "]"}], "[", "t", "]"}], "2"],
           "+", 
          SuperscriptBox[
           RowBox[{
            RowBox[{"vyeuler", "[", "\[Delta]t", "]"}], "[", "t", "]"}], 
           "2"]}], ")"}], "/", "2"}], "-", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox[
           RowBox[{
            RowBox[{"xeuler", "[", "\[Delta]t", "]"}], "[", "t", "]"}], "2"], 
          "+", 
          SuperscriptBox[
           RowBox[{
            RowBox[{"yeuler", "[", "\[Delta]t", "]"}], "[", "t", "]"}], 
           "2"]}], ")"}], 
        RowBox[{
         RowBox[{"-", "1"}], "/", "2"}]]}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "10"}], "}"}], ",", 
      RowBox[{"AxesLabel", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Style", "[", 
          RowBox[{"\"\<time\>\"", ",", "Black", ",", "12"}], "]"}], ",", 
         RowBox[{"Style", "[", 
          RowBox[{"\"\<Energy\>\"", ",", "Black", ",", "12"}], "]"}]}], 
        "}"}]}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", "Black"}]}], "]"}]}]}], "]"}]], "Input",\

 CellChangeTimes->{{3.683262030303484*^9, 3.68326207088873*^9}, {
  3.683262182930636*^9, 3.6832621977268*^9}, {3.6832622532398376`*^9, 
  3.683262253746169*^9}}],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    {GrayLevel[0], AbsoluteThickness[1.6], Opacity[1.], 
     LineBox[CompressedData["
1:eJwd13c81d8bAHCjIVHkLpfskIRKkuScRCjfhoSWJCHZpRRFZVVWVlZWFA2V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      "]]}}, {}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{
    FormBox[
     StyleBox["\"time\"", 
      GrayLevel[0], 12, StripOnInput -> False], TraditionalForm], 
    FormBox[
     StyleBox["\"Energy\"", 
      GrayLevel[0], 12, StripOnInput -> False], TraditionalForm]},
  AxesOrigin->{0, -0.8749999998724491},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
         Part[#, 1]], 
        (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
         Part[#, 1]], 
        (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{0, 10}, {-0.8749999998724491, -0.44919655841100825`}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.68326204728004*^9, 3.683262071576764*^9}, 
   3.683262199177944*^9, 3.6832622541502523`*^9, 3.6832626694432077`*^9, 
   3.683263588678843*^9, 3.6837343508212347`*^9}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["(Explicit) midpoint method :", "Section",
 CellChangeTimes->{{3.6832631216800213`*^9, 3.6832631316966553`*^9}}],

Cell[BoxData[{
 FormBox[
  RowBox[{
   RowBox[{
    SubscriptBox["x", 
     RowBox[{"n", "+", "1"}]], "=", 
    RowBox[{
     SubscriptBox["x", "n"], "+", 
     RowBox[{
      RowBox[{"[", 
       RowBox[{
        SubscriptBox[
         RowBox[{"(", 
          SubscriptBox["v", "x"], ")"}], "n"], "+", 
        RowBox[{
         RowBox[{
          SubscriptBox["a", "x"], "(", 
          RowBox[{
           SubscriptBox["x", "n"], ",", 
           SubscriptBox["y", "n"]}], ")"}], 
         RowBox[{"\[Delta]t", "/", "2"}]}]}], "]"}], "\[Delta]t"}]}]}], " ", 
   ";"}], TraditionalForm], "\[IndentingNewLine]", 
 FormBox[
  RowBox[{
   RowBox[{
    SubscriptBox["y", 
     RowBox[{"n", "+", "1"}]], "=", 
    RowBox[{
     SubscriptBox["y", "n"], "+", 
     RowBox[{
      RowBox[{"[", 
       RowBox[{
        SubscriptBox[
         RowBox[{"(", 
          SubscriptBox["v", "y"], ")"}], "n"], "+", 
        RowBox[{
         RowBox[{
          SubscriptBox["a", "y"], "(", 
          RowBox[{
           SubscriptBox["x", "n"], ",", 
           SubscriptBox["y", "n"]}], ")"}], 
         RowBox[{"\[Delta]t", "/", "2"}]}]}], "]"}], "\[Delta]t"}]}]}], " ", 
   ";"}], TraditionalForm], "\[IndentingNewLine]", 
 FormBox[
  RowBox[{
   RowBox[{
    SubscriptBox[
     RowBox[{"(", 
      SubscriptBox["v", "x"], ")"}], 
     RowBox[{"n", "+", "1"}]], "=", 
    RowBox[{
     SubscriptBox[
      RowBox[{"(", 
       SubscriptBox["v", "x"], ")"}], "n"], "+", 
     RowBox[{
      RowBox[{
       SubscriptBox["a", "x"], "(", 
       RowBox[{
        RowBox[{
         SubscriptBox["x", "n"], "+", 
         RowBox[{
          SubscriptBox[
           RowBox[{"(", 
            SubscriptBox["v", "x"], ")"}], "n"], 
          RowBox[{"\[Delta]t", "/", "2"}]}]}], ",", 
        RowBox[{
         SubscriptBox["y", "n"], "+", 
         RowBox[{
          SubscriptBox[
           RowBox[{"(", 
            SubscriptBox["v", "y"], ")"}], "n"], "\[Delta]t"}]}]}], ")"}], 
      "\[Delta]t"}]}]}], " ", ";"}], 
  TraditionalForm], "\[IndentingNewLine]", 
 FormBox[
  RowBox[{
   RowBox[{
    SubscriptBox[
     RowBox[{"(", 
      SubscriptBox["v", "y"], ")"}], 
     RowBox[{"n", "+", "1"}]], "=", 
    RowBox[{
     SubscriptBox[
      RowBox[{"(", 
       SubscriptBox["v", "y"], ")"}], "n"], "+", 
     RowBox[{
      RowBox[{
       SubscriptBox["a", "y"], "(", 
       RowBox[{
        RowBox[{
         SubscriptBox["x", "n"], "+", 
         RowBox[{
          SubscriptBox[
           RowBox[{"(", 
            SubscriptBox["v", "x"], ")"}], "n"], 
          RowBox[{"\[Delta]t", "/", "2"}]}]}], ",", 
        RowBox[{
         SubscriptBox["y", "n"], "+", 
         RowBox[{
          SubscriptBox[
           RowBox[{"(", 
            SubscriptBox["v", "y"], ")"}], "n"], "\[Delta]t"}]}]}], ")"}], 
      "\[Delta]t"}]}]}], " ", ";"}], TraditionalForm]}], "ItemParagraph",
 CellChangeTimes->{{3.6837338310866537`*^9, 3.683733913045884*^9}, {
  3.683734524454666*^9, 3.683734582377928*^9}},
 FontSize->18],

Cell[CellGroupData[{

Cell[TextData[{
 "1. Error in each step ~ ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Delta]t", "3"], TraditionalForm]],
  FormatType->"TraditionalForm"],
 ". II. Does not conserve energy."
}], "Subsubsection",
 CellChangeTimes->{{3.683734617675908*^9, 3.683734692850576*^9}, {
  3.683736268427497*^9, 3.683736276047546*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AbsoluteTiming", "[", "\[IndentingNewLine]", 
  RowBox[{"With", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"\[Delta]t", "=", "0.01"}], ",", 
      RowBox[{"nmax", "=", "1000"}]}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "[", "0", "]"}], "=", "1"}], ";", 
     RowBox[{
      RowBox[{"y", "[", "0", "]"}], "=", "0"}], ";", 
     RowBox[{
      RowBox[{"vx", "[", "0", "]"}], "=", "0"}], ";", 
     RowBox[{
      RowBox[{"vy", "[", "0", "]"}], "=", "0.5"}], ";", "\[IndentingNewLine]", 
     RowBox[{"Do", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"x", "[", 
          RowBox[{"n", "+", "1"}], "]"}], "=", 
         RowBox[{
          RowBox[{"x", "[", "n", "]"}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"vx", "[", "n", "]"}], "+", 
             RowBox[{
              RowBox[{"ax", "[", 
               RowBox[{
                RowBox[{"x", "[", "n", "]"}], ",", 
                RowBox[{"y", "[", "n", "]"}]}], "]"}], "*", 
              RowBox[{"\[Delta]t", "/", "2"}]}]}], ")"}], "*", 
           "\[Delta]t"}]}]}], ";", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"y", "[", 
          RowBox[{"n", "+", "1"}], "]"}], "=", 
         RowBox[{
          RowBox[{"y", "[", "n", "]"}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"vy", "[", "n", "]"}], "+", 
             RowBox[{
              RowBox[{"ay", "[", 
               RowBox[{
                RowBox[{"x", "[", "n", "]"}], ",", 
                RowBox[{"y", "[", "n", "]"}]}], "]"}], "*", 
              RowBox[{"\[Delta]t", "/", "2"}]}]}], ")"}], "*", 
           "\[Delta]t"}]}]}], ";", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"vx", "[", 
          RowBox[{"n", "+", "1"}], "]"}], "=", 
         RowBox[{
          RowBox[{"vx", "[", "n", "]"}], "+", 
          RowBox[{
           RowBox[{"ax", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"x", "[", "n", "]"}], "+", 
              RowBox[{
               RowBox[{"vx", "[", "n", "]"}], "*", 
               RowBox[{"\[Delta]t", "/", "2"}]}]}], ",", 
             RowBox[{
              RowBox[{"y", "[", "n", "]"}], "+", 
              RowBox[{
               RowBox[{"vy", "[", "n", "]"}], "*", 
               RowBox[{"\[Delta]t", "/", "2"}]}]}]}], "]"}], "*", 
           "\[Delta]t"}]}]}], ";", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"vy", "[", 
          RowBox[{"n", "+", "1"}], "]"}], "=", 
         RowBox[{
          RowBox[{"vy", "[", "n", "]"}], "+", 
          RowBox[{
           RowBox[{"ay", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"x", "[", "n", "]"}], "+", 
              RowBox[{
               RowBox[{"vx", "[", "n", "]"}], "*", 
               RowBox[{"\[Delta]t", "/", "2"}]}]}], ",", 
             RowBox[{
              RowBox[{"y", "[", "n", "]"}], "+", 
              RowBox[{
               RowBox[{"vy", "[", "n", "]"}], "*", 
               RowBox[{"\[Delta]t", "/", "2"}]}]}]}], "]"}], "*", 
           "\[Delta]t"}]}]}], ";"}], ",", "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{"n", ",", "0", ",", "nmax"}], "}"}]}], "]"}]}]}], "]"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.6832616421061897`*^9, 3.683261653127754*^9}, {
   3.6832616894584627`*^9, 3.683261693990344*^9}, {3.6832623584074383`*^9, 
   3.683262413111423*^9}, 3.683262446746519*^9, {3.683262699509922*^9, 
   3.683262701461788*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.041584`", ",", "Null"}], "}"}]], "Output",
 CellChangeTimes->{{3.6832616684529467`*^9, 3.683261695110804*^9}, 
   3.683262567499547*^9, 3.68326270194699*^9, 3.683734352950096*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"With", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"\[Delta]t", "=", "0.01"}], ",", 
     RowBox[{"nmax", "=", "1000"}]}], "}"}], ",", 
   RowBox[{
    RowBox[{"xmidpoint", "[", "\[Delta]t", "]"}], "=", 
    RowBox[{"Interpolation", "[", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"n", "*", "\[Delta]t"}], ",", 
         RowBox[{"x", "[", "n", "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"n", ",", "0", ",", "nmax"}], "}"}]}], "]"}], "]"}]}]}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.683261683469326*^9, 3.683261751804677*^9}, {
  3.683262584384863*^9, 3.683262585107813*^9}, {3.6832627039966*^9, 
  3.683262705567337*^9}}],

Cell[BoxData[
 TagBox[
  TemplateBox[{RowBox[{
      StyleBox[
       TagBox["InterpolatingFunction", "SummaryHead"], 
       "NonInterpretableSummary"], 
      StyleBox["[", "NonInterpretableSummary"], 
      DynamicModuleBox[{Typeset`open$$ = False}, 
       PanelBox[
        PaneSelectorBox[{False -> GridBox[{{
              PaneBox[
               ButtonBox[
                DynamicBox[
                 FEPrivate`FrontEndResource[
                 "FEBitmaps", "SquarePlusIconMedium"]], 
                ButtonFunction :> (Typeset`open$$ = True), Appearance -> None,
                 Evaluator -> Automatic, Method -> "Preemptive"], 
               Alignment -> {Center, Center}, ImageSize -> 
               Dynamic[{
                 Automatic, 3.5 CurrentValue["FontCapHeight"]/
                  AbsoluteCurrentValue[Magnification]}]], 
              GraphicsBox[{{{{}, {}, {
                   Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]], 
                   LineBox[CompressedData["
1:eJwB0QMu/CFib1JlAgAAADwAAAACAAAAStFeOa+/hj5r/P/////vPzd0wYnD
3cQ/kbVXHdqS7z/SUFjDa77VP2V/cGZlIe4/IqE47Akn4D/CZ8t3Ec/rP9Wb
k3tZVOU/KB3fV6aG6D+7wbiC/fHqP18E4x98p+M/gEqXStgX8D8GPXJzRSbb
P7tJtw/c7vI/ZTprEgbCwj/ziT6Xnbj1P8r26f7WiMK/2iBupGZS+D9GO4Cm
PVa9P1rNgu1ZJPs/gzXVJT0o2T+J0D+8VMb9P1b1SBJh2eI/WwqypoYtAED/
b9KB7pLnPz63Ng34kwFAcbSYilps6z94j482beICQGkLZih2/O0/f/LaffdM
BECUqaAN3MDvPwX2WabgsAVAMoa9wCxD8D/iJK2RzfwGQEd4rE+fM/A/jN7y
ms9kCECE8ThAfVfvP43DDGfVtAlAb8rWpkdv7T9bMxlR8CALQERTArM3Ruo/
p0NZHGqGDEB6b96TNuXlP0t/barn0w1AWOAQUiBo4D+8RXRWej0PQOze2UEo
xdA/wpunYohHEEBCKNSVjTWrv+XkrgoD7RBA3dNAxjNPmb9vc69BiKARQH6o
gGVrvtE/pRcaWg9IEkDPCAemirHfP0EBfgGh/RJAuhdEZwOs5T8cu3sZ4q8T
QDbizzIvBuo/oorjEiVWFEChShH/ig/tP4+fRJtyChVA32ctu8pc7z8oyg8F
wrIVQH4KesWlUvA/AMV038BXFkAYqwU8lo/wPz4F00jKChdAVBjQJgFi8D8o
W5uT1bEXQIC+0ecnl+8/ePZcbetmGECrcvLlvFXtP3SniCgDEBlA2YaC6E00
6j+vKE5UyrUZQC/6gutmA+Y/Ue8MD5xpGkAbaGEcAMrfP5/LNatvERtAxLCk
8XBL0D9T7VfWTccbQMbltIG/e7i/R98Tctt5HEB/5Xq6Z7+hP+bmOe9qIB1A
tc8xQgoW0z/rM1n7BNUdQAN6FMAXsOA/nJbi6KB9HkBxlQ6aTOflP4zJBUfs
Ih9APb+bVHzt6T/iQSI0QtYfQKci6U/mQO0/8mdUAc0+IED9BERrN3vvP6ZR
FDB+mSBAQqB7hdGA8D96IyEXh/IgQJ2rkGUc0fA/JADj7pBFIUAVNnoGv7jw
P4F/IQ6gnyFAQVLO6qgu8D+0CRUesPMhQJ/tRU4WfO4/mjaFdcVOIkB++l6I
AWTrP59LQoUyqCJApbNgcxUa5z96a7SFoPsiQEXHAIfys+E/CC6jzRNWI0BX
eP3ye3rTP2z7RgaIqiNAoN8CBS27k78yFFD6//8jQM1jv6DwBKm/OArHgg==

                    "]]}}}, {}, {}}, {
               DisplayFunction -> Identity, Ticks -> {Automatic, Automatic}, 
                AxesOrigin -> {0, 0}, 
                FrameTicks -> {{None, None}, {None, None}}, 
                GridLines -> {None, None}, DisplayFunction -> Identity, 
                PlotRangePadding -> {{
                   Scaled[0.1], 
                   Scaled[0.1]}, {
                   Scaled[0.1], 
                   Scaled[0.1]}}, PlotRangeClipping -> True, ImagePadding -> 
                All, DisplayFunction -> Identity, AspectRatio -> 1, 
                Axes -> {False, False}, AxesLabel -> {None, None}, 
                AxesOrigin -> {0, 0}, DisplayFunction :> Identity, 
                Frame -> {{True, True}, {True, True}}, 
                FrameLabel -> {{None, None}, {None, None}}, FrameStyle -> 
                Directive[
                  Opacity[0.5], 
                  Thickness[Tiny], 
                  RGBColor[0.368417, 0.506779, 0.709798]], 
                FrameTicks -> {{None, None}, {None, None}}, 
                GridLines -> {None, None}, GridLinesStyle -> Directive[
                  GrayLevel[0.5, 0.4]], ImageSize -> 
                Dynamic[{
                  Automatic, 3.5 CurrentValue["FontCapHeight"]/
                   AbsoluteCurrentValue[Magnification]}], 
                Method -> {
                 "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
                  AbsolutePointSize[6], "ScalingFunctions" -> None, 
                  "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
                    (
                    Part[{{Identity, Identity}, {Identity, Identity}}, 1, 
                    2][#]& )[
                    Part[#, 1]], 
                    (
                    Part[{{Identity, Identity}, {Identity, Identity}}, 2, 
                    2][#]& )[
                    Part[#, 2]]}& ), "CopiedValueFunction" -> ({
                    (
                    Part[{{Identity, Identity}, {Identity, Identity}}, 1, 
                    2][#]& )[
                    Part[#, 1]], 
                    (
                    Part[{{Identity, Identity}, {Identity, Identity}}, 2, 
                    2][#]& )[
                    Part[#, 2]]}& )}}, 
                PlotRange -> {{0., 10.}, {-0.14480102011650892`, 
                 1.0510524718654104`}}, PlotRangeClipping -> True, 
                PlotRangePadding -> {{
                   Scaled[0.1], 
                   Scaled[0.1]}, {
                   Scaled[0.1], 
                   Scaled[0.1]}}, Ticks -> {Automatic, Automatic}}], 
              GridBox[{{
                 RowBox[{
                   TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                   "\[InvisibleSpace]", 
                   TagBox[
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{"0.`", ",", "10.`"}], "}"}], "}"}], 
                    "SummaryItem"]}]}, {
                 RowBox[{
                   TagBox["\"Output: \"", "SummaryItemAnnotation"], 
                   "\[InvisibleSpace]", 
                   TagBox["\"scalar\"", "SummaryItem"]}]}}, 
               GridBoxAlignment -> {
                "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, AutoDelete -> 
               False, GridBoxItemSize -> {
                "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
               GridBoxSpacings -> {
                "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
               BaseStyle -> {
                ShowStringCharacters -> False, NumberMarks -> False, 
                 PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
            GridBoxAlignment -> {"Rows" -> {{Top}}}, AutoDelete -> False, 
            GridBoxItemSize -> {
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
            BaselinePosition -> {1, 1}], True -> GridBox[{{
              PaneBox[
               ButtonBox[
                DynamicBox[
                 FEPrivate`FrontEndResource[
                 "FEBitmaps", "SquareMinusIconMedium"]], 
                ButtonFunction :> (Typeset`open$$ = False), Appearance -> 
                None, Evaluator -> Automatic, Method -> "Preemptive"], 
               Alignment -> {Center, Center}, ImageSize -> 
               Dynamic[{
                 Automatic, 3.5 CurrentValue["FontCapHeight"]/
                  AbsoluteCurrentValue[Magnification]}]], 
              GraphicsBox[{{{{}, {}, {
                   Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]], 
                   LineBox[CompressedData["
1:eJwB0QMu/CFib1JlAgAAADwAAAACAAAAStFeOa+/hj5r/P/////vPzd0wYnD
3cQ/kbVXHdqS7z/SUFjDa77VP2V/cGZlIe4/IqE47Akn4D/CZ8t3Ec/rP9Wb
k3tZVOU/KB3fV6aG6D+7wbiC/fHqP18E4x98p+M/gEqXStgX8D8GPXJzRSbb
P7tJtw/c7vI/ZTprEgbCwj/ziT6Xnbj1P8r26f7WiMK/2iBupGZS+D9GO4Cm
PVa9P1rNgu1ZJPs/gzXVJT0o2T+J0D+8VMb9P1b1SBJh2eI/WwqypoYtAED/
b9KB7pLnPz63Ng34kwFAcbSYilps6z94j482beICQGkLZih2/O0/f/LaffdM
BECUqaAN3MDvPwX2WabgsAVAMoa9wCxD8D/iJK2RzfwGQEd4rE+fM/A/jN7y
ms9kCECE8ThAfVfvP43DDGfVtAlAb8rWpkdv7T9bMxlR8CALQERTArM3Ruo/
p0NZHGqGDEB6b96TNuXlP0t/barn0w1AWOAQUiBo4D+8RXRWej0PQOze2UEo
xdA/wpunYohHEEBCKNSVjTWrv+XkrgoD7RBA3dNAxjNPmb9vc69BiKARQH6o
gGVrvtE/pRcaWg9IEkDPCAemirHfP0EBfgGh/RJAuhdEZwOs5T8cu3sZ4q8T
QDbizzIvBuo/oorjEiVWFEChShH/ig/tP4+fRJtyChVA32ctu8pc7z8oyg8F
wrIVQH4KesWlUvA/AMV038BXFkAYqwU8lo/wPz4F00jKChdAVBjQJgFi8D8o
W5uT1bEXQIC+0ecnl+8/ePZcbetmGECrcvLlvFXtP3SniCgDEBlA2YaC6E00
6j+vKE5UyrUZQC/6gutmA+Y/Ue8MD5xpGkAbaGEcAMrfP5/LNatvERtAxLCk
8XBL0D9T7VfWTccbQMbltIG/e7i/R98Tctt5HEB/5Xq6Z7+hP+bmOe9qIB1A
tc8xQgoW0z/rM1n7BNUdQAN6FMAXsOA/nJbi6KB9HkBxlQ6aTOflP4zJBUfs
Ih9APb+bVHzt6T/iQSI0QtYfQKci6U/mQO0/8mdUAc0+IED9BERrN3vvP6ZR
FDB+mSBAQqB7hdGA8D96IyEXh/IgQJ2rkGUc0fA/JADj7pBFIUAVNnoGv7jw
P4F/IQ6gnyFAQVLO6qgu8D+0CRUesPMhQJ/tRU4WfO4/mjaFdcVOIkB++l6I
AWTrP59LQoUyqCJApbNgcxUa5z96a7SFoPsiQEXHAIfys+E/CC6jzRNWI0BX
eP3ye3rTP2z7RgaIqiNAoN8CBS27k78yFFD6//8jQM1jv6DwBKm/OArHgg==

                    "]]}}}, {}, {}}, {
               DisplayFunction -> Identity, Ticks -> {Automatic, Automatic}, 
                AxesOrigin -> {0, 0}, 
                FrameTicks -> {{None, None}, {None, None}}, 
                GridLines -> {None, None}, DisplayFunction -> Identity, 
                PlotRangePadding -> {{
                   Scaled[0.1], 
                   Scaled[0.1]}, {
                   Scaled[0.1], 
                   Scaled[0.1]}}, PlotRangeClipping -> True, ImagePadding -> 
                All, DisplayFunction -> Identity, AspectRatio -> 1, 
                Axes -> {False, False}, AxesLabel -> {None, None}, 
                AxesOrigin -> {0, 0}, DisplayFunction :> Identity, 
                Frame -> {{True, True}, {True, True}}, 
                FrameLabel -> {{None, None}, {None, None}}, FrameStyle -> 
                Directive[
                  Opacity[0.5], 
                  Thickness[Tiny], 
                  RGBColor[0.368417, 0.506779, 0.709798]], 
                FrameTicks -> {{None, None}, {None, None}}, 
                GridLines -> {None, None}, GridLinesStyle -> Directive[
                  GrayLevel[0.5, 0.4]], ImageSize -> 
                Dynamic[{
                  Automatic, 3.5 CurrentValue["FontCapHeight"]/
                   AbsoluteCurrentValue[Magnification]}], 
                Method -> {
                 "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
                  AbsolutePointSize[6], "ScalingFunctions" -> None, 
                  "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
                    (
                    Part[{{Identity, Identity}, {Identity, Identity}}, 1, 
                    2][#]& )[
                    Part[#, 1]], 
                    (
                    Part[{{Identity, Identity}, {Identity, Identity}}, 2, 
                    2][#]& )[
                    Part[#, 2]]}& ), "CopiedValueFunction" -> ({
                    (
                    Part[{{Identity, Identity}, {Identity, Identity}}, 1, 
                    2][#]& )[
                    Part[#, 1]], 
                    (
                    Part[{{Identity, Identity}, {Identity, Identity}}, 2, 
                    2][#]& )[
                    Part[#, 2]]}& )}}, 
                PlotRange -> {{0., 10.}, {-0.14480102011650892`, 
                 1.0510524718654104`}}, PlotRangeClipping -> True, 
                PlotRangePadding -> {{
                   Scaled[0.1], 
                   Scaled[0.1]}, {
                   Scaled[0.1], 
                   Scaled[0.1]}}, Ticks -> {Automatic, Automatic}}], 
              GridBox[{{
                 RowBox[{
                   TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                   "\[InvisibleSpace]", 
                   TagBox[
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{"0.`", ",", "10.`"}], "}"}], "}"}], 
                    "SummaryItem"]}]}, {
                 RowBox[{
                   TagBox["\"Output: \"", "SummaryItemAnnotation"], 
                   "\[InvisibleSpace]", 
                   TagBox["\"scalar\"", "SummaryItem"]}]}, {
                 RowBox[{
                   TagBox["\"Order: \"", "SummaryItemAnnotation"], 
                   "\[InvisibleSpace]", 
                   TagBox["3", "SummaryItem"]}]}, {
                 RowBox[{
                   TagBox["\"Method: \"", "SummaryItemAnnotation"], 
                   "\[InvisibleSpace]", 
                   TagBox["\"Hermite\"", "SummaryItem"]}]}, {
                 RowBox[{
                   TagBox["\"Periodic: \"", "SummaryItemAnnotation"], 
                   "\[InvisibleSpace]", 
                   TagBox["False", "SummaryItem"]}]}}, 
               GridBoxAlignment -> {
                "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, AutoDelete -> 
               False, GridBoxItemSize -> {
                "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
               GridBoxSpacings -> {
                "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
               BaseStyle -> {
                ShowStringCharacters -> False, NumberMarks -> False, 
                 PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
            GridBoxAlignment -> {"Rows" -> {{Top}}}, AutoDelete -> False, 
            GridBoxItemSize -> {
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
            BaselinePosition -> {1, 1}]}, 
         Dynamic[Typeset`open$$], ImageSize -> Automatic], BaselinePosition -> 
        Baseline], DynamicModuleValues :> {}], 
      StyleBox["]", "NonInterpretableSummary"]}]},
   "CopyTag",
   DisplayFunction->(#& ),
   InterpretationFunction->("InterpolatingFunction[{{0., 10.}}, <>]"& )],
  False,
  Editable->False,
  SelectWithContents->True,
  Selectable->False]], "Output",
 CellChangeTimes->{3.683261758976274*^9, 3.68326180355539*^9, 
  3.683262591558687*^9, 3.683262705941557*^9, 3.683734353840241*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"With", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"\[Delta]t", "=", "0.01"}], ",", 
     RowBox[{"nmax", "=", "1000"}]}], "}"}], ",", 
   RowBox[{
    RowBox[{"ymidpoint", "[", "\[Delta]t", "]"}], "=", 
    RowBox[{"Interpolation", "[", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"n", "*", "\[Delta]t"}], ",", 
         RowBox[{"y", "[", "n", "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"n", ",", "0", ",", "nmax"}], "}"}]}], "]"}], "]"}]}]}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.683261816267932*^9, 3.6832618184219007`*^9}, {
  3.6832625937369556`*^9, 3.683262594270892*^9}, {3.683262707359543*^9, 
  3.68326270858939*^9}}],

Cell[BoxData[
 TagBox[
  TemplateBox[{RowBox[{
      StyleBox[
       TagBox["InterpolatingFunction", "SummaryHead"], 
       "NonInterpretableSummary"], 
      StyleBox["[", "NonInterpretableSummary"], 
      DynamicModuleBox[{Typeset`open$$ = False}, 
       PanelBox[
        PaneSelectorBox[{False -> GridBox[{{
              PaneBox[
               ButtonBox[
                DynamicBox[
                 FEPrivate`FrontEndResource[
                 "FEBitmaps", "SquarePlusIconMedium"]], 
                ButtonFunction :> (Typeset`open$$ = True), Appearance -> None,
                 Evaluator -> Automatic, Method -> "Preemptive"], 
               Alignment -> {Center, Center}, ImageSize -> 
               Dynamic[{
                 Automatic, 3.5 CurrentValue["FontCapHeight"]/
                  AbsoluteCurrentValue[Magnification]}]], 
              GraphicsBox[{{{{}, {}, {
                   Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]], 
                   LineBox[CompressedData["
1:eJwB0QMu/CFib1JlAgAAADwAAAACAAAAStFeOa+/hj4AANsLyL92Pjd0wYnD
3cQ/KtUHkQPGtD/SUFjDa77VP6fiMZe7T8U/IqE47Akn4D/4mRRXutLOP9Wb
k3tZVOU/tYhV/XaC0z+7wbiC/fHqP908mkc04dY/gEqXStgX8D+UbFP8NDHY
P7tJtw/c7vI/NLMtbUoM1T/ziT6Xnbj1P4B+Ls8YkCy/2iBupGZS+D/Uqf7R
Nf3Uv1rNgu1ZJPs/zEo5ej952b+J0D+8VMb9P01h4O8RAdm/WwqypoYtAEBz
uv+jppbWvz63Ng34kwFA88zucuy60r94j482beICQK8iUZ3/0sy/f/LaffdM
BEAJX9/D6H3CvwX2WabgsAVAZ0wtLUofr7/iJK2RzfwGQGWCVbslVpM/jN7y
ms9kCEAzF/6aa8u6P43DDGfVtAlA7UTmYm5Bxz9bMxlR8CALQEYy99v8hdA/
p0NZHGqGDEDt/4Xa8oLUP0t/barn0w1AFQ2Ygobj1j+8RXRWej0PQNTZHz5U
WNY/wpunYohHEEC4XdcuN0rJP+XkrgoD7RBAcAfpfzWiz79vc69BiKARQPPA
DeBejdm/pRcaWg9IEkDqNr/s/i/bv0EBfgGh/RJAKmSrJYne2b8cu3sZ4q8T
QC947b5h5ta/oorjEiVWFECIJMlkLzbTv4+fRJtyChVAaehYgZcczb8oyg8F
wrIVQEmKCJdwmsO/AMV038BXFkCC1/t0R56zvz4F00jKChdATUscVagagT8o
W5uT1bEXQCb9PRBoY7Y/ePZcbetmGECzwZdbLs7FP3SniCgDEBlAqV3loFDy
zj+vKE5UyrUZQA11brVpR9M/Ue8MD5xpGkBCjDvq9PbVP5/LNatvERtAaAHp
ukp71T9T7VfWTccbQCE8mCf6EMI/R98Tctt5HEAhOOoDKYfTv+bmOe9qIB1A
d6ma2C0Z27/rM1n7BNUdQL1fSl3w3ty/nJbi6KB9HkDWXRc9c+Hbv4zJBUfs
Ih9AsfL7qeR+2b/iQSI0QtYfQN904uRb4dW/8mdUAc0+IEBQhgX/mNfRv6ZR
FDB+mSBAqU6bA7fsyb96IyEXh/IgQBwtJ1LMT7+/JADj7pBFIUBTPJRfm9mm
v4F/IQ6gnyFAUi/nB03XpD+0CRUesPMhQAut1sYOiL4/mjaFdcVOIkAraYMG
XZvJP59LQoUyqCJAQS0oNtRH0T96a7SFoPsiQEb+/SfsYtQ/CC6jzRNWI0B8
mIFopB/VP2z7RgaIqiNA8YyWPpOFyz8yFFD6//8jQNsXlmzz386/MIzUUw==

                    "]]}}}, {}, {}}, {
               DisplayFunction -> Identity, Ticks -> {Automatic, Automatic}, 
                AxesOrigin -> {0, 0}, 
                FrameTicks -> {{None, None}, {None, None}}, 
                GridLines -> {None, None}, DisplayFunction -> Identity, 
                PlotRangePadding -> {{
                   Scaled[0.1], 
                   Scaled[0.1]}, {
                   Scaled[0.1], 
                   Scaled[0.1]}}, PlotRangeClipping -> True, ImagePadding -> 
                All, DisplayFunction -> Identity, AspectRatio -> 1, 
                Axes -> {False, False}, AxesLabel -> {None, None}, 
                AxesOrigin -> {0, 0}, DisplayFunction :> Identity, 
                Frame -> {{True, True}, {True, True}}, 
                FrameLabel -> {{None, None}, {None, None}}, FrameStyle -> 
                Directive[
                  Opacity[0.5], 
                  Thickness[Tiny], 
                  RGBColor[0.368417, 0.506779, 0.709798]], 
                FrameTicks -> {{None, None}, {None, None}}, 
                GridLines -> {None, None}, GridLinesStyle -> Directive[
                  GrayLevel[0.5, 0.4]], ImageSize -> 
                Dynamic[{
                  Automatic, 3.5 CurrentValue["FontCapHeight"]/
                   AbsoluteCurrentValue[Magnification]}], 
                Method -> {
                 "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
                  AbsolutePointSize[6], "ScalingFunctions" -> None, 
                  "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
                    (
                    Part[{{Identity, Identity}, {Identity, Identity}}, 1, 
                    2][#]& )[
                    Part[#, 1]], 
                    (
                    Part[{{Identity, Identity}, {Identity, Identity}}, 2, 
                    2][#]& )[
                    Part[#, 2]]}& ), "CopiedValueFunction" -> ({
                    (
                    Part[{{Identity, Identity}, {Identity, Identity}}, 1, 
                    2][#]& )[
                    Part[#, 1]], 
                    (
                    Part[{{Identity, Identity}, {Identity, Identity}}, 2, 
                    2][#]& )[
                    Part[#, 2]]}& )}}, 
                PlotRange -> {{0., 10.}, {-0.45110711203005477`, 
                 0.3780033554191473}}, PlotRangeClipping -> True, 
                PlotRangePadding -> {{
                   Scaled[0.1], 
                   Scaled[0.1]}, {
                   Scaled[0.1], 
                   Scaled[0.1]}}, Ticks -> {Automatic, Automatic}}], 
              GridBox[{{
                 RowBox[{
                   TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                   "\[InvisibleSpace]", 
                   TagBox[
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{"0.`", ",", "10.`"}], "}"}], "}"}], 
                    "SummaryItem"]}]}, {
                 RowBox[{
                   TagBox["\"Output: \"", "SummaryItemAnnotation"], 
                   "\[InvisibleSpace]", 
                   TagBox["\"scalar\"", "SummaryItem"]}]}}, 
               GridBoxAlignment -> {
                "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, AutoDelete -> 
               False, GridBoxItemSize -> {
                "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
               GridBoxSpacings -> {
                "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
               BaseStyle -> {
                ShowStringCharacters -> False, NumberMarks -> False, 
                 PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
            GridBoxAlignment -> {"Rows" -> {{Top}}}, AutoDelete -> False, 
            GridBoxItemSize -> {
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
            BaselinePosition -> {1, 1}], True -> GridBox[{{
              PaneBox[
               ButtonBox[
                DynamicBox[
                 FEPrivate`FrontEndResource[
                 "FEBitmaps", "SquareMinusIconMedium"]], 
                ButtonFunction :> (Typeset`open$$ = False), Appearance -> 
                None, Evaluator -> Automatic, Method -> "Preemptive"], 
               Alignment -> {Center, Center}, ImageSize -> 
               Dynamic[{
                 Automatic, 3.5 CurrentValue["FontCapHeight"]/
                  AbsoluteCurrentValue[Magnification]}]], 
              GraphicsBox[{{{{}, {}, {
                   Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]], 
                   LineBox[CompressedData["
1:eJwB0QMu/CFib1JlAgAAADwAAAACAAAAStFeOa+/hj4AANsLyL92Pjd0wYnD
3cQ/KtUHkQPGtD/SUFjDa77VP6fiMZe7T8U/IqE47Akn4D/4mRRXutLOP9Wb
k3tZVOU/tYhV/XaC0z+7wbiC/fHqP908mkc04dY/gEqXStgX8D+UbFP8NDHY
P7tJtw/c7vI/NLMtbUoM1T/ziT6Xnbj1P4B+Ls8YkCy/2iBupGZS+D/Uqf7R
Nf3Uv1rNgu1ZJPs/zEo5ej952b+J0D+8VMb9P01h4O8RAdm/WwqypoYtAEBz
uv+jppbWvz63Ng34kwFA88zucuy60r94j482beICQK8iUZ3/0sy/f/LaffdM
BEAJX9/D6H3CvwX2WabgsAVAZ0wtLUofr7/iJK2RzfwGQGWCVbslVpM/jN7y
ms9kCEAzF/6aa8u6P43DDGfVtAlA7UTmYm5Bxz9bMxlR8CALQEYy99v8hdA/
p0NZHGqGDEDt/4Xa8oLUP0t/barn0w1AFQ2Ygobj1j+8RXRWej0PQNTZHz5U
WNY/wpunYohHEEC4XdcuN0rJP+XkrgoD7RBAcAfpfzWiz79vc69BiKARQPPA
DeBejdm/pRcaWg9IEkDqNr/s/i/bv0EBfgGh/RJAKmSrJYne2b8cu3sZ4q8T
QC947b5h5ta/oorjEiVWFECIJMlkLzbTv4+fRJtyChVAaehYgZcczb8oyg8F
wrIVQEmKCJdwmsO/AMV038BXFkCC1/t0R56zvz4F00jKChdATUscVagagT8o
W5uT1bEXQCb9PRBoY7Y/ePZcbetmGECzwZdbLs7FP3SniCgDEBlAqV3loFDy
zj+vKE5UyrUZQA11brVpR9M/Ue8MD5xpGkBCjDvq9PbVP5/LNatvERtAaAHp
ukp71T9T7VfWTccbQCE8mCf6EMI/R98Tctt5HEAhOOoDKYfTv+bmOe9qIB1A
d6ma2C0Z27/rM1n7BNUdQL1fSl3w3ty/nJbi6KB9HkDWXRc9c+Hbv4zJBUfs
Ih9AsfL7qeR+2b/iQSI0QtYfQN904uRb4dW/8mdUAc0+IEBQhgX/mNfRv6ZR
FDB+mSBAqU6bA7fsyb96IyEXh/IgQBwtJ1LMT7+/JADj7pBFIUBTPJRfm9mm
v4F/IQ6gnyFAUi/nB03XpD+0CRUesPMhQAut1sYOiL4/mjaFdcVOIkAraYMG
XZvJP59LQoUyqCJAQS0oNtRH0T96a7SFoPsiQEb+/SfsYtQ/CC6jzRNWI0B8
mIFopB/VP2z7RgaIqiNA8YyWPpOFyz8yFFD6//8jQNsXlmzz386/MIzUUw==

                    "]]}}}, {}, {}}, {
               DisplayFunction -> Identity, Ticks -> {Automatic, Automatic}, 
                AxesOrigin -> {0, 0}, 
                FrameTicks -> {{None, None}, {None, None}}, 
                GridLines -> {None, None}, DisplayFunction -> Identity, 
                PlotRangePadding -> {{
                   Scaled[0.1], 
                   Scaled[0.1]}, {
                   Scaled[0.1], 
                   Scaled[0.1]}}, PlotRangeClipping -> True, ImagePadding -> 
                All, DisplayFunction -> Identity, AspectRatio -> 1, 
                Axes -> {False, False}, AxesLabel -> {None, None}, 
                AxesOrigin -> {0, 0}, DisplayFunction :> Identity, 
                Frame -> {{True, True}, {True, True}}, 
                FrameLabel -> {{None, None}, {None, None}}, FrameStyle -> 
                Directive[
                  Opacity[0.5], 
                  Thickness[Tiny], 
                  RGBColor[0.368417, 0.506779, 0.709798]], 
                FrameTicks -> {{None, None}, {None, None}}, 
                GridLines -> {None, None}, GridLinesStyle -> Directive[
                  GrayLevel[0.5, 0.4]], ImageSize -> 
                Dynamic[{
                  Automatic, 3.5 CurrentValue["FontCapHeight"]/
                   AbsoluteCurrentValue[Magnification]}], 
                Method -> {
                 "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
                  AbsolutePointSize[6], "ScalingFunctions" -> None, 
                  "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
                    (
                    Part[{{Identity, Identity}, {Identity, Identity}}, 1, 
                    2][#]& )[
                    Part[#, 1]], 
                    (
                    Part[{{Identity, Identity}, {Identity, Identity}}, 2, 
                    2][#]& )[
                    Part[#, 2]]}& ), "CopiedValueFunction" -> ({
                    (
                    Part[{{Identity, Identity}, {Identity, Identity}}, 1, 
                    2][#]& )[
                    Part[#, 1]], 
                    (
                    Part[{{Identity, Identity}, {Identity, Identity}}, 2, 
                    2][#]& )[
                    Part[#, 2]]}& )}}, 
                PlotRange -> {{0., 10.}, {-0.45110711203005477`, 
                 0.3780033554191473}}, PlotRangeClipping -> True, 
                PlotRangePadding -> {{
                   Scaled[0.1], 
                   Scaled[0.1]}, {
                   Scaled[0.1], 
                   Scaled[0.1]}}, Ticks -> {Automatic, Automatic}}], 
              GridBox[{{
                 RowBox[{
                   TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                   "\[InvisibleSpace]", 
                   TagBox[
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{"0.`", ",", "10.`"}], "}"}], "}"}], 
                    "SummaryItem"]}]}, {
                 RowBox[{
                   TagBox["\"Output: \"", "SummaryItemAnnotation"], 
                   "\[InvisibleSpace]", 
                   TagBox["\"scalar\"", "SummaryItem"]}]}, {
                 RowBox[{
                   TagBox["\"Order: \"", "SummaryItemAnnotation"], 
                   "\[InvisibleSpace]", 
                   TagBox["3", "SummaryItem"]}]}, {
                 RowBox[{
                   TagBox["\"Method: \"", "SummaryItemAnnotation"], 
                   "\[InvisibleSpace]", 
                   TagBox["\"Hermite\"", "SummaryItem"]}]}, {
                 RowBox[{
                   TagBox["\"Periodic: \"", "SummaryItemAnnotation"], 
                   "\[InvisibleSpace]", 
                   TagBox["False", "SummaryItem"]}]}}, 
               GridBoxAlignment -> {
                "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, AutoDelete -> 
               False, GridBoxItemSize -> {
                "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
               GridBoxSpacings -> {
                "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
               BaseStyle -> {
                ShowStringCharacters -> False, NumberMarks -> False, 
                 PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
            GridBoxAlignment -> {"Rows" -> {{Top}}}, AutoDelete -> False, 
            GridBoxItemSize -> {
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
            BaselinePosition -> {1, 1}]}, 
         Dynamic[Typeset`open$$], ImageSize -> Automatic], BaselinePosition -> 
        Baseline], DynamicModuleValues :> {}], 
      StyleBox["]", "NonInterpretableSummary"]}]},
   "CopyTag",
   DisplayFunction->(#& ),
   InterpretationFunction->("InterpolatingFunction[{{0., 10.}}, <>]"& )],
  False,
  Editable->False,
  SelectWithContents->True,
  Selectable->False]], "Output",
 CellChangeTimes->{3.6832618227585773`*^9, 3.6832625946392183`*^9, 
  3.683262710528328*^9, 3.68373435468104*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"With", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"\[Delta]t", "=", "0.01"}], ",", 
     RowBox[{"nmax", "=", "1000"}]}], "}"}], ",", 
   RowBox[{
    RowBox[{"vxmidpoint", "[", "\[Delta]t", "]"}], "=", 
    RowBox[{"Interpolation", "[", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"n", "*", "\[Delta]t"}], ",", 
         RowBox[{"vx", "[", "n", "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"n", ",", "0", ",", "nmax"}], "}"}]}], "]"}], "]"}]}]}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.683261826974167*^9, 3.683261828223486*^9}, {
  3.6832625963649187`*^9, 3.683262597601955*^9}, {3.683262712424528*^9, 
  3.683262714311624*^9}}],

Cell[BoxData[
 TagBox[
  TemplateBox[{RowBox[{
      StyleBox[
       TagBox["InterpolatingFunction", "SummaryHead"], 
       "NonInterpretableSummary"], 
      StyleBox["[", "NonInterpretableSummary"], 
      DynamicModuleBox[{Typeset`open$$ = False}, 
       PanelBox[
        PaneSelectorBox[{False -> GridBox[{{
              PaneBox[
               ButtonBox[
                DynamicBox[
                 FEPrivate`FrontEndResource[
                 "FEBitmaps", "SquarePlusIconMedium"]], 
                ButtonFunction :> (Typeset`open$$ = True), Appearance -> None,
                 Evaluator -> Automatic, Method -> "Preemptive"], 
               Alignment -> {Center, Center}, ImageSize -> 
               Dynamic[{
                 Automatic, 3.5 CurrentValue["FontCapHeight"]/
                  AbsoluteCurrentValue[Magnification]}]], 
              GraphicsBox[{{{{}, {}, {
                   Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]], 
                   LineBox[CompressedData["
1:eJwB0QMu/CFib1JlAgAAADwAAAACAAAAStFeOa+/hj4AAFk5gr+Gvjd0wYnD
3cQ/qxcQVG/7xL/SUFjDa77VP5FNltlySda/IqE47Akn4D8t3vCA3xbhv9Wb
k3tZVOU/F4zIILim57+7wbiC/fHqPzoq4nqbGPC/gEqXStgX8D9BvtgCPEn1
v7tJtw/c7vI/pgFrftA4/b/ziT6Xnbj1PzD3yBL+Sp2/2iBupGZS+D8Dp0WJ
mSb9P1rNgu1ZJPs/oN/TNiq49T+J0D+8VMb9P9JJG/KPpPA/WwqypoYtAEAw
4PcDbpHpPz63Ng34kwFASpGUMXCa4j94j482beICQL6jYSZjwdk/f/LaffdM
BEBKLcwy5ZbMPwX2WabgsAVAd3JZ/7MCrD/iJK2RzfwGQGIcqwNGFbq/jN7y
ms9kCEACPtrol7rRv43DDGfVtAlAwmmHmZXs3L9bMxlR8CALQC20/VH5QOW/
p0NZHGqGDEBeGcl6uzLtv0t/barn0w1AFdl56VlU87+8RXRWej0PQBVh3QTH
m/q/wpunYohHEEDqzOlSnu//v+XkrgoD7RBAm1LJulO7/T9vc69BiKARQB1n
+kNpLfg/pRcaWg9IEkB79HBxabzyP0EBfgGh/RJAabQykf+c7D8cu3sZ4q8T
QNy/led/mOU/oorjEiVWFEAXDpAIC9TfP4+fRJtyChVANDsABo2a1D8oyg8F
wrIVQFWE2wahXcU/AMV038BXFkDgKq1ChUWSPz4F00jKChdAKB0H2MOuwr8o
W5uT1bEXQKRE0/ezlNO/ePZcbetmGEAoM/6/fKjfv3SniCgDEBlApOhFHDVA
5r+vKE5UyrUZQLzv5zOUyu2/Ue8MD5xpGkBHOXPGTT70v5/LNatvERtAr1Dh
ukmJ+79T7VfWTccbQFkAmOTJn/y/R98Tctt5HEDgSA9xKp78P+bmOe9qIB1A
zrFaJw3/9j/rM1n7BNUdQG3xhumDx/E/nJbi6KB9HkBLR6wmnxDsP4zJBUfs
Ih9A6siYkVrz5T/iQSI0QtYfQLzCpEjqI+A/8mdUAc0+IECyg1+45lvWP6ZR
FDB+mSBAj1u2DzdIyD96IyEXh/IgQIHlWr5XUaI/JADj7pBFIUB89bH1Gh68
v4F/IQ6gnyFA58kLTsSe0b+0CRUesPMhQHNCEBDxWty/mjaFdcVOIkBCD2GZ
H8jkv59LQoUyqCJA7nP4YVWf7L96a7SFoPsiQFf5+PhtD/O/CC6jzRNWI0DF
lYQKHZr6v2z7RgaIqiNAhG7i4ZZ4AcAyFFD6//8jQJYUMuq7Ifs/P8/Ydg==

                    "]]}}}, {}, {}}, {
               DisplayFunction -> Identity, Ticks -> {Automatic, Automatic}, 
                AxesOrigin -> {0, 0}, 
                FrameTicks -> {{None, None}, {None, None}}, 
                GridLines -> {None, None}, DisplayFunction -> Identity, 
                PlotRangePadding -> {{
                   Scaled[0.1], 
                   Scaled[0.1]}, {
                   Scaled[0.1], 
                   Scaled[0.1]}}, PlotRangeClipping -> True, ImagePadding -> 
                All, DisplayFunction -> Identity, AspectRatio -> 1, 
                Axes -> {False, False}, AxesLabel -> {None, None}, 
                AxesOrigin -> {0, 0}, DisplayFunction :> Identity, 
                Frame -> {{True, True}, {True, True}}, 
                FrameLabel -> {{None, None}, {None, None}}, FrameStyle -> 
                Directive[
                  Opacity[0.5], 
                  Thickness[Tiny], 
                  RGBColor[0.368417, 0.506779, 0.709798]], 
                FrameTicks -> {{None, None}, {None, None}}, 
                GridLines -> {None, None}, GridLinesStyle -> Directive[
                  GrayLevel[0.5, 0.4]], ImageSize -> 
                Dynamic[{
                  Automatic, 3.5 CurrentValue["FontCapHeight"]/
                   AbsoluteCurrentValue[Magnification]}], 
                Method -> {
                 "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
                  AbsolutePointSize[6], "ScalingFunctions" -> None, 
                  "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
                    (
                    Part[{{Identity, Identity}, {Identity, Identity}}, 1, 
                    2][#]& )[
                    Part[#, 1]], 
                    (
                    Part[{{Identity, Identity}, {Identity, Identity}}, 2, 
                    2][#]& )[
                    Part[#, 2]]}& ), "CopiedValueFunction" -> ({
                    (
                    Part[{{Identity, Identity}, {Identity, Identity}}, 1, 
                    2][#]& )[
                    Part[#, 1]], 
                    (
                    Part[{{Identity, Identity}, {Identity, Identity}}, 2, 
                    2][#]& )[
                    Part[#, 2]]}& )}}, 
                PlotRange -> {{0., 10.}, {-2.183881535265586, 
                 1.8582341476768878`}}, PlotRangeClipping -> True, 
                PlotRangePadding -> {{
                   Scaled[0.1], 
                   Scaled[0.1]}, {
                   Scaled[0.1], 
                   Scaled[0.1]}}, Ticks -> {Automatic, Automatic}}], 
              GridBox[{{
                 RowBox[{
                   TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                   "\[InvisibleSpace]", 
                   TagBox[
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{"0.`", ",", "10.`"}], "}"}], "}"}], 
                    "SummaryItem"]}]}, {
                 RowBox[{
                   TagBox["\"Output: \"", "SummaryItemAnnotation"], 
                   "\[InvisibleSpace]", 
                   TagBox["\"scalar\"", "SummaryItem"]}]}}, 
               GridBoxAlignment -> {
                "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, AutoDelete -> 
               False, GridBoxItemSize -> {
                "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
               GridBoxSpacings -> {
                "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
               BaseStyle -> {
                ShowStringCharacters -> False, NumberMarks -> False, 
                 PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
            GridBoxAlignment -> {"Rows" -> {{Top}}}, AutoDelete -> False, 
            GridBoxItemSize -> {
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
            BaselinePosition -> {1, 1}], True -> GridBox[{{
              PaneBox[
               ButtonBox[
                DynamicBox[
                 FEPrivate`FrontEndResource[
                 "FEBitmaps", "SquareMinusIconMedium"]], 
                ButtonFunction :> (Typeset`open$$ = False), Appearance -> 
                None, Evaluator -> Automatic, Method -> "Preemptive"], 
               Alignment -> {Center, Center}, ImageSize -> 
               Dynamic[{
                 Automatic, 3.5 CurrentValue["FontCapHeight"]/
                  AbsoluteCurrentValue[Magnification]}]], 
              GraphicsBox[{{{{}, {}, {
                   Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]], 
                   LineBox[CompressedData["
1:eJwB0QMu/CFib1JlAgAAADwAAAACAAAAStFeOa+/hj4AAFk5gr+Gvjd0wYnD
3cQ/qxcQVG/7xL/SUFjDa77VP5FNltlySda/IqE47Akn4D8t3vCA3xbhv9Wb
k3tZVOU/F4zIILim57+7wbiC/fHqPzoq4nqbGPC/gEqXStgX8D9BvtgCPEn1
v7tJtw/c7vI/pgFrftA4/b/ziT6Xnbj1PzD3yBL+Sp2/2iBupGZS+D8Dp0WJ
mSb9P1rNgu1ZJPs/oN/TNiq49T+J0D+8VMb9P9JJG/KPpPA/WwqypoYtAEAw
4PcDbpHpPz63Ng34kwFASpGUMXCa4j94j482beICQL6jYSZjwdk/f/LaffdM
BEBKLcwy5ZbMPwX2WabgsAVAd3JZ/7MCrD/iJK2RzfwGQGIcqwNGFbq/jN7y
ms9kCEACPtrol7rRv43DDGfVtAlAwmmHmZXs3L9bMxlR8CALQC20/VH5QOW/
p0NZHGqGDEBeGcl6uzLtv0t/barn0w1AFdl56VlU87+8RXRWej0PQBVh3QTH
m/q/wpunYohHEEDqzOlSnu//v+XkrgoD7RBAm1LJulO7/T9vc69BiKARQB1n
+kNpLfg/pRcaWg9IEkB79HBxabzyP0EBfgGh/RJAabQykf+c7D8cu3sZ4q8T
QNy/led/mOU/oorjEiVWFEAXDpAIC9TfP4+fRJtyChVANDsABo2a1D8oyg8F
wrIVQFWE2wahXcU/AMV038BXFkDgKq1ChUWSPz4F00jKChdAKB0H2MOuwr8o
W5uT1bEXQKRE0/ezlNO/ePZcbetmGEAoM/6/fKjfv3SniCgDEBlApOhFHDVA
5r+vKE5UyrUZQLzv5zOUyu2/Ue8MD5xpGkBHOXPGTT70v5/LNatvERtAr1Dh
ukmJ+79T7VfWTccbQFkAmOTJn/y/R98Tctt5HEDgSA9xKp78P+bmOe9qIB1A
zrFaJw3/9j/rM1n7BNUdQG3xhumDx/E/nJbi6KB9HkBLR6wmnxDsP4zJBUfs
Ih9A6siYkVrz5T/iQSI0QtYfQLzCpEjqI+A/8mdUAc0+IECyg1+45lvWP6ZR
FDB+mSBAj1u2DzdIyD96IyEXh/IgQIHlWr5XUaI/JADj7pBFIUB89bH1Gh68
v4F/IQ6gnyFA58kLTsSe0b+0CRUesPMhQHNCEBDxWty/mjaFdcVOIkBCD2GZ
H8jkv59LQoUyqCJA7nP4YVWf7L96a7SFoPsiQFf5+PhtD/O/CC6jzRNWI0DF
lYQKHZr6v2z7RgaIqiNAhG7i4ZZ4AcAyFFD6//8jQJYUMuq7Ifs/P8/Ydg==

                    "]]}}}, {}, {}}, {
               DisplayFunction -> Identity, Ticks -> {Automatic, Automatic}, 
                AxesOrigin -> {0, 0}, 
                FrameTicks -> {{None, None}, {None, None}}, 
                GridLines -> {None, None}, DisplayFunction -> Identity, 
                PlotRangePadding -> {{
                   Scaled[0.1], 
                   Scaled[0.1]}, {
                   Scaled[0.1], 
                   Scaled[0.1]}}, PlotRangeClipping -> True, ImagePadding -> 
                All, DisplayFunction -> Identity, AspectRatio -> 1, 
                Axes -> {False, False}, AxesLabel -> {None, None}, 
                AxesOrigin -> {0, 0}, DisplayFunction :> Identity, 
                Frame -> {{True, True}, {True, True}}, 
                FrameLabel -> {{None, None}, {None, None}}, FrameStyle -> 
                Directive[
                  Opacity[0.5], 
                  Thickness[Tiny], 
                  RGBColor[0.368417, 0.506779, 0.709798]], 
                FrameTicks -> {{None, None}, {None, None}}, 
                GridLines -> {None, None}, GridLinesStyle -> Directive[
                  GrayLevel[0.5, 0.4]], ImageSize -> 
                Dynamic[{
                  Automatic, 3.5 CurrentValue["FontCapHeight"]/
                   AbsoluteCurrentValue[Magnification]}], 
                Method -> {
                 "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
                  AbsolutePointSize[6], "ScalingFunctions" -> None, 
                  "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
                    (
                    Part[{{Identity, Identity}, {Identity, Identity}}, 1, 
                    2][#]& )[
                    Part[#, 1]], 
                    (
                    Part[{{Identity, Identity}, {Identity, Identity}}, 2, 
                    2][#]& )[
                    Part[#, 2]]}& ), "CopiedValueFunction" -> ({
                    (
                    Part[{{Identity, Identity}, {Identity, Identity}}, 1, 
                    2][#]& )[
                    Part[#, 1]], 
                    (
                    Part[{{Identity, Identity}, {Identity, Identity}}, 2, 
                    2][#]& )[
                    Part[#, 2]]}& )}}, 
                PlotRange -> {{0., 10.}, {-2.183881535265586, 
                 1.8582341476768878`}}, PlotRangeClipping -> True, 
                PlotRangePadding -> {{
                   Scaled[0.1], 
                   Scaled[0.1]}, {
                   Scaled[0.1], 
                   Scaled[0.1]}}, Ticks -> {Automatic, Automatic}}], 
              GridBox[{{
                 RowBox[{
                   TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                   "\[InvisibleSpace]", 
                   TagBox[
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{"0.`", ",", "10.`"}], "}"}], "}"}], 
                    "SummaryItem"]}]}, {
                 RowBox[{
                   TagBox["\"Output: \"", "SummaryItemAnnotation"], 
                   "\[InvisibleSpace]", 
                   TagBox["\"scalar\"", "SummaryItem"]}]}, {
                 RowBox[{
                   TagBox["\"Order: \"", "SummaryItemAnnotation"], 
                   "\[InvisibleSpace]", 
                   TagBox["3", "SummaryItem"]}]}, {
                 RowBox[{
                   TagBox["\"Method: \"", "SummaryItemAnnotation"], 
                   "\[InvisibleSpace]", 
                   TagBox["\"Hermite\"", "SummaryItem"]}]}, {
                 RowBox[{
                   TagBox["\"Periodic: \"", "SummaryItemAnnotation"], 
                   "\[InvisibleSpace]", 
                   TagBox["False", "SummaryItem"]}]}}, 
               GridBoxAlignment -> {
                "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, AutoDelete -> 
               False, GridBoxItemSize -> {
                "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
               GridBoxSpacings -> {
                "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
               BaseStyle -> {
                ShowStringCharacters -> False, NumberMarks -> False, 
                 PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
            GridBoxAlignment -> {"Rows" -> {{Top}}}, AutoDelete -> False, 
            GridBoxItemSize -> {
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
            BaselinePosition -> {1, 1}]}, 
         Dynamic[Typeset`open$$], ImageSize -> Automatic], BaselinePosition -> 
        Baseline], DynamicModuleValues :> {}], 
      StyleBox["]", "NonInterpretableSummary"]}]},
   "CopyTag",
   DisplayFunction->(#& ),
   InterpretationFunction->("InterpolatingFunction[{{0., 10.}}, <>]"& )],
  False,
  Editable->False,
  SelectWithContents->True,
  Selectable->False]], "Output",
 CellChangeTimes->{3.6832618289771833`*^9, 3.6832618623666773`*^9, 
  3.6832625981012287`*^9, 3.683262714732706*^9, 3.6837343555475187`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"With", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"\[Delta]t", "=", "0.01"}], ",", 
     RowBox[{"nmax", "=", "1000"}]}], "}"}], ",", 
   RowBox[{
    RowBox[{"vymidpoint", "[", "\[Delta]t", "]"}], "=", 
    RowBox[{"Interpolation", "[", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"n", "*", "\[Delta]t"}], ",", 
         RowBox[{"vy", "[", "n", "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"n", ",", "0", ",", "nmax"}], "}"}]}], "]"}], "]"}]}]}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.683261866543598*^9, 3.6832618689251013`*^9}, {
  3.683262600919565*^9, 3.683262601837439*^9}, {3.683262716628409*^9, 
  3.6832627184211607`*^9}}],

Cell[BoxData[
 TagBox[
  TemplateBox[{RowBox[{
      StyleBox[
       TagBox["InterpolatingFunction", "SummaryHead"], 
       "NonInterpretableSummary"], 
      StyleBox["[", "NonInterpretableSummary"], 
      DynamicModuleBox[{Typeset`open$$ = False}, 
       PanelBox[
        PaneSelectorBox[{False -> GridBox[{{
              PaneBox[
               ButtonBox[
                DynamicBox[
                 FEPrivate`FrontEndResource[
                 "FEBitmaps", "SquarePlusIconMedium"]], 
                ButtonFunction :> (Typeset`open$$ = True), Appearance -> None,
                 Evaluator -> Automatic, Method -> "Preemptive"], 
               Alignment -> {Center, Center}, ImageSize -> 
               Dynamic[{
                 Automatic, 3.5 CurrentValue["FontCapHeight"]/
                  AbsoluteCurrentValue[Magnification]}]], 
              GraphicsBox[{{{{}, {}, {
                   Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]], 
                   
                   LineBox[{{1.694915254237288*^-7, 0.4999999999998815}, {
                    0.16301769472457447`, 0.49327079799997603`}, {
                    0.3397473724046566, 0.469449262841685}, {
                    0.5047654737182123, 0.4273792008846778}, {
                    0.6665465749364282, 0.35841644358083}, {
                    0.8420398286016771, 0.22855780014820112`}, {
                    1.0058215059003999`, -0.00667809182430777}, {
                    1.1833153356461554`, -0.6850927647534502}, {
                    1.242206345076066, -1.6302665978725825`}}], 
                   
                   LineBox[{{1.4717522244854506`, -1.6302665978725825`}, {
                    1.5201174185804605`, -0.8459660459007272}, {
                    1.6963748243113828`, -0.10169728272212873`}, {
                    1.8609206536757787`, 0.15942257275365596`}, {
                    2.022229482944835, 0.2962941756515981}, {
                    2.1972504646609243`, 0.3852329244312072}, {
                    2.360559870010487, 0.4371594884189086}, {
                    2.537581427807083, 0.47163678885592986`}, {
                    2.711365985508339, 0.4889246910572795}, {
                    2.873438966843069, 0.49214227196735055`}, {
                    3.0492241006248317`, 0.4811735667533316}, {
                    3.213297658040068, 0.45460538178127674`}, {
                    3.3910833679023376`, 0.40045146896751377`}, {
                    3.565632077669267, 0.3037786343977716}, {3.72846921106967,
                     0.13311300661796371`}, {
                    3.9050184969171067`, -0.3061743612647735}, {
                    4.032452141421959, -1.6302665978725825`}}], 
                   
                   LineBox[{{4.24128092407329, -1.6302665978725825`}, {
                    4.40676977761619, -0.3703151136188659}, {
                    4.570371063082267, 0.006314138746582964}, {
                    4.747684500995377, 0.20542624815389965`}, {
                    4.921760938813147, 0.3185596728985035}, {5.08412580026439,
                     0.3867825572337206}, {5.260202814162667, 
                    0.4360069014787245}, {5.424568251694417, 
                    0.4655801802371844}, {5.5856966891308275`, 
                    0.48226476746572755`}, {5.760537279014271, 
                    0.4876516320209946}, {5.923666292531188, 
                    0.47992530274979156`}, {6.100507458495137, 
                    0.45409367448974564`}, {6.265637048092561, 
                    0.40596095934996784`}, {6.4275296375946445`, 
                    0.31997273565893625`}, {6.603134379543762, 
                    0.1336115598856523}, {
                    6.767027545126353, -0.302305003336059}, {
                    6.868837885918802, -1.6302665978725825`}}], 
                   
                   LineBox[{{7.073759902411117, -1.6302665978725825`}, {
                    7.119001181090261, -1.2838874585612268`}, {
                    7.2816579226580185`, -0.3610307798029195}, {
                    7.458026816672809, -0.0008397569099918463}, {
                    7.622684134321073, 0.17349822682749325`}, {
                    7.784104451873997, 0.28084385408083556`}, {
                    7.959236921873954, 0.35920244175451105`}, {
                    8.122657815507385, 0.41006080975671294`}, {
                    8.299790861587848, 0.4482884632813735}, {
                    8.473686907572972, 0.47231977155076604`}, {
                    8.63587137719157, 0.4838857311834124}, {8.811767999257201,
                     0.48408899779206616`}, {8.975953044956306, 
                    0.4702396194927782}, {9.153850243102443, 
                    0.4333108839343423}, {9.32851044115324, 
                    0.3591959771211904}, {9.49145906283751, 
                    0.21941226181343698`}, {
                    9.668119836968813, -0.15713975358426552`}, {
                    9.827294852967189, -1.6302665978725825`}}]}}}, {}, {}}, {
               DisplayFunction -> Identity, Ticks -> {Automatic, Automatic}, 
                AxesOrigin -> {0, 0}, 
                FrameTicks -> {{None, None}, {None, None}}, 
                GridLines -> {None, None}, DisplayFunction -> Identity, 
                PlotRangePadding -> {{
                   Scaled[0.1], 
                   Scaled[0.1]}, {
                   Scaled[0.1], 
                   Scaled[0.1]}}, PlotRangeClipping -> True, ImagePadding -> 
                All, DisplayFunction -> Identity, AspectRatio -> 1, 
                Axes -> {False, False}, AxesLabel -> {None, None}, 
                AxesOrigin -> {0, 0}, DisplayFunction :> Identity, 
                Frame -> {{True, True}, {True, True}}, 
                FrameLabel -> {{None, None}, {None, None}}, FrameStyle -> 
                Directive[
                  Opacity[0.5], 
                  Thickness[Tiny], 
                  RGBColor[0.368417, 0.506779, 0.709798]], 
                FrameTicks -> {{None, None}, {None, None}}, 
                GridLines -> {None, None}, GridLinesStyle -> Directive[
                  GrayLevel[0.5, 0.4]], ImageSize -> 
                Dynamic[{
                  Automatic, 3.5 CurrentValue["FontCapHeight"]/
                   AbsoluteCurrentValue[Magnification]}], 
                Method -> {
                 "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
                  AbsolutePointSize[6], "ScalingFunctions" -> None, 
                  "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
                    (
                    Part[{{Identity, Identity}, {Identity, Identity}}, 1, 
                    2][#]& )[
                    Part[#, 1]], 
                    (
                    Part[{{Identity, Identity}, {Identity, Identity}}, 2, 
                    2][#]& )[
                    Part[#, 2]]}& ), "CopiedValueFunction" -> ({
                    (
                    Part[{{Identity, Identity}, {Identity, Identity}}, 1, 
                    2][#]& )[
                    Part[#, 1]], 
                    (
                    Part[{{Identity, Identity}, {Identity, Identity}}, 2, 
                    2][#]& )[
                    Part[#, 2]]}& )}}, 
                PlotRange -> {{0., 10.}, {-1.6302665978725825`, 
                 0.4999999999998815}}, PlotRangeClipping -> True, 
                PlotRangePadding -> {{
                   Scaled[0.1], 
                   Scaled[0.1]}, {
                   Scaled[0.1], 
                   Scaled[0.1]}}, Ticks -> {Automatic, Automatic}}], 
              GridBox[{{
                 RowBox[{
                   TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                   "\[InvisibleSpace]", 
                   TagBox[
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{"0.`", ",", "10.`"}], "}"}], "}"}], 
                    "SummaryItem"]}]}, {
                 RowBox[{
                   TagBox["\"Output: \"", "SummaryItemAnnotation"], 
                   "\[InvisibleSpace]", 
                   TagBox["\"scalar\"", "SummaryItem"]}]}}, 
               GridBoxAlignment -> {
                "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, AutoDelete -> 
               False, GridBoxItemSize -> {
                "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
               GridBoxSpacings -> {
                "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
               BaseStyle -> {
                ShowStringCharacters -> False, NumberMarks -> False, 
                 PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
            GridBoxAlignment -> {"Rows" -> {{Top}}}, AutoDelete -> False, 
            GridBoxItemSize -> {
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
            BaselinePosition -> {1, 1}], True -> GridBox[{{
              PaneBox[
               ButtonBox[
                DynamicBox[
                 FEPrivate`FrontEndResource[
                 "FEBitmaps", "SquareMinusIconMedium"]], 
                ButtonFunction :> (Typeset`open$$ = False), Appearance -> 
                None, Evaluator -> Automatic, Method -> "Preemptive"], 
               Alignment -> {Center, Center}, ImageSize -> 
               Dynamic[{
                 Automatic, 3.5 CurrentValue["FontCapHeight"]/
                  AbsoluteCurrentValue[Magnification]}]], 
              GraphicsBox[{{{{}, {}, {
                   Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]], 
                   
                   LineBox[{{1.694915254237288*^-7, 0.4999999999998815}, {
                    0.16301769472457447`, 0.49327079799997603`}, {
                    0.3397473724046566, 0.469449262841685}, {
                    0.5047654737182123, 0.4273792008846778}, {
                    0.6665465749364282, 0.35841644358083}, {
                    0.8420398286016771, 0.22855780014820112`}, {
                    1.0058215059003999`, -0.00667809182430777}, {
                    1.1833153356461554`, -0.6850927647534502}, {
                    1.242206345076066, -1.6302665978725825`}}], 
                   
                   LineBox[{{1.4717522244854506`, -1.6302665978725825`}, {
                    1.5201174185804605`, -0.8459660459007272}, {
                    1.6963748243113828`, -0.10169728272212873`}, {
                    1.8609206536757787`, 0.15942257275365596`}, {
                    2.022229482944835, 0.2962941756515981}, {
                    2.1972504646609243`, 0.3852329244312072}, {
                    2.360559870010487, 0.4371594884189086}, {
                    2.537581427807083, 0.47163678885592986`}, {
                    2.711365985508339, 0.4889246910572795}, {
                    2.873438966843069, 0.49214227196735055`}, {
                    3.0492241006248317`, 0.4811735667533316}, {
                    3.213297658040068, 0.45460538178127674`}, {
                    3.3910833679023376`, 0.40045146896751377`}, {
                    3.565632077669267, 0.3037786343977716}, {3.72846921106967,
                     0.13311300661796371`}, {
                    3.9050184969171067`, -0.3061743612647735}, {
                    4.032452141421959, -1.6302665978725825`}}], 
                   
                   LineBox[{{4.24128092407329, -1.6302665978725825`}, {
                    4.40676977761619, -0.3703151136188659}, {
                    4.570371063082267, 0.006314138746582964}, {
                    4.747684500995377, 0.20542624815389965`}, {
                    4.921760938813147, 0.3185596728985035}, {5.08412580026439,
                     0.3867825572337206}, {5.260202814162667, 
                    0.4360069014787245}, {5.424568251694417, 
                    0.4655801802371844}, {5.5856966891308275`, 
                    0.48226476746572755`}, {5.760537279014271, 
                    0.4876516320209946}, {5.923666292531188, 
                    0.47992530274979156`}, {6.100507458495137, 
                    0.45409367448974564`}, {6.265637048092561, 
                    0.40596095934996784`}, {6.4275296375946445`, 
                    0.31997273565893625`}, {6.603134379543762, 
                    0.1336115598856523}, {
                    6.767027545126353, -0.302305003336059}, {
                    6.868837885918802, -1.6302665978725825`}}], 
                   
                   LineBox[{{7.073759902411117, -1.6302665978725825`}, {
                    7.119001181090261, -1.2838874585612268`}, {
                    7.2816579226580185`, -0.3610307798029195}, {
                    7.458026816672809, -0.0008397569099918463}, {
                    7.622684134321073, 0.17349822682749325`}, {
                    7.784104451873997, 0.28084385408083556`}, {
                    7.959236921873954, 0.35920244175451105`}, {
                    8.122657815507385, 0.41006080975671294`}, {
                    8.299790861587848, 0.4482884632813735}, {
                    8.473686907572972, 0.47231977155076604`}, {
                    8.63587137719157, 0.4838857311834124}, {8.811767999257201,
                     0.48408899779206616`}, {8.975953044956306, 
                    0.4702396194927782}, {9.153850243102443, 
                    0.4333108839343423}, {9.32851044115324, 
                    0.3591959771211904}, {9.49145906283751, 
                    0.21941226181343698`}, {
                    9.668119836968813, -0.15713975358426552`}, {
                    9.827294852967189, -1.6302665978725825`}}]}}}, {}, {}}, {
               DisplayFunction -> Identity, Ticks -> {Automatic, Automatic}, 
                AxesOrigin -> {0, 0}, 
                FrameTicks -> {{None, None}, {None, None}}, 
                GridLines -> {None, None}, DisplayFunction -> Identity, 
                PlotRangePadding -> {{
                   Scaled[0.1], 
                   Scaled[0.1]}, {
                   Scaled[0.1], 
                   Scaled[0.1]}}, PlotRangeClipping -> True, ImagePadding -> 
                All, DisplayFunction -> Identity, AspectRatio -> 1, 
                Axes -> {False, False}, AxesLabel -> {None, None}, 
                AxesOrigin -> {0, 0}, DisplayFunction :> Identity, 
                Frame -> {{True, True}, {True, True}}, 
                FrameLabel -> {{None, None}, {None, None}}, FrameStyle -> 
                Directive[
                  Opacity[0.5], 
                  Thickness[Tiny], 
                  RGBColor[0.368417, 0.506779, 0.709798]], 
                FrameTicks -> {{None, None}, {None, None}}, 
                GridLines -> {None, None}, GridLinesStyle -> Directive[
                  GrayLevel[0.5, 0.4]], ImageSize -> 
                Dynamic[{
                  Automatic, 3.5 CurrentValue["FontCapHeight"]/
                   AbsoluteCurrentValue[Magnification]}], 
                Method -> {
                 "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
                  AbsolutePointSize[6], "ScalingFunctions" -> None, 
                  "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
                    (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 
                    2][#]& )[
                    Part[#, 1]], 
                    (
                    Part[{{Identity, Identity}, {Identity, Identity}}, 2, 
                    2][#]& )[
                    Part[#, 2]]}& ), "CopiedValueFunction" -> ({
                    (
                    Part[{{Identity, Identity}, {Identity, Identity}}, 1, 
                    2][#]& )[
                    Part[#, 1]], 
                    (
                    Part[{{Identity, Identity}, {Identity, Identity}}, 2, 
                    2][#]& )[
                    Part[#, 2]]}& )}}, 
                PlotRange -> {{0., 10.}, {-1.6302665978725825`, 
                 0.4999999999998815}}, PlotRangeClipping -> True, 
                PlotRangePadding -> {{
                   Scaled[0.1], 
                   Scaled[0.1]}, {
                   Scaled[0.1], 
                   Scaled[0.1]}}, Ticks -> {Automatic, Automatic}}], 
              GridBox[{{
                 RowBox[{
                   TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                   "\[InvisibleSpace]", 
                   TagBox[
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{"0.`", ",", "10.`"}], "}"}], "}"}], 
                    "SummaryItem"]}]}, {
                 RowBox[{
                   TagBox["\"Output: \"", "SummaryItemAnnotation"], 
                   "\[InvisibleSpace]", 
                   TagBox["\"scalar\"", "SummaryItem"]}]}, {
                 RowBox[{
                   TagBox["\"Order: \"", "SummaryItemAnnotation"], 
                   "\[InvisibleSpace]", 
                   TagBox["3", "SummaryItem"]}]}, {
                 RowBox[{
                   TagBox["\"Method: \"", "SummaryItemAnnotation"], 
                   "\[InvisibleSpace]", 
                   TagBox["\"Hermite\"", "SummaryItem"]}]}, {
                 RowBox[{
                   TagBox["\"Periodic: \"", "SummaryItemAnnotation"], 
                   "\[InvisibleSpace]", 
                   TagBox["False", "SummaryItem"]}]}}, 
               GridBoxAlignment -> {
                "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, AutoDelete -> 
               False, 
               GridBoxItemSize -> {
                "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
               GridBoxSpacings -> {
                "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
               BaseStyle -> {
                ShowStringCharacters -> False, NumberMarks -> False, 
                 PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
            GridBoxAlignment -> {"Rows" -> {{Top}}}, AutoDelete -> False, 
            GridBoxItemSize -> {
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
            BaselinePosition -> {1, 1}]}, 
         Dynamic[Typeset`open$$], ImageSize -> Automatic], BaselinePosition -> 
        Baseline], DynamicModuleValues :> {}], 
      StyleBox["]", "NonInterpretableSummary"]}]},
   "CopyTag",
   DisplayFunction->(#& ),
   InterpretationFunction->("InterpolatingFunction[{{0., 10.}}, <>]"& )],
  False,
  Editable->False,
  SelectWithContents->True,
  Selectable->False]], "Output",
 CellChangeTimes->{3.6832618694225473`*^9, 3.68326260227092*^9, 
  3.683262718713086*^9, 3.683734356416225*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"With", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\[Delta]t", "=", "0.01"}], "}"}], ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"midpointorbit", "[", "\[Delta]t", "]"}], "=", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"ParametricPlot", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"xmidpoint", "[", "\[Delta]t", "]"}], "[", "t", "]"}], ",", 
         
         RowBox[{
          RowBox[{"ymidpoint", "[", "\[Delta]t", "]"}], "[", "t", "]"}]}], 
        "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", "0", ",", "10"}], "}"}], ",", 
       RowBox[{"AxesLabel", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Style", "[", 
           RowBox[{"\"\<x\>\"", ",", "Black", ",", "15"}], "]"}], ",", 
          RowBox[{"Style", "[", 
           RowBox[{"\"\<y\>\"", ",", "Black", ",", "15"}], "]"}]}], "}"}]}], 
       ",", 
       RowBox[{"PlotStyle", "\[Rule]", "Blue"}]}], "]"}], "/.", 
     RowBox[{"Line", "\[Rule]", "Arrow"}]}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.683261910648492*^9, 3.683261942184559*^9}, {
   3.683262161372587*^9, 3.6832621722183123`*^9}, {3.683262249312037*^9, 
   3.683262250143906*^9}, {3.683262606091915*^9, 3.683262609170856*^9}, {
   3.6832626730320272`*^9, 3.683262675385591*^9}, 3.683262752618299*^9, {
   3.68373439766823*^9, 3.6837343994351473`*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {RGBColor[0, 0, 1], AbsoluteThickness[1.6], Opacity[1.], FaceForm[Opacity[
    0.3]], ArrowBox[CompressedData["
1:eJw0mnc81f/7/6msUlYZhSgNZKVI77gQGYVslUihoRIhGRmRjEh2sokysjdP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     "]]}},
  Axes->{True, True},
  AxesLabel->{
    FormBox[
     StyleBox["\"x\"", 
      GrayLevel[0], 15, StripOnInput -> False], TraditionalForm], 
    FormBox[
     StyleBox["\"y\"", 
      GrayLevel[0], 15, StripOnInput -> False], TraditionalForm]},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  Method->{"ScalingFunctions" -> None},
  PlotRange->{{-0.1454307910901143, 
   1.0517724415602252`}, {-0.4511062883886615, 0.3780118551720389}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.05], 
     Scaled[0.05]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.683261924014382*^9, 3.683261942897002*^9}, 
   3.6832621726793137`*^9, 3.683262250497493*^9, 3.6832626115482397`*^9, {
   3.68326265978738*^9, 3.683262675907461*^9}, 3.683262753040614*^9, 
   3.683734357408465*^9, 3.683734399916707*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"With", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\[Delta]t", "=", "0.01"}], "}"}], ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"midpointenergy", "[", "\[Delta]t", "]"}], "=", 
    "\[IndentingNewLine]", 
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox[
           RowBox[{
            RowBox[{"vxmidpoint", "[", "\[Delta]t", "]"}], "[", "t", "]"}], 
           "2"], "+", 
          SuperscriptBox[
           RowBox[{
            RowBox[{"vymidpoint", "[", "\[Delta]t", "]"}], "[", "t", "]"}], 
           "2"]}], ")"}], "/", "2"}], "-", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox[
           RowBox[{
            RowBox[{"xmidpoint", "[", "\[Delta]t", "]"}], "[", "t", "]"}], 
           "2"], "+", 
          SuperscriptBox[
           RowBox[{
            RowBox[{"ymidpoint", "[", "\[Delta]t", "]"}], "[", "t", "]"}], 
           "2"]}], ")"}], 
        RowBox[{
         RowBox[{"-", "1"}], "/", "2"}]]}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "10"}], "}"}], ",", 
      RowBox[{"AxesLabel", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Style", "[", 
          RowBox[{"\"\<time\>\"", ",", "Black", ",", "12"}], "]"}], ",", 
         RowBox[{"Style", "[", 
          RowBox[{"\"\<Energy\>\"", ",", "Black", ",", "12"}], "]"}]}], 
        "}"}]}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", "Blue"}]}], "]"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.683262030303484*^9, 3.68326207088873*^9}, {
   3.683262182930636*^9, 3.6832621977268*^9}, {3.6832622532398376`*^9, 
   3.683262253746169*^9}, {3.683262615732993*^9, 3.683262643801177*^9}, {
   3.68326267835918*^9, 3.683262680583823*^9}, 3.6832627550336437`*^9, {
   3.683734402837492*^9, 3.683734403351637*^9}}],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    {RGBColor[0, 0, 1], AbsoluteThickness[1.6], Opacity[1.], 
     LineBox[CompressedData["
1:eJwc2Hk4VF0YAHDZs87YjbEUIUlIJcl9I0oUCalPklRKSSUJScgWkZCQpVSU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      "]]}}, {}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{
    FormBox[
     StyleBox["\"time\"", 
      GrayLevel[0], 12, StripOnInput -> False], TraditionalForm], 
    FormBox[
     StyleBox["\"Energy\"", 
      GrayLevel[0], 12, StripOnInput -> False], TraditionalForm]},
  AxesOrigin->{0, -0.8750000014764419},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
         Part[#, 1]], 
        (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
         Part[#, 1]], 
        (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{0, 10}, {-0.8750000014764419, -0.7992941976530155}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.68326204728004*^9, 3.683262071576764*^9}, 
   3.683262199177944*^9, 3.6832622541502523`*^9, {3.6832626292571487`*^9, 
   3.683262681234578*^9}, 3.683262755448194*^9, 3.6837343583463793`*^9, 
   3.683734403859714*^9}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Euler-Cromer method :", "Section",
 CellChangeTimes->{{3.683263150261177*^9, 3.683263156580481*^9}, {
  3.6837343591555557`*^9, 3.683734361947419*^9}}],

Cell[TextData[Cell[BoxData[{
 FormBox[
  RowBox[{
   RowBox[{
    SubscriptBox["x", 
     RowBox[{"n", "+", "1"}]], "=", 
    RowBox[{
     SubscriptBox["x", "n"], "+", 
     RowBox[{
      SubscriptBox[
       RowBox[{"(", 
        SubscriptBox["v", "x"], ")"}], "n"], "\[Delta]t"}]}]}], " ", ";"}], 
  TraditionalForm], "\[IndentingNewLine]", 
 FormBox[
  RowBox[{
   RowBox[{
    SubscriptBox["y", 
     RowBox[{"n", "+", "1"}]], "=", 
    RowBox[{
     SubscriptBox["y", "n"], "+", 
     RowBox[{
      SubscriptBox[
       RowBox[{"(", 
        SubscriptBox["v", "y"], ")"}], "n"], "\[Delta]t"}]}]}], " ", ";"}], 
  TraditionalForm], "\[IndentingNewLine]", 
 FormBox[
  RowBox[{
   RowBox[{
    SubscriptBox[
     RowBox[{"(", 
      SubscriptBox["v", "x"], ")"}], 
     RowBox[{"n", "+", "1"}]], "=", 
    RowBox[{
     SubscriptBox[
      RowBox[{"(", 
       SubscriptBox["v", "x"], ")"}], "n"], "+", 
     RowBox[{
      RowBox[{
       SubscriptBox["a", "x"], "(", 
       RowBox[{
        SubscriptBox["x", 
         RowBox[{"n", "+", "1"}]], ",", 
        SubscriptBox["y", 
         RowBox[{"n", "+", "1"}]]}], ")"}], "\[Delta]t"}]}]}], " ", ";"}], 
  TraditionalForm], "\[IndentingNewLine]", 
 FormBox[
  RowBox[{
   RowBox[{
    SubscriptBox[
     RowBox[{"(", 
      SubscriptBox["v", "y"], ")"}], 
     RowBox[{"n", "+", "1"}]], "=", 
    RowBox[{
     SubscriptBox[
      RowBox[{"(", 
       SubscriptBox["v", "y"], ")"}], "n"], "+", 
     RowBox[{
      RowBox[{
       SubscriptBox["a", "y"], "(", 
       RowBox[{
        SubscriptBox["x", 
         RowBox[{"n", "+", "1"}]], ",", 
        SubscriptBox["y", 
         RowBox[{"n", "+", "1"}]]}], ")"}], "\[Delta]t"}]}]}], " ", ";"}], 
  TraditionalForm]}]]], "ItemParagraph",
 CellChangeTimes->{{3.6837339757819366`*^9, 3.683733984474985*^9}},
 FontSize->18],

Cell[CellGroupData[{

Cell[TextData[{
 "1. Error in each step ~ ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Delta]t", "2"], TraditionalForm]],
  FormatType->"TraditionalForm"],
 ". II. Symplectic -- conserves energy."
}], "Subsubsection",
 CellChangeTimes->{{3.683734728610375*^9, 3.6837347305983067`*^9}, {
   3.683736232032382*^9, 3.6837362327265587`*^9}, {3.683736298765992*^9, 
   3.683736311598612*^9}, 3.683736368266561*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AbsoluteTiming", "[", "\[IndentingNewLine]", 
  RowBox[{"With", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"\[Delta]t", "=", "0.01"}], ",", 
      RowBox[{"nmax", "=", "1000"}]}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "[", "0", "]"}], "=", "1"}], ";", 
     RowBox[{
      RowBox[{"y", "[", "0", "]"}], "=", "0"}], ";", 
     RowBox[{
      RowBox[{"vx", "[", "0", "]"}], "=", "0"}], ";", 
     RowBox[{
      RowBox[{"vy", "[", "0", "]"}], "=", "0.5"}], ";", "\[IndentingNewLine]", 
     RowBox[{"Do", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"x", "[", 
          RowBox[{"n", "+", "1"}], "]"}], "=", 
         RowBox[{
          RowBox[{"x", "[", "n", "]"}], "+", 
          RowBox[{
           RowBox[{"vx", "[", "n", "]"}], "*", "\[Delta]t"}]}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"y", "[", 
          RowBox[{"n", "+", "1"}], "]"}], "=", 
         RowBox[{
          RowBox[{"y", "[", "n", "]"}], "+", 
          RowBox[{
           RowBox[{"vy", "[", "n", "]"}], "*", "\[Delta]t"}]}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"vx", "[", 
          RowBox[{"n", "+", "1"}], "]"}], "=", 
         RowBox[{
          RowBox[{"vx", "[", "n", "]"}], "+", 
          RowBox[{
           RowBox[{"ax", "[", 
            RowBox[{
             RowBox[{"x", "[", 
              RowBox[{"n", "+", "1"}], "]"}], ",", 
             RowBox[{"y", "[", 
              RowBox[{"n", "+", "1"}], "]"}]}], "]"}], "*", "\[Delta]t"}]}]}],
         ";", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"vy", "[", 
          RowBox[{"n", "+", "1"}], "]"}], "=", 
         RowBox[{
          RowBox[{"vy", "[", "n", "]"}], "+", 
          RowBox[{
           RowBox[{"ay", "[", 
            RowBox[{
             RowBox[{"x", "[", 
              RowBox[{"n", "+", "1"}], "]"}], ",", 
             RowBox[{"y", "[", 
              RowBox[{"n", "+", "1"}], "]"}]}], "]"}], "*", "\[Delta]t"}]}]}],
         ";"}], ",", "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{"n", ",", "0", ",", "nmax"}], "}"}]}], "]"}]}]}], "]"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.6832616421061897`*^9, 3.683261653127754*^9}, {
  3.6832616894584627`*^9, 3.683261693990344*^9}, {3.6832628723234167`*^9, 
  3.683262900189262*^9}, {3.683262978889696*^9, 3.6832629800099163`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.02659`", ",", "Null"}], "}"}]], "Output",
 CellChangeTimes->{{3.6832616684529467`*^9, 3.683261695110804*^9}, {
   3.683262890380821*^9, 3.683262901044587*^9}, 3.68326298176676*^9, 
   3.683734364131884*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"With", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"\[Delta]t", "=", "0.01"}], ",", 
     RowBox[{"nmax", "=", "1000"}]}], "}"}], ",", 
   RowBox[{
    RowBox[{"xeulercromer", "[", "\[Delta]t", "]"}], "=", 
    RowBox[{"Interpolation", "[", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"n", "*", "\[Delta]t"}], ",", 
         RowBox[{"x", "[", "n", "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"n", ",", "0", ",", "nmax"}], "}"}]}], "]"}], "]"}]}]}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.683261683469326*^9, 3.683261751804677*^9}, {
  3.683262905675318*^9, 3.683262908240996*^9}, {3.683262983870391*^9, 
  3.683262986907341*^9}}],

Cell[BoxData[
 TagBox[
  TemplateBox[{RowBox[{
      StyleBox[
       TagBox["InterpolatingFunction", "SummaryHead"], 
       "NonInterpretableSummary"], 
      StyleBox["[", "NonInterpretableSummary"], 
      DynamicModuleBox[{Typeset`open$$ = False}, 
       PanelBox[
        PaneSelectorBox[{False -> GridBox[{{
              PaneBox[
               ButtonBox[
                DynamicBox[
                 FEPrivate`FrontEndResource[
                 "FEBitmaps", "SquarePlusIconMedium"]], 
                ButtonFunction :> (Typeset`open$$ = True), Appearance -> None,
                 Evaluator -> Automatic, Method -> "Preemptive"], 
               Alignment -> {Center, Center}, ImageSize -> 
               Dynamic[{
                 Automatic, 3.5 CurrentValue["FontCapHeight"]/
                  AbsoluteCurrentValue[Magnification]}]], 
              GraphicsBox[{{{{}, {}, {
                   Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]], 
                   LineBox[CompressedData["
1:eJwB0QMu/CFib1JlAgAAADwAAAACAAAAStFeOa+/hj7zOjoAAADwPzd0wYnD
3cQ/1ku/m5WZ7z/SUFjDa77VP2I5WPLYL+4/IqE47Akn4D/toXNYm+XrP9Wb
k3tZVOU/DJGp85Sm6D+7wbiC/fHqP12BzThv1OM/gEqXStgX8D+YipJk/6Hb
P7tJtw/c7vI/DiPgRvsoxD/ziT6Xnbj1P2usUvgZQMK/2iBupGZS+D/IwNJl
+7a8P1rNgu1ZJPs/aiJi9vFc2T+J0D+8VMb9PwvGPVUo/OI/WwqypoYtAEBZ
GsGDcqvnPz63Ng34kwFAXghQd65r6z94j482beICQOxJYP0I2u0/f/LaffdM
BEAeTamRPHDvPwX2WabgsAVAV/QAmDj/7z/iJK2RzfwGQIzXW5v0pO8/jN7y
ms9kCEBH0oS4CUvuP43DDGfVtAlAlnrdKn8S7D9bMxlR8CALQI6vL2Kzgug/
p0NZHGqGDEA8IIVQH6bjP0t/barn0w1AjEAyRLcq2z+8RXRWej0PQC+kkGv5
08I/wpunYohHEECnPYU8kCPCv+XkrgoD7RBAXSsmbpyOuj9vc69BiKARQIKm
4l8dxtg/pRcaWg9IEkDhNetmhLPiP0EBfgGh/RJAW2oamfTW5z8cu3sZ4q8T
QKIz7eXXg+s/oorjEiVWFEBSlURxAubtP4+fRJtyChVABVe3sAJ07z8oyg8F
wrIVQM8h6iVn/e8/AMV038BXFkDk3GLYuqzvPz4F00jKChdArW/HRsxf7j8o
W5uT1bEXQNsixvUgNuw/ePZcbetmGECLJE7VR7noP3SniCgDEBlAPllvkA84
5D+vKE5UyrUZQJWdF5bYsNw/Ue8MD5xpGkDNfUoWlvrGP5/LNatvERtA+Fc+
HxNTwL9T7VfWTccbQL3F/4sBSLk/R98Tctt5HECFGRN4y1fYP+bmOe9qIB1A
bbzWY7Z54j/rM1n7BNUdQKIhMYpPoec/nJbi6KB9HkD26FdFDC/rP4zJBUfs
Ih9AWbQRXE2o7T/iQSI0QtYfQOabXZJ+Ue8/8mdUAc0+IEC7ehe5TPbvP6ZR
FDB+mSBA25pWkTyx7z96IyEXh/IgQDJ/JEJ+bu4/JADj7pBFIUClcL5O6FDs
P4F/IQ6gnyFAgJ5AI6Tj6D+0CRUesPMhQEI1/kV4dOQ/mjaFdcVOIkABfExa
FOrbP59LQoUyqCJApYasbePMxD96a7SFoPsiQEFirqt4icG/CC6jzRNWI0Dg
/sHxbN28P2z7RgaIqiNAdHFXVkgS2D8yFFD6//8jQM23SRMafOI/WaDJ2A==

                    "]]}}}, {}, {}}, {
               DisplayFunction -> Identity, Ticks -> {Automatic, Automatic}, 
                AxesOrigin -> {0, 0}, 
                FrameTicks -> {{None, None}, {None, None}}, 
                GridLines -> {None, None}, DisplayFunction -> Identity, 
                PlotRangePadding -> {{
                   Scaled[0.1], 
                   Scaled[0.1]}, {
                   Scaled[0.1], 
                   Scaled[0.1]}}, PlotRangeClipping -> True, ImagePadding -> 
                All, DisplayFunction -> Identity, AspectRatio -> 1, 
                Axes -> {False, False}, AxesLabel -> {None, None}, 
                AxesOrigin -> {0, 0}, DisplayFunction :> Identity, 
                Frame -> {{True, True}, {True, True}}, 
                FrameLabel -> {{None, None}, {None, None}}, FrameStyle -> 
                Directive[
                  Opacity[0.5], 
                  Thickness[Tiny], 
                  RGBColor[0.368417, 0.506779, 0.709798]], 
                FrameTicks -> {{None, None}, {None, None}}, 
                GridLines -> {None, None}, GridLinesStyle -> Directive[
                  GrayLevel[0.5, 0.4]], ImageSize -> 
                Dynamic[{
                  Automatic, 3.5 CurrentValue["FontCapHeight"]/
                   AbsoluteCurrentValue[Magnification]}], 
                Method -> {
                 "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
                  AbsolutePointSize[6], "ScalingFunctions" -> None, 
                  "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
                    (
                    Part[{{Identity, Identity}, {Identity, Identity}}, 1, 
                    2][#]& )[
                    Part[#, 1]], 
                    (
                    Part[{{Identity, Identity}, {Identity, Identity}}, 2, 
                    2][#]& )[
                    Part[#, 2]]}& ), "CopiedValueFunction" -> ({
                    (
                    Part[{{Identity, Identity}, {Identity, Identity}}, 1, 
                    2][#]& )[
                    Part[#, 1]], 
                    (
                    Part[{{Identity, Identity}, {Identity, Identity}}, 2, 
                    2][#]& )[
                    Part[#, 2]]}& )}}, 
                PlotRange -> {{0., 10.}, {-0.14258122086662026`, 
                 1.000000000847362}}, PlotRangeClipping -> True, 
                PlotRangePadding -> {{
                   Scaled[0.1], 
                   Scaled[0.1]}, {
                   Scaled[0.1], 
                   Scaled[0.1]}}, Ticks -> {Automatic, Automatic}}], 
              GridBox[{{
                 RowBox[{
                   TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                   "\[InvisibleSpace]", 
                   TagBox[
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{"0.`", ",", "10.`"}], "}"}], "}"}], 
                    "SummaryItem"]}]}, {
                 RowBox[{
                   TagBox["\"Output: \"", "SummaryItemAnnotation"], 
                   "\[InvisibleSpace]", 
                   TagBox["\"scalar\"", "SummaryItem"]}]}}, 
               GridBoxAlignment -> {
                "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, AutoDelete -> 
               False, GridBoxItemSize -> {
                "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
               GridBoxSpacings -> {
                "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
               BaseStyle -> {
                ShowStringCharacters -> False, NumberMarks -> False, 
                 PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
            GridBoxAlignment -> {"Rows" -> {{Top}}}, AutoDelete -> False, 
            GridBoxItemSize -> {
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
            BaselinePosition -> {1, 1}], True -> GridBox[{{
              PaneBox[
               ButtonBox[
                DynamicBox[
                 FEPrivate`FrontEndResource[
                 "FEBitmaps", "SquareMinusIconMedium"]], 
                ButtonFunction :> (Typeset`open$$ = False), Appearance -> 
                None, Evaluator -> Automatic, Method -> "Preemptive"], 
               Alignment -> {Center, Center}, ImageSize -> 
               Dynamic[{
                 Automatic, 3.5 CurrentValue["FontCapHeight"]/
                  AbsoluteCurrentValue[Magnification]}]], 
              GraphicsBox[{{{{}, {}, {
                   Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]], 
                   LineBox[CompressedData["
1:eJwB0QMu/CFib1JlAgAAADwAAAACAAAAStFeOa+/hj7zOjoAAADwPzd0wYnD
3cQ/1ku/m5WZ7z/SUFjDa77VP2I5WPLYL+4/IqE47Akn4D/toXNYm+XrP9Wb
k3tZVOU/DJGp85Sm6D+7wbiC/fHqP12BzThv1OM/gEqXStgX8D+YipJk/6Hb
P7tJtw/c7vI/DiPgRvsoxD/ziT6Xnbj1P2usUvgZQMK/2iBupGZS+D/IwNJl
+7a8P1rNgu1ZJPs/aiJi9vFc2T+J0D+8VMb9PwvGPVUo/OI/WwqypoYtAEBZ
GsGDcqvnPz63Ng34kwFAXghQd65r6z94j482beICQOxJYP0I2u0/f/LaffdM
BEAeTamRPHDvPwX2WabgsAVAV/QAmDj/7z/iJK2RzfwGQIzXW5v0pO8/jN7y
ms9kCEBH0oS4CUvuP43DDGfVtAlAlnrdKn8S7D9bMxlR8CALQI6vL2Kzgug/
p0NZHGqGDEA8IIVQH6bjP0t/barn0w1AjEAyRLcq2z+8RXRWej0PQC+kkGv5
08I/wpunYohHEECnPYU8kCPCv+XkrgoD7RBAXSsmbpyOuj9vc69BiKARQIKm
4l8dxtg/pRcaWg9IEkDhNetmhLPiP0EBfgGh/RJAW2oamfTW5z8cu3sZ4q8T
QKIz7eXXg+s/oorjEiVWFEBSlURxAubtP4+fRJtyChVABVe3sAJ07z8oyg8F
wrIVQM8h6iVn/e8/AMV038BXFkDk3GLYuqzvPz4F00jKChdArW/HRsxf7j8o
W5uT1bEXQNsixvUgNuw/ePZcbetmGECLJE7VR7noP3SniCgDEBlAPllvkA84
5D+vKE5UyrUZQJWdF5bYsNw/Ue8MD5xpGkDNfUoWlvrGP5/LNatvERtA+Fc+
HxNTwL9T7VfWTccbQL3F/4sBSLk/R98Tctt5HECFGRN4y1fYP+bmOe9qIB1A
bbzWY7Z54j/rM1n7BNUdQKIhMYpPoec/nJbi6KB9HkD26FdFDC/rP4zJBUfs
Ih9AWbQRXE2o7T/iQSI0QtYfQOabXZJ+Ue8/8mdUAc0+IEC7ehe5TPbvP6ZR
FDB+mSBA25pWkTyx7z96IyEXh/IgQDJ/JEJ+bu4/JADj7pBFIUClcL5O6FDs
P4F/IQ6gnyFAgJ5AI6Tj6D+0CRUesPMhQEI1/kV4dOQ/mjaFdcVOIkABfExa
FOrbP59LQoUyqCJApYasbePMxD96a7SFoPsiQEFirqt4icG/CC6jzRNWI0Dg
/sHxbN28P2z7RgaIqiNAdHFXVkgS2D8yFFD6//8jQM23SRMafOI/WaDJ2A==

                    "]]}}}, {}, {}}, {
               DisplayFunction -> Identity, Ticks -> {Automatic, Automatic}, 
                AxesOrigin -> {0, 0}, 
                FrameTicks -> {{None, None}, {None, None}}, 
                GridLines -> {None, None}, DisplayFunction -> Identity, 
                PlotRangePadding -> {{
                   Scaled[0.1], 
                   Scaled[0.1]}, {
                   Scaled[0.1], 
                   Scaled[0.1]}}, PlotRangeClipping -> True, ImagePadding -> 
                All, DisplayFunction -> Identity, AspectRatio -> 1, 
                Axes -> {False, False}, AxesLabel -> {None, None}, 
                AxesOrigin -> {0, 0}, DisplayFunction :> Identity, 
                Frame -> {{True, True}, {True, True}}, 
                FrameLabel -> {{None, None}, {None, None}}, FrameStyle -> 
                Directive[
                  Opacity[0.5], 
                  Thickness[Tiny], 
                  RGBColor[0.368417, 0.506779, 0.709798]], 
                FrameTicks -> {{None, None}, {None, None}}, 
                GridLines -> {None, None}, GridLinesStyle -> Directive[
                  GrayLevel[0.5, 0.4]], ImageSize -> 
                Dynamic[{
                  Automatic, 3.5 CurrentValue["FontCapHeight"]/
                   AbsoluteCurrentValue[Magnification]}], 
                Method -> {
                 "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
                  AbsolutePointSize[6], "ScalingFunctions" -> None, 
                  "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
                    (
                    Part[{{Identity, Identity}, {Identity, Identity}}, 1, 
                    2][#]& )[
                    Part[#, 1]], 
                    (
                    Part[{{Identity, Identity}, {Identity, Identity}}, 2, 
                    2][#]& )[
                    Part[#, 2]]}& ), "CopiedValueFunction" -> ({
                    (
                    Part[{{Identity, Identity}, {Identity, Identity}}, 1, 
                    2][#]& )[
                    Part[#, 1]], 
                    (
                    Part[{{Identity, Identity}, {Identity, Identity}}, 2, 
                    2][#]& )[
                    Part[#, 2]]}& )}}, 
                PlotRange -> {{0., 10.}, {-0.14258122086662026`, 
                 1.000000000847362}}, PlotRangeClipping -> True, 
                PlotRangePadding -> {{
                   Scaled[0.1], 
                   Scaled[0.1]}, {
                   Scaled[0.1], 
                   Scaled[0.1]}}, Ticks -> {Automatic, Automatic}}], 
              GridBox[{{
                 RowBox[{
                   TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                   "\[InvisibleSpace]", 
                   TagBox[
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{"0.`", ",", "10.`"}], "}"}], "}"}], 
                    "SummaryItem"]}]}, {
                 RowBox[{
                   TagBox["\"Output: \"", "SummaryItemAnnotation"], 
                   "\[InvisibleSpace]", 
                   TagBox["\"scalar\"", "SummaryItem"]}]}, {
                 RowBox[{
                   TagBox["\"Order: \"", "SummaryItemAnnotation"], 
                   "\[InvisibleSpace]", 
                   TagBox["3", "SummaryItem"]}]}, {
                 RowBox[{
                   TagBox["\"Method: \"", "SummaryItemAnnotation"], 
                   "\[InvisibleSpace]", 
                   TagBox["\"Hermite\"", "SummaryItem"]}]}, {
                 RowBox[{
                   TagBox["\"Periodic: \"", "SummaryItemAnnotation"], 
                   "\[InvisibleSpace]", 
                   TagBox["False", "SummaryItem"]}]}}, 
               GridBoxAlignment -> {
                "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, AutoDelete -> 
               False, GridBoxItemSize -> {
                "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
               GridBoxSpacings -> {
                "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
               BaseStyle -> {
                ShowStringCharacters -> False, NumberMarks -> False, 
                 PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
            GridBoxAlignment -> {"Rows" -> {{Top}}}, AutoDelete -> False, 
            GridBoxItemSize -> {
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
            BaselinePosition -> {1, 1}]}, 
         Dynamic[Typeset`open$$], ImageSize -> Automatic], BaselinePosition -> 
        Baseline], DynamicModuleValues :> {}], 
      StyleBox["]", "NonInterpretableSummary"]}]},
   "CopyTag",
   DisplayFunction->(#& ),
   InterpretationFunction->("InterpolatingFunction[{{0., 10.}}, <>]"& )],
  False,
  Editable->False,
  SelectWithContents->True,
  Selectable->False]], "Output",
 CellChangeTimes->{3.683261758976274*^9, 3.68326180355539*^9, 
  3.683262914078722*^9, 3.683262989908086*^9, 3.683734365031661*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"With", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"\[Delta]t", "=", "0.01"}], ",", 
     RowBox[{"nmax", "=", "1000"}]}], "}"}], ",", 
   RowBox[{
    RowBox[{"yeulercromer", "[", "\[Delta]t", "]"}], "=", 
    RowBox[{"Interpolation", "[", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"n", "*", "\[Delta]t"}], ",", 
         RowBox[{"y", "[", "n", "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"n", ",", "0", ",", "nmax"}], "}"}]}], "]"}], "]"}]}]}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.683261816267932*^9, 3.6832618184219007`*^9}, {
  3.6832629166771517`*^9, 3.683262917377035*^9}, {3.683262992665255*^9, 
  3.6832629943519297`*^9}, {3.683734366375153*^9, 3.68373436724124*^9}}],

Cell[BoxData[
 TagBox[
  TemplateBox[{RowBox[{
      StyleBox[
       TagBox["InterpolatingFunction", "SummaryHead"], 
       "NonInterpretableSummary"], 
      StyleBox["[", "NonInterpretableSummary"], 
      DynamicModuleBox[{Typeset`open$$ = False}, 
       PanelBox[
        PaneSelectorBox[{False -> GridBox[{{
              PaneBox[
               ButtonBox[
                DynamicBox[
                 FEPrivate`FrontEndResource[
                 "FEBitmaps", "SquarePlusIconMedium"]], 
                ButtonFunction :> (Typeset`open$$ = True), Appearance -> None,
                 Evaluator -> Automatic, Method -> "Preemptive"], 
               Alignment -> {Center, Center}, ImageSize -> 
               Dynamic[{
                 Automatic, 3.5 CurrentValue["FontCapHeight"]/
                  AbsoluteCurrentValue[Magnification]}]], 
              GraphicsBox[{{{{}, {}, {
                   Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]], 
                   LineBox[CompressedData["
1:eJwB0QMu/CFib1JlAgAAADwAAAACAAAAStFeOa+/hj4AAKcOyL92Pjd0wYnD
3cQ/19s8fgrGtD/SUFjDa77VPyLVm2QDUMU/IqE47Akn4D9S7h4NPdTOP9Wb
k3tZVOU/xtpfzBmF0z+7wbiC/fHqP3teKMCN6dY/gEqXStgX8D9zdZfWYUjY
P7tJtw/c7vI//P6RBIRb1T/ziT6Xnbj1PxIfewFbBJY/2iBupGZS+D8lShXK
6kbUv1rNgu1ZJPs/3KOkwjFd2L+J0D+8VMb9P/mE8Rmkbte/WwqypoYtAEAZ
hRbG8pnUvz63Ng34kwFAUEszvDZb0L94j482beICQMs51oXbe8e/f/LaffdM
BEBab/Dl+0+5vwX2WabgsAVAZlOD8Z/hib/iJK2RzfwGQIGLXQ7vdLE/jN7y
ms9kCECfNFWBgKvDP43DDGfVtAlAz7rMWnhCzT9bMxlR8CALQIxu/jblNNM/
p0NZHGqGDEAMqb32nZvWP0t/barn0w1ADqz1f9z41z+8RXRWej0PQMmzETHL
6tQ/wpunYohHEED5HE8iXH+dP+XkrgoD7RBAy5ZM+uo21L9vc69BiKARQDf4
A7AWoti/pRcaWg9IEkAlnfubburXv0EBfgGh/RJA17cmTTDl1L8cu3sZ4q8T
QPd54AjrstC/oorjEiVWFEDMGPSYlEXIv4+fRJtyChVAz8L3dZAUu78oyg8F
wrIVQCct5jFz8Ji/AMV038BXFkCij21nfbysPz4F00jKChdA6m1Ceewhwj8o
W5uT1bEXQKjF1+8AyMs/ePZcbetmGEBktQxAn4rSP3SniCgDEBlALdFteY3v
1T+vKE5UyrUZQIE67CA6otc/Ue8MD5xpGkBjyu6PlmvVP5/LNatvERtAOlpA
Xw8Mtj9T7VfWTccbQFTahwboPtS/R98Tctt5HEBOch2E++bYv+bmOe9qIB1A
FfdGJzpe2L/rM1n7BNUdQAE/xthkgtW/nJbi6KB9HkBIFdYvAanRv4zJBUfs
Ih9A6gFL1Jxwyr/iQSI0QtYfQJfAnkHMyb+/8mdUAc0+IECbnQdPQ1Smv6ZR
FDB+mSBAPXNSy3kFpz96IyEXh/IgQGTG6FUatMA/JADj7pBFIUCA6zWrKWbK
P4F/IQ6gnyFAiUNtqd3p0T+0CRUesPMhQHekUQGUadU/mjaFdcVOIkBG/t04
91fXP59LQoUyqCJAvmOwSfje1D96a7SFoPsiQGpKUmfzSqs/CC6jzRNWI0CD
CFmrVtvUv2z7RgaIqiNAU6awRaQt2b8yFFD6//8jQLLpxvCfvdi/mc/Uzw==

                    "]]}}}, {}, {}}, {
               DisplayFunction -> Identity, Ticks -> {Automatic, Automatic}, 
                AxesOrigin -> {0, 0}, 
                FrameTicks -> {{None, None}, {None, None}}, 
                GridLines -> {None, None}, DisplayFunction -> Identity, 
                PlotRangePadding -> {{
                   Scaled[0.1], 
                   Scaled[0.1]}, {
                   Scaled[0.1], 
                   Scaled[0.1]}}, PlotRangeClipping -> True, ImagePadding -> 
                All, DisplayFunction -> Identity, AspectRatio -> 1, 
                Axes -> {False, False}, AxesLabel -> {None, None}, 
                AxesOrigin -> {0, 0}, DisplayFunction :> Identity, 
                Frame -> {{True, True}, {True, True}}, 
                FrameLabel -> {{None, None}, {None, None}}, FrameStyle -> 
                Directive[
                  Opacity[0.5], 
                  Thickness[Tiny], 
                  RGBColor[0.368417, 0.506779, 0.709798]], 
                FrameTicks -> {{None, None}, {None, None}}, 
                GridLines -> {None, None}, GridLinesStyle -> Directive[
                  GrayLevel[0.5, 0.4]], ImageSize -> 
                Dynamic[{
                  Automatic, 3.5 CurrentValue["FontCapHeight"]/
                   AbsoluteCurrentValue[Magnification]}], 
                Method -> {
                 "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
                  AbsolutePointSize[6], "ScalingFunctions" -> None, 
                  "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
                    (
                    Part[{{Identity, Identity}, {Identity, Identity}}, 1, 
                    2][#]& )[
                    Part[#, 1]], 
                    (
                    Part[{{Identity, Identity}, {Identity, Identity}}, 2, 
                    2][#]& )[
                    Part[#, 2]]}& ), "CopiedValueFunction" -> ({
                    (
                    Part[{{Identity, Identity}, {Identity, Identity}}, 1, 
                    2][#]& )[
                    Part[#, 1]], 
                    (
                    Part[{{Identity, Identity}, {Identity, Identity}}, 2, 
                    2][#]& )[
                    Part[#, 2]]}& )}}, 
                PlotRange -> {{0., 10.}, {-0.3934107475821282, 
                 0.3794178577062077}}, PlotRangeClipping -> True, 
                PlotRangePadding -> {{
                   Scaled[0.1], 
                   Scaled[0.1]}, {
                   Scaled[0.1], 
                   Scaled[0.1]}}, Ticks -> {Automatic, Automatic}}], 
              GridBox[{{
                 RowBox[{
                   TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                   "\[InvisibleSpace]", 
                   TagBox[
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{"0.`", ",", "10.`"}], "}"}], "}"}], 
                    "SummaryItem"]}]}, {
                 RowBox[{
                   TagBox["\"Output: \"", "SummaryItemAnnotation"], 
                   "\[InvisibleSpace]", 
                   TagBox["\"scalar\"", "SummaryItem"]}]}}, 
               GridBoxAlignment -> {
                "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, AutoDelete -> 
               False, GridBoxItemSize -> {
                "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
               GridBoxSpacings -> {
                "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
               BaseStyle -> {
                ShowStringCharacters -> False, NumberMarks -> False, 
                 PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
            GridBoxAlignment -> {"Rows" -> {{Top}}}, AutoDelete -> False, 
            GridBoxItemSize -> {
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
            BaselinePosition -> {1, 1}], True -> GridBox[{{
              PaneBox[
               ButtonBox[
                DynamicBox[
                 FEPrivate`FrontEndResource[
                 "FEBitmaps", "SquareMinusIconMedium"]], 
                ButtonFunction :> (Typeset`open$$ = False), Appearance -> 
                None, Evaluator -> Automatic, Method -> "Preemptive"], 
               Alignment -> {Center, Center}, ImageSize -> 
               Dynamic[{
                 Automatic, 3.5 CurrentValue["FontCapHeight"]/
                  AbsoluteCurrentValue[Magnification]}]], 
              GraphicsBox[{{{{}, {}, {
                   Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]], 
                   LineBox[CompressedData["
1:eJwB0QMu/CFib1JlAgAAADwAAAACAAAAStFeOa+/hj4AAKcOyL92Pjd0wYnD
3cQ/19s8fgrGtD/SUFjDa77VPyLVm2QDUMU/IqE47Akn4D9S7h4NPdTOP9Wb
k3tZVOU/xtpfzBmF0z+7wbiC/fHqP3teKMCN6dY/gEqXStgX8D9zdZfWYUjY
P7tJtw/c7vI//P6RBIRb1T/ziT6Xnbj1PxIfewFbBJY/2iBupGZS+D8lShXK
6kbUv1rNgu1ZJPs/3KOkwjFd2L+J0D+8VMb9P/mE8Rmkbte/WwqypoYtAEAZ
hRbG8pnUvz63Ng34kwFAUEszvDZb0L94j482beICQMs51oXbe8e/f/LaffdM
BEBab/Dl+0+5vwX2WabgsAVAZlOD8Z/hib/iJK2RzfwGQIGLXQ7vdLE/jN7y
ms9kCECfNFWBgKvDP43DDGfVtAlAz7rMWnhCzT9bMxlR8CALQIxu/jblNNM/
p0NZHGqGDEAMqb32nZvWP0t/barn0w1ADqz1f9z41z+8RXRWej0PQMmzETHL
6tQ/wpunYohHEED5HE8iXH+dP+XkrgoD7RBAy5ZM+uo21L9vc69BiKARQDf4
A7AWoti/pRcaWg9IEkAlnfubburXv0EBfgGh/RJA17cmTTDl1L8cu3sZ4q8T
QPd54AjrstC/oorjEiVWFEDMGPSYlEXIv4+fRJtyChVAz8L3dZAUu78oyg8F
wrIVQCct5jFz8Ji/AMV038BXFkCij21nfbysPz4F00jKChdA6m1Ceewhwj8o
W5uT1bEXQKjF1+8AyMs/ePZcbetmGEBktQxAn4rSP3SniCgDEBlALdFteY3v
1T+vKE5UyrUZQIE67CA6otc/Ue8MD5xpGkBjyu6PlmvVP5/LNatvERtAOlpA
Xw8Mtj9T7VfWTccbQFTahwboPtS/R98Tctt5HEBOch2E++bYv+bmOe9qIB1A
FfdGJzpe2L/rM1n7BNUdQAE/xthkgtW/nJbi6KB9HkBIFdYvAanRv4zJBUfs
Ih9A6gFL1Jxwyr/iQSI0QtYfQJfAnkHMyb+/8mdUAc0+IECbnQdPQ1Smv6ZR
FDB+mSBAPXNSy3kFpz96IyEXh/IgQGTG6FUatMA/JADj7pBFIUCA6zWrKWbK
P4F/IQ6gnyFAiUNtqd3p0T+0CRUesPMhQHekUQGUadU/mjaFdcVOIkBG/t04
91fXP59LQoUyqCJAvmOwSfje1D96a7SFoPsiQGpKUmfzSqs/CC6jzRNWI0CD
CFmrVtvUv2z7RgaIqiNAU6awRaQt2b8yFFD6//8jQLLpxvCfvdi/mc/Uzw==

                    "]]}}}, {}, {}}, {
               DisplayFunction -> Identity, Ticks -> {Automatic, Automatic}, 
                AxesOrigin -> {0, 0}, 
                FrameTicks -> {{None, None}, {None, None}}, 
                GridLines -> {None, None}, DisplayFunction -> Identity, 
                PlotRangePadding -> {{
                   Scaled[0.1], 
                   Scaled[0.1]}, {
                   Scaled[0.1], 
                   Scaled[0.1]}}, PlotRangeClipping -> True, ImagePadding -> 
                All, DisplayFunction -> Identity, AspectRatio -> 1, 
                Axes -> {False, False}, AxesLabel -> {None, None}, 
                AxesOrigin -> {0, 0}, DisplayFunction :> Identity, 
                Frame -> {{True, True}, {True, True}}, 
                FrameLabel -> {{None, None}, {None, None}}, FrameStyle -> 
                Directive[
                  Opacity[0.5], 
                  Thickness[Tiny], 
                  RGBColor[0.368417, 0.506779, 0.709798]], 
                FrameTicks -> {{None, None}, {None, None}}, 
                GridLines -> {None, None}, GridLinesStyle -> Directive[
                  GrayLevel[0.5, 0.4]], ImageSize -> 
                Dynamic[{
                  Automatic, 3.5 CurrentValue["FontCapHeight"]/
                   AbsoluteCurrentValue[Magnification]}], 
                Method -> {
                 "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
                  AbsolutePointSize[6], "ScalingFunctions" -> None, 
                  "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
                    (
                    Part[{{Identity, Identity}, {Identity, Identity}}, 1, 
                    2][#]& )[
                    Part[#, 1]], 
                    (
                    Part[{{Identity, Identity}, {Identity, Identity}}, 2, 
                    2][#]& )[
                    Part[#, 2]]}& ), "CopiedValueFunction" -> ({
                    (
                    Part[{{Identity, Identity}, {Identity, Identity}}, 1, 
                    2][#]& )[
                    Part[#, 1]], 
                    (
                    Part[{{Identity, Identity}, {Identity, Identity}}, 2, 
                    2][#]& )[
                    Part[#, 2]]}& )}}, 
                PlotRange -> {{0., 10.}, {-0.3934107475821282, 
                 0.3794178577062077}}, PlotRangeClipping -> True, 
                PlotRangePadding -> {{
                   Scaled[0.1], 
                   Scaled[0.1]}, {
                   Scaled[0.1], 
                   Scaled[0.1]}}, Ticks -> {Automatic, Automatic}}], 
              GridBox[{{
                 RowBox[{
                   TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                   "\[InvisibleSpace]", 
                   TagBox[
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{"0.`", ",", "10.`"}], "}"}], "}"}], 
                    "SummaryItem"]}]}, {
                 RowBox[{
                   TagBox["\"Output: \"", "SummaryItemAnnotation"], 
                   "\[InvisibleSpace]", 
                   TagBox["\"scalar\"", "SummaryItem"]}]}, {
                 RowBox[{
                   TagBox["\"Order: \"", "SummaryItemAnnotation"], 
                   "\[InvisibleSpace]", 
                   TagBox["3", "SummaryItem"]}]}, {
                 RowBox[{
                   TagBox["\"Method: \"", "SummaryItemAnnotation"], 
                   "\[InvisibleSpace]", 
                   TagBox["\"Hermite\"", "SummaryItem"]}]}, {
                 RowBox[{
                   TagBox["\"Periodic: \"", "SummaryItemAnnotation"], 
                   "\[InvisibleSpace]", 
                   TagBox["False", "SummaryItem"]}]}}, 
               GridBoxAlignment -> {
                "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, AutoDelete -> 
               False, GridBoxItemSize -> {
                "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
               GridBoxSpacings -> {
                "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
               BaseStyle -> {
                ShowStringCharacters -> False, NumberMarks -> False, 
                 PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
            GridBoxAlignment -> {"Rows" -> {{Top}}}, AutoDelete -> False, 
            GridBoxItemSize -> {
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
            BaselinePosition -> {1, 1}]}, 
         Dynamic[Typeset`open$$], ImageSize -> Automatic], BaselinePosition -> 
        Baseline], DynamicModuleValues :> {}], 
      StyleBox["]", "NonInterpretableSummary"]}]},
   "CopyTag",
   DisplayFunction->(#& ),
   InterpretationFunction->("InterpolatingFunction[{{0., 10.}}, <>]"& )],
  False,
  Editable->False,
  SelectWithContents->True,
  Selectable->False]], "Output",
 CellChangeTimes->{3.6832618227585773`*^9, 3.6832629177815523`*^9, 
  3.683262994869301*^9, 3.68373436777111*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"With", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"\[Delta]t", "=", "0.01"}], ",", 
     RowBox[{"nmax", "=", "1000"}]}], "}"}], ",", 
   RowBox[{
    RowBox[{"vxeulercromer", "[", "\[Delta]t", "]"}], "=", 
    RowBox[{"Interpolation", "[", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"n", "*", "\[Delta]t"}], ",", 
         RowBox[{"vx", "[", "n", "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"n", ",", "0", ",", "nmax"}], "}"}]}], "]"}], "]"}]}]}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.683261826974167*^9, 3.683261828223486*^9}, {
  3.683262919239297*^9, 3.683262920007053*^9}, {3.68326299730719*^9, 
  3.6832629985215883`*^9}}],

Cell[BoxData[
 TagBox[
  TemplateBox[{RowBox[{
      StyleBox[
       TagBox["InterpolatingFunction", "SummaryHead"], 
       "NonInterpretableSummary"], 
      StyleBox["[", "NonInterpretableSummary"], 
      DynamicModuleBox[{Typeset`open$$ = False}, 
       PanelBox[
        PaneSelectorBox[{False -> GridBox[{{
              PaneBox[
               ButtonBox[
                DynamicBox[
                 FEPrivate`FrontEndResource[
                 "FEBitmaps", "SquarePlusIconMedium"]], 
                ButtonFunction :> (Typeset`open$$ = True), Appearance -> None,
                 Evaluator -> Automatic, Method -> "Preemptive"], 
               Alignment -> {Center, Center}, ImageSize -> 
               Dynamic[{
                 Automatic, 3.5 CurrentValue["FontCapHeight"]/
                  AbsoluteCurrentValue[Magnification]}]], 
              GraphicsBox[{{{{}, {}, {
                   Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]], 
                   LineBox[CompressedData["
1:eJwB0QMu/CFib1JlAgAAADwAAAACAAAAStFeOa+/hj4AAAo+dL+Gvjd0wYnD
3cQ/zb7vNrv5xL/SUFjDa77VP8dmAKuiRda/IqE47Akn4D9DDGzGWBLhv9Wb
k3tZVOU/g11RBuCd57+7wbiC/fHqP6KMbg0eEPC/gEqXStgX8D+UoYvHpDn1
v7tJtw/c7vI/X40WX3kb/b/ziT6Xnbj1P95A1OW8fK6/2iBupGZS+D9qNnzF
c7v9P1rNgu1ZJPs/YjU0FdjI9T+J0D+8VMb9P2cWOPcCefA/WwqypoYtAEAS
2hILbe3oPz63Ng34kwFADvC8V+y24T94j482beICQCNbCcgmldc/f/LaffdM
BEC3kXAZ03DHPwX2WabgsAVA9l003MXdgD/iJK2RzfwGQBw2f1lMzcO/jN7y
ms9kCEDU+vvopJ/Vv43DDGfVtAlAPzn76iK24L9bMxlR8CALQONHbwXg8+e/
p0NZHGqGDED78caWu0nwv0t/barn0w1A18qZTWON9b+8RXRWej0PQOSLinpd
oP2/wpunYohHEEDZqk6KJerGv+XkrgoD7RBAbrUV8uO0/T9vc69BiKARQMqx
JmE46PU/pRcaWg9IEkAw+5WkF6LwP0EBfgGh/RJAORyZpXeJ6D8cu3sZ4q8T
QBHH46a9duE/oorjEiVWFEBbP7LorEDXP4+fRJtyChVArepA7QsFxz8oyg8F
wrIVQKWPZzwy+I0/AMV038BXFkDK5V6AR93Cvz4F00jKChdAB6ZFBysZ1b8o
W5uT1bEXQPbkGGoIa+C/ePZcbetmGEAAchY99Z7nv3SniCgDEBlA1gTrpg64
77+vKE5UyrUZQDarL99y/vS/Ue8MD5xpGkA+kexz2ez8v5/LNatvERtAYlSk
e/v87r9T7VfWTccbQB1vpmIulv0/R98Tctt5HEBT8lg7w/T1P+bmOe9qIB1A
bFk64li98D/rM1n7BNUdQE4Ef3p/0Og/nJbi6KB9HkCLJOR7DBviP4zJBUfs
Ih9Am3h85h2M2D/iQSI0QtYfQN+CGti7qsk/8mdUAc0+IEAYKG2CCYCiP6ZR
FDB+mSBAS3x1ncspwr96IyEXh/IgQLzRxe1MstS/JADj7pBFIUDNwaD7EzHg
v4F/IQ6gnyFAvtg0Q+Bd57+0CRUesPMhQIBWGfUebe+/mjaFdcVOIkCFQ/bt
sHT1v59LQoUyqCJAvXXYyDWl/b96a7SFoPsiQBPJSzPTvuG/CC6jzRNWI0BN
1e6p0gH9P2z7RgaIqiNAFyco3N3u9T8yFFD6//8jQDRXj+VApvA/mZHdaw==

                    "]]}}}, {}, {}}, {
               DisplayFunction -> Identity, Ticks -> {Automatic, Automatic}, 
                AxesOrigin -> {0, 0}, 
                FrameTicks -> {{None, None}, {None, None}}, 
                GridLines -> {None, None}, DisplayFunction -> Identity, 
                PlotRangePadding -> {{
                   Scaled[0.1], 
                   Scaled[0.1]}, {
                   Scaled[0.1], 
                   Scaled[0.1]}}, PlotRangeClipping -> True, ImagePadding -> 
                All, DisplayFunction -> Identity, AspectRatio -> 1, 
                Axes -> {False, False}, AxesLabel -> {None, None}, 
                AxesOrigin -> {0, 0}, DisplayFunction :> Identity, 
                Frame -> {{True, True}, {True, True}}, 
                FrameLabel -> {{None, None}, {None, None}}, FrameStyle -> 
                Directive[
                  Opacity[0.5], 
                  Thickness[Tiny], 
                  RGBColor[0.368417, 0.506779, 0.709798]], 
                FrameTicks -> {{None, None}, {None, None}}, 
                GridLines -> {None, None}, GridLinesStyle -> Directive[
                  GrayLevel[0.5, 0.4]], ImageSize -> 
                Dynamic[{
                  Automatic, 3.5 CurrentValue["FontCapHeight"]/
                   AbsoluteCurrentValue[Magnification]}], 
                Method -> {
                 "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
                  AbsolutePointSize[6], "ScalingFunctions" -> None, 
                  "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
                    (
                    Part[{{Identity, Identity}, {Identity, Identity}}, 1, 
                    2][#]& )[
                    Part[#, 1]], 
                    (
                    Part[{{Identity, Identity}, {Identity, Identity}}, 2, 
                    2][#]& )[
                    Part[#, 2]]}& ), "CopiedValueFunction" -> ({
                    (
                    Part[{{Identity, Identity}, {Identity, Identity}}, 1, 
                    2][#]& )[
                    Part[#, 1]], 
                    (
                    Part[{{Identity, Identity}, {Identity, Identity}}, 2, 
                    2][#]& )[
                    Part[#, 2]]}& )}}, 
                PlotRange -> {{0., 10.}, {-1.8528344960717356`, 
                 1.858264705111106}}, PlotRangeClipping -> True, 
                PlotRangePadding -> {{
                   Scaled[0.1], 
                   Scaled[0.1]}, {
                   Scaled[0.1], 
                   Scaled[0.1]}}, Ticks -> {Automatic, Automatic}}], 
              GridBox[{{
                 RowBox[{
                   TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                   "\[InvisibleSpace]", 
                   TagBox[
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{"0.`", ",", "10.`"}], "}"}], "}"}], 
                    "SummaryItem"]}]}, {
                 RowBox[{
                   TagBox["\"Output: \"", "SummaryItemAnnotation"], 
                   "\[InvisibleSpace]", 
                   TagBox["\"scalar\"", "SummaryItem"]}]}}, 
               GridBoxAlignment -> {
                "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, AutoDelete -> 
               False, GridBoxItemSize -> {
                "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
               GridBoxSpacings -> {
                "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
               BaseStyle -> {
                ShowStringCharacters -> False, NumberMarks -> False, 
                 PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
            GridBoxAlignment -> {"Rows" -> {{Top}}}, AutoDelete -> False, 
            GridBoxItemSize -> {
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
            BaselinePosition -> {1, 1}], True -> GridBox[{{
              PaneBox[
               ButtonBox[
                DynamicBox[
                 FEPrivate`FrontEndResource[
                 "FEBitmaps", "SquareMinusIconMedium"]], 
                ButtonFunction :> (Typeset`open$$ = False), Appearance -> 
                None, Evaluator -> Automatic, Method -> "Preemptive"], 
               Alignment -> {Center, Center}, ImageSize -> 
               Dynamic[{
                 Automatic, 3.5 CurrentValue["FontCapHeight"]/
                  AbsoluteCurrentValue[Magnification]}]], 
              GraphicsBox[{{{{}, {}, {
                   Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]], 
                   LineBox[CompressedData["
1:eJwB0QMu/CFib1JlAgAAADwAAAACAAAAStFeOa+/hj4AAAo+dL+Gvjd0wYnD
3cQ/zb7vNrv5xL/SUFjDa77VP8dmAKuiRda/IqE47Akn4D9DDGzGWBLhv9Wb
k3tZVOU/g11RBuCd57+7wbiC/fHqP6KMbg0eEPC/gEqXStgX8D+UoYvHpDn1
v7tJtw/c7vI/X40WX3kb/b/ziT6Xnbj1P95A1OW8fK6/2iBupGZS+D9qNnzF
c7v9P1rNgu1ZJPs/YjU0FdjI9T+J0D+8VMb9P2cWOPcCefA/WwqypoYtAEAS
2hILbe3oPz63Ng34kwFADvC8V+y24T94j482beICQCNbCcgmldc/f/LaffdM
BEC3kXAZ03DHPwX2WabgsAVA9l003MXdgD/iJK2RzfwGQBw2f1lMzcO/jN7y
ms9kCEDU+vvopJ/Vv43DDGfVtAlAPzn76iK24L9bMxlR8CALQONHbwXg8+e/
p0NZHGqGDED78caWu0nwv0t/barn0w1A18qZTWON9b+8RXRWej0PQOSLinpd
oP2/wpunYohHEEDZqk6KJerGv+XkrgoD7RBAbrUV8uO0/T9vc69BiKARQMqx
JmE46PU/pRcaWg9IEkAw+5WkF6LwP0EBfgGh/RJAORyZpXeJ6D8cu3sZ4q8T
QBHH46a9duE/oorjEiVWFEBbP7LorEDXP4+fRJtyChVArepA7QsFxz8oyg8F
wrIVQKWPZzwy+I0/AMV038BXFkDK5V6AR93Cvz4F00jKChdAB6ZFBysZ1b8o
W5uT1bEXQPbkGGoIa+C/ePZcbetmGEAAchY99Z7nv3SniCgDEBlA1gTrpg64
77+vKE5UyrUZQDarL99y/vS/Ue8MD5xpGkA+kexz2ez8v5/LNatvERtAYlSk
e/v87r9T7VfWTccbQB1vpmIulv0/R98Tctt5HEBT8lg7w/T1P+bmOe9qIB1A
bFk64li98D/rM1n7BNUdQE4Ef3p/0Og/nJbi6KB9HkCLJOR7DBviP4zJBUfs
Ih9Am3h85h2M2D/iQSI0QtYfQN+CGti7qsk/8mdUAc0+IEAYKG2CCYCiP6ZR
FDB+mSBAS3x1ncspwr96IyEXh/IgQLzRxe1MstS/JADj7pBFIUDNwaD7EzHg
v4F/IQ6gnyFAvtg0Q+Bd57+0CRUesPMhQIBWGfUebe+/mjaFdcVOIkCFQ/bt
sHT1v59LQoUyqCJAvXXYyDWl/b96a7SFoPsiQBPJSzPTvuG/CC6jzRNWI0BN
1e6p0gH9P2z7RgaIqiNAFyco3N3u9T8yFFD6//8jQDRXj+VApvA/mZHdaw==

                    "]]}}}, {}, {}}, {
               DisplayFunction -> Identity, Ticks -> {Automatic, Automatic}, 
                AxesOrigin -> {0, 0}, 
                FrameTicks -> {{None, None}, {None, None}}, 
                GridLines -> {None, None}, DisplayFunction -> Identity, 
                PlotRangePadding -> {{
                   Scaled[0.1], 
                   Scaled[0.1]}, {
                   Scaled[0.1], 
                   Scaled[0.1]}}, PlotRangeClipping -> True, ImagePadding -> 
                All, DisplayFunction -> Identity, AspectRatio -> 1, 
                Axes -> {False, False}, AxesLabel -> {None, None}, 
                AxesOrigin -> {0, 0}, DisplayFunction :> Identity, 
                Frame -> {{True, True}, {True, True}}, 
                FrameLabel -> {{None, None}, {None, None}}, FrameStyle -> 
                Directive[
                  Opacity[0.5], 
                  Thickness[Tiny], 
                  RGBColor[0.368417, 0.506779, 0.709798]], 
                FrameTicks -> {{None, None}, {None, None}}, 
                GridLines -> {None, None}, GridLinesStyle -> Directive[
                  GrayLevel[0.5, 0.4]], ImageSize -> 
                Dynamic[{
                  Automatic, 3.5 CurrentValue["FontCapHeight"]/
                   AbsoluteCurrentValue[Magnification]}], 
                Method -> {
                 "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
                  AbsolutePointSize[6], "ScalingFunctions" -> None, 
                  "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
                    (
                    Part[{{Identity, Identity}, {Identity, Identity}}, 1, 
                    2][#]& )[
                    Part[#, 1]], 
                    (
                    Part[{{Identity, Identity}, {Identity, Identity}}, 2, 
                    2][#]& )[
                    Part[#, 2]]}& ), "CopiedValueFunction" -> ({
                    (
                    Part[{{Identity, Identity}, {Identity, Identity}}, 1, 
                    2][#]& )[
                    Part[#, 1]], 
                    (
                    Part[{{Identity, Identity}, {Identity, Identity}}, 2, 
                    2][#]& )[
                    Part[#, 2]]}& )}}, 
                PlotRange -> {{0., 10.}, {-1.8528344960717356`, 
                 1.858264705111106}}, PlotRangeClipping -> True, 
                PlotRangePadding -> {{
                   Scaled[0.1], 
                   Scaled[0.1]}, {
                   Scaled[0.1], 
                   Scaled[0.1]}}, Ticks -> {Automatic, Automatic}}], 
              GridBox[{{
                 RowBox[{
                   TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                   "\[InvisibleSpace]", 
                   TagBox[
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{"0.`", ",", "10.`"}], "}"}], "}"}], 
                    "SummaryItem"]}]}, {
                 RowBox[{
                   TagBox["\"Output: \"", "SummaryItemAnnotation"], 
                   "\[InvisibleSpace]", 
                   TagBox["\"scalar\"", "SummaryItem"]}]}, {
                 RowBox[{
                   TagBox["\"Order: \"", "SummaryItemAnnotation"], 
                   "\[InvisibleSpace]", 
                   TagBox["3", "SummaryItem"]}]}, {
                 RowBox[{
                   TagBox["\"Method: \"", "SummaryItemAnnotation"], 
                   "\[InvisibleSpace]", 
                   TagBox["\"Hermite\"", "SummaryItem"]}]}, {
                 RowBox[{
                   TagBox["\"Periodic: \"", "SummaryItemAnnotation"], 
                   "\[InvisibleSpace]", 
                   TagBox["False", "SummaryItem"]}]}}, 
               GridBoxAlignment -> {
                "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, AutoDelete -> 
               False, GridBoxItemSize -> {
                "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
               GridBoxSpacings -> {
                "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
               BaseStyle -> {
                ShowStringCharacters -> False, NumberMarks -> False, 
                 PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
            GridBoxAlignment -> {"Rows" -> {{Top}}}, AutoDelete -> False, 
            GridBoxItemSize -> {
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
            BaselinePosition -> {1, 1}]}, 
         Dynamic[Typeset`open$$], ImageSize -> Automatic], BaselinePosition -> 
        Baseline], DynamicModuleValues :> {}], 
      StyleBox["]", "NonInterpretableSummary"]}]},
   "CopyTag",
   DisplayFunction->(#& ),
   InterpretationFunction->("InterpolatingFunction[{{0., 10.}}, <>]"& )],
  False,
  Editable->False,
  SelectWithContents->True,
  Selectable->False]], "Output",
 CellChangeTimes->{3.6832618289771833`*^9, 3.6832618623666773`*^9, 
  3.683262920358979*^9, 3.68326299903203*^9, 3.683734368526845*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"With", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"\[Delta]t", "=", "0.01"}], ",", 
     RowBox[{"nmax", "=", "1000"}]}], "}"}], ",", 
   RowBox[{
    RowBox[{"vyeulercromer", "[", "\[Delta]t", "]"}], "=", 
    RowBox[{"Interpolation", "[", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"n", "*", "\[Delta]t"}], ",", 
         RowBox[{"vy", "[", "n", "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"n", ",", "0", ",", "nmax"}], "}"}]}], "]"}], "]"}]}]}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.683261866543598*^9, 3.6832618689251013`*^9}, {
  3.6832629219051332`*^9, 3.683262922695923*^9}, {3.683263000388074*^9, 
  3.683263001860979*^9}}],

Cell[BoxData[
 TagBox[
  TemplateBox[{RowBox[{
      StyleBox[
       TagBox["InterpolatingFunction", "SummaryHead"], 
       "NonInterpretableSummary"], 
      StyleBox["[", "NonInterpretableSummary"], 
      DynamicModuleBox[{Typeset`open$$ = False}, 
       PanelBox[
        PaneSelectorBox[{False -> GridBox[{{
              PaneBox[
               ButtonBox[
                DynamicBox[
                 FEPrivate`FrontEndResource[
                 "FEBitmaps", "SquarePlusIconMedium"]], 
                ButtonFunction :> (Typeset`open$$ = True), Appearance -> None,
                 Evaluator -> Automatic, Method -> "Preemptive"], 
               Alignment -> {Center, Center}, ImageSize -> 
               Dynamic[{
                 Automatic, 3.5 CurrentValue["FontCapHeight"]/
                  AbsoluteCurrentValue[Magnification]}]], 
              GraphicsBox[{{{{}, {}, {
                   Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]], 
                   
                   LineBox[{{1.694915254237288*^-7, 0.4999999995761562}, {
                    0.16301769472457447`, 0.4928641063931819}, {
                    0.3397473724046566, 0.46860740814961754`}, {
                    0.5047654737182123, 0.42614964950818013`}, {
                    0.6665465749364282, 0.3568633282298372}, {
                    0.8420398286016771, 0.226868495367591}, {
                    1.0058215059003999`, -0.007702016436723764}, {
                    1.1833153356461554`, -0.6799169536650758}, {
                    1.2870600204828861`, -2.3571390473634386`}}], 
                   
                   LineBox[{{1.4260512704633566`, -2.3571390473634386`}, {
                    1.5201174185804605`, -0.7912393939847919}, {
                    1.6963748243113828`, -0.04622731950550618}, {
                    1.8609206536757787`, 0.2074146947782012}, {
                    2.022229482944835, 0.3369685028521589}, {
                    2.1972504646609243`, 0.41839820886343565`}, {
                    2.360559870010487, 0.4635139609419585}, {
                    2.537581427807083, 0.4905005601320584}, {
                    2.711365985508339, 0.49994346204914336`}, {
                    2.873438966843069, 0.49495155113667244`}, {
                    3.0492241006248317`, 0.4733265174155993}, {
                    3.213297658040068, 0.43387711988606137`}, {
                    3.3910833679023376`, 0.3595076625254568}, {
                    3.565632077669267, 0.2286425013328973}, {
                    3.72846921106967, -0.01070712258228511}, {
                    3.9050184969171067`, -0.7150154798628775}, {
                    4.002496441204891, -2.3571390473634386`}}], 
                   
                   LineBox[{{4.138827279380763, -2.3571390473634386`}, {
                    4.231456915783586, -0.8331459011900983}, {
                    4.40676977761619, -0.06973371441498613}, {
                    4.570371063082267, 0.1908382668792949}, {
                    4.747684500995377, 0.3351118613818622}, {
                    4.921760938813147, 0.4158941154449439}, {5.08412580026439,
                     0.4614074017293014}, {5.260202814162667, 
                    0.48933799111002424`}, {5.424568251694417, 
                    0.4998020546688062}, {5.5856966891308275`, 
                    0.4967779873596465}, {5.760537279014271, 
                    0.4775631465358927}, {5.923666292531188, 
                    0.4408352633394341}, {6.100507458495137, 
                    0.37036292281055566`}, {6.265637048092561, 
                    0.2536450042052273}, {6.4275296375946445`, 
                    0.03449623782756344}, {
                    6.603134379543762, -0.5852336502034151}, {
                    6.711455338673049, -2.3571390473634386`}}], 
                   
                   LineBox[{{6.834135116778081, -2.3571390473634386`}, {
                    6.944632863155976, -0.8603259609974278}, {
                    7.119001181090261, -0.08923759089744822}, {
                    7.2816579226580185`, 0.17605683259418503`}, {
                    7.458026816672809, 0.32417405253372705`}, {
                    7.622684134321073, 0.4047972726495109}, {
                    7.784104451873997, 0.4540086941114366}, {
                    7.959236921873954, 0.4854413315916758}, {
                    8.122657815507385, 0.49901507069094514`}, {
                    8.299790861587848, 0.4984117016006247}, {
                    8.473686907572972, 0.4813938734419106}, {8.63587137719157,
                     0.4471167142775351}, {8.811767999257201, 
                    0.38007141569746505`}, {8.975953044956306, 
                    0.26818683647470265`}, {9.153850243102443, 
                    0.024950362963765724`}, {
                    9.32851044115324, -0.6413749036697206}, {
                    9.428653326096482, -2.3571390473634386`}}], 
                   
                   LineBox[{{9.563800759256504, -2.3571390473634386`}, {
                    9.668119836968813, -0.8054244217251056}, {
                    9.83306903473359, -0.10447324722216651`}, {
                    9.999999830508475, 0.16919524371592715`}}]}}}, {}, {}}, {
               DisplayFunction -> Identity, Ticks -> {Automatic, Automatic}, 
                AxesOrigin -> {0, 0}, 
                FrameTicks -> {{None, None}, {None, None}}, 
                GridLines -> {None, None}, DisplayFunction -> Identity, 
                PlotRangePadding -> {{
                   Scaled[0.1], 
                   Scaled[0.1]}, {
                   Scaled[0.1], 
                   Scaled[0.1]}}, PlotRangeClipping -> True, ImagePadding -> 
                All, DisplayFunction -> Identity, AspectRatio -> 1, 
                Axes -> {False, False}, AxesLabel -> {None, None}, 
                AxesOrigin -> {0, 0}, DisplayFunction :> Identity, 
                Frame -> {{True, True}, {True, True}}, 
                FrameLabel -> {{None, None}, {None, None}}, FrameStyle -> 
                Directive[
                  Opacity[0.5], 
                  Thickness[Tiny], 
                  RGBColor[0.368417, 0.506779, 0.709798]], 
                FrameTicks -> {{None, None}, {None, None}}, 
                GridLines -> {None, None}, GridLinesStyle -> Directive[
                  GrayLevel[0.5, 0.4]], ImageSize -> 
                Dynamic[{
                  Automatic, 3.5 CurrentValue["FontCapHeight"]/
                   AbsoluteCurrentValue[Magnification]}], 
                Method -> {
                 "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
                  AbsolutePointSize[6], "ScalingFunctions" -> None, 
                  "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
                    (
                    Part[{{Identity, Identity}, {Identity, Identity}}, 1, 
                    2][#]& )[
                    Part[#, 1]], 
                    (
                    Part[{{Identity, Identity}, {Identity, Identity}}, 2, 
                    2][#]& )[
                    Part[#, 2]]}& ), "CopiedValueFunction" -> ({
                    (
                    Part[{{Identity, Identity}, {Identity, Identity}}, 1, 
                    2][#]& )[
                    Part[#, 1]], 
                    (
                    Part[{{Identity, Identity}, {Identity, Identity}}, 2, 
                    2][#]& )[
                    Part[#, 2]]}& )}}, 
                PlotRange -> {{0., 10.}, {-2.3571390473634386`, 
                 0.4999999995761562}}, PlotRangeClipping -> True, 
                PlotRangePadding -> {{
                   Scaled[0.1], 
                   Scaled[0.1]}, {
                   Scaled[0.1], 
                   Scaled[0.1]}}, Ticks -> {Automatic, Automatic}}], 
              GridBox[{{
                 RowBox[{
                   TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                   "\[InvisibleSpace]", 
                   TagBox[
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{"0.`", ",", "10.`"}], "}"}], "}"}], 
                    "SummaryItem"]}]}, {
                 RowBox[{
                   TagBox["\"Output: \"", "SummaryItemAnnotation"], 
                   "\[InvisibleSpace]", 
                   TagBox["\"scalar\"", "SummaryItem"]}]}}, 
               GridBoxAlignment -> {
                "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, AutoDelete -> 
               False, GridBoxItemSize -> {
                "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
               GridBoxSpacings -> {
                "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
               BaseStyle -> {
                ShowStringCharacters -> False, NumberMarks -> False, 
                 PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
            GridBoxAlignment -> {"Rows" -> {{Top}}}, AutoDelete -> False, 
            GridBoxItemSize -> {
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
            BaselinePosition -> {1, 1}], True -> GridBox[{{
              PaneBox[
               ButtonBox[
                DynamicBox[
                 FEPrivate`FrontEndResource[
                 "FEBitmaps", "SquareMinusIconMedium"]], 
                ButtonFunction :> (Typeset`open$$ = False), Appearance -> 
                None, Evaluator -> Automatic, Method -> "Preemptive"], 
               Alignment -> {Center, Center}, ImageSize -> 
               Dynamic[{
                 Automatic, 3.5 CurrentValue["FontCapHeight"]/
                  AbsoluteCurrentValue[Magnification]}]], 
              GraphicsBox[{{{{}, {}, {
                   Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]], 
                   LineBox[{{1.694915254237288*^-7, 0.4999999995761562}, {
                    0.16301769472457447`, 0.4928641063931819}, {
                    0.3397473724046566, 0.46860740814961754`}, {
                    0.5047654737182123, 0.42614964950818013`}, {
                    0.6665465749364282, 0.3568633282298372}, {
                    0.8420398286016771, 0.226868495367591}, {
                    1.0058215059003999`, -0.007702016436723764}, {
                    1.1833153356461554`, -0.6799169536650758}, {
                    1.2870600204828861`, -2.3571390473634386`}}], 
                   
                   LineBox[{{1.4260512704633566`, -2.3571390473634386`}, {
                    1.5201174185804605`, -0.7912393939847919}, {
                    1.6963748243113828`, -0.04622731950550618}, {
                    1.8609206536757787`, 0.2074146947782012}, {
                    2.022229482944835, 0.3369685028521589}, {
                    2.1972504646609243`, 0.41839820886343565`}, {
                    2.360559870010487, 0.4635139609419585}, {
                    2.537581427807083, 0.4905005601320584}, {
                    2.711365985508339, 0.49994346204914336`}, {
                    2.873438966843069, 0.49495155113667244`}, {
                    3.0492241006248317`, 0.4733265174155993}, {
                    3.213297658040068, 0.43387711988606137`}, {
                    3.3910833679023376`, 0.3595076625254568}, {
                    3.565632077669267, 0.2286425013328973}, {
                    3.72846921106967, -0.01070712258228511}, {
                    3.9050184969171067`, -0.7150154798628775}, {
                    4.002496441204891, -2.3571390473634386`}}], 
                   
                   LineBox[{{4.138827279380763, -2.3571390473634386`}, {
                    4.231456915783586, -0.8331459011900983}, {
                    4.40676977761619, -0.06973371441498613}, {
                    4.570371063082267, 0.1908382668792949}, {
                    4.747684500995377, 0.3351118613818622}, {
                    4.921760938813147, 0.4158941154449439}, {5.08412580026439,
                     0.4614074017293014}, {5.260202814162667, 
                    0.48933799111002424`}, {5.424568251694417, 
                    0.4998020546688062}, {5.5856966891308275`, 
                    0.4967779873596465}, {5.760537279014271, 
                    0.4775631465358927}, {5.923666292531188, 
                    0.4408352633394341}, {6.100507458495137, 
                    0.37036292281055566`}, {6.265637048092561, 
                    0.2536450042052273}, {6.4275296375946445`, 
                    0.03449623782756344}, {
                    6.603134379543762, -0.5852336502034151}, {
                    6.711455338673049, -2.3571390473634386`}}], 
                   
                   LineBox[{{6.834135116778081, -2.3571390473634386`}, {
                    6.944632863155976, -0.8603259609974278}, {
                    7.119001181090261, -0.08923759089744822}, {
                    7.2816579226580185`, 0.17605683259418503`}, {
                    7.458026816672809, 0.32417405253372705`}, {
                    7.622684134321073, 0.4047972726495109}, {
                    7.784104451873997, 0.4540086941114366}, {
                    7.959236921873954, 0.4854413315916758}, {
                    8.122657815507385, 0.49901507069094514`}, {
                    8.299790861587848, 0.4984117016006247}, {
                    8.473686907572972, 0.4813938734419106}, {8.63587137719157,
                     0.4471167142775351}, {8.811767999257201, 
                    0.38007141569746505`}, {8.975953044956306, 
                    0.26818683647470265`}, {9.153850243102443, 
                    0.024950362963765724`}, {
                    9.32851044115324, -0.6413749036697206}, {
                    9.428653326096482, -2.3571390473634386`}}], 
                   
                   LineBox[{{9.563800759256504, -2.3571390473634386`}, {
                    9.668119836968813, -0.8054244217251056}, {
                    9.83306903473359, -0.10447324722216651`}, {
                    9.999999830508475, 0.16919524371592715`}}]}}}, {}, {}}, {
               DisplayFunction -> Identity, Ticks -> {Automatic, Automatic}, 
                AxesOrigin -> {0, 0}, 
                FrameTicks -> {{None, None}, {None, None}}, 
                GridLines -> {None, None}, DisplayFunction -> Identity, 
                PlotRangePadding -> {{
                   Scaled[0.1], 
                   Scaled[0.1]}, {
                   Scaled[0.1], 
                   Scaled[0.1]}}, PlotRangeClipping -> True, ImagePadding -> 
                All, DisplayFunction -> Identity, AspectRatio -> 1, 
                Axes -> {False, False}, AxesLabel -> {None, None}, 
                AxesOrigin -> {0, 0}, DisplayFunction :> Identity, 
                Frame -> {{True, True}, {True, True}}, 
                FrameLabel -> {{None, None}, {None, None}}, FrameStyle -> 
                Directive[
                  Opacity[0.5], 
                  Thickness[Tiny], 
                  RGBColor[0.368417, 0.506779, 0.709798]], 
                FrameTicks -> {{None, None}, {None, None}}, 
                GridLines -> {None, None}, GridLinesStyle -> Directive[
                  GrayLevel[0.5, 0.4]], ImageSize -> 
                Dynamic[{
                  Automatic, 3.5 CurrentValue["FontCapHeight"]/
                   AbsoluteCurrentValue[Magnification]}], 
                Method -> {
                 "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
                  AbsolutePointSize[6], "ScalingFunctions" -> None, 
                  "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
                    (
                    Part[{{Identity, Identity}, {Identity, Identity}}, 1, 
                    2][#]& )[
                    Part[#, 1]], 
                    (
                    Part[{{Identity, Identity}, {Identity, Identity}}, 2, 
                    2][#]& )[
                    Part[#, 2]]}& ), "CopiedValueFunction" -> ({
                    (
                    Part[{{Identity, Identity}, {Identity, Identity}}, 1, 
                    2][#]& )[
                    Part[#, 1]], 
                    (
                    Part[{{Identity, Identity}, {Identity, Identity}}, 2, 
                    2][#]& )[
                    Part[#, 2]]}& )}}, 
                PlotRange -> {{0., 10.}, {-2.3571390473634386`, 
                 0.4999999995761562}}, PlotRangeClipping -> True, 
                PlotRangePadding -> {{
                   Scaled[0.1], 
                   Scaled[0.1]}, {
                   Scaled[0.1], 
                   Scaled[0.1]}}, Ticks -> {Automatic, Automatic}}], 
              GridBox[{{
                 RowBox[{
                   TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                   "\[InvisibleSpace]", 
                   TagBox[
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{"0.`", ",", "10.`"}], "}"}], "}"}], 
                    "SummaryItem"]}]}, {
                 RowBox[{
                   TagBox["\"Output: \"", "SummaryItemAnnotation"], 
                   "\[InvisibleSpace]", 
                   TagBox["\"scalar\"", "SummaryItem"]}]}, {
                 RowBox[{
                   TagBox["\"Order: \"", "SummaryItemAnnotation"], 
                   "\[InvisibleSpace]", 
                   TagBox["3", "SummaryItem"]}]}, {
                 RowBox[{
                   TagBox["\"Method: \"", "SummaryItemAnnotation"], 
                   "\[InvisibleSpace]", 
                   TagBox["\"Hermite\"", "SummaryItem"]}]}, {
                 RowBox[{
                   TagBox["\"Periodic: \"", "SummaryItemAnnotation"], 
                   "\[InvisibleSpace]", 
                   TagBox["False", "SummaryItem"]}]}}, 
               GridBoxAlignment -> {
                "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, AutoDelete -> 
               False, GridBoxItemSize -> {
                "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
               GridBoxSpacings -> {
                "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
               BaseStyle -> {
                ShowStringCharacters -> False, NumberMarks -> False, 
                 PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
            GridBoxAlignment -> {"Rows" -> {{Top}}}, AutoDelete -> False, 
            GridBoxItemSize -> {
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
            BaselinePosition -> {1, 1}]}, 
         Dynamic[Typeset`open$$], ImageSize -> Automatic], BaselinePosition -> 
        Baseline], DynamicModuleValues :> {}], 
      StyleBox["]", "NonInterpretableSummary"]}]},
   "CopyTag",
   DisplayFunction->(#& ),
   InterpretationFunction->("InterpolatingFunction[{{0., 10.}}, <>]"& )],
  False,
  Editable->False,
  SelectWithContents->True,
  Selectable->False]], "Output",
 CellChangeTimes->{3.6832618694225473`*^9, 3.68326292306944*^9, 
  3.683263002322496*^9, 3.6837343693925953`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"With", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\[Delta]t", "=", "0.01"}], "}"}], ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"eulercromerorbit", "[", "\[Delta]t", "]"}], "=", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"ParametricPlot", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"xeulercromer", "[", "\[Delta]t", "]"}], "[", "t", "]"}], 
         ",", 
         RowBox[{
          RowBox[{"yeulercromer", "[", "\[Delta]t", "]"}], "[", "t", "]"}]}], 
        "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", "0", ",", "10"}], "}"}], ",", 
       RowBox[{"AxesLabel", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Style", "[", 
           RowBox[{"\"\<x\>\"", ",", "Black", ",", "15"}], "]"}], ",", 
          RowBox[{"Style", "[", 
           RowBox[{"\"\<y\>\"", ",", "Black", ",", "15"}], "]"}]}], "}"}]}], 
       ",", 
       RowBox[{"PlotStyle", "\[Rule]", "Red"}]}], "]"}], "/.", 
     RowBox[{"Line", "\[Rule]", "Arrow"}]}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.683261910648492*^9, 3.683261942184559*^9}, {
   3.683262161372587*^9, 3.6832621722183123`*^9}, {3.683262249312037*^9, 
   3.683262250143906*^9}, {3.6832629263566647`*^9, 3.683262933733707*^9}, 
   3.683263008281694*^9, {3.683734408148181*^9, 3.683734408813607*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {RGBColor[1, 0, 0], AbsoluteThickness[1.6], Opacity[1.], FaceForm[Opacity[
    0.3]], ArrowBox[CompressedData["
1:eJw0m3c8le8f/4WyIgqFMupjVEgKKXpnhZJSaKjMjNCQRBpmUUYkJbLJzs6+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     "]]}},
  Axes->{True, True},
  AxesLabel->{
    FormBox[
     StyleBox["\"x\"", 
      GrayLevel[0], 15, StripOnInput -> False], TraditionalForm], 
    FormBox[
     StyleBox["\"y\"", 
      GrayLevel[0], 15, StripOnInput -> False], TraditionalForm]},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  Method->{"ScalingFunctions" -> None},
  PlotRange->{{-0.1435957247604875, 
   1.0000118561542863`}, {-0.39645583064230855`, 0.3794193111646992}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.05], 
     Scaled[0.05]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.683261924014382*^9, 3.683261942897002*^9}, 
   3.6832621726793137`*^9, 3.683262250497493*^9, 3.683262668846613*^9, {
   3.6832629315112057`*^9, 3.683262934100917*^9}, 3.683263008821439*^9, 
   3.683734370284844*^9, 3.6837344095010567`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"With", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\[Delta]t", "=", "0.01"}], "}"}], ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"eulercromerenergy", "[", "\[Delta]t", "]"}], "=", 
    "\[IndentingNewLine]", 
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox[
           RowBox[{
            RowBox[{"vxeulercromer", "[", "\[Delta]t", "]"}], "[", "t", "]"}],
            "2"], "+", 
          SuperscriptBox[
           RowBox[{
            RowBox[{"vyeulercromer", "[", "\[Delta]t", "]"}], "[", "t", "]"}],
            "2"]}], ")"}], "/", "2"}], "-", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox[
           RowBox[{
            RowBox[{"xeulercromer", "[", "\[Delta]t", "]"}], "[", "t", "]"}], 
           "2"], "+", 
          SuperscriptBox[
           RowBox[{
            RowBox[{"yeulercromer", "[", "\[Delta]t", "]"}], "[", "t", "]"}], 
           "2"]}], ")"}], 
        RowBox[{
         RowBox[{"-", "1"}], "/", "2"}]]}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "10"}], "}"}], ",", 
      RowBox[{"AxesLabel", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Style", "[", 
          RowBox[{"\"\<time\>\"", ",", "Black", ",", "12"}], "]"}], ",", 
         RowBox[{"Style", "[", 
          RowBox[{"\"\<Energy\>\"", ",", "Black", ",", "12"}], "]"}]}], 
        "}"}]}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", "Red"}], ",", 
      RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.683262030303484*^9, 3.68326207088873*^9}, {
   3.683262182930636*^9, 3.6832621977268*^9}, {3.6832622532398376`*^9, 
   3.683262253746169*^9}, {3.683262937838311*^9, 3.6832629573025303`*^9}, 
   3.683263011891552*^9, {3.683263605091115*^9, 3.68326360584129*^9}, {
   3.683734411983227*^9, 3.683734412415148*^9}}],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    {RGBColor[1, 0, 0], AbsoluteThickness[1.6], Opacity[1.], 
     LineBox[CompressedData["
1:eJwU2Hk8VU8bAHB7dtfys13rrVBJUkLbmQoJSRIt2iTZkpQSKmVJWZJsIVQK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      "]]}}, {}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{
    FormBox[
     StyleBox["\"time\"", 
      GrayLevel[0], 12, StripOnInput -> False], TraditionalForm], 
    FormBox[
     StyleBox["\"Energy\"", 
      GrayLevel[0], 12, StripOnInput -> False], TraditionalForm]},
  AxesOrigin->{0, -1.0664048273265756`},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
         Part[#, 1]], 
        (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
         Part[#, 1]], 
        (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.68326204728004*^9, 3.683262071576764*^9}, 
   3.683262199177944*^9, 3.6832622541502523`*^9, 3.6832626694432077`*^9, {
   3.683262942493267*^9, 3.683262957668511*^9}, 3.683263012396399*^9, 
   3.683263606307487*^9, 3.6837343711722107`*^9, 3.6837344127851887`*^9}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Leapfrog method :", "Section",
 CellChangeTimes->{{3.6832631216800213`*^9, 3.6832631316966553`*^9}, {
  3.683263206038364*^9, 3.683263207957595*^9}, {3.683734371918879*^9, 
  3.683734372875023*^9}}],

Cell[TextData[Cell[BoxData[{
 FormBox[
  RowBox[{
   RowBox[{
    SubscriptBox["x", 
     RowBox[{"n", "+", "1"}]], "=", 
    RowBox[{
     SubscriptBox["x", "n"], "+", 
     RowBox[{
      RowBox[{"[", 
       RowBox[{
        SubscriptBox[
         RowBox[{"(", 
          SubscriptBox["v", "x"], ")"}], "n"], "+", 
        RowBox[{
         RowBox[{
          SubscriptBox["a", "x"], "(", 
          RowBox[{
           SubscriptBox["x", "n"], ",", 
           SubscriptBox["y", "n"]}], ")"}], 
         RowBox[{"\[Delta]t", "/", "2"}]}]}], "]"}], "\[Delta]t"}]}]}], " ", 
   ";"}], TraditionalForm], "\[IndentingNewLine]", 
 FormBox[
  RowBox[{
   RowBox[{
    SubscriptBox["y", 
     RowBox[{"n", "+", "1"}]], "=", 
    RowBox[{
     SubscriptBox["y", "n"], "+", 
     RowBox[{
      RowBox[{"[", 
       RowBox[{
        SubscriptBox[
         RowBox[{"(", 
          SubscriptBox["v", "y"], ")"}], "n"], "+", 
        RowBox[{
         RowBox[{
          SubscriptBox["a", "y"], "(", 
          RowBox[{
           SubscriptBox["x", "n"], ",", 
           SubscriptBox["y", "n"]}], ")"}], 
         RowBox[{"\[Delta]t", "/", "2"}]}]}], "]"}], "\[Delta]t"}]}]}], " ", 
   ";"}], TraditionalForm], "\[IndentingNewLine]", 
 FormBox[
  RowBox[{
   RowBox[{
    SubscriptBox[
     RowBox[{"(", 
      SubscriptBox["v", "x"], ")"}], 
     RowBox[{"n", "+", "1"}]], "=", 
    RowBox[{
     SubscriptBox[
      RowBox[{"(", 
       SubscriptBox["v", "x"], ")"}], "n"], "+", 
     RowBox[{
      RowBox[{"[", 
       RowBox[{
        RowBox[{
         SubscriptBox["a", "x"], "(", 
         RowBox[{
          SubscriptBox["x", "n"], ",", 
          SubscriptBox["y", "n"]}], ")"}], "+", 
        RowBox[{
         SubscriptBox["a", "x"], "(", 
         RowBox[{
          SubscriptBox["x", 
           RowBox[{"n", "+", "1"}]], ",", 
          SubscriptBox["y", 
           RowBox[{"n", "+", "1"}]]}], ")"}]}], "]"}], 
      RowBox[{"\[Delta]t", "/", "2"}]}]}]}], " ", ";"}], 
  TraditionalForm], "\[IndentingNewLine]", 
 FormBox[
  RowBox[{
   RowBox[{
    SubscriptBox[
     RowBox[{"(", 
      SubscriptBox["v", "y"], ")"}], 
     RowBox[{"n", "+", "1"}]], "=", 
    RowBox[{
     SubscriptBox[
      RowBox[{"(", 
       SubscriptBox["v", "y"], ")"}], "n"], "+", 
     RowBox[{
      RowBox[{"[", 
       RowBox[{
        RowBox[{
         SubscriptBox["a", "y"], "(", 
         RowBox[{
          SubscriptBox["x", "n"], ",", 
          SubscriptBox["y", "n"]}], ")"}], "+", 
        RowBox[{
         SubscriptBox["a", "y"], "(", 
         RowBox[{
          SubscriptBox["x", 
           RowBox[{"n", "+", "1"}]], ",", 
          SubscriptBox["y", 
           RowBox[{"n", "+", "1"}]]}], ")"}]}], "]"}], 
      RowBox[{"\[Delta]t", "/", "2"}]}]}]}], " ", ";"}], 
  TraditionalForm]}]]], "ItemParagraph",
 CellChangeTimes->{{3.683734032952615*^9, 3.6837340747700644`*^9}},
 FontSize->18],

Cell[CellGroupData[{

Cell[TextData[{
 "1. Error in each step ~ ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Delta]t", "3"], TraditionalForm]],
  FormatType->"TraditionalForm"],
 ". II. Symplectic -- conserves energy."
}], "Subsubsection",
 CellChangeTimes->{{3.683736344121768*^9, 3.683736371652337*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AbsoluteTiming", "[", "\[IndentingNewLine]", 
  RowBox[{"With", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"\[Delta]t", "=", "0.01"}], ",", 
      RowBox[{"nmax", "=", "1000"}]}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "[", "0", "]"}], "=", "1"}], ";", 
     RowBox[{
      RowBox[{"y", "[", "0", "]"}], "=", "0"}], ";", 
     RowBox[{
      RowBox[{"vx", "[", "0", "]"}], "=", "0"}], ";", 
     RowBox[{
      RowBox[{"vy", "[", "0", "]"}], "=", "0.5"}], ";", "\[IndentingNewLine]", 
     RowBox[{"Do", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"x", "[", 
          RowBox[{"n", "+", "1"}], "]"}], "=", 
         RowBox[{
          RowBox[{"x", "[", "n", "]"}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"vx", "[", "n", "]"}], "+", 
             RowBox[{
              RowBox[{"ax", "[", 
               RowBox[{
                RowBox[{"x", "[", "n", "]"}], ",", 
                RowBox[{"y", "[", "n", "]"}]}], "]"}], "*", 
              RowBox[{"\[Delta]t", "/", "2"}]}]}], ")"}], "*", 
           "\[Delta]t"}]}]}], ";", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"y", "[", 
          RowBox[{"n", "+", "1"}], "]"}], "=", 
         RowBox[{
          RowBox[{"y", "[", "n", "]"}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"vy", "[", "n", "]"}], "+", 
             RowBox[{
              RowBox[{"ay", "[", 
               RowBox[{
                RowBox[{"x", "[", "n", "]"}], ",", 
                RowBox[{"y", "[", "n", "]"}]}], "]"}], "*", 
              RowBox[{"\[Delta]t", "/", "2"}]}]}], ")"}], "*", 
           "\[Delta]t"}]}]}], ";", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"vx", "[", 
          RowBox[{"n", "+", "1"}], "]"}], "=", 
         RowBox[{
          RowBox[{"vx", "[", "n", "]"}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"ax", "[", 
              RowBox[{
               RowBox[{"x", "[", "n", "]"}], ",", 
               RowBox[{"y", "[", "n", "]"}]}], "]"}], "+", 
             RowBox[{"ax", "[", 
              RowBox[{
               RowBox[{"x", "[", 
                RowBox[{"n", "+", "1"}], "]"}], ",", 
               RowBox[{"y", "[", 
                RowBox[{"n", "+", "1"}], "]"}]}], "]"}]}], ")"}], "*", 
           RowBox[{"\[Delta]t", "/", "2"}]}]}]}], ";", "\[IndentingNewLine]", 
        
        RowBox[{
         RowBox[{"vy", "[", 
          RowBox[{"n", "+", "1"}], "]"}], "=", 
         RowBox[{
          RowBox[{"vy", "[", "n", "]"}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"ay", "[", 
              RowBox[{
               RowBox[{"x", "[", "n", "]"}], ",", 
               RowBox[{"y", "[", "n", "]"}]}], "]"}], "+", 
             RowBox[{"ay", "[", 
              RowBox[{
               RowBox[{"x", "[", 
                RowBox[{"n", "+", "1"}], "]"}], ",", 
               RowBox[{"y", "[", 
                RowBox[{"n", "+", "1"}], "]"}]}], "]"}]}], ")"}], "*", 
           RowBox[{"\[Delta]t", "/", "2"}]}]}]}], ";"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{"n", ",", "0", ",", "nmax"}], "}"}]}], "]"}]}]}], "]"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.6832616421061897`*^9, 3.683261653127754*^9}, {
   3.6832616894584627`*^9, 3.683261693990344*^9}, {3.6832623584074383`*^9, 
   3.683262413111423*^9}, 3.683262446746519*^9, {3.6832632204112988`*^9, 
   3.683263247386594*^9}, {3.6832633623926363`*^9, 3.6832633639169807`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.047525`", ",", "Null"}], "}"}]], "Output",
 CellChangeTimes->{{3.6832616684529467`*^9, 3.683261695110804*^9}, 
   3.683262567499547*^9, 3.683263265506811*^9, 3.683263364416881*^9, 
   3.683734374855276*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"With", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"\[Delta]t", "=", "0.01"}], ",", 
     RowBox[{"nmax", "=", "1000"}]}], "}"}], ",", 
   RowBox[{
    RowBox[{"xleapfrog", "[", "\[Delta]t", "]"}], "=", 
    RowBox[{"Interpolation", "[", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"n", "*", "\[Delta]t"}], ",", 
         RowBox[{"x", "[", "n", "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"n", ",", "0", ",", "nmax"}], "}"}]}], "]"}], "]"}]}]}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.683261683469326*^9, 3.683261751804677*^9}, {
  3.683262584384863*^9, 3.683262585107813*^9}, {3.683263269578083*^9, 
  3.683263271456411*^9}, {3.683263365950592*^9, 3.683263367130205*^9}}],

Cell[BoxData[
 TagBox[
  TemplateBox[{RowBox[{
      StyleBox[
       TagBox["InterpolatingFunction", "SummaryHead"], 
       "NonInterpretableSummary"], 
      StyleBox["[", "NonInterpretableSummary"], 
      DynamicModuleBox[{Typeset`open$$ = False}, 
       PanelBox[
        PaneSelectorBox[{False -> GridBox[{{
              PaneBox[
               ButtonBox[
                DynamicBox[
                 FEPrivate`FrontEndResource[
                 "FEBitmaps", "SquarePlusIconMedium"]], 
                ButtonFunction :> (Typeset`open$$ = True), Appearance -> None,
                 Evaluator -> Automatic, Method -> "Preemptive"], 
               Alignment -> {Center, Center}, ImageSize -> 
               Dynamic[{
                 Automatic, 3.5 CurrentValue["FontCapHeight"]/
                  AbsoluteCurrentValue[Magnification]}]], 
              GraphicsBox[{{{{}, {}, {
                   Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]], 
                   LineBox[CompressedData["
1:eJwB0QMu/CFib1JlAgAAADwAAAACAAAAStFeOa+/hj6h/f/////vPzd0wYnD
3cQ/JjyhCdmS7z/SUFjDa77VP+UT0VBgIe4/IqE47Akn4D+XOOciBc/rP9Wb
k3tZVOU/+4wJ0I2G6D+7wbiC/fHqP9vGbeFLp+M/gEqXStgX8D8sXow9jSXb
P7tJtw/c7vI/fpFk0eG+wj/ziT6Xnbj1PxSqDCMPX8K/2iBupGZS+D971O9Z
I6K/P1rNgu1ZJPs/zVDAfOHd2T+J0D+8VMb9P56G/2PJKuM/WwqypoYtAECF
4cbng83nPz63Ng34kwFAfOIjUSuD6z94j482beICQAO4hIhP6e0/f/LaffdM
BEDBoPEin3fvPwX2WabgsAVAnIp6ZFT/7z/iJK2RzfwGQMNOZu1Knu8/jN7y
ms9kCEAruPYinDzuP43DDGfVtAlAvj+pa/H76z9bMxlR8CALQE8lAvCbYeg/
p0NZHGqGDEA8CoLSmXfjP0t/barn0w1AlKelgXyq2j+8RXRWej0PQI9u/pp0
XsE/wpunYohHEEBjMTFUF1zCv+XkrgoD7RBAbQxDmS6AvT9vc69BiKARQOxc
UQH0SNk/pRcaWg9IEkBNc8p9++LiP0EBfgGh/RJApzrjGpf45z8cu3sZ4q8T
QEu/VToDm+s/oorjEiVWFEA9/2ptAfXtP4+fRJtyChVA9h6Gdxx77z8oyg8F
wrIVQCRrVAqN/e8/AMV038BXFkDfjjNGEqbvPz4F00jKChdAd2YgjVZR7j8o
W5uT1bEXQDmd0p+FH+w/ePZcbetmGECUk/yEIJjoP3SniCgDEBlAF5m820IK
5D+vKE5UyrUZQMK3pU7wMtw/Ue8MD5xpGkC628QsS4zFP5/LNatvERtARieO
SmQywb9T7VfWTccbQLWlc0cPPbw/R98Tctt5HECQtw9YCdzYP+bmOe9qIB1A
r2mLCNmp4j/rM1n7BNUdQH+xqviHw+c/nJbi6KB9HkAokhH9L0frP4zJBUfs
Ih9AzvhH2iO47T/iQSI0QtYfQCRB6htWWe8/8mdUAc0+IEBQ8/MsIvfvP6ZR
FDB+mSBA87tFroKq7z96IyEXh/IgQGGCWZnsX+4/JADj7pBFIUBX3wbIKDrs
P4F/IQ6gnyFA+3bXuFDC6D+0CRUesPMhQMSBLXl9RuQ/mjaFdcVOIkDJqYMk
b2fbP59LQoUyqCJAvh6gBg1Qwz96a7SFoPsiQK71CRN2E8K/CC6jzRNWI0AO
UM58MMe/P2z7RgaIqiNAJYgilmuX2D8yFFD6//8jQM9U3TxBrOI/oEjK1w==

                    "]]}}}, {}, {}}, {
               DisplayFunction -> Identity, Ticks -> {Automatic, Automatic}, 
                AxesOrigin -> {0, 0}, 
                FrameTicks -> {{None, None}, {None, None}}, 
                GridLines -> {None, None}, DisplayFunction -> Identity, 
                PlotRangePadding -> {{
                   Scaled[0.1], 
                   Scaled[0.1]}, {
                   Scaled[0.1], 
                   Scaled[0.1]}}, PlotRangeClipping -> True, ImagePadding -> 
                All, DisplayFunction -> Identity, AspectRatio -> 1, 
                Axes -> {False, False}, AxesLabel -> {None, None}, 
                AxesOrigin -> {0, 0}, DisplayFunction :> Identity, 
                Frame -> {{True, True}, {True, True}}, 
                FrameLabel -> {{None, None}, {None, None}}, FrameStyle -> 
                Directive[
                  Opacity[0.5], 
                  Thickness[Tiny], 
                  RGBColor[0.368417, 0.506779, 0.709798]], 
                FrameTicks -> {{None, None}, {None, None}}, 
                GridLines -> {None, None}, GridLinesStyle -> Directive[
                  GrayLevel[0.5, 0.4]], ImageSize -> 
                Dynamic[{
                  Automatic, 3.5 CurrentValue["FontCapHeight"]/
                   AbsoluteCurrentValue[Magnification]}], 
                Method -> {
                 "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
                  AbsolutePointSize[6], "ScalingFunctions" -> None, 
                  "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
                    (
                    Part[{{Identity, Identity}, {Identity, Identity}}, 1, 
                    2][#]& )[
                    Part[#, 1]], 
                    (
                    Part[{{Identity, Identity}, {Identity, Identity}}, 2, 
                    2][#]& )[
                    Part[#, 2]]}& ), "CopiedValueFunction" -> ({
                    (
                    Part[{{Identity, Identity}, {Identity, Identity}}, 1, 
                    2][#]& )[
                    Part[#, 1]], 
                    (
                    Part[{{Identity, Identity}, {Identity, Identity}}, 2, 
                    2][#]& )[
                    Part[#, 2]]}& )}}, 
                PlotRange -> {{0., 10.}, {-0.14352597438239967`, 
                 0.9999999999999326}}, PlotRangeClipping -> True, 
                PlotRangePadding -> {{
                   Scaled[0.1], 
                   Scaled[0.1]}, {
                   Scaled[0.1], 
                   Scaled[0.1]}}, Ticks -> {Automatic, Automatic}}], 
              GridBox[{{
                 RowBox[{
                   TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                   "\[InvisibleSpace]", 
                   TagBox[
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{"0.`", ",", "10.`"}], "}"}], "}"}], 
                    "SummaryItem"]}]}, {
                 RowBox[{
                   TagBox["\"Output: \"", "SummaryItemAnnotation"], 
                   "\[InvisibleSpace]", 
                   TagBox["\"scalar\"", "SummaryItem"]}]}}, 
               GridBoxAlignment -> {
                "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, AutoDelete -> 
               False, GridBoxItemSize -> {
                "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
               GridBoxSpacings -> {
                "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
               BaseStyle -> {
                ShowStringCharacters -> False, NumberMarks -> False, 
                 PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
            GridBoxAlignment -> {"Rows" -> {{Top}}}, AutoDelete -> False, 
            GridBoxItemSize -> {
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
            BaselinePosition -> {1, 1}], True -> GridBox[{{
              PaneBox[
               ButtonBox[
                DynamicBox[
                 FEPrivate`FrontEndResource[
                 "FEBitmaps", "SquareMinusIconMedium"]], 
                ButtonFunction :> (Typeset`open$$ = False), Appearance -> 
                None, Evaluator -> Automatic, Method -> "Preemptive"], 
               Alignment -> {Center, Center}, ImageSize -> 
               Dynamic[{
                 Automatic, 3.5 CurrentValue["FontCapHeight"]/
                  AbsoluteCurrentValue[Magnification]}]], 
              GraphicsBox[{{{{}, {}, {
                   Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]], 
                   LineBox[CompressedData["
1:eJwB0QMu/CFib1JlAgAAADwAAAACAAAAStFeOa+/hj6h/f/////vPzd0wYnD
3cQ/JjyhCdmS7z/SUFjDa77VP+UT0VBgIe4/IqE47Akn4D+XOOciBc/rP9Wb
k3tZVOU/+4wJ0I2G6D+7wbiC/fHqP9vGbeFLp+M/gEqXStgX8D8sXow9jSXb
P7tJtw/c7vI/fpFk0eG+wj/ziT6Xnbj1PxSqDCMPX8K/2iBupGZS+D971O9Z
I6K/P1rNgu1ZJPs/zVDAfOHd2T+J0D+8VMb9P56G/2PJKuM/WwqypoYtAECF
4cbng83nPz63Ng34kwFAfOIjUSuD6z94j482beICQAO4hIhP6e0/f/LaffdM
BEDBoPEin3fvPwX2WabgsAVAnIp6ZFT/7z/iJK2RzfwGQMNOZu1Knu8/jN7y
ms9kCEAruPYinDzuP43DDGfVtAlAvj+pa/H76z9bMxlR8CALQE8lAvCbYeg/
p0NZHGqGDEA8CoLSmXfjP0t/barn0w1AlKelgXyq2j+8RXRWej0PQI9u/pp0
XsE/wpunYohHEEBjMTFUF1zCv+XkrgoD7RBAbQxDmS6AvT9vc69BiKARQOxc
UQH0SNk/pRcaWg9IEkBNc8p9++LiP0EBfgGh/RJApzrjGpf45z8cu3sZ4q8T
QEu/VToDm+s/oorjEiVWFEA9/2ptAfXtP4+fRJtyChVA9h6Gdxx77z8oyg8F
wrIVQCRrVAqN/e8/AMV038BXFkDfjjNGEqbvPz4F00jKChdAd2YgjVZR7j8o
W5uT1bEXQDmd0p+FH+w/ePZcbetmGECUk/yEIJjoP3SniCgDEBlAF5m820IK
5D+vKE5UyrUZQMK3pU7wMtw/Ue8MD5xpGkC628QsS4zFP5/LNatvERtARieO
SmQywb9T7VfWTccbQLWlc0cPPbw/R98Tctt5HECQtw9YCdzYP+bmOe9qIB1A
r2mLCNmp4j/rM1n7BNUdQH+xqviHw+c/nJbi6KB9HkAokhH9L0frP4zJBUfs
Ih9AzvhH2iO47T/iQSI0QtYfQCRB6htWWe8/8mdUAc0+IEBQ8/MsIvfvP6ZR
FDB+mSBA87tFroKq7z96IyEXh/IgQGGCWZnsX+4/JADj7pBFIUBX3wbIKDrs
P4F/IQ6gnyFA+3bXuFDC6D+0CRUesPMhQMSBLXl9RuQ/mjaFdcVOIkDJqYMk
b2fbP59LQoUyqCJAvh6gBg1Qwz96a7SFoPsiQK71CRN2E8K/CC6jzRNWI0AO
UM58MMe/P2z7RgaIqiNAJYgilmuX2D8yFFD6//8jQM9U3TxBrOI/oEjK1w==

                    "]]}}}, {}, {}}, {
               DisplayFunction -> Identity, Ticks -> {Automatic, Automatic}, 
                AxesOrigin -> {0, 0}, 
                FrameTicks -> {{None, None}, {None, None}}, 
                GridLines -> {None, None}, DisplayFunction -> Identity, 
                PlotRangePadding -> {{
                   Scaled[0.1], 
                   Scaled[0.1]}, {
                   Scaled[0.1], 
                   Scaled[0.1]}}, PlotRangeClipping -> True, ImagePadding -> 
                All, DisplayFunction -> Identity, AspectRatio -> 1, 
                Axes -> {False, False}, AxesLabel -> {None, None}, 
                AxesOrigin -> {0, 0}, DisplayFunction :> Identity, 
                Frame -> {{True, True}, {True, True}}, 
                FrameLabel -> {{None, None}, {None, None}}, FrameStyle -> 
                Directive[
                  Opacity[0.5], 
                  Thickness[Tiny], 
                  RGBColor[0.368417, 0.506779, 0.709798]], 
                FrameTicks -> {{None, None}, {None, None}}, 
                GridLines -> {None, None}, GridLinesStyle -> Directive[
                  GrayLevel[0.5, 0.4]], ImageSize -> 
                Dynamic[{
                  Automatic, 3.5 CurrentValue["FontCapHeight"]/
                   AbsoluteCurrentValue[Magnification]}], 
                Method -> {
                 "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
                  AbsolutePointSize[6], "ScalingFunctions" -> None, 
                  "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
                    (
                    Part[{{Identity, Identity}, {Identity, Identity}}, 1, 
                    2][#]& )[
                    Part[#, 1]], 
                    (
                    Part[{{Identity, Identity}, {Identity, Identity}}, 2, 
                    2][#]& )[
                    Part[#, 2]]}& ), "CopiedValueFunction" -> ({
                    (
                    Part[{{Identity, Identity}, {Identity, Identity}}, 1, 
                    2][#]& )[
                    Part[#, 1]], 
                    (
                    Part[{{Identity, Identity}, {Identity, Identity}}, 2, 
                    2][#]& )[
                    Part[#, 2]]}& )}}, 
                PlotRange -> {{0., 10.}, {-0.14352597438239967`, 
                 0.9999999999999326}}, PlotRangeClipping -> True, 
                PlotRangePadding -> {{
                   Scaled[0.1], 
                   Scaled[0.1]}, {
                   Scaled[0.1], 
                   Scaled[0.1]}}, Ticks -> {Automatic, Automatic}}], 
              GridBox[{{
                 RowBox[{
                   TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                   "\[InvisibleSpace]", 
                   TagBox[
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{"0.`", ",", "10.`"}], "}"}], "}"}], 
                    "SummaryItem"]}]}, {
                 RowBox[{
                   TagBox["\"Output: \"", "SummaryItemAnnotation"], 
                   "\[InvisibleSpace]", 
                   TagBox["\"scalar\"", "SummaryItem"]}]}, {
                 RowBox[{
                   TagBox["\"Order: \"", "SummaryItemAnnotation"], 
                   "\[InvisibleSpace]", 
                   TagBox["3", "SummaryItem"]}]}, {
                 RowBox[{
                   TagBox["\"Method: \"", "SummaryItemAnnotation"], 
                   "\[InvisibleSpace]", 
                   TagBox["\"Hermite\"", "SummaryItem"]}]}, {
                 RowBox[{
                   TagBox["\"Periodic: \"", "SummaryItemAnnotation"], 
                   "\[InvisibleSpace]", 
                   TagBox["False", "SummaryItem"]}]}}, 
               GridBoxAlignment -> {
                "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, AutoDelete -> 
               False, GridBoxItemSize -> {
                "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
               GridBoxSpacings -> {
                "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
               BaseStyle -> {
                ShowStringCharacters -> False, NumberMarks -> False, 
                 PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
            GridBoxAlignment -> {"Rows" -> {{Top}}}, AutoDelete -> False, 
            GridBoxItemSize -> {
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
            BaselinePosition -> {1, 1}]}, 
         Dynamic[Typeset`open$$], ImageSize -> Automatic], BaselinePosition -> 
        Baseline], DynamicModuleValues :> {}], 
      StyleBox["]", "NonInterpretableSummary"]}]},
   "CopyTag",
   DisplayFunction->(#& ),
   InterpretationFunction->("InterpolatingFunction[{{0., 10.}}, <>]"& )],
  False,
  Editable->False,
  SelectWithContents->True,
  Selectable->False]], "Output",
 CellChangeTimes->{3.683261758976274*^9, 3.68326180355539*^9, 
  3.683262591558687*^9, 3.683263281293885*^9, 3.683263367547531*^9, 
  3.68373437572155*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"With", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"\[Delta]t", "=", "0.01"}], ",", 
     RowBox[{"nmax", "=", "1000"}]}], "}"}], ",", 
   RowBox[{
    RowBox[{"yleapfrog", "[", "\[Delta]t", "]"}], "=", 
    RowBox[{"Interpolation", "[", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"n", "*", "\[Delta]t"}], ",", 
         RowBox[{"y", "[", "n", "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"n", ",", "0", ",", "nmax"}], "}"}]}], "]"}], "]"}]}]}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.683261816267932*^9, 3.6832618184219007`*^9}, {
  3.6832625937369556`*^9, 3.683262594270892*^9}, {3.683263284849998*^9, 
  3.683263285242978*^9}, {3.683263368804101*^9, 3.683263370019414*^9}}],

Cell[BoxData[
 TagBox[
  TemplateBox[{RowBox[{
      StyleBox[
       TagBox["InterpolatingFunction", "SummaryHead"], 
       "NonInterpretableSummary"], 
      StyleBox["[", "NonInterpretableSummary"], 
      DynamicModuleBox[{Typeset`open$$ = False}, 
       PanelBox[
        PaneSelectorBox[{False -> GridBox[{{
              PaneBox[
               ButtonBox[
                DynamicBox[
                 FEPrivate`FrontEndResource[
                 "FEBitmaps", "SquarePlusIconMedium"]], 
                ButtonFunction :> (Typeset`open$$ = True), Appearance -> None,
                 Evaluator -> Automatic, Method -> "Preemptive"], 
               Alignment -> {Center, Center}, ImageSize -> 
               Dynamic[{
                 Automatic, 3.5 CurrentValue["FontCapHeight"]/
                  AbsoluteCurrentValue[Magnification]}]], 
              GraphicsBox[{{{{}, {}, {
                   Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]], 
                   LineBox[CompressedData["
1:eJwB0QMu/CFib1JlAgAAADwAAAACAAAAStFeOa+/hj4AAMkLyL92Pjd0wYnD
3cQ/fCEFAgPGtD/SUFjDa77VPwglNMG4T8U/IqE47Akn4D8p32mcr9LOP9Wb
k3tZVOU/w4n1zWeC0z+7wbiC/fHqP6FOylgJ4dY/gEqXStgX8D86TlREvDDY
P7tJtw/c7vI/xGZ/jzUK1T/ziT6Xnbj1P7il0VflaFe/2iBupGZS+D9l5U83
6qXUv1rNgu1ZJPs/be9zOLx42L+J0D+8VMb9P5BPg7i/eNe/WwqypoYtAEBk
121bop3Uvz63Ng34kwFAjELtdDVc0L94j482beICQKZr85kBfMe/f/LaffdM
BEAouSSR0U65vwX2WabgsAVAfvwr53LSib/iJK2RzfwGQG0izRVld7E/jN7y
ms9kCEDeOD89x6zDP43DDGfVtAlAXakfztRCzT9bMxlR8CALQJo3KtMUM9M/
p0NZHGqGDEDF0S1/1ZPWP0t/barn0w1AKSS8sEvh1z+8RXRWej0PQAAGDPue
ldQ/wpunYohHEEAaUDXI2n13P+XkrgoD7RBAV3A7iOGa1L9vc69BiKARQLww
OrTJv9i/pRcaWg9IEkCWpPVHtPXXv0EBfgGh/RJAZwfzhwrp1L8cu3sZ4q8T
QBHvTYXys9C/oorjEiVWFEBO/5yIdkXIv4+fRJtyChVAbpo7tSASu78oyg8F
wrIVQEp5lb9M4Zi/AMV038BXFkD0hepeZMasPz4F00jKChdA6R4wM8Qkwj8o
W5uT1bEXQEq82TJDyss/ePZcbetmGEB45h4X/onSP3SniCgDEBlAZDG8Qcjp
1T+vKE5UyrUZQILKkS5Zjtc/Ue8MD5xpGkBLownPOyLVP5/LNatvERtAEsjX
adSFsD9T7VfWTccbQN+fRQ1uptS/R98Tctt5HEBChQkokQbZv+bmOe9qIB1A
dz2qOZdq2L/rM1n7BNUdQGdf7EbMhtW/nJbi6KB9HkAI/bUPU6rRv4zJBUfs
Ih9AuU9J4ndwyr/iQSI0QtYfQF0XuTNbxr+/8mdUAc0+IEC6meTQRUmmv6ZR
FDB+mSBAfH+APWUUpz96IyEXh/IgQOxUyB+FuMA/JADj7pBFIUCmDyJ7UGrK
P4F/IQ6gnyFAMzQgT2Xq0T+0CRUesPMhQCEVS8dGZdU/mjaFdcVOIkBYFUC0
vUPXP59LQoUyqCJACTTaWc2P1D96a7SFoPsiQLKVV3M+Cp8/CC6jzRNWI0CE
ddgFHz7Vv2z7RgaIqiNAouP6PMxO2b8yFFD6//8jQHMImjObyti/SUHJZA==

                    "]]}}}, {}, {}}, {
               DisplayFunction -> Identity, Ticks -> {Automatic, Automatic}, 
                AxesOrigin -> {0, 0}, 
                FrameTicks -> {{None, None}, {None, None}}, 
                GridLines -> {None, None}, DisplayFunction -> Identity, 
                PlotRangePadding -> {{
                   Scaled[0.1], 
                   Scaled[0.1]}, {
                   Scaled[0.1], 
                   Scaled[0.1]}}, PlotRangeClipping -> True, ImagePadding -> 
                All, DisplayFunction -> Identity, AspectRatio -> 1, 
                Axes -> {False, False}, AxesLabel -> {None, None}, 
                AxesOrigin -> {0, 0}, DisplayFunction :> Identity, 
                Frame -> {{True, True}, {True, True}}, 
                FrameLabel -> {{None, None}, {None, None}}, FrameStyle -> 
                Directive[
                  Opacity[0.5], 
                  Thickness[Tiny], 
                  RGBColor[0.368417, 0.506779, 0.709798]], 
                FrameTicks -> {{None, None}, {None, None}}, 
                GridLines -> {None, None}, GridLinesStyle -> Directive[
                  GrayLevel[0.5, 0.4]], ImageSize -> 
                Dynamic[{
                  Automatic, 3.5 CurrentValue["FontCapHeight"]/
                   AbsoluteCurrentValue[Magnification]}], 
                Method -> {
                 "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
                  AbsolutePointSize[6], "ScalingFunctions" -> None, 
                  "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
                    (
                    Part[{{Identity, Identity}, {Identity, Identity}}, 1, 
                    2][#]& )[
                    Part[#, 1]], 
                    (
                    Part[{{Identity, Identity}, {Identity, Identity}}, 2, 
                    2][#]& )[
                    Part[#, 2]]}& ), "CopiedValueFunction" -> ({
                    (
                    Part[{{Identity, Identity}, {Identity, Identity}}, 1, 
                    2][#]& )[
                    Part[#, 1]], 
                    (
                    Part[{{Identity, Identity}, {Identity, Identity}}, 2, 
                    2][#]& )[
                    Part[#, 2]]}& )}}, 
                PlotRange -> {{0., 10.}, {-0.39543443636972075`, 
                 0.37797457382950805`}}, PlotRangeClipping -> True, 
                PlotRangePadding -> {{
                   Scaled[0.1], 
                   Scaled[0.1]}, {
                   Scaled[0.1], 
                   Scaled[0.1]}}, Ticks -> {Automatic, Automatic}}], 
              GridBox[{{
                 RowBox[{
                   TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                   "\[InvisibleSpace]", 
                   TagBox[
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{"0.`", ",", "10.`"}], "}"}], "}"}], 
                    "SummaryItem"]}]}, {
                 RowBox[{
                   TagBox["\"Output: \"", "SummaryItemAnnotation"], 
                   "\[InvisibleSpace]", 
                   TagBox["\"scalar\"", "SummaryItem"]}]}}, 
               GridBoxAlignment -> {
                "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, AutoDelete -> 
               False, GridBoxItemSize -> {
                "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
               GridBoxSpacings -> {
                "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
               BaseStyle -> {
                ShowStringCharacters -> False, NumberMarks -> False, 
                 PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
            GridBoxAlignment -> {"Rows" -> {{Top}}}, AutoDelete -> False, 
            GridBoxItemSize -> {
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
            BaselinePosition -> {1, 1}], True -> GridBox[{{
              PaneBox[
               ButtonBox[
                DynamicBox[
                 FEPrivate`FrontEndResource[
                 "FEBitmaps", "SquareMinusIconMedium"]], 
                ButtonFunction :> (Typeset`open$$ = False), Appearance -> 
                None, Evaluator -> Automatic, Method -> "Preemptive"], 
               Alignment -> {Center, Center}, ImageSize -> 
               Dynamic[{
                 Automatic, 3.5 CurrentValue["FontCapHeight"]/
                  AbsoluteCurrentValue[Magnification]}]], 
              GraphicsBox[{{{{}, {}, {
                   Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]], 
                   LineBox[CompressedData["
1:eJwB0QMu/CFib1JlAgAAADwAAAACAAAAStFeOa+/hj4AAMkLyL92Pjd0wYnD
3cQ/fCEFAgPGtD/SUFjDa77VPwglNMG4T8U/IqE47Akn4D8p32mcr9LOP9Wb
k3tZVOU/w4n1zWeC0z+7wbiC/fHqP6FOylgJ4dY/gEqXStgX8D86TlREvDDY
P7tJtw/c7vI/xGZ/jzUK1T/ziT6Xnbj1P7il0VflaFe/2iBupGZS+D9l5U83
6qXUv1rNgu1ZJPs/be9zOLx42L+J0D+8VMb9P5BPg7i/eNe/WwqypoYtAEBk
121bop3Uvz63Ng34kwFAjELtdDVc0L94j482beICQKZr85kBfMe/f/LaffdM
BEAouSSR0U65vwX2WabgsAVAfvwr53LSib/iJK2RzfwGQG0izRVld7E/jN7y
ms9kCEDeOD89x6zDP43DDGfVtAlAXakfztRCzT9bMxlR8CALQJo3KtMUM9M/
p0NZHGqGDEDF0S1/1ZPWP0t/barn0w1AKSS8sEvh1z+8RXRWej0PQAAGDPue
ldQ/wpunYohHEEAaUDXI2n13P+XkrgoD7RBAV3A7iOGa1L9vc69BiKARQLww
OrTJv9i/pRcaWg9IEkCWpPVHtPXXv0EBfgGh/RJAZwfzhwrp1L8cu3sZ4q8T
QBHvTYXys9C/oorjEiVWFEBO/5yIdkXIv4+fRJtyChVAbpo7tSASu78oyg8F
wrIVQEp5lb9M4Zi/AMV038BXFkD0hepeZMasPz4F00jKChdA6R4wM8Qkwj8o
W5uT1bEXQEq82TJDyss/ePZcbetmGEB45h4X/onSP3SniCgDEBlAZDG8Qcjp
1T+vKE5UyrUZQILKkS5Zjtc/Ue8MD5xpGkBLownPOyLVP5/LNatvERtAEsjX
adSFsD9T7VfWTccbQN+fRQ1uptS/R98Tctt5HEBChQkokQbZv+bmOe9qIB1A
dz2qOZdq2L/rM1n7BNUdQGdf7EbMhtW/nJbi6KB9HkAI/bUPU6rRv4zJBUfs
Ih9AuU9J4ndwyr/iQSI0QtYfQF0XuTNbxr+/8mdUAc0+IEC6meTQRUmmv6ZR
FDB+mSBAfH+APWUUpz96IyEXh/IgQOxUyB+FuMA/JADj7pBFIUCmDyJ7UGrK
P4F/IQ6gnyFAMzQgT2Xq0T+0CRUesPMhQCEVS8dGZdU/mjaFdcVOIkBYFUC0
vUPXP59LQoUyqCJACTTaWc2P1D96a7SFoPsiQLKVV3M+Cp8/CC6jzRNWI0CE
ddgFHz7Vv2z7RgaIqiNAouP6PMxO2b8yFFD6//8jQHMImjObyti/SUHJZA==

                    "]]}}}, {}, {}}, {
               DisplayFunction -> Identity, Ticks -> {Automatic, Automatic}, 
                AxesOrigin -> {0, 0}, 
                FrameTicks -> {{None, None}, {None, None}}, 
                GridLines -> {None, None}, DisplayFunction -> Identity, 
                PlotRangePadding -> {{
                   Scaled[0.1], 
                   Scaled[0.1]}, {
                   Scaled[0.1], 
                   Scaled[0.1]}}, PlotRangeClipping -> True, ImagePadding -> 
                All, DisplayFunction -> Identity, AspectRatio -> 1, 
                Axes -> {False, False}, AxesLabel -> {None, None}, 
                AxesOrigin -> {0, 0}, DisplayFunction :> Identity, 
                Frame -> {{True, True}, {True, True}}, 
                FrameLabel -> {{None, None}, {None, None}}, FrameStyle -> 
                Directive[
                  Opacity[0.5], 
                  Thickness[Tiny], 
                  RGBColor[0.368417, 0.506779, 0.709798]], 
                FrameTicks -> {{None, None}, {None, None}}, 
                GridLines -> {None, None}, GridLinesStyle -> Directive[
                  GrayLevel[0.5, 0.4]], ImageSize -> 
                Dynamic[{
                  Automatic, 3.5 CurrentValue["FontCapHeight"]/
                   AbsoluteCurrentValue[Magnification]}], 
                Method -> {
                 "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
                  AbsolutePointSize[6], "ScalingFunctions" -> None, 
                  "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
                    (
                    Part[{{Identity, Identity}, {Identity, Identity}}, 1, 
                    2][#]& )[
                    Part[#, 1]], 
                    (
                    Part[{{Identity, Identity}, {Identity, Identity}}, 2, 
                    2][#]& )[
                    Part[#, 2]]}& ), "CopiedValueFunction" -> ({
                    (
                    Part[{{Identity, Identity}, {Identity, Identity}}, 1, 
                    2][#]& )[
                    Part[#, 1]], 
                    (
                    Part[{{Identity, Identity}, {Identity, Identity}}, 2, 
                    2][#]& )[
                    Part[#, 2]]}& )}}, 
                PlotRange -> {{0., 10.}, {-0.39543443636972075`, 
                 0.37797457382950805`}}, PlotRangeClipping -> True, 
                PlotRangePadding -> {{
                   Scaled[0.1], 
                   Scaled[0.1]}, {
                   Scaled[0.1], 
                   Scaled[0.1]}}, Ticks -> {Automatic, Automatic}}], 
              GridBox[{{
                 RowBox[{
                   TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                   "\[InvisibleSpace]", 
                   TagBox[
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{"0.`", ",", "10.`"}], "}"}], "}"}], 
                    "SummaryItem"]}]}, {
                 RowBox[{
                   TagBox["\"Output: \"", "SummaryItemAnnotation"], 
                   "\[InvisibleSpace]", 
                   TagBox["\"scalar\"", "SummaryItem"]}]}, {
                 RowBox[{
                   TagBox["\"Order: \"", "SummaryItemAnnotation"], 
                   "\[InvisibleSpace]", 
                   TagBox["3", "SummaryItem"]}]}, {
                 RowBox[{
                   TagBox["\"Method: \"", "SummaryItemAnnotation"], 
                   "\[InvisibleSpace]", 
                   TagBox["\"Hermite\"", "SummaryItem"]}]}, {
                 RowBox[{
                   TagBox["\"Periodic: \"", "SummaryItemAnnotation"], 
                   "\[InvisibleSpace]", 
                   TagBox["False", "SummaryItem"]}]}}, 
               GridBoxAlignment -> {
                "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, AutoDelete -> 
               False, GridBoxItemSize -> {
                "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
               GridBoxSpacings -> {
                "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
               BaseStyle -> {
                ShowStringCharacters -> False, NumberMarks -> False, 
                 PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
            GridBoxAlignment -> {"Rows" -> {{Top}}}, AutoDelete -> False, 
            GridBoxItemSize -> {
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
            BaselinePosition -> {1, 1}]}, 
         Dynamic[Typeset`open$$], ImageSize -> Automatic], BaselinePosition -> 
        Baseline], DynamicModuleValues :> {}], 
      StyleBox["]", "NonInterpretableSummary"]}]},
   "CopyTag",
   DisplayFunction->(#& ),
   InterpretationFunction->("InterpolatingFunction[{{0., 10.}}, <>]"& )],
  False,
  Editable->False,
  SelectWithContents->True,
  Selectable->False]], "Output",
 CellChangeTimes->{3.6832618227585773`*^9, 3.6832625946392183`*^9, 
  3.683263285761857*^9, 3.683263370455372*^9, 3.683734376576744*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"With", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"\[Delta]t", "=", "0.01"}], ",", 
     RowBox[{"nmax", "=", "1000"}]}], "}"}], ",", 
   RowBox[{
    RowBox[{"vxleapfrog", "[", "\[Delta]t", "]"}], "=", 
    RowBox[{"Interpolation", "[", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"n", "*", "\[Delta]t"}], ",", 
         RowBox[{"vx", "[", "n", "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"n", ",", "0", ",", "nmax"}], "}"}]}], "]"}], "]"}]}]}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.683261826974167*^9, 3.683261828223486*^9}, {
  3.6832625963649187`*^9, 3.683262597601955*^9}, {3.683263287980453*^9, 
  3.683263288782865*^9}, {3.683263372909552*^9, 3.683263374080155*^9}}],

Cell[BoxData[
 TagBox[
  TemplateBox[{RowBox[{
      StyleBox[
       TagBox["InterpolatingFunction", "SummaryHead"], 
       "NonInterpretableSummary"], 
      StyleBox["[", "NonInterpretableSummary"], 
      DynamicModuleBox[{Typeset`open$$ = False}, 
       PanelBox[
        PaneSelectorBox[{False -> GridBox[{{
              PaneBox[
               ButtonBox[
                DynamicBox[
                 FEPrivate`FrontEndResource[
                 "FEBitmaps", "SquarePlusIconMedium"]], 
                ButtonFunction :> (Typeset`open$$ = True), Appearance -> None,
                 Evaluator -> Automatic, Method -> "Preemptive"], 
               Alignment -> {Center, Center}, ImageSize -> 
               Dynamic[{
                 Automatic, 3.5 CurrentValue["FontCapHeight"]/
                  AbsoluteCurrentValue[Magnification]}]], 
              GraphicsBox[{{{{}, {}, {
                   Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]], 
                   LineBox[CompressedData["
1:eJwB0QMu/CFib1JlAgAAADwAAAACAAAAStFeOa+/hj4AAFfKvr+Gvjd0wYnD
3cQ/TGH3eaj7xL/SUFjDa77VP2uBcb20Sda/IqE47Akn4D9QCGl+GRfhv9Wb
k3tZVOU/xgixwxqn57+7wbiC/fHqP6RbBvX4GPC/gEqXStgX8D/MdxP2/Un1
v7tJtw/c7vI/py4lWmY6/b/ziT6Xnbj1PxCretbLpIY/2iBupGZS+D/lDK55
ZJv9P1rNgu1ZJPs/LQ96bxi49T+J0D+8VMb9P48flnXnb/A/WwqypoYtAEAC
FBSKPePoPz63Ng34kwFARlwblbqx4T94j482beICQCHyKNwqkNc/f/LaffdM
BEA5xpI/Em3HPwX2WabgsAVAezzqUE2/gD/iJK2RzfwGQPLEMyjw0MO/jN7y
ms9kCEAWSEdqeqTVv43DDGfVtAlA2QsGKTq74L9bMxlR8CALQChqmNsA/ue/
p0NZHGqGDEDjYQupP1Pwv0t/barn0w1AfbVUi9Se9b+8RXRWej0PQJTAqUHD
wP2/wpunYohHEEAG6ADq4b+6v+XkrgoD7RBAYoO/IUWU/T9vc69BiKARQPq7
YJ2l1vU/pRcaWg9IEkCYE8wpWZjwP0EBfgGh/RJAm6icqOd+6D8cu3sZ4q8T
QJ6nV/4XceE/oorjEiVWFECsArLMvjrXP4+fRJtyChVAIsL942P/xj8oyg8F
wrIVQAwSqUEzu40/AMV038BXFkBkjq17reLCvz4F00jKChdARA4tddAe1b8o
W5uT1bEXQA4X+K2AcOC/ePZcbetmGECNEUNScKnnv3SniCgDEBlAOJAIstPK
77+vKE5UyrUZQCmUW/9vD/W/Ue8MD5xpGkCNFc//XQ39v5/LNatvERtApsj6
Ypy17L9T7VfWTccbQI7kJ8swdf0/R98Tctt5HEB8Fw/SfuL1P+bmOe9qIB1A
tqG/vAez8D/rM1n7BNUdQFhdImkCxeg/nJbi6KB9HkC2WUglcRTiP4zJBUfs
Ih9AH4ymIKWE2D/iQSI0QtYfQM2vwR6hosk/8mdUAc0+IEBVTorFAGmiP6ZR
FDB+mSBA3c6UKf4wwr96IyEXh/IgQOPxu1zOuNS/JADj7pBFIUByNWCo9zbg
v4F/IQ6gnyFAakAdkcdo57+0CRUesPMhQDkrSU9TgO+/mjaFdcVOIkCv8K+Z
DYf1v59LQoUyqCJAcysXoa7H/b96a7SFoPsiQAgmQvpFUN6/CC6jzRNWI0Co
x5MUDuH8P2z7RgaIqiNAk+fl3grc9T8yFFD6//8jQOOrBL2dm/A/6+nVHQ==

                    "]]}}}, {}, {}}, {
               DisplayFunction -> Identity, Ticks -> {Automatic, Automatic}, 
                AxesOrigin -> {0, 0}, 
                FrameTicks -> {{None, None}, {None, None}}, 
                GridLines -> {None, None}, DisplayFunction -> Identity, 
                PlotRangePadding -> {{
                   Scaled[0.1], 
                   Scaled[0.1]}, {
                   Scaled[0.1], 
                   Scaled[0.1]}}, PlotRangeClipping -> True, ImagePadding -> 
                All, DisplayFunction -> Identity, AspectRatio -> 1, 
                Axes -> {False, False}, AxesLabel -> {None, None}, 
                AxesOrigin -> {0, 0}, DisplayFunction :> Identity, 
                Frame -> {{True, True}, {True, True}}, 
                FrameLabel -> {{None, None}, {None, None}}, FrameStyle -> 
                Directive[
                  Opacity[0.5], 
                  Thickness[Tiny], 
                  RGBColor[0.368417, 0.506779, 0.709798]], 
                FrameTicks -> {{None, None}, {None, None}}, 
                GridLines -> {None, None}, GridLinesStyle -> Directive[
                  GrayLevel[0.5, 0.4]], ImageSize -> 
                Dynamic[{
                  Automatic, 3.5 CurrentValue["FontCapHeight"]/
                   AbsoluteCurrentValue[Magnification]}], 
                Method -> {
                 "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
                  AbsolutePointSize[6], "ScalingFunctions" -> None, 
                  "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
                    (
                    Part[{{Identity, Identity}, {Identity, Identity}}, 1, 
                    2][#]& )[
                    Part[#, 1]], 
                    (
                    Part[{{Identity, Identity}, {Identity, Identity}}, 2, 
                    2][#]& )[
                    Part[#, 2]]}& ), "CopiedValueFunction" -> ({
                    (
                    Part[{{Identity, Identity}, {Identity, Identity}}, 1, 
                    2][#]& )[
                    Part[#, 1]], 
                    (
                    Part[{{Identity, Identity}, {Identity, Identity}}, 2, 
                    2][#]& )[
                    Part[#, 2]]}& )}}, 
                PlotRange -> {{0., 10.}, {-1.8612505238149566`, 
                 1.850437617599533}}, PlotRangeClipping -> True, 
                PlotRangePadding -> {{
                   Scaled[0.1], 
                   Scaled[0.1]}, {
                   Scaled[0.1], 
                   Scaled[0.1]}}, Ticks -> {Automatic, Automatic}}], 
              GridBox[{{
                 RowBox[{
                   TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                   "\[InvisibleSpace]", 
                   TagBox[
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{"0.`", ",", "10.`"}], "}"}], "}"}], 
                    "SummaryItem"]}]}, {
                 RowBox[{
                   TagBox["\"Output: \"", "SummaryItemAnnotation"], 
                   "\[InvisibleSpace]", 
                   TagBox["\"scalar\"", "SummaryItem"]}]}}, 
               GridBoxAlignment -> {
                "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, AutoDelete -> 
               False, GridBoxItemSize -> {
                "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
               GridBoxSpacings -> {
                "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
               BaseStyle -> {
                ShowStringCharacters -> False, NumberMarks -> False, 
                 PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
            GridBoxAlignment -> {"Rows" -> {{Top}}}, AutoDelete -> False, 
            GridBoxItemSize -> {
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
            BaselinePosition -> {1, 1}], True -> GridBox[{{
              PaneBox[
               ButtonBox[
                DynamicBox[
                 FEPrivate`FrontEndResource[
                 "FEBitmaps", "SquareMinusIconMedium"]], 
                ButtonFunction :> (Typeset`open$$ = False), Appearance -> 
                None, Evaluator -> Automatic, Method -> "Preemptive"], 
               Alignment -> {Center, Center}, ImageSize -> 
               Dynamic[{
                 Automatic, 3.5 CurrentValue["FontCapHeight"]/
                  AbsoluteCurrentValue[Magnification]}]], 
              GraphicsBox[{{{{}, {}, {
                   Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]], 
                   LineBox[CompressedData["
1:eJwB0QMu/CFib1JlAgAAADwAAAACAAAAStFeOa+/hj4AAFfKvr+Gvjd0wYnD
3cQ/TGH3eaj7xL/SUFjDa77VP2uBcb20Sda/IqE47Akn4D9QCGl+GRfhv9Wb
k3tZVOU/xgixwxqn57+7wbiC/fHqP6RbBvX4GPC/gEqXStgX8D/MdxP2/Un1
v7tJtw/c7vI/py4lWmY6/b/ziT6Xnbj1PxCretbLpIY/2iBupGZS+D/lDK55
ZJv9P1rNgu1ZJPs/LQ96bxi49T+J0D+8VMb9P48flnXnb/A/WwqypoYtAEAC
FBSKPePoPz63Ng34kwFARlwblbqx4T94j482beICQCHyKNwqkNc/f/LaffdM
BEA5xpI/Em3HPwX2WabgsAVAezzqUE2/gD/iJK2RzfwGQPLEMyjw0MO/jN7y
ms9kCEAWSEdqeqTVv43DDGfVtAlA2QsGKTq74L9bMxlR8CALQChqmNsA/ue/
p0NZHGqGDEDjYQupP1Pwv0t/barn0w1AfbVUi9Se9b+8RXRWej0PQJTAqUHD
wP2/wpunYohHEEAG6ADq4b+6v+XkrgoD7RBAYoO/IUWU/T9vc69BiKARQPq7
YJ2l1vU/pRcaWg9IEkCYE8wpWZjwP0EBfgGh/RJAm6icqOd+6D8cu3sZ4q8T
QJ6nV/4XceE/oorjEiVWFECsArLMvjrXP4+fRJtyChVAIsL942P/xj8oyg8F
wrIVQAwSqUEzu40/AMV038BXFkBkjq17reLCvz4F00jKChdARA4tddAe1b8o
W5uT1bEXQA4X+K2AcOC/ePZcbetmGECNEUNScKnnv3SniCgDEBlAOJAIstPK
77+vKE5UyrUZQCmUW/9vD/W/Ue8MD5xpGkCNFc//XQ39v5/LNatvERtApsj6
Ypy17L9T7VfWTccbQI7kJ8swdf0/R98Tctt5HEB8Fw/SfuL1P+bmOe9qIB1A
tqG/vAez8D/rM1n7BNUdQFhdImkCxeg/nJbi6KB9HkC2WUglcRTiP4zJBUfs
Ih9AH4ymIKWE2D/iQSI0QtYfQM2vwR6hosk/8mdUAc0+IEBVTorFAGmiP6ZR
FDB+mSBA3c6UKf4wwr96IyEXh/IgQOPxu1zOuNS/JADj7pBFIUByNWCo9zbg
v4F/IQ6gnyFAakAdkcdo57+0CRUesPMhQDkrSU9TgO+/mjaFdcVOIkCv8K+Z
DYf1v59LQoUyqCJAcysXoa7H/b96a7SFoPsiQAgmQvpFUN6/CC6jzRNWI0Co
x5MUDuH8P2z7RgaIqiNAk+fl3grc9T8yFFD6//8jQOOrBL2dm/A/6+nVHQ==

                    "]]}}}, {}, {}}, {
               DisplayFunction -> Identity, Ticks -> {Automatic, Automatic}, 
                AxesOrigin -> {0, 0}, 
                FrameTicks -> {{None, None}, {None, None}}, 
                GridLines -> {None, None}, DisplayFunction -> Identity, 
                PlotRangePadding -> {{
                   Scaled[0.1], 
                   Scaled[0.1]}, {
                   Scaled[0.1], 
                   Scaled[0.1]}}, PlotRangeClipping -> True, ImagePadding -> 
                All, DisplayFunction -> Identity, AspectRatio -> 1, 
                Axes -> {False, False}, AxesLabel -> {None, None}, 
                AxesOrigin -> {0, 0}, DisplayFunction :> Identity, 
                Frame -> {{True, True}, {True, True}}, 
                FrameLabel -> {{None, None}, {None, None}}, FrameStyle -> 
                Directive[
                  Opacity[0.5], 
                  Thickness[Tiny], 
                  RGBColor[0.368417, 0.506779, 0.709798]], 
                FrameTicks -> {{None, None}, {None, None}}, 
                GridLines -> {None, None}, GridLinesStyle -> Directive[
                  GrayLevel[0.5, 0.4]], ImageSize -> 
                Dynamic[{
                  Automatic, 3.5 CurrentValue["FontCapHeight"]/
                   AbsoluteCurrentValue[Magnification]}], 
                Method -> {
                 "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
                  AbsolutePointSize[6], "ScalingFunctions" -> None, 
                  "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
                    (
                    Part[{{Identity, Identity}, {Identity, Identity}}, 1, 
                    2][#]& )[
                    Part[#, 1]], 
                    (
                    Part[{{Identity, Identity}, {Identity, Identity}}, 2, 
                    2][#]& )[
                    Part[#, 2]]}& ), "CopiedValueFunction" -> ({
                    (
                    Part[{{Identity, Identity}, {Identity, Identity}}, 1, 
                    2][#]& )[
                    Part[#, 1]], 
                    (
                    Part[{{Identity, Identity}, {Identity, Identity}}, 2, 
                    2][#]& )[
                    Part[#, 2]]}& )}}, 
                PlotRange -> {{0., 10.}, {-1.8612505238149566`, 
                 1.850437617599533}}, PlotRangeClipping -> True, 
                PlotRangePadding -> {{
                   Scaled[0.1], 
                   Scaled[0.1]}, {
                   Scaled[0.1], 
                   Scaled[0.1]}}, Ticks -> {Automatic, Automatic}}], 
              GridBox[{{
                 RowBox[{
                   TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                   "\[InvisibleSpace]", 
                   TagBox[
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{"0.`", ",", "10.`"}], "}"}], "}"}], 
                    "SummaryItem"]}]}, {
                 RowBox[{
                   TagBox["\"Output: \"", "SummaryItemAnnotation"], 
                   "\[InvisibleSpace]", 
                   TagBox["\"scalar\"", "SummaryItem"]}]}, {
                 RowBox[{
                   TagBox["\"Order: \"", "SummaryItemAnnotation"], 
                   "\[InvisibleSpace]", 
                   TagBox["3", "SummaryItem"]}]}, {
                 RowBox[{
                   TagBox["\"Method: \"", "SummaryItemAnnotation"], 
                   "\[InvisibleSpace]", 
                   TagBox["\"Hermite\"", "SummaryItem"]}]}, {
                 RowBox[{
                   TagBox["\"Periodic: \"", "SummaryItemAnnotation"], 
                   "\[InvisibleSpace]", 
                   TagBox["False", "SummaryItem"]}]}}, 
               GridBoxAlignment -> {
                "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, AutoDelete -> 
               False, GridBoxItemSize -> {
                "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
               GridBoxSpacings -> {
                "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
               BaseStyle -> {
                ShowStringCharacters -> False, NumberMarks -> False, 
                 PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
            GridBoxAlignment -> {"Rows" -> {{Top}}}, AutoDelete -> False, 
            GridBoxItemSize -> {
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
            BaselinePosition -> {1, 1}]}, 
         Dynamic[Typeset`open$$], ImageSize -> Automatic], BaselinePosition -> 
        Baseline], DynamicModuleValues :> {}], 
      StyleBox["]", "NonInterpretableSummary"]}]},
   "CopyTag",
   DisplayFunction->(#& ),
   InterpretationFunction->("InterpolatingFunction[{{0., 10.}}, <>]"& )],
  False,
  Editable->False,
  SelectWithContents->True,
  Selectable->False]], "Output",
 CellChangeTimes->{3.6832618289771833`*^9, 3.6832618623666773`*^9, 
  3.6832625981012287`*^9, 3.683263289283374*^9, 3.683263374454225*^9, 
  3.683734377374689*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"With", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"\[Delta]t", "=", "0.01"}], ",", 
     RowBox[{"nmax", "=", "1000"}]}], "}"}], ",", 
   RowBox[{
    RowBox[{"vyleapfrog", "[", "\[Delta]t", "]"}], "=", 
    RowBox[{"Interpolation", "[", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"n", "*", "\[Delta]t"}], ",", 
         RowBox[{"vy", "[", "n", "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"n", ",", "0", ",", "nmax"}], "}"}]}], "]"}], "]"}]}]}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.683261866543598*^9, 3.6832618689251013`*^9}, {
  3.683262600919565*^9, 3.683262601837439*^9}, {3.68326329170582*^9, 
  3.683263292377159*^9}, {3.683263375859715*^9, 3.68326337788113*^9}}],

Cell[BoxData[
 TagBox[
  TemplateBox[{RowBox[{
      StyleBox[
       TagBox["InterpolatingFunction", "SummaryHead"], 
       "NonInterpretableSummary"], 
      StyleBox["[", "NonInterpretableSummary"], 
      DynamicModuleBox[{Typeset`open$$ = False}, 
       PanelBox[
        PaneSelectorBox[{False -> GridBox[{{
              PaneBox[
               ButtonBox[
                DynamicBox[
                 FEPrivate`FrontEndResource[
                 "FEBitmaps", "SquarePlusIconMedium"]], 
                ButtonFunction :> (Typeset`open$$ = True), Appearance -> None,
                 Evaluator -> Automatic, Method -> "Preemptive"], 
               Alignment -> {Center, Center}, ImageSize -> 
               Dynamic[{
                 Automatic, 3.5 CurrentValue["FontCapHeight"]/
                  AbsoluteCurrentValue[Magnification]}]], 
              GraphicsBox[{{{{}, {}, {
                   Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]], 
                   LineBox[CompressedData["
1:eJwB0QMu/CFib1JlAgAAADwAAAACAAAAStFeOa+/hj7p9v/////fPzd0wYnD
3cQ/GCG31byR3z/SUFjDa77VP+Elme5mC94/IqE47Akn4D/LA5/RB1rbP9Wb
k3tZVOU/h09smO3v1j+7wbiC/fHqP5AWO/5UP80/gEqXStgX8D9Q+6bCETF8
v7tJtw/c7vI/tN9fhf/35b/ziT6Xnbj1P4NXDin93AvA2iBupGZS+D8Wr+/h
sh7pv1rNgu1ZJPs/3ZGazU0gqL+J0D+8VMb9P6ia8CDXVco/WwqypoYtAECv
jt66/HbVPz63Ng34kwFAQgfExZ+y2j94j482beICQA+qwBMDnN0/f/LaffdM
BECCeCOaPF3fPwX2WabgsAVAfwp0I/v+3z/iJK2RzfwGQGnQBke9s98/jN7y
ms9kCEDAAK8FbFjeP43DDGfVtAlA9zckwkDY2z9bMxlR8CALQJCCcFQ1G9c/
p0NZHGqGDECE5OzH/3fNP0t/barn0w1ArRy1dXmghL+8RXRWej0PQJuf/PTn
Iee/wpunYohHEEDsmBzqc9oLwOXkrgoD7RBA82+SsB9v6r9vc69BiKARQMWZ
asEvBrK/pRcaWg9IEkA9wnlCvDnIP0EBfgGh/RJAYkoiU6ZZ1T8cu3sZ4q8T
QEHvA2Nvito/oorjEiVWFEC5Qbr4I3rdP4+fRJtyChVAWJtuRqpK3z8oyg8F
wrIVQNE3yEar/N8/AMV038BXFkBQYPDMj9HfPz4F00jKChdAzDA59KGd3j8o
W5uT1bEXQGchy2X2Sdw/ePZcbetmGEAXaL/NrszXP3SniCgDEBlACqolr21V
0D+vKE5UyrUZQGLronvOC6I/Ue8MD5xpGkAXEGx7Ru7iv5/LNatvERtATtCZ
QVBSCsBT7VfWTccbQO/9aoxzSOu/R98Tctt5HEBotek92va2v+bmOe9qIB1A
9I8+hYpYxj/rM1n7BNUdQJunhxMzp9Q/nJbi6KB9HkDqTi7CrNTZP4zJBUfs
Ih9AVvVIc68A3T/iQSI0QtYfQMZFwXljCt8/8mdUAc0+IEAzdPJ7NO/fP6ZR
FDB+mSBAaE56SFLs3z96IyEXh/IgQNZrlnBJ3N4/JADj7pBFIUClkBnIrLDc
P4F/IQ6gnyFAkwhb9nBr2D+0CRUesPMhQIUE131MQ9E/mjaFdcVOIkAZ9PR4
KRaaP59LQoUyqCJArFREMpPH5L96a7SFoPsiQCgN2d0EggvACC6jzRNWI0Cy
5nV+Tovpv2z7RgaIqiNA5zbipybRur8yFFD6//8jQBco2KmIesU/hJbT5A==

                    "]]}}}, {}, {}}, {
               DisplayFunction -> Identity, Ticks -> {Automatic, Automatic}, 
                AxesOrigin -> {0, 0}, 
                FrameTicks -> {{None, None}, {None, None}}, 
                GridLines -> {None, None}, DisplayFunction -> Identity, 
                PlotRangePadding -> {{
                   Scaled[0.1], 
                   Scaled[0.1]}, {
                   Scaled[0.1], 
                   Scaled[0.1]}}, PlotRangeClipping -> True, ImagePadding -> 
                All, DisplayFunction -> Identity, AspectRatio -> 1, 
                Axes -> {False, False}, AxesLabel -> {None, None}, 
                AxesOrigin -> {0, 0}, DisplayFunction :> Identity, 
                Frame -> {{True, True}, {True, True}}, 
                FrameLabel -> {{None, None}, {None, None}}, FrameStyle -> 
                Directive[
                  Opacity[0.5], 
                  Thickness[Tiny], 
                  RGBColor[0.368417, 0.506779, 0.709798]], 
                FrameTicks -> {{None, None}, {None, None}}, 
                GridLines -> {None, None}, GridLinesStyle -> Directive[
                  GrayLevel[0.5, 0.4]], ImageSize -> 
                Dynamic[{
                  Automatic, 3.5 CurrentValue["FontCapHeight"]/
                   AbsoluteCurrentValue[Magnification]}], 
                Method -> {
                 "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
                  AbsolutePointSize[6], "ScalingFunctions" -> None, 
                  "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
                    (
                    Part[{{Identity, Identity}, {Identity, Identity}}, 1, 
                    2][#]& )[
                    Part[#, 1]], 
                    (
                    Part[{{Identity, Identity}, {Identity, Identity}}, 2, 
                    2][#]& )[
                    Part[#, 2]]}& ), "CopiedValueFunction" -> ({
                    (
                    Part[{{Identity, Identity}, {Identity, Identity}}, 1, 
                    2][#]& )[
                    Part[#, 1]], 
                    (
                    Part[{{Identity, Identity}, {Identity, Identity}}, 2, 
                    2][#]& )[
                    Part[#, 2]]}& )}}, 
                PlotRange -> {{0., 10.}, {-3.4829047400953086`, 
                 0.4999999999998708}}, PlotRangeClipping -> True, 
                PlotRangePadding -> {{
                   Scaled[0.1], 
                   Scaled[0.1]}, {
                   Scaled[0.1], 
                   Scaled[0.1]}}, Ticks -> {Automatic, Automatic}}], 
              GridBox[{{
                 RowBox[{
                   TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                   "\[InvisibleSpace]", 
                   TagBox[
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{"0.`", ",", "10.`"}], "}"}], "}"}], 
                    "SummaryItem"]}]}, {
                 RowBox[{
                   TagBox["\"Output: \"", "SummaryItemAnnotation"], 
                   "\[InvisibleSpace]", 
                   TagBox["\"scalar\"", "SummaryItem"]}]}}, 
               GridBoxAlignment -> {
                "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, AutoDelete -> 
               False, GridBoxItemSize -> {
                "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
               GridBoxSpacings -> {
                "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
               BaseStyle -> {
                ShowStringCharacters -> False, NumberMarks -> False, 
                 PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
            GridBoxAlignment -> {"Rows" -> {{Top}}}, AutoDelete -> False, 
            GridBoxItemSize -> {
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
            BaselinePosition -> {1, 1}], True -> GridBox[{{
              PaneBox[
               ButtonBox[
                DynamicBox[
                 FEPrivate`FrontEndResource[
                 "FEBitmaps", "SquareMinusIconMedium"]], 
                ButtonFunction :> (Typeset`open$$ = False), Appearance -> 
                None, Evaluator -> Automatic, Method -> "Preemptive"], 
               Alignment -> {Center, Center}, ImageSize -> 
               Dynamic[{
                 Automatic, 3.5 CurrentValue["FontCapHeight"]/
                  AbsoluteCurrentValue[Magnification]}]], 
              GraphicsBox[{{{{}, {}, {
                   Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]], 
                   LineBox[CompressedData["
1:eJwB0QMu/CFib1JlAgAAADwAAAACAAAAStFeOa+/hj7p9v/////fPzd0wYnD
3cQ/GCG31byR3z/SUFjDa77VP+Elme5mC94/IqE47Akn4D/LA5/RB1rbP9Wb
k3tZVOU/h09smO3v1j+7wbiC/fHqP5AWO/5UP80/gEqXStgX8D9Q+6bCETF8
v7tJtw/c7vI/tN9fhf/35b/ziT6Xnbj1P4NXDin93AvA2iBupGZS+D8Wr+/h
sh7pv1rNgu1ZJPs/3ZGazU0gqL+J0D+8VMb9P6ia8CDXVco/WwqypoYtAECv
jt66/HbVPz63Ng34kwFAQgfExZ+y2j94j482beICQA+qwBMDnN0/f/LaffdM
BECCeCOaPF3fPwX2WabgsAVAfwp0I/v+3z/iJK2RzfwGQGnQBke9s98/jN7y
ms9kCEDAAK8FbFjeP43DDGfVtAlA9zckwkDY2z9bMxlR8CALQJCCcFQ1G9c/
p0NZHGqGDECE5OzH/3fNP0t/barn0w1ArRy1dXmghL+8RXRWej0PQJuf/PTn
Iee/wpunYohHEEDsmBzqc9oLwOXkrgoD7RBA82+SsB9v6r9vc69BiKARQMWZ
asEvBrK/pRcaWg9IEkA9wnlCvDnIP0EBfgGh/RJAYkoiU6ZZ1T8cu3sZ4q8T
QEHvA2Nvito/oorjEiVWFEC5Qbr4I3rdP4+fRJtyChVAWJtuRqpK3z8oyg8F
wrIVQNE3yEar/N8/AMV038BXFkBQYPDMj9HfPz4F00jKChdAzDA59KGd3j8o
W5uT1bEXQGchy2X2Sdw/ePZcbetmGEAXaL/NrszXP3SniCgDEBlACqolr21V
0D+vKE5UyrUZQGLronvOC6I/Ue8MD5xpGkAXEGx7Ru7iv5/LNatvERtATtCZ
QVBSCsBT7VfWTccbQO/9aoxzSOu/R98Tctt5HEBotek92va2v+bmOe9qIB1A
9I8+hYpYxj/rM1n7BNUdQJunhxMzp9Q/nJbi6KB9HkDqTi7CrNTZP4zJBUfs
Ih9AVvVIc68A3T/iQSI0QtYfQMZFwXljCt8/8mdUAc0+IEAzdPJ7NO/fP6ZR
FDB+mSBAaE56SFLs3z96IyEXh/IgQNZrlnBJ3N4/JADj7pBFIUClkBnIrLDc
P4F/IQ6gnyFAkwhb9nBr2D+0CRUesPMhQIUE131MQ9E/mjaFdcVOIkAZ9PR4
KRaaP59LQoUyqCJArFREMpPH5L96a7SFoPsiQCgN2d0EggvACC6jzRNWI0Cy
5nV+Tovpv2z7RgaIqiNA5zbipybRur8yFFD6//8jQBco2KmIesU/hJbT5A==

                    "]]}}}, {}, {}}, {
               DisplayFunction -> Identity, Ticks -> {Automatic, Automatic}, 
                AxesOrigin -> {0, 0}, 
                FrameTicks -> {{None, None}, {None, None}}, 
                GridLines -> {None, None}, DisplayFunction -> Identity, 
                PlotRangePadding -> {{
                   Scaled[0.1], 
                   Scaled[0.1]}, {
                   Scaled[0.1], 
                   Scaled[0.1]}}, PlotRangeClipping -> True, ImagePadding -> 
                All, DisplayFunction -> Identity, AspectRatio -> 1, 
                Axes -> {False, False}, AxesLabel -> {None, None}, 
                AxesOrigin -> {0, 0}, DisplayFunction :> Identity, 
                Frame -> {{True, True}, {True, True}}, 
                FrameLabel -> {{None, None}, {None, None}}, FrameStyle -> 
                Directive[
                  Opacity[0.5], 
                  Thickness[Tiny], 
                  RGBColor[0.368417, 0.506779, 0.709798]], 
                FrameTicks -> {{None, None}, {None, None}}, 
                GridLines -> {None, None}, GridLinesStyle -> Directive[
                  GrayLevel[0.5, 0.4]], ImageSize -> 
                Dynamic[{
                  Automatic, 3.5 CurrentValue["FontCapHeight"]/
                   AbsoluteCurrentValue[Magnification]}], 
                Method -> {
                 "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
                  AbsolutePointSize[6], "ScalingFunctions" -> None, 
                  "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
                    (
                    Part[{{Identity, Identity}, {Identity, Identity}}, 1, 
                    2][#]& )[
                    Part[#, 1]], 
                    (
                    Part[{{Identity, Identity}, {Identity, Identity}}, 2, 
                    2][#]& )[
                    Part[#, 2]]}& ), "CopiedValueFunction" -> ({
                    (
                    Part[{{Identity, Identity}, {Identity, Identity}}, 1, 
                    2][#]& )[
                    Part[#, 1]], 
                    (
                    Part[{{Identity, Identity}, {Identity, Identity}}, 2, 
                    2][#]& )[
                    Part[#, 2]]}& )}}, 
                PlotRange -> {{0., 10.}, {-3.4829047400953086`, 
                 0.4999999999998708}}, PlotRangeClipping -> True, 
                PlotRangePadding -> {{
                   Scaled[0.1], 
                   Scaled[0.1]}, {
                   Scaled[0.1], 
                   Scaled[0.1]}}, Ticks -> {Automatic, Automatic}}], 
              GridBox[{{
                 RowBox[{
                   TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                   "\[InvisibleSpace]", 
                   TagBox[
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{"0.`", ",", "10.`"}], "}"}], "}"}], 
                    "SummaryItem"]}]}, {
                 RowBox[{
                   TagBox["\"Output: \"", "SummaryItemAnnotation"], 
                   "\[InvisibleSpace]", 
                   TagBox["\"scalar\"", "SummaryItem"]}]}, {
                 RowBox[{
                   TagBox["\"Order: \"", "SummaryItemAnnotation"], 
                   "\[InvisibleSpace]", 
                   TagBox["3", "SummaryItem"]}]}, {
                 RowBox[{
                   TagBox["\"Method: \"", "SummaryItemAnnotation"], 
                   "\[InvisibleSpace]", 
                   TagBox["\"Hermite\"", "SummaryItem"]}]}, {
                 RowBox[{
                   TagBox["\"Periodic: \"", "SummaryItemAnnotation"], 
                   "\[InvisibleSpace]", 
                   TagBox["False", "SummaryItem"]}]}}, 
               GridBoxAlignment -> {
                "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, AutoDelete -> 
               False, GridBoxItemSize -> {
                "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
               GridBoxSpacings -> {
                "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
               BaseStyle -> {
                ShowStringCharacters -> False, NumberMarks -> False, 
                 PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
            GridBoxAlignment -> {"Rows" -> {{Top}}}, AutoDelete -> False, 
            GridBoxItemSize -> {
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
            BaselinePosition -> {1, 1}]}, 
         Dynamic[Typeset`open$$], ImageSize -> Automatic], BaselinePosition -> 
        Baseline], DynamicModuleValues :> {}], 
      StyleBox["]", "NonInterpretableSummary"]}]},
   "CopyTag",
   DisplayFunction->(#& ),
   InterpretationFunction->("InterpolatingFunction[{{0., 10.}}, <>]"& )],
  False,
  Editable->False,
  SelectWithContents->True,
  Selectable->False]], "Output",
 CellChangeTimes->{3.6832618694225473`*^9, 3.68326260227092*^9, 
  3.6832632928745327`*^9, 3.6832633782470293`*^9, 3.683734378126466*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"With", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\[Delta]t", "=", "0.01"}], "}"}], ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"leapfrogorbit", "[", "\[Delta]t", "]"}], "=", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"ParametricPlot", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"xleapfrog", "[", "\[Delta]t", "]"}], "[", "t", "]"}], ",", 
         
         RowBox[{
          RowBox[{"yleapfrog", "[", "\[Delta]t", "]"}], "[", "t", "]"}]}], 
        "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", "0", ",", "10"}], "}"}], ",", 
       RowBox[{"AxesLabel", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Style", "[", 
           RowBox[{"\"\<x\>\"", ",", "Black", ",", "15"}], "]"}], ",", 
          RowBox[{"Style", "[", 
           RowBox[{"\"\<y\>\"", ",", "Black", ",", "15"}], "]"}]}], "}"}]}], 
       ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"RGBColor", "[", 
         RowBox[{"0", ",", "0.75", ",", "0"}], "]"}]}]}], "]"}], "/.", 
     RowBox[{"Line", "\[Rule]", "Arrow"}]}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.683261910648492*^9, 3.683261942184559*^9}, {
   3.683262161372587*^9, 3.6832621722183123`*^9}, {3.683262249312037*^9, 
   3.683262250143906*^9}, {3.683262606091915*^9, 3.683262609170856*^9}, {
   3.6832626730320272`*^9, 3.683262675385591*^9}, {3.6832632965333357`*^9, 
   3.68326330857006*^9}, 3.683263380840795*^9, {3.6837344168357983`*^9, 
   3.6837344266990356`*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {RGBColor[0, 0.75, 0], AbsoluteThickness[1.6], Opacity[1.], FaceForm[
    Opacity[0.3]], ArrowBox[CompressedData["
1:eJw0m3k8Vd/3/1EoKhVJIqFCGlSUShZK0kApRUpRlFCIZJ4p3oTMMmee59k2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     "]]}},
  Axes->{True, True},
  AxesLabel->{
    FormBox[
     StyleBox["\"x\"", 
      GrayLevel[0], 15, StripOnInput -> False], TraditionalForm], 
    FormBox[
     StyleBox["\"y\"", 
      GrayLevel[0], 15, StripOnInput -> False], TraditionalForm]},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  Method->{"ScalingFunctions" -> None},
  PlotRange->{{-0.1436137455109029, 1.}, {-0.39795182693012177`, 
   0.3779834356934081}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.05], 
     Scaled[0.05]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.683261924014382*^9, 3.683261942897002*^9}, 
   3.6832621726793137`*^9, 3.683262250497493*^9, 3.6832626115482397`*^9, {
   3.68326265978738*^9, 3.683262675907461*^9}, 3.6832633099528713`*^9, 
   3.683263381246257*^9, 3.683734378939695*^9, {3.6837344190721416`*^9, 
   3.683734427154636*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"With", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\[Delta]t", "=", "0.01"}], "}"}], ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"leapfrogenergy", "[", "\[Delta]t", "]"}], "=", 
    "\[IndentingNewLine]", 
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox[
           RowBox[{
            RowBox[{"vxleapfrog", "[", "\[Delta]t", "]"}], "[", "t", "]"}], 
           "2"], "+", 
          SuperscriptBox[
           RowBox[{
            RowBox[{"vyleapfrog", "[", "\[Delta]t", "]"}], "[", "t", "]"}], 
           "2"]}], ")"}], "/", "2"}], "-", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox[
           RowBox[{
            RowBox[{"xleapfrog", "[", "\[Delta]t", "]"}], "[", "t", "]"}], 
           "2"], "+", 
          SuperscriptBox[
           RowBox[{
            RowBox[{"yleapfrog", "[", "\[Delta]t", "]"}], "[", "t", "]"}], 
           "2"]}], ")"}], 
        RowBox[{
         RowBox[{"-", "1"}], "/", "2"}]]}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "10"}], "}"}], ",", 
      RowBox[{"AxesLabel", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Style", "[", 
          RowBox[{"\"\<time\>\"", ",", "Black", ",", "12"}], "]"}], ",", 
         RowBox[{"Style", "[", 
          RowBox[{"\"\<Energy\>\"", ",", "Black", ",", "12"}], "]"}]}], 
        "}"}]}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"RGBColor", "[", 
        RowBox[{"0", ",", "0.75", ",", "0"}], "]"}]}], ",", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "0.91"}], ",", 
         RowBox[{"-", "0.87"}]}], "}"}]}]}], "]"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.683262030303484*^9, 3.68326207088873*^9}, {
   3.683262182930636*^9, 3.6832621977268*^9}, {3.6832622532398376`*^9, 
   3.683262253746169*^9}, {3.683262615732993*^9, 3.683262643801177*^9}, {
   3.68326267835918*^9, 3.683262680583823*^9}, {3.683263316136441*^9, 
   3.683263333474011*^9}, 3.683263383313903*^9, {3.6837344313198433`*^9, 
   3.6837344683298693`*^9}}],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    {RGBColor[0, 0.75, 0], AbsoluteThickness[1.6], Opacity[1.], 
     LineBox[CompressedData["
1:eJwk3Hk8Fd8bB3D7vlz7mkRZSiItSnUelVBIslUSUpaQSpItrSQK2SpZKt9U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      "]]}}, {}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{
    FormBox[
     StyleBox["\"time\"", 
      GrayLevel[0], 12, StripOnInput -> False], TraditionalForm], 
    FormBox[
     StyleBox["\"Energy\"", 
      GrayLevel[0], 12, StripOnInput -> False], TraditionalForm]},
  AxesOrigin->{0, -0.91},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
         Part[#, 1]], 
        (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
         Part[#, 1]], 
        (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{0., 9.999999795918367}, {-0.91, -0.87}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {0, 0}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.68326204728004*^9, 3.683262071576764*^9}, 
   3.683262199177944*^9, 3.6832622541502523`*^9, {3.6832626292571487`*^9, 
   3.683262681234578*^9}, 3.683263334124098*^9, 3.683263383735979*^9, 
   3.683734379856062*^9, {3.683734435345051*^9, 3.683734468768158*^9}}]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Solving Laplace\[CloseCurlyQuote]s equation using NDSolve :", "Title",
 CellChangeTimes->{{3.683736885462632*^9, 3.6837369081409187`*^9}}],

Cell[BoxData[
 RowBox[{"With", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Lx", "=", "100"}], ",", 
     RowBox[{"Ly", "=", "100"}], ",", 
     RowBox[{"l", "=", "50"}], ",", 
     RowBox[{"w", "=", "2"}], ",", 
     RowBox[{"V", "=", "100"}]}], "}"}], ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"\[CapitalOmega]", "=", 
     RowBox[{"RegionDifference", "[", 
      RowBox[{
       RowBox[{"Rectangle", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "Lx"}], "/", "2"}], ",", 
           RowBox[{
            RowBox[{"-", "Ly"}], "/", "2"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Lx", "/", "2"}], ",", 
           RowBox[{"Ly", "/", "2"}]}], "}"}]}], "]"}], ",", 
       RowBox[{"Rectangle", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "l"}], "/", "2"}], ",", 
           RowBox[{
            RowBox[{"-", "w"}], "/", "2"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"l", "/", "2"}], ",", 
           RowBox[{"w", "/", "2"}]}], "}"}]}], "]"}]}], "]"}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"sol", "=", "\[IndentingNewLine]", 
     RowBox[{"NDSolve", "[", 
      RowBox[{
       RowBox[{"{", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{"Laplacian", "[", 
           RowBox[{
            RowBox[{"v", "[", 
             RowBox[{"x", ",", "y"}], "]"}], ",", 
            RowBox[{"{", 
             RowBox[{"x", ",", "y"}], "}"}]}], "]"}], "\[Equal]", "0"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"DirichletCondition", "[", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{
            RowBox[{"v", "[", 
             RowBox[{"x", ",", "y"}], "]"}], "\[Equal]", "V"}], ",", 
           RowBox[{
            RowBox[{
             RowBox[{"x", "\[Equal]", 
              RowBox[{
               RowBox[{"-", "l"}], "/", "2"}]}], "&&", 
             RowBox[{
              RowBox[{
               RowBox[{"-", "w"}], "/", "2"}], "\[LessEqual]", "y", 
              "\[LessEqual]", 
              RowBox[{"w", "/", "2"}]}]}], "||", 
            RowBox[{
             RowBox[{"x", "\[Equal]", 
              RowBox[{"l", "/", "2"}]}], "&&", 
             RowBox[{
              RowBox[{
               RowBox[{"-", "w"}], "/", "2"}], "\[LessEqual]", "y", 
              "\[LessEqual]", 
              RowBox[{"w", "/", "2"}]}]}], "||", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{"-", "l"}], "/", "2"}], "\[LessEqual]", "x", 
              "\[LessEqual]", 
              RowBox[{"l", "/", "2"}]}], "&&", 
             RowBox[{"y", "\[Equal]", 
              RowBox[{
               RowBox[{"-", "w"}], "/", "2"}]}]}], "||", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{"-", "l"}], "/", "2"}], "\[LessEqual]", "x", 
              "\[LessEqual]", 
              RowBox[{"l", "/", "2"}]}], "&&", 
             RowBox[{"y", "\[Equal]", 
              RowBox[{"w", "/", "2"}]}]}]}]}], "]"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"v", "[", 
           RowBox[{"x", ",", 
            RowBox[{
             RowBox[{"-", "Ly"}], "/", "2"}]}], "]"}], "\[Equal]", 
          RowBox[{"v", "[", 
           RowBox[{"x", ",", 
            RowBox[{"Ly", "/", "2"}]}], "]"}], "\[Equal]", 
          RowBox[{"v", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "Lx"}], "/", "2"}], ",", "y"}], "]"}], "\[Equal]", 
          RowBox[{"v", "[", 
           RowBox[{
            RowBox[{"Lx", "/", "2"}], ",", "y"}], "]"}], "\[Equal]", "0"}]}], 
        "}"}], ",", "v", ",", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"x", ",", "y"}], "}"}], "\[Element]", "\[CapitalOmega]"}]}], 
      "]"}]}], ";"}]}], "\[IndentingNewLine]", "]"}]], "Input",
 CellChangeTimes->{{3.683736569663858*^9, 3.683736621419661*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"potentialplot", "=", "\[IndentingNewLine]", 
  RowBox[{"DensityPlot", "[", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"v", "[", 
      RowBox[{"x", ",", "y"}], "]"}], "/.", "sol"}], ",", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", ",", "y"}], "}"}], "\[Element]", "\[CapitalOmega]"}], ",", 
    
    RowBox[{"Mesh", "\[Rule]", "20"}], ",", 
    RowBox[{"MeshFunctions", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"#3", "&"}], "}"}]}], ",", 
    RowBox[{"ColorFunction", "\[Rule]", "\"\<Rainbow\>\""}], ",", 
    RowBox[{"PlotLegends", "\[Rule]", "Automatic"}], ",", 
    RowBox[{"PlotPoints", "\[Rule]", "150"}], ",", "\[IndentingNewLine]", 
    RowBox[{"FrameTicksStyle", "\[Rule]", 
     RowBox[{"Directive", "[", 
      RowBox[{"Black", ",", "12"}], "]"}]}], ",", 
    RowBox[{"FrameLabel", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Style", "[", 
        RowBox[{"\"\<x\>\"", ",", "Black", ",", "15"}], "]"}], ",", 
       RowBox[{"Style", "[", 
        RowBox[{"\"\<y\>\"", ",", "Black", ",", "15"}], "]"}]}], "}"}]}]}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.683736635610866*^9, 3.683736751470436*^9}, {
  3.683736805633222*^9, 3.6837368190055513`*^9}}],

Cell[BoxData[
 TemplateBox[{GraphicsBox[
    GraphicsComplexBox[CompressedData["
1:eJyEmnk4lV/b983zPM/zPNumbc97E0qJTJmVMjRIUqQklRJJUUoapElCQlJh
f5OUIqKUJoqIlFRCGd79vPdz38fx/I73Od7rn3Wce1372Gutc63z+/le19Ze
vWnFWh4uLi7ifS6u/2r/dS3G/9Iy/j/tf9/n+N/td/b/bUD4nzGX8T9i5X/E
/77+08/4x/f/ZwzCP/od/7eY/q/W+h+xyT9inX/E/2yF8D9jtX/EVv8z3m37
j37Hf8T/vv65nv/5HFz/z2sxFLb7kFZk0//T/9/xf77/+PvpL5o2FPwj/k+/
2O9WvpzNJPwj/k+/nLHUV4kPjpC7fGisoLGK3Toh/ODFZ0cQMy6+G7v2mS06
QItUWvLv+fT/Y35cXOu32CT5ryDD2nmhQOztD/adAwsJRtdJ+DDTtbgjf5j9
7/4Ni6b5Vwmz2YpqS95HviYh4OaL4r9Zz9ipG+WCTChkZDwKLS1uG2Sb9TkZ
rHxGxqXto6P1vu/ZQtJPuxpzqHj4p0Wdq3OKfeiNl1VwMwWnYjfK+uh+YTs6
bld6FkBBOPtR0ueofrZ9+nb1JcoUVBpcqazl/8UOt/ES9a4nw2OJwrc4i29s
IbLT7cRWzv2WIQMZFn/Y5NqKhfyDZDCWeiyfSRXCzU5m2eZsCt58sSeGTf1k
p2tk++9XoyJkWfba2IafbOX4aIt3ojRwdQzpFraWsvX7LA5p36AiKF/AJDVu
mK1/ttS7ooiM+ov6OfsecWF/3tU8Xs74jUjKDwOOi6F2q278bW0qdueW9tCr
drMjxLpyDnVQoHDmRUBT1kt2QT6f0rLnNPRIPN27+OgY+0Xpz1Pu5WTEOnBV
1ejMsL/kxB9SdaBgblLNd7f1PNvLI+TP+lEKUn8eXdAs4Uey9ImMJgMKpm09
PlhK8+NPO1f57koK1Okf5rMPcEM/SG/n5igqPN6/PHB2BzcmHja+sjxGRbax
2b66d0/ZtXWpPKtsachKEG47HPyTfellnODDx1Sg3OI8r+MPdkjZuIvsYhoC
Q6l5t1IH2I/e7qieiqbjjpjUrUPbBSAprBD4oY0Gw+i6Ey0/y9lHei+nif6k
QYonottq8zz78Lyc7mAVDe9bA+Rzq96z9xQtLKPW0JBBeX/D5NZvdl5q0tXC
q2TojHjfzKnmQw1v9EcZUxLUdqunRxznxVRPQprHVxIsEs+Pw4AXR4IXr/kg
RcY00/WFpussO9YhcYPoPhLCjlh7lB1fYF9vPVQ+XeQI8YDY0y3cf9kxHemf
P54kYaktm/y3YpKdP7Bsvb8ACYayQ/vJVxbYqzZcf1PvQQLPFzMXyp9xdmlI
VY+lEglS31K7A1Om2Acj96yWd6DiRMn7CxIbZtl3a1d2pBRy1vPi9JG7XwTw
UTl1WHiWBjVSXeSZRF6Gw32+Lv3TJGgu/BwTCxNBodSEgYcpFYUqk5nm+4WR
vv1cYRSNggNr9Qx1FGXAyImom3xGwZ8Fk4aZHZKQqUm4Vu3IWW8278cXyTwQ
U91mfsKZhqP7LKX49GfZddXN4cKvqTjPlEpyFOJClF0C+346DefneIqEFomA
8lZZR0+eDiNV/YeOLT/o2gpe9ddySZi+6kwk2wtA5QZB2UGaDHf/M7z9goLQ
mhpyWMvg5Iv2MSDmmiI6vY3oDfwUXIkpeZj5XByLzuVkv0yhwP1SgnjxkDBm
/roczuul4Lx73jLb36JY92hUvmSBkw9izh3SoDBCnwufEuPs51N+7sRyFz5c
vrn5jeIvGvjf1J1fZiGEhUmNR6s+0LHL1jNs1yVpfPzZc51hTke7UVHxRz5J
HGjxtToVQUNOzpfIFD8BmJFXX9g8S8WFKAXViBlhqFF/71miQ8ez6uXGizb2
08WqyrQ6l9FQOpmVqzz7mW5kLaat3MLZX5e+xV0yHKXnMMw0+kOokKs8l9Jm
LYclJRE1p4IpsPutcHUdXQq+HkPUISEyrnekPfS8Iw0WcU5AcSMN9afyJ8b9
u+ixW/9aP/tEQcqxIwrugTJ4QZ+/rhZNRQctzSK5VQq5hF7CTjINKruSN8kt
ksKpW4/ujnDOT8VVJ5nWCkmEBVYx5dzJOKczlFu5II7L3/qs3WTI4It9df98
gwjerUkcOF5Kw0KBodEllgS+JT0Kjh2iYs1eMX6vfBls0hHdqNxPg6zghl19
brJIE6tWzuecnwSWwep8ljTGL903aVpDw67e7/OWT2Xw2Sd/hfMuGnjK/VLt
veRh3+ZZ6viLjrVFgiOvNZSgQX0QvLWPinUXwVYpkwd9R3KtriodI7bRMmLV
ilgQMSG+iKZAomW7Dd9RVaytl440qKCh4n3FsQ8LCjj1yqstSJCKt/ID72zN
lMAk35yODKTiEuPOZbm1CjiiFHuprIQK+spFgmGXlcD7e+uZW4co8Nx/PHh1
jDzyDQcoplxU+Jy2vx/Cksf4gsCn8qs0HHoQH6bCrYmXpMdXZe2o2JTkmrjD
XRV8tuTgooMUkOnzqmpZstic7iO2ZikNYjyu3LeTVWHWpEX6uJiK0Nurrn/I
U0a8kuT9tyo0pAzf0CouVAZ58Zyw3h0a8pP5RCrKlJFm9EeX9x4VsZI7jjS5
qWLdlcol+lNU1Ld3NkoraeBRbvut1Qmc+pbQaFrip4Kek0E7HcrI+J2kcNeQ
TxqWxS6i22+Q0HRHofzeUkmUP1ozvt/YEZmGMsVzxvJwjNnkct3WEYc6biq5
REpgpk7fJVaIBDNzT4/uPhl0uTe+1P/tiKcnbuzgOi6OlXKRmbbcJMiv/P3j
6W4hDFeWDRBSSFj2lLTkfpk05hUlma/4SbjhE6rn0y2FtLpb2ScOOOJP9ZsP
dU9EQH+uf9z7lwPIPPqd9oWC4B42Ur90iYiAyuDqD1uEQPX8/npIxBGRsUpz
rDsi+LUiYUm6PQWyHabWPmuUkOLi+UV6iIJjaVVWJ8s0kZfhaO8dQ0NHTu0X
2yB1ZC/9faBRhY6ladrRFU/U0BP10iT+Pg1PUkKjzx5QRVvSL8eWAhpeDmfv
HI81Rd2A30dtTr2Y8LYsvltlCj/fEBuRMDqib9WKtGzVxMWf7Z4Ne+gYS+JO
sslQglHU05H6UxScPb7kjqqHItYdkb7/7CIFp0Nb5nwvK8NLhVL8aSUJWXv2
5d0YU0X7r4Nyp9PJMBgsTjcMkMfvfYeEZubIWCItb7xYVQ5m/XYvwcmPWfHu
w4tH5GC0h0yc46MAU5ue+XkpgLWaZ6XgLjJ4T6upVmjKYp+mtPIRHTLihF3f
1XjKoU9E92X/Kwo06Rb0cwx17Lq89wTveioOZu5R2b9BHReW/TH7+pGKvMey
Pb6ftLGdcmI025UBQrTOqSkPNVQ3EcWSeuh4RPi6m+elGvp1nrNXb6dDMaYo
rplHDVSfaxWHQsk4efT13n0jKjDXvH5HKYUMzcUfU0wNlMDj8nH8FIeHOvsW
LB+3KYPRypv8/SYJJi1ivq1CyriV6cx/W4KMt0H5rz5eVUDFhoJ9uoZk3A+Q
fM3lr4ygD1focd8dcbOI0C6qrIBloc3hWeocvkgM2yG1Sws+JXv+CAsz8Oph
tUvOIRXs2Nwr5rSMiQtfPxsf0lGCJ/FCVOwdMlSnWQqPaGZo2Nb76FmqE7xN
1B4QXwhiTcybeyahnPO397GmNb8J8jyVtoccJyK/qUZxLMAGFX/n1q/RZ6F/
hUCle44WDhDP1OZbUvGE3GO18bI5smc3Z8RpM/EqsirfVkQRl4SNBwZDGfjQ
GpLo1aIEn/A+Nb5TdJSZrs2YkddGHpfCYOQaBoYOKZ7ivqKCxg9WVvpGDMRL
HojdrKIMaaIEwfgCA7likgGwUsYeyZCgRRcZuLnlsNoTH1kk+E3t5M9l4K6f
tvU4UwH9V24+WzPCQNM1y7vNmoro3teyoSqRDtPYM5T0JnXwXNy8rq6HhOP5
IiHuKqoYUL7wuoxJhpph7Hz5kBbqTy/awTVKQj0kUn8c1+DwSU9SiR4Zt2pZ
p1Oghh3b14emd5FRwbfBnfeHGq7MJhDCZ8nwqiy+cD5UFb27P2WRPShYVBan
J1GigYL31WulyRQ0PV7+Z5unNjpP976XLSWj9M9vb/dCTfx9RvlgGUcBd2bM
lo6VWhj0XbWb2EKGtBNvQ/YzLfTz5u8dtydDfX5tp/OMJnac8vZYto0M7kWV
n515NBC3QsGT77Ij1KbORFB85JC3cPuArrYjRD98cf1mJoOgldq77p52xIf3
4qemP0ijzX21gxeJBOpT0zFigRwWEk8Fr9lGQvi9N43jswro7lrbqDPiCOPB
kQe5i5SxYmlYoRedBv+QcSXNUE3E+aZsdS9gQKVpMVWnSA13Nl8SiOKcn8B1
G0SOdmqhxpvr2X3O+bqz7Vaz/iJtzD21ak06TAXJNe7vuf2a4LrI75RwmoKn
y3d2iPjo42mZq/F0LgXW1w/0RDjpQlYgx4brMAV5U62XEix0cPUqMamMytHj
tV+jpNbrYPGxgrgtiVQUaWYtDSvXxqgTfI/GM7EoKCbiJmc8E+HjXMe7qfhs
c3akOUEX/IuUM4qvUvFsbkXyxks6CA1dp9FFYuB53sgfHXcFXAiM+/6zko5l
l4k3q8bk8PvTk6yStQz0Jg2OTSfKIbu9t3iHOgOvi8Z+VzjIIWTpocStvgw8
8DFrKlwpjbHN2imDC3QIPpETNF+igIif99/eqWEgc/+tQsM8RZwvDdJ40c7A
9TeR1AgVedxifq9s44z3eEx/ZvmYJNwcmlz5gpmwGrxW7BElh+kCV5dGRSZ6
5RhCsp7y+MS3j2e1JBNhGuujxxuk8W5vzKcV4lQkc62ycc4yxW/zVyqahkxM
UBZnHN4hC9XAovzkVUywE0zliIYyCFHiTfUY5MynyEvou6Msjmr2vLajOOHm
Tkf3b/ukEaxio9wY6gQ//oerXpqK48a9d8du5zIh6/qpoj1SFrS3VMPSvXTc
KC/pWUY2Roh/36rXB8iYEb72Wv6iNTRVe0wKzjBxI0+tu7xWC04ZPYl+Ikw4
hj0RuXtNG9zcB8VXcviuMnVx9ofvZvhFqH3WWGWPE0eqa1Ypy0FVYdG3enki
Qu14Iug0KTi4qQm/SyeCh2xRrWAmjjVt5l7tD4gQ23D+0v79UpAo8CzXeWAD
lZKFrOzVQvBf+2I0hU5E7WUjg/s0ETS+2CEy6k2C5eM3O9RlVSA6HkMej3RE
jPbodcnTirC2iPx+0J2IZj//e39VNPFj3pSl1+WAFJltB5QrlMDfaJrzao6I
9Zf03QWrVCHOqqeEceqfwp7YTbd2KELePesAI8gRKpnjtnc/K+Pel+I/D646
4jLP4z1FkWq4+1ZGzqWNCJWKX28acpUhEfq7f68xEY0X82Isa1Sxfs7zR5MH
EYW/1vCRjZRRueKU6tgCEVMNpTW7nyvgUcq96tNaJDSb1NLWTGugRuw23+I8
EtxTDxhUHNGCxOrsGGMdR3i3jbZmc2miP7j3IEuchBX22sevk9VBinszEpBJ
gkNVvZ/LBk3UaT9rvxxBwnynMrcHtz46N/x11GA4omm/EK8zUR1eORorPlZz
5psastnwpDosfLnMDC5w6kXoseIaO208631a/bCEBP3gltz8Th383j3854wo
Cf0lnrZrMrSwcVTsXtsSEgrfWSZINmhjwtPDh3XIEXcdEPnFWAsPTW+qZD0j
gajqUv8jXRtBf5denCt0BNdq67y4rboQ0oquUXnsCNV3V/Uq/XXg8HVCy0eP
hIf+j6evW+rC2WhJlMc9IiRKxx/vW6KDIK/q095HSfA4XjO14ZsufHINmlbM
O6Jhr+foGpoeeuOO2ZZ/4ewX0501ah85+rS+51y5iyPaitbKvebRgeWilhqN
Y5z6ue19zslKXZjLXh6qmyAisUI3956DIdRW+15kcPT3XHfOh5J9ujhR/p67
/ygZGb8yRIoddUA/1eB3WcURoRNX85Y76CMKQdRz1mToM99Feqrqw+/gpuk9
0hRUOStzCTfpYJFgktRMsiPG5H1ftCTrYdaH1K32mIjy7L0UoS5dEFfsNX4n
T8buW197eTjz/1h7tKpgEw120ep+q5K1kVn7Q9PtHQ1fdk/e2V2sBY/UAyW9
vGRc7a4dU0u2glTDbQ9eZzqSyVNuQ4F6cG48+8pQmQLqDp5nW0hWUBDkXSJU
w4RO3/iyLRtVkWSyXH+ew/eTbrWenacNIb7rb8mXTiouZ0vIdMlog6t0qY+U
HxUL89bnNlTpoSRK9c0bfY6eGhbtPxItA+EnCic7FRmIuXHynsoZUYzNiKht
v8mA6nx1fo+eFEqfCJY9JnN4kGSgeVbIDEG0vlLfxTSc7DnyMGy5LgrDPJ4N
8bAgwx+VxbVPAjwP55ZfsmTC5PfgnrdRqtj+4t6TABUybrgY6TuZEcCdXFxV
yKJBRGfj91F/S/zYyH//0iATl5etL1Tzl4bHhip9+ztMSE4R7Gd+S6C0/ofe
82Im/HMW/P5ESeNVfUoaYQ1n/p5OXuVdXJhQjRKkP2MC1FfCet4CeH1u9eDq
V0wk7NuQ1dYjgsxFRqMScUxczHbr8LUVRnyXekVhIAuiS9sMg+4JIvD2+Y7P
JUzU6X2OXfdaCG6EwD8D6Zzfk5J/6PCWD9f+BJ2PP8SEhD5VdWe6GByV/wgZ
aXF4qVApym2tCOrqA/uj+5kQyVqr+ma3MmKIvlufUVjgepEYIlAijsy7Kxer
jHL8dVLBZP+oOT6nfPQ7P2+JsPgHN0tf8+LzuJxbRQlHr/S2Hl89po1LRbHX
XxMZiA78Q33b9onecPCgGo1CR9h3H0HnNSYwXp93+ISXE1CXuj3vkTC0etZ2
3/yv53uN0grrq00RrSDvtppujXTebvOnKcZIaA45+kCQgMtv05vWSEtB4Drz
pKYjASsUi+duLBGDemD7Ee6bZFhV5MjylloiW1s8nzRGga1tbEuEkhUu9kxG
cl+lI2J50bdtPTqwFojous7xl9s2NjyTkrbCC8GRQvkmJhbvWXZJIF0D9w5a
qHaaMZE+Zlt1mjRHP6IReyWW7YjJMNeSWwEEPCaefW3IYqJqi9uHMj0D3Ir5
EHqXo5+8n7lZzXKamNnYcfnbFTKGjo+98BC1gHeGR/TeKgb0iq3VbrVO0Gs+
q9ZYRpGh7flj3IfLGuvq+JfRr9BwuIwxNPrEAoOicYli6zn5zBvNlAtSgOJN
E2vhAQpUG+VfLuqwQgCv3u1eqjWEJ64POcTpIDrs1NZVnPE7SVb3pl3VQdod
A+ePvAzkHA8ToJnqoy3fV9DAgsM/6y0etZhbQ1BxDX/aQQf8rLQ5b5RuCbfJ
w6l0Tv0falzsZf1MFrwK1kv5OX5ut8u2Vt0YGZC1S0nRIg5wnRvTGjWQwpmQ
d169e+1Q9Ws+TLFUAz/f+v8I5/DeypQ+k6YIDZDlxV3dZIiQ+Zu6TIykDVqD
n8DdOiKcZxoXhLi1oN/o3bFvhIxfV7Z72E/rweq0zslnZSQseaDv39NoBK9z
FheucHjRfpiHzSWgi31KxYe25DmA6/rfbUr39JGuyvsm4xEFB9coP5UwN0FA
h76vlxsLsruq/szya2LiedbS4wV09P5NPR9WqovSS56iezfQ0T3RHVX83BxO
5oYH0zj5mi/+LS5MVoEHsc17OIOI24px51+/tIG+o+oYZZgFlfdx4RnnxPCV
uc3wK5h4aSAYrXZaG/w+Ds01cY6YcFWpN3hOQP/UeMb3PBYeVy9Xs+HRxNyj
Jn3PvVRcvX/4M6+1FY7W5Ox78pAKM/V2ky1mFni8brBZ0IDO4e98GxMec/xo
zk8fLKNiXCsAqYnG0Co5H1PbRUJM1p9++S3W2OgsrXJA3gkXKu85m5Ik8Ths
92zSIA1ZuVN8K4aMcIx7u+76HDIEL28MWhRqBa9pl8bBIjLyHr4a9zUiQDeI
adLy0wI8X5W+frVXQLzqdYn023Qk2O2en6FpoZP776dmOQYWUjuv3KZqYUuo
5b2bytaQ/OUy921SFP6BE9sSnhAgW2K/Um6nKIYMblsINVFxnL0QJR6kh9x0
3kMbOim4OCwRfclVD8O/siSOuFBAW8e99aaJHi5eTA1P0mBg3LJv7MyMJKTG
ztwVq6VjfFIk6ABZEgU3Ar9tW8+A+PN13o89xdFzd0bKKImOukcF4WPiougV
/pUvm8pA4BbWtAFdCqdJlZuy0xngFz2v9rN3nm025adU947Dt39iD1YuFsRH
paJDYRZMHBGIuE/W54fLeLk9eTUDJl/Ol4rYCeBVUhljUzUDmxs+3zkWKYqD
dlr1BVpM/L50qVlXUwS30tRWVw4w0O/fUCJkwo3FyjsTFJczMOX1V7LlgzDG
9MRc584wUIm1MUuKBTFkJN8ufZwB3ev3/nak8IIUWXh98gcD4UHy0RKN4shm
XSII2zMxxKO7P0FNAgp6Xbv1Zhg4k38U17344EtveCqlx0TL+zr9XWbc6Fz8
dscqPk69f6D9nX+4j518Z+3eCyQmCAJqWYj7xR4xIJxdRWOiW3zO+lyrFHZa
DIrLzVjggcboTfNqVaw5Yu4RyWSi/KhS4jWO/95V1LH+709rHL8RoZxXqged
ynWVs1UOIASqGwzZWoEcMJP8+qwVhiqFz25yMsEar2e1SgNWSB9+0x+qqA+f
9yzf6jFLVFADkpJHDP71XoZh+e/3T+yyYq3lDb1WIL670bWSYIiacyyv7joL
qG1tkVrmzQ39qSCHnEcsTOt1nQ2gCCPrAMHI8gUFj96GhHWcMEN+S18H9woa
SptzT20wM4Pq2LX28p0kUJqEbmY0EFB0dMdkKy8RWdTdF96YKuCWXLx3rAOn
fkWl8Y8dVkC95PUr+hc4vHzG/5CBnCK+BhDUlhx1gPpXNSfuKxKYf7Cc+2Wl
HcdncpvQY/iw+c55LsdH9jj9Zp+cW7gaKpIy9GQPEnEip5NvZLM2qjLjvub0
OyCweGLToI4ujj/NFs6yJqLS5OPqZYt0MDcvIa6xmog7NYka7va6IFU1JNL1
ibig3z11/oYerrE8FK5y/MjiHxpFo9l6mE7UfbqpnoSE4vhT6p0GoOY8HN7j
QcdK9gpfnjU62GU+eLFjgoZm64n9Z65oozpEU72So9fZJ+ek70QpwV3cNQ2q
FLDflgSsSLVAqWk4rfQ3ExeizrKiElWRe7Ou3JlOxczAs7KwUQtklw0eLlig
op/hvrP9lgmGl69+tvUTFU77v53YNm4FFcVdD7eI0PF7e1MRyd4U2xbOmvGe
ZqD8OXFfQLIRUr+UFW9kUfE1c9pfccYY3i/XyLX5EZEhcsp3dtgC15w33d3k
R0ZSy7rU8ucWeDm9Svu6miNq7C7wDqfZglG5643sBgaemG04cTtHHSOn8l+R
l1KRf0SSJ62bU7+vjjUY2FCQFeVo/4dghL1vSWZ6QUwMeC3t3tE+RY/IU5gc
CLRGx57FRiEsGYwGqO7nyaOg+qjxzR/V5rCyng2YuUrBoV0rAkLeWKDJd3LS
7ZAVIpS2reg9qwDLB7ql/C0sKG00tI8flUThqXHCvY8MOKZ4dV9SVkVYzq69
Y29oQAffHcscK/ipPROJNGGgJXf2298MI2TKeWeMNTMgtFb+PJGqjU93f7oG
RjJxqv/y9A0THfj2S6Zk/WRi+olC1PQqdcye6G5UDadAN173hDLbAH+XrrtM
GKJAambfieyDBlh8JfDzugkSdprxZev1EJBk8yJgSymnfl1dkCJOqMAiqD52
bSwZxj2KxXVsjp7tn1e25aHg7+V9wlF/OPxT3WHocYsEiTjLRTqfraF/MulV
eIsTNiTq77E+LYboOqb/2KAFomXvtZkYKEHbpdWrR4uArP3LZk9x9uepGZGb
d/qscZ6arfJ2hQH8X61UkF/CQLz+2ZfWK7Vgd1ytNiqZAr57636fO2KIMtcI
4ZVzZLwJSUz/bmqK0u8DRKVgMlQcPE1b3YyBVDf5MU7+3BzYfzK1jXE8cORG
jI4p7mS2W03HzrF9SPsv37pohqfa/RfmWHKw/BL5V5tCQLy6pqjAc0OciNgW
nT5pgvd5a281bRPHVHHkCgFPS9hRI75PNgvgzL627cuZJrg1GOwyK8eNEz/T
tt3YSMLpdu2bZq4ETEbtf8pQccIhXvMqA6IIBGpNjq85QQaP2w+vbZz1auL2
c5ItM8M6iWfG/fGqaMuNSLkmycLpsr5ZYqMMDJIbJszHLZDQq9+76TGH31ZC
aeltJrit9w9/iBdhSJfe2qjB74y3rlPLzm4QxIwV/USfOxnF6ybFpXMJOHNp
wf68AhPGCcEPAgo0QWO7TxfmMWBwmVv3b5IeDp57MFNhScPZnc4yD0b0wPVz
c9e3DEtM3lrrcCVGDnLRylbzFywRX69xPFVLHwumnYuhyMTjoG3XXxnrIXHa
Up37tD3+3Gs9oj5sCrtHYd9DSmk4HseOXPfEDKwNPAFvjrPw9mRV9jWyNKo4
CjrFpOLAlwbfVTm6eEK3aj/bwYA886+3rOkkey1ZXNNynonMNztuJQopYrzr
o5mimzVWzMVYVI0aoj/TaO7V2kUIeuhuPzHxnZ6674Lomv/ip52HPMV+6OHt
9tZfjy9boljKw25oyQJb2+PBz0/mTJz1H7EN5NSvzOvcX2hZLEy01trn+opA
b72fe8QUC55/LtYc3fqGvYRoH0xJdQCZdDrZbY8sDn0hr09NdMBbuZoHoZHS
mBCMsCr4Y4+ekK0Roq4yyNkRxxjrsEP4Oi/5xBIp1C5eOXUvzh599KYW0k8p
3G8mK0x/cECCZztdNl4OjyMXpVv8cIBz5INdD11kEPorWStbwh6fC5590iHI
In5oPGnrEluOj8tq0F4QgUqRZmLvNnuUmIl+O3hVBiPJ59eF/bZD4m3mFs0Q
JSg9CZ9tUyBCk379wwcqH3iS0gQ3W9qDGnXJ8dFzeSxtJC4xfGOD6a0J32e1
5XGpTuv2lmp7LCl8s2KXtQK+tU501Dy3x69+uRl5Z2UstNUnr/lii/ejKybl
d8ki7aAWlTvZDpo9aQ0axTI4lvx5jfFqO6jZ2jQJaimg377ZX3CFHaY6C0gq
vnIQZh32Um+3g0GrfE1JrQIuU5f501vtoFNXmLuyRQ52Vo88vGGD/cP+ebzR
fDD1WDJV1mQLjc1PNm+iCCL6XZHmQUWO3pc+ZR/WF0XztSblP4X2SPjRTImb
EEef5Bkv/XgH/NodjihzVSi9srdp5vA/9z7NB2jVA3OZjrH4OSKeHp3vPq5g
gL0S5IcWUw44nM3lH51viJQsiUyXDURYB4T5p0kZIq28d9PvSQfwhVn3Ru4x
gG+fdbOHFRGP87Y36Jbo48oH3drCTQ64l3GB795yPfgFc2cIPCDBMLrprzj0
Mb623MaIw7NRowkt7zQMUX9xM2HZIjL02GPpbCsDuEacPczbSwZ73cOyYA0D
NLkuinu2iILoo7JfBAf10aWUffD3LxqqVbfceltigB/rT/aot5HwWtBpzEDH
BHrnAn/K7idhf0vg+jt9ZljR/CBzdpUjxipNu3NHjdEQb1rc1kOCpqzqeas8
U/QeomicUSFB7sPrq+lXjdFcIJo1upcEe6mGtPX7jGHy7ko7fz8DsznL9EJJ
OigtKVDPi+HwW5LZuZv22nAX5BOPWGBg+Eq90Z3vOmjSy3ontM4K9T3to4tT
DOA2biu5/ZU1zI7dr/b4JYOffQJy3w6YQYwr88iT7ULISBeLLpPhnOfQVerk
EG0kJO78eMuGhta/z9yWjnPWS/EL1w6QERF4dPUVJ2vUau4voOy1hiNd0mRE
VApCv1e/afzAhP/3Tb8eV2pBUeTz5/vGZPS6UpQiP1qiba59uIBJQcLmTylj
yZZgzSoKmhOcYOmgHaHTIIAAvY2T0dwUfL68O/bvcnMw0ny+Ft2hocKwYfE0
nzVCFZ53DPwlInKqW433gg2OnHLKMvhEQYnkl6V3B4xwQexn65weHe2ifBMb
gjn1aftQaM4SGtwf3I0UCtNBwjVvE1YAA6oigkM+BtpIH+x2WalBxvhi66b3
7uZo4O/wW+VGgrXXMEFE0gr7PhZyrfhGgqP84oM7E81wXm3dnh85JCyPaN/D
nWWBvHpxm5O1nPtJR3X9b5jjkpd359NXVJRX3HRMSrHCjakSZdlHVFwjBonv
5uiOsMJhW9MWAiRivtGkV/PDbsOU/cgqGra3qp4eOmmF2hLDrGsRBHR1qvM9
4dRDlwzTPcM9NPh2BqeqvDbGgkF5ueoIA0rxfneLcyfp3enlEuYHOZwyNnq4
c0wcA0yf0WvfmVhxbMPn6I1yOHuubOqwIBN3LxPE9qz+wy5rwk4PDq9XcxcL
36j/yz4RvtzT8RoTolvFJ8MO/GZP/g4/suMOE8xMLpeJPC50qhKSzmUzsdL2
7u6t5bNs521Wc4hhocY7zcGoYYqdHMkyCRFmwS5c8/D9oRn2nH+7e2k3x99o
XI4zV/3L9lHq6TzYyABRSkruz5pZ9u25kOgIGgNark7SPEaj7NuUuq3KvExI
jj+o+6L7nS08e039qy8BzBeNnYfMDfBx8GuU7VKO/+ENOMv/Sg/dUVvmt/sx
IDeZ/6SrXBe/JM8OnXxLw/JKuh7jpB5WDPQfOyhmhq6Xhr8+diuDKJG7yuWe
E44ejZL2VhVA2vLfTSubiPjOe0tib5QFfAhpmx2z6HhXfn7G8oEBwiz5XERI
FhDIaHzSnq0MoViub9veWKJOv/yj27giGo6mHPh6wgobmntUhAN1cVeZXXL2
pxV4732Ze3xOCkHBnv6e+4zQO/FY77eGHQQWUxLOfeTww918865vwoyVCUMb
vn+wR+wZFx6Hz+Z43hh3UmOpEXY5fd/+aQvHPzu0+OqyCfh8/GtNj/cce2Jb
hmVsmyU8N6wcpPlqYcHi3dOAszr4zr38/I8qO5xo2/Z3eYMzDMlOBuiZocdv
fOEwLERHj/iYtLyAEcSen/KrXszCEZ5bTt/WSjDcMx+fMyhiwq/OrijkG/e/
/7/33/7KmLFFL/dL5GMWXiYTHfes5GEsuLgUhwbroV2z8ZTqUXuk2tbZt2wV
AtFw5fmefFsM1Y3Z3ebob2WWTJvhQz7Gt73tBizZRajcpPv46GNpRs8pt2af
SBb+MHtuv3wkz3jXOftR97QzuL72mf8Y4GUEbIy6cUeIhSwhtxD6q7l//R+P
ocn4t9+LNVyicYnD0yKsTiu+FmNUJq2OaO6xxF531zO8/mJoFeM1bBIzBdfD
A5ufr1HG0yFjg6R6FjL3XAifGFPDjQxf3+3XnLD2ZH11lvhvemXSW/3mUhbu
azt9nhySQVBabJb6fhZaRFM1q50VcWS3u9QgnCBzzphEuCWDXiPewidJLGTz
z1xJrlVFxsT+rAVrJ6x2Opo466sMLt9f1evUnXAm6OHQ8KopukjKFj2HSCcc
a763RaGrl67H9fZc1CQLXZVZvme3LNDLSpz+Dj1jYZ+8ZcKx0N/00f1+loqn
WTj4p31/drEcXFaT4wUXnGB8OP6r6XUeRkfWE79SFxYu/vxK3bpahDFz6lEm
bxrHj9jHCR9+S0Di93exqVKmeKvR7nI1Wx4PXGWtNi6jw+7dSQe10/og2Gbf
uTjGyffOpAC/rVN0sbY3qiLHaKgXSJkUGzaE3t54vWEOv7qvWdLkpa2IgE97
FB92MVBFzxp4x6uHBYcXuu1cVBAPFpHODFqjWrIuKIWznxJiQ/oPecpj70iq
rsUbJ0i89rc4vYkHmlMdehtDrDEW9broaY4e9nQe6Nlka4nkX+539g4po3Hy
fbfPLSaGU11+bHsphzB2UEj2mBWueLF3Tijp/WsfWln/x++b3wg8cpafhB+6
5is/3SRg03W7LrauA7wZ+7a11crh92XnL8JEW4xZL/ppUSqAB4enbWJc7Dk+
CFvEK1WweJ54eV7HHsckZnbT1qnDIrp2PxeHf7yeOHWpqKliu3d2Be8newgv
/CB4ntaCNGlhsu+pHc6qEUNgrQJR9o6QYA4fvdL6QRY+q4QTyxxDHUvtsFjm
vZ9Vkxr8z468DyixR+BIg8eFdxrw3nFY4oe0LcJbKA4dISqotvS4055jiy0l
dd1PJRRhtJIoqpbsAKPAoRjPUQ3U2r1j0CTtUf+yb51tgRaYgoQ/YNvi26a3
Fy8oq+DgjbaoBj47fFNwFtenKkLy2uHDR6QcUJWaPmh7TBP5PhX5Q3/s4Kdg
nbPNWRO+m8Jq45PtkfebpD/G0kLWrkcT79tsUaf9I+fLIo4/jskNIYTbIsm5
7Vz9ayUETGsJrq62QXOk+OCrL4ow0c0l7o63hZf1mOOmB6oIJ0wtrVS1Qcwt
8ZHN3Fow7T76ZXWVDcrjjn7dt0MdVYVzyYd+2+KuTpKE1wVVFJZekJJKsEeB
4LTK6HdFDHvG+Hy+Yg+3m1tsqfXC0FJc4rS71wH9VnuvsONVkHI07LkErwO4
9TyvhvepgDjx+nq5rwOWLLmyRtReGeWnf87PvnaAwreLxs38eihLE5c2uusA
4nOivARHH2fXq9Yd5aXgbpB4r5G/Ibq4y3YoFZHRZRSxbaeTEX6L9todkiZj
h9FMKbHTENzi6vmiriRQpC1Lq0ZN8PFTdea9YBLeMfvY+qOmMPVsW2rYR0Qy
7wyhYos51hWvivZLckTLgd77q2tMcX/5F+lVTx3RsOrmtfzdJuBZ+Wud9WlH
jGxzN37pYoTQw+lqWfVMeGxYH6rUJsG4822p1UFXBnZHrtmXdssAD/oWKY8+
YeJ56ho2gUsWj3WMqk+biqOt28rTbsge211vvrvz0BS6wVkPJHcq4tz2B6nV
DdawGZgLIZcZwWT/WTbrgAWeBEdJLaUKw+Q8oSLDmoWx1WUbGxL4Gfxm0snr
q8goexiU+263LWTePw7JuMuESBQlSkhZgHG47urb/Kvm2HWsrzqiTgslpZnU
3ZMErDB0nrjz2QAVtYwNtpZMDBg1X1r3nHNeQjemBsdSsX9xwQbDZDM0u4u4
5koxkd8s87y/RwuvD2Qndf2iI0Nk4Pg7MwNY5DjfIwdY4H2F7ci4oRx+rdil
q3DTCl+4NthJtBvhau6Fgk9FVrCbdy231RSB9+VH1kMPLHHomdnFrFUmON/q
vJy7gQqRF9ILYc4GMClwvKC6lwaXiHvm7/I4/Pqkz23qDwuBxOy6jdcX2GcH
tf/6yXH8n5POW+uzN+iL26zX3nRjYdvbOYc917mRxFOTvn4HA9Yn+X6Hhf1i
B9nadVw6w4B3jSjtXno/W/TEq9O5rQyIuz8cWan7hV2SVLevehsDWYc95S7V
jLJ9t20LZGtaYfXA3y9FxkKQjCHQb/pbo9nD/0eKLj8GDnxxLE1jQSKQhy/s
jgRiH51bG6TKwPM9ubNELz1c4OL5VbqPiVJWwJNpXX3s/p0tNPSaDtZBkYYX
R4xQuumDR2KsFSTUbL9v3KUP69CX24wPc7jAUe0F+5Egrl3Zr3LXjAXfdQ2B
2tfVcIQ4/fR7CQPcX8RuGurr4KbN54eHD1hhrfGKwqVS/NAsEuW7f8Yaq3o2
M8ssRNF5qTlCK4CC+mONmiuKzPBZ1yst084Kfx462a87Lw9D7n4TEX5HzH8x
7buvaQP71EJ5r1pr5H8+SvWJ18co+/O6OR0aormCe0dMjDFq8uvq2y2WsLPY
V86/TgYxJ/ZrZFNZyGCFB85dkUW39l65NhcnPHiT/tovkBdCIicYfJz8LZnY
/05KSw+DHpGFC6ecMFj/bGltCA8CdvqidN4JW97F1adbzrOHC0vO7xhgwSW0
u22tqSzKrZ9yDzHskRhyquC8ngCCqUaRwyP2uCJWubauUAcmwwoZe945gGdT
QaUzUQti/VVdUgkOiDPnW6+mr432T+FCg1cckJa64qCUgQ7Ip5VtZxfsESHZ
bS5XqI3HFUzV+1724KWmOFAHtJGYmXh2X7Ud9GafL4tz1kfRzd45KQ7nPKhd
t1jjoA62vlw+bG9ujyTtH1tmq3TRLHDrU956Ozg6yX39+1Ybmyqsy6diOfV3
10i83GsdpPgGh9h3cfTh+CmjJ4O6WFowY6/zkuOvC72pS2p1YAwjsnefHfa7
h/0qTdVGY/hrmcwoeziu3XTUQUwfFV/tpB/+l39vPSmg/VUXFhYK/FH9dtjd
fPBXYLQeNsqalz7StAVlo2nr+BF9XGXPWbt+soWrFeN4mIQ+jKvms75w9GuT
+5azAw/08CnqXstFlgOED+1VuiWjjpD7l9YOtDpgeNMSIRtbdRBkA04dU7BF
RfKP6jPtChjymnA6s8saxNf1Y00pcvBN3XjKimaDPXwu/uFVKqjvlMxOhCN0
Hn2pkntkjnE1/0rNG45wi34/t9XWGON3b2/o1SHhimx/9eBRI3S4zx9PFSOh
YAlz2XFjQ2xftu9AbLMjhhM+Cp54po8l0+N7G4JZOL6m757pEl7GLe3wt5Kb
DaF/luLrctkWIbfO19FKFiH3Rr693cs5+p/xEh+uzFH2dNyyno5gAt5HS/oc
2EhBbJu+kV+hFQbJZaoHBjn+QZmu8jpYC8IWq7u4NFlQTKwYT1HQQ8bPjU/q
N1NRmB+f2hpjBNJtoxCnUSosuBtOrq8zRcj3aX4DcSaGJhuKjlGUsXMx99m1
axlgWp3v9KBpwucwKXpVvBM0lE27ZnhkcTN6pNeDoy+vQg+ELR6wQnTFG889
QgyEXkvI0InTBTc7pTfyFwtyDx9cv+MqjbhH/YMDrnQ0hm6Ytz2khSrt8dqG
g1SEB7HvtpsYwmZhvra0xxElw6Px61xssMK3tba0lAkZamMG84ICYvftO9N0
hoT4gYLlzYmWyB1oH3TdRcUGlQybu90m2CvzOjrrFR3LJG/rTrE1ELPm1yqH
b0xMqwUPNHNLM85rtVQVLmfhLz33sTiHn+c1Rhn7Rawh+0DY75GuEFT3XF6R
sNwaZi3PYojZBogoPXLDOcAKl8ucuKf26OHWzu6QiyxrCNUwJf2K9UH9uFHC
5pM1ghMdpr8yDUGoKOmQfknAfEZZ/l4zfVxf/SjTZz0JS3a6UXrcreG6jhCi
F89AQNLYcN53bSCG+wHDkoUPhzWPNElLQ4PdHaWmSYZGc8SVGbY1jm5qiO3k
+IkB2tzB2EMyuODvuvNRNwG7j7yhFgQaY9b+irQ3wQbtC1a56gfFoXPB5drX
O5x6H/Hr/M+uP/TxbwGfZ/1puPbh7OTOF+Yo+nk54fpnDg+EWVEVfltB/Ypw
r8YRMkK2LqskK5lD2pB//8pxOhILLm73DuL4sCXFfp6HCFB1sJB9KS0FWkHD
1wRVGpSjD49oaVkhK6ijUHARAwqaH5eVJupgJUMlN3gXHXsu1p+emDCEX0PL
aDlnn5ZRLSgvbxijs21ZFNdlK3RHv996WkkCiS/ntE5wMxBytKqWO0IH+f6j
Bz7OMRHhvTR5NE4Ttm95Er9x6u0XwwttV2K4GEfVrnWq6zHwS8Pn1WUXDeRs
Ex4VKmBAZ8P8bNtuLST1rxn7wvGTv9ZGJxj4miDv3u0IOp8VNlsYi7wKNkIq
pVFyMNACW7vsn7Rp8yO720vpAImOiKMzr9OZVuh4Z9O37jsZrZO9gxl1VpBS
URg4wsn/qU3P1d0zDcF4XbZjk5w1dt26vJdf1hw9SZ+Wsz8zsPn721dH9ujD
6p134Jad5rh7rfvpnlxZRLv+lQi9YA2nxWcYftWCcC6oUBm/TYZFugB/fhkB
6638g34ZslBfYReZpjHCfvDBVLSUxtF31d03CeGz7B8bJxc9KmKhfKXpsdwQ
LvC1KpiuU2HBn9AVuzKIH+uvrcp+x2KAONT8+pPnA/oWq486Yl/paKjTXGMT
PUynz3u7/86j48oXobn3ZW/px8pGtvMY0GCVSmOcVTLElW9Lbm34ycK1s4N+
Z32UwbLQKiifdAI9OuZ9mrEMln9ZyJz+wsD98yM7Szn7uyFyUZR6ORUFBvKP
BxfZ4vrc8blTz8xRw0j/dYbjFxdGKybFM8yxTDFscVyqAp528MmG3abh7w2T
AOM1+jBnla68xs/AlLNZcNMaQ3S8sDmR8pOO45l3sutCTDC0XMj3IrcZvg9v
Mre+Ig/1SdP7w1eZ2HZFjXx9/A/d+prHI2MeJ5Qmvnmy0e0TfZRadDkpwgXP
q+RzwreJM5QvdfRFODE4fjFi/VsHU0jMCXFpRjnB90DA5qVlM3S1jZrHXsk4
QWd7+Kdl85rIcPUsyVzEmf/Y91cxPoqIlVaJXnmVhbp9K6Q7k+bpSSdIEk8S
majONCT039RF+EfTvg66EzaWuVUfruFmjLR1kLVnWfA5qP3c5doEp8fJ562q
C248kC42SRLFtrS8abccFoT4fGeINGXEp3sEq/WwsO54Vua733KgBe4RcDFi
YnRta85+c32cS2uK2fKNsx/UowpF2lRxssbEd+dvDm+03xwwSVNASOK48p6T
Tpgw/pvvdEIKj55MFFa0c/zQUxPXy1lCmHLZV3PRjIaQ4UgnGUUCnAmly8Wr
GdhbG+r30l4fCcKjoxbyDDSZb9fMVTPHUGipjf4qBp5d+Wu585Eh6q4cyC37
yUC8nXbhTI8Znt1Xdjtfy4Bs2vVnflcMcfxIxHSEJQFc9x5+3WvGgz1PQz+f
30mFVnB6z4eTBOT5Nfm9caNhwMo9eivz3772P89bUEB01O3ZyIICv11g72F1
/DwY+ST8vRPefm/7OnHyGz2JGbZJ/h4LzNl9ahMpKojRkzcPFmCi8uauucw/
FuhIqvkWfZeCrqcaxk/CrMFNoVzsLWRgzaoi55LnBnDZ+LlxVz8VS694HBHK
5tR1uS2bSjwYcLzrceOEiDl0i/bLRJVRoD/FbcnnR8Bk+uCqd83WOCad/epw
ty6Wy7xaFLHcCt+Pe5yLcNBEsvZEQUaUBWLLouUZlzUQyFVWdpiTb+qNUNua
YH4YHPbYG1jNwrfP7cHvu/jQS7fKj/tpB0rBWxXipDjuWc0Gtu5zQB7z1I8X
goJYlmiat2jUFq9EZHzOkcQQV9G9ikmwQ9FXWtjmjVL/WicO7/z7eYDbXMIx
nTf2UBlvUo/2EYCuWF7h7jRbbGvaa9LNkAZZ6llsTI4d/E9vmTi6TAwSFwT2
7PzC8bOwOlPdJI29t3tPbfW0RZpyjU7/IVn87bSAENUGEpn1+vdLpcAdYLE+
gGgPw1/Ps8cNRNFkIeohfckG0a0vvLmpYnDVYv1dUWSLiX1JhHhFeWS1kreq
vbaBSbLWR9sSaVRJ12Re87KBhfuAbGmULBZpyP7eVmqDwjWnziz9Joma5Zvr
lt+3AQ9LsCNjrSxKvg/3yAcSoPKm5sTfJBk4ndvQN6BjC3/uk/pL5KUwrarJ
96mfAIvjiyKSHWWgHpFBf+/vAMdCtUtvGLp4eORTgfVjW8hHjozxpmpBnk1/
Ec7nAFsfrkpuR30sX8I2nuDw547wvMMt2zn1iqnQ3xfugL06a44xvhqg9t3n
rOPn7SH1nbJvnm6AUpFZfn8VB4R1P9W8Y2iAF9UqqStr7CDauGKuIs0Qbl3z
Wzeo2yOyVkhy5Kc+jhTY5YNsj+bO42bBMobIHhsI5cu3Q/mFB33kCAOMnc6f
5rpqi/g6NxtWiCGU18/Us6zt8KFTKypb1xBOuZdMxzXtYNPDRXfUMkaa7+3P
K5/ZYt3wyPwfRwP8PLNccyefHcKkLt+ZUjOC8V1xE2NO/nZJL2g45higNfN+
qyvZDi07R47VNuhjjV3Hu2lzWxi+vXmDuWCES6I/B+NPEFBcXasrtswQ9OTE
8zoinPzlTw5cuGuIC06zHcYHbbFZ8aMCwcsIMaP5T5UdbWAmqBD3554Rogpd
Vy/U2WC7QHak90EjMErO1O/wtcGr4ZW0+EWGUGGvN3Wut8EhlQOvHGINsHjz
ry72UQI++j89LZ6ti8GYpD5XZxsQk0WkiU/10MY/2GdSbINxYlKEeqI+5Iqs
3lxzt0XxjRWnbvPqwdHQdeTUQxsMLs1tE4ni8L3F1awfrjbQvviHuBCqi7dK
Od+FL9jgYHjmnTONyqiRNltVzWMDZ7n92LVYHatJ4Tfcwmyw2zxaXGelGspX
jGrv5ozXZ6OB0kCKBt6dLBtjTNugoHJk1/ulWvjcvzpB4LkVLAnzC8VfNVHG
/4b6vMMaVTqXTt5XUcHd7fvNnaatMZHl8kzZRRNaYVWN/nsIqDhyumJBRRWx
+2vbAzjzJSnm+Ph904DPy+frNIcJoB3y/3PlmirS5+dmEwgELJ1O2KKkoo5b
nxvc6ycdwcwT+hPLZYmTlZ8WmONEtDDiDTYkWoFrinRuK8ERP+aV7Za+tIBj
w1aB7BxHTHy7QbimYoWWZzTutycdcWvS/sXmoxbQs/8865dCgtStNRW7wOHl
KdksrVRH0DoZJ3kIhkjuW3GM294Rdj1ZKR0uBhi/7nYiyYUEod1dlA4LA3wq
4YmpAQtuuUEnVy8RYAj1NWUHJzqBoCJTahTFxTC2c92afZKF6oOdRUIKwgy/
uPKX6UFMpNsNuFzTEmC0StYOCf1lonXIUvUojzCjfcrXFT/NYJ9Nbzv8XgmX
7070Tz5gITBD/1zprCJCXm5KmOpywnTaIO2VLxej+aVnWIWTC1huGj/vkufp
cXMvpWS9nRD6MrhARe47vaqIa81+jp/+tuWk74inI76vOBRevN4JvfFN52p9
+BjHKsMW2k44oSbm3aZRu1G6oMfztKGd+jhg6rtQo+MA5fvxmTunF+H+Pa1l
jI/T9OfaERopeSzYb9gZeK+Tl9HX9zGxns1E16JXv4+7/aA/nFBLOfKLgZbR
zkxbq6/0qpYrGqwqDi+vXmel9V4H23xibr4/w0D0YzGhHg9ddK60b/pA4Oj5
qAwxzfQXO82t+0X+CBMUAzkfz6wJttfbcOWe/UwcVqPve+7xhh3jnV5k3c8E
iZY/xZ/8lh3cYGB85BoTbUXCK3fxjrF3fvvxp3UbE8yHfbaWlB/skjtRQY0L
TAScHDpiupQbL4i/WI3BHL3ecL+9zvsFm6cwPHZKlIE9Bnte/cZz9mx+22K+
a3QkN2mP3lGYYFvMDVRrsugYmxAM1JWZYrdHfUk7K8JAUR1jxekf8+z8itdf
rzfS0f13r/MM3wzbdcZBZNKQAeeuF0Xepr/Zop/bs2ML6Dh6qMuUpvWBHWQp
Mn6ClwFa43Cb68xntuHhjENzrgysu7VB1X1hls0z31eRRWTg+KMlq47f5UFb
SIav1wc6JPakfB1+wou1/CrTTE0GVu0/QtvQL4CCYw3b7MI4/k/ZNlRFmgcf
b/aEe3ZyeLU6+KJ/ghA2t9ISh9sZqH8tGUCo+0ifMa0Q8chngLH125Frvo30
0MPX9Fj9nPmodjS8DDtCL4/dE+rhw8Q3G83Ny9I+0F8+f6NDsmCC4X7q4Lrb
OfT7urTuZimOf6zr69iT20f/P2S8eTxV39/+b57JPM/zzDHP53AGGaKSkqmB
kgxpNJVCSiiKQsmUihRCkcq5EA1oUkohQkWDqUwZvuf9e38en/tx37+/zmPv
vdbae7/OWtfreq699mZV8U9uE7OHb2LslwUmFhJbC+1vrIY9JBop0SPDf4hh
TQalqXr2OJx13i7i6w/i416d/cZ77UGhLIeseFUTv5EfDU002+N0+8P2zHUj
RP+kUguTRHvEpR7dbrtmmjh+PCEjl2qPC/0RG+RT++grXtGrc9sZ7clOSDT0
3SNmKDpOHeezx+3xTaXg0ML4pzWhwmYkmLlKT956pIb9n0lrJ/gccH7dzvMC
C/ykrf6s91/4CmLn99FZld9mUCy/xKl5yAFPfN63d7iywdzWSXlA2AgFtyOk
mZ9zojN1u2knqymqvoq0xKsy9Kvrbn9VqAm+z/RkO0oqwHV/2Lc9i8YooVo3
ve+Sx93Pz3viQk2xQaP6iV62IiIIZ7Ql5xj8mjseJ/ZDA3s2vUna30dAh+K7
ELVuLYinlPEtehph4XesuOZtTVjnbc33nzZCQHmQeraIOsQTqh+dGTRB1G3B
wOV8FfSZV0wXSJlCNrnDVrZCGSJf1eNcIk1x7trotipxFTS5UB69iDCBQm9x
3N5hVRTouL1rnzHCai3D6xEiqrCdrmMKfWWEyE65bZyPlJAz39XP4WME63se
GgYtimg5+vOZS7cRnG/W/YnsVMQ0y5qy9CPGyDKpWdDeqIRKifJ33zmNMFjp
nLXkpIz7JkOzIseNEcIiu1oiVBGH9jxrp6qYYNlQpSPrnBKWW6pc/pl3SH3t
83nUTRlj9V9XLjDaF2vju671UBnLAYlBWiPGkOvLS9nRpYwfFm0u6X5G2P+l
0V78phKYs19avM8kYHw/6WE8kxL6uAP99vmY4Nf6aUJlmyLGHKtng51NgKG0
9UaaKpCixBMO3TZGlE5afdA5FdQ+UfQQnCDgLk15QDBBEet12lIs4o2Qo6QQ
t/+ROEQSc8ZP3TLC7PwmgmeMKOIjh9rNLIwxWhw5aysgjv3X2vh1xY0gdVnr
mAirGObedf5UVzBGcakf69ntkigYFtSZ/ERAz8rFqMg4CZSTRjv/rDPC2LXp
Q0cnJBF3vHOzczOjfrkLtSZFCmx1G26+TTVE5M91zkmukrBdWU3xtyFg9Heu
ZkGGJOO+5psCuQm4cTd/ryFJFoQzCxaz5wkgitNFmr3lwHTkyLnoKUNsZSVa
hUqLI7r23IGYdQQYjhd8rMiQxgibbgpvqyGY78z/Cl4njbwukhgXqyGyLz9V
07CXQ7Etx9gqfkPQhUeMFbdL441y28P4IwxO15N4vt9IFqP5AevawLi+6jou
0k85nG/plUjeQYCnESXwSbIC0mRYRaI+EuDYeDDw21cZEGDfcT2CAN6pV2Xz
h8VRc80i48KIHg50CR6JnBJC2k2j1rqthij7/Whla50gHPQUL7e/NoT6d91s
KxUREF/XolGYgHaWxKzaOFEYpJTrfnSxROtjl5nqGwRsspNNvDJIwjSTRrju
Rzl87Yo4/sHXBhO6FS0SudoglMiYKLDaQeeHZc0vK00kZXekrWtl5PcjGqtZ
vhAQprMrYP8TS7ww0pnJoBIQyvqM9Z/1MTqB7UKh2QSUKoxKZRMsYWn1TIiD
lwDr6dKHXvWWeMgrG/roliF4omZqCozNkf5uW823KgI6lxaN8uWs8ObzBr3p
KEPc2SXzN1iZ4T+6/sYa6P5fPrME37lM/94SCwirck2nTxpCfkWL1lJsAftn
880bLxGg42xuZjRggcV7/TWHioxQnRQi8tDNEkHdPUxddkYQYVWRpXZYYFDe
wOOTjBHSRH8Wx3Sboy334OuXx41g+d7q+hTBAskrQYoPOYxw90b6A/hawEmO
Ysl6gsEFr6o8UikWwHwFcbODCSxOMEeUSlhAfiOXj8g2Y9zo94pukLQApd5A
f/GbEbrslOki18zR3LzOMpbZCEOdPJ/vVpmD4Hjesz2KgKJjepIbG8xQmq/P
IjNjgKxc13yfEHO0rrnEpJ9tiOCGJ9I0Rvnf1sdIh5YMIeySmDSvaYGWutaS
LesNkdD23EmYzxIN5QuK5QMGSAmYqzSU/+f5jYhURLwcHGwP9tEn7VGde8Rn
D5WFxOw5ttBSQoLr95jNt0rl8UpRQEzIyBBqCZEbi+VFQLH4EkKTcID+TvGz
ig//eR5pXlexk+E/ujvvXp+aIP454d7bnUqCj7pfU4fWMPGse6myzCl7OBPK
3dgXvhLZbGvJPJftUftz67j5wFuiaaBONHuQPRZFtKeb/JeJ5dvKCRQBCgQr
w9V6cwXhb92wtiGKhLzGDU4OpXqQz/s5z/uahK6z5de/B6rj8Jj5avHttjDz
pQeO3CRgX/BkfEGgLTRbitXiGwxh1pGg6eDKqG/3y2mxSwuyF9js3a6Q0PrJ
I1j7oxZ2sOzoHdSxwYnCrYPDoUYYCf3wS6KbhKw99AmWZT1wnhxP4PhrA4Wi
qaGEUmPIWmwX2XWLhOXOpIO/f+hCe/zwSK2sGRrzm9/d92OB2bGysfoFU+Ss
tRYTOjZLjzb9NpR/g4jdc1v931fqIqBqLMa9zQTPIvn3lBWvAu3xkgaLsxm+
XTTVPbBliR4x1aQa1kVGe1/wOWMNQexVv7qtqJGKK7YXttj0cOMmp6fQDIN/
+YKZvJ7lMePgtavNV6RsEL9XPKa/hNG/iJwzmi2mDH9s8vOl9zKdfCKtqT/P
Ft8OU8J9+YzAZ6bcLr6PhDWPmdkqN+jCx1rRaN17BzSu4ay7OCgPM7H13o2M
flz10EV4+xEuJKwf2MvK4Nd+rcSnroor9Fua4nLJDF44udaIPf7mDP25OEE3
rpWIbW+nwyQSdGAoGTkpok6G5fGiquF/3rfuZLW4IUQCr0kh4da+/3yXa63J
/8wPDObceeVkDI2dtz90neLAbNxeIsswCREHLElGj7TRd8bKV4bC4MUlU+eC
Gi7o7pDbtnDbABI7LmttdRfEvYCSRZ8MMraWWrUdXsOLKf0smxPbyUj0Kovx
cxFE5dKHpScXzeFOXv5hysmK1/Z934Z+GWPg8U2HW2//0g96tPKLMfjfsFra
sXfT/L/f85r7n/UM/99Pqdl/t68ISOj2mhtiwPXN7mcRDP59WHh3jtsU5n5F
aitgRUPMMV3eJn2Qfh/71TD5n/mQZOP/1v/Lv2XbqkASZJ7tO/3quyZ2eVzW
+ptAwucLRX8/Van9Wy7C/L/lda7pKaS0k/CodJ+K7mcdNLgt3FM/T8JKRpih
k7wOWm9tnDV3tUHMduLfkF8MvUwp/T7N0L3COVU++4IlutuLtOqCen10hW3I
4vvOj9eSty+GXCaAvePMvZRRpX/Po6j73/O5bxwut2foRp2AnnU963/2Z2j/
9/jhT18W1pURcFSGr0t9RBn5KVty+5Zt0Bp92X+gwQjbwiLtxT7aoN3sYYoa
4T/3veu/3yujn8r7VJ7uZQsBGtslQ1sC2LaK7hOpMEZ7ouryWD8TIn6x36QG
GcLmVQLfuuNMcO4sTuDx1sX25WmvfXJCyCixNOD7ZQjNKU+zI1QltNHu5SdW
G4LLLs5KhqoMUpC/C6udAcrUeLYM7FaGdkZiWMQaQyjyX78f5KKEoL2y/SQd
Q/ja3m29X6gMFaM0I5w2gAGzb/wkVBCeeflp8kkD6Jjgyq2tStj6W1+5NVAf
kZ817hcUKMHz8vgF2UZ9dFSvEfnJ8JvxixULddv08LPLXND6jAq+nVZw+PBN
Fwc10u89EVHGu9TXF3M19MGfN5ve0KAMKbvVDjcP6KM/+E605lMVqIjoNTkl
68HXer22UTTj/78eFaDUqIfIuk9/Zo+oYtmG2FpzRx/yU+v2+TapgiAyvF7o
vT68HjXaO7aqgRz0Q2WhVRdBJ9efPlYrDxE+loLTWnoIt1ovVssuhzU/9otr
cZmjYG2c9xUGv+dlbq6ucbeH0/FrgT9SWEgfqELDcVtJGKoyFPbVZQxUd2Gj
P+VkUpn6QBTHJQ7SspKx4npRMt7Zf8g9Hc9PCluf32EmKIE/Ea9n6oTNMFQ/
9ktvjRCE0+/cmt1hhrrbiYXvBRk+nPdE9cKSKYScd0DyHQVuHf7fb9qzkCZK
+m73rSFjwNiz2XUPN6klSMydVOiIv263dip/nCDyXm/fEKxERu+84Z7tmfXE
4Ai9dJlzZDQwDfOtWI3RvziZfvj4hgyM+QrVbk+j58Zxzr+4SkayW3ZHFvdb
4ou1PqJfzpCRSvtWRLjZSc97tm1rlyMZHwLelG/JHaSfVyteY+xPBp9GYt06
+3m69OzNUZ+NZAzfvrtnrqmBvsvE39Y8mIzypTiz065MaDktZ2+zinG9Lg1c
xZFT9Bo52Y+VjPK7zi0dZp+eoF/eyOtAjHdASIt0tPWpISJnzZUVtocO8FpU
yU4l/iDuurai5nuAwe9WJbKf5P4QL6TZHzAgOCC5Efskv80QJzRXGVMHaGAp
72c6fnieGLNh52RmlCOay048cqK8oz9i4b902sYeFyW+cJn4qMAsOUA4JoXB
e+//rhnvVYbmgYua5c/s0eB9Rz5gQQUXuKp3+V60h5FgxB5JP1WIkfvpQZ72
SFQy0hlJVIVvWadXqBgFCSOhrwlUPujUfX3qyEsFX0F3s3MCB356BWK6lQyp
cPLY581K2BhwpGODOwXHFUi7K8VWwV70itfGOArk0ieLnYW5gGY3rSpG+Zlq
n5j4ahl82OUmkhlFgYoKD2mYhw+nzM12BbNSMWV4ls7PLAJ9DivOR0QKhCXf
bmcz4MaDNQpx0fk07Pz9lrKa+ocueiv30BAo0Dvn/KnsGztu7ueWTg6jwHgx
zNh1jgmcbquS0k9R8EtD+mTPRja4DTpt02C05zxbSaFnsEHhe/S48jwFtfvW
Pdk/O09vLsrc4/WIAlX7H52N3Uz45dW6rGpEgV0r85lLk0xodZx5VLSWAp53
hSzjr6bp9aUyz6OTrFG9+nlSe6op5qNvj7/fSkWmYM6vrTzcUPuZPX1RiIoz
a1KzK4qYob/KKPXYFQq0roe5EA/P0p0rzp4j5dAQ+OCEwtt0ZSykpv2c/EHD
/YAJ7SF5WXi7yu9yf0yFS/fAKRkhZmznqlo4akHEjb1sl2KDCdgYuPGrhScN
a25fMoh5KYbn2VmGM+zWCOQYJj1pM4Xa2JLbzxEiJM/4O/u+MUSgRfoWzRoi
9tXzf0yTNUTtLzlWtnkqPsQMpjrm/KY7ZpFfxIZSUCU6y5e6f4GeeDVGgPc+
BQOHOrmiu2qJyx7bexbINMS5t9zc1syKpo0HL8a50LDrkBiPQtI83elQ4pOF
a2QQ0+JcPq0Tx/TVjaw+h6lYT5Pyqq+fpweQCm98yaFA7P6LIv6kETqIm0Tz
Chxx3Ga7Wui9H/R3syXnIwvIEB0ds6JvEUWnw83Yccb4l36YeVqpXAy2vKd3
8FtTweX+ZNh21yL9/tcutWv6NOyWGww8/HKa7lyr8fzHeiouEAq9ZThYYP5i
IncliYLQooNF3BGTdH0TRfs/fRR08FwOHHeeoN8y3HfFnkjF6y2bAy/YT9Dd
ph1FivbT0KG82+fpLWbcrpqsVrnEiC/x7AaZLXKY/B3fP9dLwVhUzsS+iY/0
8yeS9IXPUGEXwnSjT22IuImYGG6qTUWH/afNq2KfEg+3/eqj/aGA9CqFb+XR
Kfqkw7ZXA4ZU8Jju/KYb9IEuZnnmZaUAFf1vc/jXXJimG004vYn2o/3zPsoW
ZQ5OSBwfvrtVwhqGG1UqAu4a49xlbd8f0VSUnn9WHVhwk64018GxcN8Opaa/
GhszCJA6+9hTiNH/nLTl9ddWvCWeH465kahAxUODvrfDkVPEnr/V9R7fKJi8
LCnw5+YwsedqEmGvIg0DRwlH472z6ZGSdruygqgwXDt8XDiMHeQSpgPv1IkQ
ePTlcM8YAYr3796710FEgsVB424G1ya68Ne85LdGHK8UQXmjCdgPbLb3DaNB
OXLXguZZJRy30qzcDBr6e3OSFwmqmNxhVqaWScXXwDUnbb9wIlxzf0y5gT2U
FGo2azgTUDtrKDDKrYrxrqqIbB151BFaNr+vs4Hditryk1ITlMxfqYlQtkFw
pZiQmYEJxNJ8zU0yrFE66STvxvDFQ05OwynTVDQ5X74aZ8cNyyNjeWfVqNgV
esnLpnyEWMHDwqq+h4LSR7bxqsLfic6EGqdVHyiwnKMKPXw3RVT7Qdo3fYuC
q+E+gSfjxogFzEnFlzuoeIVahW3EJmJnUOv1z6KOEK5vK+hepYK1qbcIgS3W
EB9XcbjFb4p3XhdL3tlzQKI6j1XfVPD/8KYUdmp9/uXZQsK9r4I9J/cSUNG9
NPyYRIPKhddhGwMFcdj17ai2MSNeLJe0v9mLYGQLx9G+PitI1BmNP3U1Btu7
r2zZPhQ83kptTW8Wxk/BJxFP6Qz9PqUUR1PRgDanjnIPqDhvH2AwfHSebntg
0zefEiqeXBWv8+gZpXvkBh7vn1XHh4+K1+IZ8btaoVUr38Hwh1zGkz02nKRF
G8fEwHPW+HLnvW7hd2M45BjdZePQxQm5gZ5xLTmckOmD9ykb7OCsKzAb+o9f
e2OOs7rtqfNOc/SSHT4VD07r4CLrkP/7rQoYrWq63exMhBXdxiLIT5D03OCp
lAC7Gox4tvvvmZVHuOX3RqtaEo6XHpXe/4CVVDZwgxe7qHD2u1ockj1MH29r
UK6touJiLVs/h+0beurpYUE2LhrmdENYj8wMESvefN2+YYMiPgbfuuZ9RxBP
bJae5sbbg6LnMjrFxU3K3rNulHm1Beo5RzakhM7RBXnuKPC2U6HScWej3pkh
Yqp1Y/CMmwM+VO69rpNqhqvDu2+rd1DAca+1mMS2ilTNabHzgpkS7kmkrz3D
wYcXzG9Wl2cS8evO1aH0bVykjjmGyAnZwO/sgvtIoin843/qMvnSMGnDdA2v
+4hf9P0ldZM0cY5N7JG+iyqoEcpcG7+TwFqefMuHzEaqjwmc5E0i4eaNzwHG
vtyk02iqTNzNyO9/78r2HhIiqSv1jDBJK5C6WPr4yp24scrATFCqhoaSP3sr
Xe4N0/MeHpWPPsDQqyIWy07Hx/Qf1whOZWdpMNL5Y+W/6znxktmHNWlsjsDE
uddzL84T3T3XZK7eQMN+xxPk31M/6UkbTjVwxtKQfeFF2J/WIXrc1t/nMpUc
MFj4yf9mvSbuJ00cf21IAkffdEabvz6cLEptHmWQ0GGcHih+0QCK52cz9vYT
wVv5PmF5oz4ev3vB8p5MwiBRcmXrKQP4tm3icIkg4fVDgffzVfr49aVfPb2C
hL/CDpoTDF+86Pt0LN+XhPD73Oz9IKAl6/L6ggASaLJb9VYaDaGWqEBzDiLB
JKJy3SiDo06Wjtxz4SLBoc9EYuNeQ0TdXuEISiDitw2r1fslQ/iwKszUypBw
qvtq4E9BXRzl2+sadcAaKyEXFaY9jVEe3BurxWWDk70SL9nkjIHXIkdDxiyQ
4i468quGGSy7NI6JJ1viXR+754oYK6I+LxQEuFiCtquRMjTOgSfR94e73Szh
QGi9mfF3hX7RhC5e89YC2dLvtw9nzNPFb/wojP5sgdN5Mo/Im9ghmp1Rec7B
ErG/ZXq8XWfoszkBEsOJlmj+veIwqDFBn2wMLb+w2QILA/odqdkr//KjhcX/
5sk8C4ze7zrQFjL97zafOVjvd6flrszQN5vrCMy8MMN2wbslVlnLdD6DwvzG
TDM4U1V0b4bM0tV8uqOuMsrbZnJP7LjH8m+7kv/zvF22vWH3m7MmqBkUez1S
skK/51Kjym5nCjGVz2+1JZfp93qYMZliwtBR0z0s91lx+6pFw6btJngyvSbn
0aq5f6/nhzFs5pqtaim/6SNXD8+RC40gcL9DYUmAhcEpcuY23kZo+Nh44DSV
Hck23QUvyUZo1dH7+Lt+kW7w53Fm7IQhvDgWTFg7WOD5+tTHxnhDnMqKvx6e
NEdX5D5coMNhiLuszsUGZ//QZw/eC//E4NVa6w/cv+1n6L1HrqfX7ycgP8h4
N2Gc4c87c4qIIbq456zUVG3NhCK3N80bjbWgrOHr8zmOGQnran+etNYBV1G3
J3c9C7yE/0b36+th5kLhGqZihh+0fPlN+b02tmYLDBaFcfwbpyq9/8arZ2ex
o3q7Dv7+dR51E+BAzK9SiaJMHaj+pj3/K8+DVfrer/y4dSHIsfdArqAApKVF
H2c16ON5r5g4e+8c/UgAb37OVl3UnE157JDHij05ax/EMLj5g1isIOXkHD3i
Wc8OP1s93J+RPyqmMU/PfX9a72GeFrpdmWbWqM/T/STicnYo6yDor02JwMSf
f+PP4Mf0A+Jn295M0bfFtYlVrTB4kF7zZa5+iV4sUWCyr1sPQaXHS8Tc/vP/
P9GCip0LJyllir69JZ5z3EYP3ROc625VCiJdmGhvFaMD78t7zwgIieCRlOf2
PLImVmT9SYvuwnDlvnHTzE4H0oIq1w2GBCERrnyLfUALj2i7qfcuC2Mwq8Ss
/KI2cr9/YZ3pE8G4UkNidrsmPqodMa8dF0eQuYXgWLwWJAX8z76YEsXhMpuV
N2s0cXRd0euABlFc3hkbP8uhhZmZj5oSfiIIzdeerv+lCiud8euc/FIMn3fr
QGCOGh5rJP2+XS2C4ooz5489UUfpJkvmvUESYBEqsP3OrIExw01q7RdFEON0
XPQ2NMC3mac0O0UcRbkN28I3qGNdcMO+X/5icA1YHfu0SA037lo/dTWTwNGj
rCX2WSoYjN/GbJ8ihp2u+vYqcaoIN1pSVvwljrlVB5XO05VRsu9CclW+FEo/
/ygPyVNF7Esdce17onAfppzeEaGC0/WNmgOdEgi85a+pyqOKTbkDCzlhvLhq
yfK6ZEAFJybWF+R8lULG5cbjUcFK8Dp5PdVUQxz+X1SzUmxVIXuuJqtzRBDK
+e1e1Z1qCI0N3jpBUESPdFLwgVPKCPLwWowOF4er4J6L9XdUwTcye9+lRhiT
Z5+s3/5HGdeDz9nxbFfAJcsi1SRxNXzzqjM7/EEWv6qpT9+aK2Pf07cXK7yF
QemN25ClqoK7exZjzhyUxTGvY+oZd1VxUb+e24hJBvE5T25JiyvDqjXg63Cs
KOI77j58vF8Fu9QWzN37hLH23uc9z50UEa7VssXkjzAqZphWfXRRwkW1mu2C
piJQMqMNnt2mhl8tN5qiubgwoqr0h7RbCSaGsSy0NUL/9kco/3d83WeNzL58
SB2ndEfXVPIx/7t/QO2/x7PGC1+EM8qX9D/ZeHaKH9bXh9p5udWx/CmDt1hj
FeP6txzcxaeGR9fKd9w5tgpNF202iBSq4cdsBFPMGSGsDLH0fmpVR57MZkWl
zUL42pDrv91aE+8W7kwXvuVB8OnMt9VkDfi8lzdlXyUAot4WfT5GPBW7fpaN
uIki/Z5C9p/njDgZSy39ZeSDt2bRmmLhmrAs3xHiXb8Knr+CPslZaCB405KX
zDdubCZ5lGYaq+Aym2rh9HtBhHJrs/D/0sDxU/Yh+zs5cDilUaFntya2XJYs
1zvPirFPhXs3MsZHg5kHjVDPAXpkHF25XAO6AVtXhL8Kokj9oFRCphZ+x35/
ZhfFh84bv5i/Kmihp3iZMOUiBGUWsTuhatrg0x1RlVgriDeHng7s8VCAX/yN
j+zP+FHJIR4WxDg+POZaEBvJhuPyurR8fi2UNRfL9VdxY9pI3P+pmTbKetq2
6x3ixr2dkeeuRzL82hL79fIpXkSYPN4w5WgI9h0i7D4sDJ93J+xgQw5DbyQ5
YnOzFCDTsJa6WV4XVhfkKFQoonvN2vNO09oI25I9J+oqh6RRXqtwHx0EG5zM
a9smg1OXX3NJvCBB603giiEPLyk9c8qgN1WB9P3VERr7NQV8TghfF7qLG9bn
K+PvvxOG5uNU75PuSqRrTuoLS26K0DR91uGuRMaiNZ9CJubptyZt1x9+7ICS
D9IC2bmz9NlVz2hcnQ6QnCgkpLz6QaeR71BNMxyQ1ua+qT2tnV7S5pq/+MgB
ZgN5Vs3HXxIzPbyEWxod8LJqj6KmbD/9WaDhr417HHAyJVOBcn6R6DczuHNm
xgGJrns8qj25SZymW37WytDA5moU0KHCjI0p3zlz1znCTapNJ0p8jK4SZqD8
s5cGA28x25UIVjzet37kaCEVc28LbNTK2BARf7j8pqMjyjJaLS6Iz9B1WL8S
BJdokDS4vlfx5yA9y6bv5tbjNOQka9SmSyzSl84ryhxl8MqD5/0ZM694kaF6
5TuJwe+VJ8+82iW3SO/+OPaF8wiDv++y/RwNkUJcvsMT5y1kFMwb2J8IkEF2
ztWow5vJUO5YOqd5WwIOoicvse4ng3N73I/3BxVxYvfB3Rs+0rDMcyZL332S
Hh1fTEkJsgJ7vj7vq2gTnFN25o/ipiHyREZnX/MwfXpjy/WPJmQYRCUpHtwn
D435949rlCkYmkn8yyksh5NrfS1PvqDBe5r3s1HwAp3gbaCn6UUCS7iwphCR
gK+hOYWZBjZ4d/Zqiuk9E7RqsRSY9FthVcTY4gkGT20e1Mz5KEnCleGjZAEl
Atx77ce/mTmid+Njbe7ZLjohYCj5sx4Jpje1ktQYftE75qioXZsuqot27pye
4cVTXeOZ9I9U1NK5ltREf9JHbpziW7vaGn0yVxyNHpsg6A37Jo0eIkqdNn1y
bSJAqdtNbvSsFf4cq93BcsMYA07393wkUHCs9mNpfudHegT/Nc8XWmRc0J2s
Ubsjgps65CajG1Ygh7nZG8iYoHfdaoecGSqqJtK+OgyxQyoyYUMYg9cpg7bB
88ZT9Cp7DWtDW3uk7RfRvDfKTdqY7MHST7JHb33hyZ8qAqQ259NeDl8Y/mFV
fpG+gRJuNd46yd8lj7L0PIt+Jjmsn5rexMFtD4+NWR/WmnGSBIh5hU3XtGG5
q+Z6RY8iDnr2Oiwes8f1hnt48IyP9PDSKrOtjT+IeZuieTce14CcuNbGkxqq
qJxyazC1VAJroD5/qp4qSpt1XbaqK2Knwo5PawesofYmQO/wrBkMHZOOX+gk
gRKa0PF+XJDEezCo8o6gKvaeDY0yWS+L64EzdJVONrRt9nPSLTHHYUe/uI2C
vXSpyz6alq8IKBhX+HCDxx5UkylaoAkfSc362kPqgDlE7TyOiXev0DU1LfYG
eWvhqXRve0yKEiITDn1glich54Fgh+59PtItaq32TXYSHsic+XxVXZBkGrJf
oOcoDXYHpTSnqVwkz9GGs7+9SQhY4bieHc1PirLr87ukS8UZp59hF335SCeL
Ow5SdSgoHBh+mKn0hnjq1PP3VjkO2F/06CkpfZo+P1Kl7ZnF4N9428P85atI
9nSLlE1mJNTZs3fxa3GTlF7snNyy1gEJC2cGL1x5R09ODm8/6e2ADX9jTnM1
NxPTVfh03zJRsbB5wH9s2zJxqCtM+0SMA/SuHIXS5zH6nSH63MZcFVLcgBfd
PloJzQ/sDPImycgN4L6y03eCfi40d4dMIgX7lU6t46jpJm7gD6m9e4ACw5Xz
CSxLzfRPnzkEFsUocKkIn23NEMMdBfegpk9k+KUnKBky8rHEqnyeHaJkBEVd
y2xfUcHkOaKJaAUFwrLFQq6vBXEtuf153Wsygs9sdDzhpYB1Ti0s/j1kxBID
4nRfSkLK7XlR+20a/rw+XCJOFfjf8xWMPDugaTiXXE2DZaHvWGwBE0S3XHn9
Lo6hT4EaEa4kQeT2HZ1WfkiF1vFrKvP3hZH1JDyRI5WKt8/lE/ROM2HJcnk6
XcYRbBPn5IUKf9IFOQcfhCtQ4dbl0kRp4YGdhfJJsxAG37+JpoapCWLPqJRw
tAcVThu/ElRb+XBBJKKsVJiKoKJntSE0QUw+I+km2FPBW381/fW4ENjL3RyD
4qloqD+URmQXxhDHYOz+nVRsa9Rv82GXwGvLIDljfyriJl/Gc+wSxcDS5FqX
EQoCXpbT2fcIIfCr36kURrwOy8QdpZ8QQal8dixzFUOfbXtXB0WLwe5kHOna
LwryE4uPhNWKo+3t2jvL4RR86ieXDTOO3ztcZ747i3F+Hn/rR5Mi0KGV72jm
csTjN9GCHDLcaDczdY7OccTrmX19YVpz9Ph7FjD+TEHEi86aeobfPZkTubRW
mYoJHdZz23zFcGmTsDt7JQX3GpJeMwmL493sErmlmAItppMRerXSuGulu3p7
JAWr15m88HKQRFDJfRs3ewp2V8m0HPMXBbVf73voABUnjY7ZvXUVxZcorTLO
l1RYhI9q+e6VguFDDsGMJgp0KfNLweckUZDcYV2iQgX/ar2dIYx8oRjceH3H
Fwqcr46N/94iDd7LSv0eW6hINV5xtzytAJ9uvks8PRTQzPwcaq/KQ7TvrMeg
IRUqxWE/7pXI4lytp4nycwpeXufaLM7wk1kH3Yt7DlOwWEk4HDQvh/zu7wtf
nSk4dDST9rRQGqZCAnvZKBTwbuPhL2eWwEu+mXoBTobeVsaHEKMksPa0DWVc
nIKToZ3vI8Kk4DdBrNUro2JIve3ngSsSOByz772utyPuY0hi+/dlevmzp20t
DL31uXXzu9mUFN6fOXsk/yAFSdWZASM8smBaUXUWZ4yfLxl/x5NsxPGkv21X
Tiojf+/tJ2YXiqAr+aqHgicVGQJOrhtKJTEYOfkm8g4Va3abRDyNlIVqeb/k
XxoVgUeCrl8Yk/4/83vcGDLNf2pZToW4G+nLOKTRwVGbKi3oiMoZVk2XPwpQ
nDW1q73IGG/TixPJayQR/33YYjaPhqh9b0QIxuzYHdBvtW8HDWP75tvAIYy3
7yK1mExpqFNbx0e/pIix5ctfqnc5Yo1rmnamIQfeNd1mD2aM38PMRwxkrnJj
14to7ok6GsJcDl5JXq2A26+GLC7k0tDD8iOy4IgKem4m3/ZTcsSQ4zp7QgZD
/0vv1mlZ06BQtJA3FSeDD5FjTUXjjtjJvG96oHiQfsdibVeb8mpI0uNikslX
iVtu34x3EnPE27TniQ0HFunZCu2eZRI03GiaittOVkBTKmeCP8OPTBM3TOco
yILALlXLkWaPSx84eapd1eHO5vJtzTgjfyXEfqnNU4M3b5PKFR97xKSW3Czs
1vhnfdoe1jv2CFG4tDXvmhoSaQdTLifZg7xhdiLPRANRV3dM+k3aI3Xhr8RS
hSpO27I9OaNKQh45we78BQKG/cQ66llJeL69iubNyMd3K+vXFExaok42kun0
H2O0fidVnlazArX+fOJYpjGMeWJMapstsYXQ5CVywQQvd61nJ8Rbwq3ArMjs
ljF8lS+2D5pZ4hyX+m1DPhNMWbGxzwZb4bF7a89rI2PktMkwvTWxBOfRh467
IsyQfnLqnKKHJX5GiC+KRZrCvPfaomGAJUMvKT8Hp0wwFHFLcXWYDTa/ePJa
Y40ZXhSPSm4e1sYf+hyBckoFxuyNqQuKujiuxf8+NVMVA6XfdguQlDDv/rJr
818Z5CLX7NgeFcxYnbhaX86MoV0SnROvlFCa9fnMnOAqGJzn567hVYST29no
oABOqHOnb1mI1IG66OrX17iVUc02MRcgq4WvTdwTNjwKSIvY3ZBIJuHvRQ9+
dkkm0tO4kU/ntpKwMWijp8cbNpLV7uwUfk4SJg0Xz3s5sJE2bRp4P3SXCN+4
LxdbFv4Sqz5+ueN/nAh3re/PH0qxkYx/xIQNMpOg8z554UE7J2lqKVXnM6P+
Ng2+8dAEJpIc27sDYe1EZDqXj49tkSCxnWd6x3eFiIm8xnzvFT5Sq/sRYfNx
fmwyHuixO2SG5jCjhv0ftNA6zX3+bZ8Jrj/52fJYQ47E1cQyuSaOC3cinguL
2ZKh17FwdAe7EGmLJvn6ge8q2CprGe3oZQErpvuJDqs1kMYnV65cZYzPp1rq
VietJknQqGuSGx2RcF2qXFCbgo4PrDyPj/2gB/uHOokw9Kb7qPeevjcz9PKR
129XVZER1sByOPf7DP3B6c+k4udkpEm58D5qGKSn399iYCtAwRPJtm18T2vo
Z4raVzp/kCGfxvVaPqSP2GtrK3BCnYJR6Z7PqhY/iK/81aY7+SgQefq+dVXS
HJEovKmm5x0Z6pnZAzq/5olax3sf2PhQsHzJznNWfpZYVX5ZIUKNBsPAClNa
KB9JVOxrNYsiGfGdR8/oriihbJmnJ+WBA27cnmpM1FCCh+Z5LtZ7DiB2CD1L
tFKErsJBl9P7HCDDy/HAqlkRvVcUdb/udYCfhlBT301l9PpbhKyVdkDNtd4b
6jLK6BizKv1wwgH1V5MW/9YpocL9nMotBj8l0m4V3y1SBu/byDQDigMiLapH
juxQQlBmz6OX+yjYOfVQt5FHCB+CbQ7W36BA1P7kvN0cPyB5VkKWEb9O1biW
6wy+iBnS2hxyggyaw6beib3yCAh2dLvkR0alx/mih/py+DhSuZz4gBFfK1JE
UqYcnM5snTlxm4we/k1C2gLScLQ+xhteQsbUIRldQzlJhLwZlal5T8PpoztC
+zMU4b6/WK1Ynopw87/86Y3yyFBhyyqdokBW7J5fbLoyfO4/Udw2y/BHe6q4
jn5ThLHuwaPeOlSEsnm9P71JEXUXD63ewcj/l2j6f10OKsMgkaXZk5FPHH1k
3gcy/HJ6ZbVBkAkFmdKnOlUlFaGw7ZOKHhsF6W6mH4o9ZHCy2HvdhgNU9HIu
6ATukkP0/YnwK0cdcbhofdbp3VIYz+XJiNlDg/i7hzfrG3lxNeKrkcVaGnj4
bW6NVUmiZMAx691bGr5Yn1jSeyuFVz7a9Tuu0DBSqk7f+0cMizJRvyXfUSF/
PG3ln/Vg7iwTyu7sNGyyP6TEySqBZv+uYsVmIspch/wGJo3gVPi7aC7ECtH5
DU/5p81Qy/a28oS+FVTmPAkKWaZQ1LzSX/fUEkzWLGIhDqZwP2UWJrrGCjvC
dMa3cZrC9dHy1VXL1nh025X10jEzJDtl+cWr6OIMnl5Ud1eB7LLO97/ftZC1
fu21fZlaeOBR/5xio43i0Sedx8+poTCF/acMkRHHORmtnDAZuIlRvhzkUUbx
i/4vvi/kYJraGZPG6KcV1KBnNVNK2Pxb+kB6kSJ2VziZ5V2Th4XezKNmVVUo
6swygIsDfBom4n/+ee92p8tIMokTP4Iua2wnqmBLyu6ud47sGLWyVH28RhGv
7qx27mTjhfzDDxPN3vLA/W+WQxPcUH2jE8IsI4X7+p81v3YJwu231TGBXTIw
u39t7PsYH86aJhjS/eTgnK85FOXND3k2KePsJjkExtYkxDf8Z76KpPA/659E
kvcdDdbB/U+i64uMlZB36HdbooM22Mxt61rDlWGr531u6IIWbDbF1N5OU4Fg
9pamURNtrFmoOXQwSwmXfz04xUrShsrT9M1MB1TR8GlMfoSgg4i6iqh94aqI
VR0Xeeahhe96vjuNmNTQuStrbkOoJpKfXt/2dK8GGtvlX13s18DHH/mdD3rU
IDiVcGNAiaHv04eebFqnjsvnN/lGGGuimnx6tvu2Ml5cyyevvNbGc3Zl+/Ei
DcjOUY5bW2uBIkWrWntOGZpfxnkP39HEvkXzfbWhKkj9xZ7KX6yFbk1X+Ido
YHBDneLv7drYTO09dadEHaWf6lY/LtRB7MNeS94fajBMoPQ1rdLGqmoOwfKD
mmi7//XgXIUmmMy1Xxd/0AT9TVXupQItJOmHFzyNZfCq3nrjE3baIN59OcIp
rIA2ddPuc8kk8E2m/dDZxkRSFm0qOR5Lwo/6K+5q9+aISqHhzYoCDN7zC2d1
7xchxR0JVx4MFYS10lBN14w5hJVOuvYUD9E3TLfdUwsiwFSs78StYHmS0+Ff
GQqdErg1LbFvtxfDPxw/L6A/KU3Ka+kOjt1BheSzreezY5hJD/TFnoSlOeDW
UsfgOEWYNGYU/9WwxRGJJ7rTRpv0UN04RuNL4sev3zUCZRnmKJm8QBKL/0Hk
OLSmKKhCFy9Wvr1/eo4C5aI2+0ae30Srxg/uBSZkXDPM/TI/rYhu3aDe7INk
JMuL2xzuVkJxNO/v/nkH+E62cTyxVUJTqBRNnZE/qlh4f/+BKlyn2vVLPMgw
Ch0luIuqoKn5iZi+CBnMVnLUiUVlRBRfytaMJeNsnJp+y31VPB84cvnoOjJY
3HVHHnCpot1C+VCZsQMuhXw7FCKmAoO4at01f+yRW7DuZTJj3DjGQWG52AHS
+k4vll1VwRokxCwd4IB4czMOmwEVfE0wDxX2cYDlLY0GrzNqDB558uHLBQpu
L9mfmotTxGd33T/c3Qy/e/vLM39uRYT9PRu8O5+KvKS6Izl/5TFP+7QYy9i2
jf+66vABRcxcDH0n1EuFpg13UcwmJZgFxqfyM/z8d+NiNb4CJdyLf33+yBIV
t652vPxyVRF2KWrin/1oeK87YEiOUcDRxzf30v1p2NxVakjxUUHeH7dnZz/S
EEvjffgrXhkOq6vLXRjty17+82ezsDwqdg/ZugnQkNgRXJZzQRlikmLhotI0
5H4vKZG7qIQtn9Zxl6+jgsJ2u+gho/8n90mzCMySEVVB99+erYiv1WyW9q4U
DLIdOT1Voww8rb1eKUzB5mvNf4LblfA57EvX220U/BEJfKgXpYSMbRHqbhMM
vn+mzTVkqQLe0iq1CgMKWiI4ul8xKUFjOiAkqoYCrjQOZ3dGfi26SarivkJG
rUhisPiAMi5z7i0O/kiGokCA72EnZbDHWi2NF1JwM0rG+y2/CkLX367tqydD
s0C8f/NvFZxMeV+WkMDgv2Beb1OSMraNFj+XU2TEe63hiTEXdRACtvE8Z/iJ
kMI1+Q8Y+rLwO1c1cZoCSqR/imecKq6VuUeeCaHgCodEketJFZD5b6zvLqXA
fGSr6jNbVZSdFJhXY/gjKZXkrdNQgfftdatvfKQg72Lbn9OM8vY/ZWO8tRi8
rcKyl3xZBR9Td9+3vkfB2ibtp3cH1XDYzat62ZWKY07i6+yXVLFe6XvcsVQK
qpU1dI011GBpCJ2XShR0LtctPT6sgb5Kb2+TQArebTvg4hGljlSrq9IOrRQ4
joSZyLOqoWcqclyI4Z+unW5L7+6Ux0/fze3fqBS877BxbYqVB7+pyPqrdxzx
rmDSfJccCzJpJYK2gzSU7rxS+/ygBB6dcvZpkKKBKTSp8qmKGIhNowK/+R0R
wcwqX5kngt9rXffKptBgU3Gt99ALaXx3C70n+4OK/PD8zWvOCeHZzgE9t8tU
sETK8WfG8UNjt/rVjstECE0J3Z3zNEJMWAvuMXgki9AtvI5ihNpDQbvCntpB
0yovqKTHCAJFRxKF3pJgyXusb3nZCLwqU+6vpImg5d90f7nHCNLX+zXYcu3A
ZBH41GirEegbzFX55exAjt68evGdETz2yOy2PklCBsfSi4sxRigyoYS4frOF
NU/roeJ9Rlh1ruuZyF47yHZp8D66Z4z0x+ZlgZm20ApLc4txNkbYcvJjV18S
iq3PLWQRjCD/PUJz3T47fFjFvOWxhTEahE8c1IuxxavxXe2iHcbYdUG5PlTa
Fs1LLdG3rE1AloxfWDVtC8P1KilehcY4kFI4YT5ihRPfTe7m7TdDBnvjs1JP
azh/efE6/rkZ+l8l1EQqWYNWSzmvH2cBr3jr/b+3WGMNz+usxhvmaNT3+8wR
b41BOZGX3Vbm+JIztlp41Ap/Q5+QWp3N0ReiM2hkboWmuH3v9jmaQbZ4ari5
1QqC2gJpihPmEE29mKSUZgWjIzYvIkdNEb3nkqDCY0topTHPvXlshk9ieYbm
1ZaIEKtuYv5tCt2aamO7kt/0W3JJ+9XjHSFmtmBQNmiJEwmce7KrzVHpJJCU
VmQJ37BLp3O2muFXYYfZE2YrWBasOy1qYY7CkfzQ0EAr/Gne1Lsr0xy964WV
ogQtsfud0wZfD3O08Isfn3K3BHfsbkvVUTP4Bd+zjNLThUUS583f0cqg3hRd
tXGLImSa3YdXnsrit86d7K9rFaC97vLhy9WSSHu4777VVkXclXgg+eqING7H
ex+78U4RtTYaq75TJSFUKH1n3y0lEBYHHihclkKO0a2DXweVkERK3Vv8WAJ8
MsRV8SzyOMSb4MEVooh3CeLJGVIqEJ3t+XGfwoPA05Wfa+yVEFjT0mykz4kR
47+PFhi+uX9V7Y3b9GV6xZsNjz7mKULuENMP2xpWSOsVnqf5y+Moj42Ry2Nm
aCTzu5JnlGCXvYNqt4YZldH6zdqflPCk2bOwqpENndN3vj9WWaZ/9lo6Tl/m
hMJFobQvCTLAI5cPb3sFcco6NuBdhzSs9KN68/nEsaWF+8odqjSyzZwe1XmK
gFdYIuzkc1lcYOpxUCGJ4u0f/8XmEiHMODML9YWIw+pRyGvvPzI4/vfykkKx
MDQCubWLSuVBGq55x58gguUOOTsrVUUUbdmjE3haDMKUIMPSzXKYKD6lLD3A
qM+S+2ypiLF/eN5ReE4ETWEvYswYHBC4e5kiB1EMZp63kQ2Xx9+nelkhPmJI
8Zszf/FWBgUH2wQMYqXxQHiDQ8sHCXiYej70HRfG+gdnW/ziZeA62I8KC0l0
PDgh6r1BDpJvb7n9YvhMzyHD+K/84gh6+nTdMx1p+HZd9lzokkPADmJhr7oM
4mqdtR75SaLPQNTPhkcSXvu9Q27dkUBk51ZlsZNiuOvnt0M2SArxjj89ckZF
4bug+yT6qhi0yw4WlO+SgLvbDa2ts2J4a7DZiqdKDAnMOvLJXSLQ5w5LU9EX
R0rQo8JBARGIkoJjZy2lkLVFoDPrmTgIj6frrl+TxJHEc7Oq7aJwjJ7fbDAl
ibWce7U3ZWjgiPyLvctfFWFyYl1scYom6vdKfh+KYPTDS/7rnjppoNomXcR4
lTwmnx/Sd1XUBDklHKGSCmi5c5w1U04dM3U00TeK8phxqPkVc10d4Rtzumbe
SzP8yY68j1Vq+KM4UZHnJINfRCanJhZNpDxV0Sg7LoUTp0bjiFmaMLfLNL1H
loXKvOjGrRXqCLOQ7bhbIQvdkm2rXi+qYQefdGKwiRR0qgy0u8a0QKIJKI7o
y+D+3EpHapUWFuUNV6s7yEF48QplN58ODiiMiBNXq+GC5OtctWRdvLM4XsUT
p4ZUg+pt/kJ6GN3FJLhxiwb09OkFhlG6YKfKd3WcUIdxlrHkwpQOKAW+TbEn
NeDQ250Q9EUXafatdrsZvpX58gxR/KwO1j0kyXGZa+FR9LiYVoU2eu6MqhVK
a2FGunR+Zr8OPD8du5i2RhMSlS4Zx8ZVUMp8yyWJSQv8z368tmTkixubfE0T
poVITOThkguVRNTn8FPjdYVJr4O6HXZttsOZMqVAL1sxUmtGrnfYHiLuPz/h
5TkgSipymGHxHBLFNGHH0dcNpqjaG8zza4GMDLvM6gl/QdIF7KTKCjkgXFrn
zArVDNu99O8dzCXjx9mYJ5IULpKkSoaKh4EmJkNfHHzQR8B5f9stMan22BCW
3ZkcLkzScP16zDTEEbfXKXC5GowSn68+4CfaZg/BjrNOkl7CJL8+22+px+1h
d8BlmTdEkLS5nE0HtNUkVZVDHvN0FZJ25UiqT7s6MkzSpimtBMQo82wInabC
itDJU3+XiRT1x+tPHAcFqp8syv0KRUhj/kpSIpmKJO0+Ty5/DXmc9xEl/nDg
QaG+Ao+tttD/nm+t0sPytrjqdElHWJ9sqCOcnSDaxxXFBH+jQvfMiTleXV5S
aL+2ycWU1Wiwa+e60MtKeml+3lTKjQrn2IDYa5PzRC2qfdmTxz/pDcp7i6oP
/v/Wa5KeFZ4al2H45e4QKftVVWZYMn6SMcUmgtXsvfJbVwmg+7xEvo+oEIYu
5O9ItRVAW8xdo8QlMtz43cMblfhJDz9LH5/Sd8SmC2EPX54aJnaZKzIXhzrg
kUNVWGqNJdiH12eHbSdDYwfL1XZzC4g4VFhf5HAA3/frruabJEjDbVIxD8PJ
KLtI/PteRoT0y3u7hVuZFopmmcYlHcxw8MrW+9n5q0lONss+4Yo0XPEZ5lIS
cEC+9I9Fz3RLRL3M/XG0ajVJbPW2b96eDB/0I3DUi+oA8T2HbpQxm2Nr28y7
wl5NPCE2svCKmyDk4OgmcUcNFCjoROq+MMKxFCOrvQz/FDPb9Wr1vQni7VM6
5Cj+z/TE3+EsNTHGSFGxTVrgE0Jzxcj8Th8euNdQPQY0NeAbea/0pKsRuCs9
7M7qktF5tmQ8ikOEVL2hzkLCmAMPz6l0e8SJIOUZ1by0mwaB75cPDSkOEIN7
yp5ubpcgfdhxK28nlCHYebVG/ow9gm8WfrfylSRZabc+Ny8hI7oi5+CBNyyk
renubmc8Gfwhu2jR3c1N+lLMl0K8weBxcZ2hHcGm4DJcn1ezTMQvQ87mSS9b
RCW8q1UYsMeLQh2VekNRkmvLWKvYbnuINPtHH48TI+moJYl0MtrP2J6eWzGy
SOR722N/WI+GD5+74v2WWEhrX1zbdEn+n+8lPa4vrhAhXXqyiWvkpjC6Nm+f
HFIwx6Lz6IWxslV46LN7d8QDU4RfqYvKrxAiNR+bH18QYELfbZT/YhHA6ZwR
RaYuXgi3FLO+8qDCo3i5bj2Rg7Sx8MTNU8WOeHS+ivNO/iBR5+ubKPEiB1Rc
FGo3Wq+Cl6U8PK+uULDj18fFSrIChjYVHW49T0Nt46vA8tOK2BYh9PI6aLj2
3vF1Q4oSzJcUBTeSaDAsfCKjmy2HD9f81lxUpkLkuLOg0iMl3F+oflgoTMWr
Jte0o5vUMPyerVQ7mQrvNtXFpJcqOGP9W5Bfl4Y3ZAs/jxoNxMxkcN3poGAi
1a9XXVcLjkvXTOp5KfA03kEXkFJHX8L3hzt6aDi5Uy/yBw8nZMSn+E/EOmJn
38N3omlySDdV1Vqt64iPvkm7/tpI486RFw917tJQYSp+2rhXBkJ7LU8fs3XE
fYWLTbVBEhDmYn8cdtYRgxV8fI6sK/RtxID5cTPGdolyxuRZWVQL+bCGRjji
71tzT54oGUjq0kbPOTiirutUa26ePGw8Oc/fUFmNhN8ny5rz5cBd2vLgWo8j
rmOssu68KuT2DapcYHeEybYJu7F5OWz3M3DXbXMEb+wPuz/issh62ach5OWI
kbO7Huw+qoijh7S12odpkBDx0ShcL4bre85Ta9QY5z+ze8ExQQwnDl5YVTHg
iJfHua/KKwnDNzlnejzGERzzZx6lbRGBF+c99g+fHaFzlPfmgrQU5r7+dbXl
WQ3n/RuanXZp4HjPbAXvGUecvDpDLylWwN1ZzvKFFEfMtRVtfuKriv7rf9ID
7jsisk7T3EBJHl9ON25MLnGEO9elnbNlamCpYmqVMlgN1rI8ScGDMv9bzyI0
sO4S29TKd0dUzXmE7HgljdZDAeZ67IzyqcyD7mNqUGWRGiMUkSCY7DrtM0VA
XanwIHE7Cbt57jO77jEGFpZZ4wkKmB78urNWTAGG4nM5Jn6KSL3qoRFSqIi/
DUGrflQpYbfbjM+grSI+LYRGqWoqYOroudcNZkoIC5z+f1ydeTxU0f//7fu+
L4Ox7/u+zjWDQWijqBSSrSwpRFGIlLUURamkRUhaSMm82jdLibTYExVZQkjq
N5/H9/v9PR7f71/zuI87c8+557zP+zyfc8+cCeH4JwflP7w7ZetVIdzFZ/z9
sjx6Jk8Jz/UpY4du3NitVyp4scAuqyqojJ1xvpSKRRVcpQwPaUmqY560cWgg
Wxkcn2G/cFIZ64z3D2baqkJrb1yBMdOPxY8mHNu7memhlWuPrVlUxmDO5BZb
HxX0vNN827NVBT/fenEcG1XG5YTgtS7fVXHXMX+dUJoibl2V7A/cw4k1R4Oo
rTpyECkyvRhuxYJXwpzHJ+cUocH+iNP18yJD0bwwIuwgCVqemVXCZX8Y9Yki
8olmJPxqV6nyrv3v9ZVk0v9ev3tdAcc9PmxooM8yshfrW/4Uy+GcvueeRZ35
/zpvpPz/36/T2OS8p14aFK4npBO+fPjbfDn5ZZ8s1r7sfvDQiwteKdO/FPZL
QvLXw3RbkgieOPbynNeThnF/Z7+ZvCj2DD8dLbWWRoyA5HEDKyF0FjqujHOT
xUDXjEOriSD846LlLznIYWDNzGLGb14cFAydcPkmA7UnQVERM3KYWsf+vWQN
G/5Kdr2yjiOButz68b6XFiaXzs+rXlLGtUSJPlcpTVRfFvnpbSCLw7IH7py6
oImGf93tetHy0JawW3l9XgtSfqddK33k4NbXXXxjtS6yHtdxPn2jAeOGnBBf
Dw1YrI992lGgBUa5b5vuIAXP859lWByUJIw6ilYOFhLoaE9w6gmTJk66bbT9
YkegJbbq6vlvUoTvcrz8SKQLmu480zJ7x0547fctJCcSMGG0JL3ykCB4u2xX
ZK4hEFoyOf35ixyxcDBye18UAWHhsqBKQSki99CdxZHNBGaK8teseC5D1AY/
0tIQIzAelrhnMFqWuPvIaXrPQQdUDyapqK0iEYzA9XlMTMDtHas1GPEkQtef
Tcr/pwMU34Vu6ayUJnJeZn19sJ3JY3gWZTcoSzw5//nnaRcXKLnT66p3zFAu
pJb83fSDQFXY5aOUMQmi0+eYtlOzK7aKcZ6UuzjFqBNt3ba7xhHkjdfvd8VI
EnftTq1b0nAER8Ydy1XXJQmfMa8Np54TWJDdX3JrpxShYfQi1LCRwA5ljzj+
KzLESX1rRT5TGmhW5FN3JzgJBQWd7JxKGkprr3p+PS1A9Efoad5+5oTqp4d1
LHW4iCvU365Di98puW9Ttoho6CA/trlYz8YFQ+/nrRrP8hBVP1klayvFYevy
a3jNpAhSb9/JlXvpjKn4Dw633nATdr1mue7nqKA/FbU4vcUay/p7BoUjaPjK
eeWn5YgVnHgPtykNUtF5K351rZoo8SNgRcWBUScc2fZ5k+YuPuKMT3Sti64r
4VEu1rBm2gWTVjw9YmVOeKS3wDD14SWsD9f/LPOVJji9rUtuSOtBZWzF6Z+b
PjAeL643X81mjPG/2tblg+xIlG7MUewWxcn5hQsOrD8pD2nr2eVjtBB8RFU6
5rIssXtcpthimRUBi61N95ddICBqQisOFiQOPt/mNktlwb/aOXnRbn7c2qa1
737zAoOaWXBPgsSHgNmowvIVigTr21Mdfh8UcKzpXcQefzmC+59GUYW4Cpr+
Wll/O64IP7F1iQ10S6TqbemEFA9x0mBf6sjBZcb14g/87XNUHD/RPbG72xoX
3xRquT6jQdU9Nb7SRIzgqDZxNL6jj7dhLvVRleb47pAcc5shT3zYejTDRYYL
u5L7SDN7xSFza5vV5jMWYJTdNHxBc8Zcn0jtqIwyYjnV9GSZvFPc1h1GVVUD
u+ADN8t0Z1y7/cYodlYFSoqc7zd9cIbq/LuDqsdVYaLRK0pScEFw9+mfTmdV
kSn0Qtl9owsKzgceuEVVR/j13KmAFS7weNTcuOShhjJG67zQIRfcHzY/53hM
DdPHtfQDBlxw0E0/5O0FDTycOBNadMkFjCpy555mdTSftrj+O8MFXH20vVLa
mjh6Y13HGHN87vOs+3bLWgNPRxXs7tc4Y6bt97hXBdMLo/4URPG7YPXeV46d
2hp4F2Ox6eBfZzxPeB4k/UkNJ2RLkp01XOCf09w5GqmOBJebgc0tzhBhnJTS
u6iOjEtrrXIOOoOiWaySVq+Oo3KG5pvuOuOe2lHF08z53JhL/pp8sDOkG2j+
26CBJu9tyoklzljoseLceUwb/ZwfCjjlnDFc3md24o8m4iUmhnyPOkN9/M7h
q+Ja8Nssz1Jv5Ay/mQzNGibH/qjY6st20Am6/TcaL7NrYe+xTpUZIydwCTdv
GrmugXtX95VKx9MgEzV6vChCE/2ZN4e7b9CY/uY+4PleHYkPfq9Nu0mD2eHt
Lx5PqaG+fq7nbAcNjM/B2eVCmpDZftHg73oaylZaja8RZrbPA42qBCMaRBUf
v/YQVwcl9Pq+rR3M8bSUNLbI9ODh53cMbYapeGewqm9uQg3uW5+KVQnTmPMq
0WUmqYHkQvZHhSQaNMT92h8naGKj8NKdhOc0dMz9PfcvVRvtLjvc3pbS0NTU
v9r6pgaUL5M26lyg4vsiT6ZwtDrOmJHcxFxp8G/7a/F1VAMme5JPutZQ0X9x
LI39JXMeUOw4QflMw4j2Tpspps86sI+fKfKkIfWFsnMwRRs7uNw/nHtHxeFA
PbZTXZp4Ln7YZaMQDcMLK1Nty5heX1S/TzOCCnV7CWfdIE1Eck1NhK9g8vza
K/N/zLXwtXXi0/mLVAxSSxMlPDXB+uzPu6tFNHi+eyHnnqEFTqeN+pQMKoJq
s/ZUBGjAhh6p6GXvhOL9xSs+JWhD1kXnVkMVDU6Vtp9kmbz6TOQOKYLNCXtb
W/Kn1bWxMWqbvpCOEyb+6tl4aatjfcq7QykeLghs4lDQDVcBLz344/BDOmbX
zZ1KLbxP6R7WcrjgToWWL+2snKM1lBjfRG4z+e70iNV5Mf5ZxhzfntUhwi6o
9k0Nt50Xgv+0LPmxCh3JCYFL6m85YFEYrCUv4YKtKr7H+u7KIrvHllVKhI5g
UptbRIkMOiTebi7+TkfXxJ6X9C98MGuhfhuPpIMVClLkfUIYLzB9oFhGB8ea
+tSrm6UQrvBYcj7GFQZ3neqHu6Qxeul5itA2Jg9ba5nsj1eBHUeM75YAOkpn
ahPNk5TRzZLQvGW3K/65Xez+W6uK+Sv3OdK/0rGNu3dWM4aMi6tNj0bkE9D7
Vz8gzmkK6pkSLcKRyX/b0kYvfjLBuiVt96fSBLQmr1l6+pnCWd6kO9acwO/2
601NL02h9FxQ7PwggbA1LeO5D83wJbpba0UoAeVhgZyAKjOo17Qfs6IQIE2t
mj3gaoZ20qoxx0kK8jbtXLdPyBxKd7yLxYQIBNzXijc4aQbxnWfUonQoWDoh
N6JywAxZ3dSfhy5R8JseZZW33Qz1Qwd+m66joKMfp99dNsU9cSsfjrsUnJmY
ThEMM4VbyOG7Af0OeB6vcmwt0091Ww10V484QIiqPPaP0wwCjy9EZAY54Izr
0HzeWTPUpNR1PxIkkFfOYyZQbYKT5dvrjxIUZN9sdTaXN8XZkhcX/uaIIirE
59CFM8qg/F0MX9mijqcXZdensKohItPi6hdlZfT+uPBEbUAFDhce89qsUoLw
1LKYzTM13PA7IXAwWQlNeqr2zUx/C7gzlpLcSEb7rWM/df+o4mrGa99rdsoY
luAu8nupjvsVIyFy/sp4tO2fQQzz808rrHo0J1UQ5qeXUs2vhn4iLDTUXw16
zXJGnyeYnLstge/L1f8811HQmspWgWD/zLRisDIyqgPKWJqWGcrei2Xxh1Rw
7kJGeuSTRcaTHx6nSbvIyF9V4sVp/YvRyvD/crFaGa+TQnsTDvxicI3wVXUx
veu70p7oPf6c2PClIbR4VAY1ApGc0/zs4B3ZMfacyaP54Sx5rTRZBAqf+2Q/
y+Q8S85DQj6K0N/4T2ObLQkDOx25dE+RECfw99s8rwI2HLszdmRUETTZk3tJ
tnLQ4Hu2LB9PwhFn6zldXilEvLl0LonpCfGbz/J0PJeGaBzlsq+TAjNv96vr
XWOWv3BXLuaDEl6PvllTZCuJ/ZlyKv6VJBz43iIgaiEN29smi6vz5FEYPZcj
YiuL8+m1W2wsFFE8Z/0sTVke9LgjbuWHyPhh8bb+o6UUhOmK9dcnlFGWKGKW
OyKKOZ8PQkEkJZx5fllZQFcCoRcyrf/8kMPwdG5KVI8YrK8/D1H6QcI5JV7S
JLPcZzMm/gnizPmYHEjR75ZC/dRmtR/3ybh9Y1xAYlEce1gOsc40ML0iaN8n
zmBxZFQq27JdIWNodRKvsoQAFug7ckgkEjxCLzSKq8kihVNa5t52ZXjsSXU+
rS4J98yAi85BZPw0nx5Z6heH0KXjjVrtyhg51LFprb0EKMUrDx+8rQ4T/7Ty
v+xiiEiuEslrU0XqqEwyKVgMa0Ts+7prVKCfVEEqZbaXZP3njYwUVRRZqFq1
uAigwuuObtGoCnYV9R6RYF6vOfDpU7MGFeR3XzZtMhXBDmdzbbP9KuiwvH+t
IoQf62WSdD27yXA2V+Fy6hBC5aH6qq4UZQRSOjyiXgsj1f76GJcb8/6FFeJn
fUVA86d0flFSgPOKpjTJWlk8dK/f9rFCBWNdYb0UP36U3u7kXjWkyMyrGRG5
uaLQiznFZ3iDjDZvItvYSYTp3U/v2OjLIezvGN+omAw2m3zZ86JfFZXzvPmK
vDLMuGQfDjNUwfCv36O+3MI4OstrMv5YEQJ+th8SltnxxG/Ni4taZNzpyWrS
8uGGT4vseJS5AlZUt9BpKaLI+h6617xMHgd3dP8JteCB9rnlZUUNMgTjAy1i
f7Lj05f1DiGeihBplow2pM0y/n3dubVlkxLojY8c3lcsM0LyMu3CvBXhLHjt
arP4MiNuHc/on2IymsU+f993/wejmZoupKwki4jC75YCwQuMiLwdr8Z85TH7
5JFo/NFlRrhVTNHTPBJWk3LNjQ9rIrOMI3vlOi20PHh2/T2TsxboUkkZM0we
cB0t907SxLWmZoNtwZpMzxReUTqlgWxG0u6TTvqosP24kaWEgGDN36HCrUy+
HF/8J/Kf/aujebqPSUsQ//v7TGtiMy2Vuv2rM+pVr4SH8U9TROZ6SFVWTnjp
/jpA3oeNiDxTFfkxRwbevRwf1BMtoDyhfuSmjAY+1e6acb9tglfHld5rKzjh
1sMXpRVvuAgB94t1Nw9p41LLbft/MibQFTFQTY51gsXh7KpfS/yEgW/1faKE
hvuFIyyHfaxwhpz8rMmSgjF5NbPPu8iEqGrJUOEGCvbr6y//bpQint/JepDF
zNfapdk3JHdLEqZJTZVabBRMrheMFG4VIz7J2L9aDLWHNt/3FMsqAeLSFnY2
Li8H+Cgp3JRhEyHunPgwS3/ugKWGmR2vv4gQV87Qpb3cHXAghGrAcl6MeDHB
dmb5vANM2at3mHaIE5YD9ZFvTtsjgRH0/J+jKCF4tK0xm8cB4SktQbkrRIl4
ryexNzooODYhJbanWY4wVDfKrWhxQOnlxUeRUnLE3rgAATFTBygf/qcXYyVD
fLo76k+nOsBKQ2rp91Y5gnUva9+1XXY4dog+ul9SjrBX1xStX22Pr2mikguX
FIg7XusikjbZ49TFksysWlnikyXX2rhBewRkCUSX7yQRaoVqhyLf2cMzx5yu
mCRL3PYqicqOsMfx8QXe3GvyRO3wCV/JSTuQow91rB6SI9JdbjRsX2OH3wPb
vq0WViTcN0/u3JBhB5u3tlt91UiE2WRrAZFlCztGHzfrOXninjf/j6g3dmj4
tkEq8KECUfXGvXk9mx0eFp2KuBRBIiZlOUjTr+2Q5xVQcMZMheA4d/vV+lBb
nGhJiebMVyJmrlfHKivY4+SeddPi2WSiZsflsJl2W0j8Ce0PX6VIqMbfb3yq
YYdI3pwrHl/IxMt2u8m0T7ZQ2/sluFSJTNwN4X25z9sWpFeklqDDysRUk91G
F4oDqHd/qd0TJhOXNbyTwqwcYL7pnMI9HkViJKlq7M89e/Cxd5f4GygRdxOv
f8xtZ57/LGTPmFMkwgqEXjrupaBKxkQ0YrMiYecXXrad6Zdfan19wnxZCJMO
iTCP3xS85NUPWL9LkXjbMXB4WZMZj4bK2kpGpP8ZL//1auWKqbpI1jvbaNio
MLQv6oAg0VdoeNrOxglrnvyIUnVapiiOKh7qsnbBn/P+h1uPfqMwfA6HuzG9
go3xyrVdzAyhezaHJF11Rt72xuIf22YoHjuvJvUEOKGl71u0xRlL6HgtRZet
cEKs2aYsqz88BMdo1rUfGpLQdn7wVp1qAXqXVI/iMRoOvQlnjIWLEJevB5Ft
mePr/qoVAidcuYj0xU3HjrznQZp6j+ZGYTO8qdxrmLtJFE+ihxmykubg2LYl
Lt+CF19D1wvtu2GJqCpHjxNdCkSA1EfP574CeJ6q+UnlAB+RtNKBy1faENQ1
B04V1c5Tdo6Jvbe+oYnTmXK4Fa5EdP250RrYJw8RW+pD2bxOShzrqnRKoza+
pJ/iPq7niFzhQn/5OjGi/fr8lyg3R/wayd91f0mESB+N7XjC74j1jX+OitNF
CJJD6syUuRPY3d0tPXwFiN9yUvl0C37IfG832Opqhfn3HyclmXHUM139yVWd
FzcfJSSt8ZYgkoq4tzv+04biNYmyVKZ/zm/5XaRXzkEsdt9bWeCugzMWOXGP
003w+GS0/QtvFTxTPKeCi7rQesYmFVnuDB6CLB/Xz0H0k+u0DsAZV/PYZyVZ
2IjqWaWbwrdc0LaZlBknz0o0xll5K6g64XGihg+l1ApeWmmLB3Vo+PbyymYe
GUnidAzvYgHTP3WtrMek9y9QdH2v9pw7oA3/EOO46Bf/s2/b//x+xgT6lEMv
jG1d8FrF377nsQaywmNeM8ad4TrsVjCqx/QfDgFpux4n0M9/EbsgqYmvxQMO
G7udEFds42WnooXOZ4u5XOecMFMQmun3QgNpRVX+HSPOCFhx3t/olhZ6Cvl4
/rPfzfm1E6ml41qI1FvXn6HijCNSnWVnDupih9vubTXCznjfsP35fW5tiH5+
/srN2hnRmSEBUxY66HHX4KkedMIb7z/e+Ud0sP4mX9o0pzN6b5ZsDRnSxkuq
zy8PZn/FfPYwCvEzgNuquyHfs52wI4I2Fa6qA5MrNsWSzPElpz6y7+QlPVin
lgxeTXbCs5XEwg9JbUipbby62OmEkaf8Ex0PdbHw9lqQpYYTGHyvAsSLdREw
l59QyuqEZq82gcvROngZ4Wm3N4M5HoTfPefYoQv+qO6wLW5O2BL2/uvaEzpo
dbgm8S6IhujtvQpxQXrQbJsLPLXRCVVXaOYkTz1wXi/XPRDqBM1Xe15lJ+jj
8QGldE0uJ/AILyo/4dQH27d1B8b1nbFdO/L9uo+GkEjiLTW55gTThl9NmvbM
+J91LldNckJQ5y4JzoMG8FZU35bT4gTPHnGTiSF9fHF+taXC2Qm2IrG/pshG
OBie7Zmw0gnd7L+82ZwM0f2+3r6/jwbx1Rn5LgcMka5GYxkpo6FL5fJEBZcu
WM7JWF7jd0ZzV6Vu0qAeagrnVlCZfh5kan09K1QH05V3XPZn0OCneiolcl4b
bVfLL+5Up+FxR25lxIgOIhvSWAOZvvxuaLaVy0AHrgUPBoY7nHBuS0Yy8U8P
dat6RLRFXFD4vHVk3lIfa7mzj/dpO2Ppc+T5/d4GUHaMs3+d7ww/RUuetDo9
vF1wWFvK5oxYlbO1u+7qY/z9r7rjK5xxlJW0hytCD5t+sG2/y4z3kweE1bgM
dBFbS3ZO8nfG3vunu5Iy9HFyK7+cVpMz1kvqPD2paoDibyubX3k5o6voFe0a
qy7KEsrYNzL7hyPqSNMHf03oLI/mpTg54WrvUIZWmBYKBxVKJjY44Wn32NWO
U+rQjjr3iD5FB0vyseN2ZxkMEdftPufq6Vgfqq/bytHNMJLn47TMpMOnOuBe
P62R4r7/yCe+XC2o3NXuuHPCEs9k0iOCXVwhcDxyZG/CEEOiWaNpppMGvcCD
qr26nARfbvT8c2VX2Bo8N/G9+9/7N/5/PlpkeNvutz29wRVDso7hrHoPGH9L
2blt++mIunEjynfhDyNxVunnDR1XTHMqnuyO4cC83u+r6XN0eGgqfXWzYUO6
xcjZ7h90mK1bd/dfDhcowq8uPKmkw7doyX3HIR7wDod+06+h407nElfdawE8
iijI+sz0/Yq6N6x3vfkw0Fk72fqNjl5eaULvpDACeV6N+16iY1XBqQuSjSL4
Vd2ksfuEKx6utLqSfZML6ReulHbruwJbmocE3QUR//fJflNm/WZF3CcM+nig
QnYu55d1xdHEoLHA4QnGzoMqp7QKmPU//NX12QYJxJ+NzHVknqc9SCtI0v4/
z9chhhyfm70m8XRwCSrG9V+Sxtnl0P7DIXQYTwZcLPOSxOhDiYvdoINqVJ2W
6yyBj2csOifkXZG4gX7yrLsEGobCtI2MXZHydLpN3kkWyZtJLH1CrjBXT35f
PSAFqTGldYEf6FDvbbob908Sxz8O7Gr1coXWq1fvNfokYeWsa9oU7Qrhs71K
G3v4YBly0USa2T9WnX8b+6q50Na1957XIeb9up2S+WYg9b/rPyD5v48JYbTE
d3qfu+sK1W3Cx4Qf80GNVha3Rc8BZ8eny59omaFzk5yk0LQDluv0Su+UmePu
Qpmk51F7cDtMF6cHmSMoMSIcTH5ziz06jNdmUFO9Za7fa4+Mm/4lLC/MsPZA
yavcVQ7wfxrq92eVOZ7WV13b8t4BcrHrdyhymqPnomilrbADDor4FkVUWGDS
NO2NVjAFurc0Xxb8M0MuZ4i6ub8DmutDBrezW8D26Evi9lYKbozq6k19scDn
r1tCn1YzeXE875yfqAX44zubLB86oOeboHNjsQVMozKjdi/YQ0G/O3uwyhw/
8xo/5+naI9D/6w6/DgtIeJtN9y7ZgaW6vOrYW3PEhM9/Lf/ggB+eClNW8haI
C0hYndLGrE9U+qW3PBbw9pUaL11NwQpOB5510+aoMe068vgSBWtO2imtOmgO
0vwgtYHJW3aGeWNG4RZoTi79ZqRPgIuV1+pupwVKkk1ZH/ZQUGr7ZzmnyQK/
mvunpCYo+KxafHbuliUStIMdwx9TYE6qnBOytURP5Q3y5IwDupePPQx/agnN
21fUL7tR0C1VUM29zRJn0rfc7qlzAIq2xL0zt0RJnFD6xH/WN3Kf1EjMscDl
O1qfXMj2uHiycr50lQU2XGvL7wu2B+Xl+FmxR+b446Ro++yzHdR3388bszXH
5O6R/Igae+SavbxM4bDC4g4ztwe5dvDTXOpbU2yOz2G6K4XdHHAjlt1H8b4l
6oy/SZzPdsAh8V1K5SRrCMt9dlNosEfLlGxE2QpLHA2ouCPI5Nfv/8js4nFW
yM0PM0ozc8BbyQGjX4QlLDKqdqSccsDA3w9BzQpWcEx8/3g5gdm/p9NFqyqt
ELuhpGRRloJvP2sHPZk8FGc68mV8FwU2hnxvd45aov36k53b5xzQ+aVdt+aF
FUgbngl/W7aGYmGh2q8Ca3SL6hx3IlGgNGSXqhFmjZc/KzQGXlKQFtF6etTF
GvtfPTqcuIXAGiNyiZekPVLPnt3oEkpBcQWteFrKGj471nPutCJA3xT8Y+KI
FXqN2ci3njqi+qaF+styOyy4qHdQmfzssbV1ZzyzfLEKXh3xAQr0BpSzZQgr
rLju+ejuJwK+tWpnRg7boLor4UfjDQdUWn/r4kyzxvBtrzCqN4FN2oEGfwVt
4KfXSFohyCyPpyNGstUaHtPHe1Y4EuBLTji20s4a7WRFRS5TRxg8/imw5waz
fVS3Ns/cJNBotbur+xWTz5aHdmjGEMhZSysN/GCFhIBkIaVSAtxT3XdoWdZI
63MvszPTxF9adPa5RlW8NLN+IR6mgB/knKC4ZVXc+KbsqMMpD4VzJwf2hGog
6WQvTf4CCY7BcgOlX1UgFj8ZnemrCFESo3WLjQpmLyrefFohj2L4e+0QUkf5
1TTFD+0KyB9R59jMoQFG6JqzP0/JgPybS4sUoY5/q2r2X2qTxeCtws+9BWpo
FxtjlHnIoU6TIyfgtDpk6gceaYmpIWFGZDxTTRWhrZlFsXHq2DKT1J+dpAxe
1dUNar/VkBF0MoReSYZ8WO38VKIGeDkfHvATUcbDeDpvg44mEq/+tj4lrMIs
Z1X0qyV1kBx+aL6uU8G6z40rRz9qYCpb69mBERWURpB+XSCpY1LS3+TWZlVc
L4R95pw4Xm84d+lNuhrs8rsP3qdJQUv74knFP2pou+GozL2VC/fdOgMnj0uh
RDHo67QKN1a+jVy4PCQLdzXJrrnLPMjnf/q2OlMeK26IjjVYiqJfDE/Mtsng
8tlJke0GAnit2yz7oE8akmvlG7vP8EPS55fEhT+ymLCQjB//J4WQKYY7mVcV
M6KfLnhUsmBtz+feR21KoAYv2Jq+YMeRNxqN3BtU8LRDNr5UjQuHPio03HBS
Rshbt079O6xoe/NwattmZYy4tHYTwd8Ynr22r/cmqyLz18THxTu/GONh1V3O
Zip4cDJd6dDfJUaOm02N4SFlXKRxvuIz/smY/dLyz/wvGSyNNRVio7y41lBz
tGhcGU/IXEN0v1HG0it3t6skFbSU7G1WnHpL6bQ3P9KZpIS60brtq4emGCxN
B0fUGCqQ2/Fv5yPRv4w9U5Y/a0zVIPKpeXzFjTnGzqeRUxPM+PNQsr3Vzz7C
0I++tdN5hSbqfvPlCPqNM4yVuHkOhKlD0XDovNfVScaGR+8Yp7arYVWM/cOA
h32MuyZRq3YJkjFV1py7pXWK0qojasymqgrXDWN+pz1/MEhrufLDrcngiRvl
f5jTRCHWhbzY90sFW8lrvvFqfmBcTtgTnNenAgujuo9be9WQNX3xiNV2TRhp
3749FKSBd0LKEc5R6siv+FInq6EF0yWaWL2xLgLvKTrlG2qifu9NRbGv2qAd
yQye5tJERqL7LmUBbaQFeHP+7rCHeWlD8ZFBIcK76Z+n5moHpPyLOU8u5SE0
735c72LgAFv78l1qHgJEs7tHwfKwA/gvl1fy/uYnrhtmv6nOdMCJLJ222gkp
QjF5mvQx0BaDZZ4Xl03EiMHHLxJ2Jtijxik14KqEFPHJpij682vmfGuf8q1F
QYKI1VA5tqaVlVDWib6dnKqFc+2d7QV0V9Sd/bBr5LE+7s6EJH245Io/KUMP
5K4ZIGD9i9+3f9Ex1ax9nL9UhNCKFZwY7GBFXZOMw1a5//k/Mk6Cg4fyyzN+
nvFFw5D3IpPPc3aq+cpaSRBre+tnPyo64+0kXUt4Dw+hF/OB96YlFSGCy/Zr
EkUJx8pgsSNcotimJ6H2abclAgQXS+60iCFzPu7eCuZ8KaHyImRcTQAvZ7QN
N8EUGxVPW8nlC0HgQbvu5AQzv+l8Gf+Wq4aKQ6lFFU/MsZYUej56syOaZrNO
HNguTsj0zJQ7fSfQ4CnXKNEuRsTlPJh/5KUN6S+Lu5++NAHhe7+R+pSGSHfy
zvWJltCpLzn6pYAKMVFLsXcpNsz8k/DuWj4Nskl157XqLJC7OrmdP08brnWj
po1J5uAYS2ZZctNGpMjg+vwVptjURursfqsFfaUv5XqZZnCbXbGHvUkH906v
+rY7wgKZ2eEuv8/pYGsTZxO/hiU2RvMK+5/SgsAKkVTJAgsIui8LzzK9LtPF
RfPfR3NkC5AP3PypjQExhz2kRxY4JjmzwVpHG9RL9qsIGSuMHz746dZFph/v
/Ok3LSZMPF5dunQtxwVRxh3HO5QXKX7UeeOmchocfUXa9n6SJI77r2xb3qiD
Vdp7XMxlTXG9asLP6oQLpgvW/v0woI0VZ+q5ra47o3iSXsrxQgsHWQ5sPPjS
Gbm3Hj+Y/6qJ5jNOr5KHaBD60bGoYWqA5Q0/5xs8aVBiS8rSgQHsegQKaddo
kNzNOPJGWh/cM8bRsmeYfte7oD/fagBz+2XPYGZ92KJVD+iL6qH2WNyNTf00
8N1fIh6m6OJLeWiExwcaFt4olNUwfSrBi+31tlAajma6izBO6ePV96cWa6Jp
EDxYerdurxEiBJV2bLxMxbXLL80GTfShuVWf43QsDcOqPm5Nzw0xXtsTKVhH
Q9Nbq7lT5kYo6Ff6uHOMyvTkwokdakbQmo7uTf9Dg035d/U+DyNkflL3Ttah
4WkY5bFJkyEm6m+oQouG1LDnJ4V3GGFmoKhox0cqJma9GFsvGeCQ5sLFSBMa
yC3ZtlSqCdbdkeMMFadB5sejDZqfDfBQ5ECD8h0qKjwykzsDjNHa/ePRIQoN
udQtL675GGObNslC7DMVliNc79+1GiEl98SbYBcaVG+QKvDBCEsKqfMafMz+
Exh5Fymuj7Lqki7ucCcEfDZm5ZUygWDZymuHl6jg7PR5zeZpjCMO3LLvZWmo
r5xpEXtijI+ZQbUbb1Mhlbiv1nGTCX6SVk5J/aTi7wHRnhw9EzSM2Tfc/EuF
7/Gg64SSKV61BKS0MKiYDg7bNN1nDFefdFfbaUe0st1J2P/RGLcKFCLrfam4
fyyrl/OOMTySiYG8USosQtKehFSawE4w7MhcFhXqtSU2dy1NoaFWnRCiS8Pv
VN5y9TF9eA73xVgyfbbib1zNZ7IxvKrJ31htqGDZdkRlcJ0RnJ/mJE4YOcGO
rdRpzzkj+GpTndpPUOHK6pXFHW6EXV8slr9doMIsjP3I2REjHJWn3D0QQIP/
XA+b8kZdZL1/u7BhhIqYpWq2sSFt7Bi66OUzQMXxU8fS6ILa4I1hMzS/T8X+
Df9Yovbr4nq1xb6XX6m4FNu8/0uXDjalOAtksNEwPmf+xX5cF7v58reOdlGh
d4Kw7C/UQ1v7ee2vB6lIPf3r+l4LHfCfWs+38joVx9jLBLZVauMe/c/hNb+c
IHOUFu1DNgRvz96UQ7udkd0m7eTnpoMoK+HaB5+dURX33bjtqS5IJZ3txq3O
uBBtEhqkxIzfeu3aF0t0pkle9jCLU4XShYhMnwRnWP+Zr+vlM4QDtdJ3wNEZ
JPnBHw/FDfH66YbmrHRnuL84WZuobwDL8+E3DHldkDteKTrubQQh6Q7/Bub1
0/7YuNfmGaIq/3vavSIdhElVpX2km+M9r01wUKIrwicPjz+7KAZitJBll48r
rl/TFcsTlcAB80KTD0WuENIzUyNmhRHgtmJW7IUrdD5861G3FYIS7fh7pTZX
xEwsjMfTRDEv4CvoAlfYixpxyNHFQTp5wSOJ6Z+BleRPoh0iUEmkDtdo0pCY
pvSWVckBq6o7Cy52v2Z4finKdNpPRwnrkbyvTD/U9m/n57loA6kGLrcNro7g
fxus1Fxri+aKTSWB2RRoWV2RDH7G5OOeSMc6YyfigXro3KEdnIROxDvDGX5X
Iv31i/HZ9S4oo2hvfxdIoH1byeb209Z4vPNCPOcSgd8vh24Jr2Pys1frrNt5
AjJefu0eqjZoOnX7x8puAnlZSeN1LdbA2q3JNcz5RDXjynCPog2cOK7P6pMd
ERl62uHMWyYvzy/q18U4omGP779jPtY4nXJeYkbJEcVO3dVvAm1wKUVha7+5
I76d4irT3maNm8nUqPf9VsjnfsihzPSB450DRb0GVui3XeO409gKBt02KaXC
jmABVe/thA2GNqbXZhx0xHRnZ6f2kg1enb+bVZRH4J7Yn60m6bYIX9VQtekf
FW/yFnu32DLbLSllQ98BG3xUe6him2qFvtwqo22+jjjyslLSp8wGMSdE/u5/
aoVjM1ff0L2s8Se7dGNwCoFSU67+SEE7fL3lJrGe2S4t6WJRju2WKCwUjH62
z5UYFz4N53Q6Dty0tH1zl0BZiU7BxC07yIgS4REijnDNWQzJ328LPsXY513h
jkhs/qmYImmHu6fK5eLDnIg3UetUkmOkiXU+H0yyN1NwLvlE6OI7ezSyuUZs
+UknVnfffqYmQsebFYLX9DOZnNX95OiNl2qg1L0IkDmjgU+8SQ+fHlCDeuWN
40mHFLC93+NQuaQ6bOlqc8dFyQj+GC//s18dlx1uCR5LI2NaMvXcGub5ru2f
Oq/3kTFUakS98E4LC45CUxpblJDsqK2WflQTxXf3PmlVV8LCslS57mUNaOsn
ilZ/JSHZw/WnlqMmft6eXX/yEwkx0dtf+P/4zz4gIvn338rgkW6YkecxLRxu
NJMtOqyAvTJJJiIntdAR+iCqM00OuarCR3+UayJzfVeAQaUSum8mcfSWaaG4
5eHDUj157BW+rXeTRRsxHy8mb6FKI93gsVcvhybeW72RkraXwdehTT6uhroQ
n1i6y2cvC/mM65ve9GjAgeXPZisXKaj0zl6GsAaaS9euUNOTxV1S8i6279rQ
GX96lY9FHndmGxQKF3Sg+zT4dH66OK6eOjy5+6Q2TE4rBkeyy+OK2Z9f1/h0
0KFL73YLUoaC0ObwiWR9dPhSDrZvl8LXZh6BkjBt7DfktOkfk4OeoXrnDVdD
/Di5M7rNSQnE7RfvAiZ10eWa5bnLWxpfX98wml6hgz07Ojf0akqA+3VNBlGl
i4+8kvKqElJIHQ+/tkpfFzqmvUaFZGkIBh56rbJVH2NGAQ9/OUvAyNtjVucU
k0vWOmUMCEshbklq6yVfPRzsue/R5CkEoXqH+nN/dXDj2Q//LevFsG74RsWu
WX00a/Kdmjsnij4E4HimDmbZZdW628SB6rhi53E9jL2rvJwXrYDrjXurTyrq
otWztEGTjwzieJTIb3MdXF1XPe4jJYctF2bTPhbp4cmFaw8ficogRDnps1ey
HroUst7/9BKFLteu+IUFXZgp2nak+QrguJV5CWuXJs7SZA+ZTknAfeBsxKCs
AZwfP6YRmxTReOT5Xe8AHTTuMVzJl68IvhdvyPoR2pDTf/9stlUWFhXHmrhq
dHG2+v0fg2V5rIn9pP1lSReVhcn9gqMkRCeLMalIH21R0RVEvzyw7cCk8LQe
1jkX/CVxKyKS1bvxb4cevPRazbO45FCzOnuUuqgPRZ/EXH57MlwwmZPFoY9R
b9taxkNRrHetWf9hQQ/8q3PeyVpzw/ic+5RMhAFOO0hv5fjAj5u+Ih7Jg3rQ
WLK9ZdQkjMGaV57GlczrB31vj94jAqlyB0XOf1q4scdxbe41MVSzJNZKqBkj
Wr2Q3nRBHjcKP36biTSAVQxfcDw/GTH795Zy9RlCzYhjzUSpAk4JNp4o9jXE
NemOc3rF0lD6fayNrGQIsyK+jSJ3RREj/rbg93ltKNUUFHPpiWO8L3lPsqAR
zs6LPsxZRYb7523e7ruZPPXoQ8yu7/JgWdvuFphjjGUpoQhvSKFXZmLu4AoD
jC67PovwlgXb0m8611sD9JDNVj6IFIcMq9072XkDuLLJRsxGSCJ62bIr77Ih
KgT2pS14KYEn8IZ3grAh5PYEFhbJkHAESgO3jxlhmMXRdjxeEi/HLyaIVRnB
5HOHvrYxCWeXbhc0Meu3zkLcMnOlIsp+82mcZ/KLQ6vyt7mXEtDJjT3KQhgh
OjQ9vF9OHClmGwtES4zwc/I3abSYDy9Wib58edII7fTsrFgzEUTsvucn6GWE
Q3Zbf2yNFUGY0bWjjQqG4AlRp5V3C8Hc4vO1YxP6ONzqnpNSKA1er8g3mfZG
+DOiV/riiyy+bBpP/a1jBDH9Ud50QgUXZMz7XxUbw8VGcIDbRRHyIbsXKVLG
uKEav9DcyY/3GSRjvl8GqNzus2n9XT4EDV+P8+7Xxxmu/u+lVTIwcdQKF1Q0
RhPbYKHuNHM8/G5/v/OMEQKvGK1X/yMIjWPeZtLthlDdV3N1UZMbKm+nx7sm
DbHrw49Ptsz8Efg9dvtdJTVsEHG/p7N3meGrOizVfUoa98PXXIxK5IE4y5Hf
YyoyKIl+/LPzmgDeecmt2R8qjh0h5Or4wdeMiqGrqgNaJNwJEfMSd6qmxJSU
pnGsUsbN2uPx9/rUIWX8VPTWeU2cXF8teeOvBn4XVW1fRdIA24cUmzNZ6oh8
KOvbvIGZz8e7OKN51RAtYFi1rKmBJnsvc4fnWiDz3bI6Ia+D/j+3S/5MaSKv
n7Nwu68ObN7q7IOfBsbYeQr/ZumCp+8E2y9eCkyci48JveQm9mVnz2gl2WFJ
p/rB6l8ixOD5EeHuWXucXsywi0+UIrZoZrD72b6lUFXGJ9XbjeCfILDiwm4X
nHcs/dqQq4X0E1tdT36iIuxNKGW0Th/lhz/LL5lTUXTVhi3phAl85H1EV0pR
8Wn3RKeZrDFmmugNNZuo8O46dofnhQEGN23XLr1CRYDPYNDxM8x4vT/3yrGU
ye8XWMTKmD6i/F6OwWtNRUNv5+X2eV3E/qDlV4Qw+fxHjUqHhjb8JdQ5I3yo
WAoh7VWlaiGIOCl1XZyKq6nWFn0hzPnwe9/Ksp+O+HHsWff14xrgKj7ov5rp
61O8hcJxSRqIDW5oHa10xpuhcE23QV005lIN0145Y4aQfNZ/TAcO8Pre1O2M
pHscGTbl2jh+ZuTyPmMX1JLDPfJStGF5/2/PXmUXrK++PLO7VAvJiwrcvGEu
yLEPXn1zqzaO1s4HRpNdEHuU4aHwRgexFbv23uZ2wbmpH995BXVAvvCtg2Hq
gq3PLN7piOhhYDWZHBbngoK2VYF1mrpQqu7gFt7rikcBmg11oloYfGMr0ebj
Ar0oofTk1cz+Dj38gdrmgnqeDp7BOR3o+X7pHo5wgfPZFPEkI30cYRPfIqxN
x3oHhWvOQ1qQddVZ8HvnAtusmvyIMD1sWrb82M7sz+X6fp1ifT0si58V5JGk
Q6Dp2tswY+Z8ErDS4s2YCzg2LHnYXWK2v6fF/dkuF/R0rVcQmtVGolztJa47
rsiMI3W2msphkwltSYjkCnFXP5YVD5Th8Fz/l6E7HSpkFUGZRzqQOu0/uCKQ
jgGt/bIzl7ShSRfe9PwRHeMlX9TDWJl8ouLSmtFExxN7YUbedm2w+m2eCBFh
Enj9Ww5GmQES+c9psk87Y1Pcpbt1TP8SH4u02ePgghn2HO6e7/oISkxjFKXR
Ie199kriKlUMeo/NPl/jgtNens07mPkhIb71mf5GOgZ1LsnS+/VgRR0dlWSj
o/GQ28qN1gb/53mREl5JTG1O53PBFb2iypYCQ3ihW+3QEabftO2hLF1n5tMz
aqlG8c74zH/j3ZyCEXqTvth6NzjjqzPpjKCbEe5Vr2IQTpIQ01JJfi8ghuf2
I4WffP5RKtYdPyBwWxuN/hk7jp/VxvqTzkQF1RK204/ynr2nYl+Owznf3dbY
WGknUXTGBeSN4d+f8v6gXDoao6/7xAU6HJ3H/eu5CatD/I1Xj9hjl+4z5fRn
VtgsEuFhZm+DVVN2fvUiVvjQ/dChJsQKZ2KIttQsS4Q1d29YfkQgdOJNsKC1
NY5w/Ys/MUvAqa8xXb7LCuTsPwPVgwTu9kWFr9tgCfcHNa/3Mf3iXGjIw90S
VtjJsucclz8VdasjyAvRlnh7WercF+Z44upLMXrAYQPfFju1GAMCex4EnW9M
s0Us49+7PL4vjLZE+sfYdXRY0DQfGRm5EqubttybCaD/T3v/13obJxdczuyS
fX9CAvs/f/6swKGFNb8+d+Qxj+1nc8J1P2mgTue2nm+aKK7jmHVXtCZOZA6+
5HASx/DCy72NzGNL+v3gksNiuOex3UrzoBbmnyQcPLBSBdvyC8NvXNTBb+6V
nH3+ykhccHG4/43py9mcP9p5lbGL/cjWZ7f08C72ZrdXuhi41nKZF3rpYlbQ
MQuSfFC5Xxjw9bA2/OobDbnZlfDO0l9g4Kk+zksMeQ2ECePv/K3IJH5jDKmW
xh4LFIWDiObCx1FDxKYG2XB4krAwXdwaIWIMGs+DNRqxclhM0KZOjRlBlWwq
bShOBotVfbTEChPwSHv28Y19YHRSq55OKRpiolCcLaaWD/bfK7WbyUYw2PH5
nj6dHa81VG5tjZJB0LOKnk4bdrCum1Dy3iOH0dtaCq9y5hmHR8o3PzGURdzk
5W/jof8Y+psekvcdlsWh5ohUp/t8mHnFMTdbJAnjuG+929yFsXswRn3BXRK6
2pz7VOTEcKRgtrvVVAwDRnpuIxliyHoVpzseKAHWS/cfpYaKQP3WpbO9W8Tx
/HFYZF7qOCMp8nGPULU8Lo3MuR0zmWUEjOzY3WWpgGul9muee4wwrLp8o2+P
KiCP9eVRCcnHDJalqKodaxXx/sH+Sfeb5YwhUYYdRxAZpyaTd3MP9TEaVBxv
2Kkp47ve2nVhAsOU4lLV584iKkg1H3axD3hB4Z2QHbdTUkFK1aeY1stDFNrH
X2s+sqiC3HuHdoD3LYWH//uVaE91vL86+nBp7SjlhIF8SN8KNdyxDDN61veG
ceXxZc4be9QwuuH9kOATDiLW4Wao7iUlZEV/XyyRGKZsdTdlff+aDP3Vq2Vc
3FmJ0waXX6ec00QO39mU3StbKL8y37UFeKiBV0yeLWLTPKVlQZkeb6OI9SqX
3vXqshCtQkJu4QtquPCkT3z7rR+UK+PuiWuTlFCuvShxoe4XZaBC/MA2TzWw
m6aOb8tfosgJFMdo+jDjMLC8hGV2hFJMLp7gK5VH1KedP4KaX1MmDqiseN5H
ggNjqDDfb5QS8veLU/xZBbCuFZsl5c5QbBHaaBqtgXv/1qJ26wylcKejv/wj
MkyOU+Yqds9QiAjposCfyqC9eZXqFLFE6Y7eMRSsQ2byFkf7cMsyJdc0Ru/r
pAq+XdUjkdtZCYuCf5H37pGhplQx33iKhTippjVatk4R52erzlzX+025sNxr
nWmkAs+xHZ0neNgIq130xy6LyvitQRc/szRP6Vo1O64drQ69Vp5/YgvjlPNu
E5flo9Txbv9g/cG2ZcrHv8UhNcka4Hkd2fzn6jyFpqR++mcYs/9WhX00UVym
7CaVlOaUyELdWvHHi/1cRPJgfO2Ba6r4+FnJ9GrVH0rc9YPEDzkS2Ok1cgN6
7MTb+0RlFqsqykVF3BVbWIgAltPiR0ZV4V7bRs+I5yZaoxKfMIzl8eaqhhHb
iVlKY6dy9sxDOehW7dWPKWMj0u5ucT7zUw7NOy1bfgxzEM0irC7Vdgq4skL6
j9DGz5RfWw/2ihqLYyV3xfnTfFxEnma3624tKUTnhUr2nRUkatrchhPyFDGU
tmKO+m6YUn1nMehUiDTi9Xlk3TTYCTuBDdVH1suAra53rehZXuKP2ClFdw8F
bCmnpnfG8xJHd37K765Qwu7Llmsn5EQIjZCjf/fR5TA9+YGt9JAIEX2bvZKX
2d4ub98qxEkJEOYeGy+arpNHziVOi3fGQsT+TfdGvd6QkXb1S9nBX8LEEOXA
pahCEqST/HJr/fiJtM/liVkSMrhVlqe4j0+cSHwpX1vdoARZ29ScqFlewsip
SWOyTRbLWyo6iyVFiRRO93+LTM9LZBEVuSUvSvwsYad9CiBjxdTU0i11CeLt
ixf0TmZ8ds9sruOaFCWuFy3vOnRIHnxr2bOCucSJitHqfwfTFODLs1s/TF+c
KCGeb8lgSONo1oHoCA5p4svjXIP6E4r4U2dlysEmRtwLOlgTHieL3bNz5pm6
ksQPrnuk7BQF7M+pebIpQISwZWRVF0hJ45NRhFWbsAwRHGm25uotOcjva+F8
ZiNFvN7IaiN8Ux5tBT++/vkkSdRUH9Nv7JQBbZu0VfXsd4rilnmV8nhZyCWX
OuafmKPMGcsrTx6Whoi+rsyBmZsU+p66rsIdsohU3rdrWLWD8vMEv12vgDyy
T/Z6pRVwExnrKjJ03JVhVaWTrnmcm6AIKbnZHlBBsLtTm549N8GxkmOIkyyD
7d7d79d4/6XUbBcJPx8tDY62qLwTlEXKm96q5/x3xKFV23xi+Pwi5YV+fgHL
I0lYWI1SvbJYCeH9ufQNGyURc+ZeiWz9FKVCUmTfs24JDHxbv493WIDgffro
9cIOVTh/uN9+t4uf6GgeKNk2rAwNyROf+Mb4CEmvMrf5DgFsO9EQrWc0RTFb
daItNlMKNa78M5zJvIR3ldWCia0q+jbC/PNPQSJeasbXolgF13hXWjb6cRHv
BeIUszXE4Hs3Of3INAdhJt2wZrWyBN638uXTZFmJxqL0dD4fMYhQqCe43Zcp
Jdp7Zf2zhcE1YJvSWchOeEpu+ZOlL4qJnguWElzqqJw2sDktr46DCZtCY1nU
MBRxPbbuqxrO6V1z1XZVxSIvT+q7XE1YN/2RWZ+sjvUfZbJrRHRQH3z+2Dsh
e1Q+mDm4wUuEmB+IPHt7wQ5Dz66wP8sQJ0QOXfEX3GKPDUFLFke8JYiZj7Ih
yWb2qN/qaMv+T5Tw76v6tT3QBTYVlXO3nmjio8YB3kvtLhj/Kvk1Xl4Lq+1M
heoaXXC89Y+9kqA2Ugs45911qTiicvaAhqQJnhjJjyVGU1FVOnHOg2ICO8/3
DYcOUSHI0mrYX2+C7eKxIXpkKvinumwu5hvj9MudTf3ljtj6qjYw1dAYw073
RX75UdG9fsPRCz1GaGTd53J8GxV9a+XFd3wwRAJ38y29OCrKRcw/ktfqQvDO
p8R/BVRs3RG7N8pBDz+1hAddc6iw4YqTG5fQwnHhlr7BChcMVgU+EpzWQ2GM
vOrUVRfct1M+MdKkC/4rFLmeM3TohbduTqjQwYvzWVdKj7nClyS80/WwPNhc
6R0nNrrC0PUKaeGxMtqXfRqvvqdDjrclJpOZj9uDYsZ3whVuWxiraNEquBvn
c/4M8/0ainUqni0kZNziG+nQcIXN+5BVHWQ1sO2mxLsWu8LxcpnDB0+F/7Pe
Sh3xl96LXRZ2RUnrxSGZv2rYXxzEXhrqipu8ndlzcmRUl+9PK7dxxTUj9tL9
nlpo/JJ9v4PCB/WMRM50LUv0kRkXr0xo4tIWRmyeuCWqS81XO7TbgxJ/UfBv
lBXiNv0eUed3QLLSmXNiP60QtatRv7rcHt8HFF4S66whrWq9NGRMwdEcalZ2
hQ1e5E3q9gTa4ey/l3s5tlhB/Ldqy3Ura9T56S8/CrKCQcp0w8hmJ+Kpiei2
cHVWYk5GfL15NoHJ4s8KmROWCN6V1z+QQ+CJ8fDB2Qgr7NFmP+zd6QjN3Kmj
Nx2sYJS+reH2C0eMtTi7rOy1ht5hQd/s3QTOFhHXFf/ZwLLi78rb6x2Qvliz
8bmiDUTlpdckfaATvdKPB8M6XdC4Wc9Xs5aAQ2C4eYSLHSgRAjMRC3TCNOCc
jvq3/8PHMs4ghDfUbHhcQLmznlNijs8VZ+v7g035nYmYCKHrNw34iRrZoCC/
GTXinX3jFXZrOvKTVD5cbZXCRe8+gQZm/E8O7+xM6JDA0M0bjm8ntfB4s5/B
Qz4RBDYoreIU1kIGpAb3OiojmdLStYFNB49W+1nbhahAOcYhr2FJC6sOUWJX
hSqDonj1bNWsDiprpXdwyalgpr5MhtKqjZj05JLoOQGcG7oeGdaphZ1eJWHp
/4+r84xqqmkXNr333iH0DgkloWboVVGUpqBUC6IUG6CggmABpQiCICCCSFWQ
pgjmpkgVFEQRFAWkCUjv9cv5zvM+a73nV9Zea/bsPbNn7vu6djIZWzZ4/ftL
6vCIApyU3FmQFWSDyutm39efqoPI/qrIx5qccPHulRKrGnVYVx3qzLwiBmOM
yL6zAQtq7qdWTpRIgH3jG4taNyyIXqmwLIwTB/n8rg/PTmAhVjsg6dENCXj4
e8bdjFzfBwu37xo/2SHOds16+ZYGPJGpKhkZ3SSZL9bNiMqqgbqllgNdDjvE
G7t9eiLHD0eyeIcTD/WQ9mO2FmkrZWCu5gJrTN0YqTjrd8zh/bLgGqtaqWy6
TfpuHElQbJSF+5HX2oZkl0josVOzXqss+P/omz7Ntk7SFSn6wWamABIpwdZP
HZZII3+C7GIE5IGBOCUf5t5LFBsTzzljJwf2SWWdnMvNJIxS3veSTllo27zg
nG88RtQS7hyNI/NbunvTOQjfJe2PnPmIx8hDaVFv/6HBVtJLeXuxHbIv604+
sfN61ka8gLnselNPFj7d3ZP5SrtBGjtH0Zp2Xw6o1Cjer4fQwqkp2tZyQTnY
r27kTNqiAoHkvfTiXAU4kCI61YT5TeodNztTmyYPiA8/IXe8kcTwfFW1aEYO
hCO0vljcpgTaNM85zD45YKRcKYoMpoG1uJtH1jzl4WOKot7nHgYw/lyV6xwq
D6LJI5I85+lA64hTu42eAtzfPfyON2+PVOJ2OGqOVwHGqJ1MNCRmSKfYjM8d
/KUA0uc6Xjy5M0+Kiyz5QbMpD5VN97WCf/aSWgmhGdMeyuT23/Cr5/hB8u5U
Hny6pQiENie0HrdIPLlTtHW2UASkRw7xdtOyoOarAqwB5HE8adcYebONAfUG
+z9uesUN+oeypwjtbEiKvuBgrBAnWLdVj9tmMqGn7bxc3m84gVuUTaMxdoWo
TDf3840XM/AqOeq4+dEjZtn86Jwedrj5LvAiDT0jKj2383f4Mt0/848R/ef/
OfQHvvI96GJD7YJPvnU9FoADwvhqSyoeFHH/pYRHuiAUsVzYwgqJIkVvS4nM
e1xw/dag5FvvHtKtx9U9nBd5IbY+yVVR/wdJ2c9tK0ZACEzezlHGf/5CuqUj
S7PWxg/ijU/2sXk2EhUDakasgviBsE+7M2/6G5FrQuJEsiMvTB90kK0MZ0I9
auYqdtUSoOPYpf0sgBndNvA8PmYuC1dweWq3lWnRwcjYplPesnA1sis9QoIK
DSjz6n9tl4Ve92MCv09vEmtI/GsDpZxAHV00e5t2keg0+5KywI8L3D4y7HT5
LBEl/Rwss8lxQeiUXaH5jSGSyNGygeBAJuiiNCmd2egnWvqnYvQlWWD88Gei
YswM8fQfSY+rdKxwQbVS/czVIeKHgy6Ot7M4wI8L++pjVTPpffDMCCaeHd6v
How9yygNXW/CyoXY5cBHJYmPXlwaElzN3i8xywPJgYMtkcwNis/zh/++JY8v
J7nEmyAJf19YzV50k4UstZ6nHm8wMMfYdkLqjhy0urbhMK8kQHSG1nppUxa0
rS+1Vf+QALUf501Hx+Xg4YSM8mNlSSgmXO1NS5MBijpFnoEbkhAw0fLlg5oc
uPQM6yERfVAvE/qRLsWDdntnDU6nmcM4GopnXpSD4r4l4glRC0hMYN/gSZCD
B40L19j3WwDpxJ78014ZkPTtzlwMtYDLTuecpRnlQYuax2dawgIefG1eO3Ff
Fr4OPbrhs2UOKkKEL0MWMlCmz37c6qQFiNAL0rhMy0LXiqzHqqkF6J61wlHL
yYPYbtWv5GZzKORTuyPEIgONFB18xgYWoNh27W7Dc2nobaF4BZYWsFHWFJxd
IAXideYSx38ZQVH3xIMZcnz8fbbG2oucn+Q7eN5cDVUnx5vVoLAQYzhXcUKI
wwYLUz1eFpGhNSRm7Y8ZytXq4HxzuKFhwQJGoueo/BMVgfJL/2JyuCVoExs+
sj+S/O/8ro6BpCXGvDR6S5C89Eb6CFYBvp7r8nzZawFzMy/UnHTloehNv0RF
rQXkeVaVZw5iIOGZYkfpCUvoHzib/uC0EByYErnXNmcB2vWshKloSQizVn/d
c8ECOsTcSg1UZf77ehIi8HH7WlQQWID3u87JLiQF93Qc3qhXWoJ/Um64xWcy
Hwnxf/Yk88Tre+/XZIYkgVH2tahtoCWMsSYdpgiUgcsyX5oIZyyhRM235C6X
AuQ6SmJ3H1nCZQLutVMyBk5PpN4pcLWEr1KHjDjvS8MnS+4s+mUzaE0v4TLd
o0GYMwIqlAwi6GfxlozZbwl4t37qzu59M+D7Wj+5sceI+CYr8CpTFmBNeLRs
fIsKSX3DpP/FGMP3vuPpFEsEUD5aTVfYZgKVe1m0nU+0gSeM98+fUX3g5BmO
jWkiQMhOt/gfCgMQxmZIswsSYI+NoFt8Qh+OTYh9VknEwzdWmyQRawM4Y5cT
cukpHnRul+bhk/TBDp1LeLOBh6Yw6rYtSUsk9M7iMxefOShFiLe1tZD5RZii
d+oDHpx7in6/jjUCl7ik63uFBDiiX1et6GEE+Y0eN37OEECSdG3N0tUInJn7
U3ypCDAkU/3gzrQRvBR/G/CXQwdYsfoRJx4agXh7PDWoEeDgVK9Zeg25PtfZ
OL92bZBm+m5FB0YQ//RZY2Y0HtRuqL6IP2YEt97P1Ez7EwDf1hbFWWQEXOl3
pgNFdUA7ilu9p8UINuzy9C+9IsDDvtJvLTFGUHZIZFiqRQd6bh7b72pmiopf
MZZPxawTV255moYpS4FmtWlyYIg8DMC6oa2nBIRPX/74UEMJBPcPmoyoYYDi
z3tazCoW4mLUF4JMJMCwNqSzuRsLWvlW9aaS0lCYRci5FaUBW75pSt29GNCv
rHrPJqkB8Y1RnefI5x+PthQJT8FBytHf+YR1SRhPYLWSPYuDXrXI492C4hCA
C5o4HKQBFXEDHRFSkqC2/8KTzGIcGPy0cs5RkQK7sQ9HSFwa0OsbKcxAjjf1
8ecfPRfCwdRu5FHigDDsM3ve3FWEg6Fnml1FGAlI0dML2J7AQV2E0tGeFBFY
tC6qfiuCg45IKrNAfjHY904i+ncMDuRjrZ5FeYvCc4UvV8t5NOBqXdQ93QuC
sN1o8LugQBOUsjTUbVMFgXr2dY7TQw1ILqJ01SMIg666wsITTQ340S73JvqW
CFhdjKCgWdUAE49iTr2H/BDVRbvj/QwH9lym4ZefikDj1arz+tc1oCDmapHf
DUFQr/+j48GIA1wqPqSpQhB82PVZYjtx8MIo84/hmhA0nr+6L8sKB9OcrCE/
GyVA7NtgQ70fmbciCVGGrpJgzxHs3EbUhBYWNf8EPQlQyUhl3gvVBHqtWBeG
dgzcvFWkq1OjAUfX6QSUsBIQ9dW6Z/2PBugcWOpPlcfA7xIWPWlVTWiN9Rt6
HyEGj6PxZkPamvC9kO7UWStROOGjyp57VAuuGol3BR4UAfXDrvz9xZqwGvnj
+MkNSegTZRWRLtAA1ejnLveMxeER9s66JjneufXTnA4plATxyxctclrUwIP3
+vrfFgwscZieJMyqw/Be/f0ndzFwpTulIcsZCx5m+lsBjzFg98bWpcxCHaao
bSLD7aQhqb2oM31AHSalpw6p1kmAUSX9OL+WOsj29mNZ/DGAaqWHM/FqsGQV
snicUwoG3jLLK3Bj4aPfVIv4IwlQUE38kGGgBlq/jvyuxmHg7/GQxw6uqvBL
MPvBRp0klFD4MmiEqwPHRMCPYhNpsFAAn6X3WFB+e0CakUoaTAfm6y7LqsNz
tu/y3gPSQBG9YzSYjyPHg1+f9Gyk4OBleu9jyVio+NE8zcIpDV9ZP40m2GEh
vfPgSQV+WRgovi/H7YiFZhSJieGSgSWWx2zzgVj4NSLh+3VYBnBb+4XpBXDw
Q7PlV7GSNJzxZH6wTKsBwc8mHrEmccDW3kB/qiUORDpigm06qGDB896BIQU1
uHWu/OHbgB0ShYL4epQsFo6DMK6VlQIW/DJe+Tmqg/hqacsmPwWsMDqPNzep
wbefX12MLmyRmmJOs5KElCHc3iGB7dYaqfIVEy65RhFE86/9pbiyS/JUd0wI
wCgC3T6BBpFblCBsreVYc10FPtfLK+zdpYMYta3VIiYVuOhLZzmKp4GaZcf2
TnclCBY7S2H1mw5m714tGz2pCM3t98TcvjABR1hU/9FIRZjx2Lh5+wwTRL9a
bXn7Wgm8Jg+mv85dJrF16VUYbSmAsWIs0kyhBkyiA90PE1UYe/4BKjqpgNWr
6NpRf2UYHWdI5V9ghRh1r4XXI0qgX6DBJpYxS+xPx9tlIiWYWpO3/9zJiCrq
w9WzjvAB27hTRbEKJzp0pczdcoQbRrNrXr9dEURsu+mWRYZ84BcoltJ5kRc9
Tn/ygNVeBiJTBtpYybynqN937sAHadD3zbXy6mVA0z27NUoi8nDtzp+R3h5K
dKXy7qRJBQNEv7vrcUOYGj1xEi2svcAKTosZnn44OjTk8yXmJBcTnBBXziua
4UGyAVR53kp0MFQrTU5Jr0jaLt3fKL4yg/3fCzfeb3wiKt59+vfONiVcj04w
aE0vI6n3DCeHxNIBW7mOnoTXKFFiP1yfaqf7d53Yf/g49tJ9j+SL3cT9K8Qn
as0MkK0y8GznYh+REIdTNqJbJVGPjrA+4BCArlz3g75Uu/+sv/tD/M/5WUw+
wQ5yv0gmzyKHdTnp/8Pf/9ZvWp628Ev9Fakyunapq2STZKyU/3H48Cix62T8
tkEoNTCucD5/w7xJOle7hVFv4wTm9Dfu93sWSTHhL2cPeDLAG4WFFqzHJHEk
1P5dbPwWyeUoz8rV9m+kdSv7OqnJf/abpfjPusB5UmvndWWNcV4w/81rpPFu
m6SbnRSos8kFQyfdH5x1YQCmx/jd41S8MCXWH3i7mfb/rDubJ/3Uq3y5dmeI
1Jrt9tv+1fZ/2vtv/SVeqbVYdV4o8giJmiSPy1rhbEk6Lj64Uyh89fkxKnis
m7s63SgAJ59GTk2gNVKrCY3ZbAkG9v1J3+IJkIfMTA0b3HV9uKTNd3BwlgsN
z5fLHS/QByk9yhs8t/iQhe8Zq+bbFhChaDQTuigP73gu6riyGIN14Nu+jBx1
qErXibR1M4InxXTybWfVocmH7XnrqhGsMV5/lnVE7f98H6oGZ/RKW/6mW8Dk
qGbG9KgE2Go+8PdstwBGces+3qNKEBSXe7yr0wJWTRy/dLoogySjjKwzzgJe
nZvaQ7NKwPo3zkOQzMuZ9V46LnVKkCd5teDnsgWEvqNlP7wgBlZT+RK3ZC3h
mpkiFy05T75hWjzOR+Yrh6rshOlDGPBcjq7dl2IBAt1v88qukX2cOeuzaY0l
CAXaYCvcJIBpq/fKYTLfqf4e62dUFof+XYG8nzaWcHLzoPO3NFmIV6NXLLhn
CRK3mqIfkP1IUEs+7gP5/L4UEVfTqzKgXdM0ebrOEt7043wOkeT+u/0HpOFp
4GdGn+uW0LoeGEo3pAQUd1wdvW5ZQplK6dymuOJ/l49XhAb7Fv4fXy3/97hU
FLh5pT7uiphBbsae2fhhapRK1X95+eECUaxznNFqZoVkoR3e2LtpDMbvXdzY
83XhTv3D/AkpE3Kca6yqWiEAc/4L3snz8rBNl9Ol/UADmj4JGaoILJA8cPls
82kacPrckbZ0R0tkbXZMMTTJDHT73tOHTutBuu6X7IYVPCxenHmT+14PzAzL
T0WmECDDsP4uIVgPsMx1Fj+lCdCVH6xfOaMH08KpyVYhePAOMzmfn6sL/ON9
uB4yv33VTGTWxOnDZRG++5c/EqCsnPlSR7E+YHUGX4kp6kAkiddt+qY+mBaz
ceHntSG8+/7dw1P68FIzKlPHHA/zTlnOlV1E2DnEoNehpQuKF8e007N04Myo
MRd/LQEMz3kP151HkPmjx9gpXBdumsdVE3/gQctBarT8BwFyBgdrN28RIHm0
XFOoTRvePC0R9xM0BYXn9OMvvxqCzp7ShoulEeAL8cJzWnpwy8KRReGEHuRP
xwwVDBOAcbHnaLQsmT/pNEiuqXjYsrKzf0Awgh9c9HJH4rVB8uR3pBlkBD+/
8bEE+uIh/3zxBrOIETwwlt+iZccDU2qErzQJgcDrlx7S/tpAabjx8eQGAqql
SbPsHDIPc+gYv2AwAomnNPXaTVqwmCpzBM9sDOnSRyTviePh/hP8S5k5E2Sl
4fpNT54ORYuHP99Ip0FoBrMl/NQU6W7jOSsuaqOml37HX3dTotSIjnvOYaZI
cnqg2a6GA9HdadVLjlBHOFHLxImHe8TkjsQXPvxaSDVdmlsyf4u4H3Fe9P9h
gh7f7Jk4fIYXJVpGO+up0KGkvyHSt1dMUfpXjRXdaCPEdOyO3ksnbdQlmJaW
8pYfJL8JtyS1mKNVYeraEm5BmLwg1cf81ALtNtkebM83RFeCJxPjr6khv6ii
5QeulmhOZmZ+tMgcNtyZ6fwchMC+P3jnFUYTDtFQZViU8cKTJXXfpy1YULD1
KnL5KQjBL3ONj93GQoQm993UHvL1cjckvMqx8Mlr00Seih9afxg/e6yAA5Pu
kO7oGW4QnOAkcpN55uXrm/5WbLzAPiGc9o2Ig4ffK6/1dXKB/cpw6YY8Dphc
6dSqseQ4f0mY8noBluyJOk27j8SAit6X69R3TdC2r8DvY5KE2izLXSPu/3m+
Yn9igiSAXCjXP0ULlB4RGtTvYOBbD9Nxv01yeWpZyUGiOFCZUV13tNeCrqZt
s6MvMXDp2PNG9ruaINOp+jKxXwiKXWaMEtS1YPO0cp4IkRvClwS1Wzm14QWv
amJqCx/sTP8wZrqqBbKiv36fyhaAmgkqhkcq5Ppef4saCBSCsUvZy0feacPy
p5nX6icEofW4t1LMuhY8w9vyYGKFITO49+aXd1qgnmppZH9WDA439m2kiWpD
s8ocOi8lDBsFmHwRI224WVZfVp8tBdf20wmxxqkDljZFXdNcGjKbYnP7slTg
Q/Xp6goOWWiSmdrjtVWHMO6FsIxRaei2ZHDCkfv7s53NkNe2FFxPT2i54o0D
9qBuy//Zr/sgR1OiDxsOMK+GEx840gObY25UCZk/O3JOBZvMsgB9tX9nQQ8W
5IXwCrivjJB65f5O6QcctL7QPrd8nglWBA9+rSRi4cGmquusEjuE0YLulytY
aKzoKJEZZoRCva2GDH0caK0fvbJ3ihVou1L730bhwBunMitczgFVDNY989M4
WOe6XtTCygUcSYFUH8l+1rBf1n8mmwZKlF1+40SxZN5W2nQ6zgoN36OClQQ1
QIhzkO7dMA1s2V5ZwWI1QdZG9E0gOU/zsB1aZ7inAZrWoozu8/Rw/HOZL92U
OqxeS1klBvwluZ+PUO64ow4kCh+JGeZ50sWAWcLXYSVItWWTZ+2ng4dhS/Oz
PMrwlp76mGxlNzEh+M3DDlCE5DzeJY2rbOgIz8PcIQVu4Ghsnnz1hh31N7Qw
fzLihU9WNxpLZbmQdcZh1qBeXog4mTbsbsCHHFPxD6cTuEDVJ93Kpp8bQePn
puFGbqh4/+vRvYN8SPlXUtGNal64sBIba2/Ag0SveOINFnkhmeFOsaoVN7JV
6PCusmUn33/zTuJdXsRtissJVOCBj47Sk/JnuZDp9tI9rkFOSBLbjLh2lQd9
03UerfXihMyet6c/ETlRAkOxDpUkB8S+39FOquNH2Y8NFs6NscB3RRlKfCAn
an44kvK8hwFsDXI7clN4kc+Q0aTtSzY4YC9IM/GbEz1Dfq/aH7FA+4yzO6sk
D0o8TxBTqmeCu4+UJ/Ls2VEb15RNUQEzeBUXOd48wY86cibE4/M5oLfw3UtT
TTbE3UT5kJhOB6GH+HINnQVRQlPlw2IZbjBPL04hGPOhHuLrq5z5jPAyuHC0
8acYyuKiirTJooRSSj3NO0ICSH4unCGCkwb8qg8d4QoVQO7Ev2JfExngIzZI
IOSbMOqRjTw5b8EKglVWSyqTgsj/cv4aYxstBMSVVU3dFEIL8fs12CYYgSpo
ena2RhB1nfhp7/ueHVo3tUsexTAj53ajsUIVxv/w7b/vf4scY7TilgXQINYu
7kEQJ5yekoo/KiOMSD4G55/FccKKrOyfkHJmxErz/PFpJ2oI9/wzfeCAAJK6
9nPirYoAYL4fbKHnF0Ck0j4Ctz0ftMwcrb/ozIViLe34L5C9TvpTWGDFCw50
P/NGoK+VFPBmDhN6O9nRCysN+gMPpCE2Ta8o+RkrkklhUBU/JwPe5dETrsZc
6OvrJ/KscnJgts1g3F3IiZZfZOr01cjAYtVuT3oWJ/p7IGd4q1ca/j6qn6Nx
oUVqKE87fkEaEp6+9RXqpkLLAfrJNnkyIDb1YtrMjAE1aDdTGT6TgeCJ578u
32RAOr3Ub1+wyMET5eKF99a0CAe/Q47kysF81XsHX0VqhLxEpg5UK8Dnuwja
dWjR8+nwn2rv5EE47/x8kA0L6oj51sGxTxG6ZYZTHSIY0U1vu0ETOwVQ2zLc
fGVFj1w/lmvmBChCsDdF4L5jHEiE2YX3e4s8TJ9kVW63pkA6yL884YsSsAS1
Hyl6yIIG+nXo3j6Uh6tPdOSN+NhQfqidu+8lBdiP/Szbw8eDqq7Zi91wUQKH
HaWws2OcKFvk+/Mbaoqg5T67uR3NjvxW1Y30b8qBzfmNaYsmZnTzbnvK9yg5
WBW+t9OxToVILpjlM8OKsLik67ZN2iBOyVLV/NJThHaDAUs2SQbEay8y3XBN
GcK+P/CguLtLvLZFo2u1oAjP7K5nxF2nQ1f973lLXleCaJFGwZUUZqRdbdun
Fa8ELW90PLgfcKDtFebov8myEBr8zu62DSdKQvzHjrKoQvr5xnAaCQ40EMlH
NcmjBElGq40FdGxo8scZUdtdZRisuNh7XYgD6e1jnb5Ibk90Exd+SJQLyesy
lImpKkHAoTlv7QkOtPBO45yZnjLIblAtS0Yzo/uxPXlEX2V4Yvz1zlQvB8ox
xvjfkFOBCpuBIx+CeVAnNtVvUF4FRF1A4WrpDnHBz8Y1MpQZ/paVmYL7MpHP
NWTyx/7/fB+y8a+vJZV8/GG2uE1MZ/xYXE5DByUmzwWODqwR5c8rzW6oUEC5
YnmKfdIXoq3h2BkhoR2S4ePL1EoZa6Sg9evZKcOUoP8iOOZLJzn+BnZfdTek
BPeXkxI/3BZJp2u1C6+k0/zD3Txwwe1r0tEzq6RTmgYvRrk54H5iTd6JwxSQ
oUOT8XGMEySYHmD3JW6QnrZ86YckblhzE+0xaaX4x1vY//Wx//+hzgmVCby4
UsUl0tmTiZxbo3yAF6yVMnZaJZlYHvvW7S8JBqyp42JM8rBhyuL1oEUP+my4
pBIT+VFgG8lXXdQARKoVz2q940exxd3+G0kGsPf1c0jbOD8qf7uWaUzm4aTb
oZzOvgLoDjHr78EUIxAJ7U4wLVEHajffSz99jMDG6hTPNiUW8tLNHp2kNIbI
A+jDPVl1uExd6u5haAkPP2AOzEgqgpvnR+tEc0tgpXfWPPhUFUQOTrVRClrC
wLySG/c+lf/2DQll+MrxIMqCwxJOKVYT2zuUIDkj555Vzz/+0aoAuvGCajcq
LMFaapXL0U4axEzsHIVfWMJ9E6Ey9yNS0L9D0Iz69E/5fFnwWjhV4OdF9qG+
LsqxNUXA9ynca6VXhHs+B3UlLdTh7Gg38+w3eWDV/9ArT4WHy85T7CXpSnDP
ccF2bD/+n/tT+Pc++S/8JSnkIfhoG2hTUasLAyZrd9KqLVELzS7nlLEFoF1K
vPdlBAdovlE5JOuD/snZd/I/Lf83/nKZQ/nnntsMKSbIdQ+bfK6ZE4kvqpo/
P2WJWjslwgY5zcHjVe/q5WZx5DI/LWdKMofrHJmn0u+ZIFTd9sUrlgkd/FLY
x/bVCLovGqBiGTxQNmSUpLoYg8Kt5MUADS3wmrOX/cttDBK5Trea2vFw4NJt
rG2cMTiKShSsVBAAD9jeDFVjEEnownBFEcDdUGhWnckY3oi8wMtoEeCEh9yn
cHJ98SLepuX0BPCcPBzjPGMMoSn9aY5teDh36o3qt0xjsne27Yk34OGiylO+
8A/G8PnL0vd9GdoQJVurldpgDFF5N1RLzQnwGeMf3XDHGLyfbpl3mBCAh3Ta
uyPXBCS5ot8lCOpA0uyLkjo9E6jv059Ou0cAccuvpytpTMAw3nzJ0pQANzyG
iK7TxnCX3nA+n14HxOj2DXW1GoN7OI1unh4eJg8VUByJMoa1FKNhunFt+KLy
5xi7pwno4oNyEza1YUBBJVfL0QTsGX79GmzGwx1/P9WcEGPA/6XlzmXQhsC9
08Klgibgbcp/WMUED8Xlzz2ak4xBPcEmqDdIG2g9iCsCYiZwcoIkqfpEGzC3
XEYke01gfw7lIA+HFjhTHef0vG0CAcpKfFNLWvDI1VOm3N0Eurrd60zOaINh
5plz3gdN0KMlm+OMqxzIgpVWnDKeG0Lvpycv52LBWaToIGmIB5Kj/QaPa2Dh
WLbLi7y3fNA1/fZQPRMWRFld50pw0nDp8djwLFELBtxkHfMeYoBJ0f1xVawW
2LSlvLXqloQrjMvqKvpa4JLepZh1WwrUXH6JLWRrwtL2W6tvoVLAyORitDim
BRiVhBW9B5Igw0897l6vCVz6Xo1hLlKwdaPqE42kJjgHcM7q7crAl6uKTd7H
NEFvNCFcsFAaNG3PpcqYaQKd8Tn+k9ekgHm88nh9KJnvFfMYWESlwTD0cYHt
ogY4C+Dy3CJlwNYr/OmHVxpg+tzBRZAgA62qxTtuyhqw2GHrIouThyrNhiA1
Jg24K2hTdfmtLPwS3HDMNtSA/JCQ4S0lct5vszQR6deEP7V6x+TeyINU2IV2
6WUt2H85AzWJykH21uOOORMt4O3pWDY2l4WxX6UXsyc0ARsldfQTOe+r3+Ta
sX9Ffh7lVskMZC7YEZGWlDHQgsOTQmK9wRIQ3K3wp2NPE04/MTv0/QofpCsc
SR15pg07s64npnMkQN6prDXmsDZY9EhKbDRJwRrDvvnpGVXgkOwqdoqWBKvA
XKa+C6oQ5P/JYS1OBlR7ae18fqn+z/7c5wx8pKABrqsrMahC38/rgnMiUqAY
f3bgjpky9LdnFOaLSULcogMlc7ky5DnsXmT7Kwk9hRKajpoqwEE4vvXphTS8
TtyWLwhRA6nIRYkccv/HfnmHk4hQhew3zhsv7stAT+ezBytdasC3Vr33U1sS
vJMVVQoKVQB+aT64siUNepTLGyOn1UFvKMRI5I0MMFzH5md3q4NB7ejr3XFK
uHGvxTi5AgvvQkIDRFOoQZynOYoUgYNFdnibZkIHBR/yu4M0ceDn8Tf0RFwf
6UmNZJr0Exw8EebMWs9aIn1M1erPpMIBl0jeOGl4k8TkZn3I+yUWomNelz1n
2iOdeCBlXKlN9rNBWt/XdfMkzqGpV7kWWFC9N91whmKDlDv6vqU2UAMUE6jH
Zhx2ScXo9sOkXzgwfHxiJWOGGoQeQMchFQ0Yj77/SWB9gdTOELTD2IUDvpuB
gzradCCFxD6KfsZBLaeuHeEkDWyPlL4xfqkBMh8zpwPk90jNjxcfHaLWBObe
Wj21xxRg2R49XnFFA9JwDbqzo2skIeohZx9aDRiqKhRJTF8nEfh0xp/exMHk
VftX5ZxbpNiJDgslc20Qv9PX9OXXHum5+cL1OgUtSNq0rxLDUYLqwdt075I0
oekMzBno9JM4vbte6+dpAvJcHmYtWiCZBHTiDZQ0YaTltTPhJ5kXnvkvi09q
gKzVaNXB4TXSy1TQ16nWBFdej7QLGkukE8OrH2/HaMHJu1JyYQqzpB6lG5qT
ZZqwf+yIE4/REmm2PqY8lEcLKKU8v92NoYTh9Z8LTz+oQ89GfGi6Jw2c1Flf
0fJSh9yYhgelhiygvdOSOuRMns92TjsaqfTg5dLlzyCiBW9KnHrHyqjhESWe
uG9TE35yihhO3FklYf0duPdLqwNVhEhFBscGidFm/UldkTowOEySphWmSSQK
nT9742rwWtlds7l2nmRVyr0kH6cK9r6Hbk1SLpE+S/Qltv5SB7FX163XW5dI
9ccbhGNPqEFvr7Je+fZPks7VVpHZWhVwTf1zltlrg/S4lm03dVQFhK6IPl4Z
/UukoerT5BJVBdlm3nmV/D+kPyTL86xDynB8xPf0tfI90toLonqhryroPFjN
PR25TTr1XYrXhVEFxCoZtE98XSa1Zr/+PUGeT9RFTq/HSZ+IGT9/7nEcV4G8
p9eVNTSaSC6Iev+qsgrMd1jP2KrGk7IZR5vaDqvC3UQ3NdtLI8QXlhvGj6TU
Ie6Q7oss6yaiuWqJJ9MFNRjqCJcOO9ZFKike6q2wVweOjGuzS63jxN4Dn+81
K6pBc4mtzU4VNRKyNstr26cO9jeoX819GiTWPfHea3FUBb/hpp4FgS1i4hud
3dHjalCVWs5IcW2JyLfpM79vQxVeYu4GDlD+Jpl8uxSEBSXQpB03W5eeJRX/
UFOMGFKE/hcHOvOsV0kVaZ/psXFKUDfxsSB6rZZ0t2Za8OZlRbg+4VZ73/oR
qeSbYNrRBCUwN5eMoOwbJ26W2buasSpAfbpUc3lzL5FW2brr2xF5yLrret7n
ojBiZmcMcHTkgY7vBy4Wh0qgbSOqSS8NIQge2F9gYieOWk5r5FzQ54PSwVHq
yQJRlG8S2aL/mgeYp8IfUueIoJKqxU2nq/xQ4JFK/HVLAgnhI45Ov+CCNEXq
bQ4OcWR9U/X3dQ1uGDdre+6GF0cYjXZ+tqPsELSwtHEwUQhdPxbu+P2cADAo
P2p6riaKxA52b187JQwtDOV4qkMiaIrbdTHkliC8Hr7mJJsghHS6vBcWgoXh
4qN1bMILMXSMzi2gLlkQalIYDmjLSKBye24JAzkBMNJJ2L5RKIWKr1wTO7bD
B0U/vtfpLGGQnn7XyA9hAQiM5ksQZsUgj9uVIQtlAuCL8cNnFAgiCvvX6N6S
IFTu2VYa1gmg3OmVo7/XROAHNR97tLIoyqRg8btSiYHB6DWh35eEkEeq3QS9
qQSZC86mRzMLosvv1ke3acThx0b6V1KmMNI2Wk/RpxMDirmgOr8wUfSAwiNi
T0MCSHnSIwsLwuhowi3usrJ/9mEHyX/9XFL2wLWkX9worPaCL4+hLCw3UB1l
Ps+NJEPuy2wYycCZH5W1rZX8qBS7F1xZLw9Bdq9e9tnxo61N6w2/aVmoSWeY
xvTyosrU23QslrJwhDvoxrsRHmTtwjVvmyQHSi4Xcl+OkH39Z9eImZ88lJx6
Zoxr5UNjSY+UXgzJgbgxRd97HV4U7taAr+6XB59ft32f7nKi1/61WflEBZB8
y8v24xUfelWUhWgdFOFLrSxrYDwfCvTe+c0eqACPKufLamR2iMk1ZuY+Q/Kw
XRpRs9eyQAxT+N6NyaaCsOq0yewxaqT/LEvsNtmv7pb0bjfFUiHv3ZciD9xo
YJ+B22vNSHoksmYhcfoyFdi8zMjtPEOLZHnKnRNj6eBruHXXTM8esXPS9Mk3
TXIey4rz4cJvkCZcT+Weu8UKm9ONKkGsG0TtfR8rtXXW/9eXgOrf/v1fz2CB
W1+OL0UIb/x7nLnz7UL9qUXSNvvxl/nz7HDqz1lCNNMGSSr0vWnhDj1Qr5QG
elPSgm6SvuxqNw384ugw8fTfJuX2e4ZuHGGGmuVFYyZfSpjxZH1xR5oBygaU
69Z+rZF4V+sW7ZXZweeH7fVkGXrIwdc0JQTRw/P+uM45cUpouU351CGTCgTK
2L3CWqiBNZ6RYf8XZti7TPm3TY8WZrxn5ZnOMsJvzpHJpv2sUO41wlT6ghGq
09xTt7YZoDVJJ6WEjh1iyiUcEk05YNzks89heRqQulUb9f0zE9APHGNwLtwh
vS0wTinB0oB5k2G2NicFuJ1htqf+vUsyNxj2Maqggi86wUIT5+kh8nCHaNrS
Gun9bKumZvDmf/rvX/88k/O+hTlyj1QRPBF4C62SdNVrX1HJ68PLFD58iCof
4r3t9jNq7B//InPohtoTw1PPLUC42t+PQ1gN1K5IeZ4ItgSfkIPbCa4q0L9a
63KF7Ie5DjPJx0KVQemkddlSoSLE0m0nX53GQ2/wOSQ9IAttnCyHjrr+//9r
SlrJkwPpY1rmfZnawJhvpB9bLguX5fWJfDR4UM1MS7/yiMyDn5UDGMl+8yho
uvOhmyw4Ghj0HGrEw7rK33XrNjkQ+XXxzAMFAixoVp39rScHssk7Id8v42GX
+fCV8GZ5UN9nkvb6+f/sf5QwmPRHFoZqKChLhAlQvcjWnrEgB+1vZ1PmVwnQ
1tjs9+6KHFzycPjNmkwAaZobidP35IEOy3ch9RYB1B4OJ6ZtyMF3H9bV1gda
kE1NVBZ7LQdnmfv1hHm04cNS0YHSd7Iwn2XQO9apBWWGGt6nsZKQrSPuFXoc
D0LMJjcy6KTg1YFwzZVobeDjn6l/lSEFpQx8FM9xeNiW1qHIqcXA2b9Hi3Vr
tYHBXVncJFkSQh7ZONxf0Ab7lZ9bb0kSoB/74XqUGR48PGljNzok4HxW/BWL
D9qg/u5YTasVI9DLyx3pGdUC26zx5I5Walj6EPW8pEwLtL0PxnspsALjTZE6
a1EtiNorzebhZwHLFakUo0QtuIbGMhTb2MGAc3rcpVgTahLb3Ky0OOCY+9JN
eyFNoD1ElGBl4QGvlT8aT8k+QJV1f45ujBNkmCnfyzRqAEPvFKvTGy6oCYqI
4MdrwFzmq7Vme244zBY3xH1ZExw2rCrmQjnBOXs1btNfE9jGt5/SOPOBfIce
cy6Zt5Js8jZHSnigTc6CJYLMN8KGV9J1cvlB4kUJ9iKbJgyNvTIdneSHo830
F5NCNUFl8Jzzez9e2C2oS2uX0gT6KJFuhW4+WJzIzDlzRAPaVZkaZT7yQMwp
2VuntTVAQEvgHWcjLxgvz8i+6sCB5T3c1RJy/2Q0Gmvcr9MGY23u8SgMO1Qk
0a+fP0sAxUG6I79Z+KAm+xhBbooACmLKWQ35XNBS0ZIR0kGAp/O59zOK1kjz
do0Stzd1wPMVI6VA4RjJlNfmLR2lBrAn2sxJzo8R2Xk3BNv8VCB4+1mBS9Qm
sW1ZeyB1vwoY/ymXVRLcJG5X9I4zOqtCbZ2Ts+BnamTyGWFcC1Qh02KLQfbL
KhHn+OSANbsyNBY2t8Z0rxIl9tedVBJRggNsMrfHpYeIre08Xyt+K4H1nv2V
sOU24vzHv0UX3NVB/pPdtWmoIeKgnJoUgAV1Nr0JTEw7UdnqdAyXEg4STbMC
LEc2iP4JVST/eCxU3F/0PrM3TZSp+rjl7YAF33AWbFXtIDFC5GREqyYWAovK
Ax63saL28Wy7Lg1VGNhinLWjYEIfHx0tfRNL5r9to6zr3LQIe/NEYNtlFShR
dEz43keNKHvLLI8HKAPjxEHrfXqUqEYojH8dqwLJgnQjgbX8SO66IT5AEgO1
9tG7uq/4Ee7DZkmhqgTcU3ZwlnLiRUfYV68TxCXg7r5AuUWSMLI2HHtAsSIN
X00qTk0ISqHMeYVLol0iwDcWoGs1i0Get9+YWTEJw2u2A7i/GAnUX8iVU+X2
z76GQ7z/5o800kKPyxI7UmCCdwvFVPCOH6dUT8eFjKpuZX8Oo/nP+7p/y9v7
xzymDRFDfrlS4043aUHvQ5ZN/TtRFMpHxymSqgjVyeOH+4X40P2KZrkVGyWg
ZvrJkazOiwqueWoPayrD1gWbZwdYuNEN9pOhFNbKkGm5/nR7fom4OOsx5XlZ
Ae79ZOLpWVkhPS6v/ZnqyAG17G+TXwvPkVDJhwfdFdxQUbBI3//wL+n0uul+
zGk+ILSPPzzbvEI6/lWES8iKH96ZaLLmndki7Yp9D6uv4IGcVN8fBW2UUD26
9zC3ixtiVpdvcROWSWJi8fm5Mrwgdks+UTj7NymqLYajEMMGtcMx09uftkkR
5/ZRBBA4oFSGzuX3qAXE3N0MIAqrgLtUn68lhSXMT12/ou6mCgEGAnmk8xbw
WlBrgF1IFcrmKu/xG1mAk+oeW2y8GvyacwiaJ1iApYl03PsqFVCPEyxQorAA
6+a/Zd9xKnDpbNJPnnMWoKdTEPd9TxVek+i51NItgNHX3OvqujJsfHWQTa6x
hCGH4uMaZB84qCDYP15Bzi9nBkKNy1VAd2Ax7MzQP/kpWBUGfc9jFFMtIFzC
7a3EM3Uov6QrdO+yJdwx/jjkpKsKFdil5r9aRjB7WGO95qQAYi+XqbFcRTA9
6HZh6A8/WmrrwgWuI9gvIRUT8UcIJcv4pvt7GEEYv/8prBE/ej/SYVMubwRX
xiZrqXmE0E63Nw5OmcK52BQSMYcTXbnK/We41BweCvuV9vWwo2we2qdbBebA
bJG7t/mIGe3M7e47r24B+CkTl6Oj/Ejt28m0AX4LIDTNTVtYc6O/6er2z5fN
4dcvntF6UU4knfcp0bDSHBgde70Xr3Cj8LxU96A6c+B6LFIR+ZITNb2ciS8y
twA2heNUhBPNRDtS334FOWPgthiUeZbLi2oKu641vDcCuys+cW0H+dG1jZtn
N0eN4Fl8rCbzDLl93enPnowZQVAD5cmyLQEUHj7w3vKQMbR9WArh3hFEz672
P/twnHy8/TY1qZ4b+e/zEfVkMgMLCksGnRJ29DF7eyjLxQz2BMYG065wIJat
Za3HJDOI0O97gZwEUMTkidsl58zgpLVTcp8LKyrswQdXl5mBq/wFCrYFbnT8
82G9kw/NwPpmz2BbByeqaanjqj9sBsth2KJPA9xI8G5c9iMKcyhq+VE/Wc2J
qOuj/VY7zGAurp3/3HEu5HTCUjh62Qza6qj9hvexI2pdRnJmNQfr8aDbswYc
aEvdp/CNlRlw+dZKuchyIWytda8wjTkI7twnfjVkQKw8vvb7T5vAzfSq4AMc
vOjJaY3PIrYmQLlM4Am/J4hQjsH5i74mYK6oEhhxih91COWrNayZwJkqqrC4
XCEUZqBFd7HWBFacNLge3RVAf5pC9jwoTcHOoXk15x4f4v9zElfyyASenPAz
lDomjN4/P5ae+cEEcJLpQTf+8qG2JApBtl0TuNyD27fxSAB9uBFKnPxkCj5a
YWlWpkKo1fMo7+4FU2gfvMEe2MiPPOat/jRrmULwnb+1jQX8aODL07UBF1M4
+bz5HG6VBzkWN+oVNpiA7texuDV9IWQV0/uEtcEYOB+zhCdEsyJOzTT9xkhj
2HdiSzCjhwXdKJOh871qDCUM0lkv3DiQj37sVP8XY3jbuxynsMONcp2qI44+
MobFyY2d64940FeCXV1ChzHMnW7/e9pdAPUeWPJwyDGG3qxgO8OXfEjmVZD0
rK8xLCf9jFte5Efnm+fYKWaM4eiEi3uAHR8izQel8nGbwPBL5d4ZdQFk6HFk
Pm/CAh1YSbxnvmIGEzb8n0aoLVFESBU6lGkBCxudOhdwIijW6g1ux9cMPoUf
XotekER/TF/T890zh0/zfYEisaaIVrMpU+2nCOLbDRC/wqSNeIffE9WfUKCa
bLFXdPomqEvP46F0AzVaZ7uzUvfCAqUlboq4HRRDpu5fVkZzTGBCkeeuSYAu
9DCIMKR3GkM8ZBF+megCE+7R5fP5xnC2/1YHGtQBgp+BhECKCVzhuhln/xkP
GkVWSeJ3TcDjpbdkqQsefK6Kn8R+I48ndccR1yICrNw/X9k2RB4fD3ZP67MR
QOpRN2aCyxRCIsdtsh7i4cJ8mC3DOnm8pXBP8XPgYTrGPtQxwBQO9PzhPfhH
CzKH3YzHZEyBkocjy91HG/L7guqc8abQKcO6b4STAFM8fKmqm6YwQFF66MBH
Alj0frDtjTeFupd5eYYJBIhOqOYTIY8P56vfe3wDCDDbmrzvpZQidLk4Rntq
YwHL7rIRzqEMfY9S4qyFNSE06kTkl7NK0PmE4snHN5rgSq/w7NhLRdjKLcz/
LK0JujHUNGU6KnBgoPzj8w5NQAoZaWwRivCxa73aNksDzgQTx7wTFMHy7/ld
hxRNCGJVe8tGznM0t1JuGFNqQczjjaMHBFVA8P2ghqqlFtwheQm9a1OAQZra
FZu3eDhVQ6jaJ6MGH+/pD1yT04EfWSlM3zNlYPFYPHPGDW1g2zgzns4mC37V
MU+GhLQh8r5o1tKMNPR7vtItwmnDdOsd8R92MmSun6xz1iPA0tZCNY2/NIic
jI1RrSHz8kU7koe0FOQ18xpgevCgab/4wDpeGiSfCFXKG+Fh7Kf1isYJGciT
/0y2fTwIS0qdUvaQAKYeF8frSAeuNLzdKdmPgbm1FiHrgwQ4WPujuoBdEiQf
KOwxk/2GZSD/aEWaJFRp8EfZ3SPARl7Ahi8lBuR/z6SofMDDUuoWKdtFDE74
hVo4OhNAwou4PqYnAQ8r5YgUWHJ5/P53Avcl4JT1hQ8JVQQwyA8xpvotBn8D
GSvCuvFg7eGi8Ok1Bv7ouLS+5NWBwgvf/J7FCwG6REzqI7dnyPOdyufXItBx
Oe3FQCYevOVupR62FYEXHAUOQvIE8PdpMTq+KQRir8L86y3wUCVTE3bkrjDI
jn4epL+sA52yVke5TwhCQP7skbd5BLjtnyiS+JYfcs6S1h1P4cFNv6QssUUE
eGYuaaiMaAPr+wth34NFoH4x6FJpLwGsKy5xEqKF4Pz2bS4aK7JfQaBG9CI/
DD28u9HGQ4BKrZNXn9MKgNGNo1lcc9pQupOTbd6OAS7qhicrBQTgKOWi4lyT
gkq+HsvoeB3gcOaO8GcRh1On5rA3yrQhoPvUwPIHMdB7Pvjw8gwBcmJP2JYe
EoOxSTNebLYO3Lz8lCmsSAjSs1t1guh0ION8/d6iiACc8nZzuJGhAzFFWvdM
xgSA6hN/neobPJiy/3oqGcQPdBXyn0hxBNDv7FAVzOSBA7W53r1iBKAPgzdP
nnKBV2Pj5Fo/HlrDWxQVx7jg8ZvfG5n2BNi10a+52YABi9xvVx1SdOGYoCG/
0bYkVCvKURbK68CTFaNwt15pyLphc9p6kQBndzCttFqi4H3/rD+fsQ7gsyjS
iwh8kJnMr9fdTPa/HI+ZCk8MDLU7SfH26UDZvne5pBkp+KIc+UuEXwdW1cM8
XMukYT+LxPOwaAIMzY7IRBXLgMmDF55DpeT44rT/le0xWdhv/HWjpk4HxDiK
10ZaZOB8SJ9TiJEOnLqZMRg5KwsnsHu0GgY68MmkM+KdhAxkbQpeW2jVgaXV
8YKKL3Kg1deT00weD8TmuKuVhXLgxDJyedRVFwi0TnLyKhiQOOPYkH1GB3K/
VTUcN5IE+tOL993v6sBGxVhFxjkpoOofSp6sJoDWzbrHhCZpONT2xvK8J3k+
E0t4E/ukQKxoYCItTRcC3L8YxutKQ7z/PV16AV3QeSbztPi3JIjPxTZWYnQh
zOhSiJqQFIzHM2YUlelAlzo2r+yDJMRcEmhBz3WhyvJIFMUzKdCU1j3M7agP
mgmU4iyMkkCxZSP7IVcPmKyiFI8oSsLdH49xSYJ6EMHh/Bz3Vxy6ypoaLxvq
QZwg3Qs+egzk1Pt3yDPogb8eo5xTlzi0pa2eZffRhdyX8f01+hIQlfSIwfOT
LgQqPo5c7GIBDVaOlmN0ZB9fq/Sf6mCAa++STmfd0Yba6pwjz3C0cKuBLT4T
rw2fI5oo9vlSQuXF4z8dXbQh/ZZGxmkReohyf6U6HaMFN9rFtUiOuyRepcRz
FW+1gFHt6J8mZm7QquayG/yjCe6MisLzDwWAkS6o6o6aBqzIjtnsl6ODqbOz
LBfl8YDH7j/NF0cDB0dXQ6gsdECSOiSXQm2JSDPSs/fVVQU2yhw9jfI7ST0/
aCq/a+KgjDdkD285TAxZuDBLBVjws/p1s4x2mdje8KzcMh8Hrvcclbw0/xBt
f8ez91nhYPx8jUhxzHei2gjV+xyyP3eu9v52c1khhh+yP9nAjYObWHsPf/FJ
oiXUtt3vIp9/4HPx6C4d4gnZwI+l4GC2y1VabmKRWKICo2fzsVCFe/a3RpsS
rVjvCyjC4oDV8dt1Q8NtItvC07t7m1gwkk15k8W+TiTSam5kZqqDMvMPV5mV
JSLDkFv5Bo86MCgncAW9oEcXuE2nXI6rAs8eX09VNQXi67Oy+y1B9pFzjz5/
fCCANlkqzWPnMGBwwuL24AEetLIQ7XpsAwNuNVveeve5UOEd9zyvIvI4064f
nn3PjWSZBZ4vjkvArcRhgy4ML/o1cOgW1kcKkmMNfH/ZcCGWjENxY0/J81xk
my69ghcl6SbJOeliQLUTl4FP4EGmSXl1iV7ScCGqN/iZLh8y/13txKkkCbFM
Pv08F8jcnu1vueUuBYc/fLrFc0sEmZKsy/icpCC/MEtOdA6DLpJ8MBYaYuDh
81bzcYMkOkmgXEuylgDaE0EuY0gSffl7lisoUwSULn6o/zkoieafs2y+LhKD
vQibsrJz0mjOz36meVscglj2saxaSyEa1vpPlT8EQfrTtebr2xJI45BABoOk
CDy+c9+34JQEGkNxPnJhEtAs17POGCaGVNr38ZvTYCBMa8ny4DcMunoSe5LE
Jwn+U/0k+k1etMslwf9pkBLYr++3/g7cSHE58PXxl5TgRlWew3WbG3ENHuTf
O79BCuS5znEMz4tMHbI+3vryz/oCcv9b0E4yaKkskar+tvg51TIjXuNuv0Hc
HukgvIzYNBRBTe05X9///uf3MRIi//q2sKQ6XfAlIdTSQC9sWLpBst6099dt
4kc0mZ0dnVEbJAv9I/4970RQ1UANhWLvP++HA/jRmSs038Q6F0n4mUwbn1J+
JAAYx96LFGDYQgpdsxRCf5PKqRYYFeGdl3bU283PJNd350MNUrngtUaZdmxc
HdG/o3NpLI8bvBWtjbhrFknrlQXe7YxcMESw/Rlis0BSuZFiGe3HApfYx3gv
N5iDPcnN9vj2/1mfoI4FEW01Z2dmS4gx8MlvolaHqZGaqjkBSxgkeWX7KarB
geBat4vPEMj5DkR9UhdGj60U0rb8Ecw6THhwHRND71+rBHzXQvBO92Ba83lR
FHlBzf9wPwJp8azDRlxi6KlbWtD4JQQ3X34+yHBBBDFJx82pfkbw05BmMchS
BNn/eux1O8YUrMaevFFtY0dyI7T0l/RMoae6UyFFnQOtMteI8yqbAsvRQhYT
bi7knTgTn1RnCg+/8ATkKXOhZ5jIQqo7plB5SX9aM4QbcQe4N7JNm0KMBPPD
xXxeJNO/mq3YZAqn8xVOXRXnQQP1UaP+z0whMONGbBaGDzWEd3OLvzGF38V5
eGeCABJeG2i4d8QC0p4NKrvY7RI3NZf2CXtZAN/N9+edL6wQa1piZKulLcBB
vDPzMOUG8dMdpaF7LBaQt3AvgXKYEv1X/1IwotHaK98j7S3AGYdtGN+kRvWZ
UyksXBYwwpYaV9VIh6If1+R+WjKHfImF8OyvjGjrysbtKT0LEA39JSUxwoTe
ajMXP6OwBMMVq4fMkVPE/65/g4j8guzWjSyg96g0xRFlDtRxlOf6YLgF4ESS
372a50CGLaMZjTEW8LlcbcfmFw8yeeU0SXhoAScmSx5jBriQ3tnTwhgHCygw
mLO7f5sLVdltcoYsW4AdV671JTceZDbjK/n/uDrzcKijt/+L7Pu+M/Z9mcVO
c5gFZQ+VpLKVki2kbFkqhLRZimRJ9mgjqbktiUgR0WZNhUIKydLv81zX8/yu
6/v981znM2fOfO5zv9+v98xcM7baNnAsmJ4lMiKJik+9PPAj0hqYkx09Igp5
kZws3t6+2RqO93j0h9gLIj3P9SSRu9bwMPTyI51wbvThNjJ2vG4NMdMpWiMs
zMg4zFZhqtQaui93cT+L+kvmaG6bF75kDeNx5W9bf7ChQgFJRbZwa6iuukPu
YOFC8sd6L6iOWsOOGVWXOdISeXarXtXomDVcqXAfpmlvkF0uJv5kvmADXIkP
ptl7/pHTzq6pXNC3ARgYLBqNWSIryI86rGLXf7fK+KURzo72UsSeuIvZQEh8
yusLqWvk5Z3rfgI1NnBqq/qwBpEdHXge82KAxQam7zj035HnQYkH2uZey9rA
g5W4a3fXxBDuwpfffm428O6fqxPLVzYUpvGzhIliAzG6t6obvfhR3pNapw2s
f7wEjwx37GP9z/MAQsi9PPv8kUgbiDwsm30ljhstEkvSbNex+oSKbUWxQqin
U6o2VQtzq6hfY/4SIujjB8Wl21Y20MvMmc32SxARdyi6KJvZwN7Im6u2/lyI
MztgejrPBt7G3Dw4zC+CMtpyTNK8sf0X8tU/PCWMajviRy/628BzJWtaxIoo
2sEn1ijnZAOLq7I9ig7M/7k/xI8yR7JY2ENs4K+pAMv3foH/nP//70v+3+th
Rn9Du8YOt2L3/9+eyHkZZrSkdDFjw8cGjkfNxmtyTJG7Vh+oHZexgaj9/6Tz
tLagG8KPJKcm/vf9sDFWxFPfISltZAOKIXqmMoQf5EOf5s5fnaVDZEWZwLcJ
UeSrcPhkyQ1LqCZo1FikSCH+16M30wstYfERS03jQRy6mLJXg1xvCftyEx/o
3JJFlpLW1d9P0yAzzTBRw0kM8V1yyjPvosHe93yxguJiSM18VJaxlw7hqjyW
K8PiyL5irbeHmw57wtXMopPEEYvYLdyoAQ0+0tQeH2YRQ/sEu/KG+Ghw5M/f
9VeHMH1wb73oIksH0TUfzo0fMmh2IF+My5IOVmoZ8/grIkhBmPLj3yoNCspe
dVdhevN0gmUoWoQO9vgQfFyTKOqdV+jT/kIFiZ2Ur9ku4kibN1ZQIIAGcQG6
fiZ0WdT98vrWU4doUCOoNVvIJYlk8rxY9DToEE9dFONTl0Kxbj7Or9RpcHrp
V+ddPWmUrRH9NdmKBi+eW0d1N4qji2KlLn/6aCA8kF8jTZJGP38ZJ0p10WG0
YcrD01wG8RwZ+tTIRgcv1F+XFCiNYsb/3WhLogOzdmUSk78U2trcPxXlQodU
s12sSU+kkVPSCCt7PB0kP/Z7HQ6RR5elDj2c2Y3p1YzEh5IOWfRB0OtpAgcd
jPXyBiuO/M//Eye70/PowEmV02DKlUXs07EXeyyw569euMxRKo8+TAyd8pGw
hstfhN4Em+GQB3TanjxCh3P6fwWaqxXQY2Hmo6cnsOentpN88uXQeNhOHhZf
OpDrNJqibuOQq/LT1SdtdLj6dFdGPKsCokVorjwPtIYD1bNNvgdkkM2XczIm
I3T4Il+438YQh0rSIl1zpDD9wa/qnrovgxZMGAZadtZwuKAIL1kgh5q/7vw3
ZWoNWdE3Sut8pdCEycihMz/oYDa2sGVdVhE1m3SE0uqtQbXfYZpDXBK9WJIc
Oj9Jh29K93banpJE4xZ4u0vGNvDmsXHhzxRZNO5b/EIz1hrSu32eVnlJoYvq
g1cCV7H6pY1aHMfqpW8o5sq2zxpUkt68i/XA/Vc/KaK9Se2P1ZKtQWF7pKW9
rTw6MjVz/GivNfj0L7vVfpdGxR3oyMcUCvAceLVL8Tx2PgZa2Yw+WsFJRwfy
q/04JC6D+OiKVAj6PL0fKYsil7+JH5+uWAHcI4x/qxZCLisCx8RbrGD2Yvba
80ghdHqW3fuBAQVCzjId6nklhnzqAnCBNhS40K/mzG1sCgsHmFe2jlOA63v1
/s4lA7DAjRrvuk+BflpVA8XEEEL7zkxZPqDAathBNgcsL/g96q5nCFCA9Pqa
6GA3CQoep3HjPSgg+Lbv6ztbAyg1Onz8rBwFxL4MPzAaw/IFafwmuccKCtzD
A9VXDODgqdUlfnUqXL19tNPgjQGcSd8hN7pCgbdOxSTPGGx9NzX1PVFUuMTp
QGY/Q4KWrcy/NPZgft/Te6yJZACZYUdOqOdbgZGEd1Z5vAFYFuOTLdes4Nxt
258TZEOIcdg0P1xpBe4uMJd0jwQmf+bL+jOtoDZndXJU2ADaTp1gezBkBYey
wjX/qRvAK+YEq4h5K1Bq8S4ryjaAXyVafx0yqSApud5yo9MQ0OOvmu0ETZB6
Vb3lQQMeTnrNGN6V0oCsn2UDG3F4ePxx8cOlajUwhWraD148bB8589fbSB3Y
Fl7dsT6Ch/Hbjxndd1WhPN90dnReH+psGqf2SuhAqNrUfdhnDDcyrraYz8sA
9cJa09xhQzg99l1rMlYEyuq+/urJN4ZYu+8WNi4icPOxVoR/nBHoGyhu59qG
g7cHW2pH+kwgTtbkWJizGsS1pdGUpkzA0Z55RItJEfyk2SYyNUzh7S6d7DMa
MmB3csJuCcvPra9/q9ROykJQcXiG47Ap0CRa5tpqJOE9inqU9NAcqE+Yqot2
SoK3QpJ2V5AZNNyyz0T20vBNfrw5ccMUfMPu3mD6IgP3DNgvPJgzg7Bam5q0
ZXFwSSglmWWawhmzVf+gcGm4iyb2Xz9nBo2vTm5xKpUFzyLzWflDZkAvNRen
npSCVJ0G/Tcy5oB/Zv90Sk4KFEu9fD+lmsLX1aSULnFJKD3Tid/3CxtvT5In
BIuCwYjDkX0OZlAoneDILCoOr/0vvl9mNoP2eso74XUJkJe8P2mD5Xf248vb
Sn8Jw5OUwFZDD1PoiOs+d+a9KBilScRvuWoKwc94fWNnRGH/tfmJXT9NINf8
qCG8FYOo+PhMURVzaJqTEr/GLwwfdwa7iGebwMSpMu53umLAL/k5RTPIBF5S
mdMUayVgOvSkvISdOZgb8V830BGBJ1yX39fOmgBeP3ZxfRoHV0QKqo3ssP46
9iVnA8cJuxqyLq18MwbLMy2bWhdZIO6235m5cGOQZARJT5axwfblXdxx0sbA
iLW6vZjCChdotXffvzWG781n+pnudJAvPfqyK7eRACkfhQQeRjQzVvhaZrfp
EsHYS0P80ekGssvxovuma0QQ+pZpN1jNhAJf371+RIsIT76nLyVe40C73L/3
Gh/Ag8C+6Mup2Uvk+99Evfnl8GDPzl1f3f+dfEAx4Ov5+/ogHlKUTcgXR+fv
P+bztlKG16Sz2uE0CVTb6vWjIV8FVs4c13fiEkexU5+ePeRWgSA7htUhE0z3
FrsUbKZU4a1p2o7btpJoYJBW4/VADePc38eO5UoiirHL9+7HynDyq2FfwlZp
NP7ANfssizLwTVb42VhJohSfzZq1FFXwOZXAr/peCukEXwjBTahApJn83e0y
UqjFJ2ut4606aK9b1lUUyyAYbKdU7dEA2WPfCgqFZRD511eJk8aasOOJM9/N
dCn0aFKAN++OFuA+Xdt7qUoR2Xoq4M+rqcMPzvPzTfoyqEviVPWkKDZWrOJ8
fRWHsqgvfxSLakDn1bb1Q+tyiPMtR7TnJQ04Khi45YgaDgWrV2YnZaoC376o
nWF1sihtpGSx7p8KXLhyWsSKXR49ConDM1Sxvme3bbKIkEU+26LO5yuqwaFN
iy61LFm06F0mOVagDuwdvG9ETOTR3RMBf9opapC7lhZL4JdBzrZP2I3DFMHr
1Fh7EEUeXZlZ4IxoUwQPx+Y/NyuVkP0hGY2YVBxQvXPKwp4roiMP8lC6iTSk
1f7akKSroDmh+suTo9KQPzGzMPdFEZW29Zw3xkkAz3pwe/oFRZQwXLXi6KIA
wZxHByrVFZCC4mYN/04FYFNv3vqjCYeKS16wb/NXhCzJ1z7db3DoIM8nxJOi
DAEuSSfjTuFQWdbLxlunlEDp5IqGzA05ZOklP3bouDLYhvj6H11WQDdlG7kM
Lyn9b37mQSvJRz9dcFtmdDIupR6q4UeeFa/pDYFrjJP7n+48nCWIWl93fpp5
tczIFf6WxRMzzhBZMhP35xcBmX/pFZ477pG3Z10dWwoShHam9ZEszTFGqL9y
u/CGAOhEfLO8t0YHoSdX9pBd9aCzS0GCHoHx8Q7pUys+epB0ZsWpWc0Seu60
RhdKyCKS9ZPyvRqW8CHEksTth0N/QvLMJ45Zwljo+bn77LJo7nln/nU7S5hN
WhPx+yGHTMfjuYb4LCE1Q65pgEseWbz4+YlDkAa4nxlrhG/CSFxBijto2RpW
8G/6RI2HyPterr3piLcBjxaRF88fSCAe+fLYzHs2YB+F2xK5TwxpU+N8jv0f
D4eII5VTeevVqTbA698eSbn1m3zVz4M3+IANhI4Ib61L/0uuumo2ce+JDWTd
qjyi8371v/LgNPn+WYZlS6cNiDH+GppF/iQ/CNkb0WVkDf264uKisaKoauhv
QCiWb98LfTl4jCSC9O9dlJH5Rge5n6GUQA0R5Mx/PubcNitQJpjOPQ2UQ093
yXLOZ9Mh67cPIe63KHp9joOTM5YOpjG8gs6mIgjxOsxd8aKDP06LJ0lUDAXu
/Rw6V0qH+eYBgwtmEshpDn3N/0iHnNS00RPl4qiVllcsb0wHR4lxoVfFQugS
X17rGlDhSJPwZpA6DunLXGGpCaRBsejAOrO6NDK8ID6wTKLBxgT9seBFSdSa
Wn0rZJ4GN/7+W3lwThI92XAc8nxGg9KwT1EDBnLITvXWoL8IxmsnzsgSzqkg
y13WQ1xYnn0Wo3vWo1IC9QyqTem0W0Pyh9yZ4NtiiDpKNOvH5ptXJQZ5k6XQ
9TOfjnqxWUOh4vNj+ygKaLvffZWyk9bA1Ec5x0EQRzJPK1L9DloDv1+f2oVX
EiikW6xLookOj59ZxVbmSKFbysSCoxrWgLOLibTXVURcnyKtebH8f11YZcsl
LwW0xmpy+WyHNVAa3b8dV1NAKQcDRXKKreEa5ePCP6IsOnBwd6CHJgW6xVM7
+2JkUe/Scbu3GL9IzJpO6WxIoe3DYTx+/BRIK/OiplqYwiezlcXLBAoUSN/6
q/HMBIJ5Opuo5yng0BsuF95mArph3LkZ0RRAUhSS3z4TmNSzEvgtQ4Urtvg4
/6cmYGMxeMl4gQI7WkQnzcgmcCTJvujKAAUcYalKbMUE9GW3pTsxKODpNzLJ
f9YE9kZtTK/qUCE97ykpasYUBB4LXRL6SYHT8ycHs1NMwdlvXHGrKRVWou/F
PXM0hQSWpyVl9yhAEO5Jwd8wg891fZmkW1Q4zTQYxLhlAqG7j58bw9ZvXZXT
42AxgxbeNN9ZbyrcEhoLbHlvAr8XP5Q8dKRCZDZO/KO+CTRWmEVFtFAhJSvi
u3oXxi/05749Z6mwxCjOY/M1Bdfrd/zkNyiQ2D43NORnBhnf3+3/7EKBq+dF
D+vrm4GZzWFvaTkqdEefJRSwmcAt9urQhJNUINLeXYpexfz4j1sUmyMNdKs3
F/2mzCCHSU1QqZ0K2sNHptOfYzzzSWdjthbjz/p2PbytGSQYyNhf8MDWs9V5
o9ppBhMt3c6c2H4zr6W8v+VkBgpzMspKSRQwXQ/qtvtkCod5qogf4yjwJvv+
VMt+Etzm3X0v3Y2CcbFxy9YnBkC/n/6FS54KDwrta86Xk0D9lR1Tk7YVmNu3
G2+RIcGpvMgW62mM55tEy6r+EsGD3yHrswwFtGUWQJFqANHuPJ28VCo477Uk
d/0yhKknqXMZflT4+QVFv/THxqdcvu9j1YY7a/2egr+NYGfpXsnQWREgNe/U
8tk0BMuXHiW0GzIwNG38J37cBJ74tek764tAyeqi3qaKCZRqbrvNbccDWtVs
HAN7TcEwYofu4y5OUI6+oRlbiZ2/fUnvmX+xwx726tENBxNgu2agGA3cIGut
WdhkaQKBp6dCp5wFwDQVf8X+ogmIiajUCioKwjI6EiYvawKrdz7/Wi0SBKtr
HdbM0qbQmNWRmKMvCPsm1UyPaZlBVaL79KOd/PAjnpt6lBOrd8/Glu+7BUC8
Kv+PQr4pXC8kVc0GCwGfRMyX3MemIHUjeMzARRg++y6l+BqbQUiNx+R1KxHQ
knmS+KPPFM6zNdvufiYI9vINN3SjzKHhztVdomxCcOhG2dTMSzNwNXzneFtP
BBwivTxX9c0hPYXpjIOUCNRw5wo+uIPxZrGMjosgO6Tzzdi5r5uBRIKeFYGM
8ehQuU3jBQvwsujbNneIF/JFTqg0PDKDdNu7dt7cImD7xeZz1TdzeLmPDVcX
JAApOD8bz6tmwKR86Qh3CA9I6FACZXnMYO5v8re5QlH4t+LlnnPRHMRPM5lm
GHNCfGL5Pd4oM7DWEmDtGN5ksPO8PDeobgbd8Vxd+9i3YuvuXsiNwPZf1uZ8
x3WVcUhotV32rDnY6WufWFraCuMxN73jsH79HsRbOSHCAQ+bho+bzZnCXqkx
u83qTcblkoNC8+NmUK2zM2hDjgUSOjKVkrH+sE1Od7Hs22R8l38jwxeD8feu
jopvRBbgf3frjuK8GYgEddW+omwFtkepD2/9NYci8RvpUY+2QvT7bdKfQsyh
8PkLpl+SPLBm8q5wP5YnQls1pNlfM8HOTJ8ynQpzIOMYKdsfc8CK0Y8b69j1
pjsCyk43rzB2kQJP7ftlATTDEecEBx5w6TV0qjXA6qVubkh8+JfRzos6tMkW
YK2WNRWQyw9+iiTdi9HmMAN35W6NCQDNrFMhfrcFyItKTD3ftgU8WZIf/hgw
geSvFWlL86sM5Hd+hMhkAkodymvnsXmxU6I3FqaNQc6GN+H4jn+MRhbP7pD9
JlDndC6NmM0Kn6XFfdV7TSCTVpX/05UZpl7/IfGSTWGm7o7rxOVRxnzNltZ/
AiTwOTzTxtXGjCK9ynIy7xLg/ezBmje962QcR0U4/gYBgg7kTClG/yaL2ub8
XuQmQeZyj18B+y+y/MSm7BkPInhrcv+I4PtKfjtyEhfZToT0YKkgkWNr5Bi+
NJJ2CREIa934HVmr5N3v/sobCxHh7MWjO3nusyGhVL7nuRQDKIve5qGI2FBe
gd3sVikSqBrmvPA7yYzq/N4k728igpqUXyZFggn5+OG7HmeTANm7kM99ZkcX
5Am7T+wlAj8GOtxJW9FOe5Pp/TgixLnULZ6OZUacpLqKCQMSeD+VOt1asRUt
TvzhrX1MgrQ3Ho++h66TrXIGnnYokeCte8HQvy5mxNGg2bUvBg8ZRTtOuuv+
I396wxX7nh0P17b+c+vavxXNe+l15XzTh4WdzPzbOZnQidjFXwpn9SFPbt9D
r8NM6L2dZfUAuz4k3royVojjRnxakf6nYvShY2b3mTyMi3rrCbmqRvpA/2L0
WFObHeUf/iaenqEP1iW3SjOKOFBC7t3fnzn14ahuaaX90lbU+PDBgbQSPdCv
dahT/iCGJLnPX+/A+HXpaOdUV58kaqGzeB+UU4IPLsMb25ol0Ifcwwlcc5rA
8nJ7RZiENObDttVEfn2I8L5rpDohh+bb8+p0vinAYOvr3lfNysj+ifeRYBFJ
IL47FfhVShnZyfIILV+UBt1H0z9DpZWRqWTQtptvZOGNzkrx/ClZVP+1PeqB
vApkRmnlvrorjxKoL1ffhavAktQVBU0nOTR3Us1LIF0JrFq7qjTeyyD/N6EJ
LObKYD+fdLaDTwlx7Lp/g/uJItzt7IuSdVNGEYanQ/AZKqBrn32AMaCCArqD
+dx0lEDV5YFn7X4lFFPsNuS3XRniZnNbFuOVUaJwOnPsdUV4z7ynPGxIEbHa
iZNNcpSAoX/qMCnJGtK6WH5ICOtDhXJ9icJza5D/d+ixG5s+SGuVSCzXIjjr
PG5q8wWHFuILo1S+InC4wkS/uweHSllGR66lWMLJ7GeORCwH3bs3P+ltbQPe
B9bq3lhKoFEH+D4x/L/86ySCWE7GCN2usAH3QV6OnpwX5IZGjXqz5zYgM36R
sqN/ktysrZZlchzjX89ssa3Fr/6bfxmXjH8a/s22gfz3Ar/LAmfJ87nXnuSu
W8Lq/e6OGxhfccsnC97+bQnFo7a9sSvyqEFDR1HawgqsCiceS6vJoDs7Pfpe
llnB1pmQHTEmskg9rkNrW6wV8EyzFvzLk0Ya+vt7nzdbwRX5z/0su6WRVC39
igVYQrZ0wScld3mUb8KUe0PWCj64Xf00l6qMiDJbOGcOWIF2XJsxkaqAMvev
09eNraA0fkND2A2H4hZafF+lWYGp9dw2LyxHvtA/OJ0xawkTdgNOx34ooNnn
0e0zclYgB1eYCq0VUGDf8sHLj61AXqHPjFNYHnHcpfoqbFjBOfEBpb2rcghQ
3fP6MgqURQxJXSpQQIfIHu+HD2D895TQ3maFQ64xXaNtchSI2fHojK83Djl8
mf+4H+NLv+7jyzpdSgh/fW45fN0KHim33FnjUkQ8RiQd/2FL4DnBJ3/7Bw5t
q9E+K8BJgyBHFQl3VTn06FHZydFCGtQNJ/yzYZdCNo8idCpLaKC2+imU87wM
slpnPbGPhQ4CO01SDzyXQ4kpSVVFUxgPa5r+ET8qj7Tk3vUEu1Jgo40sbfRY
GuEepd7maaHD3nRnDheGIlKyv9L6x4kCEoUr3LK9cohlg8mFK8ca7tP6tFJq
FdHHqss7aGnWwGjll36+iUN9bHbJu5MpkN6ec86TFesbPtlNf6AAc5/PsS5t
HHK+81qn+T0FFqfv+y7ayqK/fj8ohhcooLgjgI+pSh7dJj3NysD4s9v8KvsU
RRZVnYwSTsJ48ZLs3qdOqTLoyR57RUNnjF/Trco1baTQ0qdzmURFKtx16GxP
rJRHNYa/o7dcpML3c5XlgYOSKPBKOnpRTIWDSW77jovLIIny09f2FVGBrluo
Vessh1463Tu29gXj2+Lpd1t3yCAeubeHSSFUmHi6mWWqgUMB33VC6lyowCzw
QDvxsxz6oduz2a5OhVDJcm7bcQX0Jvwo9/tcKvyQYk3K61ZAXv1Jzncw/i5S
evBp6xAOxcjs9SjD+D5/nigqIaaA0p4em5/bT4V9o018UxkKKCB4Ve0+9vjo
XDYT3g84lNAlf0PlKhUm+6NZTTEeEzj3l0l0iArCdg482+gmMCb5UyOkigZt
QQKSLQsm4KXE6naBiwaJQhvyN0VN4WreLdXCMSpw1vpVb8XyxW5Tn3y2Liq8
F8j8o4b541TqLjdHMwrodI2mGzaYQpS89LvsC1RwHewv4g41hxNv4nQO7aSA
sqAdUeAZCTLMLt5+guWbq8XfpEQxvzF7ZpObfJUC/CO/D10aIYH8jvivrSoU
qJSQHfK7SYSifI6mS/4UyGPvPfBilQD4eAs2E0MK+HPw19mQiODJ23d+3YkK
C07Hepl6SJAuEvhWA6tv0Mb87u04A0i8Sr2+3EeBkyPex0sCSGAisl/Xs5YC
ueYV3tn5RKDEvC76FUABHrXLfR8yibCkbR09WkmBmSvJLF8ESZDzeVPntA/G
95TzccKbRPjguRDnuc8KlMyylKcwf/Vy+3x/4awVCFU0uCn+JIJZknLhu3Er
WFi7Yd1yggRZfTlL0oHvGELs/efz483gm5ug5a27C4yuhzV46mtTOBf996M3
Y5mxW/Dfs95TprCb28pTP54Zvq4oMVi7MT56aSdDFBUCVQflLw9/mwO4Kaf6
8gvDhzc/X3aEW8D93XOuph1CIB80/q7Jjgx6ROr+BYyvCdKoN8pzGwR8zwxJ
yhcE3ts1a0VDFrBpFHBUN54bUti1xxtnLCDKPoongM4PsYOmj/ieWoDegbDY
85+4QbQrdVetkwXk0gwkC7exQ4tTRNnAJQtwVTJUuH+aA245nn8mvGkOby8m
EV984wPWHevD0hwW0FNbYbVsvMJoGwrwLBs2Amb7I0dura8zJr803Pu23xgO
NCQn1rkygeWuAPzTASM4ZbmhQyxaY+i82H81RtQIjoRXM+94tcawuLdL+l2y
EZy18P/EN7MF+DeEQ4O3GUG5a7HxCJUDDuWd4SgywPjsF71LKOAzuVuyZ2vF
JAlmnk073FWbJjM1XhEQcScBE+v1rw3uS+SSA9Pdqc9JQL+QoVpzbonc2dK8
R0fWCKode5mybm+Sn7qrxWSlG8Datye7naOZkdsqG+6dvgFwBTyr4A9YJy/2
r9wb5DEAByvtdyHXf5IjJtdd8y4YwPngbpaqUwvk2obZTZqsAbgGGVTobRdF
EmY7FKb8SVCtl25is8iKygdfLMv+xYOjtDK1dk0SdUBM1I0fOmDM6jrh8FUJ
WXF68EXdkoAKzWz3A1c10LcFw+DiZTFYbZI1q1JVRJ7eHXd+/1SGlF3eks80
FVBIXPnS+3YV2Ov288ApvBIyj9AMMAtUgQ8sHwLn8pRQ6NXH2Q9mVEFncPN2
U6wCSpzM+q1upgbx39rD4l4po9sNeXEheGXI5zO69WdICbVH6QpueiuBt5Pl
bOVHFaQ35Gn4iKIA6zlv1RrLEVxKNeCMLpJHzD6+RQVXrWBp8JgDsVgSxXY+
kr5+ygqa3g68yYiXQ9tT2004sTwrytYeObwug5gfjLc242mQ5/VGL/iHDEq2
saw8doAGt/ji9koXKvzX59Xy6EHswC1mUxvQS5q6rFEjjf5ksVxYKrEBuwWW
wQcdMkj9L4+4wz1r+MgXV/iQjENPrpM3R1es4bbpoe2OGHdFNjSeHCmjwwvF
O7cejSqgFSWm/JQZCmjy+N3iFZBHJfhZlthlrN/f8L+68tgcfNWqBm7/osD9
wd+C5gLmkPfiNzM3jgoDDmbs79vMIDzLRei6GRXq6e5e2w5iebG+kzkQ07cq
E22JxDWz//z+DVjB7zw/u32O78nju70v/Z43At4fSXfaZehghnd9sjca6/+Y
ByfOytGgYVXR4DzVDMztCwp8jTHei9nMKeQjQsX36zqXmulAu1ozkvHFFH78
yI74clQahTl7ZXx7SQSfS9se5rfyoYSkV6WleoYQ2rSTScKYC/mcH6arYHo3
N2lw0mlFCbEnvhfkWCECp/KrgP59MminivMJAW0CmN4ZHszroUBWYKdSKA8B
ku/s6iA9owBjf7zbOXk85HKZxxmcpgB7WryYrQoe6/eMtZ7bmN9KmQ6Z1OvD
jHZX2J/fFBDKSbZz7taHgVJbacNbFHj3JZkj9Boe2FgOUdTjKVDlY3HMUokA
Ndo1j/l3UcCwOFfqUQceaLfHx+7XUeBZeX/aSCUBwn8Ia5MPUqDxw/DpsLME
eCI2P3RPAvNLx5fWwtcJYD88+1CtiAL9LYxULSUiyO/uK6tZocDeUxJhMhZE
eGCu074yQYFDsdsVzCIIcCeYY94nkwrJY9oO8XuIwFyX6+2ArZdkec7M+AcR
IjVCdXRoVDDHsRW8kiXCgH1Yw+RXCujt9Xz5u5oIXCxvu932UcHO9kqNYwEB
Mvi+bambwvw12kq4F9ufLaG3mPcm5t9rBNqjIAJ43+TUk3qP8cDYJzJvEB72
15/bmGikwu3uwV6LOWz/9rKv7r/E/NZM0DRoAw9b2/6lNkTRwJQj14N/jAjb
lfkHTLxoYBmnmnx5Cg9nkoPOzvyjgq6mOMg+JEKrltXPRHEa2ER7bf8tRoAf
+CdV49h649JLqX3+WH7cGzi34wF2feI2r3Isb/b4HSNoq9Bg6GKM2VoCHoSN
eN8I+dDg2nU248ufCWDMrNSUL0qD6Mqfxy5KECEHXYi4zEOD6cx/q4IP9CHy
YZ+cSwgN/Pm/SP+ywQPRIvu4sD0NfrJZHsryJ0DuDbsnKqwYDx6t3/dPGQ87
xW7Kf71BhQv9AS8DSvVBNL++t+UdFQxGnryO0NGHMRWtTEVXKpSEpT0avUWE
jsV94SuYX+8pShq0wvKkbM8lK1VlGtxs7n0dP04Cvvy3PqMONMhvCCH/CySC
w9ric7IlDULEZXYoB+hDqFCJ4zKdBiVFVvpcWL4sEbRPV5+jAZ6n6GvTdjx4
aA+nWbyiAe/4YO5ojz5sDwtz3XGHBpz3PR28TfHwVplQIiFLA5Z5+XOuZQQ4
UviSpxO7n4VNap3ND0nwIbi4s2KZCiKVrzY7rUhgEesxVW1Ig9Rfvd7CPCQo
CVw4vzGC7b9txu1PgQF0ujrJ2mN8taLwsfX0Ogl4mjvO6cxRYWv8pj9NyQBm
brVqm2M8c7Q2/pFRMwGYP+04u7wDyx96XQF9F4mQ9EWijFFkCftSShdwO4ig
Uyk9ro/Nj7W9VxYTIAJhfED626IlDIczchOvEKG8OC287oIljF07qrV8lwRV
LKuaatOWICUbm3D8KwHOf3j2IemXJQQtxS0/PkiAiEs7ZnvDsfl3N7pzVQmw
kbcWqdxoCStCapk8ilg9FfWeDuVaQpTiMMe5OgLsOvgzMfWKJXheemqYWo+H
WoLLjuSdltDz2aHx2UM8nL5pk32a3xJ+2R5KOb2TAJn/6HKjLxCw6jcuKx8g
ALVhu0o3lhdzhOqNHnzGgxB6h0gVliBSG/zMgxnz5/uHN6X+WMLsxbS5bW9I
8GTXjq9EESsQOFC7ut+ACCemXztvmltCxJXjVVtFiHBTLeFU2owl/N3Y4T8h
ToLnhRNHHihbAYeJu1lJOgmshr6lf8FeX2RP92tFdiLEPXx49miTFThnU7iK
srHzc2g86WrXT4b49cC6iREzGMvJcPF4VENm79RMbtC0gGeJebPsbRuMr719
rcerMb4RpkdsbXnB+NKVlRj61BDCKJ3sPJIdZPXBfXwcGSR4ZrVz1sH+D3nF
q/da0HZDSDy23z6uXgilB50NIDQSQOtzZUeOnQBy9//n+pqPBFKBGeUPvCWR
/v2p2AOgDdGiXxanRMSR2sQqc/ARHVAIN+EZvKGKks14+YyFhYEU3Lu33UIN
kYy+cI+1SgBPPOPbfX01dCzfzfTfVU3Q4OLgtL6JQ/XfmusGf6tBwq6Ulrg8
BTSkL3E7PFMdJu9v0U3sV0QwbEF9pqwNEZ+59zX0KiIXAXfjCyqacI4jpHw+
RBFZ69248FJLA/AHZUuGTyigPKkx+z5xTZA0js26uA2HjgoYlqo0aQLL388L
9yUUkSmLU+w5VS3YHNl/ZbQAh4qVWewKFjWAZFiDr6yUQ27nj/i+X9MGpcfK
F12n5VBmaJn/xUYteJJKSzzKJYOUTwdLfO3UhonTjaI9Egro4EV5WlapNgz/
VD8q3CyDCIKhe75d1ILmlM7ufSMKqLdKo0xHRBukRabPmAsqIPXCDxODPlpA
UHqY8EYJh7xOs+bfD9SGJpE5cn66IurkNrXSllCDuWxm/iwbRTSoVRxsyqEK
bw4OyvfKK6MfuUbPWBuUYUTzxbTXeTUEa0QxlVkV4I97NpSxqoyeFaY/O+au
BL937GkafaKMakN3a2TEKoCCk8N6TJQKMpljqvljqAifU68ObZTR4MlDnSWf
CzhUi3df+4DpCV2ppdEgDYfs49RkPcapEKdkGZXvooBGF4759GN6ufrRSWqn
jTJy3+33TAeH6T3pX1r7eQWECE2Oad+p0PXNacsUVjeH659uKfZQIeSUL+s2
eUX0C8tpXJifmekosHLtVUIV/9QiT3tg+S6eq4ijWBFpRDvZTQ5QwH3DPTCP
WRnd9b2T88uQCk9Xz+0e5ldG0lHVrTym38mxNWPIfdMQfF3jP5g8MgGbjqnj
8QbGUGLkk/sWTwWmy4q5Nu/NAded0+9oieVulWA6h58+yI5ybI1jxqGmqcmx
0aMG4H35eIW6vDxqqB62aXplAJ8n6zbUoiSQbp7e0j7MD886X2piSadBhrZN
7WsfY2jw2tX85oQ6+sd6xpq1Dw+H5eiP5aSp0HDa1tIX88NVjy9KLnNYPmRW
tHe6iAfWwFIF0nYqvPCLM/tejPkLnf/T0QwqPGwVqlx1xUOYWMr+MB7MT3wP
J87g8fBP+FOBloElHO0zfLkqRwKdbtfd+XctobzXRPdpsQFc3xVlI8djCaJn
d6pE9BDgZG9455EdlpCV09R9M4sA4ml+39c7MX0tvTm7LYEELXYV4Vx6fxjO
dSEH8CLmQPGckGyr+8G4efI3F4+HGaweEY8syl1m+A4f3rylbQbs6cOPlx8M
M+6+VbbZ7msO9Y+uec4lTDMUR+gumb4WwLw4K5FnvMB4mDfde+6BIejTO+1r
ohvIZ7fu3P6w1QCYVNS1FxUayM/a/d6pqRmA5UZw0DG1Cca3hkbfYQfMP/4N
M+53jJOFrmdGV4YbgPiJB40crZ8ZLglnt7XxGsK+a69fxp6cZjxNHJjkqTCA
O7yjJTX6f8h5sXZNblh9nL4qqheK8CEx49i1xPcEWE5MPz9yhQfdC60t3uAi
QFOdkIiGNydqU7qQHdaPhyfrSZNlXtzoAZe/ajXGJ079+7sXubnRNlf2a4Qa
Ety5+XSsQIIfRd7zT78bSQSmQwnBStmcKFBl9qMjlQQUHZnfad1CCC/nTqpN
IYKcgsAfMw5BVB1ddD1CkAhSRHs/0QpudOGmcJGkORHm8246cckKIpdd52Xr
K4nQZ17orGUrjjiWz/gzgvVA7nO60h1HUXSZo5mLeFIX/M6S/E67i6OxUoO/
4oG6sOHhIfLMRxhZn7i5LZRPF4KYIyf1HYTQtvSM3DZDfXA+fv9lUKgweoz3
PRzgqAccIGg3f0QA/SzwISR568GoPUt+srEo6i1olKwy04f5oOKfiROC6Ivk
/dclE7rw4l69260WftRj3mc8a6uP8cWPRc1CHhRWbjZttagHtho66omF/Kjp
XMvfO3p4WJksuXbXhw9FPpp+xt6sD+/MDo51e6igjNq9/XVVouDBLhZcwaKK
fjwTG/lzTxKUEySIblaqKIRy3O+yozhoE8bDe26poTOkjo2v10RhYmPRucFf
FR2amJhg1xWF4t0B5irOKujImuVV2iVxyDKlKmjj1FBf6/fpD1vFoY4Yllom
qIIOHTkQFrahDr1+g7plT5XQrMZMOZpTh+BXyRx3wpURh3PXIYMRNdiV9+Xw
jxQsL7wTebI5qAZIT2WcdkgVOWe870UpanBX70Qy/rUy+i0Fpht3VIG5QhKq
YlSQQeXD+nAOdej4aFFpXaqKXn119IiQ1oCUfMkZ/WUVdPP56SyZFBU4LaOA
r1dVQffxv63nR7G82vnuSPMADRwXkwO4/sqjicNN1+VSaJDoPROsQJBHiVar
QRHeNPj9U6n1XhwO4ceZ0v5QaVB64HWrvpQ8emxt43vjMw0s3g+YzVQooiWt
8rejGK8plKcwJF/LI1evoqzTjjQgl9J+SekroZJFqxO7MT1dkuQV0MHug98F
6e48jNfmbrMUrepi95UzdQDXQoXZHH0rE14V9GxM+teHY1QoIAVZUblUkN1B
laUID0zvS7fO/LZSQ6JWQgrfcjA9djbee8tZGfXv23/s1UcKlE+O7JlgVkN3
DOTlA2VosCBcsXj7mwry8Pms40qkQnrju8R5uiq6KXfUpugvFZx+lVawaaug
gGddGoI+VFA2mLY0G1VBgmbRjY0qVGjUcYp+raGCQlijO0U5qDDTqrPjEYcS
+hohfbAayzscf5u5HisqIsPMp0fFblDAvGxp1mFZEe3ck1rN70YBYw75Szxa
imid8UDEn06BfTqP5lZ0Md/dG0J386OAs7zkv1MXlNGckbwjlzI2ji4/UzKr
iE6vdZrbmFJAyvnqQtiQEpqs6mgSz6ZAjPb2X7gFJTQy8PFsPJbXZHvWdopI
K6HhsM2c2UcqKNz0TEC2CAG2lwtnXlujQHgHb91gigV4bbnCnCAohWYsJ150
beLB36rGRjNYHi1aqH4KqzOCI3/YOwcJ0siTOXaRq4MEcq829STTZNDCUOxR
qi4etgyxCx4/KYPGHrg031M1gKA8Py67KiX0z6QlezAO06fLp92+n5NFdxrv
1h7D/MO0vUSrbUMSZQ4cnPVMwcNnUsNw8zccgtbj2zMPYXrqud5wexcN7v4g
ioTeNIcUB/fW+ChZVCDULHL8KQnsBgrdHQuxcZj+gz29+mDz9j7fRjAN7qlx
ByYamMGXHQeMFLj40O3EttrgvyQ4XpB1tqJAAIX/vOJbf8IAOIYfrFSfxKGg
14J57hqG0JTTxSyGaIDqw99eKzKFwZm7zY3MNBBfuFawq9cUKKsFvG57afCL
IzZ0C6cp3Oha/vuEQIOLtw9kU71NoPmNuJvhZRq4ZGb4Td0whaNi2qVnsfOX
w/qGMfQCD+21nBzkMEsIP7e0i4blFaYJ2q1v/pbgVBDL9KiKCLVcXtuEmS3B
YjD3Gs9lIhyJ0OnprUPA9rB43jePCPe4TvXvT0Mgy+SlnI0jwSkTVZ13XxAM
Hl2rllAlgUaMXQ+uDIHCUfmKjssk4OTHxZOvI3g1o/958qQBWDvMHlR6Ygly
ZSM66VIGwP2daPwGJhlb1/eFVC2aQdp7VzR9ep6xs3Gm9kKEOXCIRHYpOX5m
qFQfGZkaNYe2U6L8f6cWGfV7202H/ppDOa3Y7IbVb0ayfupp22QLsLpp3tNb
tcKIlN95f3+dIdzmfh8mcmKR8fxhcNMbByPIUjkod8j5CVmHX9JDztMY4uMC
FWOlPjNOZouPnJY1Al+TFfkzrycZpR0O0Vq/jcBv/SHX7S2Pycyj483HzxiB
8ZdPvoKmC4zDG3EnUpuNwHN3bGZx80/GPp76+5dOGINscfq45+YiIz6/+mC6
qCF8u9qw/S5lkvGnTnR5V6IhbF2Uy8gpbGNkr/Yf0zQxhHbZQ+sjU5/Ji2KD
TOWXDOGquWcKPeQr2UzJvambyRB4tlk3P48ZIFsfZ+0PMjeEvLvmSrcmF8hz
jucNqtwNwemd/W43dm40Kx2G60wiwNVd7y3MrwmgLcekbkq4E4A+x155+ZgI
Mo95HBt6BQ+y1u3XKncKoOQ1pheXWvBwod2+QSRXCMm5vEu8tYaHwZC4DA0N
IVSsMtnu5YEH7WvlZ8dMRNDmfU84OqEPW+oFZnuWJBB7rGvQVxWMr3RO931s
FkaXbqwqLUfqg5681924fjHUNZ6gu7NVH1q1848y9YuigFfn9sSR8MBDMPRR
J0mietYD3+pO64NOcNnH3W7iqCeyQkicjK2fJ8miLCSJ9s4Muk7+1IMVue7+
+kApdOj6gv8TTj0sFwYklJ6QQ4cXHDI6mLDxZNu1sKMyCF0aVKFRdMGcNv9p
NFwGLTcMXAAnPWjcZ9Y5kyKHPpibJ3uG6oModbjg5y9ZpBU01rDllx7Mnn3E
9bYJhwjV4Lk8owdMQWfkOQ7IoSN+1zSlNnTgbcIHRvCsNHJm4avoAX1wk9gX
uW4qhYQrsqvM3uvDtU8cw5v90mgjcP+cSx4enD5XBmgFC6H91zqeCe41BBpL
rMyDYSF0dvjN8nNdEnhVdyOteQHEePr3s+k8CXR/VLkE2AuiIe9dHP/z+1Oq
+NH9Lr7C6EfXusSdVySoTOE4bNgkhO4unxpPuWwAHbrvG4m+Qsjwn0qdi7oB
fI38JK+mII5IS2cUtI4YgMphwpuQAlHUNBJ28vUqCdK13H9pzYugeNl8bp8E
A6xvxU2aPSXR0Y+ljK9YHqZuX/g7+UAMif90l82OwfoF2p8qW4gjdWEXV/Wb
JLg3O7Dat1sM8X4oVe+eN4DLc64+z7vEUfiiYIrQHSJQnQ5dYdcRQV78rkse
rIbwmptv6XWpFNq9TI2u5DKEWb9el+klMeTPwWIdrkiCjkpT0SSKKGLduJwH
GL/5tmyV0MuQQLxXPbhPDWPrryVpmd6QQpZbxOVdKQZwLVLvreJNMSTmwrvz
ylMCnDJb2LozQhzteTiQSZjHw0+6CEP0uAgK1aeeZ5clQmE5kedMsAjadfOH
iD0nCTqjvlwJ4BFFpw0crv4yIsB3mn3jvQQRNKQnKTF1mwD/zrfo/Lgohuir
A93BFCIwUnQD5feIond5FWV74/UgavaC/6P96khAbde34ApxyHX4Nf87RQMp
f+UzP+8qD5myzR3G2PjUwsW8YyrS4P8wN97NFBv3S5wc55SEY6VXvihrqSMc
vZfU/EIKPL7Ptmz0qaIijaSem74ysCUnk3vmnjpim7r/4aKFLLzj0yCwGash
zwct1sKVUjC3oPfTUxrjP8e3R1OOSkM08eaFx10Yv/F8rXx/RQZ4Dx4eKlJU
Qyveh7K4luTB72L9HgVXddS3TGV1Oi8PxZ+3/NApUEM3L9pJyvjIwfq40YVM
ZXVkwFUQM0lWhMufpnTzelVR9IV3bAUGinBgYaHn1nc1RD7N6de9joM/BQE4
lTFVFKNj9K9yEwe5MT3fj1/SQDYCshb6Hgow6G/4C5g00DuhaeR6BgfzTO9O
+lWro0efKpP/JSiA7UH93W21Guj4lT/kE0QBeNXwMfNqmwri8VL2UqBrQmu6
INvZC5oo8CP/y7w4dRBLSSIxLquiPLn+rrFQVWCalG671qyCWsc+yZJHVEGn
UknjqZQa4pE8JZBlqww4m0ePrcPUkPNRj9vXdZQg1Uh47HiJKppPjHF1TlUC
ocg7k+ZVGkj2n+fcyShlOM+bteVChzr6du/VX7HjStAWW0f54qmOojm2f0AP
leHgGmehzXFN1KxpeaV5QhEq+dXu626qIYEZs+1Bn5Xgcs0gbj1dDb08/6ev
iUsFjuV8WP3epIGuTQsXsyUrwbClqft3Fw10UbQ40TRCEQR17G7Ef6LBfDfN
gBaqgGSTfuT8uUED92ihuDMpCqhmz8MtVAU6nK0pdCAsKyAbRtqnSSc6hJ66
rTX7Wwm1POx7e9aNDryTCc0y3YqIV8bvyXYpOvBN29q/dVZCXVuWfMLS6XDw
4XYlepASwouHnAirp4FDZEVMX7oyCl8SrXAtpUNwAd/6fh0V1OVlFkn/QIPp
qoXbXx8qIVv6CaOPZ+nALmIe0OupjDTV4343XKeBfFFfRSyXErqasjUuOYQG
LKcbePWjFFFbXNJxzRga3M7Z4v/mpxK6LJZ2f+oQDZQLeIbdLDEe7t3+sgbj
b930LV5Pjymj4THPkYY9NEhlws+zklVR+QjdemiOBt8s22b0m1TRUy6DgrxK
GtR42+7SYsbO4fc3z/7cxuadNjKMsT7Qkq23YU6jwedJvQA7Ay3UuK7RHiJI
h6ZP6zOOwRrIRePm9cQzNGBNyRMu0NFAtx39X5Z9p0EfS4KtM3bOxd7E2asl
0eBfTUn4AVl1dPP4+v0mFRp4/C0tuhCniNhMX8c3itOAWH7O5VygEpL6Fbg3
dYoKF4l72bmwOrfkC4VcUqPBntO7X++6q44cTrS0LTLhUInq2DjTZ33oS3YS
kG7VQDpyFOnzFDzUPz9yvui7OrLwCuOeGyUA6axq1zFtTbTiynKJj6IBkSSp
0lwjDWS2SfJondQEGfsytuMNSkglcotPG5M2XLIayF7AHm94vdyRb0EDWmq8
eJhClZBR8PXyVSUt8GgTXa06p4l2rO1O/p/fa9Pxyz+g16iGLIp935tcIcD6
VSPf5sdqSGSgxChjJxFkVfgCdczVkcg4+/Yhbh0wQZqik6qq6MFVXu36GS1I
0PPZJ9iuhg5VDF5hlSNAP9dkjt8rWcSceXYL2cIQqJVBlCdpsojvj4yhRoch
+I4OrGRmYf2wZEtkKxWGltu1BbNvZNDxDxMLAa0GwG7ErOGzUxVpH7Zp0RDG
+NGxPDjZRQ6xJCb4n6IZQIR8wB7Jy3KofN5qxM6DAGttGkfNdmsgQvoX4w8c
GsBr3hlrx4Gdo4fxX9crZSEj9C1OXArT34MZHqG/CFCUUp2vzU4H28TYf6Qy
I4CT+yVVdwwzuF9kf9ZIMQIr+qS0UfUP8rEwumPKnBF8ZHvV+uLiF0ZzNTWV
zcsEFjwz3UWmRxiFrb+PD14yhvwCbUp/4izDcMC+w3vKGC5PKjHZRveTUxyf
ptZsGoKkvrnpY58p8ngRl4dgoBHYRcQ6sVbJoBcyX0x+OutDVYJ0U+leORTc
K26SgcfDNevd8io/eNDmsKAuKcQA+Gv+RqdUS6At1VeYzXgxPwsSSn1zRBHV
11e/zisygPWR5fPzN6WQUpMU/8RFAuysbAs0HJdAtbvcGNNbiVDklqGy5aQs
2oy+vrZylwjuyekmFgnSaPlGdNVRYyK8ZuHUC3wsidrqOWuasHyz62OA6+ox
SRR954S/OisJYnyUc+5vlUF3e05reDqQwG24o3FBFocC7nEjr3gCXFrh3ByK
lEUf3uqejaknwFmTFsrTJFl08mJxpTGBCJ7o0Mrrhzj0q10wa/gEEQynEhXE
3eSR6h3RMzwRRHjJp05/ooJDzapbWV7GkODm985PkQY4xH3j5OJTFiLUBbvu
uKiFQ7kPOgi8P4lQeiFI1i1HEfk0uz9fuEUAo9R7o847FJF1Qr7hTXMSnEzt
lAl0UUBR3uKb++8T4LnRs+A2BwV0qYo9SOw3EWb1s59cPq+I2JnNkxLDiPBq
y4TvXJEC+mLlYuR4hgjWt4MInx4roCt1+6ZdAvHQtaY+HcCqiJi71woMuYhw
bSGzLltGAQXOeKZ1sRMgouMa15kQRSQ6vn7q0Toe4HnNnxB/HHLLSdXYcgIP
7nuW8b9eK6DjN25lyboQYE4urKZ4WBW9+RMOLYIEqOP80xL4F4fmrtGtOJr1
gcyU8CIkTQ6xfZQoGJrGA9vLixFnmpSRwVBu0MaYPkRPNIh5FSmjM6oHmGwJ
BAiHCG87DgX0l4n1xFdNPEg6p6qJ6uDQGF7+1Xtsf7vxRzcWdiuhlzdkxa84
4iGPgHMhRSmh6s8lpjspBKh4VEBrJiujJ6aatvMSRCivoy93YLqcOh7px/sM
DxGU79QAJWX05qubZ1gB1t/SZlb4fSrINOVnydd0PJwwxL2TdFFG+8Of7VVw
wYPq/NcYClafeveAPDVs/rO5bn54lDgSLmp4uXocD/+0f725OaSC9PrLT+Zd
loPLFmszwsqqSCfwUTgbHQeHYreo7mlURXeyfh4I05WDpnObHmEYj7ithGhO
+QnBlsEofAfm72LFymNTfzTgCqOIXXwA6/cSx+G6wxrwZ/+xOhYbZdRtVyRr
4aQJDhk0WQNvZcSn8rH72CkNIK+kSKW/UEGj+NY9b7N0YOmgUsqLU+qIfPNk
Mw+bOoxKMWkk56ih5/v5SrzV1aA1/v3eaaoa6uwmlcyT1ME4cvdcppA62oN7
WVsYqAGNPhEx4fp00LAavtYnooB22rxVedpDg45rlBiakgb6YhucFFNFgzkr
xd8JmI7fbH7LcUOUDq+T/bjDK7SQTNzRkEdvaHDwNccvdWUtVLJo3dL3kAb+
rq+7WZ100KW35W3mAnR4gWlWe7omuhtnbLkxRAOKyEPeSlttZDVNGRFdp0NG
zMP0/AFNtGWptLYpE/M/bjlPgoc24pgP1VOxpEPNCh9Vpk0H7dLZ7n84lQ4l
0bE9WmyaqJwoNBedT4VLNVUu11i1UVTMwUm6JB0+btla+/ilNrqi8ujLkDUd
Zv/yzDC2aCKZiDkRK04aKD0LsL7jp4ueV6xEGGP+10ZyD/w9pYV8Sqg7SH9o
IPzuUZRxvw7yLx9kJebSwTn7o+d2ArafelXTuCMYbyDjH2M26mjtrFCwOObv
7Usevvuv6qBkEodk8i4a7OVg/D8u3jycqujt46ZoMs9D5nk+o+MYz82ZZIhU
kowVlYhmlTQQSSRCGggVSQiRIjfJVElSGlEkIUMkJL3ndz2/932v5/lzXXvt
ddZw7/v7+e6z1rbxe20ItB8tqg13OPhMUeLqdVEyqKkQ51f7cJBu1WPS0mwE
liH89322cbBiunHJJ2NDaNW0f3iax0eH/Bcv++lJgCE6w9GHwkYYc4w/6mIA
umGmnys1OChJmP2y+yoBRuIU5umBHOwhWXOrXYgQ4x894FHDxvMH0iM3bTEB
7217PCZC2firjbLF1dMAxJ8dwkBVDhZEL3O1u2oC1x9t6vDO4OCPSl+dHpox
sDNahRWOsNGSeFry+yETkL84tnnVFzYWZ6wp3cwlgOfDu2E6f9l4Xa3mhvk3
CtxmU3SRN18p7YLr2z3IcEd7l9u1Jja2F4+4nAkj/p/z3WTopR119XjJwS85
OWU+1w3BiGV79cBDDkpkHBNQKzKAPTeP1r4c4eBPQ7V/e37rQeniKYOCBg6m
VNw1+FGhD5cPzb++cIuDb27mHv15Xw/OlQspa/dzcKGMldNlwPMBVeS/e95w
8MhWL/cLsnrw+8qljfaOvPhWWAhYPMnjp2ALs4CVbPS9SPK+NaEDF2Oz7UQ/
svDn6E0Fyg4dOHC19e2pnSw0DPG7orpCDzS+55jQJzXANkd4zVNjIjq6BXct
9tcBtx6pPxnxZGwpCr15tZWNXwf+1J4wscSmU2/4jtH0gLku8pLlHQNUPXp3
IidCD/i/mMsOfjBE/41b7tWcMoBb+yKJOsIGKDk6cMDMSxtu7l3/hcPTH42Z
BPK+O/qgQY8w9nhkiIsfSFwoiNCC9bi/88hhI6wui3XmBuoDN6zvll2hEUol
dLpPrtWFjPrg+BZLIzxWMrTtZBKPtyJdZY+oGSI3yOKxfKwOdJs0Xhv8aISt
xTYfnb7rwFvQalwXZoha755KpcqYwLO8UsmcJkO02ZiR/OyYEXQKefY/P2mA
doxP3wL2GIImv+Re5wQDVL+maak0bAgnUrBWTl0fmzuLG67c5fkbnz/8PekE
FBI7eW+dlT4MjW9IlTUwQZeu+HJHA168FTz4NsCbh3dVtZudLTm45aooDvL4
lrXlkH36OQ6OejwRD5DXBcqhKYKLBQdjL/9mCCVrg1TMwWWXePGmcdBuoLiN
x/NptpUCNbx4/yhQm2KhA4WL19TqHuLVl5C7EyaoA8eNKevctDiY9TXV1i1Q
BxjH7rU9+8ZG0r+ZsJM12hD5tXyojcrBu/5BP56Wa8Hvoiu+H0XYuIygTP+r
ZQzVam+1ljHZODOWaJ1cYQR32Akj+IGFZrn/6HU7jaC0Suf4fCILX9l2ZY/9
Ngbr3ZQp9WcsLE/Zei4o3Bgkz/SatjqysfzoQpP4Xn04XvC090snC1UmLG2z
6wyAvFXFRDOCg2/fqqxskjQBmmNAhvAyDvrw6x66c5cEhYzjqj288nxKv+xf
RyLsPcB9ECPP8x/GQ2h1nggrXL2rN21j4cPo1WfezOiAY8g+Tr0GC906St5W
JOsC/cN7Qk8OCwP0Dnof3qsLqw7SyubjmKgo8o6+o8cAssP+ON4UZ2Hrl/4D
ZZ/1wUDEOWrcmIVj0n++qzXowbGlHysKaph4V2XdZBmP91l87PBVh1k4fZA5
YDWoDzaWx0f0q1nYxYw4OfZRDxKkKqv4fzFRAoQqo0X0IWjd7bBY3v2SY2W7
LMf0Qbimn6D1nYkvylq//Z3ThUb9/okWNgstM57NyvB8tOa56LvXGlh4fPMY
s3S5Dd57w+oTJpjhRsn0TcETprheN0vy3BQLT1Kdrv0It8ILGZ+WiDTy1uvw
jtFaYyvc7kOOpK1go3D8YU5lqyW2eshdMTfi4DKFXWOULRb4r6SPHsXzn5Ox
LM1dQRbYLnXgZj5Pi2au1N/Z1GuByx5LfZ3y56Cj8U3FiV8WGNv1ft0x3vrV
bNhkotVEx1BpUoXAdTZm0gNK83XNkZZK2e7Jy4/dV7uO1CWb48Y/p122n2Tj
dIlD67p2OirmtEUaECVgyb3id0FTpvgqITgoPHsZDC/lfhNZTENDal5n2uRi
KF8QmhRoNcWrpNamRAYfdKzukDkiS8NwWsZ+Tx8R8KssrS5/Qke+oqjf211U
4ENUvGA1nYpmcDkpIkwdbL98zXzfZ4o/E6ccNnA0wCg8T1KWbIbiiwpGHK9p
AFnBW/LwThpe2dzvdnSRBlC9j2+RmKBiUtebFmK9Ory+vW+/GYeI58dqki7G
acDlK+8tdz4jYlrGael11zXhrqmujWUTEWk3tLqa/2pAV7t2D7mPgk1Cf5qH
WTrwNaLlfhGTit0elTrxtrpQvk3YTv0uEVNj74s+ENaGBE+jXBcXQ1wuavUw
M4wA5VLCRlYH9HBR4s35lFQj2H+lZjZ0TBttnNm3ojbowtKZ+JWU9yY4qTPz
/sJLHaBdmX5X+c0YCw5snqS+0oXPA6e8bv42xsOejiJXww3h4Ik4SwcrEzx3
pau2I9AAPPXVR8qPGaOrt0L/IMsAaG/Wi01mmuCg0+BRLd7zvUX1gev0PwPg
3ho2p7twEGL4jh/bTIVQvqKApT+4uHfHedmPTkbwTl9L7lIcG7Opv5/dziWD
S90lq2MhbFx3Mel87ioieJaXeqizWChrJyw4bmMIDZJXktYPMdHpXV1rgK4h
hFw43GGlwMLOs6DSeN8AWPrhAo2iLCwqr9cPMzMGE9sTdVFSPF6hhQ6KyxpB
sh/ZyWEjC/eHlHIKqoxAXPCPYEEgC8MNJNb3DRiC8gDhiZYDCzV9RFfqtxpD
8T+9dodyJkYWnZYLYBPhlPsKuSVrWRg3/uTpS00i1MV+C2icYCI94+G9h/Mm
QNJj7g71Y2G7waHGYQECqF30SPkjwcKleqJqNCMTmCATTA+nsnDNfERSwIIR
tG8zenFUj4Wf1jfanzlFgMwcp2z6KBPfz1FLDi0mwoYvGvHKvPGsrN8f7TVH
BM5GneB9P5j4OJIqlRhLhCu3iydaU3j9k9iukWxOgqGY3IdOvPwSLo33+s4Q
IeIbUTUpm4VihQJLjNxJ8EV7T+TYcRY6HPaiEiqIcLcotrXwGRP1ySO3umaI
kP7ypcHCMBPbVbhhrGESzLh6dD4a4c13bMfSlB0keM19a05bxUI7L05QSiEJ
QteY0W8+ZuGWhrbYeyME2DHk4JT9goXn0n6fcHhFhJ7eJ8mDvPlImVW/d8WY
V9+m6Dd/LAsv0Sf5tzQQgP9d2KpaYzaefD5qe7uKBEZEcqTPZxZO3RmaKfQl
Qrdx3kpnVTaKGKbFidYSIEVp2uyTFxs3s/ZvtNlCANn9q60ujbLwn3LehgY/
EvjvVVx2c4SFn0NMg7osCPDwefTGuScsvHNxUDN6rwnsX3NF7DGdjfyvpEyb
rYhwed4gMOMRCyUSQh85hZJBbpmWym4qj1fdDoceUyPBR5FPN49+Z6FO4MuX
Yb9IEGB7dUT3Ggsrrf2LXb+TQOjXsGuaBo/fs5irJ6+RYSYiSndamY0HyIRF
GwzJMCn6qsuQx+ctJlVuG6N5ejN7I0t1Fy8/PvlZhwdJ4P2zMsiWF++dj2XL
xaXI0HqkInbtRTa+qRBWKhonwrEje/l83dkoeK72ZXA4GR4eX3LW/REbjYlu
id90yMB/cEx0Sz8b1QbP3ZFdToKvIklSZzdx8XpCc0VukyGkuvs5QAkXHzyu
MxswNIBX3ju8WF5cvJkuqrKz1ggcW1Tc5mgcfCiSMevKIIPC4rVaH2y4SCfs
orzVJMDSCroiXxkX5+/0W6QwTOD2kwnz09UcxEeuTjNpRNhFPreppJWDm2gr
NTZnGMN5wenwDzw/c/bui9jr5WRQMT+QZnWZjcduSPkV3KLASM0WR6cGNsqX
nj+xxooC64ON2su/cHBCNTu7x9cE8mQt9qZmcrH9UeHvEDCClruxu/cNcFBq
6Y+U3vdGELs1/xBnK8+f8FV/8r5KgumaitZXnlzMiTrp8vGFAeAVvveFPvZo
63LFhS1kAPeDJH/9PcfTu+S9j5g/DeCXqAXhTyQLafGtT2mTerAt4sRIZxUL
2d/61Dgf9CEsfjq0aoyFofWRn3R26wFnZn0Tw42F6l7nF1pVbTAk++A4ldfe
s92LHN0drf+7v9r8/9tnPXoic+/V80yU439UdXCnFR69u72r5T4Tz8vcc4uR
ssJdWhd0SbznJTf66bp7llZoNjkphUZs9HL1ur/CwQpXTN5RSpFg44+khWP5
ntZoF2tiYBDFxhehpxbLW1ih09zJDH+eXylq2dT6u9AS5WsfdZb3slF6xYVA
qXJLfPjHykONj4Nfm2RlS5PpGPHhs7u/JE+fXcS8DkaYI/tRs0XoIg4utn/w
pGHeHM8wrlG2ygvDrlXBgxKfTbFhheml29fFgNWXd1sy0gwV6aukErzU4RRh
u7tZMQ03JtXvudWkDr7s2t1DjjRcfO9HQ6ukGnRu8b0w0kTDA5cd8uWG1aB4
StMzdoMZdufscO7cqwql2cGHe/xp+L1+tLLylQos1enKkiOa4aLmdJCoVACP
fQ8XqO/MMOhIVJZgtBLsurk9ZTzHDEMExNPfxGjAnkQu7VuwOV42erTrtbAG
NFs3li91o6NVJEOo5pk6DFaKrgyuMcNGdaFmoUo14BO+8FJVn45XqBaCN5LV
oO9z88m91Wa4WsCIm7FYHXLuh+H1ReaY+pFFz7VUh5KitROpCXSsfrkhLl1X
A+5/WqjQ6+PxwGKr9YovtcFIoe7O41109LpbaZI6pAmulSnZxFN0bPwUoHV/
WAMGQyWWjifRcdeW16TiAE1Y9vRVcsVjMzy1kHBmKlUDXGr8bSJ+mWHVKQM9
7cfqcOAglW+bpymKjDBXZsprwQ79qxMqi0xRIaSk/AZbHR6PDXP1oql4Oztq
7FWBGpzP4xa2DFExveEUtb9EB14r50dlFlKwa1Jm6fPV2vD8vJH9vUQK/qal
7CzS0IZ7Ie7/6KoUTEi88aJmlSFE7L8XoC9iisejLz1LEdYBMa2sT2ZzRIwY
1hFtjdEBm0uefc4nSWgoMDoU9FUbmncRhZYuJ+KJr5bGF7V0IHrscUfkVxOM
HVL3Dg7VgtZLuWdddYlIeF3o6XFSGz5dFvILiyGieFOLRupeHajTPdiTHkLE
uNKnjy6e0IXMC7vvLhYnol3nml2UI1qQ6LZz9F6WCX7+TjG7V64JkxEGwZZe
RCwo1uc7X6kDK14K9K7OJqBL4Hpv/n49UO0y653jte+tf2itzGE98DmxtcTZ
k4CnBBTHz9O1IU5NLv+5KwFfH5GuOeWrDf8En6Tx/DhOR9+May7UgkpnJ4ZF
gjFul/S5piqoCfaSZyeC2ozx0jsZ50AZDVikVdnz1sQYrVfq9O9o0ISagR+n
3fWM0dBXaV/MWzWoEj9q9optgidY7CNxDDUIPfjOm7jbGMF66MCLBXX4NarG
zl1ngqHGZfe++amD0tWIvyKaBFxpkHv1yxJNUI9fMeMoQ8AxA8e9FH494Aad
UAgLI6KQXVUydUoP2sfKTuRLEJF+ayLm40E9qF+kPld/0gRXUTaHbSjUhGR6
6mf+xwTUqquyf5ilCaqHTnst3W2C3T8r9qijMbxKXKS2wkgf888fZH3sMQQN
SfONOvt0cU90cb5fNhuN1gusHVEmwjn967lNeUwM1jSSF0wwAi+DV2NOD5m4
88LXpSIDxiDqEvOp+AsTV9lYtCZfMoLuzQUuv9LscL5+zyJ3cxM4k/3YJvEi
E3VGKKE2FAL0xWTdVJqxQ8q5Jlt5PyLwf6irS1zHxNFT9KTNWkTwsFOfxdNM
HHpTKVS4iAhWh7oCe4GF22r/ZZwvJsNfB+XdHod4PLY73ybImwwVSfvkRHx4
+W0juWi6ngi9fT0XlNbz/OGoRJWRGQV+ONTGrPZjo8nfN0TGVho81hM9/jGV
p1cllc0KTrz+y/VQDUj2eOFFLfXdoBGc+quQaLLAwny122Kn0vShN3nmr5g0
C7svL43L+meNtRQfvegwnl/c/iJx9pMVzjvdzFiMLBxQ1yKc7rbCa7PNxNA5
Fn5N7nazHLXCkOqEPOl2Hm+OL/py1tsanfMyT6by/BXZOnbD853WeNDg0CiJ
l+8dDCw5hXrW2N3ALJGUY+K1Yke9uBdW+O5ez2TPWd78SUZF3ub93pLnr4py
o9jgfH4weOqnCYiNTE95DShA6uVyCJllo932K3X0eiYeknxkqn3ZGvsP7XKz
ewyofiDx5iItS6yucj9FfcnG5G+zL2RizFFX3HIkuY+Np0u2Nh5YZo4pllll
2+rZOEj7cfJ8Fh35E4tkolrYOLZ/XuSZAB2NGhaiUm3YSBdzd7dRMsP0Vpqa
/UHe9RLf90uKzfCyIz1MX4Xnv763rRCRoOOKZnq14Bo29qV1DQu40nFIoOPx
hyBxENpizNzdQcPjwy4RTZzlPI42WVk/TcM4NZbCHoI0rMluiZfYbIYv3j+q
JXNEIFn/55yxlBm2iJ5//EBUGIzkhT1WX6DhB9/+/MEySdh69Uuu6hgNl7R9
1728SBI+hm5W2bjPDMNj+ggXJ6Whdu/e4Km3NMz+mCV/X00C5MGLcNaKjnLy
r69VOcpBzbOXyuObzLDktVJfcpYSDPG93v9qno6l39bMtqSqwLm7/HGDO+j4
81mXh7+pGhzReZstXUjHziOxsxZOqvBJ7Oxl+SBzNNpAUGmrVYX962eYwivp
+N6FmSjyRAvshS8axEya4efT8iSfHk3QDCrt45uhYZno92YJOU2I2uFbJF1M
xQlL/mpVJU1wn5ZOi6WbYo1NaMJbdy2wiXRb8fe3KfYNz9rXjWvCD+GfxfH/
2S/x4MsHuUfaoFUg0eW51RRbypknnotqQVtWy0+vCCpetSjfUeKsDUWhv3cf
qaLib+MmoXolbWiL+pcirEXFB0vgh9dvLTAoCSjapGOKmg19VzQb9cH1bPWO
HBEqZgXvLrohy8unha16SnpU5De/fP7ZBV1wXXW49n0jBbUvjOvtW6UHStLD
2Q2aJHxUcW1wo6Mu7Njfk1JLJGGTvhbZaEIPbq1oEqkKI+Evu5Sd1xT14U0w
sa73FxH3ly7Jmb1oAB0V97kOp4goNRDxd6+9IZw817TWtpKALecDW29YqAEt
UiPYRZSAeq/998fTNSA6ySqhpYCArgoO0waveHkndmvBzXP6+MCOdsn+sCGo
nbv/YpezHiqEh+3/xuPAfPc79gSWHl7fmDrbRjCBbZUH+ja/1cVbloe3Dgsa
w5zN0T0t4rr4VNoq+lK8CUgqP7WtK9VD+rr0XHWeT3u9y3b/B3cD3KpgRi4I
IoJigE7MWmEtzF/UYReAJhDPzEo8+UgbL2Y65MmUGsOvqvH8/bo6KFlwcy2e
MwHVVar6bS91EEgzfn7RxnCklv1OW10Lxesit6bvIMLcXo1smwId7HXU8Fjh
agx5eZYWYwbaWKgUOHyukADCE/tPEQ7oILHiMYf+n/f6t9YeznbWQlxt080u
43FsQm39l6+a2PP8d90SPwK8NRPdUh+miwT/mXxbSyIki9kYzntqY4Vh1iX/
q0bwXnT39ntHtTBo9u6J6H1GEHRuqwutRQPlNBuNDHn+/dyOIvWnhprYXtzv
OXiUBBMJpRdEvLVxi9OTtKB1BCi6leO+bJ0WRnpvF37wkQhHpE7svM+vjYcc
9P+5SRFhlWJN7sVzWsg9t/e+Xi4RHj5eE/PntTaejBG5MM8kAetj/NsXIro4
L3Z1/bdIElh/KN14YEwD66vcxCqXkaBut5wB9akm8hmuNlydTYJP1OcWR3S0
cItYwKroYzwfUdfds6RSHS22WPqvPUuB0z4l1XdvaaPSiG3h50wiNM77aUV9
00D+Y7Faa/+QYZYWOswa0sCE6L7IFafJMFa9I34pRRuHCzriUZwEWx/qXOhT
0EDZz3NeexIIYORwLbwnWwNvSPzavNWaDMn5xGPONppYQ9ncW/KPBCs/lIx9
mtLCbFaWp60sGZJ+6DmqXdfBB+7+Ubu8yBC/PWN6h5UWjv/NF/b5zKsPH22p
vPEve63nLBlEgu7a4fwafyVcf+Tih736RPhsszS+ia6Jkn8sso0VyTDFzz9b
2aGGj4gPos3kSGBbErO+Vk4NneiLBC0KSLC6S2XtnSp1dHHfZNs+TARx9S8W
z2TVsWPoTIHaDxJcvBW2XSlGA+lnRCjt50jQBLf/7r2phhbJhoKknyRYJyX/
TS5LBb/I6HbjAwOeT2466rigjVLeEZV6rwxATuv79dIJLTSszr3+6rohrBFR
XqR3VhvPhcgkLEk0hHG5yu1HYnRQkG3F8I8ygITGACNDK10czOAM7bfVh2zp
+AOZfdo4u1rD7FeGPqy7oXpp24Autur7dsgl6EP7b8sPV3t0MJhKvnw1Wg86
nl/zvXFDB30aQiai/+pDmdDxqzvXa+OphH5rozImDmtXZQtlGELjmIC1kDIT
x6z5zsjz/J9Ma/qhdcFMTE00z+3RNoEf6y3iiS5MfL2s1d/NkABE7RedhgJM
fNJB8g2JI4DbtUxd77d2ONt3TsTqlgnwj7spF8XbIbnY77PTEiJwLTnZRQ12
+D5TgN/jMgHixJuP5jCYKGorYTrSTQRBv28vYg1YuPOZ3sN8AzLc9veSVEhg
Y5b0oi91chTIeTW6MUuFi39KvmlGTRmCz9cmVgjPn2cd2mY/KWb6f84HE4BW
+bP3aj0Xx4KqSJdYhhCUKmm/bpk9rtg/u/JWgAFo8z3KZK3jok/n0u7maWNY
q2Hf67DAxZ9f99whC+n+7/bUjGCjnquDkiYXq5cqRgDbGHL9WqtW8/qTasxq
lfMygYjdb86GHOFi7x8xe7FGEzg3w6mfvMVFL12zII+lPH9M+b407yQXZ6gV
7ausiHAzeTX54CgXx1dJbhuMNAbzn1vdY0a4+Gjii8zdaj2oupa/TsDSHtnb
l251u20A+zmXfv3m2mNJkmzyUlkirKgqd3j+hYtLqua9Bm/pw/yzMPKwjj0K
3XFe1eyl/3++360N7km/Yq9vtUdi1JnxP0v0oVTW1rX2sj3ytV9dnrjPEFy1
BuQ7rexRen1Y095+XVAO4ctuYdhjUoXMrFCcyf9uL8kAvA+eOc0vYI+U6MD4
6B+6EHLfNUDjIhcFdk3mNN7klaXFpxXoXAxuqz2r8ksX8pJm/TW07LEYBP/4
Nxj/7/bCdOEJ/aiPq7E9rk6asy5sMgRi9are28H2KDxw9p2hoxF0vQlPDPO3
x7ot1K/bvAwhc1fAF4X79nhr1UvHP6lG0D+/6LRqqj3Wyx0zsT5mAK9tkgOp
h+1R4va+xlZFPVg380+cU2qPZzXIxNM/9WDV/u5M9e32eNKZfnGzmg6INLY/
rdpmjxd/9c7PaegCQbXl4815LnoENf6W5/m2hZILGWXH7LFVqruUP/P/9L/E
GC4O+X35+ua/37Np1getw58KLlyxx58NHmpmSgQ4GkZ340d7dJVxkNiaagxp
z/9ESBy0xzWfc0z4D5lAHjv7tHvKj9rxn7Tfuv/YyIpWDN+tYA9O7/+M17Wz
0ec0tbqp2Qxr0t61H3tvhsrh6Zes2wFLXC+e7B2yxLDAVwcrlzLxkVrN3+fe
Vrg4sO2UlyMTm1o3uzllWOG2QAX1AwtM7Nb25erlMVBScVqyyYGJ9XxeR/37
LbHN//si2z47nFNLOncwxhJR2Tvb4iATPVWlb547b4m0mhjyZQ0mvrnUGLLm
pCWesLYi9T5kY6nCzNS7FzR8aumXsb+WjTdsmshfg8wQMnPXL49mIzOz8nKZ
hhkyo/4clnnNwrdTT02iOHTMMl3872IqC0Mu6ppm8dHRz/SNVWoRC21vx4v/
9DdDA/eDMV3fWUj/t7n/2WsahhzwFGV8ZWFTVay7T7UZighuOTCmzsaQiYpR
0SQzXH5Kpab3izBonh747itLx0X6Os17Vq+Aiy17E2N41zfkt31w1RADCQcL
2LKdjnOt3OV8/OJgELns3ekhM/RNEDp92HkR/HkU2cJ/0Az5xcRSv2rxgajZ
oprI5zTERlHzil1LID1U163I0ww3/jiZN9AqAG8dBvsO88Z/ckXK7bVfloKZ
U3N/2zEavvDMfxvzdzFQfgU/519Nw5St5SN1LQJwkGSmdfoUHYuCIy1nri0B
xYEqh7e/zHD00GOVzduXQ7hs1IPocDreC5E44mKvCC3eC2v4RM3wF+WEULWX
DGQOP13LEbNA8VyVrYNflOG1pEaD0owZPhOaf94urQ6ixHLpo2/NMYA8lEbK
U4HVGnF2y0bpeGjmwJ+BKU3ocGHUsuR4vG1U7ZP+QQuoyjoLj0PoqK46G1vx
UgtKHajXl6aZY1/5vmM/1mrD0sN12hOLzJEUkrjJSV8LNrWWhj2XN8cVb41r
onN5fL1yTObeNXMUP5Vql3JcC7wu5hR6n7HErUXwvslLC55/T1ipmGCBOsHp
l5Y6aMHyNczFu5ZZYHV4o7e/tz6sDZbW6j9ljrJFmh9yg3UhVPPGyB8lc6yL
j7AK3q4DQlJbnJcO0DGT6bCzzVMHBA1HT12/bY56lj0j+zK0IVbWvsOGYYEJ
wm/t3mVrwy3udzWtYHM8kCvOm3RtuBoeNOXHb4nxhSbGCeJ6YJGnqbb/ugX2
d/ztT6Fog0P0+JXULAuk5Jdyf43rAI15Ip7DscCd78de7LHWgUxXheq4bAtU
bBzeHU3Sg7lYPc2QUXPcwZJlf7TTBW3CdYn3HebIL2372GBSA1753BGx+0TD
01MrdFc4aQHpKcHIiBdP92zcb12K1oUNar3EA39oOOLLZPiVasPQR1PVkB4a
WheD3J52LVj6I23vXTEzfML8J6z/VguOHxP+sTWChkKZzz1O2epABLnx/KQG
De/kWJ6ZdNSGusaHo+qiNNwWu+XyP9CE9o4Hl9XmTFGX4OMpdlsTul24D3v2
0VD5U/qC3B89uHrWo7UxloJTgkrbVQb04IVCdJ7eLAXfLFM7fH+vARTcXXtX
U5yI1JsFIRvtCWDbtrm034WEW1+qDB3yNoE3F2nb8uq1sCjuisweHm/l1Ro8
jzmhgu4S6eY56lQwerxBLXGrCuaZCn3SCtCDMPZF2U1XtZH215e5MoqJCuV3
Cn7eIUJussqjCyZMdFXUkXPZTwS1wY5GNSc7dHku9FttHxl6OjfvW6/AxkL/
uwONHrx2T2fZ/R3i4DLV7hXEbgJoz6Y/qSlno47Y3tGb3lQwvjXl20HloIfr
FtkedQoc1XCtlpljY9GhANNZAQr43vBXUqNxsDT8Xu2ZDzzObenxN5TnoHIk
+10ekGCETt7Pf5SDx81PxMq8IcJgzmY+owYOmhyqUzRcT4K5sNXS7ns5yAkN
9bX3JICysak7dT0H96zyyi3KM4GVVhorKm5w0G7niGqbOBEuBdpMq5Rz0CCL
PNKpTIAVK1PWpYRxsK6z0363DG98R0c/Zl3g4LaolK5Nb8iwmzIplm3AxV+y
InpOrfoQmBhhWB/KRRpx0QtXnp6UHrVmPHPiYv2FNa9dRvTgYEzchqhxHm9U
PN51cR8B7j8cvrOYVx41kr1eydOTv/IWc6MbuKiKvfqxSTpwUTEqRvb9f/XJ
wxAMXNTzRJ/Yo++xxm+LiyggLfRP68dLnp6fF5s4fNYEGFmvnryh60Dx6unj
kTyucZgdi07P4kKSqfjnp+lcfLLCiGxsxwKWrtUMo0IGKhNf27M/2/+PLh7g
YNfIS/7zrkxIOxFtdaJaEk6kqztw6lj4veDVp0YbGg5LR83qFbAwXEjEZHWH
Kb7/sjbtjA0bSUUuwhuMaTiuVvKLGM7GPpvxPslEGn7KPxyc3MLGeLvoRQvu
pph0c5P4CE9vsnUcKhdL0TDzcDO/KT8ba1rFKrdsoqG0R0L2LImNHh9+Ljy7
TkM4X5G1xnqWcYiUNnjtIQ01l5pmdZL/MiaJ3rUHWWY42PlFRrt/mrG8PPHZ
lkIzvObnH3zm5SwjSabgAvcmHQtrwsfKlk0zxp0y9zsS6SiffbK2aPEQw3S3
ltxkAx1FUGFjqj8fOLssz32gQcf6mGWjK7/ywYLZzpWrs+loX5c+kNWxwKgb
nLyQxbbAZ4r5EmbOCwzV/TGbu0LN8ThpaPyjqgKcbDeZurTDDKM2d7OIlkqw
L1/WzFvbDOv2a7o9tpaHsH8Z4rPdNNzZaphZ3qsAp6a7VBdO0zCw9OflkeGV
cMQ2Yt+1vTT0MlPbM/FHEfKPLM17522BPXWhCdtiJWFrU3njKTBHIUGHtESC
BOQcbwi9/4yOq+Vp6wQT1CHNx9F4NsgcL4HzpV8X1WCBwqz7wuvfvsjjdcuM
NOGiiOuAlLA5ii05drw5RQuu2Gozg1dYooVwRmvfjDpslGMShyUs0XNbn/tx
e014YJZDcbOxxKCC+NdvHmuAfNgVuy8eFni5qEXNq1MDKt3TXr7vMcfhOGm6
w091aIgf+XNqizXueMdIWf1cAyJjo8I7Xllg8F7GVbMJDXg+fOrZHI9vqnQj
m+oPaMKC3+0NM52W6OvjJXZtQR3SVRfpybVZ4rocxxaDIxrAqFufsyzUEleL
aqkveqoCunk/NQM3Afo+yEoSXasHSj3380sCzTG2fOhM8HF9ePv4yipPMToq
C9w80XFNDzzr7xIEb9PxxNZRy2IXXdCxF+9esYqOb5qdF7vf4enR95vfGbk0
zCJ/vrs3Qg9ulMmKHpk2RZPpv+cEg3RhxX1urAaRhiupTqHq3rrw3iRctNjP
FL8kORSVDeiAXWxN0MZWU5R2rGgcj9OBI+URH/L6qJhqJZq666kuKO0LmPvX
SEXdxqJHOnRd4NpYXi/0p2IDX3zO7wd68Izbdr7S3hSdT9owDyjrwc6tNtts
LphisbNSt7eFARwZHJ3tbzDFcwFqAVFK+pCZrmcQl0tFT7V93GyOPmTREzpn
ikxxFX+m+ieeP8wivbt/UcUUY93Exk1iDaBL02lLcQIV5980ptw1NIGJaZdV
1YkUfCRgSFozYAienZ+dJ65TMHytRbPRlAGwF3tpUPmo6ON0JXvNBiN453qu
5U0IFXtlp4a+8Lh8ZUdZlJopBYVVpUeOthsCezejaps0FV8tsb1T7GQAZjqv
ctcUUFAoJugN84Ah9LR7rV+TTsUqgSPvHdL0wWFy6R1PIgULzmZoiqaawKX4
TebCmwlY9nbz5VQxY3CMbRHprCbiEsPXD82FKKAnaNiY6qCKrtLKJ6+JMfE3
g8B+6kmG3orO+5LObPx7S4Mr8J4C0K8wk9TOQo0KlSHPcArcTd6vOnCehQMi
goTNiyiwkHtobX8gGx38LXa1hFDhldp4zewSNt6/Yfyb8JICxjbp1pISbOwv
mezZvIoCBbcVzkx/YKF7nrqR8ygZKLcsDi+MMbFcqvb97y4qJG+uMPnkxsLH
ooLjXwSpEBOyb3lmGQudVCsdFbhUuOrjRsyPYaHKh90vX6dTQK7z62g9iYXG
Fq8in/pSwMDvq+8ZTxZ+9Yrzl5aiwJn4y3s86pl44M01nU/dZDjXVvazYZ6n
r0IbLbelkOHUG4Xtan+ZiK/3TJVLUyCW8l76Xx4Tc9UjjUk/KBBz05cdN8rE
/ECHZ5OFFJ4feuBcWMZE050v83cHUEBc+dW11R689i7H2in9JkOSzlD0sgEm
jj49MpRrRwVV66mcNj0WVr2wlnkZQQXRwqMlRXIsvLzs5mmlRVRYvN6+qTuJ
hW2rlCTzp0xhFiYGCp1YqMANdc51MAUjzesXj/Hun/kymbd7nAoSCj0C9w6y
0D93/+3DD6ngqLnJySibhacOPu1pXm0KvtUNudciWMip3b62xpkKn7/nJZ4U
5PmNXbfovs9MQSy6nbChiYVK3dZmo2Wm4Hnj8NlKChvzNWOerVE0hXfrGCyR
IRYuX9L1QI9oCh+OK8SoL2OjYuBSKdVWKmza7jax8ICFfguVr/TbqHDdbSr+
tDYXvVUrrpy9SoTbCw82Rj9hoyOjaMnITwq45J98/I6Pg8TCpZ2avP6PBF1Z
d8aJg0/lpbfdf0SB8y3ikQeXcNHETKspVoA3X4etV27Yz0GzO+fjd7tSoJLU
MyuZz8GTiTLH349TYI9sZ/GHPRwMf3biGFGUCmdOyz4pPcNBnV6bRbc4JAj5
+8tK3J6LpvE7uoV/k+C7+GozGXcObnr+Pe/lXTIo34z++kSZg/PzO6wb7pBh
UjzR+KYBzz/viTcM3UyA0b1Ptf5OcvHC1Z7QghNEyJZsvaYgx8WAL6tv+53R
gdLG48J/N3NRMu1ygscOXdj4eGsf8y4Xs/zm6nzsdcCssSFuT509jgXErrit
T4XlX1fsKttkj82hvmWd70jQeWcx89YVLpz2qt6+Stoep3eu47yiAcb3LSYt
3LFCL9dUr8OW3xkWr64zaw7awPemNuH7gWy41TGoRH8pCYLbAufkqPawCC62
SfOeu8NXdrk/qbeHWHm54oM8/viv//4f3hDmokzJ+p05MoB2Tx56RFtZofSZ
y4FC2+2hYF3UynXTHFwYqdH++x+eEMrYufeGKeav2OHsZcRG98LGcYMoUxw/
N/Y0m+dXF1mFhv5QoKHniafFdyPZ2N6dtlZ9nJdv38V+HQ9iY7PayiPnd1Dx
sOKCi+L4f85HyR4K2kDFx6vbh34VsVG0pino3hkqOveuH0jo58XH3R/nP3yg
4ohF6S/WYw4qpUK881cqbv1wp4S9joOJYvqFaY+oyC8Y6W0mwstHDe6Lr38z
xc3f354tC+TgzuB1VQM8P+lOyLS+mFTF2Lk0g7uDYI4VxnuXJuwrqw32JyaN
8vhDfvMBnQ7TxRD1MzeE88UMi44+k315eYpxYmR4OsLUHHe/SLYwkRtg/JB5
5PLJzxz7p6+03FWfZvjRvros8PSX4cbUM8i8wVjIUAqw87JAE0L5HKHoOWP7
VMKr903mKEGWFcozH2c0vi3pZkxa4ImQ4pY6Qlvtl1WUbbuSzVGKz3z0wfS3
Wr7bKRKZKy3wT+91TvLR74zMcaXlFtPm6LXXI1zhwk9GUn3xobWBFuirmlS2
SLWPkfTQ4n3CMQuUemrOXdfTwJiQKD6RIWaJpwVKo9p8loFbvqTvlhfmqCT5
KSTt4zJYrvTKvVvTHLe6iE2rcgSgP8mD0c/ze537LoVFP+GHWQFmXVaXOZ4J
OTXT7y0IH+r3Kin/oeMN/Sy/ulv8MLDm15M6WXNcKpaf+s5DHpYVL9YMdaRh
ZDvdfWhABd5uuZqetYXHZ9x6FvOiEgySRSb8q83R/wBnccERdfAUF6ZYH7TA
fP7Tcdsn1GE4oKXngLAFXnjntUruqBo0+0h4NNjz/KT7ktPKGaogZK5dKD/E
44vBGshYpQY7FDUiVqlaYtmTnm+vFNXBxLLu8bt+C1xMuvRogKUOGpvExsPS
rZA0oC97OJTHF21WAq6zlijRsF3xwSTvuftloF/OtUSphf3LCDx/qFJWnSq3
zwr39W1au9qb578H0xJyl1ihY0EksS1QG6IEY/vkBKxwtEpMOLVLG7L0Mw/k
x1jisbUbYLmrAeSt+7yx7wUdAxtMgm5U6cL3z70RfcV03H4xvunwZj240v/1
4U0VOj7sf6Ws9VQPzoXkX5/fYob1+onrnxzThcrraYpKuWboo5YXHBCtA+0z
77v3OZvhrXD6h8fSxtCeDjptAxQk5+QGb91AAJ/Lq+aOypoi03n117k9JvBI
2TEnl8czR7I281N/G4Ph3JHInH8UHDw5sXOo3wgYxEAzdUMCntxsLJP71RBC
J3d2tIQScTC6p2XrHkP4LBOyVhNIaFh8cFffkBHs3jC6DfWJmPLH7UknmMBx
irbgSl8i6rKuJekUGcOW15et3B4SsOO12N2DZCNQ0JoSmq0n4L4zSyQ9tY3g
227BLzWDRNzG9hVpW2sMnp7+R6U+kbBdUf7U1RkjCO/buGmdKwnnbnZoJ6uZ
QOfVuAs6u0jY3UOMpUWbQOTNQxNK34mYxnd9lyeFCHZOD9wUA4gopRTmbuBG
gL+3Na5/iCFi75v9FZKZBPh90NX5xAgBc9Rj8jcEk+Bi+LbrUq3GuOFedZWA
JhHyI9okdbYbo6R+z0JcKRG4UlqyvooEvDJm6fIqjwA/29bDXJoJfjjAraau
IUJRu7XEmVYC9vYdXhOwngh9hG0Nsd4mSP+2Q9u+hwij69cPtC41wckGlwdW
Q0S4Pumqwmo2RPW5sWbBFSSYtBR4/2nICPt+KVrflOT5VIJf9+tuQ3ywmthx
hKcTHkIrGjYmGmFz9+mAPxEkUPx0RWmNmhGu0WF+vkQmgv/lsO/5Mobol2my
J/qGCTyF3iB7F2MMveLkc7GfBLZ3lX/eXWKM69ewFS6fJsHNwGN1hTX6uGd7
Th45jADG3/epGlUZo/c1+b0nBsmgYiR9S8uGiCoHCB9tN5FgpkGaMz9sgLuv
Dx+tZ5HBotTlhd53E3zuUR73bJoE9YtV3yVcN8AZe99N0jVEMEkg7HQd1Mej
gpW2f0ZJsETuNuOPjAm2mzmXexwjwaXYJYdyDhOQT2LUjW5JgtSVkUfzC00w
myartniWCGbzMaIfXYiY8cPQ+PFKCsyaUgeNdIzxzfuSlfePkqHE6T5PkIzx
+jO+Hoglg5SrTI5OuR5CfN6fpZ+J0DBW9s72lQF6P584FSBPgX0e987M9Rjg
ljtdLn4FZDiyo7IkkGWEV3YHuauvJINBYkj1+ZP6SNs06KafQAY1qzvPXqw3
wMyx5D9enSS4ulJ1ql1GD1da1X80sqIAcSyud9UiI3S1ThxtFzSFKweH++7F
GGDT25+kKEkqHNr8UiBvwQDz7vx+JZpCgSif8P4j1oZ4SXW5tmUkmRePvp9l
1hmiSZZFfP0BMly4kXIWnqhip7P1u3V9PE4+dDgmbpU6UgRMywR49d/37tO6
bKiBbTLO11hnyOAq8apMH9XQud03xVKJDFPWX06nVaijU8jDtLxSMgzdniA9
z1FA5rirxgXeeMaszrHuFCvhgDZjzSkGEzfJFvqP5ZPAM6nz/rFKO/R22fQu
LIkCR9fepDK92KittKky6J4p1JSI1ujS2PhsrCA6XpwGP2zHZiI/svCd6prU
iXwa+KdkDY/weFskb1zhjwENIvH95twvbDR339SZykeDC9YeuzdtY2O47wF/
Ca4pdMnHZNpksDHOS3CD31IatES+eKH9kI1RE4rFpvGmQP7Oeq7G4PGPz8Ch
bCUiHPO0Pt47wUGC4OxWn61EiGlsrqoY46BeiWze/lEijIVN6JVJcFF3kYiw
93ESUHZ3U453c/DlRdVLKxpIsOzzon46j6ce1g2tm9tIgoXyvAbRHVzMc54w
//SUCOvuPI5IInAxnzrPPyZDgjGnrfYfhTh4575S63QQFc6ZJhMqmtn4OWlH
4+FnVAg4k75HtpeDl9scjhxfQ4Hqqb+GzQ1c7BLZJKarToS4Jx4nPHi8tt/Q
5Pzv1YT//X8FkQShGpNtN0TtUb5opR8fb3zVtJiPMU+42Pnda6mNsi5keR78
ML3cHlV+NB91C9YG+snj62uXs6HSt1nsoZYMXO4R93q/zAT2NVskmCfPMHI9
y3z3X/hc67hLwunGYnv03dBOWWmqBMHta++P7eLgYsPVnOuaFjg3oR04MkhH
0tT5+eYt9pDe9s1Xl8JFYbpPamY+HY1/GMf6k8zwM0H8tvvSztpna722F8xw
UNP2XpnmVXvoVDz9XkyNjfQZbby7joGP1vbUzLGs0DBOS8ZhCaCz42vwyLNA
R0nJRccb7JCm0L3LVcrqf/NiJxftT9z2yv3FhEzvb/suFMwyNpgcSnNJswdb
Work1TYOns5//fN8oj3seLmYXyiXjV+FOw91PQag5G3YokqjwDbZ8hFPaSak
5e94OPhYHIZYPt8s99rhduvM9CPhlhjS9NHJKdUe2LQt/OOJHGxrnVQ/0cOE
6RyViWhvObDfeGri7xIOVIktzP96zsVbh4TdbHayQKPrsvAQbQnIg5/t7h1M
kPF/kbzm+RLY92S1ueU8T38e7b0zweKD1Y+iRS5cs4U7XIrJ4FkqHHalcZU3
2UJO280LaWdNwaCP4jNzyw73u9JEHfItMWzu24O4QCYvr/UnNCdYY3PGEPVt
gR16JYgfWMHjrcE3aNj/mAlaGX1q7dekQPa1hMvcpfHahi43uWOGXLTICUzc
vomOdy9FBg7z+CCu8gA1t98OmXS+3+8kLdEjMvPsaiUmptyqWSiRskSB9zvV
vgELzggl5TkwJhjdXLnGAzkyuCf95MSLSA50fnpUm1zNgMIakWt/FIhAs0n+
/aXWFkINtYpKeX4CNqgP+vqtxK77huM10dz/Wbfj5P/G8TijyTX85GALb/22
6VLlchbB66l7Cx8fm0CQkPG1s6J84Kq+PuacgzJWuJ0QUTflwpY1z045J48y
7p3VlpujMyDstw7zfNgMwzTi3nqxeStodBt+oM/6yoifCIz9+oYNb/0ii7Ln
+hnNx3e97j3BhU1iEXSX/+jxh28zFSKLYEnDkuQVBnMM9UhJMfYV9v/0CzX+
vzjL3mLg1iguBUGuBWFhl+3gzayilNtyeQyMuDKQuIMLnw0jtnZcsoWCjLGu
oUhTuFS1cXHdz38MneFP6TkPrIHxkRlaUT7FiHlyd3lAJ4NnbKbzHtN+Mm58
Cq9JnreGN2/K5iX6+OHQ6adquT9Z0H8STl2cUsQAj8szBHUuiEneK1h11RQe
qRU1Vm6aZ7Rqp6UGly2DkIddxtM1LIgWOGm5QYYGP6OmDbenzTDse6Wu1UTO
1/7byN4Tz2GAoifjyRWfBoZUDemR/S0u5IeGuZ78MF/boCYr7X3fBpx+t7F0
Vyigm5yXMv9PDjg+zHhbystX1d/zfiiE03BlhlDs2Lfx2rv7nxd/qDTHu3qC
1DVZv2tfVlX/fXjQHG9u/7Sxobm7ds3W/rINORZ4/vT7vWkavAi4cRy1pC3R
zY1uvCi2o1aud1z00TILjH7x0cuJ844Rd4r6YfeYJXauHVh4fqa61uX9l9ja
IUt81p523j9eGWTWR44aeZvjvxdnbu1Ok4ewXRErdDzN0fp73J2aKSX4dD1y
dZOVBX7VS+uY6laCR8V3VdfoW2KonXfy6d3KcHa2ULezjMf3iwJfc4zUgRPc
/y11tyXWMPUepVioQrxyBUtdxAo3je1/o/5ZDW4N0w948HibsR8oZ2lqQGgv
eeCVY4mlHutSftapgMgy39eVHpYoYhwkrs6nAVuFNz+KsbfCxdZ6saIr9WBu
s8L6p32W2BZedfuHti6MRDX9/fDcAleZCGQGnNEHgtbzrUOn6fjm+Xz1yG1D
+NXhb9Yiaoa/KcJD2h16cINpT64poKE94d/by+f1oTO9I59pRcMTyT1K/BYG
UCCV5zv+lYbzv31Goye1Afm2FCe8NkPToQtdJ17qwOArS1/SsBmui38w3HhW
GySpycFfNpvhGduz5585G8PlrpiDTT6miD/lfp0wJUF62fvaNVkUFBSksix1
jeDliQb/rbfI+PZ5vEY3kwD6C5869aINcWhGZt5nnAAHX/zduuBjhE0BeSrS
b0wgpdXxsr6vEQ4oq2699dEITjUNHxiUN8Ys1X3v7y0xAj/zP3Mbvxqi0KG2
JvGDhpCk4Nt5d9II/SibzJoVjUDwe2Ksebox+ko3aUZIkMDLdvRLaqwedjGy
Q1fL8vj38w67e0/1MYH+a2TNfiJEJN92727Vw8wYi8j19gToXb5SYiCId/16
zhu9W0Tg6Oz9m3pPF39If3YPNCbCFmEZ6YBYXcyyPGg+rEyG4Th/doglES8s
5Oj5CJPg9rI4uVP3CGhcY9TxoYQI9UZtu0vcSLjTqvPseQ8ysN9pPK/O1UUR
+s8zKW4U2O9+oSApSRcDqt+ZLe4iQ1rhfBbrqy6y9+ZFN7hQYJVpmUoISx9H
lDP+un4iQ3Or7yHSQR20104+TCujQJ7DKf8+ZQNcnv/XL2EHFe6IVQa9uaWP
dIdiOb15MtyyixtWnNLH86/uJFrdJ0Hc+mrBXSRdnHlXZDluSAXRJNrAfLs6
6oVJftq3mwKhjEv9qUJKaHmjQrh4MRmEpyLDAksVUXVfu0C5JxOlpeoO/GWS
wOHOqIzETTsMC131wOcACSyZR1a5bmdigI1I+0UuGbKVbiQW0pk4GWN93l6a
DJpCdlcTeDxXx4zY85/3jdv8Os9GzdlhibTw+0diFMi0Cj/fHcfE0uTdGVFF
ZCA+DpfNeMTE65LHpZjryCD2jL+2LZeJ3/8p85u0kiDgXqzRjQIOrnsfae7f
agpqaa5XL/HK1KnXJpuOUmD5gPvZ1e852HNlxZUQpECT0Dl36Rgu5gi5WmkY
U8BulpFcNsLBfAXZK6cukmH3bYVYmQP2eHqA1D7r8v/qyH95SN4UtgQ4Z34l
2qPS/ZxXCxlEONfqGjQ9xMXXsynZu4g6IFyA6em8+//uVxv3f6wJeqvjLvHn
cXHtzrO/dA5rAXkwBgWaeHrtsOwct0IEuhI3mrYKseBperpot440XHqaeWk+
kAm/v3q5aPhIw89h59uj10TBN6zGNTTBDh7v6lH9sJwMbxYqlq6w5YMzR//p
hDuywDxeN1Z0XhIa6++WXvcygp9LzL7aXl8E16+yfo2p28Aahe0nsZ4IfOee
PLKMa2O8jMHi+nQO6Gd5iHX9VsDhatonHQ8ueN+T2zv/mYlw7IfQjWI79HD4
XBKQ3l77yz7nYzuZC4X5Rr/+togg4ZfqrYuZVlB4TZI5i/ywz8eJy/+PAde9
BevPKM4wvm3ODYvIswa7waf3ThuwoUi7fa6EKwVjGnwjLc32wB93ZBVjHRtf
pkdVO8Tz/OrQ794lCtOMbc/17nCtmMB4Y9jhrCoCkuemSw+9YWOwYqn8mb00
HBdkfnghzsFbQxnBmQ2m6Fv48o28JQfPy9t6hGvS8GuXouS/HTyeXiy9pOKw
KR5W9vH4a8pBl5/69zokzPBHdOQXb2su6j0++lNwGR1zTa+w0yfZKOae47xF
3gxV9pzgmGRxsMMh+uHqBTMUJhBGYjdysKTkauX2m2YoJr5ZdLKMg8sy5R7q
aJjhsFTLmRduHLS2Ply13J2O4qNCnBcpHMwzddQVPG2Ga6u8yX37OUhKXrrv
1l8aFjpkb+5U4OCDyLlAeVU6Ru/klIe/5v2eQJC2cbA5aj8t2WNny0H1qcw4
2Wk6Bn+wncv+z/eZ/n5lqNTTUeaSocXnfRxUdH/ZK5Bjjt2/HnTa8Oov9Ifv
TB02R2LH+Y8v4zmo7BhfXuJigasF1IOc4zj4bd/038nNdJRMrJru5HLwrdQ3
G70t5nh25eudQXd53Dm1gjLabY7qZwWpxfu4GK42EUCVt0SZwxkxA/xc3Cas
ny08ZY7Pw98kKHlzkUrme1238v8/R/U/++kYuHfHK52wVg7uXFgZjWssUN7m
4aAVl4u/OoysxorNcVWt6oSwlD4IKoTJ+I3z+tvbW+2uwPMTM5kmq1jmuPSP
1y6WDhdfavxe/yaXjlYSFvnD6+Whd5nS/8PVm8dTFX1/3IlKqcxj5nl258m9
rHtx7w1NKkSKSkRIKdKEQsksUiIpJM2JpLSaSxQpQ2XIkFklJaKe+329vs/z
vH5f/+3X3mfvdfZee63359yzj/42UX61XR7TdPKeAHMz3xtsUWLh2EywkNLP
R+fibBv9LgYOkIkKCn18HD1jdu0jj/F/7dNmY7Jgn4erSK/RtLr2TtuwMCQ2
vtokQoAqlbNPTCaxUKo6bq/2AwE6rE+usyhiYk8JLpDVEGDcm3lDx+6z0OMQ
u73oEB8nSmgqJWHW6DzgNHmuSIjyAUes4tyY+OyKqr9HjABD1fbQnGKY+GR5
OVMyVoACiqvY9BwW7slmrlstyp+RGlWzPMg2WPQ5EC/sN4e+kZtXdR8y0e/B
bPmFC5bAjZqLD1x6WfhpuVjCNWt1EJe81MPpt8brO4JYKVlKcIF9BgSONljm
kq71mKwG6qsyPtjVMjH/w/d951hLQHqTw69Hnkx0xOIKtxplSKoTlhJE8724
x828PUgZBlovB+XIWOPDkVlKHyaUwCppTeCSAyzMnnvy3idDeXD0lJwumWJh
WWfwhmOqqjAj9kEz9ioLI24YZH1yVYTehxpzS9pZ2PxWcelXeTVYeyesVnaD
NXKCBL/82arw1zDhpiyThXHMxA1J4opw5ERu94Euawxc3uxs+VARNrktS0/Y
bI2EuZI6F8eVoWR0sezeTmvUuegVuZ9iDBJDa8912Flj9acnq1yKrCGsi9kl
Lrq/r+2leiGJptDuM2farYGFxo68cwM8E9jy40vLQLfIvnC6V7KmKRBW5jip
vbbGQw9Ic18/EvHRU/0uWToLXTr26Uz+MwE39w1Pg/jWmGJXPmuTigl8XOJ/
3SLbGj1nzC/2GJhBQPIRn9RIa/z+olv684gxLIhP/TQaykLnDs+DN1hGMLhl
AXPeXZF+OxG3/amrEYSH7aDGOLBxgxzDoMrCEKQXcNplStjYHv3B79FuVZiO
h6xnl7noEvP7l6SmARwxTy4DIgejC0eNt24wgAmpRTnRL9noPGy8cc2wEZj0
i1JTGg1LBqjXR9Ybw2G5hIKlc+ko+GId9MLaDKhscDu0lobv3xd0VHqaQJTV
zl03JelYCTrm/Xqm4KeZFHQ5lo7GJrMYRrNE93N1osNYn4GfYg+XGTWZwp0z
pLtZ1nR8OktR6o65JQTRjF1X/KLg0qubpT/4W0C1OeHW1VSKKE9WOXUGmcOl
0Y6ZxbOo+IM2Nf5yygyuPdWSX3qLiuKrdK+K6xMgVL9zVUIdGTG/8WqulhUs
l7b0z/pCxivn7/pH3bWC7qmIiPIICursnhL/tIwIkfzvL43sqLj1jVkmN5oA
VcE7//bMpuL7s4wCHzkCRN57JJTrpKBdZr9rSoYZJLhennVPi4y9TU0Lhl9b
gH9tkUTnA3N8QVSWuy5jATccRw8kipvjtk0hn0M0iKD+/oHEy0AT3Jl+dwHE
EqFtbcFC+1pjvKbrHai3hQjzFto/3DJghLSEsTz3IyTIvfRTK6TeCjnf6jqM
eWQgPNh99lSnJf7Jd5nMekwCzclbxwTjlrjFUsDR7yHB8VekY9slLPH0isdu
38aJYHXxk/y2bCuc0ZputEwkgrOW5PqRFQQMLYw0j+MRYWXqb/HGrwT0Sk9p
W/mAALP37PS2fUXA28qnZ1s9JoJFMsbpOJJwVeyeWxvdiXCgY+jQo8tETLfp
G9RWJwLDOmjg72oi+pYEvlzpSYYDzMuJGRmGeNDkvpz4UQrEVgjoTLYRxue+
CL06Q4YvxXUvCOmGuG+JMPDuTzJkNpQVm3YZ4Wblp+2HO8hwYq54vekcER8+
iDu09DAZ5By/ZL4MNEbFVfoN2xdSQSVS4S7LTR/brri+7TxEgRd1YZ2BYcbY
W/ze8toKCjQcz9q2T9oAjXq9HEdoNLjx7Dm3eI4x2nodf2/ylwwr7uWeDL9q
gBzvy/NDXKlQE22rzBs1wv4UocyddgpM7zlm/+KzERppR6rUSZJhlLLe/ECk
AX41i/vWE0CGifYTsU9M9HFMdsIwWTTfZTZnQj9t1cek3b+G9HeR4EtRmfmE
siF+7pxoaImnwCHThLCis6aoz6xpvfqVAqR7l38erbVAC98fi198oECvc+kF
G0NzpDtW0E7NpQB+cJ9x+2mOPsphC+JHyLCn/Wbk4gkznPI5pLwkiQxX/sz6
5i3yL3G3r/4HL4nm5+q6EzhugVtSG13m+lDA7us3fvYyc3Ra/EpnLIoCzpYT
r14KLPCgZ+x2yQ0UsPWSSnSbTUDbdy8ed2ymwIID/6aGzltim9wLNzsdCpx5
5n76W5sFzvu5ZVdQMxkSzszZckjJCmWqTotp7CaDas4p9rdZBPyiuc675QsZ
zG4+GFvzjIiVbpY7hUfJQFvkvkp5hIANFu4KK13JcO8TV8IpkoD+xJkvcqL1
jmlOnLtnLwEPe+032kilQH7j0OiYLhGZrx/fwlzR+vOJf/PLtTGEOGAVN04C
+wNqJeu3LcEI/iOvOlky/Ggx7QhYrYE7FforX6SK/EduOscmQBP3/FjZxO8X
7V/Hx5sTz6vjm/XDrh47SNCbP0wfl1iCi5K4yXf3EyHDWMz0KVUWY51C1cJG
ebgqbv471ydE6CmZPCFcZIdStMr79SL98Cl07G9ZAQ8PRFa6cAgk6CzK+b3+
Iw/3B9hRJK1EPD7DOaVjaofjng2HZCfJcPeUf/G+V3zcrMjR6/xEAbm6ZSmO
6XwMjR/cdPY4BQRjGmnp0XxcULJC7D2ZCh6OD6qn7vFxvn/2x2tr/uf9/04q
xBReZ/+UFaDcWEoWSaQfvOT1Qood+Lgozb6qr4kKzS9Nll3bw8fdgdVSW89R
wS3Qdc5HqgADxIwHh0U66WR8TnkwCDA6YDzv4VMSLE/cPoFSAsTQtjLyPxK8
GfzrTMgW4J/7N3bVBoj8NvRrqaGuAE+Yags3rCPBJ0HAg23hAjRY+75JSxRn
kn9UjGpdFeCOf6yIq1VE+Das9H1OtADNm7KW6M0mgfHJk7o3f4van864rmpD
gpmu402FYkK83fVe7eQ6ItQlvlOrfCTAlKVScYv1SODo31X/u0aAQx5Rx4o2
EMGnrOThjnI+3g593k86QIKRN8QqDRGvteZk7nEeIYE+/72gbLUQ1zfpHl7e
p/9/52ulPtA/n18zS1KIcrnrD1mf14O+4lWbA9SFaHwyyyQ0Th8WpK++cCVA
iJrcEH11qg5MlQiCxLYK8NivbsdFSw2AYjZ96Xa+AE+3nj2zytcAFn/2vm+7
TIC3/snerXmoBx5nSvsqQgRoWfq+aHGIPjzq3py3ykUJUwpDFE8N88HiVMH+
JZF24DOa2f7q9mzIZR1MT24jgIOx39uFV2f/9/kfDbbvsSHKi/+wrd4Z1ZJh
JOLxfSNjK2hUrDIJX/sxjo97Si2Mly2g4s2l5RVzcvi479YTGseGiWsSc/Yd
3iDi5dOMUbsEFvo/W3bTdZKPQc3Dd3dn0DFdIjbttqcADQsFRz4o0LCQrn+b
GiDA7I+zDIsV6biCMC/HV6QvBte0ONkfpOOyIDKpfpEAlyd++Cz5loYrSM+O
Uof4WICb1YKNRe3Tug121Irum+bPzR1l4zB3ebN3IhPSWI0ynvIiXv1qLpa+
3hS+cd1DCkT6Z+b1w7eDUmaweb4io/0hDQtuR52wkDODRxL5hNw4KrqRG8U0
Mi2Au0bpSlLkf873RxU/0iSCop+Eq90uCjbqDDiuDSVA/w0z+cI0EjI9pex+
ylrBMtniyCN2JLRyybdc2W4J3cr9ssufElEjZM09MxMCHG/7N3H2LRHvHZ4v
XEYiwej9/LBGMhF//qY1PmgmwYWW688v/iQgsfejXUsvEQ73q2+WuU9AX+PM
CwtEfq92qj7fuYSABvllzzU7RPl0mqFzRIKED6zy2FdoZAjhVL8+HUnE3Z1i
vhIlJNCr+TwnMJqIMsGE3o86JHi8+9fF7NdEnL1Y9cSMHxnOrL0TXzJFxAs3
6nlNdmRoN6alTj0g4w2t6DJJJQq8vvT5+IVhEqYSRs+d+0gGbkHVAdmNJFyf
/GHmhSievzN21OdvJOLqz9WPZr0kAtFr5nnvHiLyO6oWv3Qgg8mkTmjFV9H8
NOxmZpmRocFIimoQQsLb8hXj4yEkuDWx6/jEBRLOLhloVNanQrjvVT8/UxJu
jgpds+wKGSLXuu4Xf0rCayYvl+J1MvxaGqOyxIOMW9rtFSRfUMC1WOFDy3cK
quiemWgtocDcju7MWR/JSIk9Q5K3pYDwy1AiJYKM8cnx5QWjZOh+eT6cw6Lg
qa8bZPPmUmG5+X2rQikyBudXTOT2kEE8Yamr7xMyCjwf06cTKHBsF11JVomM
4kuXfo+lkUBlOqMqEkjIZ7HIBXsp0Jc2mtitQULfpVt0gqopMOZ0Y+WzTBJu
lRyRMv1IAWnr2cdP7yei89c8sxfeFFhduKrybj4Rr/VqlvpOUSDE6PN3k2ED
zN/NevNbmwrEcoOTCWOGSGbfOVupQIMrzdJdJe8MkMJ/dmvuMSpIssCzwdAQ
r108caftBxVePfmS7jZpiC2/Tm7Ov0AFhRrS9IZ2fVzSn9LS+pwKc5fvl5pb
Z4T6p0mu9CtUONIr9dskwgRfnipUKVtEhV9tKxXWapkgjZIerhZJgQdSY982
kw3xdsGtpn0MKozZpLUbmBlg/Npz39V20GHpj3OaUvt0MZQ2/13BGBVeTPnc
TOjRQdPjO5RunKOBQv/xyvdjemj6YXlxpyjOzyt9We2xUg/T96r2plBpsGWT
Q8iNCn3E+cTTVVo0WCU+yjpyVQ/H9nY/DdxNBWNB+KxzKvoo7+zq2+pFgc7R
OpU7AXp49a914lHR+uf8HXBs/KCLazn7dbxMyKBpzxkLTtDGlJqXERQ+BT75
fb5y65A2upq59O+ToULCqULfnYE6KN551Zp/ggLDTkH2D+11MKrhKPjeo8BZ
H+r8LTt10UB7ZnJwCRVMxrWc/b9o4jJzK6brKwo8n54ZWrJMG1UPH7j8PpcC
3TX5jOhHmjg///RHgWj9WkaGSsBbBe9dl9qpIuKnrBUjS3+5LMGwg25D19oo
MC8/+5HtNj20MohYdd+RChaF/DhGiC4eCr1gkTBKBPvdrUPdNYootBi5ZvqK
h3+qljBzvhCgtibuXVY5D79mN3x5s40Ad2zO5vg58FBjWwrdoYkAa2RnJt8c
5eHGxgASoY4A+d4P9iR48VDxaP1Ny9dEOJ/kYCbpx8PHhKGCd0uJ8KDkqf6+
1Vxs6xQ/pHebCJm+d7dHNXOxrr/uV+IwEYyXhjUWKfCww6m1/t5uInhxI15K
avBQQuya2b35JLhz/8e+TSVczPujzeDJE6G0KO/UvvdcnLV/RF4qmAiqvnWR
N8e52DqutsyklQCSCuR+PMHFx3I9nzMyiJDWrX7KbAkP8/9+LimbQwAj7sEO
W3UeepD48xgHReWjfrcbPHgoWJlz+J4nAaaV3FcGneBhr2XEU9MvJLDrDiHy
CXZoJ2f/fjyQDAvLBCu1J3goW7s0S+U/39d5bHznuZ8dGocd3FR+jwwp72ot
n9znIen2r0t7L1BgscE5yTMDPHxHVtfKp1Dgu8zboBMCO1zgeAZ5ulRIf5b5
YsTQDvUSSapPRX7ypm68Vy7EDk+R/EaD3ClgdPy2H/2qHbZtMjofJ/KDM0vr
u87vscOZ0e22lW8psKHh1ZHG63YoWW2v0VNFhZ3dfwzHZuzQnVgU8f6gaN/l
Cle5iq4nbOAGoTkVks3NznyJsMNnjN3ftSKo0NR4QSe7kYcFDFqCeyoNymus
hqZX26GD2MEXpjtoYKpIFvxnPL2vYotezlCh5UwW1r+1w0uJq+tLqmhgdrog
WOuGHZrdNSAX29PAzcvOb/t8e/wz+ekRx4oG/Vu5YX777NCjoS/CbRUZzlU0
Ph74xcOY2PDPfUpUeDfRq/pewQ7Pko/dDXtPhei72R1x6+zxRZS9R7w6HTrK
Xst4h/EwdoCj411Chc7T+w9kq9uhG/tsU7+faP4KqAuVNO2xJqD3jwzSYHTt
rLk+fvaY7bilDA7SQNHqSNeGUh62XzSyPGJNhZx1RaZvTtujiaNnd8NnGhzS
mAlY+8EeryhFmfZfYkDm0c8JhBF7lJ7euIt5iQ7GPV6bfN7a46eaiyRvSzq8
L1qvoMdwwNK+1xG1WnTYTfrlK+5kjzG+hU/of6ng3JLl9seCh3mfxluDrlIg
72GrbecjHi5O7f+T3kKF6aGBFZ5F9nhLXt0iwp8GQSHeVc838fCfHIgbqVDB
t9iU77Kbhy2VD/YfOUaBW/ZqreaDXFympaQWeZYKSZvbUmyJPHxWlvkk/BwZ
KForSL+teChsdPpZdIAK1Xdepzzm8XDF8RU/Oo0pkOzBd6OZifpvypVZE08D
vaF464/xPByE4kWHRTpTmvpMqPuYiyvmyt++okuBCal9L5nAw/ivXaRGcRq0
dssORc/mocs+zyXajhRQ2DD+4/YhHj5ROt3UHkaDNc9jHgqec1G9/9+kTx8F
5leo5ucP81DO4PXCFcY0eLJipfrNXTxc0KGedK+YARZ4L4Z+jYdSp561FNvQ
oEEiwjgpQ7Q/dT/diEmlwxUSy6P0LA8jU/IJcdM0mPDyV8525GFl9cynAnM6
PFgzcEHbnIsJRV1d2cV0WBdUmHefycM5tTOe/lN0OFhLdSwt56J7C0nN14YO
dR2LtoBof5vIj8dty6GDT+ulfTb/uHg96GuPcB4dmH+jY4NfcFFRZdtu9BLl
hX1Ze8xE8aQiPcq5WNT/Bbm967NecfHiAZ/Nnxto8CE403LpUi6e0tn54HUh
DYy8zq29G8/Fp+IypZ0fafDmtEmA60ouTp2gWh0g0MEk+baifioXHzI0m74q
MICvufZYThAXzX4dNi4upMMdz3+72vq5eLBTIn7OdgYEtF3SeV7BxXcsl17n
O6K8tyDnUpIED83nyu0aWMyAe6whut9bPv5YJu+jJIoP907xeSS+SB/dcJGS
G6ZA+aZRJs2Aj7/VPY5a+VAh/vz17FPtfJz1Ry6NFMKAeItdS0a2C/BmfG1p
qihPbPuX4DmpLuL55nvGS4spsG6b8bXjsQL0uJ/5yFCSAiP7jV+vnSfA42Z2
Ps40KijTUhIfrhCg3a0ttya2U8HlC0N3TrAAyWPymttOk8HmQ3DbBQcBWrMS
L1sxRZyS8vfIgVYBZu7LSrvaR4Lnhcuzx+sESBrISXTPIcN8pVti2j0CbP45
+nDDDwJku8NpBwUhvpz3UDb8DRForTpHHXcJ0SjkApx0IYJh39GLYWVCfN4r
sWOfvyH8q6U+yr4ixET/73WdHfpA8nkoUflAiCMHzO33PdGDlI1dypE5QvyQ
xL78OEQX7pYPnF1zUojSL+o615cagPPUzm9Pe/57XkrFAPp4C1NG6ULcGy2x
44mGNiy70Zvw9p8Af/3UVr5UpA3k83N3J0kL0WV79P1xXV3oy43PK8gW4h2T
xjf0Mi3IHO1PsN8kRGr87/q7PZqQf3J4x/btQjy+rvB4roc2XKWudhKsE+Dt
BFuT6DpdiOFHZAzPFaBFwtawGJ4exI8rn5t4x0dN6Zt6b6n64L5q2RyPDj4O
bl0UdU3TAHwkclrpXAe48UFyVwhfFuJ2L/5Q1m0HNW+aRtdsk4Hm18ZGrIK/
tsY7c3fc53HAZKq7OvkhH5esud+ZFERD43n5ezY5C3Dvth2GHqdpeLJzfeSM
Cx8rdeKGHdPZaOD7g/tVkY+cr7UMthkb56ac5X1ZwUffqrkrn320xjXpad56
8wW4dM70eZ1eawy9rEe9UMrHd786Xo4asHHF9JeVZ5WE2HkhYtWyL0wMqRIn
7x7QAO+EtpYD1dbYcpq/d+D+EhhxWVtw44A1VvPTHduV1WBVYlXW3D5rHKPP
cZN/qQJt3CEHVT0OUma8M+UGVGBp7zy26n42DlZ0NO6NVoIHYvdWVmxgY+JQ
h3L0VnXo8vhsdeADG2+d0vu31mAJeGwjLL2yhY3n30j3pgSowQ7ebeITUb3Y
xw0trnWLgXTN7drWdRwM1dxlmVQsBw05+2c8K9m4J6nJ9qOnAgQ/PxkV68vG
Aos5VZ07FGHFkRsaUQQOqiYGih9ZaQyDcT6q51zYeLt2/zfHFRT4+Tm07a0m
C2Pv6Fnk65mDiVRYy5qPDKy1PidJHzSFPYNRPmOXmYgybasKu/RgU26h/row
Nm7aMfTN8IIurL8ya5nkCBt500sDfExE6z5rU43YDg7ecHtoRVykBwzB1+Oy
oRzcoH7HxM2UCCsCqerpqSwU+oTaHXXVBSt+k2041wa72wfa1wfpQhc7/hO3
hoNtfu1LV0XpQfe3/WfT5W1wRbburVsUKmQL9frrh1i4rMN9uL/LAlLt723U
aGdjdVTT4lfNmnBb+9LzqSQbzNoVVPeqUxs6tuQ5zEcb/Dn7m2J0KhtW57l8
zPWm4JbizQbK/hQ4WWO1wI7HwZE5pRmbeTrgiDXbj0XYIuVv1a5AOwvoT7os
MTJmjRp+Zq27mpSB6lDu3i6Ko4MNRsVDEaK89OjR7K87Wcjwa9beOMcI9t84
eP3pEBsbXhZnLV9rDd4/7unpvKfi2hHGkZZKOmx+Za8lt4eDEpkRBnI0JmzU
d7K4P8xGfeadLZ2LLOCWVI7Z8BgVd1/Muqu71RyCBtMM/ENpuMltS776HUvI
9pLSdW+jYpP0RrdvrRYwGJa+J6CKiooT2XcenbKE5AsFu3s2U/FIc+P315ME
OOLx9+hgPwULSFVKt+8Q4O+VFhnNGTJWBS1Obhdx8tZfQdmPQyl4Nb22KEvE
qSprhXney0m4Ua+urVrEzWlfrpvOf09ExVc/TBdNE0Azq7ZheIqEWaB8pV/E
ofqHyGRvLRJWr6JobdhEgDeOmau3UMlIGudPXvOxgsqFbUn6DDJWBzheDn5E
hMlN62a9kyXj213XI8wfEOCeB1+r9jAZR83/mN40tIQtJT+CbN+R0GvJ/o/3
g4iQr2/x/uIVEhoUjiXfWEeE+Iq7EEIjo7KpeXuaKQGWXfmdZeVMROsoqy3D
Ik5uilQqUGwmYGFRHNFmHgHeSfSrZTqTMGx3i5hulBXYHtfuV71DQkaOW9Ya
KglCVs8bnzCg4MDFUYUBkf7XWuwye6srGcuXP5hveVCkZ6fSPr3YTsGuyFUe
s5gijlofGJLVQ8ArP5PyO7oo8Cfg123mRQLOFpz9KbODArojngLJ/QRsZ8xx
eSrizHNbojnWZ8xxsOROn0UGBZa9c3VjO+jjArL41rDfZDA+qZuylaCPKe4b
jI8XkIEUFXXI86UO/vpR6bzZnQxjAlbe2Fo9jI5+LP1dU3S9VtQx9+u6uF6s
vc3YlATjB7Ubg4gq6Dk8r/mgLhE235ScMN6mglmlN5++ukiEz53OdgaSqrjX
ZMgsJJYIsWT6SzEpZaw8oiDV7UCEVzON13p91XBL8tdbS51E5TAJKX8DBQxb
tOmXjJEVWIdf+exMX4KO+58uqPAnwIovnU7ijmpos+2vws8oHq7f5AetMSRY
tzVdcvNjHgYQU99I65HBf6GN4XodBxw+/Hjjslwa1P2p3pt62AG7fX1uxK5j
gGnDnvp/bx1Q5lei/gEqHQot9o6vfOiA/w7qeHdk0uC9lXPetzgH9I3ZeT1c
nA7za3J/qpH4+OEAKORV0ID67XR2UpADftILo6RcoUOj7LrW8zMO+MHsnwdt
Jw3IOs07wywcUGsy8onkWTpMPXbhP5F3QO2nf/pKGQwwjHsRno4OKL00Ibq0
nQ7d5w1CzGwccK9TjE39LCas6XPxY6xwwJ3/Rh+WqTDg7yMbn70Fov5ypR//
iKDDjbs1rzss+Ojzl/WgjsgES6oSo1NBZI9Nr9LTKyJe3DQ161SPAx5O33jJ
Np8BW/NVfWzuOeATKWk95ZUM2EghSFTv5OHhZV460b5kSNoYVXKOKuLv1UYa
afPI8Kd3x9ZXIr66dkvx7qVzJNA1qZu2n8PD/Wrliy8oU2F1Er3joohnSWTB
8ZVqDIhNmJxa7WOHLO2q9m3XGGAkZ1JvOsNDscd5Mnoi++tvsp2gmofXR+Mc
3/ygQ/C8HunMvzz0q3Lb3eBIB8L+ItXZT3lI6R7aVLWGDumFj0bkZvEwY93J
Tg01GixzKvhNDeTijHHZ6yPXqfDw9Zm1Zy15yCLdbboZx4DK/XlDUp1c0b5s
LNnGY4Hhwni1RxQevqcXcqqOMOHpM2w3tufhWJTAelScCbtXh8dZivSN/LEr
1o57meCjFSlJEfnT3HhHpyJtJuTNNbSZ38LD4X9bipxrGVCeffS2/2UeBq0i
CYk7GZDkFeWiLifimyfarGP6dLgtNJSiGQtx4ZVlFZtLaXD+64o8A6YQbwyG
Pq+vI8E+vSXtPXOEKPPHVFv5IglOx0m35r0Uor6haWvQoC4kZlvI3uj4L08R
dOApv6vzymsBrtaJ8PpprAsZqwbmPuEJMTmoVX3TuC5MFjGGc5yE+IB+zO6z
hO7/fV6trQ7W8W6rV6oI8NGVzWEuu/RBhbYoOPutHfxM+Fv8nbgAdAJ3HY8S
7fchDxvtwnQWhK+XOqqSzEeQs/xL/UdFDM4ueVnJR4/4+gyTQ1RsmBivbzQS
IPN+gRfBmYoOe0OkjIZF9dqb8yM5VDx6XsvYfqEAk97eTX5AoGFl7r5hGxGP
aXWvWxfwg4oR7jOq38wE+NNjq4nqcyr6ir3btHCSj3XiKxViCkVlj4HIu3V8
JHz9ReIdskZDs3Nx78f5mDV6/uleDWs8dZk/cdRegNP79izXDrDBe4qBfcJd
fNz9rvndfQob70gJAy35Qjw7OKC35iQD6VrvS/TZQozfk6xtHGmN3YOHW48G
awCnOt6RJuIf0j3ree/Pa8EG7TsG33+zccFJXVYQWQtk+VmaZUfYaJrvsrJw
tzZc91ijM7aNjT3rxXtG5ytDyJ/FRx61sTH5prbJ3ng58KXqfPSN46CC4Pbr
d2xlWDpHwebvRQ4aTPvdD61RgNduKpEurzjI7H3m1FavBqUZ9nfFWTZoX35j
2fyAJXDZ4mRdqej6q+4ktawmGSDMb7ZQ17fFAr0/E9QSFUiJfb4xQskGD0cl
GUR5ycOjslTvjDQbPJ4e/szivgL4eJ+KGRTxi+GZxAqb7QRw9FJNTyxi4SDT
q113NxnO/TBh7brFwojv3xLufWcAxcdq6EwDC2+NVazYkqMHOVbnCycEtnhl
/9I91jvpIFn0IumGujV+6q9GtQV0uHjj1p11mRzcPWf6xg05XVg3ZLY5r8UG
n1m0PvN7YQVKSi3+jBZrVCMYPQBFOvjL0SWcTrHwmtMik2i6BZyCbWoXp1jo
5eWS3KlpDngv9ai1qTVuLDg84wjmUFCo6/QmjIXNCzrYs23N4I12ZGhFPgM3
D5cmR2iZQeCT2DPXjZiYEdPseJJsCvL2q6F1KRMDDKZiQMIc7lsH/D2xlokD
vQr6r6VNgfnjgwqllomrv20c2jFqCmH7lUJt7FiYN/PE7nyRGdizu3Ve/mKi
cWvevvNJ2iAn1KKf/8LBU3nn9Ax0RPn22djH6SMsNLDZ7Wauawu8XPKfWH8K
Sqf9jF+tRIRrlVJbcyQZuDt1TLwikQC8P5HH7Oxp6Dvicb5pWsQvn98Wk66S
sMvqeXTXtAUsSv5eqOQkKv/OCK/9ZQ7qgu8zzu4kDG7zjPjwywzEV0v55n0m
ov6PBtdUC3Nw1hO7Jx9BxHnz7Y4cyzOF+c/rW/peEjE+SyxmQY4pnBxN4457
EFFjMMtN2tgMNDyvCQ+sJmHv6RNWsMgUblzMpFw6Q8IKYll09YgpaEr8O+H5
goRLPgWuslAwgcN/t/cMLiNh0j/u96O/TSDHYtKKpEfCtzudWj79M4emfX1v
95HJuHa/hTyPZwFbR09eN35KQvalweOuDUTg87RPn7oi4res/LTMvUQg9p04
2CBLwdleBTJrlpMgJa2Qvb+UjA2GljfPPSIB02R7pbg4BWsGPXzWfSLBpX9/
/iw+TUUYpiWfuESCj8/0PdrrKciucxvZ/oIIikHmekvuUtCtayR1vZqIR34f
XbvLjYx2tr4/i+tJMOw9RyW1j4Rb+2t+X1WkwZGcadl3G4j43IvhsO8SBVY3
f+qPliFiUcm3LdbLqVC/yaqEc8IKD5VOiFkPUIB/4uKcqU+WmDL4PD98mAqJ
6i11eoFm2HDSg2VhQYaTxafeXZTSxYJjy8pTeolAPdka+pUqj3fS95xv3k6G
m49sC9zNFXCP/PctZwtIYDrpruHsroCODmlbWsgkqD3Uixt3KGC67JG/XrtI
cHjLagJsUMJgsTuyFx6QYPDBcfrUoUUY+2a9WgOBBM9o2w5WZcj89z2y//cc
yrcHs280+8ft5+OBychLD71oELGJ1VZjx8cR/kSNuCMNUHLBN9tMPk4ElH79
4EYH49f1Kt7tfCxmlclfD6VB/3QUn7pTpH8rjlk+66bBGT9OamQ5H18rJQwe
7aSBVMULf4IVHzO2d9J45XS4pdm4IcaVj+QdS+4FiPJvnYLfxb5rfHRhVCcf
odNgSdCOa5d+OOA7xV/hq8/QYbTpy14FCT6u+zlp16zHgL3ScyY/B/Fx1v6y
P3mhDNBoKBhdZsvHkKzm46uNGRBilmUxfkjUPp/Gb+qmQ21F2sjfQj7uL18+
eJfHAPPkQZ71Zz6uv8wl766iQ2XMkbWvlfm4LSzWyt2KDt+vddxLihKg11kH
s3uaDFAuSPWSaeHj6jbjs7vt6aBBuN/wni7A15SY1Hikw9sB2m26lAD7TtbI
tCkzIIZXqfGLJ8DKbVb3JLsZIPd1W7VtjAC/Om32fDVFhVXGnL6y9QKcJ5ea
mcemQ9WTmumwdAFyw0sdf2bRIdY8WM1+uwBfjBfN552nAeO6/elSRwFuSJKJ
k++ggsG+dqdqUT62/OG9xonLANUTdss2UgT4dh6v4ZSQBgpXI08vIwlwZL64
0fgDGiSPbbwmdtoBm27NV5uSYsKO3OXBO2O56PPM+dmDbaJ9khDqePgsFxfO
8147Ik6CYtMN5htC7TDqccWakjI6lDRzqV+V7VBvKs960yMapBV85PKX2qGh
ZwTxJkXET0ndU3+y7bC/9+XLPhM6HHqlks74Y4dZ64zWep+gg3yw+YEiLXt8
JfXY4BaNDpR7Hy0ZwXbY4WnxZlUrDRJ9y9wPvbfDP02y5koiPv7K/Hvp6GUu
BgkD7T62U+HoYXmlCpF9F9MaB1+5UeGxRtWNjeFcDKnPvMa3ponGe9oy6MxF
6y+/V5inUEDR4cg1a08uXu5jFhK1qXAusvpr5VEu3hlnPOt59J/f3ZTOx28F
9J0+qLuPSoXxmsvmu7oB2x2ier7mU2F6/h6LYGMuHvxzeP6WGCrsCb54Yfw7
4IuzS1cbtFHAepeCt4YSF1dqUmOe6In8u9F7Y4ULoGro6saXAzTwzs6hh78F
0X5IYydM0GC+9q7Hsou5OJXSlLqXKOL3O202OJeLtQZJUjaFNDjYw1qXVA44
Z1vapIQDDdIP42qZSC5aiv44K5jg3S4XnWRkh9WnnQviEpkwYaUg/0rNDncY
Zm4fO8UAdbvQ/aECO3yrPPRsvQkDitf1mHgttMPLazLdcpWZQJ5e9E7N3A5X
Phf8sLxKh1xftfa1skI02ApmrqvIoPPzsOzODUI0iUpqb1pDhu78NM8t64W4
Q7irRzgqilNzlyZc7BOgf5BxcvRCkZ4ZO/v1To0AT17PjzoZSQP+0ZZF5ylC
/Lth3t6sUMr/vM9AAXXmoI1XlgAf/6XZ2W2kwUxCaLbUWwGSTb5TbeIo4PY6
R6xEWogTk/LfRgbJUJHto+RyRoiXZt/V8LhDApeFYya7mgWof2gyhS9DgSkz
CW6UqL5ZOqqjKPN/xjtKhl+C2sfK/3meRz+2da4nBY7/RHnX+P/wsfHq1+dF
em18bL0fVYivJ597tLmQ4Mov7ZCheiE+kpWNkARtGIgSO7G5UIidmheNnA/o
gLTYg0XkNDUs/RG24E2vAHo1ClajLwUCht7Kbz8kC5fVDgcJtjhA4OyOkk51
AuSWjm4ZSLWDzsPqOrZDi6GB0Jiyn2oPkvqaS5zXyPzXXvP/7/xU9NOLQVuZ
Yij0mxjvX2oDeZkP32y+whXZVaf+y4AOKesFWmG132xj6moieZMOwHfifFv7
jAsfyaYHvov9v+/bWMG1Q4THhpLjtoc3rNXMogrQ+8+pJuVAa5T2C1zldVuA
VxfUFpdsZeMjfU8zhS0C7N0p84+xkI3pwTpB9o18XKgYmNAczMEvhZNv9B2F
uNni+d8li5lY1sKT4IqL/OPSFrOt1SyMVk6Qo1eK1qPiGbG+lYUr3zpUxQwJ
cMEtNjPe0xo3aI6pZUoIMXXh8YiNUmy0+ZKyrntQG1I/RLeI63FweUb5Zpqu
NiyysqsP38nBsX2nbVLqNSDwz+1/I5s4WP8lbn1HujxMN6zRdtXlYEVmQ604
TxaiRs4qJahzcHyHYXvdASnoWKBiqvLbGglbc+UKTRZD4SmPvn95Ij5vXqj+
OVAVyLiDa5vHQfKa29U0ZxlwDJlUGrOwwd4zwa7/eV9srS95xbVsa3xfLztH
6bg1DLAsy9cM0PHOrUUS5x+SYfvdOe9apqxx7r9FpOPh1pBxz1FZfi8dfxsb
6rK1AaKYmXeovmTsW0X9HsSyBVeNsw/TVah41cGpZn6MLcgE1NbPvk3Bpnmp
s2RyOXC/et4Nig4Vj5WVNyVGcuD0XFRJXMVA71Sjmw27bWDBju++d/dS8W5v
T5KcrwMW+J1xu9sK4DFLWjI2xRbi8g1mbt6n4d+X61ycDGzhBnXwehqfhupe
P/yEa9iQ335x1ooiOibEvA9UuEYBjT3jP4OT2PiG0Vvlx7KDJuHQibPBOlhj
cGDr1gEOLIrOfyX2nIFhgUy0CKABu7Di2exHHMyu/1CYKIrLq5Wuv9A1tEZP
uesVpqI4Ts75/jJOhYnJeb7J19/Q4IRS9I5IFTbSwp2qXxUwIcvpQPLxYzSs
0zkXUmQNIMwq1FwmTcNUQslP5V9kmD5W05lcyMYjxK/u09UsuD4QfmvJSipW
9ER8vGAOcGW1xbXwPjKGhyeXmfhZg3v/7bWDERR0lborfvmCiN8+nzqzI8Ia
hzd9Dr5dbgszI74d301E7StjHDresuGt3rZofqElJmjkN+s4coCRlOI83kFD
nFxUvCaIDb1me+V3zbXCpy9bR+/qc4D0wevOsnkM7HRLDb98mANvNsjNv9TP
QIfJBbfLuTbg1aDCyu6j4bPb3G6FcFtY/4LNbOtkYOyd74zSEhv4+sPyid6Q
iCfvvL02zbcB/ayJIy00MkYXeIpzqbawsnMpl91OwodmCYdZSQA5r5Nu5nxh
oETYStUX/XTYvdGerzKPjTHrgTFb1RyuLXi2YZRpAC/yLf5uDOJCtvjI09E9
0w9C4nLn60XSgf+a//vrIjam0Iqav1HZsLh+4+UDhwi44qCG/tlaa5h1NW06
NJiKGavYmxeK1iNjAaP22SU2Bnpsj7+tSoYZavWnBAk2zmjbrQoTcdmd2R/X
vLzOxoXlpm274gGUzkrM7fw0BxccjM1SbbCDV9Nx39JjVVFwJTjj2y0ePDSZ
JpntNUR4HG2z2ooL8z4d2XDs09gDNL719VQCD3atXuQ/N1UKL6jKrVlfZget
nINZP9w0UbayQ4zG0oAOZf4n72AJGG04feN7GBfM7WcZT+MCTD+3q+ujOg/u
vyTMmpehi92n26KOpAHURT4RP3aAjK28E+Fz3ujjBX3mphEXGlyVC/vnFGgO
CX/36J8h64LRzzLHlm0GMBVoQeAe04R9GTHXTqjZwdeKnnP+ufKYKW3+tyeE
B/pmX4gWb8TxyNuAjkfJtjAv5mZEVhADOUyxxCsnOWByrZuUupOCTPbiVfoV
gOOKRe7NtWxIfbqiae5yA9T4a8DZ2ibiD8Iy09LjXBjvK1zx3no2rh50nTX8
yxa+nX5d+UGCjj2KEoMnlrDgvY9q9QoyHb2Kd+Z6VXJhpuAfTSNNGqOdWIel
5SQx8SdvbPQJAaxmzbriFKMDxeGOGYn/uLj3yd0fjVYK2HtcMn1KQsT5rQNU
RXE16KU5GPdFWsKxXw1/XOt44Pvpe9e8Zfq4roJQdLCTDs9gjBuHbJx1qVO5
dIYHr2LndlfP6OJrw3f2n3fYwy13U89ZNpIoeTSt3+GLBVo27pjvsFYNFn6X
pW9vmHlwUTZr6OQyCzhj7suSFuXjxr7AD5MmDlCuWjrspmEGljmP0woXasIi
8/PXHj0AyLVX9W5uVUAF2Q4D/8W24BPf1LFK3wLpwh9blSVs4apvX7PqajLu
vFr2oOmqCei/2HdZeUofJgtDO+xW2qLP8q6jHw3pIB1sXWX9ygTyPi907uiR
gfsnA3rfinEgZuEZ/heRHg679U71VYEtRhaUWjC6mECVPPmwKs8am6qqfA9O
0qHJUTUv/J4QrxAVF6oGOMAenuzY8CEm6B7ZZfmyh4M/1DbmiEnbwTIDNVrm
STG8LPhw+HkkDzILu8w5If8eaB8855tgTsFwQ7vf4RtkIG7lcLaUnS5EBGjf
4ynPgrsnTia9dHfAR95l3s6L7WFl7H5/r7sO+Ooibe3R+1x4OiVmKqPIx5uG
C7UGw+xgc2Xz9fy9NNiBpqEv/vM91gSOclisGfCvdvdde85CN6crC9uWaUMn
IXjTNi8bTJ2rMufbch3IWjNTDmCDskVPjzU8IIBnzK1DSedE+nVR6tEwHQLc
v1NdvvYIFQ0LCgczQqxA6uzseZZPaFja5n66Nl7EaZlnV/dKUPGx7ixF9lIy
5PhzowJE8ze7hqW410jESdfVFL/+oOCJ0+tqPD6K9CHNgswOpuAjQVTiYU0y
zN9APGLzjoIHHwWlv3tNhprle1mxJRTcGHbmdvlvMgQp3Bp/RaZhjVNclVQk
BY6oN+R7nKdiHGnn3sBeMlx0XXTK7CAVnUpNFGS9yUARqu93E9n7fL+Ww2+R
nu+DgqdzVlDw8ZxXrXPkSeApqLtrGEHFHudGE6ODRBBYJkeX02h41qIoppxD
hJHBdXuGn1CR822DP9whQiAfDpbWUHF5WvX5RpFuSXrc9a82hIYx383CxSki
3XJ2gXz+BBX1X/+qjeCQYMA4u25RHgVj6cvOyR+gwqHHedZteURccqeCZnic
CqZd0tEJgwT0+V6ThmwqFHe6EHRtiXjp0h/acW8avLofMWs6goCJzcXkTh8q
aI17bs9dTxDF7/FXNiJdcoC41m1bLAFVv0SdSeymwK/bEYeStAioMJarE5RB
hQLlw0WPk02xybXCl7yUCn+9f7ou32eG6ff79vlfoALh2RnuzE9zvPFXePZJ
HhVIVzJ8DeTMsYop2XPhLwmyM4q/2BfKosGVpHP1PkTouPP4rqv1PIxIqo4P
WkGAavVHPVEJsijrk8R6Y8zH7Y4mlJ0lDOi65h+tE+yAW4+HL7J4zICbtwPy
fboc8ErA4Wv2dCYc2Fci/M//M/Honq3b+IcF6ynefqk5Dngpz9CTPJ8F7eKX
/qRddUDyShNNtQQmrBvR+DwuxUfa8j0J6pIsMBSIMXZ5OqC6/aGh3FwmLLLj
+tXO56PqBcqvD6mivFNy7naGnQMK/71srXJnwbba2U6ztzpgo5RPQ/FcFrBO
hd5ancPFIYMDrSwnMuzUad6yapiLGTJPmQHOZBg7p6xq/4OLYdb1CXdqyXA+
1yT5Ripg3JJ9ARdmk6FN3uKgyk1AEz1FGXtLKuy9ZC53JgUw3aEwZaaKCq8o
2hczjgI6dh8X265JgZ4ovQ+q1wHV8wudP5+mQMbbchr1D+DtEd35+j1kEFuw
ebepSA9adkQLws9RwDBi97PSZ4CLdJOyOw0pMNITR26oBPx0bt2iVQlkUPmh
XSgiS1xke2b3voNkqA1Q+PZ+sy0Glvoftx2hgFHL67LjiwE3d9XUNn0nw1lB
se+INOA1itlbl2EKJL/1/C4vBAxWmH5hb0mBrrnviuo2ANJflbQsPU6GJZ4j
5tlSgGOGGD04iwZW2gukJzcDZoaH77UR6ft/4bPL4zS4KEHVvKM0ToIDAy5/
LooD8v89DA7KJcFYQfUOP1H/2+gqtufKqbAlQSC5WNTfQps13F17qJDhXSkU
hWHMoDwwfBkt6m971+EtCTYYfC2xtKSPBo9lvgm2brJFPe/AtrR0kb7mrZuV
3GiLEc0nt//1pQHBZe8T7m+RfV3PNueK9jn7tca2xSL9rR8r5jpzmgx9RbNO
7GkC3Jrm6rq2iwQ33qjLJc/h4mwFqZN6JBIEiZcsrOKJ6qvkDhybJMGHrYwE
Dy+RPzTpCJerkWFVWqGTFJ2L94xGYJMiBc5rnuSaSHCxLnOPZ8kmCgjOvpis
28/FNLr5nDnGFHg5kblII4+LGuNTj04/JgOvlpy0MxSwQuZrntFPImz5zCqa
PA/4lmbUcDuQBAzTvXGtA7Y42zntA82RDB7zqIOjfMAsIzfqKVFcIdwvqY4f
s8U/a4fC+vKIcLJ+asJKFvCN61uPJUtIcHk0wySQbotW1dXbnC1J4LdbYsed
a7YYKv5j1EFAgvlqHw75r7ZFb2H4ibL3JMjqXipcYyC6Pjy5xU6kT49P9P+N
EbW3ix+wvlFBhp4rc0paDGyxZ+25DzIs0f3GTi6O0eGgi+2WetZXEugp+r/Z
eM8WfTseGyQNkOCr7fkhP7YNflDoGXFfRIY53moqp+tt0LF8doeWBhkubBh3
8zxpg3xKeuDXPaI4/7xylc5OG1wVFdOW844MwpNU3W1vbFDreffX9FQybHTs
uxw0yUFGeo0v8AmwWLt1qQA5KMkdk83yJEHNrYVTFrts0IvBKkhwIcK09NS8
hwY22FkUaD2WTYJ9/fZDPdc5GN5TlKw8TAIdrXT1yyId+UG5gnK1jwwTyrBR
uYWDkYkujKH9ZNCXJ7v+dOWg3VCyZ9NWMpjN9ZKqvGeNubc/2I6Nk8H9rHHg
tRNs/Fw+mk+qI0PGyup9P2/aoHKp6WvFDiL4R5f0zeLb4tAxpc6kQyJ7CHnj
6+Vt8O1DlvuTt0QoXn4suTfZFueFGS5400KER5bGRwL/2eKj0oJP2h8tIdjW
223ZKQ4aNTUtKJQnwpvJ2KrTtbZ45M9FDXosAY65wRbmeg4+GWd8IjwkAi+Y
3eU9xUHigJWX1XoiVOmuObTYXDR/lf5/pRoIkFx/3PrsjA0yX32+yLxJAAnc
05F+2gYD3LQgv58ApJ41PT03bDG+jHyYqkIE03Yjgx/bbXHXL8LgQ1Get1TJ
fzOTATjz51/X2Xs0+OZUWN4q8mfzEaMYl0oGuPs1V+yy5GLkgxGbu4kMKGps
XuK+nIs7JZjXj6oyYGHZIM+plYu9DQMFN1cw4efMz537xXl4ZcmlON9BBrxx
uNtH8+Gig/Jnh6ZWBhxta4nb9w+wZp3RorpQJiRuUEiNYHExIKuz/6MtEzzb
JUyanLi4v3VxI4PGgmVHvUNSV3MRoqbatpUz4ZdCVOXck1wMrzDZmjaPBao6
svqVdVycK/3vd0UNEyRWrHH8dV+APSuCTuSMM0DxckLfiWEB3vp203ZMQAeN
Cx82Xl4ixKn3xj4fEqkQdtmu+dQJARZmK67cf4gCrQnSi/ovCdH2b32PBJ0M
zYPVbJ099vDG8WYxc++47XenI4pvbzLQ+el4gnDpf88f4///u6R4UKDbZRkC
ZGWlG2+t/GO7o0etYugCH92JP1PMm9l4oChXXfCdj53LmbPzj7FxeP+F073m
AnSe6nBauJqNRpNON7GNjypue9+0TbIxt7PPNcVdgE8GSfb2mzgIEq4KJEUB
7meXjas7cpDmPQR9XAFudX/hRPjIRn+fCco3UwGeO1M6sekjB1k071fSqQKc
+3RLR/d3Nob1K8mO3+OjUtAK7XeRNhg6dbU5/p9oPBnDi3JONpiQeJTgMk+A
Om6z/swV2iKxIrCksIaPCRZXta/+5ODyTxtHpUT21yqRQ+tf2aAVVUZVKMPH
PZaeLn6jHORt+gWuaf95Ph/8LsXVFjmuh8TWBPPx16rTakkiv4974r5SvYKP
Mf2bdDf+tMEWS339syv5SDAMVf133gbjjT82joYI8GTf5Ja3cWz0/qh5R9JI
iDsqyyWUWBxce701wMqfj94/7pe/kuOg9aTK4NRvBxzsW3FmSIGD213D4QdB
xCMax/Rfe3MQu/S1s0sc8NCZu7U5jWw8lPP2qlOnAK/PRPjyR9mYVvXT+/Wo
A0b/lGF/ymDjmlX1usGXHbD5K5G5p5iDpjHRwXLfBOjGllq+Yh8bTcq07zU9
F+Cu8s+/I35w0Pnjira+CNF8dR7A2eMc3CbvX7b3kQOOjS3YJGBzsCVk7sbU
QAeMuLP3wShwsOvNl7AjlQIcbjSUG93KQcHX+RsiJwQY1Xp5XVsWB/8wPyz/
dE6IfvEZD6UX2fzf8+2iOFdZeeOVG9MBp0pjmy9JcHBCfUH5YRkhLkkOjJUW
xWm9o0WJN2SFeKByaqbung0e/DSom7lKiLeW2c+Eddqg5g559jquENe/TGK/
32iDp9aUJj+bJcQUyaXwnGWD34QSDZabhTjIPx4SfYiNe298IBZvE+I/7cjD
62Vt8NfQAs0IGyFaKdrV819yUL9X42/vISH+nS7UDrS1xfPnuo6vOiPEOkmp
mRWlNlh5nRDL1xVi8wmdqQdsW7xi+tBG47xof5oqx2xl2eLVBRW8XVUCFFR1
d+WdssHNn03dP3QJ0P1xaq6nqi3G+TVHzDwQIm8HV6V4iS2K6RLo/RlC/M36
89C2GTDokcHxm88EmORQHuU3BZi8N3dl2JBAZL+6mxIALubILOkSrc+llSwt
+Zcie05277i0VoABs+eRb6+1xZbCphAxsgCrCZsao/ts8IXP78ylmQLspdXO
ABHwxO356n3xAhFPvrlcUmOLqpyDo6mvBCjfv3L7qlJb/HWjSZWlKsC82Fdd
f7QAzfau8r1lIsDz8mVzikXrUfcjuWGhhwBd6oNdkxUAzce3WtAEQnzeaZc6
kcLEKI3TTrX/BGh89mdpmJCJu3+YR5FvCTCncSJObISBxre/HLeTEuKbyhW9
3IsMTGnK3eiyR4DfN7TdTjrIwJVllya/54j6F85fx3lCx3tpQ9chTICpuYcw
XuZ/vo/QScXhDR8/v2sQ4PP+sbGJ2P+pT2X93/IOOoZ7KA2f+SFADF+43WEp
CxcljgbNXyzEfWsm2fqi8SpP7vbZlyrENDn6JcXHDLzFK971N0qITxOqJvp2
sZBYk6akuVaIXr4/rurIstDHY+e3IpF/SIR7zmwZZGJIsIbnQRBi5DLpuQbJ
/zP+CyYOUG3ydgQL8cuTc50351ljZuGf1sePhKiwSDzym/v/tHe3xmnTEuKt
p0KM7jjibDj+P/fHYOCNU9vlFchC1A02d6iRsEY/m7tReYlClNzz/3B13vFY
v+3/N7P3FrL3uPY0DlvDSqIIRQtFJSISJZQQUsloqDSUQoXiEIooUikjDdoR
yl6/637c9/35Pe7vn+/H9X6f53kc5zGer/NarzqXtnL898RNdrzICeWYh/ON
GtmYfi7vhEmME4qODFVucGJg3C+JbXWc+Ld71Xm7RYGBoJpWsIej/+MnZ8TW
GjHQ2Gg+UeqpEwpdUPI/XUbHpdWCvCGc8Q//PrRPt4j2v+spoWFpvglFe68T
Vl2wdv6+j41cAgaV9HtOeCu1uO2dGRttGK0THus4+UsibROfZKPPz1UJ3rud
cGSHtxqZSsefivOhaSucUE3kpmPtGTrSXsQV3RdwQr27oX/0+2m4TEypovem
I0oc+8Cjl8zR64fcItXRCVe+XyIiLEfH39Of579ynp83Ghosb6LhzrX2FxSk
nbDmhnFwUycVu48+0RH1ckIHR5aOiy4N/VLaO0iKTghp01fp62nIXn2p4rqg
Eza/XRoyIEJFqcZlEX84/TMjyOzWpXkqfqIsei71c8KjcyOrAvdQ0dlx+/zn
vv98/seOhhGHhcw26jrhzc+GTaeCqegW8a3i5EtHfF1G+8nhbVwenfucGu2E
Flxym26+oP6v/9woOCdzSNm81BFd3x5/e5yzX4uJl4ja1xwxz+TrqjXObOTT
PUmU5OQDHkuYc85h43DI+Ku/FCmIqQqXm//NxkrvIptXWdIQHCYVV2ttjnvb
3g9dpC5aPRt4aG+pzanvIrq9XlWS4HXhaFhGhQUub1x+2ysTIFJq/4o/sVQc
z9x7NrKXBQc09e+2MWiYl7an88hKBswd/n7TOZCJ2+c0B7d5WkF+2J7IZy+N
cDHy1z3+BEts+lmtdvUSG/zqB4cCj9lC1/2fbS0HlFHJ2DFyjNsWBm+0pa+f
1sY3pg7Dx7QAIpJDcgLtqWj4x6HBP5YNZr3fZYp20HC64sHaPfxs0E80VR65
R8GspIDbMY7moN3OLXKNcy37o+w1fYsJfJJ78YG3UxPsNBfUJ9s1cST66SrC
PjJ0FnzdwldqBBti/aJPGeqBj3RbdlaDPgom7PLUQXVY+qqu7bqGGQjM7ulu
u6UFPm7B3++bS2G3bs8+WogxXG60OfT0kS2ssjXb8lNcHUuW+AuPjlpBM1FS
xtKUgRabpTu6uAwg9vRv61dXNOB6ZrDfrUvWIOA1tD8mnIZ7VwxN+H2lw5ZS
Dee7A1Zor7PpxGOyLRw41vbYt04MP2w/Gfq+B2BIOzHweZYwPve7K0t7DtDS
oBCl4LkEu65H6zzfbQevrhwb8EFVHGse+Jx8yRRST7wMuLmFhgKqofnZ0jSg
hM2I2GfTMXH6pI3CIRKcVRVf+S9/RlU7dT97SIQWkpnFiBEVdd0L9nnqUcF8
cmOq8y9jlE1TTfM8QQWZ/EtqUe6muO+r1Kkt8jQoM+ET2hZnhsWZB2qV/qVz
e7Kq65cQcP33jy+L7WgwlbTfiLvFBHPWHmYev0UFJ6Jl9Ec9Mxz+nbsnpZsK
W9Qe7oy9bYLTvpdSkw1oQOaL7wiPMkbV3SUru/nIICcz6ya0UwYJn/WvD5+j
wNJJpvwA8qPuhQ671GIS2L4+l+aRKIl3+YO9Nt4kwjmtpff/GotihIaORul3
AqQNPF7+xlgarU59SNqpQIDj1oIed8XE8F37FU+3cgLo5X+4cD5BEpsOm4Z1
HeTwhHPF8YA41v++n4k2MHL/FCX/pR1mFSqFjdYwYWExx3TXlB2yd8fOfmcw
4bTtoWtvFexxx2ND7d13mCDsk+by8IY15rzuFo5tJ0G2eEcQu94K71x5qa4S
TgFq+8nnQksBXxg2JVpFUyDfdzY+AazxVtAqg8/7OXrc4xCD+hqw7u2nIz+V
iFCsmPzcmZOHhAK5EREPEgQHa6iEb2LjlJbu8l8cPRhgavYg/AUbZeFnj+JZ
EvS1sE/8WGuOveolJ66UEWGdiPpW6iFzHOFqS3IsJMHLz0lRc13m+EliKK7+
IxGGHPWLejhcHq7uU/JzGRGC55a/oxib4+pxW+d0Mgmu7UipKaxnY07E0Sjf
ZiIc+HO836KUhaurfjKlOXqbfCP6mpEeG5/McfdaDRKhXHSF6n49c9zc8Hoo
hU2Gdfd31twyYGHlzQPvlukTocRf23uPORszqIk1mhx7fTd5VZ69/K/7H/5x
USFDZVdXzHJOH7beeMX83mUirFL6usL7DBs7+3dWeFNJoLS12yw3hYU+sSMj
H4+SYf1EcrbYF3P8e3/HT3mOvvV37qy438ZCRU0elz5RIpzuPm7ot4WJBQZ3
TZ3NSHCmkHDpbT0LBQgZKzYNkWAwvdNS5CMbVbvz+Bp5zOBvx9bBHlEWFr5y
XW8hRYLrPtzuH/uYOJJW+WDVHxJkwekWPgtOHy46tm31HjJs43qmaRfNxohL
4g46/gRQzXDplyli4rKYZWGrjxNh/Q6/C0fcWKgTLvTbS5UMmz48eabFZiHl
ZGSP6QlOfKydiLvcwMTe6p4fVbEcf4ca0Z6Ecfpghm/Jv/5fIkXwgr22DRvd
t2f9HHlFgHyLZwfP27NQfvHuKtsKM6ipPZ9hjCwUcrsu7uBDgA/9weX9MizM
Pqq7vPEsEezWrqDIcDjmfZBierI2EaL3121voDJx7e+XP9JCCBCxnNbtLM7G
kcu1Zt3GZpCtrO+Xr8RCvyUMw4IDBIh/+dA9J56BLp+bC08eIkJ8Ksljaw4T
P9h4pZkMESChyV/gchUL14s18yY+M4Ol+NxELo6FPSOcxVQR4Na1p8sLypjo
Gczq3ShMAN5a5/TnYkx8MJLLu7GSCBKGJ88HTDDw+20vUSdZIsSqeHuLbWCi
pcsvAT1ZYzAZWTlfyeEKaqCr+YetBMj4fv7mUCkTV7T+Dq8QMIXwvW2PcDMD
P3kVD02OEKDCPFA8tIyBeutPn0s6SIAfC6ZpgR/oWHM0xfnMWwKcKj77NqqN
o18d8pd+4zIDF9UHwgVfaDhR+26/F5pBWP/4eOAIHbs9Tgat2k6EqS2WNdWH
Geh30UvP868ZFN/bJa+zko691pvT3kcQoO4L+8Xocxr2J5srOP4kQVLv+OI+
fiZaqDj2K30zAw/dI5vN6+kYISB57NN2U0iZXDHWwsWxp0P9u8pFEnzxe7vN
3Z+JAd17rZoXTYHyoLyg/TMdpa+YjQeUmIEgb16SwE0GNokH88h4k6BzvVnx
TwMmjnvFOW/rJcGcrv25P6oMtC060g18JKgwUbnP+5mJS75Ztm6aNYX7A370
j0dYWDW8vtqhywRWV98+cqeAirdmuCf6DYmgaxzoT7Fh4Fk+Qe8VXaYQcNg+
eJzD2beS5bNt6SbQf1j+wt5cBq59FOC/Vo/j79zksQ3qTGxQlW37yxlPL3af
2bdoJpa4N4jtlDMBU+uGJCcmC98mp9ZGMoyB917Sqy2BdFzVOnrigrkZHBDq
/PFuJw0f5+1ZRWozhm5J9+zdCXRUUBgW2iBOgG6tsZff22i4/cYXkyKCKVT0
Ek9WyzLxgKxq98o9HPsfNf/WP8bAeokbfVLjJFhSQOfzXcvErbPjV+8zKJDr
OajQakvHydqyMldTEkiVWIXe3kdHz5HktGOcPvFmdEvILIcDQwhLElbtIwLr
98eV1oJ0PLDUfMmKcCJMXhzsYNdyuDHutPv8awL87j6bNXmFjn9e/Urt6yJD
RNzP9sidTBRBuXajw2T4bunz2m+WiVOvMx2F08nQqD8ot86RhSasOeczsRT4
NTcYsNOOhSH+y1bqzpBB6tuOv08fM9HrfmKMGxcFRt2FJiO4OdyezdI2pVNg
T+XGDpkqOt5okUh8Y0uCfq7LR+q20XFYEV2Hn5LgBGHYZfULGt7aPW72ZT0B
aB2Tp/guUrG9+Oa7/c/NIDzx5ss5eRrqfY/eJxBHgDXNMa+d5ug4wHvULsGJ
DFmhw9I5DDoyA5dsuR9IhtUteZu2sGhIKM9y1+EjQtPV22dvJzKwQJAr13aK
DD6ll6MJ0VRM5O+6mp5AgZRDz7UlVRiYTNv6IbqGDG43Y358PU/Dsr6mouEg
Cpj9GitSk6Lj9QOiT72mOfV43rJZfwUNvx55sPVvHqdeG69W986jo+jAoFzU
BAV409aMDZ2l4TEnq8cxv8lg8WXpSuSnoWCQRfuYKQVO77g2cq2GhsmcKK7e
QoaQApNpoWg6lu0t9W3gzMcvetvpuBgdKY1CZ+ZbKHD1x9PyUC0Gfma/VY0+
SoFz656EpWvRcPHI1v4ALypYPBrqzBCiYz5tXuJuKxUGZjYEVR+m4bNpkY3v
f1OgSMbESJZER7M7OxN3r6SCS+jA6j8TVNTwT5zTbKPAD7M+s/eXaSgyu+nt
il1U6Irq2sJLp+GuC4fO7nGhwd+zTT5/j9PwuJHe9fTfVPA38r14TYSO9z8V
CfFU02Dr++op0ncaCskN5unZ0uCXf8itNc/pmNeRd0jDmgbnfrBnXj+h47M4
ldSa01R4LXGgt7qZgWFtzh3C6RQoXTOg4sCxv0Ez1Ul+hAqax9zMl+9moH+u
JW83mwpKcrdGWJlMLBotq1lgUMFvyHpSQ4KB0snDBXfnKXDC8GOc0kYGOja2
u+l8pcKeS2unOji6uz5c22vPIwpkW/sKr+Jm4hnXlnh3Syrs/LPnrsMLJu6h
e3xaUk+BJ3KLuu+TOP2nd3A+I5wKbaT5rw6c+Gb12hpvXKQAoaBkp/4YC+vV
xz9QvlBA5FOJfKIlE4dLb+X9/UuHzrxe1qdKFprKD52qT6HA6udlKW3B5vhK
47HVsVgaxGkJ8qxLZ2Oz8jG/0rMUYM3KFJZeYeB08s+AsQUa1N3fRu05zsba
zy+GCtqpoHBF5f1zW3P8vLk01zOCArE2QrHXvBm4wtEbZA7QIHVK5A+zjY7R
tCuru4zp8ER5/9YHRE58Kyy2nxmmQbf6s/ZkJTbG5fSEZUdw7DUTOp9awsb8
iSWpZf/6fGL7gOy6jebYtmVHKPclKnT7Oph5cHRT2PNvc+YcLt5dW3W+mdcc
r92e0D2uQoN7ORoxNcDhr+JHe7aIU6H65B3XhV4WZm35fnnpRjqUPdtVqXGB
jXUbfhcV/qJBOB/34s6/bIw87zOyMocGajPmXwv2WOCZTfecHitTYc3ryw1b
35njjQzdj5GNFCAr7qhc/d0cZZJxIXcDFSa/h0z1bLXAyJ7TKQGc/FRyWn7q
8QNz5A5IGKxxpED1wrBe1pA5Wm7X9nktTIMED4e+RystMXhD7E6xhxRoSZgZ
mjhgjsAnMHxTgsP1DKke0hYLTPe+3JSvRIc9bQl2en8tkHeNSukZFgUoWjrU
g+0WaLD55Z6cxxToCfWvOchlgc4fK0NKimmQ/jlnITbKHCVcdr+LTaSDcPCR
zB+O5ugdJut5iJsOhhrPmzu7LXBYze/+Rk6+gOSYR1K/OU7OFTz+rM+ZT+fb
5g/rLXDMt56xdyUNzNmfPZ4WWODJtjsZx+5RoSx6k0uLoiWq97UscfWgQvlN
re7zZhZYeirH5OgdKlyz3Cjk/9gSxdTWrgplUeHwEYPAw2usUGvQuiSkhQor
tFeFun6xRPtdF119KyhQ81tMJzHFEttV417V/+Xk692Fkvc0K3z7dZbw0JsK
zyT/XGVlW2KOlzhvpDsF7uj7MUb2cfznznihm8LJt7W+2UxJS/zwePOuDR+p
8Iq8rFecbYV2Qe9vXebw2RXCArlR0An7VS7BmisMqN98VLRzvyMe216w8/R5
BvzA3dEjKo54MyhAYe48E26V6a1Vc3HCvV9FlGM6GTC1Q9j24xd73HXlT/FA
3//RJwzG/16X0OD2BqnFmXuOKGixk9dxBwNom4r1iycdkctOqyFGhQn5fbeK
Fu0ccdfxeONBLwbo8gZ217Q6YvmlhqOmV+hQaPKN4GLAmb98IDG9jA7lXzLv
mlQ44f76zSx7KRpYXmz3umXMsSd62vabCR02lQUQZrKc8M/Mx4vz0XQwVnMO
L9/shNNXDjBet9NBt89VWGnUEfvFeOeXvaRBcxrlKn+JI0o29C9ZzUuHyXVZ
Aps5/tE761F7Sp0GZ7+t4nrCWU8S/zUTMc5+6p/b63Jl0BGfxnnrT6pSocb3
WAUr1xGn+TYffLiaCkdYTVuljZxQeLGx2IqLCt8UvvJP33LEo9w/nFZ+49RL
Df7muE//OW9pI4CnXWi25n4nrKpuzug7RICzrkpiNrlOqHXfbsclDn/EHNxs
ctrXCbc6a5eafSVASOuczNvrTmgJBu20P4T/9fc2AhxyNBcs6f7P+Jx4alA+
t1fv9H+uY6mQubOm+6y3E/pF7SO95+QrTTi3NTqIM38ls/q9LA0C71bF7jrs
hPfarY8bC1Bhr9xKhurb///8/zmPhLlHEpn5A/95XZsMZ1NfJ7XEWYPYutu/
bopSYZO8CTtmtQN657ylzXDypK9coPVspgMmmm8aJmr9n/P0b+aY/qa4z3qr
E9Z4Px508efkUcXJucNuTrhT4O7sveNWWFL5RyuSsz8YLdkQ1wZYfiROw6PD
EcuKjzymZMP/jkewRjFbw6WDrk64/m/88FIDwKtJx2blPv5nvUGcPtB0Wvfb
f8+/HrBx/nawVAUnvm78ypIhBpnj75O1J25x4klBgeDq/cgcD0grfqt86Ij8
2de+HjCi48bhqhd0Tjx3pqhGu3rQ8eXdLk2+ckc8cuLa2qFmKnozs63vhzni
T0eqhvNBKm66rHuPb6cjHrpuMGF/lYLKDhPHBSodUbvwyKEwdSqyv37+G7ze
EdVey1uGyVFxrLorMKXHEefirxm8a6dgT7G3aN82J4z4lZRmr0rB5wU3ty3w
SMD9B9MetRyd6980m6gSvQSaI5s1b5ab49B3DcU78RZwxnQ8piCNhJ+fhSlm
3LUE9cMqjvwDJCxa06P0gATQZ8A/+kiTjnLDgqZdX2yg8VjYsNWELr6MYwTz
hNlC94DonFeNGg6GyMtcs7YB9oWODxotS3D7e9byjiV2YK7dULruoSYW6ey/
aJc5a8WS/KySJsQN7gNyZba65sA+5Q+dKiQkWDuYju22hGdfvFSmOFzRdWPp
sZhyc9giX3rVksOROslaoVIhNMhbvLziOcsSo4QKds5dosCpbcvG37VZ4IDq
Xh7V9QzgaZ73j3O2wI156pGn3pJAReCH5QY/Fr7XWKzm16LD6jzDbdG/OVz4
WLew4vEykOpjXX2sZYU3UhU84h4vhciVMyOSZCtMzu646smvBPbr+wvDeixx
QfdN+b4HqhC0myQuwM2p01zmDk2XVaDebnLZ+BFLbAzTbyD0qsKI167VKosW
GHcy9X34b2XwaVgju+GRJQ7ybPt4ZM4A6sv+yHTz68JMplF1z3MbcF04XFvj
KIiS++zWRolzYWlo49QtGwJorq4pz+aWxOLogh77Cj1wTqEaJiERD/5e/PHY
TgaOqe6vkv5jisPv8bTwVyWwidTY/bJMHh2//HhfpmUKT6fbfeU9RXG9tP3P
W1XGcKdMiCdnO8CNgpuGhAUSqkTlJq0UANhUO63yPIfG0bE3PHlvWcBE44UR
kj4Z2ZnSg2OZUuhmcnvL1tUGIOmkqruL2wYeHDgkt96Swz2UnIQodU7dK/3Y
G1tNQ32XO0HxuiTgUQ1dfCRExcxbPO6lK+mw+65KP5e/Gc6ZBxSeE6DA74M1
0oOWYhioVnfxyhMihG9cUtp1SwKzeE9U8NBJ0LjrZVRUlygmTxaUypeQYK0T
d6aiLh9qfA6VicgkweqcFwme3wWxqkbm2q4AMgQtet3MWi+EUkefTn5wM4Ml
m+Norp0CWOhhfjWGmwR8g+euySYLoXGmxuHzHB12OuKpNWGHMB5N++J36RoB
jm7oN47WEULvCzMThX+IoNz3CMy+8P6nThD/U9dG6lYUtvrsukeA08IT24Wk
xdBF02rSQZcIT123X/5kKoJtFRdOpK4lwRqTc04yT2frxIK/b1mnSQSSxqbR
wJjFuvDTm6cd3EkwxloIvniWG7lMPTaMh//r92jv1HEp8eL02Muh1Q+IYJv3
7ZrN6fk6fjmLR7wvCOBSxTq/YMz37/VM/f/1JJA13p9cT4TqP7PPmr5N1klM
mis+MyUANXld04nLc3X/rfv/vf9J19qSrQwCvLW70oRX+FE/v1DDb5oIMQN6
V1U8J+uY11u0r54jwPurcfuWbuDC+rVD6y8qEIARbt18ykkIGSEM3r8eZuD9
Zt76jCEPpnwOTnukTgC93JGPZbw8nD6hceqOmhmU7EjZTKfO1Ak/8Una1W4E
j1SsLn17z4figc7t2hdNYJNj4vu23/+xR/2f7zfUXbZiqdSdM+X0aftnwVN8
6B64aWCftikM/ix5pOHC9e/7y0ygLDZ6x9jHP3VDqKpzocYY9peKr5XJ48KZ
zP1pUVmm4B2anH0l72/d1qa4lkJO3P96tKZPyIUPh4r97geXG8OTlcJVRvck
0Kc6oTdjzBjuTWlIX+ITRtGnV/v2GJpCijHjkVqiEEbuiHrdscUExmqPMhtC
Zuv2f6iVLvUwhqxRJ3XS66m6pzIdOJpvCKapwx1vXkzVvXw/ZbAtxgDaKoLz
Cucn6z5kjoi9szKCZ0epvVQ+LnTYXq5bKGUGea6u8vKWohgfPKZTPGwCHRqs
6YED4tj2O+Szf7A+ZGkPbj57kxd9Oz5ox4uYguGv3PfuYXK4EFxAEFU1A+1l
y4WT9KWw3DNEzU3REDKFyt1yFfnRVWWtxccRQxAUWZDMSOHFT3Vq2ukTBpB2
ved74t/Ff8dDpuE//v53n9b75/qm9KFjL/v14VB45Zv4zYt13gzHVxf79MBs
b4Kzry0XGhhpP29YYwA5UidPJY3xYGaA3P30zXaoJe+7tWCQDVonX52JWGKN
iSYPzlXlECF3dQ3/Nmtr5I0hq1/9RIDkgUUJ3fuAZX8tPcNKiaC4jMe9RsIa
Z5LeXhxVJ0JC19j3eBlzHG1a9ax1jABvFG+eu9fFxkp4e3bKkwiM6setq8wt
kFZ5hxG2hgg+EnvdBEwskF3S9/FJIAF2SzrXm6qb4/xDZa7Hd8iQbTW/LzOe
jVE/yp/0VprBZTYXj0QQG6+amwkNppvA2gvinjr+dAyztw8Kv2MMOUZVoUrO
bPxkrXuFNECGDwfY8TM2NPQ3yqm1WWYGnX0Gs893UJHPi6ecmUKA0PAPqwSi
ydh0yndtl7QZyNaN8b87QkGD8ZoYWpMZjMm886PLUvH3nV0dHlIEmBISPfXc
ioJC5blPDjOJQJ6c2qJcQ0Fx4zVSN28T4HHifGivPhXdaKI7v/wlwPVa5eVq
kxS8lyPpITRDhAefunZkEqi4R2nn6htxRNC8suGCIVJw/WSh4VYrIuT8iXat
76fi9gsVZSeVSMD8qaEgdYWKl0w6NI+WEMFU3eaOpxQNm6W60zL2ECHlxnWW
Gg8TH1rIap16QYYHzUMPyOcZ+Lrx0s4jUWQoiQ2IuOltiSlLf57O3UmDz7bD
vm3vLNGh8Pm7Gxy9uk9658SFKUt0Zapa14lzeP6hb8v5WEfcs+FsprAXE2o3
GYhJvnLADZ5RNV9I/0cPgBXsqXh0pITD98lJSTVcHkzI+PKg0jrdCUN63gw+
eUgDAYaWseeXf95/hC9J8Z3OTFt4/SjxuuQOOWBETlQV1zvhnjeOfTfOWWDQ
oE9INYevXjQf0MttBDx1YSFkvMoR+RqtHX5uAGwXkrI063PEZWNbDDqNaHgx
g0ucme2IOb9PK+zSoaFL5i2bZxx+t0/M/ckXRcUVPaccF2Ud0dful1hbAQX1
LapNbUoc8Ckh1MbiGBnnDN+2pbU5YNr9nSx9IgVXzVzjYaz8l54JvMOIJOOJ
7siEEXtHNFY9vk5AmbPvfHct7YUc8Toh2VRTl4KLWVEamXmOePba7pu3O8nY
98q+aeUBR6TxWSVwMym4Z9x3ctzLCT9Ek05+fMy5P5kcnq7khL8myxWaD1Lw
t0ZZ4qcbTuixW7fneCblf/lWkYr1X3ld9e84oWALjS9hLRUXB2bzTg38w/+I
I3miH7/8w+94NKf5c1wCR1/I3Nt8RYGKSSuO8e4wE4Zc2yPlbyLNMTy+srp0
gzBwaR28liRrgZ5WsZZnlPhhQfZHw8NQC4zQvN77/oodKl/nVX1cZAX7uHp5
V1+xBuV9SoePeLFQ4exXEk+oDWjzM4zffNTBwZZLZPtxCkzX87s+2sPGkymH
Lu0xo8PNPIdhXg5v37mw/ETHNIdHHkxkXEM6gl4p3/1fJHhw6kD6pz8sfB59
4fWBATlY9qKI2ixvhbOSZd7XVVUgKWKdAP+wBbomBQBvggiuTXk2kGFnCBnr
QmljbGPcn9dhuHvbhJW7QIv8MJ8lhHV13Fp7n4iXRXTvzMtYQsk9kdRJXiom
e40GnswEqJx43PQUJHFHmhyLn2OXm4fkUtcMKsZnrGSMNtrClM6p1/UZS7Et
zt5k5R9VVFt1t/ycLx0UF6VbLBesIcvqrxnPL0FMMSt7lZ5hA1OKm+ozi37X
7Ti3QSf0iwUsxIxIaTNJ6NFaX3iSyxqGS4W1K9Mm6rZc91f4PmsNbnbHkue7
mNjo5Qgh3/TxyJZgjWM/VcGj7uDMcyMDyH+tX7Flrx6clrXkGey1gTa3MjHh
K2IYmnTE8uJ5CqiMTxOHnGi48fHVDzO5VNBJEvl7+S4V/e79dInnp0IDzwFK
cjcVtz2/eqo3mAo2GrvEoq1oWB6XbfeeSIWKUzyDj9ypmO3YUIX9VCj93q+Q
0U1Dh1/69mM3aXDTxgunGRRMaVwobC2hAnNhs7JJEAXPTC9LM11FhQItvY/+
TylY/+fvslweGix6/ho6K03Fthhf3YuKVFAvnx84Y0nBQxl9rtkZnPvfONzI
LyCjyoQ04foyKnB39V/e8ISMH163+8Vx02H22cb3YYsmmP7NvO5iOQ22nxep
F3hrhoU8J0/vGqKB0+fxdZI7CPih+nzRQh8NHnwXrPAcMkWK5I7nX4PI0KCz
Yn/EtDiuHZS2NCwgw4QxYQNXO4dzm3gVs8+RITZTeb5aVRRdftJC4lMpkCaf
ar9phSzWTsk/tJkjw57tMbPzJ2UwpqjQe/IvGTrlI4ds7iug1hlR2tb9HF0t
/KdJ2VgKSbJ798Qvo8A643an4Oty+K3oFWXfRjL88g17qW6hhIlGLRdVJCnQ
cya4fOkLKcxIfFMTFk8Bgbn6imfLFfDw4ndSvDsFvty/SVu+Rgk3aJ/glp0g
wzq3UtRRXorxJXt5TveQYaAsKUf5mwqGijvkWnN4OMvw6ofGcnlU6H2guHGI
BImtfFaDP+SQ73VbyOppEgh3qiwU/FbA4+wKhYudZJir//X653YlXLI9ZmDt
bTJcO++jvjpZDm3zBizaxVjwQHlJThpB+991wu2/36P9Lz/Q/7l+cFnE4a42
Z723NhN5k/ixqppl+ugQFUbkR06zXATxTZ1QwqrNNBDXNnpdOCeBO3ctcj3k
xEOOn3CpjK0Imr3yp5XW0aDZWuGMxVKZf8/3gfrP+M5/g77tnaDAaCRFXDJH
EBtNKM1qDCp0dr6z0VwmjaNyB5Pmf1Dg/cHU2sx2SZzbwY46akAEr9aGP+l2
Ev8ej48Atd03RSMkx+v+qtMvXjAygnXruw9cvi+C5If7zkZ8M4RBjb98GbcF
kBknanS9xACWNuRzbS8QxpU5dVkfJAygcQzjmmQEsEjsFlqX6YKM4btop3Mi
aCzxs8iKqA8Ts3cDmhZF8Nizppofw2awNU/nhKuLJMYsUb2XdMMMHJW+7+AL
ksX62U5vZhZH5z3xDf/0XBYHDq/M/rpIgFujap5ilvJ4milYUexPgBiPD7jm
gAK6j2YX+XK4w0Em8GyhuAwmvey4rVZGgAc+InZNrxTxysMI/wgDAgxbL9wU
bpHDI6EL3BoGHC4RaFMt4FLED72qPWeWECBu4MdB3UlFVL/n0vl20A4fMvLb
iLZscLkTkKaWZY1hsktDNPkJYBOwyDP10hqzzeoy17kRQLysMvZgrjV+Eher
u53O4ZUq5aBvbYCLhMKQKxzecCno+LNyuzmOS1eVsjg8orNofPQ2wxxb999x
ySQSIJJP1TSMYoH3Chea9r8lwLMrjLX53hZ4bivpZMoBE3h51ku0LJyNepYZ
2u+OmcKKAZeK6e80HPmyc8lSU45ueBrp7uFMR65dWeVZn0zAQHh6Yf8tGnoR
+L+v5zUDoXvlwvtoNBy1LtyZ+dMEnsRcHbuYS8GC0j0bXRaN4BRvkXNUDBUN
h5P69Ti8Z+p+eWcRpw5Z2955+sPdFA5fiLmt8YuCph639V6yzCD1VHP7wTEq
Vj24vzVQkqM7FqU86lOpeEPXh2bWZAJZAbObIJmKZTaX8hrbTMHZdlpQWZmG
GoLBNa94CJCrRdb0GyVj2ImQwN2RBNjzO+kDjwgTTTwVLG1XkOHZYUnjhWJH
fDiy9MDBKRKe1g9JKRhzQDOWwIoSKSYoFlsEB152wF1X55zWf2KAS+fWnrsd
Drjk2PTUtjwm/Mo7TjDZ4oACccaucmMMaNyoMXsuwgF1/3w7d7iECSIXNFZ7
PP9Pf89nQMVEQ5RvmRN6+s76XpNmQO+lvDeVKU44XUO3m05iQNSDiKi7/z3/
ekWHU4OfzBQfOiF3RXG6tgIVIlKXJARscMLhZ4e38yfRYH2zQceR7U74d6kQ
Pl9Gh+udP5xWP3HCHV3SjzbL0+Grt8Qa1mMnTErsT91+kQYfUhJmkjSdUOpm
RW/bcsAPCTH1A1kO2DrT99GZwzPJjfZvjDh8JqS6NHkZm4SXFfsMjgg74fGf
lPx9uWTsdD7+QJ7bCUUdp2emJSgYUGG+9IY7LzQpe2RFzpvjwbiyKxLGC1Y3
4o1mLHvYeP918eK8Mg9c2uOxNdjPHOWpS8q4w5YAUSngxZygOf507BjbtXLK
ylQicHPQYXP8JR6yLldKEGQc430Th1l4McppGd8tPlB8I1Wfso2FehfyXKaP
CwJLiLQx+hAb61tOhN9SkQCLvniqoyYb2bpu/LeviYPU2hDe3mI2dm7Uf204
xANNARv3zaxgI587/00bNxGwv+2mMWnKRlj+3SJ9hRBw693hVQ5gYU98U2VH
qwS4bTe29fnBxNDTr57dJ0uCSM1GQ1tPJno+2t+9YkwE1iQ1MnbxsvD482kh
pRdiMPzwzrr8DBZei3sV8UuVH2QDR3eTp5k4PTvkdnUrH8xrpP9K6mfhcjV1
14ZCUbhrFuV33JKJS+JsA23UpKA/Nsn/9V0W+jRaWKsbyMC2+evhbetZmG++
PMLcRwYubluSOtXMRIbt9VSREjnwNRUpS13DRPOHk7NSSVKQeILLVO4GE/db
Se+VOigL38xi36vHM/DivZq6lIvSkG52+wQxkYHrhG6H+R6SgZdTtHXr/9Ix
d3G/e7CLFPSt0LGQt2Bh6tETbc8p8vCUee7IlWk6DrlOfI1pkAP/JJZ8bzod
Pz7++vP6DgXwXCGgI3iVM/77zwPjysow8+OFQ30tA8fcDelbBhXA0qXnk1wr
HZ3Usqtm1eVB8ndk7UIQA1UDCxmnlVRAN80773ggA/deXXf06rgirP19LfXM
agZWhK494NU3bvVhyUlmVooVyqXF9I+ms8HyB0vY84ksZo69jr46jVbLakus
NtVz9OtE18XDLtZQPBgS9ytIEIl60RdP7HZCdbv4xLkBO5iu8Tj9kYsCHZc3
rFp9yhKHki6te+xngI9D6w5JHNQAo447Xj90RdFkpVJcXRUBmsUSEnIJAtD+
WTQsNJgAddl+zLl8RwwZ0Dq7TdYOUhrK1z/1MYYuaf9AlU1aULhdxpTdpQ7W
1n5xRaeFQTNh+NXQWwN8NXV6TdQuNVga+zQnd7cZ5tfu8rsULA7RPjEf8tQN
4XMVZWfLkCaMxCm7qQ/Z4wpFHq/gfmtYszhVWudshDfXj5z6xqMCX6e/qLi2
GOLR2oTYfiG1f/fhc8b/0RkjVnee0dOzuK3xj61KYHCVOQSgdcLxPAIKsbYD
OUMEbLa3RL5QlUPtXAq/6STHvsHohm4vfdxhQfy9eFEDoia7143tskW91OGj
ah5WoOJxw1tgQQZdeMqtgmNMoHmZW8vPEmE807BFLeG77r/nB9I/86/66K6/
aZUUvqDlp20VI8Oj1CPlhCpxTIm7q9ORagr19HtGvzOksTLh6os3F0kgewWK
/Pu4Ufud657EN/rAKJUWMD7I4SCbU2TZewTIzorOKo1ywoQ1i5fN1WwhOGWT
YewjUax61VsReJcIb4QtojdVD1gdmuK/OlhhAo/ixNaH2vFj9s4aniBfIci5
vmbAwEAWCxtWlW0dMIOjdx9KvuJegtfniTabtxkAyUFzq9stQXywRMSs6jER
bkafbTy4eb6uVTh2XXQ0ES7Y7ihyDZTGgb8nr65eRoIjp8RfXF85WVeecKc9
Zz8Z/C98+njhLUenP8rx51WzwmUrbwUeXSmKZyv/PkJzIixZc5j9PYOArQWt
W6WyeCD/1UeS8zQBKY5CIl57Z60kz3n9+NHNh9Svk5dOnyJC2R6D4ZpMCbQt
1yqPDTWBr7aM46+ezdWVr+retCRWCFy65XddDJKEb6mHSE0L6iA2s/PacjMx
uLby2dESeS24G3TEbahGCbpEvaNVo3Xgwcc3YQVVehCwzOjrbKcVPjP64n5l
hSRuaNV5ZZNCgjudHZ90LNgQI1PQ/ajGAn/e+Jb85KoeZhVVers9Vofds98/
4jYRHHO51C5uQIJ1tesGubYs1C1VDS2dryRD0Y/OKKOfUhj1lvHj9hYTsJY2
HUl8KcHR55I7W+IJcOzKWQmqDwFr12lMFSpI/O95g68NkLmtZkUTbKDTsTks
L3WyrvKpRcHaZRbQ/9FnG5Gjv/Zq7mxMO2oJhX9aV94IJOE1oSOZXivNgc1c
8b33EgM7uKfVo0wUQCtBybTsoSUGOBlfGg6QgfaYmjEhqhU6rxJb/8tCCmjN
LyfyzgG6GZ9zOJMvBwzrRz+WMQHdt6hwKSrKwS7P0Xv+j6xQTODctON9KViz
SeG0mBZgxOSMe5mQErxI4nUbHLLCtn0fw1+1yoC9XNjrVHlA4YIDlXs3SoPu
+cKFgCorlA0ItiRRZGB9rUjjsW2ApTpHNfptFcC+mDlOT7fCNLf3EgvCCjDm
IyymKAS4WclXD9YqQe3BCDH5ICsMCLhicUNWCS6e6FBU38t5XkJMvSBJEQZ1
zQSYNEApi54D2zh1bqom94UCnYUeZV97OoqWgqmpr9MCG/De5irH079JUFn0
bcE41QIVFrOj849z9Nvh8IOxqhbYF+A1s9GEDWkOk99lTKnYvo/dtElAHrYH
tF1QuwSY2dR2zN5MDare95xW/GKFduRATQ1vVehO3Xf74D4r3Es1zZ/xWApK
dVk6zU84/npq6ndUVA68LgxZGe8GfCP8ReiDtAJMqLdr2GwF5C5et5+3UAb4
xV8uTbsLuOTKuowTOctAlHzwrcQZKzyrtO2ie64KnI/n/6gqCrj23Mq5b6aS
UPW5kXaq2BrjVqd/vGVPBf+JE03XOXp77vR1GS1PKWh03fPFVMcaSy+MH+H3
4+xnhaT5nxlAx1sjKXa/paBD3qkn/BOg6ViY7mygDAhEjF0UlrXGprl3z0Vj
GVBKmnl6e5CJ829LVSvaqXAIrMV38bMwTFhoQo6mACWVG5NnegHVHAW3xSs7
YEN4cacf2oCuYdfejGlb6Mrt0s6u4ccb22aaMdkaAscsVvE3srC1I/h96WUb
uH5GrSK9k4n39+r8ulNNxmt2Da61g7NWwW4MIs+oMThJEjdUGGpAhP/fJNUO
Y7ykoH50ZloVOvY93bD0ngwqjlZDdS4BmMnu4VdIprhjC2M145sCHCWL8P1i
CKKsoKa6ww59WCK8fbOsiSTWP1C3XHnECHgg+5FNiRGWfoyOjjivDqLOWCl9
nBv9r2UudiylwDsf/neRAvKY+vVsjukCEbx3qm6Gh/KY9nEkd388px6nyD/Q
YRPRrldb9by3JFz3O1BWlyuMWacUM26/MoVAbUmY8f5e19q6YJP1kgzkY7ON
NA8DXPbxsv8ZSxW482XTVrsjBnCTbBm57Ko6lF3V3rR8KxVEd9+/POtHR83E
hHU6IhR4LPN5xD+bjiyv81c97lAgZ6Oa1JaVdMxR3iJ657A2+AmouxgaWqKp
vrtBdhEFWhUWSl4/pWHsnPNrx+1UeO8ZZGt4jIF1614sEE5RodDHjNjA4Zfr
x9xeKL2mQJPM7I4qEQaKZFrqTZpS4YvKJZG0BjrOmYVHiq9jQPXvt4cuptFw
p+pbr08NNCBW/vW6v4SGYe6N5m8VaWC2sG2luDENbw29SEhZTQOVkF9vBs5Q
MeytTqY5iw7cE96XuZWpeNRigJ5USIMUza277ktRsaK4af2hLzS4JLlXUuEw
FUs+7xCtvUKH/dRzo/R5Kv648fbrWgodWvf/XXmun4pqUS+6JMZosFqSdFT8
OgWLtjeuKkpgwMGZXl75CTJaq1QdqMyhQ8qqg7K5C2TctCfohpshHdKytPpN
LChoxHcM+v7QoDJ4uemXLWScuLVz9WdXGtS/lPRrLKSgu8ax3k0qNBhNv7Mr
f4SMKtrbNo6eoIGB6/VzajVkPEDzk9yiT4MbVR8UN74j4fvb96watGmQf5vf
WmkrGenFZR9PitLg81q5Ku5lJHz0Sersdo6/SwdffGmTIqFI+BWH2Ws0yBLt
8d4UaYItU/TmPVuYQGV9jtBuMcbRjW1iHoE0kMjiTuOpNkVZKd/0oUYKsLZk
DkSWSGO6UZTgrt9UGFrdsKq2UwajtHbdOaFrDKJjzz/v2yKKjJ8v8W6XEYQv
DQja81AQny1ErjB3NYTq2wMp26LEcNbkHT3Y3AhmH5mseX5SCo9dGy2XPmwE
TsN2aX1bJFC5NmDd+wQ9aBFT0iiOF8DxLXL5d130oeWQsNXGC4IoEsVTEf9b
F4r1GAy29vy/z08+6PxzvnFebJfqXntt+NKyLVNMhRu9bui0uv/VBZPrE4PD
Lrxo4WsoGn1DB1LagzIZ/Ny4Esq0ZOj6IP5QsTXSc7LOVG7JvsjvOiAZVFvp
rzZdZ7aXxL+iURfOB15UDj02/u/53LT/mS//L99JPS4dEBEQ37ldQxCrf4cW
2I3qwIu0nHMCB/ix69u6VcI/dOBesVGehJcQrpv78eBUoza0NupYXEuRRNrJ
jJ7BEs7z7aKS7eNi+OGVrVt4mjZcWtuYnL1XFFv2Na1Q5din+ovkcdFBCrXf
uG8a36cJUis0VdtokjgoD1Vdo9oQ+lsx9YWeDAZ9SCDqW+uBQS91TC1REk2D
E0KMirVgIKPmSFWqBBY2UdwWZrXhInjFJgjzYdyzhr3LQBvenQ1p616URbP1
URtcjmnD/Z7Bfc035fGyK+VF9UktSKwq27P9uDR2lhxyiLmnCXNhidHznP35
cV469OEbLRD4qZ8y9EAQ49MsG5alcLjGybX67B4+3Eof5Xq/RAuqBRMajrWJ
oBhxxwFGjSYcV7E7a+4wXyei0nx1DjWgte+twekRYVzhoEPauEsT+A8Gn7gi
wYv+xc+eMAQ1AB4bfGFGLNQt7jWf2PlNA9SCduzm0ebCV1UuN/o/acDzw43L
8k0n6w4vVNm76mvAt7cl+mtj+LBQ48uDcSN1IN/KKEsGPmzoE3iv2qIOBjqZ
N4QnxP7NNQSNf/azbyg1saVFAx6pij16SBfAx/1niX186pB1N/qVt7Uo3rjm
sKZ+mzqcc7/6OqRBEqdKbt8NTdAAO9/RI4KRUmhc3adyrFcDrkhdU5REWZQP
zo6R+akOCm92RzxxkkdWmvH8k7uaYL/MkWi3RB4Dv5rquRzQhMEnC6rvt0ij
5QhJsm+jBow9Vf7WzZbB9cm3ehNmNcHii6fcHzVZjFZeuXbrLQ1o/Lqy9FKO
OA59LPcUmVsG6Zs/FNmVz9Yl16ul5jeow9lT+0OY8xN11xzKZi2c1cFWIEAx
/JosVhHVX3SIG0Be/PWd8WliqHI5NtWl1QysefMPGMZLo4tV+umeP8Zg82z5
ulW5Spi9I0ROUN8e569uaVsYYsE3zaTRsu92uPuT+B+TEBbM1O3vcpexRzHp
m8brNVgQk3frqayOHf66fHlYYRcL3iLrkFCyHfL+KMq8b8WCcder060P7VAy
a02/mjYLlpTE/LrzlY1tLy4GGB0hQP+3+qqUNHPc0c9/7/MlAugya/gSWs3x
whOhn7bjpiDG0Fn9wZGCC4Nf7k82EmDF4YdYMkpG5mixQfQjM5BcOjP4lUTB
7RednculTGGVsdyR3b/I+LnSR8f+pSl0cG9YmXyGiM/HjZL+vP3v5wD++T9t
eLZyOb2nyAF7sgP1+ryY//t6JseegS/PiYKLVlLdtdyLt8zRx2R4gMkas+p+
cLS69D0bfyqcjE9YOmIVUysfYu9pgW8pVH8yDy9Mab9Ymt3CRr/e/Aqx5hmr
bRmnqv3M2Pj09Or61yV/rKRDav0JQWyMLjrwlpYxaDXWvDvLbysbg6auHqim
ycKrC5Ln+eYZaGe5LLFeVwGUxQ5vSVdk4r0yc5/LW5cCxETH2s7SUUN4oP9i
xLxVayhXROdGS4ySpJaXqNqj49+bO65dBhDKT+p/5S0DD2qColqM+MHweKuU
vy8bO55op+v9YULls9aMRFdbDEv5GakYaAHMsbUHFtMV0VRDS+CtEwmuhjc3
dNcRIctRZm+SlDm67iubOJchBN2KDW+6W8SBf/c+ldXnjSAvkKvvOadOKjdF
FRPreXGu/835RW8zkE/mH3BOUYDwZ5WP75uZAF3vM5Q8MMdxzI40/E4HwSPf
1Z+P22NduwLRY8AW1L83p+X32ULb8kwtUVFNlCzL+MrYqQddN7j1hFt0QDrz
zWpPa01wSdWoLb4kCGGPLVx1xWVw59bdZaLp3EAkHtx7dlIK6o72Vq9jasLM
2Lulq1wm64QZf+/FfCeDlO5nib5ZXoxMjzzko0mGVp0T53/Z2cDGgYb6i7Ha
eJ09dapiF0DN5cPWu6bJ6PG+ZdM1MwD/Ctuvv5sZODs0fkDBwAK6nX5OdU1T
sKw4PITIiSP5S/Ib5a3pWHA9McqH3xLST9+s47pDxlzHvU5rQgAifzt1beHw
R1/c4ySdnxZQeutW2U5bBoZHr0nea2cJUzn+zSe8KfgrjXDlWLkV2HDfaV2X
YowCs98nniQCuItdkyVfpKGQWARXzHIioKymnwcvG4kR6SqN60ggc6XCnk5l
4S3iGtUTCwxY7KjbvNvPAi3etWT1mlhDeid5QVTAAB84mySLCNjCt/rIUGUH
SZy+5xPWszBWRyz69ibsuhks9BqdlzxAAe+ed9l69+lo4a4vxR4ng7n35aKm
AgaePFrgbLWGAsFr8hI7WAwM8rm5Kug2BfT7H9G9/zDwDV/4N/8OGgQ/2ajA
mKFhdFdbipEDHdastU31OEzDAjPtxfNJNGifWn9n9hANg6+M6Fo102F0q8py
hVg6trgFUd+002GYxzZ94iANZ96d2jR3nA72rrRDl+do2KiST7qpxADa3jXM
l0J01Lu3sutwBhum1rdkGBGNkTB6/3rTFQZcfS0XadFEx3OLzEvhtgzwhW0p
D+LoiD5O+l/yqLDNINQDhcho3pyneryeCmeSrpKpx0l454lRPsrRobd45dj+
dSTU1dLRTJVmwIPQAG1FX2M0zLeyabelgdYRxzXbJaWxmKhUWibI4bUipd8E
YW78dvBRNnEjFbyX7eiJOy2Ke0MPvf2dQIOvDuZHQtaL4n5aZ3bDHiqkxdpX
j7pKYsC6iy7+ZVQIOhVfGcKQxg0fPUd0bajgssd8RY6aHJ5Yr7H2xhAFksK9
ZiNi5VF4tO1O7X0axFU1LD3mo4wjOa9KHw1pQ3CldLTK09m6pTs8Lz3crgdL
KoMkfXPEMKHijqmiqz4k2gc9+cTZb+uyt6/2kk2h/2XW94NnlHBs83E3go4p
tEbIMNIPKWD/ar8Vx9zs0FhmvZyZLhOeHe+b2Ftsh9EKbpqVBCbwDy2UHYq0
w8+/1H0vX2PCja9/6wOX2uHDXbGWGjVMeLn//V/FHXaYkFd0zkKCDcU/AgNf
e5nj3FdjX59tZmC3sT60p9Ych8WKW1ZLEmC/ePju+lgLnHXMvvlztxmcaeVx
OviBhKWd7r7RnkT4uuvhFfErjhhnnMXKWs6Gp9x3H/TbOeFwZ2eJTy4T3g7q
VLgXOKFcQ+nOODsmlIVF3zt7xBENHM2kWwLIuDZ1906/p454bNxv/Nt2Mg6l
h80kLnFCC6aP84l+En7S2mTwXPWHVaqBqFhgvDmWqRFIo7VPrQI2O5/cd8gc
0/ftcRdLGrMqnMWR8V5zfDjce/DZqimrCk3x6QA5c5RUzNLiyZu2Ukq+17jm
BgtHzm5/LruLC4Ral0+H9rOw4cn2qYl2Odhd6Ogn18nA7QV/D+fc44ICs/DJ
4CcWyJz5+537/pSVvtw4r1+mBVaLrlC+rD9lJfiFy/jlMgt8PCGqWvPMAkkr
uNwH7pnDHoGooA0mTugjTF2oDHDg1EvvNxLPAI73pE5LhLIQ5Ux/RtlIwoXf
v5KbpIlwYjm9jSFsDRvl3geuIvOhbz3VtmfcHOZtzjY7eZJxluh1uTPCAgpW
xyvXzlHxxo8ljCfZ5vBD4v7eZxtoONxc85SpRYOjvvfnW/Ss8JfprTVD1lTQ
uftzt5wKE4OiZfNuFjPghTL9xmtXNuYsZ8QI+9BAMYSWVKjMxDdN28Ycn1Nh
ZrRAY/NfBorOvePe/p0KEo6EY9onWMi7vv+Euj0NpD9dHxHwZGDvUz+6lL0B
XBYjjeqrmOPyu1ZdES+ocOet9vV6b04/LDOD978o0GJAv/MniYHePjINKW6c
/OPf2j6oSseiuXhhaUcqTP5htyafJ6Fmj8QU6ToNurqVpGmPiRjLz1WkcIQG
VuSH/NE7SagTObGi6BYNYk6Za+eOkFDLx1bySQgdXvuX5fC9N0Yll7etL6vp
kOy110aBo/NrJQ88u+ZMh2d8w4vePob4OFuB5vueDtodBy+dszbBPkeRJ3M1
DNj099B2oZWm2FF142N4JAOOxAlqPrE0wSeTfkd5zRkwQSiOSdcxxZ9W88Ed
0wxIdbmQURNggoHLr3959JQBq+rCnld9MMJtnvQnM+4MiMj3KFZmE/DxK5ue
tW1MqGVLtt9/ZYomyg3fBLcxQIHJPzfrZIYn2d8UCEV0kDOeO+rtRsB1A6O5
F6OZ8Cme697lryZ4ZtKIYMvJ40tV+W9qxAkYu+mpk+MpFjwty1dxEzLBkgfZ
hEk6Eyx81qke+cOxt2ViD62KAeTmr51nZswwrnRAe3qGCQbVp26akk1wVKrw
jeRmOpTOF3DfKDdBvtBH6m6mdBjSrx14d8kIN+hX7nvNpkOlaZ7tK1UCPrhw
AlV8WbBDo0uykWmKG3Mi7GdVWbA78CNr/owhnnyy53zoOY7/V0jwzXJx6q2p
zNRefQa0Ctwsfn/BEPsO31SLy6VBRNAxD9F6Q9zgJfWtIJ6jf3/0zF6rMcLh
ZTPPHijTgDuk68lTAmd/ytb569+lgXxna+EQ3QDrLNY4moqxIeS++sbHzUT8
kx9ZoDHIhP/H1XnHYxW//7+MlJatrKzbXrdx73Hd9201SCrZUtGkRMlKUSFb
SUXDSGYDSYRLKmmRkFAySqEUspJ+9+fx+3y/f3z/PI9z3uNc6/16nsc573Mk
ICxT9qMunh3ROrPkCoBkXPIR6hC/vm5f06vP14E5x0+zsrWNsOb2kp+LztOA
1nLBZiZHF3Pf6JxrcKDC7TSXysBHOnjJXk/16Voa+Ab1rY64Y4wf0U1NYwO/
/aiG4AsHQ1Sy3pk1yfffglA3T6aIESYdth3u6GTBx5qjySNZBORWTqgEWNPg
U3z1gkknPTyX1NC9eQUDTslpfheV08J3ebtTcAcVJJe4yNs+0cUgQ5qOcS0V
Cvxu3RBarounh2QXeH/i2zMifN7jlz7art7EEmVRofD9uderzlOwkWLoW6lC
B+066XXf5/TQQ2V08agYHb6VJwx+nNLFV+JJw8vz6PDGJ2rXlIoOKuSkHZw6
Roe3m+uvxxJ18XPU0NKHF2gww76ulyxLwbX0wY8He2iQp1xzf8xABzc057Ef
V9PAIjH2529/Ij517D0dl0yFpltfTH5dIGLGyYLykVpzGKQ8eGu8Vxgt91vL
ScfRYH6L707CEx1cvFXwouR6I1DKlGHL5THRX3tzZIwSE8wzdbLjP/DXY/Mf
TfeiqPBAZKEPqdEIF8P48uhOCpQ6F1VIFBhhB66nfY6nQrNYhdUQyxTNZ5IH
FST4Orh5+9t7pSrYwvxTtdCMBhetk+KCq42wfQn70hzfHgLUv6pO0hS8QfB7
FkbTR2PzLRT6t0l2186usZftLFDeKHxcK1UXjXPtU7YWUoHnW0KMv2WCiaGj
Na+X0uDDmuSYao4xDqpG7vJR4kL9yUPHNkxJ4fRuvf6NEhxoWDR5m/hCkc9f
8jbr2QwI5Fz7sUhAGz9G6rzZGUGFZJLpm0knI3zi3EqwkaJAiKz7lRMSRJSa
fF7eIUcFkZXf2k+ZEXHp+mgdIwINRAYelN+xMcLyb4/7fD9TIVHtUnqrLhE1
+74cstZgwewaZa9PbHUkLH8gWnvYGAiNVx2MKmgYp5mzufYWFdaU2EbuH6Dg
cB4IZhZToTU2tPBynjFygrNXaVAs0PC5vznOAhQIt120+seAsA3fHEjHifhx
zY2Az2E0qOLsD+3QNcEUslt37xEWtInNjpDf8u9npUKjO5UMVva7Wp5FsnDz
IZM7721ZkH4q8MhZIW00G3gsMjbJhrUtp0yuimug2MWnRWN58rD6SLxY3No1
4Cv7+oVU0moMjvwu7l6nA38Xiyv7bONAV9SPRx4VkrjM4VCWuZMa6G8K7Fjw
RxRs3oa5XPYHGDC1jGhNXIX53m9JE4NM2FboqPs7Rg9z29klGZ/ZGHT0rL2u
Ghk6Uo4tvatjCue7ZY0+lFFRbS747tlbupDp40FK1GHg6k3tnl6DAJdtVrcw
6Wvwu1Tm6TWeFGgoXuUyXWqEF1draIjcJYPp8KWRP/z4E72674t2PgUOZRyc
XUE1xoJ22R+9EV/ZpdYur+65L4Ct+zbrENzZIJKfZ034qIXLx44uvniUBfWn
7Nn1/HzryDoXFbOICqOnPB3XNRDx7kWRiLF4Cvz5ynE3OsD3t9r7fjcqFZz6
Em6a2Rljty6haqKVDL71GQ2PBol468zrC6mvKbDtHdvjpoIJvsxIADV5Cnjb
d00lRxPxxC3dogXRZFA8ldST4EXE+wrHrLt6+fXUd39ARo4xikLuYO5CMnSm
O/joeRAxvmh08VlbMnj7One49hBRbN3Yl6YiEqTOzMhLjRrhB03VrxVENkaz
CtYsD2KAOUUk+ToAjMws7n69ZTVmeYbLnHsEEHK9bqJQWhX13pSuX2/Ow3cP
rDODLfhx6bHuqdgsA9axdC/2q/Prud9Ouz3q/HXBT370rKc4fBBf4nCsnw4J
q8/0e4sRcY10sPfBRwxQmyuIPxdDxi/7mnpe7uZCN0NPcpm2Am4iEjsPVQOs
qWuqrCQIoEaRXUAniGFWY/Dz1qcEOCM5dGecbo0eHFX1IAMuDNBGHxd8lsHq
sGXzGiG6MBvwcEXm/Wb2JTm5XKm7QiDqp/jj20sh3PW54Ya3rBikH6gWKn1n
hT8t+qaigQcu4uQ9O8pXg7eM5qLLHE1Y0BybL9h8lm29/U6PfbQIJNvSUsjN
FOguWtEqG0hF0+tWJgKmq7F537NYtRojuBxIzHfqtEIa+tZ53OIA4+b0HgUX
U8hdnezalrUEra4ZCpUsMIOgGyv0VlkI4mKH6Ja6PDM4lqFy1FBeCMfDuelH
88nAsplJmGwQQ52RpHv7l5FgTEDlyB0NEezeLBX6iB/n+cnV2mcVxPDWocjR
mgAqyDDzFae3LkVN8eaR/RwydPf+aHDhSuCi2s/VGw5SwOP3rK1x+GL06G4Y
nfDhc/nEhjmBpzKY87hg3HnUDLYN5yp0OazE982jW8tEKRC18dKu19JSeC7s
cv+ACX8+99TOcC5L4VujB8sWuFJArbrtwdiDFej712B+mRhf72jOdy9VVEcN
r1E4X0GG93498ZFFEuhLLvUh2VLA941gz7p2cYwGrZtGSSRwOGR2YeOYDDqd
as8SvMnXA7q5HJqyNFoEJnzheFDgwO3FHTdqZTFrzvvfiW9kqBRpif+YtgLx
hQjr7ktTuDnU/VB3xXLUEqZ0SP4lwU/zXVvWM2RwlaaJy9EVZHh6Ncpvy8lV
GFUVqvjzIQXmNdMVpqrVceNgiU59NxkGvu2RXcxWwI5FJ7qZZWTI6Cr5bqql
hsJ3Y1VjasmgKuL7ystzNTLq81hdqlQY76nQsOkVwzdifnuxiAJ+rwaStSvE
sPCr1rbb3/j6yejebUW1/z5/jFYDksKPz1vvTf7/58urCBBqZPvsw8aJ2oX1
GutObTDH3lzemeJlNPjYECX+toOH4fdfXCsZpkDog4GU3Ms89FmraZhiTIMv
8uQLFu7mGDxBs0u9RIObk3/wyQgPL22bC7XfQ4ed5w/k7bxmjkW222qST9LB
8QH901otCwwTMLl4TJsJM0X39gtOmKO3TyrvOjAg/t/eRZkd5niiOi0g9ykd
zlQmuXXdMMd8ZQXnKCYDtpGXJ0qwLHC7o+XrtjI6zJ6mPhab4KFVzfQat3Im
COx4dU33hTm6nnT7YvyLAR2EdlX5DRY4WxoXbGtJh9dnPbVSWeZIj0+/3PSR
ASYgaH/VyxxjzK0aBnwYkHfowscgEXPknD7ds1+bAc7d2h+qTpnjrRgzJ/cR
BhRZOr2NdzTH2qeiD4Sz+HW+x2w4rsgcP7bJfKhAGiyqGM54F8dEs6DIlCYt
I4h8EVPWs4OFqoXX7ya1G4DwZNoyex4THwt+u7v6lAFcXyl371IbE98Wbfu1
76wBPNyUe2R0Nwt5tix61XE9uHjx2dq7bBYqfhOV256vD2a3QsYymWz8SJtw
kU7RBynH2K9MfnupdIGw1iY9WHD/X0LtJSbODAXnqH3RAjfyZIE6nxtXJq+K
27pSF4TcUkzvf2DiPw2j2ME3OiD5vFlPkcVEg9qt/qitB4pvwhbaL2QhAZr/
RL7VhdOlH6/9Z5/DQz2q5Tkb9MEx02GqwoOJyn/OXRbT0oX9y7eUyQQwcePh
y8qZgjqgUr99ZbYPn6/PXzka+EkLqvSLjLYKMjFTZGRlgKE2rKqDVRnWDJTf
saTE7rYeqC4pzLJdxERCWvX8gkoNsOp7sPlEGgOXGuWkLRDQgSdLIfaOMBMZ
7g2243QdEHLpKvhMpKNd+UOdCRMd0MWwh5ulGKhW5lqw30AXRFnb7m69z8AN
cR4dclJ68COB2XruOQPDluKxSyR9eChDv/nPnIG//i4biJ/VB/VCncUD3Qzc
u7t408y4JgSb3qnx6aNjTfCvugQ7fZBP3LL0ZSAdi2d18rxX6sHNRs7mt/cY
mCgv8khexgD0bj+8/DmUiZPb19DDrmvCrTLzQc5DOtZf0h2vL9WA5gtrI6uv
s7F80Nbb6owmXFE4PcOlMLDgqHOi/BVNODQx/evqaRbG997V35miDh2lTuff
JLIw03VPwr8vmhBXlabU6MnA0xMfe9w3aEBf8F+loZ10LMzKTlq0RwuO48rh
0I9M9FsrkeQ6RIDiMx1W7xewMHnYV6tgtRZ4FNMU/9qx8NP+xSknY7ShNPzk
+V1GLFw163ZOfkwDwi28jiXz46FjKrbzcpY2vL1flMkoZeG7+hOll2Z0gP74
5NwfHTbWPTmbVimvB+n5hwxrLjOQufKRoKS8JkR8Ot7zr5iOZCOztnoJdfhz
dG39lRE6Cj0IjXGO0ILCRW9OS5bQ8anA1nCffE1oM+zWVs6g42RKtqi9nzZw
Z1tfd/PP/+hKtqUf04FHoiNThfIMLLk9p1VbpA1B41uvHT3NRJ+fw3/OZ2rA
dQGHtTpzLIw2au23DdKAR/YXDCZ66Xhyrf3hQA8CTJOmvJSz+LrPKUMoV1gT
qnK1HxjKsHFHbFei4DVNeLax00v6MBtDv5m4Bsdrw+74x9e/e7Fxvff122vC
tCDnt3PKt14WHtNKJUwoagOtODg2xhhQhB6h2t6hBaYuZuOPh9lI4b0dpHlp
wZSyzDGJtYC9jGnVDf0a0ND01HWdBOC/jIYlz45qQmqUvolNBxstTQacL9wk
wN6Govq13WyMOnI+8dYNDQgQyD0X3MLA8gPPZiod1UG88GRmJomJGSc+Wsgf
IsDjISWhZ4k0JAVyG9eEEuBsTlr9/koWltbfuHdQWAeO7O0tqGEwUCi+7Lr+
IXWIvNiaczGJgX1fG0PG1hLgJa1i2dFQBt4O2b0i00oNVJ3zxthPmKi6ysD0
6z51eHT808OnNDo+e17NHWggQGb1gE60IB33P185c0pHE6p/VLx2M2Cghd25
aq6OKqwN/HR703omHpb66zp2XB1UZj9ozx1jorPLUeeUBWowsy1y/dg1Jpq6
5og0kAmQddvQdmcAHcPDZpZu+a4Oqj2twnKPaUitb29+dVMNJpr6DJbY0/Gb
dJT1t4sakOkreOR+Cw11QmU2nFurAT9C5N/c307F4yOayXsvaYL0aEZEAZGG
i9x2BC120QRKYcr039d0fBzaKuaQpAIzk79UreLp+Gf1ndxDDapwZrhdoGWW
gW9yZSpDCGogxzvpe/U3Dffb9e33P6EKfp9vnHzAoeM8Lf/M3mQ1eCJ2Q8hi
jo47VG6ZVPDtJRHuc2bPGr796x/0LvNXhiOpCYdP59NwyCvpmoGVChzdVhL6
QoKO361cSzrTleE1a8Vg1j0q6n9I9N6fowrMqu83ahz447VFfzes5M9HNBvV
V9FQfthz8FO2Cuz2KTqXOE3FmwsVU5u46mCb05j8yZaGGXdpH1Vz1ODxwWnF
xlgTTP/adfaSGBF0suYIs4FWmN8znKzgRAPexJ6V7wys8XiIImmHIRXUdKdU
x9Ot8ducyttrGjQIPzIrnPPGCv8uUrp0t9gYY9N/+L4ItcbBl36T2+aIOGpz
3HnxUWus5ZKMJ41MsOKD/y/NTywwS3Q07Us0wgnV37IZLy3w1NEG9rJlHBC0
KPq6s4uNuVPnu+7H//c7gu0m//t+n6RXmv55ohq+1Vmod/a9GTxdHdXFPAC4
pHXS/mIZDTIDDRr2zwH02vdVHT30t3a+al90iwsHrCpnnIoU6Zgnn/kVswCi
oNRAgLwE2+a/Ftva8ODcNxEiacGvWv1J2YUtchZ4bsPbBze4XJiVJad95Vqg
eZxfkTYB4NZ89pasNhWQCP4arfCKg2sF2yd7vxpjsP69Z1uvzrLtGqTDdxRL
Q/xxhr6Hrz5Uktu5ZQGr4Pb5Gv1mbzWoLjl+uOmaMnAe9niRJ4RgQrlVKXLH
fO1Ob4/EIS9j0C2663loP8CcnlbMQ62FqDNmLJ9G4kHhLSHrDb5quDpv9oS+
ABfGdhnviVwxWyvROh3V+0cLFt/4WtHTRIARjmiYmroZFKinTvRIsPB4o2nM
Bh+Ax/Q62wvyZLQxnBcjhAAsJu74fTWejFk8A62YlXy+IGwtuB9qimd6o7c5
tTAhXfmLZb0dCVmvpHsUYtlQGaJwLFSXjH9sYzx715hBoBd+uxXOxFBVVfob
ERJ8nyH2F4zz10nbU9N/y01hxZjfMGOCime6ncOP2pDg5nnlqM/8uA9xKfhg
0ikBhaMfeeOOHKxPDfi88I0YMPw7An28OPhjk9TPO/NC0MBwLzFeyUHt6DAD
Q7YoHJT54+C0g4On9s6e9f62HFRLK/q0jnDQ3XHVgQBxUXhmYhe+spmD1dsb
snjXGDA+anU96J4RqiuKmqoNmgBF17/yKJeJ+y/kV7yiMsG67dbFvQsMMXBV
/oHNliRYZqPdkTpHwx3WooIue8mAvkSvzIsUJGxWcYpZRoE46/xtw6YUFFmp
5Z9RZwwXV7WptXZQcdl7XteXDhIsmFZvXtBAxqMSGvtMga+nrxmvYvuQMT3y
cV2GFxlmj/X/vraAgj7ho9dNgAReKp/tCXVEvOQ4E379PRl+vfharGNtiL8D
/LbW/+Lr9+uOd+2W8fk75qX78FYKNP3O6C45q4tMX9eF2bUUYHRM5y4p0cEj
DF6vkgYVFJ3dU393aSCR22TvepICOa0vmFfStPCB5nGSTjAFlgV13Uks18be
eeUXy8lUcLhcHlFE1UbxHvFHHo/4et/3XcI6KW1cZUMoaV9JhR3GQhEfVupg
0NUGYqM+Ce5r+bXcltVGpbxxif/8/0k26zyJwj//552lXgCTDKNnWNt71mpj
QAhxfMacDF9NH3jBFw2sOrde7HA6CcIZ9y72FmhgyPPZy7WCZPAUTK5eIq2F
Lm2735p/JEHXRy9BwiYCFnZH2J26QobC8iSzpV80cdQt4OpjfvuWMxqU0e1a
WJU9YfEkkgTbOtu/fXpDQNvwnstJfP65ZBUsImqkgamX9hVaiVBgXRB3NlmV
gF+696dKHSGDL0Yo3Aog4FhLy3GPBDJkagW+UJ1Sw7gnO0zFzMgwdnNnwPlM
dbQR7qpYyve31y5pS5adFvovufajMZAC+povq4hETfT7Wdf4ZZAMc9IC5CcB
Gjjk4+qS95UCeyVSG7s6NNH3jrbjVB4Fiv+JZz9rImD3Txm9nIUUmErgGStu
18QXb8cLNtApkFEn5ftygIA6f9u3+DDp4KAaPPQxUwuf5ai4O/C5wd736SG1
AkMcW943cM3JBFJVBdv3CtLw7J36ngPAhaSVkQeCXysjbcBDMuQBA4w1AqzM
1Ym4MHesqMEc4LhjZbjhVUnUUdBIDc42AOe2H5/OvGDjiacMEWCwsefEycq2
HRRQ5W3IXRvDgQ8/T3hJKqjiWZEMv+aLVMhNPqkhvMwYc94XMs2jSLDC1DPF
3ZmIZjVDRKjSg+NOlmeOJXHQR3RD6plkGmi8k+8b/GyK2uW/2uUUlfEe1zOC
WG0Ke19b7NugIA/zS/Y5PyjVAfexamvSczaEdpsUXzXTQpPpH2tGYsVR/srT
s4KjyyE3IOD5xGI91CKlv96mJQkbfXIet1laY6oERbLkBAcGd9VniRWuwgIj
UeWOA4ag9u7sH8m3snAQFuxi/NQCibrwfwXkRXCrysBtMFIMvqlblKWUr8Ja
emzrt+u6EHByNKO51Qobq22DLy3ggqicreQlbxWsP3kqe72eEewiKdkQ661Q
NVyctS+LCz8q11dMb7PG3UFrVv+Y5sDAMoG7qx0WguJgvvj+Q5qgbjKVXdbd
WRv67rDw6WIREMtiOO2NZwFHacGZeTESWsaqahxGElj+6Pg5ayqOLd7suj/7
SFB177RH4TspVL1UWuHbZQaXV0xu9r0hg9t03Ngb+ylQ/Yzhz7moigrXLtQ2
x1IgMcG3zrJKDfdmSrZt2UgGgfNLKpepyOO2lqR02UwSlN41mXc4sgZf5Jrq
3WgjQb9FVglrQgE/jN4fcuX3Xz6e/X58vQKuoJdl7+bng/XKNaQXWmvwNFun
No5fn4WVzaPqchSx7Li8v+hWEqgdK55Xz5JHhQ9gQqk2A5+hqxZpT5XwRmZ+
7mFVEgQ/XPGMKrUaE3w2ktbtJsMDp5IlQqqKGHDDLkxZhAyu6PNU86ISGsu8
2mPkbwai3F17HwUqY9ISzSN1SST4qfVa/Ny9VehEScoVSjQDXWvXEuH8VbhA
9ohLA9EM+oakBx5/l8Md4oYLpBvMwE3/V5fATjl8nmrLMz9rBrjPX2eC7zcR
Y3J87yoSiCklRjvz+3/Y+zOv740pLL2nbHhZUA7/PtUdvDliCu5rJE3E2xWw
5MfurlWvSRBq+2lHpocKvnbfe+uiND+f3zZJ2uxRxrpL5oXEGBLEKt2n5Gao
4kKS2Y9ZVzKYN35hv+dfL2iXuHo/iQrN+xhb1A6pYMeKqi+SaylQ8qPdE+6o
ICpNm9W+JEOP0CqX9jcq6JPh0qmrSoHf8oav/VeroU+87xXKbzIYKgYJd4Yr
Y8y2Ou76fXz7aFnve8lSxGkH1v2yWBIYxXsbD19TxjtSQj+cBMjQffRhb7yW
GgZ1LRLy4te7xMHKo3toqvhJQSVwoRcJhMoUZx6gCp5pWRd9VpoE2skC4fmP
VTHG0apQopgCO555xeaHKOOE35Kmr8spYK71hHj8nBISPPI2/VSjgqbCt532
nfJotLe8wT+SAvWhk5VfihUw/NjZnNo0Ciyv3VY30sL3v6HTht25FDij+PHq
QSU5XBTyk9M4xNeFpPxVqa4y+MkFJO1IFAjplB+4cHw1Hiv4avFXnwoGV/4G
jBXL4pfF6fUPGBTYni/fOGIpj80pxy5ebuDHu/jy18K+q9Cu3/hzyzcKpN89
/czfSQpzIu5NBYVR4Av53Uu5BEmMb4j9EOxNgZtxPtP22dJYupqiPt9JAXmT
k6ZWXBmkMTQkxHdRQUA48MLrOGlsGizQCJilwv6/5fFOaRLo6el3eWQ/FRLT
7qbqMSTR+0G6ZUATFfw5pjZth6SQJZ8oI3yHBqlLxh5qFkph1a4MuXt9ZJjQ
s12tHi6LmRp5de0rzJF56NruVxQqTCfP6G9/zMP+UdZ+WhoV9Asda1al8PBj
U1pKhjp/HT1fsW6on4ckxWaeiSIN2Aa/yl4/52FlksfQ8BMa1DFF1/3dxEP/
vMEwFT0q9GuelBo9yENaSfnOA+X8eccf8DVs4OIyl5JAnTt0II3QZi4sNcfo
XgVz1VEaNLS3J4c48fj8/UFP9RQdRFQtZCav87As6bKSgzUdSnpi1hu58HCf
i8XUyXoa5Oh987Il87A3P+JMqQEN1jUc8qjO5KGhTI3LOykGeNYoPOrlz1+Y
e59m2kkDyctGqsl7eLjHmm352ZkGzHrl3ocDXFyQnZiXxberX1+Id3M1D29H
2T/XvEWHz8M3E1y+cTGE99D71HEq3Fd5t24ygIs3ptbL3bWhwdMQm4uPcrg4
kbo75Mo0FS45fVCX8+Nij7uUZl8xFdYHDIoEkcxxzYiIQ/VhOhxVKK6O32yB
PmkCax4cZcCs3pKCCWEL7B1QC9rzkAEje64cOPaGhxIbtUi0QQZsf/YtZ7zN
HMlF3r81Zpmw0Czv2YyKOX61axaNd2DCnTBLCfICFhpxLk6sO20I18rHfk5f
ZOHoinCPE8uM4IFowV7rhWxU2lR57BzLCL48atqnOUpHr4Ndc+biepClZ/Dx
ySca/pDqzpMu0QOTyzctbg7S0Fzex3LAUxeaqblGe4/QMOGTPcFjSg/W3fu4
XmWGitTaWxbZZH34R9q7++QzKnpmiiz47K0HLsLddnbvqfi4SUB+TZMOJJrU
PH/kSseNnrO//qrqwuDHZbfEjtNws4LRrwSWDnT0Kfw0sqeh4e6tl51JuqDN
3nij9i0NT8epTmrKacO7Qub6K/z+lEYtNt8V04ZIu4ji4iEayi4+FjmlogWf
v8h+Sxel4bXkqwqiP7Vhr2MaNdyGhR6RlZ6VQTqwozw/JrmKhS8S7mg96tGF
Mi+PkXICYNm8sPC6a3qw+4nxqXXObDT3HXxT/l4HlJcOjH/k6wrhCyvs3F7o
wo6EBIfdqWx8vnA1IbFeDx6RJ2K3PmfjdHVhze4mfaC7O8YG7GXjUt91GeQc
A9hx9YhGTy8L/Y3sZNp3GsD12mcHQuwBybmH4kwf68CATdewVAsLPzcLGphs
MIS9N90qXv9lYyfDnCjioQOUuH89SrNs/JAgudndUxt+rePGndMEJD0p3P86
RRd8/cT8IkiAbUuzOhd0acO6rNDDJe8B+/fItHCI2tBmc8DodyRgynDUVjdL
bWBHN7ZwygC/NcollWbowHH22c77eYBbWzZH193SBD2l1vIvdwDnh951pz3S
htUcenMznz9jZnesusHSgtrvO+5sKwJ0n4fhjZf5XKbodyhLkYUJZglTt2UI
wFv42T07jIXlEUfZtj8IEFBT/MGCxMLkzLt2wSQ1IHgIaVP2M9Hruue55aUq
8Hbsbn7EUyYKO1//d75eGT5oRsY/WcnCi/MaL7J+qoBK2H5v4R4mGkavdCsp
VQWir0mS928Wbuk5+2aNkSqQLylUHgpl4Zmn7H3r96oCjXfUitvNwlNhfiXP
AtXgXPub7BUXWBietevLTYIKuOtszw/ksbHt11W1JxXqILndJfrFKAuHtx4S
OxlMANu0rNBJDzZOJCyy3vyZAJ33fiY4LWGjHdGHoLBOBSqFOzMvrAHUEpJW
FtNTheZn8Ssnyth4VkE0PNZDBfK63lc0NLAw9vc1m2QXZQAbp4dTl9l4fUXz
8kxRNejevFpWib+863Wqb026oAxtV+QFrI8AKgw7t6kfVIaDK1/MFvkCOp6Y
/2ddrQLRhmVCtY/58bAEIqR5ynC7sG/R6Vds/Hfm+3YaSxX0bkalixmysZZx
9G3EN1VY6WCfyZYEzI4+XXPbRgXo5WkZl0IBHwbfkvbdpg4qZknFEtv5/g6T
HUgWV4OEuNtCiTKAF0LtRV0c1YCtPqMVXs9Goun2FksNdagu/PWncQsb6z9u
r133Ug1MWTu3FekDSl98bxJ5Vh22f7dSePcbsKpTV7R0km8PB1vvZiEOXm/P
THO+rgI3Fj5YZ+oJKOLRVb8hnQATcW2GrpWAo8c6fkmrqoKBgZz7VCFgMvVe
g567Grg7NV+57c/Bpu67612uqsIe5ovl+Vkc3P/9/uM9D1SAXRw5xdvCQQkR
rdLMQBWA2X9PvTQAP1YebH1ylACq95dnXE7h2zc1u+pmlAbECyVznxhxMC8D
FaIOqkL8XBA1ehcHA2vMb4kkKUOpwb+7PD6XKxssZPXqaoCcUZ/U6lnAAMvA
jf8WEOAx6V0Hj8vBtTl3B76Oq4GoYcnmY/2AWYu+Z5+eV4MWaUfj/GJAbfBv
tbElwPftIxoH5/j59vSmb0q+Buz7db2mtRRwukhjmu2nDv9oD9UFewDtBfvz
nrwjQJKN0uGPTwDjjSMW/BvSAJ1EinNKIRXt9VJtnb8T4EmwTX2HhAl2TxMb
XOz/8/+0YhG7WBN8umPEI0fXCAIEzq0W1rDCyMt3cxda0sCxdou9yBdLlGzX
2ry1gQ5lxxv75nhWuEDX3/34Mjr0Xf0SELXOCq/m7FwFGTTIIwhf9pmwRL0r
SnXsZhooiCW8feljiZb+IvtE+mmQWfFo1HqJFSqn/+vcYk+HjS+NgkudrbBT
1OsMSYgBJd8O1IVxrTCgIoAhHk+H0phrSxNuW+JWa+Nj34tocLD5A3tbHL//
fauzvxvSoPXm2E+9QkvU8qDxzvD7U113vm2ljSV6f8gSZYnR4H3hRL2KpiWO
dDvVj8/QoStI5XSOmyXu0n/zeuQkHUJzjDuKtS1Rpp+mvkKODhXrh00+mFmi
U5BGDDmFBmEsaummrxboe/6Ju0wUHRKjW8pKz1mg9IDl9+M36LD++qicTbwl
LjRpYopYMuDDyrIvn0ot8LCn4ch5Ih1ixHPduw5YYMWjbt5rYQbkPbokFf3S
AlnLWstcrzFgtCrC9fdtC3RhDd5JUWVA2P2h5Fc/LDAjyffYcVMG/GHtiUmg
WmJV1c9nL3sYEHonjZyda4nkljATzzd8+8OV/DZPS1TYsnRGbIoOZqtfbP75
0QpPdRkqDc5QoZoUxhypscLb4wdEV4VTwY2V6Cgfb4XWWuwO3/dUEHkW4n5u
oxVWXJbMa/z2f953f0aFJ9HciKyT1qhL6TIZLKOCcs0xfb86axRmri8f4usP
OavnQ1JEa1xW4KP3cp0xui18Yi0vaY2bBb83R5sSca1C7NacAGv89fmpEOOC
McYT3W850azx65+PnaR7RDQNSGgUHLfCMenUhN+lRFzU82V0fYw17oga68yc
M8KSC8NKngesMJPsOMjKIWLkhL2/T50Vznduf6dsTMQ8o891C49YY8m4unhN
EBED29xvXr1lhdPr2VcWvSFiaNt9CbeH1lju3ML6vIOI629GzM/4WeGx5Jpv
oW7/8x30f+93moghHgIXeeXWWGX1J5rXa4xHLgocnH313/0cXP/P9dEmeCpq
q6ftfWu8Y2SxaWGACT562vc0euB/92vF9TO1x/6GW2MuX3u9LjDBiOU3KZsr
rFH/XhOJKGiKI7P5f66bW6PDl749Tp+N0Yk2N+p03ApTiE+fzqsQMeYi7hoZ
tsS3MZahPFkiKtm5cAtM+fkjkrX0UIIRJnkV+53gH08a7tezZxOxs1j69dOF
VvjU+v2uHGMjXPp2qi7/uyWGWDuM3yYY48Ro/WzBM378L9tyaf05IzwsdTVr
5wIrdN907Pr0FSJ+WLGmhOVriVfG4xg11kS8YvRmFWO/JZI6XI492WaEBsxX
18b44/3s/2WxUMgYF1/uzrTNt8TJMyZz15cQccXF4luaxZa4MzpwdMUDIj7R
85jtNbfEjYEqfppDhtj7PfzBrlOWeOPQ7I6v2YZoFw7DPzMtcY+U8PmwLQZo
l2DLKKy3RK8GA85fCUNMMVL58j7CEu1/HfQNum6Mt5tvDz16YYnzP7+sVczT
x4/RQYGS/PFGNyz7oMcwxi6jqhUNWyzRtvXDXcO/RIxaOrX/fI0BPjKejA2V
kYHj8haFSq6iePTVhGu7ojbMb93AXJsogF0ymmmPYo0BB/y3OLHE8eAKx6nC
9TpQte5W3NYLhph90LuvaLsseG+U+Sf+WR8LcZOP+mFFsH1XNO9ZJ45j7Ihq
7VIjUAyZX/ZCgQWqvJ3yb+8a46TpopDKxTzoV7FtlQwUxf6okCVDDly4J6q2
d/sWKi6L+ydk28mB5u9FMy2RC5EZZCKy5BXAlxUhG1xWTNQmU6VjjKsAVspU
FTgsmqsdGIy7UihvCIaJi073n1eHabU1VS9XWOImk4vVVrd5sMVEY/OOMRIk
L6m7MpUNGHueVVMazsaxl4UwNMfnnbVLj4qAHHwX/SHy8sk/9ma7hWoXWrkg
W/V87b9AcQw8Hmyb8JQLbqXCWn7pArjnenO8fzoLk5zI+htbWXCVffqo5waA
JL8ba3ZKUVDMc3tDUvFo7dZv36wvkIzA/UPQqIsyFy5/H014wBuvJQX/k9oq
woUU64qXYW+EcO+kpzP1KQcqOe+4jvJztXXGlweOW3Bh0or1fP/a2dryBvEX
TqNc0JFzTykqmazdFvHmgfMeBmzhUO8UxhtjzZfyKHoMB/b+ktLel7cIa/91
+K8e5ELVLscgeXFJXNhNjA5uBqifFnl1aZcZ8u5IR2a+ZEJ9taxXfZYZBrl/
jmn6zAOms7GghZsiegiXfrFv1ADbWt29ar8UQdDpUQd9G4C58flPU4km6N8j
OCb9iwXn/UWIvGXGKP/Molafn7+0xyfHq56ZA/1qS+5daR6suD08krZsrjZw
H6P0dT6AZpv2NNWYgnJ+4bmq31mgZrzXNcaQiA/v/H1FYgqhQ1mPlgUYQYyb
tergEh6Y7A8ur6Uswl3vLuwfq+eA3nx16+CwEM5cNuOsaWfAJXvHPKFYY/xK
V8xQvsUCXd0Ta76VkNDXRqatx5gHerPdxs99VFF0p6SJqsdU7bW+h7/WbjeA
9FIpT/t+Joxu+r1QVckUVUJeBp2+y4IC2QPiYUGmmFtit/FqLsCZ+0ZppwTI
uKzLX5JYD2BnkXA/l0RCVebp1ab88UR3rdAZemiCGjmzbborARSNvo8PohmS
u97toPPjfeZf5X3mlBnmBLI39o/QYKXWj4oipinG6u24GG/DgBMlDe4MURJS
zrXsfFhHhiV/KR3Un0w8YvBteaUYHZY7GDau7CbhsyC5dLNFTEjqyOrXk6Bi
6pWruqQsMgh9OlZ90puFV3mNghvLTaDjU92DVRtpOHFy9/otmqawsa7/q00J
E0/msDjnFphAq8cA48I5BqIEofm6EwEOXtDX9qZy8cefTxlnfmnD6Np7thGp
XDS45snhySpiZM+OXE+aMfw0fsaiOtCAa1S/tHshDV+mPTPpzTWC7do0twpp
Or56FtsoecUauTUfyx4H8+B59NCnJdutMS+be6j6jyXoHPjxyNTVCHKaZI90
Z7LwKNs7w1ZXFQwr0zNkYgGP5FJ9L+7XhqHKr0aOswy8U/Uj4vYOPThGetJy
qpWB8567vwwLUeCD8pt+higVC95FFZ3sNYJnl4qkaLlMvBm2gysypQKuhbfi
XBYCzlgfWGy/TA/sw59eX1VKx9u3sop++0yx7QXKHl5JkwEz9S8Jw/MMCH7R
PLdLi4Tud57vcN5Lg+z3PbZd/PHDCdcPL/EnQdn3+M/lcQy04b2+6P6CBLVx
GcMaBRT8JnfMJOYPCa73NvKW0inoSDHglNyjQJXGpODmUAruy+wW5u4mgWt9
3qfcATLev8UxKL9NhV4pn0ekbm20I3d8PTFHBcdDHZufj2visOLBy77+VHgn
YzZyqF4TH+NVyZG7VPCOHH/GeqOFcoviypx30SCtvK0jV1kbCTkX7Dc9JoP3
+qJzfct1sMO0O2Q/hw7h0Wujb1/UxqZwJ5k1FXSQ7Nbb9UlKG/9NPLRP76OD
7F3BTkkBSaTPN321HWaAVhzLyvKyLu5xf15kaEYHHR9ZSeIBY3w0HNWfLgNA
O7BLh2mjhh8Wa8sVGHPgQXBC2uE8ZRSvCMk97cvXadHdaQeX6GMLfdkJ6Ut0
cJDNmK/wl8UXpq3xiflEiN2yeG3/Mjb6vqvP78zjX++h+ebrWx1kLbqbcngf
gOMO7oa/Z0Ux7OuA6xUvJkwdpm11PK6Jv1x2fzibog9HatWsInO4GDdVYbjU
Rgh/So5ueDIsDMav82/Y32Yine/s1wpUGGws+9VqzoMxa53ELToEzLw+69K4
hQm2gTNvS/TlMFT4t9gTMS7seKdtnqKlgc5elKSGCQ7EsKG05oQk+rsXu5kW
m8Em6Qiqvpo0CrR0rE1fSYV02wAhyU9qmOWz9PKPQCq8OPBSTlaLgBn3NrRw
cqmQb7dO+vFHVTR9vUzgSx0FZuZmI5bcUcGWb5HWBxhUuKT8b9O0rBqWRj9I
+f6BCk05woc8elbjIwfTw2YiPLy757HJJ2U69DCdF9fI89Azu2pqPocGkly1
q0F1XFxrXfp7oJgGEr7PhQW/c/Fv9dyK3D00aN6iL1K9nYuTvOOB7WQ6CGea
igw+5WJ0iFnwKwM6/CnYEz8SwUWTme3zUi9oYNIxeXhQhYe9l01nbkYyINzM
8lS3rgWuqXixPIOvr5sH+td3LTLHTR1uq5xzGeDn0M1OHzJH6tHLhQf9mHBr
b/i0UpY5PpTrYNGTmODtZX9jJR8I61Pep4pIslCol5RMa6Xi+Ae20+oVWhBW
kbx0uSMND29JCMg+pQVxeTfe/4oDlDW8HJetqweXLNeF2tVxUGniZlpapC4k
mahJTuqwcBomtMYk1OGqq+3zM8qAm8uaglzsNOBxl49SpDkHu7ofdf9QIsDm
oyJvYrQ4+CkskNHyhwArMrOP0kr4/LmrWi1mVB3OXLYQPxnGwbRTHkHmDgTQ
Fn785SufN49sza4X+KMJuz9b2S7246DQ5reOg6Ha8KJ9q+oFPn8WbxFp2rdN
ExSpJZoy/P51U34c/v1PC75OUIV6OjlY3W/vd6VKE2isufRINQ62s3bLdVTr
wOnrRqR+Pu+KaHAy9V20QFZ8OFLgNgf3XDuxz7tGCxxOhZfXJnHQdZ9k3i5H
TTi9bWC1AJ2DlKt3z3v2aUMmnfBWhW+PY9pnStYp6kDjULiMazMHu6Xe3CnY
oAFJU4ofrx7jYOjTmu2hzTpgx0qaYqVxMe9sgHHpax1QP6Fgmn6Jg6pezvXr
QjSguNNHuI9vr4X2G6OWe+sDyU92R5wmF2e9g0fTm3SA2vyD/ITP/3TvnY3J
ZnqQJLMlKnWIgwMjNyfl+P0HxGpaXlvPwXvpHyKeBumCiPap9v5Rfl2N2X0v
WUwP7ioHVC9v4+BJW7c43pQ+WNsJvrmTwrdnsG5Q3WZ9ML0/2197iIOvica1
ybcMAF66hN3s4GDkaqeDueV64P3L9Z7JEi7uy/YIuN+pC/XuAlH+DC6m1yyq
2sdv7+1wdTrKg4u1M7WmEe260KJ8MeO2OBdXU0mPtj/UgyUzIyH7+Od/3h2a
kZrQAcl2da2NO7m4xHNRk1u2Frz0E+UXOC4etR0cetaoDRfV589+bONiT6ah
vtMpPXAe2fr992t+vuyW8NuRpg+CZ/RTEmK4yF0ckp76Uw9UxeQXkZZx0dVq
2HRzrxY4P8i+M7aYizIfemj+g9pA7RQqvJrFRekNx6t03+nC1Pdm7Q5THj7U
2MQw79eDX+abFp3nx8u7nfX1WzZpw7UGtbLQGipuG3B783xIA1pfhZs0iJug
ca7s6f/8j+2O4WJ2+2si3pdxPDKYYgT0BxW1JbuN0W9yoiXngxGsJDcSv3sa
43TQGvYjTSNQNrDxre0k4pyjSD6dQYTCp1bbP/saYQ0x3q1mARGMrg/0UjYZ
I/Npa2hgIxG2dntJNCoS8c2d3F1n1hJh0yfxv057jfGUvPrdZ1uIILDoft7G
o0R8vPPfCOmHEdAcYwzP9xrh4n5tA39hI8itvr4g2IqIDnZZR5h7+Ou4cFri
YBERpVpbU51MDMGNkRq7Eo1wYGeS2HS8EchrmzbccySi1sWNmkt6DWFm4xj7
2hsD7GgUHs/uM4SmtW6vUoWNUDW146ThdiM4+/O0yslTFniwzZpxUIoJe03D
7n8XtkZBU/YaqTQqnF31/b5v53/5UY8Gv7wSbp53tUK/PU151V+N0eOl/5Hr
vy1xfJ3uI9OFJtgtecth5SNLPL+Ec4F0zxgz9ymdDlpjhfseFHS8iDNGn2Di
b40qa6x0FZWw7iOiXPjBnbZUS2QJRz1+22KE2Y7bfjOPWOIC1y/BK14bYb+Q
myjdwBKzjTgBZpuIuCny7UaFCQu091H986PNGJP+JDypz7PAGxdJLVQfvh7H
QzTCEwu8Nybh/KuNiLfqtLazzllgrIP6tsZFxmjS8DD9QLMEjnhIlqV56kLv
I9dzzbMW+ENoM91gjgseDWOvT19hQ7mOvK38BWM8ViZJ3a7AATVLM83GUQk8
8ISW3LuBB0fD1P50L5+vPWhxk/v2HRtUUhzlNYLJuO5fpRoeB9AghBwh6ZFw
JD59rNyXBb0Kh9TYHAoemfi5Vz+QBRV32NJ3bck4dWmsbVk+HVLP+DYZT5Cw
dk2pxD5zgNJKxivYaYqPY66+rbVeiSZWm/3GZUgwv8RUrIhujU6ihsVn/5jD
tb+egvZKMtC4p4tcvkUPBJyeB4uq8uD6pKzIkXYN9F+vmDEqyQUBwSjYiAvQ
4LHXybnVPLDoWl1o00PAoiDFc+nXeCDQ4Wn8dI0q9g25nyzqAvjt5JM+4CeB
bTaVT+SOMeBUvcwpK7IcnrgZYpFzSRYWughwew4KgmUN5cw6QQ64u7TfuRJj
gjH939VOPeRC++Oc01lX52pvhJHKdzkD6GZ2HDxkr4IFnuvEjmrRYdvh/rrq
KBN8E6nLeG7IQprGQHqhBwNCMhYuUnloiR92Lx4z6jSH4LdaqZOWAF3nr4ed
DVHCox83nop/SYW+jRZyQcvNsOqI7vzncXW4ZNPjcGknG6VYNHmNInOcLruS
XXEJIGE56bXoEBXAqm5OUc8Ez3kG/V2YwYE3DPHNGjpUzJvYV5i7VRfu9h6b
jtiqBr5zcXfH0n/W9sQOP1p+1hQ6c15+XJkoC82bw4qoq7i4fJeXaI8rDQKS
+9RkDYg4coeQU59HB6/Wz3ZDq/g8Y+lvpWrFhD9zG9afadLCNL/za81lqfDm
PS9Zk03H718P7N84woa5tPq+tnhVdDMcOqJiBihiusFwZCcdigtarFaUcGBU
EslDL9fgSTf6xhdbAMS6R2VaMtTwjPrxqJ7FAEuec+J2rNHGQ386pJenMkC8
T3nVkw0UrFoTfV8ykA3D37UcnCxVccz8gUTGY2u0GSySD0+wBBm/4p/+aix4
L3lI7H2eJrrRztKLDXWgqqpzcLqBiS87Vd5kWLLgzPMZ6SR/Es7nb02PUGFA
VLiE2cmTJDQu8/3qNsEEN/v3b6du83mnRG343yc6pDOvTT+b5/ujUjtTq54N
Es/eCBVpkNDZV7DT6x0Tdv2737JFhoyTUZOHrdYz4aqa47RbqBlqdz06oR/E
gkLatI3/IBENGkeWT2tRwfR8ST3pORU1tGs7pys4kCuS/XXdVW1cBfdaPvXz
4yn4c9LQLyruJMdOnXMmg3NXffStTirO1X0zVbYyhXN636gsQwZ+ctJ8KPGH
AgfOMMZm5CgYYLN5YDafA69MX3B+a4ui0uiwvHoDC2p4onPWyaq4Q7Zjs6Ao
FRaJ5rIXvibhWYcTSrVX+PqyVY7yQJ6M1X2FCz4fpUBI9rN9IgQK/hE5fGBX
IQ1iaZZFfp80ceWPSNcYvu5zXv72YtpDLbwzePClzR46mJGeXdHu18DH+3zG
D1jR4NO+Qyl2BA2UWPtK27aWCou9dlmVlGvgu6iX5ebqdOibojhfv6OJ7F09
H74306Bh/nu9/y0N5DkXDl+1pcHOW7rBYdqaOLNmY96WdipI8f6c2/aEgCWM
x4e/2dOhsndR62ondbz0qGWj7lsaNE12h2rZEPBHzEt28WE65PZl1rmkE9D8
xZQuq4QGRwwmFx9brI47Da5uKdpIA9G3Cxo/rSbgw6S2a7kvGLBpLuP8+H51
JN99ADfP0MH+CWOLpJQynv8lLmfBn88+UXHxNTOq+M2HfYe2ggFXQX80q1wd
J5a7hOxcQoNlS3vruPtU0PrBH8ldC2jwk+YWW7JRFR11N1fVfeSAeOkte023
ZVgudHO8c5cBaJ5nmuiF0VFTOHu+olsZRacLU1uH9cF18pyDPZkL0V6Dira6
fB7mjSgEDXDghHxEqPk5VUwi78vEJia8L4wdtYvVQsfFmcmlY3QwkNk6McBf
N4nBR0t8DnMhl15/OfiQCnKW6sRqAkDrG+k1viWq+PLhxuilekw4O/g57KC8
Bk7nB6hRcgFWfd2z3J7PZzI7hcsOqNBh6TRXibOGiXqPj+8Oq+PCiKJK3sRG
ArLsY5gv7hlgctVnclnFUvj7uKbfUE0DBho10nT1mbh9/ZWUnAwWiOcOc+MO
q2Fu22a35ceN4MCq4OjlKwHNe/wsXEU5wI5QF5b1VMHPqeHu1dMcWE5sT/Hw
UMeL9xw3tRcvgRKxVw/L60X/+3xc+X/2C2JHDJ6dSAjTw85UE0kTh+VQbLjz
6QlzQ6j5lZlTY8XFp4IaBhfXsvBN6gPx8XEy6L9+jqc3kcH1+xPfI4pLMFP2
Z1PHflM47cqQ4XStQKGXX1Jb/CkQIaATnhuuiotVlIpN46jg3Pmn6rumOiay
Kcu4BD6PjUXsLOgjYN408wUUUGFAc3tksdgq3MC+zd4rwUOlrkFW3T061Kg/
3Z88xEWnBcJ7RXQZgGM9lrVreZh7RLbJkx83pSI/2vZ9scQot0u9L79yoXe1
cJhVriUqBzUqBspw4RBR9d0xPSYmDR91YfDjdMEc68DeLL7dLnUfv/aDBlWf
9ctO07hoMd7mdCafBi+uvYBttVws8zja7L2YCYd9puyzj/Cw8luv1kMJJp+/
0icGvHk4lna9rjSWAQLdMh+/5vAw9OvL4uYkBlySo1+oYPFQ6+ds1jtVOghx
0+eT+fqo+USQ6+t6Hvh4PLTsOwO4TmC/6zW6LnDv7hAQCgKUex+YMq9tAKN+
Tsa7DQEX/EgySJzQh1NZxtECfL1erhJpH/tMDU79SIsJPsjBl3c0GraHqIP+
9I91pt0cfGT3zyVmUg1OPnT4d5zPD3I3vyW9F1cDsYW3usaQzyvSlW9O9aqC
KOVBVBZwsanRJm5YTRXeXhgSWn6ez+2VKKDBVAP/szY73H8AJr6Lbx3U1IEd
PQ/nNv/ioJHfog9PXAgQYhvcuXIdFx09fc9drdSAWwO5u5yoXFzxItxmXToB
bm8RrUhdycV78QsSLzlpQGyWbosSn49tssLI28sIMFsT/pV4jIt+kcek5C+o
Q6DY3FunUC6uu7fSZfsEAW6oOx7xvsnF7+nBk1YHNEFzp5nsMQ0u3j37oS71
iSaMlp3gPjDgYOCiggj7fXogFBnULbOazz/lHUM35gzBq6z1TvskYEqapMXb
WCNwEss8HLSFgy9a5oqW2RuBg8DPfKIDB5PKZ3+qXDUEw+4d4rO5gL2f9p3Y
9pp/7En4O/wBcOntzcfdFYxA6ZkO9d59DgbnfFGQWmIICeOX09IE+TzxaGmO
6jcDODpY/zS4j4ObIzesULrH19d198LOb+Ziq8S68WwVQ4h69fHaST4PnRji
7K38qw+l2nVPQpy4SMsWM4vVMwBe3t0th5fwMG13AevySX1o//ft625/HrpW
afxBdX0wNr3yapciDy89DDs5Z6wLGePS7l4dXCx3buoX0tGFiLOJ/5j/uKj3
64qOjaw2DEoHhijyeekxR/t0z19t+O66SKCNn0+Xfejt8io6EH7k8Pj1u1x8
KxJx42GbFkiP1XwSSOSiZfNt8tZmbbD4mEOLsuHhwsw3n2Ri+Pw50M5Y58fD
EsOAzIN22jDz5xr3NomHu5cyqrd7a4PNa9Nfl6x4OD2iGSS7ThMcjbsVjYx4
2FJRQKix0wJxdq555RQXU7gUFSLfn80pifkKITwk7LFhviJowSxpF5mYzD/u
vNd6UkgTBPCI+Y47PLT8IsOtfKYJksaDEsfLeVicNbJwbzQBdttvNB134qGQ
mIOz1igBjKrL3fb85mFSdIrD0T4CcJU21rG+8XCx3+somR/qIJM2+TWuiYv9
t8PTu/I1IOBUSdElGR7+JvXv8d+hAZevaW682MtFrWtpXxev1YIvzZP3chJ5
GM6Nc67R0ADdR78OPD3Bw/6yw+HBdgTI2LrhEaHAGDfcSVx74oQRSN2405PW
aYynzekpl30N4a3oAMngqjHqHdP28g3VhdrymRf/j4ozD4cyehs/SckS2ZN9
nzHDmLHNGDP3jL0QlUQhWoRSFFEJKSoqKSqRSFIqZSlEbltaECUJlbJVlrJk
i/rNe73f73tdv/lnrud65syc5577nPvzOdfzHAkbKlrTXWNf8fLhQ9N6ny/9
VDzQ5LT3UiAZVhX7qKSeoSF3h1uCVAkZRLZPmJSK0ND/1sHOb/v0ofnrzsbb
cVSMQZuxzRR9cHESX+VvQMUnph1GP5+TILVmjJkhZIRJG7dHG9SSQMzlRo/+
fRoyHM4yBc4Q4dTWvEWuS4zQfNLAJT9RDzoli4sPudBQQGHk2OEXehC3wjrx
qxMNRXcOG7Bfk8Cl8PGO9nYqbk7zKP3tRwKz9Rc2KOhSMV3hB+kv0Qj8qSaU
zgs03CmVqxBTT4W68gyrYyQKzok8Pfc8lQoDl5NPqn8xxMYRhmDkCgos73EV
SNKjoFafaKGfkAG4al48LPbNGvXGnwxDmAV8bOSsqjprjYWnWvsi0piQN+Ck
smK9NZ4d1Rw538cEFv8cnbHTGu9fuDZ9yogF+7840vnJ1thKilq1pcECFE0K
l4cfsMZdjA4pxRwLeOfFF1JWbo1LB6K63guzoPuoRVlkvjUaNA/d4wRbwPGS
eyrP2qzR8NXzx3maAGy5xxvbHlpj+Mx0yHJ9NlSm7pOLy7RG+82/I/Ov8Li3
SLMgP90GD8vUrrlSyoIbtaX3smk2+Pj4t0tBZiyApipW5B9r5EhxKoYmePXC
XQre/LLG9dZVFFIKC7aduR++n2ODMWvP5XcnWoCrPDWljWuDl/bE5nWPs+Dc
2dko2ZU2mFkwUzrLtIDEHUS3ojM2+MFTPCFowQJ01YfcxN1t8Mzu+fGIYQsw
StmYd2uRLbpNqjm8Tqbhj4SNn63bbFDJ6uvNpAYaFmnuWz9sYoOxxxzT4k5T
sSPMb8MeZxv8/PLQ0R8cGkqEDt9f7mCDdeKP78TwGaHIzPbnuVPWmNQrTXvP
pSJsTflFF+G1n+H/51triKunBtmJd62xqeqPiaoADSu2fmJoDVmjaeGWDN9U
Gn5taNS1S7TGqfyHtOxAGpr5qC8RE9ZH28eaAdOHFwPfc8k/sEIKb7rclIgI
I0Ko6PVlGdoKqCUQfXZU3hBSDhUM6NlNVz2cu/5M9TsVdMqvjxIXSeF7pQOW
j+QMYWHTacr9N/IYUHOjwO2FIfgsfvl7rcYKfMZZc/ErWx9eMx0fxUyswDcj
a0JY+hSQ163sZBQb4P3YpSp+gn/Zacum1n2a1MPnwY778naqQJAVc+TAnDTm
uGupimQQQUSjbflwpA0enw5t1fpuBWYna0k+tXpwVGysfIKlBuYw11AqzMZt
KZWLRZ5YQMeo2EqP53ponp4ffDFeAV4e/1ckMU2CHQKfjX7MqMARsfyUMQJA
+iFJCuaY4ljdvu02PE4Zpe96Ly9LQ4r/h4QztgAZHzdnaoVT8aL5BnO1eQCj
rCKp3bFa+KHvd0pcuCW8vqbk+M1TDemXBuNzrTlwPLrLSaKLH1efFElqobBh
W2tg3Z4PROzVD58JsAc4UlpbmHXMBOUOXDw4sIcGVOHkmThZC3RqHFlapagB
boOOAYqiS6A6ImLcs14fdJ9uH2v7rADVJmf3PTc3hzv+Ll+z2RS0Gqu9Jr1M
E/ruDxmJPOPgjdaBU6Fr2PBBpKuCXkLHLwUrfoev50L6phdkW4IyCt2/UuNp
vQL9azTpupHa4PbvQGTfDV3oTDHwv1rPRqGGG3w5XuYwWSYvbZJghk9NXm98
1aYLJzJMQ2dfKcJJw7EfdjIAlOfpet68efSKJ9f2YT0b4h9bdz5iGWFNMqO0
j8qA/brj3awJM9TWyvMYDzaBvYL8+tcPmyOzNeLn4Wwz2OedlaK5YIafGpy+
rc4wAY3K6KNLNS3wFdf8mcwVU0iqln+Qfdocd7bYOZwR1wKvj3svVpZZ4B6Z
zu13/Mygasgn1nsPAx/ZLeVoMc2geXrpBalf//Pcs0a29nZzuGJl/VzqCxlX
u+QHHh5nQFqZ2HCKPxPtlN/pxwgzIKc+S/S8ExNrUs7sbCtmwRNldWM/L00U
ip3LjTJkgsZVIQuOiTp+U83wFf7DgD1Hntw7k62Grx7kOZqOMKBop/CEaY86
stLqFqRO8fyvvzDJebM6fvkieYTWbA6jP+yOx5mooWBktxLH1xwehtg+N3XV
QDWBq+8M4izg19a460JZSpijujqtyZXXPslkWcGMKsadfD3YksSAKD7LTdxk
FWTYOF6y/cCA74ebORE5qjh1+Oj555sZ8CDzTGPNXVVcGn7G9kkuHU55/5Nb
MqGMH00NWOc/0CHhr6fng32qeEG1vLlfiQ4GVzl/1lxWwWMB29LvWNFB8qj8
mR8VSshsZrH+tNGhmJjl+TlUEZV1+0XrkpnQekClsiJaBZdqfg1wSqBDu/D2
8oqVq1Cy+hMe0eH53U0lHTUDZfz++c2JjUxzWM20bX5TqoBuU8SZw6cZ4F7o
GzV0fxV+3bxrjC3FBM8okTcCLFV0sRaPTbjCBAdTk8WnldQwo8r6JYfnb1u7
VYe6hhXRW22HanyXObw+3rdX75Uy2p2dcBgzMgebl9aySalKeP711sjvqgwo
NuefEWeswtcK7udzpC1gssNvX/w9dYxxGFsR7GIBpIkXNbu2qiKhdKWZYAET
nOkX936UVUcrzem4m8eY8EG61eiOgwa2tCQOStMsYOXbvZbzcWoYr3iYu/2I
CFyzD8tb7asKsVuHdpRosqD1ToagmIsa1uU/OH/slgV8zeif2Mvrf7e+7+7G
ZSz42rMiZqhMBe3t950/8JkJFgUuQ1x/VWQlNObZ8a4v7sSn+TCGBmrKeuYs
8WVC0ApW8Xl1TVxjdG5HynLAqBLac813dHiTYXBeTMYOU5YqNahmc/7jff99
/WJLbGiMyz/JhH3vZfiu3dHCnsSP7fWTTHgx83vF4tU8/7fqyll53wIETy9z
P8TVxMiEkTt7YixgjWDN003WWtjFcIqVWeDF8/2exp9NWnjY1+nrP1cmHBwc
vpr8Qxu3fQ9vP/bZHATau8k1pdq4EPBj/A2VBeJ5i++P6fM+r/QyVqyRC+q0
yYuiSkoo3bRq1fvbZkC423xmms3CODV7s8XIhU2NsxemUB031KqG/m61gJOl
35cFB61CncCPUrtecvD9zOfur7xxVZ22JSVkIws3WhwQDA8whbJ/nmHXY5m4
u19kTtTNDPZc4S6U5jOAsuLSbPAhBmrKD04leFjAfZt7jz2b5HCkQN5ZhGsF
fduec1TuSeAPYe0t8n/J0KQecXrkuiqcsPbjn+nkwIaGooodfeZ4xCv6plEM
FzhfXuq/nVrBG59Dngfz3lTFfNH5vneBCEnNkfLvT5FAK2XS/tUHQELwQMrN
E4YwSCNYf/AwR/fVyw8EXLLD4XXTl9K6AZZ/bppuypOFhRd9vbu2asO/aZaw
foYgknUTil52a0H4xriO0FSAE4PKZa81GRgjqTw9xpTGp8e//NzmpA+5B8OX
eM+ysHFKrkA01RwS1M88XR5ti/UzpftEH3GA3ZpTLUDmgJzBulWTnmb4ePPF
Xk9HOkxmb0nLDDPGMuvmk8m6XDjLzC1P3imJx7yZm+ak2fA5wfT6r89SKP55
rdb6MTZsvNlHlyXoYH+0+aTxFBN0S0IP5KfSUU2eE/tqDsDrybXpYFkqLj7I
GspUt8OQNv9Pp7p5dezBx5q36XTI0L6zT+0nHaMUzxVZ3SfDqzaplZKSbLz5
68vxU7VcsNrv7s3ZuAov3VPVicq2w9PXxLZ6VnLh2qHiJ5vFLeHJnXclsWkK
yJfL6Jn15MDLkvi/XF813Bm5/m7nKxbo2z18+VJAF2V1tw2OSJrCvHjS1czv
LIRd20KnS5kgEdTtny2piylRju1rAtigm7l3b0+wDhpL+3w8pmoIO/nUh3IJ
bCQw+24P/TYDVemgoCA+Y/yyoVOHUWuHkPIplS7NhQu3hMQdesygXOPKPZMP
xphn7p4nyEeHL4mXe6pdTDBuFyd+4DcD1t8zCajkGuDkjoxFFWHm8KJEuWPj
rCG+LYxwWnaVDlbBjuuurjD77/15/xmndNxlWiGqtpgBQg+rusluRlgrIbu2
OY4D98a647600vG1irdZSzUZEyPeDrmulYEXKcmnFU4DNqskGpdvNIVHW96c
PupggY3zdEauJx0sLcqyQ/RIQDnkbPROUxkMaDcqopoHqnLiEOxnDWFLbvKP
94ssYRz5wyP9FXFRusreWH0mWlbOz4zzrivRlj61LJILPZe8ibQsdUwTDvhM
ODFWFV+gY5rlQ4KqrsLHYgKmsMjz68wrF1G8WXGwsiHSFAIGuyuqH4liRuny
zrYvpnDDpd04PGQZnny3efTDsCkodl39t3s1H546d3MwR9QMiuQ2tud/X4xu
R+jTx1fQYXjPe5H8xfz42/m2TaqPKYh/yxL7lCOABQrpHv5HePX/7eqrsU/5
kXRDccu5TjOYWyiOqFwr+L/xNDP7v/2xy7Yc8/NYQoeO4izhYZ1leJt/3Kop
iw79zWWRxfaCaOimceAF2xRsjCOWRCb8qdof+WBnWoUJrF83rTYxIojsk1V/
jheYAQn9r7pvnq1y3zqvHBhjCutuPs4m7eVDN6HkTM4BEwjewDc3Wy2EJzdO
Htv8yQQGV9acfe/O/7/9yTP5v/6464W6fd5nAqVJPfEms4v+93y6GdQ1TyTf
yR+v8oq4VN0SxcUSA/K99FJzqNTzIm0asMFU3zgZQhoXKrSIdTI/rPBZaViA
+zMAatu6n9+XcDG1WmJG7QUdfl4Y8AkypoLzzdt2c43maFRgd9BFUhci5CyO
t68CbFnDvZWz0hIt7+2+YWdvAf4EFZNiPSskT11591yWBRoDF868jLXCqrty
yyacWGDywH/u8w7A6T9vG7LkyeB9pFe+uBZQsDp9LWc9GZ4t3/83fzEHA0zi
1QVpZCj03tBO+wm4K3HLZ9dcfXDav3Wuw4CDzc+LnF++1If3DR7ymzy4OPqN
4CzxUAM6CLf23azhIlvFGvxOa0KTV80ploQlBvenMyVW8PxeExYP+3HxX5Uk
peq6DhhHWwWHLLfENmu+aRt1Ehys2tYhzvPP8EavA7ITZMj/1jQtlk7B7/dD
Qkw+68E1QY/dIxMUPDa2arB8mT4QTn1qaBUyxH22Kw9mLDeAiK8XPHN2G2L9
wXcKXpv0YdyFMBLja4gPvM4cfF1AAse5TRvUnxmivsV8djzv+h07DA+HStLw
gIXHkFw+EV73FRN3xxgi36vIyYGVvDinpOz6SKHiyRnZ28WZBJj+8p5an0jF
nSWt4YOBRGC2c00JNYb4Y2GFTLuKHpxM3rVupSkVjz6mttqJ6sGPEmeBe0DD
hsTEvzWiurDZcrINOqjo93CuSF+PAGn9z1XnNtAwbOmgqPZDAuw3f/apZ5cR
nhXlEyq6pQvxmsvLC0dpuH/axHlhDwFe2t/UM95KRU9yx406Xvy2VWweUEgx
wnZ2n+1OXyJ4bS6dPN5Bw7kPPhIZFjxOT7d6s2g7FZ2Gyk8E3tGFMYslP/Ma
qGgluHZNg4ouBJfXP9v7xxDFj8y6ROjpwrHOE0/EfY14HnjEND2JAHG710XR
rYzxmm3Rc3MTAlByMq6/1zBC+sC9Wo9bRHC74ukSepSG8YVd9n94XvA8ZN23
g81GGHz92vnXqAnWysqrz4UaodimXX+rcrShattqrXkbI5z42vCdm60D0SKm
U8lSxiigleZdmacDNeQGpxs3aDgu88rJI00bVA9/kfs1QsWlIjbXhJ5og/KT
vLGlaTT0UzoWpXdUB+p/K/zWWk5FXaZUvNw0FcZFMmSmS2k4Rj70fvUPQ9jm
duBBUiMF0zbZOjwUpUKJ2p9H9c/JaEN1XfMgyRD2rWXd8nhugIXNirNr3hiA
j/mSTiMfCqodGP9quYQCF7eZD7K22WB+napK2kkWvP5UU/V53hr3ZXeJbSOw
gWy0qzfwgzW2bPlxq/4BG/YnH0sf9rXBhTChfuGlAGmL/d0OmtmgqJLM5+BE
NiTdasshr7TBdMdFGkLLAJKl7HuSLG2we/Dh60NtAEEzLsKlYINF1q0/RgMA
Dr/oV6KxbfD3S+LhdCrA3GYPsvRFG9y7+95R8WA2OOz5Kf0k1RbDls8HXhNi
QcXg1pnBBF77tn13+BV5ecc+xg7fa4O9vyvI3Bwanr65wzrqgg2eSm+sP7LE
COUOjl+q1rPBpWq5ge93GGHP7+8pv6RskLNbZGyYSUNuzE6hhxI2OGX2cqPD
BA2Dc9av8KiwRpvmWaepPzQsmpzM3dzAxu0lorlrRczA18lqpGpOFk7bV4mL
5f5jN9zRGyrRVkKZ6xtyHv6lglaMaffDFyz0+d1Y3F3HBMsHG/8aLmHDizsJ
j2/dNcZaff/eQzlM0Aw6qk7iYyAsv3VzMoQO58rr7Y4OmaAyJVxYN4IJ5ccP
tEspU/DRhq/qrVt4vD/5PYcYZopRzk7b2r3MoNWJnNP/2hw3XVgiuO+sBXyM
5dZcFmXgwQvkISrPR693v6Jr0UxwZJnVWuFuNuTHL7k8/ISGod1ms2vP0qEl
pOzfIldTPKT0Lvp8hznsPqh0Pt5TH/s6RIwm31iA0mbDnDNh2ujQnzDbdpQG
zKln9i93MzHsT+f05B0LqO3L0Bq8TUAx1r+1gx5qsK78edKynUth2/70X9Xb
iJBSUfRsWksTaN1/Tvi3sqHzVZqVsqsmtogFzjdUc0DIcmzL+c/yuEXV+HzR
dgtoe8uozJjRQ+GbWw0fVQJc27hU6GKYPP7Zbju2188CZskedUuc6Zjs8eHj
nRUcsFk4UFBMkMXoUp3RklQizgYU+50pkoKR+VslFy9xYN8X6Y0ZLebYNzqL
QivY6K5kTvs3awauL07ZryRw8QgymT8rzGFCM8X1zjcL7No35HxsvRlIhOFe
4VtCYESPdn31Vhv85OIvFXHV4JvQHeUf/QQwVF258rO8Kl4P65je5LcCbFvq
a9h+P9gXNZNP6fULQN1C79qqtKmqs181vZZYigAtNJHY8IkBM5HrdIn3zfCC
xTUpr1xzuMzJ9QzjUHDtgn1YiCcLcueUVwm/JOGjlWmXOznL8dK84r9yn6Vg
yFnccTxAFCjL9R/+49OH3lxR+Uo6B2T/qO/SdVXAlZqr6wIcOHCZOqmhTJJF
Dcn1BK1sLnw4uPSvi548npidulf3lQI7Za9M2DgD5s86BJXzzbHfNjbL0r5P
s/12nejPTmJhwIkbzfGxZtDrq8F+9Z4LAXxyMr23VuK+8TbDrgYrjNeYWZe6
jsf11F7yEx0upCoHT2U9V8HtX1MG9EqI2Gp8Y5nxOgkAtVbHv76mEGIq7ehp
xsZIT4ljYqVSkH7s4a7mM7oAzbKxunRJtH7MUrySIAlKqWbrC8rV8NRgVsq4
pwHYODdm5/NxYevmUP2nFxUw8XXI0c/jitDRHKiVtJ4IQdo69hM9TFit7lE7
u0QHZ71DzjcL6+E13af3+3tVQH2h2PXeYQ6MrhLuKopRxfvPchyH15vD0net
0d0dFKwtCZhyZJtBmYaxUFmeGYrWWTxomzSG7bevXC89QsfFOxx2SowaQu/n
py+srjLwaUflNiue/4v3lYxK1pliYAu+/mlnCvED/e88Fizw++EzKdd96SD/
UTh7MkkV7xH/2q7PZsBJrXOPrS3l8WA+U+HIcXOQGDh1eZimiOL2r0/ySzLB
6KJBSZr7SvyYILb40jQDdPo3DdGUFNGip2hbxP/s4/7YS1/qsApe3F2l0cfz
/afiwo+N3iljmbR6z5ZWJvi9OV7+YOsqJMhZbCbyfP9wh+Tw1B4lPO98XOIQ
Pxf09kg8i9ZSQ2bcnefCaRZg8kUgtthHBR0ag2tFzrOhaGsVPCaoYoXeKM9S
zcF+TUOKv4gmFu9XuLF6QgRT4+XddYe1IHT1dJ9eDQur7i/a1lhsClvfDiz7
WssBZklFtoWtJLp2rzr+P8/j9vxR8+nlebPCi2D2nhYiFNXvDxkNYuPHUcci
91ZDkGmbGuEYqMN+gaXEQWEuLnrl9VRsFxMYrjuXrz4iixc+1EXr8urx//f8
T481lAeP5B4N58LbwxaaetOaeOvIqU27n5nDkSaLYdVbFPzR0vyTuJINfdyN
G202aOA1FevsEj06OCcwlEtnaNj22mGnFYEOOtrfJZJijPDrYPSdV6p0mLLz
/XTlMA2fKTBVpZ3o0NXie3M9Pw3tREe+nQ/mglAVRX/7CVmcPPXzu4YqC1r3
HzKN9SJiyfAF1R0mEriJFpP8kaABa/z5C7nbhRH/qhOp26Uh9WmLUEGjHE4K
H7M4EUGG6NO281+J5uD7ST9iwFUEO/uFDxkZMUB2/ZbC5i/TVfB0yefrz0wh
z9QolHJxukrTerRhmakZ5Bu+KN5xcq7qEqf3nyWPxyu2iL+UyJv93/0rrXi8
bhof+6J9sqog0ySgvY8M92+eDLV/z0G90Hf81nbmUB4ru+i2HwOD15AEbZ9Y
YqD+y2Nkfwsoe6ezzrDdHMfvxd94kUMHz8tDa4sXcRFEex0VrjIgdk9D/fZl
dui0ddq4W9gKvFgvGHNVgC+rc/g3RfD4dWtGYfAjwCnUMb1lpQ8SynZyjW8p
6MbW+Tw/TIL96Q4NQrkGGDUgs2eNBhksB2y8y7ZQcGlYQpNHKRmO0nK29a2m
4KEFIR+7hyQIPCQj6GBggMM1lQ0nJolQWzJ0w/+eAb6UmM8oW9CD+ZXv+1ws
yfinUnrrihgSuFnsYiw/qY+DhZG1jFMkUNseO6c1QsYbcm5RTlv0eHzbZrm5
k4x895lX/trqQ/j+cD86g4yc5ypNost04Itru5/YfX3UuZpco32FDApLRwX8
asi43lYhwJ/nB5ECSyOHCvUw95Dz0VOL9EHLUKbxWDMJSx13mtYOkOGp0M+y
1CF97JyU/8Z8wjtvUH3Z4BDPtlpOYZkKBarTt/CNT/KONy9rDlQ2ALZi0W/9
b2Rs75c2WqJFAJ1rr43dHuvhoQ/2eopcA7gfPlEfmEvG0dx9VobCFPiQ0MJd
JauPbTnn57tMDeBORcf8mDUZhxMx+9drCrzMGf+w1lIfU1vtKnrZRJjw6koh
VxHxye+gE3W2RJAISN28NYaELy+vL36/jgjX2qMl8naQ0Zmo0//vEhHGk8Z0
Wzp1cXHF2X2JKoYwSjXYdSCWiJfkFM/BEQrs9ntoOOijh0cWbb1aok2B+44U
w80v9TDrS9Dzhx8pUFG7PVFFnICTR7b2F+XrQyHEGjtoEbGH+6Nn6JIBkI2l
+etriXi3x+vC7Zv6kGR3pcp+ioDxK08/SDxIgiGp36miN4hoNXkp+e0BMrg9
ddpqxft+T/69oStPk0C44tDj2BACrk3c9nXhNBl03nmP2H8jYIR3rBifqz7c
WcqxENXXRoPVmn8vuOhB+8OgpdcJOqhse1VdYRsZfF78LXhgp4vvbZ+wR+rJ
0ChQVadjqYtG+04O5QmQYNuB2aNT/DoYuf6jaV6eARhNR3uv/a2DEpbnap73
k8DszPOaeCkd1N1GPXt5JQlqPNWb9gzoYP9I06RHrz4YC2byNb3QRp+21m2F
0fpwOTKu98BJXZy88ilpgkuBvYLVmQ7vNLHpZ118H50MW5t++D4a1sFtu2X5
zrUaQMcTuW75OS2suR/KVU8nwxGpktvreMfGT8fsLxwggUR7j+jmN5p4Keyq
7+kIA0iqNmx9/EsL+/hI2jRLA9Cgbz6+m6aF9UZLnnsG6kOVJltLrVYLt792
89rwgAJH0y7+WKOljZeO37DSIFGg9PEKL09rHWx7TLr99i4FjtuNauX808V8
Z3eDV3dIUDi0KFHV0hg9JWpzbPT1YNvsR31FPhMs1d+7bCxBD1i9maL3+o1Q
/D48/nheF1KdjN5N001RYfOa5b/26IDw2IDgMqoxvjKPolxT1IbE6unZDxJG
+MBQ4KaCnRZoZsTv/rnPEPcPfPQ8T9GEd8tHHM/wUdE4qtmx0ZUK9kVpAeau
hujdbxllcYgKn+OtCW08f2v689nJLJUKd648vOvOMMTbeVsaUZwKlUYDQ7G1
FFy9kJHHn0OFRe+/6qITBReOWLldOWAEJ869ZnzfRsF31x/njh+jwaLK5FjR
vRRMjR5VqhagwfdIq/KHG6lIr5wuqs6kQgH/7quibTT0Vo1YqrHfEAzKEx28
eb56WqP5TP1FQxi4dmv3SX0aXr7SuZ+mQ4VM9xilwIdUTNLbNx2uQIWl4l5C
TzIoSLL+0fY4zhBePO+z/hNjgH0uJYMlJw1hyyPtakEDCnJ/vvvJ8jWEDpFN
ocfOG+Aj67iAtaMUcHIQuGKoQ8GonjHhsHlDcAhaNSyVqY/CGevp6caGEOzT
eHwsWh/3Tef6O52nAPn6u8WsAn2c+OX1o9uZCj7L9ybI0gxwolG7pmAdBRo3
Ji5+lWGAMhfyONUOVHC5sjMm+rU1XtddE9WYDeCw5nL40522uPtX1qaWSwDl
RfJPhCJsMOgVLWVhORtomy+olaywxRHlV05kGus/9Vj7/+7HMv6zfvSoJwdO
+358HWvDwHcXe0P7Tumjgqb9mcK+VeDT/f7SQXMSHJLVYO4Q0gVJ2UqtXW4U
vL7dZ4Xzs6VQSv5pPC7PwrMBO8Wlm83AZc+jLF6eo+600hnyWUkeF6uE+T/T
B7t4ZmDqR3X4UK1zvnKZJmxMyRSJ6WXh5EOFnBJvM9AQK8qf/sbARxkdZuW9
JpC9ZBYvAwt/misaPjzMhK0lW5LX3jLGxvDlG4qKeTzUreNWoCiLfzRUfq8b
BvA8Vle79rAZ1s15S3zoBBBK+P5xulMW1y1bP3ZOkgUcnfLK5zf1sEXqTen+
BwDG39RIrKPaKHFmRyI1XQJv0Hf6QpQUPIRKz78VbPDP26I4uVcDGdLHncu0
1bFQqEnwQJYYjLmvb3/HFQCPt3vrG5rIILqpU3lPFhOsLOncXz+p6BwhFenF
+19+vOix+u0kizerJ7niHxhg+FZUuq6Ggk1baHm0GA6sNef3cNaRQdrSp7LB
ElxIUPa4a7NEHlXfKTu4LaPDtWv6a6+zGRimFyNbegeg4KAo1xFV8J/PY77S
KXMILNjoHHuWivI2/f4SgwDbz21dZLpNAb9anLjHSOTCajnHnxHnluID267D
7EFlCJ0Lvx8UTQTj5+0tS9fZYZD50PCdM1xQ1M78cDXKHKx8J58MLFBx2TsH
GUcBBsiJ5TpORBtjRFoGtd9yhr1D3NxU/J0khIdJuhC6LSDnrUVBvNxK9OZ/
v/J4GgXO7dhzdXaW9Z/15B52iNt05J3YSTa9oaz89mkWygco/I6NpcNP7qGu
G1a2+Mkxf0CGx2Vvcxtd7zLkwUemvXWxGwUMowp39BzhoK6Ik+/qn0w4p1Eh
af2MCd+bXytm6xIwqqy2P02BCD/6z3aqW6nATbuke6bfef79wvvKiackVNO8
zdD7RYQ89XGSTDEL/9F/jbCV2NAWvadTnWyK1+IPtgzacKCySP+dSKE6su0J
Q8mTbHjotEy7s8cIexSCc5njHHjzpPPJDh5vtapEfXuuaoeCclXLKxUt4VL+
eJ+CMAfeDn9grGCZIu3WicS0E+JA6bvo8+GNDixZW1B10HKkqlG8wOZIvBhY
bRbcL+9nCX/27Tj0JkgVZ3wOPhrebotuT09aJQRzoOTR5px6Vy5KtV29t1qT
CR2+0N03qgl9urLnEgb+G0/6/63T70pnPD6XIYX8K87OqbLEIZB8zjvJBrBO
13hmdbAp6BSLRAyNf2OvlT/raBgmBDOLdVc272cC1F6kv3loiNsv0+zr5s3A
ri/gZL064BfZ7aQnXAtYn/7+ZqaYImYcUt/ieIQFpb16a22sZJHf1mjqQgkb
zr19HFjrRcHw8wvGfEpcIDwOrHwhyERLFf1LRWNcyLojWOa/oIptBhKPsyVJ
2Hll9rDbdwEghvIt3fRqCV7LXOJgcYAf3JOtzYZtLEHE9eJGzTOrMMZ0oUWJ
xxuy/a79+cJL4V79qxK+RDs83X3Pbu0jS4CJp2/eNnHgQegjqdDFJLyjBSTZ
CQ5e3NU8NjTCBMfgHb0DS5RhyjxHMV5ICJZt+PKwKR4wms782V1mBp8v6Ib4
6NpinE392d4TliDodCBKi6uHLzb2ezYvLIM+V7e/FdISuOTgOL2eO8feKbb3
4HwDCZcoHO82F10Cvdfsw7LI2rDH2dzURAaw/KlH3dp8DrIMREJjEnj/16UT
ATY1BHDNtr0Qu52FP2YbJzzUAPZY+QyM0Q2wy+rY9qXS+pgZwdEN6VoKmpzM
vKTPTLjG7/Kxw0IM+y4Ung6UecFm3dCKNR4gQmT0dFfsxxVYa1BYL22zwB6W
FCpY17AYAnf83sFkycIfIwH18mkiBH990/VJl4XBpzzP2aTZ4l9Nk169eGvQ
Nt267Me/ZfBBJqHydq46aC3ZlgJGdth3YA3/4F5rMOvzfVtWPV7l+Lvg0KX3
2pBBrdmRP2iFqwbkNMbiAZYV53rVfGLjrsnhh2tWAaT+lDvpo8mAzKp7+7Lq
jPBpn83jpQ+4EHAwxOojz/Pb2XsCbt5Wh+Y/Ig4qyPOVys0OGi8ZwO9+eiRL
XAE/tgk//LzKFiPOGvmGrrQCp+Ol4unjLDg/bkJmKihgx6qUk4XPWSDjQAu5
u00VjUodFzWY/a66tbzmQ26jDvhNCCR09NjgHc8rD209uDCUaukpnNbCDtOe
e/H6lC7E81tuD5+zwNqa1PbNYqYQ1Kao9sxNH15+vzQYsIr7n3HDh/+td9ff
1y7v1jSFtpV87gXf2OhVcu+boJI4VOlXqb7o0oB8zf0ruyMkMYfzfeUJ3vjp
sDdsGLwO8IydnO25WwrPh6jZa38hg/Lr7+RlAYABhbcvXPawhF0jpd3ktfK4
X+GWi4+ZBTacvFT/uM8U1FHlOF0A4Nd6v347CWl8OyqtRfkA8Dc3pcpwOR2V
l91dYlJKRjWy3ZsGpigkdZgfSU//yz4+M6moZyUDhgdIxS1rGfA7cuum3spl
GBJZH8CpoEPansrmo43/qqaH7qXrbGPAIGN9tGioAK5I0zqrdI4OkY3mKieu
/a7ysQ5b5GrGAH87GS+f7H9VcC2ODx+bg8+muorPk3NVnm8m6YLjDHjferxJ
w+tP1bjxX9fQSTpIBm90o4wsQr8HT2u1hRmgIu22Tmn3QFVE1b3wQp6PH3pr
OBPnM1dVLh8/1jVGhwzJQ5fc1Mf/12dFTeHuq69uTScnq1pf2VbnPyEB48Qc
I7qZg7R/v4K2/rRBJ1Jo+BcdS7jYbn1up9VUlU1ut6ZBOwXeB2ykXPCSBbxq
z/lC4GDZ+i37HG9ogEZoxPICGw6WNugJ27naYr9//rTSNktYnU59dFFJByKe
na+N+MbCy4kS1MuXbVD4Y/rOox+58NghZ1OVmDVqbZi7tYgM4Nhh3P4ihYPf
Tgw+OdJmDmcS13WVe1lj1eUTXltH2fDvn1nC5HVrnGRn7A2ZYsObCmnttC8s
vGi7S0rAmQHtZiEuTVxrPDp7wUVdlg3Zhxs2Hj1ijZX77APvzLIgzneZZnak
NXKIde0th9mgpED92dRihS3Ri5gtBSxwpr/ZUihvjVHHInpitrPg8lai0hth
a8xiNgfs+8Sbd099i/Z3sEbT2GoW+zoLNlx6WhH63ADX+f6yuErQB5pj46KI
oyScWbk1QuQiBW6Y/DMr3k1EZmw1Q9PeEPbuSvnxM42Ef7cVnwzaZAg/bwlE
hcboYadD3RG3nYaw/PmxohpTIi4kDaWtUKLB8OtMZogdCZ/Y83mKx1Gh9vlT
u9sEEvr19xmu+2EId7VEbE7fIiLBfMxeiMefh88rMVc+J+LjzpE3Eg2GsLT7
k2KZNgFTbdp+/P1lCPVXvX7MbiRjqqNAmjiRCuarrJjRZ/VwQElnzzWgwiGF
zmsClnro+6TrvmIbFeY23Vzid5WE+RGMux73jeB4pGOQZjcJn20njZum0kDb
uv7tX2sSUqapuZHyNAjatW5ZsJUefr49knK7nAZyG5ZUbmkl44HOuw/Lp6nA
9A9Xj9hggH5HsTGNSoNxEenAX0F6uIuhLLDOlgZldkUSdV/JKDfv3007QYXe
noCx2VMkfHW7EcKEyUDrcyl7HU3CbTk3r7/n+VKV3YKyY7oevsw4PDYySoSA
4Q0/ZxOIeK/nz40NwXpgbJ74ia5CQNnDfuk+V4hAvvns0uLVBMw21tBNuakH
8bcbr1C/EvHZ3vvhvs4k2Pm4xK/6LwFlfsXIdFQRoUtZtdolhYBu8msFrllQ
4DeOzLkv4bVf5j8XdNsAoh79G10pR8Bddx9kNtyiQGD58oSqJiMsCP13QZCi
B+si+lc/kzbGvBd9IaEKJHjZyt5WX2+EOy5Px/Ebk8H9kApabzZCI9LdX65r
yMAYeW9jcNMIv5L/3paW0AfbFQk2BvLGWHiLzO4xJELHOC7ItRrjeEH3Dhlt
ItSc2XFf9oIxtlQMPPB+owdBe9u5I90m6LF5zt/YVg/cdtXZVLwxwYZjFmMh
TBIoTibbJRJMcDhO6obThA5Y2FjZGD82wl3W1FmPGi0Q0Jsz4/9mhL/3Zd+4
1KINVF3v9q9ogp9aSrsXdmuA4H6q7aiYEWpduen1h6YNvUnOe9etoCLjFTl5
c4UWfAyqZN14YYjlYT0dPkPakC2jID9mRUX1eYXjWbnaIObzatTL3hBVrKH3
YqkWzDx6eKZMxRDb9mb39izSgcZ3mSrf7xriGvVzwfWy2qBR3/WG+sQAn+ov
/VL7QAvuVFkkqG6g4NVSGbvfP3XhbG6rvrOjAQpHCkrJOBF4IC5VJnCBgvqf
T/RxRbWBO3y6b76Lgs+ihDXvGeqCf63nr2l1CoKfT4+QERF+pm1toZ82wPUd
LjNq0ToQzvJT1j9DQcQY/gPGOrDlN9/jTClefxwEK0vHCPC94e2wW6MBjr2f
Pvx+vy6EuywYytzSx/WKqQ4XQRdoiTg/GKiPd5KKosOkdcAzz/v4xrNkPHoi
uvu3nC4IiG2UIm3Vw2vtsZ+qKLog75Rm3ppKwrCPt4S0+AjwoLElju8Aj6OW
dzxZ1aUDF7L82kZt9LA25ODtkBktiCxPk1W7poePhjK97Vfw6m8j4V/MZgIG
7TOY+EPUgdygnjZKNBF7PFXmJQJ0wPfL6MkZTSIuWR0+9Wy1NjjV7e19eJGA
upOX+MjfdIFzKtnNIo+AgstWCz0MVId1Z7dMfnhGQBXZ2Ddh/3TgQ2t0EZNK
RAWzHdzHLpqw6VjXSNwhIp6cSn7t4qwFh+u6O+YVdPEkyJ3dAlpwt+ravfh5
XXQfj+cuEdEGS2+drkXGBFyluNLO9bsmaBdnWcwv10F3evbKA446IMS8oPNe
noA90itSF13VALly8lweRRcp10/OfBvRBiVGi2RBIwU7yUtVlXUIsHpKTrOR
Y4CyVzTrjc5qw9O3TadPfCajPAWD/5jz8qO2xD7BRx/F776SC+Hlj+pprTfL
NCloO3VZ2/uyNghld3fdydHDHVGzH9+nEWDbQQHPL1lEPEW4YadFJUBCU7VG
4AABp++0tJxtIgA3WPpH91EtPDZseSGZrAZ89W/i2x10UFC/YbuMujbcL5MP
uySli1YHrwXeO8LLx3+WvjaHdXCLf9m3USV1WFEofVXPXQPtyYYbNEa0oPNR
/M57WbpY9bgy/NJTHVA+08C6ekIXZdYYXe24qg56Hm+097vq4ED4Lf7kZxrw
APh9Yg11UWXu5fyeMA0I5Twq7N2ri8kTSy4s9taEZXpB5VNOWnhV0t2kZYM2
bOKrJXn1amODVP2DmnFNeLY0m7/NVRvbYx/cVEnQhuSb415Vw5rYpEb5Mhuv
AStU7GKL5bWxczCKMTOrAeWwbKf9GW2knN1dXfFJHSxEDjXsFtfCYocmY+9f
muDUJxLKDNJGUx+vi6r1aiB/U+logZwuvrfIEVnLpwQbUzpfE320MHDAuXL1
DnVYcspjXfaQNhaenzsSPawCCnOk+K07tDFa2P6m40tV0N1pUZ0fpIYU7/Ai
iwg1+PFJq2XQlef1pBUUH6Y6XLzvn6/pqolLkuw2p2XzePme0rpUjiZejahY
f9dHDdJ2S11bGqCJX6/rCRf/VITV/zxWPPTWwrqSuvS2tSqwvOUp7ewbdbxy
Qy3+aI0qHE6XC7N9qomnt/ObDIargn7alJSWnwbKlE21Z/iqwUJBwFbRZBoe
XqWcJU1UhYON71NrG6m4miUdueIYDfLulYjMSNtgXllW0zCPO6cvD9a4/7FG
cpvUQLA3QHPgmdb95dZoeaAt7A/veOurrF8l0zZo4bn4dyKPb8KkBIpuvbTB
3qyuW9/sWcA/5PkyUdgWPzMrxBWIbLgdbH1xdMoGTc9+0JzIZ4FRT8DX0VkK
JrO1HXJTBGCQJie0r8sIlNo6E36G0LEhxfDGta9EkHx5/uD+F0wU1umY/rnH
FDYYRqdmOzKwptK9KJtqCoOzNe/j+S1whfYVwuNjDPC4tvfkW1MmEhOOLm+2
pkHga/FMwiFzNDR77tvoagjawqEZfWoM/Lj3SYmjmimEjT7MMvGmo859ySp/
Iwp8ebplwCfBHD/gv6F4Ch0WH345HevMwtHzjzTf57NRLOE3LUiGDoSGMcb9
FxyIPkS6EXpKEZs3TWinOLBhydyLQBtRMzy88jhnoZILyn5GXy/n6CAzP5kp
Y8GFxlwaRdFBAxuKNtyNDAWg5ludKngqjd0zQfOb90xXDb/KLrZzp8CH4oFC
m1IGfNHOPOu11gL3v/6r+mMfA8YUHya8rDTBPUkZgi/PGcDlbfSAA14WiPDV
y5lih5dkrY5s2MaFycjtJSV5tqjgujvZ9D0X4r+euXJuNRc046QvaxwSQTmJ
RxN8eRw4do4sUC+mgZGBPc1noi3hKH+0fs2Z6apKxZKxTz9JYLpv/mvpQXN0
uH+QOX7TDp2uUxNqvADkldBzy3oLLD/+tfZtExOIBdTaT2qyKH1XcOnKHaaw
2HNF7p+v81WsxeuePjWngYdX6V3JW0w4WSpszh2jYQi1/2LMXgJI55NmNU+z
0arKxyHzNUAScdWYKUsDhzVvP810AXAyen6PlGWMf5eRguNlLIFZxRcWky2P
Rb0ezi47VsIauYmjpzoJUHctPeCwM8ANHamqGjIFN8lnrtUzYEJZzIaXf5cT
cXmIZLvhPiboEil+DxVIqHA0JnJdLQfCrmlkbq1Sw1enwkSPidlheJxYeK+L
JWz/rphbPfWIfeJjmCP/nuXQWLElZ/VKSbA6tsXk3QZdKKn/ktvFi6ei+3Kr
yT45ND591Droui02bCiVrHXgwlvftEeFl/RQYc3Gam1teTA9rpBtTJSGruoZ
d9UQHZA/beP3WdUObXOd/+S7//d+5f/uV2gJY1I2XzYamUN1gpDHhAQdF5kZ
fv9VJoEtfQIxgY0mUKv368BCJRNKRNd0y9bJI7fnrOKx85ZgucVE8tZnRfwi
7S5/yJsISVvaC53nOPjYNzY04HI7e+84eY1gJQGe5EQEqfUy8Whw0N0VqWaQ
Ke8BhkMsOMLRCghbJI+nvcTuP2BagkDXnfYbVkoYXWuw+nYKFzZ9vCzaLWWO
XA2SSq/RCviRN3P1yg9NWLvxQRYxzRZDtVVPbJbggkh1pue+bA4MWvVHrOXN
y9MOj41duvQgZXsee+0MC8WS1K8+OQ6wi5MoMi2vjg0H1XbLugG8pQ4JqfrK
4pE1IdM3nnJgYMc2cZvdMihbPiLeTwC84nlw0szVDHI25zzy2GiDE27TkmGf
uZBvenbhzBvALaUP1j0/awpraUUv/tQDeHdxtlV8V8TZlCbHphMWoNSxNLlw
noiPxjMSa1xZ0Ce3WXtvjCJeYG+/e8mNBTmkPTe3H1fFqPTSsLYyFlzoXxPU
dUENjwbSdpdcNIIXgfTa0QkGemQsnvZlMWCPqfHusiwaXnaOKio0Z8PW1PiK
Iik1bL/b2Pb1CBtWR6X+U96rja2eu/xqs2XgdKJn1fAqAuQ4j8p79dii36fm
FP4hLrR/d7pxeBEHXq8ecbdfbYLunferJNeyoWuR4z7rK1pYOZq5/+YACTSO
eZOTPrOwzjp8k6oCF+Cz58w/Qy18X9MrGOU7wQ6Rs48IXPuP7Z0m3XfOh4Hn
NFQ2GCT+336h/3kn4GFG5uX715mwaJvynlkiFXd5qaT5JdSwp+MF+A68E4ai
eurl/9m/Iprj47HpjwbS540988vmqqyP2OYI/uHxRqKObmmqAMqJrWza76cD
XR2fnAojDTDILXnM8Kw0zO/NTd5vbw4fOcQSp04JVF7bc+iVKxt2TMUy/F9R
0CWGM39wI2C/xYaqUX46yFDr9l31ImJQ+e07zPZFMNb9StXjJgkCOEbXjGQ5
KJHVvDtj6feq5R1P1ylm6sBiVc7KddLSoPc0v37yjxrEzo8u7AqlwG7T4tXS
fYB2LdsjoxaTgHPxKd8uRxYenDnz68EtG9x4qO50qbkVEGaMfwyiEuo/dBzZ
kk6DzOad8Te2SIGZV3CN2mMt8JUya1dSpcAmjnjwUzk2klj+r6QUiOB29lGh
5z5A/0M5cbO8eTDnotFLAQMDnJd5INLGN13FYj67XsLzt+DAjoXsvwNV5VZ1
HqNHeO3EpjUehGvDqJf3qYLvHLwQ6GenoFjM3nV3zsZJeZp9Nqv2ZfcvNpD+
jcecGjdA4yZTzbJ3dChpGhWO6hTCKZ17Sp/eM6A8rbuucG4JPnT+WNPQbA7F
t48kF7gK4sSTNcXrfjMg9/fyTL+ti5DUl1xx3dEcNq99k7x9nSBuvn8hJtDN
HIaNk195D/+r8s263UZzMIezM7atp4r7q/6z3gv/XUcv8e15aMEbX7GFsYue
qFlCruWb1vLdTMCUe4und0kj9c8mAZ3tNjj1fqlPUioHZu7pKMezSdARFx5Q
ksTFTWUC5woKdCB9ojzAbx0bM/vm5semNCGhp8hQaIKDqYnpc7ejbTBzP//f
W6840Jpv9UzilA0GHPb8UC9hCdX5MooEM33oHzomn7ONi2dvrmzhf8IEv98r
TENGJHA+BCsvzgLMpx9aGXTPFI3zv+S9W7AEF/+7i0JYavhXxUat4hOAUark
B4K4Gb69W0prLbGAA/2/mw8ni2Je4AUhc38J2Oj/+d06pghQ19mS95Wo4vVc
UarUDiPQohKHj1wFcL1cf2NmDY/Tvzyz21tmAgn7JhamVwJuHNW4dEaYAJET
j1K6FNh4/uPW3zt0bVDKeTT76VkOvHU7t7h/whq5ExJ/vD7z8uSKu88pcQv8
zP/njWg7HXY/qCFq/7NCuY13vPAKG+qNldUde4nYqzXlebefAvXat2v3hBMw
KkCbGX2BCjsOX3494KKFeVlxB/NrqOCNdSn653XQxIjuOp1Ng+ck2azbnjqo
FzqX+y6aCl83n5b8XKeLHkcVDf6Y0oDYuXqNRrAuZhhG2ht7UeHAOrP5oGM6
mF11hlKSawgbL3SdvLJKF+Mei+xye0+FeF3fis5yHfwusShqWJYKj2XD1grE
EdC9PuEv9YghHFdPkiDQSeg8lxNZqWAEOuLOrepP9XHBZQRUm6nwzW5LCoGl
j27VTIsj12lQH7jFcOGIPjZMng81odNAxuGJjMFFMrr4XQmr8KJBr1ze7oNn
yIhFZKeVRkZg1m58fCDZAEf5qTGU7zQwJU61h9Tro0L2dcPztsaQO9xdEpSm
jy+ae9BN1Qj+Zb79dMNCH9MbstyVS41g1xDt0ZgXGYsVrmZmWhnD9teR/Cdi
DHDD3/o+Tq0RhOQp7mP5k9G/dX3XhnYjOBrxIjBNk4CdyfllL+gm4P6wzulZ
MQWv7CwM4rQZw/k/SczEWgOMU3p239PNCE5d1RHZrKiHVqNWAd9SjME+xC7m
lTsFr7tbdwlSjMHVfa7z218y5v210dtw3hSePFstxNYkIUfYxEAcjMHR72+1
WBoR46o371S6aQQ74muHj1cY4MeFkLhX5saQsEivsf6AAUp4ddb5u5hA9eMR
l9PuBijXd+5rXI0x+Bac3ldWQ8bZ1R2pfMomUHF1LMCdxz2FZmWFnn+N4eiq
HSfM7unjiiPP17RJmgCnxCqkY4yCe5uy9CLiTeFofUH8kwIK9h/cvbGr0ATe
XchidSdSMMvJ/WwJ1wSslg1tlCLrIT37+9G9ksYQ0Ff5GjL08F2UpcztOCNY
Yux+V1tcH2+e+OXQmm0MNO0vd8rKSNiSLrfl3wtj8PhnRFEQJOGyQA+psR8m
YJxz99LoXRKaeeYeS9lpAuFFp7OWlOlhT7jxDbKUCQTQkh8pBxFxUZ+SU6yG
CWyFkoHfHmTM9+v9GT9nAqygXx0N+/XRSYPvfnCBCUw/n9MSEyHiWtHcslQe
x9syjvDvIuohrbhk+fxZE4gIefvVhEBEX9H16bevm0B90g0rlqgeqhULkb6L
m4JTYMaaiH9EzK70XSP01AzU74+25kiTePNGrvmfb6bw03x94bMXerizfKp7
PsAU9jD6nNhfSfj+/nqPLydMwehoYvShQQNkB8D5K9qmcJOgrFS02QAj0pyE
5RtMwIN9eCCyUx+/PN/R/pBtCqo3o/y3kijYsv1ts9E1EzgWJ7awq8kAJxMI
jx7yeMZFMEl7zUUDfHbh89EbFabw+0dDhMNFfXwaq5z7SMMMhDIrKXKryVj2
nHQhXd0MriSq8V8JpKDEH6cnxSOmsE3n7LXdk2S8k5Xwyo7EgMR+MZ0kWxI+
mg1S0jxvBj5p7/yP7qHgoIzBzp/bTWE6PZCcmqqPL78rfFmrT4f3h/4wbiwY
4vGYv07bQuiw1cyOGUUk4cLcsRbja3S49uGwXuuQPv4c+ffmbZ4ZDFv0r4vN
I6NJ1ExJLS9+kifueduuM0QnTGry5P2efrDlr9Of9TAl7qo9l+dL8eVDd5/+
JaGsiO6LJFM6vPvxV+m3ORkfhAvs2l5Nh2dPHKmBlvoo6ZEkMX2XDqxbTgSV
LAq2MrwLHvozIGP3CCNUlIInllct7S2iwwaB6tWmFAO8d6v1dMEZOpis8YhZ
LE7BGnml+kOL6NDStdE4doaCdxsOkyJXmcEum/iu2uMU9LwdXfX3nBn4NzWu
KObNn2Hpa+a/ZBKhNzxt6EWbEQoHVdtuDCOAG7Xphv59Y8ykmdY/miaC91Sl
0n4vExwd1jogfZUIJ85ZttdqmiIkXRpU304AlzRK3u91JphY+Nv5FJcACpds
ud6dJniXr9HzBYsIojOLVr1sNMZwp7TP8290YaJYjO/dNWNUWsSK+vNCB86d
eCI8Wm+CHUvYW7646cKN2jfxmh3GmL1XZH/0QU0YvbMyxrCRgpZDwy/EyjUh
UTChb5EzBW3/H1dvHRZl9O3xkkp358wwdA0MNdQskBYBEQVFQELAAAMEDBSw
QVJUBEFFSrAQFURglkUaICUYiIGUdCl159xzzu8+5/41z/vM3nv2u/fa6/v5
7nlDPkv1JEkZNP8UUFdf62J54JzFLSSClKjSwiaqLnqdnT3K060Ed257h1ys
1kXrjt/vsh6QweqZbvtCtQ722BOV7lWR4dBvCdbXO7RxX+z9b1L7lIBPUppL
8Zs2bhF6PD+5jgzJRtEs3nZaqFPvppVVQgZZzdYgeZomZpsTVQrSyPBYtf5D
I48mzl5sbb/BrwQjk1qubw31kJohvO7BTzKEdwvK0F5Q0HUPf35VNQkeD6f+
W7Wi4NiTsJDUa0pwbWPgzuY5Cu66RFC5+0QJHAL59nuaUzA9M+IoJZkEd82u
STeF6mIxd5hrQD0Jzh1cb1b/RxsXUX3vZBkRPmucEJ4I1sGf0Y8IwUQl6Hpx
l/qoSwf1fA0P/FwhggHtaG+8PgVDzkRcKDLXhN7Q01tsmPn98CeuzuXXGtB8
ZVBgh64ehm14pqQZrwnt7wfSzNMo+H3f/Tf6I+pAM5tIWtquh10cM3+GSjTg
usXnwN7rzPWil3LkYLE6lM4+tgy5ooYC/WaFnBfUYap9jfjdBWVcn+dqfve4
MjyRF37sf0UJPwUorH/gSwZqo/emX8eUcNFndLDRWQnCkjn658eIuFR56Qbj
Hwm2+oftfBNMRn7Jrny3emVgHFC7nxGugr5dns8ItXLwdTZidFKagO9iVuxz
PGUAfZ6F7WM3wHv3CIa1hczxyq5y85WiYs/f7LIEHipELA1KJWbp42yIO+d2
fiocGfY/uPKFio0bBo5pfKKCk3fGTNklKv68f+c4YysVdEdCLVnuGaBvrJkf
mwgVkH9TT76kAb5qUpDlFKCCQTRfTLCfAYaq9bJ/SqPCXg5vDVqIAToqjlUs
79KHMIv6seFkA8yTTzhfHm0Ay4MvjjXoGmJlp3E3tZoKbLxVQ9JuBshKuBXE
y2cA4gt/1M+/M8DT9/kusPMawFDAHmOv9wZ4+XDL+oPHqfA1aEujWZohPhC+
x/i21gB2s85KhFTYoW2Sx/dGNgBlnz0ca1PtsEpAccPUBoB4kcDW9AU7/BA0
fPIY0uHclpz1qkzeJIt9LebKAygK8O5OO22Peom/u6O5AGK+CnN/bLPDVK7r
Hod96eCcMqH3hln/0c2SFBN/K3jAzsFytMcOA0oKBvVPA9yQfe2Q7GSP9msS
vlKz6HBJ/JD+aosdBsaVhU1OWEJ3ZdSdvlI7LG/QaornYfooy33Zo+ZMf9x2
/UuEGEB0+O6hzXr2iOm/Ko/sALhnbGqv12yPdYG9eyrE6PA0wvi+UzyzfuME
m/lngONXghvWv7bDcbuF45ONAM6rQeneHPZ4zmEqK4rLCq579Fesxthjeozs
LXRj+t72e+c+JzpghTyuFMWagYWOGM+mQAc83dxgHOxsCdoHbU+K1TB/f6xQ
RccYwPHy4eRbmf/1fOzF+6E/LMDPwv7A8Jg93rIvU7vXSP+/+xMUK1DoPeJv
EGqPXKYsW1vaLOH0PrM21LdH71rCg9osS7jKMjv71MMew09+2WlBtgS/TVYf
qrfZY260bL+3mAV89zF7JrfLHolbKY87cy0g/KlYr/OgPeaXLf76TLCA03+v
qVfesMdN9949aLO0gHoXt67eB/b4ZjP10FKEOfA/sWl1SbLHLzvSHDhbzeFt
79/PRzPtseY5cfpxLB0GdW7IH/9ohwmhEbX9ulZwkFRZKeVnj6JRzsEXNddB
maDmC2q2HQ6fSTkzdNQK9HTDjZeUHbC9/ubcwBVLyF3L+9psHfN8Ng9kvFCl
w3dxqQNTG+yxyqxiVJtuBQGnHh4TfKGBy9zCdG9RadidJqP/z5MLb9t56nRs
1oeeRwVt9DPaqHat5MjKjRX6dXGJLeUz6phkPRmz/IwABWPjBd3aBvDLcn7L
lAwNfV5SGtvn9IE0IfHMeDsNfyUHkNw+mQHftzj/tBumGFDjw3IojwqPfn4k
eh2i4S1/QZc//XoQNypV1ahDQ1Gl24GeflT405So8OCrCfpHV4oPfzSCtKc7
tghymGLxNCV4pzrTH9vpNPTKmeFInnNGxl89kKe8mPj+kYaeestXKrdTYfG3
jCyB1wQvJv0NEDuvD5QEgeX0yybod1Lv+F4LJSbXDvKev2+Jjb7Vq2926oN1
88CiFrM/dg3j+3zz9GE6PKaPh4+GDXOxfYwYPfhmNxAsnUnDNc84NH1U9cAz
20tje5cJBlSEtMoEUsCj5Uvjl2wacrKQAnrGKLCl/cC0ay0NvXbsTd4jpQdH
7QiiUhto2F+96YlPPgV2yBm5kHLMUDhUr2zgDQXO1l84xG1viknSO8O6OGjw
9nWgyKE3Zpg2nB/RlqoCzU9vNCzessC6g21ZfIG6UHpHZcRuixmazd4K6uc2
ATq3/EWRMDMUH5ge6skwBFcbmXPqcxboW6VMH3rL5HZSlcGuDBrG+xl8c0qk
gqWZaqp3pAk6yukaGrQagHZeMLsipznW9Mzc6Gowg+oumzcZjeY4V84pXaxK
gxjRRBLXPnPkOSe+/6WkGRxhe39dr9QYI157u/t8pkImta598ZMpSvxIf97V
R4WfHU8yO5zMmOtq+sKyuCGcljhMezlqjrvrrkw+32oA+m/P7t1ub4npN+Qz
TEADgo6V2Xp4meM7e/E22y/GQFKUTpHQNEUv0QWH/i4daDnBUv/I0RT3v/n+
+VuAIdxtv5qeHGiKVe07TU4I60K2w6XNr7tNUbo0M5yFSgPrL2/NPzDjkfjz
SVhSly5wSlg9DDxsilI7mu94CutAUssbL6USUywU1e49+EQXpNPvOJn001CM
ayj43S1tUOPwjl/iNUX66ejNhi4UcNJcsFtDMsWe/N/aJyd0wNsnKeTuURPc
ltxKXdTXhvYnN35FRJsydUTug8F7bYjJH+xx0KCh03L9tc48Xbg0asjJSaah
zjZJbT5/bXDQZRH8fpmGpLq1sxcydUAl8FKDTykNF6LyMj9X6sCM4B+vSiMa
PnNuLzcQt0T2imN2zTto4Giy7qbWOlMwPhRjZv/eDD3XPny+bKAFD1k++92K
oeOie77O2X/c4LXL6fKsoi74L4gTRZ8SQH7POzsFggBI7Htfc4pZrvEtR/LT
J8ZMd5Lf/FkH8O5M5Kfie6Yw0JX+LKJeC7W3B7ndyeKGb05atPsSVuDmc2Jm
eVnyf68DYvzv9UAS558XrXhZo/CBXdIWOeZQ2CnkMeZlAyaT0VYhX4jodz7y
aqsiP3zwuR1pNcwHDLsOkabHy4xx7hwsKF+gP4q7y5qaoAm2DZ2dji8BvVMy
5AY0LJEkape9d5wG9u7yDQvL5sjpM2nmzEmD+YSPLRITGmgkIpPWsigBlMb3
OfmtazBw67VO7xYdmPtMlqHbGsCu8JqrzofpOC+1OzPHfZLRvjo7LprLCkW5
5oUJ8RKYtaeS18NLDx56CKtpFgqhUkbYk3VfuUE6q0TtxD8LePTSe6GnVRvj
3u7xtr7eyTg9dIpsYqsKs68OaVo40HGXPwfnrjI67Dn9/KejySqj7oVCY4GK
GqzUrO8vShaGh3c1CQLvlWHXtKPqj2gHbDq3suMKP4CU+KFacTdJCAyNOLTl
PhEc7ZxOcj7kQ3gaYBYzzPI/+iT0n+utTrqWnIsPmGUU2aWOa39QBzX18rU7
B5Th1tRO040JdCRfD7+6LsAeF42rzN4ZWkNcy/jki4hyepjalbEnFarwPWbn
l/l+IgjQLt1MmZKBw2qRrOQUAsqXTXPprBoCx8Szhw/mdEG46pi07hfAxfv7
8pNHzOF+1m2vripDpJxaNDqw1wpoA4XVkmICmB/r1naiUAebMtM3qu4ThrQN
rOkscwBnb/tOiySJoYBwV9+iuin4hI9Wp4eboO+lcx+CdU3BPSTacKhBD+t0
Hng8ZXJHrNaEWvtpArJ1rg4lKjN1dSrQJ85VCStuqjiLN1nAne2fyr+5kXDJ
qHnxzDdL2Nbu/fw9nwaGXlaNc6yhg0Tb2duCckT8usPGM4PJAfe9J0IfrSdh
dpLE5+UVCzicWW7xolMeoxYSszySLSGTX3Ums1gB63L25issWYLFJc+sC4/k
sF7jca6uAh3C+vBK94gC1u4OS6dsBNi5saf1G6cspjztf8d4xeSYsMGoWBNZ
HDdRF3NIpIPxTr8jC57yqJS4IlQlD1D1Rbjlo508DtWzmGluoAN63TB6s0kW
y5/Hth2RAVjfKX95PE4WA3m1EmZFADaf+bgsFCiJ57aUXtdjclvwkZz8/Bhp
tGZ7OLrlALP9LxsFjFmksO3NwlnyLzoE7Ul57dykgA6R22r49lvBWUtPXucA
KVR7EBfXcpcOyRbF/knh6thyLtlPucIMCrieLG2eNMGSniqN1demMGIwJ5RD
1keu+CqTlLNrMP/J3qifDSrA2POvtuKAJYTM0k+8F9JE2teNLtmPDWHLVffd
jofMsNL1aqr3SyaXHUHX3a8JmL9bMDgphA5ldk8c2x+TEWfiZ1p42PEtV8Xl
jptMHVDIunHDQRK4r49tCrxojfeG38+6smhj5MoatxcUSaDHFu66Ni0Lx6ne
0p9y1cBi0iVve6Ecmr4+ZflorQqweQTc3eUMyC6028csgwZhkp1Ka4yswSp1
K12viYg/ZCrYqproWFd6e3X4uAlEDB+/yLvTEjIi2hdMmONlchn95U2N4fAM
5+K+UHOs/fGUpH6HCrS8dimOXgsM5JPJevAYUHWBuHhkxhiacg3lCUlWUFDO
Qs7qlMGrHs13Mo5aQJlbGY3nrxb2SFj+k3pmDTNhB7NfhxMw01rI/neoNXic
Lgw9vUYMe//YtP3ssAa2Sxwtn4UUUYdKickg8SKfxsY8sylVoJj+DOE6tsA4
hcM6epkaIPTUsPeatjkUXJv9caNzLZZ07Cqeu2SLbpN7Lp2dAbi6u2Xm0FFR
1Hy+MUI5VR0EC675yd4TBJ33B1Yywkj/kx/4UN07hqUAZui5t9le5JKJ6L52
PVW5wwCOOA26pPb9z/PcswF2j0lnOPqKALf3ozfOVA3Q2iRkcOS7KNh8Hc81
E6dAx9Nystd5azC7cyAqUk0V5a/+HM77CeBu/Wta2Y+Cr+u1CxilppAgf+ZU
l8APhs+JL03iI6YQbs3uL8cyxQi/q/TPy90Mdlj07bLYOcfYkBZtZh1uCh48
aoaHTk78//bjWVjCzz9ObjpCg6STPm4mFh/o1XFG0UQaQPg3Q76cNCbfbe57
C3pkbDqyuEPhtyEM36NyBl/QBi+BzdtN2K2wVeiVhgQDIPTdm2ZpCTU8P9Y1
rHNrHRzsb+kwYmPFpO6bil+a1oFBktu2zVfmGeHNP9XmJewwXtHkbaWcFayW
iRTpL9lh8pJEmmHAOiAm/0pkXDXH05MWn/bfpUHsrzdusZ1WqHBcn6QyYgaf
lqhDHGa2mN5+3yc2mQ71HAtrgh+q4/3AW2fnv1BBv7mpqfuoGmoFfJxyy9SD
260d3tTzKsiNzjJEYz3Q+Tpu42lORjfPlbrbxXown0g43MSigj26wbr3WfRB
SqRL4+06ZfzrzzbVb6cHnEkfLVVyVJDduY3zWKkenM8yC9GpVMIw+Qx3x2wK
RFGy3htrKyNXeXlX8nM96KqZn+6IJCOvlGujp6M+CE5IqNsbkVGhReXvcWk9
qBBcHb1eQ8bnW7ZJR5VQQMpj7ZFjSGRyDDVjU4gepN9hE0xwJ+ND9YtbR3SZ
8dCjuvSFTwlDJEX9GwP1gMe5XF/nMREvP9kxe3OzDiS8k38SVUrCjQNtys5v
dUGc/USKU6oS5uUb8k7t1QGTf97XYJsyHiZ97O5x1Qcu5zUBzzaoIEfljT0v
k/Whdjz8KclDBfeLS/rfsaWC8b7gmseqqqiwIsXauawPrtpnnoQ1EvHjQ78+
hQkqtMX8K/nnR8Jr5bsexjdSQIdnZlD2AAm7E2yKtbfpw+4bfbCwg4xpOg8v
/uXQgQKxb6NlukrI8jRkKWiGAjmrJVOUPhKWH3N6v+JLgX/NTR8138pj1t7j
eYXOFBCTvO3EvVsJY/VuETz59YHnTUKs0x4SLr5j6cU2PVDdbJ4smaKEla2e
2tFEKiSwKQa/Zh4fKa5pa76sD4br5A3e+JBxUtpk2f+zPhiVfo1cSiTgnstH
7fWeUGCD24sstnAipmwUDKKMU2D2fZXsk2FdfPmNh/z0JBWu+ib0pqyj4Ea+
muEvf6lwTyvop62BHo6vOCU1Ew1g4NFoLOcrClp7j+EMk7PPpV/J++Snh3Ys
OtWvmT4nbsv6U4t/KBid0P75qgIVPm7xbpQdpuBv+wWh+CAaWO7l+qaSTMF9
pjbGuwVoEFf20fXkNjX8vKV6/ou0Jnyyrn2FsiooMnhrUFpFHRT2LA3MvlLG
z4FX+868UwXqiy27VCtUUEvfY1DGUQ22fi+xAub8Pztz5AiXizpslTbrGfQl
49XIbf1P+9TAr3L6ZKCzMppYVKrX3FJj+o6pr/e3GeJ5GucttbXK8DW29olm
hhb2r2U94zKiDDaMincPdmvhlisnx1pfqIBAMNyOitJGdY3L3zyUVeCNYdvX
nlUtLHf5zWuvqgzOLptrs8U08NdGp1dnNilBk5GsVb2WFm6ajaNnHVICxU9p
GntRCz+p1T3wtSWB8mj7/PNKTRTqcB6qSZeHlqt/DU+maKENLe7w3XACbD/P
lnGYVRu1WBI7jrgRQfX7uw4Xez08XcORQphXg+2+PWMr0WSsTe9OEHUkw0yn
tm44c/04bP0radFPBpZ52PZ7Iwkdo5J9q9hJYJ2zn/Y7XBn3RJGYMiMPzfJu
If0uyniNr7bwMFkKFu9IL1+WVUaVGJ5cnacy8PLvj08Sx1VQx5JRP9khDdv5
oIGtgIQKl0+4MfKlYDL0j4lXhRLW9s9bycXJQBzfq8z6Q8zxfvpozw6qNGxg
LL/q7VDCjM5zF8WdxcFcOFtUJoiM18IbYhwlJUHitAfLuxMEJFXMF3flkSBX
rjFlrTczfhl/nworSf5PXlb9D2/6flp1508iYPDs8N6XVFEYuFwYRmPm3dEh
lW//wswgZYukYs4bIspc/xq64ao4pK0Z8Mn6bY/uVupx9YWWYEOPrPdrJeG3
9IDjUrvEYXed8LM0bQc8+HeK1TPTAmSr/Z/PRSjjyyRLd4nTYmDBRxuWVFLC
/RZXNrb78UNRTcFy/Tcirmc4rH0VLwfRHm85LvYKILnvGqd3jRpkGD6KZuSQ
cHrhmVzZRxmYbBYyZwQTcdddjmN7yqQhqqeIfVRRCR1U/+2gmcqDUP1sQByv
GI5OHgRaqh7EHXui0Wplj+UfBFo8r1nBnkHOhbInRAywDTr78K4kFPRrJ8VP
E5j5bymWJ1kWDrTQpDOT5PHD6xX+gW+KMFaQEMFzlYADm1wpm/UVQZ0/ryKR
h4jXuBVZ1I7Ig3ihTt7Hceb4HIzjcoxVhMv2htxyP5RwZvueywMaiiBM4/9L
k6LgspuzkuINXohP6trPdcsB31JtfpZZ0GHdLcmoqQUBzBDyUZ8v0IDNJq7J
ua6ieGx/m9bUcS0QEesYd9MhouRUONk1igCtFYYNChGKeJvRWLd7OxEOPY0+
G6tPwPQgQovnCQLw9DkRmzxJ6HKy/c7TOeZ4qC5GDY2QsCzYQUg6VRGK5Nad
iHijhH/XeN3MPkMA3ZyvHxmZttjnyR1/KQ3gpMD9wSy6Ch5cFSpcvaIARz9z
Jj02VkWz5yqmDavyEKXNY9lpaYALi4tnq6eUgPfbbdJcgAH+4Bx/blNLhn1m
npNaCwbobsz29GOqPsS7x646uBviyTnVS7ukqWAwnXl6KcAQufY3SOna6IMX
v0ZuHbP+dSf2043v9YA1IeRXbKMd6tVvcNvgAv93/y7GErY3lpidP+6AntPR
ZdbPTeFWU0bh2zoHrMmYKaq7ZQoS1Wd1I27b48L99Ya8mZb/t/4DC9hrFFqx
MGOP58iiegyCJTyLfz870WqPGkp+b+8XWYC/89rcmM0OSNO9o/5Oxhykjh8s
LL9lj1KEUvkvfWbAzXDqFD9qj6ZnZNLH0syA4Lvrre2iPdosWFgq8ZtDokhN
rCqz/bGN3waLrpiDmLvkmgp9B1R8e0h3G7sZlL4ZCF3QcsDs+LVel7LNYHRX
7rdXE/Z4krfbe5etGfy6fHqEl3lM37DC8SvXFGh+t/aVfrTHUY04pYj7ZpAQ
2vO6zNoB4x7nDIm6moJKqd7N5Up7XBkPOFjlZwpjsyniYpfscWj1+O6lN6aw
0pHUmMPrgGfo7Kwd5qbAccnDR+iQNXZ838Ex+NwCTtRULrbsscMUkyMvfaWt
gF36oj4MWONmjvQcWjHz/H1f6a1RdcCWOx2385YtQFP33uEHQfbYdHnmZOa0
FUwd/132PFEKa9Bw76EmfTj8+auHMJOTBHsHbDR5TfDTrx1JZyhUSBT7rvBR
0BjtTz7oJ7Towb8wl5rPYSb4Kia53CiaArSZ3pYHwyYotyU9p6qMAp+Mu7xH
HGnYbzrprfCSAi39ihZi0SZo0TIstkOVAi9HAsOoZcYouybguZM8BX72DLX8
2W6C77p7djWkU2BBk0LyWjTGBuEI9uZhCtwx+5XMUDBGu9aqm8M5zPaE3ndo
nzBG63Cr8xYbKbA+pn/5xqQRPo5u/HzmgS58sSqkPXrE7A9pSO8rU9dn4jb8
zqkwwvHLEQ/PKlLAJIJt9MEJI9whnru1/70uEHy2lvmbGePeo/w+AkM6cGZT
JNeLemNc/Hnt59rDuhB7+GXLa0UT/KJVScux1gbp2ncdOcomOH50tkSCqAWH
39xPnbYywfk7xS0Dh7Tgx2Pu3vJsYzwdff69lKUOFOcKHuNQMsGM+3sq97/W
htOjW2obr5tgvbp155VeLfDMEXIWSDNBylb7s6xPtWHsueDJ9hRjdHniINpV
oAPiJTkekfrGqHk21cTqujb8lrGNneQwxql7M0HGxVpwSiCo8DhzfIAiWLPm
6DpYYdu57eaqGZZ2mf04+1sVwij6TksmBPh0vT6olJMLhdN51B8y+VVZ52vj
crcl7s8Na9ykagKjlQ1sD89wYYKqrFZUOw/Ulvfeq3RfpbtseOfxPUYHMs69
mEoftsfN6is8F32sIE04s/riKODrO9XtTXImcBabKLdtTODI3l9RwdmW6C4l
45qQaAyBcfR9R27SsZUxfrPysA12l8xt3rUD4LqRYeTOK9IgReXSzy1QAKfX
Pw2FHHkgNytU9vCsEnzq/HK+L1wXGqtqguiCVhh2+2jAXOckg17Exq8QpQ1Z
1oQ67Xu6IKnC1zovBTieapB2KlQfmnNGetQuWaFRc598PasO1IoavLQuBwzY
newuvMg878tPx5KY7Yl0pzV2P9OBpgPOr3vPAo5unax0zqKA3NjoVRMHSzRu
/VPWOW2P6pXmytsibSEz29vlx1tBmB9Uj+7ZpwytZ8pMHBe0wFWO/636ZcCO
fAF/NQlteNawvHPY1xqXw0s1HpdZAbcP502fi+YYNRRfbNI7z8h/fPaW5Nr/
fV7Mwn/25/wmniRq7F9lBNqyvVZ6wQLDC2xH7FUpKD1Yvjaxkh2O7Da0VyjR
gomKdyYsKRZocf/7mNuyHoiGlwnevmaJ3Al/XXz9NeFEciWPLfP7j63GZQcb
9MB0nfjSUBUgeMTpiRTqQWSQz79JYyv8rZMW/y3SAvZ3tXYtc+tg4e3h7Qvy
+pDss1Sr+wkwytlposzBCtg8281u8xpiJLmTy3wdDcvVFTUmJWmAVcn6c0Xr
4PtAP4vgNjG0KAhIlfkG4Bb/O075CRm/ev00+yZgAeaP1zBK35rizU7bSWmm
X0/gTHCZ+K/3ouU+H+nfbwKiX9eZDNSZo1mx5poLxzTgg+BT3RN2Fpjwz3I6
wpYOSokpn4+bUXDvhN3a3h2WsFD0h3oljIIJP46mRGvog59ZWkTvJisM3jhD
qKoyQW9hFZeIERMoW+Na2jBuBXOXastL91AxeI9VY4nrOjh81Wjh0D1x1L3T
LZ20aAkn+ZQ5flXr4NNTM6oZB6zAy2Aym7xPGbfOVW7OvWAJSgRNmap9Qrj9
2sOKbf4Ae+yWWjMNNPHK9N29LQesYd00T8EMH9MPB1ndzEhfB3f2npMJ6BPA
zD/wktvICjPZO1xXv5r/93y3/u97wifoPPIHB4wbjSF7W/mVurV0lFflO61B
toGV2YiiV8kiyBbZENx11BQ3ea5pdvExgXzV/V+2+YvhcXG90mNPjUHmk3vD
8EEJjF1WOBImS4UNMFIefNYC4tuaT3hbKmF3Z9yBMxIWQOdJIXQXMrmzaq3v
qBMdais1U4oH+FDr6Ku4LSmKGLxrtERSkwfuyNk/SS2WwKjwWs7MAj6w6BeJ
dvwuhAuXUtRjfHX/rx672QBb19UFgS0SMBcWovvghSpU02ouZj40B799bw9k
v9VGwqMDVYGedOj2k5CZr6NiKu0h2SHIFNp8zCIeh9OQ/9saD+LcWrheVHT5
3W8yFDRv0xfxsMMZzgJds1xreBBg4Zw9q4NP5l8Mz6sRoCrgquaDORGIMTU7
439HBU7HtjUaXmHHx11j7EF7Fum+yvc22fm8YLBeyMwY3rVM37TxGotPFpPD
nrl4qW8EtM75yvX6tz44Wr1NECUCdmpd8JmIRMZXCaX9Z2XVoUjc9uSJl9OM
kT2fow4E/6W/Mkbjs5bCoCXf/FKCnwzsP1xNejL1wdbCdyDPA3C6iDTfNKcD
58/s/nrmuxXuq20LYEULyNrA+rzfVQjLv7qmGq6xAlWLw4c1mo1QdHPZ044b
IuhYOup/fpMB9E1cv7t5Yh0c4ljheyahiDtPmftuWNGHXSeP3XWWo+OORcd+
1hBT/PFi27k2RVOYC/f7WxxsBULK7CdN3WnYrdO6Gr1Ih4jBjmybWgrS5tmW
84M18Ax/N1E5nQqNMaLXV2+o4cOb03fWv6AC4fnzoxnRqkju9Ng+L2QI89gk
SexRw5MXClPJVwzg0Oj63NZb6qihbEoZtzeEjj0TNq731LHcbmIou9kQ+Kki
MQeC1ZByV3IbI9UQrFjafuRUqqEK9bGLnoQhuGvmq25+QEb2xECTm91GAFe0
tnltVcF1HNWF+wSNYNVMoH+JyaMyc4EZaUWG8FKqYnbmIbM/8ypVWz2NIOBC
peP3LA18fE4hRZ9gANu8VIvHUR3fFcEkMdAA7snrnVp9qISquh+Mc4/rQq1L
632xXBKeq8HdhGYdUKZdP7AwRsEb5wUm9JoMoK3yZ4txuR62+YVOS3dR4fMG
PZ9zJvoYWcizZv1lKtw2kzST7NDDlwzO9GZvKoz37g2STNfD2CzDvKlBfRhO
vOTHEqeCe6z2dHWZaEBTMQdZLVgVrfvctM5GqkO27+TN7f91/88i2+wWbw2Y
OMbZOl5OxtI9/J3kJk3YOaOll7CDjA47963NCleFd2c/SCyxaaKtpNKNXEci
aFUvs2xh1cK1ORFOZ1KJkHGsNTfrgyZG+U+vmTtBgtoElpaYJhLy5yT15vEo
w/0fnngsiYQhB/mOKowrgbH6vqW8GWVcJ7L/m7GlLHhSumPD3VWxW079ZJC3
LHALFN5yJGjgN/7nE5KFkjDGHxD8rF8NX1hYHjH7Jw33eJfNFk3UUHF8hCfV
SBYaSyj3b1SpoBP93PYd9yVA61ufQ6iZEvYGsYkQpUXguL1tUtq0LO4Reyzg
s5kZXzYbr76KFsbtYsNaO6L0wGHROfq9nQPeJDjwnleiw8OB0YtXQxzQWGjM
SUTV7L/zB0HvP/kvzrkuKL+fH/kdbDvcP1Dhveqn6wwFbZT9OR+y+lYWNjzx
DtB5JI6K9n3SszEU+CpXf+vrCSrofrj+ePdJJu8QVSw4s/XgWOl5i8OdJri+
P7wgUVYfClnPfNGoN0G9617njnnrQ81y4FBTjjEerCXKXRrXh6SSQdaIImPc
HGfOeiiXOc9Fly54CJsglcHRcoapf6+0inl6mPx777fs9IMcPTAqbtw5cMQY
Uz1bD67Zogd7YjbyD+82QVvVkPgLAnIgrCURPTe1Fo7cl2oXLrDAY5xfJ9iW
jUGVekbKB5RB4LZn3ItSK2wKsOvLdpeH+mkFwVwpLahd1vqa+tYBuek9Qv/Y
rcAv+ZnByBsJCOb/Ur0rQANmtXSaRN0dUM3e0/NBmA1Ej9UrjybRUCT7AJim
mELLn1Ju9nIaPLHiGK7+bog/3HvrNjqag+xihdR7Yz28fS1hlGBqCQ+ppO95
FrponBzTP0YEOO7RNngrTxwPnzru/Gi3Naz8bC9/LUTA9WrGtewUYfTf4Do8
2E6G1AsmPGVfBPBBT1fusWk+SHINJXcqaGF3/oPTVtLCIFlR9GfYRxyeSFaw
vPWyQjJn6uSXAYAw3XNfbZm+2/bxw+aLbZbQH8ZXxcWtjr7r09bHMfX1+YkC
h7l7Sjgwa9B1cQVAalX8av5GEqovRSxZMvO06V9pl48DxmB8xo/u/M8E2IxH
Wk59sUABnd+F+4+S0HjEu87Yl5nXe0feu5ztYOwkFofepakBy8OHVEUBCXyt
K/RizEv7f/RKDP433uIJCybnLzG5dejB3WRDBdSdpXLc+20FZqe0hfLEFFFb
hy1G2FkKhibJNKF5VVhMPLZsWwBwnl7nU1HG9MXELx2P603hKFsLp0+gMUoM
7mxmSbYGv4AO2wpxMtqubh7fR7aCiNfl6Qn9JiiecqreLd0SLzr8achhp4GC
9IsV0WdEMPKNHl7nADjgYBroqqSO6xXeDnDWKMKd2D+jsvNWcDSxQ+LmTWFs
fEFtq3OyhqC9BTXmF4XwdG2e7Q6aENxay9ldTBeEzm7RLIHHiugY1tbS5keB
uSzX59uYvMb5vXXVL8ccC97c4y67aY8J+q869r63gfiXch/UlACia+sF/CzV
UODfjrulTD4red96WdqBgvK3fRfDtW2xXKky2XQvQExP3WDYNivw5tucONQg
hzKXNc6cyjSHcPr2tYGrJnh7XEClpRBAr/Bm+OUGMmbyHapW8AIYMXi4oapG
FYm2vcE/ba3Ac8r7F8chI0x/c+BwXd86kN6748DfKj4UqtAqzjxoBerPdomd
7tZD07Twvd9bKXBDI+5BVgIJTMR9My5l08Hs2FSbhLUGRitcZftlqQgXNFc0
fYm8YNlqfKf3ISfwpG4tNTuiBgGeI1JaWtZIS/QqZN1oBk8+jaeUMvUkvmdq
YGVGBizMhst1FHXhttvDYWqmFW7ZfrKwIE4HIhe1Cq5pW6Jd6eKGbXcs4NHa
lekzrBT0eKF+A7y1QfRYrb1VkwVOJDanHFcQgcSehl2DG5Qg+3EubYmPH9qp
DoUy82Qossm9N37gF8P9bOdA1uwy/eAPArFPfIgh/GCj34Z8NTjr9j49158V
E8we7lDLVYEOM1dtxfef6IoinQ7tLFrwfXagwZuTmd97G/TNrxsAI/XgtZYc
BxRpCe8IZsaBvKvfZaFxCXyy0W3EKloL+tX0hz9v4kLyYgLX9z/asC4jY7TP
nwu/DPYR0h/9pUsIJy7UnllgTJRAXMknAThstDXqtXI/w+rBt9rdHLogVpBS
8tlXAo5MTvtt7ydDr6zHT8IFGrSYiX5btabjZ7Z85Z4mAIt93QfPZFFRYeDQ
lcyadTC1/6J84g0hLNS3nY8VsALlKx6by/S5MH6bG9dlFxsQs4//oCbHj5J1
pzX6AiTxj/1exSVpA6hzumTw0tIeBVonJK+csQWdm3W5cn0ADx48/Xj26Azd
y5G1uqHKBiL5fLqDJHjx5efhfI0mK1D8bRX8wlcFl8oOCKtvtIajxj6Xb5xT
RbECzqqrhlbw6Nb+Py6mVMyOCYrfeswUWPd3ux8NM8Ck2qK99RfocP9UfDiv
jihGXGah5/NawZ5zLd5eLMJY/pE+03LAHj8uRinkZ1uDmbeH+YANFZM4jCUn
Qtkh22Vvr5muJsgIXE36tZEEK4eDjY5waMGmqETzTRYWyJu76liPdGRZSxiR
vGoOX3JH2XtE9YDDfaTSMxMwpoLYHnLaAbUGDTvciDYQEnnbmuOnJkQvhLgr
KgJej9h8o5hTFyzcNQn4yxzFylp0WiMp4Pqq9N2tAsAPUm9PPymmQKWP7SD6
WTHzc+GnHGErqCzQGo2KomGlpQw0HAfA0zqzRhp66NZmf/uPtBXUXAo0uHeB
glRLIwv5ZVOQ6FNbazNliiPrLE/UWOigs5AUS5qaIhztOBo0+8oKgudDS9r6
TLEwrtVxvS0J4zZd/U7jM4KGI3Dv/ggJPT68kLihYgi5midZ/z1RQo8ug8xY
bwOQVDIWXfhHwpKpudCIMgNw0vhzfOs8wHTNwftt234xZFuaREe/ELDmTjz/
tmRDeGxid+Mdvw2o/g4zv6cuzfSLcyI/rlLhb2ji+rxtlrgmhxZUut0K+I/5
/kz8YYIvGM6c+laacLP9fceJvVYYEGbwlNdJE+I3ahhdq7LGG4cUHeNVeaFv
g2+fzVYKJI8/49b7bAq7H7OoiQTSUN1TVv4gUQtYSyMY+/WsMbVm/BKOKuOu
4A/Dne4GUBEtyZaSpYwjx5QeXaEZAhvPi63l1irYwvOz/udFQ5Aus8z7e0IV
OXsN839sNQDOoJ1p3ZvV8GCWWM8yuxFTBzbvF9qjgr6z6588/WMEmnn3rT5e
V8MGn6nj7iNG4OmYXpvhrI7+t4c69xUZAcE7w37kFQWzq3esbdtiAJuuP/Oc
/krBMd4G+sWNhrCh+4nH30P6WMKmcF1c3gjahsKL1v7Sw7H2o7WmmoagfDhX
/eN2PTxq1RtrJmsIAZzrdpYw+XZjtWfh90wmLyfkZ52vUcJ4ZeexwBl1ULSW
H7//m4gvnAsKFF9pgut9ntpQQTIW3tJTyJvWAG7y72mFBhL+dhb6Q27TgF/k
23lCzkq4+3f4kVGKFkyd+hvem6CEB9pDdQ46a4PMXJHvU1dlnIvXWa1X0YQZ
Q9pOip4yCslHCoVoq8KrT4cSKu2VcCROPWpKWQ2MVnm5ArYoYUvIqwtPuZn+
MEB1s14vEU2fhhaXR6tAuoKossxDIqamFh9S5lMD9R3hZOFoEi6lTxX9ilSD
M7+UeQazNbDkcoTRMW0SNJU7utZRVVBtc9YkD1kKMt9v/CX+WBXdGPxP+TKl
gKDQ5H2Y6Wfe/Y4IUt8tCZ48B4N3fVFH3a3+l0o9BOBk6+MbnHfUMSS7InPk
gCh8OveZopKhjrst0r923xcHoU7TV2H/VHHwdilpra0YuHztvUu9pYaJrPez
VLPEgWV74EoOU9fYRS6wcCdJgN+l6G9UVEYv3YujE4ESsOZAvM7P3WQ8sPVG
fjGXKNh9PLZJ6rIKpuQ8+FGzVQCgom2tmD0ZvfguvNtmKwQph7emCFYp4z6b
3/vKrwiDkedXBluwEiK/J8deXyGIDOTmelBCROGQJ2cszwpB/pup0OwFps6+
Lh3yv7sWuHxednh8IuPJq9PD2ReEIWHbJad5OzK6NIxve3eHF1RLZa3o25Tx
zTdS6HZZAYiXPm/vxKmCwRzVQvdFeQDZlbJVaWrY4qIuNKnMBbQDngOPs1Xw
9Ni1pgoFVjge8+jQTooq3vdl/ZC3hQecHgyJ9jHLv8/2CapOFYQZwUQrG6oq
LuxzNWrZwwncvhqbnPnVcFMWVVHmEy986JVwCVZTx+5U4Ybs5zyws8d8zthJ
HdPqmlrWXF+i/79YFqf5Hz/g3qfzb42aBordaYg/HccDacsCaxxZyOhb0H58
sxEnpGf0NNcmaiK6+A9IOAiAu9HrSDFWFTwo4fNs0JoT/O/9CI5S1sZDvwQt
dRSEYHOFyTFLEXVUnX0Xk1HMCn/ZefsrZsjIs3OX4t0ONrhxJCdJ54I6fsja
eu/TeQ541/2GPWWDGg5eXWt9ypz9v7kxjvSf/v2/H6D+n+Nrux/WvfJTwiuy
nvJc01yQxPpt45p+Eoq6Ui5s7ef47/pI/k951RqbXIcqVawuuHt+6tQy/WF9
/an2Ryp47k27UNHSwn+3/035P+XPL1N1r11Qxke/JbJMO/9nvNyUcf+J5oe7
X83SzcPedrfeUkK76YfbU9MX6dJjDb22cUrYVPrQQJfBCqsjAiqunUR0PmWu
s/HSMp2VEvP5SgYZ1a51v0lyX6E38DWk5nkQUZdHNIrdiwQ9pnUvRVIJyJvx
g399JRG2VN932jdDQJ1ejs/wUQkSx3MGn4VLY+F+tYYbT8lwSpklrXVIAYOm
F8+f/qAMyppPAxiHCZjRszGpklsZsjcF3G3dL4/mDT/v9rxXgt9WDNfAPKbP
aC4JI9irQPM3XPJ8r4DTPtUFJyvIYLflyT7Fe4ooaCVfH12iBFEpm+cPEeRw
Z2aYRu4aZYh789Quz0wB//zYzbaaSIKfWv2WxVuIOPZk49OlCmWgdQcHHDFV
QLK5IcdUiBpIlVsc4JMj4sdcopGgnirwRhonOeUpYsD6hCcaG1Shcyk+45C2
LG5d5J5fWFQCghacio4Qx5vPnPYLniDCBZavJlbjkii+mjwdMUuC96mOA67m
0vgdZUUznzL7t+WtHyurLIZKd2vd2U6Ccz0XN58Xk8PIznTHJGUlKDl1583r
SmncMHRPeBpUYZax+6b1fgJeur5f9nu0Giy7rGTGf5TDS9mHjtH2E8Gvc3ZQ
8Y4cdv8kBDgoq0Ls2VXry04yWNW5bY3CgjKweVv7TnooooHu2cHwJg1gLzrB
RwolIltU2+RLW3U4ViF11kVUARvMHJxzmwnQek5ay0xBGo2+PuWkxxHgn+SQ
JyFGHN8end4xIaMC0al62tcIssiSdS0/t0YFHLIpsdERiqglsEu0+ZQ6CFzf
tDXmLBHnU8f1wpI0YC5jf9/OOzJ4ZY8yW50dERaG2bemu8oioX/Prw5tAtQ4
Jmwl20vhvRNah/UqiLC+1U58d5gsOukW7HwWKQvzVkY+gwHS2NnirUT4LA+h
nZzEnhlZHMj7yl8/Ig/uF6fZTUYk8d9YKs/4DhWoftV3RfenDA7dHbXh4tMA
TYWAS6IOJGzv0MhfktSACP9wX5liAp5Kjbxxd0kdttTSHG9XEDDgBecRjGbq
UxF1j4idNHp9WnKpCCVBwvwz6nsJSdxuFvk0rY0AjTvJKUEdwij8qkiud0oO
LNi5PFllxJDC9cKqtlwR2H/vabrnJI4nN4Zr/E0jgC+n5u+CfglMjfWbiBpV
gE05hKkz9yRwubmm7JAZCQSTbLY17xXGkajEFY53SlDRPNtT3S6GP1Mm/e1K
lSB61mm70KoESgsOtQt5kqFwl+oGgVEFvKy7c05PSR7EE5tsz1WLY0nJdekj
zPj9JuRPm9goj/M+SrcKZTSAc1TduE5BHjtnM5OXsrThyodnXm/nCPhiGaLc
lrTAxHEgsfqCFHL8uGc/46sItjTXe79FJHBtYz/9dKI0xIf4cj1IkkCW2v3L
tseVQDXyxvbkRjEU9TtMwkEyBGwIfXtSWBJDlraY24YoQ/ioj9EtkjzmzvnK
TO+QgxcHPa/V7JTEj28qLv5OUoUXz9/XfKXK4Ub5zU6xvOrgVLN04EmrAs72
B1744aIFylbHL2lqSaL9ui0ebwlysCHmQHy/kSi6yB6InLAlw4pLXMsDdUHs
+vL84Z5iFUgZWNQ4TxTBL28U1tvVKUO6baKqgpw48psd2Vtrowo6jbHC1mdF
8bgp4zV7sgocel5hX/VMGO/Xl68UbFGDcuLjeVdktu/4OcZOSA00NKTV565L
YavbckXYPzUgnmdftpmXxXGVD5acaUyutE/Yv8VRGst0zk38eiQLlByx46e/
SKP3wNrQdn9JKL6UzThPkMFF0q4hep40RHzcWDDpKo88WCm+uU4Kbm7hKvkt
L4U76gQzfKqkQOZNgbjSMVnsu6EcvGeTFMx8aQx2cZDHmuSRTR2lYnDZ15Pz
apksZm14lbdTWQLebOSdGQsRw9GS6RXx/SIgWXRSitIojnPVXZ5Vn8Xhz+mM
2BBraVTKD3daPyAMv4u2+lbGSWD6BrmuyWJJMH6xatLqIY35Qsqfs5jtV2nl
7PreIYmKLT+/pItJAAwIpt4OEMMDKtW9M42yYDGmb/01WAazf2xJ/6ypDgE1
NM38X1IYtLslOlVEDXwpNZ2PT8vjsdd3ui5xa4JsmN+fAhdZFO8LsRY0E4XQ
2xNhZ+YksCCo6e2cpyj0mlwksQsJ487fd9pkvkmCn9rFT9ItovjubsDZn2ul
gCGofUKkUhTVtpGJZyvk4Y9RUAQ7RQHnfxVdfOYlDCWlMgKa68SRz8TynZi4
GJjz7zaZXSOCDk6tEi1VYrDx4b/IWQ0RtAlRepS4QQb85qa4WqlieOtXUcXn
H9LwuFf3nn6JON6JTS+RC5CHfH9X7l4ZeRylhvq3dooA6XDem728iihtI0YO
zhAFkcTR2BMvFHHMg5Q6f18CyG6ZrdfLCHiLVLeDqCAFuYaTDHo3AXderxb8
rSIBQ0dl59myZZFOHf515LwQ3BiKf+QfL4JvT3VsL70iARWEIyavH/LgFYsa
F2EuWdifuJlBf6yAxnsOGsQ7r/nf/af/6PmZccHWXU8FMYWVg+S0TRa4fzqX
pj2Xx09YlGbpzwd5Z0uVVnZJ4Q0BYgN3PC/k3bHrVn/Oj8cVd72VF5aGgtNv
VqTF+fCcBmm+JkcRPvC2NU6ayqNx9M1qeq0gnH0ewZN2XhrrTGn7HvoIAu2B
no8vM79nRQZ2vRrjgb1RbYTDsRI4/Foq46O6EGQ+NSilPV5hWFkEHFjDKw5p
w/0VJvKCaMRydmZTrTzslHbYcOibHBLObf2ZH8sFMxU/SXoVsnihs/Q4ZwgL
JIQ88whqk8PLbIs+4Ur/wztA+P/+37qn/YH+Rh4P8AyplIWxgEYjFsy8kMP8
q8lT924v0IUaRP+kREmjSude6akATqA/6OAYd5LF2YHScMHgNXDu9i87K34J
zD7apnmlVxjI89hcNsGJ+nYnKDXZkqB8vuXkwj4e9JfXWPQKkocqKeNCt5cs
OPTBbbxrQhYsRWXvqBSzY98vXaegIUVIOaPwQmyaEwXn4orOicvBqxxBp7iG
tXi5ksvQX1kRPlrPrIh4ceHEddrcj3NEsKjRIYcbcKNzCfe2M+cIkLWQG8dd
JIi8l4WaLUOIYGW9FbaXiGBI1JuUV8pEyE/aGc0xzofCh8J3v/uv+62Un3Fo
RQuj20FrM6E0RdDlVUlHG0X0ukodM6lZoD+6bXHBr0gaV014hwfGuMDiFXfq
UCA36mXdOm06JQVdLyMEPWic6PKh2sLsozQYnf2xt855ldFpe15IDqTga/oG
1Tl1dvw6UHPqMsoDYY06W+G3GYZUXqjqyhZFyGhM3zvns8IwQrIXTUTxf+ZH
4T/zI/Vr89G9HUz9mN572MBvgR5UFe31sWCBcXnvM/GbvPKwz2/aPqd3kZEh
HkNYEiLB5X4N27QLBJxwEMJNrmzQthB5+/JrIpJ4OyiqybN07vAALvO7JPTz
7Tz6TOkvvc7cel6qf4FRfTL0tK6/DNCeTERoXlhl3NS6m1jdRQCjnUeje60I
KHBc9GHB52V6XLGP3kf9Bnq0k/GazamycMbx/DX3FzOMozkjihZcRIC/ij5E
XXb85eD8TOszEVjXvhWJuveTwV62QU56hDmfdVqzkbF/GZxvR3mOexMg7rHO
Abcd9fRnJH3PgEgyxP+7nL+4zIHipmrb88cIsLgr7/7ffDas2Pi1QsleGbbs
lP28unOS8bc7wTimQB6iYuv9P01MML7JXPnaHioLScL6nrUqgwzvC1dFw29J
wJK7+hk8+Ykh8fKXVIWbDNC3Hl649WyCQeItb+3ol4KgKnn3XVo9jGxb4u9W
DwKYbmzZ5mA8xNjw80P0902K8PWRrBc/eYDxWvvE+855pr8lNbC7V6xFwzeh
QuO5SvA5+K+kwJlWxqhxbKHBsix8zxSRHi1BeoR6LHXveQVwQik8JNBNX7+8
eM+fKAlz95rvLqTPMVqNNXfsq5CAy2cJ3lWW3xkeiwF2vAeloOO8U3T7l0aG
ufeGQ331TH248cP00KMYeuR5k+K071Jwx6CEtkuum/FBSvowZ7UATAn9I7sF
vac7BYp11fSLQKrm9ftPzF/Rt1y0kr8qLA5/bx7YFFzSz3gRxVp8/7gofDlN
iRR0nKYbZ555dDRXDD4/9xq5NP2ZMeJBDte2E4c7BwWaVF0H6ENC7PyXdomD
wfYaqVWRWbq+wnfJZqaecpgsb/ns8YteY/nqB6ZLQ4WnVR371VH66eEtwwVM
P7/QeEKsevMU4wjVWfIYhQR7f82wHrm+BgXSq1mOXyCBnTdF+aoVK2Z1f+84
G6kE4Ts8gr3v8qHC04gaSg0J1mnzuBy93cVwzydcm45SAJvis0IjpyYZZXby
VLtrYtDHdmth4Pos/cr7vDRDpl510fnTdo8NMDos2tcUehGhm+3QBc0xFry0
OmawK5X5ey49CX06c4w/pIT968uU4OFvobzh2mnGQ9q6mr5eIdgx8Lf3qO8w
XeFChpgak3+2q6bpCgb+YRRlHTVMYOYToaQXJ+7CJ/q1qUzbXAkSOKtWPH5R
MM+QkXLcca+ZBPuncwNMxCYYPd8/nt51SwRSNl0TjCX8Ywy40P+qvRUB+b+M
hcDGAcYJsHk2OCgEvyvvPyqKqWekxHxpCzkoDHWC+Mvp4gBdOTdyZpFLAMRn
gxQbVLvoXt1J/ZKPhOBSyYcAzqEJemSX4oWvZcKAh5gUkTFJ/1yse2L6hAwU
6EZdlby4Sg/5e4XWriIL2ns3fizdN0gv23TS73yRAojVCfQ4lHyi78j1Gn+n
KA8f/wjXjIxVMXxKRUvn9xBBo2ZuyTWaGwPizTNHeYUhhPW3hGjSPD02qD6m
gkSEG12zKx09vXQVzgqj+ZMEUCPGG98XqWUM6mf+SrlBAoK9+qBZLjN/L5lc
yE4UgQ8NDOm8WWZ8bV/Sm19DgBsK2V/mxa7TPTqMKvcpEOClu5YTx3gf4592
eh23Mgmo5ruJC2Y99NA5+4ZHrkrQlL1zicLSxvgzd4ruVa0E2Hd/T8zeEcaw
8F1+AUEVKDj264zLxU+MhlGf5stMv/lxsl7I8yALcmq8PVq3VRTiVOfwZxYb
1L5MMdPNVoSDxbo7Tr7+Q1fcjzM3/xDgc4+mNe3gNL3ZumBobyMJfr2xavdj
maL3tj19/v4DEfQzEyXl3b7Rg6SDDIgHVeFtR7FTP0wynvMEBG5uJ0NrxGoD
74VBhkDu1xvVK0pArdItUutaoh809DutRyOA/jbNn/80VuimxtJHA9YpQFXS
wW0yEezwuL2Ubb6DCO+rr70uY2OB7kX3QmdDImjZ8gmvr1+ma+R9K5o4QYKP
hD9mHiqD9JKLbXnWzPUw6NBX7JhRxXjOssJuc1AFuJ60jgyw/2NUKr26oz2s
DBLmNTFZI9zQqLeUzv5bGWxnDNPTMz4xVCuevu/8qQxqpOOm/w9XXx6NZfTt
b8w8z/M8z/Pw4t0vr6EiYyEZQhoMCclYlMhQGZKkpBQpkcwqtiFNZI5Ukkip
ZJ7p5677vXet+/vzWc9e5znn7M/Z+/N51j7nOKveJTZyXFNxDJWBxkpGJsmz
80QJ6sagiksyIGhjwXLNaZz4h99rwtdYBgwT439ZdK01nRT5JGJUJw2uufUG
6znzTcfnlVKOFcjAgsn+CbMTtLB5wT89Z1MKAjMqBKp3rhMPGzXTflKUBt76
XcqCrj+Jhc9Vv17ylYUnQYpFLfzU4NvMdFBnUxJGvz87aR1FCXcP/C7d8V0K
AmjyWUZ6qUBCJDfX5b4MZBZQWhxWmyWe+lNWXWYvDX/qCHol1avE6miP1Qyy
FFxbuj9RE/KeGMpux/PrmizoGtcyBOhvEl1WvuYxq8pDQ2XRaULZNyKr5noz
pZQ0fLfvj77uMk880VFNfz1BDn58T/7Yo7dtn3Wb/PGJLJTJWLp8//2DaHfY
OrnsuiK0sLZfdmZcI/q/fCMUGSwH+avO/k6WU8RxfjXl1SV5GAfJpsEdv4j8
1rfd5lnlgepmhRiT6iIx/wL9+NlMeVj2FkkoEaQAsoO10r18RQgP2+9kkbRB
XHbZEmQ9oQDMceWvhKoYgH91vWCdQgF2fmv65+CyRHxZrDDJH6AIjCMtswfi
54nX+DxvbW7r+wtFl75zqdLAXqh+QJWqAEOiwUdSpJaIDnoD/ktJqpAhWb0o
fYgSnG/sLkz6JA+/zoTqSdfOE4P51gfORypDkqGT0J8Tc0SFPV5Vlw8pAV14
fr4p9wZRO3e3qtgLJejJP7yg0MYMcWE+21RIGe443TtV5LdFtOklHOFxUoER
WqJyVz0tKE7mw/KMErx5d3qzI3mN6H6BRbTqhjLc1j5XspOCCgze6o1RJCpB
y0pBNVbQgvoO63DnGkW4S/qc9cqeCtJDoa86Rxk+2ROu3fSlgxPNL23dPFTg
qfN5+8rvdDCvvMeD9E0B/PikOD7Us4NT19FsxzRFcLnuIXapjAl+MZ6SnBNR
gtYPRLIykR725n3ZfdNBCQplzj3horPC8ORoyY3dRODwHJtodrRE39UVOD8F
YM51y9lc1gqfnq7ff0aKBGc3ciIDhSzR8sTFMNYnAOzsWyLutZYY7OVVOyZE
goC6s/s9oi1R48/v3DY+Ety43PyiL98S32VEFOt3Awjv1DU1rbTE41vUp7oS
ADStrgpYzVvilJIKz70RAEG74J9pLVbobhXkUNZoAtEvn6tS2VnhmeU8Rasu
gJUHo6bi4la4+OBx8OejANSeNYXl45Z4eMt/n7APwEywqFolgxUePs1Xai0L
kMf7MocyxgqfmLAeu9Hx/9VbH/n/6rdpANL+dn7Y2mmFsy8upm+8JoKva36x
YrAVRuxVKK4NJYLYkba4whdW6DCjFUMgmMC1rHG3pgdW+PzH3Z3vhYyA1ap8
5uQZK/y1kSjYOmsE9ErJ+7Q0rVDH/Ihp07wRbHaV8L3ffu+dcmM5+6QREJ4K
kSVbrTDMOt7Hu8AIPE3jJa3VrPDRkb1Hf0Ua/d/+/TCCCLryywMqlujePBzk
cYwEfn6qL71ZLNHpKU3q+DcSfE9TOvj3nwV2fgr6wlJIgsl5da4IYUs0/+yi
XmlqCmrBuELYsEDLj7IZBnymkJ1pM5izAch/3kK7a9wQqMndtB79FvhKiSz9
o5MEmWGL57qeUoO3sAvTU28uKPpif+HgMQasc0pX7u6mBZ6oPTen8njB3cyp
6hJJDWJcG3e30LLj/Ke8XfsXNaBF/8pTvmwNsLa/8916TQ+/SrzUl+bShHXJ
4z5blHrI32/XMVSgCepL10uIInpod4bXpGdSA3po33GdPa+L6iwd6hd9NOBU
bF7q7Ve6eIf5rHOShAYwfHIUSrmohwK30n8ECwHMh3b/Mi0Sxzs7LcN6XupA
ppT80TfpxhhO43vDuGLb756lf57bc+L+yHaOr40qWD0aXlkYzgGyrx1EqPxU
IcDbun7lBAl/mCaNLjwigJ5bgLbcgDYeePpF3nDMEFIGYkqU+zSR2vHVrXU7
EvQsyjdYSomhm+vbDb49pmBjWWXTXCeAVKyXbR15SDDTXF84KimF6qLht2+2
i4OM3vtKWwlAB6NkuoBQK0xbOGhTuQug1K7v1LfnO0Bh164b8wGqoLYex031
SR00869PmYiRUO3ARG9qijHKeJhxk1oMoPJBlaDWJwAZw/1bMKuJ6Q8ehDpx
q8NDg+wGiykjpFO1HLNvF8crgWxMBaxqwN/6j2+iVwMg26y1ZJWI6++YThB0
iNh3LU85j8kYlrI+ysz2WyIaTwW90jeFoFOLVEGNBjirVFuQn6gPSWU0Mcnp
mvDVm0t0stYEicF7Y9nLJeF02Ne077NsEDd+wjy1hIB8h+6L8M/ow8ksOVPm
HACq/lx3g3w1jH8x/LuDioAhKxv5rKX6kMPcqjQ3/rUp/m04yLOrgMCTA9XT
fDz49uTRkeznWnBls+7wfT1FlKVdznS7KQz3TTm9mMtF8EnNF79INQ2IjaM6
Dwt8kDt6r3ZYnQ4GxsZ09/syIfHc0KGleCWouOMZozlpgpRJE5cm+w1gf/aO
YYZ/Jjgj0OfA7vqf9T+q+r/68JpyqswhdjJY62dft63hwdDTKXZDH0jwM/EN
o0CyDKrefPjefay/qYCfW+hGqxqEr4+xbbVur6tdOwIOzRtgQsiHAlF1c9R4
cvu6bhgJ+p3JbRZqphDLz+Sk1WqIcsWZPWxxZKASt5JbPi6ORmUF6ap5ZhBW
qROWy8uJmkrTPZb7tWH+UNy32H4jnBoycFH108DE3jvhhHsUkOnBOXJfWgK9
pOkqogQ0IfLk8eCWp8bw6/W5y6sUanikuaMuSsES19TKznMKmkF7kvfmqT0C
WC5wjct5ty4wdrG2ZgYR8IGC1dfOAH3QLJA67EnLjUO/AvfoaWoBX3mub6Sy
MdzqbDyW/lkd5a1FjonUG4KYaLI/xSstdBj9l8GwZAb1rlXJeI8dmxspXwWY
k+BJ6epmc580shHsSzmat+PuSwlB7+syaPfma/BbbzOovuz78X4cF7rb04/d
FzGDD/wU66sjHNhlx0Z7Ws4Id17aEC6f1QOli+5hxDYVfP3GU0zWUxySlWms
aX9KwcHyHUqlpRLg49FG8fqhFXLXMmyIeZJherPcyzhUE7WSrMKSiqigXJRf
+427BnKPUPDl7maAcfWeYEtGDSiQ0X2hGysFVHfnZhqmCPg76vTUWpQ+9P26
f3VLWQy57Tuzu4fV/xsP6eo4bJYYX86zQLz9x2JN7SEn9vGFFfS3aQFNm07R
fLoJsGff4UicUEGPnXtOVn0BCK0ooSbFamJcpEdhANEIKD8+VpvW1cE9l7vf
3vxsBqLX2e5e+smJ871eLwfEDLGJdsd9yi96MLR/r+3rURI0H4s+c+eDDm7V
+J0zLydCeUjVXsv7PDhgHxzoKGsCgv2hwgnCPFi+eHOo4YcJvLPemRTexIMi
cSrq1jZEUK8yXs04xItJ/MmrvyWM4FMuy2TxiBbadRjnqzcrgcfSaWsGJnHg
Hco6TsdqBi8ydL0KDUVRov+8kFceN/LoJ61Ip2kCzVyUDu8fMywJsC4e1zWB
18kzrN0jxnjtku3XlFt6wMJvkdfWTIcT8TEyxX/VgMGgZIZOiACMQQNXzUi8
qFd2dyHwkyp2DuRTqmvvAHt9aYJnH4BthbfozKgaXnTjnt3FIwtcD3/M3Kgj
IW9wmFp5qQWWNPz5e0XCAu7dPXfvoKMVAn1pzMHv5tCycPqiWKgxjnEw1BCT
9KCi4sNHcqspfJxwUGjONsQbhL8/6LbzZhtFQfydE1rYP/b4m+JnEkiWSrrc
OC+FfUN9j0qn1YGnLPAleRhwc0TQ5miOCczoT3C8NeFG2kONImmK27gs9bhd
e0wPju4x55UPMwba5I2/bMMaSLvnzNIfkRniNNMGw43uFSL1+4RedxYrpHS7
xUn10BTGX/J2xFJux9+dOfuf+KmiakDWnNrEFtFiIkCoNoADeDJto722+VJB
b3dbSYIZJF7RehwXQIKkOoPRbp//iTv/yecrJHgmI/JG44AV/nxkYJiQCvDi
zG/uN05fmw7MzWy6WzHBrmbBQ2JWVsg5nityZsAU0pI/R2msWSJ//omTg96m
EPN0+tfMgjrE3ghzSGM3waq0Q5N3NhTAYf/wwX+LwiB/RPQT41kNCBrxnjpx
CPD6tw5z8ioblE9rJWmay8L8A2GZ6gwrtI/mI/JMkqBq98gJ5kEm3E+Yc7Nh
ZQPGT6311ryAw2XkspA+PVhT5fpz9g4fDtSlLB4pVISbJe9VFpkBV5/SvKnZ
awDVWdJJdePKuCF4hbyWIwCNBRQaXjEGsPD7SAO9jyF6Ho+6l3TPDChlh5k+
XJbFu8E32G4smsJiJ9NgF6Uk2pYnqkWbWaBHkaKA6XaePRTGQytyFnDmjvCx
DCV9KPtkSmktRwK+j01j2ksG+HzGilk8lAV/qy68zFLjgJivvVphgqaQFTF3
RZBFBIVrn2c93UXEstFP903SDGDd1ljxj4YK9P/6zEHJZYpZg8ZjEkrbfMDC
59mXIU4QFUP//7pv1zn5S/YDJgLESWfSSMcbg7C9qkpgmDo+U85Iv2xHRjm/
8pq2G0Sw0nm4vHlFFaI2J17GqgF+6jC6UHhYA96Z2Sdn0pLQS2P9vOiqDuQU
HfVjiTRCLocbyeVxmtAinuoQ2wJoxdemGxcIED1NPen6VB0pZEtdFC3V4Uk/
q8/efYDyWfF/6rgA2U6eOkPDZQTjzk5P/fuU4WqML03NGyLaRTsVy7qrQfWd
Ez+qHACbOD4khplv8+g7lhKUXIao+c4ktug4QFgzy1gEEyfyxQv2mJ0ige8/
QffVADlUz5YtfBRFgm+fJE2e5Wth7/Op3RvxRPC0i1IeeaKKTUbcSjPD3HBT
z+fFxhUp4LnbmEO5G6Dv7jfLVx4aOBgz8mxPjyX6yMpLC4daQH316YEYLSOU
By7uAFZD+JJucGqJZaUp6fg+ldayf8TOhS+Vg692gO1sUbmsmBQ8dOOX5Azh
ghZu8rzbBWnQl63SGg9QwzfFBmH50/RQuuA43p1lgm+V+E779Wz74XNWLR/X
+6aSpI+9+UtKoNdP5cMgvdWkel01Sn/7eYtpOo9SwQBNMn/ID17QB/8bV8bO
lbJAC5NKv8dhNYgsSqz8nM2Ib/lm4n64ScPKyiF9iyoLVFujJISpm4HLNdbm
/rujTUupt82WPi0SI7gu5Nw15MAWHXLI7d1U0BDwaeLk6GBT2kn+bzzU1DDX
1tm3dI0Hr8srEE+9VYUhGhaizaAZJD8yL904wIMXOm5VL8WQQMDga/8pBx1U
Z9fLSGQgwce9pAAqFh20vL6UMSOpCQY3D1jNhQG+mmt9OVmpCLmbfN3bcggl
YgwbA6vUQIK+JOlLKuCRn8M3Dy5qwc9n/COfWUl4kHAmWOW4Dlx441r1pNME
4bqMEgWtMoyaVPU4fjJGzbnkiN8fepvcZ2ULWqkUQXQxNdolXgW6Kc/FifqT
8FzunaNvOyyRYM5REztlBksViUUC4tLQ+pNGrPQsCQt+8J9nXudH6w+vdV5f
1AJWIw7RmOfbOsZVFh4RdHAhwj5ZTcUE6LVPa4YkG+B5Kz49u2hNGIr300vf
5q8B+3Zyl6Ubw5p3Hp/jI3pU3EdzmaNZFS0I62f2PqaCrAEKx1tCvKBs9ubt
I0clkPUbyGB+aYFWi1wiKts8IsMqbl9xpzmKXpv+nmRJgl1216JZqfnQSUPP
ze6mFsx/vv1m0lULLl/h9n19iIjXzlsOlZvpwPXZBi+FAQIOiBW/pl8jwrKo
y7nTWxwYm19VvNeYBEHo2BNTr4W7kgICJq6qwyOlvYN9/bIwOxb568GsKXR3
CMSdLBttupb0OCU/FsBeR8NC/ZAq/iVY7jTe1sV803H7T6dqIxMbtV3k7m09
VWIQNJtiBqcdCxla5E3g+5XO416RrChWn3Q2hpEIF4K1XjnFs2O6kll+jIUZ
2AyUvB08Qo9RWrkLDblkCLR74lrfwY3vWT1U0xKUwD/TueqzLWBW0t3Ef2Wq
0DeUXOA7Bdhxv4mh004duJgJ56tFSTg31jk0LWoCO2R6rX6xqqOD2hFROl4y
vOQWW55SY8V2xXF/ZgczYP3Ze0W9hhpFi/aR606rwHeLiiqvM0T8nLZSJyKr
Ayu/HgRJhxmhiwvrF2tbEgj3HTiw0KaJW6brkV9zAVj6mK+UkrTxXq0kLRMQ
QCdV9YfqghbGv9qbvbPSGHhyDghGjqvjFWFDmeePzIDD09zw1h1e5O7nFhjp
JUFppUioNkEON1Kp8xYkSWDCYTR6PZgZnZNy1v/r3tVb4RfOyH0nooVmanas
hB70GwocEOEl4fiiZg+duxzUMARE0BIAL+oFPZD5xI7jllfdhBi1wZnbQn3d
SgrnwvWfD+boAqVJ66zxY26s2HP/gOELbaDJZs6SMiZgxJkk3UAmA3AO2bJx
NLLAa6Jxdju6zeDJj4AsdhIzhDsa6s7yaECJwCOajgv/Oa8m3AIiKsrGfuyx
QEfHENdnkWS4JzbQ/ZTMD4oj7xQTOFXhxnoH+VujDLR71fbZvRT/Tz3U/9xT
uBM6DidcGdnDCo9cvVvp76tDdZdXis2Z7fZGvj2eKSKDFrlhI6PHGB9bd/7U
dDGGS/s+MRsfBzy8RMVxXsQYjr877iOabYQXfXZHPdc3AG/usxnJNFZYHd9S
cDeQDBre96nruv/T34ZtXfHp3UrcR0N8HHs/On7SAPItMno6lCVhlnN/T0Em
MxxgH7uTKU1GjZEg1+BvJpB3ZLHDjI+EX3RfTlOxG8HyP5p85/MmeHWC4uOM
qBHc06OrrugxRcqcxQG6RmM4bSHdYrFkgax9q5pfF8hgYHZ9xjHSAnvT3MPJ
RWYwbPbvIdMdQLodRM3qHGPoSVVT/qhiibvZjFeGGslg6+Im4DVAxjOT9QKH
aACIfW9uSv+xRD8XvuB1QzLc/nPseL0g4N0TV/VfcRmDxN7NwzzNJFBpcWDy
8yPgnmZ+dcVPFrjk0MxhrUCGkxGaiXHFpjhcExInsYsItDdY051iLXGJctry
4m4yyHw9qZJxQQ6Yfha+0VUyxQWj+pR5R8DqW5RO8MQYlHtqHEdnLNAvjmLo
w6QZSIR6VilpmeDX65u71QVNoPDlWIwfhSVKpH0NMPUgQwSXp2dDrAVe+eDt
oupqBr0sP5N5B80xyZUDK1pMoebEtKfWewOQEpupPqZFwJq1bsHpi7JQdeJ6
U4GuKRYdkWFBIxI81Qpv/xuuh7HHdwVNEKUgm1k6wS6LhNFhU/tiqUggVO6H
r2sMsZfPcyWXwQofWcmZLw1v48/4nbTzojkOXqbc7+NuCsluBUoh0iaoknTl
sIYzAf58U4l2PAz4Qqzkp8c6Ae4JXTrxzMYUZq8eSjO3JaBz47zkbIQ+/GBT
iBHfnmc9J/3dPDlE9C8K+nxS2QReTJboHa8iogDnpiTvti68tMpM/W/dBP0P
tt8ZZzECW++M1oBRfdCoTd4r+NgEL4nK7hNKMYCm3cen8oYNcXqwXYdpD+CO
l91dEheNgBR2k5DuSsS3/HH0Ul+22388rZ1xlIytFBcqTt0GuNSb63BYzgL1
877TXpsmQdlSUYHLHyJ+FDFyd7ppAmXvut1cPhtjyvXWf1lNRBg8NxrtfQFw
ECwetiUaQV7k2WNqg2aoORM3bbkdV1idOaltDElYfPaxiASZACr5GrMmemSc
ca0aauoEyO7tHphqNccxo39c0p5mID24e37iuAJIlwifusdvitejq8M3Jg3B
Z1xKYnnYAGmyHjw8d44A1/XTpHbKE9BHST81ycAUnfZlHDlIYQxf3qATm7ES
qPKYZ1iOEvH9N2WNYHkF0FniXs+LBDzxUELo/EMLPN9Wnv3mriko7mjwsyQr
gn7Y/rLLpYBzmd+4g5xImPbo2dHMeCOI9LDghxIl2LToiXP6TcJPvq3pp2u2
cSGYwiysbwwsH+Y/dN3f5sfz/yrGLpoBg+HGAPkdoHPPcas3pw3BN5Et946X
FX5tnFFPHjOD/Q1BiW+drHDgn57Gcw1ziGAsffbisilGNTY+PBVgBP1OCbuQ
hYTiCqeYnD0NgXnAPSJ1BPA0v8GY5pwBMCiJZGcKkdBoh68P7Q8DqBSZO/ZE
GDDRPahffVgfvOR7mPds+yPFZu1znpUB+Ec1j5QiYC+rUFroWQOotXLXF+8C
tGO81enYpA/n1y0PSkcDegBFWM0OQ8g5rLOvucUMDy4odudeM4EpeuI500ID
3N/I6W503gDuV5Fb+46Z44FLb42kdgK8ce8rzbxhjopO5QIzGgBslXG3R+hJ
eKt8N9/WrD4cHRm4k567HX/cCS9zDxoC7S23o+y3SNgS7Fxq98QQ4uvUPlj4
kZDuskFV9aIhxDzkr17cYYKPlB+lyUYbQs/pd/TBfEbgGKEe0rnMjsd21fsN
FZCh1770AvkcG64SaHSe3pVC2qKY4iuoBeKG6gapmfNNHZ8KzSLIusBBcOzj
UKXAxs+MbvvzVP/v/1tmS6ivpPx3NdIKzXanPvupYAG1Juw+le81cS6fmX93
FA2w8TkOsk4YwXzF6/NHTnHhUPvngsk8QaDNaLtaqyYCAn/79xU9l8R65kPu
SvLa4H7qM92bbTwY3tSbcwglwwph0rslVwKzA9K5Skk6YLIq+MOBqIntlnNu
b2dpQZPzpcHBLwSYachImx1kxHsCsaOMNwlA0fJN8gzJGN+7Rw/7MZLgbbvu
3ix7DRxTaJbs0wGoH7YNu/VbHSsLPG8/ciXB2e3V92ldD3u6T986cdgIlBwK
X7l7s+KKb18mi5M8TCYOTNi5AAZcnJ46/EcdLD5ST65QG+G90910gdvx/Mvr
r4licQbY8NYCHOJksddEnCJ8QAtc3+fMnBySRi7pxtdBpVrAKzPAxvVUBhOX
RRZp87RgiCL+M4FCHvtUfa/N1WhDuiT9xUl3eZQ7ZaW+pakN3J+5xUbLZVEr
w+kib6U2iMXZLVq+lsX3x/b3J8boAsUdXTWX83J4NOmBP9t3XXjguGAXqCiH
SQcVCOZ1+uBIWFbo2m6/pZPrrt+gHgxZHliOYpTHc3MT2rl79YAYYFU+raGA
T0J+dfPd0IP7L2nINtcUUSi0qu/3Jz1w+dUfFKCvgFQ7O9ztE/XBKNV+7f1n
ecw5yBbXxaEPtjIhBcabcijisxV7wUsfJBLpjvrHyuOR+EqsPqMLC5vnPSoV
pPHK8X3ulunKIODU5P3CSxLfq9DrEu3lwFN793BetSwerojyXZXmhj2D0tfa
/eSw4Y3og4ERDogc06Y2+SeDabZVFwq1ucA+n3KkK18ejTgc6UaUOSGKcHAt
zFUOP+7pefuUjx2m+s/0T+cpYDufZNMLCw5wYj/z1VNMCalCG4ju6pwQLVmy
IsanhC9+MeweJfFA+rIU/S5zFaSxa8xM46UGrltiNp92KaFFzNUtBbX/nBfq
pYjc7TMTwLtEDKS+GclqrYi1Vt1Fb3dtEYvyzvZ1eijh1Ekbo9cK/6kHR5X/
/R97/kiZeJmLKuZ3dtxsPLxGDLATzUjMUEYr3Tz/0zSb/20vLv+/9nreZSwT
mXIY91Zj3IZvifgotNkgzVQUVehWyEllssBzUPTabQsxDNKoPMFJLwa3Dhym
EjeSxB9NfSwCiirQcNjpy7tOSWTMv3Tw5DcVuM6UDU8ZxLFrJYBBzksVrvMu
Pp6wE8Iy03G4s0Me2Bf8RJ45iWOke1iSkZ0ypAxfWNZuEMPQ0bbCRGsVMOXm
+hTnwIoE9d8WMtQyUJlkyLdK4sGFAtcKhu9K8NwrPnG+URjDbm95SF1UBkOz
u83yPfw4Pu/6BpqVIY3e+NqOH4K4GPKFJZSkArzs9xkPpQsiwZ8c+c5cGQLb
3y0ZjPGiV0r6R3NWdbit+5ow9U0Qr+7lU4w1UYPso2vktTgh5N5Na2AFqjC3
5eCwdIAfF9cDJB1tVeG7ulSVU6UI3rZvW/KSVIPPoqvB0jtFUT7QzvO8lSro
u74SLj4sjD9bmeXbv6nBY3++qA4UwLNtR4tf7lMH23ydfn9xcTRiOe/b0asG
4wwyOdIHxDBlK3nhpZga3O0eKtFXEsXFw+p2/ttxq8Fux36fchEsEv5RM1zJ
C5+lGP4etxTDnUOFfpm5/CC4miLvSxLHvIfuc48GWaH533GI1uFB+dcDymz7
GGF5QSdg/00+dOkuoj+bTAe0/bJhn9P4MJ2GbZ8Q+3/2L1Dw/y8eNoL3ZzDF
CaBN2slNmgUKaJDwpdE4xI1jUt7p69L/qd+jEPxfe9WoLnadFzzbebu3mvB0
B/RzJbAw7+bDgy2XI9cm14gFS9kVgS6CmNBu+5VHf/W/8UfBi/ZB+O1L4zzR
nECtuPWKC3NpPCeiYINYE/4l6kwNDwaOkQ+aZFLAvOXPqhtP+PHsfurPdKlL
xAxqSZ4r9zmQ9+AJi6QgSci+66/s95oN559aWZbvlgQ3OnkGagYutEwsML2g
KgVsYiH9DDe50d4umtgWIQmUwc1vLRW4cPKC6AGBDQko4tupkELHgVTF4cMp
j8WBktbgQv9eSvxcNCZSTiUIod/NtTVMqLAmnlB4MJsXdOzftQWm7cCBY+0Z
V0e4YcdYjbHJVyY0eRFduGDAC2etf99NLqFDWeZo+cPjnBAUvF9L2pcezdhq
9xi68cJxJbne25WsaH00rPTvXj7QHB3ZlwhiGDxw8V94IxUcGbSHRzUSeO51
vBfjdWrovRVdt6tLAlM/fnXT/80Acwpv6xUlJPHbsUPyOqU7wKLmYaX4sDi+
5oqc7FzfARo/xnRlO8UxaPpIzHNdJrClodnaVKPBG523qMtMpSGG6bIV03l6
3Nr5ISmKJAOH5jvUZnmY8UxsQGjGSwn4IN0fm0n3gyixeHkXmysX/Cgc1PDO
miNCUqbrhzg2mNXlO0cYXSaK3Lx463OLEJDyZsmPq9lx6FzqL6YVdsh7Rs3N
k8SCYUNXs26rcsGxenFfk2FKpCDJ2d07ygg0P2fcixP+NT2B5RMxHOyglt/C
ON5Mgzmc0+JXHeRB74T77nizRaIs1+peUoosXHBQza7O2SCO2tV5DKbLAENJ
5EvLLgo4XrA7/fqgNKR3mahL5/xpYko7GmWepwBpRtLnWlxoIfZNbf8FVzlw
mh119ZOlhs5+rqA8fTXINzg3Ir1FD04fM8TUopQh8+hxta9iLBCEOQ8YfimA
Ra7hGY4fHDBx1/+46hk5UKzlcXvIzQGFIalqv//JwxG3DK1jBuzQud7YpvhM
AZhTop+HT7NA7d2ax7u/yEMMs8aJvdJM8PjHuVsDV+RAyCe//zoNO/wp6f2R
0aoE3nLy2vH7+CHGJzmybzv+XbVtkBUx44a9CW6//9Qpwe6N5w8uiHPCwX81
z9yOKgHfH72tCRluYFUQjKCYVgDzRaF/3/K5ICSwuW1oQBFSv3IlP9ThhNRo
64afCSpw2ctvOqOEA+Z4XaMPRyjD0wNaFVL67NDcLuu4oacCVIPf3Ro/scLE
VACtjoI6JDIF54q6ssPJmjneyk5VkJp82NmTZ4mx6VzZFREkWPWfveCXZYV0
zcGDEjIkyMivqrAWtMIuNZf6ggcAQk9mfgaUWeGPxqbnTt+IINvr981n9D96
+i4Rgnim+Kde/+dZF4DEHi6gcNcKHcTyPPiyAa5P1dgkN//nvbUx/DV45h1A
Z4HKFjkizm4kmCJS1ekkMWGLr+7HyTuaUJxzXoXNlxaF+nzFRiU0oS3x4GDO
JWbse0Sqm/OggWjPtnV3CTqsvBfsbrbNd068H7RflQDw2jiY2aIkjQceLpSJ
bBGASlC9mbJeGR3uUVuLMRpApM3WQY9jetj2o+VV8CmA+fsL38qyRJDmh+no
6gdTEM4tdbjHS8CbvBqBpG8EGLCvdIgL1ccXTQddG+8Y456pdyaW+oawx5bm
074cS3wjapTmLGcG+wrpD5npGUFngv3kYRElfOr5+vABNWPop5c2SSnSx/Qj
uk65HKYgVTpRGNxnhOHJ4qMxqWQcNlrTCeMFEFVxql1aV4DLAtrmXXREnLb+
Xqzzd7u/+vs33jAaoyrVMrkkQxXKZyLazyobof2gvFythjyaSH8WYPMV+7/8
WdoMDH2eyUacJsDp3sYd7ZX0WKs+y/npnRVmSIsfS0kngwX9nL/KiCXeubDl
kHbBDDxDDjwe/SkHlFnCO2tUROHyPpIs+zbPZ8nja7/4SAdPhBz7PrwiBCk/
lRyvtYoD76FJpc+Jk00SXWQTKm5VaHk8lnjSnQwOJ3OZ+wPFUImpmOeutilw
Fo9KrFUZ4HW1r0b/te+hkL2C67EfJYz91HeQessF8dEKj8pfKsPw26Dwb26W
aDriy3d72AyUDt+aqrtnhSt9Zlcfr5jC30W/S7ab6lB5YU1v+JYJquraHvaz
5gH/nlyNqXIZqKd69SPnohXS61nT/0gwhdiJ+Gt2FbNNZhOd+tRGWjAtm33n
qD0FVGuxOIUo8UPyBjOt4mMhzFPzv8n1SwNMFelcBY/TYqq7pq/aY2ZoL465
eS2CCwuuUWeKZTCBh86eJPpCZmzQM7VO5tOCB+su5YLr9LjLM4u/RVMLtmIC
wngrKDEig/z2wFMFqL0k1f9QnBnny3gGyt+rAPfI24vx3dzgy2EdLOOjBq25
LFulj3uIYSdSFmhaKOCxXfvPym4rTGHWS5dPMwVXt7+zzTFEZH3IpLtlRYRZ
QWPY+YOIa6M83tZKRNAyP1h71IEAV0n9WBNmgvddb+VWr/FA6guq4OhcSXAI
9BKb7afDI1WC54+gJhzJa30Q0MaJ+8zb7rVVqYLwayX15d2WGK04M+TPY/4f
/AjD/+T7HbRbFDLeAEZryeqf5wxxsKYi+LafPPRMLb6+kWyMXR9LKlv5tpqy
b5/p3bVCC1Z1H/Ilkrb1f6BtRvWu/znX5X/v/URJl4ktkvlyk19RkYPmcU24
4T/trvINMLbQ5N4xC2OoWagVo9WQh6IYrxj5byZ4ZvASvV8RAJlx2S3EQAK9
3Z0DL3Ro4Oz6qav1r6jhcv2owtkAAhh/V2oVzVFD2/x6T84H+vCRKsjf1tAI
hw+JEs+tc0GUj3L9/EcVqJ0RL8n9LQ9ad5Q1dR1N8eGH7uB3j1Vgfjm54bSP
EYZYHUpsuKEGGtNU8rZHjfCBjhf9nb8a8OpkQdisIwFfXMpzl05Sg3/7C+PD
fhqjG8vQXOoSB+Z/mAydspCDK8FBt47M6UDmilM/tY4JXmTYuHNbkhqN1Fdx
lzMVvH5oLm0TxQXz3eQuYrsqVN8ku466kNDxafjs8H0C/Lsc2IUFVjicohN7
0swMasKmNIaKtuNz20BVFIM5uOZ0TWmVWeJ1t9sj6UfMwPdYdbfTGUvcSd8m
rHbRDC7lf2wameAAattq1qfeqmAX1bHeb0kGE+2Qfaf6BJBjI0DR+SoB4qIf
wMFDAhhSmsP66pwOsHreyeaNMMBfPa8OqxbJg/pfGXrnXmkgfJg+PHpCElge
lh2LPUpEhsDzN7YeicMR6++LXamAQj1PdOznVSHW9tmqUicBpx/KDWxu63oJ
v47yMgZD9OxML0lIUYdBkxB4ss8I3+QfsI5VN8V7pFdzj/kM4dLqqmkIURhq
Kg2/LJUBDut/bU6llIJEo0vORYwkDFpc/Cssrgo75127bfKNkcb0qGHFIx2I
dggyTV43xPbkZxmjGwRols5jMvmrh2+LKzulpEzh4/3iELYcAhYq1dX0nDCB
gY+3hSizZPHx3dGHYKoKRF/mn8qNJkifNv/MOJcDXvjQvhPa5ueGAd3KJ9o5
gZW/5MyOvQow51V8mvbBAjF3hdLTqpYJgs1u5F1+td1PAVJArA0BSryi1T2f
E8Dr4CU7//NaKO9ZmhZPZwavovqnLtFJY8lP/7snY4TAQUYr4XaxAizkP+dL
oDKCjeX8Lh4rHiwuNA/qDtaEM1fmzAx2EVF37EergbsVrlWKHbViJAFt/Et3
IRsqDL6ws8K+lwVCNrT6opis8LMqnXwWuykov9DR9tjGq1zyWQmGFCLe4fNw
+X7CEn2iaMZN/mznGeufAynKrDjz3Pntl0EpkOteMFy3M4Y/U3JURVVaqBh1
qql2WADEQpcHvR/Kw2vr1f7OP+rgrFLWr1C3HXeSeQdehGyvPwm5O66bGlgw
PzvyaNoYKBdmig/T8CEtSUlr/y0DOLzy+o3zUQMMOUex93SyKdTs7vLCdLZt
nXTp7hUGU/g+rinHSsmOvY+6RIdEyXCjYZJf8j4D7k2bzYn3NgHLU2+lfpIE
8VO8SYVevSmYsN+Tql/jwn/FL8YGO5RQtCNdJMibF6TKjl05EKcB/nQXO+oz
iXhEtUpfIMoAdoEwVWw0AdNKps2P5ZhCbW39W6czohjW3FuqMKeIxcJ3N1uf
0kLqzW8J42r0uNv9peqJdFYYO3AswrgFgL6a53HvaQKKHtRNkHlsiak6Upv9
/SQozfDY37Wt12NV5q7+NdEHK4mswdJ/prAxtG+h/TIvHjBeu1CuxozPaM4s
sAUygvFb0cbAvQA7ak/RyPOLo10VR9ezAGWMay0WkeXk+b/5uQNAO2jiO1cK
AI9lchSDiBQGFrAum2eZQoPkSfvwA4JYHvr5i+uUHkQq70w41GyIxcpyKWL/
TEDntBL/vhpZnOyZ8tvvpQUtwdZqcYnG6GzVu/cwBwkM6UZehQwIob7MQ1ZN
VxV4zZz25K62CSYNqIs4/bTAzt0PdG4VmoHP096FqGESBLdYus2K8aHRy/LB
6TJVoN/JZRxEJCIb61qG5HcCcEn2p3ANqeGJp1bTG58MIH/kbufNBGO8enQ/
7cR2Hjy2b+3UVDsRKfNv0B531gBwOjHAamyCsjfa3VaNNIGL4QIVmzSggG85
9av96rCH6Jahl0TECXmX+KsrGrDYSbwQGUTE9IrAKoP9GlD6j938LB+gS4Kh
eM6oGmTEh09qF5qgwlxQ6ryjMXJ8lBb4d1Yf+kvvNxOzNaDnmKTn0RAS3hru
5jD2MgdHd8oAYzdR/CHc13rWhoyNXqUkUVUiHHh8+50uQRnfGCXwKvL9J88F
q2GH2H4m59AlIpnDj2ZRRxzNRMKyf13RgPM/DRMVB0XR94+1nLy8FtjW3Xtb
V/+PSGXO8bt1Wy+ZRxWofBcUxbO8Quds3mqAw8XJwngjZjjPbfRa+ooECHiG
CwjmUUGgSv5JoWVuqFteIzVdlIQLf7P3WHPKQyjxA0+jgwBcP19W3mIjCS84
pX/cfscHdLTXPMmJMvCx+pfNGfVxYthn3kcqp9Ug0GF/Ipu9GVweivoTqMaB
+8Lz515/s0DRaZ1rG8VksA+pThnSIG3HL/ZH37O10TnlF335B23wWT+2QR9t
iLW7XoQo8GrBMJfojR2egDv1GVUKPm3rFKXyVxHxgMuEf3I70nXg7B+vd1r6
Rsh5bMebXl+AnX4LZ12S9LFC7xeH/Q0irH3hNJvdzY6cDyzKbTNJ4H+g3jVJ
Uxab+ljcEzlJcNT5coQzjzZ6NF7niOMBoH6YkvOcjR1bPs1xjbwCePg5OcuN
WRtdDxu0viMR4ZzF1/q2s2p4sMfGM5HCEBbqX9y3iTLEIy+eclH9MIa7oY+t
/2vfZ2Sfv/PJU2bw4mpuvMBHXtw6lDjkk60Gvrf6B5d3kfAp5VAX1U4T/Bmq
UDr70ghkbfOUNFc0IYL0kfM7AwntLXquhmUSoe98vNu3YhX893iB832LORp0
X/RZETUDrmCNNTNBgM9tb+rGndXx9EUm9o+1XHBh0jMNv0gCfR31W/tyWtxL
nCxJO6AMJ8cv9QRu6wRpGQN62zADyO6iKw7Z5tFHduer7Z3fgUVUSsVXIqyQ
zE0roxZiDk2RmZJraiqgoxvUFC0A+Fo9wzDs5nSTvfjpDqV9SpAQV/Hd6wMX
HNnw2fK+pAGWHOXnTaLMoK7NSGN1ixGdOLiyKz8SkPeFsuW7UD14c9JYms2d
gH+lLF6NuepBylun+49cOOFyfPEoj5oGmJSJL4+bM2D7oJh+j7EyEC8N+42x
SaDbyOC13gcacE028sCTODLqfJfaUU5NhKozzzYPZRsid1VtsVyrHgiJBe5r
EV9oGu3KfrXr2A7453/2wYmP3FiRX7ek5aINWRz1iYERgrj8d+fbk5c1IOLa
+M83vbz46RfTp1+PtOEew8XzV2WoYcKfPMZ4iQM+ehKZaRMl0EbMq3NXpiZs
VKlJ3szSQGs5Ktv76cIAGUPzVe6S6Mn2RlaOSguuEOJtEpANL/doTfzy0YIX
9sIh7EH8uEuH50WanQa87QzNMvtogo8/OG30EvWgnarn4al3FJhW9bOdlWJb
P65mGERREHB55QiL8LoeqH20Oqkdvv0dhVJmwZsywBlvPUebZYkVVy5r2r4w
A/5sPoVgGXEUmpKodufWBI5oKUP7R3z4fvxwGqORDnyXdxMXbTTHu3qkwfQ5
M5DQdq8LeLZOfG7paAPpAnBJlfP3XBglNDxbohPO4gU6Z46UCUFNVKX8sKtD
ZYPImWGf5MYwTcxeeUZaqdOGW9e+jKZR9zRRXLh52my/Kvzrx85/64LwPTff
KFpaCi4Kyzv19ajj+PESHYEyHqg0+hm23EuFrerVH5QrlYDDrShvX5cEZjf4
Dp0L0gLGQEvtfRysIKjswTI0xQVc2QedgozEIRJ78jkHFcDg45cXhz2F4Us1
LT/nYREYbJObkwsSh91ot2tiUA5uMAZpFrqKwhf2UoFdBAWwfffxh721IEgp
fvT+5C0Oh0KT7+7TEoFd5zQe9HdKgSzvFpPcLQlYZndQ9nolDzs0tawlv4kC
sdbiatWiHGjQ+1zyub3SVPdDZPF7PDWkCn85YFjOD3LjFQ9MvWVh1IJEzK0W
hMqgb1NiHrKw5mX2Zc3jZ9MRYf9odz5a2IofDv7xjBdO/Rb1k5rcno9MSn9h
XQHQcLdO6iJLQJmbr/DfZVGoK2Yftv0jDZ22tsv7eUTh6jfOohAlOVBeSQ3d
FyoOtrpNjmrv5cGvczRqlkMITvozZ5cGScNrSv3vQtf5gbIpZTTonDSsDODT
P8S/TZlGlZePZTLA7KPRsiQ5CXy7AkGlTFrQSmFXfvKFKNCX1PXa7JeFRqZb
zImF27C9Kpasz6qFDw4wCuvLaEAlyWjjjiMJ91WLfdmrZIVbF7OkGU3IsCK9
KEfoEkWH2Dr+3qOa8Lbs1nLJHD1mPOqKLPqiCLpPVnyP2ApBSU64j9tzOfhd
/daUUYodC3nDWb8waUBtibYqfSAtntUV1Hn+VRFEuRO/sxr8IPqzuNxPblYG
XTctW9MT4nhvmpbmx01NIDmPURo1U6DV5wLL3u32BWYmGrPchKFQXvFp+PL2
/OcEsHs9uUUMPFo3tMSuAsOjNQJRx4UhMpx7lbtYAgzr+pvu0r8gEo4wbqqt
qABz9IpqkpAQ6HxTPkIASZiUZ/nFdVsC/HruOF3okwNueaZ1nb3SoMVl96Gu
Rhb2z0pkJTNLQERrbc4YuxxsKA0+PNMvhE5NI5QC99UhqPt++K0BOrj09MD5
3nIJSLyT/1FGhBaoGnrcN1vEIY2T9kV1DTe8+HO6rvWAKFSmPf8uReYDAefM
6QY2cfDzMntJyc8LQ0enZuWV1WGR4nhvzXaebY59/tyWUhMmb8RGTPhyw0Hd
gJzL2/NXEfPMYaWWG9qOEcJjU9UhXrbNQOUJB7z2sep//0gdfuz+ranxTQjG
//7W8XqiCg9sbdh+e1jhpfEkGg4PM/BeG6yIeGiFGjZFbxb+mIHgkpp91T2A
sxQl7yoTDFB8+RIr6RdA0k+zUHo/WYx5FWMW9NoYdodR1wYscuFjjdwDn1cB
Vi36EsIn1dE+defXlTZ9YDDfDCt1Bbz7Mp/IPmuAC2bCIrO/DGDCoM//mLsl
+otU7ajnIUN2lF/MdTCCZbfRP5VjvHil/5ndZqUx5h1296z7aAKjXv9y7EqV
QSpmREbroDScLvr2Yee0PAi+O6bivY8TTBczwv46KUL3SftWvbvy8L7Ve2qG
VwH6D8K8fY0kPFle2Gd83wybvcoLRXhMYCV7z+3iL+pgMAo+ScESwKR5MThB
kB80Ls20l02oAg9TsF1+kTLYv1bVDeSVhSKP+w5Nr1ebThzP3rzarAbe9nTi
vGsacGYTWSqlpWErV/Nc4xobNmQO+tSyqcPe0SMiF32E4Gi4jJgzFzXEldwb
T9qSgVkaf3d5MxGw6o3qX2hRhCengkOdKmShJaiC3bdDECjFFFa9dyjDqP+p
opkuS+zkvvSB0dgc6jQ3DE/dNUHGZ/MczZEAaff05UUCeIG5s7V1cI8qXJui
4yw5ZYW/6XUk1+6QQSMh4kTSK0u8D3YXNwrJkJO1ml19eLNp5NvYtZ1P1KFb
7iTd9C8VKJBLFRB+LQG07ffLM7b5K837+l1yojIgOhwt9HX/alMCwwof37QG
OHuoUItHzDZ9+0YO1BLThg9hj486msmCjznV9Y1GMRDTTnvOIkeAA3r7JJ0v
8uNcqsB4+A0RXFP0NV3T0gGJkHsKJmKScJWC7xO1Bw1IMHIZ/6GVB9rvumn/
1qWAOaVcOaFBHRSTi5Uc3aRB4t9iTs1veTDTrt/J7CQGvvKZxA/7NIDipHll
5C1JiKn66Vl5UQOCSphubV6SArJRJAdDFhnlrIrFHalJ0LZO9X2hbaVphu5c
7vgNZTCmOHV1RUwRUmUtngrXSoB1jWtRo44VXn4deyWjhAzBpxlu98hY4Bnr
vhAfajJsUA1wvOswR9fIOkjmMIWE9kCtYV8jpHHJvkAzYAivdjyzlPADjPS6
F6u/Pe4bMl0C7CFmeHJe7mJZvTFURs4dafCVggq6pyfeGpui+6qVW8BnMjpO
p6cX25pCQNyrnyt+5vgnqTwmo5AEzTK0G68LzPEJw5hl+3/ViV7UHmw0MUf9
0n9e1B0koHnjfWM+0RzNdxdLDS2QwLutgjY3l4zWnXahdndM4fDeDtnXO8yR
udyGcg5JoD30KrAh2xz3+IUfImqbgtsVw+eaxubIFrrA0B1uCjRxPd2b82Ts
nGnf2UhnCnkvS4RZkBE3yYEv7S3UIWBiQ0v9PTM+2evaxfhMDdrUrUkqgvIQ
ZfWrId5REkSKK7g7E3jgUpVHj+cjWmiwBPkzFOrQwKuc4xkjBb5nbj/LuGOK
PUvGyxdDjMHl6LoXOWGliey4ajIspAN11yWSIz3VYWqot21uQgIMjkg8CGkw
A7WHftcvCEtgbYOHTR2NPJxk+/Pnq7kE5F7WYa1iUwXH92H2tLel4DnvTVHz
aHN88/6O+tPjplBRYXiJYtwUIyKfewu5GG/nsXoW+mAqPJSZocNbrw7TnDGe
mXWK8LO9IOzMfXE406gzOZMFcPG4l8FQoSGy29+icuYwg/zpV5vP/AionTZF
I5IhBHQ1sgZ9oALXfn85fumdIkxy81SE18tB6hDP6rtJMi7uYK6NOk6CKztf
sa0u60HDNcZHloqANZW0dJGoCDXJm1cuOMtAh2fl45kpAl6du0hhl20CR6JP
+gdYGgL37rMHJbZ59gtqznwqa2O4UtVwy1uYE0nRUTXPjm3zfIefpIATnJj/
r8Hu7LAwiKX8EfUOBhz+06Dbsc2nUhQi9knHAT5vrh1cfyEApp9j5mPfAB6K
UrIJ0eMH+Wirq59LAEmB/ppun/nh9yvKWgGmbb3gvyuumVkOAm0Ocv30MMEE
o+PGx4/LAcWh0U1lb2PMyJsj9RXIQZ97nJTqlDEyFOmfXtaXB8n6QJvlP0YY
Vs+Rd8VXAbIuxS9oRRljUWTnna4CZRi096vUcTZCsQP6v8fuK0GKjHPZ5DUj
DPl1zImYv83H8kHhdycRFRvEX6amiwGNxYxopzjg5C23pSuWspC7dym/zh+w
IcPLt8NeHKz0l8ksewGRpj1caEYUXLRCWH0rAEWaBF3YT4rAHSCg8LY+Kr2z
w/PwFSEw1Gv5s397fKdC31w4Pi0OR0hRVVVsJFSVP/xE9Y0grPJv/a3wJGEJ
hwxjL4MonKqSqVTaAOQrvnzt4zafUtz8V57QDfjL7tejmgcS0HBQ6fxwD6CU
LfWkoL4gqDN0V5kpk5BvZIDiOa8AWDoM10yHkvDKLN9UthwvXL7cPqN7j4Sj
xi3szxrE4CSfKp25JgnH1mo/Fq1IwNQn8+AEDhI+OayfxO8rAckH9mNcPgmN
6hYjg+5IQtnSM02eI9v+yUjINwmQALfR2pribb5FQbCuQA9xSDYd+WZ+ioT3
KRUP7mySBEuV0zFX2gFZbR2tI3qlQZ8S4u22/Z/iRf04pVcKDsSAUkoI4G1l
L8337VIw+PNw47VhwBja/l+za5KQU4smEtqAQrzzEa9bpaF7/r3KkDUJ537q
UrzY5o3ye1V/cm3P59zLS+zrCbLALOyeXc5KQgG3r5su2zq+/a5tpcs6oNK7
e53FB2TBbX5UPOg54AXTV86728VgtOt0S/Xath4sanlK3i8Kz+JW5FPBFDO/
8JQXTksCTRC3HDkQ8ODV4ICO19Lw6pnln9IdgOQB9xM2RCnYSc7zD39PxPjR
sJ23R6SA/lxYOK0QoHSq65UIxW37WpLri0dEPK55PX1CUAGOmnmMfN/2n5NP
PN+1OBkIDO/ZnM8BfDPmWDmvIgPPvnepF+wBbNn/MnkvqzjMp1KSX46RULbL
7t5GvxwUlPLM7LsE6H7a1/SgszTMFT3cMWoJqDkyNX4yURxYh8K5Wx+TMFz5
XQXDrCw8DLqaTZ0JeNO/LXw5SQ44Ehat/T4DTs/T5Wps85D6o5capmJJaOCw
b1+UuTwUfrhsw94EGCi8Rcx5LQcZglqpYrokfNN0MOSenyx8zj2QEH+ehEJu
9q5zqgrwwSLvWLciCd1YPhnqJciB/sfjk7QxJFQJ5FuoOCEHp7smS+8dM0XV
KPbiR3Ty8MaDJZVmgYQ2eyjvnGOVB9G7vmoslSTM+/GPSmRQFr5N8/27t5uE
g1TBh6g7ZeDDF5cHIkDC6ydPk5cOycNesvFKAsX2+LSGTYs7lKDC5vfr2Nsk
7OKrO9bWoQhmVHZ+88uAaezyxwOsFOGpsdPxtQgSHrnlcmo9SwGKKU/tEX1P
wlgTyYtPerd11gPbguPb+FiSbbHmdt+2z1GeTdXZxlO67Kz9byWgVzhKeGBM
wj96D1Vun1AAQZ9+x3RvElZeiciQDzWAW/2uMW84AD0GvpGUHQgwyHDbuKXC
CBtTavLsGgngfa1F82MjAf06V2/LBBCA8XNcUIeSEd7qV5Hs3DSEplA+I5Fz
BPT0+gkD3YYQN5PyT+X/cfXl4VRFX/+GyDzP8zzPXMM13HVHQ0UpaZAUKWUe
SshUxogylKRQyZAMEQp3C6XQYA6VmYSIEOF33+f9vr/ned+/7rOfc/Y5e629
1uezPufsu0+3GaKuJZ8fyMNC52md7A/IHLnmUN/uHTAFBXeJNQKt7hSbX2YT
ddSDOmEO8Q1FU3R1/9ZqSrUu5L45Xy28jkXFC2cTrRx1YUP76MzZl6Zo14lK
CdUmHfCNu0u8tWmG7r6/cfyeqw5gDWUFjLHmKP5PEMf7UV2wkJTjIkiao462
gJKbRF2oykDsw4FmyGRsQVN/ry7wPJr3vWdijvZC4O/QCl1QFtxtqFtjjpTG
DdquxurCLrbUmbAeM/SRpX5+WF8PjIc7h8qOmCGWhMkccokedLjsx3/DmqF4
jBXV+6MuWOWU6aRoWKC5vLQLgvF6wG1sOHZBzgIFEb2nZq31oOuQx0zILXOE
9niyGGXoAUHwwZ3ru81Rjv4D1mU9PUABDtl17Wbo79Ll6oOyOmBV6CqlgLFA
FBLXTstVfZCzuJmVM2iBNspfmLMn6UHlsm47Uw8OcSTU9br4aYLHhqZ6mTWN
T36Wa0tp6wNnqOddwxeAJr0/n33SrgcXNdJFB1IBiVScSl0N1oezVfVBpYuA
jPxq0xlpwKR+Tze+lpZfW4OZV3Qq9eHlur1NTTWgw1FLYj6P9EH3F5NwEA0/
rlKb1sZvGsB+oTwd5yEc0gnIy5dM1AfHVZYIkiSg0+cw/xwNDWAPVpZJHwso
5LT91a53+mBYVnbdOQGHJB8PiXW0Y+BneOO72AhAryZ+HhzmNYAsyvfJp6s4
xHgQd+MzNwZmxcbq9tLw4ErFfqufhQYwEeZzIUYFkESo0reyuwagGfCu5YM3
oIc2yy93f8UAR2P4/NqoKXq6nurhMIcB5nw30fgqC9QtKBnwccgAdHrPOpy7
Z4HkMnb6+3EGEDqac2z5nwUyVgKuZ8sGoGXJqPvPGod+jNPJDhYbQOUen183
Ny0Q09DAg20cBmLo7iVMTuEQv+roL54SDBSYpqUa6gBSTTrw+IWSEQQFHulx
pU2jGjuxO3kcA/K5txRevsah+hV/mfPnDCHEYnyOifJfn4VedLHMpY1vjtky
bi8OaYcf2Pe13BC+7bKQTarHoUaXk7tExQzhnLBRVo4wILdIe/seK0Pg9bI9
0H6T5u/3+vdxdhZwsAr7bTeXLprfOnkqfs4cIm+8emhvpYsqFJ0zDyRZAHXi
yx36AF208hRf0R1iDrbTjiX7E7HoSfpgynMhc6Bzd+q1xWIR+yenvTJfzIFH
cwNbY2KCMo6/+OylYAG7pNWzI2SwaODeLqXHjDg4loZJ5X6FRV+UNKwmK2m6
rlnTZGPYBHGmTofkXLGApMz3uqo3sGj/RYFMCLAAmYVvkrevmyKTMJtSvRwL
WPv3iu4Ulyny9irroXfBgdxXwkVyhikq4JhvVefDAT4Am5aKMUWf2PdjmL/h
IMkuNNvyOxblyD8PnO+zAIyo7NVcLRNUGJn1GSuOA98ArsBmAyzK5SOGfg7F
QUO4Fttvmn124wsdk/QA9V7E1d92WHT/eMHQKB2ApGdlr95tEyQqatFAl4UD
6WtMNQwCWLRXsOHtAAkHmUWFbQZkE9SxcVCt75cFTDaOkWUyjdFNnV/GA/4W
cMazsm77ozFaOpn7Rc0dDyEf6f1XdwzRuN75FCc1PPzxeV7MMYVBps2a+fms
eHh43JjN/SoG6XlozhzKA2jFJXgnxOmir72BX/NlAMht7peOuaihQJMaWe5p
HLzFC7eGuKgjs/W2+Mo4AA/yuwuRfqoozKOurPUYwLsDhIbfr1TQ9aWv8h57
ACJbZw1Dnqoivj2qXla6AKelM7dOOGkgR4W/KeEcADvJ5g6FtproVdTKFWIt
wL6PGZFSNlrIf5trK+McQKXlFZnkeE3EZf/PrUgdQOqunfHxUHX0WslNbTkS
IPcR42G5oxroCNajwqTaAjyvRQQmTWqjNws3VNd58GDe3fRaTEIZHRJz+Uax
oekmJWIqv7sSMqV7UXBSDw+qctYV3HmKqP7lseamIjw45x6QwuzIIz3Xk2X+
hwCefn6Q/zOJCw3faT+TaG0OMZsQevcIN8qRcyv/QNMVW1ZNr/0SBVDXiEJf
VoI5fDN/2WmrJoQaOVgOVJAJYFhRsH8pWwktZrgcTlAgAW4kB/euXhplK3zx
Z/wFQLf9evK7gRvuu4J+vvYcES53lc5vJwqjnme3Nf5eJoEIxs+xO1sMFWId
qs2sSSBffvOBMb8Ial0jKKhLk8BKS1WHk0UcGUS8PfHIjgTufJgLSUEC6E2e
tVqNJwk6/toFlNoLIUGbzxbdwyQ4TH+KvlRRBPVyo7vVT0lAR9ejo/9aCNk3
38rtuEeC6gnD3+ofRJDk7Zp4fyEyVIc/OepULoAOXBrTujVAAkz0op8ZRRCp
MB0m8PWS4I5oT4mTFy9K2DanE3hDgtLVuw7ZJ/hRy0ZGECaUBFHbnEVGb3jR
iFKvmtQBEli45ZXuFK5RzXRPLn7kJMKMZ+rEK+1fVOlv8X+yPhDA4uEHrtyJ
eSqPG4+ZazkJTfa2NS/JE0B+h3Tf6zQFqf4evD5FT9O3hIjnif0ktGEgeYOR
Ew+H/0qwL3GTkXO29x8hDB7GCecDzx4how8YRsV7ZgR4JZ78GydFQTNW1ONq
mgSwKT/8sdqIhEY04yiHOwkQnCTVN3bJDFH8rTdbck0hb1bhy9RHEjr65+VP
0gAeNp5QL459pen/83oS/Il4WP5a+nW7goRarxFJU10AnVovd+vS9PQzU1UV
ViYCKBuZ/opLskCL1yvUzpy2gA9eJhttYzhkfvzOnph0Uyg8NMpiomkMy7Ny
lok0vsl9wmombmMCW9lNmYdp9WuQcIWM/StLFLn31YbEIRIo4F5zr7dqQ13M
Y9e95+XAvFiZ6BGjA22xB58eOikPYubloe3vtWDfW9azsgRZUPj6IvlhuRIg
O7OGezOyEDZx4qcUHRmdLHRxWL5KgKU8/HxbgRWy2rDzW2qgAK4z+6XKFxV4
lAkcjyx44L5A9TGXoyRk+PdQ9LUCC2jju6Ws+UINyjSjFl9T8chhx/3x7/tY
mJNLJtXtNkGeara7Y5vUYYPjQPmnbZoe+zGyZOOmBoPkPTENxgS0mcLnPC1s
grib93f33zeBoCLhyy/8KIivMlvSQYsEv/PQZcav/1kv94wMz8LVxsRy1aE+
+87aXnklOL3DEOLMowmP0y3OijJJQut1pe9nKzRhtsL/lWu2AlCvXI/9GCYK
+Eejx34x7YKgjWT/c71E9OsANdbACQfTrib9nM8B0SlYdSwamoE8WCX0mBOR
N2bAr+enGVzF9Jc9OGSFwrEP2+oKyMA2l7Iwr26JmL1J/cwtBHCxg+S4ECya
Oijml7ZhDNpGrg/yVLEo3R0fQiwxhlLF1pcnivHoW/Pd6c6jplCya2y/fwqt
7ncTuH/nkils+I7v6VS2RNY9nmqljUQoGnAezzVXBy/WkQZJWQIyC/y5+uyr
EpQ9dOEbyMShgNlpj3e0OnaXhaqy7wksvOE+ZkoIoKA6mXv39g4RgSScM1mz
pQ30YcwXoQOP0pZarbVaVSBTZZLXMsQCrcoE2GXnU9D7KLGCZx4EWOR7yXxo
QQU+UJYoDWKAxge/ph5MMYMj5z4T9E3YkIjtpJESWQ3W3bgeCv/BIRPZJ0ud
DTR+unTqYNWaLrq5NtlfyKgKxj8DuV9tmaMPrIwjw9p4FHC6a6Flnzlspt3/
rkLDS5dnS1Mp50xQ1kRuhJeIPsStKNCZn7FAzhUsuQLHyOi7jK0Q70MAje1T
BwqeGgPnzY+6qbI4RN3mHDfbwYNdqdvblTZj1K3enHNuEo8y2fiLtoNMofYj
Z/ZgpQkq7Q+Ja+M2BqOruhYX0nXQ3G7pzO0kMUhMN1fAmekgyvTht9N9gnCB
lNqQ4ayDxIPTRI+Zi0BFDEnK6IoOqn5yOTAumh9Ga71Smll0UM3f0Yx9rGKQ
K7kVJuepjRKsT4lf+ioBUy5/5filddHJAIjcDuSHwPaCgW81OmjIRM/e4Qwv
FIyTcAEeuohBdZRzgIUP7P94harb6CHj71qsDdzc8OZSy9MjbbpIa3ZK64w7
D4xu9hxT6dVFkexBO3dkOSDtwo5w30lddGjt4jMxQU5QPUg81fJYD/mlq2qo
Nu6GYV3HCx+GdRHh8btDfL93w9ekJ/VuB/VQOEa+JHqFDU6VaKf4n9JFJTsn
pVximSCOjSBM/q6DLn+my/el7v7v9/3luuhfw6mMmjsruLbzXhc7ybooiWks
vDx0FZdqod2vX6yLcsIba6ILNnGEJtK/a3F6qEVWcgi3bxvH9Cc2oNddBwXs
SSJV3vuHk//wnoOOkRflJv+W/1ptAB0ZZ2ti1/gRlzYqaiJjQPzR34Ev7YLo
1I0mHiSCgfkrA5NjgmJo0fOOTJS0PtC0+8slMQl0nj8ozTBXD/AU7tQRfTH0
OpxjjilRD4YlYjVrHkqhczeMSFbXDGCbv3U57Z8YgoFI3UuHDcD9NqfwlrMo
+n1hRxzDbgD4Sz9uA4ijG7oMqqld+sDoZStxkVUSBbX5lhEUDKDu8YDrrQJp
NFarFn5yQB86Qm7pRg3IoDW2pgW+p/rw5NPtV+wWosg2UDZpvdkAJK3cngg4
yCBV6/i+zxR9WLHd/hC9IYa0u7l/RMdioNv1y7VT10WRWsH1SwsmGPgwpKvz
6rEIarHeXzdMxYDpsRQX8qYAUpbE4BftDWGl4m7dfR4hFGtX5sLcgAEJXsMX
NnLC6HxhvkqRkSH83HuC7uR+YfTrw+uk/UNGYNze1/XirTA6/ORRdTSLEbzk
ey4afkoIWYx5htaVGoJpRYgsTyQvUhAMfmEVbwRh7UGPHxTwI9sRp8vRdEZQ
3l9/u8b0HTWQZ/mwt5wBeAyhHwuNLPB95uqi+1kBIFb212y57YbJ/NuRlpdp
8drRc6uHnxPW6PqWH70UgZ7wvYo/C1hBt7HS9/WoEAziG63TL3KBVb9d5GVn
Idj7JUp+6CozJBlpSLdwikESdvCluJowuHAv13aFC8DgiY+x1nP8MLh2qUBn
tyjksldfs/BmBl1C/XkFbhHY47ceJcLFD7+TcEZPuwUgbMjkOw+JF64m2y6H
4UQgbLddx84UD+zHvmCUphOEqV/Fn4CPH7iOXRaOZRSGFhG6rFaMIIjqfz58
bVoQrMjI53saL2AEg7U3RSUgUo3ak6AkCmWe/yqC7ESh99lF00QjHih+evRV
GVkMQG+9/i6OD+SYgtSua4mBbYLB0+4jHBD+UfR1pKEksPyJnHseJQCo8udy
T7E43Dkz877RhRuu4sTk5v9rv2TFLmxnhjDYOJbNpMkLQ+b+5vFaE36oF/8W
xCItCX/3nlt+Z8EHu2J6PDAfpcGaS7faiMAD1bM4dT4fKbi7Wt0hHikErf43
ruX0i8IsB37V8pcEdKbcla1aEID4dj6u9BJBkM9WNG39KQwJCYVfLbc4QHTU
bEGDSxoIeT8kp6t2gxnnq9r2WSnQmA75eTpYBGYxvt707yWA48iBmbIYMXAY
CWycLxGC1xlswcJcLKCu3Hvlxn4ZiH28cNLvByM8FvYYuvdbAtpjdOqC9wlB
8JHs2ugxCZBj+/IoLkAYGiKSd7RspeBWcvbcJ2ERMNLxfvt5Rgz2vsv4PNkv
Qpvf56YuGYLw6PCvUwM2YsCAq0vSiuYFF4fmo86CojDyUtGh7CQ/0C36LfQ1
C4JtcbGmeAc33EIuvClW4iB/e0mv8DI/pLCf9z3WJwxvAzzox815IbbbkN5y
XBqUyl1/Mw5wA1febWrOvCQwZM3fDlbgg3uXnRlRKCN4xpf3ZEqIw4DR5eem
aiwwEX/qLaZDAi5U+STzCrODidMRqaJpMXDSOv9l+6YgnFYLy1YK5gPBO5Ua
Zrmi8O9dR4enJwt8sJBydGwSAJO7zbHvpAQgKa5/4uV7XjjQTTRbGecBhfhd
ZCYXfpDm5s6K8+AD9el7uY20+OzTenDm8Bc+SLhXM/33LT+M2SUutJ7lAQYV
YqLEFAcsT+yqMEvngWsnLbfYDHjBdc8dy0i7XWD4x5351AQ/eJZxq0+fZQW1
a0cPBjsLwInFnAcT8pxgtmf+gEGnEEwrGvvenmGFaWp/yfFDouB7t9N9ZYQT
KgJ+TK/5icC9789tLebZ4FuFp9e/HgnIei3NZzfKDs12obvpL4jDiXRFnb0W
3FCzyS72O1USiuXKvpH+cYO8dsibWR0JWPl3YW+ZEy88fVRoUDwiBu/Ys1Zu
BbJD16cG1ZaOBerUSQ2B50taYDyG05P/1YDTyFD34pLVBvKb27/0XSQhfkP2
2D91GXiUO3PMVE4SAvOVyScbFICUFKLx84csBOw/u/enmBwMJTHNjT6UAeYs
fx2FOkWIvj0WQrSUgbw6qQcKN5WgXUD0w6CALLxhqJn3GJAHNZ/wiNfpcvA7
Jb6v+Ksi7E66665wTA58TOqP7F1TAnM3uowMO3ngnJt5f+m2EjyzCMgMC5eB
tvAE7ppKBQjizlbDl0sD3Ymw79oP5KGV6fqZ0npZ2Ch6Jrc8pwBxFfX5hAxZ
6NoTXxSorgSLxutmJGkpOM1yU+7NPTlQSWmZGCiRgWe3jZ+G08ZR3OCv4UWV
g7Ij1V9e3pKH8gDJNIFcGTD3Zr47cEcG9r7cj/04IQc5m57xl+oVAItjPzh/
WgmSn5wR3aqSh90lZa+TV+XhaxaWxSdYEabDFuT112Uh6dPms3x2BUgYPR68
l04WZK/J3E1Ll4VndsHTMT7SUManzz0VJQsmKRE8RhOKUIC67ftvKUItXW/F
Il4aQuO/Tg9Fy8CtS5yz9LYyUDPMRptfCXA1/8e1iJGBqUFqwmc1aaDEJoxW
pUhBu188h/eMJBg3ftpfelUOXE0fjElfkgIen8ElZQWa3Xf8mh2fyICO9kpQ
8VlZOM2Qd+vaSWmYcYzXKZ1RAIXvh8of0+ZjLt5kUChJFj558a9qT0tA43Ro
f0yfDFTFytgS8oVBMiZ2xX1MBj6Gbcca+IjBSb89qvXMCjBh7J2p1CgCfj6m
WB1DKZhvJMk5HheDBgFRzhdrUhCcsRVpxi8B/YNnbGK35GARtzg2aisOByfK
3N0YZOB8hbentrAoHDyq5eL3WBI89VpU7ucKQ6XV0N9j3nLwjC1+77kKCdCj
Rl7ekpMDseqrGOFlERBCYzaKzeJQfMWDe8xXFIyGVEdnPcWgrPPPKomWJxaX
2ctiSBIgwvW7sj1JCLz1dKo4iqXh1e6PTzFPBGlxCPHxtrLwoOjzujq9KJyR
2Hc+NFAC3k4eevLhpDj4qfa9pT8vDTep3TdDzgvD0bOXp5kKpCAkfSI/YZ0f
zkl4eWyoy0Ic/Xcm3DgfVN0ROPL+gAwkXHE+XTPLT/OT0fklWj5kHb++798w
Lwh2q009c5CFe7iq9KhjgsDizMJY+UkehPbEdST78YOraKd81TtZ+JIo2/Jd
TBhCI2Je7HsuB5ZLc/LDHIJQ83GRkpwoB8orbs2cBD5QDsdyE+fkocNqdLxZ
mGbfD7U+0o4saKQPln9t54fFMZNt4wRZGH2S0Nt/kxucQiWivrPLw6fJzfcc
qcKgxP6H94uiPNDNhdgG+IlClG+fwBmMCvDx3PrExiMA2E5RVgVafumOL58c
u8oLukx/om1vKMD9BF+BR0OscPMX7nPLXiWoPmQoy8YlDEVLD0s6e+WhxGZO
YJKZB/S9ZJ3/stHyXLVRjAw0/+lFsGf5ysNID2vYzzpeWM3n1A66rghBmSKX
Emb4odO2/87vfkU4VpmjnZcqDjbRisMi9xVpfDIkpvVGEAYfTJ11yVGAC5+v
nXrwWABkGAT4OuUUIYEyJv4lXxRQM98qjy1NXzXGTEScFYUTzBNbB/aoQLh2
fqmzoQiMWs+oebcow66g8DzrBXHge5jYpmeoDJyPbT+/NhaBTbLLu8JeJZjz
Jx1zkBOHU92lb7OOKMMD81ZxznZB8Gf2z6psUoZWJVeB5FlRuOoXNmYTrAro
fRmH8rgYcKjejj7srgDJJaVsBvoSUN9Yoh45rgQym03rDCr8kBXy78ZfFxXw
f3LV/aqMEHi1m5p3P1UH/9ixSw0b/BD6SNB8bkkViMefFvUmCcCbt9eUV0OV
YOm0dgXdrABwfXgeYtagCDntQ6ahUjzwfsPOtpdRCd7KbvSIC/PBuMB1qnuL
Auxtv5bWTvNvQ7/gkVhfFXBvjmn408cBIxG8PBJrymBJPjtfq8UL+63wjlo0
PXrv6g72fDIPXKgZ2ENfqQxnoCQa38QHxXkBTWePCMLrqmk1iXEZCHJkfnWG
nx+0lomXi1dlYLA4s4YSIgjC+qlu+H/SUNUY3HrbgRf+lHl1eRbowl+sh5ym
lyg84MqQyj7zf76vPkcEsd0xPHmXLNEOl+QI5xMS8HXx+G/MCgPHaKDR5e7/
c34VCdIP4X/+iiSjlJrauwIyRIid+jgyWUZBT3fYKq3XiPCi+kbZVCIWnL7m
mu0LNEW/L7ZbjH0zg+AzMQk72kKo3nhi+Kk9CVwkfPAvRSWQt4tOAeUiAZra
3tr7xWDRgNFKKHsyDn3u1jxsX2QO/D6LjYNJFmgpvDr63hFzyD7aLdH03hzN
UOn075qawVzW5BaZBdB900gS3RNzkO+7IpvRCdCW+ezUhWJD1BvorRqfYQw6
nRH6EU/N0awJqX7T3wSVkCrXopixkD7VIuAFlkhJKzRv4SgJBL8n+Z/pMga1
V9KTE59x6MvB94MhbuyAlb96ws2bD4JeNlFcZAASlQbVLxiZoKj9i78aP5OQ
x/N/Qu6GODDfE9jrQpZBUbyc4z+0MVAXW2Z8sdQY3Ro9Our0z4SGm29M45oU
keXxm2wc8YYQyr5TPHxSDmFD2q6ppWD+t79FyNBQeKGBkVUXzFzozuPcTJGu
GzuTDqhDYpNN86gnAS3RN3zTarRCQb2ZuVq2FHiZL9XHJaIEmBOsd+brLdCL
pNBL9vUA7daOdC7hRqjoipn/yiYZ2bxRbB3EEWGUeMqlvBVAxunAdd0mHdTw
wbDte5UVyqS3u3puhPy/x+Nr+b/bhRQwmD6DJmfN4HzSH4agC4yILmPjRusP
QO8c5bLX7M2A68hsSNsWH2IrrVNJ7zaA4kZ3terB/zx/4qP87+uRKLASH39w
KxUPJeNSAQdeGqMXrI9smo9RUESIAH8cjhYn9IsfF6LwqK8/Rcrd4v/szxxG
Bh0GWdb2u1YoELOjMKZBho/Rrd7SuVbI73JE1EoRGZ5e2es94qEFXgo5eWeN
8UiKTuSFaBoA0+1urMlJZTRGNbYtWiSBuwXLiwdZdMgsONts+QIPWsG/knhF
mz81x4gDIj/p0XP89FRIkQZU1do8vk9HAOUzw+nS+03Qp4Y3csMftCHa+Gyx
gL0sPG5k1t53QxSOh+s/wspogqyf3s1STzIaKn/9y2MvHgxjBs7n61AQYZtR
/N4FAvzGOshuZpMQPYO+66+XePiTeE7X10kB0q2bjQRVCEgd+VXfvyQDjExv
RJ31CMiGVe5jz5YB2LzkuxY5S0IMXWVVJvpkxPxjZ3RrmABcbyVMuL7KwbYX
r8mFFwSUZB9Hfu2jAEekOxje3CIgaceZUyKaMpDyMRH/sIGAZBx6M3BjsjCv
VLSt4kZAEysNt3/ayMNymKBA4Toeia78EPTxkQNqG1/1YxkCOjB/meUTDf+I
Y8rYrAwCKiooS7q3Kg2M2YNOwkEEVNpx5ucWvSzs0hSRUUshoNyxy2+yk2Xh
vemF2ME5Avp448Xu5l+y8GqpPfVePgERWnIq+Y/KwtHKyh51IwKKcb3oO9+i
Cq1e+y3NTxLQ37ojZ3rDVcBZWpIaUEa7f0HAU64XwjCAH7/P2oNHtyobJC4P
GMJ33ZfKWmcAfbz44uYrZ0NwMKe7EHwLELP2a/VdDRi4HKv0VcoAj57xEkjU
aEMYHyHxb80Cqt7pxMevGoLXRgU9+3dAlxUExda4jWFLeCZ17C0gis8TxeQw
I7BncamRpAJijL6nl9pvBA8WnjW1hgDqyYWUwiNG8O6a8FdBb0A1Agsx5lcM
QcPNornQFo96jkDu21PGwMfnhDFMBnSgwd96X50JOCnUVqXo4JHlhr2ouJ0x
0I+8ZLxjD0iFpbbqm7kJTJq6WYe0Arruknyod8QYSsPr9724A2jShjdXItEE
POJikZ0PjQaZhWryKw2hhaS0FSOJRwfLHrmH7iNCuJg190C8EWrkW/fK0cMD
pdDOQ6zPFJlmJZ5Nx+HhnXJvqE4FFh0e5mdyCMbD7pbWs7xEM7Sje0Z0LQYP
G26D+vHTFohiJtxOncWDWdfdGxfdzdCLSKcLjS8JcDWhxHs41Qz9E5U9MooI
UO2fQHnwyRSJerwgC8USoHbQNGVPuil67UAs3JeJh1WHBHj4DYPMVGr9Mk/i
IVuw5/fKCwxquG4VXf8XD5FnRpB1jBFaWfLhf6ONh/jz/N8cXusij0jxISUT
PCgn79J8TdFDPP1jXWXn8WBffXqUg10X7eMOZ+V4hgeWpjNMqU4qiEtdT9XP
Aw+HPE2aroeqIMNenxsVtOtVJfGI08QkOiS0fLFgHeBA1Oiv5HAVVKJfpabA
S4AC1apDN96rIH32xNGRaTxobU+zK0qoIKKmosl//R+K+6YBZalFC3XY671q
eG4K8cd4zV2XuFA58weC6F0s+GK4q8lkbmTbGFTHfMIMkt9W3RDllEDtUkZ5
54AEC/g3EUpDMsjQa3PYXYYEi0mvRu/9lkVpldsTfV9JcJS9eJHZRgmpVjQ0
1syT4LjkUKacvwTi2z76o+MTCcTHCmx3uYih1Brndw9pOJdrMFs04iOHuLEq
xs7KJKComnjxlUiixM6CYKd6Gs+PHbmHKdyFNq6eHu9pIcIC+zaZ/QsL+mSA
aVhfJ4JCNyZ54yAdErv8jPzChgQn+1evT28zoMjgrsUgThIslR2ylU1ap2re
XNGr20Ub7yfVWtbJDpxnh9WjKRrv71X9bK0hNkk9KaTNr71EBPvdA03n15eo
I7IvFWdziXBTUUCzU3mWyv1M7KSFOQn+6fw0Jl9nRmMu+hMyr2j9fb1nPZVb
qFTrj4LZK7T+DAEv7xe+py7RZStY3yCB7CaX/apXP9VKi39XDZEE23jRJzPh
zVTDmfMD5jQeG08zaNl5to3jdZB9RmdHAt3eQvYK+lmqTtHd1T9NeMhV1fvl
6C0E9v6bSYE3iaDNP9MgG7eAO13kWXLVjwT7eg907Ds0i9vBPByOoflrQKJw
6VPjMC4oyjtIwJI2Xux2hijbFxzb0CPh1QwSROXlGxs9/4Sb9t2teJeZBCwd
RReXFpdwTxf+ufMLk6CNCSttFzqJ03TuGdIhE2H/4qa98oM2nGgP9gtnFhlk
ov7WrHz/SFXt4vhR1UcCM9shG6bBnzj6gDiLXR+JcEqW63OW1Dzux+J4+6GX
RHBTGbd5/fwfTjd755RXKBEO3TH1Pnn6G848+I9vgDMR6NbfRkbZDVHfGL5p
juUjQ9jTPGcXhmaqvM9xEe/HJMh8f+wkyp7EsZe/nUpXIEKbpPzZogud1Cts
GpfYnhEA3gSwDjeM404p2t4P+EaASIG2hDfv63AfgjiHOTtIUJiQSuJLrKXu
d2VXN/1DgmNT/Q7R5v24t9pNkSdOkEFO8mzL8uggbnKCNVmGlQiLovrVE6+m
cd8PGCQm76XdrzpLJIVrDtcvyXLs+RkifE26OP0RreJIPmVjigJE2OHbU/17
+w/uH+lfeqQvAVhYH5v8m0DUeDGv6uliAlhIRXjwzg5T3zybyqGn0OqAq6Z0
e7aZICfy/Wp9HgGEPnq7nNdqxj2i6ORF0vDIz024Jz2EHuiycOfi1ghwLmOL
4SB2Gye/K+IC6xMCrLJ+HXG8toqLaKnhxtJ48mR0fsPAuyXc3PcXGykBZKh+
Z292WokVufyV5jdK0Ecc60nEI6NswBdQ5ftgQQ+99hDV9jXgABeO+usPzuuj
nSOUzE5vHhitP1l7w1EfdbTuRGckrf33fjWL+sgg4HwgH8MyLsV082kYuziy
WqlZyPpnCLupd2J0g+XQKdsS/y+DxnBvqeymWaYEupIVhsPVGED6EMO0Dy2P
i+XqK77yGMLeH8/OG5byoVecasrmF2k8ZxZcFHqQH00KrtfzfcOAdkfZYqIJ
Lwq3F1bQPoeB07hqp8abvGhKx/amFK8hlOn1emzmsCCbqVOTKUoY+HNChJTa
w4nEKay4D6IYiPtVfeIjhRORRZeG14MMoO2oQnp2Mjsi3bbJZi+m8eaDI3N8
iBVl7CorLBQ0AGPbyZbtx0zoE/dn6/9qh0aoimBUWVGgs0Mc430DoCj1rzaH
MyL/y2kSNh0GMMAt61Fkwo2OaCQvSeVhgOGrLP/wEANauspyKZHTELLGt42/
/GBCb069m1CPMgAfGsRlNjOjw3QnHlhU0exhtpWU02RAuVJChWPnMTC7tcPo
us6C3FHHkFy2IajVmQ9WyTIhXW3nAHla/b0Q3WXYwk6Hlk2/v+phxIDrzcuT
6lmb1L+jzi1hnzBw/1LRU5wpOxKy4X+K1TSEhfR3p09ZcaJnYnt8jJ4YwhST
amSOGxtibN5p3lNqBL4MBy58V+FC9bUF0cEkI+i3i8mRL2RGe55zRsbrGwJ2
xu6K9iIrihKlIwzKGdF4lm0qN5AevSQrh3iI0vpH+rZyJO9CdA2GVb8qDOFH
lHdsShYTcvnJtux9yQi8Mzx4PicyI0HBM7rVHEaQoVDDvti5TD1ZyXxxZMMY
cKq7A64k7kIlT/8YWnQag3R85wvmk8zo28EfPy8qGcMf5zBONPGPau84FC6k
TounDHrlTyxcaOAGwQlo8cWg7xma5sOAjB4Y8M46GsNQOuEnYxs9OlLt1Of2
1ggeU4+bXmreol5srjPK+WgMHTdDw7mOsKOJaK+mJFtjcA3pctXuokO3G9/n
E39hgbnnTeRhK1Zk9sCGLqPfGH6VTH0rt2ZGE/TSCefXTOCU3iPOmfvMSMiA
r074uAm8fbV5Bp/FgzDpLsQIU9r1g98OVTf9o145PH7d6aMJPHGtvHgjix0d
eBzhfrnKBPr4t3UYstnRQHDU8RgTE5Cs1b0lJMODqpi1JgJcTQBuXis7Z82N
bsp9eDzbYgRnev92ORYxIP7U6rXNXBN4EXhUUWN4mxq6WPhM9IAJuBA1xmVK
hVC7R/9t1ysm0Eu/LDvjxI/kjeZv5N42gV3LPJscmbzoarxWdOVjE8jqVFUe
PCqIdpQj953eZQQlrnVBi/6jVHyBqLv9JQyMbrLuMeb7TS20rXFqL/wf/Sby
//e7uPrtR6X4EXF4o/U5IZiyjnOiRD7n5hcFN1Etxkt0/9l/jU7s/5//379S
sPx2/7UZoTWcvVUDlo5NErhiqI1X03ZwUk/vRsX/lIZrjBkesc92cOtUtaf3
l6VBzNbZRaj/P3hDJwvhl3xty6RWcIFmqmTytCy0dSSczTq4jmNLqMi1tZCH
yK8Ot+S+ruNUylyjFCRlYfF+pP5lwZ3/9Ff4P+OR/z9tRViRIBlrrm7ikiN0
m+kuysOVRg47pX30wPQh9QC/vgJwtVupl2Su/f/z/6f/0c7yJPHDCnDGZUw7
emYXsH8wvWDlqQCKrecvZ/DSgyku5IgovxIYHg6eK8lihKGylLDX95RAeR/+
Op0xGxTzV7so+SoBNnHXOYc+Tjgf8yFF9qIi9FqGv+uV5ADrTgoybleAG5fh
PSMHN5xeVPpelKAIundZ2vpv74Yo3k8s3coM6MCLTqFRY12YSF04XEvjldv8
wt776HThUJ+d6NofeVBzFm4MZZCGOO/xwqmDyoDp7xt7IyUPuatL6xlzShDq
L76PsUMGhhuyWX9glMDxxCuseaw63Drxg32HptD/EK/scqLpLBImtIDHWwuY
KArmmaZKUD7+0KzrrRIIC2P5gz8qwPql/OCxF8pAWfxs6DChAE5E5DKvowID
cfSyvvVK0ILHLbzXVoZCXv+6PmlVwN3pkiJsKAN9V3KZEacKrHbEBjByq0Lj
UOhY70sVsCqcDv4soQS9xU0balHKcFtG8faYkyIsip9tMGpXApU0js7SP6pw
t0+DTjlCA7quHLuYyaUMxFdYMamvSnBid/HsxpISFLP+uWovpQJfqt/2j3ap
Qsms07uXCWrA94Hc/tFECaxnDml6+SnBp1Rf/TCkCr4PG1JyI1UBSFxNVUdV
IP+Fw8ILKTXgsMZWG/fIwT3RDgWbKFnwuFHQq2EpD6y8lmKHfWUg4Gx38qCR
PFhcJX05dEMOBofD6jM/KcCawX7lIRF5aGYgJ+VJKMBQuEH7zetysNWgkzou
qwg+15spT77IAuu7fJaG3YqQfVT97LvLCmBTR5LZGZcH5rY8BkMmBTg84j6N
+6UIfY8/OqdeoR1H6z/huyJQmk2a+57LgX/NdY/9YYpA5FHvaq+Uh/Ji/68c
QyRUfcOtNkmEAtjs6TaWOUvU5pSz7sBKgfeyFDUnHivUIZ9mI0SlQNejcO6F
g2R0lfCn/t8tItx+cbtZs5WMNpTYnXcVEWFu1OSU100yKvHvfrZ8jQhjXvMW
mlFkVM2UdT+8nQhkqQn72koysoi88XYmhQQegpfU1VgsUegR+oKvFDKwsXqF
PCinIP9T12s19cnAMixw2+8ZGWVu1R69X0qGshst8x2KFPT6u43OyHEyfH94
8cctNwpqvn4ndEyHDEwV9+lKmCiItQe9opsmwYc7qds+eNrx2Z1D0v9I4Noa
WHjJiIIk/64s6teRgGk+G2NGR0GPKcqUhkhaHbti+frwGBnFvGROvFtNgkvq
W76GHmQ0O1ouVilJhuc8W9d2qshIzJCw4rRJoungWqs6OQraflmp2UohgWD4
4mh5NxnFnbP23rYgwdg71/lHPmTkc79aRPAtCXpln0+VlNH8N+vmdP4QGWYs
ipPYM8nIbMi9WY6mY/ZJFby1OUxGSaeXH3l4kqDCyWBkpoCM/CcZlX60kmC4
L29RbIaMBvkzTnRGkYHd7dJ66P/sH3beCsK3NPjGKTR7m8kH+vvIYNZxK1lc
gYK+ip+aIt4ng9NgEM9wHAWpN3+O7Ukiw25HxthiJwpqbGGqLTpHBoVj00sl
YWS0J/Xg1ZRbtPs/H/ELOk9CI7jtCtPvJPix/4T+33EKMl2QY5XJIcPXzr3y
Ar9IaDy6nCrwgwS1Oswva7spaDygJD/DlQzD99N3m2Fo83f9xGmbBRLcvxIs
VShMRq13dzXm5JFouvZ48aVKEiqr4H/tcZsEEXv5uT6OkZDDt0M3hitJsMbD
8u2LpyXCaol8vmdPBvk4uQj6t1aIHZvuG8xIhiMyvRNbw/+xf5ACqdg8FoFS
KxSYTL7TKWMJhz3PX3uTboXqPP/uqV2kgMDTCLv1Kitk4vUviO67JZDp4vUv
/4//LCzBVIRpTfSFFdJ+qLD2JPT/PP8ztvrf7R5LOLBseG/X2H/651tCyKP9
vddESOiRwWk6uV0UiJisvddFi29Drwi9dFUKZGzR/wEsCd15fbeUUQ8PZ+Iy
xO1nieh5eajztwULGPv3Pi74MRHJqUkFyLLiQJydjW8yjIicfiv9Pn3bAor3
mOc7ZhOR7jWGe/tPA0T77ZJ1YSMhkmvgU+ZzAOxvR1plLUiI4pjLuqkGoGcw
Kbr6nYgOFFjvvcsN0KNzIP/gYwLi0QxwUAuxgH1je7xShYmo30WkxbDfHPTd
oxjy/hCQAOt88HMPCxDzFDWX6yagWjO3n5QRC7h86pHDHDsROTM4bnZm4uB9
yqOMn5pE1Bemyflj1gJOGEX8kcYSkcArzqk/jjiw7siQ3XOMiNokIzj+cAB4
sBSYP88mo0euh3S+auBB113lCT0tv77H9ZRxCOJhpJShmJ3THN1Bh+RTxMxA
id8r9/ANUxTt/+Z4l50pOLrZiAn9xSJ8Y2a0Ux0WZp+uRhTbmCKuo/9C8O5Y
iOt7mNCmaY4sK2rUGVVNIY00tBN0wxxFio6KGjRjQYVQlXKjyBwZVuvebzA3
hR2f6SuDjuZIXzevvarIFFbSPySQHpkhDcn99l3HsaCo955RfcQM1TUEnj3W
hgXP6oeZx1rMUMyeMHWGj+aQ+nmzXUIJh3Lrb+0t0Acw8twoflpPw7+SiKX8
qwQIuCl96l4SCa1HeGoUncSDTkpxUOg0Ea0blH+IECDA23JFlbprZHTR29BF
oZMAPjbHu47R8PHr0W9K27MESFMuWxU/REbsgdl0uU8J8CqNS9X/OwnN+hlP
jX8mQJHa82zlRBI6GH7xKMcuIkxIsxt93CChnbNp33loOvyD/FTRSiEJhY9m
bnb3ESD7jROvHCMZ2Zja0gMzEV7yY7113pDQnj5rkpwUERIm/26mmJHRcqIN
9bMmEc4o9TUv2JMQQ27BXWIvEYpCx3198khoM9BLuy+WCIYdPy0c/eVhvves
SG8EAY2FsJPtzRUh3rGlPj2QgFItOlQvNOqC9RciELpJaPrUJ56ycBngnSuI
v0BPRAsHj18JdhCHayeUzef4iOhp0l0HK7wUTAkc0dylSkTxIidlWPsk4HGj
nNndEgKyfhOi9KpcCljazecu5NHaseTxBuH/WrdSQV4fJ6BuOf+YRHFVeKhe
+GI6noCuimgfsKPVE3p/bHI0GwmoArNysYZdH8Saal9frCAiviSHNO5n+vCy
Ju2QFD8JWcVvvmszUISqWPn+CURA/ZzL8jE/dKE0TyfnzzoRac7KqOi8kQHX
qi/7HMuJ6Mcx4TshuXoQcv5gYWQrEWkpnbu+V1QX/gWKyIrEkZDKzPyv8O/a
ML+coxHzm4B8Ktg+zeoaQhC3QH+jOB45l4c/Cx3HwCG/vVwSXYCm9FoSUxQx
UCjthMusBvSlpq2VepOmQ+nuO/aUAtoWOrxh4YOB9qdFGvgwAgrqztfYB8Yw
kcX11taCgCzsPC6xaGNh2i6Gze4toBCxIY9X4wQwqeUXtkg3RkLx1xjN3PDg
OMRJ35VmikRFMue0+PHQG83JeHqPKdp8TD2y2AuQiqObP+VuhsQtb0Y1PceD
lLArB6nFHMXdFL/2y4UA103uvFwKM0OWGqX4hgQCWBj+Pv1ZyAw92ow+rK5G
gEqWwksdvmbIvsVvK1+ECL3xG3mHzcyQkeq1h5SXeOjXONY/K2CEJM8FqsTF
48HSPYp+LcYIXe/9zbxQjIdiCXuvHgljdPI3N/WeIoHmT+37dvmGqFRQsZv+
PR62Qp9j7sQbI/WIxzlyHARIqaLMcCkZo/B1Q07dJjwwKRSznC01Qg510q/i
x2g4I3o80KXIEJVfsi57x0yAvjJiwTyHEfrAFn7kVToB9Luqa6MSjNCL7ytT
jYcJsHDg+BWinBGaFFOPJjkRgD2h8/T8LWOEL5XEMhAJQPmtXeNYa4RY909T
2xcJEDXKo3lcyxBtn0h+o0smwOMUg+MX1YwR2yM6z7zrBAgbDrxrf8EQGe37
kbrXmQDDLTdilssNkXPbt6gbDQSI+KXok2qui46O1upuxOCB3/mL45iUDiLM
KWR2ixPg41+ZT4fy1FA7ddNZJooAdeiuH5eKKjqwQxCNGgSQlviNubyjhTxI
lb+jpPAwPCmvITuvjb5cbUiz34uHK3OuLOGWOkhDPtUxVRQPBOaqZIqrBlqq
fU+58QHgyYz9aqCiOqJ0nfmqNw3weCA2/1avKhqln/5bcQeAs6+YNS5aHWFC
Hq/iOgH6PoxfGz+pgYwLT3sHZQNsl/2JNQlUQy4lP3BSOnjgbnr8Jm1UDdEF
GTE++g0QZ8mE7QzSRGozzj/V5fFgeE1jyfCPKjpjTPOVHx5YmYay92iooTMn
o51VNgGKEilh5x6qIXkF/bN7aTxZtv9XUXCfJjJt9kh7FI6H1bKF+6OTGuhr
wjjlaxgeWq+MtNrGqKOrc0+ivKPxwPai52PGPlW0euNa4lQ9DXcltv5M96ih
6bSet91EPCj8ZqC7QFVHt+0cn/Au4aFcYlq0nKyOCq/89C0PpcXH+Q/7Rv01
UdEdjmktGwIw1aGVAE4NlKduf7lwGg+2fw2fJumooaGTA9XpbKZwmfl5jWMj
F1oqfPzqdxUWlE3edD4sZkfaaXyBlf9MYPrUTnSMIBea6TTTU75mAn8EmO8N
47gRzjsrqP6OCchMxji3hPKioD2tdP4GWIiO1tq7r5sHPcHFxd29RoL8GnmG
KxYK6En2p6SgJ7Q61T3/Np+NBHo+zxS11EKCWxdESpjopNGkCNlFnlZnquuK
uG80yaKlRL1vkVdJ0PNiz4xs0i50SrtZ5yiGBBo9BSyhT7ap1a8jeC5HEAE2
sTbJ1gnUUsPtqpOONJ5o2n6e7ckHzsenigcOk+H9yTNjdh311JL5o+K15mTI
R804uq7f1Loqr5wZYzK4Btf5pH0ep+r3FE2lDJLgBZOLza8nP6nPsgS9DqST
oJ7Frfqs9Tz1k0be4//6LostftI1wmCdmswjcKGZmQxcB9IGr+avU8Nr1eWe
BZBhPaq25uYIHdK7oNr40JIMR9vZJ+Rhk8pTV6fRVEuG/dJrA5ZfV6gTNox6
FbQ6eG22W3sg8Se1OKL221QwGSQHXK37WVepvj/fYcvjSYDJ+IM+Vf+hqg7Z
y+TQ/NF3VdT7tNsOdebYo4AAbiLwHcXO+DV3434vdGgy0vJfio0x+s3KNm7i
JouHiiwZcj+H+aSNMyHu25U5/PsNUNDE/aSzPEzQ9ic2eeSdPpJKqW9+ROYC
QVbOm4FeBsiq/cSHJDZ2YCO/+LbSo4ck3y1ac53jAd3Y3UpXHPVQYb2V7Gl5
PuAYf+yYXq2HzOMalUJNRaD/mBHdLyc99Fmj83CaoyCMndj/LEBSH/XflVw2
KOKHF5O+461S+iiAP6nnYA8vMDIXnTmtoYdeuQl2HnnNDybhB53ijoui8xrG
9b0thhD65SJZIE4UfQ6u9Rq8agSZnhOxB8TF0alk2ynWN8Yw/hKdr20TRyZ3
10kcMUYgE8o435Evhpj8MpmSpIyB6BH1ctJCBM05Xzgdk2oMYi4zApJ2UmiD
9aFsjY0xuPxcbft9WBJlTxcsXB8wglANSXkHRwlUM2a/++QpYyjmC4gtwskj
I91E6myTEYwTMsoPk6XRylAIF1MRBuYixfpRjwSS6OKo2PsQAy91FPdrl4qj
95cW4svOGkLlnTBKqIkk4qcPOB7bZQhDKbYXvOxk0FFPVxOrPkNQbr/YGP5D
ChkvMvlwbxrCOWe5Pf+axNDMnAKfwzYGjF1Ur5wx2KSaG8Rm3A4xgGFFlruh
iXzIsffV6gM6Y9gUfHuJ4SsfspIOnx3qMIYfB9AJ7jUe1PRBbFfjojEkTdc8
zJIUQncs7NcuNJkCYU3WNJTtF1Wl2KZ3VQQDLj4Ti31jg9RMwSOZ1lQDSJFm
TWm+8gmn6XGg8N5jA+D9jqvaNPuOUyLGp+8uxQCyrufjUImiDtOFb/nrYOCR
PudCZOYobumIh4eONAYGfL6W55Gkwd4FTGabGeEQD17p9iFZkAqdK/eeZQCG
4PnK7tNzVIxMc1xErQ60SIhzJ0V9oRLe7ca0+eqAfzuRHMW4SE28WUHP6aIL
Ip8cJa/IteP2XtIrsTXTATZP5mEL0m8q66Rf3puPuvDzFfnZ9MYqtdZHiKXK
kla3DCeWepmv48aOiWhemtcBjg7STon4Ak7Y/vmPDB8dqJkp3T8ZLA+EqDtt
t1QlgfMQd4NOjgI8EHF9bToiCVvi5maXPitApuVMV6+ODAg7MkeS7ytA6YC5
d5KQLKiNfIzL8tAC70r6YURQhLn3hpg0dRV4W9efJqSsCtfIEWXiL1Ugp0Ga
VS5LHRT8xxaX2ZVhuGtxh3JJDWLqog4FTyhD2F/3XF5mdVjD5/h2dyoAS4eU
1ZtkVfhwQGN3Wrci0NPPKxY2q8Cufb5dt9nlgc9/nVFiWBU+xX22rUIKYJXi
Nqe4oQwXvpNO+ynKgau/Sertm6pAih5sYW5XBAe/457vHNTgg8bbhBFVBbgY
vSJpkqYOHUc8qscdlWD73S7u3BRVkI7eWnZrVICzdXv4Mh6rQWcikzCTjiIw
znmOd91UB1vOg664F/Lw5ROu7CXt+Ibwo5zZAUVo+xdmtjWpBaNjIkxeC7Jw
Z+vziWQhDWC82kw3JyEHJf6S4hW9anCAUfeTX5kCeJSPJcq4a8Lnd0MY0WcK
4Ky8lLrioQFqMZHF8lh5CP/m3bp7VgPuBw2XrFXJwJXgZI9DZHU4WDmiX7wt
B8qja3wGd9XhwHHSk5E1S+SuUHPjNokC55jN5Ry0rFA6q2DooiQFjLrnSr16
LFHztvXpsw1kMNGrubgkbIXcWL1TTrWSIYvTkMff1RLNdJ0eVGWjgEMkh27O
E0u0ETZ8b32FDNuOv9Rn/C2R/a7Q9aJmMmBZLf76ZlkiE/2Qhzk4CvhYGmZI
yVqiV2LWQk/7yKAd/uDUp00i+kxKyTm4hwR71hT2vL9PRomv7skGzpKhPC7B
aTGXhLgPhanm7KGA+nF+F9xRS7Q/ovj5RZv/rKcx/o/+prOGoKhAnNQpE3Tx
wyqXINEMsipfZO6oUJDrxWeN6ZoUsA8S/XazmYDiFk4/CZ7Awbf7TBsKYxS0
ljn66uAwGXxjf6adz6Og44y/L3e9J8MyD8uNpTES8mba/FFjS4HE7mJD6KGg
3flhzJ8+UcDCbZT04BAJtf4YCh9NJUNzWwmHcQ4ZjaknaQJN799+jg1oC6Gg
/fXJeu1uFHApVXrnxGSF2hRmR7njKVC0HHoxp56ERO1vmV6/RoEqFTOQOmaF
GHknvg+WUyDsWH4K9hcJvbaIeFZmRALtFd0Mf1EyCt+d1g5upP+2f4T8/+0f
Mcr+xelvgsZZ3a0zmc0h6UdknxUfCe1NqbmcUfN/1jfds4Jb2UGqPEdIqEAH
Z7W0DfDrYt2sKTcJ5TLb35Ghx0NHQ8Fs3GsiEmrxrj5HpdVlR73DhcRJiC96
y586jYPz6odHufOIaHZT76fmexzoOieGOz8ioqTdvROb8gCj+4tYNXqIyIAJ
Y/doD0CxWVm+xCMCksiczWZmtoBfjdpNa7145LW7Pp3+mwWEdU8N39gmoKaJ
ApE+FRz4m4bOap4nIJSWGuQ6DCDHtTSdfdocfaq6KuzpYgYyFxx8rwmaIff+
J/d0iabQlBlo/vmtKaKrTJymfMXChbpvJzZNsaiVIcyKcQgLNW0eZXv6zNGd
X+96D9SbQn/x52tMRuboFFnO/YK7ObSPB2CfBpgj9WXJO7wSFvAmWN64xcAM
9R6qaf7UZwYW3cfwRgVmaHfvW5FPWHMY219m0/DaDPX0K4mJFprB6Yt+RnuH
TVHMbnHJxFJzSEz+VfTXzgwFHf88dR5rBmdNm852OJj9Py7ePJrK6G0fryjK
kCHzPJR5Ho/hnPs8Z0IlkdKgRMYmkSlRmUOFDJWhQVEhhITKrZQIKVIaTJGp
QsYS/c67Pp/3/a71++usvfaz93Pve7qua69zDqrOwrZtlyyhilbVVbXVAmck
rc0KNMhwqjmn9HG3OUYM/9hd8NYcNlDu7NKot8DCgHDz98spcMLS2TCnzwKT
3rqbHvMiw7PdhtjpZYHtMk2yC7fJ0P2Z+31MoBleNQop7ne0gPOntmVOGFni
po/ZQyovybCjd3NCA509vvv7VoAfBV69LIw3lTFH/urZZ8fHzeGLxXHKgQpL
dPmm0LJ+KwUauWJ4tG3JWCqZ3LXFiQIBRznC4ti6cXzp8/bHRwHqbEXbWapk
zLW1NYwYIYNeYeCK4FgykmdWzYhxArjHyvmv/UTGdjnFS2r2FHb9F9yvnbFA
29w3TUoeANsOp2voWVnihdpVqzPWAVwOoupP+lEwhCP1m+QaAJXNvbGinRSc
NfixjPsFgNaiPVdWOR17o3IYn2KpEDJ37FUo0jGJmsryYPP6UzwrhoyBjn09
D5vbdhOQmqDy9e8sDffIXj/WfJmtM5f9XPIVp+Njxo3FH440ePzoSVaOHh2t
931xtthLhwZzd1NeTgXo4lWvv/+TxtZL5dDyRx+6BnS2fGfX0bGOHT9aAuVg
qLG0dv0NGrZe/FPkl0WBL7FH7h8xo6LYs0N1mznk4bTwHf/QSdp/61Lt/+ru
5IYv9kr6pnC54p7J4W9MbNPiXNxwSg723HzbyUOl47qiuyKrmnSBcXXrLqvf
7LoRTdBS2qALjkmS2h+iaFj2iGfH0iIBsxSN4LRGGfjsVVzY/D//27dc6fKe
ATrSwsrfWARpw8wV7Tg1tl+mC4R7hrLZdTypc8ulWQL+bZ67nr5cFawTPynv
mSJwYV2clwaDBa0WxK/9oRb4lzydZSVmCJd1+Doi1tPRaFsWz2SFHry6/fzu
wWAabuBLVVr6bAiqAd+jnUPp+PvdxicfDhhB8TeOgovzgDfqOkakCwxB465r
WMgC4Jm1V/YavzSCMA3uIpVPVDR7vE70NJuH7qtY52xQQcU747/jrzaasR88
v2CpCVh0LzvSrJIE26pX3m0tBLxWOfZDOY8El329jtb9BDy6J+apYyEBBYdc
KrfKk/DnYY3XufEE3BvxN48OIOEAo8Rj4SoBjZH3tny/YooaN27bHHpCwM1m
FXcWryk6TAfw7A4iYEKyb/evWVOsSzybK3aaAPJzztpX/0zwQP+fFe+EafDC
qWD34ipTtDgt8EblKw1kjmV/ro8joa6ylOjaSQIE0nOlbzuYYK0LP9X/Mg38
bzY9DI01RW/uU9ycwwSs4ToS+7bOhK131SZsXWhwpvdp9Co5U3R94B89RKFB
mrjuj8IPprg7zlbZy4AGXUJrdNo8TTHrE7/zzwUCDt01e+GiScKe3vuVOq40
OPLEUtq6l4Tqr7HJQJMGuR1TrtRUM2Su1XH4YEGDSNE80UUPEp6biAy3/0uA
xrd/1x+/J+FOEym3n8k0MCu2cfi4lYSN5XMX8C0B4vKs4aMRJJQ9bGto20ZA
q1h1tbKyGW49U/K7q5UGfd3+r9RmTHFR/YL/yyY6uJ+83P+zyhQ5a4jnwlvo
cOnC12f/Fk1xmcSwEpOfzu7j1S/zFUioZF2wQ1OYDoRXUBFtpSmGJk5drOOg
g9SpkD9JKaao13fdYK6NBuYJgqGu+qaonKbONfOSBlbPHAai1E3QYsO5c2t7
2P6626hJLTTByD0F9qY2dPjIORbdLmmCxhcDZS6ls/Xa3fg7lmkmyJCysry7
hg7nPD8mKjFNMDPY3fDPCjpk5uVs/GBljKEJJw/6zdCg6kTd4OVGY+wd21E6
EEODvY/HK4Z3GONXjlGlfQ/Y7+faGS1abIwfxfJ/ch6igaat7um6SWMs8Ve6
+osdX58u3Zd6a0yRdVYu08KUBiLf34vSgoxRhueY6l8N9nlC7070iJigkPfH
9doTBHT5nt62os4Y3SdFL5yvJ+D3idLhyUBjZIL4Kf3rBOSuXscF88Z4c+bQ
t+MiVFg+ddjI1cYCl3wryAUTAM55lWEP2ThSmz3Fqd9MhaTf70Neq1riV15C
K/kkFfboKewxFLFEPs61df0/ALb6HfmmcM0ST0Rv/LFBkwp7lYN/uLH7/gOy
wYL7Ciqgptn09VcWSO2rLLXcTAVmy9mZrGVkfH16F++8MxV0Wgz+bIu2xIt3
PDdHdBOwtm82e5SNe7LHPbOVjtPAdeDr8qYWMs6/ylHSs6TB9ojv/jzN5piZ
zCdfHE0DOtMh6JSsOe71ySL529Jgbv3JwgRHcxwo/P7S3oSAK3v7Oj+Nm+Kp
wExn1QgCkgwETpCeGOLk5m9H/uc+Tdoi5MORb0aYKBlbqydEQLV9/dgqJz0s
mg5Aji0EvFYsv5QVp4rv1f6sPLuLCj9rc2/rH9TB1uCQVoU6gBOjN/UK1qrh
Fn4yf/IdgDIxSR6kaSFrTc97QQYVEqrWY+GCJvoYbJ+wXkNAjsPdbTlRWvjO
peCk20oaWChcyldx0sCfJ+/e0mT3A+MTE2IG1erI714hl+1Ih8Ri76gWdSVc
//E2s7SADk4tFeT51UqYUmF4Nz6ZDi/7y1vSdRXRvsph/eolOvD8vj373E8Z
W8/RPqSP0uEPP7f/63xFfFg3LGTQTQdVRcLTKksJfzi3etoKMWC9WXFxQJYs
Op2PV5Gfp8ODPLg4lS2PQindB24+ooPZsp4/PL7yyLIuP+jJxQCT4tGoB1cU
UCbpW1FpEAN+3/r2MuyfPGZzF4w+NmaAYuJgqNqQPH6QEAHRPQwItrk/7aQk
j1XVxm6trQy48lKG1H1O7v94438+SSCd2VwwrMMACtddQcnA7xQ+coqG2S4G
cIVtbK03XAEPrrUr9z2gQx2VCBq5txw7n7nncCcTYFm3mmN/5CJlF+qkp5wg
QKKvsO6NGgdElT6pTh8ioDfzqe3RYX6Q4j0QF5jH7jcO+2KiClYD7q/eX3WK
gGVyAbpTn1ZBbKvCHoNEKrydC7cx6l0GciW1cqDHzg9vDp5u65+U2NNED8c+
AlxCB5ntm79QOsV1zmXUUkHA/o3oS97y2tGcyxIF4gRg0q0A+S2plOKW8YFh
Ryq0vxbK6Q1pq3XTmnv4tZcKu/r0b3As9lPuDwjPn5ulgkffo4g676+1g/or
NGXfUOFAk0JH4Z5fte3/9CwtpajgktT2WHBbe23Agbcf2xjs/XPuP8hcGqhV
VrUuvPCLDqciNqvE8HBizo8owfnvdFgzfkjp70lubKd+/v2bmwEpnY4Nc1z8
GMWxbVOdGwO6HnUrA8dKfPPoX2XlDANeVnRrbVu5Ep2/ngvHQgYEnfET2vmd
Aw+/6yYXDjAATn70pXQt1c4/8fS8oscA3oYVyQGNy1G3RyX40jsDtG3ukFc5
uQJWKy2Mit8ywD/FdzM3Z6wC2t5Mi0A1A6yp3efDv4YbamoSiBN/DVC9btm/
BZfVALT6eaMbxkjU6/ZG0YXg9pt3m29d0UOzkCD5E8dEIdwt1VwtUA+zrfYY
t5SugwmlXPEIMT28/+VkhdIpcdgBA/vLf+ljn/P7ugP/RKCxrCQ4+pQhNl4t
9+eflwDB+kfbunINUMd22XDUaXH4U335WLGOAbbn5i4brxIDpQFOTvESA5SZ
6vvFmSACvZw1OXebxdF8qnvrMXlTkNV2ZG7xFEHKN8tlc56m8CSGWma8VgJd
7i0rcdQnQfSpEpn5CEms23lSt6zYDIKlzAK+y0lgxpcdY/YLJFj1sUmLe484
Rv15XN+SQYJzV1zPfL+thJZnX5y9q2UCAguH+w3HFTDyIbdjk4IJrKk5FJXW
pogd8aGRFYvGsIZIb9IUUsRdp1za9qcbQy5v5LsJVwVsON8wVk02hjdL8+mO
FAW8LXeaZ/a1MbSp8a3uaFuHotS37msV2PapaU5t7BDFymSZB69nTGHhmPov
yZ/C+G2T6ON/j8zg9P3sWeGnQljuc0Nup54ZXGt4Vzh6TQS3DbIcbqmaQapn
03Xx31MUw/WCH8zrdcBTbnkk2XOR0mAfr8y6oQOZDbdTGvxWQLFOVs8CSRd4
b6xsO5P+m2JsUyKZvFMX/vo/lTvYswK8806csxHRg4Kz898m+/9Rqs6d/fKy
TBfCVfi9SUsc8Fqpifnvpi7Emf/WD0vigitlo5t3celB7JpvnpaPuUG0tHmm
8YI+lIUO4UDjSvAtbsxve6sH7ll9wszAlWCf9KXWzFUPmGSuVYrkYUqS9H4N
GXM96LXc31k9pwryFyesftWqQ3tL7vNLD9VgR/+TqeBYDeibOkLvz9aEN/c1
Krm2acCn88/fPNTRgFWLQkvb7mnA78eyJpR6JVhrL4j7m1XBTrzXuqpLEU5s
u30he0oVer352j9lKYHd0tpNHPdUoKNjr9TGFaog3SHg/qpXC1ZsXZlGiVSB
lKp4yRXBmqC84sOXe/xKwBVRe9H6sw7U/BihJG+Sh4qe2Sx1Iy2QDH9G2bRR
Dq7WGQ0GZGiAidIeTqsbMpB66VTDTrZdswIawWd85MHrrU7KBVNNeKu74U9E
DZuHOj7Qkz1tCdLnW/x26zARdR/9lTzLhHtzeaddy6xwqOBVqBjNCkwOPxPy
02ChYrSXSU0wE77a2cX//N/vD6yygs+Oef61p1gYdk00dH8OE+yv00Y9/jFQ
fpJS1/qJAT0M++NdJSTcs6pxrEnNHAIjXL/lbKNhcpVcYt8DgNQU+8I/d2mY
Uvk56tVLOiiEmrnNNtCQcsxnr7AbG4esly5arKfhqhbR5lW+AFF5R5kDIUzk
XdJQEfzLgK+/C/pHgplIfORS8qz77/1K1v+7X6k8r6uVu4OO16vf/vZNYcLK
E297d0USqGmy3i/7KxkSpGq67xgxsMyM48vpNCacE+YfPC7FQI4LSTwPMhmg
njXl8UeMgcdcI92Sif/eR/iy/m9/56ZN2Vcf07Ar1taHGcKAnGRP5q43BIpd
P/aj9x+AK8fFA3J7TLFGu+OX4EFLCBuKTtR3ZaBf+dMjRA0DDN6qPOGIo+Mp
vmSj9uMM4LFN9LVvYeL3G1qSdX5MeEhfLrDJlYa/1KSLAk8AQPJsqDsXCSX9
aJvfsfW7/UWuSH9ZGvKvXvbjXT7AbeqM8L80AqserQp6yEkFuccfZbWnaWiy
I5P6JpYB+QeL5xIOMFC2Y0Lg8CG2vZ7zP66qMTBojcbMKna8tB4M7HF6Qsfv
yeOqTW8YwCm9fOreezpGcHvtqTzG9ofbZHz5GIE5HKbZ3AhwZf/rUW8FBlL/
ZErokJiwRbQ3j/yOjvWMXO8/6gx47V//JaGArW8jH+zImaYDmW5OehBAx6/H
tz6uYs8r1N7U8yil41JCre2/KwzYWreaK/EXHXUPrS+XGmLABv8gJ53ldLR/
uGns2B4maFfcXu16iI6Tn5Neb1NlgsvKmUfb99GxJ6Xp3LEmBpR6FDo/Z+s+
U2mmwQc1BrA1TGr+LToGa9zSCeNlwvOJhfca7PMfL47l517OBC6j5OVb5mgo
+1s5fkGUjWvPAVnZTLa/HtDaLjJBM2PB8xKJjmyCwSvJxwCXa83jzaJ0HCmy
GBOqpINs+/gXgQ107BT+6bnvMHv9Qe283nV0XGPU+KHJiwIUbonSW3QCy63X
yVl+I8OjF7Nz7tLsfBbUXlfB5tGPlnIttrLzRe7rp1jR/QA3ab5XPC+YYeYV
hv6tBDMQGAiqbeMwwxdP7j67cNAM2nZ/k7r/1hLzjp0T0n5jCVJlqSOqHZY4
eJHuaetBhtnPG0/99CWhYvuQ6c5H5rDAE64tOGGGuZfv5SftMIdSJk9G600z
1Kv7uG+UwxyadzdzV2uZ4adLXR+2XjGHHlYujcg3Q93O+JYvteYQc35XchHF
HOPc/dtd+y1gpjZGL/UeGZM4Ih28LNm83486tPyXJWrfbI5KY48Df/9bsf03
GWPW8PrILVHgYhOh4U2yQPdA9ZtOHADTEZFVW2QtUKnqNucvOwqoJb7Vqiyy
QM5tawLMsinAFTN7QbLWAj/rb+S8IQTw+2/pmcrbFHwYamTFza7/LrEdezM2
ULAvc13RwHEA4p10FmmWjHUndf0EhgAS++a2aPwgo1+IkkvAXYBff7VPxCiQ
0dWs887ZNoC5POkBd3/AhJG1GkLs9X17ttgHKQN2BL++8m0XQHWd3MY6LkD3
7d2bg5IAnggNdRxwBHQMZDWe/wzgVfRmSjUIcElbV/tjLQUetZw5MWIOqNDp
THURBFimwYjliGTvL58z6qQOoCu0423VISqubnre4xwBwLBWWiDLU/HViv4N
mzopIOo/pqgyCTjrdEFTzwsgzYtz96EmwAz/UZncSQpYTSbZHSwB1Na+whHK
to9LZrTnXw2ghIFzTfAzgKq6pZVWOoAPn12w5k2kwPx5D8JjC+DtFrKNyycy
mBzZ1Be3CLhXKFIvaD3A+U0mTzYbU/GPsuOySHuAxQLzLt1CKkY7FbRuZccn
n1ilcD+Uig5YbhJsBuBzOVf72F8qit8OOfuS3X/qDFSGNnmw57t5u6J+UOAg
q+rXuXoqTuhGNeRaAxg6dg4mZFDR42HR+++7KDDx3C34dgUVMxarrH6mAIQP
/G2YMCXwq5t6BW2BAoMVtgWae6loGKzwmHWQCqbZ/V/kF6i42cXVG0fZ+BCW
386coqLxnzxCiJ0P+/hPLdsdTMWGTYqay+cB/m5ptp0aoqLCqtuDcfcBvnz7
SDJ8SMU9/H8HDfoBOHm/Fm3UI1B7Eyx2FbHz4dwmMqgQmMtxJpBFAByyjlaq
+0fFBz4OZPsgCjyNUU9ViaGiq6uZIqUGIGSz3W3OZipKhQt1bd1KhesJTpu+
niaw/lxlz6UYAIHhqUG+O2z/bVpVbiZLhcevdjk3hRDo3nNH75c+wCa9w1md
Xyhol6uz8kkJBU4/PTOyvhbQvj9d9S4fBf4Nc71cfRYw0Ojwa0MbMvAPGBwP
3kFFwYVx6xV7yexEi4iOYxBoIfaaZ+AYBfap33t4k5fA50ebD75bSYGh9iW1
Jy1UPKGRVOplQwExWU1vDhaBD8UvxyQHADjJTUgcLALUuSUqyoyiAFG2+7bj
L8AndsJrew9RgLn9W70VO59dd990L6FQoPHt2yMfaFR8+va1bZo5BQaWbjDM
E6n4fviyd1ADGT7afekyRSr+6nX80MVLhs2UnwKtggQe3V9aKbaNDFoe3Qez
Kqn4yJ53bVwYGY7p/C7ez0PgEQcNgclsS1CuGjy/aSUVoz42rNf5YwmcBsLj
p/cQeCVp6E+GExlqNbm/dZgRaOXjnWYzbgnftCY6VHax8SNCPLUznYCDhZxc
b9l4HjzuIVGwRAWugUP0y2x8MD1aqvd3O1tXHeNZSqHTUVptdqE7kgqKBWpj
oVp0fCq6LNP9BRXeeB1cvTRJw6l8PYdT76lA4j7h/XE7Dd/eHg3rL6BCfVnT
/KPLNFySq62/P0SFgxdMZC/foiFHG1NKMYMKbkkMOZ+nNHR8WsTjs5cK95aC
HKxDaFggLbzptBIVNubPuTuVE3iQkXds+CYBha/PpYQepeE+0pPIJG8qJNo6
PHopSsOza2TSdh+hgq1vzZ8pLxqmaQnvNGafz9VNLHcZlYYe6h9YsXQqfPys
/3j5PQJria8KpuZUuKL/9bjuSwIdUzcw7ZcREP68pO1mBg0HVk3Y6bJ1nkDz
P4mf3wlUiE+jG1KooJHUtvwlBw2dJamH6E+pUEX2OXCXvZ4zTWyG9ywVco36
HeE+Da9jpTynGAGjQ5veRmvTMGPVA5XpDQTcGvqx4wmNwHzDyzwSCVSw6tF8
xGD7K1/jlV3nOFt33sti5bD3t2f0e+IiFf65qkr0RLPtTbHM9DtOhWGHhUqm
M4HnklOlbbTYeGfmlLbtFIEdxZzrjFqokHaQHsdhTKDAzRFm4iKAPonY8m8d
gVObD2ysBCr8sLr9r6yGjZ8SPpk36tnxDDx3LqmcikLcZmvWWhHQbHKjWcCF
wO01R59T2QX9MDCl9FEMgSKqD60UBQjw3JKgcZftv9HUjiiGIwG2m5rjDwgT
ePPRFZP0X+x6firq8MCawPFb3K1+/ARcm1i5JLqGwJ6x33yZ7P1K9Wd2bmSf
T9fxlC81iICNYVfKj1MJFLwgFSXYSIXZ66Npr3qpGPc3fODXHhps2f3oyEUj
Al+0GtmSnxIgOTHStZE9XpKU2W4XRoDpye2Xz3xi18+qvgrlawSsWub+x96X
QL3JL+rxVwmo2+P26EwPu/9tDw2r8ibgRRvJsItKxy0i907HidFALndj7Qc3
OkooHSBz76ZBeuDkzfVmdAzfHOWQeJEGdz5KBb3KpuM+B8f8OhsanF9N2B3Z
x46npVS96lca+Op1K9K62Hz18wGFq1/Y+3G72rxn85Uzo+6pGxpo0BTnqHNT
gI4OrKQxc1E62Jld9/7rQUed8F08Ty7SwSeXS3IiiY6D57qaFsh0WE/i2iXu
QEe1c93XdyrRwcrb4/BgoS4YNt6/daKQhkH02PyU90bA2+43uFeTgU+F1z49
Y2cMHHlS68cuMrBzjhkqr6wHf48u5b3uoGGR345LCnH6IKZaeFj5HFsH3H3h
pUOVgoTqjNFjP2k4Jv95hZ6JOGSMET/j3tNwQ5zNKVK1HkR2H30x5cruA1O2
jwSDGBBead3/aUkJo9Rb8uavU+G764tvIcGy8OZ3hN6KCX3wOO89OuJExwci
UsPV7Loc2MhwTxeSAN8nV2er2DyGpyNBfmY14MyE3Ic8A314nei/ek6Rjrdr
ZT5NW1Dghlt5BE+8CIzmacbvY9PyNx9TSTb5kkD4/4vUqqbBQwFaCiGsiceU
AodklVjwe940khy5QNm5Owq53pGhZOyIaXq4OEi31pKP/mTCrH+zlNKzSUqh
7wsLqQISyKuctdO3EAZjj130BhNzuJka9/dfuBj0tilb7OA2AI+50psbWul4
Q3D7GgFfKpRmXHL5KyUNeua+QUIfTIDFf8B0xz0mXgr3aCm5bAg5cuYSIg8A
p9okP5/ZYAjdG1aE67UDZkrfgTezRsCgdjk8Y+Nep3tK2Z0OQ6CK2vrKJVBR
OnAfz7SUEXTunRDJp7J5w/PRwF35xpAxOBWdyMbFKPWKk+s9jYBzZ4PljmtU
ZC4LPjETZAx2P0JjWi9Q8RvLMvSKuAlkLhFHjvpRMaKo//mHE0ZQPZm4/qo7
FduPbj5py2cCu2lTLTVFVGw2C3g+KmoGN4sGRIxMAHMCI6u3qphBQGVdnPAp
wP6ctCfZO8ygiEL6mXiFgjVBpC3tb0ngnrypQhYpmOQ3V7bfwwzmW2V9j7Lj
9+la/NiIFg3eDtdyT0iZ4bbC+a6AEBpkfMiZDh42RYq5pP6WFoAewY7Bm3wU
pO4l3d6WRIVXl9v/cdqS8XFevIy2DwFZLk8yON6T8aTYvNAGDgIuvmho5jpM
xo5YC8uwZir4TXtztRqS0T817vAzBQIudOgZnM21RKhJ2vKR/fzEFTd9BmGJ
yhpHLCQiCTDY0CGUa8Xm7X/8Eq+eJWCTTp/B9FsL7JVkhSWfpMG24Xe53zws
0dZYJN4ujAYqQTa9hqFmmCpkfqaOXZcl+tJ+cM8Mt7Ttz71ZTANVJ3PLpWVm
aHDR9nTCCxocj31ud/+JGe5V+2Bs+ZcGq9qVCzikzbD+1oJjN50Ovly7+dVL
SdiyseXUvQUaKG6YeFNZbo7kT2KdedfoEP+pftf2gyR8eZMrNGqaBsW1p0Mn
Vc1R/mQvdXUNDVpj+ZJ2hpoj72Il/bE3HYa1v7q+3UvCxa0f+/evJUDnC/8e
QssYt5R9ZmWxcbD8ebvk0A0j9Dmxqi9ZnICmc2VXjIWNUOi3qvThh2wc3Dde
89VdDw/rVxq0n6FCs5KKjf0RPRScNh9uHKBCTI3olZv79fHQ7IXdL75QISP6
a/fzTF30UdVO4Wev/66wj7gzpYfaDU7XdsZRoa9CX/GOuz5mJj0aOcrGpe4U
vx3q3XpYzLODSyOTjevrMrqLVhngNI/3q440AhSa514eytTHkN1HcxXZfbd2
3c8qx/d6eGfE6KTyHSr0nN+nWzOki6kAI9v7qZDX2qS4QkgPzd8teJ8po4LS
tlC3AwEG+M1L/eezWio02Oa9KPE2REc5mllcJxUC4oquPx4xwOqZ6Y97Qqkg
c8Qfrl8zREORH8+ueVFhta9rTa+cIW7I7uluYPuH2lhpMO9iiE/FuaOZlWzc
Td//6vpNfbzBRZVx+kmFhN4VMgNVhjhvfKFiJZ2A0Nbo7xurDXH96Lh/fQkV
JpdWZObPGeLuVPWfi1VUKLo8rmQcYIT7D7yQ7KESEOIUtOzYai1krVzLe56H
gBid0rT0Q5rYtHl7SMZztj2vouQ912uhoHTS6x9NVCBqT+WM5GqjUsVGS/kr
VFDlrT3BtNHBy43rL3kPUkEotkXn56AO/l6J2hKPqPC1I8Q2DXRxOi/8oKYn
AbK9bzYn7NPFjAcaGZUyBDzJu8YN9rooJpS6N86CgGTJqQ2pn3SR5xC9aeUm
Ni5SMzf6rtHB5YMJlfZsexvUykMe8mjjtF3/1+VsHJddWJ43ukMP9Zl9zW1R
BAS339K7+VUXH7Y9YdxmElBzxiYwc04Hc64KKOzgY+O20On8rFJt7LrVKc5a
ZPMkvRlVdVVdvJ0ZMXulggCXqW9qp7x0Mdx7YY8Omwedn4+TPHtWBy0vv5aM
mSVgqevM95+Nutj/teBgwH32+y76/TE20kGfo7VF/87QIFl5bfkjW32M2Cvq
p5RMAGNknXcxhy7a14cm0BsJsInI+gvLdFG4YFw5ToNd33avtHfc1GPHI+fW
bbY9woVhTRPWetha6FV2v5wG0neexZMv6aLOHfmhMXsaSA7QXUZjdXHhqb+P
FY0GQidTlrmI6+Gm0WEdgzga5Gb/Oa2fpocS1u9hyo6A502mpvbjaljGeadO
ne3P5r18WkrKGmiU9c6UVUQAS9z0gY+UJp6ycX1p854A37mvP72m1dDoeFqR
8zcG0Gv2Etu9BimcnpYyMtNU2BL6WD68Zzn0NeQcPhbM5lmV2sO20eMUjHIo
J3sRcIUcwzt+YI7i8nFX31NpArZWzwu2Pe+hpPO2jJ4IooJ02aMzD971Urb2
dEaSTlNhxWHFByXXftVG5xGKM3lUEE9xklEvHqgd9d2blsbm8ZodD6WFsodr
oz2ehaiYMqBB6Ier+lNBVOjljr+uzQCPHyP5pdQ1uG1GODnFnQExEePBXsX8
OOXekCpmyIBbnAGS0msFsOxl7IOqr0xI553zcOqUR74at9T0QQb8YKasrZfm
Q4E7PZO/rzFgJ7Xq666jvNhwPqzbuoUBc9sUT8W1ceMasd8Um0cMsGNa5Vle
EMLzUzt8TlcxQKLr1JKzvQCODgRrkcIZ0Knhs7U8UhCJPVus//gzgMXHV+R8
ZB2OGHyWVM1jQJSMJX65+be2dNvu44tbmVDSRS/hk5DC0oblReUDhtgbztvz
fusysEQKT56vER5VrS21ThaAl6vLdh5RZNf9uzWPb5wXgzRej0KSCbsPnl7U
WiyThKvhRtQ5dT3c6zySINUlCTJ8bW6hJXq4LCXJ6fIpSeirjRAIKdLDIX65
rb0B4vDNONXNQ0MPM4Rcbv2tE4XMr07/zqIuCuhfmTf1FPuf31n4NlsbIlnQ
kSmlIwZe28/nvmg1wLAXidRtz4UgPvlLTUyzAfJk27VzSgrCqHNRrXWMAQqd
zeq/uWwd9Gm3L3+yyRDPz8xWjJ1dB5P/rqYpZxkhvanOZ3JKBNbVXZQJczRE
XteIawZeQnB7i9PmZ2uNMONS0MGpO8KQkDzyZGWrIe4J7wun3ReAJ/mbquC1
IcqQIjxLB0UgxT6sv/2ZITp10H/VeAuBtKWoUKCYEf7i8JXr9eKFTfI6Zhhr
iEl22zbLJPCDzq5o8DE2wm2zZuEdLBF40HLGPGvQCE/lnDxy6BUPGB7SnxX5
ZojvRJ2d9T25oPWrkbxypBG2+nXt4svigzv+e9fuPW6ETnEf0iVfcP/n/heN
8X9/Lz3TFHN/r4MRdmaSbN6ZcoLyxrP7LNl9/4S2gaDOgz//+X31NaP/e77f
riHGYaMhNl0ih11RWQ6LH33Nd+81xojV0SUquzghWJlGC+4ywjNbeQ0OCnHA
/rUdiyF/2H3b62BHoh8XRHyjSIy8M0b15M/+jG/zlDtjVuUfkP0+x5r3m7o5
wMln7sK+c0bY8nFowvHcwn/er2uMFht1r9yYmKHkeW83O8whhhqnY7etZZpC
3tllxZblIqioZBVmsmgCEyvO6Xy4KIzr96eIiOw3hdAdE1kxerL4Lj40rPIV
CR4YiooOFEmhXW5Gy8sgEvw17kmckxJBmbOiMb0PSfDmicBsJlkMSRb3Kw9/
M4Oxpy2PRDV5IeVL3/n2fj0gVjpLMFJXw6P5OLJtqB5YePFELX3ghzrbMt+z
0Xpw5OyFmz17Ziny+jVHQ3/pg+RbezHTi38pDhtu/yTa9WBARyYtYWSCsjyc
wZ3dpwuPFBNuvV56Stll+JTyREkP7EpFGzxfpVLOzPMeXl+kCyXLlwvERGmA
fo41T+EvNfBNfKn3O0UdekvVS4zm1GDeIsByfEQTSt4vNn7P1AFdkgrtOKrC
qDWX4fAnTSi2tRSRPb8Bkhz6ikUva8H1HjVVgeL10H/I0b7wmyZc9zW24k5e
D01ZlIunR7Ug6uhMhMgGFeC+sTK24bIGzE/LekjGK8HxZ1uSOL21oSUke4iv
WBmibr8slC7ThoboSAO+n8ogpUW72L5fF2Y//eCuH1GC4XOGpXPbdSC8KvH6
S+n1EGKu2c1/Xwfi9VN44to3gIlNRv8AXRfMzizxmX1YDxq2CRFHdHTh6536
JBe+DdB0dL2mO78eOBxW0WuRlIXdiV7zLe+1YMjtV1OUowzU9g3Pi3BowZey
NbcSyuUh+LymTEWCDhx7RPHWPycL06M3nmexdCDWTt9EOl4GfIuCVnpd1Ybv
Xbs+ZsjLg1zz5j172OcRCydf2fJOAcTtc7b5rtEGe9c+xtYReSi7/8aoflgL
rLf7frpqpwBvn0caeExownKH1Sw1piLw0sYHZNS0IHhByrRtgIRCV12aYxUt
4L0Pp2zHSQIz1Lx2qrVQ4LGNU005Fw0HDpfJCsoDfBf0K1UfMkWlYNUoHpIl
VDT55oveJZBC/XdxSxPAjUb5uBNzJAyP55eef2cBHY58ok8GTNBOrajH4SAZ
os9/P3W/2RSXvX5a+bDREnZ1qXOGLZni7o7iUJltZJB22aWzzomEt7bqnase
tIQvO8LFw46YYhghsVRPIsPzMK8KSQ8zfOUb/vaINAXyblcderVkgvqlReTY
T5awGQ2LM6JNMelMd7C+PQX+7rYrDlcww4Gq2LX7WGT44SOjyvPYGONH9q47
f8wCSOMdOW1XTfHo/rSVPU/JsCicqa/UQsLfd+cD305bgsmZufr4EBP8eZmY
/ctnCcvD70+cCCDhhQdi5FWGFDgvUxhg/dkEsy+1RIzvs4Sf7TGjG2eMsa4l
YXXJjCWQRm0+1c+bosRTXTUjGQroNTlZPA8zwQ3OTte8+cngcvXCcjdbEwxW
Hz3w67wlCHqFXZDjN0Hy3nnlO5NkYDwJGvNsNcbnL8pUDkpbwkHd+6K2HiZ4
7IyOxvgFMryTUjJe94zt3x3T0RvZuriyf8WJdelmGDf6VTTisCUEMH9sviFt
gn1dti0qTyzgo3qDU9waU/QwVA1jcFmAk1tNfdN2Exxen5p1Q9iCXSeNL+nr
TFHvoIImx0MLmLS4EBFcbYo6bQ+LktdYgIuA5tdDSaa4iqVdOtVlATGNEovz
aYa4dnf14y//LGDk07P54ki2LhJ8P73YZwGeHRWKl5XNsCCuiRHJsISYk8F1
4ldM8Mv69GKP52bw1OLERN4DEyR+RffFHrCADXu9emdcTDHTkKG6YbcFzLY3
Z5ZUmeKLdKJvo5A5LLXtgr3lRnj2/PW0Z/3s+E22/CDlmbB5luejRwHmMLLv
xbCKHgmfHUjZvNXaHOJb19pMvjTFmtA1ba7nzSGXX+X9ATNTvKrvOfjdxRw2
NaT6XjIwxcLU4Z4LDWYwNMAR6m5jjI+EPd5GtVtAMIUj5KqIMb4JbdXjeGAJ
0hoDChv3GGP2xbJgkS2WoCLxiXudqzHODYnP+RmYg0ywRs+7YSN8PLapmbpo
DnkcTtXuM0bYHdWm0hdsAeRnkraP3Uzx8C6Wad8Lc1gTvzFNtdgUb2+aUoiJ
NQN5ygaOF1Ik3Bx/U0OQ7Z8HUnKjHiMmKPxg68KYgBkYTVftP8LO3yCfk0mu
z83h+rPw7u18Jmj6Ul2tQMUczO++Jfj1TfD3PpdQUo459N/q7P5ON0b9rx2W
RIE5lJeVeAbcMMa473w7rs+TQLq5wPtbkTHmWH7fOZtjBt398QwwNsEACRve
VYQZ+Kmo2SufNEIWXcrhqIsZbO67O7yL1xi3mgWsFb5rBn1LV2vWcxij2Izn
HuE1ZnDW7bLMjKsRbgrfadpIMwethCFb8QEj7Bjy6CZvY9tjPiL8ScEYFcfr
Fp0JU+gqefk7+YoRNuW9IPd2msFlUraNlLkxTvAcWD+jSoLxS6IHL1ix8ZkR
9bUtlwRz71ZKKySZ40OmxKQAOz8+k6QFLlWZ4+AmWcGNry2AU4haePO3GWaJ
xVt6+1rAgwqXZCdpMvodv6LTyAMQ9fzNUvZxS8yN//dxhQMAw7bjUYy3JTo2
0dKcywDeqhf0JQmSsQ7ztI/EAATELN8rIUfFfhsXWQEEcMmfvvTvNKCSFFU6
tgTApyurWroEMLI3sdLsGBUc57UZ17cBBrRpzzocJkOQqZ3W6URAWtdI8NoX
ZAiXjDOIDqLihScnbL/es4TCjSfr28ypuELG7cyrenZ+nVW+T4mlopf7cE6p
DBk+T2W+jn5DxROuhusP51gCd9t7P5dngMlv8yNvriEDl3voepkfgH1qb7w5
2f3g7dIRzOGjYo7E0nuFBTLgsMtKT7b9mc5xCYedyeBxzHNK6Dgdp90Olh8w
IcCBKyckI4mOI/yMxhtTVOjqyKDdVKajjX3bHpoSAdUO45XF+TS82qGjnzUP
oNGV0eD5jobfFzWTnuQQ4CMpHug3S8Osa5y3Xu4h4LXvO8K4h4Yx1C05HBxs
HfU1S+GjCB3f0A7GPf8fnf9w/6rInTR8uZTms3MHAZ99EyVTRwnkG/SbPGpG
QCOn8VRQPqDZOv28wikCOJQP+biPUVH4XECb5hIBtltPfG57SseABof0m3vp
oO+yVB1YRcd943PQMkgD1emlFXCGjqtzA5aM/tIg4G4FBG8xgbjB4sdFAUxU
4h5xeXpWAaZUi9VOudEwaiVO7g9ngtKGmUFHX3P8O3hr4l2RJOhMtZ3bcIWG
N1b9ebnyIwHXDttWTOdIgV0aoax30gAedLud/dxIx4ghnvApP3l48dcveLkC
HR8/f+xkd9gQ1hwNEmBYU1HB/ZVN+gkDiBNt+DlwlorGv0bXh4QaQD1jH4+V
JRVv0R35vFQMwSnFie/bZSp2+u9wJ0b1gXagcauGGxWr7hzoVBg3gO87bu94
7UzFCZH+QpdAA/hd6L0jNoZAi39ueUoFhvDeUUOpRpRAjrurqiRuGcAfvvhK
d24Cy1cd8V3UNIK89Esh9SNUXEvyLVFPMQSqI/NBTAsVvWOm757gM4Tq778d
H3ymIulNi2fARQO4NHzi4vuXVNTeIUSSm9cHedvC9tBKKr6W2nVCwdgI+PGV
TpURgcjzXW7jjBEUr12YEjQl8LcWoWkmpA/vBeY8ijYSGGJ7Z+zfAX24VDCk
KjlDxc2+j7PX/gaYy//2rsiFjAXNvPtmHQjQ811HF9clo9Lu17KOJALEfUzv
38ogo7VStN/3SSrUeraHPXSj4OOddnJvfhCQNcTfcs6EPW+ySG12IeCRiUTs
1TJLvL3qULbjdXZeO1/ZKL+WjPiW69GyBwRwd/fkb71NxmyuhnWpnwlo3eTW
ZeYEuPrMcdcQIRp46OXYPxsn4/lpjvvHKgg4mqE0yLxPQSP7NcmT1wjw1HFI
kdOioH/ATuPXtgQkNsQk7TpHQVIfhy+9nwD1w78TX25my/ER3zhOERroPpMo
Yy0HjLurJfDThQZB3zLXVZdZoLDMYTn/C3QYVzP0svppio4Z9qgbQYeOH3JZ
pwRN8cIf6bOaVnQI2Koi4+1hinIfGTvPXKfD7iLJkFVRZlj3p4R/9iQBbtf5
Y1N+G2GBln2+0DYayK/nmvZ9ZIjWLY+5PtJo0HZP7TnjshE6VB9oLFSlwe4T
GyNfsft0eblA2QS7rqrubX7SFW+EvYPpr2UVaKDiXthLlzXCsQ5Z2y+jBHzQ
Kiwiswzx+jL6YmUbAW/4NX5unzbEL6s30EJFaVCcIeMgc8MQoz44XDTNJGBY
g8PyvYYRXv3RWZpXSUBZ9Yeg2hhDbCk4EvEmiYC1Fs2uchkG6E196b50nwAv
IQvy3pVsHdaZMPPDjYD0aCn63/XscbjHrxeCNDCp6aTF0gxwOjT/SimDBoY/
flPUJgyw9r30Zr9OAv5cvvxU/JwBksaC+WXeEOC67WCs95w+1qkzHJLkaSBm
1f1kV5g+nluQfhCQyo6fcYq5s4QBfhBQWq5izO4rJbFI7dTHA9WJ4TwUAvpC
Y+/8vWiAz2CM01qePX8iSoLfzAA9Q7s/WggToHuj6gXfsAEmx78JCVpHwC+f
zkHNZCP0qopWP8buY+/+BE7s3WOEG1VdPkndoMK6NGzX/KGFceW9yLORBi38
y2afftJCcX2n+ORIAn5MPH637IQ2Ev6C7fLONMhaa5R59bseKtNlRzgq6FDK
Ic55WVIfvX9kehw7S4NaFyJlgksPPRxLnO+Ks8/j4bhzplQNNcbG++rY+XDu
+kD6l6sabHuXRd07QcCKsEpGQoImZowFFMk8JeCWhnK6qpAGFrmoZbhlE2C9
+YCfyS813HLx2WnXeBrM0j4PPnNVw+GZEbualwRYnhIyfd2iit8UQvUC1Ghw
2MjqpIukGi45qWm38NGg4m0Ea+uiChpl/A7kP0yDOvPfGm4NKuhjEx5ofpsB
wzFj08lq7yjXDLZdTH1LhasdnM6zV4XA7eXtZZq6BIQXq7xa7b8CnG87bAln
++vbec8vk358sCfpksDdVirkeFiFWU/MUoz9G6e1pAiw6k2fjM6epzTb+R4d
+0GF1KoqF+Hnfymnoub9YqKo8IHyryLqXSGl0r2u/Zs+FSIbS2u6aW8oXXvS
OOL1qOC9dLtP0Xmc4jcg6PNoBQOCtx50kW0TwhTj3LmNBAOyxJgbB2KEcSP3
h7dOtgzgUMoL7n8lhieMShObJRkg86VKNy1HAgWbp79/jGZA297s3W1TkrjO
2/jvnx0MKFFKm4kplsBo6I8/ackAo6qsBENBaRT0v5CZ/okBj0nLx/esEcXj
fTpmX/IYkPgw9sRyB3G0v/UsvyKDAasvUWoFKKI4esOm6kI5A/TvrOrbeWYd
BoZ4Jn7axwSuvoHpZG9FtCZlXC0UZEHVtcjjRbsUseO4Q/XYewZUTA7aFZSK
oes5ebNlrQzIPsJ5R9ZeEoXETNMuPmEAtz5uuTIhjbwSd6aqIxhwVeTz149v
pTGy/pa/lzYT0rui7k3ziv3/vt8tgZKDQW9alFlwYv/PLVmR8hjN1+C2fZAJ
gnyH5JS0RTFaotPwbxYTDCc/7fA/oIjSP1a1qoswITo4sOlPlwSav+s+JhHL
hGc9wocUyWKYCc/jTXsZ8L3qstifeAVsJT09oH6LCQOSqbc6aQro/b7V0oeH
CVN+pq02P+Wx1pJR17mWCRmZmpLHi0Tw4NmK6tt7mdAgc3KgwVUEj7RNvRf3
YMI9uzKqNbcQpjP5EqcDmQDJ+Y6S6d9r72VNLzeM0MfSNdGsXf9kIcaO5+yo
jAFuv1ydoHJBCsYF/E8YUAywpy9aO7tAAoTHa7dGdRmgf0rdjsKdUlCx5hOp
84sBbjv49p+2sBhUKZxxkZI0xEBOnU1BP8QhCjWCS54boebnTdfvKgoDr/zJ
jw/1jfCT4ES6x2VxKL+msXS71hCj91XUfXwnBq9KHy4uyhrjZ0HnpyXBAiAU
LCz0u9EISVf+ckuGCMKiQviFL0omKLVwU0H+BQ8E3evQI6cZo4szz/CSwWpo
fscUeFHF5sMq+q5j59dC5itfg6hHJrhTYpQQyRMEUuz69LpNbL26pdH2mKwA
tO/f8/INWw/kz/wSad8hBPKLps2T6qboFm0n8ukdD3Tx2rbE9BhjrU22nJK/
GCRp3cmQyTfBMV/q6joOPuiLTdO0HjTGnY+PFg7iOvAccFf+edsEf/EUFh4+
vBJePr3eYx1lgtQrl/YeN14NlWJOSfGbjZHv8QIHv806+Fs2ccxypSlOfZsR
+ACikNAowOy4aYKjjUcNH2uvg6v9gs37V7DfVykmVkNfCWSvtmXPdpqgXs7y
xCk10f/koR1bz8wq+aZqTFGO5XO4pb8wxqQH9SuVfyyDul1nKxucTLBzR+xC
94YV/3le4P/d95WqpjUaOxhhxQtXB9UnyyC4I/hb7aghiq49XkZWm6cUmnGX
Ct2UQp+Gv4ZS0mbw0OGXFKe6LCYU1fdL8ZDAYeRGickFcSTFdNJVwtj6ZmeH
pN1jEfzjQdnZddUMbGWmIgM7uMH48o1rNHF9ODc6/e/7mAA8nS7wPP5aH25H
XeRw510BPdymCSVR+vB2cmt7qM1PCom7jEUS04eIP/s2W9RPU2aNtUmZoXqw
h797sFu0jxJLPsmqfaoLk6U+w9yoAUcrO20WvqqDynbxfNMKDRi+s9wj/5UW
XAtUbdvYowYKU5c/1xzXhqRn/avXrlGD8g/p8rZdWmC7//SQqrMK5FvQM7Xt
tIBrpuqohpgKOLg96vSv0YadFWG3oi+oAn9DTZ/HAR0o8znrp5qyAerSkj9I
peqAgL3T5w+XVEDiqppc7RsdyC9fqN6wUw3CRFZMiVrowWr3y1M/KKpgeOTk
5u23dGHW5M9J7jkV2KW7IHIEtSFszN7ELn4DhPJw6yT6akJXX2xW2BslyF6M
OM5I0QKNoNVbD4fIwqVnrj08NXpQIn02N0VOGjhPXzvo4KkLXuRTY1oJirBF
sdHhUL82JM6r753/pADHZ8J3aHbrQND2HpOCMAVwfmY7dHlGG9R+uoS5nFAE
lQvO4nZn9eCZGz1F4YE81Irnmhn36kJ9qFr0syBFkDrwentruS6QlrWu5lip
AAOn/9SN2euCoMBbtbhzCmBwLFBa/r4u8PYspN8Vk4PnmrTTh310oa/xfc+e
QEWoyhfM6yV0QVni9c5aoKN9bpVw/3Ym5E3WFUWF0jDghHHVnRQWjNnKxd8f
ZOGbvVYWs3dZ0MGz/2F+PQt3vv3L8ewxE74fd5vyc2ahVUO5+RoGC1rUfh4P
G2ZhRuX3ngI9FtAty7Ozz7BQJ+J649UZJnBPDZzPHGGhYdaroY5JJjiVqueG
Klph5EzjyzohFgxsu7i1fp8VWgy+03jnxIKMG8+7V5JY6Nkzuf/sKyY4H5r4
9fc6C6N0+/ZtMWSBibmqzVwKC18GSkrHJrAg+9aVxoecLOzg1Ky4dIfd561G
SQSDhU9LShPXrWHBeLX08eR3TBz9mLTktIsFXJ5nC+ZF2fMHDoVFUljwbXdH
mC8HC303iih1/GOCbWqkiJUiC6//eJJr8JAFYU3DAX1GLDTSjCgNC2FBzp0K
rmstLLx67NF49WEWeG//27BcwgobNknaHfNnwYJuyeZMayv857E1ub2dBY/a
j2avtbXCLwURTxXTWODBkHAtOMDAeO6dU693MSHmzuGyiAoGZhcvM6lmn1c2
442ySyl7Xudnuk0I+/z6R+Z3nWDgutmDgfvYuPPVL+7egDoDDTrgSpULi13/
sSESbgzMc0rYt5p93usmCoX7NzGwyJol+/w1E4Ye/jiQ8J2BBS+2qN+6yj6f
iyIaSzExZEioYDPb/1ZcAaejJhgo/dqq874TE15vvscUUWDiH05DF9EWJoQo
eL0fGmWg2imT/J1jTPBe29XZV8NAT4liI4kdLCBS7RODXJk4nDmgfUOXCVk8
Z8CiyAr/+/mf/tb633HPf8c+VnjmnoaGd9N/xx0s9Nq7re2irxWMnXHU3ifC
nn/4TymFvX5/m8HrrRdZeFBRZqMOF3teMfyq/W4r9Jt7mjPgYwXrHT44zgVa
oWJ+1USNvhWsXfHGsfMuCy+2232ybmTBva3Ba294sLDhhaW4KrLgSmgM3xN2
fARdTyuE5rD3t79/I1zMCt0P3KPVe1vBX02h45lmVrh3IHOHqqIVeMb7XLL7
zsLhgVU1osus4IzwPfWGCRZ+CLT98938/9n/vzxkpJqR926tFT52O/vyzNv/
/r/iKiuUEjWlRw1YgWRWeO3RzXQ0WLPY1/CXAXvduDTPDNKwwLVXkOMzHXI3
rDlnZURDq7HKjQxfOiwpW8ma1dDQ+F7PrVdGDDgnHWexkE5g6JFFYzkDJsRH
BK9WD6HhHbdxJn01E0idZfXVDTQ8FTC8QWeAAV9W7hlzOUPDvdk8c9/YPK2u
eOzmn0c0nDueOKHJXs8l++N8SDANt84mhNw+yoCiy2+SRy4SaPj0/GLDRgb8
qP/ywWGBwEaR7neTNxgQ4aDni0BD9QODCZxX2PakXtjpI0jDNWm29zZbsPcP
ZEgLqtIwzLjcNfA7A1p31xRpa9NwaGb87sFWJkRuX8oceU3gPm2l3Efj7OdD
9GcMc2mosSGVs/4uu347Q05e06LhupwjJfucmWxd8t7/zA0CY79vLXbPZUBu
5T9SWT3bfpb1bm9/JhzPWLGPk92/EjD2evFuJuif04wqWE7HQONdXdJPmCAe
dueDCEHDlaH8Yi+UmLDvcaLgqj8EyhDjJVnq7Hr6mHk9r5U9Lr1+YCX7/LS1
Hw9rnaSiZa3lbfd8BpSfp+0ciSSwL563mj7CgI7LStnJjjRk6GJjWRoTXvJf
O6YoTCCJfH0azrPjaT33YHwHgbyvbXT2F7J5c2pj4WNbAq+xrJPQjQF6Twwv
2C1RkW6/3fCIFBNUeTUkmhUJdNBxGlQNoEOGYkwMw4xA2YqJHvkJBqzx4ljx
x4ZA/RAhkByhw8+RFeWCc1RM+LmJy/ItA8JerPGqZhJo+W1I/SwwQbrRk7XK
hcDKm1NvOtczQHo7y3rqBRXHeo9XpKczIMbD+9jOG1ScEfU/mPqPAc33Vi3u
W0UgT1RBifYrFqzw+jdBOUugyNHE1bXvmTBt8a8vr5eKcDhpUl2BAQuq/MlH
BAnkXLPL5s0mBggmayqVSBHY4rucwRRgwC+rdOFXA1T0X/Xh1WqkQ/iDZfGq
Q1Rs6y+PfHedCVHdqZYGoQTe742KKIlkgp/b15Hv7wlcrzaE/aeZMMeq/f+o
evNwKL/wD9gSSdYk+07JbhgzY5t75nlmhkpFZSuhoqikpIVshSyVUrZCEhJa
lF1xt5ASok0LFQkpEpG0vPO73u/7+13vn3Pd55znPvf6+ZxzzfNUKKaw8M/3
WuGX/PVvaCab3p7LRqnOfAps4uP2a9uSO0pZ6FUq8tmB728z2+YDypZs1P+R
5K7BX19Doz+2upiN+WzXnFV8nE1RVftaWsJGXY9W5R9F/H73QO6gZQ8bNYuN
TwR+5QKZYx57VIqNymc0T10Q4kGM8MJA1yk2hsYSjx9XcoEtFZF3zJDA/Rt/
b+gEHqRtGz4oxB8/tTtgcNcjLnga/f21R55A7iWdpIVzeVDK3JzoeZSNJQ47
aSnH+PU/qvZdXi4bn10Ok9lM4YFbdOuimY9s/ERx6am35sFp489uI3/YmGIt
VdtQyYNX5bMXEoUJ/Ny1Wip1Lw8mTpcS2XfZGGCYR/Tv5kGZkGjERwaBykYS
g/JnedA3MV+0lEOg/0aBLp/j/9UjXeJ/69GbXY+Dm1YT+C/6eMeVSYDFO4fN
GZVsDKYWay03AtDrbCucIWxQpX7erXdLmJAq27xcQ5OOS0zfX1303h7mVBbM
V9prhTTjYxsGbgJ8cO7QO2pDx9DqNQkzQQy4pLpg/5ZVNFT88lxsYB0D6vyp
y03uWCFEWkrsdmfAmy1ndVfPoeGmj6lSKw7SoaTZXWb8ohWy0SZq5jkdPndt
MpdToKGp2CYtpwcM8CkPqXJ1tkXwElRf8B4g/7kzWXLRDtXSKotvxgL0jHye
H/YFcP3nhpq0fAA4flD8uiYLRdoj/So0WdBlcuX8trOAQdTx2FBFFqjc8THw
uUDi3e+thkmb2aDIeV9PvUBgXUD20ZJoNlx131y+cZbAt0qjawrb2PBa/tGm
bWcJfDz86a/mSzZE+8AZRwUCfZurxWvnEpDV9cp3lzOBraHTjTvesIEXmsOZ
5sfHqhmjdQrFbNAf+bpKLILAw5ePa8s4E2Dmf6hNnV+f217V7M2RJuB4TNyI
qg0L5X1GPvjfYIPAyVXXJvn14Eejw/DhR2zYHM3Z++A2icKnEhpS1EhwZ9ET
N0lyUM4kbWzZMAHbl/RFKpEcrC//oy3WTkBuwtodsp9ItH471+nvJQJM5xtn
O74g8Xw99cf83QR4ZMsu10gm0cc81F6wkYBXgfSHG8oo0NrpwHUS5WDhjQtb
rrGtoKHkVH3EHxaWH3Z7lqdIg57v3psZQWwkaPFJUx+swKt3NlZcjY1pH3ZS
Y2Os4IvYX8oBTzbmus86HT5Fg/6QmZqrRmw00jzFeuhlBUm290IN+HG6oSZe
ao4oHSqZs+DylYW/e7I90pbT4OsU2/ThdxbOUfVrMMmwAmOdbtjays/L7ntP
NfwYsOG9TVbfGxYWqF4835dEh+r18emyG1m48tnS442VVnDp5M3tEyf5ffCv
v4WplBU4WrNuZGewUeDjUPVkLR06Yosrr/5i8XGCW+Y7DTocK19Ac8xm4TKV
u9SzO6jgsUJbniJIYOEa47SB7XQIMShe/qmVhS2yX+8+b6dB17pB0TUEC987
lJ1m19Ag6fjhjrV/AcVNDXcEuNJBZmC7u44sCy1vZs9jV9MhKZl42PMWcDYr
86mQBgNip5JfmCmz8Hu57hsLISuw3Hqms+4TG3knDBvXpdLgx9bjYYcOsDDA
b6VyQxUdbhYknSsyZKGK0rTkm1NUKOHlrx9s4NfVmvH4H4mWMOFvG51xm43m
R58eOS5JBcHvh1cvfMJGkW6dR0/bLKGG0tPXF8LGkLfkM8+jliBRlj/nBL9P
p99pSX09ZAn6Gw3iN/H7dBedScnzp4LT4Q2Llhzh9zGOslUElwrmzikWTSwC
+z7cH295RoUYmwDfCRcCY7af8wq6ZAWvAuiUd0Ikbsu6Nk9kI9//zn/b1vPz
SC1gOseljwpqgcZ7WKkE7qOZq9GcqWDTf+uMCZVEzU2Lx6wOUeEJ9bmfTg+B
sg3D9x0CrMC8dJv1PAECP3Q4D6g8ocG3y+Gvxvk4ocauVF1ClwYOFu79QfMI
zP+Yk7HAhgay5xe+WFHPxsTps1Q9LUu4/as+8/EBNjooxZcd6KLCUePOOTRl
Aic3HT+V95AGjXEHPorz+/azXCnl63ssQWFnUanxCjbKCo/umJq0gKLWhsVX
bNj43sl99HAGFUR+3/kLC9j4J3a1QvMzc3g7u2fw0T0W+jX2Ohn8NIcr7T4r
/x1nodGYusCQsDlsVSh9ffk2i4/Dp/WCes3hvEmKoLo4v4+UVZ7astUcsitQ
8/1nFlppXyk2zDSD7BW3Ez4ZsJGqvCvE/6sZHPA5fE/4NwsDB/R1fWLNwFb8
4yX3Ln5fy9arpjiZQ/IFJ4UNLmysc/507MQKMwisZAVvOs1CjeFnYvq7zIGz
xeJzfTELJ1b+jNR/Q4F8yNaN/x8cUK4q7CDHAqbi+F6RGTt8VBcx2L2UBfOa
g72L/9pj74uuFxcn2bDQxHTdqbV2uPlvot+GZ2x4WvHgb/pdO3yAG5e9ohNw
9Fncpzh/e6ycoi9ddpyA3ktCr1ap2uOmBYPeDUsI8LJ4nJXz2A4dBg0cNzII
WNsaunkBzw6tM3aJVckQMO0t8yWvzRbv3zgS1WHAhvXFFJV1Kkw8eSm85M4g
C/x+ye/urQHcFZ50RTWYDYLv93+WsgSkRgZGJa4m4GrVqMHwPiYO/pnjEcLX
74PZ021L5QEDq3eI+PHlSepXNBIcbLG+ziyrfoiAXQLWTIm7tvgt6WXsu3gS
TAW05wj8ZOBhjZ1R4ECC7xsxi19sa5Q1yzkWx8eRypt18hMnGVhE5gWXHSbg
U5r4AcLcAqupoq72YgToD8kx2rot8NuCbXXf3Njw+PnkkyAvCga65rgpqLOh
crexeD6LgikjUfOj1rNhfoHkqkkTC2QWxn/KFyQgNWwi5f5bI/wqYs7N5df1
z48Xmx7pMsYo4Z6awgdsmGMq+W/vZyPM6++KfCLOt19V+JDUG2N0NVCtrzAg
oFtg/xwBHVPUHJrpOfeVDRvLPmx3aDJB9bm+sy22BOycHKWJSZlhoLZ37Ege
AQLlARtuaZpirLDzw49+BCwYk9ZY5meKGrHF+0XSCPhI0Up7oWyGxx61R8Uq
kfBj54elHSIULHm7oO/jFwJMnJfeKXAwxw8+ny8YaBBQGlv3VpJlgOJEwIeb
xwjwI4fIuBhD7Hn8ryh6DQH9PR6X5VuW4qSftnqTGwHtE0M/mS8NsDn5rQ19
CwFxF876K+Bi/CL+LMLHhwClc2edyQp93PPLv3qol4DLLfqCYzr6eMXwV5r0
BAfePD159S9lmplItnz0u8ECz2gHw5wZUdjQqmeiVMyCQ91319YHjDLbRrf+
841kQX+LTmPK02nm+FLC+4c2C9atMS9M+/qXmb9E54HGTha4LLTT8cr/xozw
9qzQ2cCC1q4XMvrX/jCXuVQaNU2y4K4byGQ/+8ZstLuluHEE4Okje+sdeR+Z
C6N9z6c6AKjo5D22Gxhi6rwr6vI4A6Awffeaxa0u5j7TsFPcRwA5Og5bNo0+
ZUaW196kFwBkVR4Z7HX/wryVLvWYSAS4uszkrTClr1EwpDb6gA/AzQWh1fNi
/jHXnvlhX3AbwHuzilH0meHG82OPCHf++j+WBq00+zbNNHFmP9DtAjh9z9jy
9b6/TG/nrhIrHsCOnm3sdNspJsf+0u3N3wEUFQprV4WKQ4H7KcUvd+xhylVK
Yfk5IQCHslqPJCasWHKiXEB6nNnuNLDp6hRAQY3X27qcOXC9cGS+vwSAh1lC
aIrVODNl4PzThDYmDD/I50Zf/cfc+SqfO/GUP3/ZUKm6/gcmZGYva+hgwrjP
onaybpo5UKNDyugwwVqnceZW7CxzN2fB4EYdvn0OP89gjP1mhqbuu+FgDlBj
4FHsMlbVmGT+XHbjbyZU+KV0ChTfZo6vtaa9cuBAzilSUP+VPA4sqBNSleSA
19PPu7RvLULevL9ydqZc+PhScUeqigYaheg1bZPggu7uyqc+bqoY99l4sqyQ
C7+EVgb12chjuU6e6/srXKjZz/i4s1cJK5uExwaDeUDuGD9JnZVFHZ1rxfEM
HtgIZXFWyshi3tWJ5uFbXFDXfP4yrVMKP/W7PKjcwoNEuWvCdW0LsX7+gxMC
kjwwUC977i2giN2OP3ze8nmHcUpB7tY2TbTKtDSve8GFzUvduw5+0cKgbVyz
YVcuRF2WFV70QRHJrVmO5rJc2GByAUzFZXHLkrdbXE24wMnhKgjPaKNfa7Pt
ByMuzDZHpST3aaG2fPuqvmt8Hj7IVk7R1URHr9dLFdW54HpB3T3Ff7Jx/7Js
XoQ+BeVVjV8WL1CD19d7Thy7ScFu1RPdx6dUYaZ72OmQqgXqHjOj7W5Uh/7O
rWF/KixwInJxi+ULNQDXfTUcTypGjhRve7lME4SnB0tvR1mgtbPeKM9VFeo7
rmgW7bfEEC8vTfkODWDfk7yQs5SKCnIH9OJTtMFvY+669TQqmkuk6N5o14HN
VCHfzL8W+PIZnylu0YApxaL4SS9LJE4Ov5dVV4OZMVFxbqYl3mmQkbOe1gbl
iCAFT1Eqfgles/W+kjq/DzzJUOdZotTDYY2SYBWYPK6uKHzHEif/OASfeK4D
9FqtueEXLTFC+oBFW6AWVEwkpMZKW+LMYUvf1m+acPfPWjmjr5bo31e9P2JA
AxqT5vun+luhUmF5VU6LKrg8i3CpemuJ+x8Y6bs9U4H3H8o3/Mmn4vcP+4yr
DFVh6dohrZZxSyzTj+v1WqAMpUH7o1ZssUQnxx9Pow20oXH9p4K8TCrKHSj7
ti9cHVYE0I3mR1shobiIVlqtCYU/9eLO/qTiixNHnonuVIMnmeYqUYpWWKFQ
nfesVgNc7/6C6GoKXm516mjnKUOZzNNQo41UfF7P6Ge4L4DxjXmrR72t8HXR
ZTfnFgngNuzzYMlZYe9xfHXwuyL4dkzx9khbYfCD2LYx4i/z5Z8yg3k+akhJ
Khb7vJ0BHjV3Lg2/18QbndtoJgEMaMu8GFx5SRICzzyIXRdGAUZ24M4v82Ug
+2VzU5UUBTzvqxX/S1wAImseL5OlUyBzzdCKA+JCENFQVeMiTIGnUQGhDH9B
eParujcuwRxW2zwY3vptlin8KzEyydUcJonfo9ybc+DvguxD66wsIUM/7nZh
yS9mTFHni+gACvhl+aU/lp1gyvY8/Gl+mALuybe7henPmUkiR5UkTSwg6IBE
fG/nZ2bqyLQcZZwCtnKa4ZV3x5m8HbIz7zstYMrdlNu9+ikzRr7zKCOUP9+g
MT/k2TgzXfWRWICrBZx5uEcycN0U8+vAgLeZJAUuvXlOjuS3N75aFL/nwSEL
KFvZXnP+7Udm+lyJEhcLS3gWtemtQfgT5pGvFiPFDywg/PWS9hUBA0xOUVfM
tXgLKM4PPlqy4COT88z1R2elOXjKmY9QZA3BIlEncPaZEUhYJWaZbTECpeR5
grsLjSBOVbYtqNQABlhNw7GPjOHOV0XDp/8M4aWLsVPBJ0PY7twTYRFgBiZa
m6Uaao2gv0qzRs7LGGZT48+kC5iA48BZ79ozRrBPVEEvONEYSr85svN3GoHz
4nddbedNoEZ0st5L2hAuPu7pMx82Bcfdj1fQ3hvAti2s866vTGB+SaPLy2+G
EDqiPDs3zBSUX0UsWZ23BGwnRffXHTIHs5jixbE6SyCQ6VJQ8twMMgRSn3Yy
lKGljrX0sokZrM0Sop6YUIFa+9wdn9AUIlPt2N+r1OBU9oj0ATkzyF2Y+PBG
qQ4YHxn0yIswg9Tjlf8EzHShJ/FHkJiqGZiHdnJ+J+hCUfOG1F9q5vD+il1i
wBb+eN2dSackzGHPbg+3/AF16O1+sC9DzhzoBre0/HarwGz4vE+POOZgeSsn
0PCTEkg5mq8efWQG/y45Ggalq0HjsguvPWrMQNL1laPIWjVYsOXYPQcPc6gm
j24TlVYEHy9jxc4T5nBE9USr9aQ8VPhjp02SOciL/Gt/vUgBuggp+olvZlCp
JSx5LEkJTlNOehxhm0OBocfowyYNaEftHtEZU+hY61qikOaAMUnz10g782Ay
TfZiWhYX247+ntFbxINY03WjgskOqEzNpHWX8YDuWVJPyyVRdvnmxoNqPKh5
FlBY0MtBD3GJzbYKXGBThKO+X+Zg2971axct4MH79HU9iX0cZONCN5o+Dwoj
GiYq9LkoW3HWPySRB+MpYcpVezhYPefL9lrn/86DV5P/ez4TIke1hRQOPt/l
a/7jDg+qL3f8rDnNwfNBSxzl4vjza1tq6D0cDG3Ksl14mQfXCtIl1jzh4PjZ
W0m8uQ5gJB3xvpC/P4Nl34Jy9/13/pPPQ0tTgyHHGge4rq2UM/Kah0Fh4sHX
Sxyg/d9bsTl7edgX/jz/2yYHmJgb43Ayj4dHOJ+0BQ47wJ1BK7rbMh5ejFtx
Ze/1/9Yr5v6vvqaVcRPZb7jYxy5un2L/J5f4v/NvMmnijrIODwdI2O8f8J/c
nods0bXmvz85wPGboutKdHk476dF5SMZB0jMzbpo/IyLLf3S8VFFDrDZ71aV
rycPKSaXwnfN8EDjffXJ+aNc3J8QX7WJv7+vASLL1xxyQOZSd4MPP3jQUKOy
cmkMgXELbkl/jCPh4XK9UlM+r72Q2C6ZbUbC7/tl5kV8XjvByBF9/owEi8El
oWpNBJpdv1rxRp2EzuFD5f+yCRxfFuh5e5SAHUHLnRsKCczKyPLpP0vAoqTH
qEsnsDns7UauLgkuKnfeel5hoy/j5VnNAgIs7rr9YpSy8ctF7yERDgnPQvWz
Pv9jo+1BjdZvzwmYJ3sJ9KbY+G6/062XPBK8sz8MDnaxseWoiVLIfBLEzOkJ
Po/ZeKbWzupLDQna3uM9vT/Z2BHyLVg5kQTqFZOu3Rls1Fu1xyH3Gwn3ArIu
0fcS+FFx82zULRKC7NS8Cx8RmNBy9IS/KwFF0ttXirgTSHucvzGbj/uBkjBF
fGCjbkPuuWZBDghF7HlpqUrg5fuk4nohDriEHZSxHiZQKZS5UeY0Adq5JWu2
XCNw9blkqRAdAhKfZ10N5PPyMbWk0x9c+LxLfkI/04LASrjFoSMBaRcyntq1
sdEizOJNIY8A28yOTZLJbPRR0H0W9ZcNWvOuOvSok3go99gPreNcOFj1mtSp
J9CiWvCp5WIeHNK9sdpDl42llldNTlSSUJWrNvuGz+sPPN0ocTCXhM16Ds7X
rvHtqRHsFHyYhDPWq3p3bGDhobuhBYIyJAzNrShLeMTC8ync5FceHFiv5yi5
/CQL82cuXlj0lYSygu7jVx+wUI5SkyFr8N/7nn6y/jde7Q/K5rxzY+Orog0p
qWb/xSufp//7lSPUV+gAQoGHyuQ9+PodHan8zs/3uLx5SnOd2DiUFT4y/pIL
wSW1o2bqLPTuyzvyYxUXwDBVMpGv39O0inlzjv7P+41U6/PM2FhgnRuwJIuf
z2ELO7rfUZG1uPNe1BE+LxxVlf/ykoW/H66MehbLg1UPYzKTbfnjI/Vuzozx
wPR99pVXFWy0N/uno9HHA6mL7h0xTXx5mIWUZSkPAi3mPw+/x8bWDLZmZbAD
HEowWX5/LoGPpbr6nBQdQMvJPPNjIRvlm9tcbxo6wPyeTQtvr2LhaP7oBzaV
B+d399dav2Vj9xWrHKadA6yvpBCtSgQeUDp1vszDAXhubobRwlao+XEn1b6f
BVluUo1OLla4p9pScuQaC44ZzGskR9h4v2PJct/h/+pbwv+dP/OKti118yPw
nfC0ztZJHnCfPv595DMLl/+s8nBnOkBL4MUSla0E9i06IZZIOoA9r+TX4xk2
yjaUWvy85gARY/fkNzIJvCEUdniNmgMk826Zf6gl8O1SCZ8L6Q6wVXOoYD8/
/9m/yq7XH+LLJ8zW3wkh8GnN68VWjf/58zsbI7tEWYxBB1h6d8/FRHMCf3eX
JNY0OUBAnnmrbr0N+sgar2LOZULb3WKqeKYNlhny1N7eYYJYR5oz/bE1frzW
12XG50nptYNX7Ots8GC1+rrz+gBBKTabcglbDNsoEXDYF+DeHIFtq2g2KOHj
n+S5ACBGX2X3HiFrNDEB/2uZANoi9cpv4qyxJbdN1ZHPM2s3bJTaZWqDE3QF
0bkZTNgmduKn318bNBCYVHmdDyB8Ysc77xlrTHxanNX2A+AE7+KPP4U2qOl/
KjrkK4A/XUszJd0WT9Yrba/LBXgxlXhy6rMt9lODqCO9/N9Lwg88PG+LY/Gc
ul8cAF5EZ5A7YYPnIm9WvS8HoGZc7tgab4NW1EOrfCTYULhdV7ROwAbPCNSf
3xcMcOescX4PX9/5uglc12SAawbp8iG+1vgwxa9R9TXATtMxn7MXbfGp6Rke
kcaC4Hp/i22BNqi/rG9jZTgLit/2Doy1WmNq5GnXr7cALHt3BZFxdLzTsyRG
eB0LDHVWed7Js0VOYDnhYsWCWzdMQm6vt8GvmdF5X0xZ0LW4MLxilTU6Crwb
OrSNBW0Przdn+TCwzyzm8RYRFjx5Zx5WLmWLrZcjD1/RYUHjRIamTL812gXv
PiPE5/1nSzDh3xFrnJPttFCVL08bPD5ne4M1brNZH5vewYL2lvyX0j8YaOAf
hWGSLCiflA+g/bbG5ccd0D6LBQKuTf1lpA3q6e1b1NbJ/z17e0CpmoFi/gfi
1Tr56T5zcePufzZ42/hY8/A9FoSeP7DKtZGOBb2Bv3LXAYxslWC7yTGQUtPU
ZPGFCeFfbx7L/0dHpe8lP4Fv/0X3hUwOZNlgtnPgvl9XWHB9JCqCMm6F0VrS
4XaqAGtGzFa2cem4U7jKJuI1A/x1gn9VlPPtB3Ln1DcxgCUzv+BnIw1XzHQ7
qqUzYE9WwPKOfhpGhuWNaufSQWEwcAJv0/BAZoECTYEBZ2+mPDoZTUffh4ue
cazp0D/QtfiBKx2VIxvNBdJoQL9yR7umiY4qq07s631Cg0jvmw2VpTTUz4TZ
1UM00PIuvHxVnY7GT6+5K8/S4MngBrHRERquff/DZCCVBi9V/LqY/Pr3fPOj
QBsTFqwXd3+3nMlCteoS1d4xgEf33RabjAHOIWvtTccB6GeeC3jMZWEgffyk
zV4WyFw+/fdqD+Db5dY2vxks2Fn82f3Bc8AHVRJPMzTYcLLs1s5gexbO3KNV
zvnAAisn/3Pj3YD/8ktqi/n27zc/NKeBxsIbV3ZQZfNYcKPg8EWtMTae/HJQ
5M9jNhjeW/96bwILw8brD1JPsqH246xC0loW3o9ZdmrYng0CPbWlr+JZ+LGZ
ekTvBxuWXEjzcjnMwivOr/M+ebJB8dd8odrLLCz0zOLR77EhZH3xJ+9gFg5k
kSUr77JBbOGBYCUFPp57vLogP5KAoKO5O21vcyEqo2L2SowNFt//+mMmkQHn
D7SNbk1jo1xT1skfXjQoIetXveCwUEk1ZuxbgiV4vvz9clEDgR31/lvHZ6mA
ddleviokXptnDbJrzEBK+dl5D34fl/Cf9++HlRVo9zaNe78nUG7D15q5l6zA
zildK7CARPkFpUMvDlhBQZXf8pw1JP6R5I4I3qWCrYnnwO4sEvP3abYvv0yD
xb7mxW18+QmNovIuuhWc5Fx6sS+BRN+Er61j/PHjcTe/m7mR2Fny1l5DlgbP
HxQ9emVH4pvXgnqWdBpIcbZ+n+SPT+39PVHEX2/1xvVUz/sEQrK/1MAyGhgt
/ji9TpqDEnHbByOtafA2Z1/24ikCXTSnX81ppsEv1xP7FSVIvJJ4VGujOI2P
A3TdfC8SWKshtiLiOAMGQqcD/20kMTrlyxejGTrY5j5oCm0hkJOaNqaUQ4fg
ZqcfX7gk9onIGEStpkP4E0m69isCl3hXnDDSoAP1jted1dYkquxOsHaWo0OB
zHWN1/dJ/FLt/yGZpEN88abcw9EkHpewldkixYA/ouLh+1pJfHzryvaEp3QY
kbBrLUnk2yuqj1t3ig6pog8m3zaS2Hwu/9fkDjoIiDvdb/+f76heyDl9ppwO
Q7c7Eo/z40D1/aEXv1cy4MDhbTGJaST+/flMV/ikNTx69MRnlTIHwXM2WtLU
Gl5e/aJ7uJzEwUMbF7MXMuD9jttjx9aR2GPgE9bJ5/ka0ev6meIkjhzLBE0l
GihulHM63kZicAK7PzbJCrLiFCZWTpJ4YFiQeTOTBqJJpmEib0jcmvRNW3ea
BnIQL353MQcD3cvbvW9YQe7g1kq9hwR6WzjKPDjGz1tRn5zj+wjs9BSQu15l
BTv68/2sdhKoU5xpyKqlw86VIVLBc0hE/yYxx0g6WCavFlmxi2/fxQ4y7rU0
kDHp3fP3DIlyRmVunnkMyBm9NWRgxMFN55JZH7usQeHj0bAYGRIvZV4KUeev
ry2dPRS/g4P/TonsE+ri659eN7/JmIN9Q+krLx40h9yf4VPfZwncdfV1UDxL
C9zOGXuI6hPos9TT4/NdGtB+ttBbHLl4IuaTV/R6Gjg/rzkMfJyQsKbngPwc
OjTu273+gz8fB0t1ZRuk0WHL4YzTBpcJPPH3/id1cwZYRlyvYopz0Fl3k9ie
RQyI27Q1p2wjBwta/HG0nAHyZQO/KO9IPBb/xdtQ3xoiXgbdvh/Fxykh/ds7
VK3BhduztUSHxMte6mbuuTQoXfGx0yCRgwslnIx2WtCgLMz9sgZ/PcuV+5q9
FtDhU0H0E8ECAh1J6cZ7YgywM6qrvLGHiz+6a+7oylpD/4pzlPPzOWiy2G+N
dAEDrhiML3auIZCbmbQskO+/kQMO5uKbOPjg1bENGz7SYUlk36HFQxxcJHpw
+YFXDFhYp28xMUag/7IPxnRPBjiGK6u4LiNQ+JBotbo4A2L+rh934fOi1mAT
Q/tOOqy6NfNp83m+fx53zMteTAflAHX3cx0crHK5f+qemDVMXP276V49B43H
nbpv7mbA3VVJeVfyOBiUwMvMLOXr9+7Gxp6DBHZvnt5rlcyAbX1fadMTHLym
UFP9YJgBj1sV0lSCOWg6lvK3fjEDPC/8SGAbcPGmZfe5AH5+7lhJD33L4OLe
FjJ5Md+eEYu/XgkI4GLExF8j+zt0eGYNEgkcLn6dx8kXusmAG3Lp3ffpXLw2
oThu5W0NPioyintkuJhIsnyv1FkDLpYG7cMcVGPTYm/9ZsCuVU73LCc52NjR
4G+83BoamdJVx47z42tNZv1wrjUklHdTjB/z93+7w6QiA8ChubfMLZLPg2rt
N31KtAFD+cdPBPfx/XNtePVdfh9ruWmzR8+IwCNOo1HB09agWRlysyqUiyY7
8oQtN1iD8uqgIx9ucXGVvOV5+RlbUDuzouKJJAeVE+0I3x4aZEdsjH/Rzcbv
ym/0M07RgFEQI2MtSODWub6OksfoYGqzO/W9OIFJEcSRCVU6zElvKc8UJVDj
vHBPqo0lXJ8y6/8hzUYdB7vVRwLMYN2gdNXkGzYuiSHX+awzBYOpum3R19no
lyMfahlmAu7EsMyzc2y8oZNyjadoDrPzL/6d5vPCupMCewdCKGAxo1Ty0pjP
M692S2dusoBQ97yS/QQbq54E/Dw3QYGylR7Gh/+xkBod/nqHMwuki5udnyXb
42LjfWqOMwA/161/Hddmj+VqAaZBO1hwnEF5LKUGuGvi8vJpXwJ4UoVkVLsd
Fpb7/wkPZ0PXiY760mEmaosfvbyIjzPv1Ga74SLAh1mWCyl83phX5VUcOZ+J
IXfDVmXLE1CmsbJHKJmJ9FfXxw4DF/7SDCulp/m4suHSlaNF/PEY1rs3zBaj
miTBuoyAizrKv3OE7TD94BWN8H4Cds35q2BHs8VtTUnEhAgJZPoLjluDHWoW
7dzeHEuCY/QK7wtbbPHhu8HbkwMEHF+ovZfpYIeh6zJ1sq1ImM3bu73YwBbt
882nl/N5LjuoYv7u23Y4/tWu0241Cd1GwaIhWnYYfXvXiJQ/Cfprg6jWbjYI
mCv404yEE7sv7Z1WscGtdXGiSgEkaE0Yu6V1WGNwKcdoZAV//ktPLdV8W4zc
XOrRxCAhmlj/OvyqDfakXU7cEU7CmNC2ALM3Nph2rbpzaIADiXcdFfaP2eD7
5YJvxUdJENuZbvRH0BZtFFwu3Cwn4eSdY6oBC2zR4djg83B9DpwTXbi+OIqB
vq5rz9Hfk7DgcPmN6mEGFt2kT2wYIKH3zBN5Gz6O1tI7PxAAHBBnFWv6uFvj
0P2Ld4+qciDNF66fmWJgyOItkwPeHFhzs8Kh7SkD0x6cY/UVc6BiQ92+sDw6
znfYK+m2lwPWos8OfjRg4NGTE8k9XRzomu2yWOPEQK/XGrxSGgfKnzjXl/jS
cVzPOT50EQcOcTKv00foKKDclDB9iQN/h28cN5Vg4MniNV2igRxYeE5tWOsq
HW868QIUNxAgOxXVsBcpyHv38XfECgJm4fq94D0WmBW9x6a8l4CCeOsAprEl
bv2uraj4iQ0D1KYLn+WNEBdd8pNuIeD5AtHVI7/McSpMo3nxUwLKRRqOzWuk
4Owz+igxQcD6lowYssocK6Kuqnz7SoBI3dy5JesoaCzJ73e+JHgMRTxnSVrg
t9HRJbMUEqaluav6z1Awr0p0oCuChGDTHw0JMRT8NTh/7ikpDrAFRRescrTA
c8qusuXbSJj57LQtZcAc1+6Zk2vQScK7vnuL8pooKGblnLq2moCrBoO75myi
4A6nwfo6vn+myuqFBCXM0B+Ggruvk7Bx1eQ5wQgLfC0RfakujgM2+p90psbM
MeR812leLQk9+emXe+abo0qKqfdkNwkD786rWFAscKnti8oqDQ74OiYPaVpQ
sOHe5Lm/F0jo27Z/6adT5rhGvUnF5i9/flqkYX+8OabM14gVdSahP67qdryU
OW7JepKaMEjCsZNNGuruFFyWwHl3SIED4TYGY04NFDy3wm3B6RscWLd42dQ9
Iwv8/eug/hx+vPha+x9erWCBy5InWuz5+fQElzWLJ5uj/zWjs0bBHEj9uVug
9IIltu6nnP50igNfpDxmDfj2PGkZapzrzIF+ebeKQ3EU9DrVnysbwYH7ii/E
7nRbYKLy2NOaWTZc+6JXta9VGI7F9Cbox3JAd3H69mWBFpgpENf2eDcPfrqe
FlXOouGIgnaG3AMODB7S3BtpRsH4TzMvnV9zYeNizcPLSBqOjR4oOnKZC0ea
1k7JHLbADu3snOQgLni29jzifrTAPUH7z3dReJD0xX7DETka/tIOnvYU4UL3
ZGxUx2YKloQOjuBcLngdEQx/ftoSM/+dunuujgupNLT0m6FiQNbEruJ5XJBl
hYRILDfHsTf0+qWruEDkb+rXMKag0NGc6xc6OPBvN6PPOsAcP3rqSX//ygXd
A5wpzbNWGOH4eIb7hAM+724wb7y3wK09ncvnmHOh5XN8wR+mJQZIKdi8T+HC
29+yP0K0LPD7ZPpphQIO+Aucce9zsETGpqWXJ6c48JK35XFnCBWvL1tv0dzN
5yM7RjhT05b46vGNY/brebBig3d9g68VStVWeN8Y4kDDC9+1ZA8FDUW8TiZw
+PnwoMX8sq4RKjmnbrvOIGC4QOaNrrAxxj5eet6+lIBswvzGohNLcFXnv9qR
Qn79JaVu9cXqY8W9C78dLLkgbTistDDyG/P//3+tpXDSO08zo54FxJkUgVs2
wnDpoNsdi98skBS6Kz8ZLgpnF5TeqDBlg/3atOJTT6QgJL4i/JoLG1b8Uv1e
elEc5q78UbSglwXJei/uq1aKgzXdIY6pyAYfRd/rix7Pg8eDymusPrFAVvuP
06oV0vB7j2nPkxVs4OzxzfUZXwR9Mpa/Rp34z8sOT782Jg8dW67TE/nx2Fxc
1VR+cZzpK/P8t/FJFswNuMs1GVkAD6xWC3qVsSAxZ2ut4qAMBEyYvxWTYYOL
x9RI4z45uDg9+Wq9BQv2X/bddyBEBvYFxgkMHWHDx7mRotwLErBXIHSUvYcF
Q2pL/hyWkAG7rf0/1hIsmGlr9kppmg89Z6zm5NeyoUF80ZOBMhlY2KWQ5SnH
56lC7kRQqjxMXL5MmhG2wHZ7rhgcOx9SXqqk3Ytiwzf29zdhujKwMilLKimW
DX5X3GwitRbBAefkp4pLWfB6ZFen1vW5YLKw1SZlOQs0e69f2bNfGJ6VvrMT
38WCfFLPpMVJDA6wH5TbnbAF4+IzXtaScyBV5mvhw0o2+BptbroXIA/XmLel
BWTZ8CusUD3SRRZSmtNNVq/mwEc9+i0ab5r5cYyuUk7YwDFKubmj+S9mXrtM
5cIiNix/kfw1LHQBlCZq6x8T5MCR7pcjGzWnmE//5DyeUWbD/ovRRqtLFUDw
2SohwVoWnH91eMhp70LwnZU7v/IQG1SDxFiUDgVos49ZriptDzbSX4dOqgvB
sbJXGqLruTBqy5Rbcv0vc8OEyleZ+dbwbsrtbG6/LLzaWzu4/R4JTT33Jx09
fjAPJ+71iKzgwuulkStuv2pnxmbFld16bQNHTIWWaY6Igd47O45AIhfW3leu
rZ96xzx4dod9XB4Jc3kxI3oFc2CLQ45YcC0HikeHs87dlIGZ7QenTl+wA6Gf
p1TlVv5mRr0bHdizxw5GVdiw20kUOlWfngx+YgP/RNZtnJEbZcL26YEBtIaf
DyzeFAwKQcYVud72WC4c+sR8pnL2KzP/2jNWdZ8ddO4mI26HiEBn3pKgxf48
WOWuk/c26BPT+2zZ1W/KLJC4FvHoiNw0c/ppzimHcgA/6d4srkZT43L7uMPG
vgBbKtxl9O1/NKamlSh+jQE4XfjSZS11LkgtTJ1QWs0E9b37j3QIC0HTjdW3
bggBbM+UXdV3bi7QP3guF2xiQm5mxjm1WWFotDhWfMsMQFAvSndRgTCo3/Gt
rAoCWCn0uWhBvDDQN09U778BcNbv/JdokznQOO9+xKdGAG91zpqzUmJwVXfj
XKPDAAv7G308LWSgsFewd1kqQOrIGre0tvkgVnVAPIsCcLmp9fvQJwnYjcuL
ptYD9FMo+57qicOYhdn8hrMAhuJam+9XC0BeQIn3AxuA4bve20wN50Km4JnW
zUfsIMlrfKXDv3HmRMYbs73BAE+KXB0mLW83qm98NH7fiwtvbi3VC/dQw/Bw
sfT1XzhQlzbKvNI53ShL9othAhckT09FWEX+a5SeCtzHWciFOa+n1vlKPmus
anjSsmSYAzX3jOzC2xqY35zF1vmu4cKv7Vb7ofI1k7f1nkiXAhfOJDoyvKxe
MzkuJ6e2/iMh5nWV073P/5h1165/kKdRcSbcZGFygBYM7HaayRGwwlpPXbkK
bW3If5J+dXqUijGrH5+Y+KUJbW/iFWKTqZgxe/GznaQ2vHnn/VbOxAo/p55c
EZK9COTMX4THZlnhftjs4iizCFx/z/t8sJiKd1reaeQOKUD9t/D7WzKpeIw7
slVhnjKYVIemf1hkhde+kMMGsirwe9dp4bePrDBLw/j0CldlWBZUxgktpuEt
/zb5/TFKkEUJd1VYS8O4HN8D0wqKsK3jyeecAE102yM9NnCDz8u8WsvbijRw
wqc3LDKQAUy5uwZZsiJgKNve8MnFAra/MhymGEvA6+SWi/3uFrD3bliIS/p8
CD0tUJr6ngI+Ofcizzx82Pg7znOJOpUCMsrtkecEBxsZG+4Iv7xMgatDH51b
GN8aNaadVrxbTYHVJzdovL75oDHx17KLMYMUUM0s31p9ob8xK1KzPEvfAgw3
aEj+erEU3keaJcRtNYaBsfqf64dN4ZLA5bEfZ0zhrU7uVa3OpYC9qwZN9pvB
+dnaA9wN+rBQ/WG3rJ453DXRX2MOejBpMUepptMMaJ7ey31j9cDzwZPtZ8Io
8DvZbsNMFxc1+kQyFmvy4OXLq0WL1nOxSHyGSP3DhQaJuVuWrObiJ5Ey10IH
Hpis7r9zOJGLzm7vy6YzeNBO/+MofJKLOTMBxr2uPPDJIAJ+ppIY4bGxE1u5
ULn10vrTYySavH0TvaWLCzPcyktTPBIZ52M95/VyoWjhirs/GkiUfEdPXDfG
xw3v8oo0Rkgc6x7y2GDOg0HO6mXVc0nsXf9uYLEUD/IaF69vOkWiiJDuAOcL
D6buaxl56XNw2ihMNE6LBxKHRaabxElUOZZX3J7Dg2ubxWcKV5M46pj4KM2I
BzclrPtvPiHx9904WjJf/xdXZG+gOgeFR8u7Dn7hwpY9c9s9Jgmcfqybs4O/
n6GD772abhD4qn5Znmkg//m339w7Z0lixinf3yEBPJChtJheDyXQU921aynw
4J6HQ2WoB4nhFPeWR+U8sGa7Co5EEdjVnJhfOM6Ffxg+zu4jkJdocaleyQEi
bt1PKi8jsCL5dqAx1wHExY9/JAr4PNlHs+qICF+ea5cW/pJA96HI7+c7eVDJ
b22F2iTu/0JvZ47wYLdmD491lsBdArsjAlp4cH/QnV3yncR4DdjWydfvfFXR
c04GiTu8X9Wcv8oDSrW41sFzJLadvVAkz6+7byfbTqW7kPgzquRT+G4HuPhL
YrR6G4mHbGYP7zvEg9Omb0IXLyEx1OVblTPVAbY1rxNfO4fEsDeymoxDDpDI
a7NNDCbRXn6vu5LJf/dRX/7vfuxUOm1soSeJ5yJyE0Jn/rs/U/y/791Kq3ft
L0skcehBmkOurwP8/Bci9ekXgTVPl7blNDjAVNSo66XLPHTeK5gtwnaA2zdV
TuRwuYiqBfIf/r/799dc3BdWky/6wQF0bvv4tv9gY1lJtYx3IgGXyxkZxjZs
PHtxibAkn3dzt9XbD8xlY+06jwo3cwKiV2l6n2ezUTXW/+S64wTE7tZIWbWP
jTVhSzbccyKAU9cu5mfNH6/mGdLtTIACUcNoDmejkIucvOBRAuKbi9pbWwh0
bsWa2H4uTNzUIoL92CioYfT6gjuflzvxUhuC2EjKuT29y+dhbxTWUFdUsNAj
+5V+E1+eI0jxVSlhIeOry5rlav99TweY/2uf9hOMjsijgFZ1l6RFOf/Jzf7v
flckdt7usKssPKVip8hL48L1Kz6j3vU2GOA6/kbqLxvq9256HujPxkuUzS+m
1/BgdOHbXPm/DNyabSa5tZ0JTeOxjQPNdihR5/IqczMLVtxuvbQrwQ6/3+3T
S5VkwdHMwhu2a+xQ16FEYFUKGzL7gobtZG1RXPhf9ry9LCiqnol9I0HHsOSd
H9/PBzh3TOv74aMM3C4SJ3jRAWD/tsyPY7U0fPJAuma0CsB5vkPzknI6Pqk1
UBr8B3DrXbqDjRCftx+QNLlNY4Fx3oM/fmsZ2MSLuHf7PR8n1aacUJ3HwJfX
5Br9+Dg1bl1fr6kXHclDVddf1gI0bGLWzI7TsHV2ZGfBQhbIK57svn+BhuXH
ZW6ekmfDUdETLr21DPTQv//+VwYLPvfsULDPZiDld9mQ/woWVDotuP69kI7z
ipcOHj0OcPPIKwGBDXR0ndNCWaXNAv0RP7VeMTqythfMGPUChGayN20JpmPa
oxQ9gwEW7KhpKpyVsMaw0cYi0REWhAlrso++p2NPkLPuwCMWBJ2gBHzkjx8M
tK6ty2aByrs4e8snNFSa/p5UiizwppnIn7axRgkzo7Q9pXz732h3sROkowNR
3PZvkgVrj8sanTpLx7HeUsO8TDYo7k2+vm0bHW8ED/qdBTZUPT01qjJMR7fl
JnfYCmzo/G3Y9b2div0pMwvVilnwstl1q0urFRb33XQ8z9dnX7PTLmdnGpLk
wbvjb1lA6ekRqqfQcEd2ukVGFhPaA8canx/i21MhPe2EOID6N/vfXT403FR3
x3zMD8DgSJ7jhWYaxtw0a7OpZEJrcIWOpx0dIzp2i26coMNc++PKd7VoeOJq
2vlnu2ig0hPnY8BfL9+tc+aYJx0GOislT2vTsLdo9qTjFA2EZz6/cTpihf3t
pT9FKmiw+3vKlcBcK/R1XDmiakqHTdaT9NZ8KzRO2D8goEODtyrKzOoUK/wj
omohd8kKun8U2x2MoeLXZM0vKmY0uJ/79tZvaStsNNGuMvxlBaLhF2Vt+ql4
KibdevoqDdS9dSrqqVao8zO2KWQzDc7Fpu2/v8AS5+R4XHx0jQ7vbv0O9h+0
RG78UvrYfDo4ihuUPHSl4s71JnJKVTRILa/r+xxOxdxohegDHnTo9YryWvHG
Egvl2j01uumwrrer9FgvFSmLUp0DG+hwWTphsYk0FUNzo0sa9tJBSg/FN6+h
oszK03PnHGPAWNCDC+mdVGxO7s25socBlnL34zVTqShy4O5PxVEGLDg8vsZM
C5A88+GGJz++HuwvemslxELN+Ec/lCZYsO0LJaXjMRuzpOx2x4oQcPJQ4pKv
SSz0DlE2PCnAhrTC+sq58SyM0a6NvnqdBZbDx0TOP2FhSuX2ou65bPi83Otk
3msWHhKQ1n1483/ud93zaL9ZuGfufuahQyxYnzJm9OIsC5OvTJ9K38eCDU17
BjoXsfBb6mzS1yUEXJA8+WSSX8827FlxR0afAMOHM5U9fizsPNtY7c4iIHP6
fsYCZRbesJH6t5PPm+WVSNtdJiz8t1vog4o/ASe+tib1OTBA9+6u+Cl+ne2w
a/N/MWIJY6OyTH1+H+gbaZIvuUIHceqGCRaNh0er3W1iZ2nA+r5ZpOAgF+/o
0HtDGyyh/3kadwRINNtHK5T7bQWRp0wHDYc5eFVg/dGZeDMw+ENfWuBDYHtv
9GRFhCWIl5yXjJMmkb1WTTl7LRXcvqe++LCHxNeGa85kSlHh+d6MiwuqCIwp
Vnx4+50lbJkwee/K7/OyDlnTexzosFY416DgF4lFxo0eLrpWkD72jC34iERf
ydWHKFf5fpMXe9gbqgKeBkcjFZWtoVbe/cZ0IIlPFHqj9JoZoPzwqyek8XGR
8EHdyh/WIPh9a0RFJMmvq8qH7WOs+Thj85DnURJL461fiXdZQ4JY4s/f7SQW
pJiwhVxtoSKDdXHqJgcHbYReCZXZgNVdseEFt0lc0bpBsE/bBu7/mi96VpKD
hzI//dAasQbHI5v9JHkc7I03WBuWZAMmWxTZMElia8ci05c0G5BNChAwuk5i
kEWaWWEcDYJshzY6vOLg7+GzJ8Xt+XmXtU/tTgkHfU3pQ4GeFnBU499yRz7O
a+bF7to6lw5/sj8PvZnHxe+231yPGDjAcz0l31BredRc1uyTfX8RhKrLtwjx
cdDHp11Sa+VokCgrGrKUwsWJCKV7TgYsqD+57nopX253uyBvLT/uEjQGM/9e
ZmNus9b9AQOAdaP003519nhg6F5j2zWAjhGpjE4DAp8rNI2+4ufd4yHVI5NM
Au8rhq8uz6BDazfTSiiPjScMWqsIHTqcaakN8eCv19L4wqj5phkMHfHNboln
YwwzQLey2Rx2PFgxEPuT/f/2VU3b/85vHPH2l+jbw30m8PRP25ut/Wws3psc
p7LLHk5RjmmJyipD4bLfy1ZR+Xh7P2eJsB2Ba/ZR2t0al8KsimbnHRECd7oc
/5FN0YSUE1R/WS8Ce0RtDqSGW4BO556fXGcS9UYd6CICljDs0XRwzga+v298
mxHP1IdyFx3n7IcE7jF0u+jpy4K7U5fjLyQy8avbrrzqcYA9qpvklv1jok1u
Q/uBa/w8nZiWvtTBxLt2JxKzLVlw2294OnKUiX4ecw4emc+C7v2Plf8cYqLy
8wvJQuUsSD8SO1q4nIm3U7dPpvD7wG1v0X8C7+2xy++IT+VtFoR//vs83R4w
T3+rQ+QQC64tbn7r+IyJ7uWL1Hf4saAnY4bmfAFQVldJlhRhw3LpThPPQEA5
T4kFlGgWaCmyi7b7AK5Ibz5BVWNBUkK0YZ874GDdPLVdJSzIWPLFqDMDcNJ0
W4Y8lQ1PXj+fY0wCLrNNaVgRzAa/5y0LNzUCpoBYzI7N/L62MH7o1kHAxnOP
lv0zYsORpvn6Ty4ByrhmWX4rYUNM2/1DR08Czrounad2gQ0HVgypP18HOLcw
5Jp2FAdSpeQ6JDbaYNTiKKXzz7hgN7C9I+0PA6U4A39kptiQcqm67FYeoEXK
vKE7LWzooqo3WUux0O2dywO9a2zwfxc78bkT8NOZwsUfV5GwLsDI3GSbPb6e
TVhq8p0NEa5PJpjvAA1frxqRVuJCe2zCZRbLFjc29jWvVSOA0l4WZcG3j6zV
Qtm55hz4Rr+268IPWzwlcr1IspKAG3Hn896M2WD0km2rDgIHmso3js8W2aCB
SupV7CMgQdbxerOZPc78/iRV952EBX2cmrGj1vhk/5Hm8QckTE8lx220tsEz
po/LIqkc0L7DMz232AbPVZ5QgIckHJJadqe/zRpbp2scBPQ44JK8KPRlnTV+
9ZKx6F7OhdJh1UvfU20xfJ2OQvcxAiZOPRxcRlrimFXEPAM+zk3q8qnoqbPA
W8XvrJi5JBi+nBPbIWaBH580fOA6kfDRec2k35gF7lyD2hsJDvSa95uQFeYo
7Kj5i8HjwM1qVPO7aYaeN65muFI4sE1fU7icYo6ithnzvkZzILxin1nBSnPc
Dtvn1/0mwWXHtpf/WszQ1dKNuVeZA0LOG0/vcjVDh28q27de4sB75cEnf8EU
peUC3tyy4cCFiaIHQTKm+K1gYnRbHQcujrvKsuLM8O/sa5rmdf7zJUWqRP6Z
4S56s9a9aQ6I8NKFz3aboaSphe3fIyQw7jZZ7XMzw3dHx7333CWhcq1MkedR
M0zel64ZN5+EicA7rdmFZhi4QCmX840Ao90WLt0DpngnpD0gq4eAmCctAlrv
zVA//GZa2DISbG6JNrqkmGHkdagu4vvvzzPva30bzPBBh1uMwl8StJ8vXRzN
tMT0nemtD0O4cGZX3xvwam0U/3K5/l83FwqEaRYv+ml45K8nBp3nQp6w9h6H
cXN0ydSylrfngprvX23bOHPcpmj+0E+cCwOrquQ2zKNiXK/zmy8VHCgXeiHF
mkvF3WZlTewILhQXDLD+HLNC9tNyraNSfHs9OZT4hmGFC5996tu0jAs0c62D
Th+oyJDRI2ddODBo1TmWHE3Fa76+ozImXNgcUSdYz8dZXlW7617s54DleS+z
JlUqvr7ZGSRZxIHoWyXe4jeouLog0ivFnwPrnn73rTCywhDK8T1VNA4UKhbc
DB+koqP+w8lnXSSk3X1ysdSaikl7Xz0894OElOro70WVVJTb7D8mEsYvBFM2
6x2+UXHHho6Y1JskTMrOkze7RsVzf9c6pW8k4USu56NJMSou/VO/RiKChDfG
YzpX9vL3n598/LAmCZHpnwrZ6VQMD5NKqCE5sF9Yy/wWQcOzrlVRSoMcUC4w
hAfVVqgnSry7dp+AdwETV6slqLhPmzmgxORAn/k3cLzCl/eFjZmncgBZKl+P
fLFC1/3+L3348z3GfHWdFlrhSJ9phNotAv6+Ky3+lmqJWzX9pTKy+fn7eOJh
OR8n5woKrosJ4YDNYOOWs0Z0bA071FzKj9f2o72H7LpoeOGtWHnHUxLCVisU
7d1Fw1oxZ/z1hYTCVObQFlk6sqnn37yR5sCxzWExlZH/D1dvHk5V2L0Bk0yZ
MmTITObMwzGcYZ19JlIiigqpRKEUyhiZSoaKSERp1KQilCFnGRooUig0oyhF
kVTCd97veq/3d33fX+c617OfvZ619lrrvu9nn70PCd08ix5tHWNC9t8YSuZz
G7yx3jfhch0TfFneU0vW2KCHjqsPV5fXf+zEpaIDbHBg2cYYU17/u6oT+Zbk
S8LLR5yK+TtZ4FHA/6TThYQj/m9YOXeYIOf1rq+9j4RdA4Z/pNOZ8EF9LnDV
NhI6jsdyTDJ512ek77AXT0dkqOibSDozIfhrp/aNqyTsjZ7neFHYwH20X0qZ
RsIod4MPUupsEH76sr+q3wb5F7suo9QzQURvwWkhERLW/tNleToxoQ68Lt5M
4sWvUl1ThcwE75yJU0nCNpgsFnV74AsNVLcI7ZMSXAynw3O6LuYxQfG788DS
y39p3DzTUqV1POpSMFbHpS2BLKE9TtkHAASl9hVv2TvD3bXucW0dCcBnf2NN
5vww1+Dwcpr4UhpErxe9riUyxx3yz587/Z4GFv4pvUmy01zHjcn67ToACw9w
7C08JrmTIg9aTY0B2DUlOuc7/3H3hFq6xzXQ4It8vv7ICB9eCiLd1zlIg9qD
ny13Hp7hOrEfKAZq0CBc5fHrjDWj3Hse9R4LdGgQpqETbMsvhBdUNVK3qAOQ
s37E9YsIoYlK4GSNEsCa2hUWkbJiqNax0P3HAxrQ5g49k/0pjoXayvfkVtOg
c9fLyvnQBbhr6UL2eDkNnF6rn1AqFETJ6szX4ek8nVY8evVJkCi6pbCZc+4A
UYFZ+UMuwjif9fjwT1MAA+3HoUtWLMABh6qOvyVUmFss1bPj9mJI/Z3ppcWg
wpN9TknHDvyhqXxwsZVU58A0jUh6PymHIfsUU1/6s+G9Tv39HR7TXHqZ3acM
GzZUqlU9fdQ1z+1+Zru09D4b0s+IPe+aneJ+XaLlSP3Mgo+CRFGd7xfuedvt
ivM9LPjHfMVNnnnBnVoZ8eejFRsKnq454/16hLtrx8Md75qsMWP7xzsv6dpw
YB1L5BDFBoWNrKeG7mlDtEe+V0KNDU68TK1Yc1IHQtx+Kr7dZINvIjnfhlu1
wCFo7WU+bxs88EhDXuzJMhD0anmqxG+DYYfmqfs26IKzoa/f6F9rtP5iX63p
rwPShidCPNJt0KZvtaZ9syJ0558XuR5BwmKn3U5/m1RhVuT2HxNFdSxJFFx8
lKczjjvfq3nmr4lXvgw9qBizhZWnNy7nq9REsTPV1f1KPP1a+mtanCMIqxTF
CgWeW0DVjQCP89tNoHz+Qi3TwBQyGEXiDtoG0PC9tcnxkRm4JRyIqn2nDwZ9
y0Tzrc1g2iV0++VtOqClbi+qX2cOn7ZUH+vqYaPuMlHHoMscGLEn+5jMsbG6
9PwGWiIHCgtLxJqK2Lhm8uiK8WkOzGTxLRr+wMb7cwSpf5YD235w3GemmZhn
pGLqlMeG+28c94UZstCx9cqn/PscePYxU/QahYnnIwyqttx1hJUssRMP89lY
GtWi/iPUEbg7jbv5z7KxSf9YC8nKEbI9NCpe9NFRmjb8encxA1ao8wmaXiaw
rbXi5f73DNB2/db6eoiOUT1Viv8OMMFpbI/EodN0/Juu1CBwjgljCSmn/Hzp
+GliXkQhkAmjbs4SWsl0PGN24elteyYEWLsdinlDRyPlC7ut3jJgcaw0Ecmb
b0BV9RKeYcCN8AdBcyfpaHeO7/ODUwzYkObx8YEXHWct02oun2AAfzxjrTqb
joGXifaJLgY8ufC4QbkBcCAr9GmJPhNm9x+3b1xER9HN8YShOI9H9DeojfP0
69s5zW8LNjGg2/7+hYmHgL1l+56UtzOA3lzlGMNPx5vftL8UbWdCVmSw86A/
HSMein0jeHk7c0O/rH4DHS06tj+y+8ICDR9h0Q/TPJ7ZZLzs7xEW+KR0H0mw
oWNVXue11TdYMPJp4XZLezr6eghWXPfi9f1NpwO+/wA8TKU8XvL5v/t33sT/
9u8mT5dnrd5Bx5k3XG/LCBY4F2o1SvnQcdHM6y4PFRakLzq866Itz/5rUeE9
jUwIt/C58GUQcLNIZe0PHo/6Wj72RUyXjus71cV2L2SD8dpLkoZHAOVy18gR
VSx4erJa2robsDF/0VuRzf99PuQIgWIXg7ZXfnWE7adWdn7k6fUPf9VfO55h
wr5V/yyDHgOe8Eisca5hgeniRUmT1YAdsT1lbB7uNy8z/uZ2kOf/+nNT8vxs
yNzR3KmkRCD54kI979UcmGrQ9l63hUD7zBvLjzZwYPw8d0P8KgI77u1y1d7t
CFYx/orntGm4e6C7N7qRBY7TBSG9MQRaOu2qr5jhQGRjpsbkN0CMwvhGPR4v
QWXhy14Ezg96zX194Ai7M6maJ3nXfz1L5tfGYxxQmS5TEHlJR0flhWWOdA4U
ldtqK8yQsVt0fFZLlYD4hpSKhxkEWqnuHm/Y5Ajxi7QvG5wDVHRflR15jQ78
JfU/aDEUHCYL9Hzg6Qq50h8W7yLoWPH74PeaXRz4tUifzP+AjoXnMmOtX3Lg
vGbo3fumgHeSJ6KmkBefCX5u4VECe++/SNa64wir00L9jSPpeFujzjPmPRsM
djwV/s/7ezTldj07IcCBe8s8X84f4+X/Hqme9BIOKOWApi+Ph/FVPAqSVSNg
b6znUr4JMopJdryN9ePpHHMFp7uvyZh57py1aREB0jkllNsZJJT1eyA29B3g
QHKhcfpxOoau3PxoF5UDL72aP+Yn2+MCLbfAcxIEVDy9uHCNoANWKD66k8SL
B3n/95bsMjJaBl+ZXfsfXbdbR7S+kVevavvIyb/YQP70I7vD3x4zO/4MSx6n
wbdZf+lrP+zQU0FStJmHSyuneyddO+2QfMZN37qRCtuYXmU399vhniviE082
UcFdJy1VP9kOKR8fBmfycEvsEzUld5s9JryKUXYWA/ib4Rd2Usge38pop++3
BcgdWG2zTIeCjGBx36f+dHANNwqPVqSgkkRvyl49OhTsWRrYoEPFlTb0txWa
dEiQFbaZFqJh+x9DZ7xAh2c/O+7+SqBi5QFVrdFpAMMZk5XDrVQsUI7vll1F
hyUH8l+lOFOxa6br+SqejtYS9RGtkKGi5eKMVSWjdNgrtaL2ugQVpZqXyYic
p8Pb6KVV2W4UfFE69/k/+6W+YeJ7Aw5TcXnCxksO9+mgHnXpb2k+BQ9f5Ix6
F/Lyx3SusduQhu+1rz9ckkzA0lezGZUGNOQWZ6ZSZAlev9g2mDZJxX+JOaGD
b+kw5fwqdH8xDVf9SdBX7qaDitE/vY8yFFT5JJajWUSHX/f3nUpXAXT9Jaov
7EuHIu87pttFAC+c3vBv50U67HwSrMAJAByKpzxP5uXvmsBvW6Myabj2Y8IP
+xA6aB8VOaAYQUNanMxA8lk6BATpPb7VRsPnGete/VCmg2ezabG5Og0vtpaQ
Nofy5v9+aaZmDFh7YN8neUU6CCfijpNbefntMu4/7kSHbayeP5PhNPwTmqT6
9RtAWSx4H+DQsOS9cO9qEzqcN9drsYwFPBS26KtKDB1emqZ67K2ioEVZd57T
K4A+b5vrqSlkrIq+8vmfLa++CtU3sk/Y4iKrAiiQBXDoPrMiT9kOhX5s3TRi
BpDsVnchzNgOLz/81N+0F2BGoX5HXYYdnuntMuwrAPggGb1CS46EtI8md1oW
0KHJOTzA6Lo9Jg4ktjisJiD8n15r+xte17hx/EJ8EB1eqHh/zbIlIfxIzTx2
kA5RIvpJh3j4f9X67NI2Wzq89pmLs9hrg3+Um+bVdtOBYbZ2T++IDQ41Vq/M
Z9NBbVfMUBOLpwPO/aqUlaHD/JLBPsEnNhj1zb9+KocOcxJ+m1oreLx3Uj5d
Kp2AjjGnzefqbfCh479LGkEApTqazJO9Vpgjffy6UT8N4t5wMzafs8a8rw3v
0tcAdCkkO4fq22D5jnciCeEA+fVlZ75b2OCgt/RlIzkAmsJf9zfx1uiN5QOr
HgP8+/aONTVhjdxPpL/JNwAmfcgrP/J0HZcaIVNhA1BYLTBJKbJBoaG8VbF3
aWC1ouhh9C1rPOqj0y3MpIG9Z772cZ5uMUgSnCPO0eCfr8E7j902ePHF9uUu
yjQ4G8byiI2zxntnrTkZ72gQWm83q3PKBmWKXbIe7qdCZNf91Vm61jjV8rCb
ZASAXQ+WxWy3xFvrgkp7MwBGGPdVaWLWmOS0fFA1FYDE3rlZdiEJo1erRW/e
zOOhURu/aETZYKvkqUdlC6nQDL+eCT+xxk4321mjSCrYrThhc9vcBjmsBtXb
VVTorPoUTCiQsKqEseQrz99gY++n86K2GFL13EM/BGBq25JLNXUkjN1sFaVN
Bfj1926ZtA8J32YEjPuKk+CXj1dSPtMKPx1/WdvYYAdhhR86tzPoqB9Cueox
RYBOy3r3W1OAlMvc+H+vCbjVVVvb+4WHdzfh7M79BPhprrkhzgV8m+9+pa2C
gIlLDfU0A8Cozc9UZc8ScN03SEs6DLCQb9+y9DoCGizoOpd4+HvGVbnl1yYC
+I1J8T5LAHX49upZODGg58FOtXAfwNSLhpRXSQScYc2ub3QC1NT5tvqnBQHu
UQtTfTwAc9KN/BkSDFj0vI1tnwV4e0ykdESegA+DLpYfX9AwYJ2vvqIdAesa
PrvZz9BwfMvTBN0fBET4djXt3g/42Snie0okA35GNC2q7gGU8Jy2Sw5hgLpf
wuNHr2kYZ+1OuslPwG47Tb/pNYBPiCnRdysYEJFfnq2VBziFdw6H2/D42M7h
YzU8/qCzYs6MfxkDht95KvrdAHSZ+vgm8SQDyk0Ob5BeD3jt+OlKxgADJErO
yGQPAe6T21xkUsKAnAclLj+07SBo1Yaxs8IEJvndeZXfYgsLTbiXzpEJbNl7
5+lspz2cnV54Zb8egfqVP/Ri2JbwUz8kb90BBl5sjpAU3KQKv1aeTV6Tx8Ce
nRlFzw5YgWh28a2gc0xklZD8G+RtYaRGJ3V9MQeb01Se+ORag/afnB+VH5j4
tjKIKx5lCS5pRwp+NzOwJsvQZHqUDfwuQ5MpLx1w2mq/mO+MJVzWWvMoM5WB
od+/6UqNKMGnB0lE9WMGljgdV30QagX+J44JMXjj3noLpDZ42MBKQ2ZGPbCQ
2DD4eZ0ZHd5LvrrPuKACudwypxlVc0h+Z5Y/Z8fEsQU+SVnp9qCxeUkOT6rh
iS7d5Z0sMpxi2306PsFEQibh8QU9B8jmJoyKE2wsE2kvpo3ZgZf4LGWzAAfL
ex6c/JNLQNSwzL+PMUth67/XVkXj+tAXmvThzEcCaxwtAmrpttDXO6AsrsHB
KxJ/q04d5MXX6mHivgY2us/qvznDq5ONtxK1dwcysa/jhNDDGgBfruxGuY8M
rDjctGBziS34LNA332bhiD8qW43jSGyo6PiYz8p0wMqKo+8VT9nDwVT2juvD
bOTsTJy8r2wHV3ffrrPoIzCn7e56Q2k72DYeK1hQRKCR2PqaHTwdBReObjF/
QWCGUKAc36Qd/NhodNTvN48HvnSxq56ygx6m3eUgKgObOYd0cxId4P78811Z
Cgy892DP+9ZKe/gx+e1ZmhIDCwLt2Cdy7UCGbD7O/5x3vkitm4XvzGDLvPz+
ZA8CBYKFD+uamcGVBMuvtzYTeOXy1+NDBaZguVrVen0sgSXGrpUWpywgYefe
QxvrCRyN2GRPqTWHf55l+UW89T5RIsrcNcxh8a5D0+rPCMT5i3nGmTZgLfpy
zlaOjTlXnko68PS5guGHow21gEKWxzWe3GRCS7bB+eVvqbgs0OgEYcerU2Ur
YtwC0AcLMo4UsWDW/vbxbm8yitberB7k1eWO+wYLc4rpvL6YE7hagwEerwXm
LXwJfNq4N/huAQN8Dj3GtLn/u6///34ggWPUOaz5z/8Zx9T2Vhyloq9kc1Kl
PwNe3Pv1ffYB4I7FVi5bljDhQYvMzIgkz1/tG83PqlnwuPnZCnN+B7QaG1Vz
XcCCa4xVBwwOOCDDf0vGJLBBmqbQG2Rrjx0akZKWrxlQNEKqrt1riXdHuf6v
FZjg+p1zc6eaJRoL9QieVmKCOIs9GlJiiX8jS7kVe5iQxJ/sWnbIEpOPPoxp
TmFCxM9D+xw6zdC18c1gQhgTnszvWN592xjRLv7ZNyYLhqLO2kaYWeHlPQ6c
axQWlG6I/6l91RLDJ1lRul+Z8HX+3d1t9yzxX8GFSPE0AiRs3C/81ZSD00tW
uwvqM4BqtIwxf1wY1jje9bjDzwDS8vKCBe1LIOW0uHoFr29fOzf/KrJcFlgO
Rjfel1Hgx5zJ4TrfJZAU8ZGv+7ED1N/o/5D/Sg4k0o+6ak2yIf1Npv8rpUFa
k5xp47tTbFDNOfb9n/cH7tUGExH1dhb8SlMcng7/QfukWPn0MDDg0AFW7yoz
BRg3lR1eYEeBtiMvYo98XQLOJcwmRhcBsvkdUj/tFUDScBZckAylp5v3nuyR
BfnksnJmHRuamuxV8uKHaexR8Y6zH8iwZVWl17r3EiBlPPmLtocM5nfqmF/s
pGCF97Txxz4yLFLfdeM7QwEiF2apnnpOhtYk07jTDCXwN9vtfpTjAGP6QUFF
O2QhIDDv/WqmA/zUY7TTbJdA85+QhLhXFIimdAwPaStATb+Q1jUeL/w72hf5
Tk4DPi1tPfYniQ0yS0T5kk9ZodVK0fTWRWz4dRTfGw5bYv9pj3oFnv+7+Kp9
Moqs8JXAJeKYNBP2/rsy+mTOCvOT4509yUzov/UpKirJCqXepzU0n2aCu6zW
r09hVnhuseTMwhNMkH24T7VmwhJn3k3qa/LyR4hUfaVzmRXmPR6K92xlgPeV
+pnLXGtclZhUtfIrAyzTIg1Xb+HxHMHZc5YZDJCWCTq2I8QaiajpkKuHGVAn
M89+OmmFD8e+qjrvYwDfy9onre+tce539LL9DxjgVHOsJ5qnozw5ccZqV1lQ
mFA+8W+LDR4YsLV+TrBhRcMOz3t7bdHqyzv6id8s2GC9jC/2Hwk1d8s+st1p
D6NTx7WGA0Xgmkmnalw2C+aFbRzGPf/SZh/nSLjeJ0MR04nTmvyTdrntRC+/
KQeWJgutoHq8o62XtPU97cEC/28VS7RThMB9YhexRpkMlETqqU+3p2iPkzf1
rXamwEzVuoLOMinYIL62t02aDE0K8T5Wd9/RFvCpc+56kyFE09/qjds3mtgf
+8H/6Gx/+zMbqcQiIEX0jPBH0KC76PO1v9ck4HXMmEOwJg1oasfEromKQEyh
8NSva1QYpDl+mC6cpW1msGW3tVLhkH5QRvSL77TUCtbtVJ4O3ag5ei9mRhaX
BJe1rtRmg8QW9/osNTl8s/+C0awXG87marZuPCKBlWlSVq94+Bj+zvv0Kx9p
nB4rXjF3lg26agYGGfKyqDBFUV+nxgE+gb/JkxsXYcWbnv2/i3n9pCbC46a6
NE52KIv+Z9+kYCSZ7b5VA983HWcyqtnQ9eij4xOuyv+3v/GJYtlSyx1iPN2q
VZO7ZpWGLGptWDD2dTcbNDUCvylmqePMQPgvHxlHWKkwrioxoIRnjE8sePCY
DY7d9Zt2SirinQNrRezEOHDa8GVd8y1JTHh5K3qbMwci8xoJIZDE5zrNuf4i
vPHfLj53n8ngr2OSf5hLOLBY50WMaso1moPOtjvhhTa4ZpXuAqsJXRiIv+Rf
sJiEScI5LcpBuiC3bnDrMg9bLHR4+3iZkS6seFVizq0iocm/c7KCx3ShPWPl
FhdPW8Tyw/h+iz44UV8mrueNKxfW9V7ZsQy8On4Ub1xNwg+F0o2XXXXgn5ne
NYahLZ6vFHn8l6MHhd2iGWtreXrmmBhT0kgfgus7z25uscXHL5K4pxP14GnO
wZ3LPpCww8GGeidOBwwn/65L0yWhesyhwDn7ZXBr/e8SN4KEoS/5Gg326MOx
w2ePiqraobQ5Y+J1tC5oV1uHrbxli888fIWWlerCN31jfe4Ra3zzj3Ur8oku
rGlJedz02wafhupcSE1VgV0zVbd/oA1KRh2IDeRXh42Mh883RJKQ0+46kn1M
GSqFrvpK/bXFbSOXp7c+VIHmHZqJh8AWm3zrQ9i8cb0zxK11mzWwU5r/cqOI
LbRsXn9QhqKBeSKbFEZDSWAq3N+xwVwdyc6xzoYPSbD0rnq5YKoxuMUI1Gd9
NoEfpnfMxjVMIXXohY7MPmPwgKjstXwm8LZy6xk2dTn06Z3/fETZGJxk2lfq
KyyHg3mNz3VDTWBAfCE3ZcYMJoMafHvceXF+pMJVXGkOPhdKDnxJ0IU+B5XM
b7nm4En1bFq/QQ+8GdE6/AEWEO33ud3JXA+GZE6ZXx01h8tqkdHaAbow9lom
t9DBAlYIrvBjP9aGlrYk50kjCzCzLf469lIbfi9q5hw8YQ7xu7la+WnLgO3Z
8V7lozlo2+diiwsb8yiRp6/0cOCMt8GEpAcLXQQcT3se54B3IVXCncdLT8w/
5iv5yIG26O0MAS4TA0JWPfEydIQsAX5ztUkmnpG1f8aX89/fN1b+3/uUmvmK
xQceMLHfSfeEa6AjLE75Op1qysKWc/pLrlg5Qv73uudnFFh4sFo7eOkcB4Kb
NvXu3MLC816LJPtm//v7y1oGHm7QLTB+6QjrvRpDfp9j4/1tLTOv7//XHpP9
P3tf7Sj2v/bT8czVzi8q7QwwY2e/+jgHOPmljDTYwwDjJO0/NFM6zrl/WZFC
ZcL4YcGs1zz90dqlvqeOx5Mw1ik8yoyO9dZntf+kMaFNLepGrhIdJ/z760p4
vOTYycKHdY8AX3Td7G57y4TbKhm6H3h6rMG2sbLxGhOsCPUSl7s8/dNspZwZ
z4Q4i7yzZsmAaXtVVnn95Z3/ntGGtytpWEp/LF48xAQt30O126QAO/nXfovV
ZcEfYtNTjiugqNm6NQ1aLFjBil0rZgRoHH62JuwZE7TxW4WuFaD4t1/EjlAW
RFsvNDuvz9NPSsaq0x48e4N1X1fw9FYc+fGJm6NM4OYFirL7aCgqXP5qay4T
nK+GtwuepWFT9h+x4XCevX2bhX4m03Cx0BqN9YYs2H1PxrvagIrfDTY/DWKz
IG32+lD7IBXPutXu3uLHgul9l4I/bwD8pkfmbClkweAJ1dZWOuB68r6tDTlM
kD7sskh2L+DA6xDxV+uZkGZ2oeLpcypK7vU7psvjbaMnZgZ+CgBqnd41XZ3H
gmaFXy/W8AOGvdfxWrWRBbnde5Xs4gFz28U2n1dkwsGltAZODA1LPq908zFi
gsvNNtnGbhoKGWs81F/HhK3c5faeagQOj66z7tFyhKjya7sM5MmIBIc+vIiA
nZbjBifSyOhSIv7w9UMCxNnCRVrjNrx8KlAONiTgvpVMQsc2KyRPPV7fpEzA
u8/xy4SXW+MDhQtr74zTwcv7RVzPeRvU8TTWqRoFOP2yJmt1tzVqBb3327aG
DmGHZLLv3rHGoN7xpGJxOhyTcUyNMbVC0W7dc9oOdBiduRRJG7XCFUb8Euz/
7MeodgZfWmyN1otOnCLH0GENV4xjnGKNKk/HtMTi6JDHjZg387BGjyJ3zhsy
HQITt8t/WG6LNy8sGbkaRcB5WXXlxiZrHLn4Z8hBBUD02oMXhbz5o33pRouO
AJwnvwtV0rLGR3lZ+d0PKeCuWfbu5WYrLHx56KirsR38SfjUmPDQCkfH3NRD
suzg6I+SZ7LNVrjBxcNM1NEe6v5kXrm90Borv74q4XtqDwdCEwvrDSxxlX1A
QuIWB/hd2CcYttIK970oeLqsxQGOqn70TeSdr+zUpcznfg7Qu2RV9pLflniq
1G5RzRt7WPWzjS6y3wrZLo3/Dt2zB1mvcyZpylY4bRP+Zv8qe9hbI/hQXZXH
00MIrsgdO6i60i7x6qYllraFb6N+sIPcns6iFh7P3uetILSAYgcHa5I7KiSt
8UtTWsE3GzIUSt3yi3WywpkeS+I44QAOFxIUPOossTJYeYsIb71VHPOmLeGW
6DU37/B8OxlSruzR/xZmiVEyJfIRrxzgU49GhW2EBe5WdCNPa5Gh+1L/VOSI
Jap3bc5p1CSD6QS8i5u1QMcjAuKpvPEjxgdtGmd48/Mt3JJ5PCve43RVXJQV
pj5Pi93kSYbzRTmVl2sscDiheIKzlAInboRzR3nzg7Npd9pLyVBfS79TvtMS
DYK9zMRsKSAjlLnM2NQSR0QGA0Iy7eHwguV/zHjrG06NzSL/sYePGXqtn65Y
YhlFyVE03h7c2ocNz9ZbIHvHuXAxwhbc7uq+0NG3xoCf+WeP33GAxHN75l+5
8HhxqtZ3RzV7EI6kHm/ZYIkCzPVt9mdtYfn3V6zrBdaYp/WkdviqAwQolDhX
GNExYGlH674wAtD7K/OsLB3DlaYX7bEmoPcW2VvuPmD49MkFJR4EpOQV2Pr4
AV5uCI0N/kKHfqVkKVk/Gv6h9v0Tcibg6sawLePNNLx2eluvfCoBhitlMx+G
01Cg3np05BGv/qKNb6g5UfHkq4G30V8IuK68pzSph4oZxaZjHfcJ6P523M+e
RcWPpfP0m9t5x9/eaVIpQcO3e9fuVXNjQPW1efdTN6goyo502pTO013yvabr
uVTc4Tfh4MAgwFn4roh7OhVVPlA5gsIEGJ1qbDJrpWK/QphMuhQD1mTSlweK
UvHugVKmbzAD2vgCOjt8aBhw7UfjXhkGaDBDtb4nUzHQ75mljzMDTE+Q1r0o
ouHRLObi+jUMmP4SZ9x2kIoax4763zvJAIHznzpvu9Hws+I5258lDKj6FHrs
YRQFd+1V2OHE0yHlUrbNL8epyKfMCDt3kAH0pbby63n2dM1if7R9YkCUJ/9k
wELAuNsP3qf8ZkDEfaGzhkupuPHKrHPrIAO4d263adsDWlAtOx/y+qHnVOfg
n6WA2noN2bbnePZ+xQYb8uLt99yndwuXASzdhEY1T0Bq90lhkUu89f0xiglT
BVxQWnexbjMBzCkXg1IefiRu7yeRXhFw02PceZGIPbD6YzqyFQmMP/y63Y3f
Ckz+mlw80cbAhGdvrL0Xm4NZyfQsaykLx6MLLo1ocOB4heeKY+kqaPlJvO/+
OVU4a9jwWXCagRtSd+0clFcBtSLPvrB6Br49p/umdRUNDrRWexevUAAabcLo
6jUCzO82xS3vVoSs0ctDLYvsYS5hbyMnRwAum15Nlf5Kg/PlEZI3NJfAuVeq
znKzFNhPUQroNlYBl2XihVqWVAi3KThCQw242he8p4GXh4x0HdNoPXWgcjc0
mXCosO1f89PTporwhev+5mcfDdKXnhd8JKgEaZckzWzOU+HIqarsHxZaQFLJ
fdc+S4UvST/CKCRlaFj6/ekPJxqsZ5J3OnGUYO9dPpHihzx/w3/lM3rlcJum
XgBHmwOBXKJyJlsJU/60vaTG0qD2wOg8v5QcdGvFTF0mGBB9dIhs9EsDfKw/
5b5Yx+PvSmJ5J4bU8LWwb5bnERr4H1er9P+5FGCLIv8HWzbcvfXaSJR/EZx/
M5h/ydMehta/93PfKwt397n1OTqrgJbRzhrJtQx8oZeweMFrS5Bc8FWm8gsT
DR453sk0tYDbTSUTnT5MVIrnD3n42AYorKruzCA2Ltcds/mXYgF3hkes1h9k
4j1CJTQxhw5rn/xJiTRnYEu5eFq9mi24fEu+I2TjiDHXOn/mB9lCDYe7jx7H
xtKwWR1emwbbf6+sVscx8MhKPQfTB7bwWVi2bvgWB+V1nCXyE8igJhCwciKR
hXJyoZJvzthBb6hJQMQzNs7It58h2uhwZeb26N1NBC7ckQc/PpJh2ekGXcvd
LPwQauo/WUCC16d+fNF14aCy81O7dZp2cNPv1HCnoSMuVS2/aj4A0LVj9ZG2
EgYe/NL46tVmOiw0m9TvVODxQu2kN8VddNCdzNovrcnA93VbrkTO0uHTgiO/
wwgCB/ze2wkJEZD5NkQorZ/A4NrlTF8XAKprZPBWoGF2zermrqN0WOm7uf/O
dgIjml/pXc+lQWhpZsbtfQSOLilOOcuxgV/Ll5eV5XJQWnyk/QTSQF7n11zP
DKDDXjfL/VYA+ucuuPROEXhXblUi/1EC1jimt1XOE+gebfZ9oTEBsm6zl31P
Erhc5AVf6SMqZLZN6/znuZs6L19KUwkBQf1XgnyzCVSzbno185YGwuC4OXaS
wIb5OK0X2wgQSqGPRSYTeHFcUeiJCwG79O45e74hcG9t12FpXhrZTRzw7PKk
4cUPjp+z1B0gNnVvafphBn7Zk5VfIu8AQ1Sh8slzBN6u4z8e/t0CjPZ8TbqW
RuDaUpGtS0MsIFPDyCdlP4GXWtr6+ivM4cWZKCuTAALbMhkGscoWQN/x4HjM
QwLrXdm7TzSYgTbJgu95HYHnSP25Gc/M4PJQXWWnGANHelsHS9PNoaG0fIH/
EwKNlKUnljmYQ19WjbNmDoEmg3Xp/8jWQB/oHGRXMDG02dXcZY05vK81uDIo
zECOeuO98iiA0s9x9N49gGrDk19rY1mwSEY+2brdHjPHPm/N0ef1vZRDLwXa
6PgujOO6pZYF40fepDgesMcC2rNj+b0seGZWts421AHzW6N+Lp9kwaXtUX+b
Jexxj7vEJqf9LJgZ+HAvwN0eK8ZW3n77jA5F3+bleySVwJ//t5R8EAc6BN8L
uC+zRxSkOkqXsqAg9+fC/DYHpIQFlFrWMGDlMY8TwRqW+HzPXpfL9xhgxN3i
QOqyxEu/Jt708zHhs3lL0GdFE3xr/THf+wQTrp4Vtt6lZ4rtw08VLqawwZl5
2+LZOgtcofrheaMsFRJvk3LWu8lBR4CdTzWNDThl7fS3N5X7O6W0Z68dCxIj
wly9ls/ROswaSc0+FGgpM1uQkiQLH2JqyiwfsWHo/OZ4IvI3jT9nV8zYIAGs
nWuaDC2VQDF/VWgjEnDl1F7voA5BmF08b+3Qz4KsQZ+Z9ft4vMtQ3uK8ERu+
/Fo9f+m5BV6NvB2SWcmG4qsdY/V3bFBcT79zoS8bUqvcjQN5vOL1ovQdP26z
YIxuq+PZQ8YDYtlncs+y4YNbqO00j/cUij3SCxRgw7wGIaf3xvz/tz9sge9/
C/5ZsZgNPx0el8fxeM6fzh5iYxobFukrNakUkZCu7upYxvuuUW2Q8mmdNf7J
yCMnHGHDi9MLTM/LkPCSjfs+MsGGrj+bQ7pekLCpQHF253E27Pj4NCyZYYtF
pdjslcOGRznHRnd42eHeY+0fauLYENdeNlbcbosmY6yatuVsGHlD0CX07dDz
3JnF7b/YYCGQ1X7wKW/+oW2NIzVseBnI8lh7xRZz9sxM0A3YsEqqYZBRaYch
s8tYYTvZsDX9pNt4ux3m2le7tKsxAC5vGm+TJXCLyS96dTETRJj/IoQmrfCD
ppzRqX4mWKQct0i/bYXhio4jAXosOHrdT06UN550UNrfQYUFNz7+Xee/xRq7
PZ59zeKyQHaSz1vO2BbXGFo2/f7F052Jbr8dTtni5O85ybV/WSBCfLG5KGiH
251jY/tE2MDJ/ZkYm8yLxyHBZ1ReP3KPXS6/WFAazAe+YIgXGfwKhz+IfvxH
01asWx6X4QCOzvUCdqT7XCAl9qS40WB51NQUf500kG+0xdKa7WF2Reaup6uF
oCmdfWZvlx0M7VgnqKIrDgtp+4OeLLWDVIZmfYuvLFyTY/FZbqWC262rQm3M
hXAzz/qwsDwLqH3XBVyvLwRt7rrdv2fJMFvtpLK3eo6md+qeetcGB4gujY9M
nOCHiOSwwYcKDNg6rMPlvyED8aKZJVE8HqvfKWQq/VMGqqYPartY8PJbQSRH
/8BvWv+bweXFZAdgr0Dq0wXdtNHR/aa3Sh1g5tbDp0SlPNyjpba84+mO2hCB
K137FwFjrSn4vWJCtMtOf0ErAciS4abvyrcD04Gio6vnF4NW5/iNqgkHGGzs
MwknBMBoYtM/v+UOMCt1aFE0SRiKfrj91W1zgIuZs96WKA6rCrth42F7IGzV
P66JlYZD+bNBxVP2YCP38pt2dRNXY0zdI8fIAdoal35JuywNd/0PNjZ9psCF
BvsE004p8JAJd1l+0wEquU8n7j/upCXvXver6J4DFOltMj6ycjHEdX1ZbM6w
h5yjCSK3BKRg3Z+YHJ1UMihYeZgdbV4Cqp3qDuwvPF3y69pV8hNpqNvMl1PU
ZA/JsV3pDqPyEML4pFZsQYbrUlqSZeXSsF5qGg+6OED6YJgpHheHjiS1xRfT
KXBrfJ2MnsMC2FYd0/3KkgJXtgS8X9c9TfPpdD4WwvMXH78R3TD/j3bp+njU
wsUU+N3QT1pSIgCf1y11rOuyh4A2f4N1i6RgZ6VZ9V4SGcrWOa16OCILo9kB
8Y73KfCjTnOupkQaRqo1ZKx5OtJ/48R1HUU5UJqyjrQapoHjL5+V986JwRrV
uk3jCwFebvupNa8mC14BjrTt3VQwKKnq3JwpDn9xonfkHhkm/ZL4WqtEwf/8
WSv7Jgo804gq9A8Uh4O7MxgnV1Dhb/XvrgudEhDb0tbTT6dCRIL29pEEYSA/
P5SZdYMKkiOuSQqConBAk1vUpU8D9TWfPJ+n/KQ5WNUUBy2jwka/Qx6F8WO0
dp/g9fvjefF5snv6u9tDrrfo9nVChVQY3iFnMsN/j9bdl3dE+DovXhsczMr5
39IGzP7N6h+kwmnLlo1WNYM0fL8i7a46DXIG2JJ+g69pNiePNYk+I8O+NDPQ
3z9Ia/QXT0oRoUJax6p9n5/k0ra9O1hOV6HCXeOvkXGLv3Pv6Pjangmkwot9
S7Qn373hOraJtfhYUCCs4sqZmFdPaak+Ew1Pb5NBxG/K0/5EHe0JUfVZ6RYZ
vHLbCpo6v3NjAhXsScfIYGJaEVon+5bbv/n+7eNjDpB2a7DlzqUB7v09i00v
dTqA5Bum+UqVCW6Z0ve7JpoUON0697vg/RDXJrZJZckKMsjPWlN28f/mjh3h
+1xKJsPmnKrogs/fuEs3F3xUZVPgX6DShx7hYdrmttLtqQMUWL1iWzgx/57r
eUuUlHiaCjP3/v678u4blxnu9dw+ggpm8wt+pj/9w6XRZPIZE1To1fWdEno0
xT35wT2+6wcVfBcd2+nyqZtrL7FsXZwoBc5p3v+6VbeN66991SpwBwX4TlQO
DWT84todMo79bkyGjeWXrw4o8eNbQTuBnjQqHPv8wbnu3gJcUyly84saBTzF
asX4tv7gnu2ZAI1xCtQVnWzYIfebO03p9KvPosCXSPng1a/4kJl8sX62zgH0
lA94v2zix46psYNTFWRYI1/8/tOWOW7q62/vtcqpcGL0iLjxynmuxNIeUoUZ
G8rpret8w2XQ72t6feofFpyc6AiuN1LD8Ygrk3HCHHj1MkfGx3wB3ui6LUVR
Y8PK5uiTpQGSaC1/evwLD09uBaukLlwuiomPuDsoW9gQ1VQwa/h0Ib52u9bO
4eGxRO+2J1IpAqhZ+/jA8B02JB3MoDnBQqy6xIh4/piHn2lvU/1t+XD8YroS
KY8N3/+WHc7eIYq/7B7pLeDhmeNOoZqD+UJ4SvFNT2EvG45W4571mYtQ0Ysk
peXHhjUCa0onV4lge3avDXGUDYqKt3cvfiWOUa6OA7KOPHvezwq8ExbjT6G6
uIpMNlyVQ323IGUMqvo94CDCAd/b0VP+i5XReUmrXnsPD4+Tm1eTjwxw499q
ziV02+K17U4WHXRDWEKhXRP7bIvvlzzOe7V1GSicfBu7b7UtrlX74vrv9DJQ
m7oTlmFqh/0HOzcc8tGBM1uSk16W2GGm38PB9J/LwO9MjvF2L1vsXKjKSkBN
uFXce331URJmnOu4/qFEC1R1dnX+syXhHn0nPcJZGzauF3j9PdYWw9JaLt0y
14a6x6GXuNZ2GO4vlCkjpwlBvhdcU3aRcCKk+oTxIw1YRVyW8JW1xZqkjV/J
qA2HOYy/3wrscCj/bsKPMk3YqOnsdI+HsyHVp3vi/LRgUUHRnhe/bfCEfHP3
+DYNMP5YqHuRxytKBMRr+TM1gW9UvPtDgS1aBB3PN32qDuJO7Gcrebj952ic
tUmAFnyn31RizdhiwaVoluhWbfjWcWl2eYQdRoz6S37+qg0dXm8XB/LsPRen
S8SvUISk9dttXTaZwIqOZcPly0xg5dUbBsx/xvAut2hxloMxyPnn077sNIVr
edK3FI6YgJKIXXWLhhnozKY+WXPPGCbdS1aYjJnDWBVsVZU3BdnYk9vPypnD
wWCHt87aJvDz2OPKq+fMYG1jRI7iBWNQVb5yXfmIGfDPvZHP+2MCJo7PFWx5
/H2vfeRZ8klT+Fvi01//2wz+zn8cd/5hAn2Wh3dODJrA0ofFI9n+BpD4bvz7
bLwpZOvXGGbOGsGJhjXrRD4bQce3g13brcwh+JDiXmG15TB/2qV5OsoMXuZq
/PssYAIzHkHrMh15OsJltuigKBs/vzvH1XjHAc9rHd/WLGGjhpnBx8bljmCx
pIzrc5eFC0uOP7yQ6gihfKMHz8WzUPf813x5Z0cwzAp+fHsjG43Kzv8O1XWE
b6faDNzmWKi3bHwbd48juBw5PHzxCQu/UPR1RR0dwa5rq96JryxUM6vd5H7X
EShPRaLuM1h4+1DDz7/JjhDFmrlXns/CxMGYdkN5R0jbdM9i5zIWqsSNP7/U
8N/7D3H/936IZ2VZD2svs/Du0oCz862OIMQ5blm/n4WUnVOHLIoc4WfnzSW2
V5lYk/m7klPuCOWvIobkPjLxcdHKXZJdjnB/QC+4LIyJJp8vwP6z/z1/EhNf
aeeUU986wvCiX+m5N6h4TX6Lu6Q4C3Jn1eOcF9PwoIDHCj4jFnQnhbzpSaDi
nKU0SSSGCcXGs+FTLVQUYi2Z2Mxlwlh86YFTLBpuUPG6fKqQCQX+YpzBJxQM
PdHxdeQZE0TzmB0SBlQMG3rRLy7AApl5k9Zhgoo3SBVpByqZ4FDs9U+ugYJn
a3scakOYEKKrz3L3oGLd1bLyxjIWTIilRHdY0zDH3bu+Io0FZ0X2/iiwpeOx
1zEQ1MSGBheb5duF6Lg/YsO7u9m8Ppj34Xl1HKBQIvNV5Dc2CNxdGnrhDmDp
Js/aqlts2PbnfHjrDsA84809LwLZcCC5j5ndDnhlpbbBGB8Hao5+W7o7AvB5
RcKKuKtsMCkyYB8xoOEN/wcaktfZcPPkLYnvCwGfTtU+ZfSzod/p+tpTDECb
k7aHU5+zYffqc+/PmwPuYfpeziM4YB/4ojeyBFBvYUzinlg2fNY4Ta/6DVhg
PHmxr5PXx/vJ5U4/AbfobrwpspED7RQ19d/HAE8pqf+dX8HriwF5PQt/AY68
69UZXcYBn+fb9Pzr6Ai5Hd57zjuC8te1yeNnKLy+S1/HnaJDiOBE5d9iG/Su
WZq6i48Ax6K1U4aJNpgxNyWQFETAmcjSvuB7Nkhst7LevoEBhI8kIaJCwsjf
2v0uewnYcNo0gxthgx5TWgs1PxIg8sLk8fgBEs713NVydyNAY4htK+Fig1v0
s0JuXCJgf8+k0adeGzz78ecR/9sEJJXfNNytRcL40Zd++xcxQClIac+W71ZY
vGnjJrnHAJNZohW37K3wuQbX3zcP4PlNyhaXECts7ZPd6mUPkBlkyFhw0wpV
xZ992bCKDsPhhzDG0gplhj0z+q7TQW1JrE5QgRV6WnKGFNLp4CGLOf/KrJBj
eeDZ16d0mBronhIsscbO7RfjOqYp4LB/dwfnjDVuFw7qiQ2hgEeJw58yfWt0
dTno3yfL072Oy/dRXazRQlZ/354zZHBtt86N77LCiy86Vwk1UMGUlUq2oVnj
49TojnQ/KrwvvO/l7G7N02HEUOwQFbY+2Kp+dMwKz6Vkel52poF066ucGj9L
/Nw3/Y/tQoOIme4Dn/Ws0J2Ze3N2Lw1yS5peNMZaoXhIvIe5Ig2W3vVTUh62
xLOrN/k8NKVC6OFDiy6utMJTmR8zcnOosGCkXvpIkhXKJS1LLJiiwLV9rTTr
aksMqNlZduohFYJuWL5O6rDC1Uf1bGKdqWBk+6Irxc0aqaNAr4uhAV7jPC6s
tkKbW2OacjweuuvO+uydYrz1xAheLomhQKTpVMiLbgsUi3hfSTaiwgZH8kfv
dkv0TeCPum9Fg6szXHOFbEskxWuUuiIFAgKWiJ3is8TbrJfVKsUUaF8RE3LJ
hzd+9FTYGFDBsn63EN8CS/SXuyVx7REV4qwsBa4Pm+FGU5fBYQkabPPZcFhO
1gJrZmSMdr+gQZ/kgoCscXMsK1G8Z9VEBbG4JsmFVy1QuD79685gGhQf+WTb
Gm2BA67f/2TyeLOoHXbauVlg8YoNAV+lafBFgn/Tm0ALDHu6MK/L3B44kcMb
T3ZYoq5ElUpoLAladko07CuxwgO0c+rlZBJUJw6vlBi2Qot14g9WnCSBs5Xz
qKe7FeYDY/bIcxIkxG45kd5oiR1p2w4s1LCFz9nZ+8T28eLFRz5c62ELZ8e+
OGSbWeKzsIxrVY0koLuvCnxpaom35jfq5lvbAm1qpk9dyxJDDly6FfTEBpae
KfXc62mJD5R9VdYzSWC82XpRNskC4xNHClauJQErOCok7JEFTq9pHSr3JkHA
KmOdlnPmeKq6OuNKKwkuGNvk6sXwro8n/9D5xyQoD5h02XjDAs+G9tVWi9tB
ddAmS3l+Krqkd2fFmRBAelPV955LQT8+7tqL2wkgFG/Uu/ZTUK48IrqqkoD4
QPeGlYcoeG/T9R/D8gxIuHGsZtaKgnOaVT5JvQSMP+/72OtKRT3xbi/pmwQM
BU9nTb6g4I6Bufi33wg4MHbjD8jw8MJw7QVzAwZwyN4+JmEUFNI3uK9ZxoBr
mWMaC1rtIMzgwtt/6whc1rK0tHG1PTQJxH01KiEQQ2+OcvPsQXnfxduWeXTc
U/p2We4KTdjnIc+IWf7f+/zvrf/3/oFvbQmuUkYWcLFUoVYxmIE6TVreUtEW
oF1Lf09VYGBG6azZJSsSqLHClTwfs/HY29jYyBQ1EHhQpy25jYHjHC+FAh1z
OFlMp3zvZOL9cDe7qrd0oB4W1tYRU4Vvh0qWRyxlwEaXjL7YSWUQ1Np31Jlu
C6LTdV/m14nBrxuaB0ZcrSFsNu32bR7u3k80P9Qnbwcl+yeJ3Fo21oce8+V/
YQsz+Rntcnwc7Bfj335G0w7WPD70O8GNg5uoQgOkvXbwWr5J86A8B388FyhW
rrSF5S+tbn/Zw8GxxlX5Vw9yYCj/YMsBNWWUXllet92DAY5eeUe+LlCGotp0
0UFRMvi6M660GbBQsJnZHFRtCwftWbJBExx8u/uG8u5EFoTYSVj+fUnBrmuC
qW9TCNi5VTUy5j6BSmSFxxWFdsDp2/jOdZEjBvGJbtR9RQWvoQ8kjJaBqKUz
jl15HGBbCQzIFC9Bc79dq3Pv0mGm+MeOcD0CBfNX512QAjDe2NJxUUQBzKMF
iC3vKZDe/MOvPlwJTCMaBp5IWMAppQ7nqTNMPGi222eqnwU/HRpNHS9R0Nvw
ymdVS158Nx+WXnEeMO2wzUNRfzYEZ8Tlrl9CQaBf6wo258CjQw0N8Zn2SDqh
vDBsNws+N8haB7aQMXeczyv2NQuOVJ2O+RZKRtLCzqjwCjr0fDfuvPmJwJi4
pW9tXvHy0mG6TY1DoBe3VXBUxQHurM8a38NiYLDSVtcnRfbgcWSvQ643A8P4
anGtkgNs6q/ZOjRC4PXldb2/8u3BLY98dV0vgd6uHsoSDwE+vZ9YcNkZ8Aw5
6s7WYIBBTUpg+BMa2qYpz5EOAsQFHG1WMQTMropUPHID4GZuENH/kYaZFYZ/
vQUA+LZkzuXaAA7cvLZY5CSAhs8FCVN/Gn4icdvz2QBcWaWvdB5vaCpWDl0C
ALtdA2fq1KjoOKZeJKgIMDp+fsv5RF77ni/1D44FcA0vz+6/xavz4+X3zr4B
EOkYEY99D+gas4HhMALgonKDw80BDEj8VZm+AaBC7+N9dx6vOHfb2aj2HO/4
Hv8vr24BOlV7Sb3xBai8ItpewPv+rqBtU0wxAH2pWW/+JOCdB0GEuDaAld7f
qUcdgApZFyyC4gEK38sdoz6lY2D+oibpmzQeDixeaR5Dx537KfseDgGYOgS8
qdhJx/yTpT/fivPsGcpYbTCio+BpY+TrBGj2zO6d0qPj+5X9wYfjANzDR1e1
BdBRPZ1ftWItHU6EG7gp6vLGm05RluQCBNILRUmmdKzfZDWy+CwdNhu2BxZN
AC67ntGSKkMHKcOq6kIpOm4v4RZ81KRDslN3MdWNjt7VWp/DOHR4krBuo/wH
QB8NmddZfnQwNa+6X87L58KzHNc/y+iw7cpb2s8rPH+Fu710j9OBRE6LTbvA
8+/M5kX/eQ4rYP+k+XAIHZ+XF3VdN6HD+JgoWbWVjk8+1H262kiHRXyRWVdd
6NjaL/PUYwMdtPbJb+Py5qsGLm6d2UeHNwGzr/k/0vFDtkjnRiU6PLsTveL+
ETqmnG7+I94NENrz5WhJEx0HOEo0NUMCdL+0ho8o09ErXK6SzCbgGkGP6l5N
4DWm+CNHKgHbEneYuw8A3tYSdr0QTUDTmdldoQp0FDOZ2206QYe9VgWnd/+k
Y+j5u5Zvqnn+75led7CfF49T2s1Nv+hw3gBNVAvoeGH04gMSL19nlk5TFx+l
o5Sa8NzrRoCpCL2XyrsJVLY8uaPrBgEztArr74foWJWi+OHWAAFmwTasZi86
+hY8UjG7QEDNgUVSOo50XCe0eizAlYAtj36Hf9pHxzH6wsh7lQB7epXGRRUI
vHlt13khDwIe8Uv4dtHo6Ezj3A+RAFgin6dj7kNg2of9IWQROmQ5FcpTbAls
snCRkg7i5dvyhZ/Sef7746LoB7z8cFO/JW0wQKBjYHH2peV0SPp848UZIQIv
vn/LGToNoJarHt7Eq/9vm/6UUCJ48w+K1/lLEZgZ5MC4zLNXsOC4MPUtHXel
/NkhxaTDxlsWyfnJBA6J58QbjAFIpmS6uP+jI0UoQU/Mng5CmxQr1FwIpLnx
Wf1aQIfLMsZlfdEEdrbNfW/sAMifylV2/01gOjmPZdYHYFfjs+90BYFrIgZl
jbYBHL9ryTfUQuAuZfmqHik6tNQuWLDrLYG5N8zcJHj12FHG9OPrIJBve/bv
ODtbCKo0a+nZxMH9jqd+v1N1AL5HJ/Y1lv9XBwLtf3i42W4i5PUXOhQob8uT
8mOgqtEeIcNcB2g/XLz6Hu2/xyPxv+Ov5T95lsjnAOHPLvkkirOROSDROHHU
AUypK45vyGDhFU6L+JEZG/jslTi7Jp6Di8xMPqx3sYUPryEdujhYpLcq/EeK
PZAiCrpMU9kYc5ucuIaHZ2nzQ4FXs9k4XH3o+curDsAfKho98JqFt2q+614e
cYCP3eNbjl1jo5vrd1N+TTKEBtiKpAeycKNz08m+HAfwWM1Hu2DCxhozF+G3
3+wge++fIqNzbJyJf3T7YjEdfrXduVvErwhbvlPMo08w4HTmcvXMJgtMtVRL
83jHgLRPbuH9302wJjFbNOwaE/4WNWhP8pnhj0EpY2KECQIF4Wqf0AT/H67O
O57KP/z/mZGVSPbe+wzjcDiXM5HZsJXshhVCpVSUSkKKrJQilRXJzJsiChGR
hj2TyKqM+p3v4/F9/H6Pz++v87gf9/Ve1329r+v1PPd9n3PqA21Tfi8NfEO1
zzfcU0ezA5GSKSVUSDMxNmHX0EZaoapVMqI0EFvxUWp9qInCqro8ns8zuVVE
3dYmWwuJnZDqajKjASY2U/Baixb6nSetxFlEhQnLdX9LE000qaK08K6ACpnE
R46leGauw/5jH/hKhXHzwSOHXmgi4xJP8+MnmP07fj788pQ2CqSQLofr0kE2
SpSlz00Tvfiza8+FYhqsWwx97ririWTGBjYw52mQpUi0Xg3SQn9uNR8W8qKB
RYrH87v2muhfrfHUviwaqJ+ze3VzrwYi4Up5mjVpEKCsGZp9UwPdmLKq/d5I
hSCV2sd3v6ohzWKTY+nsNOBTfcWlfFEd3QsdqJaboYGU37GOpgYNRCE93eXN
SQfx/hOR/pYqqOJD63QEgQYfXuaxvDRVRS/OCYV+ZHL+W1YZX8EdGmiaQMx0
rqeBJHvChqy2GvpuP/xHgJsGsQG6E+lkNRTYpBn7SZEKT+v89Tj81NF2XKHE
2VFmoft8UlPuvBoq/+p2iCuNBt/vZV4c01BHkK+U1bRAA6rfaUqMozpS+1m2
GBvE5P7GFjJZRg2pHqW2YvqooEge2fFtWAV1iexYvRtBhXy1vROLQeqoetSV
810pBU69fFGbzjxeMuh0OqFCB8mMxDDfcVVUHK+V0MhKA4ErxYfqfVTRN/3H
oiwBVIjIuxP85J4qOl0zzfJ6NxU+aeNFyAMaSDXosflGEBWWVL+XJZRqIu+1
9xnjMlSQJ6pdfTariQYf53KYfKeAQ+vexF+ZGqgmYuzRo1UafGFVazx4VA15
khZPeMdTQZ/tjZfmOTU0Y02JVqqlQuOflpToXlWU/8zP0FaWCh+W8EqZrarI
yj/t70IcFeLdT4wNndBAp9+HmlOsqaB+Xc1qakMdNdY+ultlQAX+D4cwOi+1
ELK/BbV0KrCvJU5bVuqgp/c0jkg4U2Hu2/1f5qXaqEo14k6OFBVutMof/bim
jdhTkNcmc7yoBw4Pv+gz98f5i3+lm4lwM2t/K3ZVEloCPde9iCYgX2pRFeLH
A9UCVgo87ibw4RznZIynKMiNs2PFE02h4PicX0eTFHw70gqpDibMhJnZf5Eo
AR+ihK7cDyZCKWeMb3IkOxKzsW2XijAFod0sv+8McKHV4KPO331NYBvt1ohE
KzvSP1H29eAWE7B7k3Anv2IrcvqRRtvOZgpPql/fM7LjQOWKMsKxu0whPso2
gF9vC0rx2BlaoGECFz+k76IqbTaEpZxp7Omiw7vnVTnVhhLINk7pIp6PAZTi
k5hVEWkUrvXtYP8sHUostYVs62VQ1rFb3FeeM+DvEu5X6Vsx1Mcz5pwZzoCH
Vyajjv5abLjYo32k5AsdSm8Epv46XtfAI5ZiFG5OQDduEkrlltQhuflRetJB
AnKoLLY62KIG+iImU2L3DBFVBd+w9EwDht2KbWodCKiZ5dyprhJVqCDjve/1
GyKZuybBmudU4ZCVaYbyKtNe88KAp6cazJkfNb3yyBB5OO02G/JQgjL+QfcU
QUPUtuunOz5THu7xdrv1hhsi2yJfNa/7UkAvKaF6LhsgU8Hj5sIkKRDYnzw5
9NEAlf0KeCtVIQMc9Lvx9WsGiO693+Ped1n4+Ts3VKvAAA2JAMW1UA4est2u
OL2gj7w983+Sx+TgWXdphdN+QyTZs7LlapsoZJ9az4znN0SHKITl29vF4Y2K
rXJHkyGqa4oYEPYRBw6Nlf5d6Ybo+U75E1pPRSBj35fumo8E1HMOS+LhEYIv
9i/O99sQUE6boP4j552gbLpR8X7WAOkt5LUmcIqCqEOBhs4JQ+RQx8bT5S4E
j3IWOagHDZEvfWP5oNxOmLrFqtTGaojc08IsvMSFgMwlGJwUiQHPk8EK3nXa
UBWWgHOkY+GkHWn2zqQG/NNQEFJaxwCupEnkW7AW/NzRYtN/GAvSR/3uD65g
4KS+/OJNLm1gH58KPluqDnEivk97e7WBw3+2mzdTE+rYWMQuFeuCiFTzz1gd
ddg5v/7xWo46CN6qwgiyYuDGnTLJ5HF1eBwtmtd4WhcE253228RpQN9kmMmr
Dl0Yt55QFJHUgo8OM+ux33TBsSjPgiiiBZKndj5fDdCFF24s483vtSCZ/hMf
UKYLvdbfj2Ava8F+kaQmO1ks2PtUL51a14TNor0nd13DAFvfnK0fURtIvZ1q
lzIwQOss29xmoAHjhx7H3N2HhWGslpHPG104Uxz4Zy/TPr+17RbhiDp067tf
66nGwCLbdznZEQ1YQI4b3N0YaBEu2b1jUgfmupuNV49g4K7T8odhYQ0wfT1S
ZeyPAbPFkfT0o5oQlzhfwO+KBbfYhHrHv9owKJ3KFuWEARa/Ekf6KW244JHc
ESOIh3sPW5xdKrXg4mVJLyV5HCCNp9uwtlrQtL2R3nQfC6Vvv5b+rdOAudbm
qc7dOEijKp25fFATxNc0ZIVGsBClnNsX8UoLFHccw++t14ED5MC1e6vaUHBE
puACty4IfOEO/CSkC1ZPHX98zNCFlJnw6MMxuhDKL6i9S5bpb55Dx0qZ62/j
2C+h+k4X1GKsX0a505DX2Mer1zrMIewX9xeB86aokJbR8UOJCtuGjHxhzQSl
HS8we8M8bsbedHu4ZoqSpr7VttlR4YIxKyaHi4RItC77G0JUuDRy0GunLwm9
DlSz/+nFrFu3R9/bUI2RCW5n4MVSKvwxNhcxCjNFi/d6uTP+539w5IO0qjQB
Tfroel+VocPS5fP2RldNUULeIe4GAzqk7vEar2Jyz6qBgG/BQQbYJg0b+nkD
ysyTVi5T+N/3D/zh/36/v7XvRynfohkKweaGNDeaw3kn/b+7mTp+6bndT70Y
c0jLuHty2McA2bDd6/7ZSoaX3mSNLhtD1DNHvWWjTYHqkOBsDhHm/rHb5pzR
Q4b73mWVhlWGKO29dCPrdzIc5zV/NaFihNapqmfNKijw2vXgHHcjAfnK4nPC
Csmwo8ei96QdAf04syp39wAFtt5J+diqSkC7TFP/bVaS4eqW1m76kCGK5Lf6
ehdDgeP8sZklZwkoV8ras5+TAkYV7rqSTgRkpTxXTDxIhpVm7+iZvwT09o/I
UxEmx3xrTul7lkBAPukJK7dkyBDsiRFoeUFAjN4PFzOOk+ETptu37LE+wtxQ
zhuVZI7vG6bUrauHJOrtrVMdKcCx/tY1+ZceeuZxeIBsQYGac+nb+ZtwyD81
X9x2EmD1tvJ2Qw88uv/UxUPmO8BQ78PuPRl4dOcg6JwPYXK47sDV2c84dIU1
ovu6I8BS9GROyQ8cWtYhr/3kBIiTeB6c4oNHRR+cjF9tkOD6v0vOvINYdM3O
ZdRTHUCUVKCX6YhDwNuQeMkcoKvWklczHouaIu/ss1wyAnb/b99c4jDI/tt5
rdptBmDwJmd0Nx6HDoMLZ5s2AdSP1CmqzWBR8SnZNPbHhtAmdO9v8A4swsb8
PjmRaQieX3Nnzl3FIvV+20uJWQRwdVGLLik0QTRttkjnQQr8CV0a8J83QdcI
1rwtDylgerOR1BpqgvaXu5ErDlHgtKGu47EqImK7RCQd16EA5+DmEU01E3S6
6bRGhz4FVv+MZst0EVFRaZCI6ioZ1EtUXIQrjaDDjWXLXAAZiaZvD/lIN4J8
FQFSGpO3qmzZWTu3GsGNp3ntlS/N0Isp+UDXU0Yw3JXZLvDDDPX8xCsQOY1A
45tyhWS4GepK7ZP9do/ZXzS7qR6T3xekxU5/ZhAgavTs/vBoJt/XvxIUwBjB
Up1d2FaiGcI/qPzHyCGArEDJlESBGbIwvhBD2mUEl3SX3rSwmCGXJy05qi0Y
aDq3qfqNSEE6Czp5HpsYGD2nZdXTSEFj/hEsHQgLNeLnS767UBAsMYz7vTFw
tMhTrOo+Bd3/rBGVLyQPX/NPneb8QEEaqXcCxKJw8LtujF7JTkFNOruN/Qxw
oHT7Wc6vZjJSdp95/XEZC+sSkcJu/8go/EO/9GFDHFzBeZw8Y0pBstxbUyvb
cBAfd+a9gRkFtWlebSqWwAP/te5HxDUyChH+yXK4GQdGKRUbTxrJyCKR33Lk
Mh5qjI+U/VwmI6FUC6NCPAPEsiP5zW2xKN2X6i6+ogMRizVVoVYUZM52KDJS
GGB//dyjwCYSMk1Q+JmSwICmt3ayint3oXNFtduI4wy40rg9rjZoF4plGLAH
pZBB7JSsNNmSjJw13oYsOFHAVX2wYHmFmUfOYsvvVBjAjfu/m99fYCDzrRtG
HVtNoerVhR0LV8hIOCjHV6cWAHHzx5QmmqJkdYcfSR9J0F/1QFxcloQyEt7M
V2BI8L4oP2eviBnK7FF17LQB8PoWVrBL3wwd+xAJbpoAzrU3y8ixZoh1uu/l
rTUS8P9I2xmYb4beTJEH1zhI0BUcdyRt2gz90d21KyiRBAeSrFpu9ZqhB/m1
K9tOkoCzc01BU5eMTF7bx/l7AmRhO9jPZZqhvOPnFviSzUBKv4x1p6YZiq3y
+5swZQZaZ0oPNW0xQ5Vn/3WoNTH53wC3HHHRDL098eLAMAcZDL48ztVyMEN0
W6sn34lkuGD6UNH/jRmqit58N4ghg4++OKcBPxnpM/SsO8vJkMJ7g+MTNxmV
c1yWFGXmIXtXRewI03/0uJ8iZ/PIoKkjVnusjRnPpC9Df6bJcOW15BbfYTNU
e5zo43KUBo17h4ZYuImI99rAnukgMjwfu7mV/sgMtXMEmM53moEhy6B1XAYZ
nfGOUm2JA6Auc1VEXSUjS+0zHGJmAAd/j6Ng5vWIuJVLdvUkQVYNResRM57C
ZHQ3+LcBtIsPLFprUpCbpJl+yxcSqPHe+fmygoykf4z/CP0FEHXhy8grGQp6
EfTDXXfKGLTkr2ZxFdNQWnmwavwXgDy5i0r37SmoWXzBSMsI4Iam/qftKmT0
Z8V5hBoOgD8YffkjjoKKTxey/1ZhwJGrLnIVyXhU6xBa5Z1JhzeqAUcXjxqh
A/HoUdE4HfI1QpIM0o0QVnFZ9KcAHbzj39jOHjNCPDKU6Rf8dOjxPWhkhYj/
fT5TloiCfb9LFm2awY99dD4/OQlIVmWxiPWkg6PPG3+uz0YoaDh15k+DOXx9
GDBR36WHklVT+898pkJq+Bnhbc+ISGJg6OuHHXSocGuJXmXa/5HXeutXwwCD
n2LN9e0EdOXhkSHnKzQwmZYImrAwQTy/WfZRSugguJ5cOcFhjK4t8zvIHDMC
zq0UWq/fTliyW0wlkJh1fDVcj7uayavWhWtJO2lg37fT+6CKCvoQQQ9sT6TB
4Pkn1c8HlVG6UXbYOyMaHPubkRb4VAlVeCQNwn4afH6Vuptrvwraet7y04Vk
GjzZ4iP5nV8V/X3L7nemmQaXH57jxgWpoAdEs3+0WRpc4nrt8MVJFUnOhDNe
nqIC5tjfl/J/lFEq9pm8sxoVAqEgYluACuLQG90mOc3kZe0OHr7fyii/pufr
s1UK/K2el3D7pIisvs96//1CgWKPXgfKiBLyuqpfKkpk8up96Y1Lg0qoR9ar
ZCWLAqEWw+8iJhQRV8SLINmDVDj2IXVKokkFpQkFJBQaUuEV53TfE4oi0n71
Y3fGOgVO2GtWOb9RQFOC4j/PMu272OevKPAqoY1HH2X5iqjwozY45K6tEirD
vynpaaLAtW0agyCugLpfeY2xnqJAbPV98qqIArr893p4dQNz/lbc4Q3CiihJ
IMZ38AgFiB/sMiWUFNFXvvnG8wwqFNsPqQU9U0avtuSq6p2kwKxA6uWUFiV0
b3XAPuEuFR5l+XHVE5WRb/Ysn843KoxP0P/udlFCWn5o+90GKjhsPtCSPaqI
joxdcpOdZdZJVglW4mN1ZH6/PFulkgJrzh9i2tY1EQm/o/YgU/cs5XZy1Qpp
oxT3hv70CxQ4UKmoVHFeCyWUhVE6me2X/8TXsNO1kHlcv3d9DAWkog9y/47Q
RCejeHSdzakw4lu8oJOshkb0/30IE2IAvXatjuePHmrhKoh/L8eAmKizDsH+
+kjmq4QGzsMc+rJpEovPDdGvh2Jes5N0qHeT+upxUQ+d7zC4PLWPAWauZ84F
GeihtyFed90UGdAywfZn4Lwe+o758uCwH4Opt4/bWbzVQ66bVacIz81BRF3+
uupO/H/3VzwO9Wnhm3b8YgBBYd/w3i145LZQ/t0xzhyMzI3YvTj1/2sfbIB0
8/+dz7lnDkvPrnGYd2HR2VCV7ECaORQVw/dle0MUanvi0ulGBljsk9NbJOkh
jTf71OmxdCA8Sf1o2q6HiByRayeYOvZDDP/ZB8UGyCXJ+j23MAMs4/YGuFIM
0aRwtcA8k6cTf28ZGNhjiFQKk09+cadD9O4ov6FkE2Q7raZTd4wB9ftuH7v/
P7pSOyZMHseAYP8TQTdLDNGziaUNlgAGTPPL7zcmGiL99dBPFfUMeFbQ9i8q
0RB9qvH9uf8iAzjjpL3xy/poXdMTm6BlDqyFtcO9Dnooa2L4WdkbOgxl4frS
/E3QlhDX+2/XGHCoy6Y9gk8PnULiBlNzDMjV0Dsdp0f4r3+G9ZDsse8Dv68y
gMMvaj+/sB4KVlyaWvQ3hz/J748tyeLR1gvXVOfeM+CoKbZKfIchipab0idm
MKD6gpxs+bwBCn95JFi4mwGKDgPlN82xKNwyEb9uR4eJsTDnvH94VL15+wfr
PTocyCbGtazg0VWK4s2qPjq8uGk2Ko7Fo5WnS2fX8+nAy4dPmlrCoQhdYnPk
DzJ4XFQIuHRwG9xLj74oXGIGe/gkr0jFSECYnSzb+/N06LXYfeFU3C+S/g13
i1dBDBgbLckZ12CB/6xvixj8i0g2nBcmQUVdwP0r/Nvh25HqBs5XJFhgmMf9
KheEn/gy8dMZxhDpM97A08IBiVXjm9f2EEEoveiSf/JWYO0xqbNzIsDrCrOa
F8AKca0Xi299IwDLng/8NZSdcMDQZtiQYQp8J4eqH+7dAXLhZ99Wj5pCzL59
3dYRwqA8nb3SOEiEUINFWQNmPRhsWL3wtckYbvpEG+dIS0DT/LnD3+yIUILZ
MVVyWBw0yypDno0aw+useq/VflH4qfnyHa+aMVzUyH761VcM4mwrooeUiKDH
f68xQGYXXBpXPbzuQwTOP+PWdXdFIePLtc9R2SZw/PMkhza/DAgrf4lcWDGF
BxW+hNJObuRql577744pKOY/Hdn2mRctNdu3k56Zgkgj1dp6kQPF8Ji9kndh
QJj0k8H9BWKoU+ZDeEEec//SHJeqIqURz3yY+X6mvmtT19qHrxhv2EKt7xub
M0T8X2MWw0I0Qf7fiLLPhAH6R1eQYIlXhxfkh/e6PAyQZMJnnnf71eGVU2Hr
+3gD5BdG17oRqwGcq8jb7KcBcpq0+shhpwaZjSKUN8cN0eXJjbO7rqmBeOcN
F2NeQ6TeQr17K0gTXutacyoqMveZrs3vzQANqJvqysr0MEQH3i1atNxSh49R
WRSDNgMk8mqCRHLVghLNr4oSEYYowt6nYiZKE1b3Zyt6heqjTqdbc4MVcjA6
q9qpc8gI7U2slkx/Lgr3dC2vySkR0CND+XK2mzugOz3D0c4OAxcGzMWbeTXh
y8whm45dGBjsb5KS4dWC3TNj+V03MGAXb1ejP6IJ3rMxr9Ly8WBueuFiWLo2
+J6/tPxkUBMEQncUv/inBp2OqVl9BE3Q5wr4zC+jBh8TVC/nkzRgtndKW2uL
GpTvPpBxNFcLFNLe+HTfVIVOX60XV79qgXko8V/GAzWwmri55nxIBzZt93BN
PFCHCCE/95QabbgjbubpeUgDRCbrihJ36UKo7iWR8Cym/fbr/g8YupBLTBpb
NtQAC/Z3I96dOnDt16XXYdMq8HWh8vreGl1Yjcz+lnJWFRB//B3qV12Ign8X
w6w0QEVV/rNbDQbwqZONqVLM8W5KeV/2xEC/KnGL+y91Zt4/NPJyBgP5u2fH
mqU04F3sfr4dIjj46ylwZbhIDeQL6x987cBAgBAt8s82TeiVkLIUS8FCwpSj
uO5ddfBQ31dqpKELfU5eelLcmiDRUWqSMqQDYrEHytmZfqunNfyxzNeBfZd7
C4T7VOHd1znX7HJtWHuGgR9YVfhxdoDY/loLTLv2FHHvVQGM5oPSvew6IJBk
qmCtogIcH7azuTToQDPZ4s7ebcpAWXq1vnBRF7j07j68sUcNuCuOOD/o0QU3
wekXuaAJbG8u1X5yxMLFnLelW8TVIGP8Ov0vk4fuXk405TfRhLmjS/ecxbTA
IrTOLmFEBdKO95U+j9WC9IkF/YUAZTCdca5tcNAFw6ogAx1eZfjh3n36y30s
bMwE5Qk1qsG4UxNvLAMH5Ar2jt9yGuC+e/538yYWAvnNFtbOqcONPV53099i
QXx7UvTzLA244d5MLN2tBtHRNpiRS1hgX/d/IBqkCgOfDvWPCWBh30nT2JoK
VWB33Oo5kY6BgQ4HNHFWDbjaCxlYFix4qex7cdJQHeKfq5UtO2HhkgxP+7NG
daj3zc3TncGC5K8Lnm7XNGCsBvPkci0WjjiOtOOqVaHjzS5hiUo84AfP53Sw
qYMk66bK+TEciBDXODZL1UHmXdOoTjgO6iov8lOY87OIN7yyYIaD+6PtHMKi
OlAhWnyvKEkXNq7T7mkc1YXJQ3b7RLUxUIfxHH3Kwbx20iohvTa6MEBu4How
hAGx79v7X2/BQNvEELrtioHlEbE3Aq904VjScErWBLNdVJntIE0Xjuf5G/Uw
44+FI9fPgvl5TjBZPeInBuqz1/hNmOuvqdK6H2+PAbWJADXeUSzseHiu6AQd
A7PUfHeGHBa8ix4b7PuKgdyGFO892lhw3xFdYvUQC/rOdRUBbjgov/mga8GT
edziee5NCRZ46xjVhGtEdDX66Fj9IyqcKMNwLPcYo7LnT4VFJimg81b15JQX
IO/MzFOD2nTot903tGYDyP8sY9rmJw1iLGKOjjSSEKkh7XHjHA2CtrWus/AA
2h3zunUlilknHe3C0wpM0VuplF045nmOAM25vXgSClTfH6UnRwfrFl9exl9T
xHJYTqPUhw4l+25v3R5PQhI7ZzzYIuigG8yRiMsnIbXx/iGWCjpoXB4tOG5J
QtR3XjOuTN0i9e2lz+FbJDTS4XV95Ccdij/H9pn1k1Brr0WcCJYBOKPiEB4K
CSk4f3EvYXJ3sqZNS94cCfHvOnfX7w6Tw2+pvFdhBxQ01vG905cB/i8dLunW
kxDfzzfH5vF0OGd7Kpm3E5BIgmg0cYEBgal2uT4SZNTXbeVe6GwO+E8t/dib
Bsi6PzP5iS8FzkpUjvysM0BNrsYvHYUoYPp9ceuqtBHq77n60343BbgDPZdG
+g2RW9fNeBsPMiQVvb//4IQeemkFP8ZmyHA8+tujkGU9tPrHBbX2MTm235Kw
T1of5WSZH2oQoECNwNnqwB96yC/3TeKNy1R4nmSpUd+OQ/FfVRydHgN4hIDE
NSoGpUFgSuduM0jBrB7acQOLnmW7VbHPkmA/9oPZrAIOsYcnbWntIUGPvuRr
79s49ECGb7KkigT9GSKxwtVYZHaiKb7skhE8FQ77+DgZg/Y00w9zVhtB7k7l
zfybWMR1dpD6OMEYNnK8XuYsYNDXrF6LcWtjOJU4/fElHxb9yOD6feu9EbDs
5DouUK+L3r514nQqNAZLTX7ORgsMivkQcjvT1hhKK36OSbFjkK/A49DRbiPY
FvVp5OtZDPI+6RGeRSIyuevGyu4cDDqFX1p8UGMMxlYqB0vVMKiYVaj5+4Qx
lBxUW5/W1EWpLRcXYjRMQOySsJ1Ssy6qNyRvac0igtjNl8+frWJQ55Rtxkdh
InRTDx6LWccgVo424aIvRHDWLZ/+qoZFOq8Xap+VGENPlbzsz60YlLKkPcvG
awBtb7wiEg9gUKsYkRx83AAicYVVuTuxKGzP8HONJ/rgstVAmJCORcOpuYaV
n/ThxDVOEZk8DLJQrikS+aUH3u+u9HMpY9BT2m/zG3b6gD23/Zg2c/2Jvbpx
RRl6oCm95IxhZ/r7Sc6xUEN9mGxfe/xeGouWYyxJy0/0QEyY7wB+Hw6FfTtk
HSCiBw36TxKwAzgU+FKzdCIND9t00LtfWVg0f1NYhENFD+ZZv6p+S8egH1c7
Woyv6gP+QdO2N5UY9Du+orWDZgg2LhWaxU8wyOMo9x/GX+bxS9XXt/AYtMH5
iH+DgwCxBdcPGxti0V3d4i3dPASg1hCNNuhElJrJdXCTgwLPv/DqzkwZI9tT
KZ8MQihw9F667ZsVY0QhvHuiiKfAe+XnOxLfGsI2xbNn8jL+9/f/EPb/Pr/g
FibqFt9gAFHH5q9YLtARNj7ojUAeGUIuJY+okCWh1GpTWmAKB6TGEwJUJxqa
VUpQV0jEwrj75fXavxR00EMhMCkCC5PaJ92GWqlIPrG3+rUqHTgk7oSeMzFB
H00iv2iV6IIsI1qiY46KtGr/RXf+NoQjkn73o1LNUWtyNV81uy7UZkwHLL6g
oJzC3cd1cQToVWsT/vGFge6/qbK3QfpwvP33fFgZDcWIBWBdf5OAqpMSWiJF
Ru4VEoIeCRjwtKNkXsukooGDv34mChiBztXk28PzDHSnxnjKCk+G3Y2mJlpy
FBTqxoKJCzcFMZ3fTWcdRSDJF7Vy0siQOPWeK40gCWmxeSfehppCd9Sbj6nz
EpC9t/iqmgOTP7cuRpWGSSJMk3Chy3ZTMGksO+OkJg0bRw6FZJiSYcaiKqex
Swzcfx8N1bpiAiHgeSh7hxTImL2z8kkng0ba94S9AtJADWW7wONhBpnBtpeH
JaQhOcUWr2HOgIP7v3zg6RJB7Rk3b8YeI6Jv1vW1Pw5ugcNvD2xr/MIAn9vd
5XNPfzRcu7B2PJjGgMHfy7X7ozkQW81yEf8nBuhS5DMXetkRJsol8lIsk5/4
ZekB5Vzo1zM2Fv5V5vlAH2HLtzuRgVtZdzZzPb7z3Zbyr7ehsFgSh1MiAyKj
FD51z7Kh+5Umng9fM0D77CNTktRGw4gIb11SHQP42KK/jD9kQRmKPBkSW5j8
2H5KP+TeQoOs/6fmVl4GHNGgGauErzX0mJkeHmLyd3RSpMIzji1IuuodzsWA
AY/nv6g7X19umHffs/CpggHDDra+H8PeNGxjH0dPjzIgSWA6/cjJMtLJSpHX
ZmYMgOmJdg6p9oah8MWso88JKM3f73ZO8S64uSTH0hdHQDW0G4er8sQhiLb1
0I0JQ1TM89L3A10YVAKYbBFOQPGzy3HFDUJwJfTInTOIgFp5TuUkq3DDyeYu
K64cQ3Q14KrhhUPb4U8x3VNERBc6Ze7Z4leV4eCvlWPrSRhoVlKnkSNVwXD/
gEyVPQ4qd+M/FjKUYYJnNPaYEg5CXx5k5T6sDUNlcdNJuZqwvc/j3QceFUiW
GHH9wtTjYj2hO7ly1WDgFqtl0Ec1uE65fnVznKkHUoDWcYSpK0UDLdTncGDf
1ysvrqcKAl2OWxHzfEpn1RGaNVOHU+O2iB7GAY/Au9zWF0owrJFAvtLF1LlD
FReOtSjDtrhzK/qGOOir+3fc3VsZzKnY4EcvmHpLVdjCwkIJuncKROxTY+pI
jkKlWWsVsLbYT54fwELJ7qtujv+U4On8pw2aHw48CjIGIohyoOCTk+5jgocd
hZT90e6KIOWQ3xbH1GcGk5dY2AIUgBu+3Pn+CQcarA9xo2WK8PH4jr6ovVjY
HA3bUpCiCLcmSTMOBTgQqlblP6stD2W8Sykh81gQqFmSNs9TgLWP7bHHTJh5
5IHQo3x9BSgQ5IrTfYIFZ56msEMS8pBzuFLBlYCFDzMvZ8vT5CEm0kL7RAQO
vJJcP9fZy0PPz11uY1vx8GXLt8FRTjmwIN2mtZ3AwXLn2+I1DkUIEycdPNyo
B8Y/RBlsZ+QhUHXcM01ADy5pLKrVisvD7aZ/9muJeFD+3NK/elkBHmE4LvxN
xoN2qs9oTaosWDH+Lcgq6kFVCJlDTFMOqmWnmrfW4+H+d5eg9X/ScMb5uQUh
CA/83y+RvvQqwoz1n9CH+/Bg2doYGfJXASj0S7vMMXgwe9faw/1MGdpeDd09
WI6HuOejKz0PFAHvLHKOS0gPJDbvdvlOKcGHLX8fOTvhYWl1XLBNQAUajp5U
eLWBg4bjgYFyT5TAIVs/238EDwK0n6B3QAXmEo02bU/rQ+eBAvHRl8qwqZ8O
Vjl6MFxI3b0tlKn7bZu+/lXTg3TLH/3bnqmAtAuNd5RZn7bK88rVuSjC+t8w
x8YiPFSuDF1w6FYB9nb/BwHeeDinRLr5qVYNpnJzil/M6kHP7D+WkDlVCD1b
tZXzkB5kntY7/XhQHbzGr/jfGMOD+xwYFCdpwJnC2p/SynhQt8g1uuauCgrV
EybWrPpw2L6UZC6jDvQ4jVgWVz24Y5WoJ+ilAoTb5w34/ukBf4hJCcskMx4v
69tOp+hBTpLRiY5WNTjE5fjIpg8P1rw76zROqIGoU1OsqAMePs1Xv2ZLVIe2
VFyCtzse7Bps2xW1tIAjxEFZF6sPpTjO000xGrB8h90hZ1oPTn6XIehkq8P5
lAnuy8x4kFqTnGkqxEBtUFrdtrc6UNQaLGqsowvLb11M2JlcOMC+S35rvzbU
1r6iRWZjoWxqp01smjawldubL4hhgb/ul8ZJCTyQVFzC+byYPFR50vfsAgbS
1QqDOcg4EJ4uS2sgmKBDXRL6gfepoDLoWXZHyQSFZBCE9+2nQl02Z+v4fSLq
xpqM0v5RICmJtTlvqwnS8pMMCpGiQrbbyLUNCyKSq/+8XldEg/MCxXICIoDM
C5pSI+dp4Lp7Oj05k4R+mD8xVymnQbHmoSIrPUD9iXphRAc6VCVbxpQ5A7Kg
lZ9ny2bA+YjWUcM1QFcmxl34nzDgbGGb6I4aQGuLwQ2c8QzQbC+dMNExQGUm
IYlhdApoZDyKCy0moM2K1ysYIgV2B/hUhrcS0HzSxfjqcxQgrt3vFy0yRGx5
0cH2BlQ42+Rw4owDAQkEJbjtn6LAwOTiJeMSAlq4pPsnsJ4Curuu2YTpGCE3
CZle7Z9kSLtsnTMWr4dwFv/m/ud9BgPBi2PvlfRRuxn99+sZCvixvai+9AKL
rlWR2AROmEED7iGfXZoOCpmdXdXXIAJHvB/rvXAs6oyVSPtTQARiyXBBpTMG
sZsrSvYx9SJWTVEhqFcXNWU+x92nmcBK1uawhosuOn5FLGm/jilwzNPa84J0
0Y8XeWV1D0xANOYneYWp5w6l5YvElpvA4COxAzxMPR7fEp6o2WYCF2qNebSF
sShS5sFXGRNT6MMnnCvcj0GBIpWdf6ZNYG9KTPe+Hl1kr77v5ct1E8BrPT/3
oUUXSVMlvGIvmkKd+PL7Zeb8/v17mnD+kSlcCOMYrXmEQRfE3su7OJmA2ufN
V8vGGMThYhl4MdIEMonC5olqOPQ4vKuBRQ8Pno+nXvR545C9ZSduuQ0HU7YO
7DROHHq3Yg+9z/Tgig/HZRfmfMu87Hc4ZOmB0QX5gsN/sUhbclTQmqIPlAcB
MmbieCa/LZndJDP15jOBZs0EHPqREGJlyK4PmGi3wzavcKhrwsFWul0fdn6l
vVBUxqMfzwwbInyZepW7j0MgFIeUT65RxSP04czqD3FRJTzyPhr62UfaAFTe
fJDpXsWhopGe3Zbv9eCh6JRSqCkWrf+uo9RX40GKLftK/xssCq0z/dxzBw99
k7SM3j9GaL5/izrhFAU8siNszJ2MkeWHQ74vjCkw3dGYpPnbCHXzp477jZKh
WDuMn7PKCH1zDhUOxjD1bfRds+02xui09h3tSXYKOG3xcbt82wg9bFtZIGyS
gTAWtzD8xxCe1m4k6HSYoQLL6KnGBk04btWskUemoPgoD0meKE3wuOLp9XuG
jG7UqIvp62jAb8nSS892UtAbuYHKinItuJF1rv4QFwWFG+5/XZ6nAaaF+wns
TPv9CfpcXjs04Wo066i2FAVZh9tkDu7Rhuh/bxZEgiho4UboZiVJB96ohUxt
JlHQpqiQHBxh9sd3DWsvRkWE4ovyjRXaEIvunHs1Q0HZZ4UV3nJrw/XyPjb7
XjK6uDGsffKpNnzxv3PtlToF9bDZBagWawGDVCm1TqGggs0d034xBtDS4V1/
RISOLJfaefo+6gFb55JZYAhTjycV/JYQVQByZlLumioFNbXfETcy0YMzBl+z
2TE0pEqYf+QUj4cnvWs6ljo09J3zxl5HZh0zuvVaWGGGiipmnyimCOHhpiO3
AEGWhoqvtR09cwUPC1oFJNJNGtql0EdZYebhRNb8+nhPGiqINX06FoiHePvX
PquHqUgwtKt74rEc8D7WJE3lUFD7gW0aYhQFyNQh7/a+TkG5F7r5eJ3VYRv/
Mx6jbjIyyhVaj3sgCmoHBSrm0yioeX/nUEy9GHD2FAmS7SjoOP5v7kOKKMy2
JWJkVsiI/emBKqsMMdBclfGrFaUg+VPlheWfeYFtn0ULJ4XJGzjOa+ZHlGDp
Mi2T9QoVCV0ST2xaxMH8U5/2untUlF9U7ZjCMIFzEv6W12eZ84kIGm65ToRv
lr86nY1oaLc2ncSfYgbhU9qbXtkUlHxjWpzNgQRZ3izPJ9xo6E7Sy9OLGUTQ
zWkL38rHQH0nP8zamAI8eBEb5cS8Pntio5SDuEgQe19+NrGcgsoTcRtefgBH
n/6O93xNQeuiBw3MsgC4qZMyn54x7ZUsX9+ZJIHVXfVijk8UVCL39RQtCmDe
xyxxRoSK7I/6XslSAzhxi0vtcDUFbZsfyjHCAGyppG5ksFFRxk2eo5cZJFhi
peY536Ci4Ybc0KVqErRvNfXUMKWi+Du/TmTdMQKn42uNrhcY6O/UYff2aQKk
vNrMXPdioI92a7x+nQTImw8+d6+KgcyCpcK5wwnAUnHW3O4iA/XUdXvFazHb
B/BLPU1loAcFn9N5GsjwSPawwGU+KuK7cJKFvmkG2vPpI09OkpFZ+vqJ1d+m
cMnk+XVtNTKqXg6IQBMmMPInxLZszQyJDBRUyLqbwtxtcsY3TTKKSnURPnDc
FDL9dus9HzNDfINGPtZvTIGQlU4yPGWG8Me3J/o0mcIzpSdTfM/NUFt+kYAp
kQSLdtdJ7J5m6BLvxVKbThNwoKfvxNPIqF3jauBHRyLcP3yUJYWFjMzzd7Fs
PCWCtwPnd++HZHT65IyqrKwJOKN8sb2CZBRHdL3+zsEEjI9oH8q9SEZFpU27
+Z1N4QynSGOxNxk9CwiwSd9rArlDNmNqFmR0voS67z6T5/z37TCvIVBQmtjq
q3MUE1Cq6/h0fIyMLGZGA+MemUDvOzAbryaj3TrvDhZFmkLy+9vv8n6S0aTa
zgS266agmNZ5i6OQjFLY+qis8sw6gfF3SW9h8uveuxon2k3gduRb19kNMsoh
Pdc4v2gKt6OrdPo/MPuTUHix4UqCqxLc6FEpGSnEvX1poAKgNbnL6GM9GflK
KrpG4Rgg9OHZVOYtAnLz7/nydogOmon4hWEvAuoV0RwX4qVDV6as3B9zY9TX
xx2hJsbUGQmTrIQQIjJU5nMaTKNCxk9u27gVIqLvpVhdSKJCU2G+y65mE7Tm
f4b92wQNum2VGvhVTP57Pw9IKOhV9MGKG+YgyLVHSOoUHrFe7xv+fdAc3N8u
j2SI6SGTHNUJMpNfUx6GfZbJxSM1/3HJg+nmUFPk2Mz5C4++Ll6JWQAa8Iop
U+PyFFGS279MJX0a6G6daBG8ooDWLEmvRUbpUNR9hLd7DxbFMtRF0vgYsFpb
fpRNFocG7SMO2zD5c5KPpifwEItccguaMhfo4PRvwndLKh492lLjd1qEwdQd
3RMO3HoocCL0jVYIAyI+ThVeLsIj4xu/tmYWM8A/q7P+zAUcOuKqlJl+lwH4
x4xrkip4lDEyw/3rCh0+mIxSPMuJaHHmy+NSU3NQ0IvromTiENtrGx6sDQM8
nlIvPqvCoWLOrNOHmHwto8BiGWKIR2fUJsukdjEA19xKfLH1/7u/bIdHNXPf
DYwEmfy8UWQtjzdGdQa5HGFMfhc9Eoz/1YZDnrTT+4UEzeHVMWHM4jlDdKDK
cEHW2BxS01xOUzaxiC86Z+ymmTlID9YFn6rAo0Wyt+Cn30x+jg58ut0e99/x
Huqj8piqf5WK5uBwpKtgXwwB9ewTKzS9bw7T+ZMjriY49Lv6hJr0WXNg3Etx
dCvAocwHkWqhquZQ2W4i2LNuiCQnD6Sn+BnBPuki6a+emyRCauoMrwEBut19
JnsF10hhimuC57IYILDNbmeA5yfSf+NFB13g/k2/+IcBxUnZgeEIiwqJHmWV
mXR4Pv8py0QMg0wzDdKTHzBAYj56PP4TFj27qJufwvTnbeFhH/ZBLFIOnI8X
AXMIwN9n77mGRW6/RUZmAxlwf0mp94yzEIzU3zGeOM+APK6sNqoNFpmFKGI7
yAzIvxb4/I85DsW77pwL6ySD1ux8cJqkDJzfwToczBwPE6saRbbHoP4GXPl8
AQOmFTrirn/CIFUrEHbsIINSZ9CDg8UKYB0zeqTBlgENTyp4jbMwKHnm3I9y
pr+94USX/iZTJ2rIGiuX02H1jHDNvls7obztcAF9kQ6EdPJyaQYG7VK2++B7
iwY69y+1/b7DCsIrXC8vbWMA94ghrxwrFk3bdJZN9pBhPkl4cleCLEQ8fa5H
o5LhAM++sHhOGZDTUiwdFyPD3PzkvGa2FHi9rFF94EWGCNUNd5V7UvAoTP1f
aBwZ1PbSQ4hmslDZfNXrQBAZGl0OWBQcUQR1p1+P6hLJEDk0lFPiJg9n5br3
atwhw4u6uihVCzmQW8k8fusPGf4Ova3chpEH3pZVhu5HMgSbtm45GioHSbv2
pH/9TIMvd4oLt25nB/5Hfi3RW+nAKn798VXNLfBZY0vW3mwaeF2R1HD15ISX
+R/GLV7SwFv5rsDAzi2wUviLPqrN3M/vxMR/trPD1zzd2wLjNED76IesPLjh
UvqlYxttdHDdOfOmkM4JZ7bX+tlx0MFFdabkTBw/6Avc2K8WRYej4w5DMyOc
4DeonGj6igb+3yKH/2jwgUBg8vGMLjrcWDA2qhbZAXxFfq3mfnQ4m7KyaKjK
BsPxoa0aYXRQ+XQpQnvrdtDjLMCvmNHBtmVBHdvNB3NXzNndztMhsTmo7+wZ
HjA75euixJzPqI3TZH4VP5gU3hB8UUAHs1jvyMn326Hjac/XJBIdkq+QLcS8
dsK20oyMt8zxzotW6tj37wCbjcIne3TpwBnClTxqIAgx7xJ1jV7RYfvtUi/Z
s9vgNe90zhYGA8aewxdfQW5QFy9xvcvMZw7YUIlwS15YfBfPGOBgQOccd1K0
PBe0v/lWnceMF4WXV9os+lj/v+cPuKG9u/BSeD0dXqV3FuhTWKBQtaC4xJAB
vFIBPAM/tsCDvLlIu9MMOEXAaQiQt4PgyF/xB9+Z6+MdORCB+UtKXrz9nZzN
9Hfga+FtSuwwFbbVnpsZ7++dQt357PjgTkfe43JlBricF1gUwQpCdeFhNMrM
t7alqnu/5W6HyHjPJw+Z422atKtapi+S7hx+4vCcyaV4nn1PtENXSaqHZxJd
PRiwPfKd/N6V36TJ6x61/4IZsPcBx0d3xUWSw5hnJNcoAbQJpwMkXm8FBVHV
JX8BAvi9ybgsY80NVtFn6a4zBDhwK0JuQvAXSapTVHyj2RBePr+xnddqO7iG
1tz91Ang+cFu82y1KPiLZC48cDWCj3N/hHMqxWBlf6JWpZwR+EWu7/Q/uwu+
jltcJXcRQPJgj1WkrRiEOIj2X1EzhLi0/ZqrXaJQb26lbLhmCNmCDSVpd8Tg
UZOzX9ktZr5ZrYsbviGEOrv1pea5zaHKoYp3uG070tAfiOyvZ8DJiIv2gsGC
qPLrHL/3MgPsXD5ZJm4RQlKJWllit//3d2LshNGF7YlYl3YGKGaL3Mjt40Us
pkY2X64w4Fpe2cyDFQHEVlp+JMiegDL/mhwNFtgFaYzdswvJDCBeeZd/ezcv
ur79X4vdfQYsL+82Ylufa2h2SvWQ2M3M12wDtj1PxP6b/9EOtDWJj3FylAFv
uW2yA1wk0TiPsMYUxhzEVQMWzhTsQqKuuFtVZxgwyrN/vDhwrEERszU2L9oc
pgQG9XP7RdG8u1eTvbURUgota85N3wk2T86tLB8loFPLt5J3LIuCwMWTEcPN
BDS2FOIb9lEKgrtMXrh8J6DEY25KOSfFYMCr/K9amBFi1+O/O/dXAnIWirAr
z4yQEB+826yQhqBvpxpkM41QVbbh30YbWTj+sOI4Xw4B9cnPRN+vEIC4F+b/
6kQM0U4fY0cK93Yg3xZPCK8zRHzPrTUece8AYR1pWvpvQzQ51LIUOrsNEoIb
f6YMYoB+MLE+Ca8Grp5f5OIxGEg/eVc5IVINLAsWIxgSGJAtPH5kwlYdtlYe
2RmngAEfj0xxz3MqcH1k+0qUNQZUCmwC5euVQFhvTtmxXRduzjELYZYS6K1b
ZeidwkDX4KeVfU8U4WFj+SAfHwZanJbFFa4rww7rJi2/XxiIWD2jJT6pDKod
VxzvLWPAQeH84eibSmCaOszPuR0DV7SwlNVvinC2skDyWRYGrp9P7l++qAL8
FAFBb0Us+N0vvExlVYW2F90dG2VYsDl95TWNVwX2cuKPhx3AQoH6qoSbkTIs
1HDu/HQSC6uO+Zzc+7Thbc5RX71nWNih4zhQs0ULQoTG8v40YQHz6dRDUQ5d
2EgNWHBhYMGaNSiT0KYJqiP+r0v1cSCR5qty8pgmXNwWQRhKwwHHelyIbJQW
ZM78jvXrxYKLh0/3tx4t4L0TUnr+CBZMt3znyrHXAck3x95/2YsHK0mMfjBZ
C+q9R7iLRnGwOLuixD6nDTefSqk4auCAekarMt5CC1hFXixy38DBna3n0vj2
a8P2zgE2fgE8DIrI/Jl+rg6jlrs9PLBqcDhBOVCrAgcj8cU9c7PyUJXw/aYA
06/5U4TYyCFZMKt4J2pbioFf061j57fKgttVqxcXwjGQ1ItFk1qyoPhN6Xz8
NxxEtao62/4Ug4/1H28wiDhwAN+6U+rSUCa0foSxhgVSOifb9vcywLWw6nXZ
HcesPzzXN+slAd3TKM1qxgGj38Gq5aYs3A3a9pmWhgX5kbq+PVukQf3u3EJe
EA4y9FJ6xyUkgR4/oJGlhoNXrmc/pKbLQopQiWcvH/O8crK/1GVxqPB0Gf1l
gYXLb8PUDm+IwSv7SlG+18z16HcMH+4Qhz2mZzSbW7FAnLHUOO+4CxzSrknI
5mOBbl5GljeThCmjvaJGkxgghAZSpnVFQTQj4PBdGSwELCvgs9ikwYR77GGo
MxYcwpcP5USIQGnklArDDAueethaswhpwD5svbvxBwceeRdodFZZuF4S8NmF
2V48sJhP+JAMqHqp40buY+GeeMdJ4UeScO5Xw7pHCRaE8zfxvUkKMKObJCJg
ogfbXruSho+owKEbvb7JiTj4ZF2c5uKlxGz/Yuh3gR6UHHs2KCSlDEfIxyyv
GunDMa/Y6Wp+JXBSP+occtgQoDtIGD+rBNqyb8Vs3QxgWmlzd/kBZUj392re
804fuPeQnJ/7KAIHxS3DsEYfGN4xRwQ+KkLJwgEXfW19aGPohLf6K8Gzm1Ua
wdn6gNfe74qX1oKk29xy8r/wsPSM57NKgS587N7COqyKhRUJ3tmQdV3wc7Nk
s7yIBe+WssppEV2m387ftN3EgLuPKq/IDR3QlDpz3MaBuY9Opa4JOjPtnxc9
ibuDgdIknnXxch24+r7s4KgfDm5TWlIOMHAw6n99iFqFBWM4+eBmHwaefY64
ZlONhSr98Oxt+7Dg2vnSaqs4DtLWrC3HVjDwhKy87laoB1uPOskKuRFRIm3g
DncZBYy4esM+jxMR9ErNF16kADv9QPbXSWO0u0cjk+sJBT7Fv1tbsTZGH8y5
gz3qKVCllZ975hcRmdgQWIrbKJC/RyB4fwAR/Qg+3nPcjwJ2+y493RZqjGYX
2FbkL1Dg1ne73dY1RihdLpoyxGxfWJD/WcXCCGVjSAui9lTYmJY4Ps5qhMa4
WkTjOKggQOZwOcFhjBSN3px+K0uFAzqvvSrYjdFr/uM9DtMU6Lpr1Kd6xQiN
3HxXt8ZOhR80VgPdCAIK+VZc9XMvFR5xc275OUhARI61Y73GVDgVv/DWWoCI
XkwP/wQ7Ksyk/qqTyCQitnpt82ULKqz9MhxVtTVBSbHOB7pSaFDKM3EwfJsJ
GvabfvxdkgbgMcA4cNcEdZtKzmxXosEx2Y0Yjt0mqNRRpjxiLw3uH3um8S2H
iNoO1a2kHKIBVqT+TwizP+3up/tkJ6iQ/KxvCTqIyKjxiM7xMSrg23nnnH4Y
o5XYPRLrG1RA1yZNEtqJqNHn9y/9XBrctTzwYGiMycVCw/S+03SwFzBrayWa
IOtIA5FBHjrYfRMd8VMwQUpVZ49u7aSBg3PcbYU2E0RyfL5i+pUG1eZzGTba
puijvyyrBRcdJqdwQjVNJshmwv/s4aN08BxcEOzwNkV9I09E2/PokCTxZIX6
1Rhp1RdyXHCnQdT2VLxkrwlartujmZBBg/LVp/k8RCKisIc8/BFBg2Z+i9OF
BwCF8p/0q/FmwL6PUuZy6oCmcg0/P5llwLrGSb+ZVED1om2pGs3/c5+1xV8y
HlDQ3rfLt5hceTK66FyLFyC5nKEiw3EmByu+vY5/DShl5d+xMSZnCktH6k5N
MdPfgR/3Q2PMIbHoPOOYH6DHso0b1y6agz/1U6OcvRlqV+i4rcvkyhH5Lq/N
fEDTta+T94WbwzqnU8x5ATPUFUtRPE35X93T/v/ezyv/cM4jys4MWbgeiOFm
6qIbdd0lQTvN0IZpYvmJdQbENbSol1LN0KO14bSrB8yBYyb/kFK6GTLwnXPv
szcH7wwHuUAnM3Sv32+ZGRpQUG6gIJpkhu58shFLYTeH3IHHnXO3Afnl7pnh
fmkOvN5k6bVLZkjwlpcA8bI5HB12CNX8DEgv4RblDDKH8ODpY0FtBLTAk5O6
f4gMVleP16QGGCGC5e5varlkeNjuQ75hY4Qc50+YFxwlw8udbSUOAsYoAJzV
vyeRoUlf68VvP2Pk5GxooLOfDMOtjJLzDcbo5et43GoeGfpOGpzhWzdGwRWi
63p7ySDwIjb4uhMRpbiaxuddJINsOr+boyBzP4xSzSS6yPDrAt+8q6MxOmQi
LJPZwOzf2l97iayP1q12PW+8SYHV/p1J9x/oIWRgy1hLYOaL2+Y+dRIGqIrO
bdXdQwGWOGN0H+khdsHnmZz/aNARJBxzqU0f7X1rbTmbTQFpd0bFoxx9xP78
1tnRjxR4IoNVKczQR5WDVng8nQq79+q4RTEMEF1uMCs2nQIFaLHVgccQcdS6
S9oPUiBUuSvL55YBkkiVH0CtFHjaJVt0McYA/R+u3jwc6uj9GydLQskWSfad
LLPYZszcY+Y9M2RPQgoloUSLpMWSpZCQtU1ISgsprZQbUWmRtUVJQlolUUn8
5nM9n+/3uX7Pn+c69znnPufeXq/3um7FtV3lgnjXZdCVfYqs0WZCSDU7lw3M
8M6PFvcpKJ45nDj7iA0dFx0DP2hS8bHkpi3rjgn0XeDy53okFatLtzaMfWaD
vUYyZ/FGMgYpwZcrTBbI2te5zbUwR+fLBfO9C+hglBCzNCDOHJcsjXjL0KXD
5Pm8zlscEoZ1eHwaZdhB2+F4t20nLbDkR+QpEp8BpnNUovKOk9FnVfipD1YU
aLjzoXnveRIKJVwz8hejwJfXj6t4T8no/O9lfK4sFRYEnmwfdqTgiwtZgQkj
FKi+YBMioUHFeYOxZVKbqLD5l3naziIqNgevucekUsH2hvnNohcUnLl4937g
dwr81NhCvVFMxbn+wa3Cn6ig2lxian2agqV7a/UKAqlwnvQycH4XBb0yOHfi
F1vC64eNGJhHxUl3svCuDEvwW7H6ra0FFalvfXiur6hwRCFcykKKigG2OulK
gvrIJo0xxwV42u3pyY3zY9mQtJW/2sfACGIuypjFxrHxjcz31sg0Y3jLSkt2
j2TjkaVO2QvrjOBS8ktnTWc2DpyojDlNNYZDh/alRcywUdv/8ZGw7yaQtEfn
QnIVG3Pt0TxljjGAc/f191fZGJCU3FXeZQjP3Z0fv34kmC+m06PqnzFcuZed
G9vGxnvXRmqP8E0gOmAsP0ORg0pv7qR/GDCBMuV9PS0f2Rjh8CbbJMsIzjrT
mo0+c3CSHz7u3mACIlJvbd3SOThwruZx2lMTyDzjmnRjOQcrCsXY3samMLla
FLuDObjtdrMobacAp067L3m2h41DY6d3F+kYAt23nJss6K8/WayzwNQQ1DSU
Z47KczDVvUr8k5g+pO+49GehMQc3hfBNDVYagcz4vXQLJgdpnkmoccAYrt1p
ueW9kYOzPjP/wqUMYOx1U/nXeRz09BhYfHRWH3J2HmnTX8nB/NAlwz+f6EFm
yH1j3UQOFsTdK9SxNwLPuyoXA+Zw0KLX+UoHz0hQxyc3LM7nYFnrn84N541h
Qd1d1Re1HFx74vfkTUk9uGtnpsZw4WB1ctino5G6wL6ZnPSsno16j8gFP+br
wMQ9vR4bHQ7umqGfchHTgxuDve9MBfN3xKz3H/qpA9KaHUv+OHLwPSX1+arF
+uD6OzBXUTD+tZZt7YMxHfjscTrP+B8b459/0CjYpA1jnlfpi09xMCKlJeOn
jQ7svfq+PuMuG9XqflJM/HVg2mvzhfr9HFznOaFacVkHbhaGVCjOCOT3O8LN
xzpQu2pwZc4dDj7xPTeH4a4HaeeT5raMcPC7zueE2H8mYHnmAyUuhcCnj1d3
jUstgyS3t0V7vgv6Oy3tC1/rwP3gT5wkFzYa39dt+xmnB8JNvouYRgJ/OBqZ
KhuiDy0fL2nIaLBxYT1cv62vD+sj9ZIfb2Hjs6etafdNtWGX6qLDs91svKio
4+5ioAdlpSdj5lUK9Pm91O9DmgnY25PPaTRycLejqpfYQ2NYd1A8NkmewPcv
8u8et9aBBZ8sxiUE8XBG6mHKzLgu7N/RQm8SzF/F9Ci++Fkf8k6ob7c6ysa2
mrTONWKGAEebyYPJbPwzx/Bq9H5DsE+Oa6jjs1F4iZa9To4huKlRfBuaCVzH
2aBT88QEvDTuZhvQCOxManx7VkMXXPkHeQcPCuJrjqM1l6MHIoN++grlbJz8
e67y5ncDkLlJfdi/lI289f+SOzYawfert75VryWwIen64z+jpvCVvkpMzYlA
4Q+dWY0e5hDQ+8dazp3AC2cbtRtfGcHEAcXPs3oEak2de2Z/0xju2tS4t2wm
8OGHDvLnb8tgy8ozfhxtAjcNWCo96jOCk2GLFByqCOw750EN/7kMXMPWM+VD
CCQfW959fK4ZSDgN+qSwuHg8ImfjT5IZlNMGzfe1EHjaj3IjutUUlhoO+dWm
E9jvVdl9Z0Igf4V/6mwGgdm1Jb5/bv/n+f/fZTRZLj7fs3j7v3vmcGao9OZ/
vqtr7rdu7A3NHBR4uZH3XxF48Ou1j05h5pDjHXis5wCBQSHek5c/mMPEy3ke
SwIJvHxdvSPShASc8cC3vpUEriiQpP69LuBFD7u2pXgTGDIRa1UyaQr1b6+W
p8wR6E++HlPabgZbxWX/5hgQuK8wK93j0zKgjlTXRQnyy8KHgeK9MkYgdZrn
WphL4A6LgB4DHQO4/eOimjCbwJKTrnkvbA0h3vTZ6i3+BLpHPXFSEeSPW337
N54RIdAjvX06jWEAV0JKlvy+xkGTpYHrMpyM4Vmmc9Pdm1ycO5JYrnXKDC6d
G697I87FxpmFyW+tzSE/JYCyxYOLuZ9HKuouGQLr3QuL+lYOhu9tTv1aqQ+k
J19T1dI4uGL55gTleiOgOG26AJZczL/RNBzFNgerVZqBFYu4eE6otjV+hxHk
rIgR3zpGoOaWp850CXOQHKt8eNiEg0csc21a0syhPTaZ472WgytDiYn+eHPI
ZedJ9J7lYFF5wsipi2ZgqluxNuqoID78FHbgHnMQYUoPJgryi9iYmOnKPWbw
O82tL6GDgyV7ty+6omgO9le7fUIF+fDBi4lL94zNYP/NdO8RNw4+t9pxpbjd
FOa5NstXHeLgXUv1A/mHtCBHI0eDMW6PRTd/V2u1UmCY+nmXViEX4Xg17f0r
Cjic8BvuEdh34Ie0yarDWvDkfa/KmgA2xtpbmWutV4HGhw8TppvtUWWXp823
wyowUrQhr9LTHmffWtYtK1SGx83PvTpr7TE7P7QrxGgJSPdpPNl42B6fbHL6
/iNTFWi8Jbtt/O0xo1X+VK6mHAQ/8n9qO2OP68fcV77JVAImN29Fji0be4o/
/goiKwKLxWM2/bVHx12HOxrWK8GGmM79uZoEzv+x9tXQQnn40XOmJ3CCjTsi
h7y/H6XDr/QjZSpBHNR1POu4vZIFRPyr9vSNbKRLmc59r8KAzcIv6rOdCfy2
M59xepcVrI9SuY1febiZfzta4bclRK1od+Jp8fC/7wn+7/O3ydJOfbdCmBBV
Wcv1XcNGN/Ujh1+k2oL8A6nrtiL8/yNvbf2/8rUipCqr50xIGY/gVWWy0fCv
wZaseCYMv2ZI3r3FxtCeV6X9ZCbM87dY5T+Xg91iGy9LlzFB3XZfgaGgbWuj
IRFjx4Cu93kZuVNsrE6yyD1gzgTlyOOjHc4c7Lv4aJnvZQZUltZYLzDkYH/p
2ptFtxmgtaCXOvWBjcOM2Miuejuw+dp14aegXnxVmKdBaDJARCXuxR0uBxPa
Vm+ed9sODg60RT4W1P8jET3n5A3tIJAyLbaUzsHgO9vMVsczID9psFlcUI+u
BOT5JN1hgIvjT90Ogb+9vl0/sETbDlryPL3aBPFhmpLZfqDADvTVfQrfOgnq
PydiUcoJOkh9vB73rZqD1lcMFtgl2MH6bdc+pHdz0O9LqJm1Kh0apJcelhP4
Z1LiQ9aPbhq4hl8+tUGGg8lHHXQT1egQ3OjzLorPwTfxCvaxh+mwSm96zqNp
Ni4pnSy2i6XBCeeAx94rBPGRn2LWJG4HIQ4qM83POKghvq+8MdsOTHuWhfTq
EKjb8vGoohgD1IfqqM71HNwoInmmtJABDfqBNmRhAr/GHzDvq6PDt6u2+R5m
HGy4LH4tyZMGGjerFBoF5yP7WF/ibAoNRIOYFmEP2OhSSs/MlaLBoIJBbTyH
g1rO1lLvTOxAafeTBTMsAmlvRPOuyjBgvaLR1JAEgRayDv4Xp2zhjk5Rq+0T
NtbtuZXx94QtlIrGC50pEuCzsbdt4ma2MOuTmj8pwAe9SUftApbQ4afthZyt
Avn9ks/FCRmArNq/TvUnORgalyfO1gNg2QZq3BD4Q4nkCc+yLbbgR9K894rK
wzRK2KGXh+2h3Mfg0Zc0Ab7IHW/ppDNBevfs9uxSFtryXHYUadhB1O+r6/3N
WGjQc0SfHEmH/aXLJWdU2BjntnhLmhwPphW0hmNnbfBIoZrn5hwueLmv68iU
oWPeB/7FHW4EvBhb3PMhlI7ytOXae5Zz4O7N02b0S3aotEba4X4BByTqfav9
VjKw31Rc7pw8AaqvpFKpyxmYEXLLO7aHA1fHNioa7mTgu+PvSmxGOGDodqxh
yw47jLARnlkzwIHtTi861CftkG9IhI53EyDLcL6Y/YaB7wfieMsP8+FfbHvE
oVgqalWuvLwohge198S/MU/Y4Fzyufdh2/lwUPfT0Q0xVji2NeFZhQkflvRn
NAcyKfiRNI/dS/DAm1no1t1CQ/1meYsqVR7MNNhm7dWg4wp/fNvSw4UMyQhq
eRQdjfpMh3Zo8GGbSVFxpA4d9da833urhAcmI4EqagJeucd950h9IxdEDr6t
9/pCx8pDdREKi3lw6WKj5kZFO3xUNTZnZSUP9J4mC9Vo0fH4JquAq9t5UNc7
OmfqvC16fq05WevLg3BMXQlUGj7RSGk/0sSD0//OaCYJeMNxkcHVBYd4kB/b
3FNcTEPnpcGh3z/wQHr5+Jn1uTS033X8VcR8HlR+x3PtJXQ8ATs4+rv/s95U
UB4wUayYYUOJ5MGaBuGfDZp0lPOVdLC+yoOmy9KpZ/ztcN+9hRndc/jwpfVI
4WNZW3RYxmPfHeXB8UVfnD1+2eLC6n99Wyg8WCtdqdJmw8CPjJPhmZt4sL9s
67+C+Xb4e9+6q22HebDw/uQXzjE6Tt9ZOHS4gQufTivIlb22w91WxMyIDA+k
fu7L1b9sh+od86NzwnigWRjhaXNDYO9BqVfmgTyoagj1MRgBdJPseN57jAcf
/yby9kUxcCXv26IlF3kCXqXq5P3FDnlOz1/ke/NB2jdZVewQA/+xhD1bpwT+
6j4p0uPHQNXLoRqqW3gg8aaEzzVmoOHjo4Zxz3lQfGTb2cuRg8yUTwnhOx/a
gM/Zz+b28bPMlZduM7WMWbBjX94NnRUqkLXaXCZilw14PlszMC09ztx2Taj2
2ysbeN1ffaLXE+s3do6OfZxjCz+z6+LmSr9hyu1d1bPtgw3InVouEab7jVmT
Z/r3xiVbKEsZ2BW68TNTeZOR8Ym3tlD+S5r9IGaGmb5yXqz3NVugMleXsBwn
mdovm+ws79iCax19lVStMvTk0Lirom1h3nB1k7bcG2bscJMOV40FYfqyJQfm
KcOCbUJuD8Os4BtFxkv33R/mF65E98N31hAzQ6q58kMUFIIDL2cesYa29a5l
TGMJaJCIvp511xr2pX6dSEmU/m+d+p/69p15gLzvdORKa+ityBNuXi0Cpo+G
nulo24DhJ9WYN/tkwT3twPBDLytoj4isYvXNgbbUrGh8aQUVm7dvtDOQ/e88
1P+db8xH266+0RZiG32+LzFXB32xx7K5f6zAb6Jyz6kwTWiSiTiQIdDH4MDu
g9uCF0Fh5fYIZgsPNo+Pdhyrl0DSj7O8++58kLfT8AqdnYfqgXIbFGX4QGSX
iGdJSOCXD5G7h7z4UNibUnN2zXj9tsdq+nXmfIhWTdJ3SpuDJQO71FUHeSAi
oOSLr6hglHjfAuo5HuwKrneLLFXFN2MtPbQSPkwGarmN1yz6f+6/aaF8lUj0
997/XgfTUEXVn9z3T+/yQdFvmYXmN+X/v3y/Ih47ylY3fGKDDZrkTadrFKG4
P+SDv44tXp0xTfOlK4Gs1YroMREazkkI2L/x/SLwe5FOHCqyxVPx4kYnm+Rg
mXzQ1rCtNrj0V83Nw3GqYDqwnugftcFT469ORr1bAowZyUsZ1jZ4y+/nu1I9
dQjWq5w3Nm2NPqc4MbPuGjDjbJrbXW2DdTuevZLuUQebaTWK1oQtDh/wpZgY
qkDaqMVO/YO26PJtQXehmwosDh8+Gy5MQ70VN095bFAFoacKcow1NFymrG8+
eHYpXHv6Mmn/bhruVW8bHtu8GIxvlrQXfKehfMy+s1KrVWDloYwXx9pt8fbS
eSa6u5Vhcsu7S7EcW8yZSpnU71oKp3D7kZk0Gzy7vfuu23lZKNr02nOjozUa
+Xypfy9oG9zbpDukbIMB27rOD4vIAL1+K1AjbFD+dof/8GJpKLj+2nG+jA2m
g3pzZrQwHN1Hkso+ao1lDweObls0H2q0xk5v2UKGUPrnL+2SBlAEq54e3E0C
o9KoAybnzCHqOYd+1YcE5lK7Xk5YmYPO2+FNrcNkGKQxNH1HzEHth/OGRWkk
aNZ6e87KzQLy5+uknbYmQ7zkhp//jpnDxkWaS2+7k2EoJjlC6okFnGYlaCj3
kOAX/9QlqwhzGJFb+oV4S4KFLK/ognFzSOzSvP2jmwRTczJkxmssQOKXInf5
X5LA/x/bKDBJsH6+040zayxhV5TTjxOqJuBp/cpcl0qBaeqhNnOyKZxbaPfE
35cMMo94wrLHzAB4HzXdfpMh+1b/Skszc6gfExKzv0WGHrangpKXMURUFEhk
HSHDN3pBwyDJCF6cX/HLOIMMUyFOk6lLDOHso51rP9MoILL6bcpOOwOgOt9Z
fXIuFVIW1Zlllwp4ke7fgV2pmmDyznRkE9MCfj+0jHtWrwkUiXNjR55agMHZ
byUKBzTh7IuCybRCEoTJFzzytlIAEblj/w59J0F5UWX6OroCtP+QaPDZQQLV
8p60+eImcD9ANnbFNQpEM9/Xvp67DLI3B297a0IBxw0b5i5QNgHfRy9e6HlT
QcHh8qQafRn0xb8T3ZBLhR7Jqte/d5qA/GTpztY+KjyTXROzIc4Mgr/2Poo3
pMJvc9PgXSxT+KV0IPWUNRXq1q10WKJiCofDCzfdLKFACknX7eJqM9jnYtdd
cIAC/yi/3VKkzEBp7WhFrrwlnIjXznonONeXh8+Rrf+QIYhu01n51BzSgiLd
9jaTQfLWWN/BGnNYrJz5W0GdDCX6vxflcs2hu5iVrnObDH4/ew7m7zaH2tQ5
E67xFNDWtVANmG8Kjlt32kSMUOGKy6eDK8ZNQSv5dVmAYD8K288XXSwwB+6b
y9yeGhIY5O4fe77IHOSHhf7+eEKB/sA3SaOfzKH3ghCkR1Nhrl9x7Zi7Objd
3Hp0xxrBfL+f/jCuNofN2x7nl09TIIldwb+cbQGeiyQjdPoocNAw+ay1ngWM
r8/uPLtQsF6zhSlpuwV058ffO5hAhYNvaxtkSBZQ/aP8VyHLCjb9qNjfqWYB
S3V9Fs7ztYQ864EX1/Ut4N0yFZ22fioEJ+naRrqZwYcmffEfrRZwuDy23KLF
FFrD4m8b6pJh73Kx+ldnzKDE7W+A1kcS+FYnRxm+MAXf3T7Nt06RQaj2tg2n
kwSHLnZpfBomAYywRGbe2qJBb8tz80gOeK9bGqiqbouKd51yF49yQLKYn1cv
yC9N94bc8jYKcN/JBZa6JbZYdrm0L6SOA7dvPOokjdDwpOIco8NnOHBuf7AN
/TQNDU1GWRp6HChWu7Do7VxblLuQv0P/JAeWs/378sZs8Vyin4wkmYDv2vNA
e8oaC2V6VORfcWBA4dLg0BwaBp2IuvX7Kwd+ehkZHcq2ReWLT16NzSPgr0Uv
uNXYoLhxTeaTWgIOSfrvkGfY4oUjvtfdNhHw4aTfp5cRNPy+XEy9X4mAwx63
9tUfscETNkZWrDYOaE8axHdlCPK3V9Q1lWwOJKibmTM32GCzDvc+n0VAWXBA
p2iVDSpRradWzydAZ6dHrMoSWzy8Wk55sykBfZZ350jq2eDLI/1/E7U44J60
GwdN6HiNq6v9Xo4Dx6dyB1oZDBxYtN+gKoQLEXe3DBTsscMefvHunz+5cDph
lYNQLQM3dj/4EvWdC1Fy8kXzDJm4Y1ZebN0gF2ITJcPfqDBQ55WI8tzPXGAH
u0Wc8WbgonmnVe4mCHCYyy516z47ZHSdElGs5EJieWH5hbV22Dcye253IRc2
Dt0xcL7GQC378MdRwIPOlLI05bd26LBr8YJLTB5cmKRtmJnHRCfDdboFmTwB
btJUWLeXiQdV4xscN/Igc+7+o6ccGahZrFa7QJsHQWxDvZ16TBwoSbSCRD4M
JIfT30cx8frk5+puAc5bGdOVx37MxLy/i5UpAwL9auxbhI8w8cf+ZZKZ2/hw
uOFCwsFDTFT6FP3yvR4f1kwdJwW8JKEe6UWKjykLaMMjbE81QA8D11v5Dny4
n+P0J26KgUGHdlmEuf63rl/+v8/Jxskm7kwtYeCTkPDhe6J84D4Ofk+ZscB5
8jU1CSIsOGZuuIl61g6Z04Vr1ubzQH/JrHPpfCbKxOQytJX48GSWtda7TWCf
VM279Q/++33LdSx8fXV+h9Hz/8ER//e7YM+ulvGKxKg48UzU79gf9v/p38X4
337d2cGI3yw6phy4n+9hQcCca4vt3t21wxuOWx9aBBAQsFGkq80AkFLq9NHo
2n/Xy2X97/h93a+W3FH9z/2zyEyPBj6Iyb1X1pK0xpIDkWKWuWzQWFR2+ryn
NQ6IugpJhLBh4eTl0pZL1rj9UU9W4xAbDJqmDi4yssGhXafbIk6zQVHtXVr0
QyretLJ4pN3MhqYhFzjdR8EDi/ZnuC3jgH5rjUTrUyqezn25MpXCgdeLwhgH
jC3RIuZ2zfAqDng8qrv1fBUV9z0/eClVnwMLn1xXK31AxppgM2GmBgt+i5z9
2vCOhCWN56SShgAMqMO98yPIOGNbqba+lAWJJAmWoiMV1YkHKyU/UiAs1bvy
n5Il7tMQulX/jArLX5oTllspyDC99tSlnQrzYlJ6HTIouHmaLGRwxBIiItrs
n1cugxWZh0fVT3CwsNNkU6OwJqx6U5cW+piDQWdyp5kXtUBOvGaUZ8DBgom5
P8MnNCG8+LxiryQHX3a6OpCltAT14ZjlgX0cHPc3c64O1ob3r8bqM3w5+CU7
IkZeWAseb5GII/M5WDaUb+ITZQH31u6pXPGOwK9iOV8MN5Ghduem7clCXHQo
dbC6H0YCF0rrtKgvgRu3+ot0yJBg4lL7Ae0YAouUh/lBsyTo2W7VFHKGwL9V
6UIS8iTQmi4/lqFM4OqqNZyb2SRI26RQoJNN4IFB9tzHqmTYsOPFlmNOBGry
aJkZqQK84CG6UF6LwDGtOQVhmmS4/k1E3nMugc5NWdejBPXk6eifxPSFBGbG
O9HnRpPh3CmKa3UCgcNE9LrirWTQSgw8rNZAIFz9WhKpJcArp7szQ4YIpBXb
uAVPkeFJK+/fl1MEBhVfzroxrgs1f96zyuII5JxL5t6TN4CXxRsW6kxzsDxe
aFmXgz5c0lrfn/6MgxKTK1XaF+rDU0aaf4Q2gXHl423bXuuCssmvA7EWgvMa
letVNNCHMOnoxXlbCdTPOTsTq6gPjInSwX0kLj4rn9334KkeiJ5+p324ncDn
nNt3j38V1CMp40SKPw9HXco5u+QNQWvrqOfkKQ56nBK1UT1tBlUUUYNlk2ws
SDTSDgg2hSqPIB2+Pge3n3F1a22kgvPTRTJeYVw8f/DJ+eQzi2Dab05OT5s9
hvCqVfJj5EHosUHrWLo9bhnY+NurVgGKO66VFd+xxx1auZfG6uRh2NXgwitv
Nr4aEg5uPKcILHHPwx8c2ZhidWT5r3xl2H8mXTInloORyp6bamMVwTAy2fXa
YzbmvVrwReaZAmzo059Xl8nG/MEjZ682K0KS01tNgs7Bub/ubo25sAhWCtPg
lTAHgye+hl+SXQyBr9JvpRhycLfLnctbspSAx/AqqHfioNPUs6d/VFTBeZSj
OBHMwcbyT3P92aoweaHBea8eB/O/wtFykgqEcB/c+7Gag6HOM23OQ3aQxjC4
PcTkIov82IA3ZgV1mcEXHKd5qHHEpeyEhxV8at931KCKh+e8JvekXbaEwUfn
DSc+8rD28tjW7WZW0EOSyXzkysPTq54ttNlkBVZCrs0Vyjxcy/k2cS3ZEsaM
P1/c4M7D3tk521L1LKGmbUP4ujdcvBBUnS602xJSFjg4SSzk4dXlI5LHLwr6
dy95eP4ZF0ei06fMAqxBJ+NmXEgsH0voXhn226zAILNm6thBPnpkPd86/tUK
7tdt/Khwio/rg3JLHx6ygoiAqzNb7vExKJ9g1Cy0Aq0SzcbJLj6+uJvSdDTN
Gmj7/NulBf1fwzvfrNKlwcRN7b1hcgL5wAM9H4uZ8LVkwZS0MRvjfYbd+wcZ
sPDauRpFUzbeMt6QPmbDgCWuVnG6HDbaRq3JW76cAemuwrcdTrGRvWpX+aEP
DHDJZL7p3MrG+8Olb6a67EAtgrJ/dCcbJ4vKyxKl7SDi96pHH1PZuCU3bdGq
Zjs4PNdg6/cGNp5/uqjiajEdbqwJFJK9wcaJTfZLrsXYgf3jj9xFhWy8/lKn
aMMeOgRMpOpKhbGxt259xcJeGjwOv2xcFM9GSe9re2qyaPD7ToRekAcbtW8G
u1buYUB9h7mPUAQbH4/tvXRokg4RK11XrgM2bg+ud3Lsp8NlyeDKVWJs7A/u
Gqq6xYCGYVe3ty4EVmoaJOgGM6A2aPqj/2MC393R+70phAEp+v9k5h8g8HXn
/HJGkR0cL5dRCSsh8IL0et61uUw4YJy/c+4FAlvrnT98LrODR2ekBtrWEbjz
4flAExITLic0b51242LPnXY5ye8M0Mx8wH0nyI+KX/bfOrUKwPlvw0likMDC
hT8szgYKztfcIfzFIi52qT+ufrufASs2/Ik4sZ2LPpJaIks/MIGI7rmvcYVA
EZ1DzZt2MyFfboHOUD6BzOGu1NwdTNjtwB7N6ifwrGHPWjWJ/1w/td4vIs5F
j9B1r5M0AZh1N9VXdBL4Zs68CYwEWLb3kBaFSmCExVN3JzoAwTx1vWsfgbat
GapfPjFhekmY4roNgnx9Q35f0A0mfDsy8C1LkO9ETy+bXX2eCaNe7bZ3BeNf
PChs/6AF0HpaQrZbkO+mFE6ttTRkgnVFR9RmWUE+X9jm6+PBBNHpoqEfnRy8
mdK/bE4eE07OHRmK1uLi37DsoSYAUA5+InyinYsrbnQfeicP8Khed9WmSC4+
VHQdL7sAYF++t3xGsN/l3GCxH34ATev/WL/q4SDJ8UV8zGKA4e6ki7X9HDy2
znd/oyOAVpvfnzgKF7Nn6u97xQBEtak5VmwjsGmzxYLzwQB5a5jPdJO5eFyz
782fPgBVUsMDNW0u3rx6/HHIEQDL5Jre5wJ75Mt3r6O4sKDYibM6VZ+H1Wdh
suYSwLZ/q17HBnJRVnn/3keNAFnX1x+bekNgIv3Ww6CrLJAWkmLZlhF4Navs
QXM6gOFo54JzDwjcPyqtIW3OAhv17mMKOQJ/iom+tumb4PyXm3XvOUcg9QL/
505DFviTZfqp3wjU2HWw69UnAMZ29ia6KYEWP2I7HasAXhVdvftoOYHrP95f
UTQDcFpUvbc7jEDKjhvv61azQMV2x64xIwLZ30Y2l5wHWJw+TTr5i4OTpL81
fWQWNCZ+zu4o5GKQdt29+iKAzqbEUOezAjzwpdn3/G8A113TXQsE9eJPr4TO
pXsAKgrlVk8GufioOvr2Jj4LvBxOaP1gcZF8vSzsxRjAqjuDmhlVXNzGmbPg
6EIWdHIMuJt+cXEwKn1xYzdA/3CD/q/lHCwJKDKVKhPgoNXqSi/LuTh0p5X/
OwEgVM+/b00/Fzf+iqsXswC4t/RD3NFKHtblrJBtdABImbPX2YXFQ52mUkav
EgsMG8TdXXW4uOd8xy0JN3tQm6rwMKnkImX94dz+gyww4SX9SJkiUHpIZGnh
KhZYbvfeIPqai+Xv/GycB1gwfFydc1yeh217XimU5LEgtnt/j5wkD9c4tA7s
vSLwt8khJ1c1Dl42OlEfWg6wIbWaXRXOwRcjXpcZ1gL7FPNHFP6xUUlDNd/3
JwDXY+71onkcjPDYp3ZNmgWB14W/hbax/w9uFdj7f+6fXT8fIfpjJQsuvZww
WT2fi35h/rtfDwAUvYTXGhd5GKtgpTr/MQsGvh6o3pnBRfV5j54ejmcB98Gs
iu5xLr6zfx7UIcoCvf4vETMEDxdf/deYJvC3cHrLtXwPHuZPfvN2bmKB2BqN
D12dXJxeN9ngJ2MPW0RWk/g9XJSI4tZvLrCH25fYC3eH8lD63kwQRdYevire
48hkc7HoTN22U4H2MJqy/tstOR6KUDLuVGfYw/T1qmrsIbBEREXC6ScLEqjr
h+wE8VvaJO01qWkPYdmso0aC87TUdAleNsaCL/blmvS1XDRsfFbmdZoFXQ/0
7gOPi1nTOz6EVwviqye3hGPFw3GR9bMnmQL/sas6ObSMj9N1IU4yS+zBsv/q
ob8pPEzVOn6Qam8Pew1v3CYL6u+SOwEVH4XtgeYdHlCznIcp8R+icxIByOdY
9+V28zBi7keji1sF8XczXf7LVh4WZtkRHpYseFM9PGoYwkNvlzeLB9+wgK2O
BQFxPDzbL569UJAvVEp223UIxh+7q057fpwJL+Yeibu1lofvP0qdMAmxhU39
eYznP9kott7oUPlNJjiLrog7uIeDNrRpsn6UPTQcVNrgQLAxVW+sw9vGHi5U
nFzzaT8bi0Y/bj2obg/b9TkVzBVsTCq5qNn6lQVKfnrD9k1szG1weD7law9u
9lXL2COCeify7L2GqEC+NMhnIouNDOMenU0B9tBSc1iWUsnGiKDQF7wie3hg
xisLF/hX7W/h2393skHNOuDPqd1sTByRkjcUZcPIibce+3LZqGGRXD3ngT0s
NY37NK+UjVm9K727uuwhgqsqyWCxcTqZ27fwDR2kJid7XItZqJRutzfvLweE
/xVHD863wxeF7ENllRwwXPqRsiDQDgvobX+XWxGw4qqP0NwCO4zOnopLcCAg
lH7xx6n5DNQ3vzF6M4iAveF5wg8+MvDswcK/CfMIcP8bM/JWjomtHxbJayEB
b0aX8/2AgQsy3xY1HifAMOydm2UFAzW8K0g3lnHh3myOubmAxzOv/JuWmyLg
I0mu2VOOgcqsKLU4bS4sqretvX/DDv+m3Vvxn+9MaN+8sd1Uzgats9wL+/r+
y0t1yPj46tdY7VQ+zF/2LCvhgiUGaXRaOYoJeLkckXKeboUfaPQd0c18cLl4
q3+k+P95X9HaGi+/T+ymyfGhJTHhLMnZEiflopclM/kwyraK8W20RFIDBRrd
+DBJz2CqOlqicuys4konPrg2vXd4/oCK36f84isFPLbxqln7EwtL3D9fqDA0
iwc6v5c6NyZbos/XljGPNh6sa1O7er/bEh+ZcDtu3OTBt+cWfTUbrJDtY7Yu
9gMPvPgFvjvn0VFevPHw+288eJm+c7PUQzpu6JXN6yfxIeO7346bBbbYcUVu
lfYEF44v+xf6+hEDe/uCFtd4CPRxEbp6dQPt/7+/LFss0tS4DMp8uH6+M6fS
hYbh0uHkuelc2H9s5ZiLBAP9PD6UaPvwQEtpz016LQN5qln9lje4MOOtFxC0
lImyEW6fLZV4kF96JyHdlYmnrQ/TiMdcGDGRHNd1Y+CbrTv5S2e4IFy5+j5z
CQNXLPl6mdbNgzviRq+NpZi4+ddGg+7PPPgt5jo8T9kCWcbn0mME86+wZe7Y
nWiBEZZmq7hmPJDP/vQrQM0cI56qT+Sn2YOTvOmVS1u0IWf+HdPrgnwZ7CoX
+K9WAESiZB+1mNlD9PSvWrM2LXh663m5qJ096I0bZBg7akJsmYTop8X2YOp9
u7vHTwNqPZiesR9YcFdVynrtDk2wyXR5JK9kDz2rHnwq+qsJF4S93H8lsODs
+8De4TJN+JVQs/PQDRZEPvORmv6kCQX/XGw179tDECPzjIpgfRutcBJfgQP/
7tT+PKmrC1vu9rnf2s0F1dwiucgbCsDNtMxd78eDLasb9XZckYUCkTg7aUUe
RIXvlY6SUAAZ+typcYG9osduLYoNbaj/f+7HgGnOacxj8KFOtl/Ys14ExF9b
7g1k0kDjsYj4QdsvTLEdN+b/YFlDYZXFEed8GbizQntNcriAD7SrX9e9IQe2
M8FK9yqtweeyqXjbZgU4VJV4t/qBFTx1jYbvIYowsPrrjlmSNezTadgWuEkB
lvz8Qabds4btKUxiNU0InORItvOGrKDd4vDiinDx/9a1/3k+5DtTcvXK9ksv
rOD8Bcm9s23CcDNsmRJ3uQ0MEqkxT4UXwMhRM91jq23h5v6/+UqXVWF6tD/q
M88azibIcPzfLwX/jqHJ+mJruLvay1uUrwxCiprMBHcbOJm61mxnqUA/IbvX
dcdtoDvYbiI7UAm2Wdw6GaXEB6P0F3McJqTRqWmMTujyoZSv4r+7/1e9Rmjs
EnouHwoL5+eYHhmv3y0pKZnwkg+NipMrCnhKaOOkO+LygA+7SZese9Yo4omL
KQ4HQvnQcPxglGelIoblKx4WTaShdNiJOwbmijA4pFnVUkVD8fW76yUOyMPC
IpHBE58FcVN2VqJpmyyc2j1+/tdjGu5UnT1p1i4Cj74aNPg407ClYDFr6rQU
3G713knso6Fn8nbF0W8yQPO61DilS8eu+C9bmqqkYHfn9bm1d2wxo79JTOuk
DFSUekhsvEVDV2LR7ZY+aUjK/Cr/oImG67VZl529JSBt4+FYRzU6NkQ1quju
lAG7wNRqmwlbbDbgzLE5oQDffX52W5XR0Vpt4xznK/Mhghxx2Pw1Hae2O+vK
rheDxFcvkh0c6Vh43bSu1EscPLMu8PvO05Gx1C28IXgefL3AJ3uQ7DCifp+5
5S0JyNr+cdX3BjvMqc6c1tadB7RJqcCsYTs8c/zfswdHZ5kKJst91P7YYUvF
1j7tk6JwdHb3mT2hdrj743QVJVcUXj6TjirYx8Ats4uGY2pEoeBBxJ83YIsv
D/3aM/NUHsbPyI6M2dpgWey/UYaHOO