(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 10.4' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    241823,       4587]
NotebookOptionsPosition[    239858,       4513]
NotebookOutlinePosition[    240214,       4529]
CellTagsIndexPosition[    240171,       4526]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Fourier transform from discrete samples:", "Title",
 CellChangeTimes->{{3.685502744240395*^9, 3.685502775275304*^9}}],

Cell[CellGroupData[{

Cell[TextData[{
 "As we discussed in section, the Fourier and inverse Fourier transforms can \
be approximated from discrete samples as \n                              ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"f", "(", 
     SubscriptBox["x", "n"], ")"}], "=", 
    RowBox[{
     FractionBox["\[Delta]k", 
      SqrtBox[
       RowBox[{"2", "\[Pi]"}]]], 
     RowBox[{
      SubsuperscriptBox["\[Sum]", 
       RowBox[{"m", "=", "1"}], "N"], 
      RowBox[{
       SuperscriptBox["e", 
        RowBox[{"i", " ", 
         SubscriptBox["k", "m"], 
         SubscriptBox["x", "n"]}]], 
       RowBox[{"F", "(", 
        SubscriptBox["k", "m"], ")"}]}]}]}]}], TraditionalForm]]],
 " ;    ",
 Cell[BoxData[
  FormBox[
   RowBox[{" ", 
    RowBox[{
     RowBox[{"n", "=", "1"}], ",", "2", ",", "...", ",", "N"}]}], 
   TraditionalForm]],
  FormatType->"TraditionalForm"],
 "\n                             ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     RowBox[{"F", "(", 
      SubscriptBox["k", "m"], ")"}], "=", 
     RowBox[{
      FractionBox["\[Delta]x", 
       SqrtBox[
        RowBox[{"2", "\[Pi]"}]]], 
      RowBox[{
       SubsuperscriptBox["\[Sum]", 
        RowBox[{"n", "=", "1"}], "N"], 
       RowBox[{
        SuperscriptBox["e", 
         RowBox[{
          RowBox[{"-", "i"}], " ", 
          SubscriptBox["k", "m"], 
          SubscriptBox["x", "n"]}]], 
        RowBox[{"f", "(", 
         SubscriptBox["x", "n"], ")"}]}]}]}]}], " ", ";"}], TraditionalForm]],
  
  FormatType->"TraditionalForm"],
 "    ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"m", "=", "1"}], ",", "2", ",", "...", ",", "N"}], 
   TraditionalForm]],
  FormatType->"TraditionalForm"],
 "\n where ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"\[Delta]x", " ", "\[Delta]k"}], " ", "=", " ", 
    RowBox[{"2", 
     RowBox[{"\[Pi]", "/", 
      RowBox[{"N", "."}]}]}]}], TraditionalForm]],
  FormatType->"TraditionalForm"],
 " \n \n Using the expressions ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox["k", "m"], "=", 
     RowBox[{
      SubscriptBox["k", "1"], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"m", "-", "1"}], ")"}], "\[Delta]k"}]}]}], ","}], 
   TraditionalForm]],
  FormatType->"TraditionalForm"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox["x", "n"], "=", 
     RowBox[{
      SubscriptBox["x", "1"], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"n", "-", "1"}], ")"}], "\[Delta]x"}]}]}], ","}], 
   TraditionalForm]],
  FormatType->"TraditionalForm"],
 " we can write the first equation as\n \n                                ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"f", "(", 
     SubscriptBox["x", "n"], ")"}], "=", 
    RowBox[{
     SqrtBox[
      FractionBox["N", 
       RowBox[{"2", "\[Pi]"}]]], "\[Delta]k", " ", 
     SuperscriptBox["e", 
      RowBox[{"i", " ", 
       SubscriptBox["k", "1"], 
       SubscriptBox["x", "n"]}]], " ", 
     RowBox[{"(", 
      RowBox[{
       FractionBox["1", 
        SqrtBox["N"]], 
       RowBox[{
        SubsuperscriptBox["\[Sum]", 
         RowBox[{"m", "=", "1"}], "N"], 
        RowBox[{
         SuperscriptBox["e", 
          RowBox[{"i", " ", 
           RowBox[{"(", 
            RowBox[{"m", "-", "1"}], ")"}], "\[Delta]k", " ", 
           SubscriptBox["x", "n"]}]], 
         RowBox[{"F", "(", 
          SubscriptBox["k", "m"], ")"}]}]}]}], ")"}]}]}], TraditionalForm]],
  FormatType->"TraditionalForm"],
 ".\n \n Let\[CloseCurlyQuote]s call the term in the parenthesis ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"g", "(", 
     SubscriptBox["x", "n"], ")"}], "."}], TraditionalForm]],
  FormatType->"TraditionalForm"],
 " The function ",
 Cell[BoxData[
  FormBox["\"\<Fourier[{F(\!\(
\*SubscriptBox[\(k\), \(1\)]\)), F(\!\(
\*SubscriptBox[\(k\), \(2\)]\)), ... , F(\!\(
\*SubscriptBox[\(k\), \(N\)]\))\>", TraditionalForm]],
  FormatType->"TraditionalForm"],
 "}]\[CloseCurlyDoubleQuote] produces ",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", 
    RowBox[{
     RowBox[{"g", "(", 
      SubscriptBox["x", "1"], ")"}], ",", " ", 
     RowBox[{"g", "(", 
      SubscriptBox["x", "2"], ")"}], ",", " ", "...", ",", " ", 
     RowBox[{"g", "(", 
      SubscriptBox["x", "N"], ")"}]}]}], TraditionalForm]],
  FormatType->"TraditionalForm"],
 "} with ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["x", "1"], "=", "0."}], TraditionalForm]],
  FormatType->"TraditionalForm"],
 "\n \n Combining the above facts, we can define a module which calculates \
the Fourier transform:"
}], "Section",
 CellChangeTimes->{{3.68550279282652*^9, 3.68550279324811*^9}, {
  3.6855029456687393`*^9, 3.685503042062694*^9}, {3.685503151503088*^9, 
  3.6855031962245913`*^9}, {3.685503248552248*^9, 3.685503248552343*^9}, {
  3.685503308479751*^9, 3.685503354410674*^9}, {3.685503398685378*^9, 
  3.685503610552023*^9}, {3.685503667469886*^9, 3.6855037795125103`*^9}, {
  3.685503899658145*^9, 3.685503899658187*^9}, {3.685503937319743*^9, 
  3.6855040099724207`*^9}, {3.685504113083529*^9, 3.685504272278517*^9}, {
  3.685504317098961*^9, 3.68550441568677*^9}, {3.685504499828925*^9, 
  3.685504519789237*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"fouriertransformcalculator", "[", 
   RowBox[{"function_", ",", "kmin_", ",", "kmax_", ",", "points_"}], "]"}], ":=",
   "\[IndentingNewLine]", 
  RowBox[{"Block", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
     "\[Delta]k", ",", "kgrid", ",", "\[Delta]x", ",", "xgrid", ",", 
      "phaselist", ",", "glist", ",", "flist"}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"\[Delta]k", "=", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"kmax", "-", "kmin"}], ")"}], "/", "points"}]}], ";", " ", 
     RowBox[{"(*", " ", 
      RowBox[{
       RowBox[{
       "\[Delta]k", " ", "is", " ", "the", " ", "sample", " ", "spacing", " ",
         "in", " ", "k"}], "-", "space"}], " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{"kgrid", "=", 
      RowBox[{"Range", "[", 
       RowBox[{"kmin", ",", 
        RowBox[{"kmax", "-", "\[Delta]k"}], ",", "\[Delta]k"}], "]"}]}], ";", 
     " ", 
     RowBox[{"(*", " ", 
      RowBox[{
       RowBox[{
       "kgrid", " ", "is", " ", "the", " ", "grid", " ", "of", " ", "points", 
        " ", "in", " ", "k"}], "-", "space"}], " ", "*)"}], 
     "\[IndentingNewLine]", 
     RowBox[{"\[Delta]x", "=", 
      RowBox[{"2", "*", 
       RowBox[{"\[Pi]", "/", 
        RowBox[{"(", 
         RowBox[{"points", "*", "\[Delta]k"}], ")"}]}]}]}], ";", " ", 
     RowBox[{"(*", " ", 
      RowBox[{
       RowBox[{
       "\[Delta]x", " ", "is", " ", "the", " ", "sample", " ", "spacing", " ",
         "in", " ", "x"}], "-", "space"}], " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{"xgrid", "=", 
      RowBox[{"Range", "[", 
       RowBox[{"0", ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"points", "-", "1"}], ")"}], "*", "\[Delta]x"}], ",", 
        "\[Delta]x"}], "]"}]}], ";", " ", 
     RowBox[{"(*", " ", 
      RowBox[{
       RowBox[{
        RowBox[{
        "xgrid", " ", "is", " ", "the", " ", "grid", " ", "of", " ", "points",
          " ", "in", " ", "x"}], "-", "space"}], ",", " ", 
       RowBox[{
        RowBox[{"starting", " ", "at", " ", 
         SubscriptBox["x", "1"]}], "=", "0"}]}], " ", "*)"}], 
     "\[IndentingNewLine]", 
     RowBox[{"phaselist", "=", 
      RowBox[{"Exp", "[", 
       RowBox[{"I", "*", "kmin", "*", "xgrid"}], "]"}]}], ";", " ", 
     RowBox[{"(*", " ", 
      RowBox[{"phaselist", " ", "computes", " ", 
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["e", 
          RowBox[{
           SubscriptBox["ik", "1"], "0"}]], ",", 
         SuperscriptBox["e", 
          RowBox[{
           SubscriptBox["ik", "1"], "\[Delta]x"}]], ",", 
         SuperscriptBox["e", 
          RowBox[{
           SubscriptBox["ik", "1"], "2", "\[Delta]x"}]], ",", "...", ",", 
         SuperscriptBox["e", 
          RowBox[{
           SubscriptBox["ik", "1"], 
           RowBox[{"(", 
            RowBox[{"N", "-", "1"}], ")"}], "\[Delta]x"}]]}], "}"}]}], " ", 
      "*)"}], "\[IndentingNewLine]", 
     RowBox[{"glist", "=", 
      RowBox[{"Fourier", "[", 
       RowBox[{"function", "/@", "kgrid"}], "]"}]}], ";", " ", 
     RowBox[{"(*", " ", 
      RowBox[{"glist", " ", "computes", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"g", 
          RowBox[{"(", "0", ")"}]}], ",", 
         RowBox[{"g", 
          RowBox[{"(", "\[Delta]x", ")"}]}], ",", 
         RowBox[{"g", 
          RowBox[{"(", 
           RowBox[{"2", "\[Delta]x"}], ")"}]}], ",", "...", ",", 
         RowBox[{"g", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"N", "-", "1"}], ")"}], "\[Delta]x"}], ")"}]}]}], 
        "}"}]}], " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{"flist", "=", 
      RowBox[{
       RowBox[{"Sqrt", "[", 
        RowBox[{"points", "/", 
         RowBox[{"(", 
          RowBox[{"2", "*", "\[Pi]"}], ")"}]}], "]"}], "*", "\[Delta]k", "*", 
       "phaselist", "*", "glist"}]}], ";", " ", 
     RowBox[{"(*", " ", 
      RowBox[{"flist", " ", "computes", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"f", 
          RowBox[{"(", "0", ")"}]}], ",", 
         RowBox[{"f", 
          RowBox[{"(", "\[Delta]x", ")"}]}], ",", 
         RowBox[{"f", 
          RowBox[{"(", 
           RowBox[{"2", "\[Delta]x"}], ")"}]}], ",", "...", ",", 
         RowBox[{"f", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"N", "-", "1"}], ")"}], "\[Delta]x"}], ")"}]}]}], 
        "}"}]}], " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{"Interpolation", "[", 
      RowBox[{"Transpose", "[", 
       RowBox[{"{", 
        RowBox[{"xgrid", ",", "flist"}], "}"}], "]"}], "]"}]}]}], " ", 
   RowBox[{"(*", " ", 
    RowBox[{
    "construct", " ", "a", " ", "smooth", " ", "function", " ", "by", " ", 
     "interpolating", " ", "through", " ", "the", " ", "data", " ", 
     "points"}], " ", "*)"}], "\[IndentingNewLine]", "]"}]}]], "Input",
 CellChangeTimes->{{3.6855045223902283`*^9, 3.6855050280133533`*^9}, 
   3.685506645620139*^9}],

Cell[CellGroupData[{

Cell[TextData[{
 "Let\[CloseCurlyQuote]s plot the Fourier transform of ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"F", "(", "k", ")"}], "=", 
    RowBox[{
     SuperscriptBox["e", 
      RowBox[{"-", 
       SuperscriptBox["k", "2"]}]], "."}]}], TraditionalForm]],
  FormatType->"TraditionalForm"],
 " We take 1000 samples from ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["k", "min"], "=", 
    RowBox[{"-", "10"}]}], TraditionalForm]],
  FormatType->"TraditionalForm"],
 " to ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["k", "max"], "=", 
    RowBox[{"+", "10"}]}], TraditionalForm]],
  FormatType->"TraditionalForm"],
 "."
}], "Subsection",
 CellChangeTimes->{{3.6855050829473867`*^9, 3.6855051077456284`*^9}, {
  3.685505148082376*^9, 3.6855052209445*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"With", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"kmin", "=", 
      RowBox[{"-", "10."}]}], ",", 
     RowBox[{"kmax", "=", "10."}], ",", 
     RowBox[{"points", "=", "1000"}]}], "}"}], ",", "\[IndentingNewLine]", 
   RowBox[{"With", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"f", "=", 
       RowBox[{"fouriertransformcalculator", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"Exp", "[", 
           RowBox[{"-", 
            SuperscriptBox["#", "2"]}], "]"}], "&"}], ",", "kmin", ",", 
         "kmax", ",", "points"}], "]"}]}], "}"}], ",", "\[IndentingNewLine]", 
     
     RowBox[{"Plot", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Re", "@", 
          RowBox[{"f", "[", "x", "]"}]}], ",", 
         RowBox[{"Im", "@", 
          RowBox[{"f", "[", "x", "]"}]}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "0", ",", "5"}], "}"}], ",", "\[IndentingNewLine]", 
       
       RowBox[{"PlotRange", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"All", ",", "0.75"}], "}"}]}], ",", 
       RowBox[{"AxesLabel", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Style", "[", 
           RowBox[{"\"\<x\>\"", ",", "Black", ",", "15"}], "]"}], ",", 
          RowBox[{"Style", "[", 
           RowBox[{"\"\<f(x)\>\"", ",", "Black", ",", "15"}], "]"}]}], 
         "}"}]}], ",", 
       RowBox[{"TicksStyle", "\[Rule]", 
        RowBox[{"Directive", "[", 
         RowBox[{"Black", ",", " ", "10"}], "]"}]}]}], "]"}]}], 
    "\[IndentingNewLine]", "]"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.685505168674488*^9, 3.685505171503278*^9}, {
  3.685505238175789*^9, 3.6855053854714518`*^9}}],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
     1.], LineBox[CompressedData["
1:eJwV1nk01U0YB3BLFFnuvb9XUYSSSJRWvPFMIaEFWbqi3GsXyVKylX3fl5Qo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      "]]}, 
    {RGBColor[0.880722, 0.611041, 0.142051], AbsoluteThickness[1.6], Opacity[
     1.], LineBox[CompressedData["
1:eJwB4QQe+yFib1JlAgAAAE0AAAACAAAAnX5iBjFkez4AAABWIqD7Op5a7DpX
IFk/AKjWyrU82jvZTYpyICBpPwDcEChQIes7d0dZDgUgeT8AnGPGMen8O0bE
QFz3H4k/APCMQEM5EDytgjSD8B+ZPwCVCnNytSM84WGuFu0fqT/QVfZ0Fnk6
PHtRa2DrH7k/JJa8ZbGWUzwJ+ZvJbC7KP2U5XhUmZnA8ccJ/jOxy0z9l4Dy8
XiZ/PC6kk9G0rtk/aT40FYLXhzzlTmgc3zjgP2dEGPlpg5A8lxqGHaFg4z9q
NggHuXWUPDlyuK8DzOY/reC3kl2/ljzD15tQbyfqPyYjKwpDG5g8MYz+PhhJ
7T8jbNHfGVGZPEfmOt8wV/A/4juF3oeCnDznLbZF9OzxP/DuXifA6J88e/yJ
M7x68z+h8wgSIDihPAcR6GlUKvU/u+NF9KbPoDwFzQVHC732Pyg9nXxGk548
+86tbJJx+D+qvrZ6FhObPOVXrhkeHvo/Q+3XIkxmmjxBiG5tyK37PyIRlWQM
x5s8lf64CUNf/T877aDQ2DqdPFscw0zc8/4/s8ciw/xnnDwMwCvsIlUAQMSi
x8/xIpk8ZTWi9VksAUBSTn2kc9WVPHd+eFIg9QFAauV/tkanlDyF6pPTzs4C
QLqeknDZqZU8TCoPqAyaA0ChcF2hzY2WPI2tNsBMYQRAiilGt7OulTzKU6P8
dDkFQIrVL/ojz5E8wM1vjCwDBkDMaVUIU+KLPLJqgUDM3QZADGMD29EOhTwe
Sz84brQHQDMg+ajD94E8Q/9cg598CECOAUJu0g+DPGTWv/K4VQlAelh3bqoR
jTw+gYK1YSAKQKonJHdcA5o8km/xuwznCkAVVnoT4jWiPOKApeafvgtAedhC
t1MLpTzrZblkwocMQCJoCjj9V6A88G0SB81hDUDh2l1RY2mSPK5Jy/xmLQ5A
Qqo3bQNfcTzmaDA2A/UOQOD95dEOQ268Gqvak4fND0AoaDl3iB2EvINgcqLN
SxBAvNG6xCp3irz3/BmNS7kQQGq1twcjPIa8KLuXmcokEUB7namdZ2p7vDVj
xU8RiRFAZ/QneLznY7zAnBUYzPURQFxL1QSNx1W8KMAVik5bEkAZTp0psStV
vE0F7B3SvhJAuqZz88niVLzw2+TDySoTQFiBgR1P5kg8b5yNE4mPE0BjGCR9
7h9rPMwBJO9KkRNAB0wZPNh4azwqZ7rKDJMTQNZie7R50Ws85DHngZCWE0Dw
aQ4H3YFsPFjHQPCXnRNAaTYpqvXebTxC8vPMpqsTQGA//k55RHA8FkhahsTH
E0CWvTd1HMhyPHOt8GGGyRNAtGJ84mfucjzQEoc9SMsTQCk9mAJ0FHM8i92z
9MvOE0Cqqhn2yl9zPABzDWPT1RNA9xKg5VvzczzqncA/4uMTQBZ0oMFLDXU8
RwNXG6TlE0AbTVN/PC91PKRo7fZl5xNAZL3tWuBQdTxfMxqu6eoTQFJ8nQY+
k3U81MhzHPHxE0CeHkVrORR2PDEuCviy8xNAJl2RU6szdjyOk6DTdPUTQOlj
TY/JUnY8SV7Nivj4E0Cv4tibB5B2PKbDY2a6+hNA3WYKuiWudjwEKfpBfPwT
QNLLb8bsy3Y8YY6QHT7+E0CMF7rnW+l2PL7zJvn//xNAOlCaRHIGdzxp+DL4

      "]]}}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{
    FormBox[
     StyleBox["\"x\"", 
      GrayLevel[0], 15, StripOnInput -> False], TraditionalForm], 
    FormBox[
     StyleBox["\"f(x)\"", 
      GrayLevel[0], 15, StripOnInput -> False], TraditionalForm]},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None},
  PlotRange->{{0., 4.999999897959183}, {All, 0.75}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 0}},
  Ticks->{Automatic, Automatic},
  TicksStyle->Directive[
    GrayLevel[0], 10]]], "Output",
 CellChangeTimes->{{3.685505312290595*^9, 3.6855053913654346`*^9}}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "As expected the Fourier transform of a Gaussian is a Gaussian. However, \
note that the above does not seem to work for ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"x", "<", "0"}], ":"}], TraditionalForm]],
  FormatType->"TraditionalForm"]
}], "Subsection",
 CellChangeTimes->{{3.685505427115159*^9, 3.6855054617442083`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"With", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"kmin", "=", 
      RowBox[{"-", "10."}]}], ",", 
     RowBox[{"kmax", "=", "10."}], ",", 
     RowBox[{"points", "=", "1000"}]}], "}"}], ",", "\[IndentingNewLine]", 
   RowBox[{"With", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"f", "=", 
       RowBox[{"fouriertransformcalculator", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"Exp", "[", 
           RowBox[{"-", 
            SuperscriptBox["#", "2"]}], "]"}], "&"}], ",", "kmin", ",", 
         "kmax", ",", "points"}], "]"}]}], "}"}], ",", "\[IndentingNewLine]", 
     
     RowBox[{"Plot", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Re", "@", 
          RowBox[{"f", "[", "x", "]"}]}], ",", 
         RowBox[{"Im", "@", 
          RowBox[{"f", "[", "x", "]"}]}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{"-", "2"}], ",", "5"}], "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{"PlotRange", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"All", ",", "0.75"}], "}"}]}], ",", 
       RowBox[{"AxesLabel", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Style", "[", 
           RowBox[{"\"\<x\>\"", ",", "Black", ",", "15"}], "]"}], ",", 
          RowBox[{"Style", "[", 
           RowBox[{"\"\<f(x)\>\"", ",", "Black", ",", "15"}], "]"}]}], 
         "}"}]}], ",", 
       RowBox[{"TicksStyle", "\[Rule]", 
        RowBox[{"Directive", "[", 
         RowBox[{"Black", ",", " ", "10"}], "]"}]}]}], "]"}]}], 
    "\[IndentingNewLine]", "]"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.685505469838111*^9, 3.685505473067073*^9}}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"InterpolatingFunction", "::", "dmval"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Input value \[NoBreak]\\!\\(\\*RowBox[{\\\"{\\\", RowBox[{\
\\\"-\\\", \\\"1.999857`\\\"}], \\\"}\\\"}]\\)\[NoBreak] lies outside the \
range of data in the interpolating function. Extrapolation will be used. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/InterpolatingFunction/dmval\\\", \
ButtonNote -> \\\"InterpolatingFunction::dmval\\\"]\\)\"\>"}]], "Message", \
"MSG",
 CellChangeTimes->{{3.6855054705749187`*^9, 3.685505473512294*^9}}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"InterpolatingFunction", "::", "dmval"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Input value \[NoBreak]\\!\\(\\*RowBox[{\\\"{\\\", RowBox[{\
\\\"-\\\", \\\"1.999857`\\\"}], \\\"}\\\"}]\\)\[NoBreak] lies outside the \
range of data in the interpolating function. Extrapolation will be used. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/InterpolatingFunction/dmval\\\", \
ButtonNote -> \\\"InterpolatingFunction::dmval\\\"]\\)\"\>"}]], "Message", \
"MSG",
 CellChangeTimes->{{3.6855054705749187`*^9, 3.685505473542884*^9}}],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
     1.], LineBox[CompressedData["
1:eJwV1nc4Vu8bAHB7ZbyjVFYlKWVEUaTuJ0kkIrIqZJWR7FR2diJbZVMhkZGE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      "]]}, 
    {RGBColor[0.880722, 0.611041, 0.142051], AbsoluteThickness[1.6], Opacity[
     1.], LineBox[CompressedData["
1:eJwBIQXe+iFib1JlAgAAAFEAAAACAAAAke6m2f///7+AwicekY3tPOxeaG2a
5v6/5mEvyKf36jxGzykBNc39v8V0fseQiOg8n+e3XBNr+783Z2hQgsHjPFni
bGhgMfm/tTKv3JbC3zyKhj9Q2gL3v70adt5qL9k8dXQu3uvT9b8lrZqi0gTW
PGBiHWz9pPS/cUIwgZMe0zx8wR9SRorzv8QbrX8IpdA8lyAiOI9v8r8ESLHM
icTMPIQbKrgsPfG/OTzM5HlUyDxyFjI4ygrwv3jn4OfbWcQ878yi12MB8L//
rSbzZjzEPNkGJ+767++/QWAL2AwfxDzO4OlrYcrvv8fufgKp5MM8uJRvZy5/
778lg6ykIXHDPI38el7I6O6/vwQQcwqPwjw2zJFM/LvtvzZHbN9s3sA8iWu/
KGRi679kTjFkFJK7PPBuaEERAOe/qFjIWz4Msjyg4SfCED/iv/xRgQVguaQ8
IzJqRtud27/JDFxsGHCVPOJG+3hI6tK/GBEblfeigTxpdHL3tPLCv/hMpyV0
3lo8LuFW4udEhb8A9YaTM0QAvB3bzVrOxME/iDZxd2FIYTxJ7GkpQkLSP904
I60HLXw8gmHRZGIA2z+d/qciVqWJPBT8BejuPeI/hWoUmNMakzylglU9z6rm
P5Zb7lLjr5Y87ZmOKl126z8qA5sMFJiYPCQvxq/IFfA/6twlJwzvmzzwLh4a
9EfyP7wvmAuvSqA8F/dqUHap9D9SpUXsyDKhPN7ckNaJ4vY/S1EJ+jVEnjwt
GZmAcBD5P9TPlcl0+5k82B2W9q1t+z8LQDuNkImbPCJAbLx8ov0/nIZ2bspj
nTxklRsnUQMAQMT2UThGa5o8+zXygc0vAUDi4EFK/siVPGJltYQSSAJAtAoY
wVX8lDz2+HLtAngDQADi2i6EcZY8Whsd/ruTBEBsP/3bX9qUPAJpuKDeqQVA
RTRQqjFDjzzYGk6prNcGQNdgw+KSMoU8flvQWUPxB0AcnZGKEdeBPFEATXCF
IglAFEVrq4K6hzz0M7YukD8KQEh8MCk/x5s825IQfwRXC0CcGn9yv2akPPBV
ZTUkhgxA7e5OTgZkoDzVp6aTDKENQIwc5Skw6os8513iV6DTDkBk6TjgzZNk
vJ+fB9dOABBAOrbu0rY7hryzVxTWsYwQQKuMUXkp1Ii83UEeiOokEUC+SAb6
zWR7vG9zHo4HsxFAB/bD+sCXWryjOhddWT4SQNw5lWBy7lS87jMN34DVEkDe
Ad/Nrf1TvKF0+bSMYhNA9us4xWbwYTy+Nf+BAmUTQDqErVjOc2I82vYET3hn
E0D+xrUd/PZiPBJ5EOljbBNAvxwmmpf8YzyCfScdO3YTQL25B+xLBGY8YoZV
hemJE0BdPtxvlgFqPCKYsVVGsRNA7EsbbIvJcDw+WbcivLMTQJOo+vweA3E8
Whq97zG2E0DsGjcdSzxxPJKcyIkduxNAu6iZumOtcTwCod+99MQTQCBBxjBV
inI846kNJqPYE0B6J8RILy10PABrE/MY2xNAjhAdTDRfdDwcLBnAjt0TQGqv
HJqskHQ8VK4kWnriE0DEduLE7fF0PMSyO45R7BNAQgRJHXGtdTzgc0Fbx+4T
QHJ0mD3P2nU8/DRHKD3xE0CTajMGjgd2PDS3UsIo9hNAt1AePyRfdjxQeFiP
nvgTQL501wb3iXY8bDleXBT7E0DDhq4lIbR2PIj6YymK/RNAxyBYR6Dddjyk
u2n2//8TQM3ciBdyBnc8cL1ujw==
      "]]}}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{
    FormBox[
     StyleBox["\"x\"", 
      GrayLevel[0], 15, StripOnInput -> False], TraditionalForm], 
    FormBox[
     StyleBox["\"f(x)\"", 
      GrayLevel[0], 15, StripOnInput -> False], TraditionalForm]},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None},
  PlotRange->{{-1.9999998571428572`, 4.999999857142857}, {All, 0.75}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 0}},
  Ticks->{Automatic, Automatic},
  TicksStyle->Directive[
    GrayLevel[0], 10]]], "Output",
 CellChangeTimes->{{3.6855054706305037`*^9, 3.68550547357589*^9}}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Evidently, this is not working because the x-grid we took started from ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", "=", "0."}], TraditionalForm]],
  FormatType->"TraditionalForm"],
 " We can make use of the fact that ",
 Cell[BoxData[
  FormBox["f", TraditionalForm]],
  FormatType->"TraditionalForm"],
 "(x) is periodic with period xperiod = 2\[Pi] / \[Delta]k (follows from the \
defining equations for the discretized Fourier transform). Thus, ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"f", "(", "x", ")"}], "=", 
    RowBox[{"f", "(", 
     RowBox[{"Mod", "(", 
      RowBox[{"x", ",", "xperiod"}], ")"}], ")"}]}], TraditionalForm]],
  FormatType->"TraditionalForm"],
 ", where Mod is the residue function: Mod(a,b) is the residue after dividing \
a by b. Using this we can plot ",
 Cell[BoxData[
  FormBox[
   RowBox[{"f", "(", "x", ")"}], TraditionalForm]],
  FormatType->"TraditionalForm"],
 " for all values of x :"
}], "Subsection",
 CellChangeTimes->{{3.6855054805836267`*^9, 3.6855056500135193`*^9}, {
  3.685505685341344*^9, 3.685505813152166*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"With", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"kmin", "=", 
      RowBox[{"-", "10."}]}], ",", 
     RowBox[{"kmax", "=", "10."}], ",", 
     RowBox[{"points", "=", "1000"}]}], "}"}], ",", "\[IndentingNewLine]", 
   RowBox[{"With", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"xperiod", "=", 
        RowBox[{"2", "*", "\[Pi]", "*", 
         RowBox[{"points", "/", 
          RowBox[{"(", 
           RowBox[{"kmax", "-", "kmin"}], ")"}]}]}]}], ",", 
       RowBox[{"f", "=", 
        RowBox[{"fouriertransformcalculator", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"Exp", "[", 
            RowBox[{"-", 
             SuperscriptBox["#", "2"]}], "]"}], "&"}], ",", "kmin", ",", 
          "kmax", ",", "points"}], "]"}]}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Plot", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Re", "@", 
          RowBox[{"f", "[", 
           RowBox[{"Mod", "[", 
            RowBox[{"x", ",", "xperiod"}], "]"}], "]"}]}], ",", 
         RowBox[{"Im", "@", 
          RowBox[{"f", "[", 
           RowBox[{"Mod", "[", 
            RowBox[{"x", ",", "xperiod"}], "]"}], "]"}]}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{"-", "5"}], ",", "5"}], "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{"PlotRange", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"All", ",", "0.75"}], "}"}]}], ",", 
       RowBox[{"AxesLabel", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Style", "[", 
           RowBox[{"\"\<x\>\"", ",", "Black", ",", "15"}], "]"}], ",", 
          RowBox[{"Style", "[", 
           RowBox[{"\"\<f(x)\>\"", ",", "Black", ",", "15"}], "]"}]}], 
         "}"}]}], ",", 
       RowBox[{"TicksStyle", "\[Rule]", 
        RowBox[{"Directive", "[", 
         RowBox[{"Black", ",", " ", "10"}], "]"}]}]}], "]"}]}], 
    "\[IndentingNewLine]", "]"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.6855058240023327`*^9, 3.685505861827971*^9}, 
   3.6855060048993683`*^9}],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
     1.], LineBox[CompressedData["
1:eJwt2Xk0VV/YB3CZXeO915yKkkSGSvRDnt0glCTJrJCZzHPIFIUMRZEh81CR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      "]]}, 
    {RGBColor[0.880722, 0.611041, 0.142051], AbsoluteThickness[1.6], Opacity[
     1.], LineBox[CompressedData["
1:eJwtmWk01d/3x695urjXlVAZk9JAMhSf415DkpCZMoYkCWmiVEKSJL6GjBUy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      "]]}}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{
    FormBox[
     StyleBox["\"x\"", 
      GrayLevel[0], 15, StripOnInput -> False], TraditionalForm], 
    FormBox[
     StyleBox["\"f(x)\"", 
      GrayLevel[0], 15, StripOnInput -> False], TraditionalForm]},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None},
  PlotRange->{{-4.9999997959183675`, 4.9999997959183675`}, {All, 0.75}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 0}},
  Ticks->{Automatic, Automatic},
  TicksStyle->Directive[
    GrayLevel[0], 10]]], "Output",
 CellChangeTimes->{{3.685505859653574*^9, 3.685505862163597*^9}, 
   3.685506009570939*^9}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Other examples of Fourier transforms using our module \
\[OpenCurlyDoubleQuote]fouriertransformcalculator\[CloseCurlyDoubleQuote] :\
\>", "Section",
 CellChangeTimes->{{3.685505899300644*^9, 3.68550590505068*^9}, {
  3.685505939731801*^9, 3.6855059835474567`*^9}}],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"F", "(", "k", ")"}], "=", 
   RowBox[{
    SuperscriptBox["e", 
     RowBox[{"-", 
      SuperscriptBox["k", "4"]}]], ":"}]}], TraditionalForm]],
 FormatType->"TraditionalForm"]], "Subsection",
 CellChangeTimes->{{3.6855060280676394`*^9, 3.685506041327845*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"With", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"kmin", "=", 
      RowBox[{"-", "10."}]}], ",", 
     RowBox[{"kmax", "=", "10."}], ",", 
     RowBox[{"points", "=", "1000"}]}], "}"}], ",", "\[IndentingNewLine]", 
   RowBox[{"With", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"xperiod", "=", 
        RowBox[{"2", "*", "\[Pi]", "*", 
         RowBox[{"points", "/", 
          RowBox[{"(", 
           RowBox[{"kmax", "-", "kmin"}], ")"}]}]}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"f", "=", 
        RowBox[{"fouriertransformcalculator", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"Exp", "[", 
            RowBox[{"-", 
             SuperscriptBox["#", "4"]}], "]"}], "&"}], ",", "kmin", ",", 
          "kmax", ",", "points"}], "]"}]}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Plot", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Re", "@", 
          RowBox[{"f", "[", 
           RowBox[{"Mod", "[", 
            RowBox[{"x", ",", "xperiod"}], "]"}], "]"}]}], ",", 
         RowBox[{"Im", "@", 
          RowBox[{"f", "[", 
           RowBox[{"Mod", "[", 
            RowBox[{"x", ",", "xperiod"}], "]"}], "]"}]}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{"-", "10"}], ",", "10"}], "}"}], ",", "\[IndentingNewLine]", 
       
       RowBox[{"PlotRange", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"All", ",", "0.75"}], "}"}]}], ",", 
       RowBox[{"AxesLabel", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Style", "[", 
           RowBox[{"\"\<x\>\"", ",", "Black", ",", "15"}], "]"}], ",", 
          RowBox[{"Style", "[", 
           RowBox[{"\"\<f(x)\>\"", ",", "Black", ",", "15"}], "]"}]}], 
         "}"}]}], ",", 
       RowBox[{"TicksStyle", "\[Rule]", 
        RowBox[{"Directive", "[", 
         RowBox[{"Black", ",", " ", "10"}], "]"}]}]}], "]"}]}], 
    "\[IndentingNewLine]", "]"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.685505995856227*^9, 3.685506021160943*^9}}],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
     1.], LineBox[CompressedData["
1:eJwtm3k41N/7/wllZwbZZ4axkySpqM4hSXYVCilkCUmhhKwz2kVZSkj2so+l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      "]]}, 
    {RGBColor[0.880722, 0.611041, 0.142051], AbsoluteThickness[1.6], Opacity[
     1.], LineBox[CompressedData["
1:eJwtmnc4lu/7xx8jmzyPvccjSspIEvfNY++QbCIJlSJUKiREn0Q2GRFCopCV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      "]]}}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{
    FormBox[
     StyleBox["\"x\"", 
      GrayLevel[0], 15, StripOnInput -> False], TraditionalForm], 
    FormBox[
     StyleBox["\"f(x)\"", 
      GrayLevel[0], 15, StripOnInput -> False], TraditionalForm]},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None},
  PlotRange->{{-9.999999591836735, 9.999999591836735}, {All, 0.75}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 0}},
  Ticks->{Automatic, Automatic},
  TicksStyle->Directive[
    GrayLevel[0], 10]]], "Output",
 CellChangeTimes->{{3.6855060168540077`*^9, 3.685506021680974*^9}}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"F", "(", "k", ")"}], "=", 
   RowBox[{
    SuperscriptBox["e", 
     RowBox[{"-", 
      SuperscriptBox["k", "2"]}]], 
    RowBox[{
     SuperscriptBox["e", 
      RowBox[{
       RowBox[{"-", "i"}], " ", 
       RowBox[{"(", 
        RowBox[{"k", "+", 
         RowBox[{
          SuperscriptBox["k", "2"], "/", "2"}]}], ")"}]}]], ":"}]}]}], 
  TraditionalForm]]]], "Subsection",
 CellChangeTimes->{{3.685506115597191*^9, 3.6855061315019407`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"With", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"kmin", "=", 
      RowBox[{"-", "10."}]}], ",", 
     RowBox[{"kmax", "=", "10."}], ",", 
     RowBox[{"points", "=", "1000"}]}], "}"}], ",", "\[IndentingNewLine]", 
   RowBox[{"With", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"xperiod", "=", 
        RowBox[{"2", "*", "\[Pi]", "*", 
         RowBox[{"points", "/", 
          RowBox[{"(", 
           RowBox[{"kmax", "-", "kmin"}], ")"}]}]}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"f", "=", 
        RowBox[{"fouriertransformcalculator", "[", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"Exp", "[", 
             RowBox[{"-", 
              SuperscriptBox["#", "2"]}], "]"}], "*", 
            RowBox[{"Exp", "[", 
             RowBox[{
              RowBox[{"-", "I"}], "*", 
              RowBox[{"(", 
               RowBox[{"#", "+", 
                RowBox[{
                 SuperscriptBox["#", "2"], "/", "2"}]}], ")"}]}], "]"}]}], 
           "&"}], ",", "kmin", ",", "kmax", ",", "points"}], "]"}]}]}], "}"}],
      ",", "\[IndentingNewLine]", 
     RowBox[{"Plot", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Re", "@", 
          RowBox[{"f", "[", 
           RowBox[{"Mod", "[", 
            RowBox[{"x", ",", "xperiod"}], "]"}], "]"}]}], ",", 
         RowBox[{"Im", "@", 
          RowBox[{"f", "[", 
           RowBox[{"Mod", "[", 
            RowBox[{"x", ",", "xperiod"}], "]"}], "]"}]}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{"-", "10"}], ",", "10"}], "}"}], ",", "\[IndentingNewLine]", 
       
       RowBox[{"PlotRange", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"All", ",", "0.75"}], "}"}]}], ",", 
       RowBox[{"AxesLabel", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Style", "[", 
           RowBox[{"\"\<x\>\"", ",", "Black", ",", "15"}], "]"}], ",", 
          RowBox[{"Style", "[", 
           RowBox[{"\"\<f(x)\>\"", ",", "Black", ",", "15"}], "]"}]}], 
         "}"}]}], ",", 
       RowBox[{"TicksStyle", "\[Rule]", 
        RowBox[{"Directive", "[", 
         RowBox[{"Black", ",", " ", "10"}], "]"}]}]}], "]"}]}], 
    "\[IndentingNewLine]", "]"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.6855060778475227`*^9, 3.6855061030553617`*^9}}],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
     1.], LineBox[CompressedData["
1:eJwUVnk4VV8XlnmeXdd8uUiGQkRyzz7IVEKSKZR5/GUIqRQhyVDIVIgiiZKZ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      "]]}, 
    {RGBColor[0.880722, 0.611041, 0.142051], AbsoluteThickness[1.6], Opacity[
     1.], LineBox[CompressedData["
1:eJwUWHk81F8Xnuz7OvZ1hlRSka2F7/1qI1n7IYQkS6GSNqQIUUiIVCRbyD6D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      "]]}}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{
    FormBox[
     StyleBox["\"x\"", 
      GrayLevel[0], 15, StripOnInput -> False], TraditionalForm], 
    FormBox[
     StyleBox["\"f(x)\"", 
      GrayLevel[0], 15, StripOnInput -> False], TraditionalForm]},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None},
  PlotRange->{{-9.999999591836735, 9.999999591836735}, {All, 0.75}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 0}},
  Ticks->{Automatic, Automatic},
  TicksStyle->Directive[
    GrayLevel[0], 10]]], "Output",
 CellChangeTimes->{3.685506104188652*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"F", "(", "k", ")"}], "=", 
   RowBox[{
    RowBox[{
     SuperscriptBox["e", 
      RowBox[{"-", 
       SuperscriptBox["k", "2"]}]], 
     RowBox[{
      SubscriptBox["P", "5"], "(", 
      RowBox[{"cos", " ", "k"}], ")"}]}], ":"}]}], 
  TraditionalForm]]]], "Subsection",
 CellChangeTimes->{{3.6855063213222113`*^9, 3.685506338875112*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"With", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"kmin", "=", 
      RowBox[{"-", "10."}]}], ",", 
     RowBox[{"kmax", "=", "10."}], ",", 
     RowBox[{"points", "=", "1000"}]}], "}"}], ",", "\[IndentingNewLine]", 
   RowBox[{"With", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"xperiod", "=", 
        RowBox[{"2", "*", "\[Pi]", "*", 
         RowBox[{"points", "/", 
          RowBox[{"(", 
           RowBox[{"kmax", "-", "kmin"}], ")"}]}]}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"f", "=", 
        RowBox[{"fouriertransformcalculator", "[", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"Exp", "[", 
             RowBox[{"-", 
              SuperscriptBox["#", "2"]}], "]"}], "*", 
            RowBox[{"LegendreP", "[", 
             RowBox[{"5", ",", 
              RowBox[{"Cos", "[", "#", "]"}]}], "]"}]}], "&"}], ",", "kmin", 
          ",", "kmax", ",", "points"}], "]"}]}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Plot", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Re", "@", 
          RowBox[{"f", "[", 
           RowBox[{"Mod", "[", 
            RowBox[{"x", ",", "xperiod"}], "]"}], "]"}]}], ",", 
         RowBox[{"Im", "@", 
          RowBox[{"f", "[", 
           RowBox[{"Mod", "[", 
            RowBox[{"x", ",", "xperiod"}], "]"}], "]"}]}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{"-", "15"}], ",", "15"}], "}"}], ",", "\[IndentingNewLine]", 
       
       RowBox[{"PlotRange", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "0.02"}], ",", "0.3"}], "}"}]}], ",", 
       RowBox[{"AxesLabel", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Style", "[", 
           RowBox[{"\"\<x\>\"", ",", "Black", ",", "15"}], "]"}], ",", 
          RowBox[{"Style", "[", 
           RowBox[{"\"\<f(x)\>\"", ",", "Black", ",", "15"}], "]"}]}], 
         "}"}]}], ",", 
       RowBox[{"TicksStyle", "\[Rule]", 
        RowBox[{"Directive", "[", 
         RowBox[{"Black", ",", " ", "10"}], "]"}]}]}], "]"}]}], 
    "\[IndentingNewLine]", "]"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.685506152567089*^9, 3.685506213781736*^9}, {
  3.6855062863586903`*^9, 3.685506306084569*^9}}],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
     1.], LineBox[CompressedData["
1:eJwUmHk4lF8bx+1LJGNX1pmxjyXZwjznEZE1pKwhWxGyZ8++JREpSyFrqFAk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      "]]}, 
    {RGBColor[0.880722, 0.611041, 0.142051], AbsoluteThickness[1.6], Opacity[
     1.], LineBox[CompressedData["
1:eJwtmnc4l9/7wN/2Hm/7bb7tPULmc3hURtk7q4QKSWWUrEQKaaBQEsmIhKyM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      "]]}}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{
    FormBox[
     StyleBox["\"x\"", 
      GrayLevel[0], 15, StripOnInput -> False], TraditionalForm], 
    FormBox[
     StyleBox["\"f(x)\"", 
      GrayLevel[0], 15, StripOnInput -> False], TraditionalForm]},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None},
  PlotRange->{{-14.999999387755102`, 14.999999387755102`}, {-0.02, 0.3}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {0, 0}},
  Ticks->{Automatic, Automatic},
  TicksStyle->Directive[
    GrayLevel[0], 10]]], "Output",
 CellChangeTimes->{{3.685506154376327*^9, 3.685506214260689*^9}, {
  3.685506289913718*^9, 3.68550630770822*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"F", "(", "k", ")"}], "=", 
   RowBox[{
    RowBox[{
     SuperscriptBox["e", 
      RowBox[{"-", 
       SuperscriptBox["k", "2"]}]], 
     RowBox[{"sin", "(", 
      RowBox[{"sin", " ", "k"}], ")"}]}], ":"}]}], 
  TraditionalForm]]]], "Subsubsection",
 CellChangeTimes->{{3.685506451786015*^9, 3.6855064587299356`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"With", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"kmin", "=", 
      RowBox[{"-", "10."}]}], ",", 
     RowBox[{"kmax", "=", "10."}], ",", 
     RowBox[{"points", "=", "1000"}]}], "}"}], ",", "\[IndentingNewLine]", 
   RowBox[{"With", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"xperiod", "=", 
        RowBox[{"2", "*", "\[Pi]", "*", 
         RowBox[{"points", "/", 
          RowBox[{"(", 
           RowBox[{"kmax", "-", "kmin"}], ")"}]}]}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"f", "=", 
        RowBox[{"fouriertransformcalculator", "[", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"Exp", "[", 
             RowBox[{"-", 
              SuperscriptBox["#", "2"]}], "]"}], "*", 
            RowBox[{"Sin", "[", 
             RowBox[{"Sin", "[", "#", "]"}], "]"}]}], "&"}], ",", "kmin", ",",
           "kmax", ",", "points"}], "]"}]}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Plot", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Re", "@", 
          RowBox[{"f", "[", 
           RowBox[{"Mod", "[", 
            RowBox[{"x", ",", "xperiod"}], "]"}], "]"}]}], ",", 
         RowBox[{"Im", "@", 
          RowBox[{"f", "[", 
           RowBox[{"Mod", "[", 
            RowBox[{"x", ",", "xperiod"}], "]"}], "]"}]}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{"-", "10"}], ",", "10"}], "}"}], ",", "\[IndentingNewLine]", 
       
       RowBox[{"PlotRange", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "0.25"}], ",", "0.25"}], "}"}]}], ",", 
       RowBox[{"AxesLabel", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Style", "[", 
           RowBox[{"\"\<x\>\"", ",", "Black", ",", "15"}], "]"}], ",", 
          RowBox[{"Style", "[", 
           RowBox[{"\"\<f(x)\>\"", ",", "Black", ",", "15"}], "]"}]}], 
         "}"}]}], ",", 
       RowBox[{"TicksStyle", "\[Rule]", 
        RowBox[{"Directive", "[", 
         RowBox[{"Black", ",", " ", "10"}], "]"}]}]}], "]"}]}], 
    "\[IndentingNewLine]", "]"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.685506402187354*^9, 3.685506441716927*^9}}],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
     1.], LineBox[CompressedData["
1:eJwtmXc41v/3x+09bnuVdVdkZI94v7rfVCoS2UmJZDXMEiGjqbKVpBLKiLLC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      "]]}, 
    {RGBColor[0.880722, 0.611041, 0.142051], AbsoluteThickness[1.6], Opacity[
     1.], LineBox[CompressedData["
1:eJwtm3c419/7x83I3nu8h1RSkdHS+5yGERJSSUaEkIzwIUmiVFZ2yaiQnWyS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      "]]}}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{
    FormBox[
     StyleBox["\"x\"", 
      GrayLevel[0], 15, StripOnInput -> False], TraditionalForm], 
    FormBox[
     StyleBox["\"f(x)\"", 
      GrayLevel[0], 15, StripOnInput -> False], TraditionalForm]},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None},
  PlotRange->{{-9.999999591836735, 9.999999591836735}, {-0.25, 0.25}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {0, 0}},
  Ticks->{Automatic, Automatic},
  TicksStyle->Directive[
    GrayLevel[0], 10]]], "Output",
 CellChangeTimes->{{3.6855064050822067`*^9, 3.685506442019854*^9}}]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1243, 674},
WindowMargins->{{Automatic, 0}, {-13, Automatic}},
FrontEndVersion->"10.4 for Mac OS X x86 (32-bit, 64-bit Kernel) (April 11, \
2016)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 123, 1, 92, "Title"],
Cell[CellGroupData[{
Cell[728, 27, 5207, 169, 583, "Section"],
Cell[5938, 198, 5028, 136, 214, "Input"],
Cell[CellGroupData[{
Cell[10991, 338, 797, 28, 48, "Subsection"],
Cell[CellGroupData[{
Cell[11813, 370, 1731, 48, 113, "Input"],
Cell[13547, 420, 7555, 141, 250, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[21151, 567, 352, 9, 45, "Subsection"],
Cell[CellGroupData[{
Cell[21528, 580, 1697, 47, 113, "Input"],
Cell[23228, 629, 663, 13, 24, "Message"],
Cell[23894, 644, 663, 13, 24, "Message"],
Cell[24560, 659, 11325, 202, 251, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[35934, 867, 1090, 29, 99, "Subsection"],
Cell[CellGroupData[{
Cell[37049, 900, 2122, 58, 134, "Input"],
Cell[39174, 960, 21852, 375, 256, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[61087, 1342, 274, 5, 64, "Section"],
Cell[CellGroupData[{
Cell[61386, 1351, 322, 9, 47, "Subsection"],
Cell[CellGroupData[{
Cell[61733, 1364, 2133, 59, 155, "Input"],
Cell[63869, 1425, 32817, 555, 250, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[96735, 1986, 509, 17, 47, "Subsection"],
Cell[CellGroupData[{
Cell[97269, 2007, 2424, 67, 155, "Input"],
Cell[99696, 2076, 57609, 961, 256, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[157354, 3043, 402, 13, 47, "Subsection"],
Cell[CellGroupData[{
Cell[157781, 3060, 2367, 65, 155, "Input"],
Cell[160151, 3127, 46527, 779, 253, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[206715, 3911, 381, 12, 37, "Subsubsection"],
Cell[CellGroupData[{
Cell[207121, 3927, 2276, 63, 155, "Input"],
Cell[209400, 3992, 30394, 514, 250, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

