(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    350910,       6619]
NotebookOptionsPosition[    345693,       6482]
NotebookOutlinePosition[    346048,       6498]
CellTagsIndexPosition[    346005,       6495]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Random walk in 2D", "Title",
 CellChangeTimes->{{3.687291661098762*^9, 
  3.687291664804729*^9}},ExpressionUUID->"78295a5e-50a4-4ddf-ad70-\
12e91891ffbe"],

Cell[CellGroupData[{

Cell["Trajectory:", "Subsection",
 CellChangeTimes->{{3.6872916693363237`*^9, 
  3.6872916746724463`*^9}},ExpressionUUID->"aed366e5-e7db-45c1-9f91-\
caf6963cc56e"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"position", "[", "0", "]"}], "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Do", "[", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"position", "[", 
     RowBox[{"timestep", "+", "1"}], "]"}], "=", 
    RowBox[{
     RowBox[{"position", "[", "timestep", "]"}], "+", 
     RowBox[{"Normalize", "@", 
      RowBox[{"RandomVariate", "[", 
       RowBox[{
        RowBox[{"NormalDistribution", "[", "]"}], ",", "2"}], "]"}]}]}]}], 
   ",", "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{"timestep", ",", "0", ",", "1000"}], "}"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.687291687411384*^9, 
  3.6872916899751596`*^9}},ExpressionUUID->"5537d176-8be6-4dc5-a25f-\
f4bfb7bd840d"],

Cell[BoxData[
 RowBox[{
  RowBox[{"locations", "=", 
   RowBox[{"position", "/@", 
    RowBox[{"Range", "[", "1000", "]"}]}]}], ";"}]], "Input",ExpressionUUID->\
"e8dad974-c6a3-4e36-aa8f-a1bcbe36d4a0"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Point", "[", "locations", "]"}], ",", 
    RowBox[{"Line", "[", "locations", "]"}]}], "}"}], "]"}]], "Input",
 CellChangeTimes->{{3.687291707629855*^9, 
  3.687291707754178*^9}},ExpressionUUID->"d1b09fee-82ba-478f-af25-\
09e9a2a18958"],

Cell[BoxData[
 GraphicsBox[{PointBox[CompressedData["
1:eJwVV3c81e8Xv1x73uu69t6zjEoJn5NIGohoSGZIoSi0vigjkVAaKmSEzJBk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    "]], LineBox[CompressedData["
1:eJwVV3c81e8Xv1x73uu69t6zjEoJn5NIGohoSGZIoSi0vigjkVAaKmSEzJBk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    "]]}]], "Output",
 CellChangeTimes->{
  3.687291708130788*^9},ExpressionUUID->"74013e4f-59c6-4eba-8ec3-\
4345a78234dd"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
A function which calculates the number of steps taken before reaching a \
distance R:\
\>", "Subsection",
 CellChangeTimes->{{3.68729175512291*^9, 
  3.6872917846944*^9}},ExpressionUUID->"8ba5bf86-7ada-467b-ae5e-f4bdf468e51c"],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", "maxradius_", "]"}], ":=", "\[IndentingNewLine]", 
  RowBox[{"Block", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"timestep", ",", "position"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"timestep", "=", "0"}], ";", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"position", "[", "0", "]"}], "=", 
      RowBox[{"ConstantArray", "[", 
       RowBox[{"0", ",", "2"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"While", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"Norm", "[", 
         RowBox[{"position", "[", "timestep", "]"}], "]"}], "<", 
        "maxradius"}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{
         RowBox[{"position", "[", 
          RowBox[{"timestep", "+", "1"}], "]"}], "=", 
         RowBox[{
          RowBox[{"position", "[", "timestep", "]"}], "+", 
          RowBox[{"Normalize", "@", 
           RowBox[{"RandomVariate", "[", 
            RowBox[{
             RowBox[{"NormalDistribution", "[", "]"}], ",", "2"}], 
            "]"}]}]}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"timestep", "++"}]}]}], "]"}], ";", "\[IndentingNewLine]", 
     "timestep"}]}], "\[IndentingNewLine]", "]"}]}]], "Input",
 CellChangeTimes->{{3.68729179675731*^9, 
  3.687291825361843*^9}},ExpressionUUID->"62bb908e-96b7-44b8-98e8-\
676dd83372f6"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Calculating the number of steps for 1000 different random walks:\
\>", "Subsection",
 CellChangeTimes->{{3.687291869089806*^9, 
  3.6872918925224943`*^9}},ExpressionUUID->"97f1784a-992d-4f6b-a0c6-\
9b25dd3c5a19"],

Cell[BoxData[
 RowBox[{"With", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"maxradius", "=", "100"}], "}"}], ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"data", "=", 
     RowBox[{"ParallelTable", "[", 
      RowBox[{
       RowBox[{"f", "[", "maxradius", "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"index", ",", "1000"}], "}"}]}], "]"}]}], ";"}]}], 
  "\[IndentingNewLine]", "]"}]], "Input",
 CellChangeTimes->{{3.6872918984536324`*^9, 
  3.687291905026617*^9}},ExpressionUUID->"1e06631d-3eca-4499-a26c-\
001d6b469b27"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Plotting Histograms:", "Subsection",
 CellChangeTimes->{{3.687291919387499*^9, 
  3.687291924353056*^9}},ExpressionUUID->"33000774-601c-423d-ba74-\
e95c6a76c8ec"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Histogram", "[", "\[IndentingNewLine]", 
  RowBox[{"data", ",", "100", ",", "\[IndentingNewLine]", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", 
   RowBox[{"FrameLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Style", "[", 
       RowBox[{"\"\<Number of steps taken (N)\>\"", ",", "Black", ",", "15"}],
        "]"}], ",", 
      RowBox[{"Style", "[", 
       RowBox[{"\"\<Number of random walks\>\"", ",", "Black", ",", "15"}], 
       "]"}]}], "}"}]}], ",", 
   RowBox[{"FrameTicksStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Black", ",", "12"}], "]"}]}]}], "\[IndentingNewLine]", 
  "]"}]], "Input",
 CellChangeTimes->{{3.687291931251699*^9, 3.687291945445589*^9}, {
  3.68729199975436*^9, 
  3.687292001052032*^9}},ExpressionUUID->"8b3c8d98-a72a-49be-b1a8-\
57be443211a2"],

Cell[BoxData[
 GraphicsBox[{
   {RGBColor[0.987148, 0.8073604000000001, 0.49470040000000004`], EdgeForm[{
    Opacity[0.23099999999999998`], Thickness[Small]}], {}, 
    {RGBColor[0.987148, 0.8073604000000001, 0.49470040000000004`], EdgeForm[{
     Opacity[0.23099999999999998`], Thickness[Small]}], 
     RectangleBox[{1000., 0}, {1500., 4},
      RoundingRadius->0], RectangleBox[{1500., 0}, {2000., 15},
      RoundingRadius->0], RectangleBox[{2000., 0}, {2500., 24},
      RoundingRadius->0], RectangleBox[{2500., 0}, {3000., 29},
      RoundingRadius->0], RectangleBox[{3000., 0}, {3500., 38},
      RoundingRadius->0], RectangleBox[{3500., 0}, {4000., 54},
      RoundingRadius->0], RectangleBox[{4000., 0}, {4500., 47},
      RoundingRadius->0], RectangleBox[{4500., 0}, {5000., 50},
      RoundingRadius->0], RectangleBox[{5000., 0}, {5500., 42},
      RoundingRadius->0], RectangleBox[{5500., 0}, {6000., 44},
      RoundingRadius->0], RectangleBox[{6000., 0}, {6500., 44},
      RoundingRadius->0], RectangleBox[{6500., 0}, {7000., 32},
      RoundingRadius->0], RectangleBox[{7000., 0}, {7500., 44},
      RoundingRadius->0], RectangleBox[{7500., 0}, {8000., 29},
      RoundingRadius->0], RectangleBox[{8000., 0}, {8500., 39},
      RoundingRadius->0], RectangleBox[{8500., 0}, {9000., 31},
      RoundingRadius->0], RectangleBox[{9000., 0}, {9500., 30},
      RoundingRadius->0], RectangleBox[{9500., 0}, {10000., 24},
      RoundingRadius->0], RectangleBox[{10000., 0}, {10500., 26},
      RoundingRadius->0], RectangleBox[{10500., 0}, {11000., 26},
      RoundingRadius->0], RectangleBox[{11000., 0}, {11500., 28},
      RoundingRadius->0], RectangleBox[{11500., 0}, {12000., 17},
      RoundingRadius->0], RectangleBox[{12000., 0}, {12500., 24},
      RoundingRadius->0], RectangleBox[{12500., 0}, {13000., 24},
      RoundingRadius->0], RectangleBox[{13000., 0}, {13500., 13},
      RoundingRadius->0], RectangleBox[{13500., 0}, {14000., 12},
      RoundingRadius->0], RectangleBox[{14000., 0}, {14500., 9},
      RoundingRadius->0], RectangleBox[{14500., 0}, {15000., 11},
      RoundingRadius->0], RectangleBox[{15000., 0}, {15500., 9},
      RoundingRadius->0], RectangleBox[{15500., 0}, {16000., 20},
      RoundingRadius->0], RectangleBox[{16000., 0}, {16500., 8},
      RoundingRadius->0], RectangleBox[{16500., 0}, {17000., 18},
      RoundingRadius->0], RectangleBox[{17000., 0}, {17500., 7},
      RoundingRadius->0], RectangleBox[{17500., 0}, {18000., 4},
      RoundingRadius->0], RectangleBox[{18000., 0}, {18500., 8},
      RoundingRadius->0], RectangleBox[{18500., 0}, {19000., 5},
      RoundingRadius->0], RectangleBox[{19000., 0}, {19500., 8},
      RoundingRadius->0], RectangleBox[{19500., 0}, {20000., 9},
      RoundingRadius->0], RectangleBox[{20000., 0}, {20500., 6},
      RoundingRadius->0], RectangleBox[{20500., 0}, {21000., 5},
      RoundingRadius->0], RectangleBox[{21000., 0}, {21500., 7},
      RoundingRadius->0], RectangleBox[{21500., 0}, {22000., 4},
      RoundingRadius->0], RectangleBox[{22000., 0}, {22500., 4},
      RoundingRadius->0], RectangleBox[{22500., 0}, {23000., 4},
      RoundingRadius->0], RectangleBox[{23000., 0}, {23500., 5},
      RoundingRadius->0], RectangleBox[{23500., 0}, {24000., 5},
      RoundingRadius->0], RectangleBox[{24000., 0}, {24500., 2},
      RoundingRadius->0], RectangleBox[{24500., 0}, {25000., 5},
      RoundingRadius->0], RectangleBox[{25000., 0}, {25500., 3},
      RoundingRadius->0], RectangleBox[{26000., 0}, {26500., 1},
      RoundingRadius->0], RectangleBox[{26500., 0}, {27000., 5},
      RoundingRadius->0], RectangleBox[{27000., 0}, {27500., 3},
      RoundingRadius->0], RectangleBox[{27500., 0}, {28000., 4},
      RoundingRadius->0], RectangleBox[{28000., 0}, {28500., 1},
      RoundingRadius->0], RectangleBox[{28500., 0}, {29000., 1},
      RoundingRadius->0], RectangleBox[{29000., 0}, {29500., 3},
      RoundingRadius->0], RectangleBox[{29500., 0}, {30000., 2},
      RoundingRadius->0], RectangleBox[{30000., 0}, {30500., 1},
      RoundingRadius->0], RectangleBox[{30500., 0}, {31000., 4},
      RoundingRadius->0], RectangleBox[{31000., 0}, {31500., 2},
      RoundingRadius->0], RectangleBox[{31500., 0}, {32000., 1},
      RoundingRadius->0], RectangleBox[{32000., 0}, {32500., 1},
      RoundingRadius->0], RectangleBox[{32500., 0}, {33000., 1},
      RoundingRadius->0], RectangleBox[{33000., 0}, {33500., 1},
      RoundingRadius->0], RectangleBox[{34000., 0}, {34500., 2},
      RoundingRadius->0], RectangleBox[{35000., 0}, {35500., 1},
      RoundingRadius->0], RectangleBox[{35500., 0}, {36000., 1},
      RoundingRadius->0], RectangleBox[{36000., 0}, {36500., 1},
      RoundingRadius->0], RectangleBox[{36500., 0}, {37000., 1},
      RoundingRadius->0], RectangleBox[{37000., 0}, {37500., 1},
      RoundingRadius->0], RectangleBox[{38500., 0}, {39000., 1},
      RoundingRadius->0], RectangleBox[{39000., 0}, {39500., 1},
      RoundingRadius->0], RectangleBox[{39500., 0}, {40000., 1},
      RoundingRadius->0], RectangleBox[{42500., 0}, {43000., 1},
      RoundingRadius->0], RectangleBox[{44000., 0}, {44500., 1},
      RoundingRadius->0], RectangleBox[{47500., 0}, {48000., 1},
      RoundingRadius->
       0]}, {}, {}}, {{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{350., 0},
  Frame->True,
  FrameLabel->{{
     FormBox[
      StyleBox["\"Number of random walks\"", 
       GrayLevel[0], 15, StripOnInput -> False], TraditionalForm], None}, {
     FormBox[
      StyleBox["\"Number of steps taken (N)\"", 
       GrayLevel[0], 15, StripOnInput -> False], TraditionalForm], None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  FrameTicksStyle->Directive[
    GrayLevel[0], 12],
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  PlotRange->{{1000., 33500.}, {All, All}},
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {None, 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.68729198012681*^9, 
  3.687292001568624*^9}},ExpressionUUID->"a1d0131b-4245-4c9e-a79b-\
f62c2f0b7115"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Calculating mean and standard deviation:", "Subsection",
 CellChangeTimes->{{3.687291966944726*^9, 
  3.6872919781036577`*^9}},ExpressionUUID->"6a234768-c905-4ebb-9442-\
12f3ee55f6ba"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Naverage", "=", 
  RowBox[{"N", "@", 
   RowBox[{"Mean", "[", "data", "]"}]}]}]], "Input",
 CellChangeTimes->{{3.687291991355126*^9, 
  3.687292008580933*^9}},ExpressionUUID->"83b0f6a5-10fc-4032-9545-\
f0d733100418"],

Cell[BoxData["10006.673`"], "Output",
 CellChangeTimes->{
  3.687292009169348*^9},ExpressionUUID->"1fa336f5-ed78-4501-be67-\
2f5854ad0a18"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Nstddev", "=", 
  RowBox[{"N", "@", 
   RowBox[{"StandardDeviation", "[", "data", "]"}]}]}]], "Input",
 CellChangeTimes->{{3.687292018880871*^9, 
  3.687292026385254*^9}},ExpressionUUID->"f235da48-a97c-4bd5-865b-\
885f0a9a484d"],

Cell[BoxData["7142.336829459701`"], "Output",
 CellChangeTimes->{
  3.6872920268749733`*^9},ExpressionUUID->"17142a34-4e9b-4a93-9720-\
ec8f80b1ad07"]
}, Open  ]]
}, Open  ]],

Cell["Thus it takes about 10006 \[PlusMinus] 7142 steps to reach R=100 \
units.", "Subsection",
 CellChangeTimes->{{3.68729210825314*^9, 
  3.68729215068003*^9}},ExpressionUUID->"c0877908-6470-442c-8d7c-\
b77708a1a134"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exporting animations + some extras", "Title",
 CellChangeTimes->{{3.687291661098762*^9, 3.687291664804729*^9}, {
  3.7095638999121304`*^9, 
  3.7095639105042257`*^9}},ExpressionUUID->"bc0753d5-035b-4556-93a5-\
52bf85a57209"],

Cell[CellGroupData[{

Cell["Defining new functions in terms of predefined functions:", \
"Subsubsection",
 CellChangeTimes->{{3.686716745911327*^9, 3.6867167545475073`*^9}, {
  3.7095639334148827`*^9, 
  3.709563942791915*^9}},ExpressionUUID->"baa03f74-9868-4298-9b1b-\
36a145f78e43"],

Cell[BoxData[
 RowBox[{
  RowBox[{"f1", "[", "x_", "]"}], ":=", 
  RowBox[{
   SuperscriptBox["x", "2"], "+", 
   RowBox[{"Sin", "[", "x", "]"}]}]}]], "Input",
 CellChangeTimes->{{3.686717766956403*^9, 
  3.686717774745468*^9}},ExpressionUUID->"851a1682-99bc-492a-8346-\
5f02253bd2ad"],

Cell[BoxData[
 RowBox[{
  RowBox[{"f2", "[", "x_", "]"}], ":=", 
  RowBox[{"Cos", "[", 
   RowBox[{"f1", "[", "x", "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.6867177774399157`*^9, 
  3.686717784403904*^9}},ExpressionUUID->"440ca28d-3d0a-4168-aefb-\
33705e358e20"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"f2", "[", "x", "]"}], ",", 
     RowBox[{"Cos", "[", 
      RowBox[{
       SuperscriptBox["x", "2"], "+", 
       RowBox[{"Sin", "[", "x", "]"}]}], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "5"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.68671779057458*^9, 
  3.686717805580989*^9}},ExpressionUUID->"6fc23ce4-4033-430b-bce0-\
616b323b8a0e"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJwVm3dczd8fx6vbuNVNd/haTUpRlIioeJ9okJAoSULR0EAZUVYoGiRpUDQJ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       "]]},
     Annotation[#, "Charting`Private`Tag$361941#1"]& ], 
    TagBox[
     {RGBColor[0.880722, 0.611041, 0.142051], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJwVm3dczd8fx6vbuNVNd/haTUpRlIioeJ9okJAoSULR0EAZUVYoGiRpUDQJ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       "]]},
     Annotation[#, "Charting`Private`Tag$361941#2"]& ]}, {}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, 
     Charting`ScaledFrameTicks[{Identity, Identity}]}, {Automatic, 
     Charting`ScaledFrameTicks[{Identity, Identity}]}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{0, 5}, {-0.9999992515952887, 0.9999999999999948}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.7095615988345413`*^9},ExpressionUUID->"4807c194-3643-47f2-9718-\
46040249e85b"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Defining piecewise functions:", "Subsubsection",
 CellChangeTimes->{{3.686716745911327*^9, 
  3.6867167545475073`*^9}},ExpressionUUID->"e7238e32-deb6-4ec6-b670-\
4225f3a64de2"],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", "x_", "]"}], ":=", 
  RowBox[{"Piecewise", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"x", "<", "0"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "x"}], "+", 
        SuperscriptBox["x", "2"]}], ",", 
       RowBox[{"0", "<", "x", "<", "2"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"4", "-", "x"}], ",", 
       RowBox[{"x", ">", "2"}]}], "}"}]}], "}"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.686716757585101*^9, 
  3.686716868386701*^9}},ExpressionUUID->"97e71e73-360b-4385-ba78-\
4c867f5365b1"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"f", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "3"}], ",", "4"}], "}"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.68671679984286*^9, 3.686716835627067*^9}, {
  3.686716891851788*^9, 
  3.686716893551301*^9}},ExpressionUUID->"97f17529-28b9-48d3-9d15-\
a24ae1190d34"],

Cell[BoxData[
 GraphicsBox[{{{{}, {}, 
     TagBox[
      {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
       Opacity[1.], LineBox[CompressedData["
1:eJxTTMoPSmViYGAwAWIQ7VF++c3//+wHYLRjlXz4rN8I2qo2+6DJdwSt08w8
LfMdghboN7a/fAdB31g2eeKynQg641qwmW8xgu40vVI/6xkbnLaOOrWmcysr
nJY+8dBwwwwWOO1wj1s1t5EZTl+L0t5UF8QEp2cr5Ew/bs4Ipy/6LBJLZWWA
09OdrrEbbfy7H0a/ql01iaPhN5yWb8sM7JD/Cac3KWQfKHv+DU6f557EPWnX
Fzh99vDirrC4T3Bak+/Hzk6tD3D6rFee1Zm+13A6Wsp85717z+D0Er7WGefq
H8HpJMvA/Yott+H0l3mL+BJXXYLT4gV20V1qh+D0x3+7xM1vH4TTp3vNrzzu
R9D1qw18bX8egNPnzrrWPZi+H07n7uZzW/NoF5xeM23BVeeKjXA6YctMv7kP
N8BpkUuTjn/zQtDfpbiKg63XwelpHJet5NtWwul/zkd1LkWsgNNp9dvlWrWX
w2mzb7OZXl9YAqevPk45tU16AZyusltXcfnOXDjtuXVSjGXTbDj9YlG0CuvZ
aXB6h6QDR3bRFDjdMUHlzQXxSXDa78+tdMujXXD63cvF+qwCbXC693rO9wtR
jXA6oiu7ztK7Ek7rnf4lvehgPpyepOIJRElwGgAohb+x
        "]], 
       LineBox[CompressedData["
1:eJwVlXk41Iv3x5GkCCXZyhJRkdtFReS4Eu0hyZZISoqkXFLpikpRlqRF+VqG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        "]], LineBox[CompressedData["
1:eJwVzH1Q03UcB/DveDpE2LjiMghwAoccWhAHtouHz+eQphRwICByRBC7QEwh
HIcTLVcwYDnH01WEjmByh4QON4qn8RSjwRmhSBkgKa3FQw3j+Rps+/Xzj899
7nWfz/t9ICv/xAdWhJBQep7v6Bqf6BobgnmPO8893qZAUWZqcN9DsHndbli7
QkF2f2rLH04Eg0UxyjA9BY/8Xbo/3Ecw6dvfKv0mKZC+XzAU6E5QH+ZxpWGU
Am7dxNgWm2Dh/aw8lwEKumzFM1f8CdZsrsSQNgrq5s07teEEH0TYOEyXUhC/
L806NZJg5mS0MfYSBfZx3Xs9jxFc5VUuaQooEKjPu9+KJ+gsdhttf4+C1C8X
w/t4BOOmAkvLORS4xUwK9WKC4znpliMGCzz87DVxq5Tguzvylds6C3zec7U6
r5agQbI05zVjgV1frvy/GwQdVHw1U2uBOYZa43iX4HGTWLDwjQVkXc12IY8I
aqs6179ItADbWyAReTFwqIe1uNlrhu9+Kewy+jKw7uRL1Y4qMxwrK9CdO8TA
8xvuoT6tZshbPsM5GcxAn1f9KxO/MkNfe7rel8vAisaoN1R8M6SEHQ0by2Xg
ifKL5fmHzSBNZhoclAzUJ/158G+ZCUzlze9UgRXar3aefirchdqogRs2KdY4
W1Si3U4wQk+9LtGnzAal99481bWxDcqWv1SOTbbYcDe4fqF/EzhxGxcap+yw
iufqPHhqHYpjnk3IiD2+PMEdqTD/C9cYYz/zXPfguPHp2Ef1/0BA/O2gX6Md
MGowLqRtegHkyfnAyt6LgtZIK02ODh6o9j9RXXZEYa4VK9dtDqStszpGmxNW
dfgvr7Y8BI+UwkrXH5kYKO21z1FooGFq2c/2HhPZ2qyCOxka8IzPGF6doG1x
mN1w1gA7+u2t0Wkmkry0NiF/GLxC2WlFBibOx5pi6zk/gN/+cd+pF1lIXrns
e13UD0GL3gOSLBYOuZaEnlZ0QAfv6xRBDgsbxVOOW84dEDzPXOOdZaHQ6P3k
U74KQmaM3qFFLMycGRFe5yiB89N98bKY7gtykshEdyC8/VIyV0n3Bbo0nVHc
hIFDa89e76Tzzt8fLeXLIeJWdoWHmvZq8oKM0wTYlKDeHKHzmQEpcpEMImsP
Hrg5TTvjyNl8RS1oWLJe6e/0v6dAKedUQ5TkhaRiHX3v46+0ia7BWyJzWYKB
trrY6qKiBLQMPjt8jXahyXVQ9DFwP1nq8dt+busAiYIPozvpiS67tPUuFSoF
D45fmDJQFG1CuisOl0T8D1x1sxA=
        "]]},
      Annotation[#, 
       "Charting`Private`Tag$362037#1"]& ], {}}, {{}, {}, {}}}, {}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->FrontEndValueCache[{{Automatic, 
      Charting`ScaledFrameTicks[{Identity, Identity}]}, {Automatic, 
      Charting`ScaledFrameTicks[{Identity, Identity}]}}, {{Automatic, {{-3., 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.01, 
        0.}, {
         AbsoluteThickness[0.1]}}, {-2., 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.01, 
        0.}, {
         AbsoluteThickness[0.1]}}, {-1., 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.01, 
        0.}, {
         AbsoluteThickness[0.1]}}, {0., 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.01, 
        0.}, {
         AbsoluteThickness[0.1]}}, {1., 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.01, 
        0.}, {
         AbsoluteThickness[0.1]}}, {2., 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.01, 
        0.}, {
         AbsoluteThickness[0.1]}}, {-4., 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {-3.8, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {-3.6, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {-3.4, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {-3.2, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {-2.8, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {-2.6, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {-2.4, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {-2.2, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {-1.8, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {-1.6, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {-1.4, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {-1.2, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {-0.8, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {-0.6, 
        FormBox[
         InterpretationBox[
          StyleBox[
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {-0.4, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {-0.2, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {0.2, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {0.4, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {0.6, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {0.8, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {1.2, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {1.4, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {1.6, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {1.8, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {2.2, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {2.4, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {2.6, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {2.8, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {3., 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}}}, {Automatic, {{-2., 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.01, 
        0.}, {
         AbsoluteThickness[0.1]}}, {0., 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.01, 
        0.}, {
         AbsoluteThickness[0.1]}}, {2., 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.01, 
        0.}, {
         AbsoluteThickness[0.1]}}, {4., 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.01, 
        0.}, {
         AbsoluteThickness[0.1]}}, {-4., 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {-3.5, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {-3., 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {-2.5, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {-1.5, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {-1., 
        FormBox[
         InterpretationBox[
          StyleBox[
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {-0.5, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {0.5, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {1., 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {1.5, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {2.5, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {3., 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {3.5, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {4.5, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {5., 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {5.5, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {6., 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}}}}],
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{-3, 4}, {-2.999999857142857, 1.9977678571428572`}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.709561608692906*^9, 
  3.709561613725709*^9}},ExpressionUUID->"a94b6ed6-b197-48f4-8e12-\
bd1b28238c03"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Rotating a figure:", "Subsubsection",
 CellChangeTimes->{{3.686716923748805*^9, 
  3.686716929466817*^9}},ExpressionUUID->"b15e81aa-2143-407a-a179-\
e8dc53bd6904"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Rotate", "[", 
  RowBox[{
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"f", "[", "x", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "3"}], ",", "4"}], "}"}], ",", 
     RowBox[{"Frame", "\[Rule]", "True"}]}], "]"}], ",", 
   RowBox[{
    RowBox[{"-", "45"}], " ", "Degree"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.6867168767174463`*^9, 
  3.686716914776801*^9}},ExpressionUUID->"0592b725-1a34-4d16-9a9f-\
8eae71cf79aa"],

Cell[BoxData[
 RotationBox[
  GraphicsBox[{{{{}, {}, 
      TagBox[
       {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
        Opacity[1.], LineBox[CompressedData["
1:eJxTTMoPSmViYGAwAWIQ7VF++c3//+wHYLRjlXz4rN8I2qo2+6DJdwSt08w8
LfMdghboN7a/fAdB31g2eeKynQg641qwmW8xgu40vVI/6xkbnLaOOrWmcysr
nJY+8dBwwwwWOO1wj1s1t5EZTl+L0t5UF8QEp2cr5Ew/bs4Ipy/6LBJLZWWA
09OdrrEbbfy7H0a/ql01iaPhN5yWb8sM7JD/Cac3KWQfKHv+DU6f557EPWnX
Fzh99vDirrC4T3Bak+/Hzk6tD3D6rFee1Zm+13A6Wsp85717z+D0Er7WGefq
H8HpJMvA/Yott+H0l3mL+BJXXYLT4gV20V1qh+D0x3+7xM1vH4TTp3vNrzzu
R9D1qw18bX8egNPnzrrWPZi+H07n7uZzW/NoF5xeM23BVeeKjXA6YctMv7kP
N8BpkUuTjn/zQtDfpbiKg63XwelpHJet5NtWwul/zkd1LkWsgNNp9dvlWrWX
w2mzb7OZXl9YAqevPk45tU16AZyusltXcfnOXDjtuXVSjGXTbDj9YlG0CuvZ
aXB6h6QDR3bRFDjdMUHlzQXxSXDa78+tdMujXXD63cvF+qwCbXC693rO9wtR
jXA6oiu7ztK7Ek7rnf4lvehgPpyepOIJRElwGgAohb+x
         "]], 
        LineBox[CompressedData["
1:eJwVlXk41Iv3x5GkCCXZyhJRkdtFReS4Eu0hyZZISoqkXFLpikpRlqRF+VqG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         "]], LineBox[CompressedData["
1:eJwVzH1Q03UcB/DveDpE2LjiMghwAoccWhAHtouHz+eQphRwICByRBC7QEwh
HIcTLVcwYDnH01WEjmByh4QON4qn8RSjwRmhSBkgKa3FQw3j+Rps+/Xzj899
7nWfz/t9ICv/xAdWhJBQep7v6Bqf6BobgnmPO8893qZAUWZqcN9DsHndbli7
QkF2f2rLH04Eg0UxyjA9BY/8Xbo/3Ecw6dvfKv0mKZC+XzAU6E5QH+ZxpWGU
Am7dxNgWm2Dh/aw8lwEKumzFM1f8CdZsrsSQNgrq5s07teEEH0TYOEyXUhC/
L806NZJg5mS0MfYSBfZx3Xs9jxFc5VUuaQooEKjPu9+KJ+gsdhttf4+C1C8X
w/t4BOOmAkvLORS4xUwK9WKC4znpliMGCzz87DVxq5Tguzvylds6C3zec7U6
r5agQbI05zVjgV1frvy/GwQdVHw1U2uBOYZa43iX4HGTWLDwjQVkXc12IY8I
aqs6179ItADbWyAReTFwqIe1uNlrhu9+Kewy+jKw7uRL1Y4qMxwrK9CdO8TA
8xvuoT6tZshbPsM5GcxAn1f9KxO/MkNfe7rel8vAisaoN1R8M6SEHQ0by2Xg
ifKL5fmHzSBNZhoclAzUJ/158G+ZCUzlze9UgRXar3aefirchdqogRs2KdY4
W1Si3U4wQk+9LtGnzAal99481bWxDcqWv1SOTbbYcDe4fqF/EzhxGxcap+yw
iufqPHhqHYpjnk3IiD2+PMEdqTD/C9cYYz/zXPfguPHp2Ef1/0BA/O2gX6Md
MGowLqRtegHkyfnAyt6LgtZIK02ODh6o9j9RXXZEYa4VK9dtDqStszpGmxNW
dfgvr7Y8BI+UwkrXH5kYKO21z1FooGFq2c/2HhPZ2qyCOxka8IzPGF6doG1x
mN1w1gA7+u2t0Wkmkry0NiF/GLxC2WlFBibOx5pi6zk/gN/+cd+pF1lIXrns
e13UD0GL3gOSLBYOuZaEnlZ0QAfv6xRBDgsbxVOOW84dEDzPXOOdZaHQ6P3k
U74KQmaM3qFFLMycGRFe5yiB89N98bKY7gtykshEdyC8/VIyV0n3Bbo0nVHc
hIFDa89e76Tzzt8fLeXLIeJWdoWHmvZq8oKM0wTYlKDeHKHzmQEpcpEMImsP
Hrg5TTvjyNl8RS1oWLJe6e/0v6dAKedUQ5TkhaRiHX3v46+0ia7BWyJzWYKB
trrY6qKiBLQMPjt8jXahyXVQ9DFwP1nq8dt+busAiYIPozvpiS67tPUuFSoF
D45fmDJQFG1CuisOl0T8D1x1sxA=
         "]]},
       Annotation[#, 
        "Charting`Private`Tag$362085#1"]& ], {}}, {{}, {}, {}}}, {}, {}},
   AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
   Axes->{True, True},
   AxesLabel->{None, None},
   AxesOrigin->{0, 0},
   DisplayFunction->Identity,
   Frame->{{True, True}, {True, True}},
   FrameLabel->{{None, None}, {None, None}},
   FrameTicks->FrontEndValueCache[{{Automatic, 
       Charting`ScaledFrameTicks[{Identity, Identity}]}, {Automatic, 
       Charting`ScaledFrameTicks[{Identity, Identity}]}}, {{
      Automatic, {{-3., 
         FormBox[
          InterpretationBox[
           StyleBox[
            
            GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
             Baseline], "CacheGraphics" -> False], 
           Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.01, 
         0.}, {
          AbsoluteThickness[0.1]}}, {-2., 
         FormBox[
          InterpretationBox[
           StyleBox[
            GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
             Baseline], "CacheGraphics" -> False], 
           Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.01, 
         0.}, {
          AbsoluteThickness[0.1]}}, {-1., 
         FormBox[
          InterpretationBox[
           StyleBox[
            
            GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
             Baseline], "CacheGraphics" -> False], 
           Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.01, 
         0.}, {
          AbsoluteThickness[0.1]}}, {0., 
         FormBox[
          InterpretationBox[
           StyleBox[
            
            GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
             Baseline], "CacheGraphics" -> False], 
           Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.01, 
         0.}, {
          AbsoluteThickness[0.1]}}, {1., 
         FormBox[
          InterpretationBox[
           StyleBox[
            
            GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
             Baseline], "CacheGraphics" -> False], 
           Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.01, 
         0.}, {
          AbsoluteThickness[0.1]}}, {2., 
         FormBox[
          InterpretationBox[
           StyleBox[
            
            GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
             Baseline], "CacheGraphics" -> False], 
           Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.01, 
         0.}, {
          AbsoluteThickness[0.1]}}, {-4., 
         FormBox[
          InterpretationBox[
           StyleBox[
            
            GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
             Baseline], "CacheGraphics" -> False], 
           Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
         0.}, {
          AbsoluteThickness[0.1]}}, {-3.8, 
         FormBox[
          InterpretationBox[
           StyleBox[
            
            GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
             Baseline], "CacheGraphics" -> False], 
           Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
         0.}, {
          AbsoluteThickness[0.1]}}, {-3.6, 
         FormBox[
          InterpretationBox[
           StyleBox[
            
            GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
             Baseline], "CacheGraphics" -> False], 
           Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
         0.}, {
          AbsoluteThickness[0.1]}}, {-3.4, 
         FormBox[
          InterpretationBox[
           StyleBox[
            
            GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
             Baseline], "CacheGraphics" -> False], 
           Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
         0.}, {
          AbsoluteThickness[0.1]}}, {-3.2, 
         FormBox[
          InterpretationBox[
           StyleBox[
            
            GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
             Baseline], "CacheGraphics" -> False], 
           Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
         0.}, {
          AbsoluteThickness[0.1]}}, {-2.8, 
         FormBox[
          InterpretationBox[
           StyleBox[
            
            GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
             Baseline], "CacheGraphics" -> False], 
           Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
         0.}, {
          AbsoluteThickness[0.1]}}, {-2.6, 
         FormBox[
          InterpretationBox[
           StyleBox[
            
            GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
             Baseline], "CacheGraphics" -> False], 
           Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
         0.}, {
          AbsoluteThickness[0.1]}}, {-2.4, 
         FormBox[
          InterpretationBox[
           StyleBox[
            
            GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
             Baseline], "CacheGraphics" -> False], 
           Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
         0.}, {
          AbsoluteThickness[0.1]}}, {-2.2, 
         FormBox[
          InterpretationBox[
           StyleBox[
            
            GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
             Baseline], "CacheGraphics" -> False], 
           Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
         0.}, {
          AbsoluteThickness[0.1]}}, {-1.8, 
         FormBox[
          InterpretationBox[
           StyleBox[
            
            GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
             Baseline], "CacheGraphics" -> False], 
           Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
         0.}, {
          AbsoluteThickness[0.1]}}, {-1.6, 
         FormBox[
          InterpretationBox[
           StyleBox[
            
            GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
             Baseline], "CacheGraphics" -> False], 
           Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
         0.}, {
          AbsoluteThickness[0.1]}}, {-1.4, 
         FormBox[
          InterpretationBox[
           StyleBox[
            
            GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
             Baseline], "CacheGraphics" -> False], 
           Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
         0.}, {
          AbsoluteThickness[0.1]}}, {-1.2, 
         FormBox[
          InterpretationBox[
           StyleBox[
            
            GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
             Baseline], "CacheGraphics" -> False], 
           Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
         0.}, {
          AbsoluteThickness[0.1]}}, {-0.8, 
         FormBox[
          InterpretationBox[
           StyleBox[
            
            GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
             Baseline], "CacheGraphics" -> False], 
           Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
         0.}, {
          AbsoluteThickness[0.1]}}, {-0.6, 
         FormBox[
          InterpretationBox[
           StyleBox[
            
            GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
             Baseline], "CacheGraphics" -> False], 
           Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
         0.}, {
          AbsoluteThickness[0.1]}}, {-0.4, 
         FormBox[
          InterpretationBox[
           StyleBox[
            
            GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
             Baseline], "CacheGraphics" -> False], 
           Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
         0.}, {
          AbsoluteThickness[0.1]}}, {-0.2, 
         FormBox[
          InterpretationBox[
           StyleBox[
            
            GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
             Baseline], "CacheGraphics" -> False], 
           Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
         0.}, {
          AbsoluteThickness[0.1]}}, {0.2, 
         FormBox[
          InterpretationBox[
           StyleBox[
            
            GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
             Baseline], "CacheGraphics" -> False], 
           Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
         0.}, {
          AbsoluteThickness[0.1]}}, {0.4, 
         FormBox[
          InterpretationBox[
           StyleBox[
            
            GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
             Baseline], "CacheGraphics" -> False], 
           Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
         0.}, {
          AbsoluteThickness[0.1]}}, {0.6, 
         FormBox[
          InterpretationBox[
           StyleBox[
            
            GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
             Baseline], "CacheGraphics" -> False], 
           Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
         0.}, {
          AbsoluteThickness[0.1]}}, {0.8, 
         FormBox[
          InterpretationBox[
           StyleBox[
            
            GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
             Baseline], "CacheGraphics" -> False], 
           Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
         0.}, {
          AbsoluteThickness[0.1]}}, {1.2, 
         FormBox[
          InterpretationBox[
           StyleBox[
            
            GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
             Baseline], "CacheGraphics" -> False], 
           Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
         0.}, {
          AbsoluteThickness[0.1]}}, {1.4, 
         FormBox[
          InterpretationBox[
           StyleBox[
            
            GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
             Baseline], "CacheGraphics" -> False], 
           Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
         0.}, {
          AbsoluteThickness[0.1]}}, {1.6, 
         FormBox[
          InterpretationBox[
           StyleBox[
            
            GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
             Baseline], "CacheGraphics" -> False], 
           Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
         0.}, {
          AbsoluteThickness[0.1]}}, {1.8, 
         FormBox[
          InterpretationBox[
           StyleBox[
            
            GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
             Baseline], "CacheGraphics" -> False], 
           Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
         0.}, {
          AbsoluteThickness[0.1]}}, {2.2, 
         FormBox[
          InterpretationBox[
           StyleBox[
            
            GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
             Baseline], "CacheGraphics" -> False], 
           Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
         0.}, {
          AbsoluteThickness[0.1]}}, {2.4, 
         FormBox[
          InterpretationBox[
           StyleBox[
            
            GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
             Baseline], "CacheGraphics" -> False], 
           Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
         0.}, {
          AbsoluteThickness[0.1]}}, {2.6, 
         FormBox[
          InterpretationBox[
           StyleBox[
            
            GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
             Baseline], "CacheGraphics" -> False], 
           Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
         0.}, {
          AbsoluteThickness[0.1]}}, {2.8, 
         FormBox[
          InterpretationBox[
           StyleBox[
            
            GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
             Baseline], "CacheGraphics" -> False], 
           Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
         0.}, {
          AbsoluteThickness[0.1]}}, {3., 
         FormBox[
          InterpretationBox[
           StyleBox[
            
            GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
             Baseline], "CacheGraphics" -> False], 
           Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
         0.}, {
          AbsoluteThickness[0.1]}}}}, {Automatic, {{-2., 
         FormBox[
          InterpretationBox[
           StyleBox[
            
            GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
             Baseline], "CacheGraphics" -> False], 
           Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.01, 
         0.}, {
          AbsoluteThickness[0.1]}}, {0., 
         FormBox[
          InterpretationBox[
           StyleBox[
            
            GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
             Baseline], "CacheGraphics" -> False], 
           Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.01, 
         0.}, {
          AbsoluteThickness[0.1]}}, {2., 
         FormBox[
          InterpretationBox[
           StyleBox[
            
            GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
             Baseline], "CacheGraphics" -> False], 
           Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.01, 
         0.}, {
          AbsoluteThickness[0.1]}}, {4., 
         FormBox[
          InterpretationBox[
           StyleBox[
            
            GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
             Baseline], "CacheGraphics" -> False], 
           Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.01, 
         0.}, {
          AbsoluteThickness[0.1]}}, {-4., 
         FormBox[
          InterpretationBox[
           StyleBox[
            
            GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
             Baseline], "CacheGraphics" -> False], 
           Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
         0.}, {
          AbsoluteThickness[0.1]}}, {-3.5, 
         FormBox[
          InterpretationBox[
           StyleBox[
            
            GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
             Baseline], "CacheGraphics" -> False], 
           Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
         0.}, {
          AbsoluteThickness[0.1]}}, {-3., 
         FormBox[
          InterpretationBox[
           StyleBox[
            
            GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
             Baseline], "CacheGraphics" -> False], 
           Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
         0.}, {
          AbsoluteThickness[0.1]}}, {-2.5, 
         FormBox[
          InterpretationBox[
           StyleBox[
            
            GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
             Baseline], "CacheGraphics" -> False], 
           Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
         0.}, {
          AbsoluteThickness[0.1]}}, {-1.5, 
         FormBox[
          InterpretationBox[
           StyleBox[
            
            GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
             Baseline], "CacheGraphics" -> False], 
           Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
         0.}, {
          AbsoluteThickness[0.1]}}, {-1., 
         FormBox[
          InterpretationBox[
           StyleBox[
            
            GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
             Baseline], "CacheGraphics" -> False], 
           Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
         0.}, {
          AbsoluteThickness[0.1]}}, {-0.5, 
         FormBox[
          InterpretationBox[
           StyleBox[
            
            GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
             Baseline], "CacheGraphics" -> False], 
           Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
         0.}, {
          AbsoluteThickness[0.1]}}, {0.5, 
         FormBox[
          InterpretationBox[
           StyleBox[
            
            GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
             Baseline], "CacheGraphics" -> False], 
           Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
         0.}, {
          AbsoluteThickness[0.1]}}, {1., 
         FormBox[
          InterpretationBox[
           StyleBox[
            
            GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
             Baseline], "CacheGraphics" -> False], 
           Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
         0.}, {
          AbsoluteThickness[0.1]}}, {1.5, 
         FormBox[
          InterpretationBox[
           StyleBox[
            
            GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
             Baseline], "CacheGraphics" -> False], 
           Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
         0.}, {
          AbsoluteThickness[0.1]}}, {2.5, 
         FormBox[
          InterpretationBox[
           StyleBox[
            GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
             Baseline], "CacheGraphics" -> False], 
           Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
         0.}, {
          AbsoluteThickness[0.1]}}, {3., 
         FormBox[
          InterpretationBox[
           StyleBox[
            
            GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
             Baseline], "CacheGraphics" -> False], 
           Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
         0.}, {
          AbsoluteThickness[0.1]}}, {3.5, 
         FormBox[
          InterpretationBox[
           StyleBox[
            
            GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
             Baseline], "CacheGraphics" -> False], 
           Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
         0.}, {
          AbsoluteThickness[0.1]}}, {4.5, 
         FormBox[
          InterpretationBox[
           StyleBox[
            
            GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
             Baseline], "CacheGraphics" -> False], 
           Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
         0.}, {
          AbsoluteThickness[0.1]}}, {5., 
         FormBox[
          InterpretationBox[
           StyleBox[
            
            GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
             Baseline], "CacheGraphics" -> False], 
           Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
         0.}, {
          AbsoluteThickness[0.1]}}, {5.5, 
         FormBox[
          InterpretationBox[
           StyleBox[
            
            GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
             Baseline], "CacheGraphics" -> False], 
           Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
         0.}, {
          AbsoluteThickness[0.1]}}, {6., 
         FormBox[
          InterpretationBox[
           StyleBox[
            
            GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
             Baseline], "CacheGraphics" -> False], 
           Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
         0.}, {
          AbsoluteThickness[0.1]}}}}}],
   GridLines->{None, None},
   GridLinesStyle->Directive[
     GrayLevel[0.5, 0.4]],
   ImagePadding->All,
   Method->{
    "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
     AbsolutePointSize[6], "ScalingFunctions" -> None, 
     "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
         (Identity[#]& )[
          Part[#, 1]], 
         (Identity[#]& )[
          Part[#, 2]]}& ), "CopiedValueFunction" -> ({
         (Identity[#]& )[
          Part[#, 1]], 
         (Identity[#]& )[
          Part[#, 2]]}& )}},
   PlotRange->{{-3, 4}, {-2.999999857142857, 1.9977678571428572`}},
   PlotRangeClipping->True,
   PlotRangePadding->{{
      Scaled[0.02], 
      Scaled[0.02]}, {
      Scaled[0.05], 
      Scaled[0.05]}},
   Ticks->{Automatic, Automatic}],
  BoxRotation->-0.7853981633974483]], "Output",
 CellChangeTimes->{
  3.709561622502092*^9},ExpressionUUID->"6aff13db-ef06-4ad9-b664-\
86137de3a068"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Exporting a table of (rotated) figures to a video file for animation:\
\>", "Subsubsection",
 CellChangeTimes->{{3.686716952664856*^9, 3.6867169649572268`*^9}, {
  3.686717845866146*^9, 
  3.686717853288291*^9}},ExpressionUUID->"dc7de3d2-f301-4253-a4db-\
c2fb71d2a3ea"],

Cell[BoxData[
 RowBox[{
  RowBox[{"tableofrotatedplots", "=", "\[IndentingNewLine]", 
   RowBox[{"Table", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Rotate", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"DensityPlot", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["x", "2"], "+", 
            SuperscriptBox["y", "2"]}], ")"}], "*", 
          RowBox[{"Exp", "[", 
           RowBox[{
            RowBox[{"-", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["x", "2"], "+", 
               SuperscriptBox["y", "2"]}], ")"}]}], "/", 
            SuperscriptBox["\[Sigma]", "2"]}], "]"}]}], ",", 
         RowBox[{"{", 
          RowBox[{"x", ",", 
           RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"y", ",", 
           RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
         RowBox[{"PlotPoints", "\[Rule]", "50"}], ",", 
         RowBox[{"ImageSize", "\[Rule]", 
          RowBox[{"Scaled", "[", "0.35", "]"}]}], ",", "\[IndentingNewLine]", 
         
         RowBox[{"FrameLabel", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Style", "[", 
             RowBox[{"\"\<z/\[Lambda]\>\"", ",", "Black", ",", "15"}], "]"}], 
            ",", 
            RowBox[{"Style", "[", 
             RowBox[{"\"\<x/\[Lambda]\>\"", ",", "Black", ",", "15"}], 
             "]"}]}], "}"}]}], ",", 
         RowBox[{"FrameTicksStyle", "\[Rule]", 
          RowBox[{"Directive", "[", 
           RowBox[{"Black", ",", "12"}], "]"}]}]}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"-", "45"}], " ", "Degree"}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"\[Sigma]", ",", "1", ",", "5", ",", "0.25"}], "}"}]}], "]"}]}],
   ";"}]], "Input",
 CellChangeTimes->{{3.6867170351064663`*^9, 3.686717078226115*^9}, {
  3.6867171294981737`*^9, 3.686717193504714*^9}, {3.686717228350314*^9, 
  3.686717323810882*^9}, {3.686717572124611*^9, 
  3.6867175815507*^9}},ExpressionUUID->"cac1f01f-a944-4083-86ba-e2ed54387327"],

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"NotebookDirectory", "[", "]"}], "<>", "\"\<evolution.mov\>\""}], 
   ",", "tableofrotatedplots", ",", 
   RowBox[{"\"\<VideoEncoding\>\"", "\[Rule]", "\"\<MPEG-4 Video\>\""}], ",", 
   
   RowBox[{"\"\<FrameRate\>\"", "\[Rule]", "4"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.6867173695627537`*^9, 
  3.6867173746392317`*^9}},ExpressionUUID->"acd1e299-41da-4d2c-8401-\
fa1e93816b4a"]
}, Open  ]],

Cell[TextData[StyleBox["At this point you should be able to find the video \
files, and run them separately.", "Subsection"]], "Subsubsection",
 CellChangeTimes->{{3.686717626783584*^9, 
  3.6867176949332743`*^9}},ExpressionUUID->"cf6aef8b-0005-42c0-91de-\
1157d633197c"],

Cell[CellGroupData[{

Cell["\<\
You can also import the saved video as an animation in Mathematica:\
\>", "Subsubsection",
 CellChangeTimes->{3.686717701108947*^9, 
  3.686717899816362*^9},ExpressionUUID->"af353f1f-66b1-46dc-9822-\
e9c5456b40a2"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Import", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"NotebookDirectory", "[", "]"}], "<>", "\"\<evolution.mov\>\""}], 
   ",", "\"\<Animation\>\""}], "]"}]], "Input",
 CellChangeTimes->{{3.6867174728178997`*^9, 3.686717480624268*^9}, {
  3.686717544019384*^9, 
  3.686717552469059*^9}},ExpressionUUID->"0e859f5d-7961-444e-b7bf-\
ff261d9b5f38"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`i127$$ = 9, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {
    "\"min\"" :> {$CellContext`i127$$ = 1}, 
     "\"max\"" :> {$CellContext`i127$$ = 17}}, Typeset`bookmarkMode$$ = 
    "Menu", Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`i127$$], 1, ""}, 1, 17, 1}}, Typeset`size$$ = 
    Automatic, Typeset`update$$ = 0, Typeset`initDone$$, 
    Typeset`skipInitDone$$ = True, $CellContext`i127$346848$$ = 0}, 
    PaneBox[
     PanelBox[
      DynamicWrapperBox[GridBox[{
         {
          ItemBox[
           ItemBox[
            TagBox[
             StyleBox[GridBox[{
                {"\<\"\"\>", 
                 AnimatorBox[Dynamic[$CellContext`i127$$], {1, 17, 1},
                  AnimationRate->Automatic,
                  AnimationRunTime->0.,
                  AnimationRunning->False,
                  AnimationTimeIndex->2.5,
                  
                  AppearanceElements->{
                   "ProgressSlider", "PlayPauseButton", "FasterSlowerButtons",
                     "DirectionButton"},
                  AutoAction->False,
                  DisplayAllSteps->True]}
               },
               AutoDelete->False,
               
               GridBoxAlignment->{
                "Columns" -> {Right, {Left}}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
               
               GridBoxItemSize->{
                "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
              "ListAnimateLabel",
              StripOnInput->False],
             {"ControlArea", Top}],
            Alignment->{Automatic, Inherited},
            StripOnInput->False],
           Background->None,
           StripOnInput->False]},
         {
          ItemBox[
           TagBox[
            StyleBox[
             PaneBox[
              TagBox[
               PaneSelectorBox[{1->
                GraphicsBox[
                 TagBox[RasterBox[CompressedData["
1:eJztyjEKwkAQBdAlNpZewRuIla2lbcQDJLgGmxU2AfHsgmTiKVK8B3+Y+cy+
f7WPJqU0bmO03ftca/e57uK4lfE5lHy/lCkPuZ76TZTH+D1Elv0HAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAr8AUAAOBvBsAgC5k=
                   "], {{0, 562}, {560, 0}}, {0, 255},
                   ColorFunction->RGBColor],
                  BoxForm`ImageTag[
                  "Byte", ColorSpace -> Automatic, Interleaving -> True],
                  Selectable->False],
                 DefaultBaseStyle->"ImageGraphics",
                 ImageSizeRaw->{560, 562},
                 PlotRange->{{0, 560}, {0, 562}}], 2->
                GraphicsBox[
                 TagBox[RasterBox[CompressedData["
1:eJztyjEKwkAQBdAlNpZewRuIla2lbcQDJLgGmxU2AfHsgmTiKVK8B3+Y+cy+
f7WPJqU0bmO03ftca/e57uK4lfE5lHy/lCkPuZ76TZTH+D1Elv0HAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAr8AUAAOBvBsAgC5k=
                   "], {{0, 562}, {560, 0}}, {0, 255},
                   ColorFunction->RGBColor],
                  BoxForm`ImageTag[
                  "Byte", ColorSpace -> Automatic, Interleaving -> True],
                  Selectable->False],
                 DefaultBaseStyle->"ImageGraphics",
                 ImageSizeRaw->{560, 562},
                 PlotRange->{{0, 560}, {0, 562}}], 3->
                GraphicsBox[
                 TagBox[RasterBox[CompressedData["
1:eJztyjEKwkAQBdAlNpZewRuIla2lbcQDJLgGmxU2AfHsgmTiKVK8B3+Y+cy+
f7WPJqU0bmO03ftca/e57uK4lfE5lHy/lCkPuZ76TZTH+D1Elv0HAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAr8AUAAOBvBsAgC5k=
                   "], {{0, 562}, {560, 0}}, {0, 255},
                   ColorFunction->RGBColor],
                  BoxForm`ImageTag[
                  "Byte", ColorSpace -> Automatic, Interleaving -> True],
                  Selectable->False],
                 DefaultBaseStyle->"ImageGraphics",
                 ImageSizeRaw->{560, 562},
                 PlotRange->{{0, 560}, {0, 562}}], 4->
                GraphicsBox[
                 TagBox[RasterBox[CompressedData["
1:eJztyjEKwkAQBdAlNpZewRuIla2lbcQDJLgGmxU2AfHsgmTiKVK8B3+Y+cy+
f7WPJqU0bmO03ftca/e57uK4lfE5lHy/lCkPuZ76TZTH+D1Elv0HAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAr8AUAAOBvBsAgC5k=
                   "], {{0, 562}, {560, 0}}, {0, 255},
                   ColorFunction->RGBColor],
                  BoxForm`ImageTag[
                  "Byte", ColorSpace -> Automatic, Interleaving -> True],
                  Selectable->False],
                 DefaultBaseStyle->"ImageGraphics",
                 ImageSizeRaw->{560, 562},
                 PlotRange->{{0, 560}, {0, 562}}], 5->
                GraphicsBox[
                 TagBox[RasterBox[CompressedData["
1:eJztyjEKwkAQBdAlNpZewRuIla2lbcQDJLgGmxU2AfHsgmTiKVK8B3+Y+cy+
f7WPJqU0bmO03ftca/e57uK4lfE5lHy/lCkPuZ76TZTH+D1Elv0HAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAr8AUAAOBvBsAgC5k=
                   "], {{0, 562}, {560, 0}}, {0, 255},
                   ColorFunction->RGBColor],
                  BoxForm`ImageTag[
                  "Byte", ColorSpace -> Automatic, Interleaving -> True],
                  Selectable->False],
                 DefaultBaseStyle->"ImageGraphics",
                 ImageSizeRaw->{560, 562},
                 PlotRange->{{0, 560}, {0, 562}}], 6->
                GraphicsBox[
                 TagBox[RasterBox[CompressedData["
1:eJztyjEKwkAQBdAlNpZewRuIla2lbcQDJLgGmxU2AfHsgmTiKVK8B3+Y+cy+
f7WPJqU0bmO03ftca/e57uK4lfE5lHy/lCkPuZ76TZTH+D1Elv0HAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAr8AUAAOBvBsAgC5k=
                   "], {{0, 562}, {560, 0}}, {0, 255},
                   ColorFunction->RGBColor],
                  BoxForm`ImageTag[
                  "Byte", ColorSpace -> Automatic, Interleaving -> True],
                  Selectable->False],
                 DefaultBaseStyle->"ImageGraphics",
                 ImageSizeRaw->{560, 562},
                 PlotRange->{{0, 560}, {0, 562}}], 7->
                GraphicsBox[
                 TagBox[RasterBox[CompressedData["
1:eJztyjEKwkAQBdAlNpZewRuIla2lbcQDJLgGmxU2AfHsgmTiKVK8B3+Y+cy+
f7WPJqU0bmO03ftca/e57uK4lfE5lHy/lCkPuZ76TZTH+D1Elv0HAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAr8AUAAOBvBsAgC5k=
                   "], {{0, 562}, {560, 0}}, {0, 255},
                   ColorFunction->RGBColor],
                  BoxForm`ImageTag[
                  "Byte", ColorSpace -> Automatic, Interleaving -> True],
                  Selectable->False],
                 DefaultBaseStyle->"ImageGraphics",
                 ImageSizeRaw->{560, 562},
                 PlotRange->{{0, 560}, {0, 562}}], 8->
                GraphicsBox[
                 TagBox[RasterBox[CompressedData["
1:eJztyjEKwkAQBdAlNpZewRuIla2lbcQDJLgGmxU2AfHsgmTiKVK8B3+Y+cy+
f7WPJqU0bmO03ftca/e57uK4lfE5lHy/lCkPuZ76TZTH+D1Elv0HAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAr8AUAAOBvBsAgC5k=
                   "], {{0, 562}, {560, 0}}, {0, 255},
                   ColorFunction->RGBColor],
                  BoxForm`ImageTag[
                  "Byte", ColorSpace -> Automatic, Interleaving -> True],
                  Selectable->False],
                 DefaultBaseStyle->"ImageGraphics",
                 ImageSizeRaw->{560, 562},
                 PlotRange->{{0, 560}, {0, 562}}], 9->
                GraphicsBox[
                 TagBox[RasterBox[CompressedData["
1:eJzsvW1sFGea95tMwpCEJczO7MxzztlnpDkfdrQ62g/nPPvh7Hw5q/1wtMoq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                   "], {{0, 562}, {560, 
                   0}}, {0, 255},
                   ColorFunction->RGBColor],
                  BoxForm`ImageTag[
                  "Byte", ColorSpace -> Automatic, Interleaving -> True],
                  Selectable->False],
                 DefaultBaseStyle->"ImageGraphics",
                 ImageSizeRaw->{560, 562},
                 PlotRange->{{0, 560}, {0, 562}}], 10->
                GraphicsBox[
                 TagBox[RasterBox[CompressedData["
1:eJzt3cFu5Mp1BmAj2WSZV8gbBFllm2W2DvIANuwY2TiAHSDISyebsTAEiWa6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                   "], {{0, 
                   562}, {560, 0}}, {0, 255},
                   ColorFunction->RGBColor],
                  BoxForm`ImageTag[
                  "Byte", ColorSpace -> Automatic, Interleaving -> True],
                  Selectable->False],
                 DefaultBaseStyle->"ImageGraphics",
                 ImageSizeRaw->{560, 562},
                 PlotRange->{{0, 560}, {0, 562}}], 11->
                GraphicsBox[
                 TagBox[RasterBox[CompressedData["
1:eJzt3cFu5Mp1BmAj2WSZV8gbBFllm2W2DvIANuwY2TiAHSDISyebsTAEiWa6
2brTUvcoENUk/0PW96E8ntG0dHWrTp3/NtXN+rvf/sev/+2vfvWrX/35b86/
/Po3//VPf/rTb/77X/72/Id//eOf//0Pf/z97/75j//5+z/8/k//+Nu/Pn/w
H86P/fvz/y6/PwEAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAANQzDkP4WAEAe
AVCCPAKggr7vT6dxGgAQMz0/kkcAhJ2fH40rS/8rArAD8giAIuQRABXIIwAq
kEcAxA3DII8AiJNHABQhjwCoQB4BEOf9RwBUII8AKEIeAVCBPAIgzvU6ACqQ
RwBsrJucpvfA9pPr4bDyCIA1rJ0vc6XnA4CMdP7cS88HABnp/LmXng8AMtL5
cy89HwBkpPPnXno+AMhI58+99HwAkJHOn3vp+QAgYIPz9eZKTwkAM43fpvEy
je4yTv00ZpBHADxriTw6uV4HwJNek0geARAljwCo4JpBTyTR65cpZtlJAmB1
S+SR1zMA8LT+zXjjXUK9/dvxNoZpnMZ6cfTjewNgL2bk0XDxLo+GvmIYnfWd
PALYuSmJ0nmytfSkA/BAHgFQwuXqXDoftpaecwAeySMAKpBHAFQgjwCoIp0P
W0vPNwA/l86HraXnG4BHY9eVfI/rmtJzDsAjeQRABWN7l+vkEUBBRW9Jt6r0
nAPwYLjcjLQ16UkH4IE8AqCAYRz7Fn9+dB0ALG8Yhn5y/s3//4C3D+uG0/e+
uR8g9ZfzneQRwGzp/t269PoDVJHux61Lrz9AFel+3Lr0+gNUke7HrUuvP0AV
6X7cuvT6A1SR7setS68/QBXpfty69PoDVJHux61Lrz/A5obxMq53Dxi7aXw7
j3Q/bl26LAA2J49KSpcFwPbe3FdNHpURLQmACHlUUbQkABJeM+g6Xn6MdD9u
XbosADYnj0pKlwXA5qarc7+Maxhdsindj1s3nC4jXRwAG5JHJckjgOsrHNiX
dM0ArEEe7U+6ZgDWku6vzJOuF4C1pPsr86TrBWAFXs+wQ+miAViBPNqhdNEA
rEAe7VC6aABWMHbD6Xu6vzJPumgAHnTjZfTTeD1LYq5+GDw/2pnlCwngSUvk
0Xmk+yvzLF9IAE96m0SvedRPY550f2WeNUoJ4CnyqElrlBLAU94l0dXcPHK/
oP1ZvpAAnrREHg1Dur0y0/KFBLCM/n68y6k3Z5S/8/pX8mh3nE8BVPWpPBom
bz7rkkTXwb50vTwCypsyCN5KFyXQJHnEg3RRAk2SRzxIFyXQJHnEg3RRAm3y
fiLupWsSaJM84l66JoF2pfsftaTrEWhXuv9RS7oegR1a4PyIU9c5z4h3Fq9T
4PjkEStYvE6B43N+BCtYo1SBg1sijwY3pOO9laoVOLIlzo/oe8+PeGf5QgUO
Tx6xguULFWjFE+cZDePQp9sfxXSny9i6ioElvD8naHsz8qifnC7f89h1Q9+d
/2s43f4o5qWXR8DT3B+VzaWLHihJHrG5dNEDJckjNpcueqAkecTm0kUPfN2a
r39wfgRbW62YgdVdX+G2DnnE1lYrZmB1a78+PN2faMuqxQzsl/vRsbF0yQNF
ySM2li55oK50f6It6XoHiup7N6RjU+mSB4py3isbS5c8UNPox0dsLF3zQE3e
f8TW0jUPPOH1hJmXaUy/f3eO3uvJRLfx+UcOY+9yHdsaTpeR2UrAk36WR33/
/XrfhvMvl/8fxu77qft+OS/vMY9+OcbocrrrOYCmB4/XB39/SbcnGiOPYL/S
/QOS0vsPuEn3A0hK7z/gJt0PICm9/4CbdD+ApPT+A27S/QCS0vsPuEn3A0hK
7z/gJt0PICm9/4CbdD+ApPT+gyZ142X007jeP2GS7geQlN2U0Ch5BA+ymxIa
9TaJXvPocrefdD+ApPS2hCbJI3iQ3pbQpHdJdCWPaF1yS0Kz5BE8SG5JaF1/
N9L9AJKup62kdyW0SR7BzUsvj6CA6dod8HnpTQsHJY9gpvSmhYOSRzBTetPC
QckjmCm9aeGoRrcLglnSexaOSh7BPOk9C0eW3t+wJ+n9CkeW3t+wJ+n9CiV9
cH7EvK/Rden9DXuy+D6GI5BHsLnF9zEcwQfnR8z9Mun9DXuyxlaG3Vsij4bB
G5BghpV2M+zbB+dHzPkSY997fgQzLL+R4QDkEWxu+Y0Mx3F/fsT7nLqOR9PH
h3Fw3ATM4bwk+Nin8miYXB7d913XDdNf9d34/cXPj2AG5yXBp7g/KhSTbgoQ
Io+gmHRTgBB5BMWkmwKEyCMoJt0UIMX5EVBLuidAijyCWtI9AZLS+w+4SfcD
iHE/Oigl3RIgRh5BKemWAEnp/QfcpPsBxPS9G9JBIemWADHOe4VS0i0BUkY/
PoJS0j0BUrz/CGpJ9wT4krcnRLyesvLtMt6eYfT68Wm8O33v9ROdrwelDKfL
CPUU+KqZedR1L+dxml7jfY6h8xiG80ddsINC5BFbStc7cBzpfsa+pesXOI50
P2Pf0vULHEe6n7Fv6foFjiPdz9i3dP0Cx5HuZ+xbun6B40j3M/YtXb/AcaT7
GfuWrl/gONL9jH1L1y9wHOl+xr6l6xc4jnQ/Y9/S9QscR7qfsW/p+gWOI93P
2Ld0/QLHke5n7Fu6foHjSPcz9i1dv8BxDNNIdzX2Kl2/wHF0w0kesZl0vQPH
ke5n7Fjf9+n6BY4j3dLYMXkELCjd0ti3dP0Cx5HuZ+zYMAzp+gWOI93S2DF5
BCwo3dLYMT8/AhaUbmnsmDwCFpRuaYSM36bxMo3uMk79NGZ+GYCFrNHq2IEl
8sjzI2BBK3U7qntNInkEVLFSt6O6JfLo5HodsJw1Wh07cM2gJ5LorOu6dP0C
x7F4n2Mf5BFQzOJ9jp3o34w33iXU278db2OYxmn0dlhgQb80GVozO4/6/tRf
/jQO/dh9v/w+XbzAoVw7zMatkIqmJErXI8Ba0k2WT5NHwKGlmyyfd7k6l64X
gLWkeyyfJ4+AI0v3WD5PHgFHlu6xfJ48Ao4s3WOZJ10vAGtJ91dmcN4rcGDp
Fsvnud8CcGTpHsvnjS7XAQeW7rF83ugWQMCBpXssnzd2nQt2wGGleyyfNlxu
lApwVOkmy6dNp0gAHFW6yfJZw2nsPD8CjivdZfm5bnKa3nPUXw3yCDiydN9t
XXr9AapI9+PWpdcfoIp0P25dev0Bqkj349al1x+ginQ/bl16/QGqSPfj1qXX
H6CKdD9uXXr9AapI9+OmOc8I4Id0S26aPAL4Id2SW5def4Aq0v24den1B6gi
3Y9bl15/gCrS/bh16fUHqCLdj5vm9QwAP6RbcrvG4XTq5RHAq+nQ0XRrrur8
/GWpr3P3pS5/PIeRy3UAv+iGXh59xPU0gLLSEbGpvncgK0BR6YjYlDwCKCsd
EVtLzzcAP5fOh62l5xuAn0vnw9bS8w3Az6XzYVNeXwdQVjoiNiWPAMpKR8Sm
5BFAWemI2JQ8AigrHRFbS883AD+XzodNeX4EUFY6Ijbl/gwAZaUjYlOeHwGU
lY6IraXnG4CfS+fD1tLzDcDPXbv0MAz952TT5Enn7/+jI/muM3A9aO/tv2l6
fQBasWEa7FJ6fQBake731aXXB6AV6X5fXXp9AFqR7vfVpdcHoBXpfl9den0A
WpHu99Wl1wegFel+X116fQBake731aXXB6AV6X5fXXp9AFqR7vfVpdcHoBXp
fl9den0AWpHu99Wl1wegFel+X116fQBake731aXXB6AV6X5fXXp9AFqR7vdH
k15PgCrS/bh16fUHqCLdj1uXXn+AKtL9uHXp9QeoIt2PW5def4Aq0v24den1
B6gi3Y9bl15/gCrS/bh16fUHqCLdj1uXXn+AKtL9uHXp9QeoIt2PW5def4Aq
0v24den1B6gi3Y9bl15/gCrS/bh16fUHqCLdj1uXXn+AKtL9uHXp9QeoIt2P
+Uj/Ztyk6wVo17kDTYPWyCOgFnnUqLG7jTeplK5HoF3ZpkiMPAKKyTZFYsaX
N+OWSul6BNqVbouEyCOgmHRbJGT8Ng15BFSRbouEyCOgmHRbpJZ0PQLtSvc/
aknXI9CudP+jlnQ9Au1K9z9qSdcj0K50/6OWdD0C7Ur3P2pJ1yPQrnT/o5Z0
PQLtSvc/aknXI9CudP8jxPthgZUN00g3O8qTR8DK5BHPSNcvcBzpfsa+pesX
OI50P2Pf0vULHEe6n7Fv6foFjiPdz9i3dP0Cx5HuZ+xbun6B40j3M/YtXb/A
caT7GfuWrl/gONL9jH1L1y9wHOl+xr6l6xc4jnQ/Y9/S9QscR7qfsW/p+gWO
I93P2Ld0/QLHke5n7Fu6foHjSPczmLyeZ/F4qsU4jetjuh+j617O4/yxYRj6
/nQew3D+6JDeT8DNcLqMZGOBL5iZR9fTl3588nWcUym9/4AbecQuvc2a1zya
xpwv4fIhlLJWu4BVLZFHg8t1UMla7QLW9Xhdbrp2N0fXden9B9ws3ydgCwvk
Ud/36f0H3CzfJ2ADw3gZ11T6ah6d/AAJKlmjVcDqlsijwQ+QoJKVugXUJ4+g
lHRLgKT0/gNu0v0AUrz/CGpJ9wRIkUdQS7onQMj0igigjnRTgBB5BMWkmwKE
yCMoJt0UIEQeQTHppgBb6u/H9X21b99dO70v6ew03VCo67ph+qu+G7+/CDCY
4fpO9fSuh5o+lUcPpo8P4+B2dzCHPIKfeJc7V29P6PsM5/fBPMtvZDgAeQSb
W34jwwH042W8S6W5eeR+dzDPSrsZ9m2JPDq5oQPMscZWht3rxst4m0pf+BrO
k4U5Ft/HcATyCDa3+D4Gfkjvb9iT9H6FI0vvb9iT9H6Fo3I+BcyT3rNwVPII
5knvWTgo91+FmdKbFg5KHsFM6U0LByWPYKb0poWDkkcwU3rTwpHcn0+R3t+Q
5PwIyJFHcCOPIOCD8ynS/QCSklsSmiWP4EFyS0KzPjifIt0PICm9LaFJ8gge
pLclNOmD8ynS/QCSspsSGiWP4EF2UwJvpfsBJKX3H3CT7geQlN5/wE26H0BS
ev8BN+l+AEnp/QfcpPsBJKX3H3CT7geQlN5/wE26H0BSev8BN+l+AEnp/QdN
+uB+qqfx5S8v/3P+9eX7/56ud99/PYri4uXl/Mdx6Me/fOv67vK5/fBtGi/n
8faR54f1/en6mO77ZZw/6/tLut3QmOF0GdtvL2CGj/PozbjPo9Nla7+/693n
H3kOry7dnmiMPIId+OB+qmv+I0eXA9nYmvUMLCSRR8OQbk80Zs16Bhbywf1U
1/1ndi7YsakNqhp4ViKP+t75Smxqg6oGdirdn2hLut6BogY/QGJb6ZIHipJH
bCxd8kBd6f5EW9L1DtTk/UdsLV3zQE3yiK2lax4oaXpVOWwpXfRASfKIzaWL
HihJHrG5dNEDJckjNpcueqCO/n68u4Prdfzy0Mnp8jalseuGvnM+Bfemc02k
DPAFM/Lojdezkwa3u+M9eQTM9tF5fzNcTphN9z9qWb5QgcOTR6xg+UIFDm+J
8/7c7447K1UrcGQLnT+b7n/UskapAge3xHl/zpPlzuJ1ChyfPGIFi9cpwCel
+x+1pOsR+LphGNLfwlPS/Y9a0vUIfN31jgf75HwK7qVrEmiTPOJeuiaBr9vx
9Tr3X+VBuiiBr9vx9Tp5xIN0UQJf13Vd+lv4KnnEg3RRAl/neh1Hki5KoB2f
PZ9imPzyWeMwvA72ZThdRqraAD72xHlJJ3m0P/IIKGeJ8ynk0e4sX0gAT1oi
j7xfaXeWLySAJzmfoklrlBLAU+RRk9YoJYCnLHA+RT8MzqfYmeULCeBJ8qhJ
yxcSQNzYnUe6vzJPumgAViCPdihdNAArkEc7lC4agBXIox1KFw3AWtL9lXnS
9QKwlnR/ZZ50vQCswf2C9iddMwBrkEf7k64ZgKeN396Ml2l4PUOe8yOA5sij
kuQR0JwpfX4ZLz9Guh+3Ll0WAJuTRyWlywJge2/OLn9Npcu1u3Q/bl20JAAi
5FFF0ZIASHg9k2Ia8qiMdFkAbE4elZQuC4Aq0v24den1B6gi3Y9bl15/gCrS
/bh16fUHqCLdj1uXXn+AKtL9uHXp9QeoIt2PW5def4Aq0v24den1B6gi3Y9b
l15/gIqGyenUX8b1PbPX37+OyUcfP419f+ovfxqHfuy+n7rzr3263W/u3X2Z
AHjKF/PoNqZ7QQznhBrS8bA5eQRQzjD27R33l550AB7IIwBKGIcWr9cBUM3Y
4Mv30nMOwKOx65p7gpSecwAeySMAqkjnw9bS8w3Az6XzYWvp+Qbg0eXdsul8
2Fp6zgF4JI8AqEAeAVCBPAKggOnOq+l82Fp60gF4II8ACHg8geIinQ/Pup6d
kZpTAOaTRwAUcD2n791pfdOHdy47qQDMJo8AqGB8eTNuqZTOk2elpxWAmeQR
ABWM36YhjwCIkkcAFJbOk2el5w+AZaTz5Fnp+QNgGek8eVZ6/gBYRjpPnpWe
PwCWkc6TZ6XnD4BlpPPkWen5A2AZ6Tx5Vnr+AFhGOk+elZ4/ADLS+XMvPR8A
ZKTz5156PgDISOfPvfR8AJCRzp976fkAICOdP/fS8wFARjp/7qXnA4CMdP7c
S88HABnp/LmXng8AMtL5cy89HwBkpPPnXno+AMhI58+99HwAkJHOn3vp+QAg
I50/99LzAUBGOn/upecDgIx0/txLzwcAGen8uZeeDwB2oO97+QJAnDwCoAh5
BEAF8giACuQRABXIIwAqkEcAVCCPAKhAHgFQgTwCoAJ5BEAF8giAuGEY5BEA
cfIIgCLkEQBxnh8BAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAwKp6AAAAJv8HkkAfFA==
                   "], {{0, 
                   562}, {560, 0}}, {0, 255},
                   ColorFunction->RGBColor],
                  BoxForm`ImageTag[
                  "Byte", ColorSpace -> Automatic, Interleaving -> True],
                  Selectable->False],
                 DefaultBaseStyle->"ImageGraphics",
                 ImageSizeRaw->{560, 562},
                 PlotRange->{{0, 560}, {0, 562}}], 12->
                GraphicsBox[
                 TagBox[RasterBox[CompressedData["
1:eJzt3cFu5Mp1BmAj2WSZV8gbBFllm2W2DvIANuwY2TiAHSDISyebsTAEiWa6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                   "], {{0, 
                   562}, {560, 0}}, {0, 255},
                   ColorFunction->RGBColor],
                  BoxForm`ImageTag[
                  "Byte", ColorSpace -> Automatic, Interleaving -> True],
                  Selectable->False],
                 DefaultBaseStyle->"ImageGraphics",
                 ImageSizeRaw->{560, 562},
                 PlotRange->{{0, 560}, {0, 562}}], 13->
                GraphicsBox[
                 TagBox[RasterBox[CompressedData["
1:eJzt3cFu5Mp1BmAj2WSZV8gbBFllm2W2DvIANuwY2TiAHSDISyebsTAEiWa6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                   "], {{0, 
                   562}, {560, 0}}, {0, 255},
                   ColorFunction->RGBColor],
                  BoxForm`ImageTag[
                  "Byte", ColorSpace -> Automatic, Interleaving -> True],
                  Selectable->False],
                 DefaultBaseStyle->"ImageGraphics",
                 ImageSizeRaw->{560, 562},
                 PlotRange->{{0, 560}, {0, 562}}], 14->
                GraphicsBox[
                 TagBox[RasterBox[CompressedData["
1:eJzt3cFu5Mp1BmAj2WSZV8gbBFllm2W2DvIANuwY2TiAHSDISyebsTAEiWa6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                   "], {{0, 
                   562}, {560, 0}}, {0, 255},
                   ColorFunction->RGBColor],
                  BoxForm`ImageTag[
                  "Byte", ColorSpace -> Automatic, Interleaving -> True],
                  Selectable->False],
                 DefaultBaseStyle->"ImageGraphics",
                 ImageSizeRaw->{560, 562},
                 PlotRange->{{0, 560}, {0, 562}}], 15->
                GraphicsBox[
                 TagBox[RasterBox[CompressedData["
1:eJzt3cFu5Mp1BmAj2WSZV8gbBFllm2W2DvIANuwY2TiAHSDISyebsTAEiWa6
2brTUvcoENUk/0PW96E8ntG0dHWrTp3/NtXN+rvf/sev/+2vfvWrX/35b86/
/Po3//VPf/rTb/77X/72/Id//eOf//0Pf/z97/75j//5+z/8/k//+Nu/Pn/w
H86P/fvz/y6/PwEAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAANQzDkP4WAEAe
AVCCPAKggr7vT6dxGgAQMz0/kkcAhJ2fH40rS/8rArAD8giAIuQRABXIIwAq
kEcAxA3DII8AiJNHABQhjwCoQB4BEOf9RwBUII8AKEIeAVCBPAIgzvU6ACqQ
RwBsrJucpvfA9pPr4bDyCIA1rJ0vc6XnA4CMdP7cS88HABnp/LmXng8AMtL5
cy89HwBkpPPnXno+AMhI58+99HwAkJHOn3vp+QAgYIPz9eZKTwkAM43fpvEy
je4yTv00ZpBHADxriTw6uV4HwJNek0geARAljwCo4JpBTyTR65cpZtlJAmB1
S+SR1zMA8LT+zXjjXUK9/dvxNoZpnMZ6cfTjewNgL2bk0XDxLo+GvmIYnfWd
PALYuSmJ0nmytfSkA/BAHgFQwuXqXDoftpaecwAeySMAKpBHAFQgjwCoIp0P
W0vPNwA/l86HraXnG4BHY9eVfI/rmtJzDsAjeQRABWN7l+vkEUBBRW9Jt6r0
nAPwYLjcjLQ16UkH4IE8AqCAYRz7Fn9+dB0ALG8Yhn5y/s3//4C3D+uG0/e+
uR8g9ZfzneQRwGzp/t269PoDVJHux61Lrz9AFel+3Lr0+gNUke7HrUuvP0AV
6X7cuvT6A1SR7setS68/QBXpfty69PoDVJHux61Lrz/A5obxMq53Dxi7aXw7
j3Q/bl26LAA2J49KSpcFwPbe3FdNHpURLQmACHlUUbQkABJeM+g6Xn6MdD9u
XbosADYnj0pKlwXA5qarc7+Maxhdsindj1s3nC4jXRwAG5JHJckjgOsrHNiX
dM0ArEEe7U+6ZgDWku6vzJOuF4C1pPsr86TrBWAFXs+wQ+miAViBPNqhdNEA
rEAe7VC6aABWMHbD6Xu6vzJPumgAHnTjZfTTeD1LYq5+GDw/2pnlCwngSUvk
0Xmk+yvzLF9IAE96m0SvedRPY550f2WeNUoJ4CnyqElrlBLAU94l0dXcPHK/
oP1ZvpAAnrREHg1Dur0y0/KFBLCM/n68y6k3Z5S/8/pX8mh3nE8BVPWpPBom
bz7rkkTXwb50vTwCypsyCN5KFyXQJHnEg3RRAk2SRzxIFyXQJHnEg3RRAm3y
fiLupWsSaJM84l66JoF2pfsftaTrEWhXuv9RS7oegR1a4PyIU9c5z4h3Fq9T
4PjkEStYvE6B43N+BCtYo1SBg1sijwY3pOO9laoVOLIlzo/oe8+PeGf5QgUO
Tx6xguULFWjFE+cZDePQp9sfxXSny9i6ioElvD8naHsz8qifnC7f89h1Q9+d
/2s43f4o5qWXR8DT3B+VzaWLHihJHrG5dNEDJckjNpcueqAkecTm0kUPfN2a
r39wfgRbW62YgdVdX+G2DnnE1lYrZmB1a78+PN2faMuqxQzsl/vRsbF0yQNF
ySM2li55oK50f6It6XoHiup7N6RjU+mSB4py3isbS5c8UNPox0dsLF3zQE3e
f8TW0jUPPOH1hJmXaUy/f3eO3uvJRLfx+UcOY+9yHdsaTpeR2UrAk36WR33/
/XrfhvMvl/8fxu77qft+OS/vMY9+OcbocrrrOYCmB4/XB39/SbcnGiOPYL/S
/QOS0vsPuEn3A0hK7z/gJt0PICm9/4CbdD+ApPT+A27S/QCS0vsPuEn3A0hK
7z/gJt0PICm9/4CbdD+ApPT+gyZ142X007jeP2GS7geQlN2U0Ch5BA+ymxIa
9TaJXvPocrefdD+ApPS2hCbJI3iQ3pbQpHdJdCWPaF1yS0Kz5BE8SG5JaF1/
N9L9AJKup62kdyW0SR7BzUsvj6CA6dod8HnpTQsHJY9gpvSmhYOSRzBTetPC
QckjmCm9aeGoRrcLglnSexaOSh7BPOk9C0eW3t+wJ+n9CkeW3t+wJ+n9CiV9
cH7EvK/Rden9DXuy+D6GI5BHsLnF9zEcwQfnR8z9Mun9DXuyxlaG3Vsij4bB
G5BghpV2M+zbB+dHzPkSY997fgQzLL+R4QDkEWxu+Y0Mx3F/fsT7nLqOR9PH
h3Fw3ATM4bwk+Nin8miYXB7d913XDdNf9d34/cXPj2AG5yXBp7g/KhSTbgoQ
Io+gmHRTgBB5BMWkmwKEyCMoJt0UIMX5EVBLuidAijyCWtI9AZLS+w+4SfcD
iHE/Oigl3RIgRh5BKemWAEnp/QfcpPsBxPS9G9JBIemWADHOe4VS0i0BUkY/
PoJS0j0BUrz/CGpJ9wT4krcnRLyesvLtMt6eYfT68Wm8O33v9ROdrwelDKfL
CPUU+KqZedR1L+dxml7jfY6h8xiG80ddsINC5BFbStc7cBzpfsa+pesXOI50
P2Pf0vULHEe6n7Fv6foFjiPdz9i3dP0Cx5HuZ+xbun6B40j3M/YtXb/AcaT7
GfuWrl/gONL9jH1L1y9wHOl+xr6l6xc4jnQ/Y9/S9QscR7qfsW/p+gWOI93P
2Ld0/QLHke5n7Fu6foHjSPcz9i1dv8BxDNNIdzX2Kl2/wHF0w0kesZl0vQPH
ke5n7Fjf9+n6BY4j3dLYMXkELCjd0ti3dP0Cx5HuZ+zYMAzp+gWOI93S2DF5
BCwo3dLYMT8/AhaUbmnsmDwCFpRuaYSM36bxMo3uMk79NGZ+GYCFrNHq2IEl
8sjzI2BBK3U7qntNInkEVLFSt6O6JfLo5HodsJw1Wh07cM2gJ5LorOu6dP0C
x7F4n2Mf5BFQzOJ9jp3o34w33iXU278db2OYxmn0dlhgQb80GVozO4/6/tRf
/jQO/dh9v/w+XbzAoVw7zMatkIqmJErXI8Ba0k2WT5NHwKGlmyyfd7k6l64X
gLWkeyyfJ4+AI0v3WD5PHgFHlu6xfJ48Ao4s3WOZJ10vAGtJ91dmcN4rcGDp
Fsvnud8CcGTpHsvnjS7XAQeW7rF83ugWQMCBpXssnzd2nQt2wGGleyyfNlxu
lApwVOkmy6dNp0gAHFW6yfJZw2nsPD8CjivdZfm5bnKa3nPUXw3yCDiydN9t
XXr9AapI9+PWpdcfoIp0P25dev0Bqkj349al1x+ginQ/bl16/QGqSPfj1qXX
H6CKdD9uXXr9AapI9+OmOc8I4Id0S26aPAL4Id2SW5def4Aq0v24den1B6gi
3Y9bl15/gCrS/bh16fUHqCLdj5vm9QwAP6RbcrvG4XTq5RHAq+nQ0XRrrur8
/GWpr3P3pS5/PIeRy3UAv+iGXh59xPU0gLLSEbGpvncgK0BR6YjYlDwCKCsd
EVtLzzcAP5fOh62l5xuAn0vnw9bS8w3Az6XzYVNeXwdQVjoiNiWPAMpKR8Sm
5BFAWemI2JQ8AigrHRFbS883AD+XzodNeX4EUFY6Ijbl/gwAZaUjYlOeHwGU
lY6IraXnG4CfS+fD1tLzDcDPXbv0MAz952TT5Enn7/+jI/muM3A9aO/tv2l6
fQBasWEa7FJ6fQBake731aXXB6AV6X5fXXp9AFqR7vfVpdcHoBXpfl9den0A
WpHu99Wl1wegFel+X116fQBake731aXXB6AV6X5fXXp9AFqR7vfVpdcHoBXp
fl9den0AWpHu99Wl1wegFel+X116fQBake731aXXB6AV6X5fXXp9AFqR7vdH
k15PgCrS/bh16fUHqCLdj1uXXn+AKtL9uHXp9QeoIt2PW5def4Aq0v24den1
B6gi3Y9bl15/gCrS/bh16fUHqCLdj1uXXn+AKtL9uHXp9QeoIt2PW5def4Aq
0v24den1B6gi3Y9bl15/gCrS/bh16fUHqCLdj1uXXn+AKtL9uHXp9QeoIt2P
+Uj/Ztyk6wVo17kDTYPWyCOgFnnUqLG7jTeplK5HoF3ZpkiMPAKKyTZFYsaX
N+OWSul6BNqVbouEyCOgmHRbJGT8Ng15BFSRbouEyCOgmHRbpJZ0PQLtSvc/
aknXI9CudP+jlnQ9Au1K9z9qSdcj0K50/6OWdD0C7Ur3P2pJ1yPQrnT/o5Z0
PQLtSvc/aknXI9CudP8jxPthgZUN00g3O8qTR8DK5BHPSNcvcBzpfsa+pesX
OI50P2Pf0vULHEe6n7Fv6foFjiPdz9i3dP0Cx5HuZ+xbun6B40j3M/YtXb/A
caT7GfuWrl/gONL9jH1L1y9wHOl+xr6l6xc4jnQ/Y9/S9QscR7qfsW/p+gWO
I93P2Ld0/QLHke5n7Fu6foHjSPczmLyeZ/F4qsU4jetjuh+j617O4/yxYRj6
/nQew3D+6JDeT8DNcLqMZGOBL5iZR9fTl3588nWcUym9/4AbecQuvc2a1zya
xpwv4fIhlLJWu4BVLZFHg8t1UMla7QLW9Xhdbrp2N0fXden9B9ws3ydgCwvk
Ud/36f0H3CzfJ2ADw3gZ11T6ah6d/AAJKlmjVcDqlsijwQ+QoJKVugXUJ4+g
lHRLgKT0/gNu0v0AUrz/CGpJ9wRIkUdQS7onQMj0igigjnRTgBB5BMWkmwKE
yCMoJt0UIEQeQTHppgBb6u/H9X21b99dO70v6ew03VCo67ph+qu+G7+/CDCY
4fpO9fSuh5o+lUcPpo8P4+B2dzCHPIKfeJc7V29P6PsM5/fBPMtvZDgAeQSb
W34jwwH042W8S6W5eeR+dzDPSrsZ9m2JPDq5oQPMscZWht3rxst4m0pf+BrO
k4U5Ft/HcATyCDa3+D4Gfkjvb9iT9H6FI0vvb9iT9H6Fo3I+BcyT3rNwVPII
5knvWTgo91+FmdKbFg5KHsFM6U0LByWPYKb0poWDkkcwU3rTwpHcn0+R3t+Q
5PwIyJFHcCOPIOCD8ynS/QCSklsSmiWP4EFyS0KzPjifIt0PICm9LaFJ8gge
pLclNOmD8ynS/QCSspsSGiWP4EF2UwJvpfsBJKX3H3CT7geQlN5/wE26H0BS
ev8BN+l+AEnp/QfcpPsBJKX3H3CT7geQlN5/wE26H0BSev8BN+l+AEnp/QdN
+uB+qqfx5S8v/3P+9eX7/56ud99/PYri4uXl/Mdx6Me/fOv67vK5/fBtGi/n
8faR54f1/en6mO77ZZw/6/tLut3QmOF0GdtvL2CGj/PozbjPo9Nla7+/693n
H3kOry7dnmiMPIId+OB+qmv+I0eXA9nYmvUMLCSRR8OQbk80Zs16Bhbywf1U
1/1ndi7YsakNqhp4ViKP+t75Smxqg6oGdirdn2hLut6BogY/QGJb6ZIHipJH
bCxd8kBd6f5EW9L1DtTk/UdsLV3zQE3yiK2lax4oaXpVOWwpXfRASfKIzaWL
HihJHrG5dNEDJckjNpcueqCO/n68u4Prdfzy0Mnp8jalseuGvnM+Bfemc02k
DPAFM/Lojdezkwa3u+M9eQTM9tF5fzNcTphN9z9qWb5QgcOTR6xg+UIFDm+J
8/7c7447K1UrcGQLnT+b7n/UskapAge3xHl/zpPlzuJ1ChyfPGIFi9cpwCel
+x+1pOsR+LphGNLfwlPS/Y9a0vUIfN31jgf75HwK7qVrEmiTPOJeuiaBr9vx
9Tr3X+VBuiiBr9vx9Tp5xIN0UQJf13Vd+lv4KnnEg3RRAl/neh1Hki5KoB2f
PZ9imPzyWeMwvA72ZThdRqraAD72xHlJJ3m0P/IIKGeJ8ynk0e4sX0gAT1oi
j7xfaXeWLySAJzmfoklrlBLAU+RRk9YoJYCnLHA+RT8MzqfYmeULCeBJ8qhJ
yxcSQNzYnUe6vzJPumgAViCPdihdNAArkEc7lC4agBXIox1KFw3AWtL9lXnS
9QKwlnR/ZZ50vQCswf2C9iddMwBrkEf7k64ZgKeN396Ml2l4PUOe8yOA5sij
kuQR0JwpfX4ZLz9Guh+3Ll0WAJuTRyWlywJge2/OLn9Npcu1u3Q/bl20JAAi
5FFF0ZIASHg9k2Ia8qiMdFkAbE4elZQuC4Aq0v24den1B6gi3Y9bl15/gCrS
/bh16fUHqCLdj1uXXn+AKtL9uHXp9QeoIt2PW5def4Aq0v24den1B6gi3Y9b
l15/gIqGyenUX8b1PbPX37+OyUcfP419f+ovfxqHfuy+n7rzr3263W/u3X2Z
AHjKF/PoNqZ7QQznhBrS8bA5eQRQzjD27R33l550AB7IIwBKGIcWr9cBUM3Y
4Mv30nMOwKOx65p7gpSecwAeySMAqkjnw9bS8w3Az6XzYWvp+Qbg0eXdsul8
2Fp6zgF4JI8AqEAeAVCBPAKggOnOq+l82Fp60gF4II8ACHg8geIinQ/Pup6d
kZpTAOaTRwAUcD2n791pfdOHdy47qQDMJo8AqGB8eTNuqZTOk2elpxWAmeQR
ABWM36YhjwCIkkcAFJbOk2el5w+AZaTz5Fnp+QNgGek8eVZ6/gBYRjpPnpWe
PwCWkc6TZ6XnD4BlpPPkWen5A2AZ6Tx5Vnr+AFhGOk+elZ4/ADLS+XMvPR8A
ZKTz5156PgDISOfPvfR8AJCRzp976fkAICOdP/fS8wFARjp/7qXnA4CMdP7c
S88HABnp/LmXng8AMtL5cy89HwBkpPPnXno+AMhI58+99HwAkJHOn3vp+QAg
I50/99LzAUBGOn/upecDgIx0/txLzwcAGen8uZeeDwB2oO97+QJAnDwCoAh5
BEAF8giACuQRABXIIwAqkEcAVCCPAKhAHgFQgTwCoAJ5BEAF8giAuGEY5BEA
cfIIgCLkEQBxnh8BAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAwKp6AAAAJv8HkkAfFA==
                   "], {{0, 
                   562}, {560, 0}}, {0, 255},
                   ColorFunction->RGBColor],
                  BoxForm`ImageTag[
                  "Byte", ColorSpace -> Automatic, Interleaving -> True],
                  Selectable->False],
                 DefaultBaseStyle->"ImageGraphics",
                 ImageSizeRaw->{560, 562},
                 PlotRange->{{0, 560}, {0, 562}}], 16->
                GraphicsBox[
                 TagBox[RasterBox[CompressedData["
1:eJzt3cFu5Mp1BmAj2WSZV8gbBFllm2W2DvIANuwY2TiAHSDISyebsTAEiWa6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                   "], {{0, 
                   562}, {560, 0}}, {0, 255},
                   ColorFunction->RGBColor],
                  BoxForm`ImageTag[
                  "Byte", ColorSpace -> Automatic, Interleaving -> True],
                  Selectable->False],
                 DefaultBaseStyle->"ImageGraphics",
                 ImageSizeRaw->{560, 562},
                 PlotRange->{{0, 560}, {0, 562}}], 17->
                GraphicsBox[
                 TagBox[RasterBox[CompressedData["
1:eJzt3cFu5Mp1BmAj2WSZV8gbBFllm2W2DvIANuwY2TiAHSDISyebsTAEiWa6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                   "], {{0, 
                   562}, {560, 0}}, {0, 255},
                   ColorFunction->RGBColor],
                  BoxForm`ImageTag[
                  "Byte", ColorSpace -> Automatic, Interleaving -> True],
                  Selectable->False],
                 DefaultBaseStyle->"ImageGraphics",
                 ImageSizeRaw->{560, 562},
                 PlotRange->{{0, 560}, {0, 562}}]}, 
                Dynamic[$CellContext`i127$$],
                Alignment->Automatic,
                BaseStyle->"ListAnimateCore",
                ImageSize->All,
                TransitionDirection->Horizontal,
                TransitionDuration->0.5,
                TransitionEffect->Automatic],
               Identity,
               Editable->True,
               Selectable->True],
              ImageMargins->10],
             Deployed->False,
             StripOnInput->False,
             ScriptLevel->0,
             GraphicsBoxOptions->{PreserveImageOptions->True},
             Graphics3DBoxOptions->{PreserveImageOptions->True}],
            Identity,
            Editable->False,
            Selectable->False],
           Alignment->{Left, Center},
           Background->GrayLevel[1],
           Frame->1,
           FrameStyle->GrayLevel[0, 0.2],
           ItemSize->Automatic,
           StripOnInput->False]}
        },
        AutoDelete->False,
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Top}}, 
          "RowsIndexed" -> {}},
        GridBoxDividers->{
         "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
          "RowsIndexed" -> {}},
        GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.7], {
             Offset[0.5599999999999999]}, 
            Offset[0.7]}, "ColumnsIndexed" -> {}, "Rows" -> {
            Offset[0.4], {
             Offset[0.8]}, 
            Offset[0.4]}, "RowsIndexed" -> {}}], If[
        And[
         CurrentValue["NotebookSelected"], 
         CurrentValue["SelectionOver"]], 
        Manipulate`Dump`ReadControllerState[
         Map[Manipulate`Dump`updateOneVar[#, 
           CurrentValue["PreviousFormatTime"], 
           CurrentValue["CurrentFormatTime"]]& , {
           
           Manipulate`Dump`controllerLink[{$CellContext`i127$$, \
$CellContext`i127$346848$$}, "X1", 
            If["DefaultAbsolute", True, "JB1"], False, {1, 17, 1}, 17, 1.]}], 
         
         CurrentValue[{
          "ControllerData", {
           "Gamepad", "Joystick", "Multi-Axis Controller"}}], {}]],
       ImageSizeCache->{593., {308.884033203125, 314.615966796875}}],
      DefaultBaseStyle->{},
      FrameMargins->{{5, 5}, {5, 5}}],
     BaselinePosition->Automatic,
     ImageMargins->0],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UndoTrackedVariables:>{Typeset`show$$, Typeset`bookmarkMode$$},
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "ListAnimate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellChangeTimes->{3.686717481241995*^9, 3.686717513612945*^9, 
  3.686717590418413*^9, 3.6867179636677017`*^9, 
  3.709537123044921*^9},ExpressionUUID->"1a35740e-51d5-43c0-9d34-\
e8680c65061c"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
You can also use ListAnimate on the table of plots to run the animation:\
\>", "Subsubsection",
 CellChangeTimes->{{3.686717718590069*^9, 3.686717740709855*^9}, {
  3.686717908279797*^9, 
  3.686717913598463*^9}},ExpressionUUID->"b9c0ea6d-cf08-49c9-b9ed-\
9b7df5b2fa79"],

Cell[BoxData[
 RowBox[{"ListAnimate", "[", 
  RowBox[{"tableofrotatedplots", ",", 
   RowBox[{"AnimationRunning", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.6867173277557077`*^9, 
  3.686717335131872*^9}},ExpressionUUID->"67d962d9-eb4a-4407-8ce7-\
5fa1730a8b4d"]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1084, 671},
WindowMargins->{{12, Automatic}, {0, Automatic}},
FrontEndVersion->"11.1 for Mac OS X x86 (32-bit, 64-bit Kernel) (April 18, \
2017)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 160, 3, 92, "Title", "ExpressionUUID" -> \
"78295a5e-50a4-4ddf-ad70-12e91891ffbe"],
Cell[CellGroupData[{
Cell[765, 29, 163, 3, 44, "Subsection", "ExpressionUUID" -> \
"aed366e5-e7db-45c1-9f91-caf6963cc56e"],
Cell[931, 34, 796, 22, 96, "Input", "ExpressionUUID" -> \
"5537d176-8be6-4dc5-a25f-f4bfb7bd840d"],
Cell[1730, 58, 201, 5, 32, "Input", "ExpressionUUID" -> \
"e8dad974-c6a3-4e36-aa8f-a1bcbe36d4a0"],
Cell[CellGroupData[{
Cell[1956, 67, 317, 8, 32, "Input", "ExpressionUUID" -> \
"d1b09fee-82ba-478f-af25-09e9a2a18958"],
Cell[2276, 77, 42307, 698, 330, "Output", "ExpressionUUID" -> \
"74013e4f-59c6-4eba-8ec3-4345a78234dd"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[44632, 781, 236, 5, 44, "Subsection", "ExpressionUUID" -> \
"8ba5bf86-7ada-467b-ae5e-f4bdf468e51c"],
Cell[44871, 788, 1395, 34, 222, "Input", "ExpressionUUID" -> \
"62bb908e-96b7-44b8-98e8-676dd83372f6"]
}, Open  ]],
Cell[CellGroupData[{
Cell[46303, 827, 222, 5, 44, "Subsection", "ExpressionUUID" -> \
"97f1784a-992d-4f6b-a0c6-9b25dd3c5a19"],
Cell[46528, 834, 538, 15, 75, "Input", "ExpressionUUID" -> \
"1e06631d-3eca-4499-a26c-001d6b469b27"]
}, Open  ]],
Cell[CellGroupData[{
Cell[47103, 854, 168, 3, 44, "Subsection", "ExpressionUUID" -> \
"33000774-601c-423d-ba74-e95c6a76c8ec"],
Cell[CellGroupData[{
Cell[47296, 861, 841, 20, 117, "Input", "ExpressionUUID" -> \
"8b3c8d98-a72a-49be-b1a8-57be443211a2"],
Cell[48140, 883, 6517, 114, 254, "Output", "ExpressionUUID" -> \
"a1d0131b-4245-4c9e-a79b-f62c2f0b7115"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[54706, 1003, 190, 3, 44, "Subsection", "ExpressionUUID" -> \
"6a234768-c905-4ebb-9442-12f3ee55f6ba"],
Cell[CellGroupData[{
Cell[54921, 1010, 240, 6, 32, "Input", "ExpressionUUID" -> \
"83b0f6a5-10fc-4032-9545-f0d733100418"],
Cell[55164, 1018, 139, 3, 32, "Output", "ExpressionUUID" -> \
"1fa336f5-ed78-4501-be67-2f5854ad0a18"]
}, Open  ]],
Cell[CellGroupData[{
Cell[55340, 1026, 252, 6, 32, "Input", "ExpressionUUID" -> \
"f235da48-a97c-4bd5-865b-885f0a9a484d"],
Cell[55595, 1034, 149, 3, 32, "Output", "ExpressionUUID" -> \
"17142a34-4e9b-4a93-9720-ec8f80b1ad07"]
}, Open  ]]
}, Open  ]],
Cell[55771, 1041, 219, 4, 44, "Subsection", "ExpressionUUID" -> \
"c0877908-6470-442c-8d7c-b77708a1a134"]
}, Open  ]],
Cell[CellGroupData[{
Cell[56027, 1050, 230, 4, 92, "Title", "ExpressionUUID" -> \
"bc0753d5-035b-4556-93a5-52bf85a57209"],
Cell[CellGroupData[{
Cell[56282, 1058, 262, 5, 35, "Subsubsection", "ExpressionUUID" -> \
"baa03f74-9868-4298-9b1b-36a145f78e43"],
Cell[56547, 1065, 285, 8, 32, "Input", "ExpressionUUID" -> \
"851a1682-99bc-492a-8346-5f02253bd2ad"],
Cell[56835, 1075, 268, 7, 32, "Input", "ExpressionUUID" -> \
"440ca28d-3d0a-4168-aefb-33705e358e20"],
Cell[CellGroupData[{
Cell[57128, 1086, 469, 14, 35, "Input", "ExpressionUUID" -> \
"6fc23ce4-4033-430b-bce0-616b323b8a0e"],
Cell[57600, 1102, 42874, 724, 229, "Output", "ExpressionUUID" -> \
"4807c194-3643-47f2-9718-46040249e85b"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[100523, 1832, 182, 3, 35, "Subsubsection", "ExpressionUUID" -> \
"e7238e32-deb6-4ec6-b670-4225f3a64de2"],
Cell[100708, 1837, 663, 21, 35, "Input", "ExpressionUUID" -> \
"97e71e73-360b-4385-ba78-4c867f5365b1"],
Cell[CellGroupData[{
Cell[101396, 1862, 410, 11, 32, "Input", "ExpressionUUID" -> \
"97f17529-28b9-48d3-9d15-a24ae1190d34"],
Cell[101809, 1875, 26994, 663, 246, "Output", "ExpressionUUID" -> \
"a94b6ed6-b197-48f4-8e12-bd1b28238c03"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[128852, 2544, 169, 3, 35, "Subsubsection", "ExpressionUUID" -> \
"b15e81aa-2143-407a-a179-e8dc53bd6904"],
Cell[CellGroupData[{
Cell[129046, 2551, 483, 14, 32, "Input", "ExpressionUUID" -> \
"0592b725-1a34-4d16-9a9f-8eae71cf79aa"],
Cell[129532, 2567, 27583, 666, 435, "Output", "ExpressionUUID" -> \
"6aff13db-ef06-4ad9-b664-86137de3a068"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[157164, 3239, 279, 6, 35, "Subsubsection", "ExpressionUUID" -> \
"dc7de3d2-f301-4253-a4db-c2fb71d2a3ea"],
Cell[157446, 3247, 2161, 54, 171, "Input", "ExpressionUUID" -> \
"cac1f01f-a944-4083-86ba-e2ed54387327"],
Cell[159610, 3303, 459, 11, 54, "Input", "ExpressionUUID" -> \
"acd1e299-41da-4d2c-8401-fa1e93816b4a"]
}, Open  ]],
Cell[160084, 3317, 271, 4, 36, "Subsubsection", "ExpressionUUID" -> \
"cf6aef8b-0005-42c0-91de-1157d633197c"],
Cell[CellGroupData[{
Cell[160380, 3325, 224, 5, 29, "Subsubsection", "ExpressionUUID" -> \
"af353f1f-66b1-46dc-9822-e9c5456b40a2"],
Cell[CellGroupData[{
Cell[160629, 3334, 365, 9, 32, "Input", "ExpressionUUID" -> \
"0e859f5d-7961-444e-b7bf-ff261d9b5f38"],
Cell[160997, 3345, 184054, 3113, 653, "Output", "ExpressionUUID" -> \
"1a35740e-51d5-43c0-9d34-e8680c65061c"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[345100, 6464, 280, 6, 35, "Subsubsection", "ExpressionUUID" -> \
"b9c0ea6d-cf08-49c9-b9ed-9b7df5b2fa79"],
Cell[345383, 6472, 282, 6, 32, "Input", "ExpressionUUID" -> \
"67d962d9-eb4a-4407-8ce7-5fa1730a8b4d"]
}, Open  ]]
}, Open  ]]
}
]
*)

