(* Content-type: application/vnd.wolfram.cdf.text *)

(*** Wolfram CDF File ***)
(* http://www.wolfram.com/cdf *)

(* CreatedBy='Mathematica 11.1' *)

(*************************************************************************)
(*                                                                       *)
(*  The Mathematica License under which this file was created prohibits  *)
(*  restricting third parties in receipt of this file from republishing  *)
(*  or redistributing it by any means, including but not limited to      *)
(*  rights management or terms of use, without the express consent of    *)
(*  Wolfram Research, Inc. For additional information concerning CDF     *)
(*  licensing and redistribution see:                                    *)
(*                                                                       *)
(*        www.wolfram.com/cdf/adopting-cdf/licensing-options.html        *)
(*                                                                       *)
(*************************************************************************)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[      1064,         20]
NotebookDataLength[     26137,        598]
NotebookOptionsPosition[     26467,        589]
NotebookOutlinePosition[     26823,        605]
CellTagsIndexPosition[     26780,        602]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[TextData[StyleBox["Run the planets yourselves and find out the apparent \
motion as seen from the Earth (blue dot) in the 2nd plot! \n\nThe first \
slider allows you to vary the distance of the other planet (\
\[OpenCurlyDoubleQuote]Mars\[CloseCurlyDoubleQuote]) from the sun from 0.3 to \
15 (the earth-sun distance is taken as 1). In the animation, earth revolves \
counterclockwise around the sun. You can set Mars running counterclockwise or \
clockwise by switching between +1 and -1 in the 2nd row. The slider in the \
3rd row sets the total duration of the animation (default value = 8 years). \
The last slider plays out the motion in time, starting from 0. The letters \
\[OpenCurlyDoubleQuote]A\[CloseCurlyDoubleQuote] - \[OpenCurlyDoubleQuote]H\
\[CloseCurlyDoubleQuote] denote constellations in the sky.", \
"Subsubsection"]], "Text",
 CellChangeTimes->{{3.635113760245101*^9, 3.6351143177650137`*^9}, {
  3.635114378823102*^9, 3.635114392400429*^9}, {3.635114639566464*^9, 
  3.635114665765252*^9}, {3.663539796583579*^9, 
  3.663539804209906*^9}},ExpressionUUID->"097a08bb-b663-43c4-80cf-\
537de91b5f0d"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"With", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"sunposition", "=", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0"}], "}"}]}], ",", 
     RowBox[{"sunradius", "=", "0.2"}], ",", 
     RowBox[{"earthdistance", "=", "1"}], ",", 
     RowBox[{"earthradius", "=", "0.1"}], ",", 
     RowBox[{"marsradius", "=", "0.1"}], ",", 
     RowBox[{"marsoffset", "=", 
      RowBox[{
       RowBox[{"-", "\[Pi]"}], "/", "2"}]}], ",", 
     RowBox[{"k", "=", 
      RowBox[{"2", "*", "\[Pi]"}]}]}], "}"}], ",", "\[IndentingNewLine]", 
   RowBox[{"Manipulate", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"earthposition", ",", "marsposition", ",", "traceplot"}], 
        "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{
         RowBox[{"earthposition", "[", 
          RowBox[{"\[Tau]_", "?", "NumericQ"}], "]"}], ":=", 
         RowBox[{"earthdistance", "*", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Cos", "[", 
             RowBox[{"k", "*", 
              RowBox[{"\[Tau]", "/", 
               SuperscriptBox["earthdistance", 
                RowBox[{"3", "/", "2"}]]}]}], "]"}], ",", 
            RowBox[{"Sin", "[", 
             RowBox[{"k", "*", 
              RowBox[{"\[Tau]", "/", 
               SuperscriptBox["earthdistance", 
                RowBox[{"3", "/", "2"}]]}]}], "]"}]}], "}"}]}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"marsposition", "[", 
          RowBox[{"\[Tau]_", "?", "NumericQ"}], "]"}], ":=", 
         RowBox[{"marsdistance", "*", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Cos", "[", 
             RowBox[{
              RowBox[{"sign", "*", "k", "*", 
               RowBox[{"\[Tau]", "/", 
                SuperscriptBox["marsdistance", 
                 RowBox[{"3", "/", "2"}]]}]}], "+", "marsoffset"}], "]"}], 
            ",", 
            RowBox[{"Sin", "[", 
             RowBox[{
              RowBox[{"sign", "*", "k", "*", 
               RowBox[{"\[Tau]", "/", 
                SuperscriptBox["marsdistance", 
                 RowBox[{"3", "/", "2"}]]}]}], "+", "marsoffset"}], "]"}]}], 
           "}"}]}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"Grid", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"{", "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{"Graphics", "[", 
              RowBox[{
               RowBox[{"{", "\[IndentingNewLine]", 
                RowBox[{
                 RowBox[{"RGBColor", "[", 
                  RowBox[{"0.9", ",", "0.9", ",", "0"}], "]"}], ",", 
                 RowBox[{"Disk", "[", 
                  RowBox[{"sunposition", ",", "sunradius"}], "]"}], ",", 
                 "\[IndentingNewLine]", "Blue", ",", 
                 RowBox[{"Disk", "[", 
                  RowBox[{
                   RowBox[{"earthposition", "[", "t", "]"}], ",", 
                   "earthradius"}], "]"}], ",", "\[IndentingNewLine]", "Red", 
                 ",", 
                 RowBox[{"Disk", "[", 
                  RowBox[{
                   RowBox[{"marsposition", "[", "t", "]"}], ",", 
                   "marsradius"}], "]"}], ",", "\[IndentingNewLine]", "Black",
                  ",", 
                 RowBox[{"Arrowheads", "[", "Large", "]"}], ",", 
                 RowBox[{"Arrow", "[", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"earthposition", "[", "t", "]"}], ",", 
                    RowBox[{"marsposition", "[", "t", "]"}]}], "}"}], "]"}], 
                 ",", "\[IndentingNewLine]", "Dashed", ",", 
                 RowBox[{"Circle", "[", 
                  RowBox[{"sunposition", ",", "earthdistance"}], "]"}], ",", 
                 RowBox[{"Circle", "[", 
                  RowBox[{"sunposition", ",", "marsdistance"}], "]"}]}], 
                "}"}], ",", 
               RowBox[{"ImageSize", "\[Rule]", "400"}], ",", 
               "\[IndentingNewLine]", 
               RowBox[{"PlotRange", "\[Rule]", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"-", 
                    RowBox[{"Max", "[", 
                    RowBox[{"earthdistance", ",", "marsdistance"}], "]"}]}], 
                    "-", 
                    RowBox[{"2", "*", "marsradius"}]}], ",", 
                    RowBox[{
                    RowBox[{"Max", "[", 
                    RowBox[{"earthdistance", ",", "marsdistance"}], "]"}], 
                    "+", 
                    RowBox[{"2", "*", "marsradius"}]}]}], "}"}], ",", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"-", 
                    RowBox[{"Max", "[", 
                    RowBox[{"earthdistance", ",", "marsdistance"}], "]"}]}], 
                    "-", 
                    RowBox[{"2", "*", "marsradius"}]}], ",", 
                    RowBox[{
                    RowBox[{"Max", "[", 
                    RowBox[{"earthdistance", ",", "marsdistance"}], "]"}], 
                    "+", 
                    RowBox[{"2", "*", "marsradius"}]}]}], "}"}]}], "}"}]}]}], 
              "]"}], ",", "\[IndentingNewLine]", 
             RowBox[{"Show", "[", "\[IndentingNewLine]", 
              RowBox[{
               RowBox[{"Graphics", "[", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"Arrowheads", "[", "Large", "]"}], ",", 
                   RowBox[{"Arrow", "[", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"0", ",", "0"}], "}"}], ",", 
                    RowBox[{
                    RowBox[{"marsposition", "[", "t", "]"}], "-", 
                    RowBox[{"earthposition", "[", "t", "]"}]}]}], "}"}], 
                    "]"}], ",", 
                   RowBox[{"Text", "[", 
                    RowBox[{
                    RowBox[{"Style", "[", 
                    RowBox[{"\"\<A\>\"", ",", "Black", ",", "20"}], "]"}], 
                    ",", 
                    RowBox[{"1.25", "*", 
                    RowBox[{"(", 
                    RowBox[{"earthdistance", "+", "marsdistance"}], ")"}], 
                    "*", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Cos", "[", "\[Pi]", "]"}], ",", 
                    RowBox[{"Sin", "[", "\[Pi]", "]"}]}], "}"}]}]}], "]"}], 
                   ",", 
                   RowBox[{"Text", "[", 
                    RowBox[{
                    RowBox[{"Style", "[", 
                    RowBox[{"\"\<B\>\"", ",", "Black", ",", "20"}], "]"}], 
                    ",", 
                    RowBox[{"1.25", "*", 
                    RowBox[{"(", 
                    RowBox[{"earthdistance", "+", "marsdistance"}], ")"}], 
                    "*", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Cos", "[", 
                    RowBox[{"1.25", "*", "\[Pi]"}], "]"}], ",", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"1.25", "*", "\[Pi]"}], "]"}]}], "}"}]}]}], "]"}],
                    ",", 
                   RowBox[{"Text", "[", 
                    RowBox[{
                    RowBox[{"Style", "[", 
                    RowBox[{"\"\<C\>\"", ",", "Black", ",", "20"}], "]"}], 
                    ",", 
                    RowBox[{"1.25", "*", 
                    RowBox[{"(", 
                    RowBox[{"earthdistance", "+", "marsdistance"}], ")"}], 
                    "*", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Cos", "[", 
                    RowBox[{"1.5", "*", "\[Pi]"}], "]"}], ",", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"1.5", "*", "\[Pi]"}], "]"}]}], "}"}]}]}], "]"}], 
                   ",", 
                   RowBox[{"Text", "[", 
                    RowBox[{
                    RowBox[{"Style", "[", 
                    RowBox[{"\"\<D\>\"", ",", "Black", ",", "20"}], "]"}], 
                    ",", 
                    RowBox[{"1.25", "*", 
                    RowBox[{"(", 
                    RowBox[{"earthdistance", "+", "marsdistance"}], ")"}], 
                    "*", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Cos", "[", 
                    RowBox[{"1.75", "*", "\[Pi]"}], "]"}], ",", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"1.75", "*", "\[Pi]"}], "]"}]}], "}"}]}]}], "]"}],
                    ",", 
                   RowBox[{"Text", "[", 
                    RowBox[{
                    RowBox[{"Style", "[", 
                    RowBox[{"\"\<E\>\"", ",", "Black", ",", "20"}], "]"}], 
                    ",", 
                    RowBox[{"1.25", "*", 
                    RowBox[{"(", 
                    RowBox[{"earthdistance", "+", "marsdistance"}], ")"}], 
                    "*", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Cos", "[", "0", "]"}], ",", 
                    RowBox[{"Sin", "[", "0", "]"}]}], "}"}]}]}], "]"}], ",", 
                   RowBox[{"Text", "[", 
                    RowBox[{
                    RowBox[{"Style", "[", 
                    RowBox[{"\"\<F\>\"", ",", "Black", ",", "20"}], "]"}], 
                    ",", 
                    RowBox[{"1.25", "*", 
                    RowBox[{"(", 
                    RowBox[{"earthdistance", "+", "marsdistance"}], ")"}], 
                    "*", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.25", "*", "\[Pi]"}], "]"}], ",", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.25", "*", "\[Pi]"}], "]"}]}], "}"}]}]}], "]"}],
                    ",", 
                   RowBox[{"Text", "[", 
                    RowBox[{
                    RowBox[{"Style", "[", 
                    RowBox[{"\"\<G\>\"", ",", "Black", ",", "20"}], "]"}], 
                    ",", 
                    RowBox[{"1.25", "*", 
                    RowBox[{"(", 
                    RowBox[{"earthdistance", "+", "marsdistance"}], ")"}], 
                    "*", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.5", "*", "\[Pi]"}], "]"}], ",", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.5", "*", "\[Pi]"}], "]"}]}], "}"}]}]}], "]"}], 
                   ",", 
                   RowBox[{"Text", "[", 
                    RowBox[{
                    RowBox[{"Style", "[", 
                    RowBox[{"\"\<H\>\"", ",", "Black", ",", "20"}], "]"}], 
                    ",", 
                    RowBox[{"1.25", "*", 
                    RowBox[{"(", 
                    RowBox[{"earthdistance", "+", "marsdistance"}], ")"}], 
                    "*", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.75", "*", "\[Pi]"}], "]"}], ",", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.75", "*", "\[Pi]"}], "]"}]}], "}"}]}]}], 
                    "]"}]}], "}"}], ",", 
                 RowBox[{"ImageSize", "\[Rule]", "350"}], ",", 
                 RowBox[{"PlotRange", "\[Rule]", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "1.32"}], "*", 
                    RowBox[{"(", 
                    RowBox[{"earthdistance", "+", "marsdistance"}], ")"}]}], 
                    ",", 
                    RowBox[{"1.32", "*", 
                    RowBox[{"(", 
                    RowBox[{"earthdistance", "+", "marsdistance"}], ")"}]}]}],
                     "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "1.32"}], "*", 
                    RowBox[{"(", 
                    RowBox[{"earthdistance", "+", "marsdistance"}], ")"}]}], 
                    ",", 
                    RowBox[{"1.32", "*", 
                    RowBox[{"(", 
                    RowBox[{"earthdistance", "+", "marsdistance"}], ")"}]}]}],
                     "}"}]}], "}"}]}]}], "]"}], ",", "\[IndentingNewLine]", 
               RowBox[{"ParametricPlot", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"marsposition", "[", "\[Tau]", "]"}], "-", 
                  RowBox[{"earthposition", "[", "\[Tau]", "]"}]}], ",", 
                 RowBox[{"{", 
                  RowBox[{"\[Tau]", ",", 
                   RowBox[{"-", "0.001"}], ",", "t"}], "}"}]}], "]"}]}], 
              "]"}]}], "\[IndentingNewLine]", "}"}], "}"}], ",", 
          RowBox[{"ItemSize", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"Scaled", "[", "0.5", "]"}], ",", " ", 
              RowBox[{"Scaled", "[", "0.5", "]"}]}], "}"}], "}"}]}]}], 
         "]"}]}]}], "\[IndentingNewLine]", "]"}], ",", "\[IndentingNewLine]", 
     
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"marsdistance", ",", "2", ",", 
         RowBox[{"Style", "[", 
          RowBox[{"\"\<Distance of Mars from the sun\>\"", ",", "15"}], 
          "]"}]}], "}"}], ",", "0.3", ",", "15", ",", "0.1", ",", 
       RowBox[{"Appearance", "\[Rule]", 
        RowBox[{"{", "\"\<Labeled\>\"", "}"}]}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"sign", ",", "1", ",", 
         RowBox[{"Style", "[", 
          RowBox[{
          "\"\<Counterclockwise (+1) or clockwise (-1)\>\"", ",", "15"}], 
          "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", 
         RowBox[{"-", "1"}]}], "}"}]}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"tmax", ",", "8", ",", 
         RowBox[{"Style", "[", 
          RowBox[{"\"\<Total duration of animation (years)\>\"", ",", "15"}], 
          "]"}]}], "}"}], ",", "0", ",", "100", ",", 
       RowBox[{"Appearance", "\[Rule]", 
        RowBox[{"{", "\"\<Labeled\>\"", "}"}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"t", ",", "0", ",", 
         RowBox[{"Style", "[", 
          RowBox[{"\"\<Time (years)\>\"", ",", "15"}], "]"}]}], "}"}], ",", 
       "0", ",", "tmax", ",", 
       RowBox[{"Appearance", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"\"\<Open\>\"", ",", "\"\<Labeled\>\""}], "}"}]}]}], "}"}]}],
     "]"}]}], "]"}]], "Input",
 CellOpen->False,
 CellChangeTimes->{{3.635110708055993*^9, 3.635110708551543*^9}, {
  3.6351107702087717`*^9, 3.6351107888416147`*^9}, {3.635110865917844*^9, 
  3.635110947964017*^9}, {3.635110987427238*^9, 3.635110988911641*^9}, {
  3.635111023815482*^9, 3.635111032199275*^9}, {3.635111077364439*^9, 
  3.635111088170356*^9}, {3.635111129441724*^9, 3.6351111675160503`*^9}, {
  3.63511120320537*^9, 3.635111306426115*^9}, {3.6351114525019493`*^9, 
  3.635111461562889*^9}, {3.6351114978836327`*^9, 3.635111540327855*^9}, {
  3.635111602769887*^9, 3.635111632957591*^9}, {3.63511166567397*^9, 
  3.6351116780087442`*^9}, {3.635111767685162*^9, 3.635111768461109*^9}, {
  3.63511186001383*^9, 3.6351118602504177`*^9}, {3.635111949231372*^9, 
  3.635111952663219*^9}, {3.635113056607376*^9, 3.6351130894738092`*^9}, {
  3.635113277868019*^9, 3.6351133069681168`*^9}, {3.635113483207794*^9, 
  3.635113486085457*^9}},ExpressionUUID->"1216569a-0342-4c14-8a79-\
202c395099a6"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`marsdistance$$ = 
    2.4, $CellContext`sign$$ = -1, $CellContext`t$$ = 
    3.2640000000000002`, $CellContext`tmax$$ = 8., Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`marsdistance$$], 2, 
       Style["Distance of Mars from the sun", 15]}, 0.3, 15, 0.1}, {{
       Hold[$CellContext`sign$$], 1, 
       Style["Counterclockwise (+1) or clockwise (-1)", 15]}, {1, -1}}, {{
       Hold[$CellContext`tmax$$], 8, 
       Style["Total duration of animation (years)", 15]}, 0, 100}, {{
       Hold[$CellContext`t$$], 0, 
       Style["Time (years)", 15]}, 0, 
      Dynamic[$CellContext`tmax$$]}}, Typeset`size$$ = {
    1039., {197.134033203125, 202.865966796875}}, Typeset`update$$ = 0, 
    Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`marsdistance$522$$ = 0, $CellContext`sign$527$$ = 
    False, $CellContext`tmax$528$$ = 0, $CellContext`t$529$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`marsdistance$$ = 2, $CellContext`sign$$ = 
        1, $CellContext`t$$ = 0, $CellContext`tmax$$ = 8}, 
      "ControllerVariables" :> {
        Hold[$CellContext`marsdistance$$, $CellContext`marsdistance$522$$, 0], 
        Hold[$CellContext`sign$$, $CellContext`sign$527$$, False], 
        Hold[$CellContext`tmax$$, $CellContext`tmax$528$$, 0], 
        Hold[$CellContext`t$$, $CellContext`t$529$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> 
      Module[{$CellContext`earthposition$, $CellContext`marsposition$, \
$CellContext`traceplot$}, $CellContext`earthposition$[
           PatternTest[
            Pattern[$CellContext`\[Tau]$, 
             Blank[]], NumericQ]] := 1 {
            Cos[(2 Pi) ($CellContext`\[Tau]$/1^(3/2))], 
            
            Sin[(2 Pi) ($CellContext`\[Tau]$/
              1^(3/2))]}; $CellContext`marsposition$[
           PatternTest[
            Pattern[$CellContext`\[Tau]$, 
             Blank[]], NumericQ]] := $CellContext`marsdistance$$ {
            
            Cos[($CellContext`sign$$ (2 
                Pi)) ($CellContext`\[Tau]$/$CellContext`marsdistance$$^(3/2)) + 
             Rational[-1, 2] Pi], 
            
            Sin[($CellContext`sign$$ (2 
                Pi)) ($CellContext`\[Tau]$/$CellContext`marsdistance$$^(3/2)) + 
             Rational[-1, 2] Pi]}; Grid[{{
            Graphics[{
              RGBColor[0.9, 0.9, 0], 
              Disk[{0, 0}, 0.2], Blue, 
              Disk[
               $CellContext`earthposition$[$CellContext`t$$], 0.1], Red, 
              Disk[
               $CellContext`marsposition$[$CellContext`t$$], 0.1], Black, 
              Arrowheads[Large], 
              Arrow[{
                $CellContext`earthposition$[$CellContext`t$$], 
                $CellContext`marsposition$[$CellContext`t$$]}], Dashed, 
              Circle[{0, 0}, 1], 
              Circle[{0, 0}, $CellContext`marsdistance$$]}, ImageSize -> 400, 
             PlotRange -> {{-Max[1, $CellContext`marsdistance$$] - 2 0.1, 
                Max[1, $CellContext`marsdistance$$] + 
                2 0.1}, {-Max[1, $CellContext`marsdistance$$] - 2 0.1, 
                Max[1, $CellContext`marsdistance$$] + 2 0.1}}], 
            Show[
             Graphics[{
               Arrowheads[Large], 
               
               Arrow[{{0, 
                 0}, $CellContext`marsposition$[$CellContext`t$$] - \
$CellContext`earthposition$[$CellContext`t$$]}], 
               Text[
                Style[
                "A", Black, 20], (1.25 (1 + $CellContext`marsdistance$$)) {
                  Cos[Pi], 
                  Sin[Pi]}], 
               Text[
                Style[
                "B", Black, 20], (1.25 (1 + $CellContext`marsdistance$$)) {
                  Cos[1.25 Pi], 
                  Sin[1.25 Pi]}], 
               Text[
                Style[
                "C", Black, 20], (1.25 (1 + $CellContext`marsdistance$$)) {
                  Cos[1.5 Pi], 
                  Sin[1.5 Pi]}], 
               Text[
                Style[
                "D", Black, 20], (1.25 (1 + $CellContext`marsdistance$$)) {
                  Cos[1.75 Pi], 
                  Sin[1.75 Pi]}], 
               Text[
                Style[
                "E", Black, 20], (1.25 (1 + $CellContext`marsdistance$$)) {
                  Cos[0], 
                  Sin[0]}], 
               Text[
                Style[
                "F", Black, 20], (1.25 (1 + $CellContext`marsdistance$$)) {
                  Cos[0.25 Pi], 
                  Sin[0.25 Pi]}], 
               Text[
                Style[
                "G", Black, 20], (1.25 (1 + $CellContext`marsdistance$$)) {
                  Cos[0.5 Pi], 
                  Sin[0.5 Pi]}], 
               Text[
                Style[
                "H", Black, 20], (1.25 (1 + $CellContext`marsdistance$$)) {
                  Cos[0.75 Pi], 
                  Sin[0.75 Pi]}]}, ImageSize -> 350, 
              PlotRange -> {{(-1.32) (1 + $CellContext`marsdistance$$), 
                 1.32 (1 + $CellContext`marsdistance$$)}, {(-1.32) (
                  1 + $CellContext`marsdistance$$), 
                 1.32 (1 + $CellContext`marsdistance$$)}}], 
             
             ParametricPlot[$CellContext`marsposition$[$CellContext`\[Tau]] - \
$CellContext`earthposition$[$CellContext`\[Tau]], {$CellContext`\[Tau], \
-0.001, $CellContext`t$$}]]}}, ItemSize -> {{
             Scaled[0.5], 
             Scaled[0.5]}}]], 
      "Specifications" :> {{{$CellContext`marsdistance$$, 2, 
          Style["Distance of Mars from the sun", 15]}, 0.3, 15, 0.1, 
         Appearance -> {"Labeled"}}, {{$CellContext`sign$$, 1, 
          Style["Counterclockwise (+1) or clockwise (-1)", 15]}, {
         1, -1}}, {{$CellContext`tmax$$, 8, 
          Style["Total duration of animation (years)", 15]}, 0, 100, 
         Appearance -> {"Labeled"}}, {{$CellContext`t$$, 0, 
          Style["Time (years)", 15]}, 0, 
         Dynamic[$CellContext`tmax$$], Appearance -> {"Open", "Labeled"}}}, 
      "Options" :> {}, "DefaultOptions" :> {}],
     ImageSizeCache->{1084., {297., 303.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UndoTrackedVariables:>{Typeset`show$$, Typeset`bookmarkMode$$},
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellChangeTimes->{
  3.6351107898686943`*^9, 3.6351108702831287`*^9, {3.635110940293153*^9, 
   3.635110948664173*^9}, {3.6351109895087833`*^9, 3.635111032886675*^9}, {
   3.6351110688848*^9, 3.635111088699923*^9}, {3.635111279214117*^9, 
   3.635111332194294*^9}, {3.63511152309579*^9, 3.63511154067367*^9}, {
   3.635111605476057*^9, 3.635111633416842*^9}, {3.635111670032785*^9, 
   3.6351116783607693`*^9}, 3.635111769322379*^9, {3.63511184838875*^9, 
   3.63511187502217*^9}, {3.6351119530710382`*^9, 3.635111971032257*^9}, 
   3.635113021708703*^9, 3.635113060217285*^9, 3.6351130912406473`*^9, {
   3.635113284982752*^9, 3.635113307479699*^9}, 3.6351134869031467`*^9, 
   3.635113543774629*^9, {3.635113596648795*^9, 3.635113607952532*^9}, 
   3.635113728802842*^9, 3.635114439080647*^9, 
   3.635114648073886*^9},ExpressionUUID->"8f57bae5-825e-4446-be78-\
600f88055729"]
}, Open  ]]
},
WindowSize->{1203, 666},
WindowMargins->{{14, Automatic}, {Automatic, 12}},
FrontEndVersion->"11.1 for Mac OS X x86 (32-bit, 64-bit Kernel) (April 18, \
2017)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[1464, 33, 1123, 16, 167, "Text", "ExpressionUUID" -> \
"097a08bb-b663-43c4-80cf-537de91b5f0d"],
Cell[CellGroupData[{
Cell[2612, 53, 15985, 367, 19, "Input", "ExpressionUUID" -> \
"1216569a-0342-4c14-8a79-202c395099a6",
 CellOpen->False],
Cell[18600, 422, 7851, 164, 617, "Output", "ExpressionUUID" -> \
"8f57bae5-825e-4446-be78-600f88055729"]
}, Open  ]]
}
]
*)

(* End of internal cache information *)

(* NotebookSignature dwDkGfoBom5HiDgD82KU1tjI *)
